use llml::{vec::{EucVecf4, EucVecf2, EucVecf3}, mat::{Matf2, Matf3}, others::Complxf};
use rand::random;

#[test]
fn vec2 () {
    let alpha = EucVecf2::new(random(), random());
    let beta = EucVecf2::new(random(), random());
    let gamma = alpha.dot(beta);

    assert_eq!(alpha.x * beta.x + alpha.y * beta.y, gamma);
}

#[test]
fn vec4 () {
    let alpha = EucVecf4::new(random(), random(), random(), random());
    let beta = EucVecf4::new(random(), random(), random(), random());
    let gamma = alpha + beta;

    assert_eq!(alpha.x + beta.x, gamma.x);
    assert_eq!(alpha.y + beta.y, gamma.y);
    assert_eq!(alpha.z + beta.z, gamma.z);
    assert_eq!(alpha.w + beta.w, gamma.w);
}

#[test]
fn sum () {
    let alpha = EucVecf4::new(1., 2., 3., 4.);
    let dot = alpha.dot(alpha);
    let sum = alpha.sum();

    println!("{:?} => {} {}", alpha, dot, sum);
}

#[test]
fn cross () {
    let alpha = EucVecf3::new(random(), random(), random());
    let beta = EucVecf3::new(random(), random(), random());
    let gamma = alpha.cross(beta);

    assert_eq!(alpha.y * beta.z - alpha.z * beta.y, gamma.x);
    assert_eq!(-alpha.x * beta.z + alpha.z * beta.x, gamma.y);
    assert_eq!(alpha.x * beta.y - alpha.y * beta.x, gamma.z);
}

#[test]
fn mat2 () {
    let alpha = Matf2::of_values(random(), random(), random(), random());
    let beta = EucVecf2::new(random(), random());
    let gamma = alpha * beta;
    println!("{:?} * {:?} = {:?}", alpha, beta, gamma);
}

#[test]
fn mat3 () {
    let alpha = Matf3::of_values(
        1., -5., 10.,
        1., -2., 1.,
        2., -1., -5.
    );
    
    let inv = alpha.inv();
    println!("{:?}", inv);
}

#[test]
fn det () {
    let alpha = Matf3::of_values(
        1., -5., 10.,
        1., -2., 1.,
        2., -1., -5.
    );

    let det = alpha.det();
    println!("{:?}", det)
}

#[test]
fn complx () {
    let alpha = Complxf::new(1., 2.);
    let beta = Complxf::new(3., 4.);
    let gamma = alpha * beta;
}