/* automatically generated by rust-bindgen */

#![allow(
    dead_code,
    non_camel_case_types,
    non_upper_case_globals,
    non_snake_case
)]
#![allow(clippy::unreadable_literal)]

use libc::{size_t, FILE};

/// Storage for the value of an address.
pub type lldb_addr_t = u64;
/// Storage for a breakpoint ID.
pub type lldb_break_id_t = i32;
/// Storage for a watchpoint ID.
pub type lldb_watch_id_t = i32;
/// Storage for an OS user ID.
pub type lldb_user_id_t = u64;
/// Storage for an OS process ID.
pub type lldb_pid_t = u64;
/// Storage for an OS queue ID.
pub type lldb_queue_id_t = u64;
/// Storage for an OS thread ID.
pub type lldb_tid_t = u64;
/// Storage for an offset between 2 addresses in memory.
pub type lldb_offset_t = u64;
pub enum SBAddressOpaque {}
pub type SBAddressRef = *mut SBAddressOpaque;
pub enum SBAttachInfoOpaque {}
pub type SBAttachInfoRef = *mut SBAttachInfoOpaque;
pub enum SBBlockOpaque {}
pub type SBBlockRef = *mut SBBlockOpaque;
pub enum SBBreakpointOpaque {}
pub type SBBreakpointRef = *mut SBBreakpointOpaque;
pub enum SBBreakpointListOpaque {}
pub type SBBreakpointListRef = *mut SBBreakpointListOpaque;
pub enum SBBreakpointLocationOpaque {}
pub type SBBreakpointLocationRef = *mut SBBreakpointLocationOpaque;
pub enum SBBreakpointNameOpaque {}
pub type SBBreakpointNameRef = *mut SBBreakpointNameOpaque;
pub enum SBBroadcasterOpaque {}
pub type SBBroadcasterRef = *mut SBBroadcasterOpaque;
pub enum SBCommandOpaque {}
pub type SBCommandRef = *mut SBCommandOpaque;
pub enum SBCommandInterpreterOpaque {}
pub type SBCommandInterpreterRef = *mut SBCommandInterpreterOpaque;
pub enum SBCommandInterpreterRunOptionsOpaque {}
pub type SBCommandInterpreterRunOptionsRef = *mut SBCommandInterpreterRunOptionsOpaque;
pub enum SBCommandPluginInterfaceOpaque {}
pub type SBCommandPluginInterfaceRef = *mut SBCommandPluginInterfaceOpaque;
pub enum SBCommandReturnObjectOpaque {}
pub type SBCommandReturnObjectRef = *mut SBCommandReturnObjectOpaque;
pub enum SBCommunicationOpaque {}
pub type SBCommunicationRef = *mut SBCommunicationOpaque;
pub enum SBCompileUnitOpaque {}
pub type SBCompileUnitRef = *mut SBCompileUnitOpaque;
pub enum SBDataOpaque {}
pub type SBDataRef = *mut SBDataOpaque;
pub enum SBDebuggerOpaque {}
pub type SBDebuggerRef = *mut SBDebuggerOpaque;
pub enum SBDeclarationOpaque {}
pub type SBDeclarationRef = *mut SBDeclarationOpaque;
pub enum SBEnvironmentOpaque {}
pub type SBEnvironmentRef = *mut SBEnvironmentOpaque;
pub enum SBErrorOpaque {}
pub type SBErrorRef = *mut SBErrorOpaque;
pub enum SBEventOpaque {}
pub type SBEventRef = *mut SBEventOpaque;
pub enum SBEventListOpaque {}
pub type SBEventListRef = *mut SBEventListOpaque;
pub enum SBExecutionContextOpaque {}
pub type SBExecutionContextRef = *mut SBExecutionContextOpaque;
pub enum SBExpressionOptionsOpaque {}
pub type SBExpressionOptionsRef = *mut SBExpressionOptionsOpaque;
pub enum SBFileSpecOpaque {}
pub type SBFileSpecRef = *mut SBFileSpecOpaque;
pub enum SBFileSpecListOpaque {}
pub type SBFileSpecListRef = *mut SBFileSpecListOpaque;
pub enum SBFrameOpaque {}
pub type SBFrameRef = *mut SBFrameOpaque;
pub enum SBFunctionOpaque {}
pub type SBFunctionRef = *mut SBFunctionOpaque;
pub enum SBHostOSOpaque {}
pub type SBHostOSRef = *mut SBHostOSOpaque;
pub enum SBInstructionOpaque {}
pub type SBInstructionRef = *mut SBInstructionOpaque;
pub enum SBInstructionListOpaque {}
pub type SBInstructionListRef = *mut SBInstructionListOpaque;
pub enum SBLaunchInfoOpaque {}
pub type SBLaunchInfoRef = *mut SBLaunchInfoOpaque;
pub enum SBLineEntryOpaque {}
pub type SBLineEntryRef = *mut SBLineEntryOpaque;
pub enum SBListenerOpaque {}
pub type SBListenerRef = *mut SBListenerOpaque;
pub enum SBMemoryRegionInfoOpaque {}
pub type SBMemoryRegionInfoRef = *mut SBMemoryRegionInfoOpaque;
pub enum SBMemoryRegionInfoListOpaque {}
pub type SBMemoryRegionInfoListRef = *mut SBMemoryRegionInfoListOpaque;
pub enum SBModuleOpaque {}
pub type SBModuleRef = *mut SBModuleOpaque;
pub enum SBModuleSpecOpaque {}
pub type SBModuleSpecRef = *mut SBModuleSpecOpaque;
pub enum SBModuleSpecListOpaque {}
pub type SBModuleSpecListRef = *mut SBModuleSpecListOpaque;
pub enum SBPlatformOpaque {}
pub type SBPlatformRef = *mut SBPlatformOpaque;
pub enum SBProcessOpaque {}
pub type SBProcessRef = *mut SBProcessOpaque;
pub enum SBProcessInfoOpaque {}
pub type SBProcessInfoRef = *mut SBProcessInfoOpaque;
pub enum SBQueueOpaque {}
pub type SBQueueRef = *mut SBQueueOpaque;
pub enum SBQueueItemOpaque {}
pub type SBQueueItemRef = *mut SBQueueItemOpaque;
pub enum SBSectionOpaque {}
pub type SBSectionRef = *mut SBSectionOpaque;
pub enum SBSourceManagerOpaque {}
pub type SBSourceManagerRef = *mut SBSourceManagerOpaque;
pub enum SBStreamOpaque {}
pub type SBStreamRef = *mut SBStreamOpaque;
pub enum SBStringListOpaque {}
pub type SBStringListRef = *mut SBStringListOpaque;
pub enum SBStructuredDataOpaque {}
pub type SBStructuredDataRef = *mut SBStructuredDataOpaque;
pub enum SBSymbolOpaque {}
pub type SBSymbolRef = *mut SBSymbolOpaque;
pub enum SBSymbolContextOpaque {}
pub type SBSymbolContextRef = *mut SBSymbolContextOpaque;
pub enum SBSymbolContextListOpaque {}
pub type SBSymbolContextListRef = *mut SBSymbolContextListOpaque;
pub enum SBTargetRefOpaque {}
pub type SBTargetRef = *mut SBTargetRefOpaque;
pub enum SBThreadRefOpaque {}
pub type SBThreadRef = *mut SBThreadRefOpaque;
pub enum SBThreadCollectionOpaque {}
pub type SBThreadCollectionRef = *mut SBThreadCollectionOpaque;
pub enum SBThreadPlanOpaque {}
pub type SBThreadPlanRef = *mut SBThreadPlanOpaque;
pub enum SBTypeOpaque {}
pub type SBTypeRef = *mut SBTypeOpaque;
pub enum SBTypeMemberOpaque {}
pub type SBTypeMemberRef = *mut SBTypeMemberOpaque;
pub enum SBTypeCategoryOpaque {}
pub type SBTypeCategoryRef = *mut SBTypeCategoryOpaque;
pub enum SBTypeEnumMemberOpaque {}
pub type SBTypeEnumMemberRef = *mut SBTypeEnumMemberOpaque;
pub enum SBTypeEnumMemberListOpaque {}
pub type SBTypeEnumMemberListRef = *mut SBTypeEnumMemberListOpaque;
pub enum SBTypeFilterOpaque {}
pub type SBTypeFilterRef = *mut SBTypeFilterOpaque;
pub enum SBTypeFormatOpaque {}
pub type SBTypeFormatRef = *mut SBTypeFormatOpaque;
pub enum SBTypeMemberFunctionOpaque {}
pub type SBTypeMemberFunctionRef = *mut SBTypeMemberFunctionOpaque;
pub enum SBTypeNameSpecifierOpaque {}
pub type SBTypeNameSpecifierRef = *mut SBTypeNameSpecifierOpaque;
pub enum SBTypeSummaryOpaque {}
pub type SBTypeSummaryRef = *mut SBTypeSummaryOpaque;
pub enum SBTypeSummaryOptionsOpaque {}
pub type SBTypeSummaryOptionsRef = *mut SBTypeSummaryOptionsOpaque;
pub enum SBInputReaderOpaque {}
pub type SBInputReaderRef = *mut SBInputReaderOpaque;
pub enum SBPlatformConnectOptionsOpaque {}
pub type SBPlatformConnectOptionsRef = *mut SBPlatformConnectOptionsOpaque;
pub enum SBPlatformShellCommandOpaque {}
pub type SBPlatformShellCommandRef = *mut SBPlatformShellCommandOpaque;
pub enum SBTypeSyntheticOpaque {}
pub type SBTypeSyntheticRef = *mut SBTypeSyntheticOpaque;
pub enum SBTypeListOpaque {}
pub type SBTypeListRef = *mut SBTypeListOpaque;
pub enum SBValueOpaque {}
pub type SBValueRef = *mut SBValueOpaque;
pub enum SBValueListOpaque {}
pub type SBValueListRef = *mut SBValueListOpaque;
pub enum SBVariablesOptionsOpaque {}
pub type SBVariablesOptionsRef = *mut SBVariablesOptionsOpaque;
pub enum SBWatchpointOpaque {}
pub type SBWatchpointRef = *mut SBWatchpointOpaque;
pub enum SBUnixSignalsOpaque {}
pub type SBUnixSignalsRef = *mut SBUnixSignalsOpaque;
/// Process and thread states.
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum StateType {
    Invalid = 0,
    /// Process object is valid, but not currently loaded.
    Unloaded = 1,
    /// Process is connected to remote debug services, but not launched
    /// or attached to anything yet.
    Connected = 2,
    /// Process is currently trying to attach.
    Attaching = 3,
    /// Process is currently trying to launch.
    Launching = 4,
    /// Process or thread is stopped and can be examined.
    Stopped = 5,
    /// Process or thread is running and can't be examined.
    Running = 6,
    /// Process or thread is in the process of stepping and can't be examined.
    Stepping = 7,
    /// Process or thread has crashed and can be examined.
    Crashed = 8,
    /// Process has been detached and can't be examined.
    Detached = 9,
    /// Process has exited and can't be examined.
    Exited = 10,
    /// Process or thread is in a suspended state as far as the
    /// debugger is concerned while other processes or threads
    /// get the chance to run.
    Suspended = 11,
}
bitflags! {
    #[repr(C)]
    pub struct LaunchFlags: u32 {
        /// Exec when launching and turn the calling process into a new process.
        const EXEC          = 0b0000001;
        /// Stop as soon as the process launches to allow the process to be debugged.
        const DEBUG         = 0b0000010;
        /// Stop at the program entry point instead of auto-continuing when
        /// launching or attaching at entry point.
        const STOP_AT_ENTRY = 0b0000100;
        /// Disable address space layout randomization (ASLR).
        const DISABLE_ASLR = 8;
        /// Disable stdio for the inferior process (e.g. for a GUI app).
        const DISABLE_STDIO = 16;
        /// Launch the process in a new TTY if supported by the host.
        const LAUNCH_IN_TTY = 32;
        /// Launch the process inside a shell to get shell expansion.
        const LAUNCH_IN_SHELL = 64;
        /// Launch the process in a separate process group.
        const LAUNCH_IN_SEPARATE_PROCESS_GROUP = 128;
        /// If you are going to hand the process off (e.g. to debugserver),
        /// set this flag so that lldb and the handee don't race to set its
        /// exit status.
        const DONT_SET_EXIT_STATUS = 256;
        /// If set, then the client stub should detach rather than
        /// killing the debugee.
        const DETACH_ON_ERRROR = 512;
        /// Perform shell-style argument expansion.
        const SHELL_EXPAND_ARGUMENTS = 1024;
        /// Close the open TTY on exit.
        const CLOSE_TTY_ON_EXIT = 2048;
    }
}

/// Thread run modes.
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum RunMode {
    OnlyThisThread = 0,
    AllThreads = 1,
    OnlyDuringStepping = 2,
}

/// Byte order definitions.
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum ByteOrder {
    Invalid = 0,
    Big = 1,
    PDP = 2,
    Little = 4,
}

/// Register encoding definitions.
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum Encoding {
    Invalid = 0,
    /// Unsigned integer.
    Uint = 1,
    /// signed integer.
    Sint = 2,
    /// Floating point.
    IEEE754 = 3,
    /// Vector register.
    Vector = 4,
}

/// Display format definitions.
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum Format {
    Default = 0,
    Boolean = 1,
    Binary = 2,
    Bytes = 3,
    BytesWithASCII = 4,
    Char = 5,
    CharPrintable = 6,
    Complex = 7,
    CString = 8,
    Decimal = 9,
    Enum = 10,
    Hex = 11,
    HexUppercase = 12,
    Float = 13,
    Octal = 14,
    OSType = 15,
    Unicode16 = 16,
    Unicode32 = 17,
    Unsigned = 18,
    Pointer = 19,
    VectorOfChar = 20,
    VectorOfSInt8 = 21,
    VectorOfUInt8 = 22,
    VectorOfSInt16 = 23,
    VectorOfUInt16 = 24,
    VectorOfSInt32 = 25,
    VectorOfUInt32 = 26,
    VectorOfSInt64 = 27,
    VectorOfUInt64 = 28,
    VectorOfFloat16 = 29,
    VectorOfFloat32 = 30,
    VectorOfFloat64 = 31,
    VectorOfUInt128 = 32,
    ComplexInteger = 33,
    CharArray = 34,
    AddressInfo = 35,
    HexFloat = 36,
    Instruction = 37,
    Void = 38,
    Unicode8 = 39,
    kNumFormats = 40,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum DescriptionLevel {
    Brief = 0,
    Full = 1,
    Verbose = 2,
    Initial = 3,
    kNumDescriptionLevels = 4,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum ScriptLanguage {
    None = 0,
    Python = 1,
    Lua = 2,
    Unknown = 3,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum RegisterKind {
    EHFrame = 0,
    DWARF = 1,
    Generic = 2,
    ProcessPlugin = 3,
    LLDB = 4,
    kNumRegisterKinds = 5,
}

/// Thread stop reasons.
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum StopReason {
    Invalid = 0,
    None = 1,
    Trace = 2,
    Breakpoint = 3,
    Watchpoint = 4,
    Signal = 5,
    Exception = 6,
    Exec = 7,
    PlanComplete = 8,
    ThreadExiting = 9,
    Instrumentation = 10,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum ReturnStatus {
    Invalid = 0,
    SuccessFinishNoResult = 1,
    SuccessFinishResult = 2,
    SuccessContinuingNoResult = 3,
    SuccessContinuingResult = 4,
    Started = 5,
    Failed = 6,
    Quit = 7,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum ExpressionResults {
    Completed = 0,
    SetupError = 1,
    ParseError = 2,
    Discarded = 3,
    Interrupted = 4,
    HitBreakpoint = 5,
    TimedOut = 6,
    ResultUnavailable = 7,
    StoppedForDebug = 8,
    ThreadVanished = 9,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum ConnectionStatus {
    ConnectionStatusSuccess = 0,
    ConnectionStatusEndOfFile = 1,
    ConnectionStatusError = 2,
    ConnectionStatusTimedOut = 3,
    ConnectionStatusNoConnection = 4,
    ConnectionStatusLostConnection = 5,
    ConnectionStatusInterrupted = 6,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum ErrorType {
    Invalid = 0,
    Generic = 1,
    MachKernel = 2,
    POSIX = 3,
    Expression = 4,
    Win32 = 5,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum ValueType {
    Invalid = 0,
    VariableGlobal = 1,
    VariableStatic = 2,
    VariableArgument = 3,
    VariableLocal = 4,
    Register = 5,
    RegisterSet = 6,
    ConstResult = 7,
    VariableThreadLocal = 8,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum InputReaderGranularity {
    Invalid = 0,
    Byte = 1,
    Word = 2,
    Line = 3,
    All = 4,
}

bitflags! {
    /// These mask bits allow a common interface for queries that can
    /// limit the amount of information that gets parsed to only the
    /// information that is requested. These bits also can indicate what
    /// actually did get resolved during query function calls.
    ///
    /// Each definition corresponds to a one of the member variables
    /// in this class, and requests that that item be resolved, or
    /// indicates that the member did get resolved.
    #[repr(C)]
    pub struct SymbolContextItem: u32 {
        /// Set when a target is requested from a query or was located
        /// in the query results.
        const TARGET = 1;
        /// Set when a module is requested from a query or was located
        /// in the query results.
        const MODULE = 2;
        /// Set when a compilation unit is requested from a query or was located
        /// in the query results.
        const COMPUNIT = 4;
        /// Set when a function is requested from a query or was located
        /// in the query results.
        const FUNCTION = 8;
        /// Set when the deepest block is requested from a query or was located
        /// in the query results.
        const BLOCK = 16;
        /// Set when a line entry is requested from a query or was located
        /// in the query results.
        const LINE_ENTRY = 32;
        /// Set when a symbol is requested from a query or was located
        /// in the query results.
        const SYMBOL = 64;
        /// Indicates to try and look everything up during a routine symbol
        /// context query. This doesn't actually include looking up a variable.
        const EVERYTHING
            = Self::TARGET.bits |
              Self::MODULE.bits |
              Self::COMPUNIT.bits |
              Self::FUNCTION.bits |
              Self::BLOCK.bits |
              Self::LINE_ENTRY.bits |
              Self::SYMBOL.bits;
        /// Set when a global or static variable is requested from a query,
        /// or was located in the query results.
        ///
        /// This is potentially expensive to look up, so it isn't included in
        /// `EVERYTHING` which stops it from being used during frame PC
        /// lookups and many other potential address to symbol context lookups.
        const VARIABLE = 128;
    }
}
bitflags! {
    #[repr(C)]
    pub struct Permissions: u32 {
        const WRITABLE = 1;
        const READABLE = 2;
        const EXECUTABLE = 4;
    }
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum InputReaderAction {
    Activate = 0,
    AsynchronousOutputWritten = 1,
    Reactivate = 2,
    Deactivate = 3,
    GotToken = 4,
    Interrupt = 5,
    EndOfFile = 6,
    Done = 7,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum BreakpointEventType {
    InvalidType = 1,
    Added = 2,
    Removed = 4,
    LocationsAdded = 8,
    LocationsRemoved = 16,
    LocationsResolved = 32,
    Enabled = 64,
    Disabled = 128,
    CommandChanged = 256,
    ConditionChanged = 512,
    IgnoreChanged = 1024,
    ThreadChanged = 2048,
    AutoContinueChanged = 4096,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum WatchpointEventType {
    InvalidType = 1,
    Added = 2,
    Removed = 4,
    Enabled = 64,
    Disabled = 128,
    CommandChanged = 256,
    ConditionChanged = 512,
    IgnoreChanged = 1024,
    ThreadChanged = 2048,
    TypeChanged = 4096,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum LanguageType {
    Unknown = 0,
    C89 = 1,
    C = 2,
    Ada83 = 3,
    C_plus_plus = 4,
    Cobol74 = 5,
    Cobol85 = 6,
    Fortran77 = 7,
    Fortran90 = 8,
    Pascal83 = 9,
    Modula2 = 10,
    Java = 11,
    C99 = 12,
    Ada95 = 13,
    Fortran95 = 14,
    PLI = 15,
    ObjC = 16,
    ObjC_plus_plus = 17,
    UPC = 18,
    D = 19,
    Python = 20,
    OpenCL = 21,
    Go = 22,
    Modula3 = 23,
    Haskell = 24,
    C_plus_plus_03 = 25,
    C_plus_plus_11 = 26,
    OCaml = 27,
    Rust = 28,
    C11 = 29,
    Swift = 30,
    Julia = 31,
    Dylan = 32,
    C_plus_plus_14 = 33,
    Fortran03 = 34,
    Fortran08 = 35,
    MipsAssembler = 36,
    ExtRenderScript = 37,
    NumLanguageTypes = 38,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum InstrumentationRuntimeType {
    AddressSanitizer = 0,
    ThreadSanitizer = 1,
    UndefinedBehaviorSanitizer = 2,
    MainThreadChecker = 3,
    SwiftRuntimeReporting = 4,
    NumInstrumentationRuntimeTypes = 5,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum DynamicValueType {
    NoDynamicValues = 0,
    DynamicCanRunTarget = 1,
    DynamicDontRunTarget = 2,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum AccessType {
    None = 0,
    Public = 1,
    Private = 2,
    Protected = 3,
    Package = 4,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum CommandArgumentType {
    Address = 0,
    AddressOrExpression = 1,
    AliasName = 2,
    AliasOptions = 3,
    Architecture = 4,
    Boolean = 5,
    BreakpointID = 6,
    BreakpointIDRange = 7,
    BreakpointName = 8,
    ByteSize = 9,
    ClassName = 10,
    CommandName = 11,
    Count = 12,
    DescriptionVerbosity = 13,
    DirectoryName = 14,
    DisassemblyFlavor = 15,
    EndAddress = 16,
    Expression = 17,
    ExpressionPath = 18,
    ExprFormat = 19,
    Filename = 20,
    Format = 21,
    FrameIndex = 22,
    FullName = 23,
    FunctionName = 24,
    FunctionOrSymbol = 25,
    GDBFormat = 26,
    HelpText = 27,
    Index = 28,
    Language = 29,
    LineNum = 30,
    LogCategory = 31,
    LogChannel = 32,
    Method = 33,
    Name = 34,
    NewPathPrefix = 35,
    NumLines = 36,
    NumberPerLine = 37,
    Offset = 38,
    OldPathPrefix = 39,
    OneLiner = 40,
    Path = 41,
    PermissionsNumber = 42,
    PermissionsString = 43,
    Pid = 44,
    Plugin = 45,
    ProcessName = 46,
    PythonClass = 47,
    PythonFunction = 48,
    PythonScript = 49,
    QueueName = 50,
    RegisterName = 51,
    RegularExpression = 52,
    RunArgs = 53,
    RunMode = 54,
    ScriptedCommandSynchronicity = 55,
    ScriptLang = 56,
    SearchWord = 57,
    Selector = 58,
    SettingIndex = 59,
    SettingKey = 60,
    SettingPrefix = 61,
    SettingVariableName = 62,
    ShlibName = 63,
    SourceFile = 64,
    SortOrder = 65,
    StartAddress = 66,
    SummaryString = 67,
    Symbol = 68,
    ThreadID = 69,
    ThreadIndex = 70,
    ThreadName = 71,
    TypeName = 72,
    UnsignedInteger = 73,
    UnixSignal = 74,
    VarName = 75,
    Value = 76,
    Width = 77,
    None = 78,
    Platform = 79,
    WatchpointID = 80,
    WatchpointIDRange = 81,
    WatchType = 82,
    RawInput = 83,
    Command = 84,
    ColumnNum = 85,
    LastArg = 86,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum SymbolType {
    Any = 0,
    Absolute = 1,
    Code = 2,
    Resolver = 3,
    Data = 4,
    Trampoline = 5,
    Runtime = 6,
    Exception = 7,
    SourceFile = 8,
    HeaderFile = 9,
    ObjectFile = 10,
    CommonBlock = 11,
    Block = 12,
    Local = 13,
    Param = 14,
    Variable = 15,
    VariableType = 16,
    LineEntry = 17,
    LineHeader = 18,
    ScopeBegin = 19,
    ScopeEnd = 20,
    Additional = 21,
    Compiler = 22,
    Instrumentation = 23,
    Undefined = 24,
    ObjCClass = 25,
    ObjCMetaClass = 26,
    ObjCIVar = 27,
    ReExported = 28,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum SectionType {
    Invalid = 0,
    Code = 1,
    Container = 2,
    Data = 3,
    DataCString = 4,
    DataCStringPointers = 5,
    DataSymbolAddress = 6,
    Data4 = 7,
    Data8 = 8,
    Data16 = 9,
    DataPointers = 10,
    Debug = 11,
    ZeroFill = 12,
    DataObjCMessageRefs = 13,
    DataObjCCFStrings = 14,
    DWARFDebugAbbrev = 15,
    DWARFDebugAddr = 16,
    DWARFDebugAranges = 17,
    DWARFDebugFrame = 18,
    DWARFDebugInfo = 19,
    DWARFDebugLine = 20,
    DWARFDebugLoc = 21,
    DWARFDebugMacInfo = 22,
    DWARFDebugMacro = 23,
    DWARFDebugPubNames = 24,
    DWARFDebugPubTypes = 25,
    DWARFDebugRanges = 26,
    DWARFDebugStr = 27,
    DWARFDebugStrOffsets = 28,
    DWARFAppleNames = 29,
    DWARFAppleTypes = 30,
    DWARFAppleNamespaces = 31,
    DWARFAppleObjC = 32,
    ELFSymbolTable = 33,
    ELFDynamicSymbols = 34,
    ELFRelocationEntries = 35,
    ELFDynamicLinkInfo = 36,
    EHFrame = 37,
    ARMexidx = 38,
    ARMextab = 39,
    CompactUnwind = 40,
    GoSymtab = 41,
    AbsoluteAddress = 42,
    DWARFGNUDebugAltLink = 43,
    DWARFDebugTypes = 44,
    DWARFDebugNames = 45,
    Other = 46,
    DWARFDebugLineStr = 47,
    DWARFDebugRngLists = 48,
    DWARFDebugLocLists = 49,
    DWARFDebugAbbrevDwo = 50,
    DWARFDebugInfoDwo = 51,
    DWARFDebugStrDwo = 52,
    DWARFDebugStrOffsetsDwo = 53,
    DWARFDebugTypesDwo = 54,
    DWARFDebugRngListsDwo = 55,
    DWARFDebugLocDwo = 56,
    DWARFDebugLocListsDwo = 57,
    DWARFDebugTuIndex = 58,
}
bitflags! {
    #[repr(C)]
    pub struct EmulateInstructionOptions: u32 {
        const NONE = 0;
        const AUTO_ADVANCE_PC = 1;
        const IGNORE_CONDITIONS = 2;
    }
}
bitflags! {
    #[repr(C)]
    pub struct FunctionNameType: u32 {
        const NONE = 0;
        const AUTO = 2;
        const FULL = 4;
        const BASE = 8;
        const METHOD = 16;
        const SELECTOR = 32;
    }
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum BasicType {
    Invalid = 0,
    Void = 1,
    Char = 2,
    SignedChar = 3,
    UnsignedChar = 4,
    WChar = 5,
    SignedWChar = 6,
    UnsignedWChar = 7,
    Char16 = 8,
    Char32 = 9,
    Short = 10,
    UnsignedShort = 11,
    Int = 12,
    UnsignedInt = 13,
    Long = 14,
    UnsignedLong = 15,
    LongLong = 16,
    UnsignedLongLong = 17,
    Int128 = 18,
    UnsignedInt128 = 19,
    Bool = 20,
    Half = 21,
    Float = 22,
    Double = 23,
    LongDouble = 24,
    FloatComplex = 25,
    DoubleComplex = 26,
    LongDoubleComplex = 27,
    ObjCID = 28,
    ObjCClass = 29,
    ObjCSel = 30,
    NullPtr = 31,
    Other = 32,
}

#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(i32)]
pub enum StructuredDataType {
    Invalid = -1,
    Null = 0,
    Generic,
    Array,
    Integer,
    Float,
    Boolean,
    String,
    Dictionary,
}

bitflags! {
    #[repr(C)]
    pub struct TypeClass: u32 {
        const INVALID = 0;
        const ARRAY = 1;
        const BLOCKPOINTER = 2;
        const BUILTIN = 4;
        const CLASS = 8;
        const COMPLEX_FLOAT = 16;
        const COMPLEX_INTEGER = 32;
        const ENUMERATION = 64;
        const FUNCTION = 128;
        const MEMBER_POINTER = 256;
        const OBJC_OBJECT = 512;
        const OBJC_INTERFACE = 1024;
        const OBJC_OBJECT_POINTER = 2048;
        const POINTER = 4096;
        const REFERENCE = 8192;
        const STRUCT = 16384;
        const TYPEDEF = 32768;
        const UNION = 65536;
        const VECTOR = 131072;
        const OTHER = 2147483648;
        const ANY = 4294967295;
    }
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum TemplateArgumentKind {
    Null = 0,
    Type = 1,
    Declaration = 2,
    Integral = 3,
    Template = 4,
    TemplateExpansion = 5,
    Expression = 6,
    Pack = 7,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum TypeOptions {
    None = 0,
    Cascade = 1,
    SkipPointers = 2,
    SkipReferences = 4,
    HideChildren = 8,
    HideValue = 16,
    ShowOneLiner = 32,
    HideNames = 64,
    NonCacheable = 128,
    HideEmptyAggregates = 256,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum FrameComparison {
    Invalid = 0,
    Unknown = 1,
    Equal = 2,
    SameParent = 3,
    Younger = 4,
    Older = 5,
}
bitflags! {
    #[repr(C)]
    pub struct FilePermissions: u32 {
        const WORLD_EXECUTE = 1;
        const WORLD_WRITE = 2;
        const WORLD_READ = 4;
        const GROUP_EXECUTE = 8;
        const GROUP_WRITE = 16;
        const GROUP_READ = 32;
        const USER_EXECUTE = 64;
        const USER_WRITE = 128;
        const USER_READ = 256;
        const WORLD_RX
            = Self::WORLD_READ.bits |
              Self::WORLD_EXECUTE.bits;
        const WORLD_RW
            = Self::WORLD_READ.bits |
              Self::WORLD_WRITE.bits;
        const WORLD_RWX
            = Self::WORLD_READ.bits |
              Self::WORLD_WRITE.bits |
              Self::WORLD_EXECUTE.bits;
        const GROUP_RX
            = Self::GROUP_READ.bits |
              Self::GROUP_EXECUTE.bits;
        const GROUP_RW
            = Self::GROUP_READ.bits |
              Self::GROUP_WRITE.bits;
        const GROUP_RWX
            = Self::GROUP_READ.bits |
              Self::GROUP_WRITE.bits |
              Self::GROUP_EXECUTE.bits;
        const USER_RX
            = Self::USER_READ.bits |
              Self::USER_EXECUTE.bits;
        const USER_RW
            = Self::USER_READ.bits |
              Self::USER_WRITE.bits;
        const USER_RWX
            = Self::USER_READ.bits |
              Self::USER_WRITE.bits |
              Self::USER_EXECUTE.bits;
        const EVERYONE_R
            = Self::WORLD_READ.bits |
              Self::GROUP_READ.bits |
              Self::USER_READ.bits;
        const EVERYONE_W
            = Self::WORLD_WRITE.bits |
              Self::GROUP_WRITE.bits |
              Self::USER_WRITE.bits;
        const EVERYONE_X
            = Self::WORLD_EXECUTE.bits |
              Self::GROUP_EXECUTE.bits |
              Self::USER_EXECUTE.bits;
        const EVERYONE_RW
            = Self::EVERYONE_R.bits |
              Self::EVERYONE_W.bits;
        const EVERYONE_RX
            = Self::EVERYONE_R.bits |
              Self::EVERYONE_X.bits;
        const EVERYONE_RWX
            = Self::EVERYONE_R.bits |
              Self::EVERYONE_W.bits |
              Self::EVERYONE_X.bits;
        const FILE_DEFAULT
            = Self::USER_RW.bits;
        const DIRECTORY_DEFAULT
            = Self::USER_RWX.bits;
    }
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum QueueItemKind {
    Unknown = 0,
    Function = 1,
    Block = 2,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum QueueKind {
    Unknown = 0,
    Serial = 1,
    Concurrent = 2,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum ExpressionEvaluationPhase {
    EvaluationParse = 0,
    EvaluationIRGen = 1,
    EvaluationExecution = 2,
    EvaluationComplete = 3,
}
bitflags! {
    #[repr(C)]
    pub struct WatchpointKind: u32 {
        const READ = 1;
        const WRITE = 2;
    }
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum GdbSignal {
    BadAccess = 145,
    BadInstruction = 146,
    Arithmetic = 147,
    Emulation = 148,
    Software = 149,
    Breakpoint = 150,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum PathType {
    LLDBShlibDir = 0,
    SupportExecutableDir = 1,
    HeaderDir = 2,
    PythonDir = 3,
    LLDBSystemPlugins = 4,
    LLDBUserPlugins = 5,
    LLDBTempSystemDir = 6,
    GlobalLLDBTempSystemDir = 7,
    ClangDir = 8,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum MemberFunctionKind {
    Unknown = 0,
    Constructor = 1,
    Destructor = 2,
    InstanceMethod = 3,
    StaticMethod = 4,
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum MatchType {
    Normal = 0,
    Regex = 1,
    StartsWith = 2,
}
bitflags! {
    #[repr(C)]
    pub struct TypeFlags: u32 {
        const HAS_CHILDREN = 1;
        const HAS_VALUE = 2;
        const IS_ARRAY = 4;
        const IS_BLOCK = 8;
        const IS_BUILTIN = 16;
        const IS_CLASS = 32;
        const IS_CPLUSPLUS = 64;
        const IS_ENUMERATION = 128;
        const IS_FUNC_PROTOTYPE = 256;
        const IS_MEMBER = 512;
        const IS_OBJC = 1024;
        const IS_POINTER = 2048;
        const IS_REFERENCE = 4096;
        const IS_STRUCT_UNION = 8192;
        const IS_TEMPLATE = 16384;
        const IS_TYPEDEF = 32768;
        const IS_VECTOR = 65536;
        const IS_SCALAR = 131072;
        const IS_INTEGER = 262144;
        const IS_FLOAT = 524288;
        const IS_COMPLEX = 1048576;
        const IS_SIGNED = 2097152;
        const INSTANCE_IS_POINTER = 4194304;
    }
}
bitflags! {
    #[repr(C)]
    pub struct CommandFlags: u32 {
        const REQUIRES_TARGET = 1;
        const REQUIRES_PROCESS = 2;
        const REQUIRES_THREAD = 4;
        const REQUIRES_FRAME = 8;
        const REQUIRES_REG_CONTEXT = 16;
        const TRY_TARGET_API_LOCK = 32;
        const PROCESS_MUST_BE_LAUNCHED = 64;
        const PROCESS_MUST_BE_PAUSED = 128;
    }
}
#[derive(Copy, Clone, Debug, PartialEq, PartialOrd)]
#[repr(u32)]
pub enum TypeSummaryCapping {
    SummaryCapped = 1,
    SummaryUncapped = 0,
}
pub type ReadThreadBytesReceived = ::std::option::Option<
    unsafe extern "C" fn(
        baton: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        src_len: size_t,
    ),
>;
pub type SBBreakpointHitCallback = unsafe extern "C" fn(
    baton: *mut ::std::os::raw::c_void,
    process: SBProcessRef,
    thread: SBThreadRef,
    location: SBBreakpointLocationRef,
);
extern "C" {
    pub fn CreateSBAddress() -> SBAddressRef;
    pub fn CreateSBAddress2(section: SBSectionRef, offset: lldb_addr_t) -> SBAddressRef;
    pub fn CreateSBAddress3(load_addr: lldb_addr_t, target: SBTargetRef) -> SBAddressRef;
    pub fn CloneSBAddress(instance: SBAddressRef) -> SBAddressRef;
    pub fn DisposeSBAddress(instance: SBAddressRef);
    pub fn SBAddressIsValid(instance: SBAddressRef) -> bool;
    pub fn SBAddressClear(instance: SBAddressRef);
    pub fn SBAddressGetFileAddress(instance: SBAddressRef) -> lldb_addr_t;
    pub fn SBAddressGetLoadAddress(instance: SBAddressRef, target: SBTargetRef) -> lldb_addr_t;
    pub fn SBAddressSetAddress(instance: SBAddressRef, section: SBSectionRef, offset: lldb_addr_t);
    pub fn SBAddressSetLoadAddress(
        instance: SBAddressRef,
        load_addr: lldb_addr_t,
        target: SBTargetRef,
    );
    pub fn SBAddressOffsetAddress(instance: SBAddressRef, offset: lldb_addr_t) -> bool;
    pub fn SBAddressGetDescription(instance: SBAddressRef, description: SBStreamRef) -> bool;
    pub fn SBAddressGetSymbolContext(
        instance: SBAddressRef,
        resolve_scope: u32,
    ) -> SBSymbolContextRef;
    pub fn SBAddressGetSection(instance: SBAddressRef) -> SBSectionRef;
    pub fn SBAddressGetOffset(instance: SBAddressRef) -> lldb_addr_t;
    pub fn SBAddressGetModule(instance: SBAddressRef) -> SBModuleRef;
    pub fn SBAddressGetCompileUnit(instance: SBAddressRef) -> SBCompileUnitRef;
    pub fn SBAddressGetFunction(instance: SBAddressRef) -> SBFunctionRef;
    pub fn SBAddressGetBlock(instance: SBAddressRef) -> SBBlockRef;
    pub fn SBAddressGetSymbol(instance: SBAddressRef) -> SBSymbolRef;
    pub fn SBAddressGetLineEntry(instance: SBAddressRef) -> SBLineEntryRef;
    pub fn SBAddressIsEqual(instance: SBAddressRef, other: SBAddressRef) -> bool;
    pub fn CreateSBAttachInfo() -> SBAttachInfoRef;
    pub fn CreateSBAttachInfo2(pid: lldb_pid_t) -> SBAttachInfoRef;
    pub fn CreateSBAttachInfo3(
        path: *const ::std::os::raw::c_char,
        wait_for: bool,
    ) -> SBAttachInfoRef;
    pub fn CreateSBAttachInfo4(
        path: *const ::std::os::raw::c_char,
        wait_for: bool,
        asynchronous: bool,
    ) -> SBAttachInfoRef;
    pub fn CloneSBAttachInfo(instance: SBAttachInfoRef) -> SBAttachInfoRef;
    pub fn DisposeSBAttachInfo(instance: SBAttachInfoRef);
    pub fn SBAttachInfoGetProcessID(instance: SBAttachInfoRef) -> lldb_pid_t;
    pub fn SBAttachInfoSetProcessID(instance: SBAttachInfoRef, pid: lldb_pid_t);
    pub fn SBAttachInfoSetExecutable(
        instance: SBAttachInfoRef,
        path: *const ::std::os::raw::c_char,
    );
    pub fn SBAttachInfoSetExecutable2(instance: SBAttachInfoRef, exe_file: SBFileSpecRef);
    pub fn SBAttachInfoGetWaitForLaunch(instance: SBAttachInfoRef) -> bool;
    pub fn SBAttachInfoSetWaitForLaunch(instance: SBAttachInfoRef, b: bool);
    pub fn SBAttachInfoSetWaitForLaunch2(instance: SBAttachInfoRef, b: bool, asynchronous: bool);
    pub fn SBAttachInfoGetIgnoreExisting(instance: SBAttachInfoRef) -> bool;
    pub fn SBAttachInfoSetIgnoreExisting(instance: SBAttachInfoRef, b: bool);
    pub fn SBAttachInfoGetResumeCount(instance: SBAttachInfoRef) -> u32;
    pub fn SBAttachInfoSetResumeCount(instance: SBAttachInfoRef, c: u32);
    pub fn SBAttachInfoGetProcessPluginName(
        instance: SBAttachInfoRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBAttachInfoSetProcessPluginName(
        instance: SBAttachInfoRef,
        plugin_name: *const ::std::os::raw::c_char,
    );
    pub fn SBAttachInfoGetUserID(instance: SBAttachInfoRef) -> u32;
    pub fn SBAttachInfoGetGroupID(instance: SBAttachInfoRef) -> u32;
    pub fn SBAttachInfoUserIDIsValid(instance: SBAttachInfoRef) -> bool;
    pub fn SBAttachInfoGroupIDIsValid(instance: SBAttachInfoRef) -> bool;
    pub fn SBAttachInfoSetUserID(instance: SBAttachInfoRef, uid: u32);
    pub fn SBAttachInfoSetGroupID(instance: SBAttachInfoRef, gid: u32);
    pub fn SBAttachInfoGetEffectiveUserID(instance: SBAttachInfoRef) -> u32;
    pub fn SBAttachInfoGetEffectiveGroupID(instance: SBAttachInfoRef) -> u32;
    pub fn SBAttachInfoEffectiveUserIDIsValid(instance: SBAttachInfoRef) -> bool;
    pub fn SBAttachInfoEffectiveGroupIDIsValid(instance: SBAttachInfoRef) -> bool;
    pub fn SBAttachInfoSetEffectiveUserID(instance: SBAttachInfoRef, uid: u32);
    pub fn SBAttachInfoSetEffectiveGroupID(instance: SBAttachInfoRef, gid: u32);
    pub fn SBAttachInfoGetParentProcessID(instance: SBAttachInfoRef) -> lldb_pid_t;
    pub fn SBAttachInfoSetParentProcessID(instance: SBAttachInfoRef, pid: lldb_pid_t);
    pub fn SBAttachInfoParentProcessIDIsValid(instance: SBAttachInfoRef) -> bool;
    pub fn SBAttachInfoGetListener(instance: SBAttachInfoRef) -> SBListenerRef;
    pub fn SBAttachInfoSetListener(instance: SBAttachInfoRef, listener: SBListenerRef);
    pub fn CreateSBBlock() -> SBBlockRef;
    pub fn CloneSBBlock(instance: SBBlockRef) -> SBBlockRef;
    pub fn DisposeSBBlock(instance: SBBlockRef);
    pub fn SBBlockIsInlined(instance: SBBlockRef) -> bool;
    pub fn SBBlockIsValid(instance: SBBlockRef) -> bool;
    pub fn SBBlockGetInlinedName(instance: SBBlockRef) -> *const ::std::os::raw::c_char;
    pub fn SBBlockGetInlinedCallSiteFile(instance: SBBlockRef) -> SBFileSpecRef;
    pub fn SBBlockGetInlinedCallSiteLine(instance: SBBlockRef) -> u32;
    pub fn SBBlockGetInlinedCallSiteColumn(instance: SBBlockRef) -> u32;
    pub fn SBBlockGetParent(instance: SBBlockRef) -> SBBlockRef;
    pub fn SBBlockGetSibling(instance: SBBlockRef) -> SBBlockRef;
    pub fn SBBlockGetFirstChild(instance: SBBlockRef) -> SBBlockRef;
    pub fn SBBlockGetNumRanges(instance: SBBlockRef) -> u32;
    pub fn SBBlockGetRangeStartAddress(instance: SBBlockRef, idx: u32) -> SBAddressRef;
    pub fn SBBlockGetRangeEndAddress(instance: SBBlockRef, idx: u32) -> SBAddressRef;
    pub fn SBBlockGetRangeIndexForBlockAddress(
        instance: SBBlockRef,
        block_addr: SBAddressRef,
    ) -> u32;
    pub fn SBBlockGetVariables(
        instance: SBBlockRef,
        frame: SBFrameRef,
        arguments: bool,
        locals: bool,
        statics: bool,
        use_dynamic: DynamicValueType,
    ) -> SBValueListRef;
    pub fn SBBlockGetVariables2(
        instance: SBBlockRef,
        target: SBTargetRef,
        arguments: bool,
        locals: bool,
        statics: bool,
    ) -> SBValueListRef;
    pub fn SBBlockGetContainingInlinedBlock(instance: SBBlockRef) -> SBBlockRef;
    pub fn SBBlockGetDescription(instance: SBBlockRef, description: SBStreamRef) -> bool;
    pub fn CreateSBBreakpoint() -> SBBreakpointRef;
    pub fn CloneSBBreakpoint(instance: SBBreakpointRef) -> SBBreakpointRef;
    pub fn DisposeSBBreakpoint(instance: SBBreakpointRef);
    pub fn SBBreakpointGetID(instance: SBBreakpointRef) -> lldb_break_id_t;
    pub fn SBBreakpointIsValid(instance: SBBreakpointRef) -> bool;
    pub fn SBBreakpointClearAllBreakpointSites(instance: SBBreakpointRef);
    pub fn SBBreakpointFindLocationByAddress(
        instance: SBBreakpointRef,
        vm_addr: lldb_addr_t,
    ) -> SBBreakpointLocationRef;
    pub fn SBBreakpointFindLocationIDByAddress(
        instance: SBBreakpointRef,
        vm_addr: lldb_addr_t,
    ) -> lldb_break_id_t;
    pub fn SBBreakpointFindLocationByID(
        instance: SBBreakpointRef,
        bp_loc_id: lldb_break_id_t,
    ) -> SBBreakpointLocationRef;
    pub fn SBBreakpointGetLocationAtIndex(
        instance: SBBreakpointRef,
        index: u32,
    ) -> SBBreakpointLocationRef;
    pub fn SBBreakpointSetEnabled(instance: SBBreakpointRef, enable: bool);
    pub fn SBBreakpointIsEnabled(instance: SBBreakpointRef) -> bool;
    pub fn SBBreakpointSetOneShot(instance: SBBreakpointRef, one_shot: bool);
    pub fn SBBreakpointIsOneShot(instance: SBBreakpointRef) -> bool;
    pub fn SBBreakpointIsInternal(instance: SBBreakpointRef) -> bool;
    pub fn SBBreakpointGetHitCount(instance: SBBreakpointRef) -> u32;
    pub fn SBBreakpointSetIgnoreCount(instance: SBBreakpointRef, count: u32);
    pub fn SBBreakpointGetIgnoreCount(instance: SBBreakpointRef) -> u32;
    pub fn SBBreakpointSetCondition(
        instance: SBBreakpointRef,
        condition: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointGetCondition(instance: SBBreakpointRef) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointSetAutoContinue(instance: SBBreakpointRef, auto_continue: bool);
    pub fn SBBreakpointGetAutoContinue(instance: SBBreakpointRef) -> bool;
    pub fn SBBreakpointSetThreadID(instance: SBBreakpointRef, sb_thread_id: lldb_tid_t);
    pub fn SBBreakpointGetThreadID(instance: SBBreakpointRef) -> lldb_tid_t;
    pub fn SBBreakpointSetThreadIndex(instance: SBBreakpointRef, index: u32);
    pub fn SBBreakpointGetThreadIndex(instance: SBBreakpointRef) -> u32;
    pub fn SBBreakpointSetThreadName(
        instance: SBBreakpointRef,
        thread_name: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointGetThreadName(instance: SBBreakpointRef) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointSetQueueName(
        instance: SBBreakpointRef,
        queue_name: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointGetQueueName(instance: SBBreakpointRef) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointSetScriptCallbackFunction(
        instance: SBBreakpointRef,
        callback_function_name: *const ::std::os::raw::c_char,
        extra_args: SBStructuredDataRef,
    ) -> SBErrorRef;
    pub fn SBBreakpointSetCommandLineCommands(instance: SBBreakpointRef, commands: SBStringListRef);
    pub fn SBBreakpointGetCommandLineCommands(
        instance: SBBreakpointRef,
        commands: SBStringListRef,
    ) -> bool;
    pub fn SBBreakpointSetScriptCallbackBody(
        instance: SBBreakpointRef,
        script_body_text: *const ::std::os::raw::c_char,
    ) -> SBErrorRef;
    pub fn SBBreakpointAddName(
        instance: SBBreakpointRef,
        new_name: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBBreakpointAddNameWithErrorHandling(
        instance: SBBreakpointRef,
        new_name: *const ::std::os::raw::c_char,
    ) -> SBErrorRef;
    pub fn SBBreakpointRemoveName(
        instance: SBBreakpointRef,
        name_to_remove: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointMatchesName(
        instance: SBBreakpointRef,
        name: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBBreakpointGetNames(instance: SBBreakpointRef, names: SBStringListRef);
    pub fn SBBreakpointGetNumResolvedLocations(instance: SBBreakpointRef) -> size_t;
    pub fn SBBreakpointGetNumLocations(instance: SBBreakpointRef) -> size_t;
    pub fn SBBreakpointGetDescription(instance: SBBreakpointRef, description: SBStreamRef) -> bool;
    pub fn SBBreakpointGetDescription2(
        instance: SBBreakpointRef,
        description: SBStreamRef,
        include_locations: bool,
    ) -> bool;
    pub fn SBBreakpointEventIsBreakpointEvent(event: SBEventRef) -> bool;
    pub fn SBBreakpointGetBreakpointEventTypeFromEvent(event: SBEventRef) -> BreakpointEventType;
    pub fn SBBreakpointGetBreakpointFromEvent(event: SBEventRef) -> SBBreakpointRef;
    pub fn SBBreakpointGetBreakpointLocationAtIndexFromEvent(
        event: SBEventRef,
        loc_idx: u32,
    ) -> SBBreakpointLocationRef;
    pub fn SBBreakpointGetNumBreakpointLocationsFromEvent(event_sp: SBEventRef) -> u32;
    pub fn SBBreakpointIsHardware(instance: SBBreakpointRef) -> bool;
    pub fn SBBreakpointAddLocation(instance: SBBreakpointRef, address: SBAddressRef) -> SBErrorRef;
    pub fn CreateSBBreakpointList(target: SBTargetRef) -> SBBreakpointListRef;
    pub fn CloneSBBreakpointList(instance: SBBreakpointListRef) -> SBBreakpointListRef;
    pub fn DisposeSBBreakpointList(instance: SBBreakpointListRef);
    pub fn SBBreakpointListGetSize(instance: SBBreakpointListRef) -> size_t;
    pub fn SBBreakpointListGetBreakpointAtIndex(
        instance: SBBreakpointListRef,
        idx: size_t,
    ) -> SBBreakpointRef;
    pub fn SBBreakpointListFindBreakpointByID(
        instance: SBBreakpointListRef,
        break_id: lldb_break_id_t,
    ) -> SBBreakpointRef;
    pub fn SBBreakpointListAppend(instance: SBBreakpointListRef, sb_bkpt: SBBreakpointRef);
    pub fn SBBreakpointListAppendIfUnique(
        instance: SBBreakpointListRef,
        sb_bkpt: SBBreakpointRef,
    ) -> bool;
    pub fn SBBreakpointListAppendByID(instance: SBBreakpointListRef, id: lldb_break_id_t);
    pub fn SBBreakpointListClear(instance: SBBreakpointListRef);
    pub fn CreateSBBreakpointLocation() -> SBBreakpointLocationRef;
    pub fn CloneSBBreakpointLocation(instance: SBBreakpointLocationRef) -> SBBreakpointLocationRef;
    pub fn DisposeSBBreakpointLocation(instance: SBBreakpointLocationRef);
    pub fn SBBreakpointLocationGetID(instance: SBBreakpointLocationRef) -> lldb_break_id_t;
    pub fn SBBreakpointLocationIsValid(instance: SBBreakpointLocationRef) -> bool;
    pub fn SBBreakpointLocationGetAddress(instance: SBBreakpointLocationRef) -> SBAddressRef;
    pub fn SBBreakpointLocationGetLoadAddress(instance: SBBreakpointLocationRef) -> lldb_addr_t;
    pub fn SBBreakpointLocationSetEnabled(instance: SBBreakpointLocationRef, enabled: bool);
    pub fn SBBreakpointLocationIsEnabled(instance: SBBreakpointLocationRef) -> bool;
    pub fn SBBreakpointLocationGetHitCount(instance: SBBreakpointLocationRef) -> u32;
    pub fn SBBreakpointLocationGetIgnoreCount(instance: SBBreakpointLocationRef) -> u32;
    pub fn SBBreakpointLocationSetIgnoreCount(instance: SBBreakpointLocationRef, n: u32);
    pub fn SBBreakpointLocationSetCondition(
        instance: SBBreakpointLocationRef,
        condition: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointLocationGetCondition(
        instance: SBBreakpointLocationRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointLocationSetAutoContinue(
        instance: SBBreakpointLocationRef,
        auto_continue: bool,
    );
    pub fn SBBreakpointLocationGetAutoContinue(instance: SBBreakpointLocationRef) -> bool;
    pub fn SBBreakpointLocationSetScriptCallbackFunction(
        instance: SBBreakpointLocationRef,
        callback_function_name: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointLocationSetScriptCallbackBody(
        instance: SBBreakpointLocationRef,
        script_body_text: *const ::std::os::raw::c_char,
    ) -> SBErrorRef;
    pub fn SBBreakpointLocationSetCommandLineCommands(
        instance: SBBreakpointRef,
        commands: SBStringListRef,
    );
    pub fn SBBreakpointLocationGetCommandLineCommands(
        instance: SBBreakpointRef,
        commands: SBStringListRef,
    ) -> bool;
    pub fn SBBreakpointLocationSetThreadID(
        instance: SBBreakpointLocationRef,
        sb_thread_id: lldb_tid_t,
    );
    pub fn SBBreakpointLocationGetThreadID(instance: SBBreakpointLocationRef) -> lldb_tid_t;
    pub fn SBBreakpointLocationSetThreadIndex(instance: SBBreakpointLocationRef, index: u32);
    pub fn SBBreakpointLocationGetThreadIndex(instance: SBBreakpointLocationRef) -> u32;
    pub fn SBBreakpointLocationSetThreadName(
        instance: SBBreakpointLocationRef,
        thread_name: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointLocationGetThreadName(
        instance: SBBreakpointLocationRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointLocationSetQueueName(
        instance: SBBreakpointLocationRef,
        queue_name: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointLocationGetQueueName(
        instance: SBBreakpointLocationRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointLocationIsResolved(instance: SBBreakpointLocationRef) -> bool;
    pub fn SBBreakpointLocationGetDescription(
        instance: SBBreakpointLocationRef,
        description: SBStreamRef,
        level: DescriptionLevel,
    ) -> bool;
    pub fn SBBreakpointLocationGetBreakpoint(instance: SBBreakpointLocationRef) -> SBBreakpointRef;
    pub fn CreateSBBreakpointName() -> SBBreakpointNameRef;
    pub fn CreateSBBreakpointNameFromTarget(
        target: SBTargetRef,
        name: *const ::std::os::raw::c_char,
    ) -> SBBreakpointNameRef;
    pub fn CreateSBBreakpointNameFromBreakpoint(
        breakpoint: SBBreakpointRef,
        name: *const ::std::os::raw::c_char,
    ) -> SBBreakpointNameRef;
    pub fn CloneSBBreakpointName(instance: SBBreakpointNameRef) -> SBBreakpointNameRef;
    pub fn DisposeSBBreakpointName(instance: SBBreakpointNameRef);
    pub fn SBBreakpointNameIsValid(instance: SBBreakpointNameRef) -> bool;
    pub fn SBBreakpointNameGetName(instance: SBBreakpointNameRef) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointNameSetEnabled(instance: SBBreakpointNameRef, enable: bool);
    pub fn SBBreakpointNameIsEnabled(instance: SBBreakpointNameRef) -> bool;
    pub fn SBBreakpointNameSetOneShot(instance: SBBreakpointNameRef, one_shot: bool);
    pub fn SBBreakpointNameIsOneShot(instance: SBBreakpointNameRef) -> bool;
    pub fn SBBreakpointNameSetIgnoreCount(instance: SBBreakpointNameRef, count: u32);
    pub fn SBBreakpointNameGetIgnoreCount(instance: SBBreakpointNameRef) -> u32;
    pub fn SBBreakpointNameSetCondition(
        instance: SBBreakpointNameRef,
        condition: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointNameGetCondition(
        instance: SBBreakpointNameRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointNameSetAutoContinue(instance: SBBreakpointNameRef, auto_continue: bool);
    pub fn SBBreakpointNameGetAutoContinue(instance: SBBreakpointNameRef) -> bool;
    pub fn SBBreakpointNameSetThreadID(instance: SBBreakpointNameRef, sb_thread_id: lldb_tid_t);
    pub fn SBBreakpointNameGetThreadID(instance: SBBreakpointNameRef) -> lldb_tid_t;
    pub fn SBBreakpointNameSetThreadIndex(instance: SBBreakpointNameRef, index: u32);
    pub fn SBBreakpointNameGetThreadIndex(instance: SBBreakpointNameRef) -> u32;
    pub fn SBBreakpointNameSetThreadName(
        instance: SBBreakpointNameRef,
        thread_name: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointNameGetThreadName(
        instance: SBBreakpointNameRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointNameSetQueueName(
        instance: SBBreakpointNameRef,
        queue_name: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointNameGetQueueName(
        instance: SBBreakpointNameRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointNameSetCallback(
        instance: SBBreakpointNameRef,
        callback: SBBreakpointHitCallback,
        baton: *mut ::std::os::raw::c_void,
    );
    pub fn SBBreakpointNameSetScriptCallbackFunction(
        instance: SBBreakpointNameRef,
        callback_function_name: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointNameSetCommandLineCommands(
        instance: SBBreakpointNameRef,
        commands: SBStringListRef,
    );
    pub fn SBBreakpointNameGetCommandLineCommands(
        instance: SBBreakpointNameRef,
        commands: SBStringListRef,
    ) -> bool;
    pub fn SBBreakpointNameSetScriptCallbackBody(
        instance: SBBreakpointNameRef,
        script_body_text: *const ::std::os::raw::c_char,
    ) -> SBErrorRef;
    pub fn SBBreakpointNameGetHelpString(
        instance: SBBreakpointNameRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBBreakpointNameSetHelpString(
        instance: SBBreakpointNameRef,
        help_string: *const ::std::os::raw::c_char,
    );
    pub fn SBBreakpointNameGetAllowList(instance: SBBreakpointNameRef) -> bool;
    pub fn SBBreakpointNameSetAllowList(instance: SBBreakpointNameRef, value: bool);
    pub fn SBBreakpointNameGetAllowDelete(instance: SBBreakpointNameRef) -> bool;
    pub fn SBBreakpointNameSetAllowDelete(instance: SBBreakpointNameRef, value: bool);
    pub fn SBBreakpointNameGetAllowDisable(instance: SBBreakpointNameRef) -> bool;
    pub fn SBBreakpointNameSetAllowDisable(instance: SBBreakpointNameRef, value: bool);
    pub fn SBBreakpointNameGetDescription(
        instance: SBBreakpointNameRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn CreateSBBroadcaster() -> SBBroadcasterRef;
    pub fn CreateSBBroadcaster2(name: *const ::std::os::raw::c_char) -> SBBroadcasterRef;
    pub fn CloneSBBroadcaster(instance: SBBroadcasterRef) -> SBBroadcasterRef;
    pub fn DisposeSBBroadcaster(instance: SBBroadcasterRef);
    pub fn SBBroadcasterIsValid(instance: SBBroadcasterRef) -> bool;
    pub fn SBBroadcasterClear(instance: SBBroadcasterRef);
    pub fn SBBroadcasterBroadcastEventByType(
        instance: SBBroadcasterRef,
        event_type: u32,
        unique: bool,
    );
    pub fn SBBroadcasterBroadcastEvent(instance: SBBroadcasterRef, event: SBEventRef, unique: bool);
    pub fn SBBroadcasterAddInitialEventsToListener(
        instance: SBBroadcasterRef,
        listener: SBListenerRef,
        requested_events: u32,
    );
    pub fn SBBroadcasterAddListener(
        instance: SBBroadcasterRef,
        listener: SBListenerRef,
        event_mask: u32,
    ) -> u32;
    pub fn SBBroadcasterGetName(instance: SBBroadcasterRef) -> *const ::std::os::raw::c_char;
    pub fn SBBroadcasterEventTypeHasListeners(instance: SBBroadcasterRef, event_type: u32) -> bool;
    pub fn SBBroadcasterRemoveListener(
        instance: SBBroadcasterRef,
        listener: SBListenerRef,
        event_mask: u32,
    ) -> bool;
    pub fn CreateSBCommandInterpreterRunOptions() -> SBCommandInterpreterRunOptionsRef;
    pub fn DisposeSBCommandInterpreterRunOptions(instance: SBCommandInterpreterRunOptionsRef);
    pub fn SBCommandInterpreterRunOptionsGetStopOnContinue(
        instance: SBCommandInterpreterRunOptionsRef,
    ) -> bool;
    pub fn SBCommandInterpreterRunOptionsSetStopOnContinue(
        instance: SBCommandInterpreterRunOptionsRef,
        arg1: bool,
    );
    pub fn SBCommandInterpreterRunOptionsGetStopOnError(
        instance: SBCommandInterpreterRunOptionsRef,
    ) -> bool;
    pub fn SBCommandInterpreterRunOptionsSetStopOnError(
        instance: SBCommandInterpreterRunOptionsRef,
        arg1: bool,
    );
    pub fn SBCommandInterpreterRunOptionsGetStopOnCrash(
        instance: SBCommandInterpreterRunOptionsRef,
    ) -> bool;
    pub fn SBCommandInterpreterRunOptionsSetStopOnCrash(
        instance: SBCommandInterpreterRunOptionsRef,
        arg1: bool,
    );
    pub fn SBCommandInterpreterRunOptionsGetEchoCommands(
        instance: SBCommandInterpreterRunOptionsRef,
    ) -> bool;
    pub fn SBCommandInterpreterRunOptionsSetEchoCommands(
        instance: SBCommandInterpreterRunOptionsRef,
        arg1: bool,
    );
    pub fn SBCommandInterpreterRunOptionsGetPrintResults(
        instance: SBCommandInterpreterRunOptionsRef,
    ) -> bool;
    pub fn SBCommandInterpreterRunOptionsSetPrintResults(
        instance: SBCommandInterpreterRunOptionsRef,
        arg1: bool,
    );
    pub fn SBCommandInterpreterRunOptionsGetAddToHistory(
        instance: SBCommandInterpreterRunOptionsRef,
    ) -> bool;
    pub fn SBCommandInterpreterRunOptionsSetAddToHistory(
        instance: SBCommandInterpreterRunOptionsRef,
        arg1: bool,
    );
    pub fn CloneSBCommandInterpreter(instance: SBCommandInterpreterRef) -> SBCommandInterpreterRef;
    pub fn DisposeSBCommandInterpreter(instance: SBCommandInterpreterRef);
    pub fn SBCommandInterpreterGetArgumentTypeAsCString(
        arg_type: CommandArgumentType,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBCommandInterpreterGetArgumentDescriptionAsCString(
        arg_type: CommandArgumentType,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBCommandInterpreterEventIsCommandInterpreterEvent(event: SBEventRef) -> bool;
    pub fn SBCommandInterpreterIsValid(instance: SBCommandInterpreterRef) -> bool;
    pub fn SBCommandInterpreterCommandExists(
        instance: SBCommandInterpreterRef,
        cmd: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBCommandInterpreterAliasExists(
        instance: SBCommandInterpreterRef,
        cmd: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBCommandInterpreterGetBroadcaster(
        instance: SBCommandInterpreterRef,
    ) -> SBBroadcasterRef;
    pub fn SBCommandInterpreterGetBroadcasterClass() -> *const ::std::os::raw::c_char;
    pub fn SBCommandInterpreterHasCommands(instance: SBCommandInterpreterRef) -> bool;
    pub fn SBCommandInterpreterHasAliases(instance: SBCommandInterpreterRef) -> bool;
    pub fn SBCommandInterpreterHasAliasOptions(instance: SBCommandInterpreterRef) -> bool;
    pub fn SBCommandInterpreterGetProcess(instance: SBCommandInterpreterRef) -> SBProcessRef;
    pub fn SBCommandInterpreterGetDebugger(instance: SBCommandInterpreterRef) -> SBDebuggerRef;
    pub fn SBCommandInterpreterAddMultiwordCommand(
        instance: SBCommandInterpreterRef,
        name: *const ::std::os::raw::c_char,
        help: *const ::std::os::raw::c_char,
    ) -> SBCommandRef;
    pub fn SBCommandInterpreterAddCommand(
        instance: SBCommandInterpreterRef,
        name: *const ::std::os::raw::c_char,
        impl_: SBCommandPluginInterfaceRef,
        help: *const ::std::os::raw::c_char,
    ) -> SBCommandRef;
    pub fn SBCommandInterpreterSourceInitFileInHomeDirectory(
        instance: SBCommandInterpreterRef,
        result: SBCommandReturnObjectRef,
    );
    pub fn SBCommandInterpreterSourceInitFileInCurrentWorkingDirectory(
        instance: SBCommandInterpreterRef,
        result: SBCommandReturnObjectRef,
    );
    pub fn SBCommandInterpreterHandleCommand(
        instance: SBCommandInterpreterRef,
        command_line: *const ::std::os::raw::c_char,
        result: SBCommandReturnObjectRef,
        add_to_history: bool,
    ) -> ReturnStatus;
    pub fn SBCommandInterpreterHandleCommand2(
        instance: SBCommandInterpreterRef,
        command_line: *const ::std::os::raw::c_char,
        exe_ctx: SBExecutionContextRef,
        result: SBCommandReturnObjectRef,
        add_to_history: bool,
    ) -> ReturnStatus;
    pub fn SBCommandInterpreterHandleCommandsFromFile(
        instance: SBCommandInterpreterRef,
        file: SBFileSpecRef,
        override_context: SBExecutionContextRef,
        options: SBCommandInterpreterRunOptionsRef,
        result: SBCommandReturnObjectRef,
    );
    pub fn SBCommandInterpreterHandleCompletion(
        instance: SBCommandInterpreterRef,
        current_line: *const ::std::os::raw::c_char,
        cursor: *const ::std::os::raw::c_char,
        last_char: *const ::std::os::raw::c_char,
        match_start_point: ::std::os::raw::c_int,
        max_return_elements: ::std::os::raw::c_int,
        matches: SBStringListRef,
    ) -> ::std::os::raw::c_int;
    pub fn SBCommandInterpreterHandleCompletion2(
        instance: SBCommandInterpreterRef,
        current_line: *const ::std::os::raw::c_char,
        cursor_pos: u32,
        match_start_point: ::std::os::raw::c_int,
        max_return_elements: ::std::os::raw::c_int,
        matches: SBStringListRef,
    ) -> ::std::os::raw::c_int;
    pub fn SBCommandInterpreterHandleCompletionWithDescriptions(
        instance: SBCommandInterpreterRef,
        current_line: *const ::std::os::raw::c_char,
        cursor: *const ::std::os::raw::c_char,
        last_char: *const ::std::os::raw::c_char,
        match_start_point: ::std::os::raw::c_int,
        max_return_elements: ::std::os::raw::c_int,
        matches: SBStringListRef,
        descriptions: SBStringListRef,
    ) -> ::std::os::raw::c_int;
    pub fn SBCommandInterpreterHandleCompletionWithDescriptions2(
        instance: SBCommandInterpreterRef,
        current_line: *const ::std::os::raw::c_char,
        cursor_pos: u32,
        match_start_point: ::std::os::raw::c_int,
        max_return_elements: ::std::os::raw::c_int,
        matches: SBStringListRef,
        descriptions: SBStringListRef,
    ) -> ::std::os::raw::c_int;
    pub fn SBCommandInterpreterWasInterrupted(instance: SBCommandInterpreterRef) -> bool;
    pub fn SBCommandInterpreterIsActive(instance: SBCommandInterpreterRef) -> bool;
    pub fn SBCommandInterpreterGetIOHandlerControlSequence(
        instance: SBCommandInterpreterRef,
        ch: ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBCommandInterpreterGetPromptOnQuit(instance: SBCommandInterpreterRef) -> bool;
    pub fn SBCommandInterpreterSetPromptOnQuit(instance: SBCommandInterpreterRef, b: bool);
    pub fn SBCommandPluginInterfaceDoExecute(
        instance: SBCommandPluginInterfaceRef,
        arg1: SBDebuggerRef,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: SBCommandReturnObjectRef,
    ) -> bool;
    pub fn CloneSBCommandPluginInterface(
        instance: SBCommandPluginInterfaceRef,
    ) -> SBCommandPluginInterfaceRef;
    pub fn DisposeSBCommandPluginInterface(instance: SBCommandPluginInterfaceRef);
    pub fn CreateSBCommand() -> SBCommandRef;
    pub fn SBCommandIsValid(instance: SBCommandRef) -> bool;
    pub fn SBCommandGetName(instance: SBCommandRef) -> *const ::std::os::raw::c_char;
    pub fn SBCommandGetHelp(instance: SBCommandRef) -> *const ::std::os::raw::c_char;
    pub fn SBCommandGetHelpLong(instance: SBCommandRef) -> *const ::std::os::raw::c_char;
    pub fn SBCommandSetHelp(instance: SBCommandRef, arg1: *const ::std::os::raw::c_char);
    pub fn SBCommandSetHelpLong(instance: SBCommandRef, arg1: *const ::std::os::raw::c_char);
    pub fn SBCommandAddMultiwordCommand(
        instance: SBCommandRef,
        name: *const ::std::os::raw::c_char,
        help: *const ::std::os::raw::c_char,
    ) -> SBCommandRef;
    pub fn SBCommandAddCommand(
        instance: SBCommandRef,
        name: *const ::std::os::raw::c_char,
        impl_: SBCommandPluginInterfaceRef,
        help: *const ::std::os::raw::c_char,
    ) -> SBCommandRef;
    pub fn CloneSBCommand(instance: SBCommandRef) -> SBCommandRef;
    pub fn DisposeSBCommand(instance: SBCommandRef);
    pub fn CreateSBCommandReturnObject() -> SBCommandReturnObjectRef;
    pub fn CloneSBCommandReturnObject(
        instance: SBCommandReturnObjectRef,
    ) -> SBCommandReturnObjectRef;
    pub fn DisposeSBCommandReturnObject(instance: SBCommandReturnObjectRef);
    pub fn SBCommandReturnObjectIsValid(instance: SBCommandReturnObjectRef) -> bool;
    pub fn SBCommandReturnObjectGetOutput(
        instance: SBCommandReturnObjectRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBCommandReturnObjectGetError(
        instance: SBCommandReturnObjectRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBCommandReturnObjectPutOutput(
        instance: SBCommandReturnObjectRef,
        fh: *mut FILE,
    ) -> size_t;
    pub fn SBCommandReturnObjectGetOutputSize(instance: SBCommandReturnObjectRef) -> size_t;
    pub fn SBCommandReturnObjectGetErrorSize(instance: SBCommandReturnObjectRef) -> size_t;
    pub fn SBCommandReturnObjectPutError(
        instance: SBCommandReturnObjectRef,
        fh: *mut FILE,
    ) -> size_t;
    pub fn SBCommandReturnObjectClear(instance: SBCommandReturnObjectRef);
    pub fn SBCommandReturnObjectGetStatus(instance: SBCommandReturnObjectRef) -> ReturnStatus;
    pub fn SBCommandReturnObjectSetStatus(instance: SBCommandReturnObjectRef, status: ReturnStatus);
    pub fn SBCommandReturnObjectSucceeded(instance: SBCommandReturnObjectRef) -> bool;
    pub fn SBCommandReturnObjectHasResult(instance: SBCommandReturnObjectRef) -> bool;
    pub fn SBCommandReturnObjectAppendMessage(
        instance: SBCommandReturnObjectRef,
        message: *const ::std::os::raw::c_char,
    );
    pub fn SBCommandReturnObjectAppendWarning(
        instance: SBCommandReturnObjectRef,
        message: *const ::std::os::raw::c_char,
    );
    pub fn SBCommandReturnObjectGetDescription(
        instance: SBCommandReturnObjectRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn SBCommandReturnObjectSetImmediateOutputFile(
        instance: SBCommandReturnObjectRef,
        fh: *mut FILE,
    );
    pub fn SBCommandReturnObjectSetImmediateErrorFile(
        instance: SBCommandReturnObjectRef,
        fh: *mut FILE,
    );
    pub fn SBCommandReturnObjectPutCString(
        instance: SBCommandReturnObjectRef,
        string: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    );
    pub fn SBCommandReturnObjectPrintf(
        instance: SBCommandReturnObjectRef,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> size_t;
    pub fn SBCommandReturnObjectGetOutput2(
        instance: SBCommandReturnObjectRef,
        only_if_no_immediate: bool,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBCommandReturnObjectGetError2(
        instance: SBCommandReturnObjectRef,
        only_if_no_immediate: bool,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBCommandReturnObjectSetError(
        instance: SBCommandReturnObjectRef,
        error: SBErrorRef,
        fallback_error_cstr: *const ::std::os::raw::c_char,
    );
    pub fn SBCommandReturnObjectSetError2(
        instance: SBCommandReturnObjectRef,
        error_cstr: *const ::std::os::raw::c_char,
    );
    pub fn CreateSBCommunication() -> SBCommunicationRef;
    pub fn CreateSBCommunication2(
        broadcaster_name: *const ::std::os::raw::c_char,
    ) -> SBCommunicationRef;
    pub fn DisposeSBCommunication(instance: SBCommunicationRef);
    pub fn SBCommunicationIsValid(instance: SBCommunicationRef) -> bool;
    pub fn SBCommunicationGetBroadcaster(instance: SBCommunicationRef) -> SBBroadcasterRef;
    pub fn SBCommunicationGetBroadcasterClass() -> *const ::std::os::raw::c_char;
    pub fn SBCommunicationAdoptFileDesriptor(
        instance: SBCommunicationRef,
        fd: ::std::os::raw::c_int,
        owns_fd: bool,
    ) -> ConnectionStatus;
    pub fn SBCommunicationConnect(
        instance: SBCommunicationRef,
        url: *const ::std::os::raw::c_char,
    ) -> ConnectionStatus;
    pub fn SBCommunicationDisconnect(instance: SBCommunicationRef) -> ConnectionStatus;
    pub fn SBCommunicationIsConnected(instance: SBCommunicationRef) -> bool;
    pub fn SBCommunicationGetCloseOnEOF(instance: SBCommunicationRef) -> bool;
    pub fn SBCommunicationSetCloseOnEOF(instance: SBCommunicationRef, b: bool);
    pub fn SBCommunicationRead(
        instance: SBCommunicationRef,
        dst: *mut ::std::os::raw::c_void,
        dst_len: size_t,
        timeout_usec: u32,
        status: *mut ConnectionStatus,
    ) -> size_t;
    pub fn SBCommunicationWrite(
        instance: SBCommunicationRef,
        src: *mut ::std::os::raw::c_void,
        src_len: size_t,
        status: *mut ConnectionStatus,
    ) -> size_t;
    pub fn SBCommunicationReadThreadStart(instance: SBCommunicationRef) -> bool;
    pub fn SBCommunicationReadThreadStop(instance: SBCommunicationRef) -> bool;
    pub fn SBCommunicationReadThreadIsRunning(instance: SBCommunicationRef) -> bool;
    pub fn SBCommunicationSetReadThreadBytesReceivedCallback(
        instance: SBCommunicationRef,
        callback: ReadThreadBytesReceived,
        callback_baton: *mut ::std::os::raw::c_void,
    ) -> bool;
    pub fn CreateSBCompileUnit() -> SBCompileUnitRef;
    pub fn CloneSBCompileUnit(instance: SBCompileUnitRef) -> SBCompileUnitRef;
    pub fn DisposeSBCompileUnit(instance: SBCompileUnitRef);
    pub fn SBCompileUnitIsValid(instance: SBCompileUnitRef) -> bool;
    pub fn SBCompileUnitGetFileSpec(instance: SBCompileUnitRef) -> SBFileSpecRef;
    pub fn SBCompileUnitGetNumLineEntries(instance: SBCompileUnitRef) -> u32;
    pub fn SBCompileUnitGetLineEntryAtIndex(instance: SBCompileUnitRef, idx: u32)
        -> SBLineEntryRef;
    pub fn SBCompileUnitFindLineEntryIndex(
        instance: SBCompileUnitRef,
        start_idx: u32,
        line: u32,
        inline_file_spec: SBFileSpecRef,
    ) -> u32;
    pub fn SBCompileUnitFindLineEntryIndex2(
        instance: SBCompileUnitRef,
        start_idx: u32,
        line: u32,
        inline_file_spec: SBFileSpecRef,
        exact: bool,
    ) -> u32;
    pub fn SBCompileUnitGetSupportFileAtIndex(
        instance: SBCompileUnitRef,
        idx: u32,
    ) -> SBFileSpecRef;
    pub fn SBCompileUnitGetNumSupportFiles(instance: SBCompileUnitRef) -> u32;
    pub fn SBCompileUnitFindSupportFileIndex(
        instance: SBCompileUnitRef,
        start_idx: u32,
        sb_file: SBFileSpecRef,
        full: bool,
    ) -> u32;
    pub fn SBCompileUnitGetTypes(instance: SBCompileUnitRef, type_mask: u32) -> SBTypeListRef;
    pub fn SBCompileUnitGetLanguage(instance: SBCompileUnitRef) -> LanguageType;
    pub fn SBCompileUnitGetDescription(
        instance: SBCompileUnitRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn CreateSBData() -> SBDataRef;
    pub fn CloneSBData(instance: SBDataRef) -> SBDataRef;
    pub fn DisposeSBData(instance: SBDataRef);
    pub fn SBDataGetAddressByteSize(instance: SBDataRef) -> u8;
    pub fn SBDataSetAddressByteSize(instance: SBDataRef, addr_byte_size: u8);
    pub fn SBDataClear(instance: SBDataRef);
    pub fn SBDataIsValid(instance: SBDataRef) -> bool;
    pub fn SBDataGetByteSize(instance: SBDataRef) -> size_t;
    pub fn SBDataGetByteOrder(instance: SBDataRef) -> ByteOrder;
    pub fn SBDataSetByteOrder(instance: SBDataRef, endian: ByteOrder);
    pub fn SBDataGetFloat(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> ::std::os::raw::c_float;
    pub fn SBDataGetDouble(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> ::std::os::raw::c_double;
    pub fn SBDataGetLongDouble(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> ::std::os::raw::c_double;
    pub fn SBDataGetAddress(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> lldb_addr_t;
    pub fn SBDataGetUnsignedInt8(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> u8;
    pub fn SBDataGetUnsignedInt16(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> u16;
    pub fn SBDataGetUnsignedInt32(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> u32;
    pub fn SBDataGetUnsignedInt64(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> u64;
    pub fn SBDataGetSignedInt8(instance: SBDataRef, error: SBErrorRef, offset: lldb_offset_t)
        -> i8;
    pub fn SBDataGetSignedInt16(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> i16;
    pub fn SBDataGetSignedInt32(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> i32;
    pub fn SBDataGetSignedInt64(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> i64;
    pub fn SBDataGetString(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBDataReadRawData(
        instance: SBDataRef,
        error: SBErrorRef,
        offset: lldb_offset_t,
        buf: *mut ::std::os::raw::c_void,
        size: size_t,
    ) -> size_t;
    pub fn SBDataGetDescription(
        instance: SBDataRef,
        description: SBStreamRef,
        base_addr: lldb_addr_t,
    ) -> bool;
    pub fn SBDataSetData(
        instance: SBDataRef,
        error: SBErrorRef,
        buf: *mut ::std::os::raw::c_void,
        size: size_t,
        endian: ByteOrder,
        addr_size: u8,
    );
    pub fn SBDataAppend(instance: SBDataRef, rhs: SBDataRef) -> bool;
    pub fn SBDataCreateDataFromCString(
        endian: ByteOrder,
        addr_byte_size: u32,
        data: *const ::std::os::raw::c_char,
    ) -> SBDataRef;
    pub fn SBDataCreateDataFromUInt64Array(
        endian: ByteOrder,
        addr_byte_size: u32,
        array: *mut u64,
        array_len: size_t,
    ) -> SBDataRef;
    pub fn SBDataCreateDataFromUInt32Array(
        endian: ByteOrder,
        addr_byte_size: u32,
        array: *mut u32,
        array_len: size_t,
    ) -> SBDataRef;
    pub fn SBDataCreateDataFromSInt64Array(
        endian: ByteOrder,
        addr_byte_size: u32,
        array: *mut i64,
        array_len: size_t,
    ) -> SBDataRef;
    pub fn SBDataCreateDataFromSInt32Array(
        endian: ByteOrder,
        addr_byte_size: u32,
        array: *mut i32,
        array_len: size_t,
    ) -> SBDataRef;
    pub fn SBDataCreateDataFromDoubleArray(
        endian: ByteOrder,
        addr_byte_size: u32,
        array: *mut ::std::os::raw::c_double,
        array_len: size_t,
    ) -> SBDataRef;
    pub fn SBDataSetDataFromCString(
        instance: SBDataRef,
        data: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBDataSetDataFromUInt64Array(
        instance: SBDataRef,
        array: *mut u64,
        array_len: size_t,
    ) -> bool;
    pub fn SBDataSetDataFromUInt32Array(
        instance: SBDataRef,
        array: *mut u32,
        array_len: size_t,
    ) -> bool;
    pub fn SBDataSetDataFromSInt64Array(
        instance: SBDataRef,
        array: *mut i64,
        array_len: size_t,
    ) -> bool;
    pub fn SBDataSetDataFromSInt32Array(
        instance: SBDataRef,
        array: *mut i32,
        array_len: size_t,
    ) -> bool;
    pub fn SBDataSetDataFromDoubleArray(
        instance: SBDataRef,
        array: *mut ::std::os::raw::c_double,
        array_len: size_t,
    ) -> bool;
    pub fn CreateSBInputReader() -> SBInputReaderRef;
    pub fn CloneSBInputReader(instance: SBInputReaderRef) -> SBInputReaderRef;
    pub fn DisposeSBInputReader(instance: SBInputReaderRef);
    pub fn SBInputReaderSetIsDone(instance: SBInputReaderRef, arg1: bool);
    pub fn SBInputReaderIsActive(instance: SBInputReaderRef) -> bool;
    pub fn SBDebuggerInitialize();
    pub fn SBDebuggerTerminate();
    pub fn CloneSBDebugger(instance: SBDebuggerRef) -> SBDebuggerRef;
    pub fn SBDebuggerCreate() -> SBDebuggerRef;
    pub fn SBDebuggerCreate2(source_init_files: bool) -> SBDebuggerRef;
    pub fn SBDebuggerDestroy(debugger: SBDebuggerRef);
    pub fn SBDebuggerMemoryPressureDetected();
    pub fn CreateSBDebugger() -> SBDebuggerRef;
    pub fn DisposeSBDebugger(instance: SBDebuggerRef);
    pub fn SBDebuggerIsValid(instance: SBDebuggerRef) -> bool;
    pub fn SBDebuggerClear(instance: SBDebuggerRef);
    pub fn SBDebuggerSetAsync(instance: SBDebuggerRef, b: bool);
    pub fn SBDebuggerGetAsync(instance: SBDebuggerRef) -> bool;
    pub fn SBDebuggerSkipLLDBInitFiles(instance: SBDebuggerRef, b: bool);
    pub fn SBDebuggerSkipAppInitFiles(instance: SBDebuggerRef, b: bool);
    pub fn SBDebuggerSetInputFileHandle(
        instance: SBDebuggerRef,
        f: *mut FILE,
        transfer_ownership: bool,
    );
    pub fn SBDebuggerSetOutputFileHandle(
        instance: SBDebuggerRef,
        f: *mut FILE,
        transfer_ownership: bool,
    );
    pub fn SBDebuggerSetErrorFileHandle(
        instance: SBDebuggerRef,
        f: *mut FILE,
        transfer_ownership: bool,
    );
    pub fn SBDebuggerGetInputFileHandle(instance: SBDebuggerRef) -> *mut FILE;
    pub fn SBDebuggerGetOutputFileHandle(instance: SBDebuggerRef) -> *mut FILE;
    pub fn SBDebuggerGetErrorFileHandle(instance: SBDebuggerRef) -> *mut FILE;
    pub fn SBDebuggerSaveInputTerminalState(instance: SBDebuggerRef);
    pub fn SBDebuggerRestoreInputTerminalState(instance: SBDebuggerRef);
    pub fn SBDebuggerGetCommandInterpreter(instance: SBDebuggerRef) -> SBCommandInterpreterRef;
    pub fn SBDebuggerHandleCommand(instance: SBDebuggerRef, command: *const ::std::os::raw::c_char);
    pub fn SBDebuggerGetListener(instance: SBDebuggerRef) -> SBListenerRef;
    pub fn SBDebuggerHandleProcessEvent(
        instance: SBDebuggerRef,
        process: SBProcessRef,
        event: SBEventRef,
        out: *mut FILE,
        err: *mut FILE,
    );
    pub fn SBDebuggerCreateTarget(
        instance: SBDebuggerRef,
        filename: *const ::std::os::raw::c_char,
        target_triple: *const ::std::os::raw::c_char,
        platform_name: *const ::std::os::raw::c_char,
        add_dependent_modules: bool,
        error: SBErrorRef,
    ) -> SBTargetRef;
    pub fn SBDebuggerCreateTargetWithFileAndTargetTriple(
        instance: SBDebuggerRef,
        filename: *const ::std::os::raw::c_char,
        target_triple: *const ::std::os::raw::c_char,
    ) -> SBTargetRef;
    pub fn SBDebuggerCreateTargetWithFileAndArch(
        instance: SBDebuggerRef,
        filename: *const ::std::os::raw::c_char,
        archname: *const ::std::os::raw::c_char,
    ) -> SBTargetRef;
    pub fn SBDebuggerCreateTarget2(
        instance: SBDebuggerRef,
        filename: *const ::std::os::raw::c_char,
    ) -> SBTargetRef;
    pub fn SBDebuggerDeleteTarget(instance: SBDebuggerRef, target: SBTargetRef) -> bool;
    pub fn SBDebuggerGetTargetAtIndex(instance: SBDebuggerRef, idx: u32) -> SBTargetRef;
    pub fn SBDebuggerGetIndexOfTarget(instance: SBDebuggerRef, target: SBTargetRef) -> u32;
    pub fn SBDebuggerFindTargetWithProcessID(
        instance: SBDebuggerRef,
        pid: lldb_pid_t,
    ) -> SBTargetRef;
    pub fn SBDebuggerFindTargetWithFileAndArch(
        instance: SBDebuggerRef,
        filename: *const ::std::os::raw::c_char,
        arch: *const ::std::os::raw::c_char,
    ) -> SBTargetRef;
    pub fn SBDebuggerGetNumTargets(instance: SBDebuggerRef) -> u32;
    pub fn SBDebuggerGetSelectedTarget(instance: SBDebuggerRef) -> SBTargetRef;
    pub fn SBDebuggerSetSelectedTarget(instance: SBDebuggerRef, target: SBTargetRef);
    pub fn SBDebuggerGetSelectedPlatform(instance: SBDebuggerRef) -> SBPlatformRef;
    pub fn SBDebuggerSetSelectedPlatform(instance: SBDebuggerRef, platform: SBPlatformRef);
    pub fn SBDebuggerGetNumPlatforms(instance: SBDebuggerRef) -> u32;
    pub fn SBDebuggerGetPlatformAtIndex(instance: SBDebuggerRef, idx: u32) -> SBPlatformRef;
    pub fn SBDebuggerGetNumAvailablePlatforms(instance: SBDebuggerRef) -> u32;
    pub fn SBDebuggerGetAvailablePlatformInfoAtIndex(
        instance: SBDebuggerRef,
        idx: u32,
    ) -> SBStructuredDataRef;
    pub fn SBDebuggerGetSourceManager(instance: SBDebuggerRef) -> SBSourceManagerRef;
    pub fn SBDebuggerSetCurrentPlatform(
        instance: SBDebuggerRef,
        platform_name: *const ::std::os::raw::c_char,
    ) -> SBErrorRef;
    pub fn SBDebuggerSetCurrentPlatformSDKRoot(
        instance: SBDebuggerRef,
        sysroot: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBDebuggerSetUseExternalEditor(instance: SBDebuggerRef, input: bool) -> bool;
    pub fn SBDebuggerGetUseExternalEditor(instance: SBDebuggerRef) -> bool;
    pub fn SBDebuggerSetUseColor(instance: SBDebuggerRef, use_color: bool) -> bool;
    pub fn SBDebuggerGetUseColor(instance: SBDebuggerRef) -> bool;
    pub fn SBDebuggerGetDefaultArchitecture(
        arch_name: *mut ::std::os::raw::c_char,
        arch_name_len: size_t,
    ) -> bool;
    pub fn SBDebuggerSetDefaultArchitecture(arch_name: *const ::std::os::raw::c_char) -> bool;
    pub fn SBDebuggerGetScriptingLanguage(
        instance: SBDebuggerRef,
        script_language_name: *const ::std::os::raw::c_char,
    ) -> ScriptLanguage;
    pub fn SBDebuggerGetVersionString() -> *const ::std::os::raw::c_char;
    pub fn SBDebuggerStateAsCString(state: StateType) -> *const ::std::os::raw::c_char;
    pub fn SBDebuggerStateIsRunningState(state: StateType) -> bool;
    pub fn SBDebuggerStateIsStoppedState(state: StateType) -> bool;
    pub fn SBDebuggerEnableLog(
        instance: SBDebuggerRef,
        channel: *const ::std::os::raw::c_char,
        categories: *const *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBDebuggerDispatchInput(
        instance: SBDebuggerRef,
        baton: *mut ::std::os::raw::c_void,
        data: *const ::std::os::raw::c_void,
        data_len: size_t,
    );
    pub fn SBDebuggerDispatchInput2(
        instance: SBDebuggerRef,
        data: *const ::std::os::raw::c_void,
        data_len: size_t,
    );
    pub fn SBDebuggerDispatchInputInterrupt(instance: SBDebuggerRef);
    pub fn SBDebuggerDispatchInputEndOfFile(instance: SBDebuggerRef);
    pub fn SBDebuggerPushInputReader(instance: SBDebuggerRef, reader: SBInputReaderRef);
    pub fn SBDebuggerGetInstanceName(instance: SBDebuggerRef) -> *const ::std::os::raw::c_char;
    pub fn SBDebuggerFindDebuggerWithID(id: ::std::os::raw::c_int) -> SBDebuggerRef;
    pub fn SBDebuggerSetInternalVariable(
        var_name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        debugger_instance_name: *const ::std::os::raw::c_char,
    ) -> SBErrorRef;
    pub fn SBDebuggerGetInternalVariableValue(
        var_name: *const ::std::os::raw::c_char,
        debugger_instance_name: *const ::std::os::raw::c_char,
    ) -> SBStringListRef;
    pub fn SBDebuggerGetDescription(instance: SBDebuggerRef, description: SBStreamRef) -> bool;
    pub fn SBDebuggerGetTerminalWidth(instance: SBDebuggerRef) -> u32;
    pub fn SBDebuggerSetTerminalWidth(instance: SBDebuggerRef, term_width: u32);
    pub fn SBDebuggerGetID(instance: SBDebuggerRef) -> lldb_user_id_t;
    pub fn SBDebuggerGetPrompt(instance: SBDebuggerRef) -> *const ::std::os::raw::c_char;
    pub fn SBDebuggerSetPrompt(instance: SBDebuggerRef, prompt: *const ::std::os::raw::c_char);
    pub fn SBDebuggerGetScriptLanguage(instance: SBDebuggerRef) -> ScriptLanguage;
    pub fn SBDebuggerSetScriptLanguage(instance: SBDebuggerRef, script_lang: ScriptLanguage);
    pub fn SBDebuggerGetCloseInputOnEOF(instance: SBDebuggerRef) -> bool;
    pub fn SBDebuggerSetCloseInputOnEOF(instance: SBDebuggerRef, b: bool);
    pub fn SBDebuggerGetCategory(
        instance: SBDebuggerRef,
        category_name: *const ::std::os::raw::c_char,
    ) -> SBTypeCategoryRef;
    pub fn SBDebuggerCreateCategory(
        instance: SBDebuggerRef,
        category_name: *const ::std::os::raw::c_char,
    ) -> SBTypeCategoryRef;
    pub fn SBDebuggerDeleteCategory(
        instance: SBDebuggerRef,
        category_name: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBDebuggerGetNumCategories(instance: SBDebuggerRef) -> u32;
    pub fn SBDebuggerGetCategoryAtIndex(instance: SBDebuggerRef, arg1: u32) -> SBTypeCategoryRef;
    pub fn SBDebuggerGetDefaultCategory(instance: SBDebuggerRef) -> SBTypeCategoryRef;
    pub fn SBDebuggerGetFormatForType(
        instance: SBDebuggerRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> SBTypeFormatRef;
    pub fn SBDebuggerGetSummaryForType(
        instance: SBDebuggerRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> SBTypeSummaryRef;
    pub fn SBDebuggerGetFilterForType(
        instance: SBDebuggerRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> SBTypeFilterRef;
    pub fn SBDebuggerGetSyntheticForType(
        instance: SBDebuggerRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> SBTypeSyntheticRef;
    pub fn SBDebuggerRunCommandInterpreter(
        instance: SBDebuggerRef,
        auto_handle_events: bool,
        spawn_thread: bool,
    );
    pub fn SBDebuggerRunCommandInterpreter2(
        instance: SBDebuggerRef,
        auto_handle_events: bool,
        spawn_thread: bool,
        options: SBCommandInterpreterRunOptionsRef,
        num_errors: ::std::os::raw::c_int,
        quit_requested: bool,
        stopped_for_crash: bool,
    );
    pub fn CreateSBDeclaration() -> SBDeclarationRef;
    pub fn CloneSBDeclaration(instance: SBDeclarationRef) -> SBDeclarationRef;
    pub fn DisposeSBDeclaration(instance: SBDeclarationRef);
    pub fn SBDeclarationIsValid(instance: SBDeclarationRef) -> bool;
    pub fn SBDeclarationGetFileSpec(instance: SBDeclarationRef) -> SBFileSpecRef;
    pub fn SBDeclarationGetLine(instance: SBDeclarationRef) -> u32;
    pub fn SBDeclarationGetColumn(instance: SBDeclarationRef) -> u32;
    pub fn SBDeclarationSetFileSpec(instance: SBDeclarationRef, filespec: SBFileSpecRef);
    pub fn SBDeclarationSetLine(instance: SBDeclarationRef, line: u32);
    pub fn SBDeclarationSetColumn(instance: SBDeclarationRef, column: u32);
    pub fn SBDeclarationGetDescription(
        instance: SBDeclarationRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn CreateSBEnvironment() -> SBEnvironmentRef;
    pub fn CloneSBEnvironment(instance: SBEnvironmentRef) -> SBEnvironmentRef;
    pub fn DisposeSBEnvironment(instance: SBEnvironmentRef);
    pub fn SBEnvironmentGet(instance: SBEnvironmentRef) -> *const ::std::os::raw::c_char;
    pub fn SBEnvironmentGetNumValues(instance: SBEnvironmentRef) -> size_t;
    pub fn SBEnvironmentGetNameAtIndex(
        instance: SBEnvironmentRef,
        index: size_t,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBEnvironmentGetValueAtIndex(
        instance: SBEnvironmentRef,
        index: size_t,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBEnvironmentGetEntries(instance: SBEnvironmentRef) -> SBStringListRef;
    pub fn SBEnvironmentPutEntry(
        instance: SBEnvironmentRef,
        name_and_value: *const ::std::os::raw::c_char,
    );
    pub fn SBEnvironmentSetEntries(
        instance: SBEnvironmentRef,
        entries: SBStringListRef,
        append: bool,
    );
    pub fn SBEnvironmentSet(
        instance: SBEnvironmentRef,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        overwrite: bool,
    ) -> bool;
    pub fn SBEnvironmentUnset(
        instance: SBEnvironmentRef,
        name: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBEnvironmentClear(instance: SBEnvironmentRef);
    pub fn CreateSBError() -> SBErrorRef;
    pub fn CloneSBError(instance: SBErrorRef) -> SBErrorRef;
    pub fn DisposeSBError(instance: SBErrorRef);
    pub fn SBErrorGetCString(instance: SBErrorRef) -> *const ::std::os::raw::c_char;
    pub fn SBErrorClear(instance: SBErrorRef);
    pub fn SBErrorFail(instance: SBErrorRef) -> bool;
    pub fn SBErrorSuccess(instance: SBErrorRef) -> bool;
    pub fn SBErrorGetError(instance: SBErrorRef) -> u32;
    pub fn SBErrorGetType(instance: SBErrorRef) -> ErrorType;
    pub fn SBErrorSetError(instance: SBErrorRef, err: u32, type_: ErrorType);
    pub fn SBErrorSetErrorToErrno(instance: SBErrorRef);
    pub fn SBErrorSetErrorToGenericError(instance: SBErrorRef);
    pub fn SBErrorSetErrorString(instance: SBErrorRef, err_str: *const ::std::os::raw::c_char);
    pub fn SBErrorSetErrorStringWithFormat(
        instance: SBErrorRef,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
    pub fn SBErrorIsValid(instance: SBErrorRef) -> bool;
    pub fn SBErrorGetDescription(instance: SBErrorRef, description: SBStreamRef) -> bool;
    pub fn CreateSBEvent() -> SBEventRef;
    pub fn CreateSBEvent2(
        event: u32,
        cstr: *const ::std::os::raw::c_char,
        cstr_len: u32,
    ) -> SBEventRef;
    pub fn CloneSBEvent(instance: SBEventRef) -> SBEventRef;
    pub fn DisposeSBEvent(instance: SBEventRef);
    pub fn SBEventIsValid(instance: SBEventRef) -> bool;
    pub fn SBEventGetDataFlavor(instance: SBEventRef) -> *const ::std::os::raw::c_char;
    pub fn SBEventGetType(instance: SBEventRef) -> u32;
    pub fn SBEventGetBroadcaster(instance: SBEventRef) -> SBBroadcasterRef;
    pub fn SBEventGetBroadcasterClass(instance: SBEventRef) -> *const ::std::os::raw::c_char;
    pub fn SBEventBroadcasterMatchesPtr(
        instance: SBEventRef,
        broadcaster: SBBroadcasterRef,
    ) -> bool;
    pub fn SBEventBroadcasterMatchesRef(
        instance: SBEventRef,
        broadcaster: SBBroadcasterRef,
    ) -> bool;
    pub fn SBEventClear(instance: SBEventRef);
    pub fn SBEventGetCStringFromEvent(event: SBEventRef) -> *const ::std::os::raw::c_char;
    pub fn SBEventGetDescription(instance: SBEventRef, description: SBStreamRef) -> bool;
    pub fn CreateSBExecutionContext() -> SBExecutionContextRef;
    pub fn CreateSBExecutionContext2(target: SBTargetRef) -> SBExecutionContextRef;
    pub fn CreateSBExecutionContext3(process: SBProcessRef) -> SBExecutionContextRef;
    pub fn CreateSBExecutionContext4(thread: SBThreadRef) -> SBExecutionContextRef;
    pub fn CreateSBExecutionContext5(frame: SBFrameRef) -> SBExecutionContextRef;
    pub fn CloneSBExecutionContext(instance: SBExecutionContextRef) -> SBExecutionContextRef;
    pub fn DisposeSBExecutionContext(instance: SBExecutionContextRef);
    pub fn SBExecutionContextGetTarget(instance: SBExecutionContextRef) -> SBTargetRef;
    pub fn SBExecutionContextGetProcess(instance: SBExecutionContextRef) -> SBProcessRef;
    pub fn SBExecutionContextGetThread(instance: SBExecutionContextRef) -> SBThreadRef;
    pub fn SBExecutionContextGetFrame(instance: SBExecutionContextRef) -> SBFrameRef;
    pub fn CreateSBExpressionOptions() -> SBExpressionOptionsRef;
    pub fn CloneSBExpressionOptions(instance: SBExpressionOptionsRef) -> SBExpressionOptionsRef;
    pub fn DisposeSBExpressionOptions(instance: SBExpressionOptionsRef);
    pub fn SBExpressionOptionsGetCoerceResultToId(instance: SBExpressionOptionsRef) -> bool;
    pub fn SBExpressionOptionsSetCoerceResultToId(instance: SBExpressionOptionsRef, coerce: bool);
    pub fn SBExpressionOptionsGetUnwindOnError(instance: SBExpressionOptionsRef) -> bool;
    pub fn SBExpressionOptionsSetUnwindOnError(instance: SBExpressionOptionsRef, unwind: bool);
    pub fn SBExpressionOptionsGetIgnoreBreakpoints(instance: SBExpressionOptionsRef) -> bool;
    pub fn SBExpressionOptionsSetIgnoreBreakpoints(instance: SBExpressionOptionsRef, ignore: bool);
    pub fn SBExpressionOptionsGetFetchDynamicValue(
        instance: SBExpressionOptionsRef,
    ) -> DynamicValueType;
    pub fn SBExpressionOptionsSetFetchDynamicValue(
        instance: SBExpressionOptionsRef,
        dynamic: DynamicValueType,
    );
    pub fn SBExpressionOptionsGetTimeoutInMicroSeconds(instance: SBExpressionOptionsRef) -> u32;
    pub fn SBExpressionOptionsSetTimeoutInMicroSeconds(
        instance: SBExpressionOptionsRef,
        timeout: u32,
    );
    pub fn SBExpressionOptionsGetOneThreadTimeoutInMicroSeconds(
        instance: SBExpressionOptionsRef,
    ) -> u32;
    pub fn SBExpressionOptionsSetOneThreadTimeoutInMicroSeconds(
        instance: SBExpressionOptionsRef,
        timeout: u32,
    );
    pub fn SBExpressionOptionsGetTryAllThreads(instance: SBExpressionOptionsRef) -> bool;
    pub fn SBExpressionOptionsSetTryAllThreads(instance: SBExpressionOptionsRef, run_others: bool);
    pub fn SBExpressionOptionsGetStopOthers(instance: SBExpressionOptionsRef) -> bool;
    pub fn SBExpressionOptionsSetStopOthers(instance: SBExpressionOptionsRef, stop_others: bool);
    pub fn SBExpressionOptionsGetTrapExceptions(instance: SBExpressionOptionsRef) -> bool;
    pub fn SBExpressionOptionsSetTrapExceptions(
        instance: SBExpressionOptionsRef,
        trap_exceptions: bool,
    );
    pub fn SBExpressionOptionsSetLanguage(instance: SBExpressionOptionsRef, language: LanguageType);
    pub fn SBExpressionOptionsGetGenerateDebugInfo(instance: SBExpressionOptionsRef) -> bool;
    pub fn SBExpressionOptionsSetGenerateDebugInfo(instance: SBExpressionOptionsRef, b: bool);
    pub fn SBExpressionOptionsGetSuppressPersistentResult(instance: SBExpressionOptionsRef)
        -> bool;
    pub fn SBExpressionOptionsSetSuppressPersistentResult(
        instance: SBExpressionOptionsRef,
        b: bool,
    );
    pub fn SBExpressionOptionsGetPrefix(
        instance: SBExpressionOptionsRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBExpressionOptionsSetPrefix(
        instance: SBExpressionOptionsRef,
        prefix: *const ::std::os::raw::c_char,
    );
    pub fn SBExpressionOptionsSetAutoApplyFixIts(instance: SBExpressionOptionsRef, b: bool);
    pub fn SBExpressionOptionsGetAutoApplyFixIts(instance: SBExpressionOptionsRef) -> bool;
    pub fn SBExpressionOptionsGetRetriesWithFixIts(instance: SBExpressionOptionsRef) -> u64;
    pub fn SBExpressionOptionsSetRetriesWithFixIts(instance: SBExpressionOptionsRef, retries: u64);
    pub fn SBExpressionOptionsGetTopLevel(instance: SBExpressionOptionsRef) -> bool;
    pub fn SBExpressionOptionsSetTopLevel(instance: SBExpressionOptionsRef, b: bool);
    pub fn SBExpressionOptionsGetAllowJIT(instance: SBExpressionOptionsRef) -> bool;
    pub fn SBExpressionOptionsSetAllowJIT(instance: SBExpressionOptionsRef, b: bool);
    pub fn CreateSBFileSpec() -> SBFileSpecRef;
    pub fn CreateSBFileSpec2(path: *const ::std::os::raw::c_char) -> SBFileSpecRef;
    pub fn CreateSBFileSpec3(path: *const ::std::os::raw::c_char, resolve: bool) -> SBFileSpecRef;
    pub fn CloneSBFileSpec(instance: SBFileSpecRef) -> SBFileSpecRef;
    pub fn DisposeSBFileSpec(instance: SBFileSpecRef);
    pub fn SBFileSpecIsValid(instance: SBFileSpecRef) -> bool;
    pub fn SBFileSpecExists(instance: SBFileSpecRef) -> bool;
    pub fn SBFileSpecResolveExecutableLocation(instance: SBFileSpecRef) -> bool;
    pub fn SBFileSpecGetFilename(instance: SBFileSpecRef) -> *const ::std::os::raw::c_char;
    pub fn SBFileSpecGetDirectory(instance: SBFileSpecRef) -> *const ::std::os::raw::c_char;
    pub fn SBFileSpecSetFilename(instance: SBFileSpecRef, filename: *const ::std::os::raw::c_char);
    pub fn SBFileSpecSetDirectory(
        instance: SBFileSpecRef,
        directory: *const ::std::os::raw::c_char,
    );
    pub fn SBFileSpecGetPath(
        instance: SBFileSpecRef,
        dst_path: *mut ::std::os::raw::c_char,
        dst_len: size_t,
    ) -> u32;
    pub fn SBFileSpecResolvePath(
        src_path: *const ::std::os::raw::c_char,
        dst_path: *mut ::std::os::raw::c_char,
        dst_len: size_t,
    ) -> ::std::os::raw::c_int;
    pub fn SBFileSpecGetDescription(instance: SBFileSpecRef, description: SBStreamRef) -> bool;
    pub fn SBFileSpecAppendPathComponent(
        instance: SBFileSpecRef,
        file_or_directory: *const ::std::os::raw::c_char,
    );
    pub fn CreateSBFileSpecList() -> SBFileSpecListRef;
    pub fn CloneSBFileSpecList(instance: SBFileSpecListRef) -> SBFileSpecListRef;
    pub fn DisposeSBFileSpecList(instance: SBFileSpecListRef);
    pub fn SBFileSpecListGetSize(instance: SBFileSpecListRef) -> u32;
    pub fn SBFileSpecListGetDescription(
        instance: SBFileSpecListRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn SBFileSpecListAppend(instance: SBFileSpecListRef, sb_file: SBFileSpecRef);
    pub fn SBFileSpecListAppendIfUnique(
        instance: SBFileSpecListRef,
        sb_file: SBFileSpecRef,
    ) -> bool;
    pub fn SBFileSpecListClear(instance: SBFileSpecListRef);
    pub fn SBFileSpecListFindFileIndex(
        instance: SBFileSpecListRef,
        idx: u32,
        sb_file: SBFileSpecRef,
        full: bool,
    ) -> u32;
    pub fn SBFileSpecListGetFileSpecAtIndex(instance: SBFileSpecListRef, idx: u32)
        -> SBFileSpecRef;
    pub fn CreateSBFrame() -> SBFrameRef;
    pub fn CloneSBFrame(instance: SBFrameRef) -> SBFrameRef;
    pub fn DisposeSBFrame(instance: SBFrameRef);
    pub fn SBFrameIsEqual(instance: SBFrameRef, that: SBFrameRef) -> bool;
    pub fn SBFrameIsValid(instance: SBFrameRef) -> bool;
    pub fn SBFrameGetFrameID(instance: SBFrameRef) -> u32;
    pub fn SBFrameGetCFA(instance: SBFrameRef) -> lldb_addr_t;
    pub fn SBFrameGetPC(instance: SBFrameRef) -> lldb_addr_t;
    pub fn SBFrameSetPC(instance: SBFrameRef, new_pc: lldb_addr_t) -> bool;
    pub fn SBFrameGetSP(instance: SBFrameRef) -> lldb_addr_t;
    pub fn SBFrameGetFP(instance: SBFrameRef) -> lldb_addr_t;
    pub fn SBFrameGetPCAddress(instance: SBFrameRef) -> SBAddressRef;
    pub fn SBFrameGetSymbolContext(instance: SBFrameRef, resolve_scope: u32) -> SBSymbolContextRef;
    pub fn SBFrameGetModule(instance: SBFrameRef) -> SBModuleRef;
    pub fn SBFrameGetCompileUnit(instance: SBFrameRef) -> SBCompileUnitRef;
    pub fn SBFrameGetFunction(instance: SBFrameRef) -> SBFunctionRef;
    pub fn SBFrameGetSymbol(instance: SBFrameRef) -> SBSymbolRef;
    pub fn SBFrameGetBlock(instance: SBFrameRef) -> SBBlockRef;
    pub fn SBFrameGetFunctionName(instance: SBFrameRef) -> *const ::std::os::raw::c_char;
    pub fn SBFrameGetDisplayFunctionName(instance: SBFrameRef) -> *const ::std::os::raw::c_char;
    pub fn SBFrameGuessLanguage(instance: SBFrameRef) -> LanguageType;
    pub fn SBFrameIsInlined(instance: SBFrameRef) -> bool;
    pub fn SBFrameIsArtificial(instance: SBFrameRef) -> bool;
    pub fn SBFrameEvaluateExpression(
        instance: SBFrameRef,
        expr: *const ::std::os::raw::c_char,
        options: SBExpressionOptionsRef,
    ) -> SBValueRef;
    pub fn SBFrameGetFrameBlock(instance: SBFrameRef) -> SBBlockRef;
    pub fn SBFrameGetLineEntry(instance: SBFrameRef) -> SBLineEntryRef;
    pub fn SBFrameGetThread(instance: SBFrameRef) -> SBThreadRef;
    pub fn SBFrameDisassemble(instance: SBFrameRef) -> *const ::std::os::raw::c_char;
    pub fn SBFrameClear(instance: SBFrameRef);
    pub fn SBFrameGetVariables(
        instance: SBFrameRef,
        options: SBVariablesOptionsRef,
    ) -> SBValueListRef;
    pub fn SBFrameGetRegisters(instance: SBFrameRef) -> SBValueListRef;
    pub fn SBFrameFindRegister(
        instance: SBFrameRef,
        name: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBFrameFindVariable(
        instance: SBFrameRef,
        var_name: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBFrameFindVariable2(
        instance: SBFrameRef,
        var_name: *const ::std::os::raw::c_char,
        use_dynamic: DynamicValueType,
    ) -> SBValueRef;
    pub fn SBFrameGetValueForVariablePath(
        instance: SBFrameRef,
        var_expr_cstr: *const ::std::os::raw::c_char,
        use_dynamic: DynamicValueType,
    ) -> SBValueRef;
    pub fn SBFrameGetValueForVariablePath2(
        instance: SBFrameRef,
        var_path: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBFrameFindValue(
        instance: SBFrameRef,
        name: *const ::std::os::raw::c_char,
        value_type: ValueType,
    ) -> SBValueRef;
    pub fn SBFrameFindValue2(
        instance: SBFrameRef,
        name: *const ::std::os::raw::c_char,
        value_type: ValueType,
        use_dynamic: DynamicValueType,
    ) -> SBValueRef;
    pub fn SBFrameGetDescription(instance: SBFrameRef, description: SBStreamRef) -> bool;
    pub fn CreateSBFunction() -> SBFunctionRef;
    pub fn CloneSBFunction(instance: SBFunctionRef) -> SBFunctionRef;
    pub fn DisposeSBFunction(instance: SBFunctionRef);
    pub fn SBFunctionIsValid(instance: SBFunctionRef) -> bool;
    pub fn SBFunctionGetName(instance: SBFunctionRef) -> *const ::std::os::raw::c_char;
    pub fn SBFunctionGetDisplayName(instance: SBFunctionRef) -> *const ::std::os::raw::c_char;
    pub fn SBFunctionGetMangledName(instance: SBFunctionRef) -> *const ::std::os::raw::c_char;
    pub fn SBFunctionGetInstructions(
        instance: SBFunctionRef,
        target: SBTargetRef,
    ) -> SBInstructionListRef;
    pub fn SBFunctionGetInstructions2(
        instance: SBFunctionRef,
        target: SBTargetRef,
        flavor: *const ::std::os::raw::c_char,
    ) -> SBInstructionListRef;
    pub fn SBFunctionGetStartAddress(instance: SBFunctionRef) -> SBAddressRef;
    pub fn SBFunctionGetEndAddress(instance: SBFunctionRef) -> SBAddressRef;
    pub fn SBFunctionGetPrologueByteSize(instance: SBFunctionRef) -> u32;
    pub fn SBFunctionGetType(instance: SBFunctionRef) -> SBTypeRef;
    pub fn SBFunctionGetBlock(instance: SBFunctionRef) -> SBBlockRef;
    pub fn SBFunctionGetLanguage(instance: SBFunctionRef) -> LanguageType;
    pub fn SBFunctionGetIsOptimized(instance: SBFunctionRef) -> bool;
    pub fn SBFunctionGetDescription(instance: SBFunctionRef, description: SBStreamRef) -> bool;
    pub fn SBHostOSGetProgramFileSpec() -> SBFileSpecRef;
    pub fn SBHostOSGetLLDBPythonPath() -> SBFileSpecRef;
    pub fn SBHostOSGetLLDBPath(path_type: PathType) -> SBFileSpecRef;
    pub fn SBHostOSGetUserHomeDirectory() -> SBFileSpecRef;
    pub fn CreateSBInstruction() -> SBInstructionRef;
    pub fn CloneSBInstruction(instance: SBInstructionRef) -> SBInstructionRef;
    pub fn DisposeSBInstruction(instance: SBInstructionRef);
    pub fn SBInstructionIsValid(instance: SBInstructionRef) -> bool;
    pub fn SBInstructionGetAddress(instance: SBInstructionRef) -> SBAddressRef;
    pub fn SBInstructionGetMnemonic(
        instance: SBInstructionRef,
        target: SBTargetRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBInstructionGetOperands(
        instance: SBInstructionRef,
        target: SBTargetRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBInstructionGetComment(
        instance: SBInstructionRef,
        target: SBTargetRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBInstructionGetData(instance: SBInstructionRef, target: SBTargetRef) -> SBDataRef;
    pub fn SBInstructionGetByteSize(instance: SBInstructionRef) -> size_t;
    pub fn SBInstructionDoesBranch(instance: SBInstructionRef) -> bool;
    pub fn SBInstructionHasDelaySlot(instance: SBInstructionRef) -> bool;
    pub fn SBInstructionPrint(instance: SBInstructionRef, out: *mut FILE);
    pub fn SBInstructionGetDescription(
        instance: SBInstructionRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn SBInstructionEmulateWithFrame(
        instance: SBInstructionRef,
        frame: SBFrameRef,
        evaluate_options: u32,
    ) -> bool;
    pub fn SBInstructionDumpEmulation(
        instance: SBInstructionRef,
        triple: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBInstructionTestEmulation(
        instance: SBInstructionRef,
        output_stream: SBStreamRef,
        test_file: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn CreateSBInstructionList() -> SBInstructionListRef;
    pub fn CloneSBInstructionList(instance: SBInstructionListRef) -> SBInstructionListRef;
    pub fn DisposeSBInstructionList(instance: SBInstructionListRef);
    pub fn SBInstructionListIsValid(instance: SBInstructionListRef) -> bool;
    pub fn SBInstructionListGetSize(instance: SBInstructionListRef) -> size_t;
    pub fn SBInstructionListGetInstructionAtIndex(
        instance: SBInstructionListRef,
        idx: u32,
    ) -> SBInstructionRef;
    pub fn SBInstructionListClear(instance: SBInstructionListRef);
    pub fn SBInstructionListAppendInstruction(
        instance: SBInstructionListRef,
        inst: SBInstructionRef,
    );
    pub fn SBInstructionListPrint(instance: SBInstructionListRef, out: *mut FILE);
    pub fn SBInstructionListGetDescription(
        instance: SBInstructionListRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn SBInstructionListDumpEmulationForAllInstructions(
        instance: SBInstructionListRef,
        triple: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBLanguageRuntimeGetLanguageTypeFromString(
        string: *const ::std::os::raw::c_char,
    ) -> LanguageType;
    pub fn SBLanguageRuntimeGetNameForLanguageType(
        language: LanguageType,
    ) -> *const ::std::os::raw::c_char;
    pub fn CreateSBLaunchInfo(argv: *const *const ::std::os::raw::c_char) -> SBLaunchInfoRef;
    pub fn CloneSBLaunchInfo(instance: SBLaunchInfoRef) -> SBLaunchInfoRef;
    pub fn DisposeSBLaunchInfo(instance: SBLaunchInfoRef);
    pub fn SBLaunchInfoGetProcessID(instance: SBLaunchInfoRef) -> lldb_pid_t;
    pub fn SBLaunchInfoGetUserID(instance: SBLaunchInfoRef) -> u32;
    pub fn SBLaunchInfoGetGroupID(instance: SBLaunchInfoRef) -> u32;
    pub fn SBLaunchInfoUserIDIsValid(instance: SBLaunchInfoRef) -> bool;
    pub fn SBLaunchInfoGroupIDIsValid(instance: SBLaunchInfoRef) -> bool;
    pub fn SBLaunchInfoSetUserID(instance: SBLaunchInfoRef, uid: u32);
    pub fn SBLaunchInfoSetGroupID(instance: SBLaunchInfoRef, gid: u32);
    pub fn SBLaunchInfoGetExecutableFile(instance: SBLaunchInfoRef) -> SBFileSpecRef;
    pub fn SBLaunchInfoSetExecutableFile(
        instance: SBLaunchInfoRef,
        exe_file: SBFileSpecRef,
        add_as_first_arg: bool,
    );
    pub fn SBLaunchInfoGetListener(instance: SBLaunchInfoRef) -> SBListenerRef;
    pub fn SBLaunchInfoSetListener(instance: SBLaunchInfoRef, listener: SBListenerRef);
    pub fn SBLaunchInfoGetNumArguments(instance: SBLaunchInfoRef) -> u32;
    pub fn SBLaunchInfoGetArgumentAtIndex(
        instance: SBLaunchInfoRef,
        idx: u32,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBLaunchInfoSetArguments(
        instance: SBLaunchInfoRef,
        argv: *const *const ::std::os::raw::c_char,
        append: bool,
    );
    pub fn SBLaunchInfoGetNumEnvironmentEntries(instance: SBLaunchInfoRef) -> u32;
    pub fn SBLaunchInfoGetEnvironmentEntryAtIndex(
        instance: SBLaunchInfoRef,
        idx: u32,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBLaunchInfoSetEnvironmentEntries(
        instance: SBLaunchInfoRef,
        envp: *const *const ::std::os::raw::c_char,
        append: bool,
    );
    pub fn SBLaunchInfoSetEvironment(
        instance: SBLaunchInfoRef,
        environment: SBEnvironmentRef,
        append: bool,
    );
    pub fn SBLaunchInfoGetEnvironment(instance: SBLaunchInfoRef) -> SBEnvironmentRef;
    pub fn SBLaunchInfoClear(instance: SBLaunchInfoRef);
    pub fn SBLaunchInfoGetWorkingDirectory(
        instance: SBLaunchInfoRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBLaunchInfoSetWorkingDirectory(
        instance: SBLaunchInfoRef,
        working_dir: *const ::std::os::raw::c_char,
    );
    pub fn SBLaunchInfoGetLaunchFlags(instance: SBLaunchInfoRef) -> u32;
    pub fn SBLaunchInfoSetLaunchFlags(instance: SBLaunchInfoRef, flags: u32);
    pub fn SBLaunchInfoGetProcessPluginName(
        instance: SBLaunchInfoRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBLaunchInfoSetProcessPluginName(
        instance: SBLaunchInfoRef,
        plugin_name: *const ::std::os::raw::c_char,
    );
    pub fn SBLaunchInfoGetShell(instance: SBLaunchInfoRef) -> *const ::std::os::raw::c_char;
    pub fn SBLaunchInfoSetShell(instance: SBLaunchInfoRef, path: *const ::std::os::raw::c_char);
    pub fn SBLaunchInfoGetShellExpandArguments(instance: SBLaunchInfoRef) -> bool;
    pub fn SBLaunchInfoSetShellExpandArguments(instance: SBLaunchInfoRef, glob: bool);
    pub fn SBLaunchInfoGetResumeCount(instance: SBLaunchInfoRef) -> u32;
    pub fn SBLaunchInfoSetResumeCount(instance: SBLaunchInfoRef, c: u32);
    pub fn SBLaunchInfoAddCloseFileAction(
        instance: SBLaunchInfoRef,
        fd: ::std::os::raw::c_int,
    ) -> bool;
    pub fn SBLaunchInfoAddDuplicateFileAction(
        instance: SBLaunchInfoRef,
        fd: ::std::os::raw::c_int,
        dup_fd: ::std::os::raw::c_int,
    ) -> bool;
    pub fn SBLaunchInfoAddOpenFileAction(
        instance: SBLaunchInfoRef,
        fd: ::std::os::raw::c_int,
        path: *const ::std::os::raw::c_char,
        read: bool,
        write: bool,
    ) -> bool;
    pub fn SBLaunchInfoAddSuppressFileAction(
        instance: SBLaunchInfoRef,
        fd: ::std::os::raw::c_int,
        read: bool,
        write: bool,
    ) -> bool;
    pub fn SBLaunchInfoSetLaunchEventData(
        instance: SBLaunchInfoRef,
        data: *const ::std::os::raw::c_char,
    );
    pub fn SBLaunchInfoGetLaunchEventData(
        instance: SBLaunchInfoRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBLaunchInfoGetDetachOnError(instance: SBLaunchInfoRef) -> bool;
    pub fn SBLaunchInfoSetDetachOnError(instance: SBLaunchInfoRef, enable: bool);
    pub fn CreateSBLineEntry() -> SBLineEntryRef;
    pub fn CloneSBLineEntry(instance: SBLineEntryRef) -> SBLineEntryRef;
    pub fn DisposeSBLineEntry(instance: SBLineEntryRef);
    pub fn SBLineEntryGetStartAddress(instance: SBLineEntryRef) -> SBAddressRef;
    pub fn SBLineEntryGetEndAddress(instance: SBLineEntryRef) -> SBAddressRef;
    pub fn SBLineEntryIsValid(instance: SBLineEntryRef) -> bool;
    pub fn SBLineEntryGetFileSpec(instance: SBLineEntryRef) -> SBFileSpecRef;
    pub fn SBLineEntryGetLine(instance: SBLineEntryRef) -> u32;
    pub fn SBLineEntryGetColumn(instance: SBLineEntryRef) -> u32;
    pub fn SBLineEntrySetFileSpec(instance: SBLineEntryRef, filespec: SBFileSpecRef);
    pub fn SBLineEntrySetLine(instance: SBLineEntryRef, line: u32);
    pub fn SBLineEntrySetColumn(instance: SBLineEntryRef, column: u32);
    pub fn SBLineEntryGetDescription(instance: SBLineEntryRef, description: SBStreamRef) -> bool;
    pub fn CreateSBListener() -> SBListenerRef;
    pub fn CreateSBListener2(name: *const ::std::os::raw::c_char) -> SBListenerRef;
    pub fn CloneSBListener(instance: SBListenerRef) -> SBListenerRef;
    pub fn DisposeSBListener(instance: SBListenerRef);
    pub fn SBListenerAddEvent(instance: SBListenerRef, event: SBEventRef);
    pub fn SBListenerClear(instance: SBListenerRef);
    pub fn SBListenerIsValid(instance: SBListenerRef) -> bool;
    pub fn SBListenerStartListeningForEventClass(
        instance: SBListenerRef,
        debugger: SBDebuggerRef,
        broadcaster_class: *const ::std::os::raw::c_char,
        event_mask: u32,
    ) -> u32;
    pub fn SBListenerStopListeningForEventClass(
        instance: SBListenerRef,
        debugger: SBDebuggerRef,
        broadcaster_class: *const ::std::os::raw::c_char,
        event_mask: u32,
    ) -> bool;
    pub fn SBListenerStartListeningForEvents(
        instance: SBListenerRef,
        broadcaster: SBBroadcasterRef,
        event_mask: u32,
    ) -> u32;
    pub fn SBListenerStopListeningForEvents(
        instance: SBListenerRef,
        broadcaster: SBBroadcasterRef,
        event_mask: u32,
    ) -> bool;
    pub fn SBListenerWaitForEvent(
        instance: SBListenerRef,
        num_seconds: u32,
        event: SBEventRef,
    ) -> bool;
    pub fn SBListenerWaitForEventForBroadcaster(
        instance: SBListenerRef,
        num_seconds: u32,
        broadcaster: SBBroadcasterRef,
        sb_event: SBEventRef,
    ) -> bool;
    pub fn SBListenerWaitForEventForBroadcasterWithType(
        instance: SBListenerRef,
        num_seconds: u32,
        broadcaster: SBBroadcasterRef,
        event_type_mask: u32,
        sb_event: SBEventRef,
    ) -> bool;
    pub fn SBListenerPeekAtNextEvent(instance: SBListenerRef, sb_event: SBEventRef) -> bool;
    pub fn SBListenerPeekAtNextEventForBroadcaster(
        instance: SBListenerRef,
        broadcaster: SBBroadcasterRef,
        sb_event: SBEventRef,
    ) -> bool;
    pub fn SBListenerPeekAtNextEventForBroadcasterWithType(
        instance: SBListenerRef,
        broadcaster: SBBroadcasterRef,
        event_type_mask: u32,
        sb_event: SBEventRef,
    ) -> bool;
    pub fn SBListenerGetNextEvent(instance: SBListenerRef, sb_event: SBEventRef) -> bool;
    pub fn SBListenerGetNextEventForBroadcaster(
        instance: SBListenerRef,
        broadcaster: SBBroadcasterRef,
        sb_event: SBEventRef,
    ) -> bool;
    pub fn SBListenerGetNextEventForBroadcasterWithType(
        instance: SBListenerRef,
        broadcaster: SBBroadcasterRef,
        event_type_mask: u32,
        sb_event: SBEventRef,
    ) -> bool;
    pub fn SBListenerHandleBroadcastEvent(instance: SBListenerRef, event: SBEventRef) -> bool;
    pub fn CreateSBMemoryRegionInfo() -> SBMemoryRegionInfoRef;
    pub fn CloneSBMemoryRegionInfo(instance: SBMemoryRegionInfoRef) -> SBMemoryRegionInfoRef;
    pub fn DisposeSBMemoryRegionInfo(instance: SBMemoryRegionInfoRef);
    pub fn SBMemoryRegionInfoClear(instance: SBMemoryRegionInfoRef);
    pub fn SBMemoryRegionInfoGetRegionBase(instance: SBMemoryRegionInfoRef) -> lldb_addr_t;
    pub fn SBMemoryRegionInfoGetRegionEnd(instance: SBMemoryRegionInfoRef) -> lldb_addr_t;
    pub fn SBMemoryRegionInfoIsReadable(instance: SBMemoryRegionInfoRef) -> bool;
    pub fn SBMemoryRegionInfoIsWritable(instance: SBMemoryRegionInfoRef) -> bool;
    pub fn SBMemoryRegionInfoIsExecutable(instance: SBMemoryRegionInfoRef) -> bool;
    pub fn SBMemoryRegionInfoIsMapped(instance: SBMemoryRegionInfoRef) -> bool;
    pub fn SBMemoryRegionInfoGetName(
        instance: SBMemoryRegionInfoRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBMemoryRegionInfoGetDescription(
        instance: SBMemoryRegionInfoRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn CreateSBMemoryRegionInfoList() -> SBMemoryRegionInfoListRef;
    pub fn CloneSBMemoryRegionInfoList(
        instance: SBMemoryRegionInfoListRef,
    ) -> SBMemoryRegionInfoListRef;
    pub fn DisposeSBMemoryRegionInfoList(instance: SBMemoryRegionInfoListRef);
    pub fn SBMemoryRegionInfoListGetSize(instance: SBMemoryRegionInfoListRef) -> u32;
    pub fn SBMemoryRegionInfoListGetMemoryRegionAtIndex(
        instance: SBMemoryRegionInfoListRef,
        idx: u32,
        region: SBMemoryRegionInfoRef,
    ) -> bool;
    pub fn SBMemoryRegionInfoListAppend(
        instance: SBMemoryRegionInfoListRef,
        region: SBMemoryRegionInfoRef,
    );
    pub fn SBMemoryRegionInfoListAppendList(
        instance: SBMemoryRegionInfoListRef,
        region_list: SBMemoryRegionInfoListRef,
    );
    pub fn SBMemoryRegionInfoListClear(instance: SBMemoryRegionInfoListRef);
    pub fn CreateSBModule() -> SBModuleRef;
    pub fn CreateSBModule2(module_spec: SBModuleSpecRef) -> SBModuleRef;
    pub fn CreateSBModule3(process: SBProcessRef, header_addr: lldb_addr_t) -> SBModuleRef;
    pub fn CloneSBModule(instance: SBModuleRef) -> SBModuleRef;
    pub fn DisposeSBModule(instance: SBModuleRef);
    pub fn SBModuleIsValid(instance: SBModuleRef) -> bool;
    pub fn SBModuleClear(instance: SBModuleRef);
    pub fn SBModuleGetFileSpec(instance: SBModuleRef) -> SBFileSpecRef;
    pub fn SBModuleGetPlatformFileSpec(instance: SBModuleRef) -> SBFileSpecRef;
    pub fn SBModuleSetPlatformFileSpec(instance: SBModuleRef, platform_file: SBFileSpecRef)
        -> bool;
    pub fn SBModuleGetRemoteInstallFileSpec(instance: SBModuleRef) -> SBFileSpecRef;
    pub fn SBModuleSetRemoteInstallFileSpec(instance: SBModuleRef, file: SBFileSpecRef) -> bool;
    pub fn SBModuleGetByteOrder(instance: SBModuleRef) -> ByteOrder;
    pub fn SBModuleGetAddressByteSize(instance: SBModuleRef) -> u32;
    pub fn SBModuleGetTriple(instance: SBModuleRef) -> *const ::std::os::raw::c_char;
    pub fn SBModuleGetUUIDBytes(instance: SBModuleRef) -> *const u8;
    pub fn SBModuleGetUUIDString(instance: SBModuleRef) -> *const ::std::os::raw::c_char;
    pub fn SBModuleFindSection(
        instance: SBModuleRef,
        sect_name: *const ::std::os::raw::c_char,
    ) -> SBSectionRef;
    pub fn SBModuleResolveFileAddress(instance: SBModuleRef, vm_addr: lldb_addr_t) -> SBAddressRef;
    pub fn SBModuleResolveSymbolContextForAddress(
        instance: SBModuleRef,
        addr: SBAddressRef,
        resolve_scope: u32,
    ) -> SBSymbolContextRef;
    pub fn SBModuleGetDescription(instance: SBModuleRef, description: SBStreamRef) -> bool;
    pub fn SBModuleGetNumCompileUnits(instance: SBModuleRef) -> u32;
    pub fn SBModuleGetCompileUnitAtIndex(instance: SBModuleRef, arg1: u32) -> SBCompileUnitRef;
    pub fn SBModuleGetNumSymbols(instance: SBModuleRef) -> size_t;
    pub fn SBModuleGetSymbolAtIndex(instance: SBModuleRef, idx: size_t) -> SBSymbolRef;
    pub fn SBModuleFindSymbol(
        instance: SBModuleRef,
        name: *const ::std::os::raw::c_char,
        type_: SymbolType,
    ) -> SBSymbolRef;
    pub fn SBModuleFindSymbols(
        instance: SBModuleRef,
        name: *const ::std::os::raw::c_char,
        type_: SymbolType,
    ) -> SBSymbolContextListRef;
    pub fn SBModuleGetNumSections(instance: SBModuleRef) -> size_t;
    pub fn SBModuleGetSectionAtIndex(instance: SBModuleRef, idx: size_t) -> SBSectionRef;
    pub fn SBModuleFindFunctions(
        instance: SBModuleRef,
        name: *const ::std::os::raw::c_char,
        name_type_mask: u32,
    ) -> SBSymbolContextListRef;
    pub fn SBModuleFindGlobalVariables(
        instance: SBModuleRef,
        target: SBTargetRef,
        name: *const ::std::os::raw::c_char,
        max_matches: u32,
    ) -> SBValueListRef;
    pub fn SBModuleFindFirstGlobalVariable(
        instance: SBModuleRef,
        target: SBTargetRef,
        name: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBModuleFindFirstType(
        instance: SBModuleRef,
        name: *const ::std::os::raw::c_char,
    ) -> SBTypeRef;
    pub fn SBModuleFindTypes(
        instance: SBModuleRef,
        type_: *const ::std::os::raw::c_char,
    ) -> SBTypeListRef;
    pub fn SBModuleGetTypeByID(instance: SBModuleRef, uid: lldb_user_id_t) -> SBTypeRef;
    pub fn SBModuleGetBasicType(instance: SBModuleRef, type_: BasicType) -> SBTypeRef;
    pub fn SBModuleGetTypes(instance: SBModuleRef, type_mask: u32) -> SBTypeListRef;
    pub fn SBModuleGetVersion(instance: SBModuleRef, versions: *mut u32, num_versions: u32) -> u32;
    pub fn SBModuleGetSymbolFileSpec(instance: SBModuleRef) -> SBFileSpecRef;
    pub fn SBModuleGetObjectFileHeaderAddress(instance: SBModuleRef) -> SBAddressRef;
    pub fn SBModuleGetObjectFileEntryPointAddress(instance: SBModuleRef) -> SBAddressRef;
    pub fn CreateSBModuleSpec() -> SBModuleSpecRef;
    pub fn CloneSBModuleSpec(instance: SBModuleSpecRef) -> SBModuleSpecRef;
    pub fn DisposeSBModuleSpec(instance: SBModuleSpecRef);
    pub fn SBModuleSpecIsValid(instance: SBModuleSpecRef) -> bool;
    pub fn SBModuleSpecClear(instance: SBModuleSpecRef);
    pub fn SBModuleSpecGetFileSpec(instance: SBModuleSpecRef) -> SBFileSpecRef;
    pub fn SBModuleSpecSetFileSpec(instance: SBModuleSpecRef, fspec: SBFileSpecRef);
    pub fn SBModuleSpecGetPlatformFileSpec(instance: SBModuleSpecRef) -> SBFileSpecRef;
    pub fn SBModuleSpecSetPlatformFileSpec(instance: SBModuleSpecRef, fspec: SBFileSpecRef);
    pub fn SBModuleSpecGetSymbolFileSpec(instance: SBModuleSpecRef) -> SBFileSpecRef;
    pub fn SBModuleSpecSetSymbolFileSpec(instance: SBModuleSpecRef, fspec: SBFileSpecRef);
    pub fn SBModuleSpecGetObjectName(instance: SBModuleSpecRef) -> *const ::std::os::raw::c_char;
    pub fn SBModuleSpecSetObjectName(
        instance: SBModuleSpecRef,
        name: *const ::std::os::raw::c_char,
    );
    pub fn SBModuleSpecGetTriple(instance: SBModuleSpecRef) -> *const ::std::os::raw::c_char;
    pub fn SBModuleSpecSetTriple(instance: SBModuleSpecRef, triple: *const ::std::os::raw::c_char);
    pub fn SBModuleSpecGetUUIDBytes(instance: SBModuleSpecRef) -> *const u8;
    pub fn SBModuleSpecGetUUIDLength(instance: SBModuleSpecRef) -> size_t;
    pub fn SBModuleSpecSetUUIDBytes(
        instance: SBModuleSpecRef,
        uuid: *const u8,
        uuid_len: size_t,
    ) -> bool;
    pub fn SBModuleSpecGetDescription(instance: SBModuleSpecRef, description: SBStreamRef) -> bool;
    pub fn CreateSBModuleSpecList() -> SBModuleSpecListRef;
    pub fn CloneSBModuleSpecList(instance: SBModuleSpecListRef) -> SBModuleSpecListRef;
    pub fn DisposeSBModuleSpecList(instance: SBModuleSpecListRef);
    pub fn SBModuleSpecListGetModuleSpecifications(
        path: *const ::std::os::raw::c_char,
    ) -> SBModuleSpecListRef;
    pub fn SBModuleSpecListAppend(instance: SBModuleSpecListRef, spec: SBModuleSpecRef);
    pub fn SBModuleSpecListAppendList(
        instance: SBModuleSpecListRef,
        spec_list: SBModuleSpecListRef,
    );
    pub fn SBModuleSpecListFindFirstMatchingSpec(
        instance: SBModuleSpecListRef,
        match_spec: SBModuleSpecRef,
    ) -> SBModuleSpecRef;
    pub fn SBModuleSpecListFindMatchingSpecs(
        instance: SBModuleSpecListRef,
        match_spec: SBModuleSpecRef,
    ) -> SBModuleSpecListRef;
    pub fn SBModuleSpecListGetSize(instance: SBModuleSpecListRef) -> size_t;
    pub fn SBModuleSpecListGetSpecAtIndex(
        instance: SBModuleSpecListRef,
        i: size_t,
    ) -> SBModuleSpecRef;
    pub fn SBModuleSpecListGetDescription(
        instance: SBModuleSpecListRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn CreateSBPlatformConnectOptions(
        url: *const ::std::os::raw::c_char,
    ) -> SBPlatformConnectOptionsRef;
    pub fn CloneSBPlatformConnectOptions(
        instance: SBPlatformConnectOptionsRef,
    ) -> SBPlatformConnectOptionsRef;
    pub fn DisposeSBPlatformConnectOptions(instance: SBPlatformConnectOptionsRef);
    pub fn SBPlatformConnectOptionsGetURL(
        instance: SBPlatformConnectOptionsRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBPlatformConnectOptionsSetURL(
        instance: SBPlatformConnectOptionsRef,
        url: *const ::std::os::raw::c_char,
    );
    pub fn SBPlatformConnectOptionsGetRsyncEnabled(instance: SBPlatformConnectOptionsRef) -> bool;
    pub fn SBPlatformConnectOptionsEnableRsync(
        instance: SBPlatformConnectOptionsRef,
        options: *const ::std::os::raw::c_char,
        remote_path_prefix: *const ::std::os::raw::c_char,
        omit_remote_hostname: bool,
    );
    pub fn SBPlatformConnectOptionsDisableRsync(instance: SBPlatformConnectOptionsRef);
    pub fn SBPlatformConnectOptionsGetLocalCacheDirectory(
        instance: SBPlatformConnectOptionsRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBPlatformConnectOptionsSetLocalCacheDirectory(
        instance: SBPlatformConnectOptionsRef,
        path: *const ::std::os::raw::c_char,
    );
    pub fn CreateSBPlatformShellCommand(
        shell_command: *const ::std::os::raw::c_char,
    ) -> SBPlatformShellCommandRef;
    pub fn CloneSBPlatformShellCommand(
        instance: SBPlatformShellCommandRef,
    ) -> SBPlatformShellCommandRef;
    pub fn DisposeSBPlatformShellCommand(instance: SBPlatformShellCommandRef);
    pub fn SBPlatformShellCommandClear(instance: SBPlatformShellCommandRef);
    pub fn SBPlatformShellCommandGetCommand(
        instance: SBPlatformShellCommandRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBPlatformShellCommandSetCommand(
        instance: SBPlatformShellCommandRef,
        shell_command: *const ::std::os::raw::c_char,
    );
    pub fn SBPlatformShellCommandGetWorkingDirectory(
        instance: SBPlatformShellCommandRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBPlatformShellCommandSetWorkingDirectory(
        instance: SBPlatformShellCommandRef,
        path: *const ::std::os::raw::c_char,
    );
    pub fn SBPlatformShellCommandGetTimeoutSeconds(instance: SBPlatformShellCommandRef) -> u32;
    pub fn SBPlatformShellCommandSetTimeoutSeconds(instance: SBPlatformShellCommandRef, sec: u32);
    pub fn SBPlatformShellCommandGetSignal(
        instance: SBPlatformShellCommandRef,
    ) -> ::std::os::raw::c_int;
    pub fn SBPlatformShellCommandGetStatus(
        instance: SBPlatformShellCommandRef,
    ) -> ::std::os::raw::c_int;
    pub fn SBPlatformShellCommandGetOutput(
        instance: SBPlatformShellCommandRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn CreateSBPlatform() -> SBPlatformRef;
    pub fn CreateSBPlatform2(platform_name: *const ::std::os::raw::c_char) -> SBPlatformRef;
    pub fn CloneSBPlatform(instance: SBPlatformRef) -> SBPlatformRef;
    pub fn DisposeSBPlatform(instance: SBPlatformRef);
    pub fn SBPlatformIsValid(instance: SBPlatformRef) -> bool;
    pub fn SBPlatformClear(instance: SBPlatformRef);
    pub fn SBPlatformGetWorkingDirectory(instance: SBPlatformRef) -> *const ::std::os::raw::c_char;
    pub fn SBPlatformSetWorkingDirectory(
        instance: SBPlatformRef,
        path: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBPlatformGetName(instance: SBPlatformRef) -> *const ::std::os::raw::c_char;
    pub fn SBPlatformConnectRemote(
        instance: SBPlatformRef,
        connect_options: SBPlatformConnectOptionsRef,
    ) -> SBErrorRef;
    pub fn SBPlatformDisconnectRemote(instance: SBPlatformRef);
    pub fn SBPlatformIsConnected(instance: SBPlatformRef) -> bool;
    pub fn SBPlatformGetTriple(instance: SBPlatformRef) -> *const ::std::os::raw::c_char;
    pub fn SBPlatformGetHostname(instance: SBPlatformRef) -> *const ::std::os::raw::c_char;
    pub fn SBPlatformGetOSBuild(instance: SBPlatformRef) -> *const ::std::os::raw::c_char;
    pub fn SBPlatformGetOSDescription(instance: SBPlatformRef) -> *const ::std::os::raw::c_char;
    pub fn SBPlatformGetOSMajorVersion(instance: SBPlatformRef) -> u32;
    pub fn SBPlatformGetOSMinorVersion(instance: SBPlatformRef) -> u32;
    pub fn SBPlatformGetOSUpdateVersion(instance: SBPlatformRef) -> u32;
    pub fn SBPlatformPut(
        instance: SBPlatformRef,
        src: SBFileSpecRef,
        dst: SBFileSpecRef,
    ) -> SBErrorRef;
    pub fn SBPlatformGet(
        instance: SBPlatformRef,
        src: SBFileSpecRef,
        dst: SBFileSpecRef,
    ) -> SBErrorRef;
    pub fn SBPlatformInstall(
        instance: SBPlatformRef,
        src: SBFileSpecRef,
        dst: SBFileSpecRef,
    ) -> SBErrorRef;
    pub fn SBPlatformRun(
        instance: SBPlatformRef,
        shell_command: SBPlatformShellCommandRef,
    ) -> SBErrorRef;
    pub fn SBPlatformLaunch(instance: SBPlatformRef, launch_info: SBLaunchInfoRef) -> SBErrorRef;
    pub fn SBPlatformKill(instance: SBPlatformRef, pid: lldb_pid_t) -> SBErrorRef;
    pub fn SBPlatformMakeDirectory(
        instance: SBPlatformRef,
        path: *const ::std::os::raw::c_char,
        file_permissions: u32,
    ) -> SBErrorRef;
    pub fn SBPlatformGetFilePermissions(
        instance: SBPlatformRef,
        path: *const ::std::os::raw::c_char,
    ) -> u32;
    pub fn SBPlatformSetFilePermissions(
        instance: SBPlatformRef,
        path: *const ::std::os::raw::c_char,
        file_permissions: u32,
    ) -> SBErrorRef;
    pub fn SBPlatformGetEnvironment(instance: SBPlatformRef) -> SBEnvironmentRef;
    pub fn CreateSBProcess() -> SBProcessRef;
    pub fn CloneSBProcess(instance: SBProcessRef) -> SBProcessRef;
    pub fn DisposeSBProcess(instance: SBProcessRef);
    pub fn SBProcessGetBroadcasterClassName() -> *const ::std::os::raw::c_char;
    pub fn SBProcessGetPluginName(instance: SBProcessRef) -> *const ::std::os::raw::c_char;
    pub fn SBProcessGetShortPluginName(instance: SBProcessRef) -> *const ::std::os::raw::c_char;
    pub fn SBProcessClear(instance: SBProcessRef);
    pub fn SBProcessIsValid(instance: SBProcessRef) -> bool;
    pub fn SBProcessGetTarget(instance: SBProcessRef) -> SBTargetRef;
    pub fn SBProcessGetByteOrder(instance: SBProcessRef) -> ByteOrder;
    pub fn SBProcessPutSTDIN(
        instance: SBProcessRef,
        src: *const ::std::os::raw::c_char,
        src_len: size_t,
    ) -> size_t;
    pub fn SBProcessGetSTDOUT(
        instance: SBProcessRef,
        dst: *mut ::std::os::raw::c_char,
        dst_len: size_t,
    ) -> size_t;
    pub fn SBProcessGetSTDERR(
        instance: SBProcessRef,
        dst: *mut ::std::os::raw::c_char,
        dst_len: size_t,
    ) -> size_t;
    pub fn SBProcessGetAsyncProfileData(
        instance: SBProcessRef,
        dst: *mut ::std::os::raw::c_char,
        dst_len: size_t,
    ) -> size_t;
    pub fn SBProcessReportEventState(instance: SBProcessRef, event: SBEventRef, out: *mut FILE);
    pub fn SBProcessAppendEventStateReport(
        instance: SBProcessRef,
        event: SBEventRef,
        result: SBCommandReturnObjectRef,
    );
    pub fn SBProcessRemoteAttachToProcessWithID(
        instance: SBProcessRef,
        pid: lldb_pid_t,
        error: SBErrorRef,
    ) -> bool;
    pub fn SBProcessRemoteLaunch(
        instance: SBProcessRef,
        argv: *const *const ::std::os::raw::c_char,
        envp: *const *const ::std::os::raw::c_char,
        stdin_path: *const ::std::os::raw::c_char,
        stdout_path: *const ::std::os::raw::c_char,
        stderr_path: *const ::std::os::raw::c_char,
        working_directory: *const ::std::os::raw::c_char,
        launch_flags: u32,
        stop_at_entry: bool,
        error: SBErrorRef,
    ) -> bool;
    pub fn SBProcessGetNumThreads(instance: SBProcessRef) -> u32;
    pub fn SBProcessGetThreadAtIndex(instance: SBProcessRef, index: size_t) -> SBThreadRef;
    pub fn SBProcessGetThreadByID(instance: SBProcessRef, sb_thread_id: lldb_tid_t) -> SBThreadRef;
    pub fn SBProcessGetThreadByIndexID(instance: SBProcessRef, index_id: u32) -> SBThreadRef;
    pub fn SBProcessGetSelectedThread(instance: SBProcessRef) -> SBThreadRef;
    pub fn SBProcessCreateOSPluginThread(
        instance: SBProcessRef,
        tid: lldb_tid_t,
        context: lldb_addr_t,
    ) -> SBThreadRef;
    pub fn SBProcessSetSelectedThread(instance: SBProcessRef, thread: SBThreadRef) -> bool;
    pub fn SBProcessSetSelectedThreadByID(instance: SBProcessRef, tid: lldb_tid_t) -> bool;
    pub fn SBProcessSetSelectedThreadByIndexID(instance: SBProcessRef, index_id: u32) -> bool;
    pub fn SBProcessGetNumQueues(instance: SBProcessRef) -> u32;
    pub fn SBProcessGetQueueAtIndex(instance: SBProcessRef, index: size_t) -> SBQueueRef;
    pub fn SBProcessGetState(instance: SBProcessRef) -> StateType;
    pub fn SBProcessGetExitStatus(instance: SBProcessRef) -> ::std::os::raw::c_int;
    pub fn SBProcessGetExitDescription(instance: SBProcessRef) -> *const ::std::os::raw::c_char;
    pub fn SBProcessGetProcessID(instance: SBProcessRef) -> lldb_pid_t;
    pub fn SBProcessGetUniqueID(instance: SBProcessRef) -> u32;
    pub fn SBProcessGetAddressByteSize(instance: SBProcessRef) -> u32;
    pub fn SBProcessDestroy(instance: SBProcessRef) -> SBErrorRef;
    pub fn SBProcessContinue(instance: SBProcessRef) -> SBErrorRef;
    pub fn SBProcessStop(instance: SBProcessRef) -> SBErrorRef;
    pub fn SBProcessKill(instance: SBProcessRef) -> SBErrorRef;
    pub fn SBProcessDetach(instance: SBProcessRef) -> SBErrorRef;
    pub fn SBProcessDetach2(instance: SBProcessRef, keep_stopped: bool) -> SBErrorRef;
    pub fn SBProcessSignal(instance: SBProcessRef, signal: ::std::os::raw::c_int) -> SBErrorRef;
    pub fn SBProcessGetUnixSignals(instance: SBProcessRef) -> SBUnixSignalsRef;
    pub fn SBProcessSendAsyncInterrupt(instance: SBProcessRef);
    pub fn SBProcessGetStopID(instance: SBProcessRef, include_expression_stops: bool) -> u32;
    pub fn SBProcessReadMemory(
        instance: SBProcessRef,
        addr: lldb_addr_t,
        buf: *mut ::std::os::raw::c_void,
        size: size_t,
        error: SBErrorRef,
    ) -> size_t;
    pub fn SBProcessWriteMemory(
        instance: SBProcessRef,
        addr: lldb_addr_t,
        buf: *mut ::std::os::raw::c_void,
        size: size_t,
        error: SBErrorRef,
    ) -> size_t;
    pub fn SBProcessReadCStringFromMemory(
        instance: SBProcessRef,
        addr: lldb_addr_t,
        buf: *mut ::std::os::raw::c_void,
        size: size_t,
        error: SBErrorRef,
    ) -> size_t;
    pub fn SBProcessReadUnsignedFromMemory(
        instance: SBProcessRef,
        addr: lldb_addr_t,
        byte_size: u32,
        error: SBErrorRef,
    ) -> u64;
    pub fn SBProcessReadPointerFromMemory(
        instance: SBProcessRef,
        addr: lldb_addr_t,
        error: SBErrorRef,
    ) -> lldb_addr_t;
    pub fn SBProcessGetStateFromEvent(event: SBEventRef) -> StateType;
    pub fn SBProcessGetRestartedFromEvent(event: SBEventRef) -> bool;
    pub fn SBProcessGetNumRestartedReasonsFromEvent(event: SBEventRef) -> size_t;
    pub fn SBProcessGetRestartedReasonAtIndexFromEvent(
        event: SBEventRef,
        idx: size_t,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBProcessGetProcessFromEvent(event: SBEventRef) -> SBProcessRef;
    pub fn SBProcessGetInterruptedFromEvent(event: SBEventRef) -> bool;
    pub fn SBProcessGetStructuredDataFromEvent(event: SBEventRef) -> SBStructuredDataRef;
    pub fn SBProcessEventIsProcessEvent(event: SBEventRef) -> bool;
    pub fn SBProcessEventIsStructuredDataEvent(event: SBEventRef) -> bool;
    pub fn SBProcessGetBroadcaster(instance: SBProcessRef) -> SBBroadcasterRef;
    pub fn SBProcessGetBroadcasterClass() -> *const ::std::os::raw::c_char;
    pub fn SBProcessGetDescription(instance: SBProcessRef, description: SBStreamRef) -> bool;
    pub fn SBProcessGetNumSupportedHardwareWatchpoints(
        instance: SBProcessRef,
        error: SBErrorRef,
    ) -> u32;
    pub fn SBProcessLoadImage(
        instance: SBProcessRef,
        image_spec: SBFileSpecRef,
        error: SBErrorRef,
    ) -> u32;
    pub fn SBProcessLoadImageUsingPaths(
        instance: SBProcessRef,
        image_spec: SBFileSpecRef,
        paths: SBStringListRef,
        loaded_path: SBFileSpecRef,
        error: SBErrorRef,
    ) -> u32;
    pub fn SBProcessUnloadImage(instance: SBProcessRef, image_token: u32) -> SBErrorRef;
    pub fn SBProcessSendEventData(
        instance: SBProcessRef,
        data: *const ::std::os::raw::c_char,
    ) -> SBErrorRef;
    pub fn SBProcessGetNumExtendedBacktraceTypes(instance: SBProcessRef) -> u32;
    pub fn SBProcessGetExtendedBacktraceTypeAtIndex(
        instance: SBProcessRef,
        idx: u32,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBProcessGetHistoryThreads(
        instance: SBProcessRef,
        addr: lldb_addr_t,
    ) -> SBThreadCollectionRef;
    pub fn SBProcessIsInstrumentationRuntimePresent(
        instance: SBProcessRef,
        type_: InstrumentationRuntimeType,
    ) -> bool;
    pub fn SBProcessSaveCore(
        instance: SBProcessRef,
        file_name: *const ::std::os::raw::c_char,
    ) -> SBErrorRef;
    pub fn SBProcessGetMemoryRegionInfo(
        instance: SBProcessRef,
        load_addr: lldb_addr_t,
        region_info: SBMemoryRegionInfoRef,
    ) -> SBErrorRef;
    pub fn SBProcessGetMemoryRegions(instance: SBProcessRef) -> SBMemoryRegionInfoListRef;
    pub fn SBProcessGetProcessInfo(instance: SBProcessRef) -> SBProcessInfoRef;
    pub fn CreateSBProcessInfo() -> SBProcessInfoRef;
    pub fn CloneSBProcessInfo(instance: SBProcessInfoRef) -> SBProcessInfoRef;
    pub fn DisposeSBProcessInfo(instance: SBProcessInfoRef);
    pub fn SBProcessInfoIsValid(instance: SBProcessInfoRef) -> bool;
    pub fn SBProcessInfoGetName(instance: SBProcessInfoRef) -> *const ::std::os::raw::c_char;
    pub fn SBProcessInfoGetExecutableFile(instance: SBProcessInfoRef) -> SBFileSpecRef;
    pub fn SBProcessInfoGetProcessID(instance: SBProcessInfoRef) -> lldb_pid_t;
    pub fn SBProcessInfoGetUserID(instance: SBProcessInfoRef) -> u32;
    pub fn SBProcessInfoGetGroupID(instance: SBProcessInfoRef) -> u32;
    pub fn SBProcessInfoUserIDIsValid(instance: SBProcessInfoRef) -> bool;
    pub fn SBProcessInfoGroupIDIsValid(instance: SBProcessInfoRef) -> bool;
    pub fn SBProcessInfoGetEffectiveUserID(instance: SBProcessInfoRef) -> u32;
    pub fn SBProcessInfoGetEffectiveGroupID(instance: SBProcessInfoRef) -> u32;
    pub fn SBProcessInfoEffectiveUserIDIsValid(instance: SBProcessInfoRef) -> bool;
    pub fn SBProcessInfoEffectiveGroupIDIsValid(instance: SBProcessInfoRef) -> bool;
    pub fn SBProcessInfoGetParentProcessID(instance: SBProcessInfoRef) -> lldb_pid_t;
    pub fn CreateSBQueue() -> SBQueueRef;
    pub fn CloneSBQueue(instance: SBQueueRef) -> SBQueueRef;
    pub fn DisposeSBQueue(instance: SBQueueRef);
    pub fn SBQueueIsValid(instance: SBQueueRef) -> bool;
    pub fn SBQueueClear(instance: SBQueueRef);
    pub fn SBQueueGetProcess(instance: SBQueueRef) -> SBProcessRef;
    pub fn SBQueueGetQueueID(instance: SBQueueRef) -> lldb_queue_id_t;
    pub fn SBQueueGetName(instance: SBQueueRef) -> *const ::std::os::raw::c_char;
    pub fn SBQueueGetIndexID(instance: SBQueueRef) -> u32;
    pub fn SBQueueGetNumThreads(instance: SBQueueRef) -> u32;
    pub fn SBQueueGetThreadAtIndex(instance: SBQueueRef, arg1: u32) -> SBThreadRef;
    pub fn SBQueueGetNumPendingItems(instance: SBQueueRef) -> u32;
    pub fn SBQueueGetPendingItemAtIndex(instance: SBQueueRef, arg1: u32) -> SBQueueItemRef;
    pub fn SBQueueGetNumRunningItems(instance: SBQueueRef) -> u32;
    pub fn SBQueueGetKind(instance: SBQueueRef) -> QueueKind;
    pub fn CreateSBQueueItem() -> SBQueueItemRef;
    pub fn CloneSBQueueItem(instance: SBQueueItemRef) -> SBQueueItemRef;
    pub fn DisposeSBQueueItem(instance: SBQueueItemRef);
    pub fn SBQueueItemIsValid(instance: SBQueueItemRef) -> bool;
    pub fn SBQueueItemClear(instance: SBQueueItemRef);
    pub fn SBQueueItemGetKind(instance: SBQueueItemRef) -> QueueItemKind;
    pub fn SBQueueItemSetKind(instance: SBQueueItemRef, kind: QueueItemKind);
    pub fn SBQueueItemGetAddress(instance: SBQueueItemRef) -> SBAddressRef;
    pub fn SBQueueItemSetAddress(instance: SBQueueItemRef, addr: SBAddressRef);
    pub fn SBQueueItemGetExtendedBacktraceThread(
        instance: SBQueueItemRef,
        type_: *const ::std::os::raw::c_char,
    ) -> SBThreadRef;
    pub fn CreateSBSection() -> SBSectionRef;
    pub fn CloneSBSection(instance: SBSectionRef) -> SBSectionRef;
    pub fn DisposeSBSection(instance: SBSectionRef);
    pub fn SBSectionIsValid(instance: SBSectionRef) -> bool;
    pub fn SBSectionGetName(instance: SBSectionRef) -> *const ::std::os::raw::c_char;
    pub fn SBSectionGetParent(instance: SBSectionRef) -> SBSectionRef;
    pub fn SBSectionFindSubSection(
        instance: SBSectionRef,
        sect_name: *const ::std::os::raw::c_char,
    ) -> SBSectionRef;
    pub fn SBSectionGetNumSubSections(instance: SBSectionRef) -> size_t;
    pub fn SBSectionGetSubSectionAtIndex(instance: SBSectionRef, idx: size_t) -> SBSectionRef;
    pub fn SBSectionGetFileAddress(instance: SBSectionRef) -> lldb_addr_t;
    pub fn SBSectionGetLoadAddress(instance: SBSectionRef, target: SBTargetRef) -> lldb_addr_t;
    pub fn SBSectionGetByteSize(instance: SBSectionRef) -> lldb_addr_t;
    pub fn SBSectionGetFileOffset(instance: SBSectionRef) -> u64;
    pub fn SBSectionGetFileByteSize(instance: SBSectionRef) -> u64;
    pub fn SBSectionGetSectionData(instance: SBSectionRef) -> SBDataRef;
    pub fn SBSectionGetSectionData2(instance: SBSectionRef, offset: u64, size: u64) -> SBDataRef;
    pub fn SBSectionGetSectionType(instance: SBSectionRef) -> SectionType;
    pub fn SBSectionGetPermissions(instance: SBSectionRef) -> u32;
    pub fn SBSectionGetTargetByteSize(instance: SBSectionRef) -> u32;
    pub fn SBSectionGetDescription(instance: SBSectionRef, description: SBStreamRef) -> bool;
    pub fn CreateSBSourceManager(debugger: SBDebuggerRef) -> SBSourceManagerRef;
    pub fn CreateSBSourceManager2(target: SBTargetRef) -> SBSourceManagerRef;
    pub fn CloneSBSourceManager(instance: SBSourceManagerRef) -> SBSourceManagerRef;
    pub fn DisposeSBSourceManager(instance: SBSourceManagerRef);
    pub fn SBSourceManagerDisplaySourceLinesWithLineNumbers(
        instance: SBSourceManagerRef,
        file: SBFileSpecRef,
        line: u32,
        context_before: u32,
        context_after: u32,
        current_line_cstr: *const ::std::os::raw::c_char,
        s: SBStreamRef,
    ) -> size_t;
    pub fn SBSourceManagerDisplaySourceLinesWithLineNumbersAndColumn(
        instance: SBSourceManagerRef,
        file: SBFileSpecRef,
        line: u32,
        column: u32,
        context_before: u32,
        context_after: u32,
        current_line_cstr: *const ::std::os::raw::c_char,
        s: SBStreamRef,
    ) -> size_t;
    pub fn CreateSBStream() -> SBStreamRef;
    pub fn DisposeSBStream(instance: SBStreamRef);
    pub fn SBStreamIsValid(instance: SBStreamRef) -> bool;
    pub fn SBStreamGetData(instance: SBStreamRef) -> *const ::std::os::raw::c_char;
    pub fn SBStreamGetSize(instance: SBStreamRef) -> size_t;
    pub fn SBStreamPrintf(instance: SBStreamRef, format: *const ::std::os::raw::c_char, ...);
    pub fn SBStreamPrint(instance: SBStreamRef, str: *const ::std::os::raw::c_char);
    pub fn SBStreamRedirectToFile(
        instance: SBStreamRef,
        path: *const ::std::os::raw::c_char,
        append: bool,
    );
    pub fn SBStreamRedirectToFileHandle(
        instance: SBStreamRef,
        fh: *mut FILE,
        transfer_fh_ownership: bool,
    );
    pub fn SBStreamRedirectToFileDescriptor(
        instance: SBStreamRef,
        fd: ::std::os::raw::c_int,
        transfer_fh_ownership: bool,
    );
    pub fn SBStreamClear(instance: SBStreamRef);
    pub fn CreateSBStringList() -> SBStringListRef;
    pub fn CloneSBStringList(instance: SBStringListRef) -> SBStringListRef;
    pub fn DisposeSBStringList(instance: SBStringListRef);
    pub fn SBStringListIsValid(instance: SBStringListRef) -> bool;
    pub fn SBStringListAppendString(instance: SBStringListRef, str: *const ::std::os::raw::c_char);
    pub fn SBStringListAppendList(
        instance: SBStringListRef,
        strv: *const *const ::std::os::raw::c_char,
        strc: ::std::os::raw::c_int,
    );
    pub fn SBStringListAppendList2(instance: SBStringListRef, strings: SBStringListRef);
    pub fn SBStringListGetSize(instance: SBStringListRef) -> u32;
    pub fn SBStringListGetStringAtIndex(
        instance: SBStringListRef,
        idx: size_t,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBStringListClear(instance: SBStringListRef);
    pub fn CreateSBStructuredData() -> SBStructuredDataRef;
    pub fn CloneSBStructuredData(instance: SBStructuredDataRef) -> SBStructuredDataRef;
    pub fn DisposeSBStructuredData(instance: SBStructuredDataRef);
    pub fn SBStructuredDataIsValid(instance: SBStructuredDataRef) -> bool;
    pub fn SBStructuredDataClear(instance: SBStructuredDataRef);
    pub fn SBStructuredDataSetFromJSON(
        instance: SBStructuredDataRef,
        stream: SBStreamRef,
    ) -> SBErrorRef;
    pub fn SBStructuredDataGetAsJSON(
        instance: SBStructuredDataRef,
        stream: SBStreamRef,
    ) -> SBErrorRef;
    pub fn SBStructuredDataGetDescription(
        instance: SBStructuredDataRef,
        stream: SBStreamRef,
    ) -> SBErrorRef;
    pub fn SBStructuredDataGetType(instance: SBStructuredDataRef) -> StructuredDataType;
    pub fn SBStructuredDataGetSize(instance: SBStructuredDataRef) -> size_t;
    pub fn SBStructuredDataGetKeys(instance: SBStructuredDataRef, keys: SBStringListRef) -> bool;
    pub fn SBStructuredDataGetValueForKey(
        instance: SBStructuredDataRef,
        key: *const ::std::os::raw::c_char,
    ) -> SBStructuredDataRef;
    pub fn SBStructuredDataGetItemAtIndex(
        instance: SBStructuredDataRef,
        idx: size_t,
    ) -> SBStructuredDataRef;
    pub fn SBStructuredDataGetIntegerValue(instance: SBStructuredDataRef, fail_value: u64) -> u64;
    pub fn SBStructuredDataGetFloatValue(
        instance: SBStructuredDataRef,
        fail_value: ::std::os::raw::c_double,
    ) -> ::std::os::raw::c_double;
    pub fn SBStructuredDataGetBooleanValue(instance: SBStructuredDataRef, fail_value: bool)
        -> bool;
    pub fn SBStructuredDataGetStringValue(
        instance: SBStructuredDataRef,
        dst: *mut ::std::os::raw::c_char,
        dstlen: size_t,
    ) -> size_t;
    pub fn CreateSBSymbol() -> SBSymbolRef;
    pub fn CloneSBSymbol(instance: SBSymbolRef) -> SBSymbolRef;
    pub fn DisposeSBSymbol(instance: SBSymbolRef);
    pub fn SBSymbolIsValid(instance: SBSymbolRef) -> bool;
    pub fn SBSymbolGetName(instance: SBSymbolRef) -> *const ::std::os::raw::c_char;
    pub fn SBSymbolGetDisplayName(instance: SBSymbolRef) -> *const ::std::os::raw::c_char;
    pub fn SBSymbolGetMangledName(instance: SBSymbolRef) -> *const ::std::os::raw::c_char;
    pub fn SBSymbolGetInstructions(
        instance: SBSymbolRef,
        target: SBTargetRef,
    ) -> SBInstructionListRef;
    pub fn SBSymbolGetInstructions2(
        instance: SBSymbolRef,
        target: SBTargetRef,
        flavor_string: *const ::std::os::raw::c_char,
    ) -> SBInstructionListRef;
    pub fn SBSymbolGetStartAddress(instance: SBSymbolRef) -> SBAddressRef;
    pub fn SBSymbolGetEndAddress(instance: SBSymbolRef) -> SBAddressRef;
    pub fn SBSymbolGetPrologueByteSize(instance: SBSymbolRef) -> u32;
    pub fn SBSymbolGetType(instance: SBSymbolRef) -> SymbolType;
    pub fn SBSymbolGetDescription(instance: SBSymbolRef, description: SBStreamRef) -> bool;
    pub fn SBSymbolIsExternal(instance: SBSymbolRef) -> bool;
    pub fn SBSymbolIsSynthetic(instance: SBSymbolRef) -> bool;
    pub fn CreateSBSymbolContext() -> SBSymbolContextRef;
    pub fn CloneSBSymbolContext(instance: SBSymbolContextRef) -> SBSymbolContextRef;
    pub fn DisposeSBSymbolContext(instance: SBSymbolContextRef);
    pub fn SBSymbolContextIsValid(instance: SBSymbolContextRef) -> bool;
    pub fn SBSymbolContextGetModule(instance: SBSymbolContextRef) -> SBModuleRef;
    pub fn SBSymbolContextGetCompileUnit(instance: SBSymbolContextRef) -> SBCompileUnitRef;
    pub fn SBSymbolContextGetFunction(instance: SBSymbolContextRef) -> SBFunctionRef;
    pub fn SBSymbolContextGetBlock(instance: SBSymbolContextRef) -> SBBlockRef;
    pub fn SBSymbolContextGetLineEntry(instance: SBSymbolContextRef) -> SBLineEntryRef;
    pub fn SBSymbolContextGetSymbol(instance: SBSymbolContextRef) -> SBSymbolRef;
    pub fn SBSymbolContextSetModule(instance: SBSymbolContextRef, module: SBModuleRef);
    pub fn SBSymbolContextSetCompileUnit(
        instance: SBSymbolContextRef,
        compile_unit: SBCompileUnitRef,
    );
    pub fn SBSymbolContextSetFunction(instance: SBSymbolContextRef, function: SBFunctionRef);
    pub fn SBSymbolContextSetBlock(instance: SBSymbolContextRef, block: SBBlockRef);
    pub fn SBSymbolContextSetLineEntry(instance: SBSymbolContextRef, line_entry: SBLineEntryRef);
    pub fn SBSymbolContextSetSymbol(instance: SBSymbolContextRef, symbol: SBSymbolRef);
    pub fn SBSymbolContextGetParentOfInlinedScope(
        instance: SBSymbolContextRef,
        curr_frame_pc: SBAddressRef,
        parent_frame_addr: SBAddressRef,
    ) -> SBSymbolContextRef;
    pub fn SBSymbolContextGetDescription(
        instance: SBSymbolContextRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn CreateSBSymbolContextList() -> SBSymbolContextListRef;
    pub fn CloneSBSymbolContextList(instance: SBSymbolContextListRef) -> SBSymbolContextListRef;
    pub fn DisposeSBSymbolContextList(instance: SBSymbolContextListRef);
    pub fn SBSymbolContextListIsValid(instance: SBSymbolContextListRef) -> bool;
    pub fn SBSymbolContextListGetSize(instance: SBSymbolContextListRef) -> u32;
    pub fn SBSymbolContextListGetContextAtIndex(
        instance: SBSymbolContextListRef,
        idx: u32,
    ) -> SBSymbolContextRef;
    pub fn SBSymbolContextListGetDescription(
        instance: SBSymbolContextListRef,
        description: SBStreamRef,
    ) -> bool;
    pub fn SBSymbolContextListAppend(instance: SBSymbolContextListRef, sc: SBSymbolContextRef);
    pub fn SBSymbolContextListAppendList(
        instance: SBSymbolContextListRef,
        sc_list: SBSymbolContextListRef,
    );
    pub fn SBSymbolContextListClear(instance: SBSymbolContextListRef);
    pub fn CreateSBTarget() -> SBTargetRef;
    pub fn CloneSBTarget(instance: SBTargetRef) -> SBTargetRef;
    pub fn DisposeSBTarget(instance: SBTargetRef);
    pub fn SBTargetIsValid(instance: SBTargetRef) -> bool;
    pub fn SBTargetEventIsTargetEvent(event: SBEventRef) -> bool;
    pub fn SBTargetGetTargetFromEvent(event: SBEventRef) -> SBTargetRef;
    pub fn SBTargetGetNumModulesFromEvent(event: SBEventRef) -> u32;
    pub fn SBTargetGetModuleAtIndexFromEvent(idx: u32, event: SBEventRef) -> SBModuleRef;
    pub fn SBTargetGetBroadcasterClassName() -> *const ::std::os::raw::c_char;
    pub fn SBTargetGetProcess(instance: SBTargetRef) -> SBProcessRef;
    pub fn SBTargetSetCollectingStats(instance: SBTargetRef, v: bool);
    pub fn SBTargetGetCollectingStats(instance: SBTargetRef) -> bool;
    pub fn SBTargetGetStatistics(instance: SBTargetRef) -> SBStructuredDataRef;
    pub fn SBTargetGetPlatform(instance: SBTargetRef) -> SBPlatformRef;
    pub fn SBTargetGetEnvironment(instance: SBTargetRef) -> SBEnvironmentRef;
    pub fn SBTargetInstall(instance: SBTargetRef) -> SBErrorRef;
    pub fn SBTargetLaunch(
        instance: SBTargetRef,
        listener: SBListenerRef,
        argv: *const *const ::std::os::raw::c_char,
        envp: *const *const ::std::os::raw::c_char,
        stdin_path: *const ::std::os::raw::c_char,
        stdout_path: *const ::std::os::raw::c_char,
        stderr_path: *const ::std::os::raw::c_char,
        working_directory: *const ::std::os::raw::c_char,
        launch_flags: u32,
        stop_at_entry: bool,
        error: SBErrorRef,
    ) -> SBProcessRef;
    pub fn SBTargetLaunchSimple(
        instance: SBTargetRef,
        argv: *const *const ::std::os::raw::c_char,
        envp: *const *const ::std::os::raw::c_char,
        working_directory: *const ::std::os::raw::c_char,
    ) -> SBProcessRef;
    pub fn SBTargetLaunch2(
        instance: SBTargetRef,
        launch_info: SBLaunchInfoRef,
        error: SBErrorRef,
    ) -> SBProcessRef;
    pub fn SBTargetLoadCore(
        instance: SBTargetRef,
        core_file: *const ::std::os::raw::c_char,
        error: SBErrorRef,
    ) -> SBProcessRef;
    pub fn SBTargetAttach(
        instance: SBTargetRef,
        attach_info: SBAttachInfoRef,
        error: SBErrorRef,
    ) -> SBProcessRef;
    pub fn SBTargetAttachToProcessWithID(
        instance: SBTargetRef,
        listener: SBListenerRef,
        pid: lldb_pid_t,
        error: SBErrorRef,
    ) -> SBProcessRef;
    pub fn SBTargetAttachToProcessWithName(
        instance: SBTargetRef,
        listener: SBListenerRef,
        name: *const ::std::os::raw::c_char,
        wait_for: bool,
        error: SBErrorRef,
    ) -> SBProcessRef;
    pub fn SBTargetConnectRemote(
        instance: SBTargetRef,
        listener: SBListenerRef,
        url: *const ::std::os::raw::c_char,
        plugin_name: *const ::std::os::raw::c_char,
        error: SBErrorRef,
    ) -> SBProcessRef;
    pub fn SBTargetGetExecutable(instance: SBTargetRef) -> SBFileSpecRef;
    pub fn SBTargetAppendImageSearchPath(
        instance: SBTargetRef,
        from: *const ::std::os::raw::c_char,
        to: *const ::std::os::raw::c_char,
        error: SBErrorRef,
    );
    pub fn SBTargetAddModule(instance: SBTargetRef, module: SBModuleRef) -> bool;
    pub fn SBTargetAddModuleSpec(
        instance: SBTargetRef,
        module_spec: SBModuleSpecRef,
    ) -> SBModuleRef;
    pub fn SBTargetGetNumModules(instance: SBTargetRef) -> u32;
    pub fn SBTargetGetModuleAtIndex(instance: SBTargetRef, idx: u32) -> SBModuleRef;
    pub fn SBTargetRemoveModule(instance: SBTargetRef, module: SBModuleRef) -> bool;
    pub fn SBTargetGetDebugger(instance: SBTargetRef) -> SBDebuggerRef;
    pub fn SBTargetFindModule(instance: SBTargetRef, file_spec: SBFileSpecRef) -> SBModuleRef;
    pub fn SBTargetFindCompileUnits(
        instance: SBTargetRef,
        file_spec: SBFileSpecRef,
    ) -> SBSymbolContextListRef;
    pub fn SBTargetGetByteOrder(instance: SBTargetRef) -> ByteOrder;
    pub fn SBTargetGetAddressByteSize(instance: SBTargetRef) -> u32;
    pub fn SBTargetGetTriple(instance: SBTargetRef) -> *const ::std::os::raw::c_char;
    pub fn SBTargetGetDataByteSize(instance: SBTargetRef) -> u32;
    pub fn SBTargetGetCodeByteSize(instance: SBTargetRef) -> u32;
    pub fn SBTargetSetSectionLoadAddress(
        instance: SBTargetRef,
        section: SBSectionRef,
        section_base_addr: lldb_addr_t,
    ) -> SBErrorRef;
    pub fn SBTargetClearSectionLoadAddress(
        instance: SBTargetRef,
        section: SBSectionRef,
    ) -> SBErrorRef;
    pub fn SBTargetSetModuleLoadAddress(
        instance: SBTargetRef,
        module: SBModuleRef,
        sections_offset: i64,
    ) -> SBErrorRef;
    pub fn SBTargetClearModuleLoadAddress(instance: SBTargetRef, module: SBModuleRef)
        -> SBErrorRef;
    pub fn SBTargetFindFunctions(
        instance: SBTargetRef,
        name: *const ::std::os::raw::c_char,
        name_type_mask: u32,
    ) -> SBSymbolContextListRef;
    pub fn SBTargetFindGlobalVariables(
        instance: SBTargetRef,
        name: *const ::std::os::raw::c_char,
        max_matches: u32,
    ) -> SBValueListRef;
    pub fn SBTargetFindFirstGlobalVariable(
        instance: SBTargetRef,
        name: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBTargetFindGlobalVariables2(
        instance: SBTargetRef,
        name: *const ::std::os::raw::c_char,
        max_matches: u32,
        matchtype: MatchType,
    ) -> SBValueListRef;
    pub fn SBTargetFindGlobalFunctions(
        instance: SBTargetRef,
        name: *const ::std::os::raw::c_char,
        max_matches: u32,
        matchtype: MatchType,
    ) -> SBSymbolContextListRef;
    pub fn SBTargetClear(instance: SBTargetRef);
    pub fn SBTargetResolveFileAddress(
        instance: SBTargetRef,
        file_addr: lldb_addr_t,
    ) -> SBAddressRef;
    pub fn SBTargetResolveLoadAddress(instance: SBTargetRef, vm_addr: lldb_addr_t) -> SBAddressRef;
    pub fn SBTargetResolvePastLoadAddress(
        instance: SBTargetRef,
        stop_id: u32,
        vm_addr: lldb_addr_t,
    ) -> SBAddressRef;
    pub fn SBTargetResolveSymbolContextForAddress(
        instance: SBTargetRef,
        addr: SBAddressRef,
        resolve_scope: u32,
    ) -> SBSymbolContextRef;
    pub fn SBTargetReadMemory(
        instance: SBTargetRef,
        addr: SBAddressRef,
        buf: *mut ::std::os::raw::c_void,
        size: size_t,
        error: SBErrorRef,
    ) -> size_t;
    pub fn SBTargetBreakpointCreateByLocation(
        instance: SBTargetRef,
        file: *const ::std::os::raw::c_char,
        line: u32,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByLocation2(
        instance: SBTargetRef,
        file_spec: SBFileSpecRef,
        line: u32,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByLocation3(
        instance: SBTargetRef,
        file_spec: SBFileSpecRef,
        line: u32,
        offset: lldb_addr_t,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByLocation4(
        instance: SBTargetRef,
        file_spec: SBFileSpecRef,
        line: u32,
        offset: lldb_addr_t,
        module_list: SBFileSpecListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByLocation5(
        instance: SBTargetRef,
        file_spec: SBFileSpecRef,
        line: u32,
        column: u32,
        offset: lldb_addr_t,
        module_list: SBFileSpecListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByName(
        instance: SBTargetRef,
        symbol_name: *const ::std::os::raw::c_char,
        module_name: *const ::std::os::raw::c_char,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByName2(
        instance: SBTargetRef,
        symbol_name: *const ::std::os::raw::c_char,
        module_list: SBFileSpecListRef,
        comp_unit_list: SBFileSpecListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByName3(
        instance: SBTargetRef,
        symbol_name: *const ::std::os::raw::c_char,
        name_type_mask: u32,
        module_list: SBFileSpecListRef,
        comp_unit_list: SBFileSpecListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByNames(
        instance: SBTargetRef,
        symbol_name: *const *const ::std::os::raw::c_char,
        num_names: u32,
        name_type_mask: u32,
        module_list: SBFileSpecListRef,
        comp_unit_list: SBFileSpecListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByNames2(
        instance: SBTargetRef,
        symbol_name: *const *const ::std::os::raw::c_char,
        num_names: u32,
        name_type_mask: u32,
        symbol_language: LanguageType,
        module_list: SBFileSpecListRef,
        comp_unit_list: SBFileSpecListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByNames3(
        instance: SBTargetRef,
        symbol_name: *const *const ::std::os::raw::c_char,
        num_names: u32,
        name_type_mask: u32,
        symbol_language: LanguageType,
        offset: lldb_addr_t,
        module_list: SBFileSpecListRef,
        comp_unit_list: SBFileSpecListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByRegex(
        instance: SBTargetRef,
        symbol_name_regex: *const ::std::os::raw::c_char,
        module_name: *const ::std::os::raw::c_char,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByRegex2(
        instance: SBTargetRef,
        symbol_name_regex: *const ::std::os::raw::c_char,
        module_list: SBFileSpecListRef,
        comp_unit_list: SBFileSpecListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByRegex3(
        instance: SBTargetRef,
        symbol_name_regex: *const ::std::os::raw::c_char,
        symbol_language: LanguageType,
        module_list: SBFileSpecListRef,
        comp_unit_list: SBFileSpecListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateBySourceRegex(
        instance: SBTargetRef,
        source_regex: *const ::std::os::raw::c_char,
        source_file: SBFileSpecRef,
        module_name: *const ::std::os::raw::c_char,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateBySourceRegex2(
        instance: SBTargetRef,
        source_regex: *const ::std::os::raw::c_char,
        module_list: SBFileSpecListRef,
        source_file: SBFileSpecListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateBySourceRegex3(
        instance: SBTargetRef,
        source_regex: *const ::std::os::raw::c_char,
        module_list: SBFileSpecListRef,
        source_file: SBFileSpecListRef,
        func_names: SBStringListRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateForException(
        instance: SBTargetRef,
        language: LanguageType,
        catch_bp: bool,
        throw_bp: bool,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateByAddress(
        instance: SBTargetRef,
        address: lldb_addr_t,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateBySBAddress(
        instance: SBTargetRef,
        address: SBAddressRef,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointCreateFromScript(
        instance: SBTargetRef,
        class_name: *const ::std::os::raw::c_char,
        extra_args: SBStructuredDataRef,
        module_list: SBFileSpecListRef,
        file_list: SBFileSpecListRef,
        request_hardware: bool,
    ) -> SBBreakpointRef;
    pub fn SBTargetBreakpointsCreateFromFile(
        instance: SBTargetRef,
        source_file: SBFileSpecRef,
        new_bps: SBBreakpointListRef,
    ) -> SBErrorRef;
    pub fn SBTargetBreakpointsCreateFromFile2(
        instance: SBTargetRef,
        source_file: SBFileSpecRef,
        matching_names: SBStringListRef,
        new_bps: SBBreakpointListRef,
    ) -> SBErrorRef;
    pub fn SBTargetBreakpointsWriteToFile(
        instance: SBTargetRef,
        dest_file: SBFileSpecRef,
    ) -> SBErrorRef;
    pub fn SBTargetBreakpointsWriteToFile2(
        instance: SBTargetRef,
        dest_file: SBFileSpecRef,
        bkpt_list: SBBreakpointListRef,
        append: bool,
    ) -> SBErrorRef;
    pub fn SBTargetGetNumBreakpoints(instance: SBTargetRef) -> u32;
    pub fn SBTargetGetBreakpointAtIndex(instance: SBTargetRef, idx: u32) -> SBBreakpointRef;
    pub fn SBTargetBreakpointDelete(instance: SBTargetRef, break_id: lldb_break_id_t) -> bool;
    pub fn SBTargetFindBreakpointByID(
        instance: SBTargetRef,
        break_id: lldb_break_id_t,
    ) -> SBBreakpointRef;
    pub fn SBTargetFindBreakpointsByName(
        instance: SBTargetRef,
        name: *const ::std::os::raw::c_char,
        bkpt_list: SBBreakpointListRef,
    ) -> bool;
    pub fn SBTargetGetBreakpointNames(instance: SBTargetRef, names: SBStringListRef);
    pub fn SBTargetDeleteBreakpointName(instance: SBTargetRef, name: *const ::std::os::raw::c_char);
    pub fn SBTargetEnableAllBreakpoints(instance: SBTargetRef) -> bool;
    pub fn SBTargetDisableAllBreakpoints(instance: SBTargetRef) -> bool;
    pub fn SBTargetDeleteAllBreakpoints(instance: SBTargetRef) -> bool;
    pub fn SBTargetGetNumWatchpoints(instance: SBTargetRef) -> u32;
    pub fn SBTargetGetWatchpointAtIndex(instance: SBTargetRef, idx: u32) -> SBWatchpointRef;
    pub fn SBTargetDeleteWatchpoint(instance: SBTargetRef, watch_id: lldb_watch_id_t) -> bool;
    pub fn SBTargetFindWatchpointByID(
        instance: SBTargetRef,
        watch_id: lldb_watch_id_t,
    ) -> SBWatchpointRef;
    pub fn SBTargetWatchAddress(
        instance: SBTargetRef,
        addr: lldb_addr_t,
        size: size_t,
        read: bool,
        write: bool,
        error: SBErrorRef,
    ) -> SBWatchpointRef;
    pub fn SBTargetEnableAllWatchpoints(instance: SBTargetRef) -> bool;
    pub fn SBTargetDisableAllWatchpoints(instance: SBTargetRef) -> bool;
    pub fn SBTargetDeleteAllWatchpoints(instance: SBTargetRef) -> bool;
    pub fn SBTargetGetBroadcaster(instance: SBTargetRef) -> SBBroadcasterRef;
    pub fn SBTargetFindFirstType(
        instance: SBTargetRef,
        type_: *const ::std::os::raw::c_char,
    ) -> SBTypeRef;
    pub fn SBTargetFindTypes(
        instance: SBTargetRef,
        type_: *const ::std::os::raw::c_char,
    ) -> SBTypeListRef;
    pub fn SBTargetGetBasicType(instance: SBTargetRef, type_: BasicType) -> SBTypeRef;
    pub fn SBTargetCreateValueFromAddress(
        instance: SBTargetRef,
        name: *const ::std::os::raw::c_char,
        addr: SBAddressRef,
        type_: SBTypeRef,
    ) -> SBValueRef;
    pub fn SBTargetCreateValueFromData(
        instance: SBTargetRef,
        name: *const ::std::os::raw::c_char,
        data: SBDataRef,
        type_: SBTypeRef,
    ) -> SBValueRef;
    pub fn SBTargetCreateValueFromExpression(
        instance: SBTargetRef,
        name: *const ::std::os::raw::c_char,
        expr: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBTargetGetSourceManager(instance: SBTargetRef) -> SBSourceManagerRef;
    pub fn SBTargetReadInstructions(
        instance: SBTargetRef,
        base_addr: SBAddressRef,
        count: u32,
    ) -> SBInstructionListRef;
    pub fn SBTargetReadInstructions2(
        instance: SBTargetRef,
        base_addr: SBAddressRef,
        count: u32,
        flavor_string: *const ::std::os::raw::c_char,
    ) -> SBInstructionListRef;
    pub fn SBTargetGetInstructions(
        instance: SBTargetRef,
        base_addr: SBAddressRef,
        buf: *mut ::std::os::raw::c_void,
        size: size_t,
    ) -> SBInstructionListRef;
    pub fn SBTargetGetInstructionsWithFlavor(
        instance: SBTargetRef,
        base_addr: SBAddressRef,
        flavor_string: *const ::std::os::raw::c_char,
        buf: *mut ::std::os::raw::c_void,
        size: size_t,
    ) -> SBInstructionListRef;
    pub fn SBTargetGetInstructions2(
        instance: SBTargetRef,
        base_addr: lldb_addr_t,
        buf: *mut ::std::os::raw::c_void,
        size: size_t,
    ) -> SBInstructionListRef;
    pub fn SBTargetGetInstructionsWithFlavor2(
        instance: SBTargetRef,
        base_addr: lldb_addr_t,
        flavor_string: *const ::std::os::raw::c_char,
        buf: *mut ::std::os::raw::c_void,
        size: size_t,
    ) -> SBInstructionListRef;
    pub fn SBTargetFindSymbols(
        instance: SBTargetRef,
        name: *const ::std::os::raw::c_char,
        type_: SymbolType,
    ) -> SBSymbolContextListRef;
    pub fn SBTargetGetDescription(
        instance: SBTargetRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn SBTargetEvaluateExpression(
        instance: SBTargetRef,
        expr: *const ::std::os::raw::c_char,
        options: SBExpressionOptionsRef,
    ) -> SBValueRef;
    pub fn SBTargetGetStackRedZoneSize(instance: SBTargetRef) -> lldb_addr_t;
    pub fn SBTargetGetLaunchInfo(instance: SBTargetRef) -> SBLaunchInfoRef;
    pub fn SBTargetSetLaunchInfo(instance: SBTargetRef, launch_info: SBLaunchInfoRef);
    pub fn SBThreadGetBroadcasterClassName() -> *const ::std::os::raw::c_char;
    pub fn CreateSBThread() -> SBThreadRef;
    pub fn CloneSBThread(instance: SBThreadRef) -> SBThreadRef;
    pub fn DisposeSBThread(instance: SBThreadRef);
    pub fn SBThreadGetQueue(instance: SBThreadRef) -> SBQueueRef;
    pub fn SBThreadIsValid(instance: SBThreadRef) -> bool;
    pub fn SBThreadClear(instance: SBThreadRef);
    pub fn SBThreadGetStopReason(instance: SBThreadRef) -> StopReason;
    pub fn SBThreadGetStopReasonDataCount(instance: SBThreadRef) -> size_t;
    pub fn SBThreadGetStopReasonDataAtIndex(instance: SBThreadRef, idx: u32) -> u64;
    pub fn SBThreadGetStopReasonExtendedInfoAsJSON(
        instance: SBThreadRef,
        stream: SBStreamRef,
    ) -> bool;
    pub fn SBThreadGetStopReasonExtendedBacktraces(
        instance: SBThreadRef,
        type_: InstrumentationRuntimeType,
    ) -> SBThreadCollectionRef;
    pub fn SBThreadGetStopDescription(
        instance: SBThreadRef,
        dst: *mut ::std::os::raw::c_char,
        dst_len: size_t,
    ) -> size_t;
    pub fn SBThreadGetStopReturnValue(instance: SBThreadRef) -> SBValueRef;
    pub fn SBThreadGetThreadID(instance: SBThreadRef) -> lldb_tid_t;
    pub fn SBThreadGetIndexID(instance: SBThreadRef) -> u32;
    pub fn SBThreadGetName(instance: SBThreadRef) -> *const ::std::os::raw::c_char;
    pub fn SBThreadGetQueueName(instance: SBThreadRef) -> *const ::std::os::raw::c_char;
    pub fn SBThreadGetQueueID(instance: SBThreadRef) -> lldb_queue_id_t;
    pub fn SBThreadGetInfoItemByPathAsString(
        instance: SBThreadRef,
        path: *const ::std::os::raw::c_char,
        strm: SBStreamRef,
    ) -> bool;
    pub fn SBThreadStepOver(instance: SBThreadRef, stop_other_threads: RunMode, error: SBErrorRef);
    pub fn SBThreadStepInto(instance: SBThreadRef, stop_other_threads: RunMode);
    pub fn SBThreadStepInto2(
        instance: SBThreadRef,
        target_name: *const ::std::os::raw::c_char,
        stop_other_threads: RunMode,
    );
    pub fn SBThreadStepInto3(
        instance: SBThreadRef,
        target_name: *const ::std::os::raw::c_char,
        end_line: u32,
        error: SBErrorRef,
        stop_other_threads: RunMode,
    );
    pub fn SBThreadStepOut(instance: SBThreadRef, error: SBErrorRef);
    pub fn SBThreadStepOutOfFrame(instance: SBThreadRef, frame: SBFrameRef, error: SBErrorRef);
    pub fn SBThreadStepInstruction(instance: SBThreadRef, step_over: bool, error: SBErrorRef);
    pub fn SBThreadStepOverUntil(
        instance: SBThreadRef,
        frame: SBFrameRef,
        file_spec: SBFileSpecRef,
        line: u32,
    ) -> SBErrorRef;
    pub fn SBThreadStepUsingScriptedThreadPlan(
        instance: SBThreadRef,
        script_class_name: *const ::std::os::raw::c_char,
        args_data: SBStructuredDataRef,
        resume_immediately: bool,
    ) -> SBErrorRef;
    pub fn SBThreadJumpToLine(
        instance: SBThreadRef,
        file_spec: SBFileSpecRef,
        line: u32,
    ) -> SBErrorRef;
    pub fn SBThreadRunToAddress(instance: SBThreadRef, addr: lldb_addr_t, error: SBErrorRef);
    pub fn SBThreadReturnFromFrame(
        instance: SBThreadRef,
        frame: SBFrameRef,
        return_value: SBValueRef,
    ) -> SBErrorRef;
    pub fn SBThreadUnwindInnermostExpression(instance: SBThreadRef) -> SBErrorRef;
    pub fn SBThreadSuspend(instance: SBThreadRef, error: SBErrorRef) -> bool;
    pub fn SBThreadResume(instance: SBThreadRef, error: SBErrorRef) -> bool;
    pub fn SBThreadIsSuspended(instance: SBThreadRef) -> bool;
    pub fn SBThreadIsStopped(instance: SBThreadRef) -> bool;
    pub fn SBThreadGetNumFrames(instance: SBThreadRef) -> u32;
    pub fn SBThreadGetFrameAtIndex(instance: SBThreadRef, idx: u32) -> SBFrameRef;
    pub fn SBThreadGetSelectedFrame(instance: SBThreadRef) -> SBFrameRef;
    pub fn SBThreadSetSelectedFrame(instance: SBThreadRef, frame_idx: u32) -> SBFrameRef;
    pub fn SBThreadEventIsThreadEvent(event: SBEventRef) -> bool;
    pub fn SBThreadGetStackFrameFromEvent(event: SBEventRef) -> SBFrameRef;
    pub fn SBThreadGetThreadFromEvent(event: SBEventRef) -> SBThreadRef;
    pub fn SBThreadGetProcess(instance: SBThreadRef) -> SBProcessRef;
    pub fn SBThreadGetDescription(instance: SBThreadRef, description: SBStreamRef) -> bool;
    pub fn SBThreadGetStatus(instance: SBThreadRef, status: SBStreamRef) -> bool;
    pub fn SBThreadGetExtendedBacktraceThread(
        instance: SBThreadRef,
        type_: *const ::std::os::raw::c_char,
    ) -> SBThreadRef;
    pub fn SBThreadGetExtendedBacktraceOriginatingIndexID(instance: SBThreadRef) -> u32;
    pub fn SBThreadGetCurrentException(instance: SBThreadRef) -> SBValueRef;
    pub fn SBThreadGetCurrentExceptionBacktrace(instance: SBThreadRef) -> SBThreadRef;
    pub fn SBThreadSafeToCallFunctions(instance: SBThreadRef) -> bool;
    pub fn CreateSBThreadCollection() -> SBThreadCollectionRef;
    pub fn CloneSBThreadCollection(instance: SBThreadCollectionRef) -> SBThreadCollectionRef;
    pub fn DisposeSBThreadCollection(instance: SBThreadCollectionRef);
    pub fn SBThreadCollectionIsValid(instance: SBThreadCollectionRef) -> bool;
    pub fn SBThreadCollectionGetSize(instance: SBThreadCollectionRef) -> size_t;
    pub fn SBThreadCollectionGetThreadAtIndex(
        instance: SBThreadCollectionRef,
        idx: size_t,
    ) -> SBThreadRef;
    pub fn CreateSBThreadPlan() -> SBThreadPlanRef;
    pub fn CreateSBThreadPlan2(
        thread: SBThreadRef,
        class_name: *const ::std::os::raw::c_char,
    ) -> SBThreadPlanRef;
    pub fn CloneSBThreadPlan(instance: SBThreadPlanRef) -> SBThreadPlanRef;
    pub fn DisposeSBThreadPlan(instance: SBThreadPlanRef);
    pub fn SBThreadPlanIsValid(instance: SBThreadPlanRef) -> bool;
    pub fn SBThreadPlanClear(instance: SBThreadPlanRef);
    pub fn SBThreadPlanGetStopReason(instance: SBThreadPlanRef) -> StopReason;
    pub fn SBThreadPlanGetStopReasonDataCount(instance: SBThreadPlanRef) -> size_t;
    pub fn SBThreadPlanGetStopReasonDataAtIndex(instance: SBThreadPlanRef, idx: u32) -> u64;
    pub fn SBThreadPlanGetThread(instance: SBThreadPlanRef) -> SBThreadRef;
    pub fn SBThreadPlanGetDescription(instance: SBThreadPlanRef, description: SBStreamRef) -> bool;
    pub fn SBThreadPlanSetPlanComplete(instance: SBThreadPlanRef, success: bool);
    pub fn SBThreadPlanIsPlanComplete(instance: SBThreadPlanRef) -> bool;
    pub fn SBThreadPlanIsPlanStale(instance: SBThreadPlanRef) -> bool;
    pub fn SBThreadPlanQueueThreadPlanForStepOverRange(
        instance: SBThreadPlanRef,
        start_address: SBAddressRef,
        range_size: lldb_addr_t,
        error: SBErrorRef,
    ) -> SBThreadPlanRef;
    pub fn SBThreadPlanQueueThreadPlanForStepInRange(
        instance: SBThreadPlanRef,
        start_address: SBAddressRef,
        range_size: lldb_addr_t,
        error: SBErrorRef,
    ) -> SBThreadPlanRef;
    pub fn SBThreadPlanQueueThreadPlanForStepOut(
        instance: SBThreadPlanRef,
        frame_idx_to_step_to: u32,
        first_insn: bool,
        error: SBErrorRef,
    ) -> SBThreadPlanRef;
    pub fn SBThreadPlanQueueThreadPlanForRunToAddress(
        instance: SBThreadPlanRef,
        address: SBAddressRef,
        error: SBErrorRef,
    ) -> SBThreadPlanRef;
    pub fn SBThreadPlanQueueThreadPlanForStepScripted(
        instance: SBThreadPlanRef,
        script_class_name: *const ::std::os::raw::c_char,
        args_data: SBStructuredDataRef,
        error: SBErrorRef,
    ) -> SBThreadPlanRef;
    pub fn CreateSBTypeMember() -> SBTypeMemberRef;
    pub fn CloneSBTypeMember(instance: SBTypeMemberRef) -> SBTypeMemberRef;
    pub fn DisposeSBTypeMember(instance: SBTypeMemberRef);
    pub fn SBTypeMemberIsValid(instance: SBTypeMemberRef) -> bool;
    pub fn SBTypeMemberGetName(instance: SBTypeMemberRef) -> *const ::std::os::raw::c_char;
    pub fn SBTypeMemberGetType(instance: SBTypeMemberRef) -> SBTypeRef;
    pub fn SBTypeMemberGetOffsetInBytes(instance: SBTypeMemberRef) -> u64;
    pub fn SBTypeMemberGetOffsetInBits(instance: SBTypeMemberRef) -> u64;
    pub fn SBTypeMemberIsBitfield(instance: SBTypeMemberRef) -> bool;
    pub fn SBTypeMemberGetBitfieldSizeInBits(instance: SBTypeMemberRef) -> u32;
    pub fn SBTypeMemberGetDescription(
        instance: SBTypeMemberRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn CreateSBTypeMemberFunction() -> SBTypeMemberFunctionRef;
    pub fn CloneSBTypeMemberFunction(instance: SBTypeMemberFunctionRef) -> SBTypeMemberFunctionRef;
    pub fn DisposeSBTypeMemberFunction(instance: SBTypeMemberFunctionRef);
    pub fn SBTypeMemberFunctionIsValid(instance: SBTypeMemberFunctionRef) -> bool;
    pub fn SBTypeMemberFunctionGetName(
        instance: SBTypeMemberFunctionRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBTypeMemberFunctionGetType(instance: SBTypeMemberFunctionRef) -> SBTypeRef;
    pub fn SBTypeMemberFunctionGetReturnType(instance: SBTypeMemberFunctionRef) -> SBTypeRef;
    pub fn SBTypeMemberFunctionGetNumberOfArguments(instance: SBTypeMemberFunctionRef) -> u32;
    pub fn SBTypeMemberFunctionGetArgumentTypeAtIndex(
        instance: SBTypeMemberFunctionRef,
        arg1: u32,
    ) -> SBTypeRef;
    pub fn SBTypeMemberFunctionGetKind(instance: SBTypeMemberFunctionRef) -> MemberFunctionKind;
    pub fn SBTypeMemberFunctionGetDescription(
        instance: SBTypeMemberFunctionRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn CreateSBType() -> SBTypeRef;
    pub fn CloneSBType(instance: SBTypeRef) -> SBTypeRef;
    pub fn DisposeSBType(instance: SBTypeRef);
    pub fn SBTypeIsValid(instance: SBTypeRef) -> bool;
    pub fn SBTypeGetByteSize(instance: SBTypeRef) -> u64;
    pub fn SBTypeIsPointerType(instance: SBTypeRef) -> bool;
    pub fn SBTypeIsReferenceType(instance: SBTypeRef) -> bool;
    pub fn SBTypeIsFunctionType(instance: SBTypeRef) -> bool;
    pub fn SBTypeIsPolymorphicClass(instance: SBTypeRef) -> bool;
    pub fn SBTypeIsArrayType(instance: SBTypeRef) -> bool;
    pub fn SBTypeIsVectorType(instance: SBTypeRef) -> bool;
    pub fn SBTypeIsTypedefType(instance: SBTypeRef) -> bool;
    pub fn SBTypeGetPointerType(instance: SBTypeRef) -> SBTypeRef;
    pub fn SBTypeGetPointeeType(instance: SBTypeRef) -> SBTypeRef;
    pub fn SBTypeGetReferenceType(instance: SBTypeRef) -> SBTypeRef;
    pub fn SBTypeGetTypedefedType(instance: SBTypeRef) -> SBTypeRef;
    pub fn SBTypeGetDereferencedType(instance: SBTypeRef) -> SBTypeRef;
    pub fn SBTypeGetUnqualifiedType(instance: SBTypeRef) -> SBTypeRef;
    pub fn SBTypeGetArrayElementType(instance: SBTypeRef) -> SBTypeRef;
    pub fn SBTypeGetArrayType(instance: SBTypeRef, size: u64) -> SBTypeRef;
    pub fn SBTypeGetVectorElementType(instance: SBTypeRef) -> SBTypeRef;
    pub fn SBTypeGetCanonicalType(instance: SBTypeRef) -> SBTypeRef;
    pub fn SBTypeGetBasicType(instance: SBTypeRef) -> BasicType;
    pub fn SBTypeGetBasicType2(instance: SBTypeRef, type_: BasicType) -> SBTypeRef;
    pub fn SBTypeGetNumberOfFields(instance: SBTypeRef) -> u32;
    pub fn SBTypeGetNumberOfDirectBaseClasses(instance: SBTypeRef) -> u32;
    pub fn SBTypeGetNumberOfVirtualBaseClasses(instance: SBTypeRef) -> u32;
    pub fn SBTypeGetFieldAtIndex(instance: SBTypeRef, idx: u32) -> SBTypeMemberRef;
    pub fn SBTypeGetDirectBaseClassAtIndex(instance: SBTypeRef, idx: u32) -> SBTypeMemberRef;
    pub fn SBTypeGetVirtualBaseClassAtIndex(instance: SBTypeRef, idx: u32) -> SBTypeMemberRef;
    pub fn SBTypeGetEnumMembers(instance: SBTypeRef) -> SBTypeEnumMemberListRef;
    pub fn SBTypeGetNumberOfTemplateArguments(instance: SBTypeRef) -> u32;
    pub fn SBTypeGetTemplateArgumentType(instance: SBTypeRef, idx: u32) -> SBTypeRef;
    pub fn SBTypeGetTemplateArgumentKind(instance: SBTypeRef, idx: u32) -> TemplateArgumentKind;
    pub fn SBTypeGetFunctionReturnType(instance: SBTypeRef) -> SBTypeRef;
    pub fn SBTypeGetFunctionArgumentTypes(instance: SBTypeRef) -> SBTypeListRef;
    pub fn SBTypeGetNumberOfMemberFunctions(instance: SBTypeRef) -> u32;
    pub fn SBTypeGetMemberFunctionAtIndex(instance: SBTypeRef, idx: u32)
        -> SBTypeMemberFunctionRef;
    pub fn SBTypeGetName(instance: SBTypeRef) -> *const ::std::os::raw::c_char;
    pub fn SBTypeGetDisplayTypeName(instance: SBTypeRef) -> *const ::std::os::raw::c_char;
    pub fn SBTypeGetTypeClass(instance: SBTypeRef) -> u32;
    pub fn SBTypeIsTypeComplete(instance: SBTypeRef) -> bool;
    pub fn SBTypeGetTypeFlags(instance: SBTypeRef) -> u32;
    pub fn SBTypeGetDescription(
        instance: SBTypeRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn CreateSBTypeList() -> SBTypeListRef;
    pub fn CloneSBTypeList(instance: SBTypeListRef) -> SBTypeListRef;
    pub fn DisposeSBTypeList(instance: SBTypeListRef);
    pub fn SBTypeListIsValid(instance: SBTypeListRef) -> bool;
    pub fn SBTypeListAppend(instance: SBTypeListRef, type_: SBTypeRef);
    pub fn SBTypeListGetTypeAtIndex(instance: SBTypeListRef, index: u32) -> SBTypeRef;
    pub fn SBTypeListGetSize(instance: SBTypeListRef) -> u32;
    pub fn CreateSBTypeCategory() -> SBTypeCategoryRef;
    pub fn CloneSBTypeCategory(instance: SBTypeCategoryRef) -> SBTypeCategoryRef;
    pub fn DisposeSBTypeCategory(instance: SBTypeCategoryRef);
    pub fn SBTypeCategoryIsValid(instance: SBTypeCategoryRef) -> bool;
    pub fn SBTypeCategoryGetEnabled(instance: SBTypeCategoryRef) -> bool;
    pub fn SBTypeCategorySetEnabled(instance: SBTypeCategoryRef, arg1: bool);
    pub fn SBTypeCategoryGetName(instance: SBTypeCategoryRef) -> *const ::std::os::raw::c_char;
    pub fn SBTypeCategoryGetLanguageAtIndex(
        instance: SBTypeCategoryRef,
        index: u32,
    ) -> LanguageType;
    pub fn SBTypeCategoryGetNumLanguages(instance: SBTypeCategoryRef) -> u32;
    pub fn SBTypeCategoryAddLanguage(instance: SBTypeCategoryRef, language: LanguageType);
    pub fn SBTypeCategoryGetDescription(
        instance: SBTypeCategoryRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn SBTypeCategoryGetNumFormats(instance: SBTypeCategoryRef) -> u32;
    pub fn SBTypeCategoryGetNumSummaries(instance: SBTypeCategoryRef) -> u32;
    pub fn SBTypeCategoryGetNumFilters(instance: SBTypeCategoryRef) -> u32;
    pub fn SBTypeCategoryGetNumSynthetics(instance: SBTypeCategoryRef) -> u32;
    pub fn SBTypeCategoryGetTypeNameSpecifierForFilterAtIndex(
        instance: SBTypeCategoryRef,
        arg1: u32,
    ) -> SBTypeNameSpecifierRef;
    pub fn SBTypeCategoryGetTypeNameSpecifierForFormatAtIndex(
        instance: SBTypeCategoryRef,
        arg1: u32,
    ) -> SBTypeNameSpecifierRef;
    pub fn SBTypeCategoryGetTypeNameSpecifierForSummaryAtIndex(
        instance: SBTypeCategoryRef,
        arg1: u32,
    ) -> SBTypeNameSpecifierRef;
    pub fn SBTypeCategoryGetTypeNameSpecifierForSyntheticAtIndex(
        instance: SBTypeCategoryRef,
        arg1: u32,
    ) -> SBTypeNameSpecifierRef;
    pub fn SBTypeCategoryGetFilterForType(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> SBTypeFilterRef;
    pub fn SBTypeCategoryGetFormatForType(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> SBTypeFormatRef;
    pub fn SBTypeCategoryGetSummaryForType(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> SBTypeSummaryRef;
    pub fn SBTypeCategoryGetSyntheticForType(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> SBTypeSyntheticRef;
    pub fn SBTypeCategoryGetFilterAtIndex(
        instance: SBTypeCategoryRef,
        arg1: u32,
    ) -> SBTypeFilterRef;
    pub fn SBTypeCategoryGetFormatAtIndex(
        instance: SBTypeCategoryRef,
        arg1: u32,
    ) -> SBTypeFormatRef;
    pub fn SBTypeCategoryGetSummaryAtIndex(
        instance: SBTypeCategoryRef,
        arg1: u32,
    ) -> SBTypeSummaryRef;
    pub fn SBTypeCategoryGetSyntheticAtIndex(
        instance: SBTypeCategoryRef,
        arg1: u32,
    ) -> SBTypeSyntheticRef;
    pub fn SBTypeCategoryAddTypeFormat(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
        arg2: SBTypeFormatRef,
    ) -> bool;
    pub fn SBTypeCategoryDeleteTypeFormat(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> bool;
    pub fn SBTypeCategoryAddTypeSummary(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
        arg2: SBTypeSummaryRef,
    ) -> bool;
    pub fn SBTypeCategoryDeleteTypeSummary(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> bool;
    pub fn SBTypeCategoryAddTypeFilter(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
        arg2: SBTypeFilterRef,
    ) -> bool;
    pub fn SBTypeCategoryDeleteTypeFilter(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> bool;
    pub fn SBTypeCategoryAddTypeSynthetic(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
        arg2: SBTypeSyntheticRef,
    ) -> bool;
    pub fn SBTypeCategoryDeleteTypeSynthetic(
        instance: SBTypeCategoryRef,
        arg1: SBTypeNameSpecifierRef,
    ) -> bool;
    pub fn CreateSBTypeEnumMember() -> SBTypeEnumMemberRef;
    pub fn CloneSBTypeEnumMember(instance: SBTypeEnumMemberRef) -> SBTypeEnumMemberRef;
    pub fn DisposeSBTypeEnumMember(instance: SBTypeEnumMemberRef);
    pub fn SBTypeEnumMemberIsValid(instance: SBTypeEnumMemberRef) -> bool;
    pub fn SBTypeEnumMemberGetValueAsSigned(instance: SBTypeEnumMemberRef) -> i64;
    pub fn SBTypeEnumMemberGetValueAsUnsigned(instance: SBTypeEnumMemberRef) -> u64;
    pub fn SBTypeEnumMemberGetName(instance: SBTypeEnumMemberRef) -> *const ::std::os::raw::c_char;
    pub fn SBTypeEnumMemberGetType(instance: SBTypeEnumMemberRef) -> SBTypeRef;
    pub fn SBTypeEnumMemberGetDescription(
        instance: SBTypeEnumMemberRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn CreateSBTypeEnumMemberList() -> SBTypeEnumMemberListRef;
    pub fn CloneSBTypeEnumMemberList(instance: SBTypeEnumMemberListRef) -> SBTypeEnumMemberListRef;
    pub fn DisposeSBTypeEnumMemberList(instance: SBTypeEnumMemberListRef);
    pub fn SBTypeEnumMemberListIsValid(instance: SBTypeEnumMemberListRef) -> bool;
    pub fn SBTypeEnumMemberListAppend(
        instance: SBTypeEnumMemberListRef,
        entry: SBTypeEnumMemberRef,
    );
    pub fn SBTypeEnumMemberListGetTypeEnumMemberAtIndex(
        instance: SBTypeEnumMemberListRef,
        index: u32,
    ) -> SBTypeEnumMemberRef;
    pub fn SBTypeEnumMemberListGetSize(instance: SBTypeEnumMemberListRef) -> u32;
    pub fn CreateSBTypeFilter() -> SBTypeFilterRef;
    pub fn CreateSBTypeFilter2(options: u32) -> SBTypeFilterRef;
    pub fn CloneSBTypeFilter(instance: SBTypeFilterRef) -> SBTypeFilterRef;
    pub fn DisposeSBTypeFilter(instance: SBTypeFilterRef);
    pub fn SBTypeFilterIsValid(instance: SBTypeFilterRef) -> bool;
    pub fn SBTypeFilterGetNumberOfExpressionPaths(instance: SBTypeFilterRef) -> u32;
    pub fn SBTypeFilterGetExpressionPathAtIndex(
        instance: SBTypeFilterRef,
        i: u32,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBTypeFilterReplaceExpressionPathAtIndex(
        instance: SBTypeFilterRef,
        i: u32,
        item: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBTypeFilterAppendExpressionPath(
        instance: SBTypeFilterRef,
        item: *const ::std::os::raw::c_char,
    );
    pub fn SBTypeFilterClear(instance: SBTypeFilterRef);
    pub fn SBTypeFilterGetOptions(instance: SBTypeFilterRef) -> u32;
    pub fn SBTypeFilterSetOptions(instance: SBTypeFilterRef, arg1: u32);
    pub fn SBTypeFilterGetDescription(
        instance: SBTypeFilterRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn SBTypeFilterIsEqualTo(instance: SBTypeFilterRef, rhs: SBTypeFilterRef) -> bool;
    pub fn CreateSBTypeFormat() -> SBTypeFormatRef;
    pub fn CreateSBTypeFormat2(format: Format, options: u32) -> SBTypeFormatRef;
    pub fn CreateSBTypeFormat3(
        type_: *const ::std::os::raw::c_char,
        options: u32,
    ) -> SBTypeFormatRef;
    pub fn CloneSBTypeFormat(instance: SBTypeFormatRef) -> SBTypeFormatRef;
    pub fn DisposeSBTypeFormat(instance: SBTypeFormatRef);
    pub fn SBTypeFormatIsValid(instance: SBTypeFormatRef) -> bool;
    pub fn SBTypeFormatGetFormat(instance: SBTypeFormatRef) -> Format;
    pub fn SBTypeFormatGetTypeName(instance: SBTypeFormatRef) -> *const ::std::os::raw::c_char;
    pub fn SBTypeFormatGetOptions(instance: SBTypeFormatRef) -> u32;
    pub fn SBTypeFormatSetFormat(instance: SBTypeFormatRef, arg1: Format);
    pub fn SBTypeFormatSetTypeName(instance: SBTypeFormatRef, arg1: *const ::std::os::raw::c_char);
    pub fn SBTypeFormatSetOptions(instance: SBTypeFormatRef, arg1: u32);
    pub fn SBTypeFormatGetDescription(
        instance: SBTypeFormatRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn SBTypeFormatIsEqualTo(instance: SBTypeFormatRef, rhs: SBTypeFormatRef) -> bool;
    pub fn CreateSBTypeNameSpecifier() -> SBTypeNameSpecifierRef;
    pub fn CreateSBTypeNameSpecifier2(
        name: *const ::std::os::raw::c_char,
        is_regex: bool,
    ) -> SBTypeNameSpecifierRef;
    pub fn CreateSBTypeNameSpecifier3(type_: SBTypeRef) -> SBTypeNameSpecifierRef;
    pub fn CloneSBTypeNameSpecifier(instance: SBTypeNameSpecifierRef) -> SBTypeNameSpecifierRef;
    pub fn DisposeSBTypeNameSpecifier(instance: SBTypeNameSpecifierRef);
    pub fn SBTypeNameSpecifierIsValid(instance: SBTypeNameSpecifierRef) -> bool;
    pub fn SBTypeNameSpecifierGetName(
        instance: SBTypeNameSpecifierRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBTypeNameSpecifierGetType(instance: SBTypeNameSpecifierRef) -> SBTypeRef;
    pub fn SBTypeNameSpecifierIsRegex(instance: SBTypeNameSpecifierRef) -> bool;
    pub fn SBTypeNameSpecifierGetDescription(
        instance: SBTypeNameSpecifierRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn SBTypeNameSpecifierIsEqualTo(
        instance: SBTypeNameSpecifierRef,
        rhs: SBTypeNameSpecifierRef,
    ) -> bool;
    pub fn CreateSBTypeSummaryOptions() -> SBTypeSummaryOptionsRef;
    pub fn CloneSBTypeSummaryOptions(instance: SBTypeSummaryOptionsRef) -> SBTypeSummaryOptionsRef;
    pub fn DisposeSBTypeSummaryOptions(instance: SBTypeSummaryOptionsRef);
    pub fn SBTypeSummaryOptionsIsValid(instance: SBTypeSummaryOptionsRef) -> bool;
    pub fn SBTypeSummaryOptionsGetLanguage(instance: SBTypeSummaryOptionsRef) -> LanguageType;
    pub fn SBTypeSummaryOptionsGetCapping(instance: SBTypeSummaryOptionsRef) -> TypeSummaryCapping;
    pub fn SBTypeSummaryOptionsSetLanguage(instance: SBTypeSummaryOptionsRef, arg1: LanguageType);
    pub fn SBTypeSummaryOptionsSetCapping(
        instance: SBTypeSummaryOptionsRef,
        arg1: TypeSummaryCapping,
    );
    pub fn CreateSBTypeSummary() -> SBTypeSummaryRef;
    pub fn SBTypeSummaryCreateWithSummaryString(
        data: *const ::std::os::raw::c_char,
        options: u32,
    ) -> SBTypeSummaryRef;
    pub fn SBTypeSummaryCreateWithFunctionName(
        data: *const ::std::os::raw::c_char,
        options: u32,
    ) -> SBTypeSummaryRef;
    pub fn SBTypeSummaryCreateWithScriptCode(
        data: *const ::std::os::raw::c_char,
        options: u32,
    ) -> SBTypeSummaryRef;
    pub fn CloneSBTypeSummary(instance: SBTypeSummaryRef) -> SBTypeSummaryRef;
    pub fn DisposeSBTypeSummary(instance: SBTypeSummaryRef);
    pub fn SBTypeSummaryIsValid(instance: SBTypeSummaryRef) -> bool;
    pub fn SBTypeSummaryIsFunctionCode(instance: SBTypeSummaryRef) -> bool;
    pub fn SBTypeSummaryIsFunctionName(instance: SBTypeSummaryRef) -> bool;
    pub fn SBTypeSummaryIsSummaryString(instance: SBTypeSummaryRef) -> bool;
    pub fn SBTypeSummaryGetData(instance: SBTypeSummaryRef) -> *const ::std::os::raw::c_char;
    pub fn SBTypeSummarySetSummaryString(
        instance: SBTypeSummaryRef,
        data: *const ::std::os::raw::c_char,
    );
    pub fn SBTypeSummarySetFunctionName(
        instance: SBTypeSummaryRef,
        data: *const ::std::os::raw::c_char,
    );
    pub fn SBTypeSummarySetFunctionCode(
        instance: SBTypeSummaryRef,
        data: *const ::std::os::raw::c_char,
    );
    pub fn SBTypeSummaryGetOptions(instance: SBTypeSummaryRef) -> u32;
    pub fn SBTypeSummarySetOptions(instance: SBTypeSummaryRef, arg1: u32);
    pub fn SBTypeSummaryGetDescription(
        instance: SBTypeSummaryRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn SBTypeSummaryIsEqualTo(instance: SBTypeSummaryRef, rhs: SBTypeSummaryRef) -> bool;
    pub fn CreateSBTypeSynthetic() -> SBTypeSyntheticRef;
    pub fn SBTypeSyntheticCreateWithClassName(
        data: *const ::std::os::raw::c_char,
        options: u32,
    ) -> SBTypeSyntheticRef;
    pub fn SBTypeSyntheticCreateWithScriptCode(
        data: *const ::std::os::raw::c_char,
        options: u32,
    ) -> SBTypeSyntheticRef;
    pub fn CloneSBTypeSynthetic(instance: SBTypeSyntheticRef) -> SBTypeSyntheticRef;
    pub fn DisposeSBTypeSynthetic(instance: SBTypeSyntheticRef);
    pub fn SBTypeSyntheticIsValid(instance: SBTypeSyntheticRef) -> bool;
    pub fn SBTypeSyntheticIsClassCode(instance: SBTypeSyntheticRef) -> bool;
    pub fn SBTypeSyntheticIsClassName(instance: SBTypeSyntheticRef) -> bool;
    pub fn SBTypeSyntheticGetData(instance: SBTypeSyntheticRef) -> *const ::std::os::raw::c_char;
    pub fn SBTypeSyntheticSetClassName(
        instance: SBTypeSyntheticRef,
        data: *const ::std::os::raw::c_char,
    );
    pub fn SBTypeSyntheticSetClassCode(
        instance: SBTypeSyntheticRef,
        data: *const ::std::os::raw::c_char,
    );
    pub fn SBTypeSyntheticGetOptions(instance: SBTypeSyntheticRef) -> u32;
    pub fn SBTypeSyntheticSetOptions(instance: SBTypeSyntheticRef, arg1: u32);
    pub fn SBTypeSyntheticGetDescription(
        instance: SBTypeSyntheticRef,
        description: SBStreamRef,
        description_level: DescriptionLevel,
    ) -> bool;
    pub fn SBTypeSyntheticIsEqualTo(instance: SBTypeSyntheticRef, rhs: SBTypeSyntheticRef) -> bool;
    pub fn CreateSBUnixSignals() -> SBUnixSignalsRef;
    pub fn CloneSBUnixSignals(instance: SBUnixSignalsRef) -> SBUnixSignalsRef;
    pub fn DisposeSBUnixSignals(instance: SBUnixSignalsRef);
    pub fn SBUnixSignalsClear(instance: SBUnixSignalsRef);
    pub fn SBUnixSignalsIsValid(instance: SBUnixSignalsRef) -> bool;
    pub fn SBUnixSignalsGetSignalAsCString(
        instance: SBUnixSignalsRef,
        signo: i32,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBUnixSignalsGetSignalNumberFromName(
        instance: SBUnixSignalsRef,
        name: *const ::std::os::raw::c_char,
    ) -> i32;
    pub fn SBUnixSignalsGetShouldSuppress(instance: SBUnixSignalsRef, signo: i32) -> bool;
    pub fn SBUnixSignalsSetShouldSuppress(
        instance: SBUnixSignalsRef,
        signo: i32,
        value: bool,
    ) -> bool;
    pub fn SBUnixSignalsGetShouldStop(instance: SBUnixSignalsRef, signo: i32) -> bool;
    pub fn SBUnixSignalsSetShouldStop(instance: SBUnixSignalsRef, signo: i32, value: bool) -> bool;
    pub fn SBUnixSignalsGetShouldNotify(instance: SBUnixSignalsRef, signo: i32) -> bool;
    pub fn SBUnixSignalsSetShouldNotify(
        instance: SBUnixSignalsRef,
        signo: i32,
        value: bool,
    ) -> bool;
    pub fn SBUnixSignalsGetNumSignals(instance: SBUnixSignalsRef) -> i32;
    pub fn SBUnixSignalsGetSignalAtIndex(instance: SBUnixSignalsRef, index: i32) -> i32;
    pub fn CreateSBValue() -> SBValueRef;
    pub fn CloneSBValue(instance: SBValueRef) -> SBValueRef;
    pub fn DisposeSBValue(instance: SBValueRef);
    pub fn SBValueIsValid(instance: SBValueRef) -> bool;
    pub fn SBValueClear(instance: SBValueRef);
    pub fn SBValueGetError(instance: SBValueRef) -> SBErrorRef;
    pub fn SBValueGetID(instance: SBValueRef) -> lldb_user_id_t;
    pub fn SBValueGetName(instance: SBValueRef) -> *const ::std::os::raw::c_char;
    pub fn SBValueGetTypeName(instance: SBValueRef) -> *const ::std::os::raw::c_char;
    pub fn SBValueGetDisplayTypeName(instance: SBValueRef) -> *const ::std::os::raw::c_char;
    pub fn SBValueGetByteSize(instance: SBValueRef) -> size_t;
    pub fn SBValueIsInScope(instance: SBValueRef) -> bool;
    pub fn SBValueGetFormat(instance: SBValueRef) -> Format;
    pub fn SBValueSetFormat(instance: SBValueRef, format: Format);
    pub fn SBValueGetValue(instance: SBValueRef) -> *const ::std::os::raw::c_char;
    pub fn SBValueGetValueAsSigned(instance: SBValueRef, error: SBErrorRef, fail_value: i64)
        -> i64;
    pub fn SBValueGetValueAsUnsigned(
        instance: SBValueRef,
        error: SBErrorRef,
        fail_value: u64,
    ) -> u64;
    pub fn SBValueGetValueAsSigned2(instance: SBValueRef, fail_value: i64) -> i64;
    pub fn SBValueGetValueAsUnsigned2(instance: SBValueRef, fail_value: u64) -> u64;
    pub fn SBValueGetValueType(instance: SBValueRef) -> ValueType;
    pub fn SBValueGetValueDidChange(instance: SBValueRef) -> bool;
    pub fn SBValueGetSummary(instance: SBValueRef) -> *const ::std::os::raw::c_char;
    pub fn SBValueGetSummary2(
        instance: SBValueRef,
        stream: SBStreamRef,
        options: SBTypeSummaryOptionsRef,
    ) -> *const ::std::os::raw::c_char;
    pub fn SBValueGetObjectDescription(instance: SBValueRef) -> *const ::std::os::raw::c_char;
    pub fn SBValueGetDynamicValue(
        instance: SBValueRef,
        use_dynamic: DynamicValueType,
    ) -> SBValueRef;
    pub fn SBValueGetStaticValue(instance: SBValueRef) -> SBValueRef;
    pub fn SBValueGetNonSyntheticValue(instance: SBValueRef) -> SBValueRef;
    pub fn SBValueGetPreferDynamicValue(instance: SBValueRef) -> DynamicValueType;
    pub fn SBValueSetPreferDynamicValue(instance: SBValueRef, use_dynamic: DynamicValueType);
    pub fn SBValueGetPreferSyntheticValue(instance: SBValueRef) -> bool;
    pub fn SBValueSetPreferSyntheticValue(instance: SBValueRef, use_synthetic: bool);
    pub fn SBValueIsDynamic(instance: SBValueRef) -> bool;
    pub fn SBValueIsSynthetic(instance: SBValueRef) -> bool;
    pub fn SBValueIsSyntheticChildrenGenerated(instance: SBValueRef) -> bool;
    pub fn SBValueSetSyntheticChildrenGenerated(instance: SBValueRef, b: bool);
    pub fn SBValueGetLocation(instance: SBValueRef) -> *const ::std::os::raw::c_char;
    pub fn SBValueSetValueFromCString(
        instance: SBValueRef,
        value_str: *const ::std::os::raw::c_char,
    ) -> bool;
    pub fn SBValueSetValueFromCString2(
        instance: SBValueRef,
        value_str: *const ::std::os::raw::c_char,
        error: SBErrorRef,
    ) -> bool;
    pub fn SBValueGetTypeFormat(instance: SBValueRef) -> SBTypeFormatRef;
    pub fn SBValueGetTypeSummary(instance: SBValueRef) -> SBTypeSummaryRef;
    pub fn SBValueGetTypeFilter(instance: SBValueRef) -> SBTypeFilterRef;
    pub fn SBValueGetTypeSynthetic(instance: SBValueRef) -> SBTypeSyntheticRef;
    pub fn SBValueGetChildAtIndex(instance: SBValueRef, idx: u32) -> SBValueRef;
    pub fn SBValueCreateChildAtOffset(
        instance: SBValueRef,
        name: *const ::std::os::raw::c_char,
        offset: u32,
        type_: SBTypeRef,
    ) -> SBValueRef;
    pub fn SBValueCast(instance: SBValueRef, type_: SBTypeRef) -> SBValueRef;
    pub fn SBValueCreateValueFromExpression(
        instance: SBValueRef,
        name: *const ::std::os::raw::c_char,
        expression: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBValueCreateValueFromExpression2(
        instance: SBValueRef,
        name: *const ::std::os::raw::c_char,
        expression: *const ::std::os::raw::c_char,
        options: SBExpressionOptionsRef,
    ) -> SBValueRef;
    pub fn SBValueCreateValueFromAddress(
        instance: SBValueRef,
        name: *const ::std::os::raw::c_char,
        address: lldb_addr_t,
        type_: SBTypeRef,
    ) -> SBValueRef;
    pub fn SBValueCreateValueFromData(
        instance: SBValueRef,
        name: *const ::std::os::raw::c_char,
        data: SBDataRef,
        type_: SBTypeRef,
    ) -> SBValueRef;
    pub fn SBValueGetChildAtIndex2(
        instance: SBValueRef,
        idx: u32,
        use_dynamic: DynamicValueType,
        can_create_synthetic: bool,
    ) -> SBValueRef;
    pub fn SBValueGetIndexOfChildWithName(
        instance: SBValueRef,
        name: *const ::std::os::raw::c_char,
    ) -> u32;
    pub fn SBValueGetChildMemberWithName(
        instance: SBValueRef,
        name: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBValueGetChildMemberWithName2(
        instance: SBValueRef,
        name: *const ::std::os::raw::c_char,
        use_dynamic: DynamicValueType,
    ) -> SBValueRef;
    pub fn SBValueGetValueForExpressionPath(
        instance: SBValueRef,
        expr_path: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBValueAddressOf(instance: SBValueRef) -> SBValueRef;
    pub fn SBValueGetLoadAddress(instance: SBValueRef) -> lldb_addr_t;
    pub fn SBValueGetAddress(instance: SBValueRef) -> SBAddressRef;
    pub fn SBValueGetPointeeData(instance: SBValueRef, item_idx: u32, item_count: u32)
        -> SBDataRef;
    pub fn SBValueGetData(instance: SBValueRef) -> SBDataRef;
    pub fn SBValueSetData(instance: SBValueRef, data: SBDataRef, error: SBErrorRef) -> bool;
    pub fn SBValueGetDeclaration(instance: SBValueRef) -> SBDeclarationRef;
    pub fn SBValueMightHaveChildren(instance: SBValueRef) -> bool;
    pub fn SBValueIsRuntimeSupportValue(instance: SBValueRef) -> bool;
    pub fn SBValueGetNumChildren(instance: SBValueRef) -> u32;
    pub fn SBValueGetOpaqueType(instance: SBValueRef) -> *mut ::std::os::raw::c_void;
    pub fn SBValueGetTarget(instance: SBValueRef) -> SBTargetRef;
    pub fn SBValueGetProcess(instance: SBValueRef) -> SBProcessRef;
    pub fn SBValueGetThread(instance: SBValueRef) -> SBThreadRef;
    pub fn SBValueGetFrame(instance: SBValueRef) -> SBFrameRef;
    pub fn SBValueDereference(instance: SBValueRef) -> SBValueRef;
    pub fn SBValueTypeIsPointerType(instance: SBValueRef) -> bool;
    pub fn SBValueGetType(instance: SBValueRef) -> SBTypeRef;
    pub fn SBValuePersist(instance: SBValueRef) -> SBValueRef;
    pub fn SBValueGetDescription(instance: SBValueRef, description: SBStreamRef) -> bool;
    pub fn SBValueGetExpressionPath(instance: SBValueRef, description: SBStreamRef) -> bool;
    pub fn SBValueGetExpressionPath2(
        instance: SBValueRef,
        description: SBStreamRef,
        qualify_cxx_base_classes: bool,
    ) -> bool;
    pub fn SBValueEvaluateExpression(
        instance: SBValueRef,
        expr: *const ::std::os::raw::c_char,
        options: SBExpressionOptionsRef,
        name: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBValueWatch(
        instance: SBValueRef,
        resolve_location: bool,
        read: bool,
        write: bool,
        error: SBErrorRef,
    ) -> SBWatchpointRef;
    pub fn SBValueWatch2(
        instance: SBValueRef,
        resolve_location: bool,
        read: bool,
        write: bool,
    ) -> SBWatchpointRef;
    pub fn SBValueWatchPointee(
        instance: SBValueRef,
        resolve_location: bool,
        read: bool,
        write: bool,
        error: SBErrorRef,
    ) -> SBWatchpointRef;
    pub fn CreateSBValueList() -> SBValueListRef;
    pub fn CloneSBValueList(instance: SBValueListRef) -> SBValueListRef;
    pub fn DisposeSBValueList(instance: SBValueListRef);
    pub fn SBValueListIsValid(instance: SBValueListRef) -> bool;
    pub fn SBValueListClear(instance: SBValueListRef);
    pub fn SBValueListAppend(instance: SBValueListRef, val_obj: SBValueRef);
    pub fn SBValueListAppendList(instance: SBValueListRef, value_list: SBValueListRef);
    pub fn SBValueListGetSize(instance: SBValueListRef) -> u32;
    pub fn SBValueListGetValueAtIndex(instance: SBValueListRef, idx: u32) -> SBValueRef;
    pub fn SBValueListGetFirstValueByName(
        instance: SBValueListRef,
        name: *const ::std::os::raw::c_char,
    ) -> SBValueRef;
    pub fn SBValueListFindValueObjectByUID(
        instance: SBValueListRef,
        uid: lldb_user_id_t,
    ) -> SBValueRef;
    pub fn CreateSBVariablesOptions() -> SBVariablesOptionsRef;
    pub fn CloneSBVariablesOptions(instance: SBVariablesOptionsRef) -> SBVariablesOptionsRef;
    pub fn DisposeSBVariablesOptions(instance: SBVariablesOptionsRef);
    pub fn SBVariablesOptionsIsValid(instance: SBVariablesOptionsRef) -> bool;
    pub fn SBVariablesOptionsGetIncludeArguments(instance: SBVariablesOptionsRef) -> bool;
    pub fn SBVariablesOptionsSetIncludeArguments(instance: SBVariablesOptionsRef, arg1: bool);
    pub fn SBVariablesOptionsGetIncludeRecognizedArguments(
        instance: SBVariablesOptionsRef,
        target: SBTargetRef,
    ) -> bool;
    pub fn SBVariablesOptionsSetIncludeRecognizedArguments(
        instance: SBVariablesOptionsRef,
        arg1: bool,
    );
    pub fn SBVariablesOptionsGetIncludeLocals(instance: SBVariablesOptionsRef) -> bool;
    pub fn SBVariablesOptionsSetIncludeLocals(instance: SBVariablesOptionsRef, arg1: bool);
    pub fn SBVariablesOptionsGetIncludeStatics(instance: SBVariablesOptionsRef) -> bool;
    pub fn SBVariablesOptionsSetIncludeStatics(instance: SBVariablesOptionsRef, arg1: bool);
    pub fn SBVariablesOptionsGetInScopeOnly(instance: SBVariablesOptionsRef) -> bool;
    pub fn SBVariablesOptionsSetInScopeOnly(instance: SBVariablesOptionsRef, arg1: bool);
    pub fn SBVariablesOptionsGetIncludeRuntimeSupportValues(
        instance: SBVariablesOptionsRef,
    ) -> bool;
    pub fn SBVariablesOptionsSetIncludeRuntimeSupportValues(
        instance: SBVariablesOptionsRef,
        arg1: bool,
    );
    pub fn SBVariablesOptionsGetUseDynamic(instance: SBVariablesOptionsRef) -> DynamicValueType;
    pub fn SBVariablesOptionsSetUseDynamic(instance: SBVariablesOptionsRef, arg1: DynamicValueType);
    pub fn CreateSBWatchpoint() -> SBWatchpointRef;
    pub fn CloneSBWatchpoint(instance: SBWatchpointRef) -> SBWatchpointRef;
    pub fn DisposeSBWatchpoint(instance: SBWatchpointRef);
    pub fn SBWatchpointIsValid(instance: SBWatchpointRef) -> bool;
    pub fn SBWatchpointGetError(instance: SBWatchpointRef) -> SBErrorRef;
    pub fn SBWatchpointGetID(instance: SBWatchpointRef) -> lldb_watch_id_t;
    pub fn SBWatchpointGetHardwareIndex(instance: SBWatchpointRef) -> i32;
    pub fn SBWatchpointGetWatchAddress(instance: SBWatchpointRef) -> lldb_addr_t;
    pub fn SBWatchpointGetWatchSize(instance: SBWatchpointRef) -> size_t;
    pub fn SBWatchpointSetEnabled(instance: SBWatchpointRef, enabled: bool);
    pub fn SBWatchpointIsEnabled(instance: SBWatchpointRef) -> bool;
    pub fn SBWatchpointGetHitCount(instance: SBWatchpointRef) -> u32;
    pub fn SBWatchpointGetIgnoreCount(instance: SBWatchpointRef) -> u32;
    pub fn SBWatchpointSetIgnoreCount(instance: SBWatchpointRef, n: u32);
    pub fn SBWatchpointGetCondition(instance: SBWatchpointRef) -> *const ::std::os::raw::c_char;
    pub fn SBWatchpointSetCondition(
        instance: SBWatchpointRef,
        condition: *const ::std::os::raw::c_char,
    );
    pub fn SBWatchpointGetDescription(
        instance: SBWatchpointRef,
        description: SBStreamRef,
        level: DescriptionLevel,
    ) -> bool;
    pub fn SBWatchpointClear(instance: SBWatchpointRef);
    pub fn SBWatchpointEventIsWatchpointEvent(event: SBEventRef) -> bool;
    pub fn SBWatchpointGetWatchpointEventTypeFromEvent(event: SBEventRef) -> WatchpointEventType;
    pub fn SBWatchpointGetWatchpointFromEvent(event: SBEventRef) -> SBWatchpointRef;
}
