# Mun Programming Language Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, sex characteristics, gender identity and expression,
level of experience, education, socio-economic status, nationality, personal
appearance, race, religion, or sexual identity and orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
 advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
 address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
 professional setting

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

These are the policies for upholding our community's standards of conduct. If
you feel that a thread needs moderation, please contact the Mun moderators at
[moderators@mun-lang.org](mailto:moderators@mun-lang.org).

1. Remarks that violate the Mun standards of conduct, including hateful,
   hurtful, oppressive, or exclusionary remarks, are not allowed. (Cursing in
   general is discouraged, and never tolerated if targeting another user, and
   never in a hateful manner.)
2. Remarks that moderators find inappropriate, whether listed in the code of
   conduct or not, are also not allowed.
3. Moderators will first respond to such remarks with a warning.
4. If the warning is unheeded, the user will be "kicked," i.e., kicked out of
   the communication channel to cool off.
5. If the user comes back and continues to make trouble, they will be banned,
   i.e., indefinitely excluded.
6. Moderators may choose at their discretion to un-ban the user if it was a
   first offense and they offer the offended party a genuine apology.
7. If a moderator bans someone and you think it was unjustified, please take it
   up with that moderator, or with a different moderator, **in private**.
   Complaints about bans in-channel are not allowed.
8. Moderators, organization members, and anyone closely involved with the
   Mun project are held to a higher standard than other community members.
   If a moderator creates an inappropriate situation, they should expect less
   leeway than others.

## Goals

In the Mun community we strive to go the extra step to look out for each other.
Don't just aim to be technically unimpeachable, try to be your best self. In
particular, avoid flirting with offensive or sensitive issues, particularly if
they're off-topic; this all too often leads to unnecessary fights, hurt
feelings, and damaged trust; worse, it can drive people away from the community
entirely.

And if someone takes issue with something you said or did, resist the urge to be
defensive. Just stop doing what it was they complained about and apologize. Even
if you feel you were misinterpreted or unfairly accused, chances are good there
was something you could've communicated better — remember that it's your
responsibility to make your fellow Mun community members comfortable. Everyone
wants to get along and we are all here first and foremost because we want to
talk about making games. You will find that people will be eager to assume good
intent and forgive as long as you earn their trust.

## Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at
[moderators@mun-lang.org](mailto:moderators@mun-lang.org). All complaints will
be reviewed and investigated and will result in a response that is deemed
necessary and appropriate to the circumstances. The project team is obligated to
maintain confidentiality with regard to the reporter of an incident. Further
details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor
Covenant](https://www.contributor-covenant.org), version 1.4, available at
https://www.contributor-covenant.org/version/1/4/code-of-conduct.html and the
Rust Code of Conduct, available here: https://www.rust-lang.org/conduct.html.
