/// Dom events
pub enum Event {
    Abort,
    Afterprint,
    Animationend,
    Animationiteration,
    Animationstart,
    Beforeprint,
    Beforeunload,
    Blur,
    Canplay,
    Canplaythrough,
    Change,
    Click,
    Contextmenu,
    Copy,
    Cut,
    Dblclick,
    Drag,
    Dragend,
    Dragenter,
    Dragleave,
    Dragover,
    Dragstart,
    Drop,
    Durationchange,
    Ended,
    Error,
    Focus,
    Focusin,
    Focusout,
    Fullscreenchange,
    Fullscreenerror,
    Hashchange,
    Input,
    Invalid,
    Keydown,
    Keypress,
    Keyup,
    Load,
    Loadeddata,
    Loadedmetadata,
    Loadstart,
    Message,
    Mousedown,
    Mouseenter,
    Mouseleave,
    Mousemove,
    Mouseover,
    Mouseout,
    Mouseup,
    Mousewheel,
    Offline,
    Online,
    Open,
    Pagehide,
    Pageshow,
    Paste,
    Pause,
    Play,
    Playing,
    Popstate,
    Progress,
    Ratechange,
    Resize,
    Reset,
    Scroll,
    Search,
    Seeked,
    Seeking,
    Select,
    Show,
    Stalled,
    Storage,
    Submit,
    Suspend,
    Timeupdate,
    Toggle,
    Touchcancel,
    Touchend,
    Touchmove,
    Touchstart,
    Transitionend,
    Unload,
    Volumechange,
    Waiting,
    Wheel,
}

pub(crate) fn get_event_str(typ: Event) -> &'static str {
    match typ {
        Event::Abort => "abort",
        Event::Afterprint => "afterprint",
        Event::Animationend => "animationend",
        Event::Animationiteration => "animationiteration",
        Event::Animationstart => "animationstart",
        Event::Beforeprint => "beforeprint",
        Event::Beforeunload => "beforeunload",
        Event::Blur => "blur",
        Event::Canplay => "canplay",
        Event::Canplaythrough => "canplaythrough",
        Event::Change => "change",
        Event::Click => "click",
        Event::Contextmenu => "contextmenu",
        Event::Copy => "copy",
        Event::Cut => "cut",
        Event::Dblclick => "dblclick",
        Event::Drag => "drag",
        Event::Dragend => "dragend",
        Event::Dragenter => "dragenter",
        Event::Dragleave => "dragleave",
        Event::Dragover => "dragover",
        Event::Dragstart => "dragstart",
        Event::Drop => "drop",
        Event::Durationchange => "durationchange",
        Event::Ended => "ended",
        Event::Error => "error",
        Event::Focus => "focus",
        Event::Focusin => "focusin",
        Event::Focusout => "focusout",
        Event::Fullscreenchange => "fullscreenchange",
        Event::Fullscreenerror => "fullscreenerror",
        Event::Hashchange => "hashchange",
        Event::Input => "input",
        Event::Invalid => "invalid",
        Event::Keydown => "keydown",
        Event::Keypress => "keypress",
        Event::Keyup => "keyup",
        Event::Load => "load",
        Event::Loadeddata => "loadeddata",
        Event::Loadedmetadata => "loadedmetadata",
        Event::Loadstart => "loadstart",
        Event::Message => "message",
        Event::Mousedown => "mousedown",
        Event::Mouseenter => "mouseenter",
        Event::Mouseleave => "mouseleave",
        Event::Mousemove => "mousemove",
        Event::Mouseover => "mouseover",
        Event::Mouseout => "mouseout",
        Event::Mouseup => "mouseup",
        Event::Mousewheel => "mousewheel",
        Event::Offline => "offline",
        Event::Online => "online",
        Event::Open => "open",
        Event::Pagehide => "pagehide",
        Event::Pageshow => "pageshow",
        Event::Paste => "paste",
        Event::Pause => "pause",
        Event::Play => "play",
        Event::Playing => "playing",
        Event::Popstate => "popstate",
        Event::Progress => "progress",
        Event::Ratechange => "ratechange",
        Event::Resize => "resize",
        Event::Reset => "reset",
        Event::Scroll => "scroll",
        Event::Search => "search",
        Event::Seeked => "seeked",
        Event::Seeking => "seeking",
        Event::Select => "select",
        Event::Show => "show",
        Event::Stalled => "stalled",
        Event::Storage => "storage",
        Event::Submit => "submit",
        Event::Suspend => "suspend",
        Event::Timeupdate => "timeupdate",
        Event::Toggle => "toggle",
        Event::Touchcancel => "touchcancel",
        Event::Touchend => "touchend",
        Event::Touchmove => "touchmove",
        Event::Touchstart => "touchstart",
        Event::Transitionend => "transitionend",
        Event::Unload => "unload",
        Event::Volumechange => "volumechange",
        Event::Waiting => "waiting",
        Event::Wheel => "wheel",
    }
}
