/// Element types
pub enum WidgetType {
    Address,
    Article,
    Aside,
    Footer,
    Header,
    H1,
    H2,
    H3,
    H4,
    H5,
    H6,
    Main,
    Nav,
    Section,
    Blockquote,
    Dd,
    Div,
    Dl,
    Dt,
    Figcaption,
    Figure,
    Hr,
    Li,
    Ol,
    P,
    Pre,
    Ul,
    A,
    Abbr,
    B,
    Bdi,
    Bdo,
    Br,
    Cite,
    Code,
    Data,
    Dfn,
    Em,
    I,
    Kbd,
    Mark,
    Q,
    Rp,
    Rt,
    Ruby,
    S,
    Samp,
    Small,
    Span,
    Strong,
    Sub,
    Sup,
    Time,
    U,
    Var,
    Wbr,
    Area,
    Audio,
    Img,
    Map,
    Track,
    Video,
    Embed,
    Iframe,
    Object,
    Param,
    Picture,
    Portal,
    Source,
    Svg,
    Math,
    Canvas,
    Noscript,
    Script,
    Del,
    Ins,
    Caption,
    Col,
    Colgroup,
    Table,
    Tbody,
    Td,
    Tfoot,
    Th,
    Thead,
    Tr,
    Button,
    Datalist,
    Fieldset,
    Form,
    Input,
    Label,
    Legend,
    Meter,
    Optgroup,
    Option,
    Output,
    Progress,
    Select,
    Textarea,
    Details,
    Dialog,
    Menu,
    Summary,
    Slot,
    Template,
}

pub(crate) fn get_element_str(typ: WidgetType) -> &'static str {
    match typ {
        WidgetType::Address => "address",
        WidgetType::Article => "article",
        WidgetType::Aside => "aside",
        WidgetType::Footer => "footer",
        WidgetType::Header => "header",
        WidgetType::H1 => "h1",
        WidgetType::H2 => "h2",
        WidgetType::H3 => "h3",
        WidgetType::H4 => "h4",
        WidgetType::H5 => "h5",
        WidgetType::H6 => "h6",
        WidgetType::Main => "main",
        WidgetType::Nav => "nav",
        WidgetType::Section => "section",
        WidgetType::Blockquote => "blockquote",
        WidgetType::Dd => "dd",
        WidgetType::Div => "div",
        WidgetType::Dl => "dl",
        WidgetType::Dt => "dt",
        WidgetType::Figcaption => "figcaption",
        WidgetType::Figure => "figure",
        WidgetType::Hr => "hr",
        WidgetType::Li => "li",
        WidgetType::Ol => "ol",
        WidgetType::P => "p",
        WidgetType::Pre => "pre",
        WidgetType::Ul => "ul",
        WidgetType::A => "a",
        WidgetType::Abbr => "abbr",
        WidgetType::B => "b",
        WidgetType::Bdi => "bdi",
        WidgetType::Bdo => "bdo",
        WidgetType::Br => "br",
        WidgetType::Cite => "cite",
        WidgetType::Code => "code",
        WidgetType::Data => "data",
        WidgetType::Dfn => "dfn",
        WidgetType::Em => "em",
        WidgetType::I => "i",
        WidgetType::Kbd => "kbd",
        WidgetType::Mark => "mark",
        WidgetType::Q => "q",
        WidgetType::Rp => "rp",
        WidgetType::Rt => "rt",
        WidgetType::Ruby => "ruby",
        WidgetType::S => "s",
        WidgetType::Samp => "samp",
        WidgetType::Small => "small",
        WidgetType::Span => "span",
        WidgetType::Strong => "strong",
        WidgetType::Sub => "sub",
        WidgetType::Sup => "sup",
        WidgetType::Time => "time",
        WidgetType::U => "u",
        WidgetType::Var => "var",
        WidgetType::Wbr => "wbr",
        WidgetType::Area => "area",
        WidgetType::Audio => "audio",
        WidgetType::Img => "img",
        WidgetType::Map => "map",
        WidgetType::Track => "track",
        WidgetType::Video => "video",
        WidgetType::Embed => "embed",
        WidgetType::Iframe => "iframe",
        WidgetType::Object => "object",
        WidgetType::Param => "param",
        WidgetType::Picture => "picture",
        WidgetType::Portal => "portal",
        WidgetType::Source => "source",
        WidgetType::Svg => "svg",
        WidgetType::Math => "math",
        WidgetType::Canvas => "canvas",
        WidgetType::Noscript => "noscript",
        WidgetType::Script => "script",
        WidgetType::Del => "del",
        WidgetType::Ins => "ins",
        WidgetType::Caption => "caption",
        WidgetType::Col => "col",
        WidgetType::Colgroup => "colgroup",
        WidgetType::Table => "table",
        WidgetType::Tbody => "tbody",
        WidgetType::Td => "td",
        WidgetType::Tfoot => "tfoot",
        WidgetType::Th => "th",
        WidgetType::Thead => "thead",
        WidgetType::Tr => "tr",
        WidgetType::Button => "button",
        WidgetType::Datalist => "datalist",
        WidgetType::Fieldset => "fieldset",
        WidgetType::Form => "form",
        WidgetType::Input => "input",
        WidgetType::Label => "label",
        WidgetType::Legend => "legend",
        WidgetType::Meter => "meter",
        WidgetType::Optgroup => "optgroup",
        WidgetType::Option => "option",
        WidgetType::Output => "output",
        WidgetType::Progress => "progress",
        WidgetType::Select => "select",
        WidgetType::Textarea => "textarea",
        WidgetType::Details => "details",
        WidgetType::Dialog => "dialog",
        WidgetType::Menu => "menu",
        WidgetType::Summary => "summary",
        WidgetType::Slot => "slot",
        WidgetType::Template => "template",
    }
}
