use liveterm::TermPrinter;
use std::fmt::Write;
fn main() -> Result<(), Box<dyn std::error::Error>> {
    let mut tp = TermPrinter::new(std::io::stdout());
    for i in 0.. {
        tp.clear()?; // clear what we draw last time
        tp.buf.clear(); // clear the buffer

        // fill the buffer
        writeln!(
            tp.buf,
            "Now I've been \x1b[m\x1b[m\x1b[32m\x1b[1mrunning\x1b[m for {}.{} seconds",
            i / 10,
            i % 10
        )?;
        writeln!(tp.buf)?;
        writeln!(tp.buf, "本日はいかがお過ごしでしょうか？")?;

        tp.print()?; // draw the buffer
        std::thread::sleep(std::time::Duration::from_millis(100));
    }
    Ok(())
}
