pub const PADDING: f32 = 0.35;
pub const BOTH_PADDINGS: f32 = 2.0 * PADDING;
pub const BOTH_VERTICAL_PADDINGS: f32 = DEFAULT_COMPONENT_HEIGHT - DEFAULT_TEXT_SIZE;
pub const VERTICAL_PADDING: f32 = BOTH_VERTICAL_PADDINGS / 2.0;
pub const ICON_MIN_VERTICAL_PADDING: f32 = 0.1;
pub const DEFAULT_COMPONENT_HEIGHT: f32 = 1.0;
pub const TWO_ROW_HEIGHT: f32 = 2.0 * DEFAULT_TEXT_SIZE + BOTH_VERTICAL_PADDINGS;
pub const DEFAULT_TEXT_SIZE: f32 = 0.725;
pub const DEFAULT_TEXT_ASCENT: f32 = 0.55;
pub const DEFAULT_TEXT_DESCENT: f32 = DEFAULT_TEXT_SIZE - DEFAULT_TEXT_ASCENT;
pub const TEXT_ALIGN_TOP: f32 = VERTICAL_PADDING + DEFAULT_TEXT_ASCENT;
pub const TEXT_ALIGN_BOTTOM: f32 = -(VERTICAL_PADDING + DEFAULT_TEXT_DESCENT);
pub const TEXT_ALIGN_CENTER: f32 = DEFAULT_TEXT_ASCENT - DEFAULT_TEXT_SIZE / 2.0;
pub const SEPARATOR_THICKNESS: f32 = 0.1;
pub const THIN_SEPARATOR_THICKNESS: f32 = SEPARATOR_THICKNESS / 2.0;
pub const PSEUDO_PIXELS: f32 = 1.0 / 24.0;
pub const DEFAULT_VERTICAL_WIDTH: f32 = 11.5;

pub fn vertical_padding(height: f32) -> f32 {
    (ICON_MIN_VERTICAL_PADDING * height).min(PADDING)
}
