use common::*;
use color::*;
use piece::*;
use square::*;

const WHITE_PAWN_OPENING: [Score; 64] = [
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
   -5,   0,   5,  20,  20,   5,   0,  -5,
  -10,   0,  10,  30,  30,  10,   0, -10,
  -10,   0,   5,  20,  20,   5,   0, -10,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0, -20, -20,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0
];

const WHITE_PAWN_ENDING: [Score; 64] = [
    0,   0,   0,   0,   0,   0,   0,   0,
   50,  50,  30,  20,  20,  30,  50,  50,
   30,  30,  20,  10,  10,  20,  30,  30,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0
];

const WHITE_KNIGHT_OPENING: [Score; 64] = [
  -50, -40, -30, -20, -20, -30, -40, -50,
  -40, -15,   0,   0,   0,   0, -15, -40,
  -30,   0,  10,  15,  15,  10,   0, -30,
  -20,   5,  15,  20,  20,  15,   5, -20,
  -20,   0,  15,  20,  20,  15,   0, -20,
  -30,   5,  10,  15,  15,  10,   5, -30,
  -40, -15,   0,   5,   5,   0, -15, -40,
  -50, -40, -30, -20, -20, -30, -40, -50,
];

const WHITE_KNIGHT_ENDING: [Score; 64] = [
  -50, -40, -30, -30, -30, -30, -40, -50,
  -40, -20,   0,   0,   0,   0, -20, -40,
  -30,   0,  10,  15,  15,  10,   0, -30,
  -30,   5,  15,  20,  20,  15,   5, -30,
  -30,   0,  15,  20,  20,  15,   0, -30,
  -30,   5,  10,  15,  15,  10,   5, -30,
  -40, -20,   0,   5,   5,   0, -20, -40,
  -50, -40, -30, -30, -30, -30, -40, -50,
];

const WHITE_BISHOP_OPENING: [Score; 64] = [
  -20, -10, -10, -10, -10, -10, -10, -20,
  -10,   0,   0,   0,   0,   0,   0, -10,
  -10,   0,   5,  10,  10,   5,   0, -10,
  -10,   5,   5,  10,  10,   5,   5, -10,
  -10,   0,  10,  10,  10,  10,   0, -10,
  -10,  10,  10,  10,  10,  10,  10, -10,
  -10,   5,   0,   0,   0,   0,   5, -10,
  -20, -10, -10, -10, -10, -10, -10, -20,
];

const WHITE_BISHOP_ENDING: [Score; 64] = [
  -20, -10, -10, -10, -10, -10, -10, -20,
  -10,   0,   0,   0,   0,   0,   0, -10,
  -10,   0,   5,  10,  10,   5,   0, -10,
  -10,   5,   5,  10,  10,   5,   5, -10,
  -10,   0,  10,  10,  10,  10,   0, -10,
  -10,  10,  10,  10,  10,  10,  10, -10,
  -10,   5,   0,   0,   0,   0,   5, -10,
  -20, -10, -10, -10, -10, -10, -10, -20,
];

const WHITE_ROOK_OPENING: [Score; 64] = [
    0,   0,   0,   0,   0,   0,   0,   0,
    5,  10,  10,  10,  10,  10,  10,   5,
   -5,   0,   0,   0,   0,   0,   0,  -5,
   -5,   0,   0,   0,   0,   0,   0,  -5,
   -5,   0,   0,   0,   0,   0,   0,  -5,
   -5,   0,   0,   0,   0,   0,   0,  -5,
   -5,   0,   0,   0,   0,   0,   0,  -5,
    0,   0,   0,   5,   5,   0,   0,   0
];

const WHITE_ROOK_ENDING: [Score; 64] = [
    0,   0,   0,   0,   0,   0,   0,   0,
    5,  10,  10,  10,  10,  10,  10,   5,
   -5,   0,   0,   0,   0,   0,   0,  -5,
   -5,   0,   0,   0,   0,   0,   0,  -5,
   -5,   0,   0,   0,   0,   0,   0,  -5,
   -5,   0,   0,   0,   0,   0,   0,  -5,
   -5,   0,   0,   0,   0,   0,   0,  -5,
    0,   0,   0,   5,   5,   0,   0,   0
];

const WHITE_QUEEN_OPENING: [Score; 64] = [
  -20, -10, -10,  -5,  -5, -10, -10, -20,
  -10,   0,   0,   0,   0,   0,   0, -10,
  -10,   0,   5,   5,   5,   5,   0, -10,
   -5,   0,   5,   5,   5,   5,   0,  -5,
    0,   0,   5,   5,   5,   5,   0,  -5,
  -10,   5,   5,   5,   5,   5,   0, -10,
  -10,   0,   5,   0,   0,   0,   0, -10,
  -20, -10, -10,  -5,  -5, -10, -10, -20
];

const WHITE_QUEEN_ENDING: [Score; 64] = [
  -20, -10, -10,  -5,  -5, -10, -10, -20,
  -10,   0,   0,   0,   0,   0,   0, -10,
  -10,   0,   5,   5,   5,   5,   0, -10,
   -5,   0,   5,   5,   5,   5,   0,  -5,
    0,   0,   5,   5,   5,   5,   0,  -5,
  -10,   5,   5,   5,   5,   5,   0, -10,
  -10,   0,   5,   0,   0,   0,   0, -10,
  -20, -10, -10,  -5,  -5, -10, -10, -20
];

const WHITE_KING_OPENING: [Score; 64] = [
  -30, -40, -40, -50, -50, -40, -40, -30,
  -30, -40, -40, -50, -50, -40, -40, -30,
  -30, -40, -40, -50, -50, -40, -40, -30,
  -30, -40, -40, -50, -50, -40, -40, -30,
  -20, -30, -30, -40, -40, -30, -30, -20,
  -10, -20, -20, -20, -20, -20, -20, -10,
   20,  20,   0,   0,   0,   0,  20,  20,
   20,  30,  10,   0,   0,  10,  30,  20
];

const WHITE_KING_ENDING: [Score; 64] = [
  -50, -40, -30, -20, -20, -30, -40, -50,
  -30, -20, -10,   0,   0, -10, -20, -30,
  -30, -10,  20,  30,  30,  20, -10, -30,
  -30, -10,  30,  40,  40,  30, -10, -30,
  -30, -10,  30,  40,  40,  30, -10, -30,
  -30, -10,  20,  30,  30,  20, -10, -30,
  -30, -30,   0,   0,   0,   0, -30, -30,
  -50, -30, -30, -30, -30, -30, -30, -50
];

const WHITE_PIECES_OPENING: [[Score; 64]; 6] = [
    WHITE_PAWN_OPENING,
    WHITE_KNIGHT_OPENING,
    WHITE_BISHOP_OPENING,
    WHITE_ROOK_OPENING,
    WHITE_QUEEN_OPENING,
    WHITE_KING_OPENING
];

const WHITE_PIECES_ENDING: [[Score; 64]; 6] = [
    WHITE_PAWN_ENDING,
    WHITE_KNIGHT_ENDING,
    WHITE_BISHOP_ENDING,
    WHITE_ROOK_ENDING,
    WHITE_QUEEN_ENDING,
    WHITE_KING_ENDING
];

lazy_static! {
    pub static ref PST: [[[Score; 2]; 64]; 14] = {
        let mut pst_values = [[[0; 2]; 64]; 14];

        for c in 0..2 {
            for p in 0..6 {
                for s in 0..64 {
                    let square = (s as Square).flip((c as Color) ^ 1);
                    let piece = (c as Color) | PIECES[p];

                    let score = WHITE_PIECES_OPENING[p][s];
                    pst_values[piece as usize][square as usize][0] = score;

                    let score = WHITE_PIECES_ENDING[p][s];
                    pst_values[piece as usize][square as usize][1] = score;
                }
            }
        }

        pst_values
    };
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_pst() {
        let white_score = PST[WHITE_KNIGHT as usize][F3.flip(WHITE) as usize][0];
        let black_score = PST[BLACK_KNIGHT as usize][F3.flip(BLACK) as usize][0];
        assert!(white_score > 0);
        assert_eq!(white_score, black_score);
    }
}
