Object.assign(window.search, {"doc_urls":["overview.html#overview","overview.html#pre-requistes","overview.html#lisp-dialect","overview.html#data-types","overview.html#statements","overview.html#keywords","overview.html#examples","overview.html#interpreter","overview.html#repl","introduction.html#introduction","lexer.html#lexer","lexer.html#source","lexer.html#code-walk-through","lexer.html#testing","parser.html#parser","parser.html#source","parser.html#code-walk-through","parser.html#object-model","parser.html#parser-1","parser.html#testing","evaluator.html#evaluator","evaluator.html#source","evaluator.html#code-walk-through","evaluator.html#eval_symbol","evaluator.html#eval_list","evaluator.html#variable-definitions","evaluator.html#binary-operations","evaluator.html#if-statement","evaluator.html#lambda","evaluator.html#function-call","repl.html#repl","repl.html#source","repl.html#code-walk-through","next.html#whats-next"],"index":{"documentStore":{"docInfo":{"0":{"body":58,"breadcrumbs":2,"title":1},"1":{"body":40,"breadcrumbs":3,"title":2},"10":{"body":0,"breadcrumbs":2,"title":1},"11":{"body":1,"breadcrumbs":2,"title":1},"12":{"body":134,"breadcrumbs":4,"title":3},"13":{"body":28,"breadcrumbs":2,"title":1},"14":{"body":0,"breadcrumbs":2,"title":1},"15":{"body":1,"breadcrumbs":2,"title":1},"16":{"body":18,"breadcrumbs":4,"title":3},"17":{"body":74,"breadcrumbs":3,"title":2},"18":{"body":116,"breadcrumbs":2,"title":1},"19":{"body":26,"breadcrumbs":2,"title":1},"2":{"body":18,"breadcrumbs":3,"title":2},"20":{"body":35,"breadcrumbs":2,"title":1},"21":{"body":1,"breadcrumbs":2,"title":1},"22":{"body":84,"breadcrumbs":4,"title":3},"23":{"body":188,"breadcrumbs":2,"title":1},"24":{"body":64,"breadcrumbs":2,"title":1},"25":{"body":77,"breadcrumbs":3,"title":2},"26":{"body":30,"breadcrumbs":3,"title":2},"27":{"body":53,"breadcrumbs":2,"title":1},"28":{"body":79,"breadcrumbs":2,"title":1},"29":{"body":122,"breadcrumbs":3,"title":2},"3":{"body":2,"breadcrumbs":3,"title":2},"30":{"body":0,"breadcrumbs":2,"title":1},"31":{"body":1,"breadcrumbs":2,"title":1},"32":{"body":76,"breadcrumbs":4,"title":3},"33":{"body":46,"breadcrumbs":4,"title":2},"4":{"body":9,"breadcrumbs":2,"title":1},"5":{"body":2,"breadcrumbs":2,"title":1},"6":{"body":40,"breadcrumbs":2,"title":1},"7":{"body":77,"breadcrumbs":2,"title":1},"8":{"body":9,"breadcrumbs":2,"title":1},"9":{"body":109,"breadcrumbs":2,"title":1}},"docs":{"0":{"body":"The lisp-rs project implements an interpreter, in Rust, for a small subset of Scheme , a Lisp dialect. The main goal of this document is to make sure the reader understands the inner details of how the interpreter was implemented. The project was inspired by Peter Norvig's article (How to Write a (Lisp) Interpreter (in Python)) and the book Writing An Interpreter In Go . This document serves as a commentary on the code that implements the interpreter. Rust's rich programming constructs such as enum, pattern matching, and error handling make it easy and a joy to implement this bare-bone interpreter.","breadcrumbs":"Overview » Overview","id":"0","title":"Overview"},"1":{"body":"To make the most out of this project, it is expected that the user is aware of the following Computer Science concepts Lists Recursion Rust is a non-trivial language, however, to implement the Lisp interpreter, the reader needs to have moderate experience with the language. Knowing the following four concepts should be enough for the user to understand the whole project Enums and Pattern Matching Smart Pointers Error handling","breadcrumbs":"Overview » Pre-requistes","id":"1","title":"Pre-requistes"},"10":{"body":"","breadcrumbs":"Lexer » Lexer","id":"10","title":"Lexer"},"11":{"body":"lexer.rs","breadcrumbs":"Lexer » Source","id":"11","title":"Source"},"12":{"body":"Lexer is a component of the interpreter that takes the program text and converts it to a stream of atomic units known as tokens . Every token has a type and may even have a value associated with it. In the case of our interpreter, there are four types of tokens. The four tokens can be represented using a Rust enum as follows. pub enum Token { Integer(i64), Symbol(String), LParen, RParen, } Integer: A signed 64-bit integer Symbol: Any group of characters other than an integer or parenthesis LParen: Left parenthesis RParen: Right parenthesis The first step in implementing a lexer is to replace the parenthesis with an extra space before and after it. For example, (define sqr (* x x)) will get converted to ( define sqr ( * x x ) ) With this simple trick, the process of tokenization involves splitting the Lisp program with whitespace. let program2 = program.replace(\"(\", \" ( \") .replace(\")\", \" ) \"); let words = program2.split_whitespace(); Once the words for the program are obtained, they can be converted into tokens using Rust's pattern matching as follows let mut tokens: Vec<Token> = Vec::new();\nfor word in words { match word { \"(\" => tokens.push(Token::LParen), \")\" => tokens.push(Token::RParen), _ => { let i = word.parse::<i64>(); if i.is_ok() { tokens.push(Token::Integer( i.unwrap())); } else { tokens.push(Token::Symbol( word.to_string())); } } }\n} At this point, we have a vector of tokens for the entire Lisp program. Note that a vector in Rust is a stack, hence the tokens are stored in the vector in the reverse order as shown below with an example. List Recursion","breadcrumbs":"Lexer » Code Walk Through","id":"12","title":"Code Walk Through"},"13":{"body":"The lexer code can be unit tested as shown below let tokens = tokenize(\"(+ 1 2)\");\nassert_eq!( tokens, vec![ Token::LParen, Token::Symbol(\"+\".to_string()), Token::Integer(1), Token::Integer(2), Token::RParen, ]\n); To cement your understanding of the Lexing process please go through the remaining tests in lexer.rs","breadcrumbs":"Lexer » Testing","id":"13","title":"Testing"},"14":{"body":"","breadcrumbs":"Parser » Parser","id":"14","title":"Parser"},"15":{"body":"parser.rs","breadcrumbs":"Parser » Source","id":"15","title":"Source"},"16":{"body":"The job of the parser is to take the vector of tokens and convert it into a recursive list structure (mentioned in the introduction ). This recursive list structure is an in-memory representation of the Lisp program.","breadcrumbs":"Parser » Code Walk Through","id":"16","title":"Code Walk Through"},"17":{"body":"Before diving into the details of how the recursive list structure is created, we need to first define the objects that will make up the elements of the list. This is done in the object Rust module with an enum defined as follows pub enum Object { Void, Integer(i64), Bool(bool), Symbol(String), Lambda(Vec<String>, Vec<Object>), List(Vec<Object>),\n} Void : An empty object Integer : A signed 64-bit integer Bool : A boolean value Symbol : A Lisp symbol, similar to the Symbol token Lambda : Function object, with the first vector representing the parameter labels and the second vector representing the body of the function. This object is not used during parsing but will be used during the evaluation phase of the interpreter. List : List object","breadcrumbs":"Parser » Object model","id":"17","title":"Object model"},"18":{"body":"The parser for the Lisp dialect is a simple recursive function. It takes a vector of tokens (in reverse) generated by the lexer and generates a single List Object representing the entire Lisp program. The core logic of the parser is implemented by the recursive parse_list function as shown below. It expects a vector of tokens, with the first token of the vector being a left parenthesis indicating the start of the list. The function then proceeds to process the elements of the list one at a time. If it encounters atomic tokens such as an integer or symbol it creates corresponding atomic objects and adds them to the list. If it encounters another left parenthesis it recurses with the remaining tokens. Finally, the function returns with the list object when it encounters the right parenthesis. let token = tokens.pop();\nif token != Some(Token::LParen) { return Err(ParseError { err: format!(\"Expected LParen, found {:?}\", token), });\n} let mut list: Vec<Object> = Vec::new(); while !tokens.is_empty() { let token = tokens.pop(); if token == None { return Err(ParseError { err: format!(\"Insufficient tokens\"), }); } let t = token.unwrap(); match t { Token::Integer(n) => list.push(Object::Integer(n)), Token::Symbol(s) => list.push(Object::Symbol(s)), Token::LParen => { tokens.push(Token::LParen); let sub_list = parse_list(tokens)?; list.push(sub_list); } Token::RParen => { return Ok(Object::List(list)); } }\n}","breadcrumbs":"Parser » Parser","id":"18","title":"Parser"},"19":{"body":"The above parsing code can be unit tested as follows let list = parse(\"(+ 1 2)\").unwrap();\nassert_eq!( list, Object::List(vec![ Object::Symbol(\"+\".to_string()), Object::Integer(1), Object::Integer(2), ])\n); To cement your understanding of the parsing process please go through the remaining tests in parser.rs","breadcrumbs":"Parser » Testing","id":"19","title":"Testing"},"2":{"body":"In order to keep the interpreter simple and its implementation easy to understand, the number of features supported by it has been limited on purpose. Following are the data types and statements that will be supported by the interpreter.","breadcrumbs":"Overview » Lisp Dialect","id":"2","title":"Lisp Dialect"},"20":{"body":"Now comes the most exciting part of the project. Evaluation is the final step that will produce the result for the Lisp program. At a high level, the evaluator function recursively walks the List-based structure created by the parser and evaluates each atomic object and list (recursively), combines these intermediate values, and produces the final result.","breadcrumbs":"Evaluator » Evaluator","id":"20","title":"Evaluator"},"21":{"body":"eval.rs","breadcrumbs":"Evaluator » Source","id":"21","title":"Source"},"22":{"body":"The evaluator is implemented using the recursive eval_obj function. The eval_obj function takes the List object representing the program and the global env variable (a simple hashmap) as the input. The function then starts processing the List object representing the program by iterating over each element of this list fn eval_obj(obj: &Object, env: &mut Rc<RefCell<Env>>) -> Result<Object, String> { match obj { Object::Void => Ok(Object::Void), Object::Lambda(_params, _body) => Ok(Object::Void), Object::Bool(_) => Ok(obj.clone()), Object::Integer(n) => Ok(Object::Integer(*n)), Object::Symbol(s) => eval_symbol(s, env), Object::List(list) => eval_list(list, env), }\n} In the case of the atomic objects such as an integer and boolean, the evaluator simply returns a copy of the object. In the case of the Void and Lambda (function objects), it returns the Void object. We will now walk through the eval_symbol and eval_list functions which implement most of the functionality of the evaluator.","breadcrumbs":"Evaluator » Code Walk Through","id":"22","title":"Code Walk Through"},"23":{"body":"Before understanding the eval_symbol function, it is important to understand the design of how variables are implemented for the Lisp interpreter. The variables are just string labels assigned to values and they are created using the define keyword. Note a variable can be assigned atomic values such as integer or a boolean or it can be assigned function objects ( (define x 1) (define sqr (lambda (r) (* r r))) ) The above Lisp code defines (or creates) two variables with the names x and sqr that represent an integer and function object respectively. Also, the scope of these variables lies within the list object that they are defined under. This is achieved by storing the mapping from the variable names (strings) to the objects in a map-like data structure called Env as shown below. // env.rs\npub struct Env { parent: Option<Rc<RefCell<Env>>>, vars: HashMap<String, Object>,\n} The interpreter creates an instance of Env at the start of the program to store the global variable definitions. In addition, for every function call, the interpreter creates a new instance of env and uses the new instance to evaluate the function call. This new instance of env contains the function parameters as well as a back pointer to the parent env instance from where the function is called as shown below with an example ( (define m 10) (define n 12) (define K 100) (define func1 (lambda (x) (+ x K))) (define func2 (lambda (x) (- x K))) (func1 m) (func2 n)\n) Function Call This concept will become clearer as we will walk through the code. The job of eval_symbol is to look up the Object bound to the symbol. This is done by recursively looking up in the passed env variable or any of its parent env until the root env of the program. let val = env.borrow_mut().get(s);\nif val.is_none() { return Err(format!(\"Unbound symbol: {}\", s));\n}\nOk(val.unwrap().clone())","breadcrumbs":"Evaluator » eval_symbol","id":"23","title":"eval_symbol"},"24":{"body":"The eval_list function is the core of the evaluator and is implemented as shown below. let head = &list[0];\nmatch head { Object::Symbol(s) => match s.as_str() { \"+\" | \"-\" | \"*\" | \"/\" | \"<\" | \">\" | \"=\" | \"!=\" => { return eval_binary_op(&list, env); } \"if\" => eval_if(&list, env), \"define\" => eval_define(&list, env), \"lambda\" => eval_function_definition(&list), _ => eval_function_call(&s, &list, env), }, _ => { let mut new_list = Vec::new(); for obj in list { let result = eval_obj(obj, env)?; match result { Object::Void => {} _ => new_list.push(result), } } Ok(Object::List(new_list)) }\n} This function peeks at the head of the list and if the head does not match the symbol object, it iterates all of the elements of the list recursively evaluating each element and returning a new list with the evaluated object values.","breadcrumbs":"Evaluator » eval_list","id":"24","title":"eval_list"},"25":{"body":"If the head of the list in the eval_list function matches the define keyword, for example (define sqr (lambda (x) (* x x))) the eval_define function calls eval_obj on the third argument of the list and assigns the evaluated object value to the symbol defined by the second argument in the list. The symbol and its object value are then stored in the current env . let sym = match &list[1] { Object::Symbol(s) => s.clone(), _ => return Err(format!(\"Invalid define\")),\n};\nlet val = eval_obj(&list[2], env)?;\nenv.borrow_mut().set(&sym, val); In the example above the symbol sqr and the function object representing the lambda will be stored in the current env . Once the function sqr has been defined in this manner, any latter code can access the corresponding function object by looking up the symbol sqr in env .","breadcrumbs":"Evaluator » Variable definitions","id":"25","title":"Variable definitions"},"26":{"body":"If the head of the list in the eval_list function matches a binary operator, the list is evaluated on the basis of the type of the binary operator, for example (+ x y) the eval_binary_op function calls the eval_obj on the second and third element of the list and performs the binary sum operation on the evaluated values.","breadcrumbs":"Evaluator » Binary operations","id":"26","title":"Binary operations"},"27":{"body":"If the head of the list in the eval_list function matches the if keyword, for example (if (> x y) (x) (y)) the eval_if function calls eval_obj on the second element of the list and depending upon whether the evaluated value is true or false, calls the eval_obj on either the third or fourth element of the list and returns the value let cond_obj = eval_obj(&list[1], env)?;\nlet cond = match cond_obj { Object::Bool(b) => b, _ => return Err(format!(\"Condition must be a boolean\")),\n}; if cond == true { return eval_obj(&list[2], env);\n} else { return eval_obj(&list[3], env);\n}","breadcrumbs":"Evaluator » If statement","id":"27","title":"If statement"},"28":{"body":"As mentioned earlier, the lambda (or function) object consists of two vectors Lambda(Vec<String>, Vec<Object>) If the head of the list in the eval_list function matches the lambda keyword, for example (lambda (x) (* x x)) the eval_function_definition function evaluates the second element of the list as a vector of parameter names. let params = match &list[1] { Object::List(list) => { let mut params = Vec::new(); for param in list { match param { Object::Symbol(s) => params.push(s.clone()), _ => return Err(format!(\"Invalid lambda parameter\")), } } params } _ => return Err(format!(\"Invalid lambda\")),\n}; The third element of the list is simply cloned as the function body. let body = match &list[2] { Object::List(list) => list.clone(), _ => return Err(format!(\"Invalid lambda\")),\n}; Ok(Object::Lambda(params, body)) The evaluated parameter and body vector are returned as the lambda object","breadcrumbs":"Evaluator » Lambda","id":"28","title":"Lambda"},"29":{"body":"If the head of the list is a Symbol object and it does not match any of the aforementioned keywords or binary operators, the interpreter assumes that the Symbol object maps to a Lambda (function object). An example of the function call in Lisp is as follows (find_max a b c) To evaluate this list the eval_function_call function is called. This function first performs the lookup for the function object using the function name, find_max in the case of this example. let lamdba = env.borrow_mut().get(s);\nif lamdba.is_none() { return Err(format!(\"Unbound symbol: {}\", s));\n} If the function object is found, a new env object is created. This new env object has a pointer to the parent env object. This is required to get the values of the variables not defined in the scope of the function. let mut new_env = Rc::new( RefCell::new( Env::extend(env.clone()))); The next step in evaluating the function call requires preparing the function parameters. This is done by iterating over the remainder of the list and evaluating each parameter. The parameter name and the evaluated object are then set in the new env object. for (i, param) in params.iter().enumerate() { let val = eval_obj(&list[i + 1], env)?; new_env.borrow_mut().set(param, val);\n} Finally, the function body is evaluated by passing the new_env, which contains the parameters to the function let new_body = body.clone();\nreturn eval_obj(&Object::List(new_body), &mut new_env);","breadcrumbs":"Evaluator » Function Call","id":"29","title":"Function Call"},"3":{"body":"integer boolean","breadcrumbs":"Overview » Data types","id":"3","title":"Data types"},"30":{"body":"","breadcrumbs":"REPL » REPL","id":"30","title":"REPL"},"31":{"body":"main.rs","breadcrumbs":"REPL » Source","id":"31","title":"Source"},"32":{"body":"The REPL is the simplest part of the interpreter implementation. It uses the linefeed crate to implement the functionality. The REPL first creates an instance of env to hold the global variables for the interpreter. let mut env = Rc::new(RefCell::new(env::Env::new())); The REPL is a simple while loop that takes one line as an input from the user, evaluates it, and prints out the evaluated object. The REPL is terminated if the user enters the exit keyword. while let ReadResult::Input(input) = reader.read_line().unwrap() { if input.eq(\"exit\") { break; } let val = eval::eval(input.as_ref(), &mut env)?; match val { Object::Void => {} Object::Integer(n) => println!(\"{}\", n), Object::Bool(b) => println!(\"{}\", b), Object::Symbol(s) => println!(\"{}\", s), Object::Lambda(params, body) => { println!(\"Lambda(\"); for param in params { println!(\"{} \", param); } println!(\")\"); for expr in body { println!(\" {}\", expr); } } _ => println!(\"{}\", val), }\n}","breadcrumbs":"REPL » Code Walk Through","id":"32","title":"Code Walk Through"},"33":{"body":"Congratulations!!! if you have made it so far, you now have a grasp of how to implement a Lisp interpreter in Rust. A few easy things to try next would be to add support for float point numbers, unsigned integers, and strings. Once you are able to successfully make these changes the next thing to try would be to add support for the List datatype followed by support for the functional constructs of map, filter, and reduce. With this knowledge, you should be then able to implement an interpreter for any non-trivial language.","breadcrumbs":"What's Next » What's next","id":"33","title":"What's next"},"4":{"body":"variable definition and assignment if-else function definition using lambdas function calls","breadcrumbs":"Overview » Statements","id":"4","title":"Statements"},"5":{"body":"define if-else lambda","breadcrumbs":"Overview » Keywords","id":"5","title":"Keywords"},"6":{"body":"Following are some of the sample programs that you will be able run using the interpreter ( (define factorial (lambda (n) (if (< n 1) 1 (* n (factorial (- n 1)))))) (factorial 5) ) ( (define pix 314) (define r 10) (define sqr (lambda (r) (* r r))) (define area (lambda (r) (* pix (sqr r)))) (area r) )","breadcrumbs":"Overview » Examples","id":"6","title":"Examples"},"7":{"body":"The interpreter will be implemented from scratch and without the help of any tools such as nom or pest . The interpreter implementation is broken down into four parts Lexer ~ 20 lines of code Parser ~ 60 lines of code Evaluator ~ 170 lines of code REPL ~ 30 lines of code The best way to understand the implementation of the interpreter is to check out the code and walk through it while reading this document. git clone https://github.com/vishpat/lisp-rs\ngit checkout 0.0.1 Once you thoroughly understand the implementation, you will be equipped to add new features to it, such as support for new data types like strings, floating-point numbers, lists, or functional programming constructs such as map, filter, reduce functions, etc.","breadcrumbs":"Overview » Interpreter","id":"7","title":"Interpreter"},"8":{"body":"To run the interpreter and get its REPL (Read-Eval-Print-Loop) cargo run","breadcrumbs":"Overview » REPL","id":"8","title":"REPL"},"9":{"body":"Lisp is an abbreviation for Lis t P rocessor. Every Lisp program is simply a list. The elements of this list can either be atomic values such as an integer or a string or another list. Thus a Lisp program is a recursive list as shown below. List Recursion The Lisp interpreter is a software program that parses the text of a Lisp program and creates an in-memory List-based recursive data structure. Once the Lisp program is represented as a data structure, interpreting the program involves recursively evaluating these lists. This is the core of what a Lisp interpreter does, there is nothing more to it. Simple and Beautiful. The following chapters in this book will walk you through the code that implements this interpreter. The interpreting process can be broken down into three phases. Lexing: Converting the Lisp program text into a stream of tokens. Parsing: Converting the stream of tokens into an in-memory recursive list data structure. Evaluation: Walking the in-memory recursive list and producing the final result. In addition, the final chapter will implement a simple REPL to evaluate the Lisp program.","breadcrumbs":"Introduction » Introduction","id":"9","title":"Introduction"}},"length":34,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"0":{".":{"1":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"0":{"0":{"df":1,"docs":{"23":{"tf":1.0}}},"df":2,"docs":{"23":{"tf":1.0},"6":{"tf":1.0}}},"2":{"df":1,"docs":{"23":{"tf":1.0}}},"7":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":5,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"6":{"tf":1.7320508075688772}}},"2":{")":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":1,"docs":{"7":{"tf":1.0}}},"df":1,"docs":{"13":{"tf":1.0}}},"3":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"1":{"4":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"6":{"tf":1.0}}},"6":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"4":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}},"df":6,"docs":{"12":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"32":{"tf":1.0}}},"a":{"b":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"d":{"d":{"df":3,"docs":{"18":{"tf":1.0},"33":{"tf":1.4142135623730951},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"18":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":2,"docs":{"13":{"tf":1.0},"19":{"tf":1.0}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"4":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":6,"docs":{"12":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"9":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.0},"9":{"tf":1.0}}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":3,"docs":{"27":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":1,"docs":{"18":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":2.0},"29":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"17":{"tf":1.0},"28":{"tf":2.0},"29":{"tf":1.0},"32":{"tf":1.4142135623730951}}},"y":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"0":{"tf":1.0},"9":{"tf":1.0}}},"l":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"17":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"23":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"22":{"tf":1.4142135623730951},"29":{"tf":1.0}}}}},"df":1,"docs":{"29":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"19":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"7":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":11,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}}},"d":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.7320508075688772},"16":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"18":{"tf":1.0},"24":{"tf":1.0},"9":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"18":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":2.0},"29":{"tf":1.0},"32":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":5,"docs":{"2":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"23":{"tf":3.1622776601683795},"24":{"tf":1.0},"25":{"tf":2.23606797749979},"29":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"23":{"tf":1.0},"25":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":3,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"33":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951}}}},"v":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":7,"docs":{"22":{"tf":2.0},"23":{"tf":3.0},"24":{"tf":2.23606797749979},"25":{"tf":2.0},"27":{"tf":1.7320508075688772},"29":{"tf":2.23606797749979},"32":{"tf":1.7320508075688772}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"25":{"tf":1.0},"28":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"18":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}}}},"t":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}},"e":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}},"l":{"(":{"&":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"f":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":6,"docs":{"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"[":{"1":{"df":1,"docs":{"27":{"tf":1.0}}},"2":{"df":2,"docs":{"25":{"tf":1.0},"27":{"tf":1.0}}},"3":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":2,"docs":{"22":{"tf":1.0},"24":{"tf":1.0}}}},"df":0,"docs":{}}},"df":4,"docs":{"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"df":1,"docs":{"22":{"tf":1.0}}},"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"8":{"tf":1.0}},"u":{"df":13,"docs":{"17":{"tf":1.0},"20":{"tf":2.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":2.23606797749979},"32":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":8,"docs":{"12":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}},"r":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"33":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.0},"7":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"18":{"tf":1.0},"20":{"tf":1.4142135623730951},"29":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"d":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"22":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"1":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"18":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":3,"docs":{"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"7":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"1":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":15,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":2.0},"20":{"tf":1.0},"22":{"tf":2.449489742783178},"23":{"tf":2.8284271247461903},"24":{"tf":1.4142135623730951},"25":{"tf":2.23606797749979},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":2.0},"29":{"tf":3.605551275463989},"32":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":3,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":6,"docs":{"24":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"0":{"tf":2.0},"1":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"7":{"tf":2.0},"9":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"n":{"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"22":{"tf":1.0},"32":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"23":{"tf":2.23606797749979},"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":8,"docs":{"12":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"33":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"6":{"4":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":13,"docs":{"0":{"tf":2.449489742783178},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"29":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.0},"9":{"tf":2.23606797749979}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0}}}}}},"j":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"16":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{},"y":{"df":1,"docs":{"0":{"tf":1.0}}}}},"k":{"df":1,"docs":{"23":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":7,"docs":{"23":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"1":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.0},"23":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"b":{"d":{"a":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":10,"docs":{"17":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":2.8284271247461903},"29":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"b":{"a":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}},"x":{"df":2,"docs":{"13":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"13":{"tf":1.0}}}},"df":5,"docs":{"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"7":{"tf":1.0}}}}}},"i":{"df":2,"docs":{"23":{"tf":1.0},"9":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"7":{"tf":2.0}},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":12,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":1.0},"9":{"tf":3.0}}},"t":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"[":{"0":{"df":1,"docs":{"24":{"tf":1.0}}},"1":{"df":2,"docs":{"25":{"tf":1.0},"28":{"tf":1.0}}},"2":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":18,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"18":{"tf":2.449489742783178},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":2.23606797749979},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":2.0},"29":{"tf":1.7320508075688772},"33":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":3.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"25":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.0}}}}},"p":{"df":2,"docs":{"32":{"tf":1.0},"8":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"18":{"tf":1.0}}}}}},"df":0,"docs":{}}},"m":{"a":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":1,"docs":{"0":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"17":{"tf":1.0},"33":{"tf":1.0}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"p":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}}},"t":{"c":{"df":0,"docs":{},"h":{"df":12,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"18":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":2.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.0},"29":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"23":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"28":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.4142135623730951}}}}},"df":3,"docs":{"23":{"tf":1.4142135623730951},"32":{"tf":1.0},"6":{"tf":2.0}},"e":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"1":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"w":{"_":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":4,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"29":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}}},"n":{"df":2,"docs":{"1":{"tf":1.0},"33":{"tf":1.0}},"e":{"df":1,"docs":{"18":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.0},"23":{"tf":1.0}}},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"w":{"df":3,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"2":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":2,"docs":{"22":{"tf":1.0},"24":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{"df":1,"docs":{"22":{"tf":1.0}}},"b":{"df":2,"docs":{"27":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"1":{"df":1,"docs":{"19":{"tf":1.0}}},"2":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":2,"docs":{"22":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"(":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"28":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"\"":{"+":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":10,"docs":{"17":{"tf":2.8284271247461903},"18":{"tf":1.7320508075688772},"20":{"tf":1.0},"22":{"tf":2.6457513110645907},"23":{"tf":2.449489742783178},"24":{"tf":1.4142135623730951},"25":{"tf":2.0},"28":{"tf":1.4142135623730951},"29":{"tf":3.1622776601683795},"32":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"*":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"c":{"df":5,"docs":{"12":{"tf":1.0},"25":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}},"df":2,"docs":{"18":{"tf":1.0},"32":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":2.0},"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"r":{"c":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"22":{"tf":1.0},"29":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"28":{"tf":2.23606797749979},"29":{"tf":1.0},"32":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"17":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":2.0}}}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.7320508075688772},"29":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":2.0},"18":{"tf":1.7320508075688772}}}}}}}}},"s":{"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"19":{"tf":1.0}}}},"df":5,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.7320508075688772},"20":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"df":3,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.0}}}}}}}},"df":1,"docs":{"9":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"26":{"tf":1.0},"29":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"32":{"tf":2.6457513110645907}}}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"18":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"9":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"2":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"12":{"tf":1.0}}},"df":10,"docs":{"0":{"tf":1.0},"12":{"tf":2.0},"16":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":2.8284271247461903}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"20":{"tf":1.0}}}},"df":0,"docs":{}}}}},"u":{"b":{"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"r":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"23":{"tf":1.7320508075688772},"6":{"tf":2.6457513110645907}},"e":{"a":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":10,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"9":{"tf":2.449489742783178}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"33":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":3,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":5,"docs":{"30":{"tf":1.0},"32":{"tf":2.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":7,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"18":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"27":{"tf":2.0},"28":{"tf":2.0},"29":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"s":{"df":2,"docs":{"0":{"tf":1.0},"7":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}},"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"33":{"tf":1.0}}}}}},"s":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"23":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"17":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"0":{"tf":1.0}}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"9":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"i":{"df":3,"docs":{"22":{"tf":1.0},"28":{"tf":1.0},"9":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"25":{"tf":2.0},"6":{"tf":1.4142135623730951}}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"27":{"tf":1.0},"4":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"33":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"u":{"b":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":6,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"7":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}}},"df":7,"docs":{"12":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":2.0},"29":{"tf":1.7320508075688772}}}}},"df":1,"docs":{"25":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":5,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0}}}}},"df":2,"docs":{"18":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"r":{"d":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":9,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"18":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"1":{"df":1,"docs":{"13":{"tf":1.0}}},"2":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"\"":{"+":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":6,"docs":{"12":{"tf":3.1622776601683795},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":3.3166247903554},"9":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":1,"docs":{"33":{"tf":1.4142135623730951}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"o":{"df":2,"docs":{"23":{"tf":1.0},"28":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"p":{"df":3,"docs":{"17":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}},"s":{"df":8,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}}}}}},"v":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772}},"u":{"df":10,"docs":{"12":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":1,"docs":{"23":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"22":{"tf":1.0},"23":{"tf":2.8284271247461903},"25":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":4,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":1,"docs":{"13":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"12":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":8,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"y":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"12":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}}}}},"x":{"df":6,"docs":{"12":{"tf":2.0},"23":{"tf":2.449489742783178},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772}}},"y":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.4142135623730951}}}}},"breadcrumbs":{"root":{"0":{".":{"0":{".":{"1":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"0":{"0":{"df":1,"docs":{"23":{"tf":1.0}}},"df":2,"docs":{"23":{"tf":1.0},"6":{"tf":1.0}}},"2":{"df":1,"docs":{"23":{"tf":1.0}}},"7":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":5,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"6":{"tf":1.7320508075688772}}},"2":{")":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":1,"docs":{"7":{"tf":1.0}}},"df":1,"docs":{"13":{"tf":1.0}}},"3":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"1":{"4":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"6":{"tf":1.0}}},"6":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"4":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}},"df":6,"docs":{"12":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"32":{"tf":1.0}}},"a":{"b":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"d":{"d":{"df":3,"docs":{"18":{"tf":1.0},"33":{"tf":1.4142135623730951},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"18":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":2,"docs":{"13":{"tf":1.0},"19":{"tf":1.0}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"4":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":6,"docs":{"12":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"9":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.0},"9":{"tf":1.0}}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":3,"docs":{"27":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":1,"docs":{"18":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":2.23606797749979},"29":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"17":{"tf":1.0},"28":{"tf":2.0},"29":{"tf":1.0},"32":{"tf":1.4142135623730951}}},"y":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"0":{"tf":1.0},"9":{"tf":1.0}}},"l":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"17":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"23":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":2.23606797749979},"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"22":{"tf":1.4142135623730951},"29":{"tf":1.0}}}}},"df":1,"docs":{"29":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"19":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"7":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":11,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"32":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}}},"d":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.7320508075688772},"16":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"18":{"tf":1.0},"24":{"tf":1.0},"9":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"18":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":2.0},"29":{"tf":1.0},"32":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":5,"docs":{"2":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"23":{"tf":3.1622776601683795},"24":{"tf":1.0},"25":{"tf":2.23606797749979},"29":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":3,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"33":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951}}}},"v":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":7,"docs":{"22":{"tf":2.0},"23":{"tf":3.0},"24":{"tf":2.23606797749979},"25":{"tf":2.0},"27":{"tf":1.7320508075688772},"29":{"tf":2.23606797749979},"32":{"tf":1.7320508075688772}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"25":{"tf":1.0},"28":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"18":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}}}},"t":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}},"e":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}},"l":{"(":{"&":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"f":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":6,"docs":{"22":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"[":{"1":{"df":1,"docs":{"27":{"tf":1.0}}},"2":{"df":2,"docs":{"25":{"tf":1.0},"27":{"tf":1.0}}},"3":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":2,"docs":{"22":{"tf":1.0},"24":{"tf":1.0}}}},"df":0,"docs":{}}},"df":4,"docs":{"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"df":1,"docs":{"22":{"tf":1.0}}},"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":2.0}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"8":{"tf":1.0}},"u":{"df":14,"docs":{"17":{"tf":1.0},"20":{"tf":2.449489742783178},"21":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":1.4142135623730951},"24":{"tf":2.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":2.449489742783178},"32":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":8,"docs":{"12":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}},"r":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"33":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.0},"7":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"18":{"tf":1.0},"20":{"tf":1.4142135623730951},"29":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"d":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"22":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"1":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"18":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":3,"docs":{"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"7":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"1":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":15,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":2.0},"20":{"tf":1.0},"22":{"tf":2.449489742783178},"23":{"tf":2.8284271247461903},"24":{"tf":1.4142135623730951},"25":{"tf":2.23606797749979},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":2.0},"29":{"tf":3.7416573867739413},"32":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":3,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":6,"docs":{"24":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"0":{"tf":2.0},"1":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"7":{"tf":2.0},"9":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"n":{"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"22":{"tf":1.0},"32":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"23":{"tf":2.23606797749979},"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":8,"docs":{"12":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"33":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"6":{"4":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":13,"docs":{"0":{"tf":2.449489742783178},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"29":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":2.23606797749979},"8":{"tf":1.0},"9":{"tf":2.23606797749979}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0}}}}}},"j":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"16":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{},"y":{"df":1,"docs":{"0":{"tf":1.0}}}}},"k":{"df":1,"docs":{"23":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":7,"docs":{"23":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"1":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.0},"23":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"b":{"d":{"a":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":10,"docs":{"17":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":3.0},"29":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"b":{"a":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}},"x":{"df":2,"docs":{"13":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"13":{"tf":1.0}}}},"df":6,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"7":{"tf":1.0}}}}}},"i":{"df":2,"docs":{"23":{"tf":1.0},"9":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"7":{"tf":2.0}},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":12,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":1.0},"9":{"tf":3.0}}},"t":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"[":{"0":{"df":1,"docs":{"24":{"tf":1.0}}},"1":{"df":2,"docs":{"25":{"tf":1.0},"28":{"tf":1.0}}},"2":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":18,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"18":{"tf":2.449489742783178},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":2.23606797749979},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":2.0},"29":{"tf":1.7320508075688772},"33":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":3.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"25":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.0}}}}},"p":{"df":2,"docs":{"32":{"tf":1.0},"8":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"18":{"tf":1.0}}}}}},"df":0,"docs":{}}},"m":{"a":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":1,"docs":{"0":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"17":{"tf":1.0},"33":{"tf":1.0}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"p":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}}},"t":{"c":{"df":0,"docs":{},"h":{"df":12,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"18":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":2.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.0},"29":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"23":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"28":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":7,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.4142135623730951}}}}},"df":3,"docs":{"23":{"tf":1.4142135623730951},"32":{"tf":1.0},"6":{"tf":2.0}},"e":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"1":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"w":{"_":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":4,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"29":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":2.23606797749979}}}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}}},"n":{"df":2,"docs":{"1":{"tf":1.0},"33":{"tf":1.0}},"e":{"df":1,"docs":{"18":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.0},"23":{"tf":1.0}}},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"w":{"df":3,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"2":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":2,"docs":{"22":{"tf":1.0},"24":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{"df":1,"docs":{"22":{"tf":1.0}}},"b":{"df":2,"docs":{"27":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"1":{"df":1,"docs":{"19":{"tf":1.0}}},"2":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":2,"docs":{"22":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"(":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"28":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"\"":{"+":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":10,"docs":{"17":{"tf":3.0},"18":{"tf":1.7320508075688772},"20":{"tf":1.0},"22":{"tf":2.6457513110645907},"23":{"tf":2.449489742783178},"24":{"tf":1.4142135623730951},"25":{"tf":2.0},"28":{"tf":1.4142135623730951},"29":{"tf":3.1622776601683795},"32":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"*":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"c":{"df":5,"docs":{"12":{"tf":1.0},"25":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}},"df":2,"docs":{"18":{"tf":1.0},"32":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":2.23606797749979},"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"r":{"c":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"22":{"tf":1.0},"29":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":9,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"28":{"tf":2.23606797749979},"29":{"tf":1.0},"32":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"17":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":2.0}}}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.7320508075688772},"29":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":2.0},"18":{"tf":1.7320508075688772}}}}}}}}},"s":{"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"19":{"tf":1.0}}}},"df":8,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":2.23606797749979},"19":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"df":3,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.0}}}}}}}},"df":1,"docs":{"9":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"26":{"tf":1.0},"29":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.4142135623730951}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"32":{"tf":2.6457513110645907}}}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"18":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"9":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"2":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"12":{"tf":1.0}}},"df":10,"docs":{"0":{"tf":1.0},"12":{"tf":2.0},"16":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":2.8284271247461903}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"20":{"tf":1.0}}}},"df":0,"docs":{}}}}},"u":{"b":{"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"r":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"23":{"tf":1.7320508075688772},"6":{"tf":2.6457513110645907}},"e":{"a":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":10,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"9":{"tf":2.449489742783178}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"33":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":3,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":6,"docs":{"30":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":7,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"18":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"27":{"tf":2.0},"28":{"tf":2.0},"29":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"s":{"df":2,"docs":{"0":{"tf":1.0},"7":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}},"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"33":{"tf":1.0}}}}}},"s":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"23":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"17":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"0":{"tf":1.0}}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"9":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"i":{"df":3,"docs":{"22":{"tf":1.0},"28":{"tf":1.0},"9":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"25":{"tf":2.0},"6":{"tf":1.4142135623730951}}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"27":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"33":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"u":{"b":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":6,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"7":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}}},"df":7,"docs":{"12":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":2.0},"29":{"tf":1.7320508075688772}}}}},"df":1,"docs":{"25":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":5,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0}}}}},"df":2,"docs":{"18":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":2.0},"19":{"tf":2.0}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"r":{"d":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":9,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"32":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"18":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"1":{"df":1,"docs":{"13":{"tf":1.0}}},"2":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"\"":{"+":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":6,"docs":{"12":{"tf":3.1622776601683795},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":3.3166247903554},"9":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":1,"docs":{"33":{"tf":1.4142135623730951}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"o":{"df":2,"docs":{"23":{"tf":1.0},"28":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"p":{"df":3,"docs":{"17":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}},"s":{"df":8,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}}}}}},"v":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772}},"u":{"df":10,"docs":{"12":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":1,"docs":{"23":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"22":{"tf":1.0},"23":{"tf":2.8284271247461903},"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":4,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":1,"docs":{"13":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"12":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":8,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"32":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"y":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"12":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}}}}},"x":{"df":6,"docs":{"12":{"tf":2.0},"23":{"tf":2.449489742783178},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772}}},"y":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.4142135623730951}}}}},"title":{"root":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"18":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"30":{"tf":1.0},"8":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"4":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"19":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":4,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});