//! # Art
//!
//! A library for modeling artistic concepts.

pub use self::kinds::PrimaryColor;
pub use self::kinds::SecondaryColor;
pub use self::utils::mix;
pub mod kinds {
    /// The primary colors according to the RYB color model.
    #[derive(PartialEq, Debug)]
    pub enum PrimaryColor {
        Red,
        Yellow,
        Blue,
    }

    /// The secondary colors according to the RYB color model.
    #[derive(PartialEq, Debug)]
    pub enum SecondaryColor {
        Orange,
        Green,
        Purple,
    }
}

pub mod utils {
    use crate::kinds::*;

    /// Combines two primary colors in equal amounts to create
    /// a secondary color.
    pub fn mix(c1: PrimaryColor, c2: PrimaryColor) -> SecondaryColor {
        if c1 == PrimaryColor::Red || c2 == PrimaryColor::Red {
            return SecondaryColor::Purple;
        } else if c1 == c2 {
            return SecondaryColor::Green;
        } else {
            return SecondaryColor::Orange;
        }
    }
}

#[cfg(test)]
mod tests {
    use super::*;
    #[test]
    fn primary_color_red() {
        let color = mix(PrimaryColor::Red, PrimaryColor::Red);
        assert_eq!(color, SecondaryColor::Purple)
    }
}
