use std::io::Write;

use anyhow::Result;
use assert_cmd::Command;
use predicates::prelude::*;
use tempfile::NamedTempFile;

static NAME: &str = "matcher";

#[test]
fn test_file_does_not_exist() -> Result<()> {
    let path = "doesnotexist.txt";
    let pattern = ".";

    let mut cmd = Command::cargo_bin(NAME)?;
    cmd.arg(&pattern).arg(&path);
    cmd.assert()
        .failure()
        .stderr(predicate::str::contains("could not open file"));

    Ok(())
}

#[test]
fn test_find_matches() -> Result<()> {
    let mut file = NamedTempFile::new()?;
    writeln!(file, "A test\nActual content\nMore content\nAnother text")?;
    file.flush()?;

    let mut cmd = Command::cargo_bin(NAME)?;
    cmd.arg("content").arg(file.path());
    cmd.assert()
        .success()
        .stdout(predicate::str::contains("Actual content")
            .and(predicate::str::contains("More content"))
            .and(predicate::str::contains("Another text").not()));

    Ok(())
}
