// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


// Implementation is generated by `strum` in `ModuleParameterValueChoice`.
impl ModuleParameterValueKind
{
	/// Read.
	#[inline(always)]
	pub fn read(self, sys_path: &SysPath, module_name: &LinuxKernelModuleName, parameter_name: &CStr) -> io::Result<Option<ModuleParameterValueChoice>>
	{
		match self
		{
			ModuleParameterValueKind::byte => u8::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::byte)),
			
			ModuleParameterValueKind::short => i16::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::short)),
			
			ModuleParameterValueKind::ushort => u16::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::ushort)),
			
			ModuleParameterValueKind::int => i32::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::int)),
			
			ModuleParameterValueKind::uint => u32::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::uint)),
			
			ModuleParameterValueKind::long => isize::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::long)),
			
			ModuleParameterValueKind::ulong => usize::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::ulong)),
			
			ModuleParameterValueKind::ullong => u64::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::ullong)),
			
			ModuleParameterValueKind::charp => StringLinuxKernelModuleParameterValue::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::charp)),
			
			ModuleParameterValueKind::bool => bool::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::bool)),
			
			ModuleParameterValueKind::invbool => InverseBooleanModuleParameterValue::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::invbool)),
			
			ModuleParameterValueKind::intel_ixgbevf_debug_level => IntelIxgbevfDebugLevelModuleParameterValue::read_linux_module_parameter(sys_path, module_name, parameter_name).map(|option| option.map(ModuleParameterValueChoice::intel_ixgbevf_debug_level)),
		}
	}
}
