// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


/// This does not really exist.
#[non_exhaustive]
#[derive(Debug, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[repr(u16)]
pub(crate) enum IFLA_AF_SPEC
{
	#[allow(dead_code)]
	IFLA_AF_SPEC_INET = AF_INET as u16,
	
	#[allow(dead_code)]
	IFLA_AF_SPEC_INET6 = AF_INET6 as u16,
}

impl From<u16> for IFLA_AF_SPEC
{
	#[inline(always)]
	fn from(value: u16) -> Self
	{
		unsafe { transmute(value) }
	}
}

impl NetlinkAttributeType for IFLA_AF_SPEC
{
	#[inline(always)]
	fn to_u16(self) -> u16
	{
		self as u16
	}
}
