// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


use super::*;
use crate::bpf::JustInTimeCompilationChoice;
use crate::bpf::JustInTimeCompilationHardening;
use crate::bpf::JustInTimeMemoryAllocationLimitSizeInBytes;
use crate::bpf::c::BPF_MAP_CREATE_flags;
use crate::bpf::c::BPF_TAG_SIZE;
use crate::bpf::c::bpf_map_type;
use crate::bpf::c::bpf_prog_type;
use crate::bpf::extended::BpfMountPoint;
use crate::bpf::extended::bpf_type_format::BpfTypeFormatTypeIdentifier;
use crate::bpf::extended::identifiers::BpfTypeFormatIdentifier;
use crate::bpf::extended::identifiers::ExtendedBpfProgramIdentifier;
use crate::bpf::extended::identifiers::Identifier;
use crate::bpf::extended::identifiers::MapIdentifier;
use crate::bpf::extended::maps::domain::access_permissions::KernelOnlyAccessPermissions;
use crate::bpf::extended::maps::domain::MapName;
use crate::bpf::extended::maps::domain::MaximumEntries;
use crate::bpf::extended::maps::domain::KeySize;
use crate::bpf::extended::programs::ProgramName;
use crate::bpf::extended::programs::Information;
use crate::capabilities_and_privileges::AmbientCapabilitySet;
use crate::capabilities_and_privileges::BoundingCapabilitySet;
use crate::capabilities_and_privileges::PermittedEffectiveAndInheritableCapabilitySets;
use crate::cgroups::version2::Cgroup;
use crate::cgroups::version2::CgroupMountPoint;
use crate::cgroups::version2::CgroupName;
use crate::cgroups::version2::Controllers;
use crate::cgroups::version2::MaximumNumber;
use crate::cgroups::version2::NonRootCgroup;
use crate::cgroups::version2::NonRootCgroupType;
use crate::cgroups::version2::RootCgroup;
use crate::cgroups::version2::child_cgroup_names;
use crate::cgroups::version2::controllers::cpu::*;
use crate::cgroups::version2::controllers::cpuset::*;
use crate::cgroups::version2::controllers::hugetlb::*;
use crate::cgroups::version2::controllers::memory::*;
use crate::cgroups::version2::controllers::pids::*;
use crate::cgroups::version2::controllers::rdma::*;
use crate::cgroups::version2::statistics::Statistics;
use crate::cgroups::version2::statistics::EventStatistics;
use crate::cpu::HyperThreadingStatus;
use crate::cpu::HyperThreads;
use crate::cpu::cpu_supports_1gb_pages;
use crate::cpu::maximum_logical_processor_identifiers_per_package;
use crate::environment::CommandLine;
use crate::environment::Environment;
use crate::file_descriptors::OnDiskFileDescriptor;
use crate::file_descriptors::bpf::BpfFileDescriptor;
use crate::file_descriptors::bpf::ExtendedBpfProgramCanBeAttachedFileDescriptor;
use crate::file_descriptors::bpf::MapFileDescriptor;
use crate::file_descriptors::bpf::ExtendedBpfProgramFileDescriptor;
use crate::file_descriptors::bpf::BpfTypeFormatFileDescriptor;
use crate::file_descriptors::directory::DirectoryFileDescriptor;
use crate::file_descriptors::netlink::NetlinkSocketFileDescriptor;
use crate::file_descriptors::netlink::route::RouteNetlinkProtocol;
use crate::file_descriptors::netlink::route::get_address::{GetInternetProtocolVersion6AddressMessageData, GetInternetProtocolVersion4AddressMessageData, GetInternetProtocolVersion6OtherCastAddressMessageData};
use crate::file_descriptors::netlink::route::get_link::GetLinkMessageData;
use crate::file_descriptors::netlink::route::express_data_path::GetExpressDataPathDiagnosticsMessageData;
use crate::file_handles::AllocatedFreeAndMaximumNumberOfFileHandles;
use crate::file_handles::NumberOfFileHandles;
use crate::file_systems::FileSystemType;
use crate::file_systems::FileSystemTypeList;
use crate::file_systems::FileSystemMountFlags;
use crate::inode::Inode;
use crate::inode::NumberOfInodes;
use crate::interrupt_request::{InterruptRequest, InterruptRequestType, InterruptRequestWakeUp, InterruptRequestActionName};
use crate::interrupt_request::SpuriousInterruptRequestInformation;
use crate::io_priority::IoPriority;
use crate::linux_kernel_command_line::LinuxKernelCommandLineParameters;
use crate::linux_kernel_lock_down::LockDownState;
use crate::linux_kernel_modules::LinuxKernelModuleName;
use crate::linux_kernel_modules::LinuxKernelModulesList;
use crate::linux_kernel_version::LinuxKernelDomainName;
use crate::linux_kernel_version::LinuxKernelHostName;
use crate::linux_kernel_version::LinuxKernelVersion;
use crate::memory::huge_pages::DefaultHugePageSizes;
use crate::memory::huge_pages::GlobalHugePagePoolSize;
use crate::memory::huge_pages::HugePagePoolStatistics;
use crate::memory::huge_pages::HugePageSize;
use crate::memory::information::MemoryInformation;
use crate::memory::information::VirtualMemoryStatisticName;
use crate::memory::memory_maps::MemoryMaps;
use crate::memory::numa::MemoryLatencyRelativeCost;
use crate::memory::numa::MemoryPolicy;
use crate::memory::numa::MemoryPolicyDynamism;
use crate::memory::numa::NumaNodes;
use crate::mounts::Mount;
use crate::mounts::Mounts;
use crate::mounts::VirtualFileSystemMountPoint;
use crate::network_device::*;
use crate::network_device::c::*;
use crate::network_device::coalescing::CoalesceConfiguration;
use crate::network_device::eeprom::*;
use crate::network_device::energy_efficient_ethernet::EnergyEfficientEthernetInformation;
use crate::network_device::pause::PauseConfiguration;
use crate::network_device::queues::*;
use crate::network_device::receive_side_scaling::{HashFunctionConfiguration, ReceiveFlowSteeringFlowCount};
use crate::network_device::string_sets::AllStringSets;
use crate::network_device::tunables::*;
use crate::network_device::wake_on_lan::WakeOnLanInformation;
use crate::paths::*;
use crate::pci_express::*;
use crate::pci_express::resources::ResourceEntry;
use crate::personality::PersonalityFlags;
use crate::pressure_stall::{MemoryOrInputOutputTimeStalled, CpuTimeStalled};
use crate::process::*;
use crate::process::stat::Stat;
use crate::process::statm::StatM;
use crate::process::status::Status;
use crate::process_control::*;
use crate::process_control::c::PR_GET_IO_FLUSHER;
use crate::resource_limits::ResourceLimitsSet;
use crate::scheduling::*;
use crate::signals::Signal;
use crate::speculation_mitigation::SpeculationMitigation;
use crate::swap::*;
use crate::thread::*;
use crate::time::*;
use crate::user_and_groups::*;
use crate::file_descriptors::cgroup::{CgroupProgramAttachmentType, CgroupProgramQueryFlags, CgroupProgramAttachmentFlags};
use crate::network_device::link_settings::LinkSettings;
use crate::configuration::Milliseconds;
use crate::network_device::receive_side_scaling::hash_function_fields::*;


include!("CommonCgroupVersion2Diagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuCacheInformationDiagnostic.rs");
#[cfg(target_arch = "x86_64")] include!("CpuCacheParameterInformationDiagnostic.rs");
#[cfg(target_arch = "x86_64")] include!("CpuDeterministicAddressTranslationInformationDiagonostic.rs");
#[cfg(target_arch = "x86_64")] include!("CpuExtendedFeatureInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuExtendedFunctionInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuExtendedStateInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuExtendedTopologyLevelInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuFeatureInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuHigherExtendedStateInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuHypervisorInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuIntelEnclavePageCacheDiagnostic.rs");
#[cfg(target_arch = "x86_64")] include!("CpuIntelSgxInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuIntelResourceDirectorTechnologyInformation.rs");
#[cfg(target_arch = "x86_64")] include!("CpuLayer2CacheAllocationIntelResourceDirectorTechnologyInformation.rs");
#[cfg(target_arch = "x86_64")] include!("CpuLayer3CacheAllocationIntelResourceDirectorTechnologyInformation.rs");
#[cfg(target_arch = "x86_64")] include!("CpuLayer3CacheMonitoringIntelResourceDirectorTechnologyInformation.rs");
#[cfg(target_arch = "x86_64")] include!("CpuMemoryBandwidthAllocationIntelResourceDirectorTechnologyInformation.rs");
#[cfg(target_arch = "x86_64")] include!("CpuMemoryEncryptionInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuMonitorMwaitInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuPerformanceMonitoringInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuProcessorFrequencyInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuProcessorTraceInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuSystemOnChipVendorInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuThermalPowerInformationDiagnostics.rs");
#[cfg(target_arch = "x86_64")] include!("CpuTimestampCounterInformationDiagnostics.rs");
include!("CurrentProcessDiagnostics.rs");
include!("CurrentThreadDiagnostic.rs");
include!("Diagnostics.rs");
include!("DiagnosticUnobtainable.rs");
include!("DiagnosticUnobtainableResult.rs");
include!("EnvironmentDiagnostic.rs");
include!("EtcGroupRecordDiagnostic.rs");
include!("EtcPasswdRecordDiagnostic.rs");
include!("ExtendedBerkeleyPacketFilterDiagnostics.rs");
include!("ExtendedBerkeleyPacketFilterIdentifierDiagnostic.rs");
include!("MapExtendedBerkeleyPacketFilterDiagnostic.rs");
include!("ProgramExtendedBerkeleyPacketFilterDiagnostic.rs");
include!("TypeFormatExtendedBerkeleyPacketFilterDiagnostic.rs");
include!("FileHandleDiagnostics.rs");
include!("FileSystemMetadataDiagnostics.rs");
include!("FileSystemsDiagnostics.rs");
include!("GroupIdentifierDiagnostic.rs");
include!("GroupsDiagnostics.rs");
include!("HugePageSizeMemoryDiagnostic.rs");
include!("HyperThreadDiagnostic.rs");
include!("HyperThreadsDiagnostics.rs");
include!("InodeDiagnostics.rs");
include!("InternetProtocolVersion4AddressesDiagnostic.rs");
include!("InternetProtocolVersion6AddressesDiagnostic.rs");
include!("InterruptRequestDiagnostics.rs");
include!("InterruptRequestDiagnostic.rs");
include!("LinuxKernelDiagnostic.rs");
include!("MemoryDiagnostics.rs");
include!("MiscellaneousProcessControlDiagnostics.rs");
include!("MountDiagnostic.rs");
include!("MountPointFileSystemDiagnostics.rs");
include!("NetworkDeviceDiagnostic.rs");
include!("NetworkDeviceDiagnostics.rs");
include!("NetworkDeviceInputOutputControlDiagnostic.rs");
include!("NetworkDeviceReceiveQueueDiagnostic.rs");
include!("NetworkDeviceTransmitQueueDiagnostic.rs");
include!("NonRootCgroupVersion2Diagnostics.rs");
include!("NonRootCgroupVersion2HugetlbDiagnostics.rs");
include!("NumaNodeMemoryDiagnostic.rs");
include!("NumaNodeMemoryDiagnostics.rs");
include!("PageSizeMemoryDiagnostics.rs");
include!("PciDeviceDiagnostics.rs");
include!("ProcessDiagnostics.rs");
include!("ProcSysFileDiagnostic.rs");
include!("RootCgroupVersion2Diagnostics.rs");
include!("SchedulingDiagnostics.rs");
include!("SwapDiagnostics.rs");
include!("ThreadDiagnostic.rs");
include!("UndocumentedError.rs");
include!("UserIdentifierDiagnostic.rs");
include!("UsersAndGroupsDiagnostics.rs");
include!("UsersDiagnostics.rs");
