// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


#[derive(Default, Debug, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub(super) struct IntelIxgbevfCoalescingStrategy;

impl CoalescingStrategy for IntelIxgbevfCoalescingStrategy
{
	#[inline(always)]
	fn coalesce_configuration(&self, paired_transmit_receive_queues: bool, receive_coalescing_preference: &ReceiveCoalescingPreference, transmit_coalescing_preference: &TransmitCoalescingPreference) -> CoalesceConfiguration
	{
		CoalesceConfiguration
		{
			adaptive_coalescing: None,
			
			receive_transmit: ReceiveTransmitCoalescing
			{
				receive: CoalescePair
				{
					microseconds:
					{
						let value = receive_coalescing_preference.interrupt_throttle_rate_setting.into();
						if value == 0
						{
							None
						}
						else
						{
							Some(new_non_zero_u32(value))
						}
					},
					
					maximum_frames: None,
				},
				
				transmit: CoalescePair
				{
					microseconds: if !paired_transmit_receive_queues
					{
						let value = transmit_coalescing_preference.interrupt_throttle_rate_setting.into();
						if value == 0
						{
							None
						}
						else
						{
							Some(new_non_zero_u32(value))
						}
					}
					else
					{
						None
					},
					
					maximum_frames: None,
				},
			},
			
			receive_transmit_whilst_irq_is_being_serviced_by_the_host: ReceiveTransmitCoalescing::DisabledWhereMaximumFramesUnsupported,
			
			low_packet_rate_packets_per_second_threshold: None,
			
			receive_transmit_at_low_packet_rate: ReceiveTransmitCoalescing::DisabledWhereMaximumFramesUnsupported,
			
			high_packet_rate_packets_per_second_threshold: None,
			
			receive_transmit_at_high_packet_rate: ReceiveTransmitCoalescing::DisabledWhereMaximumFramesUnsupported,
			
			statistics_block_coalesce_microseconds: None
		}
	}
}
