// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


/// Can not exceed `u16::MAX`.
///
/// Amount of time for a socket to linger.
///
/// Defaults to on with 5 seconds.
#[derive(Debug, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[derive(Deserialize, Serialize)]
#[serde(deny_unknown_fields)]
pub enum SocketLingerSeconds
{
	/// Off.
	Off,

	/// On.
	On(u16),
}

impl Default for SocketLingerSeconds
{
	#[inline(always)]
	fn default() -> Self
	{
		SocketLingerSeconds::On(5)
	}
}
