// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


/// Gets the maximum number of watches per user.
///
/// Reads from `/proc/sys/user/max_inotify_instances`.
///
/// Default is 8,192.
#[inline(always)]
pub fn maximum_number_of_watches_per_user_namespaced(proc_path: &ProcPath) -> NonZeroU32
{
	proc_path.sys_user_file_path("max_inotify_instances").read_value().unwrap()
}
