// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


use self::controller_configurations::*;
use super::*;
use crate::memory::huge_pages::DefaultHugePageSizes;


/// Controller configuration.
pub mod controller_configurations;


include!("BelowRootCgroupConfiguration.rs");
include!("CachedDesiredControllersAndOurDepth.rs");
include!("CgroupConfigurationVariant.rs");
include!("ChildCgroupConfiguration.rs");
include!("ChildrenCgroupConfiguration.rs");
include!("DomainCgroupConfiguration.rs");
include!("DomainCgroupConfigurationVariant.rs");
include!("DomainOrThreadedCgroupConfiguration.rs");
include!("Migration.rs");
include!("ProcessOrThreadIdentifierChoice.rs");
include!("RootCgroupConfiguration.rs");
include!("ThreadedCgroupConfiguration.rs");
include!("ThreadedCgroupConfigurationVariant.rs");
