// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


/// System calls wrapper.
#[derive(Debug, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[derive(EnumIter)]
#[derive(Deserialize, Serialize)]
#[serde(deny_unknown_fields)]
#[repr(usize)]
pub enum SYS
{
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] _llseek = 140,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] _newselect = 5022,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] _newselect = 142,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] _sysctl = 5152,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] _sysctl = 149,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] _sysctl = 149,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] _sysctl = 156,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] accept = 202,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] accept = 5042,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] accept = 330,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] accept = 202,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] accept = 43,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] accept4 = 242,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] accept4 = 5293,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] accept4 = 344,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] accept4 = 242,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] accept4 = 364,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] accept4 = 288,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] access = 5020,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] access = 33,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] access = 33,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] access = 21,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] acct = 89,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] acct = 5158,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] acct = 51,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] acct = 89,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] acct = 51,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] acct = 163,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] add_key = 217,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] add_key = 5239,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] add_key = 269,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] add_key = 217,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] add_key = 278,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] add_key = 248,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] adjtimex = 171,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] adjtimex = 5154,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] adjtimex = 124,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] adjtimex = 171,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] adjtimex = 124,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] adjtimex = 159,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] afs_syscall = 5176,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] afs_syscall = 137,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] afs_syscall = 137,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] afs_syscall = 183,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] alarm = 5037,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] alarm = 27,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] alarm = 27,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] alarm = 37,

	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] arch_prctl = 158,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] bdflush = 134,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] bdflush = 134,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] bind = 200,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] bind = 5048,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] bind = 327,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] bind = 200,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] bind = 361,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] bind = 49,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] bpf = 280,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] bpf = 5315,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] bpf = 361,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] bpf = 280,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] bpf = 351,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] bpf = 321,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] break_ = 17,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] brk = 214,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] brk = 5012,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] brk = 45,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] brk = 214,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] brk = 45,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] brk = 12,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] cachectl = 5198,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] cacheflush = 5197,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] capget = 90,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] capget = 5123,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] capget = 183,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] capget = 90,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] capget = 184,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] capget = 125,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] capset = 91,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] capset = 5124,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] capset = 184,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] capset = 91,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] capset = 185,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] capset = 126,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] chdir = 49,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] chdir = 5078,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] chdir = 12,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] chdir = 49,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] chdir = 12,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] chdir = 80,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] chmod = 5088,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] chmod = 15,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] chmod = 15,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] chmod = 90,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] chown = 5090,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] chown = 181,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] chown = 212,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] chown = 92,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] chroot = 51,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] chroot = 5156,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] chroot = 61,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] chroot = 51,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] chroot = 61,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] chroot = 161,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] clock_adjtime = 266,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] clock_adjtime = 5300,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] clock_adjtime = 347,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] clock_adjtime = 266,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] clock_adjtime = 337,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] clock_adjtime = 305,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] clock_getres = 114,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] clock_getres = 5223,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] clock_getres = 247,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] clock_getres = 114,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] clock_getres = 261,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] clock_getres = 229,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] clock_gettime = 113,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] clock_gettime = 5222,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] clock_gettime = 246,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] clock_gettime = 113,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] clock_gettime = 260,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] clock_gettime = 228,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] clock_nanosleep = 115,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] clock_nanosleep = 5224,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] clock_nanosleep = 248,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] clock_nanosleep = 115,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] clock_nanosleep = 262,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] clock_nanosleep = 230,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] clock_settime = 112,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] clock_settime = 5221,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] clock_settime = 245,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] clock_settime = 112,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] clock_settime = 259,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] clock_settime = 227,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] clone = 220,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] clone = 5055,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] clone = 120,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] clone = 220,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] clone = 120,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] clone = 56,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] clone3 = 435,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] clone3 = 5435,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] clone3 = 435,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] clone3 = 435,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] clone3 = 435,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] clone3 = 435,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] close = 57,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] close = 5003,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] close = 6,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] close = 57,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] close = 6,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] close = 3,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] connect = 203,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] connect = 5041,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] connect = 328,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] connect = 203,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] connect = 362,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] connect = 42,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] copy_file_range = 285,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] copy_file_range = 5320,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] copy_file_range = 379,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] copy_file_range = 285,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] copy_file_range = 375,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] copy_file_range = 326,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] creat = 5083,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] creat = 8,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] creat = 8,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] creat = 85,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] create_module = 5167,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] create_module = 127,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] create_module = 127,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] create_module = 174,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] delete_module = 106,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] delete_module = 5169,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] delete_module = 129,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] delete_module = 106,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] delete_module = 129,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] delete_module = 176,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] dup = 23,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] dup = 5031,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] dup = 41,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] dup = 23,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] dup = 41,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] dup = 32,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] dup2 = 5032,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] dup2 = 63,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] dup2 = 63,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] dup2 = 33,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] dup3 = 24,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] dup3 = 5286,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] dup3 = 316,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] dup3 = 24,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] dup3 = 326,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] dup3 = 292,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] epoll_create = 5207,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] epoll_create = 236,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] epoll_create = 249,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] epoll_create = 213,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] epoll_create1 = 20,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] epoll_create1 = 5285,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] epoll_create1 = 315,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] epoll_create1 = 20,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] epoll_create1 = 327,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] epoll_create1 = 291,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] epoll_ctl = 21,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] epoll_ctl = 5208,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] epoll_ctl = 237,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] epoll_ctl = 21,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] epoll_ctl = 250,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] epoll_ctl = 233,

	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] epoll_ctl_old = 214,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] epoll_pwait = 22,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] epoll_pwait = 5272,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] epoll_pwait = 303,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] epoll_pwait = 22,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] epoll_pwait = 312,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] epoll_pwait = 281,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] epoll_wait = 5209,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] epoll_wait = 238,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] epoll_wait = 251,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] epoll_wait = 232,

	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] epoll_wait_old = 215,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] eventfd = 5278,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] eventfd = 307,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] eventfd = 318,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] eventfd = 284,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] eventfd2 = 19,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] eventfd2 = 5284,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] eventfd2 = 314,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] eventfd2 = 19,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] eventfd2 = 323,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] eventfd2 = 290,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] execve = 221,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] execve = 5057,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] execve = 11,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] execve = 221,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] execve = 11,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] execve = 59,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] execveat = 281,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] execveat = 5316,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] execveat = 362,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] execveat = 281,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] execveat = 354,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] execveat = 322,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] exit = 93,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] exit = 5058,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] exit = 1,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] exit = 93,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] exit = 1,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] exit = 60,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] exit_group = 94,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] exit_group = 5205,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] exit_group = 234,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] exit_group = 94,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] exit_group = 248,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] exit_group = 231,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] faccessat = 48,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] faccessat = 5259,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] faccessat = 298,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] faccessat = 48,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] faccessat = 300,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] faccessat = 269,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fadvise64 = 223,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fadvise64 = 5215,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fadvise64 = 233,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fadvise64 = 223,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fadvise64 = 253,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fadvise64 = 221,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fallocate = 47,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fallocate = 5279,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fallocate = 309,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fallocate = 47,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fallocate = 314,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fallocate = 285,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fanotify_init = 262,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fanotify_init = 5295,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fanotify_init = 323,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fanotify_init = 262,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fanotify_init = 332,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fanotify_init = 300,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fanotify_mark = 263,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fanotify_mark = 5296,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fanotify_mark = 324,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fanotify_mark = 263,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fanotify_mark = 333,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fanotify_mark = 301,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fchdir = 50,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fchdir = 5079,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fchdir = 133,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fchdir = 50,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fchdir = 133,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fchdir = 81,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fchmod = 52,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fchmod = 5089,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fchmod = 94,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fchmod = 52,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fchmod = 94,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fchmod = 91,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fchmodat = 53,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fchmodat = 5258,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fchmodat = 297,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fchmodat = 53,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fchmodat = 299,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fchmodat = 268,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fchown = 55,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fchown = 5091,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fchown = 95,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fchown = 55,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fchown = 207,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fchown = 93,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fchownat = 54,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fchownat = 5250,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fchownat = 289,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fchownat = 54,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fchownat = 291,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fchownat = 260,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fcntl = 25,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fcntl = 5070,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fcntl = 55,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fcntl = 25,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fcntl = 55,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fcntl = 72,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fdatasync = 83,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fdatasync = 5073,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fdatasync = 148,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fdatasync = 83,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fdatasync = 148,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fdatasync = 75,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fgetxattr = 10,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fgetxattr = 5185,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fgetxattr = 214,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fgetxattr = 10,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fgetxattr = 229,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fgetxattr = 193,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] finit_module = 273,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] finit_module = 5307,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] finit_module = 353,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] finit_module = 273,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] finit_module = 344,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] finit_module = 313,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] flistxattr = 13,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] flistxattr = 5188,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] flistxattr = 217,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] flistxattr = 13,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] flistxattr = 232,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] flistxattr = 196,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] flock = 32,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] flock = 5071,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] flock = 143,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] flock = 32,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] flock = 143,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] flock = 73,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fork = 5056,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fork = 2,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fork = 2,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fork = 57,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fremovexattr = 16,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fremovexattr = 5191,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fremovexattr = 220,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fremovexattr = 16,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fremovexattr = 235,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fremovexattr = 199,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fsconfig = 431,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fsconfig = 5431,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fsconfig = 431,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fsconfig = 431,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fsconfig = 431,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fsconfig = 431,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fsetxattr = 7,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fsetxattr = 5182,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fsetxattr = 211,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fsetxattr = 7,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fsetxattr = 226,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fsetxattr = 190,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fsmount = 432,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fsmount = 5432,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fsmount = 432,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fsmount = 432,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fsmount = 432,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fsmount = 432,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fsopen = 430,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fsopen = 5430,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fsopen = 430,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fsopen = 430,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fsopen = 430,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fsopen = 430,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fspick = 433,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fspick = 5433,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fspick = 433,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fspick = 433,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fspick = 433,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fspick = 433,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fstat = 80,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fstat = 5005,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fstat = 108,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fstat = 80,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fstat = 108,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fstat = 5,

	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fstatat = 79,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fstatfs = 44,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fstatfs = 5135,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fstatfs = 100,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fstatfs = 44,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fstatfs = 100,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fstatfs = 138,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fstatfs64 = 253,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fstatfs64 = 266,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] fsync = 82,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] fsync = 5072,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] fsync = 118,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] fsync = 82,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] fsync = 118,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] fsync = 74,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ftime = 35,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] ftruncate = 46,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] ftruncate = 5075,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ftruncate = 93,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] ftruncate = 46,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] ftruncate = 93,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] ftruncate = 77,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] futex = 98,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] futex = 5194,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] futex = 221,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] futex = 98,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] futex = 238,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] futex = 202,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] futimesat = 5251,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] futimesat = 290,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] futimesat = 292,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] futimesat = 261,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] get_kernel_syms = 5170,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] get_kernel_syms = 130,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] get_kernel_syms = 130,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] get_kernel_syms = 177,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] get_mempolicy = 236,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] get_mempolicy = 5228,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] get_mempolicy = 260,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] get_mempolicy = 236,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] get_mempolicy = 269,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] get_mempolicy = 239,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] get_robust_list = 100,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] get_robust_list = 5269,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] get_robust_list = 299,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] get_robust_list = 100,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] get_robust_list = 305,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] get_robust_list = 274,

	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] get_thread_area = 211,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getcpu = 168,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getcpu = 5271,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getcpu = 302,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getcpu = 168,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getcpu = 311,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getcpu = 309,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getcwd = 17,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getcwd = 5077,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getcwd = 182,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getcwd = 17,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getcwd = 183,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getcwd = 79,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getdents = 5076,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getdents = 141,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getdents = 141,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getdents = 78,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getdents64 = 61,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getdents64 = 5308,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getdents64 = 202,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getdents64 = 61,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getdents64 = 220,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getdents64 = 217,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getegid = 177,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getegid = 5106,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getegid = 50,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getegid = 177,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getegid = 202,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getegid = 108,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] geteuid = 175,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] geteuid = 5105,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] geteuid = 49,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] geteuid = 175,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] geteuid = 201,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] geteuid = 107,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getgid = 176,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getgid = 5102,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getgid = 47,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getgid = 176,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getgid = 200,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getgid = 104,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getgroups = 158,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getgroups = 5113,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getgroups = 80,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getgroups = 158,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getgroups = 205,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getgroups = 115,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getitimer = 102,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getitimer = 5035,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getitimer = 105,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getitimer = 102,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getitimer = 105,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getitimer = 36,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getpeername = 205,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getpeername = 5051,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getpeername = 332,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getpeername = 205,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getpeername = 368,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getpeername = 52,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getpgid = 155,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getpgid = 5119,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getpgid = 132,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getpgid = 155,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getpgid = 132,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getpgid = 121,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getpgrp = 5109,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getpgrp = 65,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getpgrp = 65,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getpgrp = 111,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getpid = 172,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getpid = 5038,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getpid = 20,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getpid = 172,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getpid = 20,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getpid = 39,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getpmsg = 5174,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getpmsg = 187,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getpmsg = 188,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getpmsg = 181,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getppid = 173,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getppid = 5108,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getppid = 64,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getppid = 173,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getppid = 64,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getppid = 110,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getpriority = 141,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getpriority = 5137,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getpriority = 96,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getpriority = 141,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getpriority = 96,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getpriority = 140,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getrandom = 278,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getrandom = 5313,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getrandom = 359,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getrandom = 278,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getrandom = 349,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getrandom = 318,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getresgid = 150,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getresgid = 5118,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getresgid = 170,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getresgid = 150,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getresgid = 211,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getresgid = 120,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getresuid = 148,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getresuid = 5116,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getresuid = 165,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getresuid = 148,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getresuid = 209,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getresuid = 118,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getrlimit = 163,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getrlimit = 5095,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getrlimit = 76,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getrlimit = 163,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getrlimit = 191,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getrlimit = 97,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getrusage = 165,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getrusage = 5096,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getrusage = 77,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getrusage = 165,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getrusage = 77,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getrusage = 98,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getsid = 156,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getsid = 5122,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getsid = 147,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getsid = 156,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getsid = 147,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getsid = 124,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getsockname = 204,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getsockname = 5050,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getsockname = 331,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getsockname = 204,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getsockname = 367,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getsockname = 51,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getsockopt = 209,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getsockopt = 5054,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getsockopt = 340,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getsockopt = 209,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getsockopt = 365,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getsockopt = 55,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] gettid = 178,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] gettid = 5178,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] gettid = 207,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] gettid = 178,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] gettid = 236,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] gettid = 186,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] gettimeofday = 169,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] gettimeofday = 5094,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] gettimeofday = 78,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] gettimeofday = 169,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] gettimeofday = 78,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] gettimeofday = 96,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getuid = 174,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getuid = 5100,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getuid = 24,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getuid = 174,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getuid = 199,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getuid = 102,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] getxattr = 8,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] getxattr = 5183,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] getxattr = 212,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] getxattr = 8,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] getxattr = 227,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] getxattr = 191,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] gtty = 32,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] idle = 112,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] idle = 112,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] init_module = 105,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] init_module = 5168,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] init_module = 128,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] init_module = 105,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] init_module = 128,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] init_module = 175,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] inotify_add_watch = 27,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] inotify_add_watch = 5244,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] inotify_add_watch = 276,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] inotify_add_watch = 27,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] inotify_add_watch = 285,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] inotify_add_watch = 254,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] inotify_init = 5243,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] inotify_init = 275,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] inotify_init = 284,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] inotify_init = 253,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] inotify_init1 = 26,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] inotify_init1 = 5288,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] inotify_init1 = 318,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] inotify_init1 = 26,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] inotify_init1 = 324,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] inotify_init1 = 294,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] inotify_rm_watch = 28,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] inotify_rm_watch = 5245,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] inotify_rm_watch = 277,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] inotify_rm_watch = 28,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] inotify_rm_watch = 286,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] inotify_rm_watch = 255,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] io_cancel = 3,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] io_cancel = 5204,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] io_cancel = 231,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] io_cancel = 3,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] io_cancel = 247,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] io_cancel = 210,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] io_destroy = 1,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] io_destroy = 5201,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] io_destroy = 228,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] io_destroy = 1,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] io_destroy = 244,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] io_destroy = 207,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] io_getevents = 4,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] io_getevents = 5202,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] io_getevents = 229,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] io_getevents = 4,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] io_getevents = 245,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] io_getevents = 208,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] io_pgetevents = 292,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] io_pgetevents = 5328,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] io_pgetevents = 388,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] io_pgetevents = 292,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] io_pgetevents = 382,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] io_pgetevents = 333,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] io_setup = 0,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] io_setup = 5200,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] io_setup = 227,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] io_setup = 0,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] io_setup = 243,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] io_setup = 206,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] io_submit = 2,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] io_submit = 5203,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] io_submit = 230,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] io_submit = 2,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] io_submit = 246,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] io_submit = 209,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] io_uring_enter = 426,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] io_uring_enter = 5426,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] io_uring_enter = 426,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] io_uring_enter = 426,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] io_uring_enter = 426,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] io_uring_enter = 426,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] io_uring_register = 427,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] io_uring_register = 5427,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] io_uring_register = 427,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] io_uring_register = 427,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] io_uring_register = 427,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] io_uring_register = 427,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] io_uring_setup = 425,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] io_uring_setup = 5425,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] io_uring_setup = 425,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] io_uring_setup = 425,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] io_uring_setup = 425,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] io_uring_setup = 425,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] ioctl = 29,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] ioctl = 5015,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ioctl = 54,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] ioctl = 29,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] ioctl = 54,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] ioctl = 16,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ioperm = 101,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] ioperm = 173,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] iopl = 110,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] iopl = 172,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] ioprio_get = 31,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] ioprio_get = 5274,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ioprio_get = 274,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] ioprio_get = 31,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] ioprio_get = 283,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] ioprio_get = 252,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] ioprio_set = 30,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] ioprio_set = 5273,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ioprio_set = 273,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] ioprio_set = 30,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] ioprio_set = 282,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] ioprio_set = 251,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ipc = 117,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] ipc = 117,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] kcmp = 272,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] kcmp = 5306,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] kcmp = 354,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] kcmp = 272,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] kcmp = 343,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] kcmp = 312,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] kexec_file_load = 294,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] kexec_file_load = 382,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] kexec_file_load = 294,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] kexec_file_load = 381,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] kexec_file_load = 320,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] kexec_load = 104,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] kexec_load = 5270,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] kexec_load = 268,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] kexec_load = 104,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] kexec_load = 277,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] kexec_load = 246,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] keyctl = 219,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] keyctl = 5241,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] keyctl = 271,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] keyctl = 219,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] keyctl = 280,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] keyctl = 250,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] kill = 129,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] kill = 5060,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] kill = 37,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] kill = 129,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] kill = 37,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] kill = 62,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] lchown = 5092,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] lchown = 16,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] lchown = 198,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] lchown = 94,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] lgetxattr = 9,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] lgetxattr = 5184,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] lgetxattr = 213,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] lgetxattr = 9,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] lgetxattr = 228,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] lgetxattr = 192,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] link = 5084,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] link = 9,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] link = 9,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] link = 86,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] linkat = 37,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] linkat = 5255,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] linkat = 294,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] linkat = 37,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] linkat = 296,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] linkat = 265,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] listen = 201,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] listen = 5049,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] listen = 329,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] listen = 201,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] listen = 363,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] listen = 50,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] listxattr = 11,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] listxattr = 5186,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] listxattr = 215,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] listxattr = 11,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] listxattr = 230,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] listxattr = 194,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] llistxattr = 12,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] llistxattr = 5187,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] llistxattr = 216,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] llistxattr = 12,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] llistxattr = 231,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] llistxattr = 195,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] lock = 53,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] lookup_dcookie = 18,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] lookup_dcookie = 5206,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] lookup_dcookie = 235,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] lookup_dcookie = 18,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] lookup_dcookie = 110,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] lookup_dcookie = 212,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] lremovexattr = 15,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] lremovexattr = 5190,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] lremovexattr = 219,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] lremovexattr = 15,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] lremovexattr = 234,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] lremovexattr = 198,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] lseek = 62,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] lseek = 5008,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] lseek = 19,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] lseek = 62,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] lseek = 19,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] lseek = 8,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] lsetxattr = 6,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] lsetxattr = 5181,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] lsetxattr = 210,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] lsetxattr = 6,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] lsetxattr = 225,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] lsetxattr = 189,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] lstat = 5006,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] lstat = 107,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] lstat = 107,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] lstat = 6,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] madvise = 233,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] madvise = 5027,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] madvise = 205,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] madvise = 233,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] madvise = 219,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] madvise = 28,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mbind = 235,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mbind = 5227,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mbind = 259,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mbind = 235,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mbind = 268,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mbind = 237,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] membarrier = 283,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] membarrier = 5318,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] membarrier = 365,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] membarrier = 283,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] membarrier = 356,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] membarrier = 324,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] memfd_create = 279,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] memfd_create = 5314,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] memfd_create = 360,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] memfd_create = 279,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] memfd_create = 350,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] memfd_create = 319,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] migrate_pages = 238,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] migrate_pages = 5246,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] migrate_pages = 258,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] migrate_pages = 238,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] migrate_pages = 287,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] migrate_pages = 256,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mincore = 232,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mincore = 5026,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mincore = 206,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mincore = 232,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mincore = 218,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mincore = 27,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mkdir = 5081,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mkdir = 39,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mkdir = 39,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mkdir = 83,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mkdirat = 34,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mkdirat = 5248,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mkdirat = 287,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mkdirat = 34,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mkdirat = 289,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mkdirat = 258,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mknod = 5131,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mknod = 14,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mknod = 14,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mknod = 133,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mknodat = 33,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mknodat = 5249,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mknodat = 288,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mknodat = 33,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mknodat = 290,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mknodat = 259,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mlock = 228,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mlock = 5146,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mlock = 150,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mlock = 228,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mlock = 150,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mlock = 149,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mlock2 = 284,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mlock2 = 5319,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mlock2 = 378,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mlock2 = 284,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mlock2 = 374,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mlock2 = 325,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mlockall = 230,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mlockall = 5148,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mlockall = 152,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mlockall = 230,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mlockall = 152,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mlockall = 151,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mmap = 222,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mmap = 5009,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mmap = 90,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mmap = 222,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mmap = 90,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mmap = 9,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] modify_ldt = 123,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] modify_ldt = 154,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mount = 40,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mount = 5160,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mount = 21,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mount = 40,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mount = 21,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mount = 165,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] move_mount = 429,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] move_mount = 5429,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] move_mount = 429,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] move_mount = 429,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] move_mount = 429,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] move_mount = 429,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] move_pages = 239,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] move_pages = 5267,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] move_pages = 301,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] move_pages = 239,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] move_pages = 310,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] move_pages = 279,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mprotect = 226,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mprotect = 5010,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mprotect = 125,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mprotect = 226,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mprotect = 125,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mprotect = 10,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mpx = 56,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mq_getsetattr = 185,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mq_getsetattr = 5235,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mq_getsetattr = 267,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mq_getsetattr = 185,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mq_getsetattr = 276,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mq_getsetattr = 245,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mq_notify = 184,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mq_notify = 5234,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mq_notify = 266,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mq_notify = 184,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mq_notify = 275,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mq_notify = 244,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mq_open = 180,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mq_open = 5230,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mq_open = 262,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mq_open = 180,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mq_open = 271,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mq_open = 240,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mq_timedreceive = 183,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mq_timedreceive = 5233,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mq_timedreceive = 265,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mq_timedreceive = 183,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mq_timedreceive = 274,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mq_timedreceive = 243,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mq_timedsend = 182,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mq_timedsend = 5232,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mq_timedsend = 264,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mq_timedsend = 182,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mq_timedsend = 273,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mq_timedsend = 242,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mq_unlink = 181,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mq_unlink = 5231,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mq_unlink = 263,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mq_unlink = 181,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mq_unlink = 272,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mq_unlink = 241,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] mremap = 216,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] mremap = 5024,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] mremap = 163,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] mremap = 216,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] mremap = 163,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] mremap = 25,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] msgctl = 187,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] msgctl = 5069,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] msgctl = 402,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] msgctl = 187,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] msgctl = 402,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] msgctl = 71,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] msgget = 186,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] msgget = 5066,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] msgget = 399,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] msgget = 186,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] msgget = 399,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] msgget = 68,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] msgrcv = 188,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] msgrcv = 5068,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] msgrcv = 401,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] msgrcv = 188,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] msgrcv = 401,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] msgrcv = 70,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] msgsnd = 189,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] msgsnd = 5067,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] msgsnd = 400,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] msgsnd = 189,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] msgsnd = 400,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] msgsnd = 69,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] msync = 227,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] msync = 5025,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] msync = 144,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] msync = 227,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] msync = 144,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] msync = 26,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] multiplexer = 201,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] munlock = 229,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] munlock = 5147,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] munlock = 151,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] munlock = 229,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] munlock = 151,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] munlock = 150,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] munlockall = 231,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] munlockall = 5149,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] munlockall = 153,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] munlockall = 231,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] munlockall = 153,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] munlockall = 152,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] munmap = 215,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] munmap = 5011,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] munmap = 91,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] munmap = 215,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] munmap = 91,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] munmap = 11,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] name_to_handle_at = 264,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] name_to_handle_at = 5298,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] name_to_handle_at = 345,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] name_to_handle_at = 264,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] name_to_handle_at = 335,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] name_to_handle_at = 303,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] nanosleep = 101,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] nanosleep = 5034,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] nanosleep = 162,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] nanosleep = 101,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] nanosleep = 162,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] nanosleep = 35,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] newfstatat = 79,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] newfstatat = 5252,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] newfstatat = 291,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] newfstatat = 293,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] newfstatat = 262,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] nfsservctl = 42,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] nfsservctl = 5173,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] nfsservctl = 168,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] nfsservctl = 42,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] nfsservctl = 169,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] nfsservctl = 180,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] nice = 34,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] nice = 34,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] oldfstat = 28,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] oldlstat = 84,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] oldolduname = 59,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] oldstat = 18,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] olduname = 109,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] open = 5002,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] open = 5,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] open = 5,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] open = 2,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] open_by_handle_at = 265,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] open_by_handle_at = 5299,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] open_by_handle_at = 346,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] open_by_handle_at = 265,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] open_by_handle_at = 336,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] open_by_handle_at = 304,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] open_tree = 428,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] open_tree = 5428,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] open_tree = 428,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] open_tree = 428,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] open_tree = 428,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] open_tree = 428,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] openat = 56,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] openat = 5247,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] openat = 286,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] openat = 56,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] openat = 288,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] openat = 257,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] openat2 = 437,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] openat2 = 5437,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] openat2 = 437,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] openat2 = 437,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] openat2 = 437,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] openat2 = 437,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pause = 5033,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pause = 29,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pause = 29,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pause = 34,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pciconfig_iobase = 200,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pciconfig_read = 198,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pciconfig_write = 199,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] perf_event_open = 241,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] perf_event_open = 5292,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] perf_event_open = 319,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] perf_event_open = 241,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] perf_event_open = 331,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] perf_event_open = 298,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] personality = 92,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] personality = 5132,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] personality = 136,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] personality = 92,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] personality = 136,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] personality = 135,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pidfd_open = 434,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pidfd_open = 5434,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pidfd_open = 434,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pidfd_open = 434,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pidfd_open = 434,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pidfd_open = 434,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pidfd_getfd = 438,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pidfd_getfd = 5438,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pidfd_getfd = 438,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pidfd_getfd = 438,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pidfd_getfd = 438,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pidfd_getfd = 438,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pidfd_send_signal = 424,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pidfd_send_signal = 5424,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pidfd_send_signal = 424,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pidfd_send_signal = 424,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pidfd_send_signal = 424,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pidfd_send_signal = 424,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pipe = 5021,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pipe = 42,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pipe = 42,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pipe = 22,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pipe2 = 59,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pipe2 = 5287,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pipe2 = 317,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pipe2 = 59,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pipe2 = 325,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pipe2 = 293,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pivot_root = 41,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pivot_root = 5151,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pivot_root = 203,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pivot_root = 41,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pivot_root = 217,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pivot_root = 155,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pkey_alloc = 289,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pkey_alloc = 5324,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pkey_alloc = 384,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pkey_alloc = 289,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pkey_alloc = 385,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pkey_alloc = 330,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pkey_free = 290,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pkey_free = 5325,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pkey_free = 385,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pkey_free = 290,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pkey_free = 386,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pkey_free = 331,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pkey_mprotect = 288,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pkey_mprotect = 5323,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pkey_mprotect = 386,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pkey_mprotect = 288,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pkey_mprotect = 384,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pkey_mprotect = 329,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] poll = 5007,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] poll = 167,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] poll = 168,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] poll = 7,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] ppoll = 73,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] ppoll = 5261,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ppoll = 281,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] ppoll = 73,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] ppoll = 302,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] ppoll = 271,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] prctl = 167,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] prctl = 5153,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] prctl = 171,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] prctl = 167,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] prctl = 172,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] prctl = 157,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pread64 = 67,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pread64 = 5016,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pread64 = 179,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pread64 = 67,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pread64 = 180,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pread64 = 17,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] preadv = 69,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] preadv = 5289,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] preadv = 320,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] preadv = 69,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] preadv = 328,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] preadv = 295,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] preadv2 = 286,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] preadv2 = 5321,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] preadv2 = 380,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] preadv2 = 286,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] preadv2 = 376,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] preadv2 = 327,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] prlimit64 = 261,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] prlimit64 = 5297,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] prlimit64 = 325,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] prlimit64 = 261,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] prlimit64 = 334,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] prlimit64 = 302,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] process_vm_readv = 270,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] process_vm_readv = 5304,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] process_vm_readv = 351,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] process_vm_readv = 270,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] process_vm_readv = 340,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] process_vm_readv = 310,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] process_vm_writev = 271,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] process_vm_writev = 5305,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] process_vm_writev = 352,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] process_vm_writev = 271,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] process_vm_writev = 341,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] process_vm_writev = 311,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] prof = 44,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] profil = 98,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pselect6 = 72,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pselect6 = 5260,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pselect6 = 280,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pselect6 = 72,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pselect6 = 301,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pselect6 = 270,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] ptrace = 117,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] ptrace = 5099,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ptrace = 26,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] ptrace = 117,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] ptrace = 26,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] ptrace = 101,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] putpmsg = 5175,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] putpmsg = 188,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] putpmsg = 189,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] putpmsg = 182,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pwrite64 = 68,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pwrite64 = 5017,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pwrite64 = 180,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pwrite64 = 68,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pwrite64 = 181,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pwrite64 = 18,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pwritev = 70,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pwritev = 5290,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pwritev = 321,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pwritev = 70,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pwritev = 329,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pwritev = 296,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pwritev2 = 287,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pwritev2 = 5322,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pwritev2 = 381,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pwritev2 = 287,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pwritev2 = 377,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pwritev2 = 328,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] query_module = 5171,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] query_module = 166,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] query_module = 167,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] query_module = 178,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] quotactl = 60,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] quotactl = 5172,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] quotactl = 131,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] quotactl = 60,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] quotactl = 131,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] quotactl = 179,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] read = 63,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] read = 5000,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] read = 3,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] read = 63,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] read = 3,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] read = 0,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] readahead = 213,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] readahead = 5179,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] readahead = 191,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] readahead = 213,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] readahead = 222,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] readahead = 187,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] readdir = 89,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] readdir = 89,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] readlink = 5087,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] readlink = 85,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] readlink = 85,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] readlink = 89,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] readlinkat = 78,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] readlinkat = 5257,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] readlinkat = 296,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] readlinkat = 78,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] readlinkat = 298,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] readlinkat = 267,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] readv = 65,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] readv = 5018,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] readv = 145,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] readv = 65,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] readv = 145,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] readv = 19,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] reboot = 142,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] reboot = 5164,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] reboot = 88,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] reboot = 142,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] reboot = 88,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] reboot = 169,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] recv = 336,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] recvfrom = 207,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] recvfrom = 5044,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] recvfrom = 337,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] recvfrom = 207,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] recvfrom = 371,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] recvfrom = 45,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] recvmmsg = 243,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] recvmmsg = 5294,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] recvmmsg = 343,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] recvmmsg = 243,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] recvmmsg = 357,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] recvmmsg = 299,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] recvmsg = 212,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] recvmsg = 5046,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] recvmsg = 342,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] recvmsg = 212,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] recvmsg = 372,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] recvmsg = 47,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] remap_file_pages = 234,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] remap_file_pages = 5210,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] remap_file_pages = 239,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] remap_file_pages = 234,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] remap_file_pages = 267,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] remap_file_pages = 216,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] removexattr = 14,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] removexattr = 5189,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] removexattr = 218,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] removexattr = 14,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] removexattr = 233,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] removexattr = 197,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rename = 5080,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rename = 38,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rename = 38,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rename = 82,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] renameat = 38,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] renameat = 5254,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] renameat = 293,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] renameat = 295,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] renameat = 264,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] renameat2 = 276,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] renameat2 = 5311,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] renameat2 = 357,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] renameat2 = 276,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] renameat2 = 347,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] renameat2 = 316,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] request_key = 218,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] request_key = 5240,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] request_key = 270,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] request_key = 218,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] request_key = 279,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] request_key = 249,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] reserved177 = 5177,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] reserved193 = 5193,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] restart_syscall = 128,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] restart_syscall = 5213,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] restart_syscall = 0,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] restart_syscall = 128,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] restart_syscall = 7,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] restart_syscall = 219,

	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] riscv_flush_icache = 244 + 15,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rmdir = 5082,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rmdir = 40,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rmdir = 40,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rmdir = 84,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] rseq = 293,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rseq = 5327,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rseq = 387,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] rseq = 293,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rseq = 383,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rseq = 334,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] rt_sigaction = 134,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rt_sigaction = 5013,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rt_sigaction = 173,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] rt_sigaction = 134,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rt_sigaction = 174,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rt_sigaction = 13,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] rt_sigpending = 136,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rt_sigpending = 5125,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rt_sigpending = 175,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] rt_sigpending = 136,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rt_sigpending = 176,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rt_sigpending = 127,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] rt_sigprocmask = 135,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rt_sigprocmask = 5014,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rt_sigprocmask = 174,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] rt_sigprocmask = 135,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rt_sigprocmask = 175,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rt_sigprocmask = 14,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] rt_sigqueueinfo = 138,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rt_sigqueueinfo = 5127,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rt_sigqueueinfo = 177,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] rt_sigqueueinfo = 138,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rt_sigqueueinfo = 178,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rt_sigqueueinfo = 129,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] rt_sigreturn = 139,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rt_sigreturn = 5211,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rt_sigreturn = 172,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] rt_sigreturn = 139,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rt_sigreturn = 173,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rt_sigreturn = 15,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] rt_sigsuspend = 133,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rt_sigsuspend = 5128,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rt_sigsuspend = 178,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] rt_sigsuspend = 133,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rt_sigsuspend = 179,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rt_sigsuspend = 130,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] rt_sigtimedwait = 137,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rt_sigtimedwait = 5126,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rt_sigtimedwait = 176,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] rt_sigtimedwait = 137,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rt_sigtimedwait = 177,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rt_sigtimedwait = 128,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] rt_tgsigqueueinfo = 240,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] rt_tgsigqueueinfo = 5291,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rt_tgsigqueueinfo = 322,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] rt_tgsigqueueinfo = 240,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] rt_tgsigqueueinfo = 330,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] rt_tgsigqueueinfo = 297,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] rtas = 255,

	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] s390_guarded_storage = 378,

	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] s390_pci_mmio_read = 353,

	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] s390_pci_mmio_write = 352,

	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] s390_runtime_instr = 342,

	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] s390_sthyi = 380,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_get_priority_max = 125,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_get_priority_max = 5143,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_get_priority_max = 159,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_get_priority_max = 125,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_get_priority_max = 159,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_get_priority_max = 146,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_get_priority_min = 126,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_get_priority_min = 5144,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_get_priority_min = 160,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_get_priority_min = 126,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_get_priority_min = 160,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_get_priority_min = 147,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_getaffinity = 123,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_getaffinity = 5196,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_getaffinity = 223,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_getaffinity = 123,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_getaffinity = 240,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_getaffinity = 204,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_getattr = 275,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_getattr = 5310,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_getattr = 356,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_getattr = 275,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_getattr = 346,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_getattr = 315,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_getparam = 121,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_getparam = 5140,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_getparam = 155,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_getparam = 121,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_getparam = 155,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_getparam = 143,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_getscheduler = 120,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_getscheduler = 5142,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_getscheduler = 157,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_getscheduler = 120,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_getscheduler = 157,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_getscheduler = 145,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_rr_get_interval = 127,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_rr_get_interval = 5145,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_rr_get_interval = 161,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_rr_get_interval = 127,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_rr_get_interval = 161,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_rr_get_interval = 148,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_setaffinity = 122,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_setaffinity = 5195,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_setaffinity = 222,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_setaffinity = 122,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_setaffinity = 239,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_setaffinity = 203,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_setattr = 274,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_setattr = 5309,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_setattr = 355,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_setattr = 274,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_setattr = 345,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_setattr = 314,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_setparam = 118,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_setparam = 5139,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_setparam = 154,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_setparam = 118,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_setparam = 154,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_setparam = 142,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_setscheduler = 119,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_setscheduler = 5141,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_setscheduler = 156,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_setscheduler = 119,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_setscheduler = 156,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_setscheduler = 144,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sched_yield = 124,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sched_yield = 5023,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sched_yield = 158,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sched_yield = 124,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sched_yield = 158,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sched_yield = 24,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] seccomp = 277,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] seccomp = 5312,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] seccomp = 358,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] seccomp = 277,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] seccomp = 348,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] seccomp = 317,

	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] security = 185,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] select = 82,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] select = 142,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] select = 23,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] semctl = 191,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] semctl = 5064,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] semctl = 394,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] semctl = 191,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] semctl = 394,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] semctl = 66,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] semget = 190,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] semget = 5062,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] semget = 393,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] semget = 190,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] semget = 393,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] semget = 64,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] semop = 193,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] semop = 5063,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] semop = 193,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] semop = 65,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] semtimedop = 192,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] semtimedop = 5214,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] semtimedop = 392,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] semtimedop = 192,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] semtimedop = 392,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] semtimedop = 220,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] send = 334,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sendfile = 71,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sendfile = 5039,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sendfile = 186,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sendfile = 71,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sendfile = 187,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sendfile = 40,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sendmmsg = 269,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sendmmsg = 5302,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sendmmsg = 349,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sendmmsg = 269,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sendmmsg = 358,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sendmmsg = 307,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sendmsg = 211,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sendmsg = 5045,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sendmsg = 341,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sendmsg = 211,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sendmsg = 370,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sendmsg = 46,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sendto = 206,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sendto = 5043,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sendto = 335,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sendto = 206,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sendto = 369,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sendto = 44,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] set_mempolicy = 237,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] set_mempolicy = 5229,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] set_mempolicy = 261,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] set_mempolicy = 237,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] set_mempolicy = 270,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] set_mempolicy = 238,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] set_robust_list = 99,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] set_robust_list = 5268,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] set_robust_list = 300,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] set_robust_list = 99,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] set_robust_list = 304,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] set_robust_list = 273,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] set_thread_area = 5242,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] set_thread_area = 205,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] set_tid_address = 96,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] set_tid_address = 5212,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] set_tid_address = 232,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] set_tid_address = 96,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] set_tid_address = 252,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] set_tid_address = 218,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setdomainname = 162,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setdomainname = 5166,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setdomainname = 121,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setdomainname = 162,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setdomainname = 121,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setdomainname = 171,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setfsgid = 152,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setfsgid = 5121,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setfsgid = 139,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setfsgid = 152,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setfsgid = 216,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setfsgid = 123,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setfsuid = 151,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setfsuid = 5120,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setfsuid = 138,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setfsuid = 151,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setfsuid = 215,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setfsuid = 122,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setgid = 144,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setgid = 5104,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setgid = 46,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setgid = 144,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setgid = 214,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setgid = 106,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setgroups = 159,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setgroups = 5114,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setgroups = 81,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setgroups = 159,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setgroups = 206,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setgroups = 116,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sethostname = 161,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sethostname = 5165,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sethostname = 74,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sethostname = 161,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sethostname = 74,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sethostname = 170,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setitimer = 103,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setitimer = 5036,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setitimer = 104,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setitimer = 103,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setitimer = 104,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setitimer = 38,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setns = 268,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setns = 5303,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setns = 350,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setns = 268,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setns = 339,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setns = 308,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setpgid = 154,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setpgid = 5107,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setpgid = 57,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setpgid = 154,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setpgid = 57,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setpgid = 109,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setpriority = 140,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setpriority = 5138,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setpriority = 97,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setpriority = 140,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setpriority = 97,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setpriority = 141,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setregid = 143,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setregid = 5112,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setregid = 71,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setregid = 143,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setregid = 204,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setregid = 114,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setresgid = 149,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setresgid = 5117,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setresgid = 169,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setresgid = 149,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setresgid = 210,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setresgid = 119,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setresuid = 147,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setresuid = 5115,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setresuid = 164,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setresuid = 147,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setresuid = 208,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setresuid = 117,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setreuid = 145,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setreuid = 5111,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setreuid = 70,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setreuid = 145,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setreuid = 203,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setreuid = 113,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setrlimit = 164,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setrlimit = 5155,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setrlimit = 75,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setrlimit = 164,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setrlimit = 75,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setrlimit = 160,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setsid = 157,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setsid = 5110,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setsid = 66,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setsid = 157,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setsid = 66,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setsid = 112,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setsockopt = 208,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setsockopt = 5053,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setsockopt = 339,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setsockopt = 208,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setsockopt = 366,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setsockopt = 54,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] settimeofday = 170,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] settimeofday = 5159,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] settimeofday = 79,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] settimeofday = 170,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] settimeofday = 79,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] settimeofday = 164,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setuid = 146,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setuid = 5103,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setuid = 23,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setuid = 146,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setuid = 213,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setuid = 105,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] setxattr = 5,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] setxattr = 5180,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] setxattr = 209,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] setxattr = 5,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] setxattr = 224,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] setxattr = 188,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sgetmask = 68,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] shmat = 196,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] shmat = 5029,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] shmat = 397,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] shmat = 196,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] shmat = 397,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] shmat = 30,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] shmctl = 195,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] shmctl = 5030,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] shmctl = 396,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] shmctl = 195,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] shmctl = 396,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] shmctl = 31,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] shmdt = 197,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] shmdt = 5065,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] shmdt = 398,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] shmdt = 197,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] shmdt = 398,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] shmdt = 67,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] shmget = 194,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] shmget = 5028,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] shmget = 395,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] shmget = 194,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] shmget = 395,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] shmget = 29,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] shutdown = 210,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] shutdown = 5047,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] shutdown = 338,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] shutdown = 210,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] shutdown = 373,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] shutdown = 48,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sigaction = 67,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sigaction = 67,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sigaltstack = 132,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sigaltstack = 5129,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sigaltstack = 185,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sigaltstack = 132,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sigaltstack = 186,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sigaltstack = 131,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] signal = 48,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] signal = 48,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] signalfd = 5276,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] signalfd = 305,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] signalfd = 316,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] signalfd = 282,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] signalfd4 = 74,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] signalfd4 = 5283,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] signalfd4 = 313,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] signalfd4 = 74,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] signalfd4 = 322,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] signalfd4 = 289,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sigpending = 73,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sigpending = 73,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sigprocmask = 126,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sigprocmask = 126,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sigreturn = 119,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sigreturn = 119,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sigsuspend = 72,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sigsuspend = 72,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] socket = 198,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] socket = 5040,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] socket = 326,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] socket = 198,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] socket = 359,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] socket = 41,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] socketcall = 102,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] socketcall = 102,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] socketpair = 199,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] socketpair = 5052,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] socketpair = 333,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] socketpair = 199,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] socketpair = 360,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] socketpair = 53,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] splice = 76,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] splice = 5263,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] splice = 283,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] splice = 76,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] splice = 306,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] splice = 275,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] spu_create = 279,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] spu_run = 278,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ssetmask = 69,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] stat = 5004,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] stat = 106,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] stat = 106,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] stat = 4,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] statfs = 43,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] statfs = 5134,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] statfs = 99,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] statfs = 43,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] statfs = 99,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] statfs = 137,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] statfs64 = 252,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] statfs64 = 265,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] statx = 291,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] statx = 5326,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] statx = 383,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] statx = 291,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] statx = 379,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] statx = 332,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] stime = 25,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] stty = 31,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] subpage_prot = 310,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] swapcontext = 249,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] swapoff = 225,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] swapoff = 5163,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] swapoff = 115,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] swapoff = 225,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] swapoff = 115,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] swapoff = 168,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] swapon = 224,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] swapon = 5162,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] swapon = 87,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] swapon = 224,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] swapon = 87,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] swapon = 167,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] switch_endian = 363,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] symlink = 5086,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] symlink = 83,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] symlink = 83,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] symlink = 88,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] symlinkat = 36,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] symlinkat = 5256,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] symlinkat = 295,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] symlinkat = 36,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] symlinkat = 297,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] symlinkat = 266,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sync = 81,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sync = 5157,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sync = 36,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sync = 81,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sync = 36,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sync = 162,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sync_file_range = 84,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sync_file_range = 5264,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sync_file_range = 84,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sync_file_range = 307,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sync_file_range = 277,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sync_file_range2 = 308,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] syncfs = 267,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] syncfs = 5301,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] syncfs = 348,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] syncfs = 267,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] syncfs = 338,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] syncfs = 306,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sys_debug_setcontext = 256,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sysfs = 5136,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sysfs = 135,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sysfs = 135,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sysfs = 139,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] sysinfo = 179,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sysinfo = 5097,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] sysinfo = 116,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sysinfo = 179,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] sysinfo = 116,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] sysinfo = 99,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] syslog = 116,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] syslog = 5101,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] syslog = 103,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] syslog = 116,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] syslog = 103,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] syslog = 103,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] sysmips = 5199,

	/// Also known as __NR_arch_specific_syscall.
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] sysriscv = 244,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] tee = 77,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] tee = 5265,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] tee = 284,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] tee = 77,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] tee = 308,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] tee = 276,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] tgkill = 131,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] tgkill = 5225,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] tgkill = 250,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] tgkill = 131,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] tgkill = 241,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] tgkill = 234,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] time = 13,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] time = 201,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] timer_create = 107,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] timer_create = 5216,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] timer_create = 240,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] timer_create = 107,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] timer_create = 254,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] timer_create = 222,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] timer_delete = 111,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] timer_delete = 5220,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] timer_delete = 244,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] timer_delete = 111,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] timer_delete = 258,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] timer_delete = 226,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] timer_getoverrun = 109,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] timer_getoverrun = 5219,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] timer_getoverrun = 243,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] timer_getoverrun = 109,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] timer_getoverrun = 257,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] timer_getoverrun = 225,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] timer_gettime = 108,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] timer_gettime = 5218,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] timer_gettime = 242,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] timer_gettime = 108,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] timer_gettime = 256,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] timer_gettime = 224,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] timer_settime = 110,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] timer_settime = 5217,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] timer_settime = 241,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] timer_settime = 110,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] timer_settime = 255,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] timer_settime = 223,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] timerfd = 5277,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] timerfd = 317,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] timerfd_create = 85,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] timerfd_create = 5280,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] timerfd_create = 306,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] timerfd_create = 85,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] timerfd_create = 319,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] timerfd_create = 283,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] timerfd_gettime = 87,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] timerfd_gettime = 5281,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] timerfd_gettime = 312,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] timerfd_gettime = 87,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] timerfd_gettime = 321,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] timerfd_gettime = 287,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] timerfd_settime = 86,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] timerfd_settime = 5282,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] timerfd_settime = 311,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] timerfd_settime = 86,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] timerfd_settime = 320,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] timerfd_settime = 286,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] times = 153,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] times = 5098,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] times = 43,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] times = 153,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] times = 43,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] times = 100,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] tkill = 130,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] tkill = 5192,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] tkill = 208,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] tkill = 130,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] tkill = 237,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] tkill = 200,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] truncate = 45,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] truncate = 5074,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] truncate = 92,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] truncate = 45,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] truncate = 92,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] truncate = 76,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] tuxcall = 225,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] tuxcall = 184,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ugetrlimit = 190,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ulimit = 58,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] umask = 166,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] umask = 5093,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] umask = 60,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] umask = 166,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] umask = 60,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] umask = 95,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] umount = 22,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] umount = 22,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] umount2 = 39,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] umount2 = 5161,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] umount2 = 52,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] umount2 = 39,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] umount2 = 52,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] umount2 = 166,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] uname = 160,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] uname = 5061,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] uname = 122,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] uname = 160,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] uname = 122,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] uname = 63,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] unlink = 5085,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] unlink = 10,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] unlink = 10,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] unlink = 87,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] unlinkat = 35,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] unlinkat = 5253,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] unlinkat = 292,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] unlinkat = 35,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] unlinkat = 294,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] unlinkat = 263,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] unshare = 97,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] unshare = 5262,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] unshare = 282,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] unshare = 97,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] unshare = 303,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] unshare = 272,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] uselib = 86,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] uselib = 86,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] uselib = 134,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] userfaultfd = 282,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] userfaultfd = 5317,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] userfaultfd = 364,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] userfaultfd = 282,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] userfaultfd = 355,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] userfaultfd = 323,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] ustat = 5133,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] ustat = 62,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] ustat = 62,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] ustat = 136,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] utime = 5130,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] utime = 30,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] utime = 30,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] utime = 132,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] utimensat = 88,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] utimensat = 5275,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] utimensat = 304,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] utimensat = 88,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] utimensat = 315,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] utimensat = 280,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] utimes = 5226,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] utimes = 251,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] utimes = 313,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] utimes = 235,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] vfork = 189,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] vfork = 190,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] vfork = 58,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] vhangup = 58,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] vhangup = 5150,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] vhangup = 111,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] vhangup = 58,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] vhangup = 111,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] vhangup = 153,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] vm86 = 113,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] vmsplice = 75,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] vmsplice = 5266,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] vmsplice = 285,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] vmsplice = 75,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] vmsplice = 309,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] vmsplice = 278,

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] vserver = 5236,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] vserver = 236,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] wait4 = 260,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] wait4 = 5059,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] wait4 = 114,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] wait4 = 260,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] wait4 = 114,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] wait4 = 61,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] waitid = 95,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] waitid = 5237,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] waitid = 272,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] waitid = 95,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] waitid = 281,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] waitid = 247,

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] waitpid = 7,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] write = 64,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] write = 5001,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] write = 4,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] write = 64,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] write = 4,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] write = 1,

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] writev = 66,
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] writev = 5019,
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] writev = 146,
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] writev = 66,
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] writev = 146,
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] writev = 20,
}

impl SYS
{
	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pub const InclusiveMinimum: Self = SYS::io_setup;
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pub const InclusiveMinimum: Self = SYS::read;
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pub const InclusiveMinimum: Self = SYS::restart_syscall;
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pub const InclusiveMinimum: Self = SYS::io_setup;
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pub const InclusiveMinimum: Self = SYS::exit;
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pub const InclusiveMinimum: Self = SYS::read;

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pub const InclusiveMaximum: Self = SYS::pidfd_getfd;
	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pub const InclusiveMaximum: Self = SYS::pidfd_getfd;
	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pub const InclusiveMaximum: Self = SYS::pidfd_getfd;
	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pub const InclusiveMaximum: Self = SYS::pidfd_getfd;
	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pub const InclusiveMaximum: Self = SYS::pidfd_getfd;
	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pub const InclusiveMaximum: Self = SYS::pidfd_getfd;

	#[cfg(target_arch = "aarch64")] #[allow(missing_docs)] pub const Undefined: [Range<u32>; 3] =
	[
		244 .. 260,
		295 .. 424,
		436 .. 437,
	];

	#[cfg(target_arch = "mips64")] #[allow(missing_docs)] pub const Undefined: [Range<u32>; 3] =
	[
		5238 .. 5239,
		5329 .. 5424,
		5436 .. 5437,
	];

	#[cfg(target_arch = "powerpc64")] #[allow(missing_docs)] pub const Undefined: [Range<u32>; 10] =
	[
		192 .. 198,
		204 .. 205,
		224 .. 225,
		226 .. 227,
		254 .. 255,
		257 .. 258,
		366 .. 378,
		389 .. 392,
		403 .. 424,
		436 .. 437,
	];

	#[cfg(target_arch = "riscv64")] #[allow(missing_docs)] pub const Undefined: [Range<u32>; 4] =
	[
		38 .. 39,
		245 .. 260,
		295 .. 424,
		436 .. 437,
	];

	#[cfg(target_arch = "s390x")] #[allow(missing_docs)] pub const Undefined: [Range<u32>; 34] =
	[
		13 .. 14,
		16 .. 19,
		23 .. 26,
		28 .. 29,
		31 .. 33,
		35 .. 36,
		44 .. 45,
		46 .. 48,
		49 .. 51,
		53 .. 54,
		56 .. 57,
		58 .. 60,
		68 .. 72,
		76 .. 77,
		80 .. 83,
		84 .. 85,
		95 .. 96,
		98 .. 99,
		101 .. 102,
		109 .. 110,
		113 .. 114,
		123 .. 124,
		138 .. 141,
		164 .. 167,
		170 .. 172,
		182 .. 183,
		192 .. 198,
		221 .. 222,
		223 .. 224,
		242 .. 243,
		263 .. 265,
		387 .. 392,
		403 .. 424,
		436 .. 437,
	];

	#[cfg(target_arch = "x86_64")] #[allow(missing_docs)] pub const Undefined: [Range<u32>; 2] =
	[
		335 .. 424,
		436 .. 437,
	];
}
