// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


/// Minimum Internet Protocol version 4 Maximum Transmission Unit (MTU) defined in RFC 791.
#[allow(dead_code)]
pub(crate) const ETH_MIN_MTU: u32 = 68;

/// Maximum Maximum Transmission Unit (MTU); identical to `IP_MAX_MTU`.
#[allow(dead_code)]
pub(crate) const ETH_MAX_MTU: u32 = 65535;
