// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


/// Field ordering based on order as generated by `inet6_fill_ifaddr()` in Linux source `addrconf.c` (for Internet Protocol version 6).
#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub(crate) struct GetAddressProcessingMessageStateOtherCastInternetProtocolVersion6
{
	pub(crate) common: GetAddressProcessingMessageStateCommon,
	
	pub(crate) other_cast_address: Option<in6_addr>,
}

#[allow(missing_docs)]
impl GetAddressProcessingMessageStateOtherCastInternetProtocolVersion6
{
	#[inline(always)]
	pub(crate) fn new(message_header: &ifaddrmsg) -> Result<Self, String>
	{
		Ok
		(
			Self
			{
				common: GetAddressProcessingMessageStateCommon::new::<in6_addr>(message_header)?,
				
				other_cast_address: None,
			}
		)
	}
}

#[allow(missing_docs)]
impl GetAddressProcessingMessageStateOtherCastInternetProtocolVersion6
{
	#[inline(always)]
	pub(crate) fn to_processed_message(self) -> Result<GetInternetProtocolVersion6OtherCastAddressMessageData, String>
	{
		let common = self.common;
		let interface_flags = common.interface_flags;
		Ok
		(
			GetInternetProtocolVersion6OtherCastAddressMessageData
			{
				common: common.to_processed_message::<in6_addr>()?,
				
				interface_flags,
				
				other_cast_address: self.other_cast_address,
			}
		)
	}
}
