use criterion::{black_box, criterion_group, criterion_main, Criterion};
use linicon::{lookup_icon, IconPath, LiniconError};
use std::time::Duration;

fn find_all(
    theme_name: &str,
    icon_name: &str,
    size: u16,
    scale: u16,
) -> Vec<Result<IconPath, LiniconError>> {
    lookup_icon(icon_name)
        .from_theme(theme_name)
        .with_size(size)
        .with_scale(scale)
        .collect()
}

fn find_all_benches(c: &mut Criterion) {
    c.bench_function("find_all Faenza wireshark 64 1", |b| {
        b.iter(|| {
            find_all(
                black_box("Faenza"),
                black_box("wireshark"),
                black_box(64),
                black_box(1),
            )
        })
    });
    c.bench_function("find_all Papirus firefox 128 1", |b| {
        b.iter(|| {
            find_all(
                black_box("Papirus"),
                black_box("firefox"),
                black_box(128),
                black_box(1),
            )
        })
    });
}

fn find_one(
    theme_name: &str,
    icon_name: &str,
    size: u16,
    scale: u16,
) -> Result<IconPath, LiniconError> {
    lookup_icon(icon_name)
        .from_theme(theme_name)
        .with_size(size)
        .with_scale(scale)
        .next()
        .unwrap()
}

fn find_one_benches(c: &mut Criterion) {
    c.bench_function("find_one Faenza wireshark 64 1", |b| {
        b.iter(|| {
            find_one(
                black_box("Faenza"),
                black_box("wireshark"),
                black_box(64),
                black_box(1),
            )
        })
    });
    c.bench_function("find_one Papirus firefox 128 1", |b| {
        b.iter(|| {
            find_one(
                black_box("Papirus"),
                black_box("firefox"),
                black_box(128),
                black_box(1),
            )
        })
    });
}

criterion_group! {
    name = benches;
    config = Criterion::default()
        .measurement_time(Duration::new(7, 0));
    targets = find_all_benches, find_one_benches
}
criterion_main!(benches);
