# linicon

[![crates.io](https://img.shields.io/crates/v/linicon.svg)](https://crates.io/crates/linicon)
[![docs.rs](https://docs.rs/linicon/badge.svg)](https://docs.rs/linicon)

A library for looking up icons on Linux and other FreeDesktop compliant systems.
This library implements the [FreeDesktop Icon Theme specification](spec).

[spec]: https://specifications.freedesktop.org/icon-theme-spec/icon-theme-spec-latest.html

## Other Parts of this Project

- [geticons](https://git.sr.ht/~zethra/geticons) A cli utility to get icons on
&ast;nix system.  Based on this library.
- [Freedesktop Entry Parser](https://git.sr.ht/~zethra/freedesktop_entry_parser)
A library for parsing Freedesktop entires files, used by this library.  `.desktop`
files and theme index files use this format.
- [linicon-theme](https://git.sr.ht/~zethra/linicon-theme) Query user's icon theme.
- [linicon-ffi](https://git.sr.ht/~zethra/linicon-ffi) C bindings for linicon.
- [Freedesktop Entry Parser JS](https://git.sr.ht/~zethra/freedesktop-entry-parser-js)
Freedesktop Entry Parser compiled into wasm for use in JS.

## Build and Testing

The tests for this library depend on the Faenza icon pack being installed.
To test icon looks I need an icon library installed and Faenza is pretty small
and available on a lot of distros.

## Contributing

Please send any and all patches, bugs, and questions to my public inbox
[~zethra/public-inbox@lists.sr.ht](mailto:~zethra/public-inbox@lists.sr.ht)
or submit a ticket to the bug tracker if you feel so inclined
[todo.sr.ht/~zethra/linicon](https://todo.sr.ht/~zethra/linicon).
