/// This file is automatically generated by `build.rs`. Any changes made here will be
/// lost forever.
///
/// Any modification must be done in `lib.tpl.rs` and it will be compiled automatically
/// by build.rs
use crate::{stemmer::StemmerTrait, stopwords::StopwordsTrait};
use rust_stemmers::{Algorithm, Stemmer};
use serde::{Deserialize, Serialize};
use std::{collections::HashSet, str::FromStr};
use stopwords::{Stopwords, NLTK};
use strum::IntoEnumIterator;
use strum_macros::{Display, EnumIter};
use textcat::category::Categories;

#[derive(
    Clone, Debug, EnumIter, Eq, Display, PartialEq, Hash, Ord, PartialOrd, Serialize, Deserialize,
)]
pub enum Language {
    Afrikaans,
    Albanian,
    Arabic,
    Armenian,
    Azerbaijani,
    Belarusian,
    Bengali,
    Bosnian,
    Bulgarian,
    Catalan,
    Chinese,
    Czech,
    Danish,
    Dutch,
    English,
    Esperanto,
    Estonian,
    Euskara,
    Finnish,
    French,
    Georgian,
    German,
    Greek,
    Guarani,
    Gujarati,
    Hebrew,
    Hindi,
    Hungarian,
    Icelandic,
    Indonesian,
    Irish,
    Italian,
    Japanese,
    Kazakh,
    Ladino,
    Latin,
    Norwegian,
    Persian,
    Portuguese,
    Romanian,
    Russian,
    Spanish,
    Swedish,
    Tamil,
    Turkish,
    Urdu,
    Vietnamese,
    Welsh,
}

impl Language {
    pub fn all() -> HashSet<Language> {
        Language::iter().collect()
    }
}

impl StopwordsTrait for Language {
    fn stopwords(&self) -> Option<&'static [&'static str]> {
        match self {
            Self::Arabic => NLTK::stopwords(stopwords::Language::Arabic),
            Self::Azerbaijani => NLTK::stopwords(stopwords::Language::Azerbaijani),
            Self::Danish => NLTK::stopwords(stopwords::Language::Danish),
            Self::Dutch => NLTK::stopwords(stopwords::Language::Dutch),
            Self::English => NLTK::stopwords(stopwords::Language::English),
            Self::Finnish => NLTK::stopwords(stopwords::Language::Finnish),
            Self::French => NLTK::stopwords(stopwords::Language::French),
            Self::German => NLTK::stopwords(stopwords::Language::German),
            Self::Greek => NLTK::stopwords(stopwords::Language::Greek),
            Self::Hungarian => NLTK::stopwords(stopwords::Language::Hungarian),
            Self::Italian => NLTK::stopwords(stopwords::Language::Italian),
            Self::Kazakh => NLTK::stopwords(stopwords::Language::Kazakh),
            Self::Norwegian => NLTK::stopwords(stopwords::Language::Norwegian),
            Self::Portuguese => NLTK::stopwords(stopwords::Language::Portuguese),
            Self::Romanian => NLTK::stopwords(stopwords::Language::Romanian),
            Self::Russian => NLTK::stopwords(stopwords::Language::Russian),
            Self::Spanish => NLTK::stopwords(stopwords::Language::Spanish),
            Self::Swedish => NLTK::stopwords(stopwords::Language::Swedish),
            Self::Turkish => NLTK::stopwords(stopwords::Language::Turkish),
            _ => None,
        }
    }
}

impl StemmerTrait for Language {
    fn stemmer(&self) -> Option<Stemmer> {
        match self {
            Self::Arabic => Some(Stemmer::create(Algorithm::Arabic)),
            Self::Danish => Some(Stemmer::create(Algorithm::Danish)),
            Self::Dutch => Some(Stemmer::create(Algorithm::Dutch)),
            Self::English => Some(Stemmer::create(Algorithm::English)),
            Self::Finnish => Some(Stemmer::create(Algorithm::Finnish)),
            Self::French => Some(Stemmer::create(Algorithm::French)),
            Self::German => Some(Stemmer::create(Algorithm::German)),
            Self::Greek => Some(Stemmer::create(Algorithm::Greek)),
            Self::Hungarian => Some(Stemmer::create(Algorithm::Hungarian)),
            Self::Italian => Some(Stemmer::create(Algorithm::Italian)),
            Self::Norwegian => Some(Stemmer::create(Algorithm::Norwegian)),
            Self::Portuguese => Some(Stemmer::create(Algorithm::Portuguese)),
            Self::Romanian => Some(Stemmer::create(Algorithm::Romanian)),
            Self::Russian => Some(Stemmer::create(Algorithm::Russian)),
            Self::Spanish => Some(Stemmer::create(Algorithm::Spanish)),
            Self::Swedish => Some(Stemmer::create(Algorithm::Swedish)),
            Self::Tamil => Some(Stemmer::create(Algorithm::Tamil)),
            Self::Turkish => Some(Stemmer::create(Algorithm::Turkish)),
            _ => None,
        }
    }
}

impl FromStr for Language {
    type Err = String;

    fn from_str(name: &str) -> Result<Language, String> {
        match name.to_lowercase().as_str() {
            "afrikaans" => Ok(Self::Afrikaans),
            "albanian" => Ok(Self::Albanian),
            "arabic" => Ok(Self::Arabic),
            "armenian" => Ok(Self::Armenian),
            "azerbaijani" => Ok(Self::Azerbaijani),
            "belarusian" => Ok(Self::Belarusian),
            "bengali" => Ok(Self::Bengali),
            "bosnian" => Ok(Self::Bosnian),
            "bulgarian" => Ok(Self::Bulgarian),
            "catalan" => Ok(Self::Catalan),
            "chinese" => Ok(Self::Chinese),
            "czech" => Ok(Self::Czech),
            "danish" => Ok(Self::Danish),
            "dutch" => Ok(Self::Dutch),
            "english" => Ok(Self::English),
            "esperanto" => Ok(Self::Esperanto),
            "estonian" => Ok(Self::Estonian),
            "euskara" => Ok(Self::Euskara),
            "finnish" => Ok(Self::Finnish),
            "french" => Ok(Self::French),
            "georgian" => Ok(Self::Georgian),
            "german" => Ok(Self::German),
            "greek" => Ok(Self::Greek),
            "guarani" => Ok(Self::Guarani),
            "gujarati" => Ok(Self::Gujarati),
            "hebrew" => Ok(Self::Hebrew),
            "hindi" => Ok(Self::Hindi),
            "hungarian" => Ok(Self::Hungarian),
            "icelandic" => Ok(Self::Icelandic),
            "indonesian" => Ok(Self::Indonesian),
            "irish" => Ok(Self::Irish),
            "italian" => Ok(Self::Italian),
            "japanese" => Ok(Self::Japanese),
            "kazakh" => Ok(Self::Kazakh),
            "ladino" => Ok(Self::Ladino),
            "latin" => Ok(Self::Latin),
            "norwegian" => Ok(Self::Norwegian),
            "persian" => Ok(Self::Persian),
            "portuguese" => Ok(Self::Portuguese),
            "romanian" => Ok(Self::Romanian),
            "russian" => Ok(Self::Russian),
            "spanish" => Ok(Self::Spanish),
            "swedish" => Ok(Self::Swedish),
            "tamil" => Ok(Self::Tamil),
            "turkish" => Ok(Self::Turkish),
            "urdu" => Ok(Self::Urdu),
            "vietnamese" => Ok(Self::Vietnamese),
            "welsh" => Ok(Self::Welsh),
            _ => Err("Invalid argument".to_string()),
        }
    }
}

pub struct Lingo {
    inner: Categories<Language>,
}

#[allow(clippy::new_without_default)]
impl Lingo {
    pub fn new() -> Self {
        Lingo {
            inner: Self::get_embed_languages(),
        }
    }

    pub fn get_language(&self, sample: &str) -> Option<Language> {
        self.inner.get_category(sample)
    }

    pub fn get_languages(&self, sample: &str) -> Option<Vec<(Language, u64)>> {
        self.inner.get_categories(sample)
    }

    #[allow(clippy::invisible_characters)]
    pub fn get_embed_languages() -> Categories<Language> {
        let mut f: Categories<Language> = vec![
            (
                Language::Afrikaans,
                vec![
                    "e", "a", "i", "n", "s", "r", "o", "t", "d", "e_", "l", "k", "g", "ie", "n_",
                    "_d", "m", "er", "s_", "ie_", "di", "u", "t_", "v", "h", "an", "_di", "w",
                    "en", "r_", "die", "_v", "aa", "_s", "die_", "_die", "b", "p", "te", "_h",
                    "_o", "in", "_n", "ge", "_e", "y", "_w", "de", "_g", "ee", "_m", "_i", "k_",
                    "el", "et", "an_", "_a", "es", "oo", "_b", "en_", "g_", "_t", "ar", "f", "d_",
                    "on", "er_", "is", "le", "or", "et_", "at", "va", "he", "nd", "st", "se", "l_",
                    "ek", "_k", "_ge", "y_", "_en", "ng", "re", "oe", "wa", "van", "ni", "me",
                    "n_d", "_va", "be", "it", "_en_", "da", "te_", "we", "ns", "aar", "li", "at_",
                    "m_", "_van", "ke", "al", "is_", "om", "_he", "van_", "_in", "_wa", "rd",
                    "in_", "ve", "j", "as", "n_di", "rs", "_da", "_l", "ma", "_be", "ing", "ri",
                    "e_v", "ro", "_is", "ver", "_is_", "_te", "ou", "ig", "ei", "_in_", "ar_",
                    "aan", "nie", "si", "ik", "aar_", "e_s", "_ve", "_j", "nt", "_n_", "oor", "ko",
                    "_ni", "het", "ers", "_me", "nie_", "nde", "it_", "_het", "het_", "om_",
                    "_nie", "op", "ed", "p_", "_ver", "ui", "ka", "_p", "_on", "so", "la", "ek_",
                    "es_", "ra", "de_", "ng_", "se_", "_r", "ne", "der", "ste", "ll", "sk", "ns_",
                    "u_", "as_", "f_", "to", "eg", "s_d", "na", "e_d", "eer", "le_", "t_d", "ing_",
                    "e_g", "e_w", "_ma", "_oo", "and", "ter", "ta", "wat", "e_b", "_wat", "ho",
                    "a_", "ou_", "ag", "lle", "el_", "wat_", "ul", "e_e", "ak", "e_o", "an_d",
                    "vi", "vo", "e_m", "al_", "_so", "ti", "e_k", "_se", "_op", "wo", "ord", "em",
                    "_we", "_te_", "sa", "aan_", "ha", "r_d", "_vi", "_om", "_aa", "id", "op_",
                    "maa", "e_t", "e_h", "t_di", "dit_", "dit", "_st", "_dit", "e_a", "lik", "ur",
                    "_aan", "tr", "ir", "n_s", "s_n", "ens", "lle_", "hu", "dat", "pe", "_ko",
                    "_ek", "ons", "erd", "ier", "us", "lo", "nder", "dat_", "_wo", "vir", "rd_",
                    "sie", "rk", "ir_", "eer_", "e_ge", "rt", "_vir", "vir_", "ol", "n_h", "ges",
                    "ew", "c", "met", "ke_", "_om_", "_ek_", "_as", "s_di", "rs_", "am", "_hu",
                    "mo", "ies", "_to", "_ho", "ons_", "no", "_met", "_u", "_ons", "pr", "ond",
                    "e_i", "ord_", "_na", "_maa", "ot", "gt", "_ka", "wee", "r_di", "os", "met_",
                    "eu", "s_v", "or_", "af", "uit", "ad", "een", "_dat", "ull", "t_n", "in_d",
                    "_sa", "il", "ie_v", "ie_s", "ok", "daa", "ba", "_op_", "gs", "_vo", "_as_",
                    "ulle", "hul", "gr", "ers_", "erk", "e_n", "_le", "sp", "ru", "hi", "n_o",
                    "ik_", "e_r", "e_p", "_daa", "nd_", "n_v", "ag_", "_hul", "oor_", "ig_",
                    "der_", "bo", "_oor", "end", "_re", "ki", "wor", "sta", "s_s", "pa", "od",
                    "e_ve", "_de", "s_o", "e_l", "daar", "wi", "word", "nk", "jo", "t_h", "_al",
                    "_1", "_wor", "ry", "n_n", "ede", "of", "ga", "_hi", "kan", "e_be", "_mo",
                    "sy", "s_w", "ien", "ie_d", "en_d", "go", "s_i",
                ],
            ),
            (
                Language::Albanian,
                vec![
                    "ë", "e", "t", "i", "r", "a", "n", "s", "ë_", "h", "e_", "j", "u", "k", "m",
                    "o", "të", "p", "d", "_t", "të_", "_n", "sh", "l", "_p", "_s", "a_", "i_",
                    "ër", "te", "_m", "_k", "g", "r_", "_të_", "_të", "te_", "ht", "sht", "_e",
                    "t_", "is", "_e_", "ri", "n_", "nd", "v", "he", "_a", "et", "pë", "q", "për",
                    "me", "b", "_d", "ish", "it", "në", "j_", "ur", "ar", "in", "_për", "_pë",
                    "_i", "en", "rë", "o_", "isht", "hte", "_v", "ë_t", "z", "shte", "je", "në_",
                    "f", "dh", "_me", "s_", "jë", "gj", "ej", "_b", "ës", "nj", "at", "u_", "hte_",
                    "mi", "er", "ër_", "ë_p", "si", "re", "ra", "in_", "ej_", "_sh", "_në", "ën",
                    "ti", "kë", "ku", "_g", "ta", "pa", "on", "një", "ni", "me_", "jë_", "_q",
                    "ur_", "th", "se", "es", "e_t", "e_m", "do", "as", "_si", "_në_", "y", "ve",
                    "ng", "e_n", "an", "_pa", "ë_k", "ç", "se_", "po", "ki", "im", "ë_n", "nt",
                    "më", "ll", "ja", "aj", "_nj", "_nd", "_me_", "_l", "_f", "ës_", "ë_s", "rë_",
                    "që", "një_", "it_", "il", "ik", "e_s", "_i_", "ët", "ë_m", "të_t", "për_",
                    "or", "ka", "he_", "etë", "e_k", "dhe", "_ve", "_një", "_ng", "_gj", "ën_",
                    "ua", "tu", "rr", "që_", "kis", "ha", "dhe_", "_ki", "_h", "ë_a", "së", "pr",
                    "oh", "kish", "k_", "ga", "end", "e_të", "di", "c", "_që", "_kë", "un", "nte_",
                    "nte", "nga", "më_", "li", "ko", "ji", "i_n", "hi", "hej_", "hej", "atë",
                    "_që_", "_nga", "_ku", "_kis", "_dh", "ë_të", "to", "ri_", "kur", "jo_", "jo",
                    "_më", "_ish", "_is", "_dhe", "uk", "të_p", "ta_", "shi", "sa", "rt", "r_t",
                    "ni_", "nd_", "n_e_", "n_e", "m_", "lë", "kët", "hë", "hu", "gji", "et_",
                    "e_p", "e_me", "d_", "bë", "ap", "ai", "_te", "_pr", "_po", "_mi", "_kët",
                    "vet", "va", "ul", "uar_", "uar", "tër", "të_m", "tha", "silv", "sil", "r_n",
                    "qe", "po_", "ohe", "ndo", "na", "mir", "men", "mb", "lv", "le", "jit", "ir",
                    "imi", "ilv", "gjit", "e_v", "e_d", "ar_", "a_p", "_vet", "_th", "_ta", "_sil",
                    "_se", "_r", "_më_", "_c", "ëri", "ë_v", "ë_pë", "ë_pa", "ë_l", "und", "uk_",
                    "të_n", "të_k", "së_", "rs", "ro", "ra_", "pi", "ont", "ohej", "nu", "nga_",
                    "ka_", "jith", "je_", "ith", "i_s", "gu", "ga_", "de", "br", "al", "ak", "a_s",
                    "a_n", "a_m", "_u", "_tha", "_se_", "_nu", "_kur", "_ka", "_j", "_e_s", "_bë",
                    "ëm", "ë_sh", "ë_e_", "ë_e", "ë_d", "va_", "të_s", "tha_", "tet", "te_m",
                    "tan", "rm", "rit", "rg", "rej", "oni", "nuk_", "nuk", "nin_", "nin", "mend",
                    "lva_", "lva", "lo", "ke", "jt", "j_n", "ilva", "id", "i_k", "ha_", "h_", "fa",
                    "bi", "a_e_", "a_e", "_ç", "_z", "_sa", "_nuk", "_ndo", "_mir", "ëtë_", "ëtë",
                    "ër_t", "zi", "vë", "tër_", "tur", "tr", "ti_", "te_n", "te_k", "tani", "t_t",
                    "st", "sht_", "s_s", "rën", "r_të", "pre", "pas", "par", "ot", "or_", "onte",
                    "na_", "n_p", "ma", "la",
                ],
            ),
            (
                Language::Arabic,
                vec![
                    "ا", "ل", "ي", "م", "ر", "و", "ب", "ن", "ال", "ي_", "_ا", "س", "ف", "_ال", "د",
                    "ت", "ع", "أ", "ة_", "ة", "_م", "ه", "_ف", "ك", "في", "في_", "_أ", "_في",
                    "_في_", "ل_", "ق", "ن_", "_و", "ا_", "_ل", "_ب", "ح", "ه_", "م_", "ري", "ر_",
                    "سي", "با", "ج", "_ع", "مي", "يس", "ان", "لم", "ى_", "ى", "ب_", "ش", "سي_",
                    "إ", "ار", "ي_ا", "د_", "ي_ال", "ث", "لا", "ض", "يسي", "ص", "يسي_", "ور",
                    "ميسي", "ميس", "الم", "من", "عا", "خ", "_ك", "ية_", "ية", "ني", "را", "_ميس",
                    "_مي", "_2", "ون", "ذ", "_من", "ين", "ول", "بر", "_س", "ما", "يا", "من_",
                    "لى_", "لى", "دو", "ة_ا", "20", "لع", "أو", "ة_ال", "_ه", "_من_", "لأ", "في_ا",
                    "سب", "ز", "دي", "عب", "_إ", "_20", "لي", "ت_", "ام", "اد", "_ت", "_1", "و_",
                    "نا", "مر", "ط", "_الم", "هد", "رة_", "رة", "بي", "الأ", "_ي", "ً", "نة_", "نة",
                    "ل_م", "_ن", "_الأ", "عب_", "_ح", "نت", "مب", "لو", "لد", "اني", "مو", "لك",
                    "عل", "ع_", "اع", "سم", "وس", "وب", "وا", "ف_", "س_", "دور", "وري", "كر",
                    "ة_ف", "اس", "يو", "ي_ف", "ري_", "_ر", "ين_", "ي_م", "ي_أ", "ول_", "وري_",
                    "ني_", "لاع", "دوري", "تي", "الد", "ات", "اب", "ئ", "أول", "00", "نه", "ن_ا",
                    "لعا", "لت", "لاعب", "لإ", "سبان", "سبا", "باني", "بان", "اعب", "إسبا", "إسب",
                    "إس", "_أو", "ير", "لون", "كا", "ك_", "غ", "شل", "ز_", "رو", "دف", "ة_في",
                    "الإ", "ال_", "_ق", "_عل", "يل", "ونة_", "ونة", "هدف", "ن_ال", "لونة", "على_",
                    "على", "عام", "شلون", "شلو", "رشلو", "رشل", "رش", "تم", "بع", "برشل", "برش",
                    "الع", "_الع", "_الإ", "_200", "200", "ائ", "أن", "_على", "ما_", "له", "لدو",
                    "قا", "سج", "دم", "دا", "ته", "تا", "ة_أ", "ام_", "العا", "ارا", "لق", "قد",
                    "فا", "ست", "دي_", "الدو", "اف", "اعب_", "ادي_", "ادي", "أول_", "_هد", "_مو",
                    "_برش", "_بر", "7_", "ي_و", "ي_في", "ه_ا", "نادي", "ناد", "لل", "لدور", "كرة_",
                    "كرة", "سم_", "سا", "جل", "_عا", "_الد", "يك", "ي_ب", "وسم", "وأ", "موسم",
                    "موس", "لإسب", "لإس", "ته_", "ة_و", "بت", "اني_", "_وأ", "_أن", "ًا_", "ًا", "ً_",
                    "ها", "م_20", "م_2", "لن", "لر", "عام_", "رة_ا", "ذه", "بر_", "بار", "الإس",
                    "اري", "إل", "_هدف", "_لا", "_ض", "_د", "_إل", "6_", "4_", "201", "01", "ي_ل",
                    "وسم_", "وبا", "ه_ال", "مع", "مبار", "مبا", "لعال", "ق_", "في_م", "عالم",
                    "عال", "سجل_", "سجل", "جل_", "اً_", "اً", "الت", "ا_ا", "إلى_", "إلى", "أك",
                    "أس", "أر", "_لاع", "_عام", "_خ", "_إلى", "ي_ع", "وبا_", "عد", "حي", "ة_م",
                    "ة_ل", "بط", "با_", "الك", "اسي", "ات_", "ا_ف", "أص", "_مب", "_ما", "يد",
                    "وروب", "ورو", "هب", "نه_", "ند", "ن_م", "مس", "لم_", "لك_", "لة_", "لة",
                    "لأول", "لأو", "كث", "فر", "ضد_", "ضد", "سن", "ريا", "روب", "رب", "ث_", "بية_",
                    "بية", "بارا", "الي", "الم_", "الر", "اب_", "ا_ال", "أورو", "أور", "_مبا",
                    "_كر", "_ضد_", "_ضد", "_ش", "_ج", "_الك", "_الر", "_201", "يق", "يف", "ير_",
                    "ى_ال", "ى_ا",
                ],
            ),
            (
                Language::Armenian,
                vec![
                    "ա", "ն", "ր", "ո", "ե", "ի", "ւ", "ու", "մ", "ան", "կ", "ն_", "տ", "յ", "ս",
                    "վ", "հ", "ար", "եր", "ի_", "լ", "_ա", "ց", "կա", "թ", "_հ", "դ", "ը", "ք",
                    "ակ", "գ", "նե", "այ", "րա", "մ_", "ին", "ը_", "պ", "նա", "հա", "ան_", "ւմ",
                    "ում", "որ", "ր_", "_մ", "մա", "ղ", "բ", "է", "ներ", "ել", "ւմ_", "_հա",
                    "ում_", "յա", "տա", "_է", "_ե", "րո", "րի", "_ո", "ւթ", "ութ", "_կ", "ամ", "ծ",
                    "են", "լ_", "շ", "թյ", "խ", "ւթյ", "ությ", "է_", "ւն", "ակա", "ին_", "ուն",
                    "ռ", "_է_", "աս", "նո", "վա", "չ", "յո", "կան", "_ն", "յու", "_ի", "յան", "ատ",
                    "ել_", "նի", "ավ", "պա", "երի", "ական", "ց_", "զ", "ջ", "ստ", "_ս", "րի_",
                    "նու", "րե", "_դ", "_պ", "րու", "յուն", "առ", "_գ", "կան_", "վե", "_տ", "մե",
                    "և", "ք_", "տե", "ով", "_բ", "սա", "ւ_", "_կա", "ս_", "աց", "ւթյո", "թյու",
                    "թյո", "մի", "լո", "իր", "ետ", "վ_", "ած", "ների", "ն_ա", "են_", "ես", "նք",
                    "ող", "ա_", "կո", "երի_", "վո", "րդ", "_ու", "խա", "բա", "դա", "յան_", "թյա",
                    "ւթյա", "րը", "նի_", "անի", "ամա", "_որ", "արա", "րը_", "_այ", "անա", "_մա",
                    "ման", "նն", "նակ", "_վ", "տ_", "ձ", "որ_", "եր_", "ագ", "ն_հ", "լի", "նը",
                    "ծ_", "տո", "գա", "ու_", "նը_", "անո", "ահ", "կ_", "_են", "ով_", "հայ", "_պա",
                    "թյան", "քա", "պե", "ապ", "փ", "_մե", "_թ", "նդ", "կար", "ալ", "և_", "րկ",
                    "ռա", "աղ", "երը", "ժ", "ած_", "սի", "_հայ", "հե", "երը_", "_խ", "_ար", "յի",
                    "մ_է", "ի_հ", "գո", "_մի", "այի", "տան", "_չ", "ից", "անու", "նում", "մար",
                    "եղ", "լու", "ղա", "ստա", "_լ", "_եր", "աստ", "համ", "ւմ_է", "աշ", "ցո", "_ան",
                    "եց", "դի", "յն", "ախ", "կե", "անի_", "շա", "ադ", "ից_", "արո", "առա", "_համ",
                    "_բա", "ի_ա", "_շ", "_ք", "_նա", "ված", "_և", "_հե", "ննե", "համա", "դր",
                    "_են_", "րան", "տար", "ններ", "ազ", "օ", "ոն", "ըն", "տի", "թե", "ները", "եկ",
                    "_առ", "րութ", "_և_", "վել", "նք_", "մ_է_", "իա", "ցի", "ճ", "ցու", "րտ", "նց",
                    "_ին", "ւր", "ուր", "բե", "թա", "ն_հա", "իս", "_ը", "այա", "րն", "ն_ո", "ղ_",
                    "կի", "ավա", "ն_մ", "ցա", "ն_կ", "կու", "_իր", "ի_մ", "եմ", "դե", "ված_", "մո",
                    "մբ", "այն", "քի", "հո", "ես_", "մն", "ար_", "տու", "աստա", "ւս", "ավո", "մ_ե",
                    "խո", "վոր", "դ_", "գր", "աք", "անը", "_որ_", "րակ", "նչ", "ելո", "սե", "լա",
                    "ուս", "հետ", "արդ", "տր", "իմ", "ատա", "անը_", "ւնն", "ւն_", "ջա", "նկ", "տն",
                    "ունն", "հան", "րգ", "ստան", "րվ", "ուն_", "յին", "իկ", "երո", "ային", "_տա",
                    "_ըն", "րում", "_2", "յին_", "բո", "ւմ_ե", "ռո", "կն", "_կար", "_դա", "պատ",
                    "_տե", "_1", "րին", "վի", "սո", "մաս", "ման_", "լ_է", "ցն", "րծ", "իտ", "աբ",
                    "ավոր", "_փ", "_առա", "դո", "_հետ", "ան_հ", "գի", "ւյ", "վու", "ել_է", "ույ",
                    "ներ_", "նակա", "յն_", "_օ", "որո", "նել", "ի_հա", "_քա", "եւ", "նութ", "նտ",
                    "_ամ", "ւննե", "պետ",
                ],
            ),
            (
                Language::Azerbaijani,
                vec![
                    "i", "a", "ə", "n", "r", "l", "d", "s", "ı", "m", "t", "y", "u", "n_", "e",
                    "b", "ə_", "k", "o", "i_", "r_", "in", "ü", "ər", "ş", "q", "a_", "ar", "v",
                    "də", "lə", "la", "an", "il", "h", "_i", "_b", "z", "ri", "ir", "di", "ı_",
                    "ın", "da", "ən", "_m", "c", "nd", "_a", "_d", "li", "ya", "_s", "f", "ra",
                    "_o", "də_", "x", "ç", "si", "_t", "ni", "al", "lər", "mə", "_v", "ma", "ö",
                    "_k", "lar", "_q", "in_", "g", "_e", "an_", "_h", "əl", "mi", "tə", "iy",
                    "ir_", "əs", "u_", "ol", "ən_", "_y", "p", "və", "_ə", "un", "ət", "ki", "ti",
                    "əri", "na", "rə", "ad", "ğ", "ay", "bi", "is", "da_", "as", "nı", "rı", "_və",
                    "və_", "_g", "hə", "_il", "k_", "dı", "_və_", "ba", "ın_", "on", "_ol", "er",
                    "ır", "sə", "sa", "ta", "ndə", "rd", "lm", "ld", "lı", "st", "arı", "ün",
                    "ər_", "_c", "nə", "rl", "rin", "at", "iş", "sı", "ini", "ək", "ind", "t_",
                    "bu", "l_", "ik", "ilə", "_tə", "ləri", "_bi", "dən", "dir", "yə", "ində",
                    "qa", "ur", "q_", "aq", "nda", "_n", "ed", "az", "_ş", "_mə", "ərin", "dən_",
                    "lə_", "_bu", "əd", "aş", "_1", "nl", "lu", "i_i", "ar_", "et", "ları", "əsi",
                    "im", "əy", "şd", "bə", "mü", "am", "b_", "ara", "əh", "_ya", "_ç", "_ba",
                    "ası", "nu", "nin", "yi", "nın", "ha", "ri_", "_r", "_f", "nin_", "_mü", "_ed",
                    "_hə", "ll", "lan", "şə", "or", "iya", "əm", "ndə_", "_x", "id", "ni_", "lər_",
                    "bir", "ır_", "nın_", "_də", "əb", "ə_b", "_qa", "ələ", "ş_", "_bir", "ını",
                    "ka", "_da", "ul", "nda_", "di_", "m_", "dir_", "ıl", "ci", "ild", "ey",
                    "lar_", "kə", "_p", "zi", "r_b", "anı", "sin", "rın", "edi", "inin", "_ki",
                    "ınd", "ili", "ah", "ında", "te", "n_s", "na_", "ağ", "n_i", "n_b", "ərə",
                    "bu_", "arın", "ak", "du", "_ü", "en", "va", "ldə", "_bu_", "tl", "_edi", "z_",
                    "ya_", "zə", "nə_", "yy", "s_", "dan", "ış", "şa", "si_", "_şə", "rlə", "mu",
                    "ye", "li_", "it", "d_", "el", "cə", "̇", "ldə_", "i̇", "ib", "ca", "qə", "i_il",
                    "so", "nla", "dır", "fə", "ildə", "dil", "_sa", "aq_", "ab", "əti", "rm",
                    "miş", "dü", "_ö", "xa", "pa", "ki_", "_is", "su", "fi", "_i̇", "un_", "iri",
                    "gö", "əz", "əri_", "_et", "çi", "iyy", "za", "n_a", "dan_", "əf", "ğı", "sın",
                    "ola", "ci_", "a_b", "_ild", "_gö", "tı", "if", "ür", "ilə_", "hər", "ü_",
                    "ro", "ist", "ve", "ra_", "bir_", "yyə", "_on", "mı", "ala", "ət_", "ə_m",
                    "ə_i", "ə_a", "n_m", "gə", "us", "_ye", "ax", "adı", "_u", "_ola", "_l", "ək_",
                    "yı", "vi", "inə", "_sə", "_ha", "_ci", "n_d", "ilm", "ə_d", "ün_", "öv", "tu",
                    "sı_", "əş", "əli", "tm", "_ta", "nlar", "iz", "_so", "yət", "rı_", "inə_",
                    "ini_", "fa", "19", "əsin", "ələr", "lik", "ur_", "n_ə", "ada", "_qə", "il_",
                    "alı", "ı_i", "rə_",
                ],
            ),
            (
                Language::Belarusian,
                vec![
                    "а", "н", "і", "р", "ы", "с", "к", "е", "л", "т", "д", "я", "о", "в", "м",
                    "а_", "у", "п", "ц", "з", "ў", "і_", "на", "г", "_п", "ра", "б", "ка", "ь",
                    "ч", "ы_", "та", "я_", "_н", "_с", "ва", "_а", "е_", "ад", "э", "ў_", "па",
                    "х", "й", "ш", "ал", "_з", "ас", "у_", "ар", "ан", "ам", "ла", "ав", "_і",
                    "_в", "_д", "ры", "_па", "_к", "да", "пр", "ь_", "ст", "лі", "га", "_м", "аў",
                    "м_", "дз", "_на", "ны", "_г", "не", "ж", "_б", "на_", "ць", "ма", "й_", "кі",
                    "_т", "ю", "_пр", "ні", "ць_", "_ў", "_і_", "за", "х_", "ай", "аг", "_р", "ль",
                    "ац", "_у", "ак", "вы", "ча", "_я", "пра", "аб", "нн", "ё", "ск", "мі", "ве",
                    "то", "чы", "ле", "_ка", "ін", "ты", "аў_", "_за", "зе", "ер", "ат", "ым",
                    "о_", "ай_", "_пра", "са", "не_", "ен", "ца", "од", "ста", "ся", "ава", "ага",
                    "ро", "га_", "кі_", "дзе", "ыя", "ля", "_ў_", "_ад", "сц", "ік", "тр", "ку",
                    "аз", "ых", "ня", "з_", "ае", "ру", "_да", "ны_", "_ш", "оў", "ко", "цы",
                    "_ра", "цц", "а_п", "рэ", "_у_", "_на_", "ю_", "ці", "пе", "лі_", "к_", "_не",
                    "як", "ме", "ца_", "ел", "го", "_л", "ту", "алі", "ага_", "ус", "ых_", "ол",
                    "іц", "ві", "ыя_", "_вы", "ам_", "_з_", "ба", "ап", "ач", "_як", "ов", "_ма",
                    "во", "ўн", "а_н", "цца", "ор", "ала", "пры", "зі", "ын", "цца_", "эт", "ым_",
                    "ды", "ая", "ьн", "вя", "бы", "і_п", "сп", "а_с", "та_", "ска", "ся_", "i",
                    "мі_", "ла_", "мо", "ах", "асц", "бо", "_та", "ўс", "жа", "іс", "_га", "шт",
                    "ф", "дн", "а_а", "ім", "іл", "ыц", "ці_", "пад", "льн", "ка_", "ае_", "св",
                    "бе", "зн", "_пры", "эн", "_дз", "ара", "анн", "_ч", "_ст", "тв", "т_", "аць",
                    "пер", "а_з", "ян", "да_", "кр", "ец", "то_", "адз", "ая_", "_пе", "шы", "но",
                    "дзі", "д_", "ада", "сі", "най", "_шт", "_ж", "уд", "тэ", "ну", "ло", "ык",
                    "што", "чн", "а_ў", "ана", "ыс", "ыл", "іка", "нік", "ія", "су", "ры_", "н_",
                    "жы", "_што", "_са", "аць_", "_не_", "ха", "сл", "ня_", "_св", "до", "ва_",
                    "аст", "а_б", "што_", "ур", "ед", "ую", "гэ", "я_п", "ул", "е_п", "ду", "алі_",
                    "_гэ", "і_н", "рад", "му", "гэт", "оль", "але", "_ц", "_гэт", "а_па", "_аб",
                    "раз", "зя", "бу", "ця", "ера", "аю", "і_с", "ес", "ша", "нас", "_бы", "_1",
                    "іч", "іх", "тар", "ку_", "кл", "нт", "кал", "ван", "ння", "_х", "ос", "нс",
                    "а_в", "_пер", "це", "наг", "а_к", "_ча", "ных_", "ных", "_пад", "і_а", "ы_п",
                    "сці", "рав", "рам", "он", "нне", "ары", "ама", "тра", "кам", "аль", "а_на",
                    "ра_", "най_", "кт", "ет", "ей", "а_д", "_бе", "дзя", "ву", "вал", "і_з",
                    "эта", "лад", "аве", "гі", "іх_", "ял", "ні_", "ным", "_мо", "сн", "се", "зна",
                    "гр", "ару", "амі", "яў", "нага", "ля_", "зе_", "_ве", "_ва", "ён",
                ],
            ),
            (
                Language::Bengali,
                vec![
                    "া",
                    "ে",
                    "র",
                    "্",
                    "ন",
                    "ক",
                    "ি",
                    "ে_",
                    "ব",
                    "ত",
                    "র_",
                    "স",
                    "প",
                    "ম",
                    "_ক",
                    "ল",
                    "য",
                    "া_",
                    "ার",
                    "দ",
                    "ন_",
                    "_ব",
                    "ু",
                    "_প",
                    "_স",
                    "য়",
                    "হ",
                    "জ",
                    "কর",
                    "ের",
                    "্য",
                    "ট",
                    "্র",
                    "_কর",
                    "এ",
                    "শ",
                    "ের_",
                    "_এ",
                    "ি_",
                    "আ",
                    "_আ",
                    "রে",
                    "ার_",
                    "ন্",
                    "গ",
                    "রা",
                    "ই",
                    "ান",
                    "ো",
                    "থ",
                    "ছ",
                    "কে",
                    "ও",
                    "ী",
                    "ষ",
                    "তা",
                    "_হ",
                    "_ন",
                    "চ",
                    "র্",
                    "_ত",
                    "না",
                    "দে",
                    "বা",
                    "_ম",
                    "্ত",
                    "তে",
                    "ভ",
                    "কা",
                    "ও_",
                    "ক্",
                    "নি",
                    "ধ",
                    "কে_",
                    "প্",
                    "_জ",
                    "মা",
                    "রে_",
                    "_দ",
                    "বি",
                    "বে",
                    "তে_",
                    "স্",
                    "প্র",
                    "_ও",
                    "ত_",
                    "অ",
                    "_অ",
                    "যা",
                    "ক_",
                    "েন",
                    "ং",
                    "_প্",
                    "তি",
                    "লে",
                    "িক",
                    "_প্র",
                    "_য",
                    "নে",
                    "করে",
                    "_করে",
                    "রি",
                    "খ",
                    "উ",
                    "_বি",
                    "লা",
                    "য়_",
                    "_তা",
                    "_ও_",
                    "য়ে",
                    "ই_",
                    "ছে",
                    "ণ",
                    "ত্",
                    "_থ",
                    "াক",
                    "য_",
                    "পা",
                    "্য_",
                    "রা_",
                    "িত",
                    "_শ",
                    "েন_",
                    "রত",
                    "দের",
                    "াল",
                    "করে_",
                    "িন",
                    "সা",
                    "পর",
                    "াদ",
                    "দের_",
                    "জন",
                    "ল_",
                    "়",
                    "ে_প",
                    "বে_",
                    "টি",
                    "েক",
                    "র_ক",
                    "ে_আ",
                    "্যা",
                    "্ব",
                    "থা",
                    "্ষ",
                    "ড",
                    "_উ",
                    "_নি",
                    "ছে_",
                    "না_",
                    "র_স",
                    "ে_এ",
                    "_পা",
                    "যে",
                    "য়",
                    "ন্য",
                    "কি",
                    "ক্ষ",
                    "ায়",
                    "টা",
                    "_গ",
                    "_র",
                    "ী_",
                    "াম",
                    "দ্",
                    "থে",
                    "ে_ব",
                    "ফ",
                    "ির",
                    "এক",
                    "_এক",
                    "্ট",
                    "ব্",
                    "_বা",
                    "িয়",
                    "_কা",
                    "াব",
                    "া_ক",
                    "র_প",
                    "াই",
                    "ং_",
                    "_পর",
                    "_চ",
                    "সম",
                    "_মা",
                    "কার",
                    "াস",
                    "র_জ",
                    "_জন",
                    "ান_",
                    "ভা",
                    "েকে",
                    "ে_ক",
                    "াদে",
                    "সে",
                    "দি",
                    "করা",
                    "_না",
                    "ন_ক",
                    "েছ",
                    "_থে",
                    "ন্য_",
                    "থেকে",
                    "থেক",
                    "_থেক",
                    "_করা",
                    "এব",
                    "_এব",
                    "াত",
                    "পন",
                    "ে_স",
                    "েশ",
                    "েকে_",
                    "হা",
                    "্ন",
                    "বং",
                    "ু_",
                    "ব_",
                    "আম",
                    "_ভ",
                    "_আম",
                    "্থ",
                    "র_ব",
                    "াদের",
                    "_কি",
                    "য়ে_",
                    "বং_",
                    "জন্",
                    "এবং_",
                    "এবং",
                    "_সম",
                    "_এবং",
                    "াজ",
                    "জা",
                    "জন্য",
                    "র_জন",
                    "ব্য",
                    "তার",
                    "_ব্",
                    "_সা",
                    "_জন্",
                    "ে_ত",
                    "য়া",
                    "লে_",
                    "ো",
                    "ম_",
                    "ষ্",
                    "শি",
                    "টি_",
                    "করত",
                    "_করত",
                    "ূ",
                    "রতে",
                    "মি",
                    "েছে",
                    "মে",
                    "ো_",
                    "ন্ত",
                    "ণ_",
                    "র_ম",
                    "_দে",
                    "িক_",
                    "_ব্য",
                    "হয়",
                    "রতে_",
                    "করতে",
                    "মন",
                    "_ই",
                    "মান",
                    "_হয়",
                    "শে",
                    "_যে",
                    "ড়",
                    "ঠ",
                    "েল",
                    "আপ",
                    "লি",
                    "তা_",
                    "_যা",
                    "ত্র",
                    "_আপ",
                    "ৃ",
                    "ম্",
                    "ারে",
                    "ে_য",
                    "ুল",
                    "আপন",
                    "_ল",
                    "িত_",
                    "চা",
                    "গে",
                    "িশ",
                    "যে_",
                    "_আপন",
                    "ে_হ",
                    "ভি",
                    "িস",
                    "বল",
                    "া_হ",
                    "্ধ",
                    "ায়_",
                    "ারা",
                    "পার",
                    "ে_ন",
                    "াকে",
                    "ুর",
                    "াহ",
                    "নি_",
                    "িল",
                    "স_",
                    "নের",
                    "শ্",
                    "ট_",
                    "রী",
                    "রক",
                    "নের_",
                    "চ্",
                    "হব",
                    "পরি",
                    "দা",
                    "্দ",
                    "িয়ে",
                    "তে_প",
                    "জে",
                    "কো",
                    "_হব",
                    "ে_পা",
                    "িন্",
                    "_স্",
                    "ি_ক",
                    "ন্ন",
                    "ধা",
                    "ক্ত",
                    "অন",
                    "_তার",
                    "_অন",
                    "হবে",
                    "_হবে",
                    "_থা",
                    "িষ",
                    "ল্",
                    "ন_কর",
                    "_পার",
                    "_কো",
                    "্প",
                    "_ফ",
                    "_পরি",
                    "_না_",
                    "ের_স",
                    "া_কর",
                    "থাক",
                    "টা_",
                    "_জা",
                    "্রত",
                    "স্থ",
                    "লো",
                    "েছে_",
                    "ার্",
                    "ারা_",
                    "হবে_",
                    "া_প",
                    "নে_",
                    "_থাক",
                    "্রা",
                    "িভ",
                    "ষা",
                    "প্রত",
                    "োন",
                    "াকে_",
                    "বার",
                    "জ_",
                    "ে_তা",
                    "িদ",
                    "দেশ",
                    "খা",
                    "_সে",
                    "রু",
                    "ঙ",
                    "্ন_",
                    "া_ব",
                    "নু",
                    "_বল",
                    "্তি",
                    "্ছ",
                    "ুন",
                    "ার_ক",
                    "াপ",
                    "ানে",
                    "ষ_",
                    "লা_",
                    "নার",
                    "করা_",
                    "্ম",
                    "িব",
                    "রণ",
                    "চ্ছ",
                    "_শি",
                    "েই",
                    "সব",
                    "গ্",
                ],
            ),
            (
                Language::Bosnian,
                vec![
                    "a", "i", "o", "e", "n", "j", "r", "s", "t", "a_", "u", "k", "e_", "l", "d",
                    "v", "m", "je", "p", "i_", "_s", "g", "_p", "u_", "z", "o_", "na", "b", "je_",
                    "_n", "_i", "ra", "an", "ko", "ij", "_k", "st", "_j", "_o", "ni", "_d", "_u",
                    "c", "h", "_je", "no", "č", "ta", "ja", "m_", "po", "ri", "en", "ti", "pr",
                    "_na", "_je_", "in", "ov", "od", "va", "li", "nj", "ma", "ka", "re", "ne",
                    "la", "na_", "_po", "_pr", "_t", "da", "_b", "_i_", "al", "om", "_m", "š",
                    "im", "oj", "vi", "or", "os", "to", "ije", "ro", "se", "vo", "er", "at", "ar",
                    "_u_", "_a", "di", "sk", "lj", "og", "_r", "te", "av", "_z", "a_s", "_ko",
                    "il", "ad", "aj", "ji", "_v", "ve", "ak", "is", "za", "ja_", "on", "sa", "bi",
                    "ne_", "lo", "ju", "ž", "_se", "_g", "om_", "n_", "ed", "el", "ć", "d_", "em",
                    "nje", "g_", "ih", "ci", "ik", "et", "h_", "e_s", "do", "iz", "da_", "a_p",
                    "tr", "me", "i_s", "go", "e_p", "f", "se_", "ma_", "a_i", "it", "_se_", "_za",
                    "io", "ih_", "am", "a_n", "ki", "_od", "sta", "ija", "iv", "ol", "as", "su",
                    "_sa", "mi", "mo", "anj", "az", "e_i", "_ka", "ob", "ru", "le", "no_", "ju_",
                    "koj", "ti_", "ka_", "es", "_do", "_1", "ek", "_da", "e_n", "a_j", "pa", "ir",
                    "a_k", "_su", "od_", "ji_", "_iz", "og_", "_bi", "i_p", "zi", "ke", "e_o",
                    "de", "_na_", "va_", "ni_", "j_", "ije_", "ost", "ao", "la_", "t_", "r_", "ot",
                    "dn", "_koj", "su_", "a_je", "im_", "sv", "k_", "_h", "ra_", "ič", "ut", "ok",
                    "pre", "io_", "ima", "ao_", "ke_", "_l", "s_", "li_", "gr", "a_u", "_st",
                    "_ra", "ic", "rij", "si", "_su_", "e_u", "dr", "u_s", "_sv", "vn", "ta_", "ku",
                    "ac", "ran", "a_o", "_ne", "nu", "đ", "pri", "kr", "ga", "i_n", "ova", "_pre",
                    "ko_", "eg", "sti", "e_d", "cij", "bo", "_od_", "pro", "jen", "št", "tu", "nt",
                    "sl", "a_na", "e_k", "ija_", "ako", "za_", "ist", "če", "o_s", "o_j", "ima_",
                    "_pro", "jed", "ba", "ez", "a_d", "a_i_", "či", "br", "ač", "_f", "_e", "us",
                    "nje_", "_pri", "o_je", "to_", "gl", "tv", "odi", "ada", "sp", "_c", "lu",
                    "e_b", "ns", "e_na", "_da_", "u_p", "ina", "i_o", "gra", "sa_", "op", "e_po",
                    "ce", "ug", "oji", "du", "_nj", "lja", "vr", "ori", "ev", "sn", "ovi", "i_i",
                    "lje", "čn", "_za_", "rad", "din", "ali", "a_u_", "z_", "van", "ur", "tra",
                    "sko", "o_p", "naj", "ca", "sto", "nja", "ine", "i_k", "i_d", "a_pr", "0_",
                    "un", "ili", "eć", "an_", "a_po", "_to", "kom", "je_p", "te_", "ira", "pos",
                    "e_pr", "ati", "_č", "_te", "_ma", "ve_", "ski", "ani", "aci", "oj_", "ap",
                    "anje", "_mo", "čk", "o_n", "nik", "nij", "ana", "a_t", "_go", "ći", "e_t",
                    "_naj", "lik", "a_ko", "zn", "nji", "gi", "mu", "iti", "hi", "pi", "ine_",
                    "ena", "e_i_", "_kr", "u_n", "rn",
                ],
            ),
            (
                Language::Bulgarian,
                vec![
                    "а", "и", "е", "о", "т", "н", "а_", "р", "с", "в", "д", "к", "л", "е_", "п",
                    "и_", "м", "_с", "на", "з", "о_", "_н", "_п", "я", "б", "ъ", "та", "ни", "т_",
                    "то", "ат", "на_", "_на", "те", "г", "у", "ст", "ра", "ч", "_д", "_о", "_в",
                    "ва", "_и", "ит", "ен", "пр", "от", "ре", "_к", "ан", "та_", "_на_", "за",
                    "_пр", "по", "_т", "ка", "но", "_з", "то_", "ите", "да", "ко", "ри", "ия",
                    "те_", "_за", "в_", "не", "ед", "ов", "а_с", "ц", "ли", "_м", "се", "щ", "_по",
                    "я_", "ите_", "ж", "ин", "_б", "_е", "ата", "_от", "ти", "ро", "ата_", "ор",
                    "ет", "а_п", "а_н", "ва_", "_се", "ви", "ав", "ве", "_в_", "ия_", "да_", "за_",
                    "ал", "че", "й", "_и_", "ма", "ар", "ят", "ос", "ни_", "н_", "_р", "х", "_да",
                    "ци", "ел", "де", "пре", "ме", "ле", "се_", "ди", "от_", "во", "_за_", "ер",
                    "_от_", "_г", "си", "об", "_ко", "од", "ки", "ла", "е_с", "ск", "из", "_да_",
                    "_се_", "ш", "но_", "ени", "_пре", "ол", "ес", "до", "тр", "ми", "он", "аз",
                    "са", "с_", "ак", "а_на", "_а", "го", "е_п", "_е_", "_не", "е_н", "а_д", "_ч",
                    "ред", "ф", "не_", "ис", "ие", "ър", "га", "ат_", "тв", "_ка", "а_в", "и_с",
                    "и_п", "ам", "а_о", "съ", "про", "ло", "о_н", "_до", "ас", "ще", "кат", "ем",
                    "мо", "ият", "_то", "ом", "ани", "ето", "а_к", "и_н", "_са", "им", "а_и", "па",
                    "ир", "а_пр", "ил", "_про", "м_", "ото", "ето_", "ще_", "че_", "ств", "лн",
                    "ост", "ки_", "ек", "е_на", "д_", "сл", "_съ", "_из", "_у", "_ст", "ик", "ад",
                    "ли_", "ят_", "ото_", "ста", "_ра", "ен_", "би", "тел", "ния", "бо", "ча",
                    "са_", "а_з", "нт", "ез", "ран", "нат", "а_т", "пред", "е_о", "въ", "_л",
                    "ест", "зи", "ова", "й_", "л_", "_об", "ив", "ри_", "нит", "ват", "_щ", "иц",
                    "а_б", "о_с", "ка_", "_че", "е_в", "а_се", "ира", "ок", "нс", "ич", "а_за",
                    "_не_", "ра_", "ните", "дн", "е_и", "_с_", "и_в", "а_по", "ние", "ие_", "и_о",
                    "р_", "ина", "_ще_", "_ще", "о_на", "и_и", "ог", "о_п", "при", "е_д", "_си",
                    "ъл", "раз", "ане", "ята", "по_", "ти_", "бъ", "бе", "пе", "к_", "_по_",
                    "ята_", "со", "ски", "то_н", "ой", "ев", "т_н", "ру", "а_м", "ната", "ай",
                    "ава", "_са_", "ова_", "же", "е_пр", "тъ", "оп", "_ф", "_те", "_го", "сп",
                    "и_на", "и_к", "_при", "ба", "а_е", "чи", "кт", "ван", "_бъ", "ът", "ато",
                    "тов", "и_д", "да_с", "яв", "ция", "ма_", "ап", "си_", "_но", "_че_", "ията",
                    "оч", "т_с", "на_с", "на_п", "и_т", "ение", "вр", "ше", "а_да", "стр", "0_",
                    "ха", "сти", "рав", "ния_", "и_пр", "и_з", "гр", "кр", "вс", "бр", "та_н",
                    "нов", "али", "_ре", "тн", "т_п", "ня", "_раз", "_въ", "ои", "е_з", "а_в_",
                    "та_с", "дв", "а_от", "ска", "ори", "ове", "къ", "_1", "о_д", "ние_", "нд",
                    "щи", "пъ", "ац", "ю", "зв", "ент", "ви_", "_сл", "_им", "ъд", "рн",
                ],
            ),
            (
                Language::Catalan,
                vec![
                    "e", "a", "s", "r", "l", "i", "t", "n", "c", "o", "d", "u", "a_", "s_", "_d",
                    "p", "m", "es", "e_", "de", "_de", "_l", "_e", "l_", "_c", "_a", "t_", "es_",
                    "en", "el", "_p", "de_", "_de_", "an", "at", "ta", "re", "ra", "er", "na", "g",
                    "al", "v", "ci", "co", "nt", "_m", "ue", "se", "r_", "on", "la", "ar", "_s",
                    "qu", "q", "n_", "te", "i_", "b", "que", "st", "_i", "or", "le", "el_", "s_d",
                    "_co", "it", "_t", "_la", "à", "la_", "f", "ac", "ur", "me", "_la_", "pr",
                    "pe", "l'", "_l'", "_el", "e_l", "ca", "_se", "va", "un", "ti", "est", "at_",
                    "ns", "ma", "ll", "ic", "_qu", "_q", "_i_", "ó", "x", "tr", "s_de", "li", "gu",
                    "a_l", "ue_", "que_", "po", "nt_", "na_", "les", "en_", "de_l", "al_", "a_d",
                    "_v", "_que", "ro", "ri", "ls_", "ls", "les_", "in", "ia", "ent", "del",
                    "a_de", "_el_", "_del", "_a_", "'a", "à_", "per", "pa", "da", "aci", "_pr",
                    "_le", "_f", "ó_", "om", "ni", "mi", "j", "ió_", "ió", "e_c", "_les", "_en",
                    "s_e", "os", "ona", "ne", "men", "l_d", "ir", "io", "er_", "ec", "e_la", "di",
                    "ció_", "ció", "a_e", "_u", "_pe", "_es", "é", "ues", "ta_", "rs", "ra_",
                    "ons", "ol", "ion", "ia_", "et", "es_d", "de_c", "cu", "am", "_r", "ura",
                    "sta", "si", "ques", "l'a", "ent_", "des", "del_", "ct", "con", "ad", "ació",
                    "a_c", "_un", "_re", "_po", "_n", "_l'a", "_en_", "_al", "és_", "és", "z",
                    "vi", "va_", "t_de", "t_d", "t_a", "s_i", "s_c", "rt", "rd", "ran", "pre",
                    "nc", "nal", "ment", "h", "eu", "els_", "els", "ei", "da_", "com", "ant",
                    "a_t", "_per", "_ma", "_g", "_com", "'e", "us", "uest", "tu", "to", "tes_",
                    "tes", "s_p", "rs_", "rn", "res", "r_a", "no", "l_de", "ix", "im", "il", "fe",
                    "ep", "em", "ell", "eg", "e_co", "cr", "cia", "ar_", "aque", "aqu", "aq",
                    "an_", "a_qu", "a_q", "a_m", "a_l'", "_va", "_ca", "è", "y", "ura_", "ul",
                    "u_", "ts_", "ts", "ter", "tat", "sta_", "ss", "s_v", "s_i_", "rà_", "rà",
                    "r_e", "pro", "per_", "ns_", "nda", "nd", "mp", "m_", "lt", "l'e", "ita",
                    "iona", "ea", "d'", "cor", "cion", "cio", "ati", "a_s", "a_p", "_ta", "_mi",
                    "_l'e", "_des", "_d'", "_con", "_aqu", "_aq", "_al_", "_1", "í", "ve", "van",
                    "una_", "una", "ui", "tz", "tura", "tur", "tre", "tiv", "tat_", "tar", "tam",
                    "t_e", "ste", "so", "sc", "s_f", "s_co", "rne", "rep", "rea", "rac", "ra_d",
                    "ot", "onal", "oc", "ny", "nta", "ncia", "nci", "n_l", "mar", "ll_", "lit",
                    "l_p", "l_m", "l_c", "ju", "iv", "ir_", "ig", "ici", "ha", "fa", "ete", "esta",
                    "esc", "es_f", "es_e", "era", "el_p", "eix", "ect", "e_p", "cons", "cia_",
                    "cat", "br", "bli", "bl", "any", "ant_", "ana", "a_a", "_una", "_tr", "_pre",
                    "_no", "_j", "_in", "_ha", "_h", "_es_", "_cu", "_cor", "00", "'es", "àr",
                    "za", "y_", "xp", "x_", "van_", "us_", "urs",
                ],
            ),
            (
                Language::Chinese,
                vec![
                    "球_", "球", "_球_", "_球", "的_", "的", "_的_", "_的", "西_", "西", "_西_",
                    "_西", "_2", "年_", "年", "_年_", "_年", "20", "_1", "_20", "美_", "美", "斯_",
                    "斯", "_美_", "_美", "_斯_", "_斯", "梅_西_", "梅_西", "梅_", "梅", "_梅_西",
                    "_梅_", "_梅", "美_斯_", "美_斯", "一_", "一", "_美_斯", "_一_", "_一", "賽_",
                    "賽", "巴_", "巴", "在_", "在", "_賽_", "_賽", "_巴_", "_巴", "_在_", "_在",
                    "塞_", "塞", "_塞_", "_塞", "足_", "足", "巴_塞_", "巴_塞", "_足_", "_足",
                    "_巴_塞", "他_", "他", "_他_", "_他", "01", "為_", "為", "入_", "入", "i",
                    "_為_", "_為", "_入_", "_入", "_201", "201", "00", "加_", "加", "冠_", "冠",
                    "_加_", "_加", "_冠_", "_冠", "6_", "隊_", "隊", "_隊_", "_隊", "4_", "最_",
                    "最", "中_", "中", "上_", "上", "_最_", "_最", "_中_", "_中", "_上_", "_上",
                    "和_", "和", "_和_", "_和", "0_", "國_", "國", "世_", "世", "_國_", "_國",
                    "_世_", "_世", "軍_", "軍", "生_", "生", "班_", "班", "成_", "成", "了_", "了",
                    "a", "_軍_", "_軍", "_生_", "_生", "_班_", "_班", "_成_", "_成", "_了_", "_了",
                    "5_", "盃_", "盃", "次_", "次", "會_", "會", "時_", "時", "家_", "家",
                    "冠_軍_", "冠_軍", "_盃_", "_盃", "_次_", "_次", "_會_", "_會", "_時_", "_時",
                    "_家_", "_家", "_冠_軍", "足_球_", "足_球", "西_班_", "西_班", "聯_", "聯",
                    "罗_", "罗", "界_", "界", "班_牙_", "班_牙", "牙_", "牙", "有_", "有", "月_",
                    "月", "是_", "是", "史_", "史", "世_界_", "世_界", "c", "_足_球", "_西_班",
                    "_聯_", "_聯", "_罗_", "_罗", "_界_", "_界", "_班_牙", "_牙_", "_牙", "_有_",
                    "_有", "_月_", "_月", "_是_", "_是", "_史_", "_史", "_世_界", "1_", "那_",
                    "那", "於_", "於", "員_", "員", "以_", "以", "n", "e", "_那_", "_那", "_於_",
                    "_於", "_員_", "_員", "_以_", "_以", "_6", "_200", "7_", "200", "阿_", "阿",
                    "聯_賽_", "聯_賽", "罗_那_", "罗_那", "第_", "第", "甲_", "甲", "獎_", "獎",
                    "洲_", "洲", "根_", "根", "大_", "大", "塞_罗_", "塞_罗", "史_上_", "史_上",
                    "s", "l", "_阿_", "_阿", "_聯_賽", "_罗_那", "_第_", "_第", "_甲_", "_甲",
                    "_獎_", "_獎", "_洲_", "_洲", "_根_", "_根", "_大_", "_大", "_塞_罗", "_史_上",
                    "9_", "2_", "隆_", "隆", "阿_根_", "阿_根", "金_", "金", "球_員_", "球_員",
                    "王_", "王", "歐_", "歐", "根_廷_", "根_廷", "日_", "日", "得_", "得", "廷_",
                    "廷", "助_", "助", "m", "_隆_", "_隆", "_阿_根", "_金_", "_金", "_球_員",
                    "_王_", "_王", "_歐_", "_歐", "_根_廷", "_日_", "_日", "_得_", "_得", "_廷_",
                    "_廷", "_助_", "_助", "_6_", "16", "赛_", "赛", "西_甲_", "西_甲", "的_球_",
                    "的_球", "比_", "比", "攻_", "攻", "成_為_", "成_為", "塞_隆_", "塞_隆", "場_",
                    "場", "個_", "個", "o", "_赛_", "_赛", "_西_甲", "_的_球", "_比_", "_比",
                    "_攻_", "_攻", "_成_為", "_塞_隆", "_場_", "_場", "_個_", "_個", "3_", "16_",
                    "球_會_", "球_會", "獲_", "獲", "歐_洲_", "歐_洲", "拿_", "拿", "德_", "德",
                    "屆_", "屆", "尔_", "尔", "國_家_", "國_家", "及_", "及", "協_", "協", "出_",
                    "出", "亞_", "亞", "不_", "不", "_球_會", "_獲_", "_獲", "_歐_洲", "_拿_",
                    "_拿", "_德_", "_德", "_屆_", "_屆", "_尔_", "_尔", "_國_家", "_及_", "_及",
                    "_協_", "_協",
                ],
            ),
            (
                Language::Czech,
                vec![
                    "o", "e", "a", "n", "t", "s", "i", "v", "r", "l", "d", "k", "p", "u", "m", "c",
                    "í", "e_", "_p", "z", "h", "j", "y", "á", "a_", "_s", "b", "_v", "o_", "_n",
                    "st", "í_", "u_", "ě", "i_", "po", "ro", "ov", "_z", "é", "y_", "ní", "_a",
                    "en", "ř", "_j", "ch", "na", "_k", "_t", "m_", "_d", "č", "te", "je", "pr",
                    "_o", "ý", "_po", "ž", "le", "ne", "ou", "od", "_m", "ra", "ko", "t_", "to",
                    "_pr", "ho", "ní_", "š", "é_", "do", "no", "os", "_na", "la", "se", "_b", "h_",
                    "ta", "_a_", "li", "ch_", "al", "em", "ed", "na_", "_je", "er", "va", "at",
                    "ce", "an", "_r", "ni", "lo", "in", "_ne", "ů", "v_", "el", "ě_", "ve", "ti",
                    "ak", "de", "pro", "př", "_se", "ob", "l_", "ic", "ře", "ost", "or", "je_",
                    "ou_", "_př", "k_", "_pro", "ně", "_do", "ad", "vo", "av", "za", "ol", "dn",
                    "s_", "_h", "sk", "es", "_v_", "_c", "g", "it", "_na_", "me", "et", "f", "tr",
                    "á_", "vy", "tu", "se_", "re", "em_", "ka", "by", "ot", "on", "_se_", "_za",
                    "ze", "ku", "kt", "ho_", "_st", "ná", "so", "_l", "mi", "vý", "n_", "vá", "as",
                    "d_", "ac", "to_", "rá", "ce_", "mo", "om", "ec", "e_s", "ky", "da", "il",
                    "že", "né", "ci", "_u", "e_p", "íc", "oz", "is", "ů_", "_vy", "ej", "si", "ma",
                    "sta", "am", "_je_", "_i", "e_v", "ím", "ar", "vě", "ky_", "sl", "ok", "vi",
                    "pa", "tn", "ké", "di", "ří", "án", "ter", "ova", "ně_", "_č", "mu", "ek",
                    "ý_", "sp", "ud", "ru", "ení", "_ve", "uj", "nt", "_ko", "ji", "_1", "ýc",
                    "ck", "_by", "ých", "z_", "vn", "ri", "kl", "ři", "ez", "bo", "_to", "ých_",
                    "_ro", "ení_", "a_p", "né_", "ny", "_ob", "mě", "ln", "o_p", "ti_", "cí",
                    "la_", "ik", "zn", "sti", "yl", "ný", "kte", "iv", "_te", "če", "ut", "op",
                    "_od", "ké_", "js", "e_n", "us", "tí", "kr", "ja", "hl", "oj", "le_", "ku_",
                    "jí", "ev", "pra", "_ž", "že_", "í_p", "r_", "kter", "ick", "áv", "u_p", "oh",
                    "_kt", "tě", "pod", "i_p", "do_", "ci_", "ím_", "bu", "a_s", "í_s", "te_",
                    "oc", "eb", "_kte", "sou", "ny_", "byl", "_f", "čn", "pře", "o_s", "nos", "ší",
                    "mi_", "aj", "ích", "ál", "_s_", "_ta", "_js", "zd", "dě", "_sp", "_e", "ích_",
                    "_vý", "_pod", "lu", "_pře", "pe", "ech", "e_z", "tv", "pl", "dy", "a_v", "ty",
                    "při", "lo_", "ž_", "zá", "sa", "nost", "be", "az", "ví", "hod", "ab", "še",
                    "up", "_při", "_byl", "uje", "dr", "nu", "hr", "_ja", "_do_", "át", "li_",
                    "kon", "ak_", "ová", "a_n", "ro_", "tu_", "o_v", "edn", "co", "éh", "str",
                    "du", "at_", "0_", "ém", "vé", "sv", "sti_", "ého", "stu", "st_", "rn", "mu_",
                    "lá", "jak", "ého_", "im", "_o_", "id", "_zá", "en_", "e_t", "dá", "_2", "ět",
                    "tí_", "tak", "i_s", "ent", "dl", "_z_",
                ],
            ),
            (
                Language::Danish,
                vec![
                    "e", "r", "n", "t", "s", "i", "a", "d", "l", "o", "g", "e_", "er", "k", "de",
                    "r_", "en", "f", "m", "t_", "_d", "er_", "n_", "b", "v", "u", "_a", "re",
                    "_de", "h", "et", "te", "_e", "_s", "ge", "_f", "st", "g_", "se", "in", "et_",
                    "en_", "el", "le", "_o", "p", "ng", "ar", "an", "or", "ri", "nd", "_k", "og",
                    "c", "_i", "æ", "ti", "s_", "ø", "ne", "fo", "der", "_t", "sk", "og_", "ke",
                    "de_", "is", "for", "es", "be", "_og", "li", "_og_", "_m", "_b", "ma", "d_",
                    "af", "_v", "_fo", "ing", "al", "ve", "un", "j", "i_", "at", "_for", "ld",
                    "il", "f_", "der_", "rs", "re_", "ns", "ls", "ko", "af_", "_af_", "_af", "y",
                    "nde", "ll", "_p", "nge", "els", "det", "ch", "_i_", "on", "me", "ere", "den",
                    "ag", "_en", "ol", "lse", "ke_", "ig", "id", "else", "det_", "_ko", "_det",
                    "rt", "ra", "om", "k_", "ik", "ge_", "ev", "_u", "_er", "_1", "w", "til", "ta",
                    "ser", "m_", "lle", "ha", "em", "e_d", "_h", "_er_", "å", "sti", "ris", "ng_",
                    "ist", "eg", "ed", "e_e", "am", "und", "ter", "ske", "rk", "r_d", "op", "ing_",
                    "e_a", "an_", "_de_", "ør", "to", "ser_", "rist", "rin", "or_", "nt", "la",
                    "l_", "ie", "da", "br", "at_", "_l", "_der", "_at_", "_at", "vi", "tr", "t_d",
                    "si", "ro", "ren", "r_f", "r_e", "r_de", "old", "ne_", "kr", "kon", "kke",
                    "kk", "ige", "gt", "es_", "ers", "eri", "ens", "end", "e_b", "ce", "te_",
                    "ste", "ske_", "sen", "se_", "ring", "ni", "n_a", "ler", "il_", "hr", "ho",
                    "ger", "gen", "fr", "for_", "e_f", "e_de", "di", "den_", "ark", "_w", "_til",
                    "_ti", "_st", "_ma", "_j", "_den", "_c", "_ar", "ær", "va", "til_", "t_s",
                    "t_e", "t_de", "so", "rd", "r_o", "pr", "nder", "lse_", "lig", "ki", "ide",
                    "er_o", "ene", "ek", "eb", "e_s", "_un", "_g", "_fr", "v_", "unde", "tt",
                    "t_i", "t_a", "sto", "sc", "sa", "r_s", "r_i", "ot", "ns_", "nn", "nd_", "nc",
                    "n_d", "mi", "lin", "le_", "lde", "ka", "isti", "ikke", "ikk", "ia", "hri",
                    "hol", "he", "gs", "gel", "g_s", "ft", "ere_", "er_e", "er_d", "ent", "ens_",
                    "en_a", "e_o", "e_fo", "del", "chri", "chr", "av", "ar_", "ale", "age", "_und",
                    "_sk", "_si", "_et_", "_et", "_en_", "_da", "00", "æl", "ver", "us", "ud",
                    "ts", "tel", "t_k", "skr", "sch", "rn", "ret", "rb", "r_a", "ov", "ote", "ors",
                    "om_", "nne", "nce", "mar", "kt", "kke_", "ind", "in_", "ige_", "hris", "hold",
                    "gr", "ger_", "gen_", "g_e", "g_a", "ende", "ed_", "e_v", "e_t", "e_l", "ds",
                    "dan", "bl", "all", "_vi", "_va", "_te", "_r", "_pr", "_n", "_me", "_kon",
                    "_in", "_ikk", "_ik", "_di", "_chr", "_ch", "_br", "_be", "0_", "æn", "å_",
                    "væ", "var_", "var", "tte", "tian", "tia", "ter_", "ten", "tal", "t_v", "t_m",
                    "sy", "stia", "ses", "sen_", "s_k", "ru", "rst", "rk_", "r_v", "r_og", "r_k",
                    "pe", "over", "ove",
                ],
            ),
            (
                Language::Dutch,
                vec![
                    "e", "n", "t", "a", "i", "r", "d", "n_", "o", "en", "s", "g", "e_", "l", "en_",
                    "t_", "de", "er", "v", "u", "k", "h", "_d", "an", "j", "_v", "m", "ge", "b",
                    "in", "r_", "et", "z", "te", "p", "ij", "_e", "st", "de_", "_h", "aa", "w",
                    "ie", "et_", "_z", "ee", "an_", "_de", "s_", "el", "he", "ve", "_o", "_b",
                    "_de_", "er_", "c", "_s", "_i", "at", "_m", "_a", "le", "be", "ar", "_g", "ng",
                    "den", "_he", "va", "ni", "or", "oo", "nt", "g_", "_va", "van", "nd", "da",
                    "d_", "ver", "van_", "ud", "re", "n_d", "_w", "_k", "tu", "_van", "ze", "ri",
                    "ing", "di", "_t", "vo", "stu", "n_v", "_st", "zi", "het", "at_", "al", "_zi",
                    "_in", "_het", "_ge", "_be", "on", "het_", "gen", "ch", "aar", "_da", "rd",
                    "li", "ke", "k_", "f", "es", "ude", "tud", "ti", "stud", "is", "_vo", "_stu",
                    "t_d", "op", "it", "den_", "we", "ra", "oe", "me", "ed", "_ve", "_en_", "_en",
                    "_ee", "ui", "uden", "ten", "se", "ro", "oor", "ne", "l_", "gen_", "een",
                    "dat_", "dat", "_ver", "n_z", "ie_", "eg", "eer", "een_", "der", "_n", "_j",
                    "_een", "zij", "te_", "rs", "nte", "nge", "nde", "jn", "ijn", "eu", "ent",
                    "e_v", "_zij", "_l", "tude", "ten_", "pa", "p_", "ng_", "n_de", "je", "en_v",
                    "ek", "die", "_dat", "zijn", "un", "ste", "ns", "ma", "jn_", "in_", "ijn_",
                    "gel", "en_z", "en_d", "ar_", "aar_", "aan", "_ze", "_p", "ze_", "t_e", "sc",
                    "ot", "nie", "n_s", "n_o", "n_h", "mo", "la", "je_", "ho", "erd", "ei", "an_d",
                    "_op", "_in_", "_al", "wa", "voor", "voo", "ta", "rt", "om", "n_w", "ll",
                    "lij", "jk", "inge", "ijk", "ic", "ente", "aan_", "_voo", "_u", "_te", "zo",
                    "to", "ter", "t_de", "sch", "rde", "or_", "op_", "oor_", "ol", "n_ve", "n_e",
                    "n_a", "lijk", "ing_", "ers", "en_o", "el_", "e_o", "dent", "ag", "ad", "_mo",
                    "_me", "_je_", "_je", "t_z", "t_m", "t_be", "t_b", "r_d", "ou", "nt_", "nder",
                    "n_zi", "n_t", "n_st", "n_g", "n_b", "m_", "len", "iet", "ich", "gr", "est",
                    "ep", "em", "eke", "e_h", "die_", "_nie", "_ni", "_er", "_di", "ur", "uit",
                    "tr", "t_h", "rk", "nten", "nn", "niet", "ngen", "na", "n_i", "n_he", "mi",
                    "kr", "is_", "ig", "iet_", "hu", "ev", "ere", "en_e", "elij", "eli", "ele",
                    "ege", "eb", "e_va", "e_s", "e_d", "do", "der_", "ba", "as", "_zo", "_we",
                    "_wa", "_le", "_aa", "wi", "ven", "us", "ts", "tij", "se_", "rij", "ren",
                    "r_z", "pe", "ond", "og", "no", "ning", "nin", "nd_", "n_vo", "n_in", "n_ge",
                    "n_be", "met_", "met", "lle", "len_", "ker", "ken", "jd", "j_", "it_", "ik",
                    "ijd", "ij_", "gro", "g_v", "even", "eve", "end", "eerd", "ede", "e_st", "e_b",
                    "bi", "_ze_", "_to", "_r", "_pa", "_op_", "_met", "_ma", "_do", "_die", "udie",
                    "udi", "tudi", "tijd", "tel", "t_v", "t_he", "ss", "si", "rin", "rden", "rd_",
                    "r_e", "oude", "oud", "ord", "ok", "oet", "nne", "n_m",
                ],
            ),
            (
                Language::English,
                vec![
                    "e", "t", "a", "i", "n", "o", "s", "r", "h", "e_", "_t", "l", "d", "th", "c",
                    "s_", "_th", "_a", "he", "m", "u", "the", "f", "in", "_the", "n_", "p", "_i",
                    "t_", "d_", "he_", "er", "y", "b", "the_", "g", "w", "on", "re", "r_", "_o",
                    "an", "_w", "v", "en", "ti", "y_", "_b", "nd", "it", "ea", "es", "_s", "at",
                    "ar", "_in", "ha", "ve", "to", "o_", "st", "f_", "be", "te", "on_", "nd_",
                    "_c", "_an", "of", "er_", "ed", "and", "_to", "_p", "_of", "ng", "to_", "se",
                    "of_", "me", "io", "_of_", "or", "nt", "a_", "_f", "and_", "_to_", "_r", "in_",
                    "_be", "_and", "ion", "g_", "ed_", "as", "_h", "s_a", "ing", "al", "_d", "ng_",
                    "is", "e_t", "de", "_m", "k", "ing_", "ns", "l_", "_l", "_a_", "ou", "li",
                    "ic", "_in_", "n_t", "ne", "hi", "es_", "ri", "n_th", "ra", "le", "ion_",
                    "e_a", "co", "ce", "_e", "ll", "ie", "ad", "_it", "tio", "ro", "il", "ent",
                    "_co", "tion", "ac", "_re", "wi", "re_", "pe", "ec", "_ha", "ve_", "ts", "so",
                    "s_t", "pr", "h_", "at_", "_wi", "wh", "ver", "ts_", "pa", "em", "ct", "ch",
                    "_g", "’", "we", "rt", "men", "f_th", "f_t", "d_t", "_wh", "us", "tha", "t_t",
                    "ns_", "ma", "m_", "la", "her", "e_i", "be_", "am", "_tha", "ty", "om", "nc",
                    "ll_", "it_", "in_t", "hat", "et", "di", "ci", "_de", "_be_", "st_", "ss",
                    "of_t", "iv", "is_", "ee", "_n", "s_an", "rea", "e_o", "ar_", "_we", "_on",
                    "un", "ul", "thi", "s_o", "res", "ot", "nt_", "na", "ment", "g_t", "ere",
                    "e_th", "d_a", "ce_", "ca", "as_", "ab", "_u", "’s_", "’s", "ta", "si", "s_th",
                    "op", "ng_t", "n_a", "mp", "lo", "im", "hat_", "fo", "el", "art", "_pr",
                    "_it_", "ut", "r_t", "ons", "ive", "ent_", "e_r", "e_m", "ati", "_y", "that",
                    "ill", "ess", "en_", "e_s", "e_p", "con", "_pa", "ty_", "ther", "t_w", "part",
                    "par", "p_", "mo", "ill_", "ho", "her_", "go", "for", "eas", "ch_", "av", "ai",
                    "_thi", "_te", "_ma", "_is", "ur", "tu", "tt", "tr", "t_i", "s_w", "rs", "pro",
                    "ov", "or_", "one", "ni", "n_o", "n_i", "mi", "ly_", "ly", "le_", "ir", "hin",
                    "hav", "fr", "es_a", "ear", "e_in", "e_f", "an_", "al_", "_hav", "_con",
                    "will", "wil", "ter", "t_th", "se_", "s_of", "s_a_", "per", "os", "ne_", "me_",
                    "ig", "ies_", "ies", "he_t", "ge", "g_th", "ei", "e_c", "d_th", "d_b", "bl",
                    "ace", "_wil", "_mo", "_la", "_is_", "_go", "_fo", "_ca", "_al", "ye", "y_i",
                    "wo", "to_t", "thin", "t_a", "s_s", "s_c", "r_i", "ove", "ons_", "o_t", "nf",
                    "he_s", "have", "gr", "eve", "ev", "ed_t", "e_re", "e_b", "d_i", "ave_", "ave",
                    "_ye", "_v", "_un", "_so", "_se", "_ra", "_pro", "_on_", "_le", "_he", "_at",
                    "_as", "year", "yea", "y_in", "y_a", "x", "with", "wit", "vi", "ut_", "tic",
                    "tea", "t_o", "su", "sh", "ry", "riv", "oul", "on_o", "o_th", "nce", "ld_",
                    "ld", "iti", "ith",
                ],
            ),
            (
                Language::Esperanto,
                vec![
                    "a", "o", "i", "e", "n", "r", "s", "l", "t", "u", "m", "k", "o_", "d", "n_",
                    "p", "a_", "s_", "v", "e_", "j", "_k", "_p", "as", "i_", "as_", "_s", "_m",
                    "in", "en", "_v", "la", "_l", "or", "on", "_d", "f", "_a", "ĉ", "ro", "b",
                    "j_", "l_", "g", "vi", "la_", "ka", "_e", "_n", "an", "ta", "ri", "_vi", "_f",
                    "st", "on_", "te", "r_", "po", "aj", "_ĉ", "_t", "mi", "u_", "mo", "in_", "el",
                    "ra", "_la", "er", "re", "ar", "al", "de", "_la_", "ĝ", "ko", "_mi", "am",
                    "oj", "_ka", "is", "to", "da", "nt", "es", "un", "aj_", "_r", "m_", "ia",
                    "ro_", "_po", "ti", "lo", "c", "nd", "en_", "va", "se", "no", "ni", "do", "ma",
                    "_de", "pr", "na", "ku", "kaj_", "kaj", "is_", "de_", "_kaj", "z", "ve", "ol",
                    "ne", "li", "h", "om", "pe", "ki", "ŝ", "ur", "pa", "o_k", "nu", "or_", "io",
                    "_se", "_pr", "_h", "tr", "du", "ga", "_ki", "_i", "_de_", "ir", "fo", "at",
                    "ĉi", "me", "_j", "si", "oj_", "mi_", "est", "to_", "su", "ie", "_ĉi", "_b",
                    "te_", "e_l", "ĝi", "so", "pl", "_ne", "_mi_", "tas_", "tas", "n_p", "_mo",
                    "_en", "_am", "n_k", "_ĝ", "_ko", "_fo", "_du", "_al", "vo", "le", "_su",
                    "_l_", "_en_", "ĉe", "os", "al_", "_ku", "sta", "ru", "por", "oro", "o_p",
                    "jn", "ia_", "_pe", "tu", "for", "bo", "a_k", "_pa", "_ni", "_for", "ra_",
                    "o_d", "lu", "am_", "a_s", "_ŝ", "_ĉe", "_por", "um", "s_k", "el_", "di",
                    "_pl", "_o", "un_", "s_m", "por_", "ne_", "jn_", "iv", "et", "das_", "das",
                    "a_p", "_ma", "ul", "s_p", "nda", "ed", "do_", "a_v", "_ĝi", "_si", "_al_",
                    "uk", "sa", "mo_", "ja", "em", "e_l_", "d_", "_ve", "ng", "ek", "_do", "ta_",
                    "t_", "oro_", "o_m", "ko_", "iu", "iel", "e_k", "_es", "_c", "s_s", "rt", "rd",
                    "no_", "n_s", "mp", "il", "ent", "e_p", "_tr", "_ne_", "ĉa", "us", "ub", "mon",
                    "id", "da_", "an_", "_ri", "_re", "ŝi", "stas", "pri", "pi", "ni_", "n_m",
                    "n_l", "n_d", "mu", "kor", "fi", "end", "duk", "av", "a_m", "_in", "_est",
                    "vi_", "ri_", "per", "ojn_", "ojn", "nk", "n_a", "lo_", "las", "ino", "ig",
                    "de_l", "ce", "as_p", "ant", "a_vi", "us_", "um_", "uko", "sen", "ov", "je",
                    "iu_", "iel_", "fe", "esta", "duko", "ci", "as_m", "_ŝi", "_nu", "ŭ", "uko_",
                    "sin", "s_v", "s_n", "s_mi", "re_", "ond", "kr", "kie", "int", "go", "ev",
                    "aŭ", "as_k", "ag", "_vi_", "_va", "_sen", "_pri", "_kie", "_duk", "ĉe_",
                    "vin", "ur_", "ten", "sti", "s_a", "pro", "op", "o_v", "o_s", "o_e", "o_a",
                    "ndas", "nas", "min", "kun", "it", "i_p", "fa", "elo", "e_v", "e_s", "ara",
                    "a_ĉ", "a_a", "_so", "_pro", "_min", "_kun", "_kor", "viv", "sp", "se_", "rm",
                    "ort", "ola", "nin", "min_", "mal", "las_", "kun_", "kiel", "e_m", "br", "a_d",
                    "_vin", "_te", "_mu", "_mal", "_ja", "_g", "ĝo", "vin_", "ver", "vas_", "vas",
                    "ter", "sk", "rin",
                ],
            ),
            (
                Language::Estonian,
                vec![
                    "a", "e", "i", "s", "t", "u", "l", "k", "n", "m", "a_", "d", "o", "e_", "r",
                    "_k", "s_", "i_", "v", "h", "g", "p", "d_", "j", "_t", "_m", "se", "ma", "is",
                    "t_", "in", "_s", "ô", "ä", "ta", "as", "st", "te", "_p", "le", "_j", "_v",
                    "si", "ku", "el", "al", "_o", "ja", "va", "es", "li", "_e", "id", "_a", "us",
                    "ud", "ei", "da", "mi", "ü", "ol", "nu", "_n", "u_", "tu", "ka", "ja_", "_ja",
                    "me", "ga", "na", "b", "n_", "em", "st_", "_se", "uu", "ud_", "ra", "l_", "at",
                    "ul", "ma_", "ik", "et", "an", "ne", "ks", "ee", "de", "aa", "a_k", "_ta",
                    "_ja_", "_h", "nud", "_ku", "nud_", "he", "ga_", "as_", "ag", "ni", "ko",
                    "id_", "am", "_l", "ôi", "är", "te_", "ll", "le_", "ke", "_va", "_te", "_mi",
                    "nd", "ii", "ad", "_r", "vô", "sa", "is_", "es_", "a_t", "_vô", "ks_", "ju",
                    "ha", "en", "ast", "ak", "_ol", "ut", "ta_", "pa", "ise", "il", "gi", "eg",
                    "ar", "_si", "_ko", "_ka", "sin", "ne_", "it", "in_", "ed", "ah", "_ma", "ö",
                    "vi", "un", "ui", "sel", "se_", "re", "po", "oo", "ki", "e_k", "da_", "d_j",
                    "a_p", "_i", "vôi", "ts", "su", "ri", "oli", "min", "li_", "la", "kui", "gu",
                    "e_v", "ai", "_vôi", "ust", "oh", "na_", "lu", "lt", "im", "i_t", "gi_", "est",
                    "er", "ei_", "asi", "aga", "a_e", "_ä", "_pa", "_kui", "_ei_", "_ei", "ära",
                    "us_", "sta", "ole", "lt_", "kk", "ist", "ine", "i_s", "ge", "ema", "ele",
                    "eh", "e_m", "av", "a_m", "_tu", "_po", "tt", "tas", "s_t", "s_s", "s_m", "or",
                    "mis", "me_", "lle", "les", "ida", "hel", "et_", "ek", "a_o", "a_a", "_oli",
                    "_me", "u_k", "ste", "sin_", "s_k", "pu", "pi", "ot", "on", "ng", "mu", "lis",
                    "kuu", "inu", "ine_", "ina", "hk", "gu_", "eis", "e_s", "e_p", "d_k", "ava",
                    "aks", "aj", "aga_", "ad_", "a_v", "a_h", "_ü", "_ta_", "_sel", "_ni", "_ju",
                    "_et", "ôt", "ää", "um", "ui_", "tei", "t_k", "s_o", "on_", "oma", "om", "nn",
                    "m_", "kui_", "ka_", "ia", "i_v", "i_m", "hi", "est_", "ell", "el_", "ea",
                    "di", "de_", "d_a", "ast_", "a_s", "a_ku", "_on_", "_on", "_oma", "_om",
                    "_kuu", "_he", "_aga", "_ag", "üü", "ül", "äi", "ve", "uul", "tte", "tas_",
                    "rd", "puu", "pe", "oli_", "nii", "lm", "lg", "ld", "kü", "kô", "ki_", "kas",
                    "ja_k", "ime", "i_n", "ev", "ema_", "elle", "ega", "d_m", "b_", "ami", "ama",
                    "al_", "ae", "ab", "a_l", "_sa", "_nii", "_na", "_mu", "_kô", "_ke", "_ha",
                    "_et_", "üüd", "üd", "ôi_", "vas", "use", "tus", "tul", "tte_", "tl", "t_o",
                    "sell", "see", "s_p", "roh", "ro", "rk", "ra_", "pol", "nii_", "nde", "lä",
                    "kuul", "ing", "ina_", "ika", "ii_", "hke", "em_", "ega_", "e_va", "e_t",
                    "e_se", "e_r", "du", "d_ja", "ba", "ata", "all", "aks_", "aja", "a_j", "_ô",
                    "_ära", "_är", "_ve", "_tei", "_roh", "_ro", "_pu", "_pol", "_min", "_lä",
                    "_kü", "üüd_",
                ],
            ),
            (
                Language::Euskara,
                vec![
                    "a", "e", "r", "i", "n", "t", "o", "k", "u", "z", "a_", "n_", "s", "en", "l",
                    "_e", "ar", "d", "g", "er", "en_", "ra", "b", "an", "re", "ta", "ko", "o_",
                    "rr", "ak", "h", "ri", "m", "ia", "p", "k_", "_z", "at", "te", "ko_", "in",
                    "et", "_a", "_b", "ze", "_g", "_i", "_h", "an_", "tu", "ek", "eta", "al",
                    "ren", "es", "na", "tz", "ta_", "a_e", "it", "i_", "err", "ai", "zi", "ren_",
                    "ur", "la", "ik", "za", "ka", "rre", "or", "iz", "eta_", "de", "u_", "be",
                    "nt", "ni", "ir", "ako", "ak_", "_et", "_eta", "rt", "ea", "_er", "oa", "ba",
                    "st", "is", "e_", "pa", "on", "_d", "zen", "nd", "are", "_es", "ra_", "di",
                    "_k", "ge", "aren", "ako_", "n_e", "io", "eg", "ma", "ha", "ia_", "_err", "gi",
                    "tu_", "atu", "ro", "ki", "hi", "go", "erre", "eko", "ne", "ga", "era", "da",
                    "_m", "sp", "eko_", "arr", "_ze", "zu", "li", "ld", "ber", "zen_", "ut", "un",
                    "ue", "su", "rri", "ran", "f", "bi", "_zi", "ti", "spa", "rra", "as", "ald",
                    "n_a", "le", "au", "_p", "nia", "ain", "_ba", "u_z", "sa", "n_z", "me", "_be",
                    "tze", "il", "ri_", "iak", "_o", "_iz", "r_", "o_e", "ist", "el", "_zu", "_ha",
                    "si", "ria", "ez", "esp", "_zen", "na_", "la_", "en_a", "a_h", "_u", "_s",
                    "_l", "_esp", "ts", "n_b", "ini", "en_e", "ek_", "_ge", "ol", "ntz", "ku",
                    "espa", "a_g", "_hi", "kar", "ie", "du", "a_i", "tu_z", "ten", "k_e", "c",
                    "ag", "uen", "pai", "iza", "ger", "ua", "tza", "spai", "pain", "ib", "he",
                    "ara", "aini", "ab", "_ir", "uen_", "ten_", "n_h", "ira", "inia", "fr", "art",
                    "ad", "_f", "sta", "n_g", "lde", "itu", "eri", "alde", "a_et", "ean", "sk",
                    "rte", "ot", "do", "z_", "uz", "te_", "reg", "pe", "ok", "ko_e", "iar", "gu",
                    "fra", "ari", "ar_", "a_b", "_ger", "_1", "zue", "ul", "tik", "rak", "oa_",
                    "ere", "az", "atu_", "an_z", "_ka", "_ga", "urr", "to", "j", "ena", "ean_",
                    "bat", "ana", "ute", "rreg", "in_", "iko", "eu", "ela", "_fr", "_bi", "zuen",
                    "tan", "mo", "ika", "ik_", "fran", "en_b", "eh", "_zue", "_iza", "_he", "_fra",
                    "_de", "_ber", "_bat", "zt", "zk", "zeko", "zek", "us", "tzek", "tar", "t_",
                    "o_i", "niak", "men", "itz", "iako", "end", "ea_", "_j", "_ar", "so", "rri_",
                    "rik", "res", "rat", "n_k", "l_", "i_z", "ho", "gin", "em", "egi", "aur", "am",
                    "a_a", "_ko", "zan", "tat", "ta_e", "ste", "ru", "rk", "pr", "izan", "int",
                    "est", "era_", "a_es", "_t", "_ira", "_di", "_al", "zit", "x", "ter", "tan_",
                    "o_a", "n_d", "lt", "iri", "har", "gar", "erra", "en_g", "ate", "arre", "ant",
                    "a_er", "_n", "_ho", "_eu", "tak", "no", "lo", "lar", "kon", "erri", "de_",
                    "zio", "zan_", "tzi", "tek", "rren", "ndo", "n_i", "man", "koa", "ko_i", "ke",
                    "ize", "iak_", "gr", "ert", "ene", "dor", "an_e", "ala", "ak_e", "a_s", "a_m",
                    "_me", "_au", "zia", "um", "u_zu",
                ],
            ),
            (
                Language::Finnish,
                vec![
                    "a", "i", "t", "n", "e", "s", "l", "k", "o", "u", "ä", "n_", "m", "a_", "v",
                    "h", "y", "ta", "r", "an", "st", "in", "p", "en", "j", "is", "_k", "it", "si",
                    "aa", "i_", "tt", "li", "ä_", "va", "_t", "ll", "en_", "mi", "ka", "se", "te",
                    "an_", "tä", "tu", "el", "oi", "ai", "_o", "_v", "t_", "ma", "es", "to", "et",
                    "_s", "d", "_e", "_p", "ki", "il", "al", "on", "ol", "us", "la", "e_", "ku",
                    "ks", "im", "ik", "_j", "ta_", "sa", "ri", "le", "ja", "in_", "_m", "_h", "ti",
                    "ss", "ke", "at", "uu", "n_k", "ko", "nn", "lu", "ist", "aan", "sta", "na",
                    "_va", "ii", "as", "uo", "ut", "un", "tä_", "os", "ne", "ha", "ei", "aan_",
                    "ssa", "nk", "_l", "on_", "er", "_a", "vä", "ty", "tta", "toi", "sk", "oim",
                    "n_t", "me", "ia", "ar", "ak", "_ka", "ö", "ää", "vi", "sa_", "nt", "n_p",
                    "lä", "ja_", "ie", "am", "_to", "yt", "ul", "su", "sta_", "ssa_", "om", "ni",
                    "lli", "ksi", "imi", "de", "toim", "taa", "ste", "pa", "oimi", "n_v", "min",
                    "ise", "he", "ett", "ell", "ee", "ais", "_on", "_ol", "_ko", "_ja", "_ha",
                    "lla", "itt", "est", "all", "aa_", "a_o", "a_k", "_y", "_n", "vo", "uk", "sä",
                    "si_", "pä", "ok", "lt", "kse", "kk", "jo", "je", "em", "au", "at_", "an_k",
                    "_toi", "ts", "sen", "pi", "ot", "nki", "n_s", "le_", "iv", "iin", "ht",
                    "_on_", "_ke", "_ja_", "än", "äl", "äi", "ust", "up", "tus", "ttä", "ten",
                    "s_", "ole", "nna", "mu", "mis", "lle", "lla_", "lis", "la_", "ksi_", "eri",
                    "av", "ama", "a_m", "_tu", "_ma", "äv", "ät", "yy", "yh", "van", "u_", "oli",
                    "oit", "nne", "n_va", "mm", "lin", "jä", "ite", "i_k", "hal", "ast", "aj",
                    "ah", "_ku", "_jo", "voi", "uut", "uks", "stä", "sti", "ra", "oj", "nta",
                    "n_m", "n_j", "kau", "io", "iks", "iin_", "i_t", "hu", "hel", "hd", "g", "et_",
                    "en_t", "eh", "alli", "a_v", "a_s", "a_j", "_ta", "_su", "_i", "_et", "är",
                    "ä_t", "y_", "vai", "uv", "ur", "ulu", "täv", "ttaa", "ten_", "sä_", "stu",
                    "ssä_", "ssä", "so", "sia", "ses", "rk", "rj", "po", "pe", "ou", "ost", "op",
                    "no", "nen_", "nen", "n_h", "maa", "lle_", "lai", "kä", "kin", "kesk", "kes",
                    "kaup", "kan", "iste", "isi", "int", "ine", "ila", "iksi", "ien", "ia_", "ess",
                    "esk", "aup", "ari", "ank", "a_e", "_si", "_pä", "_ole", "_kes", "_hal", "ävä",
                    "äs", "vat_", "vat", "val", "ukse", "ui", "til", "ti_", "tet", "tel", "tav",
                    "taan", "suu", "suo", "stä_", "sku", "sit", "sen_", "ri_", "pu", "pp", "omi",
                    "oll", "nä", "ns", "n_tu", "n_o", "n_ka", "n_e", "mä", "lä_", "lo", "lm",
                    "llä", "li_", "lais", "kin_", "ita", "iss", "inn", "inen", "imin", "ill", "ho",
                    "ev", "eu", "ella", "een", "ava", "aka", "ain", "_yh", "_vai", "_u", "_suo",
                    "_se", "_r", "_mu", "_mi", "_kan", "äli", "ä_v", "ä_s", "ä_k", "ytt", "yt_",
                    "väl",
                ],
            ),
            (
                Language::French,
                vec![
                    "e", "s", "i", "r", "n", "a", "t", "e_", "o", "u", "l", "d", "s_", "_d", "c",
                    "p", "é", "m", "es", "_l", "t_", "on", "le", "de", "es_", "_de", "re", "en",
                    "f", "_p", "n_", "_c", "de_", "nt", "g", "_de_", "_a", "r_", "_le", "_e", "v",
                    "an", "_s", "er", "h", "qu", "q", "ai", "a_", "ou", "it", "is", "_m", "le_",
                    "te", "ra", "ns", "la", "io", "ti", "e_d", "co", "se", "ion", "les", "s_d",
                    "les_", "in", "ie", "ur", "_f", "é_", "re_", "nt_", "b", "u_", "pr", "on_",
                    "ar", "_t", "et", "ent", "di", "_r", "_le_", "tr", "ns_", "me", "e_l", "ce",
                    "_qu", "_q", "_la", "_co", "è", "ui", "po", "pa", "la_", "ir", "au", "_les",
                    "_la_", "ue", "t_d", "s_l", "ro", "or", "nd", "ion_", "eu", "at", "tion",
                    "tio", "st", "nc", "e_de", "dé", "ch", "si", "ons", "ne", "et_", "_pa", "ve",
                    "un", "ts", "ss", "s_c", "que", "er_", "té", "ts_", "it_", "il", "i_", "el",
                    "e_s", "_n", "_i", "_en", "sa", "ré", "ma", "e_c", "_dé", "x", "se_", "s_p",
                    "s_de", "li", "_et_", "_et", "à_", "à", "ut", "ri", "om", "n_d", "j", "ent_",
                    "ci", "ap", "_à_", "_à", "_se", "_pr", "_g", "ér", "s_le", "rt", "pe", "par",
                    "ont", "oi", "mi", "l'", "he", "en_", "em", "ec", "e_p", "e_m", "e_f", "con",
                    "as", "ait", "_par", "_l'", "'a", "és", "ue_", "té_", "te_", "so", "s_r",
                    "s_a", "r_l", "ons_", "mp", "is_", "ire", "e_e", "e_a", "d'", "_re", "_j",
                    "_di", "_d'", "_con", "_ce", "ès_", "ès", "y", "vi", "ur_", "ta", "su", "our",
                    "ni", "ne_", "mo", "ge", "fi", "est", "es_r", "es_d", "bl", "av", "_so", "_h",
                    "ét", "x_", "un_", "rs", "res", "que_", "né", "me_", "l_", "e_le", "des_",
                    "des", "che", "au_", "ait_", "ais", "_su", "_o", "_mo", "_ma", "_des", "_av",
                    "ée", "éc", "à_l", "ux", "us", "up", "ui_", "t_de", "sé", "s_s", "s_e", "pro",
                    "pp", "pl", "nt_d", "n_de", "iqu", "iq", "ions", "il_", "ien", "ic", "e_qu",
                    "e_q", "du", "da", "ces", "ati", "ans", "_à_l", "_un", "_u", "_b", "tre", "to",
                    "rès_", "rès", "rè", "rs_", "r_le", "r_d", "qui_", "qui", "on_d", "nte", "men",
                    "ll", "ique", "id", "fo", "e_n", "e_co", "dr", "de_l", "com", "ces_", "ce_",
                    "atio", "ans_", "anc", "al", "_tr", "_qui", "_pro", "_in", "_il", "_en_",
                    "_ch", "_au", "ê", "ég", "ée_", "é_d", "à_la", "ux_", "t_p", "st_", "ser",
                    "s_m", "rec", "r_de", "pu", "oup", "ont_", "no", "nn", "ndr", "ndi", "na",
                    "mé", "ment", "mai", "lé", "ité", "ig", "if", "ier", "he_", "ha", "gr", "ff",
                    "est_", "es_c", "emen", "eme", "do", "de_f", "ct", "ca", "c_", "app", "ant",
                    "_v", "_to", "_po", "_il_", "_es", "_do", "_au_", "és_", "él", "é_l", "va",
                    "um", "uis", "tou", "t_l", "t_c", "t_a", "sion", "sio", "s_co", "rés", "rc",
                    "rai", "pas", "os", "ort", "omp", "lle", "le_p", "le_c", "k", "ité_", "ire_",
                    "ir_", "im",
                ],
            ),
            (
                Language::Georgian,
                vec![
                    "ა",
                    "ი",
                    "ე",
                    "ს",
                    "რ",
                    "ო",
                    "მ",
                    "ლ",
                    "დ",
                    "ნ",
                    "ს_",
                    "ბ",
                    "ი_",
                    "ის",
                    "ვ",
                    "ა_",
                    "უ",
                    "თ",
                    "ის_",
                    "ებ",
                    "გ",
                    "და",
                    "_მ",
                    "ტ",
                    "ლი",
                    "შ",
                    "ხ",
                    "არ",
                    "ან",
                    "კ",
                    "სა",
                    "რი",
                    "_ს",
                    "_დ",
                    "_ა",
                    "ც",
                    "ბი",
                    "მა",
                    "ამ",
                    "წ",
                    "ელ",
                    "_და",
                    "ერ",
                    "და_",
                    "ად",
                    "ქ",
                    "_გ",
                    "ია",
                    "გა",
                    "ლე",
                    "რე",
                    "პ",
                    "ები",
                    "ნი",
                    "მო",
                    "ლი_",
                    "ბა",
                    "რო",
                    "მი",
                    "ას",
                    "ულ",
                    "ფ",
                    "ზ",
                    "ნა",
                    "_ი",
                    "რა",
                    "_სა",
                    "ვე",
                    "ე_",
                    "თა",
                    "ში",
                    "ავ",
                    "ალ",
                    "ენ",
                    "ობ",
                    "მე",
                    "_გა",
                    "დე",
                    "_რ",
                    "ვი",
                    "ვა",
                    "ში_",
                    "სი",
                    "ნ_",
                    "_შ",
                    "ნე",
                    "_წ",
                    "ო_",
                    "ს_მ",
                    "ით",
                    "ყ",
                    "ლა",
                    "თ_",
                    "ლო",
                    "ილ",
                    "შე",
                    "_კ",
                    "ეს",
                    "ბის",
                    "ურ",
                    "ინ",
                    "ომ",
                    "ორ",
                    "ახ",
                    "ღ",
                    "_და_",
                    "_ე",
                    "რთ",
                    "დი",
                    "დ_",
                    "_შე",
                    "ბის_",
                    "ძ",
                    "ლებ",
                    "ან_",
                    "ული",
                    "ონ",
                    "თი",
                    "ბა_",
                    "რი_",
                    "იდ",
                    "ოს",
                    "ების",
                    "ტი",
                    "ება",
                    "_მა",
                    "_პ",
                    "ს_ს",
                    "ირ",
                    "ი_მ",
                    "_მო",
                    "ით_",
                    "ის_მ",
                    "_თ",
                    "ელი",
                    "ხე",
                    "რის",
                    "ემ",
                    "ლის",
                    "_მი",
                    "ეთ",
                    "ა_მ",
                    "ია_",
                    "_1",
                    "ული_",
                    "რებ",
                    "ატ",
                    "ც_",
                    "აც",
                    "_რო",
                    "აშ",
                    "ად_",
                    "ჩ",
                    "ს_დ",
                    "ოდ",
                    "ტე",
                    "ოლ",
                    "ზე",
                    "ა_დ",
                    "მ_",
                    "ევ",
                    "ი_ა",
                    "ბე",
                    "ედ",
                    "ტა",
                    "ი_დ",
                    "სე",
                    "კა",
                    "_ბ",
                    "ბუ",
                    "ცი",
                    "იმ",
                    "რის_",
                    "_უ",
                    "ი_ს",
                    "სტ",
                    "ას_",
                    "ათ",
                    "ა_ს",
                    "ა_ა",
                    "იან",
                    "მდ",
                    "ოვ",
                    "ა_და",
                    "მის",
                    "ლის_",
                    "გი",
                    "ტო",
                    "ის_ს",
                    "ს_გ",
                    "არი",
                    "ხა",
                    "რომ",
                    "_ნ",
                    "წე",
                    "აქ",
                    "ება_",
                    "ს_ა",
                    "ნებ",
                    "ობა",
                    "ეო",
                    "_არ",
                    "ვლ",
                    "რ_",
                    "სახ",
                    "ილი",
                    "არე",
                    "ანი",
                    "_რომ",
                    "ნდ",
                    "ბი_",
                    "ი_და",
                    "ველ",
                    "_ხ",
                    "_მე",
                    "კი",
                    "აი",
                    "_ქ",
                    "ერი",
                    "ამო",
                    "_ფ",
                    "დებ",
                    "ადა",
                    "აღ",
                    "ური",
                    "პი",
                    "იე",
                    "ეს_",
                    "გე",
                    "ს_შ",
                    "კუ",
                    "იც",
                    "ზე_",
                    "ბს",
                    "ს_და",
                    "უნ",
                    "ლ_",
                    "ები_",
                    "თვ",
                    "ლს",
                    "იო",
                    "აკ",
                    "ბულ",
                    "ბს_",
                    "ვის",
                    "აგ",
                    "i",
                    "ს_სა",
                    "ნის",
                    "ერთ",
                    "გან",
                    "დგ",
                    "ობი",
                    "ნი_",
                    "იტ",
                    "ი_გ",
                    "მა_",
                    "ჯ",
                    "ელი_",
                    "აა",
                    "ყო",
                    "მდე",
                    "აზ",
                    "ორი",
                    "ნო",
                    "კო",
                    "იუ",
                    "ებუ",
                    "ბით",
                    "აში",
                    "ი_ი",
                    "ებულ",
                    "_ო",
                    "სი_",
                    "იი",
                    "ალი",
                    "_ტ",
                    "ს_გა",
                    "ბო",
                    "რს",
                    "ისა",
                    "გამ",
                    "_გამ",
                    "ქა",
                    "ეტ",
                    "ტრ",
                    "ოს_",
                    "ნტ",
                    "ვრ",
                    "ეგ",
                    "მარ",
                    "ბით_",
                    "რმ",
                    "იკ",
                    "ართ",
                    "წლ",
                    "იდა",
                    "_ერ",
                    "ლები",
                    "ის_დ",
                    "ს_შე",
                    "ოგ",
                    "აში_",
                    "_ც",
                    "თა_",
                    "ეთი",
                    "ამა",
                    "_ამ",
                    "_2",
                    "ფი",
                    "ხვ",
                    "ური_",
                    "წა",
                    "ლია",
                    "დან",
                    "_წლ",
                    "ლს_",
                    "ლობ",
                    "თავ",
                    "გრ",
                    "ბრ",
                    "რუ",
                    "ის_გ",
                    "ა_რ",
                    "_წე",
                    "_სი",
                    "დრ",
                    "ი_გა",
                    "თი_",
                    "ანა",
                    "_თა",
                    "წი",
                    "_ჩ",
                    "_რა",
                    "პა",
                    "თე",
                    "გამო",
                    "_ნა",
                    "ხლ",
                    "სამ",
                    "ნის_",
                    "ისი",
                    "ცე",
                    "ებს",
                    "რდ",
                    "ვის_",
                    "ს_რ",
                    "ელს",
                    "ხო",
                    "ნს",
                    "იის",
                    "ეობ",
                    "ებს_",
                    "ფე",
                    "იყ",
                    "ებით",
                    "აუ",
                    "ასა",
                    "ა_სა",
                    "ობა_",
                    "ი_რ",
                    "გო",
                    "ბული",
                    "ოე",
                    "აბ",
                    "სო",
                    "მოს",
                    "ომე",
                    "აც_",
                    "ადგ",
                    "_ის",
                    "ივ",
                    "19",
                    "ინა",
                    "ნა_",
                    "ექ",
                    "_19",
                    "ცხ",
                    "ი_სა",
                    "ახლ",
                    "ამი",
                    "ტუ",
                    "ს_ი",
                    "თის",
                    "თან",
                    "_სამ",
                    "სა_",
                    "_ლ",
                    "სხ",
                    "მხ",
                    "დან_",
                    "_ერთ",
                    "მის_",
                    "იდან",
                    "ის_შ",
                    "იის_",
                    "ა_გ",
                    "0_",
                    "რები",
                    "ჭ",
                ],
            ),
            (
                Language::German,
                vec![
                    "e", "n", "i", "r", "t", "s", "a", "d", "l", "u", "h", "er", "g", "en", "o",
                    "n_", "e_", "c", "ch", "en_", "_d", "b", "m", "ei", "de", "r_", "te", "t_",
                    "ie", "f", "in", "k", "er_", "ã_", "ã", "w", "ge", "_e", "un", "be", "p", "_s",
                    "z", "s_", "_a", "nd", "v", "_de", "ne", "_b", "le", "_g", "st", "ng", "he",
                    "re", "it", "di", "es", "der", "_v", "_w", "au", "ic", "is", "ein", "an", "sc",
                    "sch", "li", "_di", "die", "on", "_be", "se", "el", "_die", "ich", "nt", "ie_",
                    "der_", "_h", "_ei", "d_", "we", "ung", "h_", "_ein", "ch_", "che", "g_", "_m",
                    "_n", "si", "ti", "ã_¼_", "ã_¼", "¼_", "die_", "_¼_", "_¼", "_u", "ra", "or",
                    "_der", "_r", "ll", "n_d", "den", "ve", "ten", "da", "al", "nd_", "ine", "et",
                    "_f", "_au", "_p", "ver", "ng_", "ri", "rs", "_un", "me", "den_", "_z", "_da",
                    "t_d", "rt", "gen", "_i", "hr", "ung_", "at", "rd", "ht", "te_", "ur", "m_",
                    "ers", "vo", "ten_", "nde", "wi", "ig", "ter", "l_", "cht", "_k", "en_d",
                    "eine", "as", "_ver", "_ve", "_we", "le_", "_vo", "und", "on_", "og", "ar",
                    "ss", "_t", "gl", "eit", "ste", "em", "_l", "zu", "ber", "mi", "_ge", "ze",
                    "â_", "â", "gr", "pr", "es_", "uc", "ru", "ro", "ni", "und_", "ns", "ma",
                    "_si", "uch", "gen_", "ent", "e_d", "il", "hen", "ier", "_und", "ne_", "tz",
                    "eb", "kt", "go", "eg", "us", "ite", "it_", "nen", "n_s", "_er", "ut", "uf",
                    "end", "na", "la", "gle", "io", "sp", "oo", "ha", "ac", "_go", "nen_", "_â_",
                    "_â", "nte", "ere", "e_s", "tr", "ot", "ke", "ta", "nge", "lle", "ion", "lic",
                    "he_", "_wi", "st_", "mm", "_ã_", "_ã", "ach", "ist", "_o", "ed", "bei", "n_a",
                    "chen", "ub", "ert", "eh", "du", "_zu", "oog", "lich", "goog", "goo", "ol",
                    "nn", "_goo", "hen_", "hi", "e_a", "auf", "rde", "oogl", "ogl", "das", "_mi",
                    "_das", "ine_", "fã_", "fã", "ell", "rn", "ogle", "mit", "von_", "von", "n_de",
                    "i_", "r_d", "nk", "em_", "_von", "ts", "ren", "n_e", "_an", "lt", "en_s",
                    "ls", "ko", "icht", "ich_", "e_e", "che_", "gle_", "ag", "ab", "_se", "wer",
                    "_c", "to", "sche", "fã_¼", "ern", "_auf", "su", "iche", "ht_", "_al", "um",
                    "men", "fe", "eis", "_bei", "wei", "e_v", "and", "eu", "_pr", "am", "tu",
                    "rã_", "rã", "ec", "_re", "t_de", "isch", "isc", "ind", "ige", "ges", "e_b",
                    "chr", "bs", "rei", "n_w", "ir", "eite", "_en", "run", "_mit", "tt", "nu",
                    "mit_", "en_a", "ei_", "ben", "rt_", "om", "n_b", "tel", "as_", "t_w", "f_",
                    "cht_", "ber_", "_st", "el_", "e_g", "_den", "00", "schr", "pi", "lu", "her",
                    "aus", "_is", "tion", "tio", "r_e", "ist_", "in_", "ren_", "ge_", "des", "se_",
                    "n_g", "_in", "nf", "g_d", "n_v", "lin", "en_e", "ech", "sie", "rden", "pro",
                    "od", "nter", "n_di", "et_", "ese", "das_", "ug", "len", "fa", "erd", "bi",
                    "_wer",
                ],
            ),
            (
                Language::Greek,
                vec![
                    "α", "ο", "τ", "ε", "ν", "ι", "σ", "π", "μ", "ρ", "η", "ς", "ς_", "υ", "κ",
                    "_τ", "α_", "ί", "ν_", "_σ", "έ", "δ", "λ", "τη", "ου", "_π", "ι_", "_μ", "_ε",
                    "ό", "το", "να", "ο_", "ε_", "_α", "_τη", "με", "η_", "αν", "ά", "ω", "υ_",
                    "ρο", "ου_", "γ", "πρ", "χ", "_το", "_πρ", "ή", "μα", "ικ", "στ", "αι", "ία",
                    "τι", "_κ", "ης_", "ης", "ύ", "ας", "_ο", "τα", "συ", "ερ", "ει", "ας_", "ώ",
                    "τε", "πο", "κα", "αι_", "_συ", "_ν", "_δ", "να_", "του", "ον", "ντ", "ην",
                    "ία_", "υμ", "της_", "της", "την_", "την", "ς_τ", "ην_", "εί", "_του", "_στ",
                    "φ", "πα", "μπ", "με_", "θ", "επ", "_της", "_να_", "_να", "ρα", "ει_", "α_τ",
                    "ή_", "_επ", "υν", "του_", "προ", "_την", "_με", "_η", "ση", "σε", "νε", "κο",
                    "ατ", "_προ", "ς_σ", "ού", "ιν", "εδ", "γι", "ασ", "αμ", "_κα", "ων", "ς_μ",
                    "ρό", "ρι", "και", "ισ", "ια", "ετ", "δρ", "β", "_αν", "συμ", "ορ", "οι",
                    "ν_π", "ις_", "ις", "εν", "δο", "απ", "_συμ", "_με_", "τον", "τικ", "τη_",
                    "ς_π", "πρό", "ον_", "και_", "κή", "ημ", "ε_τ", "δι", "ανα", "α_ε", "_πρό",
                    "_ο_", "_και", "_γ", "ων_", "χε", "των_", "των", "τω", "συν", "ς_ε", "που",
                    "πι", "πά", "ος_", "ος", "ν_τ", "μο", "με_τ", "ική", "ευ", "εδρ", "δρο", "δε",
                    "ίν", "_μα", "_απ", "ύν", "τον_", "σχ", "σο", "πε", "οσ", "οκ", "ο_τ", "νο",
                    "ν_ε", "ν_α", "μας", "ια_", "εν_", "για_", "για", "αλ", "αί", "α_σ", "_των",
                    "_τω", "_συν", "_μπ", "_μας", "_για", "_γι", "_έ", "ών", "όεδρ", "όεδ", "όε",
                    "τις_", "τις", "στη", "ση_", "σί", "ρόεδ", "ρόε", "ρικ", "πρόε", "που_", "ξ",
                    "μετ", "μβ", "μας_", "μέ", "λο", "λε", "λα", "κή_", "ική_", "ι_σ", "η_τ",
                    "ες_", "ες", "ερι", "εδρο", "αρ", "έσ", "έν", "ά_", "_ό", "_τον", "_στη",
                    "_εί", "_αμ", "ύ_", "ωσ", "υρ", "το_", "τί", "στο", "σει", "σα", "ς_το",
                    "ς_τη", "ροσ", "ρος_", "ρος", "ρί", "προσ", "πα_", "ού_", "οι_", "οδ", "νέ",
                    "ν_πρ", "μπά", "μερι", "μερ", "λλ", "κό", "ι_τ", "ι_να", "ι_ν", "ηπα_", "ηπα",
                    "ηπ", "η_σ", "ερικ", "είν", "ασί", "αν_", "αμερ", "αμε", "α_τη", "α_α", "ίο",
                    "ίνα", "ίας_", "ίας", "ής_", "ής", "έρ", "_που", "_πο", "_ηπα", "_ηπ", "_ευ",
                    "_δι", "_ανα", "_αμε", "ών_", "ό_", "υς_", "υς", "υμμ", "υμβ", "τική", "τερ",
                    "τεν_", "τεν", "τα_", "συμμ", "συμβ", "στι", "σμ", "σία", "ς_κ", "ς_η", "ς_δ",
                    "ρω", "ρε", "πλ", "πάιν", "πάι", "ους_", "ους", "ουμ", "οντ", "ο_μ", "ο_κ",
                    "νω", "ντεν", "ντε", "ντα", "ναι_", "ναι", "ν_τη", "μπάι", "μμ", "ματ", "λί",
                    "κά", "ιντε", "ιντ", "ικα", "ι_ο", "ευρ", "επι", "ελ", "είνα", "ε_το", "ε_σ",
                    "δημ", "δη", "ακ", "α_το", "α_ν", "ίου", "ίναι", "έτ", "άιντ", "άιν", "άι",
                    "_σχ", "_σε", "_οι_", "_οι", "_μπά", "_ευρ", "_επι", "_είν", "_δε", "_2", "ότ",
                    "ός_", "ός", "ως_", "ως", "ψ", "χει_", "χει", "χα", "φή", "υτ", "υμμε", "υμε_",
                    "υμε", "υ_π", "τρ", "τη_σ", "τας_",
                ],
            ),
            (
                Language::Guarani,
                vec![
                    "a", "e", "o", "i", "a_", "h", "r", "p", "u", "e_", "t", "v", "m", "k", "n",
                    "_o", "ha", "y", "c", "_h", "o_", "g", "pe", "d", "re", "ch", "va", "é", "j",
                    "gu", "ha_", "i_", "_ha", "er", "te", "b", "ñ", "ap", "he", "ra", "mb", "â",
                    "pe_", "_a", "á", "va_", "_p", "a_o", "ko", "et", "nd", "_m", "_t", "s",
                    "_ha_", "a'", "ta", "_r", "cha", "ó", "ic", "ua", "ek", "an", "_i", "ve", "â_",
                    "ma", "de", "py", "ere", "ik", "ich", "ko_", "po", "ku", "je", "l", "a_h",
                    "av", "_pe", "oj", "ar", "ec", "_n", "râ", "up", "e_h", "ñe", "ña", "vo", "em",
                    "_ñ", "ba", "_k", "_he", "oi", "ér", "mba", "e_o", "ve_", "u_", "ech", "ue",
                    "icha", "gua", "rek", "ra_", "ete", "ka", "_j", "ja", "ai", "î", "vo_", "pi",
                    "og", "mo", "_oj", "_re", "_c", "râ_", "om", "eko", "_u", "_e", "y_", "yr",
                    "te_", "ogu", "ag", "_mb", "at", "agu", "a_ha", "oñ", "ei", "ê", "oje", "_oi",
                    "yv", "_ña", "pa", "ho", "a_a", "gue", "en", "eh", "cha_", "ah", "ñan", "ep",
                    "_mba", "e_ha", "_y", "_oñ", "_ch", "'e", "ué", "ui", "uer", "it", "_oje",
                    "_og", "_d", "reko", "ha_o", "e_m", "am", "a'e", "áv", "re_", "op", "oh",
                    "guer", "_ogu", "_de", "év", "ta_", "i_o", "ay", "a_e", "_te", "_ta", "_ma",
                    "ru", "rec", "oñe", "o_h", "da", "_nd", "rech", "erek", "der", "ái", "or",
                    "mi", "me", "ho_", "gui", "cho", "a_m", "éra", "uere", "nt", "ip", "hagu",
                    "hag", "uér", "pet", "ogue", "ng", "iko", "dere", "apy", "ua_", "pete", "erec",
                    "echo", "óv", "cho_", "_pet", "_oñe", "ym", "uéra", "o_o", "nde", "ma_",
                    "gua_", "ga", "eko_", "e_p", "ape", "and", "a_t", "_ap", "éra_", "mba'", "hu",
                    "erâ", "e_r", "ba'", "_ñan", "_der", "ú", "oik", "may", "e_a", "_may", "î_",
                    "éi", "tâ", "he_", "ev", "_v", "ép", "upe", "té", "pó", "nte", "maym", "iv",
                    "ia", "es", "emb", "che", "aym", "apo", "ñem", "ui_", "o_de", "o_d", "ni",
                    "ko_d", "gui_", "agua", "_om", "_oik", "_hag", "yma", "vy", "tap", "kué",
                    "de_", "ci", "bo", "a_r", "a_i", "va_o", "tu", "nde_", "mbo", "ehe", "ayma",
                    "ave", "_tap", "_che", "um", "ra_o", "kuér", "há", "e_n", "a_og", "ê_", "yp",
                    "yma_", "uk", "pa_", "ov", "on", "kua", "im", "iko_", "etâ", "_je", "por",
                    "kó", "kat", "het", "erâ_", "ara", "_ku", "_ja", "épe", "áva", "ava", "ak",
                    "_um", "_pe_", "_het", "ñand", "épe_", "pe_o", "omb", "nda", "ir", "echa",
                    "e_i", "a_y", "yvy", "sa", "ry", "nte_", "mi_", "end", "_av", "'é", "ón",
                    "áva_", "umi_", "umi", "pe_h", "na", "mba_", "ba_", "as", "are", "a_p", "a'é",
                    "_yv", "_umi", "_s", "upe_", "teî", "pyr", "oñem", "mbi", "jo", "jap", "eî",
                    "eg", "bi", "ape_", "a_k", "_va", "'a", "í", "se", "no", "eteî", "e'", "ang",
                    "aha", "a_ñ", "_up", "_ko", "óva", "ór", "áich", "áic", "o_p", "kóv", "hup",
                    "hech", "hec", "egu", "e_pe", "e_ma", "che_", "ad",
                ],
            ),
            (
                Language::Gujarati,
                vec![
                    "ા",
                    "ે",
                    "ર",
                    "ન",
                    "્",
                    "મ",
                    "ી",
                    "ત",
                    "ે_",
                    "વ",
                    "ક",
                    "ં",
                    "ો",
                    "ા_",
                    "સ",
                    "ય",
                    "િ",
                    "ી_",
                    "લ",
                    "પ",
                    "ુ",
                    "ં_",
                    "જ",
                    "મા",
                    "ગ",
                    "_પ",
                    "ાં",
                    "દ",
                    "ના",
                    "હ",
                    "_ક",
                    "_સ",
                    "ાં_",
                    "ો_",
                    "છ",
                    "્ય",
                    "આ",
                    "શ",
                    "_મ",
                    "_આ",
                    "ટ",
                    "ાર",
                    "માં",
                    "_છ",
                    "_ત",
                    "્ર",
                    "_જ",
                    "ના_",
                    "માં_",
                    "થ",
                    "છે",
                    "_છે",
                    "છે_",
                    "ને",
                    "_છે_",
                    "_વ",
                    "અ",
                    "_અ",
                    "વા",
                    "બ",
                    "ણ",
                    "ને_",
                    "રા",
                    "ાન",
                    "ર_",
                    "ડ",
                    "ું",
                    "ભ",
                    "ની",
                    "ામ",
                    "ચ",
                    "ું_",
                    "ર્",
                    "તા",
                    "ધ",
                    "ની_",
                    "_ર",
                    "_ન",
                    "તે",
                    "એ",
                    "_હ",
                    "યા",
                    "_દ",
                    "લા",
                    "ક_",
                    "કા",
                    "ત_",
                    "ત્",
                    "_ગ",
                    "ય_",
                    "ખ",
                    "_તે",
                    "_ભ",
                    "રી",
                    "અન",
                    "_અન",
                    "_બ",
                    "ેલ",
                    "મ_",
                    "સ્",
                    "વે",
                    "ન_",
                    "ષ",
                    "ભા",
                    "કર",
                    "_એ",
                    "પ્",
                    "અને",
                    "_અને",
                    "આવ",
                    "_આવ",
                    "ળ",
                    "અને_",
                    "ક્",
                    "કે",
                    "_કર",
                    "_મા",
                    "રે",
                    "_ભા",
                    "ં_આ",
                    "નુ",
                    "નો",
                    "ૂ",
                    "પ્ર",
                    "_શ",
                    "ઓ",
                    "હત",
                    "્વ",
                    "્યા",
                    "ાં_આ",
                    "ેન",
                    "ાય",
                    "ન્",
                    "સા",
                    "નો_",
                    "થી",
                    "_લ",
                    "_પ્",
                    "રત",
                    "ાત",
                    "ં_આવ",
                    "વિ",
                    "_પ્ર",
                    "ફ",
                    "ે_છ",
                    "થી_",
                    "નું_",
                    "નું",
                    "આવે",
                    "_આવે",
                    "ા_પ",
                    "ેમ",
                    "_રા",
                    "ે_છે",
                    "ે_ત",
                    "ણ_",
                    "ામા",
                    "િક",
                    "્ત",
                    "તા_",
                    "a",
                    "યુ",
                    "સ_",
                    "_હત",
                    "ાજ",
                    "e",
                    "પા",
                    "લ્",
                    "ઉ",
                    "ાગ",
                    "વેલ",
                    "શ્",
                    "ીન",
                    "ાવ",
                    "રો",
                    "પર",
                    "ગા",
                    "્લ",
                    "્ટ",
                    "ામાં",
                    "ાસ",
                    "ેશ",
                    "્ષ",
                    "કો",
                    "આવેલ",
                    "ે_આ",
                    "દે",
                    "કે_",
                    "યો",
                    "િલ",
                    "_ઉ",
                    "ે_જ",
                    "ે_ક",
                    "જ્",
                    "_કે",
                    "ઇ",
                    "_વિ",
                    "_થ",
                    "ાલ",
                    "જે",
                    "રી_",
                    "મન",
                    "આ_",
                    "ે_પ",
                    "ે_તે",
                    "રે_",
                    "ઈ",
                    "લા_",
                    "_આ_",
                    "ેલા",
                    "તી",
                    "તિ",
                    "r",
                    "વા_",
                    "લ_",
                    "_સા",
                    "વી",
                    "ટે",
                    "લુ",
                    "રાજ",
                    "દ્",
                    "લો",
                    "યન",
                    "i",
                    "_જે",
                    "જ્ય",
                    "હે",
                    "તેમ",
                    "_તેમ",
                    "ાટ",
                    "એક",
                    "_એક",
                    "ા_મ",
                    "ુ_",
                    "લી",
                    "_રાજ",
                    "રિ",
                    "ના_પ",
                    "ાના",
                    "શન",
                    "યા_",
                    "_ગા",
                    "ોન",
                    "ે_સ",
                    "ભાર",
                    "ત્ર",
                    "_દે",
                    "_ખ",
                    "ેલા_",
                    "_ચ",
                    "n",
                    "ુક",
                    "િલ્",
                    "સં",
                    "ારત",
                    "દેશ",
                    "તો",
                    "_પા",
                    "મે",
                    "જા",
                    "_ભાર",
                    "થા",
                    "_પર",
                    "િવ",
                    "વર",
                    "તી_",
                    "_સ્",
                    "_કા",
                    "ભાગ",
                    "િય",
                    "ભારત",
                    "ંગ",
                    "જિ",
                    "્ય_",
                    "ે_અ",
                    "રન",
                    "મુ",
                    "્ચ",
                    "રમ",
                    "કાર",
                    "ાના_",
                    "ામ_",
                    "એ_",
                    "s",
                    "સમ",
                    "તર",
                    "તે_",
                    "ગામ",
                    "ી_સ",
                    "ાર_",
                    "ેર",
                    "હા",
                    "વસ",
                    "લ્લ",
                    "જી",
                    "_ફ",
                    "િત",
                    "એક_",
                    "_એક_",
                    "ી_પ",
                    "o",
                    "તો_",
                    "_સં",
                    "_ભાગ",
                    "ા_વ",
                    "િમ",
                    "ેશન",
                    "ેવ",
                    "િન",
                    "જ_",
                    "્યુ",
                    "ીક",
                    "દિ",
                    "ક્ષ",
                    "_ના",
                    "_તા",
                    "ય_છ",
                    "્મ",
                    "ે_મ",
                    "હો",
                    "રત_",
                    "ય_છે",
                    "દર",
                    "ગ્",
                    "ંત",
                    "ે_વ",
                    "ા_સ",
                    "મહ",
                    "ગમ",
                    "ઓ_",
                    "t",
                    "_જિ",
                    "ુર",
                    "િલ્લ",
                    "રવ",
                    "દા",
                    "_દેશ",
                    "્યન",
                    "ાણ",
                    "પણ",
                    "_ગામ",
                    "ાય_",
                    "વી_",
                    "યો_",
                    "નિ",
                    "જિલ્",
                    "જિલ",
                    "_જિલ",
                    "ાથ",
                    "્સ",
                    "્થ",
                    "િ_",
                    "ાજ્ય",
                    "ાજ્",
                    "વેલા",
                    "વન",
                    "_મહ",
                    "લે",
                    "રાજ્",
                    "ગુ",
                    "ી_વ",
                    "માટ",
                    "ોક",
                    "ાટે",
                    "વામ",
                    "માટે",
                    "ડ_",
                    "ં_પ",
                    "_માટ",
                    "_કે_",
                    "ેટ",
                    "તેન",
                    "ી_જ",
                    "િક_",
                    "વ્",
                    "ગમા",
                    "ં_મ",
                    "ા_ત",
                    "ા_ક",
                    "ગમાં",
                    "_મુ",
                    "_તેન",
                    "_ગુ",
                    "્લા",
                    "યાર",
                    "ચિ",
                    "ઘ",
                    "ગ_",
                    "_વા",
                    "ી_મ",
                    "ારત_",
                    "ત_દ",
                    "ુજ",
                    "ા_ગ",
                    "રણ",
                    "ટ_",
                    "_સમ",
                    "ાત_",
                    "મો",
                    "ડા",
                ],
            ),
            (
                Language::Hebrew,
                vec![
                    "י", "ו", "ה", "ל", "מ", "ר", "ת", "ב", "א", "_ה", "ש", "ת_", "ח", "ם", "ם_",
                    "כ", "ע", "_מ", "נ", "ס", "_ב", "ד", "ים", "ים_", "ה_", "_ל", "פ", "ל_", "ג",
                    "ות", "ק", "_ש", "צ", "ר_", "ות_", "_א", "י_", "ן_", "ן", "ור", "_ו", "ו_",
                    "_י", "_ח", "לי", "ת_ה", "_כ", "א_", "_ע", "ח_", "ג_", "את", "יל", "ז", "את_",
                    "ני", "רו", "_פ", "מו", "פס", "יו", "רי", "סח", "פסח", "בי", "פסח_", "סח_",
                    "מצ", "חג", "המ", "_המ", "רא", "חג_", "לא", "ך", "די", "הי", "ך_", "ב_", "ת_מ",
                    "הו", "לה", "כו", "ט", "ור_", "מי", "ל_ה", "כל", "_נ", "של", "רים_", "רים",
                    "יש", "ול", "רב", "סו", "_את_", "_את", "על", "וא", "הג", "ץ_", "ץ", "ם_ל",
                    "בו", "אכ", "נו", "יי", "ית", "הח", "_הח", "נה", "חמ", "ום_", "ום", "אל",
                    "_של", "צי", "יר", "יא", "או", "שי", "שו", "_ק", "קר", "צו", "ם_ה", "ליל",
                    "לו", "וה", "_פס", "עו", "_פסח", "שר", "רות", "קו", "ד_", "ַ", "_מצ", "_הי",
                    "ער", "ם_ב", "ית_", "דר", "ימ", "וד", "אי", "ּ", "רות_", "על_", "מץ_", "מץ",
                    "חמץ_", "חמץ", "שב", "כי", "ים_ל", "_ז", "ת_ב", "פי", "יצ", "יום_", "יום",
                    "חי", "ונ", "ג_ה", "_על", "_יש", "_חמ", "ש_", "צר", "ן_ה", "יה", "ומ", "וי",
                    "מש", "ם_ו", "יס", "וע", "ון_", "ון", "וב", "_ס", "צרי", "מל", "יל_", "חג_ה",
                    "ה_ה", "בע", "_על_", "ם_מ", "הר", "הס", "דו", "גי", "_ת", "_לי", "_חמץ", "ציא",
                    "ני_", "לאכ", "ין_", "ין", "יב", "חר", "חו", "אח", "תי", "ת_ל", "של_", "קי",
                    "פר", "מת", "מנ", "ים_ו", "י_ה", "ות_ה", "הפ", "הל", "החג", "_כל", "_הס",
                    "_החג", "תו", "ר_מ", "צרים", "ף_", "ף", "עד", "מק", "מים_", "מים", "ם_ש",
                    "לה_", "החג_", "הא", "ה_ב", "ָ", "ְ", "_של_", "_שב", "_הפ", "_הו", "שמ", "מצרי",
                    "מצר", "מכ", "יציא", "יצי", "ים_ב", "וא_", "ה_ל", "דר_", "די_", "במ", "אחר",
                    "_ר", "_לה", "_הר", "רת", "סור", "סדר_", "סדר", "סד", "לכ", "לח", "ל_פ", "כל_",
                    "כה", "הפס", "בה", "ִ", "_מל", "ת_מצ", "ת_ח", "שנ", "שה", "רה", "סי", "מר",
                    "מלא", "ם_א", "ליל_", "ל_מ", "כה_", "_מת", "_ליל", "_חג", "_הפס", "_הא", "שרא",
                    "רה_", "רב_", "ר_ל", "ק_", "נה_", "מלאכ", "יק", "יע", "ימי", "וו", "הפסח",
                    "הסדר", "הסד", "הוא_", "הוא", "ה_ש", "בת", "בד", "את_מ", "את_ה", "אל_", "_מלא",
                    "_הסד", "_ג", "ת_ו", "שראל", "רת_", "ראל", "מן_", "מן", "לים_", "לים", "ישרא",
                    "ישר", "ול_", "וג", "ו_ב", "ה_א", "בנ", "ֹ", "_מו", "_לא", "_יצ", "_ד", "_במ",
                    "ראל_", "פו", "עב", "ספ", "סור_", "מצו", "מות", "לד", "יל_ה", "ות_מ", "הש",
                    "ה_מ", "בכ", "בא", "ֶ", "_נו", "_ישר", "_חג_", "_הוא", "_בי", "ת_י", "ת_א",
                    "רך_", "רך", "ר_ה", "ציאת", "פי_", "מח", "לת_", "לת", "לע", "ל_ב", "ירו",
                    "יאת_", "יאת", "זה_", "זה", "הם_", "הם", "דים_", "דים", "גים_", "גים", "_ער",
                    "_לח", "_בה", "ת_ש", "ת_כ", "ת_המ", "ר_ב", "קרא", "צות_", "צות", "צה", "עד_",
                    "נהג", "מע", "מס", "מה", "לפ", "ל_הס", "יש_", "ים_ש", "ילה_",
                ],
            ),
            (
                Language::Hindi,
                vec![
                    "ा",
                    "क",
                    "र",
                    "े",
                    "ि",
                    "_क",
                    "न",
                    "्",
                    "ह",
                    "त",
                    "स",
                    "ी",
                    "ं",
                    "ो",
                    "े_",
                    "प",
                    "ल",
                    "ी_",
                    "म",
                    "_स",
                    "द",
                    "_प",
                    "ा_",
                    "र_",
                    "_ह",
                    "ं_",
                    "ब",
                    "य",
                    "ार",
                    "के_",
                    "के",
                    "ै",
                    "ु",
                    "त_",
                    "व",
                    "ध",
                    "_ब",
                    "_के_",
                    "_के",
                    "ों",
                    "भ",
                    "ज",
                    "ग",
                    "ों_",
                    "है",
                    "का",
                    "_है",
                    "ने",
                    "्र",
                    "्त",
                    "ल_",
                    "न_",
                    "च",
                    "कि",
                    "_म",
                    "_द",
                    "ो_",
                    "ै_",
                    "है_",
                    "ने_",
                    "अ",
                    "_है_",
                    "_अ",
                    "रत",
                    "धि",
                    "ट",
                    "_न",
                    "ि_",
                    "ान",
                    "स्",
                    "क्",
                    "ंध",
                    "_भ",
                    "ता",
                    "की_",
                    "की",
                    "कर",
                    "इ",
                    "_व",
                    "_ज",
                    "ेक",
                    "श",
                    "मे",
                    "भा",
                    "को",
                    "_र",
                    "_को",
                    "ें",
                    "े_स",
                    "ारत",
                    "स्त",
                    "रो",
                    "भारत",
                    "भार",
                    "दि",
                    "को_",
                    "क_",
                    "ं_क",
                    "_भार",
                    "_भा",
                    "_त",
                    "_को_",
                    "_की_",
                    "_की",
                    "्ता",
                    "ों_क",
                    "िय",
                    "ाल",
                    "ारत_",
                    "हा",
                    "सं",
                    "वा",
                    "रत_",
                    "यो",
                    "प्र",
                    "प्",
                    "का_",
                    "ए",
                    "_सं",
                    "_प्र",
                    "_प्",
                    "_का_",
                    "_का",
                    "_कर",
                    "ें_",
                    "िस्",
                    "िस",
                    "िन",
                    "िक",
                    "स्ता",
                    "रह",
                    "या",
                    "में_",
                    "में",
                    "बा",
                    "पा",
                    "ना",
                    "कार",
                    "उ",
                    "_ल",
                    "_रह",
                    "_मे",
                    "_बा",
                    "_पा",
                    "_उ",
                    "्तान",
                    "्ट",
                    "े_क",
                    "ु_",
                    "िस्त",
                    "ार_",
                    "ाकिस",
                    "ाकि",
                    "ाक",
                    "से",
                    "सि",
                    "ले",
                    "पाकि",
                    "पाक",
                    "तान",
                    "ड",
                    "किस्",
                    "किस",
                    "_में",
                    "_पाक",
                    "्रो",
                    "िकार",
                    "िका",
                    "िंधु",
                    "िंध",
                    "िं",
                    "ान_",
                    "ा_ह",
                    "सिंध",
                    "सिं",
                    "ली_",
                    "ली",
                    "म_",
                    "ब_",
                    "पर",
                    "नद",
                    "धु_",
                    "धु",
                    "धिका",
                    "धिक",
                    "दिय",
                    "ठ",
                    "ट_",
                    "के_स",
                    "अधिक",
                    "अधि",
                    "अध",
                    "ंधु_",
                    "ंधु",
                    "ं_के",
                    "_सिं",
                    "_सि",
                    "_वा",
                    "_पर",
                    "_इ",
                    "_अधि",
                    "_अध",
                    "्ट_",
                    "ोग",
                    "ॉ",
                    "ैठक_",
                    "ैठक",
                    "ैठ",
                    "ेक्ट",
                    "ेक्",
                    "े_तह",
                    "े_त",
                    "ी_प",
                    "ि_के",
                    "ि_क",
                    "ा_है",
                    "ही",
                    "हत_",
                    "हत",
                    "संधि",
                    "संध",
                    "लेक",
                    "र्",
                    "री",
                    "र_प",
                    "या_",
                    "बैठक",
                    "बैठ",
                    "बै",
                    "पर_",
                    "ने_क",
                    "न_क",
                    "धि_क",
                    "धि_",
                    "दो",
                    "द_",
                    "थ",
                    "तान_",
                    "तहत_",
                    "तहत",
                    "तह",
                    "ठक_",
                    "ठक",
                    "ग_",
                    "क्ट",
                    "के_त",
                    "कि_",
                    "कर_",
                    "ई_",
                    "ई",
                    "आ",
                    "ंधि_",
                    "ंधि",
                    "ं_प",
                    "_संध",
                    "_बैठ",
                    "_बै",
                    "_पर_",
                    "_नद",
                    "_दि",
                    "_तहत",
                    "_तह",
                    "_च",
                    "ोन",
                    "ोग_क",
                    "ोग_",
                    "ो_प",
                    "ेश",
                    "ू",
                    "ी_स",
                    "ाल_",
                    "ात",
                    "हो",
                    "ह_",
                    "ल_क",
                    "र_क",
                    "योग_",
                    "योग",
                    "फ",
                    "त_क",
                    "जल_",
                    "जल",
                    "गा",
                    "ग_क",
                    "कार_",
                    "और_",
                    "और",
                    "औ",
                    "_हो",
                    "_से",
                    "_ने",
                    "_जल_",
                    "_जल",
                    "_और_",
                    "_और",
                    "_औ",
                    "_आ",
                    "्रोज",
                    "ोजेक",
                    "ोजे",
                    "ोज",
                    "ों_प",
                    "ॉवर_",
                    "ॉवर",
                    "ॉव",
                    "ेना",
                    "ेन",
                    "े_ब",
                    "े_ज",
                    "े_का",
                    "े_अ",
                    "ुक्त",
                    "ुक्",
                    "ुक",
                    "ीत_",
                    "ीत",
                    "ी_ह",
                    "िल",
                    "ियों",
                    "ियो",
                    "ारी_",
                    "ारी",
                    "ाब_",
                    "ाब",
                    "ान_क",
                    "ातची",
                    "ातच",
                    "ाइ",
                    "ा_रह",
                    "ा_र",
                    "हु",
                    "से_",
                    "सा",
                    "वाल",
                    "वार",
                    "वर_",
                    "वर",
                    "रोजे",
                    "रोज",
                    "री_",
                    "र_प्",
                    "यों_",
                    "यों",
                    "युक्",
                    "युक",
                    "यु",
                    "भी_",
                    "भी",
                    "बातच",
                    "बात",
                    "फ_",
                    "प्रो",
                    "पॉवर",
                    "पॉव",
                    "पॉ",
                    "पू",
                    "पयोग",
                    "पयो",
                    "पय",
                    "नाब_",
                    "नाब",
                    "ना_",
                    "नदिय",
                    "नदि",
                    "न_को",
                    "दे",
                    "दियो",
                    "तर",
                    "तचीत",
                    "तची",
                    "तच",
                    "जेक्",
                    "जेक",
                    "जे",
                    "चीत_",
                    "चीत",
                    "ची",
                    "गा_",
                    "क्त",
                    "क्ट_",
                    "उपयो",
                    "उपय",
                    "उप",
                    "इस",
                    "आय",
                    "ं_पर",
                    "_हा",
                    "_सा",
                    "_लेक",
                    "_ले",
                    "_य",
                    "_बात",
                    "_पॉव",
                    "_पॉ",
                    "_नदि",
                    "_दो",
                    "_दे",
                    "_कि",
                    "_उपय",
                    "_उप",
                ],
            ),
            (
                Language::Hungarian,
                vec![
                    "e", "a", "t", "l", "s", "n", "k", "i", "z", "r", "o", "á", "m", "é", "g",
                    "_a", "a_", "y", "t_", "b", "d", "v", "k_", "sz", "el", "_a_", "h", "n_", "_m",
                    "s_", "_k", "et", "gy", "en", "_e", "i_", "p", "u", "j", "ö", "te", "_s", "ó",
                    "f", "eg", "le", "l_", "al", "_h", "és", "er", "_t", "z_", "e_", "ek", "me",
                    "at", "az", "ta", "an", "ze", "c", "tt", "y_", "_v", "ak", "_é", "em", "_n",
                    "ne", "_az", "_sz", "_f", "es", "ke", "ny", "ol", "re", "í", "be", "ü", "en_",
                    "_i", "is", "az_", "ás", "gy_", "_az_", "nt", "ál", "ár", "ő", "ez", "on",
                    "or", "la", "án", "lt", "t_a", "na", "m_", "ve", "tá", "ly", "mi", "_b", "in",
                    "ek_", "to", "_l", "_me", "ko", "ra", "ar", "k_a", "és_", "té", "ho", "ha",
                    "g_", "an_", "og", "ba", "ok", "tt_", "se", "ég", "ye", "sze", "én", "va",
                    "ma", "ik", "ka", "ag", "zt", "egy", "rt", "ak_", "de", "r_", "ot", "_el",
                    "ki", "ér", "os", "kö", "ll", "_és", "cs", "át", "sé", "_p", "lá", "_és_",
                    "ro", "_r", "nd", "am", "oz", "él", "sa", "_eg", "má", "sá", "_ho", "meg", "ú",
                    "_egy", "ti", "em_", "ni", "_meg", "he", "ül", "za", "vá", "et_", "so", "fe",
                    "_kö", "ké", "_mi", "st", "zá", "_ne", "t_a_", "n_a", "ó_", "ág", "ele", "õ",
                    "ya", "ad", "ban", "ss", "_c", "it", "ban_", "ít", "_d", "ben", "a_k", "_j",
                    "is_", "agy", "a_m", "ogy", "bb", "om", "mé", "_ha", "zé", "ott", "li", "nk",
                    "ett", "ség", "hog", "hogy", "_le", "k_a_", "ét", "zo", "_is", "ga", "ere",
                    "ap", "ge", "ék", "rá", "as", "_ma", "nem", "ben_", "_te", "ri", "ogy_", "_ki",
                    "lé", "lt_", "a_a", "ok_", "_hog", "öz", "_fe", "_g", "mo", "ely", "fo", "a_s",
                    "_á", "nak", "nak_", "e_a", "do", "al_", "_a_k", "nek", "_nem", "po", "ai",
                    "tet", "zet", "il", "szt", "_be", "_va", "já", "_sze", "je", "len", "ép",
                    "el_", "_ke", "ed", "ut", "go", "_is_", "nt_", "min", "ete", "s_a", "nem_",
                    "ni_", "lm", "ik_", "di", "let", "int", "zer", "l_a", "vé", "nek_", "ja", "ör",
                    "lk", "köz", "tó", "t_m", "szer", "ul", "tal", "ra_", "_cs", "vi", "es_",
                    "án_", "tu", "lo", "a_t", "_min", "nn", "a_h", "át_", "zi", "t_k", "da", "ság",
                    "fel", "ól", "pe", "_a_m", "áb", "né", "ala", "_a_s", "_ta", "ész", "ló",
                    "k_m", "at_", "_o", "ott_", "n_a_", "z_e", "gya", "a_f", "ő_", "i_a", "k_e",
                    "ig", "egy_", "aj", "ény", "dé", "us", "_ké", "vo", "ta_", "gye", "yi", "sza",
                    "rs", "gi", "szá", "ön", "tö", "a_sz", "áll", "val", "_köz", "z_a", "ká", "ák",
                    "_fel", "tot", "az_e", "_ez", "_al", "ia", "esz", "rd", "tás", "rm", "há",
                    "ent", "_u", "mag", "re_", "ai_", "te_", "d_", "b_", "ter", "eze", "_am",
                    "a_a_", "tel", "nye", "mel", "_na", "_fo", "_ko", "_a_t", "si", "_vá", "un",
                    "gá", "_mag",
                ],
            ),
            (
                Language::Icelandic,
                vec![
                    "a", "r", "n", "i", "e", "s", "t", "l", "u", "ð", "g", "m", "k", "r_", "f",
                    "a_", "v", "_s", "ð_", "o", "ar", "h", "á", "in", "i_", "_e", "d", "að", "í",
                    "_a", "n_", "er", "m_", "_h", "þ", "_v", "_þ", "að_", "j", "nn", "st", "g_",
                    "_f", "an", "b", "ei", "um", "ó", "t_", "ur", "_m", "ið", "y", "na", "_að",
                    "ir", "um_", "u_", "_o", "ti", "ar_", "_að_", "p", "ri", "æ", "ta", "_á", "í_",
                    "ve", "á_", "ö", "nd", "ur_", "_í", "ra", "og", "og_", "_og_", "_og", "la",
                    "en", "_t", "ir_", "ið_", "_í_", "ni", "il", "ng", "_l", "ga", "_b", "le",
                    "un", "ú", "s_", "se", "_er", "ki", "_g", "eg", "tt", "sk", "é", "er_", "vi",
                    "_k", "al", "inn", "nu", "l_", "_se", "em", "nn_", "ða", "am", "_á_", "ði",
                    "sa", "af", "ma", "_ve", "kk", "_n", "rð", "ka", "_er_", "_u", "ver", "tu",
                    "me", "re", "na_", "_vi", "þe", "ðu", "li", "ja", "_þe", "ing", "gu", "ef",
                    "ns", "va", "da", "r_s", "di", "sem", "ll", "þa", "_þa", "ha", "he", "ru",
                    "mi", "em_", "_sem", "sem_", "lu", "_st", "gi", "fr", "ra_", "til", "ek",
                    "_ha", "jó", "is", "yr", "ag", "_r", "eð", "st_", "_ti", "fa", "_me", "ann",
                    "_til", "_he", "ta_", "ge", "es", "ld", "ss", "or", "ein", "ndi", "rn", "si",
                    "and", "rs", "a_s", "nar", "it", "f_", "ku", "il_", "_fr", "við", "ki_", "_d",
                    "et", "r_e", "leg", "inn_", "_sa", "r_a", "fy", "_ei", "_en", "au", "_um",
                    "til_", "_ver", "_sk", "as", "_við", "fi", "sta", "nna", "ekk", "ig", "_fy",
                    "sam", "ý", "ð_s", "r_h", "ga_", "ni_", "fyr", "ey", "num", "kki", "gar",
                    "nni", "var", "ik", "ví", "sl", "ði_", "num_", "_fyr", "_va", "ri_", "on",
                    "það", "_það", "það_", "með", "rá", "ða_", "rir", "ko", "kki_", "_ge", "_ekk",
                    "_ek", "hv", "fu", "ál", "fn", "erð", "ekki", "_um_", "ður", "r_v", "_með",
                    "ð_e", "ns_", "du", "te", "el", "sv", "rf", "yri", "_sam", "a_e", "við_",
                    "ega", "nin", "en_", "ke", "gr", "d_", "ð_v", "i_s", "r_þ", "rt", "nga",
                    "_ein", "yrir", "n_s", "ins", "in_", "fyri", "ak", "vo", "_al", "_en_", "nar_",
                    "k_", "enn", "a_a", "tt_", "ru_", "r_f", "ór", "_2", "ne", "at", "ngu", "ár",
                    "rk", "með_", "eð_", "ð_h", "ær", "rir_", "_1", "lan", "c", "all", "_mi",
                    "_af", "öl", "tr", "kr", "gar_", "ður_", "di_", "r_m", "ð_f", "ík", "ti_",
                    "m_s", "ug", "pp", "já", "im", "be", "ð_þ", "yn", "r_að", "an_", "la_", "_hv",
                    "þei", "má", "lei", "br", "ba", "_þei", "ja_", "fe", "eir", "_ef", "rg", "_le",
                    "ok", "nda", "ast", "_var", "ör", "ér", "a_v", "_sv", "kj", "g_s", "ft", "su",
                    "inga", "jö", "sin", "ndi_", "ð_a", "han", "a_h", "æð", "nu_", "m_e", "ins_",
                    "a_þ", "ól", "un_", "tur", "ka_", "ann_", "a_f", "n_e", "gn", "ess", "_han",
                    "rr", "rin", "nni_", "mu", "inu", "fl", "æt", "stu", "r_á",
                ],
            ),
            (
                Language::Indonesian,
                vec![
                    "a", "n", "e", "i", "an", "t", "u", "r", "k", "m", "s", "g", "d", "n_", "a_",
                    "p", "l", "ng", "an_", "b", "h", "i_", "er", "_d", "ka", "_m", "en", "y", "da",
                    "_s", "ya", "o", "_p", "ang", "_k", "la", "g_", "me", "ng_", "ta", "ra", "ar",
                    "_t", "at", "_b", "_me", "ga", "ak", "in", "ah", "se", "di", "h_", "ang_",
                    "_a", "pa", "ma", "un", "al", "j", "pe", "sa", "kan", "_se", "te", "u_", "be",
                    "ba", "tu", "k_", "as", "em", "t_", "ny", "kan_", "ke", "am", "ti", "_i",
                    "_pe", "_da", "na", "si", "nya", "men", "ri", "_di", "ya_", "ah_", "it",
                    "_men", "_ke", "ha", "eng", "ap", "_te", "el", "ia", "nga", "ad", "_be", "_y",
                    "yan", "_ya", "yang", "nya_", "_yan", "ber", "c", "ja", "nt", "at_", "li",
                    "r_", "w", "gan", "ik", "de", "s_", "uk", "ai", "aka", "dan", "ngan", "ki",
                    "ala", "_ber", "is", "ara", "_l", "_ba", "nd", "_ma", "ua", "mu", "gan_", "ni",
                    "ak_", "ter", "ing", "enga", "ada", "pu", "per", "ran", "wa", "ru", "_sa",
                    "ata", "ag", "n_d", "eb", "l_", "_ka", "ek", "il", "su", "us", "dan_", "bu",
                    "di_", "_dan", "n_k", "_de", "a_m", "ela", "a_s", "re", "n_s", "mp", "mb",
                    "tu_", "a_d", "m_", "n_m", "_pa", "n_p", "da_", "lah", "era", "tan", "_ter",
                    "apa", "ri_", "ku", "_h", "es", "or", "ur", "asi", "et", "_j", "an_d", "_per",
                    "gi", "pen", "an_p", "a_k", "ung", "an_k", "gg", "ngg", "_u", "lah_", "mi",
                    "itu", "a_p", "an_m", "ut", "an_s", "si_", "ir", "_in", "den", "id", "akan",
                    "le", "ka_", "a_t", "i_s", "_ti", "ra_", "_o", "un_", "f", "ari", "_pen",
                    "n_b", "ta_", "rt", "deng", "_r", "i_d", "lu", "n_t", "gu", "ju", "ian", "du",
                    "on", "_it", "ih", "ca", "_itu", "itu_", "ge", "_den", "pi", "ana", "pat",
                    "ntu", "meng", "ul", "mem", "_mem", "rang", "ep", "ai_", "bi", "ar_", "ed",
                    "ay", "_ha", "a_me", "st", "ngk", "gk", "an_b", "um", "uk_", "_di_", "ena",
                    "p_", "ada_", "man", "ian_", "i_k", "_n", "nda", "ika", "e_", "ama", "a_b",
                    "n_me", "i_p", "_la", "ud", "lan", "emb", "ari_", "lam", "im", "_ta", "am_",
                    "_ak", "ia_", "ara_", "al_", "_g", "n_ke", "dar", "_su", "au", "ali", "ni_",
                    "ert", "ga_", "asa", "a_a", "aha", "dal", "aga", "_c", "ne", "a_i", "n_pe",
                    "eka", "g_m", "eri", "as_", "seb", "nj", "ng_m", "n_se", "n_a", "dala", "dak",
                    "_un", "aa", "a_se", "pun", "ora", "ita", "han", "nta", "ini", "i_m", "aj",
                    "_ki", "mer", "k_m", "unt", "san", "ida", "ema", "ban", "aw", "an_t", "oran",
                    "n_i", "uh", "_an", "pad", "aya", "ng_d", "g_d", "pat_", "dap", "ent", "tuk",
                    "eh", "tid", "mas", "dak_", "in_", "_ad", "alam", "_unt", "ntuk", "_mer",
                    "uka", "rs", "ol", "i_t", "and", "_tid", "ung_", "g_s", "untu", "ti_", "ngka",
                    "ng_s", "na_", "ini_", "gka", "an_a", "ngga", "gga", "awa", "a_y", "tuk_",
                    "tida", "ih_", "idak", "asi_", "adi", "ma_", "any", "_pu", "pr",
                ],
            ),
            (
                Language::Irish,
                vec![
                    "a", "i", "h", "n", "_a", "r", "s", "t", "e", "c", "l", "g", "a_", "o", "n_",
                    "d", "m", "b", "an", "u", "h_", "í", "é", "_s", "ai", "ch", "ea", "á", "r_",
                    "_b", "s_", "ar", "f", "_t", "_c", "in", "an_", "_m", "í_", "_d", "bh", "ac",
                    "ag", "_a_", "th", "_an", "ir", "ha", "ach", "_l", "é_", "_bh", "_an_", "_ag",
                    "l_", "e_", "g_", "_f", "le", "p", "is", "il", "na", "id", "ar_", "_i", "ó",
                    "mh", "_n", "_g", "t_", "r_a", "nn", "_ch", "ch_", "á_", "o_", "it", "ir_",
                    "dh", "ach_", "sé", "_sé", "_ar", "ú", "ái", "sé_", "h_a", "ei", "am", "_sé_",
                    "_le", "ra", "he", "al", "ui", "ta", "ean", "éa", "us", "ig", "gu", "d_", "_p",
                    "te", "se", "n_a", "as", "a_a", "oi", "nn_", "hu", "hai", "de", "ag_", "éi",
                    "us_", "st", "sa", "ith", "in_", "gus_", "gus", "ga", "agus", "agu", "a_d",
                    "a_b", "_ar_", "_agu", "ua", "is_", "tha", "s_a", "rt", "i_", "há", "go",
                    "dh_", "_ac", "ío", "tá_", "tá", "ní", "na_", "ma", "il_", "ia", "hí", "go_",
                    "gh", "bhí", "at", "ann", "ad", "a_bh", "_ní", "_go", "_bhí", "í_a", "re",
                    "n_t", "le_", "la", "igh", "hí_", "fa", "ear", "each", "eac", "bhí_", "amh",
                    "ait", "_é", "_go_", "_ag_", "ti", "rí", "m_", "hea", "fh", "eo", "c_", "ann_",
                    "_a_d", "_a_b", "th_", "ng", "mh_", "inn", "hái", "ho", "hi", "h_s", "as_",
                    "air", "_ó", "_tá_", "_tá", "_se", "_fh", "_de", "án", "sc", "rai", "r_an",
                    "or", "n_n", "ith_", "ir_a", "ha_", "h_t", "cha", "ar_a", "aith", "aig", "aid",
                    "_r", "_ach", "é_a", "ta_", "t_a", "sa_", "om", "l_a", "igh_", "hé", "hf",
                    "gh_", "d_a", "ca", "be", "art", "al_", "air_", "ain", "aigh", "acha", "a_c",
                    "_ta", "_ma", "_in", "_dh", "án_", "uil", "tea", "sea", "rea", "r_s", "nt",
                    "ne", "n_s", "n_f", "lá", "li", "io", "im", "ile", "idh_", "idh", "id_", "ht",
                    "har", "ean_", "eag", "cu", "chu", "bhf", "bea", "amh_", "aga", "_o", "_mh",
                    "_is", "_chu", "_bhf", "úi", "ós", "í_s", "éan", "sí", "si", "s_d", "ri",
                    "ra_", "r_a_", "on", "oc", "nn_a", "n_b", "mé_", "mé", "mu", "mha", "ll",
                    "ist", "ile_", "ic", "hr", "hean", "h_m", "di", "bhe", "an_t", "ail", "a_f",
                    "a_de", "_ti", "_th", "_sí", "_na", "_mé_", "_mé", "_fa", "_bea", "_be", "ú_",
                    "é_c", "áid", "y", "te_", "sí_", "ste", "seo", "sean", "s_an", "rt_", "pa",
                    "ol", "ní_", "n_ní", "lt", "lei", "iste", "ing", "hó", "hui", "hua", "ha_a",
                    "fai", "en", "eir_", "eir", "eann", "deir", "dei", "dea", "cht", "ba", "as_a",
                    "ana", "adh_", "adh", "a_s", "a_m", "a_g", "a_ch", "_éi", "_sí_", "_si", "_sc",
                    "_sa", "_ní_", "_mu", "_lei", "_dei", "_bhe", "_am", "_ai", "óst", "éal",
                    "é_s", "áil", "uí_a", "uí_", "uí", "uil_", "uid_", "uid", "uai", "tú", "tr",
                    "thai", "teac", "sé_a", "sh", "rra", "rr", "r_m", "ph", "os", "ois", "och",
                    "ob", "ns", "nach", "nac", "n_r", "n_l", "n_an",
                ],
            ),
            (
                Language::Italian,
                vec![
                    "a", "e", "i", "o", "l", "n", "r", "a_", "s", "c", "e_", "t", "d", "o_", "i_",
                    "u", "v", "p", "m", "_c", "_s", "_d", "_a", "la", "_p", "g", "er", "ar", "an",
                    "h", "_l", "co", "ri", "_m", "re", "ll", "la_", "l_", "_i", "no", "ra", "di",
                    "ch", "el", "to", "va", "se", "n_", "b", "ia", "_v", "_di", "f", "_n", "in",
                    "av", "al", "_e", "_co", "do", "on", "to_", "re_", "or", "na", "ta", "li",
                    "en", "ca", "pe", "si", "da", "ve", "va_", "ma", "sa", "ol", "lla", "le", "de",
                    "as", "cc", "lla_", "io", "_f", "il", "a_c", "_e_", "tt", "o_d", "no_", "ne",
                    "nd", "ia_", "_pe", "st", "nt", "il_", "gli", "gl", "_il_", "_il", "_ch",
                    "ra_", "na_", "ell", "_u", "_se", "_de", "ti", "se_", "qu", "q", "om", "me",
                    "le_", "io_", "he_", "he", "che_", "che", "at", "_qu", "_q", "_ca", "_b", "vi",
                    "un", "lo", "e_s", "e_d", "di_", "ci", "a_m", "_ma", "_di_", "_che", "te",
                    "si_", "pa", "a_d", "_un", "_la", "z", "vo", "i_s", "del", "ava", "a_i", "_g",
                    "_del", "ss", "r_", "per", "a_s", "_t", "_si", "_per", "is", "ev", "et", "es",
                    "e_c", "and", "_r", "_no", "po", "l'", "hi", "era", "e_l", "e_a", "a_a",
                    "_la_", "ua", "sc", "os", "o_c", "ne_", "li_", "ie", "el_", "chi", "_vi",
                    "_in", "_al", "tto", "tr", "su", "sa_", "ro", "o_s", "o_a", "mo", "lo_", "it",
                    "ic", "eva", "e_p", "com", "ava_", "are", "all", "a_n", "_su", "_com", "_a_",
                    "'a", "ta_", "per_", "on_", "ndo", "in_", "gli_", "fa", "era_", "er_", "are_",
                    "ano_", "ano", "ad", "ac", "a_l", "_in_", "ur", "un_", "tu", "tto_", "te_",
                    "so", "qua", "oc", "non", "mp", "mi", "la_m", "i_c", "ella", "do_", "ari",
                    "a_p", "_un_", "_si_", "_qua", "_non", "_do", "é_", "é", "ut", "uo", "ue",
                    "ti_", "sse", "pr", "non_", "ni", "me_", "id", "i_d", "i_a", "eva_", "da_",
                    "col", "ce", "be", "a_e", "_ve", "_tu", "_l'", "_gli", "_gl", "ul", "pi",
                    "ome", "o_i", "o_e", "o_di", "l_p", "l'a", "ig", "gn", "fi", "e_e", "dd",
                    "cch", "cas", "ave", "acc", "a_v", "a_ma", "a_f", "a_e_", "a_co", "_sa", "_ri",
                    "_ne", "_fa", "_da", "_col", "_cas", "zi", "rr", "que", "ome_", "og", "o_p",
                    "ndo_", "n_c", "man", "ent", "dell", "cchi", "casa", "ato", "asa_", "asa",
                    "am", "ale", "a_di", "_vo", "_st", "_que", "_pa", "_o", "_mo", "_av", "_all",
                    "ó_", "ó", "van", "uri", "u_", "sta", "sse_", "rid", "par", "ot", "oi", "o_de",
                    "nda", "iv", "far", "ess", "e_n", "e_i", "del_", "come", "bi", "ato_", "ando",
                    "anda", "ale_", "a_il", "_me", "_le", "_l'a", "_be", "_an", "vano", "una_",
                    "una", "uel", "ser", "ridd", "ora", "oi_", "occ", "o_l", "o_e_", "nz", "n_ca",
                    "la_c", "ir", "ina", "idd", "i_l", "i_i", "hi_", "ene", "e_pe", "e_di", "e_ch",
                    "con", "cco", "ba", "ap", "ant", "a_no", "a_de", "a_ch", "a_b", "_se_", "_pr",
                    "_pi", "_lo", "_le_", "_i_", "_era", "_er", "_ave",
                ],
            ),
            (
                Language::Japanese,
                vec![
                    "の_",
                    "の",
                    "_の_",
                    "_の",
                    "た_",
                    "た",
                    "_た_",
                    "_た",
                    "を_",
                    "を",
                    "_を_",
                    "_を",
                    "に_",
                    "に",
                    "_に_",
                    "_に",
                    "と_",
                    "と",
                    "し_",
                    "し",
                    "_と_",
                    "_と",
                    "_し_",
                    "_し",
                    "は_",
                    "は",
                    "が_",
                    "が",
                    "_は_",
                    "_は",
                    "_が_",
                    "_が",
                    "る_",
                    "る",
                    "_る_",
                    "_る",
                    "者_",
                    "者",
                    "_者_",
                    "_者",
                    "い_",
                    "い",
                    "_い_",
                    "_い",
                    "て_",
                    "て",
                    "_て_",
                    "_て",
                    "な_",
                    "な",
                    "で_",
                    "で",
                    "う_",
                    "う",
                    "_な_",
                    "_な",
                    "_で_",
                    "_で",
                    "_う_",
                    "_う",
                    "疑_者_",
                    "疑_者",
                    "疑_",
                    "疑",
                    "容_疑_",
                    "容_疑",
                    "容_",
                    "容",
                    "し_た_",
                    "し_た",
                    "か_",
                    "か",
                    "_疑_者",
                    "_疑_",
                    "_疑",
                    "_容_疑",
                    "_容_",
                    "_容",
                    "_し_た",
                    "_か_",
                    "_か",
                    "ら_",
                    "ら",
                    "っ_",
                    "っ",
                    "_ら_",
                    "_ら",
                    "_っ_",
                    "_っ",
                    "_2",
                    "っ_た_",
                    "っ_た",
                    "た_と_",
                    "た_と",
                    "す_",
                    "す",
                    "さ_",
                    "さ",
                    "_っ_た",
                    "_た_と",
                    "_す_",
                    "_す",
                    "_さ_",
                    "_さ",
                    "月_",
                    "月",
                    "同_",
                    "同",
                    "ン",
                    "れ_",
                    "れ",
                    "す_る_",
                    "す_る",
                    "_月_",
                    "_月",
                    "_同_",
                    "_同",
                    "_れ_",
                    "_れ",
                    "_す_る",
                    "_1",
                    "験_",
                    "験",
                    "碇_",
                    "碇",
                    "日_",
                    "日",
                    "ー",
                    "り_",
                    "り",
                    "よ_",
                    "よ",
                    "ど_",
                    "ど",
                    "て_い_",
                    "て_い",
                    "し_て_",
                    "し_て",
                    "あ_",
                    "あ",
                    "_験_",
                    "_験",
                    "_碇_",
                    "_碇",
                    "_日_",
                    "_日",
                    "_り_",
                    "_り",
                    "_よ_",
                    "_よ",
                    "_ど_",
                    "_ど",
                    "_て_い",
                    "_し_て",
                    "_あ_",
                    "_あ",
                    "3_",
                    "食_",
                    "食",
                    "表_",
                    "表",
                    "発_",
                    "発",
                    "治_験_",
                    "治_験",
                    "治_",
                    "治",
                    "果_",
                    "果",
                    "性_",
                    "性",
                    "事_",
                    "事",
                    "ろ_",
                    "ろ",
                    "も_",
                    "も",
                    "な_ど_",
                    "な_ど",
                    "だ_",
                    "だ",
                    "i",
                    "_食_",
                    "_食",
                    "_表_",
                    "_表",
                    "_発_",
                    "_発",
                    "_治_験",
                    "_治_",
                    "_治",
                    "_果_",
                    "_果",
                    "_性_",
                    "_性",
                    "_事_",
                    "_事",
                    "_ろ_",
                    "_ろ",
                    "_も_",
                    "_も",
                    "_な_ど",
                    "_だ_",
                    "_だ",
                    "2_",
                    "食_事_",
                    "食_事",
                    "赤_堀_",
                    "赤_堀",
                    "赤_",
                    "赤",
                    "者_の_",
                    "者_の",
                    "碇_容_",
                    "碇_容",
                    "時_",
                    "時",
                    "年_",
                    "年",
                    "堀_",
                    "堀",
                    "効_",
                    "効",
                    "ータ_",
                    "ータ",
                    "ン_",
                    "ワ",
                    "データ_",
                    "データ",
                    "デー",
                    "デ",
                    "タ_",
                    "タ",
                    "ク",
                    "る_と_",
                    "る_と",
                    "よ_う_",
                    "よ_う",
                    "は_2",
                    "せ_",
                    "せ",
                    "さ_せ_",
                    "さ_せ",
                    "が_あ_",
                    "が_あ",
                    "え_",
                    "え",
                    "_食_事",
                    "_赤_堀",
                    "_赤_",
                    "_赤",
                    "_者_の",
                    "_碇_容",
                    "_時_",
                    "_時",
                    "_年_",
                    "_年",
                    "_堀_",
                    "_堀",
                    "_効_",
                    "_効",
                    "_ワ",
                    "_データ",
                    "_デー",
                    "_デ",
                    "_る_と",
                    "_よ_う",
                    "_は_2",
                    "_せ_",
                    "_せ",
                    "_さ_せ",
                    "_が_あ",
                    "_え_",
                    "_え",
                    "_3",
                    "_2_",
                    "重_",
                    "重",
                    "責_任_",
                    "責_任",
                    "責_",
                    "責",
                    "護_",
                    "護",
                    "解_",
                    "解",
                    "者_が_",
                    "者_が",
                    "米_",
                    "米",
                    "社_",
                    "社",
                    "発_表_",
                    "発_表",
                    "症_",
                    "症",
                    "生_",
                    "生",
                    "死_",
                    "死",
                    "検_",
                    "検",
                    "昨_年_",
                    "昨_年",
                    "昨_",
                    "昨",
                    "堀_容_",
                    "堀_容",
                    "国_",
                    "国",
                    "含_",
                    "含",
                    "同_社_",
                    "同_社",
                    "可_",
                    "可",
                    "分_",
                    "分",
                    "共_",
                    "共",
                    "全_",
                    "全",
                    "保_護_",
                    "保_護",
                    "保_",
                    "保",
                    "使_",
                    "使",
                    "任_",
                    "任",
                    "一_",
                    "一",
                    "ワクチン",
                    "ワクチ",
                    "ワク",
                    "ル",
                    "ト",
                    "チン_",
                    "チン",
                    "チ",
                    "クチン_",
                    "クチン",
                    "クチ",
                    "ら_れ_",
                    "ら_れ",
                    "や_",
                    "や",
                    "と_し_",
                    "と_し",
                    "ず_",
                    "ず",
                    "こ_",
                    "こ",
                    "d",
                    "a",
                    "_重_",
                    "_重",
                    "_責_任",
                    "_責_",
                    "_責",
                    "_護_",
                    "_護",
                    "_解_",
                    "_解",
                    "_者_が",
                    "_米_",
                    "_米",
                    "_社_",
                    "_社",
                    "_発_表",
                    "_症_",
                    "_症",
                    "_生_",
                    "_生",
                    "_死_",
                    "_死",
                    "_検_",
                    "_検",
                    "_昨_年",
                    "_昨_",
                    "_昨",
                    "_堀_容",
                    "_国_",
                    "_国",
                    "_含_",
                    "_含",
                    "_同_社",
                    "_可_",
                    "_可",
                    "_分_",
                    "_分",
                    "_共_",
                    "_共",
                    "_全_",
                    "_全",
                    "_保_護",
                    "_保_",
                    "_保",
                    "_使_",
                    "_使",
                ],
            ),
            (
                Language::Kazakh,
                vec![
                    "а", "ы", "е", "н", "т", "р", "л", "і", "д", "с", "қ", "о", "к", "м", "ы_",
                    "н_", "б", "и", "ар", "ж", "у", "ан", "_б", "ғ", "_ж", "да", "ң", "з", "ал",
                    "а_", "_а", "ын", "й", "та", "г", "_қ", "п", "ш", "і_", "ер", "ен", "е_", "_т",
                    "ң_", "ды", "_к", "ла", "қа", "нд", "де", "лы", "ін", "ұ", "_с", "ға", "ө",
                    "ты", "ас", "р_", "ан_", "ны", "ат", "ыл", "_о", "_м", "ен_", "ке", "ә", "сы",
                    "те", "на", "ра", "ың", "_қа", "ры", "ай", "ме", "ү", "ды_", "ті", "ың_", "ол",
                    "ст", "не", "ық", "ба", "ғы", "ет", "қ_", "ді", "жа", "_д", "_жа", "ле", "ге",
                    "ма", "ау", "са", "нда", "рд", "ақ", "ала", "ір", "лд", "ағ", "_ба", "рі",
                    "ек", "п_", "да_", "я", "гі", "ор", "ары", "ад", "_е", "ел", "тт", "ыс",
                    "ның_", "ның", "ық_", "_ө", "ес", "л_", "ам", "ре", "к_", "лі", "ынд", "ар_",
                    "_ке", "ған", "у_", "де_", "ік", "қт", "бо", "асы", "іл", "ында", "ні", "он",
                    "ыр", "ұр", "алы", "_бо", "ің", "мен", "тар", "ын_", "лар", "не_", "_1", "қы",
                    "ің_", "ін_", "ді_", "с_", "_ш", "ия", "аз", "бі", "сі", "мен_", "лық", "ей",
                    "шы", "рт", "бе", "кт", "сы_", "аты", "ына", "лғ", "ған_", "ғы_", "дар", "ылы",
                    "жы", "_са", "ста", "тер", "ка", "рын", "ері", "_ал", "й_", "ер_", "бол",
                    "аны", "_де", "м_", "за", "_бол", "_ме", "лы_", "ег", "ады", "ара", "ады_",
                    "ыны", "со", "в", "уы", "құ", "_та", "ып", "ым", "ты_", "нде", "же", "ша",
                    "сын", "т_", "се", "кө", "ард", "ән", "_п", "_н", "_кө", "ы_б", "нда_", "ағы",
                    "_жы", "н_б", "н_а", "лық_", "лға", "йд", "ем", "өз", "кі", "жыл", "ші", "_құ",
                    "х", "ед", "ік_", "_бі", "мд", "ып_", "_жыл", "_ор", "ген", "н_ж", "па", "_со",
                    "інд", "ы_қ", "_ә", "ф", "тын", "жә", "_жә", "ім", "то", "әне", "ығ", "зд",
                    "әне_", "рл", "және", "жән", "_жән", "дан", "қо", "арын", "рды", "мы", "йы",
                    "бір", "ықт", "ының", "ри", "қта", "інде", "_қо", "н_қ", "на_", "аға", "ы_а",
                    "іс", "еті", "дың", "бас", "лда", "гі_", "аш", "ин", "тан", "дың_", "ыз",
                    "нің", "н_т", "_өз", "ұл", "нің_", "із", "іні", "рг", "_же", "_бір", "тү",
                    "ген_", "аст", "аб", "ға_", "зе", "з_", "анд", "айд", "ры_", "ата", "_2",
                    "лған", "н_к", "_бас", "лды", "ең", "_ү", "_бе", "ул", "бұ", "рін", "рн",
                    "құр", "ни", "іне", "нде_", "қан", "ик", "ақ_", "ап", "қар", "қаз", "ай_",
                    "арды", "_бұ", "тал", "_ар", "лер", "ге_", "_ұ", "ц", "тұ", "_құр", "_р",
                    "_ма", "ми", "ада", "_қаз", "19", "ті_", "ту", "н_с", "а_б", "рғ", "ру", "ом",
                    "ез", "ағы_", "інің", "ти", "рі_", "ола", "еді_", "еді", "ары_", "_ау", "і_б",
                    "зі", "атын", "_тұ", "қты", "ы_т", "_19", "ы_ж", "аза", "ұра", "үр", "ро",
                    "ны_", "етт", "ы_с", "ығы", "ына_", "тін", "нал", "ауы", "_г", "0_", "ос",
                    "ло", "_ат", "ілі", "уд", "қал", "ше",
                ],
            ),
            (
                Language::Ladino,
                vec![
                    "a", "e", "s", "i", "o", "n", "l", "r", "d", "t", "a_", "s_", "u", "_d", "m",
                    "k", "e_", "de", "_e", "n_", "y", "en", "_de", "ra", "es", "el", "de_", "la",
                    "_l", "_de_", "l_", "as", "o_", "p", "_k", "an", "os", "on", "is", "os_", "_i",
                    "_a", "el_", "v", "es_", "_la", "si", "as_", "la_", "nt", "_m", "ta", "i_",
                    "_la_", "un", "or", "ar", "_en", "b", "al", "_s", "_p", "on_", "s_d", "li",
                    "ka", "en_", "ae", "re", "ko", "g", "da", "te", "_i_", "yo", "st", "j", "er",
                    "rae", "f", "srae", "sra", "sr", "rael", "lo", "isra", "isr", "ael", "_o",
                    "ri", "yi", "in", "ent", "na", "mu", "a_d", "_t", "_ko", "s_de", "e_l", "ad",
                    "_el", "_u", "yis", "ti", "io", "ia", "di", "_el_", "00", "tr", "_y", "_mu",
                    "_en_", "a_e", "sa", "pa", "ns", "ik", "do", "_un", "nte", "de_l", "yon", "ma",
                    "_yis", "_yi", "yisr", "po", "nd", "ie", "a_de", "_es", "sy", "se", "ne", "iv",
                    "ika", "to", "h", "eli", "e_la", "_f", "ro", "mo", "los_", "los", "las", "om",
                    "ni", "n_d", "_lo", "r_", "no", "em", "ael_", "na_", "ka_", "est", "al_",
                    "_los", "va", "us", "ika_", "ur", "ul", "s_k", "s_i", "res", "do_", "ans",
                    "a_k", "_r", "z", "tu", "syon", "syo", "so", "mi", "kom", "_po", "_pa", "_kom",
                    "_1", "yon_", "te_", "sa_", "s_a", "n_e", "mun", "le", "ien", "es_d", "dan",
                    "a_en", "_ka", "0_", "ta_", "s_e", "on_d", "kon", "it", "am", "a_i", "_da",
                    "ve", "ny", "n_de", "me", "ke", "ente", "dj", "aeli", "a_p", "_si", "_ar",
                    "_an", "y_", "sta", "s_i_", "ran", "os_d", "n_l", "mp", "ku", "ju", "ist",
                    "ion", "id", "gr", "e_d", "asy", "asi", "ab", "_se", "_dan", "ye", "ya", "ura",
                    "ud", "ua", "sti", "ru", "o_d", "nsa", "nes", "ji", "ia_", "asyo", "any",
                    "ansa", "an_", "_re", "_kon", "_is", "_g", "ue", "tra", "ra_", "nte_", "im",
                    "e_i", "e_a", "dju", "dans", "_mun", "_dj", "00_", "una_", "una", "tur", "rt",
                    "or_", "o_e", "nsa_", "nes_", "nde", "mo_", "men", "lt", "jud", "iva", "gra",
                    "end", "as_d", "ara", "ant", "a_l", "_or", "_ku", "_es_", "_dju", "000_",
                    "000", ".0", "un_", "ult", "tura", "to_", "s_l", "res_", "por", "omo", "nos",
                    "li_", "las_", "l_d", "kul", "ios", "il", "i_e", "gu", "esta", "eli_", "e_e",
                    "djud", "ay", "at", "ada", "a_m", "a_a", "_una", "_tr", "_isr", ".000", ".00",
                    "vi", "ultu", "s_s", "s_p", "s_m", "rs", "ot", "os_k", "ori", "op", "omo_",
                    "nto", "nos_", "ng", "n_s", "n_la", "ment", "ltur", "ltu", "kult", "kl", "ke_",
                    "ita", "ion_", "iji", "ij", "ha", "ez", "ev", "ene", "en_l", "e_k", "de_d",
                    "da_", "c", "bi", "ba", "av", "a_po", "a_i_", "_un_", "_so", "_kul", "_ke_",
                    "_ke", "_b", "_2", "ya_", "uni", "udi", "tro", "s_o", "s_ko", "ral", "rab",
                    "pr", "ov", "ones", "one", "ol", "o_k", "o_de", "mus", "man", "l_e", "komo",
                    "judi", "ing", "fe", "ers", "e_lo", "del_", "del", "ak",
                ],
            ),
            (
                Language::Latin,
                vec![
                    "e", "i", "a", "u", "t", "s", "r", "m", "o", "n", "s_", "c", "l", "e_", "p",
                    "d", "t_", "m_", "qu", "q", "er", "is", "a_", "_i", "_a", "v", "um", "re",
                    "te", "_s", "it", "ue", "is_", "in", "_p", "_e", "us", "b", "i_", "_c", "que",
                    "um_", "nt", "at", "ra", "us_", "ue_", "que_", "_t", "or", "en", "ti", "h",
                    "g", "f", "et", "li", "am", "_m", "tu", "_d", "ro", "em", "o_", "et_", "os",
                    "an", "_v", "_f", "ta", "ia", "ur", "r_", "de", "ae", "ri", "pe", "on", "mi",
                    "_h", "_et_", "_et", "ui", "si", "ni", "la", "es", "_n", "s_a", "na", "im",
                    "ic", "am_", "_in", "ma", "_qu", "_q", "vi", "st", "re_", "em_", "_r", "_l",
                    "di", "ve", "tr", "ns", "id", "ul", "to", "su", "ne", "it_", "cu", "ci", "as",
                    "un", "os_", "hi", "el", "ct", "co", "c_", "te_", "s_i", "s_e", "ru", "pr",
                    "mu", "ere", "_te", "se", "qui", "ol", "no", "le", "il", "ec", "au", "ar",
                    "_o", "sa", "nt_", "m_i", "at_", "ter", "n_", "ll", "ent", "e_p", "do", "_pr",
                    "rt", "pi", "nu", "ere_", "er_", "e_s", "ca", "as_", "al", "ac", "_si", "_re",
                    "_pe", "sque", "squ", "sq", "per", "om", "mo", "me", "iu", "ib", "es_", "ce",
                    "ant", "_u", "_su", "_co", "_au", "x", "tis", "ra_", "pro", "pa", "na_", "lu",
                    "is_a", "e_t", "da", "_vi", "_no", "_ma", "_hi", "_de", "vo", "unt", "uis",
                    "ti_", "tem", "ss", "s_et", "pu", "po", "nd", "lo", "ir", "iam", "ia_", "fe",
                    "era", "ens", "_ve", "_sa", "_pro", "_pa", "_la", "us_a", "up", "uo", "tis_",
                    "ta_", "s_s", "s_p", "s_in", "rum_", "rum", "quo", "nti", "nte", "mp", "equ",
                    "eq", "cum", "bi", "ag", "a_c", "_im", "_cu", "_ca", "ut", "tum", "tor",
                    "tem_", "t_i", "rr", "ros", "rat", "ora", "ns_", "nis", "nc", "ic_", "ibu",
                    "gn", "gi", "ex", "ect", "e_r", "du", "bu", "ba", "av", "_tr", "_quo", "_il",
                    "_fe", "_ac", "ver", "unt_", "tur", "tum_", "t_e", "si_", "s_m", "op", "oc",
                    "itu", "ie", "ibus", "iam_", "fer", "ev", "eri", "ep", "eli", "e_a", "bus",
                    "ate", "ad", "_se", "_po", "_fer", "_do", "_da", "_ae", "uis_", "uc", "ua",
                    "tus", "tro", "ter_", "t_s", "t_a", "s_t", "s_qu", "s_q", "s_c", "ro_", "rem",
                    "rat_", "ora_", "ntem", "non", "nis_", "ng", "mqu", "mq", "min", "m_s", "m_c",
                    "lia", "ite", "ip", "imp", "ill", "ig", "hic_", "hic", "fu", "eu", "ens_",
                    "ed", "eb", "e_v", "d_", "cum_", "cto", "cr", "bus_", "be", "ap", "ab", "_mo",
                    "_me", "_imp", "_hic", "us_e", "ur_", "um_i", "uit", "ue_p", "ue_a", "ud",
                    "tque", "tqu", "tq", "t_f", "t_c", "se_", "sc", "s_h", "ros_", "ris", "quis",
                    "pt", "or_", "oqu", "oq", "on_", "omn", "oe", "non_", "mn", "mit", "m_n",
                    "m_h", "m_d", "m_a", "lt", "lle", "is_i", "ine", "ina_", "ina", "in_", "imu",
                    "i_s", "ho", "ha", "est", "err", "equi", "enti", "e_re", "e_pe", "e_d", "e_c",
                    "dol",
                ],
            ),
            (
                Language::Norwegian,
                vec![
                    "e", "n", "r", "t", "a", "s", "o", "l", "i", "n_", "r_", "g", "k", "h", "en",
                    "e_", "d", "_h", "m", "er", "t_", "v", "_s", "er_", "an", "u", "en_", "ha",
                    "_ha", "f", "g_", "de", "_e", "å", "p", "_d", "_o", "te", "et", "_f", "or",
                    "ne", "an_", "et_", "_i", "han", "_han", "nn", "å_", "ke", "_de", "m_", "han_",
                    "se", "_v", "_m", "re", "og", "b", "st", "om", "me", "_og", "og_", "ar",
                    "_og_", "un", "_t", "in", "ge", "fo", "el", "_k", "for", "ng", "_a", "j", "ø",
                    "i_", "_for", "_fo", "l_", "il", "_er_", "_er", "sk", "om_", "le", "_b", "r_h",
                    "_n", "_g", "ve", "ne_", "ti", "n_h", "kk", "al", "e_h", "ar_", "li", "hu",
                    "es", "_p", "va", "tt", "te_", "t_h", "or_", "nne", "kke", "det", "y", "rt",
                    "is", "det_", "at", "_se", "_hu", "so", "r_s", "n_ha", "ke_", "for_", "eg",
                    "d_", "_me", "vi", "un_", "hun_", "hun", "ed", "_u", "_so", "_r", "_l", "_hun",
                    "ør", "pe", "nge", "n_s", "ka", "je", "il_", "he", "de_", "som", "s_", "ll",
                    "har_", "har", "_i_", "_har", "_det", "til", "ter", "ste", "som_", "r_d", "la",
                    "ig", "g_s", "er_h", "e_s", "_ti", "_som", "_en", "ns", "ik", "eg_", "am",
                    "_å", "_til", "v_", "til_", "ten", "ta", "t_ha", "t_e", "på_", "på", "nt",
                    "nd", "n_m", "kke_", "ikk", "gen", "er_s", "enn", "av", "a_", "_på_", "_på",
                    "år", "ut", "re_", "on", "no", "n_e", "mme", "mm", "ene", "en_h", "_ka", "_in",
                    "_he", "år_", "r_ha", "r_f", "r_de", "lo", "lig", "ko", "ing", "ikke", "hv",
                    "hen", "enne", "em", "e_ha", "den_", "den", "_vi", "_ve", "_ikk", "_ik", "_av",
                    "tte", "tr", "ten_", "ste_", "r_i", "r_e", "pen_", "pen", "nne_", "ni", "n_v",
                    "n_t", "inn", "ham_", "ham", "ei", "ed_", "e_f", "am_", "_st", "_no", "_ham",
                    "_den", "_at", "ær", "æ", "unn", "t_s", "så_", "så", "n_k", "ma", "k_", "it",
                    "gen_", "du", "be", "av_", "ans", "_å_", "_un", "_hv", "_hen", "tt_", "sv",
                    "sp", "ser", "seg_", "seg", "rs", "ra", "oe", "nni", "ng_", "n_o", "n_me",
                    "men", "med", "lt", "ls", "le_", "ld", "kan", "ig_", "est", "ere", "eng",
                    "els", "e_d", "der", "da", "at_", "ang", "ak", "_va", "_så_", "_så", "_sk",
                    "_seg", "_om_", "_om", "_kan", "_et", "_en_", "_du", "_av_", "_at_", "vo",
                    "unni", "ter_", "t_o", "t_er", "t_a", "ss", "ske", "ser_", "sa", "ru", "rt_",
                    "ro", "rd", "r_o", "pp", "ord", "ol", "og_s", "nn_", "ngen", "n_i", "men_",
                    "med_", "lle", "kt", "kan_", "inge", "ie", "henn", "gan", "ga", "et_e", "er_i",
                    "ene_", "en_s", "en_m", "e_m", "e_e", "_unn", "_med", "_de_", "_be", "ør_",
                    "å_h", "var", "t_v", "sl", "si", "sen", "ri", "r_se", "r_a", "ort", "o_", "nå",
                    "noe", "ner", "ne_h", "nde", "n_u", "n_f", "n_er", "n_d", "n_b", "mo", "mer_",
                    "mer", "lv", "lig_", "lan", "ker_", "ker", "i_h", "gu", "gj", "ger_", "ger",
                    "g_f", "et_h", "er_d", "end", "ek", "e_o", "e_i", "e_fo",
                ],
            ),
            (
                Language::Persian,
                vec![
                    "ا",
                    "ی",
                    "ر",
                    "د",
                    "ه",
                    "ن",
                    "م",
                    "و",
                    "ب",
                    "ت",
                    "س",
                    "ه_",
                    "ی_",
                    "ک",
                    "_م",
                    "_ب",
                    "_د",
                    "ل",
                    "ر_",
                    "_ا",
                    "ای",
                    "ن_",
                    "‌",
                    "د_",
                    "ش",
                    "ع",
                    "ز",
                    "دا",
                    "_ک",
                    "ح",
                    "ت_",
                    "ط",
                    "و_",
                    "ا_",
                    "یر",
                    "_دا",
                    "ره",
                    "ان",
                    "می",
                    "_و",
                    "ق",
                    "را",
                    "خ",
                    "به",
                    "ف",
                    "اس",
                    "_و_",
                    "ست",
                    "دای",
                    "ایر",
                    "یره",
                    "دایر",
                    "ایره",
                    "_دای",
                    "ین",
                    "ار",
                    "ند",
                    "به_",
                    "در",
                    "پ",
                    "_به",
                    "_ر",
                    "_در",
                    "با",
                    "ی‌",
                    "ه‌",
                    "ز_",
                    "در_",
                    "_در_",
                    "ره_",
                    "_ت",
                    "_به_",
                    "_با",
                    "ین_",
                    "نی",
                    "رد",
                    "ان_",
                    "_ه",
                    "از",
                    "_پ",
                    "یره_",
                    "ل_",
                    "ای_",
                    "سا",
                    "_ن",
                    "ها",
                    "‌ا",
                    "گ",
                    "ٔ_",
                    "ٔ",
                    "هٔ_",
                    "هٔ",
                    "بر",
                    "p",
                    "که_",
                    "که",
                    "م_",
                    "ری",
                    "است",
                    "ی_ب",
                    "_که_",
                    "_که",
                    "_ش",
                    "آ",
                    "_می",
                    "ند_",
                    "ست_",
                    "از_",
                    "y",
                    "s",
                    "l",
                    "کر",
                    "ور",
                    "را_",
                    "اب",
                    "_را",
                    "_بر",
                    "_از",
                    "_آ",
                    "ص",
                    "i",
                    "a",
                    "_کر",
                    "_را_",
                    "_از_",
                    "رو",
                    "رد_",
                    "است_",
                    "مس",
                    "س_",
                    "او",
                    "_ح",
                    "_اس",
                    "وی",
                    "می‌",
                    "ض",
                    "t",
                    "_ی",
                    "_مس",
                    "_ع",
                    "‌ه",
                    "یا",
                    "کرد",
                    "چ",
                    "ه‌ا",
                    "مح",
                    "لا",
                    "د_ک",
                    "ث",
                    "_می‌",
                    "_س",
                    "‌ها",
                    "ون",
                    "ود",
                    "هم",
                    "نا",
                    "با_",
                    "ام",
                    "_کرد",
                    "_مح",
                    "_با_",
                    "ی_م",
                    "وا",
                    "ده",
                    "_خ",
                    "_است",
                    "ید",
                    "رک",
                    "ی_ا",
                    "ه_د",
                    "ه_ب",
                    "ن_ب",
                    "مر",
                    "ع_",
                    "ره‌",
                    "ر_ا",
                    "حا",
                    "یو",
                    "پی",
                    "سی",
                    "ر_م",
                    "تی",
                    "تا",
                    "اط",
                    "_ز",
                    "‌ای_",
                    "‌ای",
                    "ال",
                    "ا_م",
                    "آن",
                    "_پی",
                    "_آن",
                    "ک_",
                    "ود_",
                    "های",
                    "ه_م",
                    "ه_ا",
                    "ن_د",
                    "لی",
                    "ط_",
                    "دس",
                    "د_که",
                    "تر",
                    "بی",
                    "ار_",
                    "r",
                    "_هم",
                    "_ف",
                    "یک",
                    "ن_م",
                    "مسا",
                    "عد",
                    "ر_د",
                    "دو",
                    "ج",
                    "بر_",
                    "آن_",
                    "_مسا",
                    "_ق",
                    "_آن_",
                    "کز",
                    "کرد_",
                    "ول",
                    "ه‌ای",
                    "نی_",
                    "مرکز",
                    "مرک",
                    "شی",
                    "شد",
                    "زم",
                    "رکز",
                    "رش",
                    "بو",
                    "برا",
                    "اد",
                    "ysty",
                    "yst",
                    "ys",
                    "yle_",
                    "yle",
                    "yl",
                    "tyle",
                    "tyl",
                    "ty",
                    "styl",
                    "sty",
                    "st",
                    "spla",
                    "spl",
                    "sp",
                    "play",
                    "pla",
                    "pl",
                    "le_",
                    "le",
                    "lays",
                    "lay",
                    "la",
                    "ispl",
                    "isp",
                    "is",
                    "e_",
                    "e",
                    "disp",
                    "dis",
                    "di",
                    "d",
                    "ayst",
                    "ays",
                    "ay",
                    "_برا",
                    "_dis",
                    "_di",
                    "_d",
                    "‌های",
                    "ی_د",
                    "وس",
                    "من",
                    "ش_",
                    "دی",
                    "خو",
                    "ح_",
                    "بت",
                    "ئ",
                    "_۱",
                    "یره‌",
                    "کن",
                    "ها_",
                    "مین",
                    "محا",
                    "طی",
                    "زمی",
                    "ر_دا",
                    "دن",
                    "دد",
                    "ثا",
                    "بود",
                    "بت_",
                    "اص",
                    "pi_",
                    "pi",
                    "i_",
                    "_یک",
                    "_مر",
                    "_محا",
                    "_عد",
                    "_زم",
                    "_بود",
                    "_بو",
                    "_ای",
                    "_pi_",
                    "_pi",
                    "_p",
                    "‌ک",
                    "‌ش",
                    "۰_",
                    "چن",
                    "وس_",
                    "ور_",
                    "ما",
                    "فل",
                    "زمین",
                    "این",
                    "اخ",
                    "ا_ب",
                    "_گ",
                    "_زمی",
                    "_ث",
                    "یه",
                    "ی_ک",
                    "ی_ر",
                    "وی_",
                    "و_ب",
                    "ه‌ها",
                    "ه‌ه",
                    "هر",
                    "ن‌",
                    "ف_",
                    "عی",
                    "عدد",
                    "طی_",
                    "سب",
                    "زی",
                    "دد_",
                    "دار",
                    "خت",
                    "ثابت",
                    "ثاب",
                    "تی_",
                    "اح",
                    "ابت",
                    "_چ",
                    "_عدد",
                    "_دو",
                    "_خو",
                    "_ثاب",
                    "_ثا",
                    "_این",
                    "ین_د",
                    "یف",
                    "یش",
                    "یر_",
                    "ی_و",
                    "ی_را",
                    "پی_",
                    "وان",
                    "هن",
                    "های_",
                    "ه_ک",
                    "ه_ت",
                    "نو",
                    "نان",
                    "مین_",
                    "مو",
                    "قط",
                    "عدد_",
                    "ره‌ا",
                    "را_ب",
                    "د_۱",
                    "د_پ",
                    "حت_",
                    "حت",
                    "تار",
                    "ت_ک",
                    "ت_م",
                    "ب_",
                    "اق",
                    "اع",
                    "اش",
                    "ابت_",
                    "ائ",
                    "le_p",
                    "e_pi",
                    "e_p",
                    "_پی_",
                    "_بی",
                    "_بر_",
                    "ی_با",
                    "گی",
                    "گر",
                ],
            ),
            (
                Language::Portuguese,
                vec![
                    "a", "o", "e", "s", "i", "r", "t", "d", "n", "o_", "m", "u", "a_", "c", "e_",
                    "s_", "p", "_d", "l", "de", "_a", "es", "os", "_p", "ra", "os_", "do", "_s",
                    "nt", "_de", "de_", "v", "_c", "re", "_m", "to", "_e", "te", "r_", "g", "ar",
                    "ta", "or", "co", "_n", "en", "se", "do_", "_de_", "f", "er", "m_", "ma", "as",
                    "_t", "ri", "b", "da", "ad", "o_d", "st", "qu", "q", "no", "_se", "_o", "_co",
                    "ç", "ão", "ã", "is", "ão_", "in", "ia", "an", "me", "es_", "ue", "pa", "_qu",
                    "_q", "_f", "ti", "po", "on", "io", "h", "al", "s_d", "que", "nte", "am",
                    "ent", "ca", "_do", "om", "_que", "_a_", "to_", "em", "ci", "as_", "ra_", "é",
                    "ue_", "u_", "te_", "que_", "_r", "_pa", "_no", "na", "ec", "_po", "tr",
                    "o_de", "ic", "em_", "ei", "á", "ss", "si", "ou", "no_", "li", "ce", "aç",
                    "ado", "a_d", "_re", "_i", "_e_", "par", "o_c", "o_a", "nto", "nd", "mi", "id",
                    "_o_", "_do_", "_da", "um", "so", "sa", "res", "pr", "o_p", "men", "l_", "im",
                    "ai", "í", "ve", "rt", "mo", "it", "il", "el", "da_", "ant", "a_a", "_par",
                    "_ma", "ção_", "ção", "çã", "s_de", "ro", "o_s", "ma_", "ia_", "fo", "est",
                    "er_", "e_p", "con", "com", "ara", "a_p", "_l", "_b", "ão_d", "or_", "ont",
                    "nte_", "ment", "la", "ir", "dos_", "dos", "ar_", "ac", "a_de", "_com", "x",
                    "va", "uma_", "uma", "tu", "sta", "s_e", "pe", "ou_", "os_d", "nto_", "lh",
                    "ho", "e_d", "di", "_v", "_no_", "_fo", "_es", "vo", "vi", "tra", "tos_",
                    "tos", "s_p", "s_a", "rio", "o_e", "ni", "is_", "gu", "ente", "e_n", "e_c",
                    "e_a", "at", "am_", "ado_", "a_s", "a_m", "_um", "_u", "_pr", "_na", "ur",
                    "ua", "s_t", "s_n", "ria", "r_a", "ol", "o_m", "o_do", "o_co", "ne", "nc",
                    "mu", "lo", "ist", "io_", "ica", "gr", "e_t", "e_m", "des", "dad", "ação",
                    "açã", "ara_", "al_", "ade", "_uma", "_in", "_con", "ões_", "ões", "õe", "õ",
                    "ça", "ul", "ui", "ter", "ta_", "ser", "sen", "rec", "por", "para", "o_n",
                    "mp", "le", "j", "iv", "ida", "eg", "do_p", "ct", "cont", "br", "ap", "a_e",
                    "_te", "_ta", "_por", "_mi", "_me", "_ap", "z", "tiv", "tes", "tado", "tad",
                    "s_o", "rr", "ov", "oc", "o_t", "o_se", "o_o", "nta", "ns", "mo_", "m_a",
                    "ime", "gra", "gi", "fi", "ess", "ed", "e_s", "ba", "ab", "a_c", "_ser", "_pe",
                    "_os_", "_os", "_mu", "_est", "_em", "_des", "_da_", "ça_", "à", "va_", "ut",
                    "un", "tes_", "tar", "tan", "str", "ser_", "se_", "s_c", "ria_", "res_", "r_m",
                    "os_p", "ort", "omo_", "omo", "o_qu", "o_q", "o_i", "nos", "ndo_", "ndo",
                    "min", "ito", "idad", "i_", "go", "eu", "esta", "ento", "ece", "e_o", "e_de",
                    "das_", "das", "dade", "como", "cia", "av", "a_r", "a_f", "_à", "_ne", "_g",
                    "_em_", "_das", "ário", "ári", "ár", "à_", "us", "uit", "tor", "tic", "tant",
                    "sti", "s_s", "s_m", "s_f", "s_e_",
                ],
            ),
            (
                Language::Romanian,
                vec![
                    "a", "i", "e", "t", "r", "n", "u", "e_", "c", "s", "a_", "o", "l", "i_", "d",
                    "p", "m", "in", "_c", "_s", "_d", "ar", "re", "_a", "_p", "de", "ra", "at",
                    "f", "_i", "n_", "ta", "st", "ca", "u_", "ti", "te", "_de", "si", "de_", "un",
                    "t_", "_m", "_o", "_in", "nt", "g", "ce", "ul", "ri", "_ca", "or", "b", "ma",
                    "_de_", "es", "_f", "la", "are", "ta_", "l_", "v", "tr", "_si", "te_", "re_",
                    "in_", "el", "ea", "ci", "se", "_t", "_u", "_e", "si_", "oa", "ia", "_l", "ni",
                    "cu", "are_", "_si_", "z", "e_c", "as", "ne", "le", "da", "an", "_ma", "pe",
                    "ic", "ei", "_un", "ra_", "pa", "lu", "li", "int", "er", "e_a", "ac", "a_s",
                    "a_d", "r_", "est", "ste", "_n", "sa", "la_", "ii", "i_c", "car", "_pe", "to",
                    "o_", "na", "it", "ie", "al", "_se", "_in_", "_cu", "il", "en", "ei_", "e_i",
                    "care", "ai", "a_c", "_o_", "un_", "ul_", "ui", "se_", "ii_", "i_p", "este",
                    "e_s", "e_d", "cu_", "au", "ata", "me", "lo", "le_", "co", "ata_", "ara", "am",
                    "_v", "_cu_", "_car", "_b", "ui_", "ste_", "ru", "pr", "pe_", "om", "fa",
                    "ca_", "a_p", "_r", "_ce", "rt", "nu", "na_", "i_d", "h", "e_p", "e_in", "ap",
                    "a_de", "a_a", "_sa", "ur", "tu", "tra", "sa_", "e_f", "ara_", "ace", "a_i",
                    "_pe_", "_da", "zi", "sc", "pi", "ot", "nd", "n_c", "mu", "mi", "lui", "is",
                    "io", "ia_", "e_o", "e_m", "e_ca", "di", "ce_", "au_", "a_o", "_un_", "_la",
                    "_ca_", "ve", "ut", "po", "os", "or_", "oar", "ne_", "lui_", "i_s", "fo", "fe",
                    "ele", "ea_", "ci_", "bi", "at_", "ai_", "a_in", "_se_", "_pa", "_fa", "_co",
                    "_ac", "um", "tat", "ir", "ie_", "et", "ent", "ele_", "e_si", "c_", "_nu",
                    "_int", "_di", "ulu", "ti_", "sta", "pu", "op", "ol", "nu_", "ntr", "mar",
                    "iu", "im", "ici", "i_m", "i_e", "i_a", "ga", "ec", "cel", "a_l", "_sa_",
                    "_la_", "_fo", "_est", "_es", "_a_", "ului", "su", "par", "ori", "on", "ns",
                    "mo", "m_", "it_", "hi", "e_ma", "do", "din", "dat", "ati", "a_un", "a_u",
                    "a_t", "_st", "_po", "_nu_", "_lu", "_g", "_din", "_ar", "une", "tru", "tie",
                    "t_d", "str", "ro", "ost", "oc", "nic", "ng", "nc", "mul", "mai_", "mai",
                    "ma_", "lor_", "lor", "ini", "ine", "ind", "i_o", "i_ma", "gi", "fi", "em",
                    "e_v", "e_de", "da_", "ate", "ad", "a_si", "a_f", "a_e", "_tr", "_pr", "_or",
                    "_mar", "_e_", "_do", "_ace", "una", "u_s", "tul", "tot", "tor", "tin", "t_c",
                    "sin", "si_c", "s_", "rm", "ri_", "res", "rea", "ran", "pri", "pl", "pin",
                    "nta", "nde", "n_ca", "mp", "min", "lt", "j", "iv", "ina", "in_c", "ilo",
                    "i_u", "i_i", "i_de", "far", "esc", "e_o_", "de_f", "de_a", "d_", "cr", "ch",
                    "az", "ator", "ato", "ast", "art", "ar_", "ani", "a_pe", "a_n", "_to", "_mai",
                    "_ci", "vi", "up", "tre", "tie_", "te_d", "te_a", "ta_s", "ta_d", "st_", "so",
                    "sea", "sc_", "sa_s", "rul", "rti",
                ],
            ),
            (
                Language::Russian,
                vec![
                    "о", "е", "а", "и", "н", "т", "с", "в", "р", "л", "к", "м", "д", "п", "у",
                    "о_", "е_", "я", "ы", "и_", "_п", "ь", "_н", "_в", "_с", "з", "г", "а_", "б",
                    "ч", "ст", "я_", "то", "но", "_о", "_и", "по", "ь_", "й", "на", "не", "ни",
                    "ен", "_к", "_по", "ж", "ра", "ро", "ов", "ко", "х", "й_", "м_", "в_", "_т",
                    "т_", "пр", "_д", "го", "ка", "_м", "ал", "у_", "ре", "ли", "во", "ер", "ос",
                    "ть", "от", "ва", "ш", "та", "ю", "ет", "_не", "_б", "_на", "ы_", "_и_", "од",
                    "_пр", "ел", "ол", "_р", "он", "те", "ор", "ан", "ло", "ла", "де", "_в_", "ле",
                    "ит", "ть_", "ат", "ом", "ог", "ве", "_з", "то_", "но_", "ны", "ес", "не_",
                    "за", "ри", "ль", "_ч", "ц", "ме", "ти", "да", "на_", "ем", "_у", "ин", "до",
                    "ак", "че", "х_", "мо", "л_", "го_", "ил", "к_", "ся", "ас", "ой", "се", "_г",
                    "ся_", "об", "_не_", "ам", "_е", "щ", "им", "ли_", "ск", "э", "тр", "же", "ед",
                    "тв", "аз", "ой_", "ав", "_за", "со", "ис", "ки", "сл", "про", "_ко", "_на_",
                    "ет_", "_э", "ост", "ми", "ви", "ар", "н_", "вы", "_ра", "ю_", "сь", "_л",
                    "сь_", "бы", "нн", "ие", "ег", "_а", "с_", "ру", "эт", "пе", "ив", "ди", "_то",
                    "вс", "ени", "чт", "ей", "_про", "ма", "из", "ое", "_эт", "бо", "ств", "е_п",
                    "_ка", "что", "ча", "ого", "_чт", "ок", "о_в", "_что", "ия", "о_п", "ать", "ф",
                    "ае", "ом_", "_от", "_он", "_вс", "хо", "ож", "_мо", "_бы", "чи", "ик", "его",
                    "му", "дн", "_во", "_ст", "ие_", "что_", "ста", "и_п", "при", "ну", "_я",
                    "ого_", "_со", "и_н", "его_", "ад", "это", "оч", "ия_", "енн", "их", "_при",
                    "ест", "о_с", "кр", "и_в", "ку", "_это", "о_н", "ми_", "и_с", "ек", "па", "ня",
                    "ем_", "ак_", "а_п", "ые", "уд", "ры", "ла_", "ать_", "ци", "ты", "тс", "ля",
                    "ев", "ду", "ые_", "тел", "мен", "все", "ыл", "ше", "_но", "_до", "ый", "си",
                    "ый_", "св", "_та", "ят", "са", "оп", "ова", "ей_", "е_н", "ьн", "сп", "оро",
                    "льн", "да_", "ает", "_вы", "сто", "ани", "_все", "ще", "ни_", "ере", "ая",
                    "али", "_ни", "_го", "оз", "_ж", "пер", "му_", "зн", "_св", "_де", "ту", "ое_",
                    "бе", "а_с", "их_", "ить", "_я_", "_с_", "тся_", "тся", "оль", "мы", "мн",
                    "ез", "был", "ал_", "раз", "р_", "под", "ов_", "ка_", "з_", "е_с", "лу",
                    "_был", "ние", "ло_", "ель", "га", "как", "ая_", "я_н", "ус", "он_", "нно",
                    "ич", "е_в", "аю", "_об", "ния", "_ме", "тн", "пол", "ово", "ове", "о_о",
                    "ко_", "а_н", "_из", "тор", "ото", "ки_", "ии", "ид", "и_о", "вн", "ых", "ти_",
                    "ров", "нт", "ир", "ии_", "е_и", "вер", "вал", "а_в", "ши", "сти", "ния_",
                    "жи", "_под", "ь_в", "жн", "_х", "_те", "_раз", "_как", "уч", "лю", "лен",
                    "ий", "пос", "ног", "вл", "аж", "_пе", "я_п", "ут", "так", "стр", "ить_",
                ],
            ),
            (
                Language::Spanish,
                vec![
                    "e", "a", "o", "s", "n", "r", "i", "l", "d", "c", "t", "e_", "a_", "s_", "u",
                    "m", "de", "p", "_d", "_de", "o_", "_l", "la", "de_", "en", "_de_", "es", "_p",
                    "n_", "_e", "_c", "as", "_la", "os", "ci", "os_", "or", "ar", "ra", "_a",
                    "la_", "er", "r_", "f", "ue", "nt", "_la_", "as_", "te", "an", "_m", "do",
                    "st", "re", "l_", "_s", "ta", "es_", "el", "ad", "v", "on", "b", "y", "po",
                    "g", "e_l", "co", "ca", "al", "to", "lo", "se", "na", "qu", "q", "ue_", "s_d",
                    "que", "in", "ic", "ent", "ó", "ro", "h", "un", "mi", "_po", "í", "s_de", "pa",
                    "le", "el_", "da", "_y", "_co", "y_", "que_", "do_", "ni", "e_la", "ac", "a_d",
                    "_en", "tr", "de_l", "_que", "_qu", "_q", "por", "ie", "id", "en_", "ec",
                    "a_de", "_f", "ti", "or_", "ma", "ió", "_y_", "ón_", "ón", "á", "ri", "nd",
                    "_t", "_lo", "pr", "me", "ión_", "ión", "_se", "_por", "te_", "o_d", "nte",
                    "ne", "j", "e_p", "e_e", "ció", "a_l", "_i", "_en_", "_el", "por_", "om",
                    "o_de", "est", "di", "ción", "ce", "a_c", "_h", "_el_", "to_", "io", "aci",
                    "_pr", "_es", "los_", "los", "_u", "ía", "ta_", "oc", "no", "ado", "a_p",
                    "_pa", "_n", "z", "se_", "ra_", "na_", "n_l", "mo", "is", "_v", "_un", "_r",
                    "_los", "_a_", "ía_", "si", "li", "las", "im", "ien", "dad", "cu", "_o", "_ma",
                    "tra", "par", "o_a", "nto", "mp", "las_", "ha", "com", "am", "ació", "_mi",
                    "_las", "_in", "_ca", "vi", "sta", "sa", "s_l", "rt", "nto_", "nte_", "n_d",
                    "e_d", "ara", "ar_", "_ci", "ve", "s_c", "pl", "ol", "n_la", "n_de", "men",
                    "ll", "la_c", "il", "ient", "ica", "ia", "ga", "fe", "et", "ento", "em", "e_s",
                    "e_c", "dos", "des", "at", "al_", "a_m", "a_la", "a_e", "_re", "_par", "_com",
                    "ur", "una", "sp", "s_p", "rr", "res", "os_d", "one", "nes_", "nes", "nc",
                    "mu", "lo_", "les", "iv", "ir", "if", "ido", "ici", "ho", "er_", "ente", "e_m",
                    "e_de", "dos_", "ba", "ado_", "_una", "_se_", "_j", "_ha", "_b", "ón_d", "ñ",
                    "é", "za", "una_", "ul", "ud", "ten", "ste", "so", "s_y", "s_s", "s_qu", "s_q",
                    "s_e", "s_a", "r_c", "pu", "pro", "ot", "on_", "o_e", "les_", "ion", "ida",
                    "gr", "fi", "es_d", "e_lo", "ct", "cie", "cal", "as_d", "and", "an_", "a_y",
                    "a_po", "a_a", "_pro", "su", "s_y_", "rec", "r_e", "pe", "para", "no_", "nic",
                    "ndo", "n_p", "n_c", "ment", "ist", "ido_", "fu", "fo", "esp", "eri", "en_l",
                    "eg", "ece", "e_se", "do_a", "del_", "del", "de_p", "de_m", "con", "cen",
                    "ara_", "ant", "ab", "a_f", "_tr", "_fu", "_est", "_del", "_al", "ú", "x",
                    "ue_s", "to_d", "ter", "str", "sta_", "s_m", "rí", "rá", "rs", "ron_", "ron",
                    "ras", "ran", "pre", "or_c", "ones", "ob", "ndo_", "nci", "n_m", "má", "mo_",
                    "min", "mie", "je", "ip", "ini", "idad", "gu", "fue", "ena", "ed", "e_co",
                    "de_c", "cio", "au", "ante", "ani", "a_y_",
                ],
            ),
            (
                Language::Swedish,
                vec![
                    "a", "i", "a_", "k", "u", "n", "w", "m", "o", "e", "wa", "h", "i_", "s", "t",
                    "l", "_k", "y", "_w", "_wa", "wa_", "_m", "r", "o_", "ka", "ku", "li", "z",
                    "ma", "b", "a_k", "an", "ya", "g", "ha", "a_m", "na", "j", "ik", "d", "_ku",
                    "f", "at", "am", "_n", "ya_", "u_", "is", "hi", "al", "_ya", "_y", "_a", "ki",
                    "a_w", "sh", "e_", "ti", "ta", "ri", "_h", "il", "ia", "_ma", "p", "a_wa",
                    "_ya_", "_ka", "zi", "ni", "ng", "ali", "_wa_", "na_", "ba", "ia_", "ar", "ak",
                    "a_ma", "la", "v", "mb", "ika", "a_ku", "_u", "ili", "i_k", "ati", "as", "_s",
                    "ni_", "in", "a_n", "za", "kw", "kat", "i_w", "_na", "se", "li_", "i_wa", "si",
                    "kwa", "c", "zi_", "sa", "ma_", "kati", "ka_", "_l", "ut", "un", "ish", "hu",
                    "fa", "ch", "_v", "_na_", "_kw", "nd", "di", "a_u", "a_s", "sha", "mba", "ja",
                    "it", "ana", "ai", "_kwa", "za_", "yo", "ko", "ika_", "er", "amb", "a_ya",
                    "a_y", "a_a", "_t", "_kat", "ya_k", "on", "kwa_", "en", "bi", "af", "_z",
                    "_ki", "_i", "_hi", "wak", "wa_m", "tu", "ny", "mi", "la_", "ha_", "fu", "ek",
                    "ama", "aj", "aa", "a_v", "_ha", "_ali", "_al", "um", "ti_", "sa_", "rik",
                    "ji", "iw", "iki", "if", "he", "ao", "amba", "a_ki", "a_h", "_wak", "_la",
                    "_j", "_b", "wa_k", "us", "tik", "ra", "le", "iz", "iwa", "eri", "em", "a_ka",
                    "_se", "wan", "uu", "ul", "to", "tika", "ke", "i_ya", "i_y", "i_ku", "go",
                    "ga", "atik", "ari", "a_t", "a_na", "a_kw", "yo_", "ye", "vy", "ua", "pi",
                    "mu", "mk", "kut", "ini", "ili_", "ho", "ao_", "_za", "_mk", "we", "wal", "vi",
                    "uwa", "uw", "uu_", "sha_", "no", "ndi", "mo", "kuwa", "kuw", "kam", "iy",
                    "iwa_", "im", "ifa", "i_z", "i_m", "fa_", "di_", "da", "az", "aw", "aki", "ad",
                    "a_hi", "_ta", "_am", "zi_w", "wa_n", "uz", "uta", "uh", "rika", "pa", "ot",
                    "o_h", "no_", "me", "iyo", "ini_", "ifa_", "ge", "ez", "es", "ba_", "ay", "au",
                    "ang", "ali_", "ah", "ab", "a_vi", "a_se", "_vy", "_vi", "_p", "_kam", "zo",
                    "wana", "wa_w", "vya", "ur", "uo", "u_wa", "u_w", "th", "o_wa", "o_w", "o_k",
                    "o_a", "nj", "ngo", "nga", "mar", "lis", "kuu", "kis", "ki_", "je", "ip",
                    "iki_", "id", "ib", "i_ka", "i_a", "ho_", "hi_", "gu", "dh", "cha", "ani",
                    "ana_", "ama_", "ag", "a_mk", "a_l", "a_b", "_vya", "_la_", "wi", "wa_s",
                    "uwa_", "ung", "tu_", "ta_", "su", "sem", "ok", "nz", "mku", "kuu_", "kali",
                    "kal", "ju", "isha", "i_za", "ema_", "ema", "eke", "bw", "azi", "awa", "atu",
                    "ati_", "ata", "asi", "aka", "aji", "a_ta", "a_j", "_za_", "_r", "_ni", "_mku",
                    "_mar", "_kut", "_amb", "ye_", "wam", "wali", "w_", "uo_", "uli", "uhu", "uf",
                    "te", "seri", "ser", "sema", "re", "om", "o_ya", "o_y", "o_l", "nye", "ndi_",
                    "mu_", "man", "li_k", "kama", "iyo_", "ita", "isa", "ir", "iku", "ikal", "i_n",
                    "hus", "hiyo", "hiy", "hil", "heri", "her",
                ],
            ),
            (
                Language::Tamil,
                vec![
                    "்",
                    "க",
                    "ு",
                    "ி",
                    "த",
                    "்_",
                    "ப",
                    "ம",
                    "ட",
                    "ர",
                    "ா",
                    "ல",
                    "ன",
                    "வ",
                    "ற",
                    "ை",
                    "்க",
                    "ய",
                    "ள",
                    "ு_",
                    "்த",
                    "ம்",
                    "ச",
                    "்ப",
                    "ம்_",
                    "ந",
                    "ன்",
                    "ல்",
                    "க்",
                    "_ப",
                    "து",
                    "்ட",
                    "ர்",
                    "ப்",
                    "_க",
                    "ும",
                    "த்",
                    "_ம",
                    "க்க",
                    "ல்_",
                    "ில",
                    "ும்",
                    "தி",
                    "இ",
                    "கள",
                    "_இ",
                    "ும்_",
                    "ப்ப",
                    "த்த",
                    "ட்",
                    "ண",
                    "கு",
                    "ிய",
                    "து_",
                    "அ",
                    "_அ",
                    "_த",
                    "_வ",
                    "ரு",
                    "டு",
                    "ள்",
                    "ுக",
                    "்ற",
                    "_ச",
                    "்_ப",
                    "ட்ட",
                    "ெ",
                    "ந்",
                    "ை_",
                    "ந்த",
                    "ில்",
                    "ே",
                    "ின",
                    "ர்_",
                    "ன்_",
                    "்_க",
                    "ில்_",
                    "ற்",
                    "பட",
                    "கி",
                    "_ந",
                    "ோ",
                    "ாக",
                    "ொ",
                    "்கள",
                    "ின்",
                    "ிக",
                    "ண்",
                    "டி",
                    "ிர",
                    "ுத",
                    "வி",
                    "ழ",
                    "ி_",
                    "்கு",
                    "்தி",
                    "ைய",
                    "ங",
                    "ங்",
                    "்பட",
                    "ங்க",
                    "்_த",
                    "ஆ",
                    "று",
                    "எ",
                    "_எ",
                    "ள்_",
                    "பி",
                    "்_இ",
                    "_ஆ",
                    "ார",
                    "கா",
                    "்_ம",
                    "வர",
                    "்து",
                    "கள்",
                    "கள்_",
                    "சி",
                    "ரி",
                    "்_அ",
                    "க_",
                    "ுக்",
                    "ற்ற",
                    "ான",
                    "ூ",
                    "ப்பட",
                    "ன்ற",
                    "ண்ட",
                    "மா",
                    "ளி",
                    "த்தி",
                    "ின்_",
                    "ைக",
                    "ுக்க",
                    "உ",
                    "்டு",
                    "_உ",
                    "்_ச",
                    "க்கு",
                    "்ச",
                    "ன_",
                    "ிற",
                    "யி",
                    "பு",
                    "மு",
                    "பா",
                    "்_வ",
                    "யா",
                    "தா",
                    "ார்",
                    "என",
                    "_என",
                    "றி",
                    "்ள",
                    "்று",
                    "ீ",
                    "ள்ள",
                    "ாட",
                    "ாக_",
                    "ுவ",
                    "வா",
                    "ால",
                    "லை",
                    "த_",
                    "ுப",
                    "்கி",
                    "ிட",
                    "க்_",
                    "்கள்",
                    "பட்",
                    "மை",
                    "_மு",
                    "ுத்",
                    "பட்ட",
                    "்_ந",
                    "வு",
                    "களி",
                    "கு_",
                    "ிக்",
                    "கும",
                    "்வ",
                    "ய_",
                    "ைப",
                    "்டி",
                    "்த_",
                    "பெ",
                    "்_எ",
                    "கும்",
                    "ிப",
                    "ரா",
                    "_பி",
                    "தில",
                    "க்_க",
                    "ுத்த",
                    "டை",
                    "a",
                    "்கு_",
                    "ப்_",
                    "ஒ",
                    "என்",
                    "்ல",
                    "ைக்",
                    "_ஒ",
                    "_என்",
                    "்பு",
                    "்து_",
                    "ச்",
                    "ுள",
                    "நி",
                    "படு",
                    "இர",
                    "_இர",
                    "த்து",
                    "ார்_",
                    "்_ஆ",
                    "ப்_ப",
                    "ந்து",
                    "செ",
                    "ிக்க",
                    "ைப்",
                    "ு_ப",
                    "வர்",
                    "டு_",
                    "்படு",
                    "ுந",
                    "ளை",
                    "_கா",
                    "ுட",
                    "ித",
                    "கை",
                    "ர்க",
                    "_1",
                    "லி",
                    "யில",
                    "_வி",
                    "_செ",
                    "்பட்",
                    "ு_ம",
                    "ங்கள",
                    "ுற",
                    "தை",
                    "ு_க",
                    "மி",
                    "போ",
                    "ுப்",
                    "ல்ல",
                    "டுக",
                    "ு_இ",
                    "ய்",
                    "பத",
                    "தில்",
                    "திர",
                    "ெய",
                    "ிரு",
                    "லா",
                    "தன",
                    "டத",
                    "_கு",
                    "ிய_",
                    "ிப்",
                    "்பி",
                    "கொ",
                    "்தில",
                    "ிவ",
                    "ாட்",
                    "ட்டு",
                    "ுந்த",
                    "ுந்",
                    "று_",
                    "ந்த_",
                    "கர",
                    "ான_",
                    "ம்_இ",
                    "ன்ப",
                    "ுள்",
                    "ண்டு",
                    "_பெ",
                    "ுகள",
                    "சு",
                    "்கா",
                    "ு_வ",
                    "யில்",
                    "ப்பு",
                    "்பா",
                    "ு_அ",
                    "ஸ",
                    "ருந",
                    "ம்ப",
                    "ம்_ப",
                    "ளு",
                    "ளில",
                    "ரை",
                    "கப",
                    "னை",
                    "்சி",
                    "ிப்ப",
                    "ற்று",
                    "ாத",
                    "ாவ",
                    "திய",
                    "களில",
                    "்_உ",
                    "ர்கள",
                    "கப்",
                    "ு_த",
                    "ற்க",
                    "ே_",
                    "இத",
                    "_சி",
                    "_இத",
                    "ட_",
                    "_நி",
                    "்டு_",
                    "ருந்",
                    "நா",
                    "இரு",
                    "_இரு",
                    "ல்_ப",
                    "தல",
                    "டா",
                    "்ம",
                    "ாம",
                    "ா_",
                    "லு",
                    "றத",
                    "தொ",
                    "்ன",
                    "ஸ்",
                    "னி",
                    "_மா",
                    "ால்",
                    "ருக",
                    "ையி",
                    "ியா",
                    "களை",
                    "்_என",
                    "ுகி",
                    "ுப்ப",
                    "ளில்",
                    "ைகள",
                    "ிகள",
                    "யு",
                    "க்கி",
                    "த்_",
                    "கிற",
                    "களு",
                    "_கொ",
                    "னா",
                    "_தொ",
                    "ியி",
                    "றை",
                    "ு_ச",
                    "டுத",
                    "கப்ப",
                    "்பத",
                    "ேர",
                    "ற_",
                    "ன்ன",
                    "ுள்ள",
                    "ச்ச",
                    "இந்",
                    "இந",
                    "அத",
                    "_இந்",
                    "_இந",
                    "_அத",
                    "்தா",
                    "வை",
                    "ம்_அ",
                    "ைப்ப",
                    "ால்_",
                    "றும",
                    "டும",
                    "தம",
                    "ட்டி",
                    "கட",
                    "_தி",
                    "ித்",
                    "ம்_க",
                    "த்_த",
                    "து_இ",
                    "ம்_ம",
                    "றும்",
                    "்டத",
                    "ன்று",
                    "்ந",
                    "ாண",
                    "றா",
                    "்கப",
                    "ாட்ட",
                    "ப்பி",
                    "டிய",
                    "அம",
                    "_அம",
                    "்கும",
                    "ைக்க",
                    "ுதி",
                    "ல்_இ",
                    "ரும",
                    "ரு_",
                ],
            ),
            (
                Language::Turkish,
                vec![
                    "a", "e", "i", "l", "r", "n", "k", "t", "d", "m", "ı", "s", "u", "y", "o",
                    "e_", "n_", "b", "ar", "er", "la", "ü", "le", "i_", "r_", "a_", "an", "_b",
                    "in", "z", "g", "v", "ý", "de", "ş", "il", "en", "_k", "k_", "ma", "_a", "ri",
                    "ir", "_d", "_i", "h", "da", "_s", "li", "c", "_y", "ç", "p", "nd", "ra", "ya",
                    "lar", "ı_", "al", "ın", "ö", "ak", "ve", "_t", "ler", "ğ", "bi", "ek", "_v",
                    "_g", "re", "me", "ka", "si", "eri", "el", "te", "_ve", "ta", "_e", "_o", "ni",
                    "et", "ti", "ol", "di", "f", "ve_", "an_", "ay", "ne", "_ve_", "sa", "_bi",
                    "_h", "u_", "ir_", "in_", "_m", "es", "da_", "am", "en_", "as", "m_", "ki",
                    "un", "na", "ara", "rı", "lı", "ul", "_ya", "_ka", "nı", "ye", "de_", "at",
                    "leri", "ile", "im", "kl", "em", "ik", "nl", "mi", "l_", "ge", "_ol", "ha",
                    "arı", "nda", "ba", "z_", "lan", "iy", "ed", "bir", "rl", "ad", "lu", "ur",
                    "þ", "bu", "er_", "ün", "on", "_bir", "iz", "is", "sı", "or", "ıl", "_de",
                    "se", "ak_", "lm", "kt", "esi", "_ge", "t_", "_bu", "ır", "_ç", "rin", "ini",
                    "ru", "ları", "ür", "it", "_ba", "st", "_ö", "erin", "tı", "rd", "ar_", "nde",
                    "ke", "ýn", "_sa", "le_", "nu", "_ta", "ý_", "_p", "iş", "ili", "aş", "be",
                    "ap", "yo", "ri_", "ku", "dı", "_ha", "bir_", "n_b", "_ü", "ind", "bil", "_il",
                    "ð", "den", "nda_", "ce", "az", "ama", "ey", "inde", "e_b", "ola", "ele", "ği",
                    "si_", "ld", "ek_", "ınd", "ll", "li_", "ze", "ın_", "ala", "ası", "ön",
                    "ında", "ca", "_f", "ml", "eri_", "gi", "rm", "ci", "nc", "_al", "ne_", "edi",
                    "_u", "_te", "tü", "ını", "r_b", "ab", "anı", "çi", "ere", "ko", "eti", "iç",
                    "_da", "ık", "ör", "yı", "ler_", "ik_", "ış", "rk", "so", "rs", "gö", "um",
                    "tl", "du", "bu_", "_ola", "çe", "_be", "lar_", "im_", "_bu_", "rak", "eli",
                    "den_", "_iç", "nde_", "sin", "rın", "_gö", "ver", "na_", "esi_", "arın",
                    "nla", "_ku", "lma", "ni_", "dan", "mak", "e_k", "ah", "ım", "mı", "i_b", "ev",
                    "_so", "_ko", "ır_", "yap", "ma_", "len", "iler", "_me", "_yap", "fa", "aya",
                    "dü", "a_b", "n_k", "alı", "şt", "nin", "anl", "yl", "ok", "iye", "hi", "ac",
                    "ine", "e_y", "ro", "nin_", "ağ", "lý", "dir", "lara", "rak_", "e_d", "_n",
                    "ü_", "rý", "n_s", "_ar", "ız", "nı_", "lg", "i_i", "dan_", "üz", "ulu", "n_d",
                    "arak", "rek", "kar", "içi", "e_i", "’", "rt", "_se", "za", "tir", "kle", "he",
                    "eni", "ec", "sın", "rı_", "n_a", "ana", "ğı", "el_", "_ye", "çin", "ný", "iğ",
                    "eğ", "_içi", "ük", "ula", "zi", "lik", "lan_", "ki_", "için", "ine_", "ede",
                    "a_d", "̇", "ş_", "ýl", "ya_", "uru", "lam", "kla", "i̇", "iri", "rle", "re_",
                    "r_a", "nm", "mu", "mas", "ekt", "ren", "kı", "gü", "arı_", "ça", "to", "mü",
                    "_an",
                ],
            ),
            (
                Language::Urdu,
                vec![
                    "ی", "ا", "ر", "ک", "و", "م", "س", "ی_", "_ک", "ے_", "ے", "_م", "ن", "می",
                    "_س", "ں_", "ں", "ل", "ہ", "ب", "گ", "یں_", "یں", "میں_", "میں", "_میں", "_می",
                    "_ا", "ون", "کی", "سو", "ال", "_سو", "_ر", "ٹ", "ع", "سون", "ری", "را", "ت",
                    "_گ", "_سون", "یک", "ک_", "ل_", "ق", "د", "ے_ک", "ٹ_", "ونے_", "ونے", "نے_ک",
                    "نے_", "نے", "سونے", "ار", "ئ", "_ق", "یا", "قی", "ر_", "ای", "_قی", "_ری",
                    "یک_", "یر", "کے_", "کے", "کی_", "ڈ", "ایک_", "ایک", "ال_", "ا_", "_ہ", "_کے_",
                    "_کے", "_ایک", "_ای", "یٹ_", "یٹ", "یال_", "یال", "ہ_", "گرا", "گر", "گئ",
                    "کا", "پ", "می_", "ما", "م_", "ط", "ریال", "ریا", "رک", "خ", "ام", "ئی_", "ئی",
                    "_گرا", "_گر", "_کی_", "_کی", "_ع", "_ریا", "_1", "ے_کے", "یٹ_م", "یراط",
                    "یرا", "ہو", "ھ", "گرام", "گئی_", "گئی", "کیٹ_", "کیٹ", "ک_گ", "ٹ_می", "ٹ_م",
                    "ود", "نرخ", "نر", "مارک", "مار", "م_سو", "م_س", "قیرا", "قیر", "ط_", "رکیٹ",
                    "رکی", "رخ", "رام_", "رام", "راط_", "راط", "ج", "ب_", "ام_س", "ام_", "اط_",
                    "اط", "ارکی", "ارک", "_ہو", "_پ", "_نرخ", "_نر", "_ن", "_مار", "_ما", "_قیر",
                    "_ت", "ے_نر", "ے_ن", "یک_گ", "ی_گ", "ں_م", "کے_ن", "کہ_", "کہ", "کم", "ک_گر",
                    "ڈ_", "وں_", "وں", "ودی_", "ودی", "ف", "عودی", "عود", "عو", "عا", "ط_ای",
                    "ط_ا", "سعود", "سعو", "سع", "س_", "رہ", "دی_", "دی", "جبکہ", "جبک", "جب", "ت_",
                    "بکہ_", "بکہ", "بک", "او", "اط_ا", "_کم", "_کا", "_ف", "_عا", "_ب", "ے_کی",
                    "یمت_", "یمت", "یم", "ی_ما", "ی_م", "ی_قی", "ی_ق", "ی_جب", "ی_ج", "ہے_", "ہے",
                    "ہوگئ", "ہوگ", "ھی", "ں_ک", "ں_می", "کی_ق", "کو_", "کو", "کمی_", "کمی", "کار",
                    "پی", "وں_م", "وگئ", "وگ", "و_", "نرخ_", "می_م", "مت_", "مت", "لمی_", "لمی",
                    "لم", "ل_می", "ل_م", "قیمت", "قیم", "عالم", "عال", "س_س", "ریک", "رخ_", "خ_",
                    "تھ", "المی", "الم", "ال_م", "اب", "_ہوگ", "_گئی", "_گئ", "_کو_", "_کو",
                    "_کمی", "_قیم", "_عال", "_سعو", "_سع", "_رہ", "_د", "_جبک", "_جب", "_ج", "_تھ",
                    "_او", "_2", "8_", "ے_عا", "ے_ع", "ے_س", "یں_ک", "یں_س", "یں_د", "یکار", "یکا",
                    "یک_ا", "یصد_", "یصد", "یص", "یر_ک", "یر_", "یاب_", "یاب", "ی_ہ", "ی_گو",
                    "ی_گئ", "ی_عر", "ی_ع", "ی_س", "ی_تھ", "ی_ت", "ہے_ع", "ہا_", "ہا", "ہ_21",
                    "ہ_2", "ھی_", "ں_کم", "ں_س", "ں_دس", "ں_د", "گولڈ", "گول", "گو", "کی_گ",
                    "کہ_2", "کارڈ", "کا_", "ک_ہو", "ک_ہ", "ک_او", "ک_ا", "ڈالر", "ڈال", "ڈا",
                    "ڈ_کی", "ڈ_ک", "ڈ_ما", "ڈ_م", "چ", "پیر_", "پیر", "پر_", "پر", "ٹ_ک", "وگئی",
                    "ونس_", "ونس", "ونا_", "ونا", "ولڈ_", "ولڈ", "ول", "ور", "وا", "نس_س", "نس_",
                    "نس", "نرخو", "نا_", "نا", "لڈ_م", "لڈ_", "لڈ", "لر_", "لر", "ل_ر", "فیصد",
                    "فیص", "فی", "عرب_", "عرب", "عر", "صد_", "صد", "ص", "سونا", "ستیا", "ستی",
                    "ست", "س_سو", "ز_", "ز", "ریکا", "رہا_", "رہا", "رڈ_ک", "رڈ_", "رڈ", "رو",
                    "رخوں", "رخو", "رب_", "رب", "ر_کو", "ر_ک", "ر_ا", "دی_گ", "دی_ع", "دستی",
                    "دست", "دس", "د_", "خوں_", "خوں", "خو", "ث", "تیاب", "تیا", "تی", "تھی",
                    "تک_ہ", "تک_", "تک", "با", "ب_رہ", "ب_ر", "اونس", "اون", "الر_",
                ],
            ),
            (
                Language::Vietnamese,
                vec![
                    "n", "h", "i", "t", "g", "c", "_t", "n_", "ng", "ng_", "g_", "a", "_c", "m",
                    "u", "o", "l", "i_", "đ", "_đ", "_l", "r", "_n", "nh", "à", "á", "v", "m_",
                    "_g", "t_", "gi", "tr", "hi", "_v", "_gi", "s", "p", "_tr", "d", "ch", "c_",
                    "_h", "k", "h_", "_k", "ế", "o_", "y", "ê", "u_", "th", "_th", "_p", "_m",
                    "_ch", "ên_", "ên", "ph", "nh_", "_s", "_ph", "y_", "n_t", "b", "an", "a_",
                    "_b", "ố", "_nh", "_d", "ạ", "àn", "ệ", "ấ", "ả", "và", "kh", "iế", "e", "_và",
                    "_kh", "ớ", "ề", "ô", "à_", "n_c", "_ng", "ầ", "ất_", "ất", "ại_", "ại", "ư",
                    "đi", "í", "á_", "x", "q", "ng_t", "iá_", "iá", "giá_", "giá", "g_t", "_đi",
                    "_giá", "ứ", "ảm_", "ảm", "qu", "ng_đ", "n_l", "iệ", "iảm_", "iảm", "iả", "ho",
                    "h_t", "giảm", "giả", "g_đ", "_x", "_qu", "_q", "_giả", "_1", "ợ", "ới_", "ới",
                    "ị", "ể", "ế_", "ó", "ên_t", "án", "và_", "trên", "trê", "rên_", "rên", "rê",
                    "phi", "ng_c", "la", "hiế", "g_c", "d_", "ca", "an_", "_và_", "_trê", "_phi",
                    "ỹ_", "ỹ", "ị_", "ến_", "ến", "ầu", "ăng_", "ăng", "ăn", "ă", "â", "án_",
                    "ác_", "ác", "àn_", "xu", "ua", "u_c", "trư", "t_t", "rư", "qua", "p_", "nhi",
                    "ng_k", "ng_b", "mỹ_", "mỹ", "khi", "hứ", "hí", "g_k", "g_b", "ao_", "ao",
                    "_xu", "_trư", "_qua", "_nhi", "_mỹ_", "_mỹ", "_khi", "_ca", "_3", "3_", "ủ",
                    "ồ", "ống_", "ống", "ốn", "ễm_", "ễm", "ễ", "ề_", "ếu_", "ếu", "ế_gi", "ế_g",
                    "ầu_", "ơn_", "ơn", "ơ", "đôla", "đôl", "đô", "đi_x", "đi_", "ôla_", "ôla",
                    "ôl", "ín", "ã", "ày_", "ày", "àng_", "àng", "àn_c", "xuốn", "xuố", "về_",
                    "về", "vàng", "vàn", "uống", "uốn", "uố", "uy", "u_h", "tăng", "tăn", "tă",
                    "toàn", "toà", "to", "phiế", "oàn_", "oàn", "oà", "ong_", "ong", "on", "o_n",
                    "o_d", "nhiễ", "nh_t", "ng_g", "n_to", "n_n", "n_cầ", "mất_", "mất", "mấ",
                    "lên_", "lên", "lê", "lo", "la_", "ki", "iễm_", "iễm", "iễ", "iề", "iếu_",
                    "iếu", "iến_", "iến", "ia", "i_đ", "i_xu", "i_x", "i_ph", "i_p", "i_c", "hế_",
                    "hế", "hơn_", "hơn", "hơ", "hô", "hiệ", "hiễm", "hiễ", "hiếu", "hi_", "g_kh",
                    "g_gi", "g_g", "do_", "do", "cầu", "cầ", "chứ", "ch_", "bi", "anh_", "anh",
                    "_đôl", "_đô", "_đi_", "_xuố", "_về_", "_về", "_vàn", "_tăn", "_tă", "_toà",
                    "_to", "_mất", "_mấ", "_lên", "_lê", "_lo", "_ki", "_hơn", "_hơ", "_do_",
                    "_do", "_cầu", "_cầ", "_chứ", "_bi", "9_", "ừ_", "ừ", "ứng_", "ứng", "ứn",
                    "ức_", "ức", "ờng_", "ờng", "ờn", "ờ", "ổ_", "ổ", "ồng_", "ồng", "ồn", "ốc_",
                    "ốc", "ố_c", "ố_", "ị_tr", "ị_t", "ện", "ểm_", "ểm", "ể_", "ền_", "ền", "ếu_c",
                    "ần_", "ần", "ất_t", "ượ", "ường", "ườn", "ườ", "ũng_", "ũng", "ũn", "ũ",
                    "đồng", "đồn", "đồ", "điểm", "điể", "đang", "đan", "đa", "ôm_q", "ôm_", "ôm",
                    "ó_", "ính_", "ính", "ích_", "ích", "íc", "é", "ây_", "ây", "y_t", "w", "vi",
                    "uất_", "uất", "uấ",
                ],
            ),
            (
                Language::Welsh,
                vec![
                    "y", "d", "a", "n", "e", "r", "i", "o", "l", "h", "g", "_y", "f", "t", "w",
                    "n_", "dd", "u", "m", "s", "c", "d_", "yn", "r_", "_a", "yn_", "yd", "th",
                    "l_", "_g", "u_", "_yn", "_d", "_yn_", "_i", "i_", "ym", "ydd", "_c", "b",
                    "ae", "h_", "y_", "wy", "g_", "ra", "ia", "an", "ol", "ar", "th_", "ei", "dd_",
                    "_y_", "di", "ol_", "_e", "ed", "_n", "gy", "cy", "ai", "_s", "o_", "da",
                    "_cy", "'r_", "'r", "p", "ne", "er", "ith", "it", "au", "_m", "_h", "au_",
                    "od", "n_y", "en", "de", "_p", "_gy", "_f", "ha", "yr", "wyd", "ddi", "mr",
                    "eg", "a_", "ymr", "ll", "fe", "_o", "_i_", "_ar", "ri", "io", "if", "hy",
                    "ad", "_dd", "yn_y", "wn", "s_", "eg_", "rae", "ny", "no", "ew", "_b", "ydd_",
                    "wydd", "gym", "d_y", "_gym", "yf", "eth", "et", "do", "ch", "_a_", "rh",
                    "nydd", "nyd", "la", "ho", "eu", "el", "ef", "at", "yr_", "ymra", "raeg",
                    "mrae", "mra", "me", "ith_", "er_", "aeth", "aet", "aeg_", "aeg", "wn_", "r_g",
                    "nt", "ni", "n_y_", "le", "fa", "aith", "ait", "ys", "yddi", "we", "t_", "si",
                    "ng", "iai", "gymr", "gw", "ga", "g_y", "fn", "ff", "eth_", "efn", "edd", "c_",
                    "ac", "_yr_", "_yr", "_ia", "ro", "nn", "l_y", "iait", "_ne", "_me", "_l",
                    "_hy", "_ei", "wr", "rha", "oed", "oe", "ma", "fnyd", "fny", "eith", "eit",
                    "efny", "defn", "def", "dde", "d_yn", "al", "_w", "_gw", "_da", "sy", "rt",
                    "rif", "rd", "oedd", "n_a", "id", "es", "dol_", "dol", "ar_", "ad_", "_ym",
                    "_o_", "_iai", "y_g", "rth", "re", "r_y", "o'r_", "o'r", "o'", "n_d", "li",
                    "ig", "f_", "ewn", "eu_", "ei_", "cym", "aw", "an_", "_y_g", "_t", "_fe",
                    "_ei_", "_cym", "_ar_", "yw", "un", "te", "ry", "r_gy", "r_a", "pa", "on",
                    "l_i", "i_d", "hw", "gr", "fr", "fo", "dio", "ddo", "ddio", "dda", "dd_y",
                    "cr", "bl", "af", "ac_", "_r", "_dde", "_ac", "'r_g", "yd_", "u_a", "st", "sg",
                    "os", "og", "od_", "new", "na", "mewn", "mew", "io_", "il", "ig_", "gwe", "fy",
                    "fer", "ewn_", "edd_", "dy", "dr", "d_i", "d_a", "_sy", "_si", "_pa", "_new",
                    "_mew", "_ma", "_ga", "_ac_", "u'", "so", "par", "or", "nt_", "my", "ly", "lw",
                    "l_i_", "l_a", "is", "in", "id_", "iad", "hr", "he", "ge", "g_yn", "eg_y",
                    "e_", "dia", "d_e", "cyf", "_rh", "_gwe", "_eu_", "_eu", "_cyf", "yr_a", "yg",
                    "yddo", "y_gy", "y_c", "w_", "u'r_", "u'r", "tr", "ta", "s_y", "rw", "rth_",
                    "rdd", "r_i", "r_ar", "ol_a", "odol", "odo", "odd", "ob", "o_a", "nol", "newy",
                    "n_h", "n_g", "n_f", "n_c", "m_", "ll_", "ic", "iad_", "i_g", "i'", "han",
                    "gu", "gan", "fl", "fer_", "ewyd", "ewy", "ent", "du", "di_", "ddef", "dat",
                    "d_p", "d_c", "cyn", "ch_", "ant", "al_", "_par", "_ll", "_de", "ynn", "yn_e",
                    "yn_d", "ymy", "yl", "yfr", "yfl", "wi", "us", "u_yn", "u_y", "u_p", "t_y",
                    "sa", "rwy", "ru", "rif_", "rhau", "rau_", "rau",
                ],
            ),
        ]
        .into();

        // The more languages we support the less lower the threshold needs to be
        let _ = f.set_threshold(0.01);

        f
    }
}

#[cfg(test)]
mod test {
    use crate::{Language, Lingo, Stemmer, Stopwords};

    #[test]
    fn test_english_stopwords() {
        let stopwords = Language::English.stopwords();
        assert_eq!(true, stopwords.is_some());
        assert_eq!(true, 100 < stopwords.expect("stopwords").len());
    }

    #[test]
    fn test_guarani_stopwords() {
        let stopwords = Language::Guarani.stopwords();
        assert_eq!(true, stopwords.is_none());
    }

    #[test]
    fn test_english_stemmer() {
        let stopwords = Language::English.stemmer();
        assert_eq!(true, stopwords.is_some());
    }

    #[test]
    fn test_guarani_stemmer() {
        let stopwords = Language::Guarani.stemmer();
        assert_eq!(true, stopwords.is_none());
    }

    fn test_expected_language(l: Lingo, sample: &str, expected: Language) {
        if let Some(language) = l.get_language(sample) {
            assert_eq!(expected, language);
        } else {
            panic!(
                "{} -> {}",
                sample,
                if let Some(candidates) = l.get_languages(sample) {
                    candidates
                        .iter()
                        .map(|l| l.0.to_string())
                        .collect::<Vec<String>>()
                        .join(", ")
                } else {
                    "no candidate".into()
                }
            );
        }
    }

    #[test]
    fn test_afrikaans_from_str() {
        assert_eq!(Language::Afrikaans.to_string(), "Afrikaans".to_owned());
    }

    #[test]
    fn test_afrikaans_1() {
        test_expected_language(
                Lingo::new(),
                "Elkeen het die reg tot opvoeding. Opvoeding sal gratis wees, ten minste in die elementêre en fundamentele stadiums. Elementêre opvoeding sal verpligtend wees. Tegniese en professionele opvoeding sal geredelik beskikbaar wees en ho‘r opvoeding sal net so geredelik op meriete beskikbaar wees.",
                Language::Afrikaans
            );
    }

    #[test]
    fn test_afrikaans_2() {
        test_expected_language(
                Lingo::new(),
                "Opvoeding sal gemik wees op die volle ontwikkeling van die menslike persoonlikheid en op die bevordering van respek vir menseregte en fundamentele vryheid. Dit sal begrip, verdraag-saamheid en vriendskap tussen alle nasies, rasse of etniese groepe bevorder, asook die aktiwiteite van die Verenigde Volke in die handhawing van vrede.",
                Language::Afrikaans
            );
    }

    #[test]
    fn test_tamil_from_str() {
        assert_eq!(Language::Tamil.to_string(), "Tamil".to_owned());
    }

    #[test]
    fn test_tamil_1() {
        test_expected_language(
                Lingo::new(),
                "சமுதாயத்தின் பண்பாட்டு வாழ்க்கையிற் சுதந்திரமாகப் பங்குகொள்வதற்கும், கலைகளைத் தூய்ப்பதற்கும் அறிவியல் முன்னேற்றத்திலும், அதன் நன்மைகளிலும் பங்கெடு்ப்பதற்கும் எவருக்கும் உரிமையுண்டு.",
                Language::Tamil
            );
    }

    #[test]
    fn test_tamil_2() {
        test_expected_language(
                Lingo::new(),
                "அறிவியல், இலக்கிய, கலைப் படைப்பின் ஆக்கியற் கர்த்தர் என்ற வகையில் அப்படைப்புகள் வழியாக வரும் ஒழுக்க நெறி, பருப்பொருள் நலங்களின் பாதுகாப்பிற்கு அத்தகையோர் ஒவ்வொருவருக்கும் உரிமை உடையவராவர்.",
                Language::Tamil
            );
    }

    #[test]
    fn test_tamil_3() {
        test_expected_language(Lingo::new(), "உறுப்புரை 27", Language::Tamil);
    }

    #[test]
    fn test_kazakh_from_str() {
        assert_eq!(Language::Kazakh.to_string(), "Kazakh".to_owned());
    }

    #[test]
    fn test_kazakh_1() {
        test_expected_language(
            Lingo::new(),
            "Ас мәзіріндегі ең жақсы тағам қайсысы?",
            Language::Kazakh,
        );
    }

    #[test]
    fn test_kazakh_2() {
        test_expected_language(
            Lingo::new(),
            "Өлкеңіздегі ең жақсы тағам қайсысы",
            Language::Kazakh,
        );
    }

    #[test]
    fn test_kazakh_3() {
        test_expected_language(Lingo::new(), "Мен ет жемеймін.", Language::Kazakh);
    }

    #[test]
    fn test_turkish_from_str() {
        assert_eq!(Language::Turkish.to_string(), "Turkish".to_owned());
    }

    #[test]
    fn test_turkish_1() {
        test_expected_language(
                Lingo::new(),
                "Herkes, topluluğun kültürel faaliyetine serbestçe katılmak, güzel sanatları tatmak, ilim sahasındaki ilerleyişe iştirak etmek ve bundan faydalanmak hakkını haizdir.",
                Language::Turkish
            );
    }

    #[test]
    fn test_turkish_2() {
        test_expected_language(
                Lingo::new(),
                "Herkesin yarattığı, her türlü bilim, edebiyat veya sanat eserlerinden mütevellit manevi ve maddi menfaatlerin korunmasına hakkı vardır.",
                Language::Turkish
            );
    }

    #[test]
    fn test_turkish_3() {
        test_expected_language(
            Lingo::new(),
            "Ana baba, çocuklarına verilecek eğitim türünü seçmek hakkını öncelikle haizdirler.",
            Language::Turkish,
        );
    }

    #[test]
    fn test_azerbaijani_from_str() {
        assert_eq!(Language::Azerbaijani.to_string(), "Azerbaijani".to_owned());
    }

    #[test]
    fn test_azerbaijani_1() {
        test_expected_language(
            Lingo::new(),
            "Mərhəmətli, rəhmli Allahın adı ilə!",
            Language::Azerbaijani,
        );
    }

    #[test]
    fn test_azerbaijani_2() {
        test_expected_language(
                Lingo::new(),
                "Həmd (şükür və tə\'rif) olsun Allaha (və ya: Həmd məxsusdur Allaha) - aləmlərin Rəbbinə,",
                Language::Azerbaijani
            );
    }

    #[test]
    fn test_azerbaijani_3() {
        test_expected_language(
            Lingo::new(),
            " (Bu dünyada hamıya) mərhəmətli, (axirətdə isə ancaq mö\'minlərə) rəhmli olana,",
            Language::Azerbaijani,
        );
    }

    #[test]
    fn test_bulgarian_from_str() {
        assert_eq!(Language::Bulgarian.to_string(), "Bulgarian".to_owned());
    }

    #[test]
    fn test_bulgarian_1() {
        test_expected_language(
                Lingo::new(),
                "Bсеки човек има право на образование. Oбразованието трябва да бъде безплатно, поне що се отнася до началното и основното образование. Hачалното образование трябва да бъде задължително. Tехническото и професионалното образование трябва да бъдат общодостъпни, а висшето образование трябва да бъде еднакво достъпно за всички на основата на техните способности.",
                Language::Bulgarian
            );
    }

    #[test]
    fn test_bulgarian_2() {
        test_expected_language(
                Lingo::new(),
                "Oбразованието трябва да бъде насочено към цялостно развитие на човешката личност и заcилване на уважението към правата на човека и основните свободи",
                Language::Bulgarian
            );
    }

    #[test]
    fn test_bulgarian_3() {
        test_expected_language(
            Lingo::new(),
            "Bсеки човек има право свободно да участва в културния живот на обществото",
            Language::Bulgarian,
        );
    }

    #[test]
    fn test_belarusian_from_str() {
        assert_eq!(Language::Belarusian.to_string(), "Belarusian".to_owned());
    }

    #[test]
    fn test_belarusian_1() {
        test_expected_language(
                Lingo::new(),
                "Кожны чалавек мае права на адукацыю. Адукацыя павiнна быць бясплатнай па меншай меры ў тым, што датычыць пачатковай i агульнай адукацыi. Пачатковая адукацыя павiнна быць абавязковай. Тэхнiчная i прафесiянальная адукацыя павiнна быць агульнадаступнай i вышэйшая адукацыя павiнна быць аднолькава даступнай для ўсiх на падставе здольнасцей кожнага.",
                Language::Belarusian
            );
    }

    #[test]
    fn test_belarusian_2() {
        test_expected_language(
                Lingo::new(),
                "Адукацыя павiнна быць накiравана да поўнага развiцця чалавечай асобы i да павелiчэння павагi да правоў чалавека i асноўных свабод",
                Language::Belarusian
            );
    }

    #[test]
    fn test_belarusian_3() {
        test_expected_language(
            Lingo::new(),
            "Кожны чалавек мае права свабодна ўдзельнiчаць у культурным жыццi грамадства",
            Language::Belarusian,
        );
    }

    #[test]
    fn test_bengali_from_str() {
        assert_eq!(Language::Bengali.to_string(), "Bengali".to_owned());
    }

    #[test]
    fn test_bengali_1() {
        test_expected_language(
                Lingo::new(),
                "প্রত্যেকের‌ই শিক্ষালাভের অধিকার রয়েছে। অন্ততঃপক্ষে প্রাথমিক ও মৌলিক পর্যায়ে শিক্ষা অবৈতনিক হবে। প্রাথমিক শিক্ষা বাধ্যতামূলক হবে। কারিগরী ও বৃত্তিমূলক শিক্ষা সাধারণভাবে লভ্য থাকবে এবং উচ্চতর শিক্ষা মেধার ভিত্তিতে সকলের জন্য সমভাবে উন্মুক্ত থাকবে।",
                Language::Bengali
            );
    }

    #[test]
    fn test_bengali_2() {
        test_expected_language(
                Lingo::new(),
                "ব্যক্তিত্বের পূর্ণ বিকাশ এবং মানবিক অধিকার ও মৌলিক স্বাধীনতা-সমূহের প্রতি শ্রদ্ধাবোধ সুদৃঢ় করার লক্ষ্যে শিক্ষা ",
                Language::Bengali
            );
    }

    #[test]
    fn test_bosnian_from_str() {
        assert_eq!(Language::Bosnian.to_string(), "Bosnian".to_owned());
    }

    #[test]
    fn test_bosnian_1() {
        test_expected_language(
                Lingo::new(),
                "Svako ima pravo na školovanje. Školovanje treba da bude besplatno bar u osnovnim i nižim školama. Osnovna nastava je obavezna. Tehnička i stručna nastava treba da bude opšte dostupna, a viša nastava treba da bude svima podjednako pristupačna na osnovu utvrdjenih kriterijuma.",
                Language::Bosnian
            );
    }

    #[test]
    fn test_bosnian_2() {
        test_expected_language(
            Lingo::new(),
            "Roditelji imaju prvenstveno pravo da biraju vrstu školovanja za svoju decu.",
            Language::Bosnian,
        );
    }

    #[test]
    fn test_estonian_from_str() {
        assert_eq!(Language::Estonian.to_string(), "Estonian".to_owned());
    }

    #[test]
    fn test_estonian_1() {
        test_expected_language(
                Lingo::new(),
                "Igal inimesel on õigus haridusele. Haridus peab olema tasuta vähemalt alg- ja üldhariduse osas. Algharidus peab olema kohustuslik. Tehniline ja kutseharidus peab olema kättesaadav kõigile ja kõrgem haridus võrdselt kättesaadav kõigile vastavalt igaühe võimetele.",
                Language::Estonian
            );
    }

    #[test]
    fn test_estonian_2() {
        test_expected_language(
                Lingo::new(),
                "Haridus peab olema suunatud inimisiksuse täielikule arendamisele ja inimõigustest ning põhivabadustest lugupidamise suurendamisele",
                Language::Estonian
            );
    }

    #[test]
    fn test_estonian_3() {
        test_expected_language(
            Lingo::new(),
            "Vanematel on oma laste hariduse valikul eesõigus.",
            Language::Estonian,
        );
    }

    #[test]
    fn test_czech_from_str() {
        assert_eq!(Language::Czech.to_string(), "Czech".to_owned());
    }

    #[test]
    fn test_czech_1() {
        test_expected_language(
            Lingo::new(),
            "Každý má právo na vzdělání. Vzdělání nechť je bezplatné, ",
            Language::Czech,
        );
    }

    #[test]
    fn test_czech_2() {
        test_expected_language(
            Lingo::new(),
            "Rodiče mají přednostní právo volit druh vzdělání pro své děti.",
            Language::Czech,
        );
    }

    #[test]
    fn test_czech_3() {
        test_expected_language(
                Lingo::new(),
                "Vzdělání má směřovat k plnému rozvoji lidské osobnosti a k posílení úcty k lidským právům a základním svobodám",
                Language::Czech
            );
    }

    #[test]
    fn test_czech_4() {
        test_expected_language(
            Lingo::new(),
            "rozvoji činnosti Spojených národů pro zachování míru.",
            Language::Czech,
        );
    }

    #[test]
    fn test_albanian_from_str() {
        assert_eq!(Language::Albanian.to_string(), "Albanian".to_owned());
    }

    #[test]
    fn test_albanian_1() {
        test_expected_language(
                Lingo::new(),
                "Gjithkush ka të drejtën e shkollimit. Arsimi duhet të jetë falas, të paktën në shkollat fillore dhe të ulta. Arsimi fillor është i detyrueshëm. Arsimi teknik dhe profesional duhet të zgjerohet e arsimi i lartë duhet t\'u bëhet i mundshëm të gjithëve në bazë të aftësisë.",
                Language::Albanian
            );
    }

    #[test]
    fn test_spanish_from_str() {
        assert_eq!(Language::Spanish.to_string(), "Spanish".to_owned());
    }

    #[test]
    fn test_spanish_1() {
        test_expected_language(
                Lingo::new(),
                "En el hotel ¡Ya estoy en el hotel! Ayer por la noche he llegado a la ciudad de Santiago de Compostela. ",
                Language::Spanish
            );
    }

    #[test]
    fn test_spanish_2() {
        test_expected_language(
                Lingo::new(),
                "El hotel está a pocos minutos de la catedral. Hace un mes que he hecho la reserva de la habitación.",
                Language::Spanish
            );
    }

    #[test]
    fn test_spanish_3() {
        test_expected_language(
                Lingo::new(),
                "Y estoy encantado! La habitación es de tamaño mediano. Tiene mucha luz y una gran ventana. ",
                Language::Spanish
            );
    }

    #[test]
    fn test_spanish_4() {
        test_expected_language(
                Lingo::new(),
                "Tengo una cama grande y una gran caja fuerte. Lamentablemente no tiene cuarto de baño propio, pero hay uno común en el pasillo.",
                Language::Spanish
            );
    }

    #[test]
    fn test_spanish_5() {
        test_expected_language(
                Lingo::new(),
                "He realizado el check-in nada más llegar. Los empleados del hotel son muy amables. Me ha atendido una recepcionista que sabía hablar… ¡8 idiomas!",
                Language::Spanish
            );
    }

    #[test]
    fn test_guarani_from_str() {
        assert_eq!(Language::Guarani.to_string(), "Guarani".to_owned());
    }

    #[test]
    fn test_guarani_1() {
        test_expected_language(
                Lingo::new(),
                "Mayma yvypóra ou ko yvy ári iñapytyʼyre ha eteĩcha tekoruvicharenda ha akatúape jeguerekópe; ha ikatu rupi oikuaa añetéva ha añeteʼyva, iporãva ha ivaíva, tekotevẽ pehenguéicha oiko oñondivekuéra",
                Language::Guarani
            );
    }

    #[test]
    fn test_catalan_from_str() {
        assert_eq!(Language::Catalan.to_string(), "Catalan".to_owned());
    }

    #[test]
    fn test_catalan_1() {
        test_expected_language(
                Lingo::new(),
                "Francisco de Goya y Lucientes (Fuendetodos, Saragossa, 30 de març del 1746 - Bordeus, França, 15 d\'abril del 1828) fou un pintor i gravador aragonès. La seva obra comprèn la pintura de cavallet i mural, el gravat i el dibuix. En totes aquestes facetes va desenvolupar un estil que inaugura el romanticisme. La seva contribució representa també el començament de la pintura contemporània, i se\'l considera un precursor de les avantguardes pictòriques del segle XX.",
                Language::Catalan
            );
    }

    #[test]
    fn test_catalan_2() {
        test_expected_language(
                Lingo::new(),
                "La seva obra reflecteix el convuls període històric en què va viure, particularment per les conseqüències de la Guerra de la Independència Espanyola (Guerra del Francès), de la qual ha quedat la sèrie d\'estampes Els estralls de la guerra. Cal destacat també la famosa pintura La maja nua.",
                Language::Catalan
            );
    }

    #[test]
    fn test_catalan_3() {
        test_expected_language(
                Lingo::new(),
                "El claustre d\'estil romànic del Mas del Vent de Palamós és un conjunt arquitectònic suposadament datat del segle XII i que s\'ha considerat procedent de Castella que es troba dins d\'una finca privada des de 1959. La seva troballa va sortir a la premsa a inicis de juny de 2012 gràcies a la investigació de Gerardo Boto, investigador del Departament d\'Història i Història de l\'Art de la Universitat de Girona,[1] tot i que varis documents anteriors ja tenien constància de la seva existència.[2][3] L\'obra està mancada de qualsevol catalogació o protecció.[4]",
                Language::Catalan
            );
    }

    #[test]
    fn test_catalan_4() {
        test_expected_language(
                Lingo::new(),
                "Segons el càlcul de Gerardo Boto, les galeries fan 23,8 i 23,9 metres de llargada. Dues d\'elles presenten deu arcs sobre columnes i capitells dobles, excepte la del mig, que és quàdruple. De les altres dues galeries que acabarien de tancar el claustre de 44 capitells no se\'n conserven columnes ni arcs i els capitells reposen directament sobre les bases.[7] Envoltat de pins, oliveres i garrofers,[8] compta amb un petit teulat de ferro que el protegeix de la humitat.[9]",
                Language::Catalan
            );
    }

    #[test]
    fn test_catalan_5() {
        test_expected_language(
                Lingo::new(),
                "El claustre del Mas del Vent, segons Gerardo Boto, historiador de l\'art nascut a Lleó, és d\'enormes proporcions. Els capitells superen les mides de qualsevol altre conjunt conegut i els arcs fan 3,21 metres des del fust a la clau.[5][6] Alguns capitells mostren figures humanes i gran nombre d\'elements vegetals i animals, sobretot aus, lleons i senglars i monstres, tot i que no hi ha cap motiu religiós.[1][4]",
                Language::Catalan
            );
    }

    #[test]
    fn test_catalan_6() {
        test_expected_language(
                Lingo::new(),
                "El claustre del Mas del Vent, segons Gerardo Boto, historiador de l\'art nascut a Lleó, és d\'enormes proporcions. Els capitells superen les mides de qualsevol altre conjunt conegut i els arcs fan 3,21 metres des del fust a la clau.[5][6] Alguns capitells mostren figures humanes i gran nombre d\'elements vegetals i animals, sobretot aus, lleons i senglars i monstres, tot i que no hi ha cap motiu religiós.[1][4]",
                Language::Catalan
            );
    }

    #[test]
    fn test_catalan_7() {
        test_expected_language(
                Lingo::new(),
                "Xena: Warrior Princess (en català. Xena: la princesa guerrera) és una sèrie de televisió originalment emesa entre el 15 de setembre de 1995 i el 18 de juny de 2001. La sèrie va ser creada el 1995 pels directors i productors Robert Tapert i John Schulian, amb l\'ajuda dels productors Sam Raimi i RJ Stewart. La idea va sorgir a partir de Xena, un personatge secundari de la primera temporada de Hercules: The Legendary Journeys. Rodada a Nova Zelanda, es tracta d\'una coproducció entre aquest país i els Estats Units. La sèrie ha estat produïda per la Pacific Renaissance Pictures Ltd, els creadors són Robert Tapert i Sam Raimi, productors de la sèrie i fou distribuïda per Universal Studios. La sèrie, ambientada a l\'Antiga Grècia, narra les aventures de Xena (Lucy Lawless) i Gabrielle (Renée O\'Connor), dos grans guerreres i inseparables amigues que lluiten contra les injustícies de l\'època.",
                Language::Catalan
            );
    }

    #[test]
    fn test_catalan_8() {
        test_expected_language(
                Lingo::new(),
                "La sèrie es va mantenir en l\'aire durant sis temporades als Estats Units, entre 1995 i 2001, convertint-se en la més reeixida de les sèries sindicades del moment i arribant a ser un autèntic fenomen social al llarg de tot el món .De fet, és considerada una de les millors sèries de la història per la revista TV Guide i, avui dia, el fanatisme per la sèrie continua actiu a Internet. Aquesta sèrie d\'aventures, vista en més de vuitanta-sis països dels cinc continents, ha rebut diversos premis, incloent un Emmy. A més, aprofitant l\'èxit de la mateixa, s\'han comercialitzat nombrosos productes sobre ella, com ara episodis en DVD, una pel·lícula, llibres, còmics o videojocs. La influència de la sèrie fora de la pantalla arriba a sectors com la comunitat lèsbica o la astronòmica, així com a altres sèries de televisió i pel·lícules.",
                Language::Catalan
            );
    }

    #[test]
    fn test_dutch_from_str() {
        assert_eq!(Language::Dutch.to_string(), "Dutch".to_owned());
    }

    #[test]
    fn test_dutch_1() {
        test_expected_language(
                Lingo::new(),
                "Het Nederlands is een West-Germaanse taal en de moedertaal van de meeste inwoners van Nederland, België en Suriname, de drie lidstaten van de Nederlandse Taalunie, een internationale instelling die onder meer de regels voor de Nederlandse standaardtaal vastlegt. In de Europese Unie spreken ongeveer 23 miljoen mensen Nederlands als eerste taal, en een bijkomende vijf miljoen als tweede taal. Verder is het Nederlands ook een officiële taal van de Caraïbische eilanden Aruba, Curaçao en Sint-Maarten, terwijl er nog minderheden bestaan in Frankrijk, Duitsland en in mindere mate Indonesië, en nog ruim een half miljoen sprekers in de Verenigde Staten, Canada en Australië. De Kaap-Hollandse dialecten van Zuid-Afrika en Namibië werden gestandaardiseerd tot Afrikaans, een wederzijds verstaanbare dochtertaal van het Nederlands.",
                Language::Dutch
            );
    }

    #[test]
    fn test_dutch_2() {
        test_expected_language(
                Lingo::new(),
                "Het Nederlands is nauw verwant aan het Engels en Duits, en wordt tussen beide geplaatst. Naast het feit dat het Nederlands de Hoogduitse klankverschuiving niet heeft ondergaan, verschilt het Nederlands – net als het Engels – verder ook van het Duits door de sterke reductie van de naamvallen, de algemene zeldzaamheid van de Germaanse umlaut en een meer regelmatige morfologie. Het moderne Nederlands heeft in oorsprong drie grammaticale geslachten, waarvan er twee in de praktijk grotendeels samenvallen (de de-woorden). Bijgevolg speelt het grammaticale geslacht een kleinere grammaticale rol dan in het Duits. De Nederlandse woordvolgorde is onderwerp-werkwoord-lijdend voorwerp (SVO) in hoofdzinnen maar past, net als in het Duits, inversie toe in bijzinnen (SOV). Het Nederlands kent een hoofdzakelijk Germaanse woordenschat, in grotere mate dan het sterk geromaniseerde Engels, maar aangevuld door een grotere Romaanse component dan in het Duits.",
                Language::Dutch
            );
    }

    #[test]
    fn test_english_from_str() {
        assert_eq!(Language::English.to_string(), "English".to_owned());
    }

    #[test]
    fn test_english_1() {
        test_expected_language(
                Lingo::new(),
                "SEOUL, South Korea (AP) — The outside world focuses on the messages of doom and gloom from North Korea: bombastic threats of nuclear war, fantasy videos of U.S. cities in flames, digitally altered photos of leader Kim Jong Un guiding military drills. But back home, North Koreans get a decidedly softer dose of propaganda: Kim portrayed as a young, energetic leader, a people person and family man.",
                Language::English
            );
    }

    #[test]
    fn test_english_2() {
        test_expected_language(
                Lingo::new(),
                "Mixed in with the images showing Kim aboard a speeding boat on a tour of front-line islands, or handing out commemorative rifles to smartly saluting soldiers, are those of Kim and his wife clapping at a dolphin show or linking arms with weeping North Korean children",
                Language::English
            );
    }

    #[test]
    fn test_english_3() {
        test_expected_language(
                Lingo::new(),
                "The pictures can look odd or obviously staged to outsiders. But they\'re carefully crafted propaganda meant to give North Koreans an image of a country governed by a leader who is as comfortable overseeing a powerful military as he is mingling with the people.",
                Language::English
            );
    }

    #[test]
    fn test_english_4() {
        test_expected_language(
                Lingo::new(),
                "Views are the V in MVC. Views are responsible for generating the specific output required for the request. Often this is in the form of HTML, XML, or JSON, but streaming files and creating PDF’s that users can download are also responsibilities of the View Layer.",
                Language::English
            );
    }

    #[test]
    fn test_english_5() {
        test_expected_language(
                Lingo::new(),
                "CakePHP comes with a few built-in View classes for handling the most common rendering scenarios",
                Language::English
            );
    }

    #[test]
    fn test_english_6() {
        test_expected_language(
                Lingo::new(),
                "View extending allows you to wrap one view in another. Combining this with view blocks gives you a powerful way to keep your views DRY. For example, your application has a sidebar that needs to change depending on the specific view being rendered. By extending a common view file you can avoid repeating the common markup for your sidebar, and only define the parts that change",
                Language::English
            );
    }

    #[test]
    fn test_esperanto_from_str() {
        assert_eq!(Language::Esperanto.to_string(), "Esperanto".to_owned());
    }

    #[test]
    fn test_esperanto_1() {
        test_expected_language(
                Lingo::new(),
                "Lucy LAWLESS, naskiĝis kiel Lucille Frances Ryan (* 29-a de marto 1968 en Mount Albert, Nov-Zelando) estas novzelanda aktorino.",
                Language::Esperanto
            );
    }

    #[test]
    fn test_esperanto_2() {
        test_expected_language(
                Lingo::new(),
                "Ŝi iĝis mondkonata en la rolo de Xena, kiel ĉefrolulo de la televida serio. Ŝi ankaŭ rolludis en etaj roloj, kiel en la kineja filmo \"Spiderman\" aŭ en la TV-serio \"Tarzan\" en 2002. Ŝi ankaŭ donis sian voĉon ĉe \"The Simpsons\".",
                Language::Esperanto
            );
    }

    #[test]
    fn test_esperanto_3() {
        test_expected_language(
            Lingo::new(),
            "Ŝi estas edziniĝinta ekde 1998 kun Robert G. Tapert, produktisto de la serio \"Xena\"",
            Language::Esperanto,
        );
    }

    #[test]
    fn test_esperanto_4() {
        test_expected_language(
                Lingo::new(),
                "Laŭ sagao, la urbo (Barcino) estis fondita de Hamilkar Barka, patro de Hanibal Barka el Kartago. Post tio trakonstruis la urbon la romianoj al fortikaĵo (castrum). La centro de la urbo kuŝis sur Mons Taber, sur malgranda monteto proksime al la tiama Konsildomo (Plaça de Sant Jaume). Oni povas ankoraŭ hodiaŭ trovi restaĵojn de la romia urbomuro en la praurba parto. Gravaj romiaj trovitaĵoj estas ekspoziciitaj ĉe Plaça del Rei. En la 5-a jarcento la urbon konkeris visigotoj, en la 8-a jc. la maŭroj. En 801 konkeris la urbon la franca reĝo. Je 985 disrabis Barcelonon Al-Mansur, armeestro de Kordovo.",
                Language::Esperanto
            );
    }

    #[test]
    fn test_esperanto_5() {
        test_expected_language(
                Lingo::new(),
                "En la mezepoko Barcelono estis ĉefurbo de Reĝlando de Aragono kaj elstara mara kaj komerca potenco en la okcidenta Mediteranea maro, kun gravaj posedaĵoj, kiel Sardio kaj Sicilio. Ekde la 15-a jarcento, post la Kompromiso de Caspe (1412) kaj la enlanda milito (1462-1472), la urbo perdis potencon, unue favore al Valencio kaj poste al kastiliaj urboj. La malvenko en la milito de postveno de Hispanio (1701-1714) kaj la postaj reprezalioj de Filipo la 5-a de Kastilio plimalfortigis kaj katenis la urbon ĝis meze de la 19-a jarcento, kiam estiĝis permeso malkonstrui la urbomurojn.",
                Language::Esperanto
            );
    }

    #[test]
    fn test_esperanto_6() {
        test_expected_language(
                Lingo::new(),
                "La ekonomia bonfarto permesis rapidegan plilarĝigon de la urbo, kiu ensorbis diversajn antaŭurbojn kiel Sants, Gràcia kaj Sarrià. Partoj de la urbo aldoniĝis post eventoj, kiel la internaciaj ekspozicioj de 1888 kaj 1929, la Olimpikaj ludoj (1992) aŭ la Forumo de la Kulturoj (2004).",
                Language::Esperanto
            );
    }

    #[test]
    fn test_irish_from_str() {
        assert_eq!(Language::Irish.to_string(), "Irish".to_owned());
    }

    #[test]
    fn test_irish_1() {
        test_expected_language(
            Lingo::new(),
            "Tá ag gach uile dhuine an ceart chun an oideachais.",
            Language::Irish,
        );
    }

    #[test]
    fn test_irish_2() {
        test_expected_language(
                Lingo::new(),
                "Tá ag na tuismitheoirí, i dtosach ar chách eile, an ceart chun an cineál oideachais a thoghadh a bhéarfar dá leanaí",
                Language::Irish
            );
    }

    #[test]
    fn test_welsh_from_str() {
        assert_eq!(Language::Welsh.to_string(), "Welsh".to_owned());
    }

    #[test]
    fn test_welsh_1() {
        test_expected_language(
                Lingo::new(),
                "Y mae gan bawb hawl i addysg. Dylai addysg fod yn rhydd, o leiaf addysg elfennol a sylfaenol. Dylai addysg elfennol fod yn orfodol. Dylid gwneud addysg dechnegol a phroffesiynol yn agored i bawb, a dylai fod mynediad llawn a chydradd i bawb i addysg uwchradd ar sail teilyngdod",
                Language::Welsh
            );
    }

    #[test]
    fn test_welsh_2() {
        test_expected_language(
            Lingo::new(),
            "Gan rieni y mae\'r hawl cyntaf i ddewis y math o addysg a roddir i\'w plant.",
            Language::Welsh,
        );
    }

    #[test]
    fn test_gujarati_from_str() {
        assert_eq!(Language::Gujarati.to_string(), "Gujarati".to_owned());
    }

    #[test]
    fn test_gujarati_1() {
        test_expected_language(
            Lingo::new(),
            "પોતાનાં બાળકોને કયા પ્રકારનું શિક્ષણ આપવું તે પસંદ કરવાનો પ્રથમ અધિકાર માબાપોને રહેશે.",
            Language::Gujarati,
        );
    }

    #[test]
    fn test_hungarian_from_str() {
        assert_eq!(Language::Hungarian.to_string(), "Hungarian".to_owned());
    }

    #[test]
    fn test_hungarian_1() {
        test_expected_language(
                Lingo::new(),
                "Minden személynek joga van a neveléshez. A nevelésnek, legalábbis az elemi és alapvető oktatást illetően, ingyenesnek kell lennie. Az elemi oktatás kötelező. A technikai és szakoktatást általánossá kell tenni; a felsőbb tanulmányokra való felvételnek mindenki előtt -érdeméhez képest- egyenlő feltételek mellett nyitva kell állnia.",
                Language::Hungarian
            );
    }

    #[test]
    fn test_hungarian_2() {
        test_expected_language(
            Lingo::new(),
            "A szülőket elsőbbségi jog illeti meg a gyermekeiknek adandó nevelés megválasztásában.",
            Language::Hungarian,
        );
    }

    #[test]
    fn test_indonesian_from_str() {
        assert_eq!(Language::Indonesian.to_string(), "Indonesian".to_owned());
    }

    #[test]
    fn test_indonesian_1() {
        test_expected_language(
            Lingo::new(),
            " Setiap orang berhak mendapat pendidikan",
            Language::Indonesian,
        );
    }

    #[test]
    fn test_indonesian_2() {
        test_expected_language(
                Lingo::new(),
                "Orang-tua mempunyai hak utama untuk memilih jenis pendidikan yang akan diberikan kepada anak-anak mereka.",
                Language::Indonesian
            );
    }

    #[test]
    fn test_indonesian_3() {
        test_expected_language(
                Lingo::new(),
                "Pendidikan harus ditujukan ke arah perkembangan pribadi yang seluas-luasnya serta memperkokoh rasa penghargaan terhadap hak-hak manusia dan kebebasan asasi",
                Language::Indonesian
            );
    }

    #[test]
    fn test_georgian_from_str() {
        assert_eq!(Language::Georgian.to_string(), "Georgian".to_owned());
    }

    #[test]
    fn test_georgian_1() {
        test_expected_language(
                Lingo::new(),
                "ყოველ ადამიანს აქვს განათლების უფლება. განათლება დაწყებითი და ზოგადი მაინც, უფასო უნდა იყოს. დაწყებითი განათლება უნდა იყოს სავალდებულო. ტექნიკური და პროფესიული განათლება უნდა იყოს ხელმისაწვდომი, უმაღლესი განათლება კი - ერთაირად მისაწვდომი ყველასათვის თითოეულის უნარისამბერ",
                Language::Georgian
            );
    }

    #[test]
    fn test_georgian_2() {
        test_expected_language(
                Lingo::new(),
                "მშობლებს აქვთ პრიორიტეტის უფლება აირჩიონ რა სახის განათლებაც სურთ თავიანთი მცირეწლოვანი შვილებისათვის.",
                Language::Georgian
            );
    }

    #[test]
    fn test_icelandic_from_str() {
        assert_eq!(Language::Icelandic.to_string(), "Icelandic".to_owned());
    }

    #[test]
    fn test_icelandic_1() {
        test_expected_language(
                Lingo::new(),
                "Hver maður á rétt til menntunar. Skal hún veitt ókeypis, að minnsta kosti barnafræðsla og undirstöðummentu. Börn skulu vera skólaskyld. Iðnaðar- og verknám skal öllum standa til boða og æðri menntu vera öllum jafnfrjáls, þeim er hæfileika hafa til að njóta hennar.",
                Language::Icelandic
            );
    }

    #[test]
    fn test_icelandic_2() {
        test_expected_language(
                Lingo::new(),
                "Menntun skal beina í þá átt að þroska persónuleika einstaklinganna og innræta þeim virðingu fyrir mannréttindum og mannhelgi. Hún skal miða að því að efla skilning, umburðarlyndi og vináttu meðal allra þjóða, kynþátta og trúarflokka og að efla starf Sameinuðu þjóðanna í þágu friðarins.",
                Language::Icelandic
            );
    }

    #[test]
    fn test_icelandic_3() {
        test_expected_language(
            Lingo::new(),
            "Foreldrar skulu fremur öðrum ráða, hverrar menntunar börn þeirra skuli njóta.",
            Language::Icelandic,
        );
    }

    #[test]
    fn test_armenian_from_str() {
        assert_eq!(Language::Armenian.to_string(), "Armenian".to_owned());
    }

    #[test]
    fn test_armenian_1() {
        test_expected_language(
                Lingo::new(),
                "1Եթէ խօսեմ մարդկանց լեզուները եւ հրեշտակներինը, բայց սէր չունենամ, կը նմանուեմ մի պղնձի, որ հնչում է, կամ՝ ծնծղաների, որ ղօղանջում են։",
                Language::Armenian
            );
    }

    #[test]
    fn test_armenian_2() {
        test_expected_language(
            Lingo::new(),
            "եւ եթէ ունենամ ամբողջ հաւատը՝ մինչեւ իսկ լեռները տեղափոխելու չափ",
            Language::Armenian,
        );
    }

    #[test]
    fn test_euskara_from_str() {
        assert_eq!(Language::Euskara.to_string(), "Euskara".to_owned());
    }

    #[test]
    fn test_euskara_1() {
        test_expected_language(
                Lingo::new(),
                "Eskozia (ingelesez eta scotseraz Scotland; Eskoziako gaeleraz Alba) Erresuma Batua osatzen duten lau herrialdeetatik iparraldeena kokatzen dena da. Ingalaterra eta Galesekin batera Britainia Handiko Uhartea osatzen dute, Eskoziak lurralde honen heren bat hartzen du eta 790 uharte baino gehiago ditu. Ipar eta mendebaldean Ozeano Atlantikoarekin mugatzen du, ekialdean Ipar Itsasoarekin, hegoaldean Ingalaterrarekin eta azkenik hego-mendebaldean Iparraldeko kanala eta Irlandako itsasoarekin. Eskoziar lurraldea 78.772 km2-tan hedatzen da eta bere biztanleria gutxi-gorabehera 5.116.900 biztanletakoa da, honek km2-ko 65 biztanleko dentsitatea ematen duelarik. Hiriburua Edinburgh da, aldiz hiririk handiena Glasgow, azken honen hiriguneak eskoziar biztanlegoaren %20a osatzen duelarik.",
                Language::Euskara
            );
    }

    #[test]
    fn test_euskara_2() {
        test_expected_language(
                Lingo::new(),
                "1707 urterarte Eskoziako Erresuma independientea izan zen, data honetan Britainia Handia sortzeko Ingalaterrarekin Batasun Agiria sinatu zelarik. Batasunak ez zuen Eskoziako berezko sistema legal edo judizialaren aldaketarik suposatu, hau ordudanik Gales, Ingalaterra eta Ipar Irlandakotik ezberdina delarik, honenbestez nazioarteko zuzenbidean erakunde juridiko ezberdintzat onartu eta hartzen da. Berezko legeen biziraupena jaso da, baita eskoziar kulturako zati diren hezkuntza eta erlijio sistema ezberdinak, hauek mendeetan zehar garatu direlarik. XIX. mendean sortua, eskoziar independentismoa eragina eta indarra pilatuz joan da, batez ere XX. mendearen amaieratik aurrera, eta Scottish National Party (SNP, Eskoziako Alderdi Nazionala) alderdia ordezkari duela. Alderdi horren helburu nagusia Eskoziaren independentzia da eta 2011ko Eskoziar Parlamenturako hauteskundeetan gehiengo absolutua lortu zuen.",
                Language::Euskara
            );
    }

    #[test]
    fn test_euskara_3() {
        test_expected_language(
                Lingo::new(),
                "Meneame.net taldeko adimena erabiliz albisteak ezagutarazteko balio duen gaztelaniazko bloga da. Erregistratutako erabiltzaileek gainontzekoek (erregistratuta edo gabe) bozka ditzaketen albisteak bidal ditzakete webgunera, boto gehien dituzten albisteak azalera pasako direlarik. Proiektu honen garatzailea Ricardo Galli da, Balear Uharteetako Unibertsitateko irakaslea.",
                Language::Euskara
            );
    }

    #[test]
    fn test_euskara_4() {
        test_expected_language(
                Lingo::new(),
                "Web 2.0 proiektu bat da, Digg.com-en ideia berean oinarrituz. Hala eta guztiz ere, azken honek ez bezala, karma bezalako kontzeptuak ere baditu. Karma erabiltzaile batek duen puntuazioa da, bere partehartzea eta lan onaren ondorioz handituz doana.",
                Language::Euskara
            );
    }

    #[test]
    fn test_euskara_5() {
        test_expected_language(
            Lingo::new(),
            "Meneame.neten oinarrituta, eta euskaraz, Zabaldu.com egitasmoa dugu.",
            Language::Euskara,
        );
    }

    #[test]
    fn test_chinese_from_str() {
        assert_eq!(Language::Chinese.to_string(), "Chinese".to_owned());
    }

    #[test]
    fn test_chinese_1() {
        test_expected_language(
                Lingo::new(),
                "在欧冠小组赛第二轮与鲍里索夫（白俄罗斯球队）的对阵中，梅西独中两元，并造成对方打进一个乌龙球，最终使得巴塞5-0大胜对手。本场比赛后，梅西以194个进球，追平库巴拉成为巴塞罗那足球俱乐部历史上的第二射手。其後在作客捷克的比尔森胜利時再演帽子戲法協助球隊作客4比0大勝，本场比赛后，美斯突破200球。在主场5:0战胜利雲特的比赛中，梅西打入1球，本场比赛是梅西代表巴塞罗那一队正式参加的第292场的比赛，至此，梅西追平菲利普·科库，并列成为代表巴塞罗那俱乐部出场次数最多的外籍球员。",
                Language::Chinese
            );
    }

    #[test]
    fn test_persian_from_str() {
        assert_eq!(Language::Persian.to_string(), "Persian".to_owned());
    }

    #[test]
    fn test_persian_1() {
        test_expected_language(
                Lingo::new(),
                "ابوجعفر خازن خراسانی ستاره‌شناس و ریاضی‌دان ایرانی[۱] است که در قرن چهارم هجری قمری در خراسان می‌زیست. از او کتاب‌هایی در این دو علم در دست است. وی به کمک مقاطع مخروطی، معادلهٴ درجه سوم را که به معادلهٴ ماهانی موسوم است حل کرد. در مابین سال‌های ۹۶۱ و ۹۷۱ میلادی درگذشت.",
                Language::Persian
            );
    }

    #[test]
    fn test_persian_2() {
        test_expected_language(
                Lingo::new(),
                "خراسان (خراسان بزرگ یا خراسان باستانی یا خراسان تاریخی) سرزمینی بزرگ‌تر از خراسان امروزی، بخشی از ایران بزرگ و از دوران ایران ساسانی نامی سنتی و همگانی برای اشاره به نواحی شرقی ایران است. ساسانیان سرزمین ایران را چهار بخش کرده بودند که یکی از آن بخش‌ها خراسان به معنای «سرزمین خورشید» بود.[۲][۳] گسترهٔ تاریخی خراسان بزرگ استان خراسان در ایران کنونی و بخش‌های شمالی و باختری افغانستان و ترکمنستان امروزی را در بر می‌گرفت. در مفهوم گسترده‌تر ازبکستان و تاجیکستان و بخش‌هایی از قرقیزستان و قزاقستان را هم می‌توان در خراسان بزرگ تاریخی برشمرد.[۴]",
                Language::Persian
            );
    }

    #[test]
    fn test_japanese_from_str() {
        assert_eq!(Language::Japanese.to_string(), "Japanese".to_owned());
    }

    #[test]
    fn test_japanese_1() {
        test_expected_language(
            Lingo::new(),
            "どうした報道ステーション？OBとしてもあまりに悲しい「”女性を馬鹿にした”番組 ",
            Language::Japanese,
        );
    }

    #[test]
    fn test_japanese_2() {
        test_expected_language(
                Lingo::new(),
                "呉座氏は、ベストセラー「応仁の乱」で知られる日本中世史が専門の歴史学者。「鎌倉殿の13人」は三谷幸喜さんが脚本を担当し、鎌倉幕府の2代執権北条義時を描く。主演の義時を小栗旬さんが演じる",
                Language::Japanese
            );
    }

    #[test]
    fn test_japanese_3() {
        test_expected_language(
            Lingo::new(),
            "などと批判の声が上がっていた",
            Language::Japanese,
        );
    }

    #[test]
    fn test_greek_from_str() {
        assert_eq!(Language::Greek.to_string(), "Greek".to_owned());
    }

    #[test]
    fn test_greek_1() {
        test_expected_language(
                Lingo::new(),
                "Τρεις Έλληνες που ζουν στο Ισραήλ περιγράφουν την πρώτη φάση επιστροφής στην κανονικότητα.",
                Language::Greek
            );
    }

    #[test]
    fn test_greek_2() {
        test_expected_language(
                Lingo::new(),
                "Κάτι που μοιάζει σαν αιωνιότητα –η πανδημία κορωνοϊού που «έσκασε» στα χέρια του πλανήτη πριν από περίπου έναν χρόνο",
                Language::Greek
            );
    }

    #[test]
    fn test_hindi_from_str() {
        assert_eq!(Language::Hindi.to_string(), "Hindi".to_owned());
    }

    #[test]
    fn test_hindi_1() {
        test_expected_language(
                Lingo::new(),
                "नई दिल्ली, एजेंसी। उत्तर भारत के पहाड़ी राज्यों में पिछले 2 दिनों से भारी बारिश और बर्फबारी हो रही है। जम्मू और कश्मीर के ऊपर बना पश्चिमी विक्षोभ पूर्वी दिशा में आगे बढ़ता रहेगा। साथ ही चक्रवाती सिस्टम हरियाणा और दिल्ली के ऊपर पहुंच जाएगा। स्काईमेट वेदर के मुताबिक इन दोनों सिस्टमों के कारण उत्तर भारत के पहाड़ी राज्यों के साथ-साथ मैदानी इलाकों में आज भी मौसमी गतिविधियां जारी रहेंगी और कुछ हिस्सों में ओलावृष्टि की संभावना है। राजस्थान के बाद पंजाब, हरियाणा और दिल्ली समेत उत्तर के मैदानी इलाकों से गुरुवार से मौसम साफ हो जाएगा। पहाड़ों पर गतिविधियां जारी रहेंगी और 25 मार्च से मौसम साफ होने की संभावना है।,",
                Language::Hindi
            );
    }

    #[test]
    fn test_hindi_2() {
        test_expected_language(
            Lingo::new(),
            "परमबीर सिंह की याचिका पर सुप्रीम कोर्ट में आज सुनवाई, सीबीआइ जांच की मांग",
            Language::Hindi,
        );
    }

    #[test]
    fn test_russian_from_str() {
        assert_eq!(Language::Russian.to_string(), "Russian".to_owned());
    }

    #[test]
    fn test_russian_1() {
        test_expected_language(
            Lingo::new(),
            "Болеющий коронавирусом Иван Ургант продолжил работать",
            Language::Russian,
        );
    }

    #[test]
    fn test_russian_2() {
        test_expected_language(
                Lingo::new(),
                "Телеведущий сказал, что он сидит на даче один в самоизоляции после получения положительного теста на коронавирус - семьи с ним нет.",
                Language::Russian
            );
    }

    #[test]
    fn test_vietnamese_from_str() {
        assert_eq!(Language::Vietnamese.to_string(), "Vietnamese".to_owned());
    }

    #[test]
    fn test_vietnamese_1() {
        test_expected_language(
            Lingo::new(),
            "Dự án Grand Marina Saigon \'chào sân\' thị trường quốc tế",
            Language::Vietnamese,
        );
    }

    #[test]
    fn test_vietnamese_2() {
        test_expected_language(
                Lingo::new(),
                "Đại sứ EU nói Việt Nam là nước có tiềm năng được chuyển giao công nghệ sản xuất vaccine Covid-19, dù vấn đề này chưa được thảo luận.",
                Language::Vietnamese
            );
    }

    #[test]
    fn test_vietnamese_3() {
        test_expected_language(
                Lingo::new(),
                "Dự án căn hộ hạng sang Grand Marina Saigon được nhà phát triển Masterise Homes giới thiệu tại Hong Kong, mở đường chinh phục nhà đầu tư quốc tế.",
                Language::Vietnamese
            );
    }

    #[test]
    fn test_urdu_from_str() {
        assert_eq!(Language::Urdu.to_string(), "Urdu".to_owned());
    }

    #[test]
    fn test_urdu_1() {
        test_expected_language(
                Lingo::new(),
                "سعودی محکمہ پاسپورٹ نے سعودی شہریوں اور مقیم غیرملکیوں سے پھر کہا ہے کہ وہ مملکت کے تمام علاقوں میں محکمہ پاسپورٹ کے ڈائریکٹر جنرل سے ویڈیو کالنگ سروس سے استفادہ کریں۔ ",
                Language::Urdu
            );
    }

    #[test]
    fn test_urdu_2() {
        test_expected_language(
                Lingo::new(),
                "سیدتی میگزین کے مطابق محکمہ پاسپورٹ نے ٹوئٹر کے اکاؤنٹ پر کہا کہ سعودی عرب کے تمام علاقوں کے پاسپورٹ دفاتر میں ڈائریکٹر جنرل سے وڈیو کال کی سہولت مقامی شہریوں اور مقیم غیرملکیوں کو ڈیجیٹل پلیٹ فارمز کے ذریعے خدمات کا معیار بہتر بنانے کی غرض سے متعارف کرائی گئی ہے۔",
                Language::Urdu
            );
    }
}
