/// This file is automatically generated by `build.rs`. Any changes made here will be
/// lost forever.
///
/// Any modification must be done in `lib.tpl.rs` and it will be compiled automatically
/// by build.rs
use crate::{stopwords::StopwordsTrait, stemmer::StemmerTrait};
use rust_stemmers::{Algorithm, Stemmer};
use std::collections::HashSet;
use std::str::FromStr;
use stopwords::{Stopwords, NLTK};
use strum::IntoEnumIterator;
use strum_macros::{Display, EnumIter};
use textcat::storage::FileContent;

#[derive(Clone, Debug, EnumIter, Eq, Display, PartialEq, Hash, Ord, PartialOrd)]
pub enum Language {
    {% for lang in languages %}
        {{lang|capitalize}},{% endfor %}
}

impl Language {
    pub fn name(&self) -> &'static str {
        match self {
            {% for lang in languages %}
            Self::{{lang|capitalize}} => "{{lang}}",{% endfor %}
        }
    }

    pub fn all() -> HashSet<Language> {
        Language::iter().collect()
    }
}

impl StopwordsTrait for Language {
    fn stopwords(&self) -> Option<&'static [&'static str]> {
        match self {
        {% for lang in stopwords %}
            Self::{{lang}} => NLTK::stopwords(stopwords::Language::{{lang}}),{% endfor %}
            _ => None
        }
    }
}

impl StemmerTrait for Language {
    fn stemmer(&self) -> Option<Stemmer> {
        match self {
        {% for lang in stemmers %}
            Self::{{lang}} => Some(Stemmer::create(Algorithm::{{lang}})),{% endfor %}
            _ => None
        }

    }
}

impl FromStr for Language {
    type Err = String;

    fn from_str(name: &str) -> Result<Language, String> {
        match name.to_lowercase().as_str() {
        {% for lang in languages %}
            "{{lang}}" => Ok(Self::{{lang|capitalize}}),{% endfor %}
        _ => Err("Invalid argument".to_string()),
        }
    }
}

pub struct Lingo {
    built_in: FileContent,
}

#[allow(clippy::new_without_default)]
impl Lingo {
    pub fn new() -> Self {
        Lingo {
            built_in: Self::get_embed_languages(),
        }
    }
    
    pub fn get_language(&self, sample: &str) -> Option<Language> {
        self.built_in
            .get_category(sample)
            .map(|r| Language::from_str(r.as_str()).unwrap())
    }

    pub fn get_languages(&self, sample: &str) -> Option<Vec<(Language, u64)>> {
        Some(self.built_in
            .get_categories(sample)?
            .iter()
            .map(|r| (Language::from_str(&r.0).unwrap(), r.1))
            .collect()
        )
    }

    #[allow(unused_must_use)]
    #[allow(clippy::invisible_characters)]
    pub fn get_embed_languages() -> FileContent {
        let mut f = FileContent::from_vec(vec![
        {% for c in ngrams %}
            (
                Language::{{c.0|capitalize}}.name(),
                vec![
                {% for ngram in c.1|slice(end=400) %}
                    "{{ngram}}",{% endfor %}
                ]
            ),{% endfor %}
        ]
        );

        // The more languages we support the less lower the threshold needs to be
        f.set_threshold(0.01);

        f
    }
}

mod test {
    #[allow(unused_imports)]
    use crate::{Language, Lingo, Stopwords, Stemmer};

    #[test]
    fn test_english_stopwords() {
        let stopwords = Language::English.stopwords();
        assert_eq!(true, stopwords.is_some());
        assert_eq!(true, 100 < stopwords.unwrap().len());
    }

    #[test]
    fn test_guarani_stopwords() {
        let stopwords = Language::Guarani.stopwords();
        assert_eq!(true, stopwords.is_none());
    }

    #[test]
    fn test_english_stemmer() {
        let stopwords = Language::English.stemmer();
        assert_eq!(true, stopwords.is_some());
    }

    #[test]
    fn test_guarani_stemmer() {
        let stopwords = Language::Guarani.stemmer();
        assert_eq!(true, stopwords.is_none());
    }

    {% for test in tests %}
        #[test]
        fn test_{{test['category']}}_from_str() {
            assert_eq!(Language::{{test['category']|capitalize}}.name(), "{{test['category']|addslashes}}");
        }

        {% set i = loop.index %}
        {% for text in test['fixtures'] %}
        #[test]
        fn test_{{test['category']}}_{{loop.index}}() {
            let l = Lingo::new();
            let sample = "{{text|addslashes}}";
            let language = l.get_language(sample);

            if language.is_none() {
                panic!(
                    "{} -> {}",
                    sample,
                    l.get_languages(sample).unwrap().iter().map(|l| l.0.name()).collect::<Vec<&str>>().join(", ")
                );
            }

            assert_eq!(
                Language::{{test['category']|capitalize}},
                language.unwrap()
            );
        }
        {% endfor %}
    {% endfor %}
}
