
# Lightningd

Utility to run a regtest lightningd process, useful in integration testing environment.

```rust
let bitcoind_exe = bitcoind::exe_path().expect("bitcoind version feature must be enabled or BITCOIND_EXE env var must be present");
let bitcoind = bitcoind::BitcoinD::new(bitcoind_exe).unwrap();
let lightningd_exe = env::var("LIGHTNINGD_EXE").expect("lightningd path must be specified in LIGHTNINGD_EXE env var");
let lightningd = lightningd::LightningD::new(lightningd_exe, bitcoind).unwrap();
```

# Test

Run test example:

```bash
RUST_LOG=debug LIGHTNINGD_EXE=/usr/local/bin/lightningd cargo test --features bitcoind_22_0 -- --nocapture
```