// Ignore clippy warnings on this autogenerated file:
#![allow(clippy::all)]
// This code was autogenerated with `dbus-codegen-rust --client blocking --destination org.freedesktop.login1 --interfaces org.freedesktop.login1.Session --path /org/freedesktop/login1/session/auto --system-bus --output src/generated.rs`, see https://github.com/diwic/dbus-rs
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait OrgFreedesktopLogin1Session {
    fn terminate(&self) -> Result<(), dbus::Error>;
    fn activate(&self) -> Result<(), dbus::Error>;
    fn lock(&self) -> Result<(), dbus::Error>;
    fn unlock(&self) -> Result<(), dbus::Error>;
    fn set_idle_hint_(&self, idle: bool) -> Result<(), dbus::Error>;
    fn set_locked_hint_(&self, locked: bool) -> Result<(), dbus::Error>;
    fn kill(&self, who: &str, signal_number: i32) -> Result<(), dbus::Error>;
    fn take_control(&self, force: bool) -> Result<(), dbus::Error>;
    fn release_control(&self) -> Result<(), dbus::Error>;
    fn set_type_(&self, type_: &str) -> Result<(), dbus::Error>;
    fn take_device(&self, major: u32, minor: u32) -> Result<(arg::OwnedFd, bool), dbus::Error>;
    fn release_device(&self, major: u32, minor: u32) -> Result<(), dbus::Error>;
    fn pause_device_complete(&self, major: u32, minor: u32) -> Result<(), dbus::Error>;
    fn set_brightness(&self, subsystem: &str, name: &str, brightness: u32) -> Result<(), dbus::Error>;
    fn id(&self) -> Result<String, dbus::Error>;
    fn user(&self) -> Result<(u32, dbus::Path<'static>), dbus::Error>;
    fn name(&self) -> Result<String, dbus::Error>;
    fn timestamp(&self) -> Result<u64, dbus::Error>;
    fn timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn vtnr(&self) -> Result<u32, dbus::Error>;
    fn seat(&self) -> Result<(String, dbus::Path<'static>), dbus::Error>;
    fn tty(&self) -> Result<String, dbus::Error>;
    fn display(&self) -> Result<String, dbus::Error>;
    fn remote(&self) -> Result<bool, dbus::Error>;
    fn remote_host(&self) -> Result<String, dbus::Error>;
    fn remote_user(&self) -> Result<String, dbus::Error>;
    fn service(&self) -> Result<String, dbus::Error>;
    fn desktop(&self) -> Result<String, dbus::Error>;
    fn scope(&self) -> Result<String, dbus::Error>;
    fn leader(&self) -> Result<u32, dbus::Error>;
    fn audit(&self) -> Result<u32, dbus::Error>;
    fn type_(&self) -> Result<String, dbus::Error>;
    fn class(&self) -> Result<String, dbus::Error>;
    fn active(&self) -> Result<bool, dbus::Error>;
    fn state(&self) -> Result<String, dbus::Error>;
    fn idle_hint(&self) -> Result<bool, dbus::Error>;
    fn idle_since_hint(&self) -> Result<u64, dbus::Error>;
    fn idle_since_hint_monotonic(&self) -> Result<u64, dbus::Error>;
    fn locked_hint(&self) -> Result<bool, dbus::Error>;
}

#[derive(Debug)]
pub struct OrgFreedesktopLogin1SessionPauseDevice {
    pub major: u32,
    pub minor: u32,
    pub type_: String,
}

impl arg::AppendAll for OrgFreedesktopLogin1SessionPauseDevice {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.major, i);
        arg::RefArg::append(&self.minor, i);
        arg::RefArg::append(&self.type_, i);
    }
}

impl arg::ReadAll for OrgFreedesktopLogin1SessionPauseDevice {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopLogin1SessionPauseDevice {
            major: i.read()?,
            minor: i.read()?,
            type_: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopLogin1SessionPauseDevice {
    const NAME: &'static str = "PauseDevice";
    const INTERFACE: &'static str = "org.freedesktop.login1.Session";
}

#[derive(Debug)]
pub struct OrgFreedesktopLogin1SessionResumeDevice {
    pub major: u32,
    pub minor: u32,
    pub fd: arg::OwnedFd,
}

impl arg::AppendAll for OrgFreedesktopLogin1SessionResumeDevice {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.major, i);
        arg::RefArg::append(&self.minor, i);
        arg::RefArg::append(&self.fd, i);
    }
}

impl arg::ReadAll for OrgFreedesktopLogin1SessionResumeDevice {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopLogin1SessionResumeDevice {
            major: i.read()?,
            minor: i.read()?,
            fd: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopLogin1SessionResumeDevice {
    const NAME: &'static str = "ResumeDevice";
    const INTERFACE: &'static str = "org.freedesktop.login1.Session";
}

#[derive(Debug)]
pub struct OrgFreedesktopLogin1SessionLock {
}

impl arg::AppendAll for OrgFreedesktopLogin1SessionLock {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for OrgFreedesktopLogin1SessionLock {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopLogin1SessionLock {
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopLogin1SessionLock {
    const NAME: &'static str = "Lock";
    const INTERFACE: &'static str = "org.freedesktop.login1.Session";
}

#[derive(Debug)]
pub struct OrgFreedesktopLogin1SessionUnlock {
}

impl arg::AppendAll for OrgFreedesktopLogin1SessionUnlock {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for OrgFreedesktopLogin1SessionUnlock {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopLogin1SessionUnlock {
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopLogin1SessionUnlock {
    const NAME: &'static str = "Unlock";
    const INTERFACE: &'static str = "org.freedesktop.login1.Session";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> OrgFreedesktopLogin1Session for blocking::Proxy<'a, C> {

    fn terminate(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "Terminate", ())
    }

    fn activate(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "Activate", ())
    }

    fn lock(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "Lock", ())
    }

    fn unlock(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "Unlock", ())
    }

    fn set_idle_hint_(&self, idle: bool) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "SetIdleHint", (idle, ))
    }

    fn set_locked_hint_(&self, locked: bool) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "SetLockedHint", (locked, ))
    }

    fn kill(&self, who: &str, signal_number: i32) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "Kill", (who, signal_number, ))
    }

    fn take_control(&self, force: bool) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "TakeControl", (force, ))
    }

    fn release_control(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "ReleaseControl", ())
    }

    fn set_type_(&self, type_: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "SetType", (type_, ))
    }

    fn take_device(&self, major: u32, minor: u32) -> Result<(arg::OwnedFd, bool), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "TakeDevice", (major, minor, ))
    }

    fn release_device(&self, major: u32, minor: u32) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "ReleaseDevice", (major, minor, ))
    }

    fn pause_device_complete(&self, major: u32, minor: u32) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "PauseDeviceComplete", (major, minor, ))
    }

    fn set_brightness(&self, subsystem: &str, name: &str, brightness: u32) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.login1.Session", "SetBrightness", (subsystem, name, brightness, ))
    }

    fn id(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Id")
    }

    fn user(&self) -> Result<(u32, dbus::Path<'static>), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "User")
    }

    fn name(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Name")
    }

    fn timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Timestamp")
    }

    fn timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "TimestampMonotonic")
    }

    fn vtnr(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "VTNr")
    }

    fn seat(&self) -> Result<(String, dbus::Path<'static>), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Seat")
    }

    fn tty(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "TTY")
    }

    fn display(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Display")
    }

    fn remote(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Remote")
    }

    fn remote_host(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "RemoteHost")
    }

    fn remote_user(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "RemoteUser")
    }

    fn service(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Service")
    }

    fn desktop(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Desktop")
    }

    fn scope(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Scope")
    }

    fn leader(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Leader")
    }

    fn audit(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Audit")
    }

    fn type_(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Type")
    }

    fn class(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Class")
    }

    fn active(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "Active")
    }

    fn state(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "State")
    }

    fn idle_hint(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "IdleHint")
    }

    fn idle_since_hint(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "IdleSinceHint")
    }

    fn idle_since_hint_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "IdleSinceHintMonotonic")
    }

    fn locked_hint(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.login1.Session", "LockedHint")
    }
}
