/* Copyright 2017 - 2021 R. Thomas
 * Copyright 2017 - 2021 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_MSVCR110_DLL_LOOKUP_H_
#define LIEF_PE_MSVCR110_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> msvcr110_dll_lookup {
    { 0x014b, "$I10_OUTPUT"                                                                                                       },
    { 0x0001, "??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z"                                                              },
    { 0x0002, "??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z"                                                             },
    { 0x0003, "??0SchedulerPolicy@Concurrency@@QAA@IZZ"                                                                           },
    { 0x0004, "??0SchedulerPolicy@Concurrency@@QAE@ABV01@@Z"                                                                      },
    { 0x0005, "??0SchedulerPolicy@Concurrency@@QAE@XZ"                                                                            },
    { 0x0006, "??0_CancellationTokenState@details@Concurrency@@AAE@XZ"                                                            },
    { 0x0007, "??0_Cancellation_beacon@details@Concurrency@@QAE@XZ"                                                               },
    { 0x0008, "??0_Condition_variable@details@Concurrency@@QAE@XZ"                                                                },
    { 0x0009, "??0_Context@details@Concurrency@@QAE@PAVContext@2@@Z"                                                              },
    { 0x000a, "??0_Interruption_exception@details@Concurrency@@QAE@PBD@Z"                                                         },
    { 0x000b, "??0_Interruption_exception@details@Concurrency@@QAE@XZ"                                                            },
    { 0x000c, "??0_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                          },
    { 0x000d, "??0_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                               },
    { 0x000e, "??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"                                                                  },
    { 0x000f, "??0_ReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                             },
    { 0x0010, "??0_ReentrantLock@details@Concurrency@@QAE@XZ"                                                                     },
    { 0x0011, "??0_ReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                                  },
    { 0x0012, "??0_Scheduler@details@Concurrency@@QAE@PAVScheduler@2@@Z"                                                          },
    { 0x0013, "??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"                                           },
    { 0x0014, "??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"                                              },
    { 0x0015, "??0_SpinLock@details@Concurrency@@QAE@ACJ@Z"                                                                       },
    { 0x0016, "??0_StructuredTaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z"                            },
    { 0x0017, "??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z"                                      },
    { 0x0018, "??0_TaskCollection@details@Concurrency@@QAE@XZ"                                                                    },
    { 0x0019, "??0_Timer@details@Concurrency@@IAE@I_N@Z"                                                                          },
    { 0x001a, "??0__non_rtti_object@std@@QAE@ABV01@@Z"                                                                            },
    { 0x001b, "??0__non_rtti_object@std@@QAE@PBD@Z"                                                                               },
    { 0x001c, "??0bad_cast@std@@AAE@PBQBD@Z"                                                                                      },
    { 0x001d, "??0bad_cast@std@@QAE@ABV01@@Z"                                                                                     },
    { 0x001e, "??0bad_cast@std@@QAE@PBD@Z"                                                                                        },
    { 0x001f, "??0bad_target@Concurrency@@QAE@PBD@Z"                                                                              },
    { 0x0020, "??0bad_target@Concurrency@@QAE@XZ"                                                                                 },
    { 0x0021, "??0bad_typeid@std@@QAE@ABV01@@Z"                                                                                   },
    { 0x0022, "??0bad_typeid@std@@QAE@PBD@Z"                                                                                      },
    { 0x0023, "??0context_self_unblock@Concurrency@@QAE@PBD@Z"                                                                    },
    { 0x0024, "??0context_self_unblock@Concurrency@@QAE@XZ"                                                                       },
    { 0x0025, "??0context_unblock_unbalanced@Concurrency@@QAE@PBD@Z"                                                              },
    { 0x0026, "??0context_unblock_unbalanced@Concurrency@@QAE@XZ"                                                                 },
    { 0x0027, "??0critical_section@Concurrency@@QAE@XZ"                                                                           },
    { 0x0028, "??0default_scheduler_exists@Concurrency@@QAE@PBD@Z"                                                                },
    { 0x0029, "??0default_scheduler_exists@Concurrency@@QAE@XZ"                                                                   },
    { 0x002a, "??0event@Concurrency@@QAE@XZ"                                                                                      },
    { 0x002b, "??0exception@std@@QAE@ABQBD@Z"                                                                                     },
    { 0x002c, "??0exception@std@@QAE@ABQBDH@Z"                                                                                    },
    { 0x002d, "??0exception@std@@QAE@ABV01@@Z"                                                                                    },
    { 0x002e, "??0exception@std@@QAE@XZ"                                                                                          },
    { 0x002f, "??0improper_lock@Concurrency@@QAE@PBD@Z"                                                                           },
    { 0x0030, "??0improper_lock@Concurrency@@QAE@XZ"                                                                              },
    { 0x0031, "??0improper_scheduler_attach@Concurrency@@QAE@PBD@Z"                                                               },
    { 0x0032, "??0improper_scheduler_attach@Concurrency@@QAE@XZ"                                                                  },
    { 0x0033, "??0improper_scheduler_detach@Concurrency@@QAE@PBD@Z"                                                               },
    { 0x0034, "??0improper_scheduler_detach@Concurrency@@QAE@XZ"                                                                  },
    { 0x0035, "??0improper_scheduler_reference@Concurrency@@QAE@PBD@Z"                                                            },
    { 0x0036, "??0improper_scheduler_reference@Concurrency@@QAE@XZ"                                                               },
    { 0x0037, "??0invalid_link_target@Concurrency@@QAE@PBD@Z"                                                                     },
    { 0x0038, "??0invalid_link_target@Concurrency@@QAE@XZ"                                                                        },
    { 0x0039, "??0invalid_multiple_scheduling@Concurrency@@QAE@PBD@Z"                                                             },
    { 0x003a, "??0invalid_multiple_scheduling@Concurrency@@QAE@XZ"                                                                },
    { 0x003b, "??0invalid_operation@Concurrency@@QAE@PBD@Z"                                                                       },
    { 0x003c, "??0invalid_operation@Concurrency@@QAE@XZ"                                                                          },
    { 0x003d, "??0invalid_oversubscribe_operation@Concurrency@@QAE@PBD@Z"                                                         },
    { 0x003e, "??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ"                                                            },
    { 0x003f, "??0invalid_scheduler_policy_key@Concurrency@@QAE@PBD@Z"                                                            },
    { 0x0040, "??0invalid_scheduler_policy_key@Concurrency@@QAE@XZ"                                                               },
    { 0x0041, "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@PBD@Z"                                           },
    { 0x0042, "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@XZ"                                              },
    { 0x0043, "??0invalid_scheduler_policy_value@Concurrency@@QAE@PBD@Z"                                                          },
    { 0x0044, "??0invalid_scheduler_policy_value@Concurrency@@QAE@XZ"                                                             },
    { 0x0045, "??0message_not_found@Concurrency@@QAE@PBD@Z"                                                                       },
    { 0x0046, "??0message_not_found@Concurrency@@QAE@XZ"                                                                          },
    { 0x0047, "??0missing_wait@Concurrency@@QAE@PBD@Z"                                                                            },
    { 0x0048, "??0missing_wait@Concurrency@@QAE@XZ"                                                                               },
    { 0x0049, "??0nested_scheduler_missing_detach@Concurrency@@QAE@PBD@Z"                                                         },
    { 0x004a, "??0nested_scheduler_missing_detach@Concurrency@@QAE@XZ"                                                            },
    { 0x004b, "??0operation_timed_out@Concurrency@@QAE@PBD@Z"                                                                     },
    { 0x004c, "??0operation_timed_out@Concurrency@@QAE@XZ"                                                                        },
    { 0x004d, "??0reader_writer_lock@Concurrency@@QAE@XZ"                                                                         },
    { 0x004e, "??0scheduler_not_attached@Concurrency@@QAE@PBD@Z"                                                                  },
    { 0x004f, "??0scheduler_not_attached@Concurrency@@QAE@XZ"                                                                     },
    { 0x0050, "??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z"                                                       },
    { 0x0051, "??0scheduler_resource_allocation_error@Concurrency@@QAE@PBDJ@Z"                                                    },
    { 0x0052, "??0scheduler_worker_creation_error@Concurrency@@QAE@J@Z"                                                           },
    { 0x0053, "??0scheduler_worker_creation_error@Concurrency@@QAE@PBDJ@Z"                                                        },
    { 0x0054, "??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z"                                                         },
    { 0x0055, "??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"                                                       },
    { 0x0056, "??0scoped_lock_read@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"                                                  },
    { 0x0057, "??0task_canceled@Concurrency@@QAE@PBD@Z"                                                                           },
    { 0x0058, "??0task_canceled@Concurrency@@QAE@XZ"                                                                              },
    { 0x0059, "??0unsupported_os@Concurrency@@QAE@PBD@Z"                                                                          },
    { 0x005a, "??0unsupported_os@Concurrency@@QAE@XZ"                                                                             },
    { 0x005b, "??1SchedulerPolicy@Concurrency@@QAE@XZ"                                                                            },
    { 0x005c, "??1_CancellationTokenState@details@Concurrency@@UAE@XZ"                                                            },
    { 0x005d, "??1_Cancellation_beacon@details@Concurrency@@QAE@XZ"                                                               },
    { 0x005e, "??1_Condition_variable@details@Concurrency@@QAE@XZ"                                                                },
    { 0x005f, "??1_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                          },
    { 0x0060, "??1_ReentrantBlockingLock@details@Concurrency@@QAE@XZ"                                                             },
    { 0x0061, "??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                  },
    { 0x0062, "??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@XZ"                                                     },
    { 0x0063, "??1_SpinLock@details@Concurrency@@QAE@XZ"                                                                          },
    { 0x0064, "??1_TaskCollection@details@Concurrency@@QAE@XZ"                                                                    },
    { 0x0065, "??1_Timer@details@Concurrency@@MAE@XZ"                                                                             },
    { 0x0066, "??1__non_rtti_object@std@@UAE@XZ"                                                                                  },
    { 0x0067, "??1bad_cast@std@@UAE@XZ"                                                                                           },
    { 0x0068, "??1bad_typeid@std@@UAE@XZ"                                                                                         },
    { 0x0069, "??1critical_section@Concurrency@@QAE@XZ"                                                                           },
    { 0x006a, "??1event@Concurrency@@QAE@XZ"                                                                                      },
    { 0x006b, "??1exception@std@@UAE@XZ"                                                                                          },
    { 0x006c, "??1reader_writer_lock@Concurrency@@QAE@XZ"                                                                         },
    { 0x006d, "??1scoped_lock@critical_section@Concurrency@@QAE@XZ"                                                               },
    { 0x006e, "??1scoped_lock@reader_writer_lock@Concurrency@@QAE@XZ"                                                             },
    { 0x006f, "??1scoped_lock_read@reader_writer_lock@Concurrency@@QAE@XZ"                                                        },
    { 0x0070, "??1type_info@@UAE@XZ"                                                                                              },
    { 0x0071, "??2@YAPAXI@Z"                                                                                                      },
    { 0x0072, "??2@YAPAXIHPBDH@Z"                                                                                                 },
    { 0x0073, "??3@YAXPAX@Z"                                                                                                      },
    { 0x0074, "??3@YAXPAXHPBDH@Z"                                                                                                 },
    { 0x0075, "??4?$_SpinWait@$00@details@Concurrency@@QAEAAV012@ABV012@@Z"                                                       },
    { 0x0076, "??4?$_SpinWait@$0A@@details@Concurrency@@QAEAAV012@ABV012@@Z"                                                      },
    { 0x0077, "??4SchedulerPolicy@Concurrency@@QAEAAV01@ABV01@@Z"                                                                 },
    { 0x0078, "??4__non_rtti_object@std@@QAEAAV01@ABV01@@Z"                                                                       },
    { 0x0079, "??4bad_cast@std@@QAEAAV01@ABV01@@Z"                                                                                },
    { 0x007a, "??4bad_typeid@std@@QAEAAV01@ABV01@@Z"                                                                              },
    { 0x007b, "??4exception@std@@QAEAAV01@ABV01@@Z"                                                                               },
    { 0x007c, "??8type_info@@QBE_NABV0@@Z"                                                                                        },
    { 0x007d, "??9type_info@@QBE_NABV0@@Z"                                                                                        },
    { 0x007e, "??_7__non_rtti_object@std@@6B@"                                                                                    },
    { 0x007f, "??_7bad_cast@std@@6B@"                                                                                             },
    { 0x0080, "??_7bad_typeid@std@@6B@"                                                                                           },
    { 0x0081, "??_7exception@std@@6B@"                                                                                            },
    { 0x0082, "??_F?$_SpinWait@$00@details@Concurrency@@QAEXXZ"                                                                   },
    { 0x0083, "??_F?$_SpinWait@$0A@@details@Concurrency@@QAEXXZ"                                                                  },
    { 0x0084, "??_F_Context@details@Concurrency@@QAEXXZ"                                                                          },
    { 0x0085, "??_F_Scheduler@details@Concurrency@@QAEXXZ"                                                                        },
    { 0x0086, "??_Fbad_cast@std@@QAEXXZ"                                                                                          },
    { 0x0087, "??_Fbad_typeid@std@@QAEXXZ"                                                                                        },
    { 0x0088, "??_U@YAPAXI@Z"                                                                                                     },
    { 0x0089, "??_U@YAPAXIHPBDH@Z"                                                                                                },
    { 0x008a, "??_V@YAXPAX@Z"                                                                                                     },
    { 0x008b, "??_V@YAXPAXHPBDH@Z"                                                                                                },
    { 0x008c, "?Alloc@Concurrency@@YAPAXI@Z"                                                                                      },
    { 0x008d, "?Block@Context@Concurrency@@SAXXZ"                                                                                 },
    { 0x008e, "?Create@CurrentScheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"                                                  },
    { 0x008f, "?Create@Scheduler@Concurrency@@SAPAV12@ABVSchedulerPolicy@2@@Z"                                                    },
    { 0x0090, "?CreateResourceManager@Concurrency@@YAPAUIResourceManager@1@XZ"                                                    },
    { 0x0091, "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPAVScheduleGroup@2@AAVlocation@2@@Z"                          },
    { 0x0092, "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPAVScheduleGroup@2@XZ"                                        },
    { 0x0093, "?CurrentContext@Context@Concurrency@@SAPAV12@XZ"                                                                   },
    { 0x0094, "?Detach@CurrentScheduler@Concurrency@@SAXXZ"                                                                       },
    { 0x0095, "?DisableTracing@Concurrency@@YAJXZ"                                                                                },
    { 0x0096, "?EnableTracing@Concurrency@@YAJXZ"                                                                                 },
    { 0x0097, "?Free@Concurrency@@YAXPAX@Z"                                                                                       },
    { 0x0098, "?Get@CurrentScheduler@Concurrency@@SAPAVScheduler@2@XZ"                                                            },
    { 0x0099, "?GetExecutionContextId@Concurrency@@YAIXZ"                                                                         },
    { 0x009a, "?GetNumberOfVirtualProcessors@CurrentScheduler@Concurrency@@SAIXZ"                                                 },
    { 0x009b, "?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ"                                                  },
    { 0x009c, "?GetPolicy@CurrentScheduler@Concurrency@@SA?AVSchedulerPolicy@2@XZ"                                                },
    { 0x009d, "?GetPolicyValue@SchedulerPolicy@Concurrency@@QBEIW4PolicyElementKey@2@@Z"                                          },
    { 0x009e, "?GetProcessorCount@Concurrency@@YAIXZ"                                                                             },
    { 0x009f, "?GetProcessorNodeCount@Concurrency@@YAIXZ"                                                                         },
    { 0x00a0, "?GetSchedulerId@Concurrency@@YAIXZ"                                                                                },
    { 0x00a1, "?GetSharedTimerQueue@details@Concurrency@@YAPAXXZ"                                                                 },
    { 0x00a2, "?Id@Context@Concurrency@@SAIXZ"                                                                                    },
    { 0x00a3, "?Id@CurrentScheduler@Concurrency@@SAIXZ"                                                                           },
    { 0x00a4, "?IsAvailableLocation@CurrentScheduler@Concurrency@@SA_NABVlocation@2@@Z"                                           },
    { 0x00a5, "?IsCurrentTaskCollectionCanceling@Context@Concurrency@@SA_NXZ"                                                     },
    { 0x00a6, "?Log2@details@Concurrency@@YAKI@Z"                                                                                 },
    { 0x00a7, "?Oversubscribe@Context@Concurrency@@SAX_N@Z"                                                                       },
    { 0x00a8, "?RegisterShutdownEvent@CurrentScheduler@Concurrency@@SAXPAX@Z"                                                     },
    { 0x00a9, "?ResetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXXZ"                                                         },
    { 0x00aa, "?ScheduleGroupId@Context@Concurrency@@SAIXZ"                                                                       },
    { 0x00ab, "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0@Z"                                                       },
    { 0x00ac, "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0AAVlocation@2@@Z"                                         },
    { 0x00ad, "?SetConcurrencyLimits@SchedulerPolicy@Concurrency@@QAEXII@Z"                                                       },
    { 0x00ae, "?SetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"                                      },
    { 0x00af, "?SetPolicyValue@SchedulerPolicy@Concurrency@@QAEIW4PolicyElementKey@2@I@Z"                                         },
    { 0x00b0, "?VirtualProcessorId@Context@Concurrency@@SAIXZ"                                                                    },
    { 0x00b1, "?Yield@Context@Concurrency@@SAXXZ"                                                                                 },
    { 0x00b2, "?_Abort@_StructuredTaskCollection@details@Concurrency@@AAEXXZ"                                                     },
    { 0x00b3, "?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                   },
    { 0x00b4, "?_Acquire@_NonReentrantPPLLock@details@Concurrency@@QAEXPAX@Z"                                                     },
    { 0x00b5, "?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00b6, "?_Acquire@_ReentrantLock@details@Concurrency@@QAEXXZ"                                                              },
    { 0x00b7, "?_Acquire@_ReentrantPPLLock@details@Concurrency@@QAEXPAX@Z"                                                        },
    { 0x00b8, "?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                       },
    { 0x00b9, "?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00ba, "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00bb, "?_Cancel@_StructuredTaskCollection@details@Concurrency@@QAEXXZ"                                                    },
    { 0x00bc, "?_Cancel@_TaskCollection@details@Concurrency@@QAEXXZ"                                                              },
    { 0x00bd, "?_CheckTaskCollection@_UnrealizedChore@details@Concurrency@@IAEXXZ"                                                },
    { 0x00be, "?_CleanupToken@_StructuredTaskCollection@details@Concurrency@@AAEXXZ"                                              },
    { 0x00bf, "?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z"                                                               },
    { 0x00c0, "?_ConcRT_Trace@details@Concurrency@@YAXHPB_WZZ"                                                                    },
    { 0x00c1, "?_Confirm_cancel@_Cancellation_beacon@details@Concurrency@@QAE_NXZ"                                                },
    { 0x00c2, "?_Copy_str@exception@std@@AAEXPBD@Z"                                                                               },
    { 0x00c3, "?_CurrentContext@_Context@details@Concurrency@@SA?AV123@XZ"                                                        },
    { 0x00c4, "?_Current_node@location@Concurrency@@SA?AV12@XZ"                                                                   },
    { 0x00c5, "?_DeregisterCallback@_CancellationTokenState@details@Concurrency@@QAEXPAV_CancellationTokenRegistration@23@@Z"     },
    { 0x00c6, "?_Destroy@_AsyncTaskCollection@details@Concurrency@@EAEXXZ"                                                        },
    { 0x00c7, "?_Destroy@_CancellationTokenState@details@Concurrency@@EAEXXZ"                                                     },
    { 0x00c8, "?_DoYield@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"                                                             },
    { 0x00c9, "?_DoYield@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"                                                            },
    { 0x00ca, "?_Get@_CurrentScheduler@details@Concurrency@@SA?AV_Scheduler@23@XZ"                                                },
    { 0x00cb, "?_GetConcRTTraceInfo@Concurrency@@YAPBU_CONCRT_TRACE_INFO@details@1@XZ"                                            },
    { 0x00cc, "?_GetConcurrency@details@Concurrency@@YAIXZ"                                                                       },
    { 0x00cd, "?_GetCurrentInlineDepth@_StackGuard@details@Concurrency@@CAAAIXZ"                                                  },
    { 0x00ce, "?_GetNumberOfVirtualProcessors@_CurrentScheduler@details@Concurrency@@SAIXZ"                                       },
    { 0x00cf, "?_GetScheduler@_Scheduler@details@Concurrency@@QAEPAVScheduler@3@XZ"                                               },
    { 0x00d0, "?_Id@_CurrentScheduler@details@Concurrency@@SAIXZ"                                                                 },
    { 0x00d1, "?_Invoke@_CancellationTokenRegistration@details@Concurrency@@AAEXXZ"                                               },
    { 0x00d2, "?_IsCanceling@_StructuredTaskCollection@details@Concurrency@@QAE_NXZ"                                              },
    { 0x00d3, "?_IsCanceling@_TaskCollection@details@Concurrency@@QAE_NXZ"                                                        },
    { 0x00d4, "?_IsSynchronouslyBlocked@_Context@details@Concurrency@@QBE_NXZ"                                                    },
    { 0x00d5, "?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"                                                          },
    { 0x00d6, "?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"                                                 },
    { 0x00d7, "?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z"               },
    { 0x00d8, "?_NewTokenState@_CancellationTokenState@details@Concurrency@@SAPAV123@XZ"                                          },
    { 0x00d9, "?_NumberOfSpins@?$_SpinWait@$00@details@Concurrency@@IAEKXZ"                                                       },
    { 0x00da, "?_NumberOfSpins@?$_SpinWait@$0A@@details@Concurrency@@IAEKXZ"                                                      },
    { 0x00db, "?_Oversubscribe@_Context@details@Concurrency@@SAX_N@Z"                                                             },
    { 0x00dc, "?_Reference@_Scheduler@details@Concurrency@@QAEIXZ"                                                                },
    { 0x00dd, "?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEPAV_CancellationTokenRegistration@23@P6AXPAX@Z0H@Z" },
    { 0x00de, "?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEXPAV_CancellationTokenRegistration@23@@Z"       },
    { 0x00df, "?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                   },
    { 0x00e0, "?_Release@_NonReentrantPPLLock@details@Concurrency@@QAEXXZ"                                                        },
    { 0x00e1, "?_Release@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00e2, "?_Release@_ReentrantLock@details@Concurrency@@QAEXXZ"                                                              },
    { 0x00e3, "?_Release@_ReentrantPPLLock@details@Concurrency@@QAEXXZ"                                                           },
    { 0x00e4, "?_Release@_Scheduler@details@Concurrency@@QAEIXZ"                                                                  },
    { 0x00e5, "?_ReleaseRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                       },
    { 0x00e6, "?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"                                                      },
    { 0x00e7, "?_ReportUnobservedException@details@Concurrency@@YAXXZ"                                                            },
    { 0x00e8, "?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"                                                               },
    { 0x00e9, "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"                                                              },
    { 0x00ea, "?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z" },
    { 0x00eb, "?_RunAndWait@_TaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z"       },
    { 0x00ec, "?_Schedule@_StructuredTaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"                           },
    { 0x00ed, "?_Schedule@_StructuredTaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z"             },
    { 0x00ee, "?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"                                     },
    { 0x00ef, "?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z"                       },
    { 0x00f0, "?_ScheduleTask@_CurrentScheduler@details@Concurrency@@SAXP6AXPAX@Z0@Z"                                             },
    { 0x00f1, "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"                                                       },
    { 0x00f2, "?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"                                                      },
    { 0x00f3, "?_SetUnobservedExceptionHandler@details@Concurrency@@YAXP6AXXZ@Z"                                                  },
    { 0x00f4, "?_ShouldSpinAgain@?$_SpinWait@$00@details@Concurrency@@IAE_NXZ"                                                    },
    { 0x00f5, "?_ShouldSpinAgain@?$_SpinWait@$0A@@details@Concurrency@@IAE_NXZ"                                                   },
    { 0x00f6, "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"                                                           },
    { 0x00f7, "?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ"                                                          },
    { 0x00f8, "?_SpinYield@Context@Concurrency@@SAXXZ"                                                                            },
    { 0x00f9, "?_Start@_Timer@details@Concurrency@@IAEXXZ"                                                                        },
    { 0x00fa, "?_Stop@_Timer@details@Concurrency@@IAEXXZ"                                                                         },
    { 0x00fb, "?_Tidy@exception@std@@AAEXXZ"                                                                                      },
    { 0x00fc, "?_Trace_agents@Concurrency@@YAXW4Agents_EventType@1@_JZZ"                                                          },
    { 0x00fd, "?_Trace_ppl_function@Concurrency@@YAXABU_GUID@@EW4ConcRT_EventType@1@@Z"                                           },
    { 0x00fe, "?_TryAcquire@_NonReentrantBlockingLock@details@Concurrency@@QAE_NXZ"                                               },
    { 0x00ff, "?_TryAcquire@_ReentrantBlockingLock@details@Concurrency@@QAE_NXZ"                                                  },
    { 0x0100, "?_TryAcquire@_ReentrantLock@details@Concurrency@@QAE_NXZ"                                                          },
    { 0x0101, "?_TryAcquireWrite@_ReaderWriterLock@details@Concurrency@@QAE_NXZ"                                                  },
    { 0x0102, "?_Type_info_dtor@type_info@@CAXPAV1@@Z"                                                                            },
    { 0x0103, "?_Type_info_dtor_internal@type_info@@CAXPAV1@@Z"                                                                   },
    { 0x0104, "?_UnderlyingYield@details@Concurrency@@YAXXZ"                                                                      },
    { 0x0105, "?_ValidateExecute@@YAHP6GHXZ@Z"                                                                                    },
    { 0x0106, "?_ValidateRead@@YAHPBXI@Z"                                                                                         },
    { 0x0107, "?_ValidateWrite@@YAHPAXI@Z"                                                                                        },
    { 0x0108, "?_Value@_SpinCount@details@Concurrency@@SAIXZ"                                                                     },
    { 0x0109, "?_Yield@_Context@details@Concurrency@@SAXXZ"                                                                       },
    { 0x010a, "?__ExceptionPtrAssign@@YAXPAXPBX@Z"                                                                                },
    { 0x010b, "?__ExceptionPtrCompare@@YA_NPBX0@Z"                                                                                },
    { 0x010c, "?__ExceptionPtrCopy@@YAXPAXPBX@Z"                                                                                  },
    { 0x010d, "?__ExceptionPtrCopyException@@YAXPAXPBX1@Z"                                                                        },
    { 0x010e, "?__ExceptionPtrCreate@@YAXPAX@Z"                                                                                   },
    { 0x010f, "?__ExceptionPtrCurrentException@@YAXPAX@Z"                                                                         },
    { 0x0110, "?__ExceptionPtrDestroy@@YAXPAX@Z"                                                                                  },
    { 0x0111, "?__ExceptionPtrRethrow@@YAXPBX@Z"                                                                                  },
    { 0x0112, "?__ExceptionPtrSwap@@YAXPAX0@Z"                                                                                    },
    { 0x0113, "?__ExceptionPtrToBool@@YA_NPBX@Z"                                                                                  },
    { 0x0115, "?_inconsistency@@YAXXZ"                                                                                            },
    { 0x0116, "?_invalid_parameter@@YAXPBG00II@Z"                                                                                 },
    { 0x0117, "?_is_exception_typeof@@YAHABVtype_info@@PAU_EXCEPTION_POINTERS@@@Z"                                                },
    { 0x0118, "?_name_internal_method@type_info@@QBEPBDPAU__type_info_node@@@Z"                                                   },
    { 0x0119, "?_open@@YAHPBDHH@Z"                                                                                                },
    { 0x011a, "?_query_new_handler@@YAP6AHI@ZXZ"                                                                                  },
    { 0x011b, "?_query_new_mode@@YAHXZ"                                                                                           },
    { 0x011c, "?_set_new_handler@@YAP6AHI@ZH@Z"                                                                                   },
    { 0x011d, "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"                                                                             },
    { 0x011e, "?_set_new_mode@@YAHH@Z"                                                                                            },
    { 0x011f, "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZH@Z"                                                         },
    { 0x0120, "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"                                                  },
    { 0x0121, "?_sopen@@YAHPBDHHH@Z"                                                                                              },
    { 0x0122, "?_type_info_dtor_internal_method@type_info@@QAEXXZ"                                                                },
    { 0x0123, "?_wopen@@YAHPB_WHH@Z"                                                                                              },
    { 0x0124, "?_wsopen@@YAHPB_WHHH@Z"                                                                                            },
    { 0x0125, "?before@type_info@@QBE_NABV1@@Z"                                                                                   },
    { 0x0126, "?current@location@Concurrency@@SA?AV12@XZ"                                                                         },
    { 0x0127, "?from_numa_node@location@Concurrency@@SA?AV12@G@Z"                                                                 },
    { 0x0128, "?get_error_code@scheduler_resource_allocation_error@Concurrency@@QBEJXZ"                                           },
    { 0x0129, "?lock@critical_section@Concurrency@@QAEXXZ"                                                                        },
    { 0x012a, "?lock@reader_writer_lock@Concurrency@@QAEXXZ"                                                                      },
    { 0x012b, "?lock_read@reader_writer_lock@Concurrency@@QAEXXZ"                                                                 },
    { 0x012c, "?name@type_info@@QBEPBDPAU__type_info_node@@@Z"                                                                    },
    { 0x012d, "?native_handle@critical_section@Concurrency@@QAEAAV12@XZ"                                                          },
    { 0x012e, "?notify_all@_Condition_variable@details@Concurrency@@QAEXXZ"                                                       },
    { 0x012f, "?notify_one@_Condition_variable@details@Concurrency@@QAEXXZ"                                                       },
    { 0x0130, "?raw_name@type_info@@QBEPBDXZ"                                                                                     },
    { 0x0131, "?reset@event@Concurrency@@QAEXXZ"                                                                                  },
    { 0x0132, "?set@event@Concurrency@@QAEXXZ"                                                                                    },
    { 0x0133, "?set_new_handler@@YAP6AXXZP6AXXZ@Z"                                                                                },
    { 0x0134, "?set_task_execution_resources@Concurrency@@YAXGPAU_GROUP_AFFINITY@@@Z"                                             },
    { 0x0135, "?set_task_execution_resources@Concurrency@@YAXK@Z"                                                                 },
    { 0x0136, "?set_terminate@@YAP6AXXZH@Z"                                                                                       },
    { 0x0137, "?set_terminate@@YAP6AXXZP6AXXZ@Z"                                                                                  },
    { 0x0138, "?set_unexpected@@YAP6AXXZH@Z"                                                                                      },
    { 0x0139, "?set_unexpected@@YAP6AXXZP6AXXZ@Z"                                                                                 },
    { 0x013a, "?swprintf@@YAHPAGIPBGZZ"                                                                                           },
    { 0x013b, "?swprintf@@YAHPA_WIPB_WZZ"                                                                                         },
    { 0x013c, "?terminate@@YAXXZ"                                                                                                 },
    { 0x013d, "?try_lock@critical_section@Concurrency@@QAE_NXZ"                                                                   },
    { 0x013e, "?try_lock@reader_writer_lock@Concurrency@@QAE_NXZ"                                                                 },
    { 0x013f, "?try_lock_for@critical_section@Concurrency@@QAE_NI@Z"                                                              },
    { 0x0140, "?try_lock_read@reader_writer_lock@Concurrency@@QAE_NXZ"                                                            },
    { 0x0141, "?unexpected@@YAXXZ"                                                                                                },
    { 0x0142, "?unlock@critical_section@Concurrency@@QAEXXZ"                                                                      },
    { 0x0143, "?unlock@reader_writer_lock@Concurrency@@QAEXXZ"                                                                    },
    { 0x0144, "?vswprintf@@YAHPA_WIPB_WPAD@Z"                                                                                     },
    { 0x0145, "?wait@Concurrency@@YAXI@Z"                                                                                         },
    { 0x0146, "?wait@_Condition_variable@details@Concurrency@@QAEXAAVcritical_section@3@@Z"                                       },
    { 0x0147, "?wait@event@Concurrency@@QAEII@Z"                                                                                  },
    { 0x0148, "?wait_for@_Condition_variable@details@Concurrency@@QAE_NAAVcritical_section@3@I@Z"                                 },
    { 0x0149, "?wait_for_multiple@event@Concurrency@@SAIPAPAV12@I_NI@Z"                                                           },
    { 0x014a, "?what@exception@std@@UBEPBDXZ"                                                                                     },
    { 0x014c, "_CIacos"                                                                                                           },
    { 0x014d, "_CIasin"                                                                                                           },
    { 0x014e, "_CIatan"                                                                                                           },
    { 0x014f, "_CIatan2"                                                                                                          },
    { 0x0150, "_CIcos"                                                                                                            },
    { 0x0151, "_CIcosh"                                                                                                           },
    { 0x0152, "_CIexp"                                                                                                            },
    { 0x0153, "_CIfmod"                                                                                                           },
    { 0x0154, "_CIlog"                                                                                                            },
    { 0x0155, "_CIlog10"                                                                                                          },
    { 0x0156, "_CIpow"                                                                                                            },
    { 0x0157, "_CIsin"                                                                                                            },
    { 0x0158, "_CIsinh"                                                                                                           },
    { 0x0159, "_CIsqrt"                                                                                                           },
    { 0x015a, "_CItan"                                                                                                            },
    { 0x015b, "_CItanh"                                                                                                           },
    { 0x015c, "_CRT_RTC_INIT"                                                                                                     },
    { 0x015d, "_CRT_RTC_INITW"                                                                                                    },
    { 0x015e, "_CreateFrameInfo"                                                                                                  },
    { 0x015f, "_CxxThrowException"                                                                                                },
    { 0x0160, "_EH_prolog"                                                                                                        },
    { 0x0161, "_FindAndUnlinkFrame"                                                                                               },
    { 0x0162, "_Getdays"                                                                                                          },
    { 0x0163, "_Getmonths"                                                                                                        },
    { 0x0164, "_Gettnames"                                                                                                        },
    { 0x0165, "_HUGE"                                                                                                             },
    { 0x0166, "_IsExceptionObjectToBeDestroyed"                                                                                   },
    { 0x0167, "_Lock_shared_ptr_spin_lock"                                                                                        },
    { 0x0168, "_NLG_Dispatch2"                                                                                                    },
    { 0x0169, "_NLG_Return"                                                                                                       },
    { 0x016a, "_NLG_Return2"                                                                                                      },
    { 0x016b, "_Strftime"                                                                                                         },
    { 0x016c, "_Unlock_shared_ptr_spin_lock"                                                                                      },
    { 0x016d, "_W_Getdays"                                                                                                        },
    { 0x016e, "_W_Getmonths"                                                                                                      },
    { 0x016f, "_W_Gettnames"                                                                                                      },
    { 0x0170, "_Wcsftime"                                                                                                         },
    { 0x0171, "_XcptFilter"                                                                                                       },
    { 0x0172, "__AdjustPointer"                                                                                                   },
    { 0x0173, "__BuildCatchObject"                                                                                                },
    { 0x0174, "__BuildCatchObjectHelper"                                                                                          },
    { 0x0175, "__CppXcptFilter"                                                                                                   },
    { 0x0176, "__CxxDetectRethrow"                                                                                                },
    { 0x0177, "__CxxExceptionFilter"                                                                                              },
    { 0x0178, "__CxxFrameHandler"                                                                                                 },
    { 0x0179, "__CxxFrameHandler2"                                                                                                },
    { 0x017a, "__CxxFrameHandler3"                                                                                                },
    { 0x017b, "__CxxLongjmpUnwind"                                                                                                },
    { 0x017c, "__CxxQueryExceptionSize"                                                                                           },
    { 0x017d, "__CxxRegisterExceptionObject"                                                                                      },
    { 0x017e, "__CxxUnregisterExceptionObject"                                                                                    },
    { 0x017f, "__DestructExceptionObject"                                                                                         },
    { 0x0180, "__FrameUnwindFilter"                                                                                               },
    { 0x0181, "__RTCastToVoid"                                                                                                    },
    { 0x0182, "__RTDynamicCast"                                                                                                   },
    { 0x0183, "__RTtypeid"                                                                                                        },
    { 0x0184, "__STRINGTOLD"                                                                                                      },
    { 0x0185, "__STRINGTOLD_L"                                                                                                    },
    { 0x0186, "__TypeMatch"                                                                                                       },
    { 0x0197, "___crtCreateSemaphoreExW@24"                                                                                       },
    { 0x0187, "___lc_codepage_func"                                                                                               },
    { 0x0188, "___lc_collate_cp_func"                                                                                             },
    { 0x0189, "___lc_locale_name_func"                                                                                            },
    { 0x018a, "___mb_cur_max_func"                                                                                                },
    { 0x018b, "___mb_cur_max_l_func"                                                                                              },
    { 0x018c, "___setlc_active_func"                                                                                              },
    { 0x018d, "___unguarded_readlc_active_add_func"                                                                               },
    { 0x018e, "__argc"                                                                                                            },
    { 0x018f, "__argv"                                                                                                            },
    { 0x0190, "__badioinfo"                                                                                                       },
    { 0x0191, "__clean_type_info_names_internal"                                                                                  },
    { 0x0192, "__control87_2"                                                                                                     },
    { 0x0193, "__create_locale"                                                                                                   },
    { 0x0194, "__crtCompareStringA"                                                                                               },
    { 0x0195, "__crtCompareStringEx"                                                                                              },
    { 0x0196, "__crtCompareStringW"                                                                                               },
    { 0x0198, "__crtCreateSymbolicLinkW"                                                                                          },
    { 0x0199, "__crtEnumSystemLocalesEx"                                                                                          },
    { 0x019a, "__crtFlsAlloc"                                                                                                     },
    { 0x019b, "__crtFlsFree"                                                                                                      },
    { 0x019c, "__crtFlsGetValue"                                                                                                  },
    { 0x019d, "__crtFlsSetValue"                                                                                                  },
    { 0x019e, "__crtGetDateFormatEx"                                                                                              },
    { 0x019f, "__crtGetLocaleInfoEx"                                                                                              },
    { 0x01a0, "__crtGetShowWindowMode"                                                                                            },
    { 0x01a1, "__crtGetTimeFormatEx"                                                                                              },
    { 0x01a2, "__crtGetUserDefaultLocaleName"                                                                                     },
    { 0x01a3, "__crtInitializeCriticalSectionEx"                                                                                  },
    { 0x01a4, "__crtIsPackagedApp"                                                                                                },
    { 0x01a5, "__crtIsValidLocaleName"                                                                                            },
    { 0x01a6, "__crtLCMapStringA"                                                                                                 },
    { 0x01a7, "__crtLCMapStringEx"                                                                                                },
    { 0x01a8, "__crtLCMapStringW"                                                                                                 },
    { 0x01a9, "__crtSetThreadStackGuarantee"                                                                                      },
    { 0x01aa, "__crtSetUnhandledExceptionFilter"                                                                                  },
    { 0x01ab, "__crtTerminateProcess"                                                                                             },
    { 0x01ac, "__crtUnhandledException"                                                                                           },
    { 0x01ad, "__daylight"                                                                                                        },
    { 0x01ae, "__dllonexit"                                                                                                       },
    { 0x01af, "__doserrno"                                                                                                        },
    { 0x01b0, "__dstbias"                                                                                                         },
    { 0x01b1, "__fpecode"                                                                                                         },
    { 0x01b2, "__free_locale"                                                                                                     },
    { 0x01b3, "__get_current_locale"                                                                                              },
    { 0x01b4, "__get_flsindex"                                                                                                    },
    { 0x01b5, "__get_tlsindex"                                                                                                    },
    { 0x01b6, "__getmainargs"                                                                                                     },
    { 0x01b7, "__initenv"                                                                                                         },
    { 0x01b8, "__iob_func"                                                                                                        },
    { 0x01b9, "__isascii"                                                                                                         },
    { 0x01ba, "__iscsym"                                                                                                          },
    { 0x01bb, "__iscsymf"                                                                                                         },
    { 0x01bc, "__iswcsym"                                                                                                         },
    { 0x01bd, "__iswcsymf"                                                                                                        },
    { 0x01be, "__lconv"                                                                                                           },
    { 0x01bf, "__lconv_init"                                                                                                      },
    { 0x01c0, "__libm_sse2_acos"                                                                                                  },
    { 0x01c1, "__libm_sse2_acosf"                                                                                                 },
    { 0x01c2, "__libm_sse2_asin"                                                                                                  },
    { 0x01c3, "__libm_sse2_asinf"                                                                                                 },
    { 0x01c4, "__libm_sse2_atan"                                                                                                  },
    { 0x01c5, "__libm_sse2_atan2"                                                                                                 },
    { 0x01c6, "__libm_sse2_atanf"                                                                                                 },
    { 0x01c7, "__libm_sse2_cos"                                                                                                   },
    { 0x01c8, "__libm_sse2_cosf"                                                                                                  },
    { 0x01c9, "__libm_sse2_exp"                                                                                                   },
    { 0x01ca, "__libm_sse2_expf"                                                                                                  },
    { 0x01cb, "__libm_sse2_log"                                                                                                   },
    { 0x01cc, "__libm_sse2_log10"                                                                                                 },
    { 0x01cd, "__libm_sse2_log10f"                                                                                                },
    { 0x01ce, "__libm_sse2_logf"                                                                                                  },
    { 0x01cf, "__libm_sse2_pow"                                                                                                   },
    { 0x01d0, "__libm_sse2_powf"                                                                                                  },
    { 0x01d1, "__libm_sse2_sin"                                                                                                   },
    { 0x01d2, "__libm_sse2_sinf"                                                                                                  },
    { 0x01d3, "__libm_sse2_tan"                                                                                                   },
    { 0x01d4, "__libm_sse2_tanf"                                                                                                  },
    { 0x01d5, "__mb_cur_max"                                                                                                      },
    { 0x01d6, "__p___argc"                                                                                                        },
    { 0x01d7, "__p___argv"                                                                                                        },
    { 0x01d8, "__p___initenv"                                                                                                     },
    { 0x01d9, "__p___mb_cur_max"                                                                                                  },
    { 0x01da, "__p___wargv"                                                                                                       },
    { 0x01db, "__p___winitenv"                                                                                                    },
    { 0x01dc, "__p__acmdln"                                                                                                       },
    { 0x01dd, "__p__commode"                                                                                                      },
    { 0x01de, "__p__daylight"                                                                                                     },
    { 0x01df, "__p__dstbias"                                                                                                      },
    { 0x01e0, "__p__environ"                                                                                                      },
    { 0x01e1, "__p__fmode"                                                                                                        },
    { 0x01e2, "__p__iob"                                                                                                          },
    { 0x01e3, "__p__mbcasemap"                                                                                                    },
    { 0x01e4, "__p__mbctype"                                                                                                      },
    { 0x01e5, "__p__pctype"                                                                                                       },
    { 0x01e6, "__p__pgmptr"                                                                                                       },
    { 0x01e7, "__p__pwctype"                                                                                                      },
    { 0x01e8, "__p__timezone"                                                                                                     },
    { 0x01e9, "__p__tzname"                                                                                                       },
    { 0x01ea, "__p__wcmdln"                                                                                                       },
    { 0x01eb, "__p__wenviron"                                                                                                     },
    { 0x01ec, "__p__wpgmptr"                                                                                                      },
    { 0x01ed, "__pctype_func"                                                                                                     },
    { 0x01ee, "__pioinfo"                                                                                                         },
    { 0x01ef, "__pwctype_func"                                                                                                    },
    { 0x01f0, "__pxcptinfoptrs"                                                                                                   },
    { 0x01f1, "__report_gsfailure"                                                                                                },
    { 0x01f2, "__set_app_type"                                                                                                    },
    { 0x01f3, "__setlc_active"                                                                                                    },
    { 0x01f4, "__setusermatherr"                                                                                                  },
    { 0x01f5, "__strncnt"                                                                                                         },
    { 0x01f6, "__swprintf_l"                                                                                                      },
    { 0x01f7, "__sys_errlist"                                                                                                     },
    { 0x01f8, "__sys_nerr"                                                                                                        },
    { 0x01f9, "__threadhandle"                                                                                                    },
    { 0x01fa, "__threadid"                                                                                                        },
    { 0x01fb, "__timezone"                                                                                                        },
    { 0x01fc, "__toascii"                                                                                                         },
    { 0x01fd, "__tzname"                                                                                                          },
    { 0x01fe, "__unDName"                                                                                                         },
    { 0x01ff, "__unDNameEx"                                                                                                       },
    { 0x0200, "__unDNameHelper"                                                                                                   },
    { 0x0114, "__uncaught_exception"                                                                                              },
    { 0x0201, "__unguarded_readlc_active"                                                                                         },
    { 0x0202, "__vswprintf_l"                                                                                                     },
    { 0x0203, "__wargv"                                                                                                           },
    { 0x0204, "__wcserror"                                                                                                        },
    { 0x0205, "__wcserror_s"                                                                                                      },
    { 0x0206, "__wcsncnt"                                                                                                         },
    { 0x0207, "__wgetmainargs"                                                                                                    },
    { 0x0208, "__winitenv"                                                                                                        },
    { 0x0209, "_abnormal_termination"                                                                                             },
    { 0x020a, "_abs64"                                                                                                            },
    { 0x020b, "_access"                                                                                                           },
    { 0x020c, "_access_s"                                                                                                         },
    { 0x020d, "_acmdln"                                                                                                           },
    { 0x020e, "_aligned_free"                                                                                                     },
    { 0x020f, "_aligned_malloc"                                                                                                   },
    { 0x0210, "_aligned_msize"                                                                                                    },
    { 0x0211, "_aligned_offset_malloc"                                                                                            },
    { 0x0212, "_aligned_offset_realloc"                                                                                           },
    { 0x0213, "_aligned_offset_recalloc"                                                                                          },
    { 0x0214, "_aligned_realloc"                                                                                                  },
    { 0x0215, "_aligned_recalloc"                                                                                                 },
    { 0x0216, "_amsg_exit"                                                                                                        },
    { 0x0217, "_assert"                                                                                                           },
    { 0x0218, "_atodbl"                                                                                                           },
    { 0x0219, "_atodbl_l"                                                                                                         },
    { 0x021a, "_atof_l"                                                                                                           },
    { 0x021b, "_atoflt"                                                                                                           },
    { 0x021c, "_atoflt_l"                                                                                                         },
    { 0x021d, "_atoi64"                                                                                                           },
    { 0x021e, "_atoi64_l"                                                                                                         },
    { 0x021f, "_atoi_l"                                                                                                           },
    { 0x0220, "_atol_l"                                                                                                           },
    { 0x0221, "_atoldbl"                                                                                                          },
    { 0x0222, "_atoldbl_l"                                                                                                        },
    { 0x0223, "_beep"                                                                                                             },
    { 0x0224, "_beginthread"                                                                                                      },
    { 0x0225, "_beginthreadex"                                                                                                    },
    { 0x0226, "_byteswap_uint64"                                                                                                  },
    { 0x0227, "_byteswap_ulong"                                                                                                   },
    { 0x0228, "_byteswap_ushort"                                                                                                  },
    { 0x0229, "_c_exit"                                                                                                           },
    { 0x022a, "_cabs"                                                                                                             },
    { 0x022b, "_callnewh"                                                                                                         },
    { 0x022c, "_calloc_crt"                                                                                                       },
    { 0x022d, "_cexit"                                                                                                            },
    { 0x022e, "_cgets"                                                                                                            },
    { 0x022f, "_cgets_s"                                                                                                          },
    { 0x0230, "_cgetws"                                                                                                           },
    { 0x0231, "_cgetws_s"                                                                                                         },
    { 0x0232, "_chdir"                                                                                                            },
    { 0x0233, "_chdrive"                                                                                                          },
    { 0x0234, "_chgsign"                                                                                                          },
    { 0x0235, "_chkesp"                                                                                                           },
    { 0x0236, "_chmod"                                                                                                            },
    { 0x0237, "_chsize"                                                                                                           },
    { 0x0238, "_chsize_s"                                                                                                         },
    { 0x0239, "_clearfp"                                                                                                          },
    { 0x023a, "_close"                                                                                                            },
    { 0x023b, "_commit"                                                                                                           },
    { 0x023c, "_commode"                                                                                                          },
    { 0x023d, "_configthreadlocale"                                                                                               },
    { 0x023e, "_control87"                                                                                                        },
    { 0x023f, "_controlfp"                                                                                                        },
    { 0x0240, "_controlfp_s"                                                                                                      },
    { 0x0241, "_copysign"                                                                                                         },
    { 0x0242, "_cprintf"                                                                                                          },
    { 0x0243, "_cprintf_l"                                                                                                        },
    { 0x0244, "_cprintf_p"                                                                                                        },
    { 0x0245, "_cprintf_p_l"                                                                                                      },
    { 0x0246, "_cprintf_s"                                                                                                        },
    { 0x0247, "_cprintf_s_l"                                                                                                      },
    { 0x0248, "_cputs"                                                                                                            },
    { 0x0249, "_cputws"                                                                                                           },
    { 0x024a, "_creat"                                                                                                            },
    { 0x024b, "_create_locale"                                                                                                    },
    { 0x024c, "_crt_debugger_hook"                                                                                                },
    { 0x024d, "_cscanf"                                                                                                           },
    { 0x024e, "_cscanf_l"                                                                                                         },
    { 0x024f, "_cscanf_s"                                                                                                         },
    { 0x0250, "_cscanf_s_l"                                                                                                       },
    { 0x0251, "_ctime32"                                                                                                          },
    { 0x0252, "_ctime32_s"                                                                                                        },
    { 0x0253, "_ctime64"                                                                                                          },
    { 0x0254, "_ctime64_s"                                                                                                        },
    { 0x0255, "_cwait"                                                                                                            },
    { 0x0256, "_cwprintf"                                                                                                         },
    { 0x0257, "_cwprintf_l"                                                                                                       },
    { 0x0258, "_cwprintf_p"                                                                                                       },
    { 0x0259, "_cwprintf_p_l"                                                                                                     },
    { 0x025a, "_cwprintf_s"                                                                                                       },
    { 0x025b, "_cwprintf_s_l"                                                                                                     },
    { 0x025c, "_cwscanf"                                                                                                          },
    { 0x025d, "_cwscanf_l"                                                                                                        },
    { 0x025e, "_cwscanf_s"                                                                                                        },
    { 0x025f, "_cwscanf_s_l"                                                                                                      },
    { 0x0260, "_daylight"                                                                                                         },
    { 0x0261, "_difftime32"                                                                                                       },
    { 0x0262, "_difftime64"                                                                                                       },
    { 0x0263, "_dosmaperr"                                                                                                        },
    { 0x0264, "_dstbias"                                                                                                          },
    { 0x0265, "_dup"                                                                                                              },
    { 0x0266, "_dup2"                                                                                                             },
    { 0x0267, "_dupenv_s"                                                                                                         },
    { 0x0268, "_ecvt"                                                                                                             },
    { 0x0269, "_ecvt_s"                                                                                                           },
    { 0x026a, "_endthread"                                                                                                        },
    { 0x026b, "_endthreadex"                                                                                                      },
    { 0x026c, "_environ"                                                                                                          },
    { 0x026d, "_eof"                                                                                                              },
    { 0x026e, "_errno"                                                                                                            },
    { 0x026f, "_except_handler2"                                                                                                  },
    { 0x0270, "_except_handler3"                                                                                                  },
    { 0x0271, "_except_handler4_common"                                                                                           },
    { 0x0272, "_execl"                                                                                                            },
    { 0x0273, "_execle"                                                                                                           },
    { 0x0274, "_execlp"                                                                                                           },
    { 0x0275, "_execlpe"                                                                                                          },
    { 0x0276, "_execv"                                                                                                            },
    { 0x0277, "_execve"                                                                                                           },
    { 0x0278, "_execvp"                                                                                                           },
    { 0x0279, "_execvpe"                                                                                                          },
    { 0x027a, "_exit"                                                                                                             },
    { 0x027b, "_expand"                                                                                                           },
    { 0x027c, "_fclose_nolock"                                                                                                    },
    { 0x027d, "_fcloseall"                                                                                                        },
    { 0x027e, "_fcvt"                                                                                                             },
    { 0x027f, "_fcvt_s"                                                                                                           },
    { 0x0280, "_fdopen"                                                                                                           },
    { 0x0281, "_fflush_nolock"                                                                                                    },
    { 0x0282, "_fgetchar"                                                                                                         },
    { 0x0283, "_fgetwc_nolock"                                                                                                    },
    { 0x0284, "_fgetwchar"                                                                                                        },
    { 0x0285, "_filbuf"                                                                                                           },
    { 0x0286, "_filelength"                                                                                                       },
    { 0x0287, "_filelengthi64"                                                                                                    },
    { 0x0288, "_fileno"                                                                                                           },
    { 0x0289, "_findclose"                                                                                                        },
    { 0x028a, "_findfirst32"                                                                                                      },
    { 0x028b, "_findfirst32i64"                                                                                                   },
    { 0x028c, "_findfirst64"                                                                                                      },
    { 0x028d, "_findfirst64i32"                                                                                                   },
    { 0x028e, "_findnext32"                                                                                                       },
    { 0x028f, "_findnext32i64"                                                                                                    },
    { 0x0290, "_findnext64"                                                                                                       },
    { 0x0291, "_findnext64i32"                                                                                                    },
    { 0x0292, "_finite"                                                                                                           },
    { 0x0293, "_flsbuf"                                                                                                           },
    { 0x0294, "_flushall"                                                                                                         },
    { 0x0295, "_fmode"                                                                                                            },
    { 0x0296, "_fpclass"                                                                                                          },
    { 0x0297, "_fpieee_flt"                                                                                                       },
    { 0x0298, "_fpreset"                                                                                                          },
    { 0x0299, "_fprintf_l"                                                                                                        },
    { 0x029a, "_fprintf_p"                                                                                                        },
    { 0x029b, "_fprintf_p_l"                                                                                                      },
    { 0x029c, "_fprintf_s_l"                                                                                                      },
    { 0x029d, "_fputchar"                                                                                                         },
    { 0x029e, "_fputwc_nolock"                                                                                                    },
    { 0x029f, "_fputwchar"                                                                                                        },
    { 0x02a0, "_fread_nolock"                                                                                                     },
    { 0x02a1, "_fread_nolock_s"                                                                                                   },
    { 0x02a2, "_free_locale"                                                                                                      },
    { 0x02a3, "_freea"                                                                                                            },
    { 0x02a4, "_freea_s"                                                                                                          },
    { 0x02a5, "_freefls"                                                                                                          },
    { 0x02a6, "_fscanf_l"                                                                                                         },
    { 0x02a7, "_fscanf_s_l"                                                                                                       },
    { 0x02a8, "_fseek_nolock"                                                                                                     },
    { 0x02a9, "_fseeki64"                                                                                                         },
    { 0x02aa, "_fseeki64_nolock"                                                                                                  },
    { 0x02ab, "_fsopen"                                                                                                           },
    { 0x02ac, "_fstat32"                                                                                                          },
    { 0x02ad, "_fstat32i64"                                                                                                       },
    { 0x02ae, "_fstat64"                                                                                                          },
    { 0x02af, "_fstat64i32"                                                                                                       },
    { 0x02b0, "_ftell_nolock"                                                                                                     },
    { 0x02b1, "_ftelli64"                                                                                                         },
    { 0x02b2, "_ftelli64_nolock"                                                                                                  },
    { 0x02b3, "_ftime32"                                                                                                          },
    { 0x02b4, "_ftime32_s"                                                                                                        },
    { 0x02b5, "_ftime64"                                                                                                          },
    { 0x02b6, "_ftime64_s"                                                                                                        },
    { 0x02b7, "_ftol"                                                                                                             },
    { 0x02b8, "_fullpath"                                                                                                         },
    { 0x02b9, "_futime32"                                                                                                         },
    { 0x02ba, "_futime64"                                                                                                         },
    { 0x02bb, "_fwprintf_l"                                                                                                       },
    { 0x02bc, "_fwprintf_p"                                                                                                       },
    { 0x02bd, "_fwprintf_p_l"                                                                                                     },
    { 0x02be, "_fwprintf_s_l"                                                                                                     },
    { 0x02bf, "_fwrite_nolock"                                                                                                    },
    { 0x02c0, "_fwscanf_l"                                                                                                        },
    { 0x02c1, "_fwscanf_s_l"                                                                                                      },
    { 0x02c2, "_gcvt"                                                                                                             },
    { 0x02c3, "_gcvt_s"                                                                                                           },
    { 0x02c4, "_get_current_locale"                                                                                               },
    { 0x02c5, "_get_daylight"                                                                                                     },
    { 0x02c6, "_get_doserrno"                                                                                                     },
    { 0x02c7, "_get_dstbias"                                                                                                      },
    { 0x02c8, "_get_errno"                                                                                                        },
    { 0x02c9, "_get_fmode"                                                                                                        },
    { 0x02ca, "_get_heap_handle"                                                                                                  },
    { 0x02cb, "_get_invalid_parameter_handler"                                                                                    },
    { 0x02cc, "_get_osfhandle"                                                                                                    },
    { 0x02cd, "_get_output_format"                                                                                                },
    { 0x02ce, "_get_pgmptr"                                                                                                       },
    { 0x02cf, "_get_printf_count_output"                                                                                          },
    { 0x02d0, "_get_purecall_handler"                                                                                             },
    { 0x02d1, "_get_terminate"                                                                                                    },
    { 0x02d2, "_get_timezone"                                                                                                     },
    { 0x02d3, "_get_tzname"                                                                                                       },
    { 0x02d4, "_get_unexpected"                                                                                                   },
    { 0x02d5, "_get_wpgmptr"                                                                                                      },
    { 0x02d6, "_getc_nolock"                                                                                                      },
    { 0x02d7, "_getch"                                                                                                            },
    { 0x02d8, "_getch_nolock"                                                                                                     },
    { 0x02d9, "_getche"                                                                                                           },
    { 0x02da, "_getche_nolock"                                                                                                    },
    { 0x02db, "_getcwd"                                                                                                           },
    { 0x02dc, "_getdcwd"                                                                                                          },
    { 0x02dd, "_getdiskfree"                                                                                                      },
    { 0x02de, "_getdllprocaddr"                                                                                                   },
    { 0x02df, "_getdrive"                                                                                                         },
    { 0x02e0, "_getdrives"                                                                                                        },
    { 0x02e1, "_getmaxstdio"                                                                                                      },
    { 0x02e2, "_getmbcp"                                                                                                          },
    { 0x02e3, "_getpid"                                                                                                           },
    { 0x02e4, "_getptd"                                                                                                           },
    { 0x02e5, "_getsystime"                                                                                                       },
    { 0x02e6, "_getw"                                                                                                             },
    { 0x02e7, "_getwch"                                                                                                           },
    { 0x02e8, "_getwch_nolock"                                                                                                    },
    { 0x02e9, "_getwche"                                                                                                          },
    { 0x02ea, "_getwche_nolock"                                                                                                   },
    { 0x02eb, "_getws"                                                                                                            },
    { 0x02ec, "_getws_s"                                                                                                          },
    { 0x02ed, "_global_unwind2"                                                                                                   },
    { 0x02ee, "_gmtime32"                                                                                                         },
    { 0x02ef, "_gmtime32_s"                                                                                                       },
    { 0x02f0, "_gmtime64"                                                                                                         },
    { 0x02f1, "_gmtime64_s"                                                                                                       },
    { 0x02f2, "_heapadd"                                                                                                          },
    { 0x02f3, "_heapchk"                                                                                                          },
    { 0x02f4, "_heapmin"                                                                                                          },
    { 0x02f5, "_heapset"                                                                                                          },
    { 0x02f6, "_heapused"                                                                                                         },
    { 0x02f7, "_heapwalk"                                                                                                         },
    { 0x02f8, "_hypot"                                                                                                            },
    { 0x02f9, "_hypotf"                                                                                                           },
    { 0x02fa, "_i64toa"                                                                                                           },
    { 0x02fb, "_i64toa_s"                                                                                                         },
    { 0x02fc, "_i64tow"                                                                                                           },
    { 0x02fd, "_i64tow_s"                                                                                                         },
    { 0x02fe, "_initptd"                                                                                                          },
    { 0x02ff, "_initterm"                                                                                                         },
    { 0x0300, "_initterm_e"                                                                                                       },
    { 0x0301, "_inp"                                                                                                              },
    { 0x0302, "_inpd"                                                                                                             },
    { 0x0303, "_inpw"                                                                                                             },
    { 0x0304, "_invalid_parameter"                                                                                                },
    { 0x0305, "_invalid_parameter_noinfo"                                                                                         },
    { 0x0306, "_invalid_parameter_noinfo_noreturn"                                                                                },
    { 0x0307, "_invoke_watson"                                                                                                    },
    { 0x0308, "_iob"                                                                                                              },
    { 0x0309, "_isalnum_l"                                                                                                        },
    { 0x030a, "_isalpha_l"                                                                                                        },
    { 0x030b, "_isatty"                                                                                                           },
    { 0x030c, "_iscntrl_l"                                                                                                        },
    { 0x030d, "_isctype"                                                                                                          },
    { 0x030e, "_isctype_l"                                                                                                        },
    { 0x030f, "_isdigit_l"                                                                                                        },
    { 0x0310, "_isgraph_l"                                                                                                        },
    { 0x0311, "_isleadbyte_l"                                                                                                     },
    { 0x0312, "_islower_l"                                                                                                        },
    { 0x0313, "_ismbbalnum"                                                                                                       },
    { 0x0314, "_ismbbalnum_l"                                                                                                     },
    { 0x0315, "_ismbbalpha"                                                                                                       },
    { 0x0316, "_ismbbalpha_l"                                                                                                     },
    { 0x0317, "_ismbbgraph"                                                                                                       },
    { 0x0318, "_ismbbgraph_l"                                                                                                     },
    { 0x0319, "_ismbbkalnum"                                                                                                      },
    { 0x031a, "_ismbbkalnum_l"                                                                                                    },
    { 0x031b, "_ismbbkana"                                                                                                        },
    { 0x031c, "_ismbbkana_l"                                                                                                      },
    { 0x031d, "_ismbbkprint"                                                                                                      },
    { 0x031e, "_ismbbkprint_l"                                                                                                    },
    { 0x031f, "_ismbbkpunct"                                                                                                      },
    { 0x0320, "_ismbbkpunct_l"                                                                                                    },
    { 0x0321, "_ismbblead"                                                                                                        },
    { 0x0322, "_ismbblead_l"                                                                                                      },
    { 0x0323, "_ismbbprint"                                                                                                       },
    { 0x0324, "_ismbbprint_l"                                                                                                     },
    { 0x0325, "_ismbbpunct"                                                                                                       },
    { 0x0326, "_ismbbpunct_l"                                                                                                     },
    { 0x0327, "_ismbbtrail"                                                                                                       },
    { 0x0328, "_ismbbtrail_l"                                                                                                     },
    { 0x0329, "_ismbcalnum"                                                                                                       },
    { 0x032a, "_ismbcalnum_l"                                                                                                     },
    { 0x032b, "_ismbcalpha"                                                                                                       },
    { 0x032c, "_ismbcalpha_l"                                                                                                     },
    { 0x032d, "_ismbcdigit"                                                                                                       },
    { 0x032e, "_ismbcdigit_l"                                                                                                     },
    { 0x032f, "_ismbcgraph"                                                                                                       },
    { 0x0330, "_ismbcgraph_l"                                                                                                     },
    { 0x0331, "_ismbchira"                                                                                                        },
    { 0x0332, "_ismbchira_l"                                                                                                      },
    { 0x0333, "_ismbckata"                                                                                                        },
    { 0x0334, "_ismbckata_l"                                                                                                      },
    { 0x0335, "_ismbcl0"                                                                                                          },
    { 0x0336, "_ismbcl0_l"                                                                                                        },
    { 0x0337, "_ismbcl1"                                                                                                          },
    { 0x0338, "_ismbcl1_l"                                                                                                        },
    { 0x0339, "_ismbcl2"                                                                                                          },
    { 0x033a, "_ismbcl2_l"                                                                                                        },
    { 0x033b, "_ismbclegal"                                                                                                       },
    { 0x033c, "_ismbclegal_l"                                                                                                     },
    { 0x033d, "_ismbclower"                                                                                                       },
    { 0x033e, "_ismbclower_l"                                                                                                     },
    { 0x033f, "_ismbcprint"                                                                                                       },
    { 0x0340, "_ismbcprint_l"                                                                                                     },
    { 0x0341, "_ismbcpunct"                                                                                                       },
    { 0x0342, "_ismbcpunct_l"                                                                                                     },
    { 0x0343, "_ismbcspace"                                                                                                       },
    { 0x0344, "_ismbcspace_l"                                                                                                     },
    { 0x0345, "_ismbcsymbol"                                                                                                      },
    { 0x0346, "_ismbcsymbol_l"                                                                                                    },
    { 0x0347, "_ismbcupper"                                                                                                       },
    { 0x0348, "_ismbcupper_l"                                                                                                     },
    { 0x0349, "_ismbslead"                                                                                                        },
    { 0x034a, "_ismbslead_l"                                                                                                      },
    { 0x034b, "_ismbstrail"                                                                                                       },
    { 0x034c, "_ismbstrail_l"                                                                                                     },
    { 0x034d, "_isnan"                                                                                                            },
    { 0x034e, "_isprint_l"                                                                                                        },
    { 0x034f, "_ispunct_l"                                                                                                        },
    { 0x0350, "_isspace_l"                                                                                                        },
    { 0x0351, "_isupper_l"                                                                                                        },
    { 0x0352, "_iswalnum_l"                                                                                                       },
    { 0x0353, "_iswalpha_l"                                                                                                       },
    { 0x0354, "_iswcntrl_l"                                                                                                       },
    { 0x0355, "_iswcsym_l"                                                                                                        },
    { 0x0356, "_iswcsymf_l"                                                                                                       },
    { 0x0357, "_iswctype_l"                                                                                                       },
    { 0x0358, "_iswdigit_l"                                                                                                       },
    { 0x0359, "_iswgraph_l"                                                                                                       },
    { 0x035a, "_iswlower_l"                                                                                                       },
    { 0x035b, "_iswprint_l"                                                                                                       },
    { 0x035c, "_iswpunct_l"                                                                                                       },
    { 0x035d, "_iswspace_l"                                                                                                       },
    { 0x035e, "_iswupper_l"                                                                                                       },
    { 0x035f, "_iswxdigit_l"                                                                                                      },
    { 0x0360, "_isxdigit_l"                                                                                                       },
    { 0x0361, "_itoa"                                                                                                             },
    { 0x0362, "_itoa_s"                                                                                                           },
    { 0x0363, "_itow"                                                                                                             },
    { 0x0364, "_itow_s"                                                                                                           },
    { 0x0365, "_j0"                                                                                                               },
    { 0x0366, "_j1"                                                                                                               },
    { 0x0367, "_jn"                                                                                                               },
    { 0x0368, "_kbhit"                                                                                                            },
    { 0x0369, "_lfind"                                                                                                            },
    { 0x036a, "_lfind_s"                                                                                                          },
    { 0x036b, "_libm_sse2_acos_precise"                                                                                           },
    { 0x036c, "_libm_sse2_asin_precise"                                                                                           },
    { 0x036d, "_libm_sse2_atan_precise"                                                                                           },
    { 0x036e, "_libm_sse2_cos_precise"                                                                                            },
    { 0x036f, "_libm_sse2_exp_precise"                                                                                            },
    { 0x0370, "_libm_sse2_log10_precise"                                                                                          },
    { 0x0371, "_libm_sse2_log_precise"                                                                                            },
    { 0x0372, "_libm_sse2_pow_precise"                                                                                            },
    { 0x0373, "_libm_sse2_sin_precise"                                                                                            },
    { 0x0374, "_libm_sse2_sqrt_precise"                                                                                           },
    { 0x0375, "_libm_sse2_tan_precise"                                                                                            },
    { 0x0376, "_loaddll"                                                                                                          },
    { 0x0377, "_local_unwind2"                                                                                                    },
    { 0x0378, "_local_unwind4"                                                                                                    },
    { 0x0379, "_localtime32"                                                                                                      },
    { 0x037a, "_localtime32_s"                                                                                                    },
    { 0x037b, "_localtime64"                                                                                                      },
    { 0x037c, "_localtime64_s"                                                                                                    },
    { 0x037d, "_lock"                                                                                                             },
    { 0x037e, "_lock_file"                                                                                                        },
    { 0x037f, "_locking"                                                                                                          },
    { 0x0380, "_logb"                                                                                                             },
    { 0x0381, "_longjmpex"                                                                                                        },
    { 0x0382, "_lrotl"                                                                                                            },
    { 0x0383, "_lrotr"                                                                                                            },
    { 0x0384, "_lsearch"                                                                                                          },
    { 0x0385, "_lsearch_s"                                                                                                        },
    { 0x0386, "_lseek"                                                                                                            },
    { 0x0387, "_lseeki64"                                                                                                         },
    { 0x0388, "_ltoa"                                                                                                             },
    { 0x0389, "_ltoa_s"                                                                                                           },
    { 0x038a, "_ltow"                                                                                                             },
    { 0x038b, "_ltow_s"                                                                                                           },
    { 0x038c, "_makepath"                                                                                                         },
    { 0x038d, "_makepath_s"                                                                                                       },
    { 0x038e, "_malloc_crt"                                                                                                       },
    { 0x038f, "_mbbtombc"                                                                                                         },
    { 0x0390, "_mbbtombc_l"                                                                                                       },
    { 0x0391, "_mbbtype"                                                                                                          },
    { 0x0392, "_mbbtype_l"                                                                                                        },
    { 0x0393, "_mbcasemap"                                                                                                        },
    { 0x0394, "_mbccpy"                                                                                                           },
    { 0x0395, "_mbccpy_l"                                                                                                         },
    { 0x0396, "_mbccpy_s"                                                                                                         },
    { 0x0397, "_mbccpy_s_l"                                                                                                       },
    { 0x0398, "_mbcjistojms"                                                                                                      },
    { 0x0399, "_mbcjistojms_l"                                                                                                    },
    { 0x039a, "_mbcjmstojis"                                                                                                      },
    { 0x039b, "_mbcjmstojis_l"                                                                                                    },
    { 0x039c, "_mbclen"                                                                                                           },
    { 0x039d, "_mbclen_l"                                                                                                         },
    { 0x039e, "_mbctohira"                                                                                                        },
    { 0x039f, "_mbctohira_l"                                                                                                      },
    { 0x03a0, "_mbctokata"                                                                                                        },
    { 0x03a1, "_mbctokata_l"                                                                                                      },
    { 0x03a2, "_mbctolower"                                                                                                       },
    { 0x03a3, "_mbctolower_l"                                                                                                     },
    { 0x03a4, "_mbctombb"                                                                                                         },
    { 0x03a5, "_mbctombb_l"                                                                                                       },
    { 0x03a6, "_mbctoupper"                                                                                                       },
    { 0x03a7, "_mbctoupper_l"                                                                                                     },
    { 0x03a8, "_mbctype"                                                                                                          },
    { 0x03a9, "_mblen_l"                                                                                                          },
    { 0x03aa, "_mbsbtype"                                                                                                         },
    { 0x03ab, "_mbsbtype_l"                                                                                                       },
    { 0x03ac, "_mbscat_s"                                                                                                         },
    { 0x03ad, "_mbscat_s_l"                                                                                                       },
    { 0x03ae, "_mbschr"                                                                                                           },
    { 0x03af, "_mbschr_l"                                                                                                         },
    { 0x03b0, "_mbscmp"                                                                                                           },
    { 0x03b1, "_mbscmp_l"                                                                                                         },
    { 0x03b2, "_mbscoll"                                                                                                          },
    { 0x03b3, "_mbscoll_l"                                                                                                        },
    { 0x03b4, "_mbscpy_s"                                                                                                         },
    { 0x03b5, "_mbscpy_s_l"                                                                                                       },
    { 0x03b6, "_mbscspn"                                                                                                          },
    { 0x03b7, "_mbscspn_l"                                                                                                        },
    { 0x03b8, "_mbsdec"                                                                                                           },
    { 0x03b9, "_mbsdec_l"                                                                                                         },
    { 0x03ba, "_mbsicmp"                                                                                                          },
    { 0x03bb, "_mbsicmp_l"                                                                                                        },
    { 0x03bc, "_mbsicoll"                                                                                                         },
    { 0x03bd, "_mbsicoll_l"                                                                                                       },
    { 0x03be, "_mbsinc"                                                                                                           },
    { 0x03bf, "_mbsinc_l"                                                                                                         },
    { 0x03c0, "_mbslen"                                                                                                           },
    { 0x03c1, "_mbslen_l"                                                                                                         },
    { 0x03c2, "_mbslwr"                                                                                                           },
    { 0x03c3, "_mbslwr_l"                                                                                                         },
    { 0x03c4, "_mbslwr_s"                                                                                                         },
    { 0x03c5, "_mbslwr_s_l"                                                                                                       },
    { 0x03c6, "_mbsnbcat"                                                                                                         },
    { 0x03c7, "_mbsnbcat_l"                                                                                                       },
    { 0x03c8, "_mbsnbcat_s"                                                                                                       },
    { 0x03c9, "_mbsnbcat_s_l"                                                                                                     },
    { 0x03ca, "_mbsnbcmp"                                                                                                         },
    { 0x03cb, "_mbsnbcmp_l"                                                                                                       },
    { 0x03cc, "_mbsnbcnt"                                                                                                         },
    { 0x03cd, "_mbsnbcnt_l"                                                                                                       },
    { 0x03ce, "_mbsnbcoll"                                                                                                        },
    { 0x03cf, "_mbsnbcoll_l"                                                                                                      },
    { 0x03d0, "_mbsnbcpy"                                                                                                         },
    { 0x03d1, "_mbsnbcpy_l"                                                                                                       },
    { 0x03d2, "_mbsnbcpy_s"                                                                                                       },
    { 0x03d3, "_mbsnbcpy_s_l"                                                                                                     },
    { 0x03d4, "_mbsnbicmp"                                                                                                        },
    { 0x03d5, "_mbsnbicmp_l"                                                                                                      },
    { 0x03d6, "_mbsnbicoll"                                                                                                       },
    { 0x03d7, "_mbsnbicoll_l"                                                                                                     },
    { 0x03d8, "_mbsnbset"                                                                                                         },
    { 0x03d9, "_mbsnbset_l"                                                                                                       },
    { 0x03da, "_mbsnbset_s"                                                                                                       },
    { 0x03db, "_mbsnbset_s_l"                                                                                                     },
    { 0x03dc, "_mbsncat"                                                                                                          },
    { 0x03dd, "_mbsncat_l"                                                                                                        },
    { 0x03de, "_mbsncat_s"                                                                                                        },
    { 0x03df, "_mbsncat_s_l"                                                                                                      },
    { 0x03e0, "_mbsnccnt"                                                                                                         },
    { 0x03e1, "_mbsnccnt_l"                                                                                                       },
    { 0x03e2, "_mbsncmp"                                                                                                          },
    { 0x03e3, "_mbsncmp_l"                                                                                                        },
    { 0x03e4, "_mbsncoll"                                                                                                         },
    { 0x03e5, "_mbsncoll_l"                                                                                                       },
    { 0x03e6, "_mbsncpy"                                                                                                          },
    { 0x03e7, "_mbsncpy_l"                                                                                                        },
    { 0x03e8, "_mbsncpy_s"                                                                                                        },
    { 0x03e9, "_mbsncpy_s_l"                                                                                                      },
    { 0x03ea, "_mbsnextc"                                                                                                         },
    { 0x03eb, "_mbsnextc_l"                                                                                                       },
    { 0x03ec, "_mbsnicmp"                                                                                                         },
    { 0x03ed, "_mbsnicmp_l"                                                                                                       },
    { 0x03ee, "_mbsnicoll"                                                                                                        },
    { 0x03ef, "_mbsnicoll_l"                                                                                                      },
    { 0x03f0, "_mbsninc"                                                                                                          },
    { 0x03f1, "_mbsninc_l"                                                                                                        },
    { 0x03f2, "_mbsnlen"                                                                                                          },
    { 0x03f3, "_mbsnlen_l"                                                                                                        },
    { 0x03f4, "_mbsnset"                                                                                                          },
    { 0x03f5, "_mbsnset_l"                                                                                                        },
    { 0x03f6, "_mbsnset_s"                                                                                                        },
    { 0x03f7, "_mbsnset_s_l"                                                                                                      },
    { 0x03f8, "_mbspbrk"                                                                                                          },
    { 0x03f9, "_mbspbrk_l"                                                                                                        },
    { 0x03fa, "_mbsrchr"                                                                                                          },
    { 0x03fb, "_mbsrchr_l"                                                                                                        },
    { 0x03fc, "_mbsrev"                                                                                                           },
    { 0x03fd, "_mbsrev_l"                                                                                                         },
    { 0x03fe, "_mbsset"                                                                                                           },
    { 0x03ff, "_mbsset_l"                                                                                                         },
    { 0x0400, "_mbsset_s"                                                                                                         },
    { 0x0401, "_mbsset_s_l"                                                                                                       },
    { 0x0402, "_mbsspn"                                                                                                           },
    { 0x0403, "_mbsspn_l"                                                                                                         },
    { 0x0404, "_mbsspnp"                                                                                                          },
    { 0x0405, "_mbsspnp_l"                                                                                                        },
    { 0x0406, "_mbsstr"                                                                                                           },
    { 0x0407, "_mbsstr_l"                                                                                                         },
    { 0x0408, "_mbstok"                                                                                                           },
    { 0x0409, "_mbstok_l"                                                                                                         },
    { 0x040a, "_mbstok_s"                                                                                                         },
    { 0x040b, "_mbstok_s_l"                                                                                                       },
    { 0x040c, "_mbstowcs_l"                                                                                                       },
    { 0x040d, "_mbstowcs_s_l"                                                                                                     },
    { 0x040e, "_mbstrlen"                                                                                                         },
    { 0x040f, "_mbstrlen_l"                                                                                                       },
    { 0x0410, "_mbstrnlen"                                                                                                        },
    { 0x0411, "_mbstrnlen_l"                                                                                                      },
    { 0x0412, "_mbsupr"                                                                                                           },
    { 0x0413, "_mbsupr_l"                                                                                                         },
    { 0x0414, "_mbsupr_s"                                                                                                         },
    { 0x0415, "_mbsupr_s_l"                                                                                                       },
    { 0x0416, "_mbtowc_l"                                                                                                         },
    { 0x0417, "_memccpy"                                                                                                          },
    { 0x0418, "_memicmp"                                                                                                          },
    { 0x0419, "_memicmp_l"                                                                                                        },
    { 0x041a, "_mkdir"                                                                                                            },
    { 0x041b, "_mkgmtime32"                                                                                                       },
    { 0x041c, "_mkgmtime64"                                                                                                       },
    { 0x041d, "_mktemp"                                                                                                           },
    { 0x041e, "_mktemp_s"                                                                                                         },
    { 0x041f, "_mktime32"                                                                                                         },
    { 0x0420, "_mktime64"                                                                                                         },
    { 0x0421, "_msize"                                                                                                            },
    { 0x0422, "_nextafter"                                                                                                        },
    { 0x0423, "_onexit"                                                                                                           },
    { 0x0424, "_open"                                                                                                             },
    { 0x0425, "_open_osfhandle"                                                                                                   },
    { 0x0426, "_outp"                                                                                                             },
    { 0x0427, "_outpd"                                                                                                            },
    { 0x0428, "_outpw"                                                                                                            },
    { 0x0429, "_pclose"                                                                                                           },
    { 0x042a, "_pctype"                                                                                                           },
    { 0x042b, "_pgmptr"                                                                                                           },
    { 0x042c, "_pipe"                                                                                                             },
    { 0x042d, "_popen"                                                                                                            },
    { 0x042e, "_printf_l"                                                                                                         },
    { 0x042f, "_printf_p"                                                                                                         },
    { 0x0430, "_printf_p_l"                                                                                                       },
    { 0x0431, "_printf_s_l"                                                                                                       },
    { 0x0432, "_purecall"                                                                                                         },
    { 0x0433, "_putch"                                                                                                            },
    { 0x0434, "_putch_nolock"                                                                                                     },
    { 0x0435, "_putenv"                                                                                                           },
    { 0x0436, "_putenv_s"                                                                                                         },
    { 0x0437, "_putw"                                                                                                             },
    { 0x0438, "_putwch"                                                                                                           },
    { 0x0439, "_putwch_nolock"                                                                                                    },
    { 0x043a, "_putws"                                                                                                            },
    { 0x043b, "_pwctype"                                                                                                          },
    { 0x043c, "_read"                                                                                                             },
    { 0x043d, "_realloc_crt"                                                                                                      },
    { 0x043e, "_recalloc"                                                                                                         },
    { 0x043f, "_recalloc_crt"                                                                                                     },
    { 0x0440, "_resetstkoflw"                                                                                                     },
    { 0x0441, "_rmdir"                                                                                                            },
    { 0x0442, "_rmtmp"                                                                                                            },
    { 0x0443, "_rotl"                                                                                                             },
    { 0x0444, "_rotl64"                                                                                                           },
    { 0x0445, "_rotr"                                                                                                             },
    { 0x0446, "_rotr64"                                                                                                           },
    { 0x0447, "_scalb"                                                                                                            },
    { 0x0448, "_scanf_l"                                                                                                          },
    { 0x0449, "_scanf_s_l"                                                                                                        },
    { 0x044a, "_scprintf"                                                                                                         },
    { 0x044b, "_scprintf_l"                                                                                                       },
    { 0x044c, "_scprintf_p"                                                                                                       },
    { 0x044d, "_scprintf_p_l"                                                                                                     },
    { 0x044e, "_scwprintf"                                                                                                        },
    { 0x044f, "_scwprintf_l"                                                                                                      },
    { 0x0450, "_scwprintf_p"                                                                                                      },
    { 0x0451, "_scwprintf_p_l"                                                                                                    },
    { 0x0452, "_searchenv"                                                                                                        },
    { 0x0453, "_searchenv_s"                                                                                                      },
    { 0x0455, "_seh_longjmp_unwind"                                                                                               },
    { 0x0454, "_seh_longjmp_unwind4"                                                                                              },
    { 0x0456, "_set_SSE2_enable"                                                                                                  },
    { 0x0457, "_set_abort_behavior"                                                                                               },
    { 0x0458, "_set_controlfp"                                                                                                    },
    { 0x0459, "_set_doserrno"                                                                                                     },
    { 0x045a, "_set_errno"                                                                                                        },
    { 0x045b, "_set_error_mode"                                                                                                   },
    { 0x045c, "_set_fmode"                                                                                                        },
    { 0x045d, "_set_invalid_parameter_handler"                                                                                    },
    { 0x045e, "_set_malloc_crt_max_wait"                                                                                          },
    { 0x045f, "_set_output_format"                                                                                                },
    { 0x0460, "_set_printf_count_output"                                                                                          },
    { 0x0461, "_set_purecall_handler"                                                                                             },
    { 0x0462, "_seterrormode"                                                                                                     },
    { 0x0463, "_setjmp"                                                                                                           },
    { 0x0464, "_setjmp3"                                                                                                          },
    { 0x0465, "_setmaxstdio"                                                                                                      },
    { 0x0466, "_setmbcp"                                                                                                          },
    { 0x0467, "_setmode"                                                                                                          },
    { 0x0468, "_setsystime"                                                                                                       },
    { 0x0469, "_sleep"                                                                                                            },
    { 0x046a, "_snprintf"                                                                                                         },
    { 0x046b, "_snprintf_c"                                                                                                       },
    { 0x046c, "_snprintf_c_l"                                                                                                     },
    { 0x046d, "_snprintf_l"                                                                                                       },
    { 0x046e, "_snprintf_s"                                                                                                       },
    { 0x046f, "_snprintf_s_l"                                                                                                     },
    { 0x0470, "_snscanf"                                                                                                          },
    { 0x0471, "_snscanf_l"                                                                                                        },
    { 0x0472, "_snscanf_s"                                                                                                        },
    { 0x0473, "_snscanf_s_l"                                                                                                      },
    { 0x0474, "_snwprintf"                                                                                                        },
    { 0x0475, "_snwprintf_l"                                                                                                      },
    { 0x0476, "_snwprintf_s"                                                                                                      },
    { 0x0477, "_snwprintf_s_l"                                                                                                    },
    { 0x0478, "_snwscanf"                                                                                                         },
    { 0x0479, "_snwscanf_l"                                                                                                       },
    { 0x047a, "_snwscanf_s"                                                                                                       },
    { 0x047b, "_snwscanf_s_l"                                                                                                     },
    { 0x047c, "_sopen"                                                                                                            },
    { 0x047d, "_sopen_s"                                                                                                          },
    { 0x047e, "_spawnl"                                                                                                           },
    { 0x047f, "_spawnle"                                                                                                          },
    { 0x0480, "_spawnlp"                                                                                                          },
    { 0x0481, "_spawnlpe"                                                                                                         },
    { 0x0482, "_spawnv"                                                                                                           },
    { 0x0483, "_spawnve"                                                                                                          },
    { 0x0484, "_spawnvp"                                                                                                          },
    { 0x0485, "_spawnvpe"                                                                                                         },
    { 0x0486, "_splitpath"                                                                                                        },
    { 0x0487, "_splitpath_s"                                                                                                      },
    { 0x0488, "_sprintf_l"                                                                                                        },
    { 0x0489, "_sprintf_p"                                                                                                        },
    { 0x048a, "_sprintf_p_l"                                                                                                      },
    { 0x048b, "_sprintf_s_l"                                                                                                      },
    { 0x048c, "_sscanf_l"                                                                                                         },
    { 0x048d, "_sscanf_s_l"                                                                                                       },
    { 0x048e, "_stat32"                                                                                                           },
    { 0x048f, "_stat32i64"                                                                                                        },
    { 0x0490, "_stat64"                                                                                                           },
    { 0x0491, "_stat64i32"                                                                                                        },
    { 0x0492, "_statusfp"                                                                                                         },
    { 0x0493, "_statusfp2"                                                                                                        },
    { 0x0494, "_strcoll_l"                                                                                                        },
    { 0x0495, "_strdate"                                                                                                          },
    { 0x0496, "_strdate_s"                                                                                                        },
    { 0x0497, "_strdup"                                                                                                           },
    { 0x0498, "_strerror"                                                                                                         },
    { 0x0499, "_strerror_s"                                                                                                       },
    { 0x049a, "_strftime_l"                                                                                                       },
    { 0x049b, "_stricmp"                                                                                                          },
    { 0x049c, "_stricmp_l"                                                                                                        },
    { 0x049d, "_stricoll"                                                                                                         },
    { 0x049e, "_stricoll_l"                                                                                                       },
    { 0x049f, "_strlwr"                                                                                                           },
    { 0x04a0, "_strlwr_l"                                                                                                         },
    { 0x04a1, "_strlwr_s"                                                                                                         },
    { 0x04a2, "_strlwr_s_l"                                                                                                       },
    { 0x04a3, "_strncoll"                                                                                                         },
    { 0x04a4, "_strncoll_l"                                                                                                       },
    { 0x04a5, "_strnicmp"                                                                                                         },
    { 0x04a6, "_strnicmp_l"                                                                                                       },
    { 0x04a7, "_strnicoll"                                                                                                        },
    { 0x04a8, "_strnicoll_l"                                                                                                      },
    { 0x04a9, "_strnset"                                                                                                          },
    { 0x04aa, "_strnset_s"                                                                                                        },
    { 0x04ab, "_strrev"                                                                                                           },
    { 0x04ac, "_strset"                                                                                                           },
    { 0x04ad, "_strset_s"                                                                                                         },
    { 0x04ae, "_strtime"                                                                                                          },
    { 0x04af, "_strtime_s"                                                                                                        },
    { 0x04b0, "_strtod_l"                                                                                                         },
    { 0x04b1, "_strtoi64"                                                                                                         },
    { 0x04b2, "_strtoi64_l"                                                                                                       },
    { 0x04b3, "_strtol_l"                                                                                                         },
    { 0x04b4, "_strtoui64"                                                                                                        },
    { 0x04b5, "_strtoui64_l"                                                                                                      },
    { 0x04b6, "_strtoul_l"                                                                                                        },
    { 0x04b7, "_strupr"                                                                                                           },
    { 0x04b8, "_strupr_l"                                                                                                         },
    { 0x04b9, "_strupr_s"                                                                                                         },
    { 0x04ba, "_strupr_s_l"                                                                                                       },
    { 0x04bb, "_strxfrm_l"                                                                                                        },
    { 0x04bc, "_swab"                                                                                                             },
    { 0x04bd, "_swprintf"                                                                                                         },
    { 0x04be, "_swprintf_c"                                                                                                       },
    { 0x04bf, "_swprintf_c_l"                                                                                                     },
    { 0x04c0, "_swprintf_p"                                                                                                       },
    { 0x04c1, "_swprintf_p_l"                                                                                                     },
    { 0x04c2, "_swprintf_s_l"                                                                                                     },
    { 0x04c3, "_swscanf_l"                                                                                                        },
    { 0x04c4, "_swscanf_s_l"                                                                                                      },
    { 0x04c5, "_sys_errlist"                                                                                                      },
    { 0x04c6, "_sys_nerr"                                                                                                         },
    { 0x04c7, "_tell"                                                                                                             },
    { 0x04c8, "_telli64"                                                                                                          },
    { 0x04c9, "_tempnam"                                                                                                          },
    { 0x04ca, "_time32"                                                                                                           },
    { 0x04cb, "_time64"                                                                                                           },
    { 0x04cc, "_timezone"                                                                                                         },
    { 0x04cd, "_tolower"                                                                                                          },
    { 0x04ce, "_tolower_l"                                                                                                        },
    { 0x04cf, "_toupper"                                                                                                          },
    { 0x04d0, "_toupper_l"                                                                                                        },
    { 0x04d1, "_towlower_l"                                                                                                       },
    { 0x04d2, "_towupper_l"                                                                                                       },
    { 0x04d3, "_tzname"                                                                                                           },
    { 0x04d4, "_tzset"                                                                                                            },
    { 0x04d5, "_ui64toa"                                                                                                          },
    { 0x04d6, "_ui64toa_s"                                                                                                        },
    { 0x04d7, "_ui64tow"                                                                                                          },
    { 0x04d8, "_ui64tow_s"                                                                                                        },
    { 0x04d9, "_ultoa"                                                                                                            },
    { 0x04da, "_ultoa_s"                                                                                                          },
    { 0x04db, "_ultow"                                                                                                            },
    { 0x04dc, "_ultow_s"                                                                                                          },
    { 0x04dd, "_umask"                                                                                                            },
    { 0x04de, "_umask_s"                                                                                                          },
    { 0x04df, "_ungetc_nolock"                                                                                                    },
    { 0x04e0, "_ungetch"                                                                                                          },
    { 0x04e1, "_ungetch_nolock"                                                                                                   },
    { 0x04e2, "_ungetwc_nolock"                                                                                                   },
    { 0x04e3, "_ungetwch"                                                                                                         },
    { 0x04e4, "_ungetwch_nolock"                                                                                                  },
    { 0x04e5, "_unlink"                                                                                                           },
    { 0x04e6, "_unloaddll"                                                                                                        },
    { 0x04e7, "_unlock"                                                                                                           },
    { 0x04e8, "_unlock_file"                                                                                                      },
    { 0x04e9, "_utime32"                                                                                                          },
    { 0x04ea, "_utime64"                                                                                                          },
    { 0x04eb, "_vcprintf"                                                                                                         },
    { 0x04ec, "_vcprintf_l"                                                                                                       },
    { 0x04ed, "_vcprintf_p"                                                                                                       },
    { 0x04ee, "_vcprintf_p_l"                                                                                                     },
    { 0x04ef, "_vcprintf_s"                                                                                                       },
    { 0x04f0, "_vcprintf_s_l"                                                                                                     },
    { 0x04f1, "_vcwprintf"                                                                                                        },
    { 0x04f2, "_vcwprintf_l"                                                                                                      },
    { 0x04f3, "_vcwprintf_p"                                                                                                      },
    { 0x04f4, "_vcwprintf_p_l"                                                                                                    },
    { 0x04f5, "_vcwprintf_s"                                                                                                      },
    { 0x04f6, "_vcwprintf_s_l"                                                                                                    },
    { 0x04f7, "_vfprintf_l"                                                                                                       },
    { 0x04f8, "_vfprintf_p"                                                                                                       },
    { 0x04f9, "_vfprintf_p_l"                                                                                                     },
    { 0x04fa, "_vfprintf_s_l"                                                                                                     },
    { 0x04fb, "_vfwprintf_l"                                                                                                      },
    { 0x04fc, "_vfwprintf_p"                                                                                                      },
    { 0x04fd, "_vfwprintf_p_l"                                                                                                    },
    { 0x04fe, "_vfwprintf_s_l"                                                                                                    },
    { 0x04ff, "_vprintf_l"                                                                                                        },
    { 0x0500, "_vprintf_p"                                                                                                        },
    { 0x0501, "_vprintf_p_l"                                                                                                      },
    { 0x0502, "_vprintf_s_l"                                                                                                      },
    { 0x0503, "_vscprintf"                                                                                                        },
    { 0x0504, "_vscprintf_l"                                                                                                      },
    { 0x0505, "_vscprintf_p"                                                                                                      },
    { 0x0506, "_vscprintf_p_l"                                                                                                    },
    { 0x0507, "_vscwprintf"                                                                                                       },
    { 0x0508, "_vscwprintf_l"                                                                                                     },
    { 0x0509, "_vscwprintf_p"                                                                                                     },
    { 0x050a, "_vscwprintf_p_l"                                                                                                   },
    { 0x050b, "_vsnprintf"                                                                                                        },
    { 0x050c, "_vsnprintf_c"                                                                                                      },
    { 0x050d, "_vsnprintf_c_l"                                                                                                    },
    { 0x050e, "_vsnprintf_l"                                                                                                      },
    { 0x050f, "_vsnprintf_s"                                                                                                      },
    { 0x0510, "_vsnprintf_s_l"                                                                                                    },
    { 0x0511, "_vsnwprintf"                                                                                                       },
    { 0x0512, "_vsnwprintf_l"                                                                                                     },
    { 0x0513, "_vsnwprintf_s"                                                                                                     },
    { 0x0514, "_vsnwprintf_s_l"                                                                                                   },
    { 0x0515, "_vsprintf_l"                                                                                                       },
    { 0x0516, "_vsprintf_p"                                                                                                       },
    { 0x0517, "_vsprintf_p_l"                                                                                                     },
    { 0x0518, "_vsprintf_s_l"                                                                                                     },
    { 0x0519, "_vswprintf"                                                                                                        },
    { 0x051a, "_vswprintf_c"                                                                                                      },
    { 0x051b, "_vswprintf_c_l"                                                                                                    },
    { 0x051c, "_vswprintf_l"                                                                                                      },
    { 0x051d, "_vswprintf_p"                                                                                                      },
    { 0x051e, "_vswprintf_p_l"                                                                                                    },
    { 0x051f, "_vswprintf_s_l"                                                                                                    },
    { 0x0520, "_vwprintf_l"                                                                                                       },
    { 0x0521, "_vwprintf_p"                                                                                                       },
    { 0x0522, "_vwprintf_p_l"                                                                                                     },
    { 0x0523, "_vwprintf_s_l"                                                                                                     },
    { 0x0524, "_waccess"                                                                                                          },
    { 0x0525, "_waccess_s"                                                                                                        },
    { 0x0526, "_wasctime"                                                                                                         },
    { 0x0527, "_wasctime_s"                                                                                                       },
    { 0x0528, "_wassert"                                                                                                          },
    { 0x0529, "_wchdir"                                                                                                           },
    { 0x052a, "_wchmod"                                                                                                           },
    { 0x052b, "_wcmdln"                                                                                                           },
    { 0x052c, "_wcreat"                                                                                                           },
    { 0x052d, "_wcreate_locale"                                                                                                   },
    { 0x052e, "_wcscoll_l"                                                                                                        },
    { 0x052f, "_wcsdup"                                                                                                           },
    { 0x0530, "_wcserror"                                                                                                         },
    { 0x0531, "_wcserror_s"                                                                                                       },
    { 0x0532, "_wcsftime_l"                                                                                                       },
    { 0x0533, "_wcsicmp"                                                                                                          },
    { 0x0534, "_wcsicmp_l"                                                                                                        },
    { 0x0535, "_wcsicoll"                                                                                                         },
    { 0x0536, "_wcsicoll_l"                                                                                                       },
    { 0x0537, "_wcslwr"                                                                                                           },
    { 0x0538, "_wcslwr_l"                                                                                                         },
    { 0x0539, "_wcslwr_s"                                                                                                         },
    { 0x053a, "_wcslwr_s_l"                                                                                                       },
    { 0x053b, "_wcsncoll"                                                                                                         },
    { 0x053c, "_wcsncoll_l"                                                                                                       },
    { 0x053d, "_wcsnicmp"                                                                                                         },
    { 0x053e, "_wcsnicmp_l"                                                                                                       },
    { 0x053f, "_wcsnicoll"                                                                                                        },
    { 0x0540, "_wcsnicoll_l"                                                                                                      },
    { 0x0541, "_wcsnset"                                                                                                          },
    { 0x0542, "_wcsnset_s"                                                                                                        },
    { 0x0543, "_wcsrev"                                                                                                           },
    { 0x0544, "_wcsset"                                                                                                           },
    { 0x0545, "_wcsset_s"                                                                                                         },
    { 0x0546, "_wcstod_l"                                                                                                         },
    { 0x0547, "_wcstoi64"                                                                                                         },
    { 0x0548, "_wcstoi64_l"                                                                                                       },
    { 0x0549, "_wcstol_l"                                                                                                         },
    { 0x054a, "_wcstombs_l"                                                                                                       },
    { 0x054b, "_wcstombs_s_l"                                                                                                     },
    { 0x054c, "_wcstoui64"                                                                                                        },
    { 0x054d, "_wcstoui64_l"                                                                                                      },
    { 0x054e, "_wcstoul_l"                                                                                                        },
    { 0x054f, "_wcsupr"                                                                                                           },
    { 0x0550, "_wcsupr_l"                                                                                                         },
    { 0x0551, "_wcsupr_s"                                                                                                         },
    { 0x0552, "_wcsupr_s_l"                                                                                                       },
    { 0x0553, "_wcsxfrm_l"                                                                                                        },
    { 0x0554, "_wctime32"                                                                                                         },
    { 0x0555, "_wctime32_s"                                                                                                       },
    { 0x0556, "_wctime64"                                                                                                         },
    { 0x0557, "_wctime64_s"                                                                                                       },
    { 0x0558, "_wctomb_l"                                                                                                         },
    { 0x0559, "_wctomb_s_l"                                                                                                       },
    { 0x055a, "_wctype"                                                                                                           },
    { 0x055b, "_wdupenv_s"                                                                                                        },
    { 0x055c, "_wenviron"                                                                                                         },
    { 0x055d, "_wexecl"                                                                                                           },
    { 0x055e, "_wexecle"                                                                                                          },
    { 0x055f, "_wexeclp"                                                                                                          },
    { 0x0560, "_wexeclpe"                                                                                                         },
    { 0x0561, "_wexecv"                                                                                                           },
    { 0x0562, "_wexecve"                                                                                                          },
    { 0x0563, "_wexecvp"                                                                                                          },
    { 0x0564, "_wexecvpe"                                                                                                         },
    { 0x0565, "_wfdopen"                                                                                                          },
    { 0x0566, "_wfindfirst32"                                                                                                     },
    { 0x0567, "_wfindfirst32i64"                                                                                                  },
    { 0x0568, "_wfindfirst64"                                                                                                     },
    { 0x0569, "_wfindfirst64i32"                                                                                                  },
    { 0x056a, "_wfindnext32"                                                                                                      },
    { 0x056b, "_wfindnext32i64"                                                                                                   },
    { 0x056c, "_wfindnext64"                                                                                                      },
    { 0x056d, "_wfindnext64i32"                                                                                                   },
    { 0x056e, "_wfopen"                                                                                                           },
    { 0x056f, "_wfopen_s"                                                                                                         },
    { 0x0570, "_wfreopen"                                                                                                         },
    { 0x0571, "_wfreopen_s"                                                                                                       },
    { 0x0572, "_wfsopen"                                                                                                          },
    { 0x0573, "_wfullpath"                                                                                                        },
    { 0x0574, "_wgetcwd"                                                                                                          },
    { 0x0575, "_wgetdcwd"                                                                                                         },
    { 0x0576, "_wgetenv"                                                                                                          },
    { 0x0577, "_wgetenv_s"                                                                                                        },
    { 0x0578, "_wmakepath"                                                                                                        },
    { 0x0579, "_wmakepath_s"                                                                                                      },
    { 0x057a, "_wmkdir"                                                                                                           },
    { 0x057b, "_wmktemp"                                                                                                          },
    { 0x057c, "_wmktemp_s"                                                                                                        },
    { 0x057d, "_wopen"                                                                                                            },
    { 0x057e, "_wperror"                                                                                                          },
    { 0x057f, "_wpgmptr"                                                                                                          },
    { 0x0580, "_wpopen"                                                                                                           },
    { 0x0581, "_wprintf_l"                                                                                                        },
    { 0x0582, "_wprintf_p"                                                                                                        },
    { 0x0583, "_wprintf_p_l"                                                                                                      },
    { 0x0584, "_wprintf_s_l"                                                                                                      },
    { 0x0585, "_wputenv"                                                                                                          },
    { 0x0586, "_wputenv_s"                                                                                                        },
    { 0x0587, "_wremove"                                                                                                          },
    { 0x0588, "_wrename"                                                                                                          },
    { 0x0589, "_write"                                                                                                            },
    { 0x058a, "_wrmdir"                                                                                                           },
    { 0x058b, "_wscanf_l"                                                                                                         },
    { 0x058c, "_wscanf_s_l"                                                                                                       },
    { 0x058d, "_wsearchenv"                                                                                                       },
    { 0x058e, "_wsearchenv_s"                                                                                                     },
    { 0x058f, "_wsetlocale"                                                                                                       },
    { 0x0590, "_wsopen"                                                                                                           },
    { 0x0591, "_wsopen_s"                                                                                                         },
    { 0x0592, "_wspawnl"                                                                                                          },
    { 0x0593, "_wspawnle"                                                                                                         },
    { 0x0594, "_wspawnlp"                                                                                                         },
    { 0x0595, "_wspawnlpe"                                                                                                        },
    { 0x0596, "_wspawnv"                                                                                                          },
    { 0x0597, "_wspawnve"                                                                                                         },
    { 0x0598, "_wspawnvp"                                                                                                         },
    { 0x0599, "_wspawnvpe"                                                                                                        },
    { 0x059a, "_wsplitpath"                                                                                                       },
    { 0x059b, "_wsplitpath_s"                                                                                                     },
    { 0x059c, "_wstat32"                                                                                                          },
    { 0x059d, "_wstat32i64"                                                                                                       },
    { 0x059e, "_wstat64"                                                                                                          },
    { 0x059f, "_wstat64i32"                                                                                                       },
    { 0x05a0, "_wstrdate"                                                                                                         },
    { 0x05a1, "_wstrdate_s"                                                                                                       },
    { 0x05a2, "_wstrtime"                                                                                                         },
    { 0x05a3, "_wstrtime_s"                                                                                                       },
    { 0x05a4, "_wsystem"                                                                                                          },
    { 0x05a5, "_wtempnam"                                                                                                         },
    { 0x05a6, "_wtmpnam"                                                                                                          },
    { 0x05a7, "_wtmpnam_s"                                                                                                        },
    { 0x05a8, "_wtof"                                                                                                             },
    { 0x05a9, "_wtof_l"                                                                                                           },
    { 0x05aa, "_wtoi"                                                                                                             },
    { 0x05ab, "_wtoi64"                                                                                                           },
    { 0x05ac, "_wtoi64_l"                                                                                                         },
    { 0x05ad, "_wtoi_l"                                                                                                           },
    { 0x05ae, "_wtol"                                                                                                             },
    { 0x05af, "_wtol_l"                                                                                                           },
    { 0x05b0, "_wunlink"                                                                                                          },
    { 0x05b1, "_wutime32"                                                                                                         },
    { 0x05b2, "_wutime64"                                                                                                         },
    { 0x05b3, "_y0"                                                                                                               },
    { 0x05b4, "_y1"                                                                                                               },
    { 0x05b5, "_yn"                                                                                                               },
    { 0x05b6, "abort"                                                                                                             },
    { 0x05b7, "abs"                                                                                                               },
    { 0x05b8, "acos"                                                                                                              },
    { 0x05b9, "asctime"                                                                                                           },
    { 0x05ba, "asctime_s"                                                                                                         },
    { 0x05bb, "asin"                                                                                                              },
    { 0x05bc, "atan"                                                                                                              },
    { 0x05bd, "atan2"                                                                                                             },
    { 0x05be, "atexit"                                                                                                            },
    { 0x05bf, "atof"                                                                                                              },
    { 0x05c0, "atoi"                                                                                                              },
    { 0x05c1, "atol"                                                                                                              },
    { 0x05c2, "bsearch"                                                                                                           },
    { 0x05c3, "bsearch_s"                                                                                                         },
    { 0x05c4, "btowc"                                                                                                             },
    { 0x05c5, "calloc"                                                                                                            },
    { 0x05c6, "ceil"                                                                                                              },
    { 0x05c7, "clearerr"                                                                                                          },
    { 0x05c8, "clearerr_s"                                                                                                        },
    { 0x05c9, "clock"                                                                                                             },
    { 0x05ca, "cos"                                                                                                               },
    { 0x05cb, "cosh"                                                                                                              },
    { 0x05cc, "div"                                                                                                               },
    { 0x05cd, "exit"                                                                                                              },
    { 0x05ce, "exp"                                                                                                               },
    { 0x05cf, "fabs"                                                                                                              },
    { 0x05d0, "fclose"                                                                                                            },
    { 0x05d1, "feof"                                                                                                              },
    { 0x05d2, "ferror"                                                                                                            },
    { 0x05d3, "fflush"                                                                                                            },
    { 0x05d4, "fgetc"                                                                                                             },
    { 0x05d5, "fgetpos"                                                                                                           },
    { 0x05d6, "fgets"                                                                                                             },
    { 0x05d7, "fgetwc"                                                                                                            },
    { 0x05d8, "fgetws"                                                                                                            },
    { 0x05d9, "floor"                                                                                                             },
    { 0x05da, "fmod"                                                                                                              },
    { 0x05db, "fopen"                                                                                                             },
    { 0x05dc, "fopen_s"                                                                                                           },
    { 0x05dd, "fprintf"                                                                                                           },
    { 0x05de, "fprintf_s"                                                                                                         },
    { 0x05df, "fputc"                                                                                                             },
    { 0x05e0, "fputs"                                                                                                             },
    { 0x05e1, "fputwc"                                                                                                            },
    { 0x05e2, "fputws"                                                                                                            },
    { 0x05e3, "fread"                                                                                                             },
    { 0x05e4, "fread_s"                                                                                                           },
    { 0x05e5, "free"                                                                                                              },
    { 0x05e6, "freopen"                                                                                                           },
    { 0x05e7, "freopen_s"                                                                                                         },
    { 0x05e8, "frexp"                                                                                                             },
    { 0x05e9, "fscanf"                                                                                                            },
    { 0x05ea, "fscanf_s"                                                                                                          },
    { 0x05eb, "fseek"                                                                                                             },
    { 0x05ec, "fsetpos"                                                                                                           },
    { 0x05ed, "ftell"                                                                                                             },
    { 0x05ee, "fwprintf"                                                                                                          },
    { 0x05ef, "fwprintf_s"                                                                                                        },
    { 0x05f0, "fwrite"                                                                                                            },
    { 0x05f1, "fwscanf"                                                                                                           },
    { 0x05f2, "fwscanf_s"                                                                                                         },
    { 0x05f3, "getc"                                                                                                              },
    { 0x05f4, "getchar"                                                                                                           },
    { 0x05f5, "getenv"                                                                                                            },
    { 0x05f6, "getenv_s"                                                                                                          },
    { 0x05f7, "gets"                                                                                                              },
    { 0x05f8, "gets_s"                                                                                                            },
    { 0x05f9, "getwc"                                                                                                             },
    { 0x05fa, "getwchar"                                                                                                          },
    { 0x05fb, "is_wctype"                                                                                                         },
    { 0x05fc, "isalnum"                                                                                                           },
    { 0x05fd, "isalpha"                                                                                                           },
    { 0x05fe, "iscntrl"                                                                                                           },
    { 0x05ff, "isdigit"                                                                                                           },
    { 0x0600, "isgraph"                                                                                                           },
    { 0x0601, "isleadbyte"                                                                                                        },
    { 0x0602, "islower"                                                                                                           },
    { 0x0603, "isprint"                                                                                                           },
    { 0x0604, "ispunct"                                                                                                           },
    { 0x0605, "isspace"                                                                                                           },
    { 0x0606, "isupper"                                                                                                           },
    { 0x0607, "iswalnum"                                                                                                          },
    { 0x0608, "iswalpha"                                                                                                          },
    { 0x0609, "iswascii"                                                                                                          },
    { 0x060a, "iswcntrl"                                                                                                          },
    { 0x060b, "iswctype"                                                                                                          },
    { 0x060c, "iswdigit"                                                                                                          },
    { 0x060d, "iswgraph"                                                                                                          },
    { 0x060e, "iswlower"                                                                                                          },
    { 0x060f, "iswprint"                                                                                                          },
    { 0x0610, "iswpunct"                                                                                                          },
    { 0x0611, "iswspace"                                                                                                          },
    { 0x0612, "iswupper"                                                                                                          },
    { 0x0613, "iswxdigit"                                                                                                         },
    { 0x0614, "isxdigit"                                                                                                          },
    { 0x0615, "labs"                                                                                                              },
    { 0x0616, "ldexp"                                                                                                             },
    { 0x0617, "ldiv"                                                                                                              },
    { 0x0618, "llabs"                                                                                                             },
    { 0x0619, "lldiv"                                                                                                             },
    { 0x061a, "localeconv"                                                                                                        },
    { 0x061b, "log"                                                                                                               },
    { 0x061c, "log10"                                                                                                             },
    { 0x061d, "longjmp"                                                                                                           },
    { 0x061e, "malloc"                                                                                                            },
    { 0x061f, "mblen"                                                                                                             },
    { 0x0620, "mbrlen"                                                                                                            },
    { 0x0621, "mbrtowc"                                                                                                           },
    { 0x0622, "mbsrtowcs"                                                                                                         },
    { 0x0623, "mbsrtowcs_s"                                                                                                       },
    { 0x0624, "mbstowcs"                                                                                                          },
    { 0x0625, "mbstowcs_s"                                                                                                        },
    { 0x0626, "mbtowc"                                                                                                            },
    { 0x0627, "memchr"                                                                                                            },
    { 0x0628, "memcmp"                                                                                                            },
    { 0x0629, "memcpy"                                                                                                            },
    { 0x062a, "memcpy_s"                                                                                                          },
    { 0x062b, "memmove"                                                                                                           },
    { 0x062c, "memmove_s"                                                                                                         },
    { 0x062d, "memset"                                                                                                            },
    { 0x062e, "modf"                                                                                                              },
    { 0x062f, "perror"                                                                                                            },
    { 0x0630, "pow"                                                                                                               },
    { 0x0631, "printf"                                                                                                            },
    { 0x0632, "printf_s"                                                                                                          },
    { 0x0633, "putc"                                                                                                              },
    { 0x0634, "putchar"                                                                                                           },
    { 0x0635, "puts"                                                                                                              },
    { 0x0636, "putwc"                                                                                                             },
    { 0x0637, "putwchar"                                                                                                          },
    { 0x0638, "qsort"                                                                                                             },
    { 0x0639, "qsort_s"                                                                                                           },
    { 0x063a, "raise"                                                                                                             },
    { 0x063b, "rand"                                                                                                              },
    { 0x063c, "rand_s"                                                                                                            },
    { 0x063d, "realloc"                                                                                                           },
    { 0x063e, "remove"                                                                                                            },
    { 0x063f, "rename"                                                                                                            },
    { 0x0640, "rewind"                                                                                                            },
    { 0x0641, "scanf"                                                                                                             },
    { 0x0642, "scanf_s"                                                                                                           },
    { 0x0643, "setbuf"                                                                                                            },
    { 0x0644, "setlocale"                                                                                                         },
    { 0x0645, "setvbuf"                                                                                                           },
    { 0x0646, "signal"                                                                                                            },
    { 0x0647, "sin"                                                                                                               },
    { 0x0648, "sinh"                                                                                                              },
    { 0x0649, "sprintf"                                                                                                           },
    { 0x064a, "sprintf_s"                                                                                                         },
    { 0x064b, "sqrt"                                                                                                              },
    { 0x064c, "srand"                                                                                                             },
    { 0x064d, "sscanf"                                                                                                            },
    { 0x064e, "sscanf_s"                                                                                                          },
    { 0x064f, "strcat"                                                                                                            },
    { 0x0650, "strcat_s"                                                                                                          },
    { 0x0651, "strchr"                                                                                                            },
    { 0x0652, "strcmp"                                                                                                            },
    { 0x0653, "strcoll"                                                                                                           },
    { 0x0654, "strcpy"                                                                                                            },
    { 0x0655, "strcpy_s"                                                                                                          },
    { 0x0656, "strcspn"                                                                                                           },
    { 0x0657, "strerror"                                                                                                          },
    { 0x0658, "strerror_s"                                                                                                        },
    { 0x0659, "strftime"                                                                                                          },
    { 0x065a, "strlen"                                                                                                            },
    { 0x065b, "strncat"                                                                                                           },
    { 0x065c, "strncat_s"                                                                                                         },
    { 0x065d, "strncmp"                                                                                                           },
    { 0x065e, "strncpy"                                                                                                           },
    { 0x065f, "strncpy_s"                                                                                                         },
    { 0x0660, "strnlen"                                                                                                           },
    { 0x0661, "strpbrk"                                                                                                           },
    { 0x0662, "strrchr"                                                                                                           },
    { 0x0663, "strspn"                                                                                                            },
    { 0x0664, "strstr"                                                                                                            },
    { 0x0665, "strtod"                                                                                                            },
    { 0x0666, "strtok"                                                                                                            },
    { 0x0667, "strtok_s"                                                                                                          },
    { 0x0668, "strtol"                                                                                                            },
    { 0x0669, "strtoul"                                                                                                           },
    { 0x066a, "strxfrm"                                                                                                           },
    { 0x066b, "swprintf_s"                                                                                                        },
    { 0x066c, "swscanf"                                                                                                           },
    { 0x066d, "swscanf_s"                                                                                                         },
    { 0x066e, "system"                                                                                                            },
    { 0x066f, "tan"                                                                                                               },
    { 0x0670, "tanh"                                                                                                              },
    { 0x0671, "tmpfile"                                                                                                           },
    { 0x0672, "tmpfile_s"                                                                                                         },
    { 0x0673, "tmpnam"                                                                                                            },
    { 0x0674, "tmpnam_s"                                                                                                          },
    { 0x0675, "tolower"                                                                                                           },
    { 0x0676, "toupper"                                                                                                           },
    { 0x0677, "towlower"                                                                                                          },
    { 0x0678, "towupper"                                                                                                          },
    { 0x0679, "ungetc"                                                                                                            },
    { 0x067a, "ungetwc"                                                                                                           },
    { 0x067b, "vfprintf"                                                                                                          },
    { 0x067c, "vfprintf_s"                                                                                                        },
    { 0x067d, "vfwprintf"                                                                                                         },
    { 0x067e, "vfwprintf_s"                                                                                                       },
    { 0x067f, "vprintf"                                                                                                           },
    { 0x0680, "vprintf_s"                                                                                                         },
    { 0x0681, "vsprintf"                                                                                                          },
    { 0x0682, "vsprintf_s"                                                                                                        },
    { 0x0683, "vswprintf_s"                                                                                                       },
    { 0x0684, "vwprintf"                                                                                                          },
    { 0x0685, "vwprintf_s"                                                                                                        },
    { 0x0686, "wcrtomb"                                                                                                           },
    { 0x0687, "wcrtomb_s"                                                                                                         },
    { 0x0688, "wcscat"                                                                                                            },
    { 0x0689, "wcscat_s"                                                                                                          },
    { 0x068a, "wcschr"                                                                                                            },
    { 0x068b, "wcscmp"                                                                                                            },
    { 0x068c, "wcscoll"                                                                                                           },
    { 0x068d, "wcscpy"                                                                                                            },
    { 0x068e, "wcscpy_s"                                                                                                          },
    { 0x068f, "wcscspn"                                                                                                           },
    { 0x0690, "wcsftime"                                                                                                          },
    { 0x0691, "wcslen"                                                                                                            },
    { 0x0692, "wcsncat"                                                                                                           },
    { 0x0693, "wcsncat_s"                                                                                                         },
    { 0x0694, "wcsncmp"                                                                                                           },
    { 0x0695, "wcsncpy"                                                                                                           },
    { 0x0696, "wcsncpy_s"                                                                                                         },
    { 0x0697, "wcsnlen"                                                                                                           },
    { 0x0698, "wcspbrk"                                                                                                           },
    { 0x0699, "wcsrchr"                                                                                                           },
    { 0x069a, "wcsrtombs"                                                                                                         },
    { 0x069b, "wcsrtombs_s"                                                                                                       },
    { 0x069c, "wcsspn"                                                                                                            },
    { 0x069d, "wcsstr"                                                                                                            },
    { 0x069e, "wcstod"                                                                                                            },
    { 0x069f, "wcstok"                                                                                                            },
    { 0x06a0, "wcstok_s"                                                                                                          },
    { 0x06a1, "wcstol"                                                                                                            },
    { 0x06a2, "wcstombs"                                                                                                          },
    { 0x06a3, "wcstombs_s"                                                                                                        },
    { 0x06a4, "wcstoul"                                                                                                           },
    { 0x06a5, "wcsxfrm"                                                                                                           },
    { 0x06a6, "wctob"                                                                                                             },
    { 0x06a7, "wctomb"                                                                                                            },
    { 0x06a8, "wctomb_s"                                                                                                          },
    { 0x06a9, "wmemcpy_s"                                                                                                         },
    { 0x06aa, "wmemmove_s"                                                                                                        },
    { 0x06ab, "wprintf"                                                                                                           },
    { 0x06ac, "wprintf_s"                                                                                                         },
    { 0x06ad, "wscanf"                                                                                                            },
    { 0x06ae, "wscanf_s"                                                                                                          },
};


}
}

#endif

