//! Constants used by Ouster data structures and calculations.

/// Number of azimuth _ticks_ in one revolution.
pub const ENCODER_TICKS_PER_REV: u32 = 90112;

/// Number of laser returns in one column.
pub const PIXELS_PER_COLUMN: usize = 64;

/// Number of columns in one packet, where each column represents a vertical scan.
pub const COLUMNS_PER_PACKET: usize = 16;

/// Altitude angles of OS-1.
pub const OS_1_BEAM_ALTITUDE_DEGREES: [f64; 64] = [
    17.042, 16.427, 15.872, 15.324, 14.851, 14.269, 13.733, 13.18, 12.713, 12.136, 11.599, 11.067,
    10.587, 10.046, 9.503, 8.966, 8.504, 7.952, 7.414, 6.869, 6.417, 5.866, 5.331, 4.792, 4.329,
    3.791, 3.248, 2.699, 2.26, 1.709, 1.17, 0.62, 0.177, -0.37, -0.916, -1.466, -1.924, -2.454,
    -3.001, -3.551, -3.997, -4.545, -5.088, -5.64, -6.08, -6.638, -7.17, -7.736, -8.197, -8.728,
    -9.282, -9.854, -10.299, -10.833, -11.386, -11.965, -12.422, -12.957, -13.525, -14.109,
    -14.576, -15.133, -15.691, -16.3,
];
pub const OS_1_BEAM_AZIMUTH_DEGREE_CORRECTIONS: [f64; 64] = [
    3.073,
    0.922,
    -1.238,
    -3.386,
    3.057,
    0.915,
    -1.214,
    -3.321,
    3.06,
    0.937,
    -1.174,
    -3.284,
    3.051,
    0.953,
    -1.154,
    -3.242,
    3.05,
    0.958,
    -1.126,
    -3.198,
    3.053,
    0.981,
    -1.104,
    -3.177,
    3.082,
    1.001,
    -1.079,
    #[allow(clippy::approx_constant)]
    -3.141,
    3.101,
    1.025,
    -1.048,
    -3.124,
    3.115,
    1.041,
    -1.028,
    -3.1,
    3.135,
    1.066,
    -1.0,
    -3.077,
    3.177,
    1.093,
    -0.981,
    -3.06,
    3.213,
    1.117,
    -0.963,
    -3.048,
    3.249,
    1.158,
    -0.948,
    -3.047,
    3.297,
    1.2,
    -0.913,
    -3.023,
    3.345,
    1.231,
    -0.881,
    -3.022,
    3.425,
    1.267,
    -0.872,
    -3.024,
];
