#### General usage of lichen

Primarily, lichen is geared towards an interactive story. You declare nodes, which typically start at ```root```. Each call to a node using ```next``` will pause the current node's execution, and start next iteration on the following node. If the next node was not advanced, or a `call` was made, then it will automatically pick back up where that last node paused. Iterations will only step when there are emitted variables, so logic and functions are run through. If logic denotes skipping certain sections, then the same iteration step will continue on. That is to say each line of source in lichen does *not* relate to a step in the evaluation.

State data is typically declared ahead of time, using ```def``` blocks, however this is not necessary and blocks can be built on the fly by just specifying nested paths, eg: ```@some.thing true``` builds a ```some``` def block, with a ```thing``` field set to a ```true``` boolean. Writing all state must be prefixed with ```@``` and reading all state must be read from existing state data. That is to say, functions do not return data to be worked on-- they can only be written directly to state. For example, ```@some.thing (inc) 1 2 3``` would swap the value in ```some.thing``` from the result of the custom function ```inc```. This is assuming ```inc``` returned a value, which is optional on custom functions, in that case, nothing is written. For repeatable mutations, a node block can be called on using ```next:call```, which will call the node, evaluate it, then return back to the originating node to continue.

Logic is used to control the flow through a set of nodes, and allows for branching of the dialogue. Basic control flow such as ```if/or``` exists, as well can control state mutations using ```when```. All nodes naturally die off. To control this behavior, you can specify special instructions so the evaluator will change this process. Examples include ```next:restart``` which will restart current node, or if specified with an argument, some other node. This restart is at the beginning of the node, and not where it left off. If you need early exits, ```next:back``` will pop off the current node being evaluated (only if it was `call`ed) and head back to where the last node was evaluating. As well ```next:exit``` which ends all evaluation. Read the [next enum](https://github.com/viperscape/lichen/blob/master/src/source.rs#L49) for more information on what's going on.
