mod test_split_string_with_space {
    use zymod::stringutils;

    #[test]
    fn test_case1() {
        let s = String::from("cpu  847888 530 189111 18209812 6407 41606 16275 0 0 0");
        let mut v: Vec<String> = Vec::new();
        stringutils::split_string_with_space(&s, 0, &mut v);
        assert_eq!(v.len(), 12);
    }

    #[test]
    fn test_case2() {
        let s = String::from("cpu  847888 530 189111 18209812 6407 41606 16275 0 0 0");
        let mut v: Vec<String> = Vec::new();

        stringutils::split_string_with_space(&s, 5, &mut v);
        assert_eq!(v.len(), 10);
    }

    #[test]
    fn test_case3() {
        let s = String::from("11 22 3");
        let mut v: Vec<String> = Vec::new();

        stringutils::split_string_with_space(&s, 0, &mut v);
        assert_eq!(v.len(), 3);

        assert_eq!(v.get(0).unwrap(), "11");
        assert_eq!(v.get(1).unwrap(), "22");
        assert_eq!(v.get(2).unwrap(), "3");
    }

    #[test]
    fn test_case4() {
        let s = String::from("123 45 67");
        let mut v: Vec<String> = Vec::new();

        stringutils::split_string_with_space(&s, 0, &mut v);

        assert_eq!(v.len(), 3);

        assert_eq!(v.get(0).unwrap(), "123");
        assert_eq!(v.get(1).unwrap(), "45");
        assert_eq!(v.get(2).unwrap(), "67");
    }

    #[test]
    fn test_case5() {
        let s = String::from(" 123 45 67 ");
        let mut v: Vec<String> = Vec::new();

        stringutils::split_string_with_space(&s, 0, &mut v);

        assert_eq!(v.len(), 5);

        assert_eq!(v.get(0).unwrap(), "");
        assert_eq!(v.get(1).unwrap(), "123");
        assert_eq!(v.get(2).unwrap(), "45");
        assert_eq!(v.get(3).unwrap(), "67");
        assert_eq!(v.get(4).unwrap(), "");
    }
}
