pub fn split_string_with_space(s: &String, begin: usize, vv: &mut Vec<String>) {
    _split_string_with_space(s, begin, vv);
}

fn _split_string_with_space(s: &String, begin: usize, vv: &mut Vec<String>) -> bool {
    let in_s = s[begin..].to_string();
    let in_bytes = in_s.as_bytes();
    let in_bytes_len = in_bytes.len();

    if in_bytes_len == 1 {
        vv.push(in_s.clone());
        return false;
    }

    let mut has_space = false;
    let mut _s = String::new();

    for i in 0..in_bytes_len {
        if in_bytes[i] != 0x20 {
            _s.push(char::from(in_bytes[i]));
        }

        if in_bytes[i] == 0x20 {
            has_space = true;
            vv.push(_s.clone());
            _s.clear();

            if !_split_string_with_space(&in_s, i + 1, vv) {
                return false;
            }
        }
    }

    if !has_space {
        vv.push(in_s.clone());
        return false;
    }

    return true;
}
