use std::fs::File;
use std::io::{self, BufRead};

pub struct ModConfStruct {
    pub active: bool,
    pub agent_url: String,
    pub interval: u64,
    pub mod_name: String,
}

pub fn load_mod_conf(filename: &String) -> io::Result<ModConfStruct> {
    let mut conf = ModConfStruct {
        active: false,
        agent_url: "".parse().unwrap(),
        interval: 1000,
        mod_name: "".parse().unwrap(),
    };

    let file = File::open(filename)?;
    let lines = io::BufReader::new(file).lines();

    for line in lines {
        let l = line?;
        let pos = l.find("=").unwrap();

        let name = &l[..pos];
        let value = &l[(pos + 1)..];

        if name == "mod_name" {
            conf.mod_name = value.parse().unwrap();
        } else if name == "interval" {
            conf.interval = value.parse().unwrap();
        } else if name == "agent_url" {
            conf.agent_url = value.parse().unwrap();
        } else if name == "active" {
            conf.active = value.parse().unwrap();
        }
    }
    return Ok(conf);
}
