mod agent_conf;
mod mod_conf;
mod zhiyan;

use serde_json::Value;
use std::{fs, thread, time::Duration};
use tokio::runtime::Builder;
use tonic::Request;
use zhiyan::zhi_yan_client::ZhiYanClient;
use zhiyan::ZhiYanRequest;

pub fn path_exists(path: &str) -> bool {
    fs::metadata(path).is_ok()
}

pub fn send_request_json(json_value: Value) -> Result<(), ureq::Error> {
    let args: Vec<String> = std::env::args().collect();
    let conf_filename = &args[1];
    let mod_conf = mod_conf::load_mod_conf(conf_filename).unwrap();
    loop {
        let send_request = ureq::post(mod_conf.agent_url.as_str())
            .send_json(json_value.clone())?
            .into_string()?;
        println!("{:?}", send_request);
        thread::sleep(Duration::from_millis(mod_conf.interval));
    }
}

pub fn mod_send_request_grpc(name: String, datetime: i64, content: String, conf_filename: String) {
    let mod_conf = mod_conf::load_mod_conf(&conf_filename.to_string()).unwrap();

    let run_time = Builder::new_multi_thread()
        .enable_all()
        .worker_threads(2)
        .thread_keep_alive(Duration::from_millis(1))
        .max_blocking_threads(2)
        .on_thread_start(|| {
            println!("Mod to Agent Start!");
        })
        .on_thread_stop(|| {
            println!("Mod to Agent Stop!");
        })
        .build()
        .unwrap();
    run_time.block_on(async {
        let mut client = ZhiYanClient::connect(mod_conf.agent_url.clone())
            .await
            .unwrap();

        let request = Request::new(ZhiYanRequest {
            name: name.clone(),
            datetime: datetime.clone(),
            content: content.clone(),
        });

        let response = client.zymod(request).await.unwrap();
        let upload_response = response.get_ref();
        println!(
            "Code:{:?}\nMessages{:?}\n+++++++++++++++++++++",
            upload_response.code, upload_response.message
        );
        thread::sleep(Duration::from_millis(mod_conf.interval.clone()));
    });
    run_time.shutdown_timeout(Duration::from_millis(10));

    return;
}

pub fn agent_send_request_grpc(
    name: String,
    datetime: i64,
    content: String,
    conf_filename: String,
) {
    let agent_conf = agent_conf::load_agent_conf(&conf_filename.to_string()).unwrap();

    tokio::spawn(async move {
        let mut client = ZhiYanClient::connect(agent_conf.server_url).await.unwrap();

        let request = Request::new(ZhiYanRequest {
            name: name.clone(),
            datetime: datetime.clone(),
            content: content.clone(),
        });
        let response = client.zymod(request).await.unwrap();
        let upload_response = response.get_ref();
        println!(
            "{:?}\n{:?}\n+++++++++++++++++++++",
            upload_response.code, upload_response.message
        )
    });
    return;
}
