mod agent_conf;
mod mod_conf;
mod zhiyan_proto;

use serde_json::Value;
use std::{fs, thread, time::Duration};
use tokio::runtime::Builder;
use tonic::Request;
use zhiyan_proto::upload_client::UploadClient;
use zhiyan_proto::UploadRequest;

pub fn path_exists(path: &str) -> bool {
    fs::metadata(path).is_ok()
}

pub fn send_request_json(json_value: Value) -> Result<(), ureq::Error> {
    let args: Vec<String> = std::env::args().collect();
    let conf_filename = &args[1];
    let mod_conf = mod_conf::load_mod_conf(conf_filename).unwrap();
    loop {
        let send_request = ureq::post(mod_conf.agent_url.as_str())
            .send_json(json_value.clone())?
            .into_string()?;
        println!("{:?}", send_request);
        thread::sleep(Duration::from_millis(mod_conf.interval));
    }
}

pub fn mod_send_request_grpc(
    name: String,
    datetime: i64,
    content: Vec<f32>,
    conf_filename: String,
) {
    let mod_conf = mod_conf::load_mod_conf(&conf_filename.to_string()).unwrap();

    let run_time = Builder::new_multi_thread().enable_all().build().unwrap();
    run_time.block_on(async {
        let mut client = UploadClient::connect(mod_conf.agent_url.clone())
            .await
            .unwrap();

        let request = Request::new(UploadRequest {
            name: name.clone(),
            datetime: datetime.clone(),
            content: content.clone(),
        });

        let response = client.data_upload(request).await.unwrap();
        let upload_response = response.get_ref();
        println!(
            "Code:{:?}\tMessages{:?}",
            upload_response.code, upload_response.message
        );
        thread::sleep(Duration::from_millis(mod_conf.interval.clone()));
    });
}

pub fn agent_send_request_grpc(
    name: String,
    datetime: i64,
    content: Vec<f32>,
    conf_filename: String,
) {
    let agent_conf = agent_conf::load_agent_conf(&conf_filename.to_string()).unwrap();

    let run_time = Builder::new_multi_thread().enable_all().build().unwrap();
    run_time.spawn(async move {
        let mut client = UploadClient::connect(agent_conf.server_url).await.unwrap();

        let request = Request::new(UploadRequest {
            name: name.clone(),
            datetime: datetime.clone(),
            content: content.clone(),
        });

        let response = client.data_upload(request).await.unwrap();
        let upload_response = response.get_ref();
        println!("{:?}\n{:?}", upload_response.code, upload_response.message);
    });
    std::mem::forget(run_time);
}
