use std::fs::File;
use std::io::{self, BufRead};

pub struct ModConfStruct {
    pub agent_id: String,
    pub server_url: String,
    pub active: bool,
}

pub fn load_agent_conf(filename: &String) -> io::Result<ModConfStruct> {
    let mut conf = ModConfStruct {
        agent_id: "".parse().unwrap(),
        server_url: "".parse().unwrap(),
        active: false,
    };

    let file = File::open(filename)?;
    let lines = io::BufReader::new(file).lines();

    for line in lines {
        let l = line?;
        let pos = l.find("=").unwrap();

        let name = &l[..pos];
        let value = &l[(pos + 1)..];

        if name == "agent_id" {
            conf.agent_id = value.parse().unwrap();
        } else if name == "server_url" {
            conf.server_url = value.parse().unwrap();
        } else if name == "active" {
            conf.active = value.parse().unwrap();
        }
    }
    Ok(conf)
}
