// Maps from character code to their value in the z-base-32 scheme
// Table starts from character code 49 ('1')
pub const CHARACTER_MIN_VALUE: u8 = 49;
pub const CHARACTER_TO_QUINTET: &'static [u8] = &[
    18, // '1'
    255, 25, // '3'
    26, // '4'
    27, // '5'
    30, // '6'
    29, // '7'
    7,  // '8'
    31, // '9'
    255, 255, 255, 255, 255, 255, 255, 24, // 'A'
    1,  // 'B'
    12, // 'C'
    3,  // 'D'
    8,  // 'E'
    5,  // 'F'
    6,  // 'G'
    28, // 'H'
    21, // 'I'
    9,  // 'J'
    10, // 'K'
    255, 11, // 'M'
    2,  // 'N'
    16, // 'O'
    13, // 'P'
    14, // 'Q'
    4,  // 'R'
    22, // 'S'
    17, // 'T'
    19, // 'U'
    255, 20, // 'W'
    15, // 'X'
    0,  // 'Y'
    23, // 'Z'
    255, 255, 255, 255, 255, 255, 24, // 'a'
    1,  // 'b'
    12, // 'c'
    3,  // 'd'
    8,  // 'e'
    5,  // 'f'
    6,  // 'g'
    28, // 'h'
    21, // 'i'
    9,  // 'j'
    10, // 'k'
    255, 11, // 'm'
    2,  // 'n'
    16, // 'o'
    13, // 'p'
    14, // 'q'
    4,  // 'r'
    22, // 's'
    17, // 't'
    19, // 'u'
    255, 20, // 'w'
    15, // 'x'
    0,  // 'y'
    23, // 'z'
];

pub const QUINTET_TO_CHARACTER: &'static [u8] = &[
    b'y', b'b', b'n', b'd', b'r', b'f', b'g', b'8', b'e', b'j', b'k', b'm', b'c', b'p', b'q', b'x',
    b'o', b't', b'1', b'u', b'w', b'i', b's', b'z', b'a', b'3', b'4', b'5', b'h', b'7', b'6', b'9',
];
