/* automatically generated by rust-bindgen 0.55.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!(
            (bit_offset + (bit_width as usize)) / 8
                <= self.storage.as_ref().len()
        );
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!(
            (bit_offset + (bit_width as usize)) / 8
                <= self.storage.as_ref().len()
        );
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const _STDINT_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 28;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const LY_LOLOG: u32 = 1;
pub const LY_LOSTORE: u32 = 2;
pub const LY_LOSTORE_LAST: u32 = 6;
pub const LY_LDGDICT: u32 = 1;
pub const LY_LDGXPATH: u32 = 2;
pub const _ARPA_INET_H: u32 = 1;
pub const _NETINET_IN_H: u32 = 1;
pub const _SYS_SOCKET_H: u32 = 1;
pub const __iovec_defined: u32 = 1;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __FD_ZERO_STOS: &'static [u8; 6usize] = b"stosq\0";
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const __PTHREAD_MUTEX_LOCK_ELISION: u32 = 1;
pub const __PTHREAD_MUTEX_NUSERS_AFTER_KIND: u32 = 0;
pub const __PTHREAD_MUTEX_USE_UNION: u32 = 0;
pub const __PTHREAD_RWLOCK_INT_FLAGS_SHARED: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const PF_UNSPEC: u32 = 0;
pub const PF_LOCAL: u32 = 1;
pub const PF_UNIX: u32 = 1;
pub const PF_FILE: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_AX25: u32 = 3;
pub const PF_IPX: u32 = 4;
pub const PF_APPLETALK: u32 = 5;
pub const PF_NETROM: u32 = 6;
pub const PF_BRIDGE: u32 = 7;
pub const PF_ATMPVC: u32 = 8;
pub const PF_X25: u32 = 9;
pub const PF_INET6: u32 = 10;
pub const PF_ROSE: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_NETBEUI: u32 = 13;
pub const PF_SECURITY: u32 = 14;
pub const PF_KEY: u32 = 15;
pub const PF_NETLINK: u32 = 16;
pub const PF_ROUTE: u32 = 16;
pub const PF_PACKET: u32 = 17;
pub const PF_ASH: u32 = 18;
pub const PF_ECONET: u32 = 19;
pub const PF_ATMSVC: u32 = 20;
pub const PF_RDS: u32 = 21;
pub const PF_SNA: u32 = 22;
pub const PF_IRDA: u32 = 23;
pub const PF_PPPOX: u32 = 24;
pub const PF_WANPIPE: u32 = 25;
pub const PF_LLC: u32 = 26;
pub const PF_IB: u32 = 27;
pub const PF_MPLS: u32 = 28;
pub const PF_CAN: u32 = 29;
pub const PF_TIPC: u32 = 30;
pub const PF_BLUETOOTH: u32 = 31;
pub const PF_IUCV: u32 = 32;
pub const PF_RXRPC: u32 = 33;
pub const PF_ISDN: u32 = 34;
pub const PF_PHONET: u32 = 35;
pub const PF_IEEE802154: u32 = 36;
pub const PF_CAIF: u32 = 37;
pub const PF_ALG: u32 = 38;
pub const PF_NFC: u32 = 39;
pub const PF_VSOCK: u32 = 40;
pub const PF_KCM: u32 = 41;
pub const PF_QIPCRTR: u32 = 42;
pub const PF_SMC: u32 = 43;
pub const PF_MAX: u32 = 44;
pub const AF_UNSPEC: u32 = 0;
pub const AF_LOCAL: u32 = 1;
pub const AF_UNIX: u32 = 1;
pub const AF_FILE: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_AX25: u32 = 3;
pub const AF_IPX: u32 = 4;
pub const AF_APPLETALK: u32 = 5;
pub const AF_NETROM: u32 = 6;
pub const AF_BRIDGE: u32 = 7;
pub const AF_ATMPVC: u32 = 8;
pub const AF_X25: u32 = 9;
pub const AF_INET6: u32 = 10;
pub const AF_ROSE: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_NETBEUI: u32 = 13;
pub const AF_SECURITY: u32 = 14;
pub const AF_KEY: u32 = 15;
pub const AF_NETLINK: u32 = 16;
pub const AF_ROUTE: u32 = 16;
pub const AF_PACKET: u32 = 17;
pub const AF_ASH: u32 = 18;
pub const AF_ECONET: u32 = 19;
pub const AF_ATMSVC: u32 = 20;
pub const AF_RDS: u32 = 21;
pub const AF_SNA: u32 = 22;
pub const AF_IRDA: u32 = 23;
pub const AF_PPPOX: u32 = 24;
pub const AF_WANPIPE: u32 = 25;
pub const AF_LLC: u32 = 26;
pub const AF_IB: u32 = 27;
pub const AF_MPLS: u32 = 28;
pub const AF_CAN: u32 = 29;
pub const AF_TIPC: u32 = 30;
pub const AF_BLUETOOTH: u32 = 31;
pub const AF_IUCV: u32 = 32;
pub const AF_RXRPC: u32 = 33;
pub const AF_ISDN: u32 = 34;
pub const AF_PHONET: u32 = 35;
pub const AF_IEEE802154: u32 = 36;
pub const AF_CAIF: u32 = 37;
pub const AF_ALG: u32 = 38;
pub const AF_NFC: u32 = 39;
pub const AF_VSOCK: u32 = 40;
pub const AF_KCM: u32 = 41;
pub const AF_QIPCRTR: u32 = 42;
pub const AF_SMC: u32 = 43;
pub const AF_MAX: u32 = 44;
pub const SOL_RAW: u32 = 255;
pub const SOL_DECNET: u32 = 261;
pub const SOL_X25: u32 = 262;
pub const SOL_PACKET: u32 = 263;
pub const SOL_ATM: u32 = 264;
pub const SOL_AAL: u32 = 265;
pub const SOL_IRDA: u32 = 266;
pub const SOL_NETBEUI: u32 = 267;
pub const SOL_LLC: u32 = 268;
pub const SOL_DCCP: u32 = 269;
pub const SOL_NETLINK: u32 = 270;
pub const SOL_TIPC: u32 = 271;
pub const SOL_RXRPC: u32 = 272;
pub const SOL_PPPOL2TP: u32 = 273;
pub const SOL_BLUETOOTH: u32 = 274;
pub const SOL_PNPIPE: u32 = 275;
pub const SOL_RDS: u32 = 276;
pub const SOL_IUCV: u32 = 277;
pub const SOL_CAIF: u32 = 278;
pub const SOL_ALG: u32 = 279;
pub const SOL_NFC: u32 = 280;
pub const SOL_KCM: u32 = 281;
pub const SOL_TLS: u32 = 282;
pub const SOMAXCONN: u32 = 128;
pub const _BITS_SOCKADDR_H: u32 = 1;
pub const _SS_SIZE: u32 = 128;
pub const FIOSETOWN: u32 = 35073;
pub const SIOCSPGRP: u32 = 35074;
pub const FIOGETOWN: u32 = 35075;
pub const SIOCGPGRP: u32 = 35076;
pub const SIOCATMARK: u32 = 35077;
pub const SIOCGSTAMP: u32 = 35078;
pub const SIOCGSTAMPNS: u32 = 35079;
pub const SOL_SOCKET: u32 = 1;
pub const SO_DEBUG: u32 = 1;
pub const SO_REUSEADDR: u32 = 2;
pub const SO_TYPE: u32 = 3;
pub const SO_ERROR: u32 = 4;
pub const SO_DONTROUTE: u32 = 5;
pub const SO_BROADCAST: u32 = 6;
pub const SO_SNDBUF: u32 = 7;
pub const SO_RCVBUF: u32 = 8;
pub const SO_SNDBUFFORCE: u32 = 32;
pub const SO_RCVBUFFORCE: u32 = 33;
pub const SO_KEEPALIVE: u32 = 9;
pub const SO_OOBINLINE: u32 = 10;
pub const SO_NO_CHECK: u32 = 11;
pub const SO_PRIORITY: u32 = 12;
pub const SO_LINGER: u32 = 13;
pub const SO_BSDCOMPAT: u32 = 14;
pub const SO_REUSEPORT: u32 = 15;
pub const SO_PASSCRED: u32 = 16;
pub const SO_PEERCRED: u32 = 17;
pub const SO_RCVLOWAT: u32 = 18;
pub const SO_SNDLOWAT: u32 = 19;
pub const SO_RCVTIMEO: u32 = 20;
pub const SO_SNDTIMEO: u32 = 21;
pub const SO_SECURITY_AUTHENTICATION: u32 = 22;
pub const SO_SECURITY_ENCRYPTION_TRANSPORT: u32 = 23;
pub const SO_SECURITY_ENCRYPTION_NETWORK: u32 = 24;
pub const SO_BINDTODEVICE: u32 = 25;
pub const SO_ATTACH_FILTER: u32 = 26;
pub const SO_DETACH_FILTER: u32 = 27;
pub const SO_GET_FILTER: u32 = 26;
pub const SO_PEERNAME: u32 = 28;
pub const SO_TIMESTAMP: u32 = 29;
pub const SCM_TIMESTAMP: u32 = 29;
pub const SO_ACCEPTCONN: u32 = 30;
pub const SO_PEERSEC: u32 = 31;
pub const SO_PASSSEC: u32 = 34;
pub const SO_TIMESTAMPNS: u32 = 35;
pub const SCM_TIMESTAMPNS: u32 = 35;
pub const SO_MARK: u32 = 36;
pub const SO_TIMESTAMPING: u32 = 37;
pub const SCM_TIMESTAMPING: u32 = 37;
pub const SO_PROTOCOL: u32 = 38;
pub const SO_DOMAIN: u32 = 39;
pub const SO_RXQ_OVFL: u32 = 40;
pub const SO_WIFI_STATUS: u32 = 41;
pub const SCM_WIFI_STATUS: u32 = 41;
pub const SO_PEEK_OFF: u32 = 42;
pub const SO_NOFCS: u32 = 43;
pub const SO_LOCK_FILTER: u32 = 44;
pub const SO_SELECT_ERR_QUEUE: u32 = 45;
pub const SO_BUSY_POLL: u32 = 46;
pub const SO_MAX_PACING_RATE: u32 = 47;
pub const SO_BPF_EXTENSIONS: u32 = 48;
pub const SO_INCOMING_CPU: u32 = 49;
pub const SO_ATTACH_BPF: u32 = 50;
pub const SO_DETACH_BPF: u32 = 27;
pub const SO_ATTACH_REUSEPORT_CBPF: u32 = 51;
pub const SO_ATTACH_REUSEPORT_EBPF: u32 = 52;
pub const SO_CNX_ADVICE: u32 = 53;
pub const SCM_TIMESTAMPING_OPT_STATS: u32 = 54;
pub const SO_MEMINFO: u32 = 55;
pub const SO_INCOMING_NAPI_ID: u32 = 56;
pub const SO_COOKIE: u32 = 57;
pub const SCM_TIMESTAMPING_PKTINFO: u32 = 58;
pub const SO_PEERGROUPS: u32 = 59;
pub const SO_ZEROCOPY: u32 = 60;
pub const SO_TXTIME: u32 = 61;
pub const SCM_TXTIME: u32 = 61;
pub const __osockaddr_defined: u32 = 1;
pub const __USE_KERNEL_IPV6_DEFS: u32 = 0;
pub const IP_OPTIONS: u32 = 4;
pub const IP_HDRINCL: u32 = 3;
pub const IP_TOS: u32 = 1;
pub const IP_TTL: u32 = 2;
pub const IP_RECVOPTS: u32 = 6;
pub const IP_RETOPTS: u32 = 7;
pub const IP_MULTICAST_IF: u32 = 32;
pub const IP_MULTICAST_TTL: u32 = 33;
pub const IP_MULTICAST_LOOP: u32 = 34;
pub const IP_ADD_MEMBERSHIP: u32 = 35;
pub const IP_DROP_MEMBERSHIP: u32 = 36;
pub const IP_UNBLOCK_SOURCE: u32 = 37;
pub const IP_BLOCK_SOURCE: u32 = 38;
pub const IP_ADD_SOURCE_MEMBERSHIP: u32 = 39;
pub const IP_DROP_SOURCE_MEMBERSHIP: u32 = 40;
pub const IP_MSFILTER: u32 = 41;
pub const MCAST_JOIN_GROUP: u32 = 42;
pub const MCAST_BLOCK_SOURCE: u32 = 43;
pub const MCAST_UNBLOCK_SOURCE: u32 = 44;
pub const MCAST_LEAVE_GROUP: u32 = 45;
pub const MCAST_JOIN_SOURCE_GROUP: u32 = 46;
pub const MCAST_LEAVE_SOURCE_GROUP: u32 = 47;
pub const MCAST_MSFILTER: u32 = 48;
pub const IP_MULTICAST_ALL: u32 = 49;
pub const IP_UNICAST_IF: u32 = 50;
pub const MCAST_EXCLUDE: u32 = 0;
pub const MCAST_INCLUDE: u32 = 1;
pub const IP_ROUTER_ALERT: u32 = 5;
pub const IP_PKTINFO: u32 = 8;
pub const IP_PKTOPTIONS: u32 = 9;
pub const IP_PMTUDISC: u32 = 10;
pub const IP_MTU_DISCOVER: u32 = 10;
pub const IP_RECVERR: u32 = 11;
pub const IP_RECVTTL: u32 = 12;
pub const IP_RECVTOS: u32 = 13;
pub const IP_MTU: u32 = 14;
pub const IP_FREEBIND: u32 = 15;
pub const IP_IPSEC_POLICY: u32 = 16;
pub const IP_XFRM_POLICY: u32 = 17;
pub const IP_PASSSEC: u32 = 18;
pub const IP_TRANSPARENT: u32 = 19;
pub const IP_ORIGDSTADDR: u32 = 20;
pub const IP_RECVORIGDSTADDR: u32 = 20;
pub const IP_MINTTL: u32 = 21;
pub const IP_NODEFRAG: u32 = 22;
pub const IP_CHECKSUM: u32 = 23;
pub const IP_BIND_ADDRESS_NO_PORT: u32 = 24;
pub const IP_RECVFRAGSIZE: u32 = 25;
pub const IP_PMTUDISC_DONT: u32 = 0;
pub const IP_PMTUDISC_WANT: u32 = 1;
pub const IP_PMTUDISC_DO: u32 = 2;
pub const IP_PMTUDISC_PROBE: u32 = 3;
pub const IP_PMTUDISC_INTERFACE: u32 = 4;
pub const IP_PMTUDISC_OMIT: u32 = 5;
pub const SOL_IP: u32 = 0;
pub const IP_DEFAULT_MULTICAST_TTL: u32 = 1;
pub const IP_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IP_MAX_MEMBERSHIPS: u32 = 20;
pub const IPV6_ADDRFORM: u32 = 1;
pub const IPV6_2292PKTINFO: u32 = 2;
pub const IPV6_2292HOPOPTS: u32 = 3;
pub const IPV6_2292DSTOPTS: u32 = 4;
pub const IPV6_2292RTHDR: u32 = 5;
pub const IPV6_2292PKTOPTIONS: u32 = 6;
pub const IPV6_CHECKSUM: u32 = 7;
pub const IPV6_2292HOPLIMIT: u32 = 8;
pub const IPV6_NEXTHOP: u32 = 9;
pub const IPV6_AUTHHDR: u32 = 10;
pub const IPV6_UNICAST_HOPS: u32 = 16;
pub const IPV6_MULTICAST_IF: u32 = 17;
pub const IPV6_MULTICAST_HOPS: u32 = 18;
pub const IPV6_MULTICAST_LOOP: u32 = 19;
pub const IPV6_JOIN_GROUP: u32 = 20;
pub const IPV6_LEAVE_GROUP: u32 = 21;
pub const IPV6_ROUTER_ALERT: u32 = 22;
pub const IPV6_MTU_DISCOVER: u32 = 23;
pub const IPV6_MTU: u32 = 24;
pub const IPV6_RECVERR: u32 = 25;
pub const IPV6_V6ONLY: u32 = 26;
pub const IPV6_JOIN_ANYCAST: u32 = 27;
pub const IPV6_LEAVE_ANYCAST: u32 = 28;
pub const IPV6_IPSEC_POLICY: u32 = 34;
pub const IPV6_XFRM_POLICY: u32 = 35;
pub const IPV6_HDRINCL: u32 = 36;
pub const IPV6_RECVPKTINFO: u32 = 49;
pub const IPV6_PKTINFO: u32 = 50;
pub const IPV6_RECVHOPLIMIT: u32 = 51;
pub const IPV6_HOPLIMIT: u32 = 52;
pub const IPV6_RECVHOPOPTS: u32 = 53;
pub const IPV6_HOPOPTS: u32 = 54;
pub const IPV6_RTHDRDSTOPTS: u32 = 55;
pub const IPV6_RECVRTHDR: u32 = 56;
pub const IPV6_RTHDR: u32 = 57;
pub const IPV6_RECVDSTOPTS: u32 = 58;
pub const IPV6_DSTOPTS: u32 = 59;
pub const IPV6_RECVPATHMTU: u32 = 60;
pub const IPV6_PATHMTU: u32 = 61;
pub const IPV6_DONTFRAG: u32 = 62;
pub const IPV6_RECVTCLASS: u32 = 66;
pub const IPV6_TCLASS: u32 = 67;
pub const IPV6_AUTOFLOWLABEL: u32 = 70;
pub const IPV6_ADDR_PREFERENCES: u32 = 72;
pub const IPV6_MINHOPCOUNT: u32 = 73;
pub const IPV6_ORIGDSTADDR: u32 = 74;
pub const IPV6_RECVORIGDSTADDR: u32 = 74;
pub const IPV6_TRANSPARENT: u32 = 75;
pub const IPV6_UNICAST_IF: u32 = 76;
pub const IPV6_RECVFRAGSIZE: u32 = 77;
pub const IPV6_FREEBIND: u32 = 78;
pub const IPV6_ADD_MEMBERSHIP: u32 = 20;
pub const IPV6_DROP_MEMBERSHIP: u32 = 21;
pub const IPV6_RXHOPOPTS: u32 = 54;
pub const IPV6_RXDSTOPTS: u32 = 59;
pub const IPV6_PMTUDISC_DONT: u32 = 0;
pub const IPV6_PMTUDISC_WANT: u32 = 1;
pub const IPV6_PMTUDISC_DO: u32 = 2;
pub const IPV6_PMTUDISC_PROBE: u32 = 3;
pub const IPV6_PMTUDISC_INTERFACE: u32 = 4;
pub const IPV6_PMTUDISC_OMIT: u32 = 5;
pub const SOL_IPV6: u32 = 41;
pub const SOL_ICMPV6: u32 = 58;
pub const IPV6_RTHDR_LOOSE: u32 = 0;
pub const IPV6_RTHDR_STRICT: u32 = 1;
pub const IPV6_RTHDR_TYPE_0: u32 = 0;
pub const IN_CLASSA_NET: u32 = 4278190080;
pub const IN_CLASSA_NSHIFT: u32 = 24;
pub const IN_CLASSA_HOST: u32 = 16777215;
pub const IN_CLASSA_MAX: u32 = 128;
pub const IN_CLASSB_NET: u32 = 4294901760;
pub const IN_CLASSB_NSHIFT: u32 = 16;
pub const IN_CLASSB_HOST: u32 = 65535;
pub const IN_CLASSB_MAX: u32 = 65536;
pub const IN_CLASSC_NET: u32 = 4294967040;
pub const IN_CLASSC_NSHIFT: u32 = 8;
pub const IN_CLASSC_HOST: u32 = 255;
pub const IN_LOOPBACKNET: u32 = 127;
pub const INET_ADDRSTRLEN: u32 = 16;
pub const INET6_ADDRSTRLEN: u32 = 46;
pub const _TIME_H: u32 = 1;
pub const _BITS_TIME_H: u32 = 1;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_MONOTONIC: u32 = 1;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 2;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 3;
pub const CLOCK_MONOTONIC_RAW: u32 = 4;
pub const CLOCK_REALTIME_COARSE: u32 = 5;
pub const CLOCK_MONOTONIC_COARSE: u32 = 6;
pub const CLOCK_BOOTTIME: u32 = 7;
pub const CLOCK_REALTIME_ALARM: u32 = 8;
pub const CLOCK_BOOTTIME_ALARM: u32 = 9;
pub const CLOCK_TAI: u32 = 11;
pub const TIMER_ABSTIME: u32 = 1;
pub const __struct_tm_defined: u32 = 1;
pub const __itimerspec_defined: u32 = 1;
pub const _BITS_TYPES_LOCALE_T_H: u32 = 1;
pub const _BITS_TYPES___LOCALE_T_H: u32 = 1;
pub const TIME_UTC: u32 = 1;
pub const LYD_VALUE_FIXED_MEM_SIZE: u32 = 24;
pub const LYPLG_SUFFIX: &'static [u8; 4usize] = b".so\0";
pub const LYPLG_TYPE_DIR: &'static [u8; 34usize] =
    b"/usr/local/lib/libyang/extensions\0";
pub const LYPLG_EXT_DIR: &'static [u8; 29usize] =
    b"/usr/local/lib/libyang/types\0";
pub const _INTTYPES_H: u32 = 1;
pub const ____gwchar_t_defined: u32 = 1;
pub const __PRI64_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const __PRIPTR_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const PRId8: &'static [u8; 2usize] = b"d\0";
pub const PRId16: &'static [u8; 2usize] = b"d\0";
pub const PRId32: &'static [u8; 2usize] = b"d\0";
pub const PRId64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdLEAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST16: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIi8: &'static [u8; 2usize] = b"i\0";
pub const PRIi16: &'static [u8; 2usize] = b"i\0";
pub const PRIi32: &'static [u8; 2usize] = b"i\0";
pub const PRIi64: &'static [u8; 3usize] = b"li\0";
pub const PRIiLEAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST16: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiFAST16: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST32: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIo8: &'static [u8; 2usize] = b"o\0";
pub const PRIo16: &'static [u8; 2usize] = b"o\0";
pub const PRIo32: &'static [u8; 2usize] = b"o\0";
pub const PRIo64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoLEAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST16: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIu8: &'static [u8; 2usize] = b"u\0";
pub const PRIu16: &'static [u8; 2usize] = b"u\0";
pub const PRIu32: &'static [u8; 2usize] = b"u\0";
pub const PRIu64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuLEAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST16: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIx8: &'static [u8; 2usize] = b"x\0";
pub const PRIx16: &'static [u8; 2usize] = b"x\0";
pub const PRIx32: &'static [u8; 2usize] = b"x\0";
pub const PRIx64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxLEAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST16: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIX8: &'static [u8; 2usize] = b"X\0";
pub const PRIX16: &'static [u8; 2usize] = b"X\0";
pub const PRIX32: &'static [u8; 2usize] = b"X\0";
pub const PRIX64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXLEAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST16: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXFAST16: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST32: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIdMAX: &'static [u8; 3usize] = b"ld\0";
pub const PRIiMAX: &'static [u8; 3usize] = b"li\0";
pub const PRIoMAX: &'static [u8; 3usize] = b"lo\0";
pub const PRIuMAX: &'static [u8; 3usize] = b"lu\0";
pub const PRIxMAX: &'static [u8; 3usize] = b"lx\0";
pub const PRIXMAX: &'static [u8; 3usize] = b"lX\0";
pub const PRIdPTR: &'static [u8; 3usize] = b"ld\0";
pub const PRIiPTR: &'static [u8; 3usize] = b"li\0";
pub const PRIoPTR: &'static [u8; 3usize] = b"lo\0";
pub const PRIuPTR: &'static [u8; 3usize] = b"lu\0";
pub const PRIxPTR: &'static [u8; 3usize] = b"lx\0";
pub const PRIXPTR: &'static [u8; 3usize] = b"lX\0";
pub const SCNd8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNd16: &'static [u8; 3usize] = b"hd\0";
pub const SCNd32: &'static [u8; 2usize] = b"d\0";
pub const SCNd64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNi8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNi16: &'static [u8; 3usize] = b"hi\0";
pub const SCNi32: &'static [u8; 2usize] = b"i\0";
pub const SCNi64: &'static [u8; 3usize] = b"li\0";
pub const SCNiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiFAST16: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST32: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNu8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNu16: &'static [u8; 3usize] = b"hu\0";
pub const SCNu32: &'static [u8; 2usize] = b"u\0";
pub const SCNu64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNo8: &'static [u8; 4usize] = b"hho\0";
pub const SCNo16: &'static [u8; 3usize] = b"ho\0";
pub const SCNo32: &'static [u8; 2usize] = b"o\0";
pub const SCNo64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNx8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNx16: &'static [u8; 3usize] = b"hx\0";
pub const SCNx32: &'static [u8; 2usize] = b"x\0";
pub const SCNx64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNdMAX: &'static [u8; 3usize] = b"ld\0";
pub const SCNiMAX: &'static [u8; 3usize] = b"li\0";
pub const SCNoMAX: &'static [u8; 3usize] = b"lo\0";
pub const SCNuMAX: &'static [u8; 3usize] = b"lu\0";
pub const SCNxMAX: &'static [u8; 3usize] = b"lx\0";
pub const SCNdPTR: &'static [u8; 3usize] = b"ld\0";
pub const SCNiPTR: &'static [u8; 3usize] = b"li\0";
pub const SCNoPTR: &'static [u8; 3usize] = b"lo\0";
pub const SCNuPTR: &'static [u8; 3usize] = b"lu\0";
pub const SCNxPTR: &'static [u8; 3usize] = b"lx\0";
pub const LY_PRI_ARRAY_COUNT_TYPE: &'static [u8; 3usize] = b"lu\0";
pub const LY_DATA_TYPE_COUNT: u32 = 20;
pub const PCRE2_CODE_UNIT_WIDTH: u32 = 8;
pub const PCRE2_MAJOR: u32 = 10;
pub const PCRE2_MINOR: u32 = 32;
pub const PCRE2_DATE: u32 = 1999;
pub const PCRE2_HAVE_STDINT_H: u32 = 1;
pub const PCRE2_HAVE_INTTYPES_H: u32 = 1;
pub const _LIBC_LIMITS_H_: u32 = 1;
pub const MB_LEN_MAX: u32 = 16;
pub const _BITS_POSIX1_LIM_H: u32 = 1;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const PTHREAD_KEYS_MAX: u32 = 1024;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const AIO_PRIO_DELTA_MAX: u32 = 20;
pub const PTHREAD_STACK_MIN: u32 = 16384;
pub const DELAYTIMER_MAX: u32 = 2147483647;
pub const TTY_NAME_MAX: u32 = 32;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const HOST_NAME_MAX: u32 = 64;
pub const MQ_PRIO_MAX: u32 = 32768;
pub const SEM_VALUE_MAX: u32 = 2147483647;
pub const _BITS_POSIX2_LIM_H: u32 = 1;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const COLL_WEIGHTS_MAX: u32 = 255;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const CHARCLASS_NAME_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 32767;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __ENUM_IDTYPE_T: u32 = 1;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const __HAVE_FLOAT128: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128: u32 = 0;
pub const __HAVE_FLOAT64X: u32 = 1;
pub const __HAVE_FLOAT64X_LONG_DOUBLE: u32 = 1;
pub const __HAVE_FLOAT16: u32 = 0;
pub const __HAVE_FLOAT32: u32 = 1;
pub const __HAVE_FLOAT64: u32 = 1;
pub const __HAVE_FLOAT32X: u32 = 1;
pub const __HAVE_FLOAT128X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT16: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128X: u32 = 0;
pub const __HAVE_FLOATN_NOT_TYPEDEF: u32 = 0;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _ALLOCA_H: u32 = 1;
pub const PCRE2_ANCHORED: u32 = 2147483648;
pub const PCRE2_NO_UTF_CHECK: u32 = 1073741824;
pub const PCRE2_ENDANCHORED: u32 = 536870912;
pub const PCRE2_ALLOW_EMPTY_CLASS: u32 = 1;
pub const PCRE2_ALT_BSUX: u32 = 2;
pub const PCRE2_AUTO_CALLOUT: u32 = 4;
pub const PCRE2_CASELESS: u32 = 8;
pub const PCRE2_DOLLAR_ENDONLY: u32 = 16;
pub const PCRE2_DOTALL: u32 = 32;
pub const PCRE2_DUPNAMES: u32 = 64;
pub const PCRE2_EXTENDED: u32 = 128;
pub const PCRE2_FIRSTLINE: u32 = 256;
pub const PCRE2_MATCH_UNSET_BACKREF: u32 = 512;
pub const PCRE2_MULTILINE: u32 = 1024;
pub const PCRE2_NEVER_UCP: u32 = 2048;
pub const PCRE2_NEVER_UTF: u32 = 4096;
pub const PCRE2_NO_AUTO_CAPTURE: u32 = 8192;
pub const PCRE2_NO_AUTO_POSSESS: u32 = 16384;
pub const PCRE2_NO_DOTSTAR_ANCHOR: u32 = 32768;
pub const PCRE2_NO_START_OPTIMIZE: u32 = 65536;
pub const PCRE2_UCP: u32 = 131072;
pub const PCRE2_UNGREEDY: u32 = 262144;
pub const PCRE2_UTF: u32 = 524288;
pub const PCRE2_NEVER_BACKSLASH_C: u32 = 1048576;
pub const PCRE2_ALT_CIRCUMFLEX: u32 = 2097152;
pub const PCRE2_ALT_VERBNAMES: u32 = 4194304;
pub const PCRE2_USE_OFFSET_LIMIT: u32 = 8388608;
pub const PCRE2_EXTENDED_MORE: u32 = 16777216;
pub const PCRE2_LITERAL: u32 = 33554432;
pub const PCRE2_EXTRA_ALLOW_SURROGATE_ESCAPES: u32 = 1;
pub const PCRE2_EXTRA_BAD_ESCAPE_IS_LITERAL: u32 = 2;
pub const PCRE2_EXTRA_MATCH_WORD: u32 = 4;
pub const PCRE2_EXTRA_MATCH_LINE: u32 = 8;
pub const PCRE2_JIT_COMPLETE: u32 = 1;
pub const PCRE2_JIT_PARTIAL_SOFT: u32 = 2;
pub const PCRE2_JIT_PARTIAL_HARD: u32 = 4;
pub const PCRE2_NOTBOL: u32 = 1;
pub const PCRE2_NOTEOL: u32 = 2;
pub const PCRE2_NOTEMPTY: u32 = 4;
pub const PCRE2_NOTEMPTY_ATSTART: u32 = 8;
pub const PCRE2_PARTIAL_SOFT: u32 = 16;
pub const PCRE2_PARTIAL_HARD: u32 = 32;
pub const PCRE2_DFA_RESTART: u32 = 64;
pub const PCRE2_DFA_SHORTEST: u32 = 128;
pub const PCRE2_SUBSTITUTE_GLOBAL: u32 = 256;
pub const PCRE2_SUBSTITUTE_EXTENDED: u32 = 512;
pub const PCRE2_SUBSTITUTE_UNSET_EMPTY: u32 = 1024;
pub const PCRE2_SUBSTITUTE_UNKNOWN_UNSET: u32 = 2048;
pub const PCRE2_SUBSTITUTE_OVERFLOW_LENGTH: u32 = 4096;
pub const PCRE2_NO_JIT: u32 = 8192;
pub const PCRE2_CONVERT_UTF: u32 = 1;
pub const PCRE2_CONVERT_NO_UTF_CHECK: u32 = 2;
pub const PCRE2_CONVERT_POSIX_BASIC: u32 = 4;
pub const PCRE2_CONVERT_POSIX_EXTENDED: u32 = 8;
pub const PCRE2_CONVERT_GLOB: u32 = 16;
pub const PCRE2_CONVERT_GLOB_NO_WILD_SEPARATOR: u32 = 48;
pub const PCRE2_CONVERT_GLOB_NO_STARSTAR: u32 = 80;
pub const PCRE2_NEWLINE_CR: u32 = 1;
pub const PCRE2_NEWLINE_LF: u32 = 2;
pub const PCRE2_NEWLINE_CRLF: u32 = 3;
pub const PCRE2_NEWLINE_ANY: u32 = 4;
pub const PCRE2_NEWLINE_ANYCRLF: u32 = 5;
pub const PCRE2_NEWLINE_NUL: u32 = 6;
pub const PCRE2_BSR_UNICODE: u32 = 1;
pub const PCRE2_BSR_ANYCRLF: u32 = 2;
pub const PCRE2_ERROR_END_BACKSLASH: u32 = 101;
pub const PCRE2_ERROR_END_BACKSLASH_C: u32 = 102;
pub const PCRE2_ERROR_UNKNOWN_ESCAPE: u32 = 103;
pub const PCRE2_ERROR_QUANTIFIER_OUT_OF_ORDER: u32 = 104;
pub const PCRE2_ERROR_QUANTIFIER_TOO_BIG: u32 = 105;
pub const PCRE2_ERROR_MISSING_SQUARE_BRACKET: u32 = 106;
pub const PCRE2_ERROR_ESCAPE_INVALID_IN_CLASS: u32 = 107;
pub const PCRE2_ERROR_CLASS_RANGE_ORDER: u32 = 108;
pub const PCRE2_ERROR_QUANTIFIER_INVALID: u32 = 109;
pub const PCRE2_ERROR_INTERNAL_UNEXPECTED_REPEAT: u32 = 110;
pub const PCRE2_ERROR_INVALID_AFTER_PARENS_QUERY: u32 = 111;
pub const PCRE2_ERROR_POSIX_CLASS_NOT_IN_CLASS: u32 = 112;
pub const PCRE2_ERROR_POSIX_NO_SUPPORT_COLLATING: u32 = 113;
pub const PCRE2_ERROR_MISSING_CLOSING_PARENTHESIS: u32 = 114;
pub const PCRE2_ERROR_BAD_SUBPATTERN_REFERENCE: u32 = 115;
pub const PCRE2_ERROR_NULL_PATTERN: u32 = 116;
pub const PCRE2_ERROR_BAD_OPTIONS: u32 = 117;
pub const PCRE2_ERROR_MISSING_COMMENT_CLOSING: u32 = 118;
pub const PCRE2_ERROR_PARENTHESES_NEST_TOO_DEEP: u32 = 119;
pub const PCRE2_ERROR_PATTERN_TOO_LARGE: u32 = 120;
pub const PCRE2_ERROR_HEAP_FAILED: u32 = 121;
pub const PCRE2_ERROR_UNMATCHED_CLOSING_PARENTHESIS: u32 = 122;
pub const PCRE2_ERROR_INTERNAL_CODE_OVERFLOW: u32 = 123;
pub const PCRE2_ERROR_MISSING_CONDITION_CLOSING: u32 = 124;
pub const PCRE2_ERROR_LOOKBEHIND_NOT_FIXED_LENGTH: u32 = 125;
pub const PCRE2_ERROR_ZERO_RELATIVE_REFERENCE: u32 = 126;
pub const PCRE2_ERROR_TOO_MANY_CONDITION_BRANCHES: u32 = 127;
pub const PCRE2_ERROR_CONDITION_ASSERTION_EXPECTED: u32 = 128;
pub const PCRE2_ERROR_BAD_RELATIVE_REFERENCE: u32 = 129;
pub const PCRE2_ERROR_UNKNOWN_POSIX_CLASS: u32 = 130;
pub const PCRE2_ERROR_INTERNAL_STUDY_ERROR: u32 = 131;
pub const PCRE2_ERROR_UNICODE_NOT_SUPPORTED: u32 = 132;
pub const PCRE2_ERROR_PARENTHESES_STACK_CHECK: u32 = 133;
pub const PCRE2_ERROR_CODE_POINT_TOO_BIG: u32 = 134;
pub const PCRE2_ERROR_LOOKBEHIND_TOO_COMPLICATED: u32 = 135;
pub const PCRE2_ERROR_LOOKBEHIND_INVALID_BACKSLASH_C: u32 = 136;
pub const PCRE2_ERROR_UNSUPPORTED_ESCAPE_SEQUENCE: u32 = 137;
pub const PCRE2_ERROR_CALLOUT_NUMBER_TOO_BIG: u32 = 138;
pub const PCRE2_ERROR_MISSING_CALLOUT_CLOSING: u32 = 139;
pub const PCRE2_ERROR_ESCAPE_INVALID_IN_VERB: u32 = 140;
pub const PCRE2_ERROR_UNRECOGNIZED_AFTER_QUERY_P: u32 = 141;
pub const PCRE2_ERROR_MISSING_NAME_TERMINATOR: u32 = 142;
pub const PCRE2_ERROR_DUPLICATE_SUBPATTERN_NAME: u32 = 143;
pub const PCRE2_ERROR_INVALID_SUBPATTERN_NAME: u32 = 144;
pub const PCRE2_ERROR_UNICODE_PROPERTIES_UNAVAILABLE: u32 = 145;
pub const PCRE2_ERROR_MALFORMED_UNICODE_PROPERTY: u32 = 146;
pub const PCRE2_ERROR_UNKNOWN_UNICODE_PROPERTY: u32 = 147;
pub const PCRE2_ERROR_SUBPATTERN_NAME_TOO_LONG: u32 = 148;
pub const PCRE2_ERROR_TOO_MANY_NAMED_SUBPATTERNS: u32 = 149;
pub const PCRE2_ERROR_CLASS_INVALID_RANGE: u32 = 150;
pub const PCRE2_ERROR_OCTAL_BYTE_TOO_BIG: u32 = 151;
pub const PCRE2_ERROR_INTERNAL_OVERRAN_WORKSPACE: u32 = 152;
pub const PCRE2_ERROR_INTERNAL_MISSING_SUBPATTERN: u32 = 153;
pub const PCRE2_ERROR_DEFINE_TOO_MANY_BRANCHES: u32 = 154;
pub const PCRE2_ERROR_BACKSLASH_O_MISSING_BRACE: u32 = 155;
pub const PCRE2_ERROR_INTERNAL_UNKNOWN_NEWLINE: u32 = 156;
pub const PCRE2_ERROR_BACKSLASH_G_SYNTAX: u32 = 157;
pub const PCRE2_ERROR_PARENS_QUERY_R_MISSING_CLOSING: u32 = 158;
pub const PCRE2_ERROR_VERB_ARGUMENT_NOT_ALLOWED: u32 = 159;
pub const PCRE2_ERROR_VERB_UNKNOWN: u32 = 160;
pub const PCRE2_ERROR_SUBPATTERN_NUMBER_TOO_BIG: u32 = 161;
pub const PCRE2_ERROR_SUBPATTERN_NAME_EXPECTED: u32 = 162;
pub const PCRE2_ERROR_INTERNAL_PARSED_OVERFLOW: u32 = 163;
pub const PCRE2_ERROR_INVALID_OCTAL: u32 = 164;
pub const PCRE2_ERROR_SUBPATTERN_NAMES_MISMATCH: u32 = 165;
pub const PCRE2_ERROR_MARK_MISSING_ARGUMENT: u32 = 166;
pub const PCRE2_ERROR_INVALID_HEXADECIMAL: u32 = 167;
pub const PCRE2_ERROR_BACKSLASH_C_SYNTAX: u32 = 168;
pub const PCRE2_ERROR_BACKSLASH_K_SYNTAX: u32 = 169;
pub const PCRE2_ERROR_INTERNAL_BAD_CODE_LOOKBEHINDS: u32 = 170;
pub const PCRE2_ERROR_BACKSLASH_N_IN_CLASS: u32 = 171;
pub const PCRE2_ERROR_CALLOUT_STRING_TOO_LONG: u32 = 172;
pub const PCRE2_ERROR_UNICODE_DISALLOWED_CODE_POINT: u32 = 173;
pub const PCRE2_ERROR_UTF_IS_DISABLED: u32 = 174;
pub const PCRE2_ERROR_UCP_IS_DISABLED: u32 = 175;
pub const PCRE2_ERROR_VERB_NAME_TOO_LONG: u32 = 176;
pub const PCRE2_ERROR_BACKSLASH_U_CODE_POINT_TOO_BIG: u32 = 177;
pub const PCRE2_ERROR_MISSING_OCTAL_OR_HEX_DIGITS: u32 = 178;
pub const PCRE2_ERROR_VERSION_CONDITION_SYNTAX: u32 = 179;
pub const PCRE2_ERROR_INTERNAL_BAD_CODE_AUTO_POSSESS: u32 = 180;
pub const PCRE2_ERROR_CALLOUT_NO_STRING_DELIMITER: u32 = 181;
pub const PCRE2_ERROR_CALLOUT_BAD_STRING_DELIMITER: u32 = 182;
pub const PCRE2_ERROR_BACKSLASH_C_CALLER_DISABLED: u32 = 183;
pub const PCRE2_ERROR_QUERY_BARJX_NEST_TOO_DEEP: u32 = 184;
pub const PCRE2_ERROR_BACKSLASH_C_LIBRARY_DISABLED: u32 = 185;
pub const PCRE2_ERROR_PATTERN_TOO_COMPLICATED: u32 = 186;
pub const PCRE2_ERROR_LOOKBEHIND_TOO_LONG: u32 = 187;
pub const PCRE2_ERROR_PATTERN_STRING_TOO_LONG: u32 = 188;
pub const PCRE2_ERROR_INTERNAL_BAD_CODE: u32 = 189;
pub const PCRE2_ERROR_INTERNAL_BAD_CODE_IN_SKIP: u32 = 190;
pub const PCRE2_ERROR_NO_SURROGATES_IN_UTF16: u32 = 191;
pub const PCRE2_ERROR_BAD_LITERAL_OPTIONS: u32 = 192;
pub const PCRE2_ERROR_SUPPORTED_ONLY_IN_UNICODE: u32 = 193;
pub const PCRE2_ERROR_INVALID_HYPHEN_IN_OPTIONS: u32 = 194;
pub const PCRE2_ERROR_NOMATCH: i32 = -1;
pub const PCRE2_ERROR_PARTIAL: i32 = -2;
pub const PCRE2_ERROR_UTF8_ERR1: i32 = -3;
pub const PCRE2_ERROR_UTF8_ERR2: i32 = -4;
pub const PCRE2_ERROR_UTF8_ERR3: i32 = -5;
pub const PCRE2_ERROR_UTF8_ERR4: i32 = -6;
pub const PCRE2_ERROR_UTF8_ERR5: i32 = -7;
pub const PCRE2_ERROR_UTF8_ERR6: i32 = -8;
pub const PCRE2_ERROR_UTF8_ERR7: i32 = -9;
pub const PCRE2_ERROR_UTF8_ERR8: i32 = -10;
pub const PCRE2_ERROR_UTF8_ERR9: i32 = -11;
pub const PCRE2_ERROR_UTF8_ERR10: i32 = -12;
pub const PCRE2_ERROR_UTF8_ERR11: i32 = -13;
pub const PCRE2_ERROR_UTF8_ERR12: i32 = -14;
pub const PCRE2_ERROR_UTF8_ERR13: i32 = -15;
pub const PCRE2_ERROR_UTF8_ERR14: i32 = -16;
pub const PCRE2_ERROR_UTF8_ERR15: i32 = -17;
pub const PCRE2_ERROR_UTF8_ERR16: i32 = -18;
pub const PCRE2_ERROR_UTF8_ERR17: i32 = -19;
pub const PCRE2_ERROR_UTF8_ERR18: i32 = -20;
pub const PCRE2_ERROR_UTF8_ERR19: i32 = -21;
pub const PCRE2_ERROR_UTF8_ERR20: i32 = -22;
pub const PCRE2_ERROR_UTF8_ERR21: i32 = -23;
pub const PCRE2_ERROR_UTF16_ERR1: i32 = -24;
pub const PCRE2_ERROR_UTF16_ERR2: i32 = -25;
pub const PCRE2_ERROR_UTF16_ERR3: i32 = -26;
pub const PCRE2_ERROR_UTF32_ERR1: i32 = -27;
pub const PCRE2_ERROR_UTF32_ERR2: i32 = -28;
pub const PCRE2_ERROR_BADDATA: i32 = -29;
pub const PCRE2_ERROR_MIXEDTABLES: i32 = -30;
pub const PCRE2_ERROR_BADMAGIC: i32 = -31;
pub const PCRE2_ERROR_BADMODE: i32 = -32;
pub const PCRE2_ERROR_BADOFFSET: i32 = -33;
pub const PCRE2_ERROR_BADOPTION: i32 = -34;
pub const PCRE2_ERROR_BADREPLACEMENT: i32 = -35;
pub const PCRE2_ERROR_BADUTFOFFSET: i32 = -36;
pub const PCRE2_ERROR_CALLOUT: i32 = -37;
pub const PCRE2_ERROR_DFA_BADRESTART: i32 = -38;
pub const PCRE2_ERROR_DFA_RECURSE: i32 = -39;
pub const PCRE2_ERROR_DFA_UCOND: i32 = -40;
pub const PCRE2_ERROR_DFA_UFUNC: i32 = -41;
pub const PCRE2_ERROR_DFA_UITEM: i32 = -42;
pub const PCRE2_ERROR_DFA_WSSIZE: i32 = -43;
pub const PCRE2_ERROR_INTERNAL: i32 = -44;
pub const PCRE2_ERROR_JIT_BADOPTION: i32 = -45;
pub const PCRE2_ERROR_JIT_STACKLIMIT: i32 = -46;
pub const PCRE2_ERROR_MATCHLIMIT: i32 = -47;
pub const PCRE2_ERROR_NOMEMORY: i32 = -48;
pub const PCRE2_ERROR_NOSUBSTRING: i32 = -49;
pub const PCRE2_ERROR_NOUNIQUESUBSTRING: i32 = -50;
pub const PCRE2_ERROR_NULL: i32 = -51;
pub const PCRE2_ERROR_RECURSELOOP: i32 = -52;
pub const PCRE2_ERROR_DEPTHLIMIT: i32 = -53;
pub const PCRE2_ERROR_RECURSIONLIMIT: i32 = -53;
pub const PCRE2_ERROR_UNAVAILABLE: i32 = -54;
pub const PCRE2_ERROR_UNSET: i32 = -55;
pub const PCRE2_ERROR_BADOFFSETLIMIT: i32 = -56;
pub const PCRE2_ERROR_BADREPESCAPE: i32 = -57;
pub const PCRE2_ERROR_REPMISSINGBRACE: i32 = -58;
pub const PCRE2_ERROR_BADSUBSTITUTION: i32 = -59;
pub const PCRE2_ERROR_BADSUBSPATTERN: i32 = -60;
pub const PCRE2_ERROR_TOOMANYREPLACE: i32 = -61;
pub const PCRE2_ERROR_BADSERIALIZEDDATA: i32 = -62;
pub const PCRE2_ERROR_HEAPLIMIT: i32 = -63;
pub const PCRE2_ERROR_CONVERT_SYNTAX: i32 = -64;
pub const PCRE2_ERROR_INTERNAL_DUPMATCH: i32 = -65;
pub const PCRE2_INFO_ALLOPTIONS: u32 = 0;
pub const PCRE2_INFO_ARGOPTIONS: u32 = 1;
pub const PCRE2_INFO_BACKREFMAX: u32 = 2;
pub const PCRE2_INFO_BSR: u32 = 3;
pub const PCRE2_INFO_CAPTURECOUNT: u32 = 4;
pub const PCRE2_INFO_FIRSTCODEUNIT: u32 = 5;
pub const PCRE2_INFO_FIRSTCODETYPE: u32 = 6;
pub const PCRE2_INFO_FIRSTBITMAP: u32 = 7;
pub const PCRE2_INFO_HASCRORLF: u32 = 8;
pub const PCRE2_INFO_JCHANGED: u32 = 9;
pub const PCRE2_INFO_JITSIZE: u32 = 10;
pub const PCRE2_INFO_LASTCODEUNIT: u32 = 11;
pub const PCRE2_INFO_LASTCODETYPE: u32 = 12;
pub const PCRE2_INFO_MATCHEMPTY: u32 = 13;
pub const PCRE2_INFO_MATCHLIMIT: u32 = 14;
pub const PCRE2_INFO_MAXLOOKBEHIND: u32 = 15;
pub const PCRE2_INFO_MINLENGTH: u32 = 16;
pub const PCRE2_INFO_NAMECOUNT: u32 = 17;
pub const PCRE2_INFO_NAMEENTRYSIZE: u32 = 18;
pub const PCRE2_INFO_NAMETABLE: u32 = 19;
pub const PCRE2_INFO_NEWLINE: u32 = 20;
pub const PCRE2_INFO_DEPTHLIMIT: u32 = 21;
pub const PCRE2_INFO_RECURSIONLIMIT: u32 = 21;
pub const PCRE2_INFO_SIZE: u32 = 22;
pub const PCRE2_INFO_HASBACKSLASHC: u32 = 23;
pub const PCRE2_INFO_FRAMESIZE: u32 = 24;
pub const PCRE2_INFO_HEAPLIMIT: u32 = 25;
pub const PCRE2_INFO_EXTRAOPTIONS: u32 = 26;
pub const PCRE2_CONFIG_BSR: u32 = 0;
pub const PCRE2_CONFIG_JIT: u32 = 1;
pub const PCRE2_CONFIG_JITTARGET: u32 = 2;
pub const PCRE2_CONFIG_LINKSIZE: u32 = 3;
pub const PCRE2_CONFIG_MATCHLIMIT: u32 = 4;
pub const PCRE2_CONFIG_NEWLINE: u32 = 5;
pub const PCRE2_CONFIG_PARENSLIMIT: u32 = 6;
pub const PCRE2_CONFIG_DEPTHLIMIT: u32 = 7;
pub const PCRE2_CONFIG_RECURSIONLIMIT: u32 = 7;
pub const PCRE2_CONFIG_STACKRECURSE: u32 = 8;
pub const PCRE2_CONFIG_UNICODE: u32 = 9;
pub const PCRE2_CONFIG_UNICODE_VERSION: u32 = 10;
pub const PCRE2_CONFIG_VERSION: u32 = 11;
pub const PCRE2_CONFIG_HEAPLIMIT: u32 = 12;
pub const PCRE2_CONFIG_NEVER_BACKSLASH_C: u32 = 13;
pub const PCRE2_CONFIG_COMPILED_WIDTHS: u32 = 14;
pub const PCRE2_SIZE_MAX: i32 = -1;
pub const PCRE2_CALLOUT_STARTMATCH: u32 = 1;
pub const PCRE2_CALLOUT_BACKTRACK: u32 = 2;
pub const PCRE2_LOCAL_WIDTH: u32 = 8;
pub const _STDIO_H: u32 = 1;
pub const __GNUC_VA_LIST: u32 = 1;
pub const _____fpos_t_defined: u32 = 1;
pub const ____mbstate_t_defined: u32 = 1;
pub const _____fpos64_t_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const __FILE_defined: u32 = 1;
pub const __struct_FILE_defined: u32 = 1;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const EOF: i32 = -1;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const P_tmpdir: &'static [u8; 5usize] = b"/tmp\0";
pub const _BITS_STDIO_LIM_H: u32 = 1;
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const LY_REV_SIZE: u32 = 11;
pub const LYS_UNKNOWN: u32 = 0;
pub const LYS_CONTAINER: u32 = 1;
pub const LYS_CHOICE: u32 = 2;
pub const LYS_LEAF: u32 = 4;
pub const LYS_LEAFLIST: u32 = 8;
pub const LYS_LIST: u32 = 16;
pub const LYS_ANYXML: u32 = 32;
pub const LYS_ANYDATA: u32 = 96;
pub const LYS_CASE: u32 = 128;
pub const LYS_RPC: u32 = 256;
pub const LYS_ACTION: u32 = 512;
pub const LYS_NOTIF: u32 = 1024;
pub const LYS_USES: u32 = 2048;
pub const LYS_INPUT: u32 = 4096;
pub const LYS_OUTPUT: u32 = 8192;
pub const LYS_GROUPING: u32 = 16384;
pub const LYS_AUGMENT: u32 = 32768;
pub const LYS_NODETYPE_MASK: u32 = 65535;
pub const LYS_YIN: u32 = 1;
pub const LYSP_RESTR_PATTERN_ACK: u32 = 6;
pub const LYSP_RESTR_PATTERN_NACK: u32 = 21;
pub const LYS_DEV_NOT_SUPPORTED: u32 = 1;
pub const LYS_DEV_ADD: u32 = 2;
pub const LYS_DEV_DELETE: u32 = 3;
pub const LYS_DEV_REPLACE: u32 = 4;
pub const LYS_CONFIG_W: u32 = 1;
pub const LYS_CONFIG_R: u32 = 2;
pub const LYS_CONFIG_MASK: u32 = 3;
pub const LYS_STATUS_CURR: u32 = 4;
pub const LYS_STATUS_DEPRC: u32 = 8;
pub const LYS_STATUS_OBSLT: u32 = 16;
pub const LYS_STATUS_MASK: u32 = 28;
pub const LYS_MAND_TRUE: u32 = 32;
pub const LYS_MAND_FALSE: u32 = 64;
pub const LYS_MAND_MASK: u32 = 96;
pub const LYS_PRESENCE: u32 = 128;
pub const LYS_UNIQUE: u32 = 128;
pub const LYS_KEY: u32 = 256;
pub const LYS_KEYLESS: u32 = 512;
pub const LYS_FENABLED: u32 = 32;
pub const LYS_ORDBY_SYSTEM: u32 = 128;
pub const LYS_ORDBY_USER: u32 = 64;
pub const LYS_ORDBY_MASK: u32 = 96;
pub const LYS_YINELEM_TRUE: u32 = 128;
pub const LYS_YINELEM_FALSE: u32 = 256;
pub const LYS_YINELEM_MASK: u32 = 384;
pub const LYS_USED_GRP: u32 = 1024;
pub const LYS_SET_VALUE: u32 = 512;
pub const LYS_SET_MIN: u32 = 512;
pub const LYS_SET_MAX: u32 = 1024;
pub const LYS_SET_BASE: u32 = 1;
pub const LYS_SET_BIT: u32 = 2;
pub const LYS_SET_ENUM: u32 = 4;
pub const LYS_SET_FRDIGITS: u32 = 8;
pub const LYS_SET_LENGTH: u32 = 16;
pub const LYS_SET_PATH: u32 = 32;
pub const LYS_SET_PATTERN: u32 = 64;
pub const LYS_SET_RANGE: u32 = 128;
pub const LYS_SET_TYPE: u32 = 256;
pub const LYS_SET_REQINST: u32 = 512;
pub const LYS_SET_DFLT: u32 = 512;
pub const LYS_SET_UNITS: u32 = 1024;
pub const LYS_SET_CONFIG: u32 = 2048;
pub const LYS_SINGLEQUOTED: u32 = 256;
pub const LYS_DOUBLEQUOTED: u32 = 512;
pub const LYS_YIN_ATTR: u32 = 1024;
pub const LYS_YIN_ARGUMENT: u32 = 2048;
pub const LYS_INTERNAL: u32 = 4096;
pub const LYS_IS_ENUM: u32 = 512;
pub const LYS_IS_INPUT: u32 = 4096;
pub const LYS_IS_OUTPUT: u32 = 8192;
pub const LYS_IS_NOTIF: u32 = 16384;
pub const LYS_FLAGS_COMPILED_MASK: u32 = 255;
pub const LYS_IFF_NOT: u32 = 0;
pub const LYS_IFF_AND: u32 = 1;
pub const LYS_IFF_OR: u32 = 2;
pub const LYS_IFF_F: u32 = 3;
pub const LYS_NODE_HASH_COUNT: u32 = 4;
pub const LYS_FIND_XP_SCHEMA: u32 = 8;
pub const LYS_FIND_XP_OUTPUT: u32 = 16;
pub const LYS_GETNEXT_WITHCHOICE: u32 = 1;
pub const LYS_GETNEXT_NOCHOICE: u32 = 2;
pub const LYS_GETNEXT_WITHCASE: u32 = 4;
pub const LYS_GETNEXT_INTONPCONT: u32 = 8;
pub const LYS_GETNEXT_OUTPUT: u32 = 16;
pub const LYD_NODE_INNER: u32 = 1809;
pub const LYD_NODE_TERM: u32 = 12;
pub const LYD_NODE_ANY: u32 = 96;
pub const LYD_DEFAULT: u32 = 1;
pub const LYD_WHEN_TRUE: u32 = 2;
pub const LYD_NEW: u32 = 4;
pub const LYD_HT_MIN_ITEMS: u32 = 4;
pub const LYD_VALHINT_STRING: u32 = 1;
pub const LYD_VALHINT_DECNUM: u32 = 2;
pub const LYD_VALHINT_OCTNUM: u32 = 4;
pub const LYD_VALHINT_HEXNUM: u32 = 8;
pub const LYD_VALHINT_NUM64: u32 = 16;
pub const LYD_VALHINT_BOOLEAN: u32 = 32;
pub const LYD_VALHINT_EMPTY: u32 = 64;
pub const LYD_NODEHINT_LIST: u32 = 128;
pub const LYD_NODEHINT_LEAFLIST: u32 = 256;
pub const LYD_HINT_DATA: u32 = 499;
pub const LYD_HINT_SCHEMA: u32 = 511;
pub const LYD_NEW_PATH_UPDATE: u32 = 1;
pub const LYD_NEW_PATH_OUTPUT: u32 = 2;
pub const LYD_NEW_PATH_OPAQ: u32 = 4;
pub const LYD_NEW_PATH_BIN_VALUE: u32 = 8;
pub const LYD_NEW_PATH_CANON_VALUE: u32 = 16;
pub const LYD_IMPLICIT_NO_STATE: u32 = 1;
pub const LYD_IMPLICIT_NO_CONFIG: u32 = 2;
pub const LYD_IMPLICIT_OUTPUT: u32 = 4;
pub const LYD_IMPLICIT_NO_DEFAULTS: u32 = 8;
pub const LYD_COMPARE_FULL_RECURSION: u32 = 1;
pub const LYD_COMPARE_DEFAULTS: u32 = 2;
pub const LYD_DUP_RECURSIVE: u32 = 1;
pub const LYD_DUP_NO_META: u32 = 2;
pub const LYD_DUP_WITH_PARENTS: u32 = 4;
pub const LYD_DUP_WITH_FLAGS: u32 = 8;
pub const LYD_MERGE_DESTRUCT: u32 = 1;
pub const LYD_MERGE_DEFAULTS: u32 = 2;
pub const LYD_DIFF_DEFAULTS: u32 = 1;
pub const LYD_DIFF_MERGE_DEFAULTS: u32 = 1;
pub const LY_CTX_ALL_IMPLEMENTED: u32 = 1;
pub const LY_CTX_REF_IMPLEMENTED: u32 = 2;
pub const LY_CTX_NO_YANGLIBRARY: u32 = 4;
pub const LY_CTX_DISABLE_SEARCHDIRS: u32 = 8;
pub const LY_CTX_DISABLE_SEARCHDIR_CWD: u32 = 16;
pub const LY_CTX_PREFER_SEARCHDIRS: u32 = 32;
pub const LY_CTX_SET_PRIV_PARSED: u32 = 64;
pub const LY_CTX_EXPLICIT_COMPILE: u32 = 128;
pub const _STRING_H: u32 = 1;
pub const _STRINGS_H: u32 = 1;
pub const _UNISTD_H: u32 = 1;
pub const _POSIX_VERSION: u32 = 200809;
pub const __POSIX2_THIS_VERSION: u32 = 200809;
pub const _POSIX2_VERSION: u32 = 200809;
pub const _POSIX2_C_VERSION: u32 = 200809;
pub const _POSIX2_C_BIND: u32 = 200809;
pub const _POSIX2_C_DEV: u32 = 200809;
pub const _POSIX2_SW_DEV: u32 = 200809;
pub const _POSIX2_LOCALEDEF: u32 = 200809;
pub const _XOPEN_VERSION: u32 = 700;
pub const _XOPEN_XCU_VERSION: u32 = 4;
pub const _XOPEN_XPG2: u32 = 1;
pub const _XOPEN_XPG3: u32 = 1;
pub const _XOPEN_XPG4: u32 = 1;
pub const _XOPEN_UNIX: u32 = 1;
pub const _XOPEN_ENH_I18N: u32 = 1;
pub const _XOPEN_LEGACY: u32 = 1;
pub const _BITS_POSIX_OPT_H: u32 = 1;
pub const _POSIX_JOB_CONTROL: u32 = 1;
pub const _POSIX_SAVED_IDS: u32 = 1;
pub const _POSIX_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_SYNCHRONIZED_IO: u32 = 200809;
pub const _POSIX_FSYNC: u32 = 200809;
pub const _POSIX_MAPPED_FILES: u32 = 200809;
pub const _POSIX_MEMLOCK: u32 = 200809;
pub const _POSIX_MEMLOCK_RANGE: u32 = 200809;
pub const _POSIX_MEMORY_PROTECTION: u32 = 200809;
pub const _POSIX_CHOWN_RESTRICTED: u32 = 0;
pub const _POSIX_VDISABLE: u8 = 0u8;
pub const _POSIX_NO_TRUNC: u32 = 1;
pub const _XOPEN_REALTIME: u32 = 1;
pub const _XOPEN_REALTIME_THREADS: u32 = 1;
pub const _XOPEN_SHM: u32 = 1;
pub const _POSIX_THREADS: u32 = 200809;
pub const _POSIX_REENTRANT_FUNCTIONS: u32 = 1;
pub const _POSIX_THREAD_SAFE_FUNCTIONS: u32 = 200809;
pub const _POSIX_THREAD_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKSIZE: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKADDR: u32 = 200809;
pub const _POSIX_THREAD_PRIO_INHERIT: u32 = 200809;
pub const _POSIX_THREAD_PRIO_PROTECT: u32 = 200809;
pub const _POSIX_THREAD_ROBUST_PRIO_INHERIT: u32 = 200809;
pub const _POSIX_THREAD_ROBUST_PRIO_PROTECT: i32 = -1;
pub const _POSIX_SEMAPHORES: u32 = 200809;
pub const _POSIX_REALTIME_SIGNALS: u32 = 200809;
pub const _POSIX_ASYNCHRONOUS_IO: u32 = 200809;
pub const _POSIX_ASYNC_IO: u32 = 1;
pub const _LFS_ASYNCHRONOUS_IO: u32 = 1;
pub const _POSIX_PRIORITIZED_IO: u32 = 200809;
pub const _LFS64_ASYNCHRONOUS_IO: u32 = 1;
pub const _LFS_LARGEFILE: u32 = 1;
pub const _LFS64_LARGEFILE: u32 = 1;
pub const _LFS64_STDIO: u32 = 1;
pub const _POSIX_SHARED_MEMORY_OBJECTS: u32 = 200809;
pub const _POSIX_CPUTIME: u32 = 0;
pub const _POSIX_THREAD_CPUTIME: u32 = 0;
pub const _POSIX_REGEXP: u32 = 1;
pub const _POSIX_READER_WRITER_LOCKS: u32 = 200809;
pub const _POSIX_SHELL: u32 = 1;
pub const _POSIX_TIMEOUTS: u32 = 200809;
pub const _POSIX_SPIN_LOCKS: u32 = 200809;
pub const _POSIX_SPAWN: u32 = 200809;
pub const _POSIX_TIMERS: u32 = 200809;
pub const _POSIX_BARRIERS: u32 = 200809;
pub const _POSIX_MESSAGE_PASSING: u32 = 200809;
pub const _POSIX_THREAD_PROCESS_SHARED: u32 = 200809;
pub const _POSIX_MONOTONIC_CLOCK: u32 = 0;
pub const _POSIX_CLOCK_SELECTION: u32 = 200809;
pub const _POSIX_ADVISORY_INFO: u32 = 200809;
pub const _POSIX_IPV6: u32 = 200809;
pub const _POSIX_RAW_SOCKETS: u32 = 200809;
pub const _POSIX2_CHAR_TERM: u32 = 200809;
pub const _POSIX_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_THREAD_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_TRACE: i32 = -1;
pub const _POSIX_TRACE_EVENT_FILTER: i32 = -1;
pub const _POSIX_TRACE_INHERIT: i32 = -1;
pub const _POSIX_TRACE_LOG: i32 = -1;
pub const _POSIX_TYPED_MEMORY_OBJECTS: i32 = -1;
pub const _POSIX_V7_LPBIG_OFFBIG: i32 = -1;
pub const _POSIX_V6_LPBIG_OFFBIG: i32 = -1;
pub const _XBS5_LPBIG_OFFBIG: i32 = -1;
pub const _POSIX_V7_LP64_OFF64: u32 = 1;
pub const _POSIX_V6_LP64_OFF64: u32 = 1;
pub const _XBS5_LP64_OFF64: u32 = 1;
pub const __ILP32_OFF32_CFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __ILP32_OFF32_LDFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __ILP32_OFFBIG_CFLAGS: &'static [u8; 48usize] =
    b"-m32 -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64\0";
pub const __ILP32_OFFBIG_LDFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __LP64_OFF64_CFLAGS: &'static [u8; 5usize] = b"-m64\0";
pub const __LP64_OFF64_LDFLAGS: &'static [u8; 5usize] = b"-m64\0";
pub const STDIN_FILENO: u32 = 0;
pub const STDOUT_FILENO: u32 = 1;
pub const STDERR_FILENO: u32 = 2;
pub const R_OK: u32 = 4;
pub const W_OK: u32 = 2;
pub const X_OK: u32 = 1;
pub const F_OK: u32 = 0;
pub const L_SET: u32 = 0;
pub const L_INCR: u32 = 1;
pub const L_XTND: u32 = 2;
pub const _GETOPT_POSIX_H: u32 = 1;
pub const _GETOPT_CORE_H: u32 = 1;
pub const F_ULOCK: u32 = 0;
pub const F_LOCK: u32 = 1;
pub const F_TLOCK: u32 = 2;
pub const F_TEST: u32 = 3;
pub const LY_PRINT_SHRINK: u32 = 2;
pub const LYD_PARSE_ONLY: u32 = 65536;
pub const LYD_PARSE_STRICT: u32 = 131072;
pub const LYD_PARSE_OPAQ: u32 = 262144;
pub const LYD_PARSE_NO_STATE: u32 = 524288;
pub const LYD_PARSE_LYB_MOD_UPDATE: u32 = 1048576;
pub const LYD_PARSE_OPTS_MASK: u32 = 4294901760;
pub const LYD_VALIDATE_NO_STATE: u32 = 1;
pub const LYD_VALIDATE_PRESENT: u32 = 2;
pub const LYD_VALIDATE_OPTS_MASK: u32 = 65535;
pub const LYD_PRINT_WITHSIBLINGS: u32 = 1;
pub const LYD_PRINT_SHRINK: u32 = 2;
pub const LYD_PRINT_KEEPEMPTYCONT: u32 = 4;
pub const LYD_PRINT_WD_MASK: u32 = 240;
pub const LYD_PRINT_WD_EXPLICIT: u32 = 0;
pub const LYD_PRINT_WD_TRIM: u32 = 16;
pub const LYD_PRINT_WD_ALL: u32 = 32;
pub const LYD_PRINT_WD_ALL_TAG: u32 = 64;
pub const LYD_PRINT_WD_IMPL_TAG: u32 = 128;
pub const LYS_PRINT_SHRINK: u32 = 2;
pub const LYS_PRINT_NO_SUBSTMT: u32 = 16;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ly_ctx {
    _unused: [u8; 0],
}
pub type ly_bool = u8;
pub mod LY_LOG_LEVEL {
    pub type Type = ::std::os::raw::c_uint;
    pub const LY_LLERR: Type = 0;
    pub const LY_LLWRN: Type = 1;
    pub const LY_LLVRB: Type = 2;
    pub const LY_LLDBG: Type = 3;
}
extern "C" {
    pub fn ly_log_level(level: LY_LOG_LEVEL::Type) -> LY_LOG_LEVEL::Type;
}
extern "C" {
    pub fn ly_log_options(opts: u32) -> u32;
}
extern "C" {
    pub fn ly_log_dbg_groups(dbg_groups: u32) -> u32;
}
pub type ly_log_clb = ::std::option::Option<
    unsafe extern "C" fn(
        level: LY_LOG_LEVEL::Type,
        msg: *const ::std::os::raw::c_char,
        path: *const ::std::os::raw::c_char,
    ),
>;
extern "C" {
    pub fn ly_set_log_clb(clb: ly_log_clb, path: ly_bool);
}
extern "C" {
    pub fn ly_get_log_clb() -> ly_log_clb;
}
pub mod LY_ERR {
    pub type Type = ::std::os::raw::c_uint;
    pub const LY_SUCCESS: Type = 0;
    pub const LY_EMEM: Type = 1;
    pub const LY_ESYS: Type = 2;
    pub const LY_EINVAL: Type = 3;
    pub const LY_EEXIST: Type = 4;
    pub const LY_ENOTFOUND: Type = 5;
    pub const LY_EINT: Type = 6;
    pub const LY_EVALID: Type = 7;
    pub const LY_EDENIED: Type = 8;
    pub const LY_EINCOMPLETE: Type = 9;
    pub const LY_ERECOMPILE: Type = 10;
    pub const LY_ENOT: Type = 11;
    pub const LY_EOTHER: Type = 12;
    pub const LY_EPLUGIN: Type = 128;
}
pub mod LY_VECODE {
    pub type Type = ::std::os::raw::c_uint;
    pub const LYVE_SUCCESS: Type = 0;
    pub const LYVE_SYNTAX: Type = 1;
    pub const LYVE_SYNTAX_YANG: Type = 2;
    pub const LYVE_SYNTAX_YIN: Type = 3;
    pub const LYVE_REFERENCE: Type = 4;
    pub const LYVE_XPATH: Type = 5;
    pub const LYVE_SEMANTICS: Type = 6;
    pub const LYVE_SYNTAX_XML: Type = 7;
    pub const LYVE_SYNTAX_JSON: Type = 8;
    pub const LYVE_DATA: Type = 9;
    pub const LYVE_OTHER: Type = 10;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ly_err_item {
    pub level: LY_LOG_LEVEL::Type,
    pub no: LY_ERR::Type,
    pub vecode: LY_VECODE::Type,
    pub msg: *mut ::std::os::raw::c_char,
    pub path: *mut ::std::os::raw::c_char,
    pub apptag: *mut ::std::os::raw::c_char,
    pub next: *mut ly_err_item,
    pub prev: *mut ly_err_item,
}
#[test]
fn bindgen_test_layout_ly_err_item() {
    assert_eq!(
        ::std::mem::size_of::<ly_err_item>(),
        56usize,
        concat!("Size of: ", stringify!(ly_err_item))
    );
    assert_eq!(
        ::std::mem::align_of::<ly_err_item>(),
        8usize,
        concat!("Alignment of ", stringify!(ly_err_item))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_err_item>())).level as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_err_item),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_err_item>())).no as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_err_item),
            "::",
            stringify!(no)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_err_item>())).vecode as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_err_item),
            "::",
            stringify!(vecode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_err_item>())).msg as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_err_item),
            "::",
            stringify!(msg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_err_item>())).path as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_err_item),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_err_item>())).apptag as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_err_item),
            "::",
            stringify!(apptag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_err_item>())).next as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_err_item),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_err_item>())).prev as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_err_item),
            "::",
            stringify!(prev)
        )
    );
}
impl Default for ly_err_item {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn ly_vecode(ctx: *const ly_ctx) -> LY_VECODE::Type;
}
extern "C" {
    pub fn ly_errcode(ctx: *const ly_ctx) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_errmsg(ctx: *const ly_ctx) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn ly_errpath(ctx: *const ly_ctx) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn ly_errapptag(ctx: *const ly_ctx) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn ly_err_first(ctx: *const ly_ctx) -> *mut ly_err_item;
}
extern "C" {
    pub fn ly_err_last(ctx: *const ly_ctx) -> *mut ly_err_item;
}
extern "C" {
    pub fn ly_err_print(ctx: *const ly_ctx, eitem: *mut ly_err_item);
}
extern "C" {
    pub fn ly_err_clean(ctx: *mut ly_ctx, eitem: *mut ly_err_item);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ly_in {
    _unused: [u8; 0],
}
pub mod LYS_INFORMAT {
    pub type Type = ::std::os::raw::c_uint;
    pub const LYS_IN_UNKNOWN: Type = 0;
    pub const LYS_IN_YANG: Type = 1;
    pub const LYS_IN_YIN: Type = 3;
}
extern "C" {
    pub fn lys_parse(
        ctx: *mut ly_ctx,
        in_: *mut ly_in,
        format: LYS_INFORMAT::Type,
        features: *mut *const ::std::os::raw::c_char,
        module: *mut *const lys_module,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_parse_mem(
        ctx: *mut ly_ctx,
        data: *const ::std::os::raw::c_char,
        format: LYS_INFORMAT::Type,
        module: *mut *const lys_module,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_parse_fd(
        ctx: *mut ly_ctx,
        fd: ::std::os::raw::c_int,
        format: LYS_INFORMAT::Type,
        module: *mut *const lys_module,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_parse_path(
        ctx: *mut ly_ctx,
        path: *const ::std::os::raw::c_char,
        format: LYS_INFORMAT::Type,
        module: *mut *const lys_module,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_search_localfile(
        searchpaths: *const *const ::std::os::raw::c_char,
        cwd: ly_bool,
        name: *const ::std::os::raw::c_char,
        revision: *const ::std::os::raw::c_char,
        localfile: *mut *mut ::std::os::raw::c_char,
        format: *mut LYS_INFORMAT::Type,
    ) -> LY_ERR::Type;
}
pub type size_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: size_t,
}
#[test]
fn bindgen_test_layout_iovec() {
    assert_eq!(
        ::std::mem::size_of::<iovec>(),
        16usize,
        concat!("Size of: ", stringify!(iovec))
    );
    assert_eq!(
        ::std::mem::align_of::<iovec>(),
        8usize,
        concat!("Alignment of ", stringify!(iovec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iovec>())).iov_base as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iovec),
            "::",
            stringify!(iov_base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iovec>())).iov_len as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iovec),
            "::",
            stringify!(iov_len)
        )
    );
}
impl Default for iovec {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type ssize_t = __ssize_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulong;
pub type register_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fd_set>())).__fds_bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(__fds_bits)
        )
    );
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_rwlock_arch_t() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_rwlock_arch_t>(),
        56usize,
        concat!("Size of: ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_rwlock_arch_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__readers
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__wrphase_futex
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__wrphase_futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers_futex
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers_futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad3
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad4
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__cur_writer
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__cur_writer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__shared
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__rwelision
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__rwelision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad1
                as *const _ as usize
        },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad2
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__flags
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_internal_list>())).__prev
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_internal_list>())).__next
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
impl Default for __pthread_internal_list {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_mutex_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_mutex_s>())).__lock as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_mutex_s>())).__count as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_mutex_s>())).__owner as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_mutex_s>())).__nusers as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_mutex_s>())).__kind as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_mutex_s>())).__spins as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_mutex_s>())).__elision as *const _
                as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_mutex_s>())).__list as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
impl Default for __pthread_mutex_s {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __bindgen_anon_1: __pthread_cond_s__bindgen_ty_1,
    pub __bindgen_anon_2: __pthread_cond_s__bindgen_ty_2,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_1 {
    pub __wseq: ::std::os::raw::c_ulonglong,
    pub __wseq32: __pthread_cond_s__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 > ())) . __low as * const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 > ())) . __high as * const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq32
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq32)
        )
    );
}
impl Default for __pthread_cond_s__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_2 {
    pub __g1_start: ::std::os::raw::c_ulonglong,
    pub __g1_start32: __pthread_cond_s__bindgen_ty_2__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 > ())) . __low as * const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 > ())) . __high as * const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>()))
                .__g1_start as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>()))
                .__g1_start32 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start32)
        )
    );
}
impl Default for __pthread_cond_s__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout___pthread_cond_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s>(),
        48usize,
        concat!("Size of: ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s>())).__g_refs as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_refs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s>())).__g_size as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s>())).__g1_orig_size
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g1_orig_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s>())).__wrefs as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__wrefs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s>())).__g_signals as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_signals)
        )
    );
}
impl Default for __pthread_cond_s {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutexattr_t>())).__size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutexattr_t>())).__align as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_mutexattr_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_condattr_t>())).__size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_condattr_t>())).__align as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_condattr_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 7usize],
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_attr_t>())).__size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_attr_t>())).__align as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_attr_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 5usize],
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_mutex_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
    _bindgen_union_align: [u64; 6usize],
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_cond_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 7usize],
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t>())).__data as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t>())).__size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t>())).__align as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_rwlock_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__align as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_rwlockattr_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 4usize],
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_barrier_t>())).__size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_barrier_t>())).__align as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_barrier_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_barrierattr_t>())).__size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_barrierattr_t>())).__align
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_barrierattr_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type socklen_t = __socklen_t;
pub mod __socket_type {
    pub type Type = ::std::os::raw::c_uint;
    pub const SOCK_STREAM: Type = 1;
    pub const SOCK_DGRAM: Type = 2;
    pub const SOCK_RAW: Type = 3;
    pub const SOCK_RDM: Type = 4;
    pub const SOCK_SEQPACKET: Type = 5;
    pub const SOCK_DCCP: Type = 6;
    pub const SOCK_PACKET: Type = 10;
    pub const SOCK_CLOEXEC: Type = 524288;
    pub const SOCK_NONBLOCK: Type = 2048;
}
pub type sa_family_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockaddr {
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[test]
fn bindgen_test_layout_sockaddr() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr>(),
        16usize,
        concat!("Size of: ", stringify!(sockaddr))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr>(),
        2usize,
        concat!("Alignment of ", stringify!(sockaddr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr>())).sa_family as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr),
            "::",
            stringify!(sa_family)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr>())).sa_data as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr),
            "::",
            stringify!(sa_data)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_family: sa_family_t,
    pub __ss_padding: [::std::os::raw::c_char; 118usize],
    pub __ss_align: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_sockaddr_storage() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr_storage>(),
        128usize,
        concat!("Size of: ", stringify!(sockaddr_storage))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_storage>(),
        8usize,
        concat!("Alignment of ", stringify!(sockaddr_storage))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_storage>())).ss_family as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(ss_family)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_storage>())).__ss_padding
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(__ss_padding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_storage>())).__ss_align as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(__ss_align)
        )
    );
}
impl Default for sockaddr_storage {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub mod _bindgen_ty_1 {
    pub type Type = ::std::os::raw::c_uint;
    pub const MSG_OOB: Type = 1;
    pub const MSG_PEEK: Type = 2;
    pub const MSG_DONTROUTE: Type = 4;
    pub const MSG_CTRUNC: Type = 8;
    pub const MSG_PROXY: Type = 16;
    pub const MSG_TRUNC: Type = 32;
    pub const MSG_DONTWAIT: Type = 64;
    pub const MSG_EOR: Type = 128;
    pub const MSG_WAITALL: Type = 256;
    pub const MSG_FIN: Type = 512;
    pub const MSG_SYN: Type = 1024;
    pub const MSG_CONFIRM: Type = 2048;
    pub const MSG_RST: Type = 4096;
    pub const MSG_ERRQUEUE: Type = 8192;
    pub const MSG_NOSIGNAL: Type = 16384;
    pub const MSG_MORE: Type = 32768;
    pub const MSG_WAITFORONE: Type = 65536;
    pub const MSG_BATCH: Type = 262144;
    pub const MSG_ZEROCOPY: Type = 67108864;
    pub const MSG_FASTOPEN: Type = 536870912;
    pub const MSG_CMSG_CLOEXEC: Type = 1073741824;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: size_t,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: size_t,
    pub msg_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_msghdr() {
    assert_eq!(
        ::std::mem::size_of::<msghdr>(),
        56usize,
        concat!("Size of: ", stringify!(msghdr))
    );
    assert_eq!(
        ::std::mem::align_of::<msghdr>(),
        8usize,
        concat!("Alignment of ", stringify!(msghdr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<msghdr>())).msg_name as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<msghdr>())).msg_namelen as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_namelen)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<msghdr>())).msg_iov as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_iov)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<msghdr>())).msg_iovlen as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_iovlen)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<msghdr>())).msg_control as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_control)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<msghdr>())).msg_controllen as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_controllen)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<msghdr>())).msg_flags as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_flags)
        )
    );
}
impl Default for msghdr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct cmsghdr {
    pub cmsg_len: size_t,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
    pub __cmsg_data: __IncompleteArrayField<::std::os::raw::c_uchar>,
}
#[test]
fn bindgen_test_layout_cmsghdr() {
    assert_eq!(
        ::std::mem::size_of::<cmsghdr>(),
        16usize,
        concat!("Size of: ", stringify!(cmsghdr))
    );
    assert_eq!(
        ::std::mem::align_of::<cmsghdr>(),
        8usize,
        concat!("Alignment of ", stringify!(cmsghdr))
    );
}
extern "C" {
    pub fn __cmsg_nxthdr(
        __mhdr: *mut msghdr,
        __cmsg: *mut cmsghdr,
    ) -> *mut cmsghdr;
}
pub mod _bindgen_ty_2 {
    pub type Type = ::std::os::raw::c_uint;
    pub const SCM_RIGHTS: Type = 1;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_linger() {
    assert_eq!(
        ::std::mem::size_of::<linger>(),
        8usize,
        concat!("Size of: ", stringify!(linger))
    );
    assert_eq!(
        ::std::mem::align_of::<linger>(),
        4usize,
        concat!("Alignment of ", stringify!(linger))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<linger>())).l_onoff as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(linger),
            "::",
            stringify!(l_onoff)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<linger>())).l_linger as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(linger),
            "::",
            stringify!(l_linger)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct osockaddr {
    pub sa_family: ::std::os::raw::c_ushort,
    pub sa_data: [::std::os::raw::c_uchar; 14usize],
}
#[test]
fn bindgen_test_layout_osockaddr() {
    assert_eq!(
        ::std::mem::size_of::<osockaddr>(),
        16usize,
        concat!("Size of: ", stringify!(osockaddr))
    );
    assert_eq!(
        ::std::mem::align_of::<osockaddr>(),
        2usize,
        concat!("Alignment of ", stringify!(osockaddr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<osockaddr>())).sa_family as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(osockaddr),
            "::",
            stringify!(sa_family)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<osockaddr>())).sa_data as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(osockaddr),
            "::",
            stringify!(sa_data)
        )
    );
}
pub mod _bindgen_ty_3 {
    pub type Type = ::std::os::raw::c_uint;
    pub const SHUT_RD: Type = 0;
    pub const SHUT_WR: Type = 1;
    pub const SHUT_RDWR: Type = 2;
}
extern "C" {
    pub fn socket(
        __domain: ::std::os::raw::c_int,
        __type: ::std::os::raw::c_int,
        __protocol: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn socketpair(
        __domain: ::std::os::raw::c_int,
        __type: ::std::os::raw::c_int,
        __protocol: ::std::os::raw::c_int,
        __fds: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bind(
        __fd: ::std::os::raw::c_int,
        __addr: *const sockaddr,
        __len: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsockname(
        __fd: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __len: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn connect(
        __fd: ::std::os::raw::c_int,
        __addr: *const sockaddr,
        __len: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpeername(
        __fd: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __len: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn send(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: size_t,
        __flags: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn recv(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __n: size_t,
        __flags: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn sendto(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: size_t,
        __flags: ::std::os::raw::c_int,
        __addr: *const sockaddr,
        __addr_len: socklen_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn recvfrom(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __n: size_t,
        __flags: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __addr_len: *mut socklen_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn sendmsg(
        __fd: ::std::os::raw::c_int,
        __message: *const msghdr,
        __flags: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn recvmsg(
        __fd: ::std::os::raw::c_int,
        __message: *mut msghdr,
        __flags: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn getsockopt(
        __fd: ::std::os::raw::c_int,
        __level: ::std::os::raw::c_int,
        __optname: ::std::os::raw::c_int,
        __optval: *mut ::std::os::raw::c_void,
        __optlen: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsockopt(
        __fd: ::std::os::raw::c_int,
        __level: ::std::os::raw::c_int,
        __optname: ::std::os::raw::c_int,
        __optval: *const ::std::os::raw::c_void,
        __optlen: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn listen(
        __fd: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn accept(
        __fd: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __addr_len: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn shutdown(
        __fd: ::std::os::raw::c_int,
        __how: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sockatmark(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isfdtype(
        __fd: ::std::os::raw::c_int,
        __fdtype: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type in_addr_t = u32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct in_addr {
    pub s_addr: in_addr_t,
}
#[test]
fn bindgen_test_layout_in_addr() {
    assert_eq!(
        ::std::mem::size_of::<in_addr>(),
        4usize,
        concat!("Size of: ", stringify!(in_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<in_addr>(),
        4usize,
        concat!("Alignment of ", stringify!(in_addr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in_addr>())).s_addr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr),
            "::",
            stringify!(s_addr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ip_opts {
    pub ip_dst: in_addr,
    pub ip_opts: [::std::os::raw::c_char; 40usize],
}
#[test]
fn bindgen_test_layout_ip_opts() {
    assert_eq!(
        ::std::mem::size_of::<ip_opts>(),
        44usize,
        concat!("Size of: ", stringify!(ip_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<ip_opts>(),
        4usize,
        concat!("Alignment of ", stringify!(ip_opts))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_opts>())).ip_dst as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_opts),
            "::",
            stringify!(ip_dst)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_opts>())).ip_opts as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_opts),
            "::",
            stringify!(ip_opts)
        )
    );
}
impl Default for ip_opts {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreqn {
    pub imr_multiaddr: in_addr,
    pub imr_address: in_addr,
    pub imr_ifindex: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_ip_mreqn() {
    assert_eq!(
        ::std::mem::size_of::<ip_mreqn>(),
        12usize,
        concat!("Size of: ", stringify!(ip_mreqn))
    );
    assert_eq!(
        ::std::mem::align_of::<ip_mreqn>(),
        4usize,
        concat!("Alignment of ", stringify!(ip_mreqn))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_mreqn>())).imr_multiaddr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreqn),
            "::",
            stringify!(imr_multiaddr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_mreqn>())).imr_address as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreqn),
            "::",
            stringify!(imr_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_mreqn>())).imr_ifindex as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreqn),
            "::",
            stringify!(imr_ifindex)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct in_pktinfo {
    pub ipi_ifindex: ::std::os::raw::c_int,
    pub ipi_spec_dst: in_addr,
    pub ipi_addr: in_addr,
}
#[test]
fn bindgen_test_layout_in_pktinfo() {
    assert_eq!(
        ::std::mem::size_of::<in_pktinfo>(),
        12usize,
        concat!("Size of: ", stringify!(in_pktinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<in_pktinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(in_pktinfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in_pktinfo>())).ipi_ifindex as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in_pktinfo),
            "::",
            stringify!(ipi_ifindex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in_pktinfo>())).ipi_spec_dst as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(in_pktinfo),
            "::",
            stringify!(ipi_spec_dst)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in_pktinfo>())).ipi_addr as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(in_pktinfo),
            "::",
            stringify!(ipi_addr)
        )
    );
}
pub mod _bindgen_ty_4 {
    pub type Type = ::std::os::raw::c_uint;
    pub const IPPROTO_IP: Type = 0;
    pub const IPPROTO_ICMP: Type = 1;
    pub const IPPROTO_IGMP: Type = 2;
    pub const IPPROTO_IPIP: Type = 4;
    pub const IPPROTO_TCP: Type = 6;
    pub const IPPROTO_EGP: Type = 8;
    pub const IPPROTO_PUP: Type = 12;
    pub const IPPROTO_UDP: Type = 17;
    pub const IPPROTO_IDP: Type = 22;
    pub const IPPROTO_TP: Type = 29;
    pub const IPPROTO_DCCP: Type = 33;
    pub const IPPROTO_IPV6: Type = 41;
    pub const IPPROTO_RSVP: Type = 46;
    pub const IPPROTO_GRE: Type = 47;
    pub const IPPROTO_ESP: Type = 50;
    pub const IPPROTO_AH: Type = 51;
    pub const IPPROTO_MTP: Type = 92;
    pub const IPPROTO_BEETPH: Type = 94;
    pub const IPPROTO_ENCAP: Type = 98;
    pub const IPPROTO_PIM: Type = 103;
    pub const IPPROTO_COMP: Type = 108;
    pub const IPPROTO_SCTP: Type = 132;
    pub const IPPROTO_UDPLITE: Type = 136;
    pub const IPPROTO_MPLS: Type = 137;
    pub const IPPROTO_RAW: Type = 255;
    pub const IPPROTO_MAX: Type = 256;
}
pub mod _bindgen_ty_5 {
    pub type Type = ::std::os::raw::c_uint;
    pub const IPPROTO_HOPOPTS: Type = 0;
    pub const IPPROTO_ROUTING: Type = 43;
    pub const IPPROTO_FRAGMENT: Type = 44;
    pub const IPPROTO_ICMPV6: Type = 58;
    pub const IPPROTO_NONE: Type = 59;
    pub const IPPROTO_DSTOPTS: Type = 60;
    pub const IPPROTO_MH: Type = 135;
}
pub type in_port_t = u16;
pub mod _bindgen_ty_6 {
    pub type Type = ::std::os::raw::c_uint;
    pub const IPPORT_ECHO: Type = 7;
    pub const IPPORT_DISCARD: Type = 9;
    pub const IPPORT_SYSTAT: Type = 11;
    pub const IPPORT_DAYTIME: Type = 13;
    pub const IPPORT_NETSTAT: Type = 15;
    pub const IPPORT_FTP: Type = 21;
    pub const IPPORT_TELNET: Type = 23;
    pub const IPPORT_SMTP: Type = 25;
    pub const IPPORT_TIMESERVER: Type = 37;
    pub const IPPORT_NAMESERVER: Type = 42;
    pub const IPPORT_WHOIS: Type = 43;
    pub const IPPORT_MTP: Type = 57;
    pub const IPPORT_TFTP: Type = 69;
    pub const IPPORT_RJE: Type = 77;
    pub const IPPORT_FINGER: Type = 79;
    pub const IPPORT_TTYLINK: Type = 87;
    pub const IPPORT_SUPDUP: Type = 95;
    pub const IPPORT_EXECSERVER: Type = 512;
    pub const IPPORT_LOGINSERVER: Type = 513;
    pub const IPPORT_CMDSERVER: Type = 514;
    pub const IPPORT_EFSSERVER: Type = 520;
    pub const IPPORT_BIFFUDP: Type = 512;
    pub const IPPORT_WHOSERVER: Type = 513;
    pub const IPPORT_ROUTESERVER: Type = 520;
    pub const IPPORT_RESERVED: Type = 1024;
    pub const IPPORT_USERRESERVED: Type = 5000;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub __in6_u: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub __u6_addr8: [u8; 16usize],
    pub __u6_addr16: [u16; 8usize],
    pub __u6_addr32: [u32; 4usize],
    _bindgen_union_align: [u32; 4usize],
}
#[test]
fn bindgen_test_layout_in6_addr__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<in6_addr__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(in6_addr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<in6_addr__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(in6_addr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in6_addr__bindgen_ty_1>())).__u6_addr8
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_addr__bindgen_ty_1),
            "::",
            stringify!(__u6_addr8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in6_addr__bindgen_ty_1>())).__u6_addr16
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_addr__bindgen_ty_1),
            "::",
            stringify!(__u6_addr16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in6_addr__bindgen_ty_1>())).__u6_addr32
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_addr__bindgen_ty_1),
            "::",
            stringify!(__u6_addr32)
        )
    );
}
impl Default for in6_addr__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_in6_addr() {
    assert_eq!(
        ::std::mem::size_of::<in6_addr>(),
        16usize,
        concat!("Size of: ", stringify!(in6_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<in6_addr>(),
        4usize,
        concat!("Alignment of ", stringify!(in6_addr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in6_addr>())).__in6_u as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_addr),
            "::",
            stringify!(__in6_u)
        )
    );
}
impl Default for in6_addr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub static in6addr_any: in6_addr;
}
extern "C" {
    pub static in6addr_loopback: in6_addr;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [::std::os::raw::c_uchar; 8usize],
}
#[test]
fn bindgen_test_layout_sockaddr_in() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr_in>(),
        16usize,
        concat!("Size of: ", stringify!(sockaddr_in))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_in>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_in))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in>())).sin_family as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_family)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in>())).sin_port as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_port)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in>())).sin_addr as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in>())).sin_zero as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_zero)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_family: sa_family_t,
    pub sin6_port: in_port_t,
    pub sin6_flowinfo: u32,
    pub sin6_addr: in6_addr,
    pub sin6_scope_id: u32,
}
#[test]
fn bindgen_test_layout_sockaddr_in6() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr_in6>(),
        28usize,
        concat!("Size of: ", stringify!(sockaddr_in6))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_in6>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_in6))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in6>())).sin6_family as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_family)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in6>())).sin6_port as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_port)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in6>())).sin6_flowinfo as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_flowinfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in6>())).sin6_addr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in6>())).sin6_scope_id as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_scope_id)
        )
    );
}
impl Default for sockaddr_in6 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreq {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
}
#[test]
fn bindgen_test_layout_ip_mreq() {
    assert_eq!(
        ::std::mem::size_of::<ip_mreq>(),
        8usize,
        concat!("Size of: ", stringify!(ip_mreq))
    );
    assert_eq!(
        ::std::mem::align_of::<ip_mreq>(),
        4usize,
        concat!("Alignment of ", stringify!(ip_mreq))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_mreq>())).imr_multiaddr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreq),
            "::",
            stringify!(imr_multiaddr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_mreq>())).imr_interface as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreq),
            "::",
            stringify!(imr_interface)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreq_source {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
    pub imr_sourceaddr: in_addr,
}
#[test]
fn bindgen_test_layout_ip_mreq_source() {
    assert_eq!(
        ::std::mem::size_of::<ip_mreq_source>(),
        12usize,
        concat!("Size of: ", stringify!(ip_mreq_source))
    );
    assert_eq!(
        ::std::mem::align_of::<ip_mreq_source>(),
        4usize,
        concat!("Alignment of ", stringify!(ip_mreq_source))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_mreq_source>())).imr_multiaddr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreq_source),
            "::",
            stringify!(imr_multiaddr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_mreq_source>())).imr_interface as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreq_source),
            "::",
            stringify!(imr_interface)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_mreq_source>())).imr_sourceaddr
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreq_source),
            "::",
            stringify!(imr_sourceaddr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ipv6_mreq {
    pub ipv6mr_multiaddr: in6_addr,
    pub ipv6mr_interface: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_ipv6_mreq() {
    assert_eq!(
        ::std::mem::size_of::<ipv6_mreq>(),
        20usize,
        concat!("Size of: ", stringify!(ipv6_mreq))
    );
    assert_eq!(
        ::std::mem::align_of::<ipv6_mreq>(),
        4usize,
        concat!("Alignment of ", stringify!(ipv6_mreq))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ipv6_mreq>())).ipv6mr_multiaddr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ipv6_mreq),
            "::",
            stringify!(ipv6mr_multiaddr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ipv6_mreq>())).ipv6mr_interface as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ipv6_mreq),
            "::",
            stringify!(ipv6mr_interface)
        )
    );
}
impl Default for ipv6_mreq {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct group_req {
    pub gr_interface: u32,
    pub gr_group: sockaddr_storage,
}
#[test]
fn bindgen_test_layout_group_req() {
    assert_eq!(
        ::std::mem::size_of::<group_req>(),
        136usize,
        concat!("Size of: ", stringify!(group_req))
    );
    assert_eq!(
        ::std::mem::align_of::<group_req>(),
        8usize,
        concat!("Alignment of ", stringify!(group_req))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<group_req>())).gr_interface as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(group_req),
            "::",
            stringify!(gr_interface)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<group_req>())).gr_group as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(group_req),
            "::",
            stringify!(gr_group)
        )
    );
}
impl Default for group_req {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct group_source_req {
    pub gsr_interface: u32,
    pub gsr_group: sockaddr_storage,
    pub gsr_source: sockaddr_storage,
}
#[test]
fn bindgen_test_layout_group_source_req() {
    assert_eq!(
        ::std::mem::size_of::<group_source_req>(),
        264usize,
        concat!("Size of: ", stringify!(group_source_req))
    );
    assert_eq!(
        ::std::mem::align_of::<group_source_req>(),
        8usize,
        concat!("Alignment of ", stringify!(group_source_req))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<group_source_req>())).gsr_interface
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(group_source_req),
            "::",
            stringify!(gsr_interface)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<group_source_req>())).gsr_group as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(group_source_req),
            "::",
            stringify!(gsr_group)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<group_source_req>())).gsr_source as *const _
                as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(group_source_req),
            "::",
            stringify!(gsr_source)
        )
    );
}
impl Default for group_source_req {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_msfilter {
    pub imsf_multiaddr: in_addr,
    pub imsf_interface: in_addr,
    pub imsf_fmode: u32,
    pub imsf_numsrc: u32,
    pub imsf_slist: [in_addr; 1usize],
}
#[test]
fn bindgen_test_layout_ip_msfilter() {
    assert_eq!(
        ::std::mem::size_of::<ip_msfilter>(),
        20usize,
        concat!("Size of: ", stringify!(ip_msfilter))
    );
    assert_eq!(
        ::std::mem::align_of::<ip_msfilter>(),
        4usize,
        concat!("Alignment of ", stringify!(ip_msfilter))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_msfilter>())).imsf_multiaddr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_msfilter),
            "::",
            stringify!(imsf_multiaddr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_msfilter>())).imsf_interface as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_msfilter),
            "::",
            stringify!(imsf_interface)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_msfilter>())).imsf_fmode as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_msfilter),
            "::",
            stringify!(imsf_fmode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_msfilter>())).imsf_numsrc as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_msfilter),
            "::",
            stringify!(imsf_numsrc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ip_msfilter>())).imsf_slist as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_msfilter),
            "::",
            stringify!(imsf_slist)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct group_filter {
    pub gf_interface: u32,
    pub gf_group: sockaddr_storage,
    pub gf_fmode: u32,
    pub gf_numsrc: u32,
    pub gf_slist: [sockaddr_storage; 1usize],
}
#[test]
fn bindgen_test_layout_group_filter() {
    assert_eq!(
        ::std::mem::size_of::<group_filter>(),
        272usize,
        concat!("Size of: ", stringify!(group_filter))
    );
    assert_eq!(
        ::std::mem::align_of::<group_filter>(),
        8usize,
        concat!("Alignment of ", stringify!(group_filter))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<group_filter>())).gf_interface as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(group_filter),
            "::",
            stringify!(gf_interface)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<group_filter>())).gf_group as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(group_filter),
            "::",
            stringify!(gf_group)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<group_filter>())).gf_fmode as *const _
                as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(group_filter),
            "::",
            stringify!(gf_fmode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<group_filter>())).gf_numsrc as *const _
                as usize
        },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(group_filter),
            "::",
            stringify!(gf_numsrc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<group_filter>())).gf_slist as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(group_filter),
            "::",
            stringify!(gf_slist)
        )
    );
}
impl Default for group_filter {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn ntohl(__netlong: u32) -> u32;
}
extern "C" {
    pub fn ntohs(__netshort: u16) -> u16;
}
extern "C" {
    pub fn htonl(__hostlong: u32) -> u32;
}
extern "C" {
    pub fn htons(__hostshort: u16) -> u16;
}
extern "C" {
    pub fn bindresvport(
        __sockfd: ::std::os::raw::c_int,
        __sock_in: *mut sockaddr_in,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bindresvport6(
        __sockfd: ::std::os::raw::c_int,
        __sock_in: *mut sockaddr_in6,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet_addr(__cp: *const ::std::os::raw::c_char) -> in_addr_t;
}
extern "C" {
    pub fn inet_lnaof(__in: in_addr) -> in_addr_t;
}
extern "C" {
    pub fn inet_makeaddr(__net: in_addr_t, __host: in_addr_t) -> in_addr;
}
extern "C" {
    pub fn inet_netof(__in: in_addr) -> in_addr_t;
}
extern "C" {
    pub fn inet_network(__cp: *const ::std::os::raw::c_char) -> in_addr_t;
}
extern "C" {
    pub fn inet_ntoa(__in: in_addr) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn inet_pton(
        __af: ::std::os::raw::c_int,
        __cp: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet_ntop(
        __af: ::std::os::raw::c_int,
        __cp: *const ::std::os::raw::c_void,
        __buf: *mut ::std::os::raw::c_char,
        __len: socklen_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn inet_aton(
        __cp: *const ::std::os::raw::c_char,
        __inp: *mut in_addr,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet_neta(
        __net: in_addr_t,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn inet_net_ntop(
        __af: ::std::os::raw::c_int,
        __cp: *const ::std::os::raw::c_void,
        __bits: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn inet_net_pton(
        __af: ::std::os::raw::c_int,
        __cp: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_void,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet_nsap_addr(
        __cp: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_uchar,
        __len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn inet_nsap_ntoa(
        __len: ::std::os::raw::c_int,
        __cp: *const ::std::os::raw::c_uchar,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[test]
fn bindgen_test_layout_max_align_t() {
    assert_eq!(
        ::std::mem::size_of::<max_align_t>(),
        32usize,
        concat!("Size of: ", stringify!(max_align_t))
    );
    assert_eq!(
        ::std::mem::align_of::<max_align_t>(),
        16usize,
        concat!("Alignment of ", stringify!(max_align_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce1
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce2
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_tm() {
    assert_eq!(
        ::std::mem::size_of::<tm>(),
        56usize,
        concat!("Size of: ", stringify!(tm))
    );
    assert_eq!(
        ::std::mem::align_of::<tm>(),
        8usize,
        concat!("Alignment of ", stringify!(tm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_min as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_hour as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_hour)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mday as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mon as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_year as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_year)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_wday as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_wday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_yday as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_yday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_isdst as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_isdst)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<tm>())).tm_gmtoff as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_gmtoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_zone as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_zone)
        )
    );
}
impl Default for tm {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct itimerspec {
    pub it_interval: timespec,
    pub it_value: timespec,
}
#[test]
fn bindgen_test_layout_itimerspec() {
    assert_eq!(
        ::std::mem::size_of::<itimerspec>(),
        32usize,
        concat!("Size of: ", stringify!(itimerspec))
    );
    assert_eq!(
        ::std::mem::align_of::<itimerspec>(),
        8usize,
        concat!("Alignment of ", stringify!(itimerspec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<itimerspec>())).it_interval as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerspec),
            "::",
            stringify!(it_interval)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<itimerspec>())).it_value as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerspec),
            "::",
            stringify!(it_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigevent {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_struct {
    pub __locales: [*mut __locale_data; 13usize],
    pub __ctype_b: *const ::std::os::raw::c_ushort,
    pub __ctype_tolower: *const ::std::os::raw::c_int,
    pub __ctype_toupper: *const ::std::os::raw::c_int,
    pub __names: [*const ::std::os::raw::c_char; 13usize],
}
#[test]
fn bindgen_test_layout___locale_struct() {
    assert_eq!(
        ::std::mem::size_of::<__locale_struct>(),
        232usize,
        concat!("Size of: ", stringify!(__locale_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<__locale_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(__locale_struct))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__locale_struct>())).__locales as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__locales)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__locale_struct>())).__ctype_b as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_b)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__locale_struct>())).__ctype_tolower
                as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_tolower)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__locale_struct>())).__ctype_toupper
                as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_toupper)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__locale_struct>())).__names as *const _
                as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__names)
        )
    );
}
impl Default for __locale_struct {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __locale_t = *mut __locale_struct;
pub type locale_t = __locale_t;
extern "C" {
    pub fn clock() -> clock_t;
}
extern "C" {
    pub fn time(__timer: *mut time_t) -> time_t;
}
extern "C" {
    pub fn difftime(__time1: time_t, __time0: time_t) -> f64;
}
extern "C" {
    pub fn mktime(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn strftime(
        __s: *mut ::std::os::raw::c_char,
        __maxsize: size_t,
        __format: *const ::std::os::raw::c_char,
        __tp: *const tm,
    ) -> size_t;
}
extern "C" {
    pub fn strftime_l(
        __s: *mut ::std::os::raw::c_char,
        __maxsize: size_t,
        __format: *const ::std::os::raw::c_char,
        __tp: *const tm,
        __loc: locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn gmtime(__timer: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn localtime(__timer: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn gmtime_r(__timer: *const time_t, __tp: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn localtime_r(__timer: *const time_t, __tp: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn asctime(__tp: *const tm) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime(__timer: *const time_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn asctime_r(
        __tp: *const tm,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime_r(
        __timer: *const time_t,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut __tzname: [*mut ::std::os::raw::c_char; 2usize];
}
extern "C" {
    pub static mut __daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut __timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 2usize];
}
extern "C" {
    pub fn tzset();
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub fn stime(__when: *const time_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timegm(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn timelocal(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn dysize(__year: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nanosleep(
        __requested_time: *const timespec,
        __remaining: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getres(
        __clock_id: clockid_t,
        __res: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime(
        __clock_id: clockid_t,
        __tp: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_settime(
        __clock_id: clockid_t,
        __tp: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_nanosleep(
        __clock_id: clockid_t,
        __flags: ::std::os::raw::c_int,
        __req: *const timespec,
        __rem: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getcpuclockid(
        __pid: pid_t,
        __clock_id: *mut clockid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_create(
        __clock_id: clockid_t,
        __evp: *mut sigevent,
        __timerid: *mut timer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_delete(__timerid: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_settime(
        __timerid: timer_t,
        __flags: ::std::os::raw::c_int,
        __value: *const itimerspec,
        __ovalue: *mut itimerspec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_gettime(
        __timerid: timer_t,
        __value: *mut itimerspec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_getoverrun(__timerid: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timespec_get(
        __ts: *mut timespec,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type __gwchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct imaxdiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_imaxdiv_t() {
    assert_eq!(
        ::std::mem::size_of::<imaxdiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<imaxdiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<imaxdiv_t>())).quot as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<imaxdiv_t>())).rem as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn imaxabs(__n: intmax_t) -> intmax_t;
}
extern "C" {
    pub fn imaxdiv(__numer: intmax_t, __denom: intmax_t) -> imaxdiv_t;
}
extern "C" {
    pub fn strtoimax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn strtoumax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
extern "C" {
    pub fn wcstoimax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn wcstoumax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
pub mod LY_DATA_TYPE {
    pub type Type = ::std::os::raw::c_uint;
    pub const LY_TYPE_UNKNOWN: Type = 0;
    pub const LY_TYPE_BINARY: Type = 1;
    pub const LY_TYPE_UINT8: Type = 2;
    pub const LY_TYPE_UINT16: Type = 3;
    pub const LY_TYPE_UINT32: Type = 4;
    pub const LY_TYPE_UINT64: Type = 5;
    pub const LY_TYPE_STRING: Type = 6;
    pub const LY_TYPE_BITS: Type = 7;
    pub const LY_TYPE_BOOL: Type = 8;
    pub const LY_TYPE_DEC64: Type = 9;
    pub const LY_TYPE_EMPTY: Type = 10;
    pub const LY_TYPE_ENUM: Type = 11;
    pub const LY_TYPE_IDENT: Type = 12;
    pub const LY_TYPE_INST: Type = 13;
    pub const LY_TYPE_LEAFREF: Type = 14;
    pub const LY_TYPE_UNION: Type = 15;
    pub const LY_TYPE_INT8: Type = 16;
    pub const LY_TYPE_INT16: Type = 17;
    pub const LY_TYPE_INT32: Type = 18;
    pub const LY_TYPE_INT64: Type = 19;
}
extern "C" {
    pub static mut ly_data_type2str: [*const ::std::os::raw::c_char; 20usize];
}
pub mod LY_VALUE_FORMAT {
    pub type Type = ::std::os::raw::c_uint;
    pub const LY_VALUE_CANON: Type = 0;
    pub const LY_VALUE_SCHEMA: Type = 1;
    pub const LY_VALUE_SCHEMA_RESOLVED: Type = 2;
    pub const LY_VALUE_XML: Type = 3;
    pub const LY_VALUE_JSON: Type = 4;
    pub const LY_VALUE_LYB: Type = 5;
}
pub mod idtype_t {
    pub type Type = ::std::os::raw::c_uint;
    pub const P_ALL: Type = 0;
    pub const P_PID: Type = 1;
    pub const P_PGID: Type = 2;
}
pub type _Float32 = f32;
pub type _Float64 = f64;
pub type _Float32x = f64;
pub type _Float64x = u128;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn __ctype_get_mb_cur_max() -> size_t;
}
extern "C" {
    pub fn atof(__nptr: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(__nptr: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(
        __nptr: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(
        __nptr: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtod(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtold(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtol(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoul(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn strtoll(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoull(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn l64a(__n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn a64l(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srandom(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn initstate(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setstate(
        __statebuf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
#[test]
fn bindgen_test_layout_random_data() {
    assert_eq!(
        ::std::mem::size_of::<random_data>(),
        48usize,
        concat!("Size of: ", stringify!(random_data))
    );
    assert_eq!(
        ::std::mem::align_of::<random_data>(),
        8usize,
        concat!("Alignment of ", stringify!(random_data))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<random_data>())).fptr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(fptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<random_data>())).rptr as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<random_data>())).state as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<random_data>())).rand_type as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<random_data>())).rand_deg as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_deg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<random_data>())).rand_sep as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_sep)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<random_data>())).end_ptr as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(end_ptr)
        )
    );
}
impl Default for random_data {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn random_r(
        __buf: *mut random_data,
        __result: *mut i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srandom_r(
        __seed: ::std::os::raw::c_uint,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate_r(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setstate_r(
        __statebuf: *mut ::std::os::raw::c_char,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn rand_r(__seed: *mut ::std::os::raw::c_uint)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn erand48(__xsubi: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(
        __xsubi: *mut ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jrand48(
        __xsubi: *mut ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srand48(__seedval: ::std::os::raw::c_long);
}
extern "C" {
    pub fn seed48(
        __seed16v: *mut ::std::os::raw::c_ushort,
    ) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn lcong48(__param: *mut ::std::os::raw::c_ushort);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
#[test]
fn bindgen_test_layout_drand48_data() {
    assert_eq!(
        ::std::mem::size_of::<drand48_data>(),
        24usize,
        concat!("Size of: ", stringify!(drand48_data))
    );
    assert_eq!(
        ::std::mem::align_of::<drand48_data>(),
        8usize,
        concat!("Alignment of ", stringify!(drand48_data))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<drand48_data>())).__x as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__x)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<drand48_data>())).__old_x as *const _
                as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__old_x)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<drand48_data>())).__c as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__c)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<drand48_data>())).__init as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__init)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<drand48_data>())).__a as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__a)
        )
    );
}
extern "C" {
    pub fn drand48_r(
        __buffer: *mut drand48_data,
        __result: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn erand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand48_r(
        __seedval: ::std::os::raw::c_long,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seed48_r(
        __seed16v: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lcong48_r(
        __param: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __nmemb: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn alloca(
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(__size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn aligned_alloc(
        __alignment: size_t,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn atexit(
        __func: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn at_quick_exit(
        __func: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn on_exit(
        __func: ::std::option::Option<
            unsafe extern "C" fn(
                __status: ::std::os::raw::c_int,
                __arg: *mut ::std::os::raw::c_void,
            ),
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn quick_exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _Exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(
        __name: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn putenv(
        __string: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __replace: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(
        __name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mktemp(
        __template: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(
        __template: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        __template: *mut ::std::os::raw::c_char,
        __suffixlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(
        __template: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn system(
        __command: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn realpath(
        __name: *const ::std::os::raw::c_char,
        __resolved: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    );
}
extern "C" {
    pub fn abs(__x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(__x: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llabs(__x: ::std::os::raw::c_longlong)
        -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn div(
        __numer: ::std::os::raw::c_int,
        __denom: ::std::os::raw::c_int,
    ) -> div_t;
}
extern "C" {
    pub fn ldiv(
        __numer: ::std::os::raw::c_long,
        __denom: ::std::os::raw::c_long,
    ) -> ldiv_t;
}
extern "C" {
    pub fn lldiv(
        __numer: ::std::os::raw::c_longlong,
        __denom: ::std::os::raw::c_longlong,
    ) -> lldiv_t;
}
extern "C" {
    pub fn ecvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qecvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qfcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qgcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ecvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fcvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qecvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qfcvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mblen(
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbtowc(
        __pwc: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wctomb(
        __s: *mut ::std::os::raw::c_char,
        __wchar: wchar_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        __pwcs: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcstombs(
        __s: *mut ::std::os::raw::c_char,
        __pwcs: *const wchar_t,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn rpmatch(
        __response: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsubopt(
        __optionp: *mut *mut ::std::os::raw::c_char,
        __tokens: *const *mut ::std::os::raw::c_char,
        __valuep: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getloadavg(
        __loadavg: *mut f64,
        __nelem: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type PCRE2_UCHAR8 = u8;
pub type PCRE2_UCHAR16 = u16;
pub type PCRE2_UCHAR32 = u32;
pub type PCRE2_SPTR8 = *const PCRE2_UCHAR8;
pub type PCRE2_SPTR16 = *const PCRE2_UCHAR16;
pub type PCRE2_SPTR32 = *const PCRE2_UCHAR32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_general_context_8 {
    _unused: [u8; 0],
}
pub type pcre2_general_context_8 = pcre2_real_general_context_8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_compile_context_8 {
    _unused: [u8; 0],
}
pub type pcre2_compile_context_8 = pcre2_real_compile_context_8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_match_context_8 {
    _unused: [u8; 0],
}
pub type pcre2_match_context_8 = pcre2_real_match_context_8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_convert_context_8 {
    _unused: [u8; 0],
}
pub type pcre2_convert_context_8 = pcre2_real_convert_context_8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_code_8 {
    _unused: [u8; 0],
}
pub type pcre2_code_8 = pcre2_real_code_8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_match_data_8 {
    _unused: [u8; 0],
}
pub type pcre2_match_data_8 = pcre2_real_match_data_8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_jit_stack_8 {
    _unused: [u8; 0],
}
pub type pcre2_jit_stack_8 = pcre2_real_jit_stack_8;
pub type pcre2_jit_callback_8 = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
    ) -> *mut pcre2_jit_stack_8,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_callout_block_8 {
    pub version: u32,
    pub callout_number: u32,
    pub capture_top: u32,
    pub capture_last: u32,
    pub offset_vector: *mut size_t,
    pub mark: PCRE2_SPTR8,
    pub subject: PCRE2_SPTR8,
    pub subject_length: size_t,
    pub start_match: size_t,
    pub current_position: size_t,
    pub pattern_position: size_t,
    pub next_item_length: size_t,
    pub callout_string_offset: size_t,
    pub callout_string_length: size_t,
    pub callout_string: PCRE2_SPTR8,
    pub callout_flags: u32,
}
#[test]
fn bindgen_test_layout_pcre2_callout_block_8() {
    assert_eq!(
        ::std::mem::size_of::<pcre2_callout_block_8>(),
        112usize,
        concat!("Size of: ", stringify!(pcre2_callout_block_8))
    );
    assert_eq!(
        ::std::mem::align_of::<pcre2_callout_block_8>(),
        8usize,
        concat!("Alignment of ", stringify!(pcre2_callout_block_8))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).version
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).callout_number
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(callout_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).capture_top
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(capture_top)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).capture_last
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(capture_last)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).offset_vector
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(offset_vector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).mark as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(mark)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).subject
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(subject)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).subject_length
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(subject_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).start_match
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(start_match)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).current_position
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(current_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).pattern_position
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(pattern_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).next_item_length
                as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(next_item_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>()))
                .callout_string_offset as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(callout_string_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>()))
                .callout_string_length as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(callout_string_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).callout_string
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(callout_string)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_8>())).callout_flags
                as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_8),
            "::",
            stringify!(callout_flags)
        )
    );
}
impl Default for pcre2_callout_block_8 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_callout_enumerate_block_8 {
    pub version: u32,
    pub pattern_position: size_t,
    pub next_item_length: size_t,
    pub callout_number: u32,
    pub callout_string_offset: size_t,
    pub callout_string_length: size_t,
    pub callout_string: PCRE2_SPTR8,
}
#[test]
fn bindgen_test_layout_pcre2_callout_enumerate_block_8() {
    assert_eq!(
        ::std::mem::size_of::<pcre2_callout_enumerate_block_8>(),
        56usize,
        concat!("Size of: ", stringify!(pcre2_callout_enumerate_block_8))
    );
    assert_eq!(
        ::std::mem::align_of::<pcre2_callout_enumerate_block_8>(),
        8usize,
        concat!("Alignment of ", stringify!(pcre2_callout_enumerate_block_8))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_8>())).version
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_8),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_8>()))
                .pattern_position as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_8),
            "::",
            stringify!(pattern_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_8>()))
                .next_item_length as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_8),
            "::",
            stringify!(next_item_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_8>()))
                .callout_number as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_8),
            "::",
            stringify!(callout_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_8>()))
                .callout_string_offset as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_8),
            "::",
            stringify!(callout_string_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_8>()))
                .callout_string_length as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_8),
            "::",
            stringify!(callout_string_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_8>()))
                .callout_string as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_8),
            "::",
            stringify!(callout_string)
        )
    );
}
impl Default for pcre2_callout_enumerate_block_8 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn pcre2_config_8(
        arg1: u32,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_general_context_copy_8(
        arg1: *mut pcre2_general_context_8,
    ) -> *mut pcre2_general_context_8;
}
extern "C" {
    pub fn pcre2_general_context_create_8(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: size_t,
                arg2: *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void,
        >,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_void,
            ),
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut pcre2_general_context_8;
}
extern "C" {
    pub fn pcre2_general_context_free_8(arg1: *mut pcre2_general_context_8);
}
extern "C" {
    pub fn pcre2_compile_context_copy_8(
        arg1: *mut pcre2_compile_context_8,
    ) -> *mut pcre2_compile_context_8;
}
extern "C" {
    pub fn pcre2_compile_context_create_8(
        arg1: *mut pcre2_general_context_8,
    ) -> *mut pcre2_compile_context_8;
}
extern "C" {
    pub fn pcre2_compile_context_free_8(arg1: *mut pcre2_compile_context_8);
}
extern "C" {
    pub fn pcre2_set_bsr_8(
        arg1: *mut pcre2_compile_context_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_character_tables_8(
        arg1: *mut pcre2_compile_context_8,
        arg2: *const ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_compile_extra_options_8(
        arg1: *mut pcre2_compile_context_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_max_pattern_length_8(
        arg1: *mut pcre2_compile_context_8,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_newline_8(
        arg1: *mut pcre2_compile_context_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_parens_nest_limit_8(
        arg1: *mut pcre2_compile_context_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_compile_recursion_guard_8(
        arg1: *mut pcre2_compile_context_8,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: u32,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_convert_context_copy_8(
        arg1: *mut pcre2_convert_context_8,
    ) -> *mut pcre2_convert_context_8;
}
extern "C" {
    pub fn pcre2_convert_context_create_8(
        arg1: *mut pcre2_general_context_8,
    ) -> *mut pcre2_convert_context_8;
}
extern "C" {
    pub fn pcre2_convert_context_free_8(arg1: *mut pcre2_convert_context_8);
}
extern "C" {
    pub fn pcre2_set_glob_escape_8(
        arg1: *mut pcre2_convert_context_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_glob_separator_8(
        arg1: *mut pcre2_convert_context_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_pattern_convert_8(
        arg1: PCRE2_SPTR8,
        arg2: size_t,
        arg3: u32,
        arg4: *mut *mut PCRE2_UCHAR8,
        arg5: *mut size_t,
        arg6: *mut pcre2_convert_context_8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_converted_pattern_free_8(arg1: *mut PCRE2_UCHAR8);
}
extern "C" {
    pub fn pcre2_match_context_copy_8(
        arg1: *mut pcre2_match_context_8,
    ) -> *mut pcre2_match_context_8;
}
extern "C" {
    pub fn pcre2_match_context_create_8(
        arg1: *mut pcre2_general_context_8,
    ) -> *mut pcre2_match_context_8;
}
extern "C" {
    pub fn pcre2_match_context_free_8(arg1: *mut pcre2_match_context_8);
}
extern "C" {
    pub fn pcre2_set_callout_8(
        arg1: *mut pcre2_match_context_8,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut pcre2_callout_block_8,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_depth_limit_8(
        arg1: *mut pcre2_match_context_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_heap_limit_8(
        arg1: *mut pcre2_match_context_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_match_limit_8(
        arg1: *mut pcre2_match_context_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_offset_limit_8(
        arg1: *mut pcre2_match_context_8,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_recursion_limit_8(
        arg1: *mut pcre2_match_context_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_recursion_memory_management_8(
        arg1: *mut pcre2_match_context_8,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: size_t,
                arg2: *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void,
        >,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_void,
            ),
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_compile_8(
        arg1: PCRE2_SPTR8,
        arg2: size_t,
        arg3: u32,
        arg4: *mut ::std::os::raw::c_int,
        arg5: *mut size_t,
        arg6: *mut pcre2_compile_context_8,
    ) -> *mut pcre2_code_8;
}
extern "C" {
    pub fn pcre2_code_free_8(arg1: *mut pcre2_code_8);
}
extern "C" {
    pub fn pcre2_code_copy_8(arg1: *const pcre2_code_8) -> *mut pcre2_code_8;
}
extern "C" {
    pub fn pcre2_code_copy_with_tables_8(
        arg1: *const pcre2_code_8,
    ) -> *mut pcre2_code_8;
}
extern "C" {
    pub fn pcre2_pattern_info_8(
        arg1: *const pcre2_code_8,
        arg2: u32,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_callout_enumerate_8(
        arg1: *const pcre2_code_8,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut pcre2_callout_enumerate_block_8,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_match_data_create_8(
        arg1: u32,
        arg2: *mut pcre2_general_context_8,
    ) -> *mut pcre2_match_data_8;
}
extern "C" {
    pub fn pcre2_match_data_create_from_pattern_8(
        arg1: *const pcre2_code_8,
        arg2: *mut pcre2_general_context_8,
    ) -> *mut pcre2_match_data_8;
}
extern "C" {
    pub fn pcre2_dfa_match_8(
        arg1: *const pcre2_code_8,
        arg2: PCRE2_SPTR8,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_8,
        arg7: *mut pcre2_match_context_8,
        arg8: *mut ::std::os::raw::c_int,
        arg9: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_match_8(
        arg1: *const pcre2_code_8,
        arg2: PCRE2_SPTR8,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_8,
        arg7: *mut pcre2_match_context_8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_match_data_free_8(arg1: *mut pcre2_match_data_8);
}
extern "C" {
    pub fn pcre2_get_mark_8(arg1: *mut pcre2_match_data_8) -> PCRE2_SPTR8;
}
extern "C" {
    pub fn pcre2_get_ovector_count_8(arg1: *mut pcre2_match_data_8) -> u32;
}
extern "C" {
    pub fn pcre2_get_ovector_pointer_8(
        arg1: *mut pcre2_match_data_8,
    ) -> *mut size_t;
}
extern "C" {
    pub fn pcre2_get_startchar_8(arg1: *mut pcre2_match_data_8) -> size_t;
}
extern "C" {
    pub fn pcre2_substring_copy_byname_8(
        arg1: *mut pcre2_match_data_8,
        arg2: PCRE2_SPTR8,
        arg3: *mut PCRE2_UCHAR8,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_copy_bynumber_8(
        arg1: *mut pcre2_match_data_8,
        arg2: u32,
        arg3: *mut PCRE2_UCHAR8,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_free_8(arg1: *mut PCRE2_UCHAR8);
}
extern "C" {
    pub fn pcre2_substring_get_byname_8(
        arg1: *mut pcre2_match_data_8,
        arg2: PCRE2_SPTR8,
        arg3: *mut *mut PCRE2_UCHAR8,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_get_bynumber_8(
        arg1: *mut pcre2_match_data_8,
        arg2: u32,
        arg3: *mut *mut PCRE2_UCHAR8,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_length_byname_8(
        arg1: *mut pcre2_match_data_8,
        arg2: PCRE2_SPTR8,
        arg3: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_length_bynumber_8(
        arg1: *mut pcre2_match_data_8,
        arg2: u32,
        arg3: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_nametable_scan_8(
        arg1: *const pcre2_code_8,
        arg2: PCRE2_SPTR8,
        arg3: *mut PCRE2_SPTR8,
        arg4: *mut PCRE2_SPTR8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_number_from_name_8(
        arg1: *const pcre2_code_8,
        arg2: PCRE2_SPTR8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_list_free_8(arg1: *mut PCRE2_SPTR8);
}
extern "C" {
    pub fn pcre2_substring_list_get_8(
        arg1: *mut pcre2_match_data_8,
        arg2: *mut *mut *mut PCRE2_UCHAR8,
        arg3: *mut *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_serialize_encode_8(
        arg1: *mut *const pcre2_code_8,
        arg2: i32,
        arg3: *mut *mut u8,
        arg4: *mut size_t,
        arg5: *mut pcre2_general_context_8,
    ) -> i32;
}
extern "C" {
    pub fn pcre2_serialize_decode_8(
        arg1: *mut *mut pcre2_code_8,
        arg2: i32,
        arg3: *const u8,
        arg4: *mut pcre2_general_context_8,
    ) -> i32;
}
extern "C" {
    pub fn pcre2_serialize_get_number_of_codes_8(arg1: *const u8) -> i32;
}
extern "C" {
    pub fn pcre2_serialize_free_8(arg1: *mut u8);
}
extern "C" {
    pub fn pcre2_substitute_8(
        arg1: *const pcre2_code_8,
        arg2: PCRE2_SPTR8,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_8,
        arg7: *mut pcre2_match_context_8,
        arg8: PCRE2_SPTR8,
        arg9: size_t,
        arg10: *mut PCRE2_UCHAR8,
        arg11: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_jit_compile_8(
        arg1: *mut pcre2_code_8,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_jit_match_8(
        arg1: *const pcre2_code_8,
        arg2: PCRE2_SPTR8,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_8,
        arg7: *mut pcre2_match_context_8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_jit_free_unused_memory_8(arg1: *mut pcre2_general_context_8);
}
extern "C" {
    pub fn pcre2_jit_stack_create_8(
        arg1: size_t,
        arg2: size_t,
        arg3: *mut pcre2_general_context_8,
    ) -> *mut pcre2_jit_stack_8;
}
extern "C" {
    pub fn pcre2_jit_stack_assign_8(
        arg1: *mut pcre2_match_context_8,
        arg2: pcre2_jit_callback_8,
        arg3: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn pcre2_jit_stack_free_8(arg1: *mut pcre2_jit_stack_8);
}
extern "C" {
    pub fn pcre2_get_error_message_8(
        arg1: ::std::os::raw::c_int,
        arg2: *mut PCRE2_UCHAR8,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_maketables_8(arg1: *mut pcre2_general_context_8) -> *const u8;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_general_context_16 {
    _unused: [u8; 0],
}
pub type pcre2_general_context_16 = pcre2_real_general_context_16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_compile_context_16 {
    _unused: [u8; 0],
}
pub type pcre2_compile_context_16 = pcre2_real_compile_context_16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_match_context_16 {
    _unused: [u8; 0],
}
pub type pcre2_match_context_16 = pcre2_real_match_context_16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_convert_context_16 {
    _unused: [u8; 0],
}
pub type pcre2_convert_context_16 = pcre2_real_convert_context_16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_code_16 {
    _unused: [u8; 0],
}
pub type pcre2_code_16 = pcre2_real_code_16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_match_data_16 {
    _unused: [u8; 0],
}
pub type pcre2_match_data_16 = pcre2_real_match_data_16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_jit_stack_16 {
    _unused: [u8; 0],
}
pub type pcre2_jit_stack_16 = pcre2_real_jit_stack_16;
pub type pcre2_jit_callback_16 = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
    ) -> *mut pcre2_jit_stack_16,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_callout_block_16 {
    pub version: u32,
    pub callout_number: u32,
    pub capture_top: u32,
    pub capture_last: u32,
    pub offset_vector: *mut size_t,
    pub mark: PCRE2_SPTR16,
    pub subject: PCRE2_SPTR16,
    pub subject_length: size_t,
    pub start_match: size_t,
    pub current_position: size_t,
    pub pattern_position: size_t,
    pub next_item_length: size_t,
    pub callout_string_offset: size_t,
    pub callout_string_length: size_t,
    pub callout_string: PCRE2_SPTR16,
    pub callout_flags: u32,
}
#[test]
fn bindgen_test_layout_pcre2_callout_block_16() {
    assert_eq!(
        ::std::mem::size_of::<pcre2_callout_block_16>(),
        112usize,
        concat!("Size of: ", stringify!(pcre2_callout_block_16))
    );
    assert_eq!(
        ::std::mem::align_of::<pcre2_callout_block_16>(),
        8usize,
        concat!("Alignment of ", stringify!(pcre2_callout_block_16))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).version
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).callout_number
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(callout_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).capture_top
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(capture_top)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).capture_last
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(capture_last)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).offset_vector
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(offset_vector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).mark as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(mark)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).subject
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(subject)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).subject_length
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(subject_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).start_match
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(start_match)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).current_position
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(current_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).pattern_position
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(pattern_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).next_item_length
                as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(next_item_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>()))
                .callout_string_offset as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(callout_string_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>()))
                .callout_string_length as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(callout_string_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).callout_string
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(callout_string)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_16>())).callout_flags
                as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_16),
            "::",
            stringify!(callout_flags)
        )
    );
}
impl Default for pcre2_callout_block_16 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_callout_enumerate_block_16 {
    pub version: u32,
    pub pattern_position: size_t,
    pub next_item_length: size_t,
    pub callout_number: u32,
    pub callout_string_offset: size_t,
    pub callout_string_length: size_t,
    pub callout_string: PCRE2_SPTR16,
}
#[test]
fn bindgen_test_layout_pcre2_callout_enumerate_block_16() {
    assert_eq!(
        ::std::mem::size_of::<pcre2_callout_enumerate_block_16>(),
        56usize,
        concat!("Size of: ", stringify!(pcre2_callout_enumerate_block_16))
    );
    assert_eq!(
        ::std::mem::align_of::<pcre2_callout_enumerate_block_16>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pcre2_callout_enumerate_block_16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_16>())).version
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_16),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_16>()))
                .pattern_position as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_16),
            "::",
            stringify!(pattern_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_16>()))
                .next_item_length as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_16),
            "::",
            stringify!(next_item_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_16>()))
                .callout_number as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_16),
            "::",
            stringify!(callout_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_16>()))
                .callout_string_offset as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_16),
            "::",
            stringify!(callout_string_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_16>()))
                .callout_string_length as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_16),
            "::",
            stringify!(callout_string_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_16>()))
                .callout_string as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_16),
            "::",
            stringify!(callout_string)
        )
    );
}
impl Default for pcre2_callout_enumerate_block_16 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn pcre2_config_16(
        arg1: u32,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_general_context_copy_16(
        arg1: *mut pcre2_general_context_16,
    ) -> *mut pcre2_general_context_16;
}
extern "C" {
    pub fn pcre2_general_context_create_16(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: size_t,
                arg2: *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void,
        >,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_void,
            ),
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut pcre2_general_context_16;
}
extern "C" {
    pub fn pcre2_general_context_free_16(arg1: *mut pcre2_general_context_16);
}
extern "C" {
    pub fn pcre2_compile_context_copy_16(
        arg1: *mut pcre2_compile_context_16,
    ) -> *mut pcre2_compile_context_16;
}
extern "C" {
    pub fn pcre2_compile_context_create_16(
        arg1: *mut pcre2_general_context_16,
    ) -> *mut pcre2_compile_context_16;
}
extern "C" {
    pub fn pcre2_compile_context_free_16(arg1: *mut pcre2_compile_context_16);
}
extern "C" {
    pub fn pcre2_set_bsr_16(
        arg1: *mut pcre2_compile_context_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_character_tables_16(
        arg1: *mut pcre2_compile_context_16,
        arg2: *const ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_compile_extra_options_16(
        arg1: *mut pcre2_compile_context_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_max_pattern_length_16(
        arg1: *mut pcre2_compile_context_16,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_newline_16(
        arg1: *mut pcre2_compile_context_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_parens_nest_limit_16(
        arg1: *mut pcre2_compile_context_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_compile_recursion_guard_16(
        arg1: *mut pcre2_compile_context_16,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: u32,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_convert_context_copy_16(
        arg1: *mut pcre2_convert_context_16,
    ) -> *mut pcre2_convert_context_16;
}
extern "C" {
    pub fn pcre2_convert_context_create_16(
        arg1: *mut pcre2_general_context_16,
    ) -> *mut pcre2_convert_context_16;
}
extern "C" {
    pub fn pcre2_convert_context_free_16(arg1: *mut pcre2_convert_context_16);
}
extern "C" {
    pub fn pcre2_set_glob_escape_16(
        arg1: *mut pcre2_convert_context_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_glob_separator_16(
        arg1: *mut pcre2_convert_context_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_pattern_convert_16(
        arg1: PCRE2_SPTR16,
        arg2: size_t,
        arg3: u32,
        arg4: *mut *mut PCRE2_UCHAR16,
        arg5: *mut size_t,
        arg6: *mut pcre2_convert_context_16,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_converted_pattern_free_16(arg1: *mut PCRE2_UCHAR16);
}
extern "C" {
    pub fn pcre2_match_context_copy_16(
        arg1: *mut pcre2_match_context_16,
    ) -> *mut pcre2_match_context_16;
}
extern "C" {
    pub fn pcre2_match_context_create_16(
        arg1: *mut pcre2_general_context_16,
    ) -> *mut pcre2_match_context_16;
}
extern "C" {
    pub fn pcre2_match_context_free_16(arg1: *mut pcre2_match_context_16);
}
extern "C" {
    pub fn pcre2_set_callout_16(
        arg1: *mut pcre2_match_context_16,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut pcre2_callout_block_16,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_depth_limit_16(
        arg1: *mut pcre2_match_context_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_heap_limit_16(
        arg1: *mut pcre2_match_context_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_match_limit_16(
        arg1: *mut pcre2_match_context_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_offset_limit_16(
        arg1: *mut pcre2_match_context_16,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_recursion_limit_16(
        arg1: *mut pcre2_match_context_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_recursion_memory_management_16(
        arg1: *mut pcre2_match_context_16,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: size_t,
                arg2: *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void,
        >,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_void,
            ),
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_compile_16(
        arg1: PCRE2_SPTR16,
        arg2: size_t,
        arg3: u32,
        arg4: *mut ::std::os::raw::c_int,
        arg5: *mut size_t,
        arg6: *mut pcre2_compile_context_16,
    ) -> *mut pcre2_code_16;
}
extern "C" {
    pub fn pcre2_code_free_16(arg1: *mut pcre2_code_16);
}
extern "C" {
    pub fn pcre2_code_copy_16(arg1: *const pcre2_code_16)
        -> *mut pcre2_code_16;
}
extern "C" {
    pub fn pcre2_code_copy_with_tables_16(
        arg1: *const pcre2_code_16,
    ) -> *mut pcre2_code_16;
}
extern "C" {
    pub fn pcre2_pattern_info_16(
        arg1: *const pcre2_code_16,
        arg2: u32,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_callout_enumerate_16(
        arg1: *const pcre2_code_16,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut pcre2_callout_enumerate_block_16,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_match_data_create_16(
        arg1: u32,
        arg2: *mut pcre2_general_context_16,
    ) -> *mut pcre2_match_data_16;
}
extern "C" {
    pub fn pcre2_match_data_create_from_pattern_16(
        arg1: *const pcre2_code_16,
        arg2: *mut pcre2_general_context_16,
    ) -> *mut pcre2_match_data_16;
}
extern "C" {
    pub fn pcre2_dfa_match_16(
        arg1: *const pcre2_code_16,
        arg2: PCRE2_SPTR16,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_16,
        arg7: *mut pcre2_match_context_16,
        arg8: *mut ::std::os::raw::c_int,
        arg9: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_match_16(
        arg1: *const pcre2_code_16,
        arg2: PCRE2_SPTR16,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_16,
        arg7: *mut pcre2_match_context_16,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_match_data_free_16(arg1: *mut pcre2_match_data_16);
}
extern "C" {
    pub fn pcre2_get_mark_16(arg1: *mut pcre2_match_data_16) -> PCRE2_SPTR16;
}
extern "C" {
    pub fn pcre2_get_ovector_count_16(arg1: *mut pcre2_match_data_16) -> u32;
}
extern "C" {
    pub fn pcre2_get_ovector_pointer_16(
        arg1: *mut pcre2_match_data_16,
    ) -> *mut size_t;
}
extern "C" {
    pub fn pcre2_get_startchar_16(arg1: *mut pcre2_match_data_16) -> size_t;
}
extern "C" {
    pub fn pcre2_substring_copy_byname_16(
        arg1: *mut pcre2_match_data_16,
        arg2: PCRE2_SPTR16,
        arg3: *mut PCRE2_UCHAR16,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_copy_bynumber_16(
        arg1: *mut pcre2_match_data_16,
        arg2: u32,
        arg3: *mut PCRE2_UCHAR16,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_free_16(arg1: *mut PCRE2_UCHAR16);
}
extern "C" {
    pub fn pcre2_substring_get_byname_16(
        arg1: *mut pcre2_match_data_16,
        arg2: PCRE2_SPTR16,
        arg3: *mut *mut PCRE2_UCHAR16,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_get_bynumber_16(
        arg1: *mut pcre2_match_data_16,
        arg2: u32,
        arg3: *mut *mut PCRE2_UCHAR16,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_length_byname_16(
        arg1: *mut pcre2_match_data_16,
        arg2: PCRE2_SPTR16,
        arg3: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_length_bynumber_16(
        arg1: *mut pcre2_match_data_16,
        arg2: u32,
        arg3: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_nametable_scan_16(
        arg1: *const pcre2_code_16,
        arg2: PCRE2_SPTR16,
        arg3: *mut PCRE2_SPTR16,
        arg4: *mut PCRE2_SPTR16,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_number_from_name_16(
        arg1: *const pcre2_code_16,
        arg2: PCRE2_SPTR16,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_list_free_16(arg1: *mut PCRE2_SPTR16);
}
extern "C" {
    pub fn pcre2_substring_list_get_16(
        arg1: *mut pcre2_match_data_16,
        arg2: *mut *mut *mut PCRE2_UCHAR16,
        arg3: *mut *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_serialize_encode_16(
        arg1: *mut *const pcre2_code_16,
        arg2: i32,
        arg3: *mut *mut u8,
        arg4: *mut size_t,
        arg5: *mut pcre2_general_context_16,
    ) -> i32;
}
extern "C" {
    pub fn pcre2_serialize_decode_16(
        arg1: *mut *mut pcre2_code_16,
        arg2: i32,
        arg3: *const u8,
        arg4: *mut pcre2_general_context_16,
    ) -> i32;
}
extern "C" {
    pub fn pcre2_serialize_get_number_of_codes_16(arg1: *const u8) -> i32;
}
extern "C" {
    pub fn pcre2_serialize_free_16(arg1: *mut u8);
}
extern "C" {
    pub fn pcre2_substitute_16(
        arg1: *const pcre2_code_16,
        arg2: PCRE2_SPTR16,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_16,
        arg7: *mut pcre2_match_context_16,
        arg8: PCRE2_SPTR16,
        arg9: size_t,
        arg10: *mut PCRE2_UCHAR16,
        arg11: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_jit_compile_16(
        arg1: *mut pcre2_code_16,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_jit_match_16(
        arg1: *const pcre2_code_16,
        arg2: PCRE2_SPTR16,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_16,
        arg7: *mut pcre2_match_context_16,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_jit_free_unused_memory_16(arg1: *mut pcre2_general_context_16);
}
extern "C" {
    pub fn pcre2_jit_stack_create_16(
        arg1: size_t,
        arg2: size_t,
        arg3: *mut pcre2_general_context_16,
    ) -> *mut pcre2_jit_stack_16;
}
extern "C" {
    pub fn pcre2_jit_stack_assign_16(
        arg1: *mut pcre2_match_context_16,
        arg2: pcre2_jit_callback_16,
        arg3: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn pcre2_jit_stack_free_16(arg1: *mut pcre2_jit_stack_16);
}
extern "C" {
    pub fn pcre2_get_error_message_16(
        arg1: ::std::os::raw::c_int,
        arg2: *mut PCRE2_UCHAR16,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_maketables_16(
        arg1: *mut pcre2_general_context_16,
    ) -> *const u8;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_general_context_32 {
    _unused: [u8; 0],
}
pub type pcre2_general_context_32 = pcre2_real_general_context_32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_compile_context_32 {
    _unused: [u8; 0],
}
pub type pcre2_compile_context_32 = pcre2_real_compile_context_32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_match_context_32 {
    _unused: [u8; 0],
}
pub type pcre2_match_context_32 = pcre2_real_match_context_32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_convert_context_32 {
    _unused: [u8; 0],
}
pub type pcre2_convert_context_32 = pcre2_real_convert_context_32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_code_32 {
    _unused: [u8; 0],
}
pub type pcre2_code_32 = pcre2_real_code_32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_match_data_32 {
    _unused: [u8; 0],
}
pub type pcre2_match_data_32 = pcre2_real_match_data_32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_real_jit_stack_32 {
    _unused: [u8; 0],
}
pub type pcre2_jit_stack_32 = pcre2_real_jit_stack_32;
pub type pcre2_jit_callback_32 = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
    ) -> *mut pcre2_jit_stack_32,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_callout_block_32 {
    pub version: u32,
    pub callout_number: u32,
    pub capture_top: u32,
    pub capture_last: u32,
    pub offset_vector: *mut size_t,
    pub mark: PCRE2_SPTR32,
    pub subject: PCRE2_SPTR32,
    pub subject_length: size_t,
    pub start_match: size_t,
    pub current_position: size_t,
    pub pattern_position: size_t,
    pub next_item_length: size_t,
    pub callout_string_offset: size_t,
    pub callout_string_length: size_t,
    pub callout_string: PCRE2_SPTR32,
    pub callout_flags: u32,
}
#[test]
fn bindgen_test_layout_pcre2_callout_block_32() {
    assert_eq!(
        ::std::mem::size_of::<pcre2_callout_block_32>(),
        112usize,
        concat!("Size of: ", stringify!(pcre2_callout_block_32))
    );
    assert_eq!(
        ::std::mem::align_of::<pcre2_callout_block_32>(),
        8usize,
        concat!("Alignment of ", stringify!(pcre2_callout_block_32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).version
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).callout_number
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(callout_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).capture_top
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(capture_top)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).capture_last
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(capture_last)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).offset_vector
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(offset_vector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).mark as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(mark)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).subject
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(subject)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).subject_length
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(subject_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).start_match
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(start_match)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).current_position
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(current_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).pattern_position
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(pattern_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).next_item_length
                as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(next_item_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>()))
                .callout_string_offset as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(callout_string_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>()))
                .callout_string_length as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(callout_string_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).callout_string
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(callout_string)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_block_32>())).callout_flags
                as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_block_32),
            "::",
            stringify!(callout_flags)
        )
    );
}
impl Default for pcre2_callout_block_32 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcre2_callout_enumerate_block_32 {
    pub version: u32,
    pub pattern_position: size_t,
    pub next_item_length: size_t,
    pub callout_number: u32,
    pub callout_string_offset: size_t,
    pub callout_string_length: size_t,
    pub callout_string: PCRE2_SPTR32,
}
#[test]
fn bindgen_test_layout_pcre2_callout_enumerate_block_32() {
    assert_eq!(
        ::std::mem::size_of::<pcre2_callout_enumerate_block_32>(),
        56usize,
        concat!("Size of: ", stringify!(pcre2_callout_enumerate_block_32))
    );
    assert_eq!(
        ::std::mem::align_of::<pcre2_callout_enumerate_block_32>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pcre2_callout_enumerate_block_32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_32>())).version
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_32),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_32>()))
                .pattern_position as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_32),
            "::",
            stringify!(pattern_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_32>()))
                .next_item_length as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_32),
            "::",
            stringify!(next_item_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_32>()))
                .callout_number as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_32),
            "::",
            stringify!(callout_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_32>()))
                .callout_string_offset as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_32),
            "::",
            stringify!(callout_string_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_32>()))
                .callout_string_length as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_32),
            "::",
            stringify!(callout_string_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pcre2_callout_enumerate_block_32>()))
                .callout_string as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pcre2_callout_enumerate_block_32),
            "::",
            stringify!(callout_string)
        )
    );
}
impl Default for pcre2_callout_enumerate_block_32 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn pcre2_config_32(
        arg1: u32,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_general_context_copy_32(
        arg1: *mut pcre2_general_context_32,
    ) -> *mut pcre2_general_context_32;
}
extern "C" {
    pub fn pcre2_general_context_create_32(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: size_t,
                arg2: *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void,
        >,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_void,
            ),
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut pcre2_general_context_32;
}
extern "C" {
    pub fn pcre2_general_context_free_32(arg1: *mut pcre2_general_context_32);
}
extern "C" {
    pub fn pcre2_compile_context_copy_32(
        arg1: *mut pcre2_compile_context_32,
    ) -> *mut pcre2_compile_context_32;
}
extern "C" {
    pub fn pcre2_compile_context_create_32(
        arg1: *mut pcre2_general_context_32,
    ) -> *mut pcre2_compile_context_32;
}
extern "C" {
    pub fn pcre2_compile_context_free_32(arg1: *mut pcre2_compile_context_32);
}
extern "C" {
    pub fn pcre2_set_bsr_32(
        arg1: *mut pcre2_compile_context_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_character_tables_32(
        arg1: *mut pcre2_compile_context_32,
        arg2: *const ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_compile_extra_options_32(
        arg1: *mut pcre2_compile_context_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_max_pattern_length_32(
        arg1: *mut pcre2_compile_context_32,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_newline_32(
        arg1: *mut pcre2_compile_context_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_parens_nest_limit_32(
        arg1: *mut pcre2_compile_context_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_compile_recursion_guard_32(
        arg1: *mut pcre2_compile_context_32,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: u32,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_convert_context_copy_32(
        arg1: *mut pcre2_convert_context_32,
    ) -> *mut pcre2_convert_context_32;
}
extern "C" {
    pub fn pcre2_convert_context_create_32(
        arg1: *mut pcre2_general_context_32,
    ) -> *mut pcre2_convert_context_32;
}
extern "C" {
    pub fn pcre2_convert_context_free_32(arg1: *mut pcre2_convert_context_32);
}
extern "C" {
    pub fn pcre2_set_glob_escape_32(
        arg1: *mut pcre2_convert_context_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_glob_separator_32(
        arg1: *mut pcre2_convert_context_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_pattern_convert_32(
        arg1: PCRE2_SPTR32,
        arg2: size_t,
        arg3: u32,
        arg4: *mut *mut PCRE2_UCHAR32,
        arg5: *mut size_t,
        arg6: *mut pcre2_convert_context_32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_converted_pattern_free_32(arg1: *mut PCRE2_UCHAR32);
}
extern "C" {
    pub fn pcre2_match_context_copy_32(
        arg1: *mut pcre2_match_context_32,
    ) -> *mut pcre2_match_context_32;
}
extern "C" {
    pub fn pcre2_match_context_create_32(
        arg1: *mut pcre2_general_context_32,
    ) -> *mut pcre2_match_context_32;
}
extern "C" {
    pub fn pcre2_match_context_free_32(arg1: *mut pcre2_match_context_32);
}
extern "C" {
    pub fn pcre2_set_callout_32(
        arg1: *mut pcre2_match_context_32,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut pcre2_callout_block_32,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_depth_limit_32(
        arg1: *mut pcre2_match_context_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_heap_limit_32(
        arg1: *mut pcre2_match_context_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_match_limit_32(
        arg1: *mut pcre2_match_context_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_offset_limit_32(
        arg1: *mut pcre2_match_context_32,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_recursion_limit_32(
        arg1: *mut pcre2_match_context_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_set_recursion_memory_management_32(
        arg1: *mut pcre2_match_context_32,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: size_t,
                arg2: *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void,
        >,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_void,
            ),
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_compile_32(
        arg1: PCRE2_SPTR32,
        arg2: size_t,
        arg3: u32,
        arg4: *mut ::std::os::raw::c_int,
        arg5: *mut size_t,
        arg6: *mut pcre2_compile_context_32,
    ) -> *mut pcre2_code_32;
}
extern "C" {
    pub fn pcre2_code_free_32(arg1: *mut pcre2_code_32);
}
extern "C" {
    pub fn pcre2_code_copy_32(arg1: *const pcre2_code_32)
        -> *mut pcre2_code_32;
}
extern "C" {
    pub fn pcre2_code_copy_with_tables_32(
        arg1: *const pcre2_code_32,
    ) -> *mut pcre2_code_32;
}
extern "C" {
    pub fn pcre2_pattern_info_32(
        arg1: *const pcre2_code_32,
        arg2: u32,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_callout_enumerate_32(
        arg1: *const pcre2_code_32,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut pcre2_callout_enumerate_block_32,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_match_data_create_32(
        arg1: u32,
        arg2: *mut pcre2_general_context_32,
    ) -> *mut pcre2_match_data_32;
}
extern "C" {
    pub fn pcre2_match_data_create_from_pattern_32(
        arg1: *const pcre2_code_32,
        arg2: *mut pcre2_general_context_32,
    ) -> *mut pcre2_match_data_32;
}
extern "C" {
    pub fn pcre2_dfa_match_32(
        arg1: *const pcre2_code_32,
        arg2: PCRE2_SPTR32,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_32,
        arg7: *mut pcre2_match_context_32,
        arg8: *mut ::std::os::raw::c_int,
        arg9: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_match_32(
        arg1: *const pcre2_code_32,
        arg2: PCRE2_SPTR32,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_32,
        arg7: *mut pcre2_match_context_32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_match_data_free_32(arg1: *mut pcre2_match_data_32);
}
extern "C" {
    pub fn pcre2_get_mark_32(arg1: *mut pcre2_match_data_32) -> PCRE2_SPTR32;
}
extern "C" {
    pub fn pcre2_get_ovector_count_32(arg1: *mut pcre2_match_data_32) -> u32;
}
extern "C" {
    pub fn pcre2_get_ovector_pointer_32(
        arg1: *mut pcre2_match_data_32,
    ) -> *mut size_t;
}
extern "C" {
    pub fn pcre2_get_startchar_32(arg1: *mut pcre2_match_data_32) -> size_t;
}
extern "C" {
    pub fn pcre2_substring_copy_byname_32(
        arg1: *mut pcre2_match_data_32,
        arg2: PCRE2_SPTR32,
        arg3: *mut PCRE2_UCHAR32,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_copy_bynumber_32(
        arg1: *mut pcre2_match_data_32,
        arg2: u32,
        arg3: *mut PCRE2_UCHAR32,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_free_32(arg1: *mut PCRE2_UCHAR32);
}
extern "C" {
    pub fn pcre2_substring_get_byname_32(
        arg1: *mut pcre2_match_data_32,
        arg2: PCRE2_SPTR32,
        arg3: *mut *mut PCRE2_UCHAR32,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_get_bynumber_32(
        arg1: *mut pcre2_match_data_32,
        arg2: u32,
        arg3: *mut *mut PCRE2_UCHAR32,
        arg4: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_length_byname_32(
        arg1: *mut pcre2_match_data_32,
        arg2: PCRE2_SPTR32,
        arg3: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_length_bynumber_32(
        arg1: *mut pcre2_match_data_32,
        arg2: u32,
        arg3: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_nametable_scan_32(
        arg1: *const pcre2_code_32,
        arg2: PCRE2_SPTR32,
        arg3: *mut PCRE2_SPTR32,
        arg4: *mut PCRE2_SPTR32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_number_from_name_32(
        arg1: *const pcre2_code_32,
        arg2: PCRE2_SPTR32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_substring_list_free_32(arg1: *mut PCRE2_SPTR32);
}
extern "C" {
    pub fn pcre2_substring_list_get_32(
        arg1: *mut pcre2_match_data_32,
        arg2: *mut *mut *mut PCRE2_UCHAR32,
        arg3: *mut *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_serialize_encode_32(
        arg1: *mut *const pcre2_code_32,
        arg2: i32,
        arg3: *mut *mut u8,
        arg4: *mut size_t,
        arg5: *mut pcre2_general_context_32,
    ) -> i32;
}
extern "C" {
    pub fn pcre2_serialize_decode_32(
        arg1: *mut *mut pcre2_code_32,
        arg2: i32,
        arg3: *const u8,
        arg4: *mut pcre2_general_context_32,
    ) -> i32;
}
extern "C" {
    pub fn pcre2_serialize_get_number_of_codes_32(arg1: *const u8) -> i32;
}
extern "C" {
    pub fn pcre2_serialize_free_32(arg1: *mut u8);
}
extern "C" {
    pub fn pcre2_substitute_32(
        arg1: *const pcre2_code_32,
        arg2: PCRE2_SPTR32,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_32,
        arg7: *mut pcre2_match_context_32,
        arg8: PCRE2_SPTR32,
        arg9: size_t,
        arg10: *mut PCRE2_UCHAR32,
        arg11: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_jit_compile_32(
        arg1: *mut pcre2_code_32,
        arg2: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_jit_match_32(
        arg1: *const pcre2_code_32,
        arg2: PCRE2_SPTR32,
        arg3: size_t,
        arg4: size_t,
        arg5: u32,
        arg6: *mut pcre2_match_data_32,
        arg7: *mut pcre2_match_context_32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_jit_free_unused_memory_32(arg1: *mut pcre2_general_context_32);
}
extern "C" {
    pub fn pcre2_jit_stack_create_32(
        arg1: size_t,
        arg2: size_t,
        arg3: *mut pcre2_general_context_32,
    ) -> *mut pcre2_jit_stack_32;
}
extern "C" {
    pub fn pcre2_jit_stack_assign_32(
        arg1: *mut pcre2_match_context_32,
        arg2: pcre2_jit_callback_32,
        arg3: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn pcre2_jit_stack_free_32(arg1: *mut pcre2_jit_stack_32);
}
extern "C" {
    pub fn pcre2_get_error_message_32(
        arg1: ::std::os::raw::c_int,
        arg2: *mut PCRE2_UCHAR32,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pcre2_maketables_32(
        arg1: *mut pcre2_general_context_32,
    ) -> *const u8;
}
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout___mbstate_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wch
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wchb
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wchb)
        )
    );
}
impl Default for __mbstate_t__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        8usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mbstate_t>())).__count as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mbstate_t>())).__value as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__value)
        )
    );
}
impl Default for __mbstate_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_G_fpos_t>())).__pos as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_G_fpos_t>())).__state as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__state)
        )
    );
}
impl Default for _G_fpos_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __fpos_t = _G_fpos_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos64_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos64_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_G_fpos64_t>())).__pos as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_G_fpos64_t>())).__state as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__state)
        )
    );
}
impl Default for _G_fpos64_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __fpos64_t = _G_fpos64_t;
pub type __FILE = _IO_FILE;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: size_t,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_ptr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_end as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_base as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_base as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_ptr as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_end as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_base as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_end as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_base as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_backup_base as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_end as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._markers as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._chain as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._fileno as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._flags2 as *const _ as usize
        },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._old_offset as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._cur_column as *const _
                as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._vtable_offset as *const _
                as usize
        },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._shortbuf as *const _ as usize
        },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._lock as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._offset as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._codecvt as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_codecvt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._wide_data as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_wide_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._freeres_list as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_list)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._freeres_buf as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>())).__pad5 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._mode as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_IO_FILE>()))._unused2 as *const _ as usize
        },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
impl Default for _IO_FILE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type fpos_t = __fpos_t;
extern "C" {
    pub static mut stdin: *mut FILE;
}
extern "C" {
    pub static mut stdout: *mut FILE;
}
extern "C" {
    pub static mut stderr: *mut FILE;
}
extern "C" {
    pub fn remove(
        __filename: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameat(
        __oldfd: ::std::os::raw::c_int,
        __old: *const ::std::os::raw::c_char,
        __newfd: ::std::os::raw::c_int,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(
        __s: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpnam_r(
        __s: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn freopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
        __stream: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fdopen(
        __fd: ::std::os::raw::c_int,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fmemopen(
        __s: *mut ::std::os::raw::c_void,
        __len: size_t,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufloc: *mut *mut ::std::os::raw::c_char,
        __sizeloc: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub fn setbuf(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        __stream: *mut FILE,
        __buf: *mut ::std::os::raw::c_char,
        __modes: ::std::os::raw::c_int,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(
        __stream: *mut FILE,
        __buf: *mut ::std::os::raw::c_char,
        __size: size_t,
    );
}
extern "C" {
    pub fn setlinebuf(__stream: *mut FILE);
}
extern "C" {
    pub fn fprintf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf(
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf(
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_fscanf"]
    pub fn fscanf1(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_scanf"]
    pub fn scanf1(
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_sscanf"]
    pub fn sscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vfscanf"]
    pub fn vfscanf1(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vscanf"]
    pub fn vscanf1(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vsscanf"]
    pub fn vsscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(
        __c: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(
        __c: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc_unlocked(
        __c: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(
        __c: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(
        __c: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(
        __w: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        __s: *mut ::std::os::raw::c_char,
        __n: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getline(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn fputs(
        __s: *const ::std::os::raw::c_char,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetc(
        __c: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __s: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fread_unlocked(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fwrite_unlocked(
        __ptr: *const ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fseek(
        __stream: *mut FILE,
        __off: ::std::os::raw::c_long,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(__stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rewind(__stream: *mut FILE);
}
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __off: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> __off_t;
}
extern "C" {
    pub fn fgetpos(
        __stream: *mut FILE,
        __pos: *mut fpos_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(
        __stream: *mut FILE,
        __pos: *const fpos_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr(__stream: *mut FILE);
}
extern "C" {
    pub fn feof(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr_unlocked(__stream: *mut FILE);
}
extern "C" {
    pub fn feof_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(__s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub static mut sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn fileno(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        __command: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn pclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(
        __s: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn flockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn __uflow(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __overflow(
        arg1: *mut FILE,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ly_path {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lyxp_expr {
    _unused: [u8; 0],
}
pub mod ly_stmt {
    pub type Type = ::std::os::raw::c_uint;
    pub const LY_STMT_NONE: Type = 0;
    pub const LY_STMT_NOTIFICATION: Type = 1;
    pub const LY_STMT_INPUT: Type = 2;
    pub const LY_STMT_OUTPUT: Type = 3;
    pub const LY_STMT_ACTION: Type = 4;
    pub const LY_STMT_RPC: Type = 5;
    pub const LY_STMT_ANYDATA: Type = 6;
    pub const LY_STMT_ANYXML: Type = 7;
    pub const LY_STMT_AUGMENT: Type = 8;
    pub const LY_STMT_CASE: Type = 9;
    pub const LY_STMT_CHOICE: Type = 10;
    pub const LY_STMT_CONTAINER: Type = 11;
    pub const LY_STMT_GROUPING: Type = 12;
    pub const LY_STMT_LEAF: Type = 13;
    pub const LY_STMT_LEAF_LIST: Type = 14;
    pub const LY_STMT_LIST: Type = 15;
    pub const LY_STMT_USES: Type = 16;
    pub const LY_STMT_ARGUMENT: Type = 17;
    pub const LY_STMT_BASE: Type = 18;
    pub const LY_STMT_BELONGS_TO: Type = 19;
    pub const LY_STMT_BIT: Type = 20;
    pub const LY_STMT_CONFIG: Type = 21;
    pub const LY_STMT_CONTACT: Type = 22;
    pub const LY_STMT_DEFAULT: Type = 23;
    pub const LY_STMT_DESCRIPTION: Type = 24;
    pub const LY_STMT_DEVIATE: Type = 25;
    pub const LY_STMT_DEVIATION: Type = 26;
    pub const LY_STMT_ENUM: Type = 27;
    pub const LY_STMT_ERROR_APP_TAG: Type = 28;
    pub const LY_STMT_ERROR_MESSAGE: Type = 29;
    pub const LY_STMT_EXTENSION: Type = 30;
    pub const LY_STMT_EXTENSION_INSTANCE: Type = 31;
    pub const LY_STMT_FEATURE: Type = 32;
    pub const LY_STMT_FRACTION_DIGITS: Type = 33;
    pub const LY_STMT_IDENTITY: Type = 34;
    pub const LY_STMT_IF_FEATURE: Type = 35;
    pub const LY_STMT_IMPORT: Type = 36;
    pub const LY_STMT_INCLUDE: Type = 37;
    pub const LY_STMT_KEY: Type = 38;
    pub const LY_STMT_LENGTH: Type = 39;
    pub const LY_STMT_MANDATORY: Type = 40;
    pub const LY_STMT_MAX_ELEMENTS: Type = 41;
    pub const LY_STMT_MIN_ELEMENTS: Type = 42;
    pub const LY_STMT_MODIFIER: Type = 43;
    pub const LY_STMT_MODULE: Type = 44;
    pub const LY_STMT_MUST: Type = 45;
    pub const LY_STMT_NAMESPACE: Type = 46;
    pub const LY_STMT_ORDERED_BY: Type = 47;
    pub const LY_STMT_ORGANIZATION: Type = 48;
    pub const LY_STMT_PATH: Type = 49;
    pub const LY_STMT_PATTERN: Type = 50;
    pub const LY_STMT_POSITION: Type = 51;
    pub const LY_STMT_PREFIX: Type = 52;
    pub const LY_STMT_PRESENCE: Type = 53;
    pub const LY_STMT_RANGE: Type = 54;
    pub const LY_STMT_REFERENCE: Type = 55;
    pub const LY_STMT_REFINE: Type = 56;
    pub const LY_STMT_REQUIRE_INSTANCE: Type = 57;
    pub const LY_STMT_REVISION: Type = 58;
    pub const LY_STMT_REVISION_DATE: Type = 59;
    pub const LY_STMT_STATUS: Type = 60;
    pub const LY_STMT_SUBMODULE: Type = 61;
    pub const LY_STMT_TYPE: Type = 62;
    pub const LY_STMT_TYPEDEF: Type = 63;
    pub const LY_STMT_UNIQUE: Type = 64;
    pub const LY_STMT_UNITS: Type = 65;
    pub const LY_STMT_VALUE: Type = 66;
    pub const LY_STMT_WHEN: Type = 67;
    pub const LY_STMT_YANG_VERSION: Type = 68;
    pub const LY_STMT_YIN_ELEMENT: Type = 69;
    pub const LY_STMT_SYNTAX_SEMICOLON: Type = 70;
    pub const LY_STMT_SYNTAX_LEFT_BRACE: Type = 71;
    pub const LY_STMT_SYNTAX_RIGHT_BRACE: Type = 72;
    pub const LY_STMT_ARG_TEXT: Type = 73;
    pub const LY_STMT_ARG_VALUE: Type = 74;
}
extern "C" {
    pub fn ly_stmt2str(stmt: ly_stmt::Type) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn lys_nodetype2stmt(nodetype: u16) -> ly_stmt::Type;
}
pub mod ly_stmt_cardinality {
    pub type Type = ::std::os::raw::c_uint;
    pub const LY_STMT_CARD_OPT: Type = 0;
    pub const LY_STMT_CARD_MAND: Type = 1;
    pub const LY_STMT_CARD_SOME: Type = 2;
    pub const LY_STMT_CARD_ANY: Type = 3;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_import {
    pub module: *mut lys_module,
    pub name: *const ::std::os::raw::c_char,
    pub prefix: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysp_ext_instance,
    pub flags: u16,
    pub rev: [::std::os::raw::c_char; 11usize],
}
#[test]
fn bindgen_test_layout_lysp_import() {
    assert_eq!(
        ::std::mem::size_of::<lysp_import>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_import))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_import>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_import))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_import>())).module as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_import),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_import>())).name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_import),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_import>())).prefix as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_import),
            "::",
            stringify!(prefix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_import>())).dsc as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_import),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_import>())).ref_ as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_import),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_import>())).exts as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_import),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_import>())).flags as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_import),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_import>())).rev as *const _ as usize
        },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_import),
            "::",
            stringify!(rev)
        )
    );
}
impl Default for lysp_import {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_include {
    pub submodule: *mut lysp_submodule,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysp_ext_instance,
    pub rev: [::std::os::raw::c_char; 11usize],
    pub injected: ly_bool,
}
#[test]
fn bindgen_test_layout_lysp_include() {
    assert_eq!(
        ::std::mem::size_of::<lysp_include>(),
        56usize,
        concat!("Size of: ", stringify!(lysp_include))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_include>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_include))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_include>())).submodule as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_include),
            "::",
            stringify!(submodule)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_include>())).name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_include),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_include>())).dsc as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_include),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_include>())).ref_ as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_include),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_include>())).exts as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_include),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_include>())).rev as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_include),
            "::",
            stringify!(rev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_include>())).injected as *const _
                as usize
        },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_include),
            "::",
            stringify!(injected)
        )
    );
}
impl Default for lysp_include {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_ext {
    pub name: *const ::std::os::raw::c_char,
    pub argname: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysp_ext_instance,
    pub flags: u16,
    pub compiled: *mut lysc_ext,
}
#[test]
fn bindgen_test_layout_lysp_ext() {
    assert_eq!(
        ::std::mem::size_of::<lysp_ext>(),
        56usize,
        concat!("Size of: ", stringify!(lysp_ext))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_ext>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_ext))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext>())).name as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext>())).argname as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext),
            "::",
            stringify!(argname)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext>())).dsc as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext>())).ref_ as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext>())).exts as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext>())).flags as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext>())).compiled as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext),
            "::",
            stringify!(compiled)
        )
    );
}
impl Default for lysp_ext {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_stmt {
    pub stmt: *const ::std::os::raw::c_char,
    pub arg: *const ::std::os::raw::c_char,
    pub format: LY_VALUE_FORMAT::Type,
    pub prefix_data: *mut ::std::os::raw::c_void,
    pub next: *mut lysp_stmt,
    pub child: *mut lysp_stmt,
    pub flags: u16,
    pub kw: ly_stmt::Type,
}
#[test]
fn bindgen_test_layout_lysp_stmt() {
    assert_eq!(
        ::std::mem::size_of::<lysp_stmt>(),
        56usize,
        concat!("Size of: ", stringify!(lysp_stmt))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_stmt>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_stmt))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_stmt>())).stmt as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_stmt),
            "::",
            stringify!(stmt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_stmt>())).arg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_stmt),
            "::",
            stringify!(arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_stmt>())).format as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_stmt),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_stmt>())).prefix_data as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_stmt),
            "::",
            stringify!(prefix_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_stmt>())).next as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_stmt),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_stmt>())).child as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_stmt),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_stmt>())).flags as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_stmt),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_stmt>())).kw as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_stmt),
            "::",
            stringify!(kw)
        )
    );
}
impl Default for lysp_stmt {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_ext_instance {
    pub name: *const ::std::os::raw::c_char,
    pub argument: *const ::std::os::raw::c_char,
    pub format: LY_VALUE_FORMAT::Type,
    pub parsed: *mut lysp_node,
    pub prefix_data: *mut ::std::os::raw::c_void,
    pub child: *mut lysp_stmt,
    pub parent: *mut ::std::os::raw::c_void,
    pub parent_stmt: ly_stmt::Type,
    pub parent_stmt_index: u64,
    pub flags: u16,
}
#[test]
fn bindgen_test_layout_lysp_ext_instance() {
    assert_eq!(
        ::std::mem::size_of::<lysp_ext_instance>(),
        80usize,
        concat!("Size of: ", stringify!(lysp_ext_instance))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_ext_instance>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_ext_instance))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext_instance>())).name as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext_instance),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext_instance>())).argument as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext_instance),
            "::",
            stringify!(argument)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext_instance>())).format as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext_instance),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext_instance>())).parsed as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext_instance),
            "::",
            stringify!(parsed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext_instance>())).prefix_data
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext_instance),
            "::",
            stringify!(prefix_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext_instance>())).child as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext_instance),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext_instance>())).parent as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext_instance),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext_instance>())).parent_stmt
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext_instance),
            "::",
            stringify!(parent_stmt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext_instance>())).parent_stmt_index
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext_instance),
            "::",
            stringify!(parent_stmt_index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ext_instance>())).flags as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ext_instance),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysp_ext_instance {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_feature {
    pub name: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub iffeatures_c: *mut lysc_iffeature,
    pub depfeatures: *mut *mut lysp_feature,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysp_ext_instance,
    pub flags: u16,
}
#[test]
fn bindgen_test_layout_lysp_feature() {
    assert_eq!(
        ::std::mem::size_of::<lysp_feature>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_feature))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_feature>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_feature))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_feature>())).name as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_feature),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_feature>())).iffeatures as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_feature),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_feature>())).iffeatures_c as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_feature),
            "::",
            stringify!(iffeatures_c)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_feature>())).depfeatures as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_feature),
            "::",
            stringify!(depfeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_feature>())).dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_feature),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_feature>())).ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_feature),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_feature>())).exts as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_feature),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_feature>())).flags as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_feature),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysp_feature {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_iffeature {
    pub expr: *mut u8,
    pub features: *mut *mut lysp_feature,
}
#[test]
fn bindgen_test_layout_lysc_iffeature() {
    assert_eq!(
        ::std::mem::size_of::<lysc_iffeature>(),
        16usize,
        concat!("Size of: ", stringify!(lysc_iffeature))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_iffeature>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_iffeature))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_iffeature>())).expr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_iffeature),
            "::",
            stringify!(expr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_iffeature>())).features as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_iffeature),
            "::",
            stringify!(features)
        )
    );
}
impl Default for lysc_iffeature {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_qname {
    pub str_: *const ::std::os::raw::c_char,
    pub mod_: *const lysp_module,
}
#[test]
fn bindgen_test_layout_lysp_qname() {
    assert_eq!(
        ::std::mem::size_of::<lysp_qname>(),
        16usize,
        concat!("Size of: ", stringify!(lysp_qname))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_qname>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_qname))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_qname>())).str_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_qname),
            "::",
            stringify!(str_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_qname>())).mod_ as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_qname),
            "::",
            stringify!(mod_)
        )
    );
}
impl Default for lysp_qname {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_ident {
    pub name: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub bases: *mut *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysp_ext_instance,
    pub flags: u16,
}
#[test]
fn bindgen_test_layout_lysp_ident() {
    assert_eq!(
        ::std::mem::size_of::<lysp_ident>(),
        56usize,
        concat!("Size of: ", stringify!(lysp_ident))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_ident>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_ident))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ident>())).name as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ident),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ident>())).iffeatures as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ident),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ident>())).bases as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ident),
            "::",
            stringify!(bases)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ident>())).dsc as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ident),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ident>())).ref_ as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ident),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ident>())).exts as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ident),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_ident>())).flags as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_ident),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysp_ident {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_restr {
    pub arg: lysp_qname,
    pub emsg: *const ::std::os::raw::c_char,
    pub eapptag: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_restr() {
    assert_eq!(
        ::std::mem::size_of::<lysp_restr>(),
        56usize,
        concat!("Size of: ", stringify!(lysp_restr))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_restr>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_restr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_restr>())).arg as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_restr),
            "::",
            stringify!(arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_restr>())).emsg as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_restr),
            "::",
            stringify!(emsg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_restr>())).eapptag as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_restr),
            "::",
            stringify!(eapptag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_restr>())).dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_restr),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_restr>())).ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_restr),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_restr>())).exts as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_restr),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_restr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_revision {
    pub date: [::std::os::raw::c_char; 11usize],
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_revision() {
    assert_eq!(
        ::std::mem::size_of::<lysp_revision>(),
        40usize,
        concat!("Size of: ", stringify!(lysp_revision))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_revision>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_revision))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_revision>())).date as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_revision),
            "::",
            stringify!(date)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_revision>())).dsc as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_revision),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_revision>())).ref_ as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_revision),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_revision>())).exts as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_revision),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_revision {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_type_enum {
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub value: i64,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
    pub flags: u16,
}
#[test]
fn bindgen_test_layout_lysp_type_enum() {
    assert_eq!(
        ::std::mem::size_of::<lysp_type_enum>(),
        56usize,
        concat!("Size of: ", stringify!(lysp_type_enum))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_type_enum>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_type_enum))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type_enum>())).name as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type_enum),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type_enum>())).dsc as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type_enum),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type_enum>())).ref_ as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type_enum),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type_enum>())).value as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type_enum),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type_enum>())).iffeatures as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type_enum),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type_enum>())).exts as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type_enum),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type_enum>())).flags as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type_enum),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysp_type_enum {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_type {
    pub name: *const ::std::os::raw::c_char,
    pub range: *mut lysp_restr,
    pub length: *mut lysp_restr,
    pub patterns: *mut lysp_restr,
    pub enums: *mut lysp_type_enum,
    pub bits: *mut lysp_type_enum,
    pub path: *mut lyxp_expr,
    pub bases: *mut *const ::std::os::raw::c_char,
    pub types: *mut lysp_type,
    pub exts: *mut lysp_ext_instance,
    pub pmod: *const lysp_module,
    pub compiled: *mut lysc_type,
    pub fraction_digits: u8,
    pub require_instance: u8,
    pub flags: u16,
}
#[test]
fn bindgen_test_layout_lysp_type() {
    assert_eq!(
        ::std::mem::size_of::<lysp_type>(),
        104usize,
        concat!("Size of: ", stringify!(lysp_type))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_type>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_type))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).name as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).range as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(range)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).length as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).patterns as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(patterns)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).enums as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(enums)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).bits as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).path as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).bases as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(bases)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).types as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(types)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).exts as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).pmod as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(pmod)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).compiled as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(compiled)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).fraction_digits as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(fraction_digits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).require_instance as *const _
                as usize
        },
        97usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(require_instance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_type>())).flags as *const _ as usize
        },
        98usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_type),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysp_type {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_tpdf {
    pub name: *const ::std::os::raw::c_char,
    pub units: *const ::std::os::raw::c_char,
    pub dflt: lysp_qname,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysp_ext_instance,
    pub type_: lysp_type,
    pub flags: u16,
}
#[test]
fn bindgen_test_layout_lysp_tpdf() {
    assert_eq!(
        ::std::mem::size_of::<lysp_tpdf>(),
        168usize,
        concat!("Size of: ", stringify!(lysp_tpdf))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_tpdf>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_tpdf))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_tpdf>())).name as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_tpdf),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_tpdf>())).units as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_tpdf),
            "::",
            stringify!(units)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_tpdf>())).dflt as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_tpdf),
            "::",
            stringify!(dflt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_tpdf>())).dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_tpdf),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_tpdf>())).ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_tpdf),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_tpdf>())).exts as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_tpdf),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_tpdf>())).type_ as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_tpdf),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_tpdf>())).flags as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_tpdf),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysp_tpdf {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_when {
    pub cond: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_when() {
    assert_eq!(
        ::std::mem::size_of::<lysp_when>(),
        32usize,
        concat!("Size of: ", stringify!(lysp_when))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_when>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_when))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_when>())).cond as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_when),
            "::",
            stringify!(cond)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_when>())).dsc as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_when),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_when>())).ref_ as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_when),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_when>())).exts as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_when),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_when {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_refine {
    pub nodeid: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub musts: *mut lysp_restr,
    pub presence: *const ::std::os::raw::c_char,
    pub dflts: *mut lysp_qname,
    pub min: u32,
    pub max: u32,
    pub exts: *mut lysp_ext_instance,
    pub flags: u16,
}
#[test]
fn bindgen_test_layout_lysp_refine() {
    assert_eq!(
        ::std::mem::size_of::<lysp_refine>(),
        80usize,
        concat!("Size of: ", stringify!(lysp_refine))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_refine>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_refine))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).nodeid as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(nodeid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).dsc as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).ref_ as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).iffeatures as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).musts as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).presence as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(presence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).dflts as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(dflts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).min as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).max as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(max)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).exts as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_refine>())).flags as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_refine),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysp_refine {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_deviate {
    pub mod_: u8,
    pub next: *mut lysp_deviate,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_deviate() {
    assert_eq!(
        ::std::mem::size_of::<lysp_deviate>(),
        24usize,
        concat!("Size of: ", stringify!(lysp_deviate))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_deviate>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_deviate))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate>())).mod_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate),
            "::",
            stringify!(mod_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate>())).next as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate>())).exts as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_deviate {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_deviate_add {
    pub mod_: u8,
    pub next: *mut lysp_deviate,
    pub exts: *mut lysp_ext_instance,
    pub units: *const ::std::os::raw::c_char,
    pub musts: *mut lysp_restr,
    pub uniques: *mut lysp_qname,
    pub dflts: *mut lysp_qname,
    pub flags: u16,
    pub min: u32,
    pub max: u32,
}
#[test]
fn bindgen_test_layout_lysp_deviate_add() {
    assert_eq!(
        ::std::mem::size_of::<lysp_deviate_add>(),
        72usize,
        concat!("Size of: ", stringify!(lysp_deviate_add))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_deviate_add>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_deviate_add))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_add>())).mod_ as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_add),
            "::",
            stringify!(mod_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_add>())).next as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_add),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_add>())).exts as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_add),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_add>())).units as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_add),
            "::",
            stringify!(units)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_add>())).musts as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_add),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_add>())).uniques as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_add),
            "::",
            stringify!(uniques)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_add>())).dflts as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_add),
            "::",
            stringify!(dflts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_add>())).flags as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_add),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_add>())).min as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_add),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_add>())).max as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_add),
            "::",
            stringify!(max)
        )
    );
}
impl Default for lysp_deviate_add {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_deviate_del {
    pub mod_: u8,
    pub next: *mut lysp_deviate,
    pub exts: *mut lysp_ext_instance,
    pub units: *const ::std::os::raw::c_char,
    pub musts: *mut lysp_restr,
    pub uniques: *mut lysp_qname,
    pub dflts: *mut lysp_qname,
}
#[test]
fn bindgen_test_layout_lysp_deviate_del() {
    assert_eq!(
        ::std::mem::size_of::<lysp_deviate_del>(),
        56usize,
        concat!("Size of: ", stringify!(lysp_deviate_del))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_deviate_del>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_deviate_del))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_del>())).mod_ as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_del),
            "::",
            stringify!(mod_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_del>())).next as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_del),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_del>())).exts as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_del),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_del>())).units as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_del),
            "::",
            stringify!(units)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_del>())).musts as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_del),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_del>())).uniques as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_del),
            "::",
            stringify!(uniques)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_del>())).dflts as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_del),
            "::",
            stringify!(dflts)
        )
    );
}
impl Default for lysp_deviate_del {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_deviate_rpl {
    pub mod_: u8,
    pub next: *mut lysp_deviate,
    pub exts: *mut lysp_ext_instance,
    pub type_: *mut lysp_type,
    pub units: *const ::std::os::raw::c_char,
    pub dflt: lysp_qname,
    pub flags: u16,
    pub min: u32,
    pub max: u32,
}
#[test]
fn bindgen_test_layout_lysp_deviate_rpl() {
    assert_eq!(
        ::std::mem::size_of::<lysp_deviate_rpl>(),
        72usize,
        concat!("Size of: ", stringify!(lysp_deviate_rpl))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_deviate_rpl>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_deviate_rpl))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_rpl>())).mod_ as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_rpl),
            "::",
            stringify!(mod_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_rpl>())).next as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_rpl),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_rpl>())).exts as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_rpl),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_rpl>())).type_ as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_rpl),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_rpl>())).units as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_rpl),
            "::",
            stringify!(units)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_rpl>())).dflt as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_rpl),
            "::",
            stringify!(dflt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_rpl>())).flags as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_rpl),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_rpl>())).min as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_rpl),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviate_rpl>())).max as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviate_rpl),
            "::",
            stringify!(max)
        )
    );
}
impl Default for lysp_deviate_rpl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_deviation {
    pub nodeid: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub deviates: *mut lysp_deviate,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_deviation() {
    assert_eq!(
        ::std::mem::size_of::<lysp_deviation>(),
        40usize,
        concat!("Size of: ", stringify!(lysp_deviation))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_deviation>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_deviation))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviation>())).nodeid as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviation),
            "::",
            stringify!(nodeid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviation>())).dsc as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviation),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviation>())).ref_ as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviation),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviation>())).deviates as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviation),
            "::",
            stringify!(deviates)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_deviation>())).exts as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_deviation),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_deviation {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node>())).parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node>())).nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node>())).flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node>())).next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node>())).name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node>())).dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node>())).ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node>())).iffeatures as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node>())).exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_container {
    pub __bindgen_anon_1: lysp_node_container__bindgen_ty_1,
    pub musts: *mut lysp_restr,
    pub when: *mut lysp_when,
    pub presence: *const ::std::os::raw::c_char,
    pub typedefs: *mut lysp_tpdf,
    pub groupings: *mut lysp_node_grp,
    pub child: *mut lysp_node,
    pub actions: *mut lysp_node_action,
    pub notifs: *mut lysp_node_notif,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_container__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_container__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_container__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_container__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_container__bindgen_ty_1__bindgen_ty_1>(
        ),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_container__bindgen_ty_1__bindgen_ty_1>(
        ),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_container__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_container__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_container__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_container__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_container__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_container__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_container__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_container__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_container() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_container>(),
        128usize,
        concat!("Size of: ", stringify!(lysp_node_container))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_container>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_container))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_container>())).musts as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_container>())).when as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_container>())).presence as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container),
            "::",
            stringify!(presence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_container>())).typedefs as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container),
            "::",
            stringify!(typedefs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_container>())).groupings
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container),
            "::",
            stringify!(groupings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_container>())).child as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_container>())).actions as *const _
                as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container),
            "::",
            stringify!(actions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_container>())).notifs as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_container),
            "::",
            stringify!(notifs)
        )
    );
}
impl Default for lysp_node_container {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_leaf {
    pub __bindgen_anon_1: lysp_node_leaf__bindgen_ty_1,
    pub musts: *mut lysp_restr,
    pub when: *mut lysp_when,
    pub type_: lysp_type,
    pub units: *const ::std::os::raw::c_char,
    pub dflt: lysp_qname,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_leaf__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_leaf__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_leaf__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_leaf__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_leaf__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_leaf__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_leaf__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_leaf__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_leaf__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_leaf__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_leaf__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_leaf() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_leaf>(),
        208usize,
        concat!("Size of: ", stringify!(lysp_node_leaf))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_leaf>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_leaf))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf>())).musts as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf>())).when as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf>())).type_ as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf>())).units as *const _
                as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf),
            "::",
            stringify!(units)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaf>())).dflt as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaf),
            "::",
            stringify!(dflt)
        )
    );
}
impl Default for lysp_node_leaf {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_leaflist {
    pub __bindgen_anon_1: lysp_node_leaflist__bindgen_ty_1,
    pub musts: *mut lysp_restr,
    pub when: *mut lysp_when,
    pub type_: lysp_type,
    pub units: *const ::std::os::raw::c_char,
    pub dflts: *mut lysp_qname,
    pub min: u32,
    pub max: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_leaflist__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1>(
        ),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_leaflist__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_leaflist__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_leaflist__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_leaflist__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_leaflist__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_leaflist__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaflist__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_leaflist__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_leaflist() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_leaflist>(),
        208usize,
        concat!("Size of: ", stringify!(lysp_node_leaflist))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_leaflist>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_leaflist))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaflist>())).musts as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaflist>())).when as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaflist>())).type_ as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaflist>())).units as *const _
                as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist),
            "::",
            stringify!(units)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaflist>())).dflts as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist),
            "::",
            stringify!(dflts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaflist>())).min as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_leaflist>())).max as *const _
                as usize
        },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_leaflist),
            "::",
            stringify!(max)
        )
    );
}
impl Default for lysp_node_leaflist {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_list {
    pub __bindgen_anon_1: lysp_node_list__bindgen_ty_1,
    pub musts: *mut lysp_restr,
    pub when: *mut lysp_when,
    pub key: *const ::std::os::raw::c_char,
    pub typedefs: *mut lysp_tpdf,
    pub groupings: *mut lysp_node_grp,
    pub child: *mut lysp_node,
    pub actions: *mut lysp_node_action,
    pub notifs: *mut lysp_node_notif,
    pub uniques: *mut lysp_qname,
    pub min: u32,
    pub max: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_list__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_list__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_list__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_list__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_list__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_list__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_list__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_list__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_list__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_list__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_list__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_list() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_list>(),
        144usize,
        concat!("Size of: ", stringify!(lysp_node_list))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_list>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_list))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).musts as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).when as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).key as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).typedefs as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(typedefs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).groupings as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(groupings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).child as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).actions as *const _
                as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(actions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).notifs as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(notifs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).uniques as *const _
                as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(uniques)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).min as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_list>())).max as *const _ as usize
        },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_list),
            "::",
            stringify!(max)
        )
    );
}
impl Default for lysp_node_list {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_choice {
    pub __bindgen_anon_1: lysp_node_choice__bindgen_ty_1,
    pub child: *mut lysp_node,
    pub when: *mut lysp_when,
    pub dflt: lysp_qname,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_choice__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_choice__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_choice__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_choice__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_choice__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_choice__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . parent as * const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . nodetype as * const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . flags as * const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . next as * const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . name as * const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . dsc as * const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . ref_ as * const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . iffeatures as * const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . exts as * const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_choice__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_choice__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_choice__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_choice__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_choice__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_choice__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_choice__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_choice__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_choice() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_choice>(),
        96usize,
        concat!("Size of: ", stringify!(lysp_node_choice))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_choice>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_choice))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_choice>())).child as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_choice>())).when as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_choice>())).dflt as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_choice),
            "::",
            stringify!(dflt)
        )
    );
}
impl Default for lysp_node_choice {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_case {
    pub __bindgen_anon_1: lysp_node_case__bindgen_ty_1,
    pub child: *mut lysp_node,
    pub when: *mut lysp_when,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_case__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_case__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_case__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_case__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_case__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_case__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_case__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_case__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_case__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_case__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_case__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_case() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_case>(),
        80usize,
        concat!("Size of: ", stringify!(lysp_node_case))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_case>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_case))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case>())).child as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_case>())).when as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_case),
            "::",
            stringify!(when)
        )
    );
}
impl Default for lysp_node_case {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_anydata {
    pub __bindgen_anon_1: lysp_node_anydata__bindgen_ty_1,
    pub musts: *mut lysp_restr,
    pub when: *mut lysp_when,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_anydata__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_anydata__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_anydata__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_anydata__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_anydata__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_anydata__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_anydata__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_anydata__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_anydata__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_anydata__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_anydata__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_anydata__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_anydata__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_anydata__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_anydata() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_anydata>(),
        80usize,
        concat!("Size of: ", stringify!(lysp_node_anydata))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_anydata>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_anydata))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_anydata>())).musts as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_anydata>())).when as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_anydata),
            "::",
            stringify!(when)
        )
    );
}
impl Default for lysp_node_anydata {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_uses {
    pub __bindgen_anon_1: lysp_node_uses__bindgen_ty_1,
    pub refines: *mut lysp_refine,
    pub augments: *mut lysp_node_augment,
    pub when: *mut lysp_when,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_uses__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_uses__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_uses__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_uses__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(
            )))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(
            )))
            .name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(
            )))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(
            )))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(
            )))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses__bindgen_ty_1__bindgen_ty_1>(
            )))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_uses__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_uses__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_uses__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_uses__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_uses__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_uses__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_uses__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_uses() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_uses>(),
        88usize,
        concat!("Size of: ", stringify!(lysp_node_uses))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_uses>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_uses))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses>())).refines as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses),
            "::",
            stringify!(refines)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses>())).augments as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses),
            "::",
            stringify!(augments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_uses>())).when as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_uses),
            "::",
            stringify!(when)
        )
    );
}
impl Default for lysp_node_uses {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_action_inout {
    pub __bindgen_anon_1: lysp_node_action_inout__bindgen_ty_1,
    pub musts: *mut lysp_restr,
    pub typedefs: *mut lysp_tpdf,
    pub groupings: *mut lysp_node_grp,
    pub child: *mut lysp_node,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_action_inout__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1>(
        ),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<
            lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
        >(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_action_inout__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_action_inout__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_action_inout__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_action_inout__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_action_inout__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_action_inout__bindgen_ty_1>()))
                .node as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_action_inout__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_action_inout() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_action_inout>(),
        96usize,
        concat!("Size of: ", stringify!(lysp_node_action_inout))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_action_inout>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_action_inout))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_action_inout>())).musts as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_action_inout>())).typedefs
                as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout),
            "::",
            stringify!(typedefs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_action_inout>())).groupings
                as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout),
            "::",
            stringify!(groupings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_action_inout>())).child as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action_inout),
            "::",
            stringify!(child)
        )
    );
}
impl Default for lysp_node_action_inout {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_action {
    pub __bindgen_anon_1: lysp_node_action__bindgen_ty_1,
    pub typedefs: *mut lysp_tpdf,
    pub groupings: *mut lysp_node_grp,
    pub input: lysp_node_action_inout,
    pub output: lysp_node_action_inout,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_action__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_action__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_action__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node_action,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_action__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_action__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_action__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . parent as * const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . nodetype as * const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . flags as * const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . next as * const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . name as * const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . dsc as * const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . ref_ as * const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . iffeatures as * const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysp_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . exts as * const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_action__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_action__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_action__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_action__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_action__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_action__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_action__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_action__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_action() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_action>(),
        272usize,
        concat!("Size of: ", stringify!(lysp_node_action))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_action>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_action))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_action>())).typedefs as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action),
            "::",
            stringify!(typedefs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_action>())).groupings as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action),
            "::",
            stringify!(groupings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_action>())).input as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_action>())).output as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_action),
            "::",
            stringify!(output)
        )
    );
}
impl Default for lysp_node_action {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_notif {
    pub __bindgen_anon_1: lysp_node_notif__bindgen_ty_1,
    pub musts: *mut lysp_restr,
    pub typedefs: *mut lysp_tpdf,
    pub groupings: *mut lysp_node_grp,
    pub child: *mut lysp_node,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_notif__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_notif__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_notif__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node_notif,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_notif__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_notif__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_notif__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_notif__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_notif__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_notif__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_notif__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_notif__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_notif() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_notif>(),
        96usize,
        concat!("Size of: ", stringify!(lysp_node_notif))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_notif>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_notif))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif>())).musts as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif>())).typedefs as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif),
            "::",
            stringify!(typedefs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif>())).groupings as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif),
            "::",
            stringify!(groupings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_notif>())).child as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_notif),
            "::",
            stringify!(child)
        )
    );
}
impl Default for lysp_node_notif {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_grp {
    pub __bindgen_anon_1: lysp_node_grp__bindgen_ty_1,
    pub typedefs: *mut lysp_tpdf,
    pub groupings: *mut lysp_node_grp,
    pub child: *mut lysp_node,
    pub actions: *mut lysp_node_action,
    pub notifs: *mut lysp_node_notif,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_grp__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_grp__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_grp__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node_grp,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_grp__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(
            )))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(
            )))
            .name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(
            )))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(
            )))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(
            )))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp__bindgen_ty_1__bindgen_ty_1>(
            )))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_grp__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_grp__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_grp__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_grp__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_grp__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_grp__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_grp__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_grp() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_grp>(),
        104usize,
        concat!("Size of: ", stringify!(lysp_node_grp))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_grp>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_grp))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp>())).typedefs as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp),
            "::",
            stringify!(typedefs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp>())).groupings as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp),
            "::",
            stringify!(groupings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp>())).child as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp>())).actions as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp),
            "::",
            stringify!(actions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_grp>())).notifs as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_grp),
            "::",
            stringify!(notifs)
        )
    );
}
impl Default for lysp_node_grp {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysp_node_augment {
    pub __bindgen_anon_1: lysp_node_augment__bindgen_ty_1,
    pub child: *mut lysp_node,
    pub when: *mut lysp_when,
    pub actions: *mut lysp_node_action,
    pub notifs: *mut lysp_node_notif,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysp_node_augment__bindgen_ty_1 {
    pub node: lysp_node,
    pub __bindgen_anon_1: lysp_node_augment__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_node_augment__bindgen_ty_1__bindgen_ty_1 {
    pub parent: *mut lysp_node,
    pub nodetype: u16,
    pub flags: u16,
    pub next: *mut lysp_node_augment,
    pub nodeid: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub iffeatures: *mut lysp_qname,
    pub exts: *mut lysp_ext_instance,
}
#[test]
fn bindgen_test_layout_lysp_node_augment__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_augment__bindgen_ty_1__bindgen_ty_1>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_augment__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_augment__bindgen_ty_1__bindgen_ty_1,
            >()))
            .parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_augment__bindgen_ty_1__bindgen_ty_1,
            >()))
            .nodetype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_augment__bindgen_ty_1__bindgen_ty_1,
            >()))
            .flags as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_augment__bindgen_ty_1__bindgen_ty_1,
            >()))
            .next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_augment__bindgen_ty_1__bindgen_ty_1,
            >()))
            .nodeid as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodeid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_augment__bindgen_ty_1__bindgen_ty_1,
            >()))
            .dsc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_augment__bindgen_ty_1__bindgen_ty_1,
            >()))
            .ref_ as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_augment__bindgen_ty_1__bindgen_ty_1,
            >()))
            .iffeatures as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(iffeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysp_node_augment__bindgen_ty_1__bindgen_ty_1,
            >()))
            .exts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysp_node_augment__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_augment__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_augment__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(lysp_node_augment__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_augment__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_augment__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_augment__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysp_node_augment__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysp_node_augment() {
    assert_eq!(
        ::std::mem::size_of::<lysp_node_augment>(),
        96usize,
        concat!("Size of: ", stringify!(lysp_node_augment))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_node_augment>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_node_augment))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_augment>())).child as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_augment>())).when as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_augment>())).actions as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment),
            "::",
            stringify!(actions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_node_augment>())).notifs as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_node_augment),
            "::",
            stringify!(notifs)
        )
    );
}
impl Default for lysp_node_augment {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub mod LYS_VERSION {
    pub type Type = ::std::os::raw::c_uint;
    pub const LYS_VERSION_UNDEF: Type = 0;
    pub const LYS_VERSION_1_0: Type = 1;
    pub const LYS_VERSION_1_1: Type = 2;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_module {
    pub mod_: *mut lys_module,
    pub revs: *mut lysp_revision,
    pub imports: *mut lysp_import,
    pub includes: *mut lysp_include,
    pub extensions: *mut lysp_ext,
    pub features: *mut lysp_feature,
    pub identities: *mut lysp_ident,
    pub typedefs: *mut lysp_tpdf,
    pub groupings: *mut lysp_node_grp,
    pub data: *mut lysp_node,
    pub augments: *mut lysp_node_augment,
    pub rpcs: *mut lysp_node_action,
    pub notifs: *mut lysp_node_notif,
    pub deviations: *mut lysp_deviation,
    pub exts: *mut lysp_ext_instance,
    pub version: u8,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub __bindgen_padding_0: [u16; 3usize],
}
#[test]
fn bindgen_test_layout_lysp_module() {
    assert_eq!(
        ::std::mem::size_of::<lysp_module>(),
        128usize,
        concat!("Size of: ", stringify!(lysp_module))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_module>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_module))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).mod_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(mod_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).revs as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(revs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).imports as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(imports)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).includes as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(includes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).extensions as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(extensions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).features as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(features)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).identities as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(identities)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).typedefs as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(typedefs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).groupings as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(groupings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).data as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).augments as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(augments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).rpcs as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(rpcs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).notifs as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(notifs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).deviations as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(deviations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).exts as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_module>())).version as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_module),
            "::",
            stringify!(version)
        )
    );
}
impl Default for lysp_module {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl lysp_module {
    #[inline]
    pub fn parsing(&self) -> u8 {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8)
        }
    }
    #[inline]
    pub fn set_parsing(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_submod(&self) -> u8 {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8)
        }
    }
    #[inline]
    pub fn set_is_submod(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        parsing: u8,
        is_submod: u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<
            [u8; 1usize],
            u8,
        > = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let parsing: u8 = unsafe { ::std::mem::transmute(parsing) };
            parsing as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_submod: u8 = unsafe { ::std::mem::transmute(is_submod) };
            is_submod as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysp_submodule {
    pub mod_: *mut lys_module,
    pub revs: *mut lysp_revision,
    pub imports: *mut lysp_import,
    pub includes: *mut lysp_include,
    pub extensions: *mut lysp_ext,
    pub features: *mut lysp_feature,
    pub identities: *mut lysp_ident,
    pub typedefs: *mut lysp_tpdf,
    pub groupings: *mut lysp_node_grp,
    pub data: *mut lysp_node,
    pub augments: *mut lysp_node_augment,
    pub rpcs: *mut lysp_node_action,
    pub notifs: *mut lysp_node_notif,
    pub deviations: *mut lysp_deviation,
    pub exts: *mut lysp_ext_instance,
    pub version: u8,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub name: *const ::std::os::raw::c_char,
    pub filepath: *const ::std::os::raw::c_char,
    pub prefix: *const ::std::os::raw::c_char,
    pub org: *const ::std::os::raw::c_char,
    pub contact: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_lysp_submodule() {
    assert_eq!(
        ::std::mem::size_of::<lysp_submodule>(),
        184usize,
        concat!("Size of: ", stringify!(lysp_submodule))
    );
    assert_eq!(
        ::std::mem::align_of::<lysp_submodule>(),
        8usize,
        concat!("Alignment of ", stringify!(lysp_submodule))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).mod_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(mod_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).revs as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(revs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).imports as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(imports)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).includes as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(includes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).extensions as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(extensions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).features as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(features)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).identities as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(identities)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).typedefs as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(typedefs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).groupings as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(groupings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).data as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).augments as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(augments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).rpcs as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(rpcs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).notifs as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(notifs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).deviations as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(deviations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).exts as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).version as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).name as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).filepath as *const _
                as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(filepath)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).prefix as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(prefix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).org as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(org)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).contact as *const _
                as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(contact)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).dsc as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysp_submodule>())).ref_ as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(lysp_submodule),
            "::",
            stringify!(ref_)
        )
    );
}
impl Default for lysp_submodule {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl lysp_submodule {
    #[inline]
    pub fn parsing(&self) -> u8 {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8)
        }
    }
    #[inline]
    pub fn set_parsing(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_submod(&self) -> u8 {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8)
        }
    }
    #[inline]
    pub fn set_is_submod(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn latest_revision(&self) -> u8 {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u8)
        }
    }
    #[inline]
    pub fn set_latest_revision(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        parsing: u8,
        is_submod: u8,
        latest_revision: u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<
            [u8; 1usize],
            u8,
        > = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let parsing: u8 = unsafe { ::std::mem::transmute(parsing) };
            parsing as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_submod: u8 = unsafe { ::std::mem::transmute(is_submod) };
            is_submod as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let latest_revision: u8 =
                unsafe { ::std::mem::transmute(latest_revision) };
            latest_revision as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_prefix {
    pub prefix: *mut ::std::os::raw::c_char,
    pub mod_: *const lys_module,
}
#[test]
fn bindgen_test_layout_lysc_prefix() {
    assert_eq!(
        ::std::mem::size_of::<lysc_prefix>(),
        16usize,
        concat!("Size of: ", stringify!(lysc_prefix))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_prefix>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_prefix))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_prefix>())).prefix as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_prefix),
            "::",
            stringify!(prefix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_prefix>())).mod_ as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_prefix),
            "::",
            stringify!(mod_)
        )
    );
}
impl Default for lysc_prefix {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_ext {
    pub name: *const ::std::os::raw::c_char,
    pub argname: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_ext,
    pub module: *mut lys_module,
    pub refcount: u32,
    pub flags: u16,
}
#[test]
fn bindgen_test_layout_lysc_ext() {
    assert_eq!(
        ::std::mem::size_of::<lysc_ext>(),
        48usize,
        concat!("Size of: ", stringify!(lysc_ext))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_ext>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_ext))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext>())).name as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext>())).argname as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext),
            "::",
            stringify!(argname)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext>())).exts as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext>())).plugin as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext>())).module as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext>())).refcount as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext>())).flags as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysc_ext {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_ext_substmt {
    pub stmt: ly_stmt::Type,
    pub cardinality: ly_stmt_cardinality::Type,
    pub storage: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_ext_substmt() {
    assert_eq!(
        ::std::mem::size_of::<lysc_ext_substmt>(),
        16usize,
        concat!("Size of: ", stringify!(lysc_ext_substmt))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_ext_substmt>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_ext_substmt))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_substmt>())).stmt as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_substmt),
            "::",
            stringify!(stmt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_substmt>())).cardinality as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_substmt),
            "::",
            stringify!(cardinality)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_substmt>())).storage as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_substmt),
            "::",
            stringify!(storage)
        )
    );
}
impl Default for lysc_ext_substmt {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_ext_instance {
    pub def: *mut lysc_ext,
    pub argument: *const ::std::os::raw::c_char,
    pub module: *mut lys_module,
    pub exts: *mut lysc_ext_instance,
    pub substmts: *mut lysc_ext_substmt,
    pub data: *mut ::std::os::raw::c_void,
    pub parent: *mut ::std::os::raw::c_void,
    pub parent_stmt: ly_stmt::Type,
    pub parent_stmt_index: u64,
}
#[test]
fn bindgen_test_layout_lysc_ext_instance() {
    assert_eq!(
        ::std::mem::size_of::<lysc_ext_instance>(),
        72usize,
        concat!("Size of: ", stringify!(lysc_ext_instance))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_ext_instance>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_ext_instance))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_instance>())).def as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_instance),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_instance>())).argument as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_instance),
            "::",
            stringify!(argument)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_instance>())).module as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_instance),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_instance>())).exts as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_instance),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_instance>())).substmts as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_instance),
            "::",
            stringify!(substmts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_instance>())).data as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_instance),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_instance>())).parent as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_instance),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_instance>())).parent_stmt
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_instance),
            "::",
            stringify!(parent_stmt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ext_instance>())).parent_stmt_index
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ext_instance),
            "::",
            stringify!(parent_stmt_index)
        )
    );
}
impl Default for lysc_ext_instance {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_when {
    pub cond: *mut lyxp_expr,
    pub context: *mut lysc_node,
    pub prefixes: *mut lysc_prefix,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub refcount: u32,
    pub flags: u16,
}
#[test]
fn bindgen_test_layout_lysc_when() {
    assert_eq!(
        ::std::mem::size_of::<lysc_when>(),
        56usize,
        concat!("Size of: ", stringify!(lysc_when))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_when>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_when))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_when>())).cond as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_when),
            "::",
            stringify!(cond)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_when>())).context as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_when),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_when>())).prefixes as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_when),
            "::",
            stringify!(prefixes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_when>())).dsc as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_when),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_when>())).ref_ as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_when),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_when>())).exts as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_when),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_when>())).refcount as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_when),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_when>())).flags as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_when),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysc_when {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_ident {
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub module: *mut lys_module,
    pub derived: *mut *mut lysc_ident,
    pub exts: *mut lysc_ext_instance,
    pub flags: u16,
}
#[test]
fn bindgen_test_layout_lysc_ident() {
    assert_eq!(
        ::std::mem::size_of::<lysc_ident>(),
        56usize,
        concat!("Size of: ", stringify!(lysc_ident))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_ident>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_ident))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ident>())).name as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ident),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ident>())).dsc as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ident),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ident>())).ref_ as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ident),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ident>())).module as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ident),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ident>())).derived as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ident),
            "::",
            stringify!(derived)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ident>())).exts as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ident),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_ident>())).flags as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_ident),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysc_ident {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_revision {
    pub date: [::std::os::raw::c_char; 11usize],
    pub exts: *mut lysc_ext_instance,
}
#[test]
fn bindgen_test_layout_lysc_revision() {
    assert_eq!(
        ::std::mem::size_of::<lysc_revision>(),
        24usize,
        concat!("Size of: ", stringify!(lysc_revision))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_revision>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_revision))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_revision>())).date as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_revision),
            "::",
            stringify!(date)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_revision>())).exts as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_revision),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysc_revision {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_range {
    pub parts: *mut lysc_range_lysc_range_part,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub emsg: *const ::std::os::raw::c_char,
    pub eapptag: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_range_lysc_range_part {
    pub __bindgen_anon_1: lysc_range_lysc_range_part__bindgen_ty_1,
    pub __bindgen_anon_2: lysc_range_lysc_range_part__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_range_lysc_range_part__bindgen_ty_1 {
    pub min_64: i64,
    pub min_u64: u64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_lysc_range_lysc_range_part__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_range_lysc_range_part__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(lysc_range_lysc_range_part__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_range_lysc_range_part__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_range_lysc_range_part__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_range_lysc_range_part__bindgen_ty_1>()))
                .min_64 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_range_lysc_range_part__bindgen_ty_1),
            "::",
            stringify!(min_64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_range_lysc_range_part__bindgen_ty_1>()))
                .min_u64 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_range_lysc_range_part__bindgen_ty_1),
            "::",
            stringify!(min_u64)
        )
    );
}
impl Default for lysc_range_lysc_range_part__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_range_lysc_range_part__bindgen_ty_2 {
    pub max_64: i64,
    pub max_u64: u64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_lysc_range_lysc_range_part__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<lysc_range_lysc_range_part__bindgen_ty_2>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(lysc_range_lysc_range_part__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_range_lysc_range_part__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_range_lysc_range_part__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_range_lysc_range_part__bindgen_ty_2>()))
                .max_64 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_range_lysc_range_part__bindgen_ty_2),
            "::",
            stringify!(max_64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_range_lysc_range_part__bindgen_ty_2>()))
                .max_u64 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_range_lysc_range_part__bindgen_ty_2),
            "::",
            stringify!(max_u64)
        )
    );
}
impl Default for lysc_range_lysc_range_part__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_range_lysc_range_part() {
    assert_eq!(
        ::std::mem::size_of::<lysc_range_lysc_range_part>(),
        16usize,
        concat!("Size of: ", stringify!(lysc_range_lysc_range_part))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_range_lysc_range_part>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_range_lysc_range_part))
    );
}
impl Default for lysc_range_lysc_range_part {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_range() {
    assert_eq!(
        ::std::mem::size_of::<lysc_range>(),
        48usize,
        concat!("Size of: ", stringify!(lysc_range))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_range>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_range))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_range>())).parts as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_range),
            "::",
            stringify!(parts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_range>())).dsc as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_range),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_range>())).ref_ as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_range),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_range>())).emsg as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_range),
            "::",
            stringify!(emsg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_range>())).eapptag as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_range),
            "::",
            stringify!(eapptag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_range>())).exts as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_range),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysc_range {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_pattern {
    pub expr: *const ::std::os::raw::c_char,
    pub code: *mut pcre2_code_8,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub emsg: *const ::std::os::raw::c_char,
    pub eapptag: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub __bindgen_padding_0: u32,
}
#[test]
fn bindgen_test_layout_lysc_pattern() {
    assert_eq!(
        ::std::mem::size_of::<lysc_pattern>(),
        64usize,
        concat!("Size of: ", stringify!(lysc_pattern))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_pattern>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_pattern))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_pattern>())).expr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_pattern),
            "::",
            stringify!(expr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_pattern>())).code as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_pattern),
            "::",
            stringify!(code)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_pattern>())).dsc as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_pattern),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_pattern>())).ref_ as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_pattern),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_pattern>())).emsg as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_pattern),
            "::",
            stringify!(emsg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_pattern>())).eapptag as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_pattern),
            "::",
            stringify!(eapptag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_pattern>())).exts as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_pattern),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysc_pattern {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl lysc_pattern {
    #[inline]
    pub fn inverted(&self) -> u32 {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32)
        }
    }
    #[inline]
    pub fn set_inverted(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn refcount(&self) -> u32 {
        unsafe {
            ::std::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32)
        }
    }
    #[inline]
    pub fn set_refcount(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        inverted: u32,
        refcount: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<
            [u8; 4usize],
            u32,
        > = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let inverted: u32 = unsafe { ::std::mem::transmute(inverted) };
            inverted as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let refcount: u32 = unsafe { ::std::mem::transmute(refcount) };
            refcount as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_must {
    pub cond: *mut lyxp_expr,
    pub prefixes: *mut lysc_prefix,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub emsg: *const ::std::os::raw::c_char,
    pub eapptag: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
}
#[test]
fn bindgen_test_layout_lysc_must() {
    assert_eq!(
        ::std::mem::size_of::<lysc_must>(),
        56usize,
        concat!("Size of: ", stringify!(lysc_must))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_must>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_must))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_must>())).cond as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_must),
            "::",
            stringify!(cond)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_must>())).prefixes as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_must),
            "::",
            stringify!(prefixes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_must>())).dsc as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_must),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_must>())).ref_ as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_must),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_must>())).emsg as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_must),
            "::",
            stringify!(emsg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_must>())).eapptag as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_must),
            "::",
            stringify!(eapptag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_must>())).exts as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_must),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysc_must {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
}
#[test]
fn bindgen_test_layout_lysc_type() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type>(),
        24usize,
        concat!("Size of: ", stringify!(lysc_type))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type>())).exts as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type>())).plugin as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type>())).basetype as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type>())).refcount as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type),
            "::",
            stringify!(refcount)
        )
    );
}
impl Default for lysc_type {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type_num {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
    pub range: *mut lysc_range,
}
#[test]
fn bindgen_test_layout_lysc_type_num() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_num>(),
        32usize,
        concat!("Size of: ", stringify!(lysc_type_num))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_num>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_num))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_num>())).exts as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_num),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_num>())).plugin as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_num),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_num>())).basetype as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_num),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_num>())).refcount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_num),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_num>())).range as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_num),
            "::",
            stringify!(range)
        )
    );
}
impl Default for lysc_type_num {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type_dec {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
    pub fraction_digits: u8,
    pub range: *mut lysc_range,
}
#[test]
fn bindgen_test_layout_lysc_type_dec() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_dec>(),
        40usize,
        concat!("Size of: ", stringify!(lysc_type_dec))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_dec>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_dec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_dec>())).exts as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_dec),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_dec>())).plugin as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_dec),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_dec>())).basetype as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_dec),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_dec>())).refcount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_dec),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_dec>())).fraction_digits
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_dec),
            "::",
            stringify!(fraction_digits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_dec>())).range as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_dec),
            "::",
            stringify!(range)
        )
    );
}
impl Default for lysc_type_dec {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type_str {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
    pub length: *mut lysc_range,
    pub patterns: *mut *mut lysc_pattern,
}
#[test]
fn bindgen_test_layout_lysc_type_str() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_str>(),
        40usize,
        concat!("Size of: ", stringify!(lysc_type_str))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_str>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_str))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_str>())).exts as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_str),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_str>())).plugin as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_str),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_str>())).basetype as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_str),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_str>())).refcount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_str),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_str>())).length as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_str),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_str>())).patterns as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_str),
            "::",
            stringify!(patterns)
        )
    );
}
impl Default for lysc_type_str {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_type_bitenum_item {
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub __bindgen_anon_1: lysc_type_bitenum_item__bindgen_ty_1,
    pub flags: u16,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_type_bitenum_item__bindgen_ty_1 {
    pub value: i32,
    pub position: u32,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_lysc_type_bitenum_item__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_bitenum_item__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(lysc_type_bitenum_item__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_bitenum_item__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_type_bitenum_item__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bitenum_item__bindgen_ty_1>()))
                .value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bitenum_item__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bitenum_item__bindgen_ty_1>()))
                .position as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bitenum_item__bindgen_ty_1),
            "::",
            stringify!(position)
        )
    );
}
impl Default for lysc_type_bitenum_item__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_type_bitenum_item() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_bitenum_item>(),
        40usize,
        concat!("Size of: ", stringify!(lysc_type_bitenum_item))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_bitenum_item>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_bitenum_item))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bitenum_item>())).name as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bitenum_item),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bitenum_item>())).dsc as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bitenum_item),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bitenum_item>())).ref_ as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bitenum_item),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bitenum_item>())).exts as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bitenum_item),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bitenum_item>())).flags as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bitenum_item),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for lysc_type_bitenum_item {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type_enum {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
    pub enums: *mut lysc_type_bitenum_item,
}
#[test]
fn bindgen_test_layout_lysc_type_enum() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_enum>(),
        32usize,
        concat!("Size of: ", stringify!(lysc_type_enum))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_enum>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_enum))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_enum>())).exts as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_enum),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_enum>())).plugin as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_enum),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_enum>())).basetype as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_enum),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_enum>())).refcount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_enum),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_enum>())).enums as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_enum),
            "::",
            stringify!(enums)
        )
    );
}
impl Default for lysc_type_enum {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type_bits {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
    pub bits: *mut lysc_type_bitenum_item,
}
#[test]
fn bindgen_test_layout_lysc_type_bits() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_bits>(),
        32usize,
        concat!("Size of: ", stringify!(lysc_type_bits))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_bits>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_bits))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bits>())).exts as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bits),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bits>())).plugin as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bits),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bits>())).basetype as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bits),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bits>())).refcount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bits),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bits>())).bits as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bits),
            "::",
            stringify!(bits)
        )
    );
}
impl Default for lysc_type_bits {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type_leafref {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
    pub path: *mut lyxp_expr,
    pub prefixes: *mut lysc_prefix,
    pub cur_mod: *const lys_module,
    pub realtype: *mut lysc_type,
    pub require_instance: u8,
}
#[test]
fn bindgen_test_layout_lysc_type_leafref() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_leafref>(),
        64usize,
        concat!("Size of: ", stringify!(lysc_type_leafref))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_leafref>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_leafref))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_leafref>())).exts as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_leafref),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_leafref>())).plugin as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_leafref),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_leafref>())).basetype as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_leafref),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_leafref>())).refcount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_leafref),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_leafref>())).path as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_leafref),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_leafref>())).prefixes as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_leafref),
            "::",
            stringify!(prefixes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_leafref>())).cur_mod as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_leafref),
            "::",
            stringify!(cur_mod)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_leafref>())).realtype as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_leafref),
            "::",
            stringify!(realtype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_leafref>())).require_instance
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_leafref),
            "::",
            stringify!(require_instance)
        )
    );
}
impl Default for lysc_type_leafref {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type_identityref {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
    pub bases: *mut *mut lysc_ident,
}
#[test]
fn bindgen_test_layout_lysc_type_identityref() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_identityref>(),
        32usize,
        concat!("Size of: ", stringify!(lysc_type_identityref))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_identityref>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_identityref))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_identityref>())).exts as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_identityref),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_identityref>())).plugin as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_identityref),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_identityref>())).basetype
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_identityref),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_identityref>())).refcount
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_identityref),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_identityref>())).bases as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_identityref),
            "::",
            stringify!(bases)
        )
    );
}
impl Default for lysc_type_identityref {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type_instanceid {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
    pub require_instance: u8,
}
#[test]
fn bindgen_test_layout_lysc_type_instanceid() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_instanceid>(),
        32usize,
        concat!("Size of: ", stringify!(lysc_type_instanceid))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_instanceid>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_instanceid))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_instanceid>())).exts as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_instanceid),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_instanceid>())).plugin as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_instanceid),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_instanceid>())).basetype
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_instanceid),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_instanceid>())).refcount
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_instanceid),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_instanceid>())).require_instance
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_instanceid),
            "::",
            stringify!(require_instance)
        )
    );
}
impl Default for lysc_type_instanceid {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type_union {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
    pub types: *mut *mut lysc_type,
}
#[test]
fn bindgen_test_layout_lysc_type_union() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_union>(),
        32usize,
        concat!("Size of: ", stringify!(lysc_type_union))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_union>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_union))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_union>())).exts as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_union),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_union>())).plugin as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_union),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_union>())).basetype as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_union),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_union>())).refcount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_union),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_union>())).types as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_union),
            "::",
            stringify!(types)
        )
    );
}
impl Default for lysc_type_union {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_type_bin {
    pub exts: *mut lysc_ext_instance,
    pub plugin: *mut lyplg_type,
    pub basetype: LY_DATA_TYPE::Type,
    pub refcount: u32,
    pub length: *mut lysc_range,
}
#[test]
fn bindgen_test_layout_lysc_type_bin() {
    assert_eq!(
        ::std::mem::size_of::<lysc_type_bin>(),
        32usize,
        concat!("Size of: ", stringify!(lysc_type_bin))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_type_bin>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_type_bin))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bin>())).exts as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bin),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bin>())).plugin as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bin),
            "::",
            stringify!(plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bin>())).basetype as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bin),
            "::",
            stringify!(basetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bin>())).refcount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bin),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_type_bin>())).length as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_type_bin),
            "::",
            stringify!(length)
        )
    );
}
impl Default for lysc_type_bin {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node,
    pub prev: *mut lysc_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node>(),
        80usize,
        concat!("Size of: ", stringify!(lysc_node))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).nodetype as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).flags as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).hash as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).module as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).dsc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).ref_ as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).exts as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node>())).priv_ as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_node_action_inout {
    pub __bindgen_anon_1: lysc_node_action_inout__bindgen_ty_1,
    pub child: *mut lysc_node,
    pub musts: *mut lysc_must,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_node_action_inout__bindgen_ty_1 {
    pub node: lysc_node,
    pub __bindgen_anon_1: lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1 {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node,
    pub prev: *mut lysc_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1>(
        ),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<
            lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
        >(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .nodetype as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .flags as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .hash as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .module as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .dsc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .ref_ as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .exts as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1,
            >()))
            .priv_ as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node_action_inout__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_action_inout__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_action_inout__bindgen_ty_1>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_action_inout__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_action_inout__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_action_inout__bindgen_ty_1>()))
                .node as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysc_node_action_inout__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_action_inout() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_action_inout>(),
        96usize,
        concat!("Size of: ", stringify!(lysc_node_action_inout))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_action_inout>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_action_inout))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_action_inout>())).child as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_action_inout>())).musts as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action_inout),
            "::",
            stringify!(musts)
        )
    );
}
impl Default for lysc_node_action_inout {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_node_action {
    pub __bindgen_anon_1: lysc_node_action__bindgen_ty_1,
    pub when: *mut *mut lysc_when,
    pub input: lysc_node_action_inout,
    pub output: lysc_node_action_inout,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_node_action__bindgen_ty_1 {
    pub node: lysc_node,
    pub __bindgen_anon_1: lysc_node_action__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node_action__bindgen_ty_1__bindgen_ty_1 {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node_action,
    pub prev: *mut lysc_node_action,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node_action__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_action__bindgen_ty_1__bindgen_ty_1>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_action__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . nodetype as * const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . flags as * const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . hash as * const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . module as * const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . parent as * const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . next as * const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . prev as * const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . name as * const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . dsc as * const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . ref_ as * const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . exts as * const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_action__bindgen_ty_1__bindgen_ty_1 > ())) . priv_ as * const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node_action__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_action__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_action__bindgen_ty_1>(),
        80usize,
        concat!("Size of: ", stringify!(lysc_node_action__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_action__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_action__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_action__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysc_node_action__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_action() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_action>(),
        280usize,
        concat!("Size of: ", stringify!(lysc_node_action))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_action>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_action))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_action>())).when as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_action>())).input as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_action>())).output as *const _
                as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_action),
            "::",
            stringify!(output)
        )
    );
}
impl Default for lysc_node_action {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_node_notif {
    pub __bindgen_anon_1: lysc_node_notif__bindgen_ty_1,
    pub child: *mut lysc_node,
    pub musts: *mut lysc_must,
    pub when: *mut *mut lysc_when,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_node_notif__bindgen_ty_1 {
    pub node: lysc_node,
    pub __bindgen_anon_1: lysc_node_notif__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node_notif__bindgen_ty_1__bindgen_ty_1 {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node_notif,
    pub prev: *mut lysc_node_notif,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node_notif__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .nodetype as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .hash as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .module as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .dsc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .ref_ as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .exts as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1__bindgen_ty_1>(
            )))
            .priv_ as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node_notif__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_notif__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_notif__bindgen_ty_1>(),
        80usize,
        concat!("Size of: ", stringify!(lysc_node_notif__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_notif__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_notif__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysc_node_notif__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_notif() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_notif>(),
        104usize,
        concat!("Size of: ", stringify!(lysc_node_notif))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_notif>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_notif))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif>())).child as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif>())).musts as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_notif>())).when as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_notif),
            "::",
            stringify!(when)
        )
    );
}
impl Default for lysc_node_notif {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_node_container {
    pub __bindgen_anon_1: lysc_node_container__bindgen_ty_1,
    pub child: *mut lysc_node,
    pub musts: *mut lysc_must,
    pub when: *mut *mut lysc_when,
    pub actions: *mut lysc_node_action,
    pub notifs: *mut lysc_node_notif,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_node_container__bindgen_ty_1 {
    pub node: lysc_node,
    pub __bindgen_anon_1: lysc_node_container__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node_container__bindgen_ty_1__bindgen_ty_1 {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node,
    pub prev: *mut lysc_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node_container__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_container__bindgen_ty_1__bindgen_ty_1>(
        ),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_container__bindgen_ty_1__bindgen_ty_1>(
        ),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .nodetype as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .flags as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .hash as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .module as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .dsc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .ref_ as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .exts as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_container__bindgen_ty_1__bindgen_ty_1,
            >()))
            .priv_ as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node_container__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_container__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_container__bindgen_ty_1>(),
        80usize,
        concat!("Size of: ", stringify!(lysc_node_container__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_container__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_container__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_container__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysc_node_container__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_container() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_container>(),
        120usize,
        concat!("Size of: ", stringify!(lysc_node_container))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_container>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_container))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_container>())).child as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_container>())).musts as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_container>())).when as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_container>())).actions as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container),
            "::",
            stringify!(actions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_container>())).notifs as *const _
                as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_container),
            "::",
            stringify!(notifs)
        )
    );
}
impl Default for lysc_node_container {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_node_case {
    pub __bindgen_anon_1: lysc_node_case__bindgen_ty_1,
    pub child: *mut lysc_node,
    pub when: *mut *mut lysc_when,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_node_case__bindgen_ty_1 {
    pub node: lysc_node,
    pub __bindgen_anon_1: lysc_node_case__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node_case__bindgen_ty_1__bindgen_ty_1 {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node,
    pub prev: *mut lysc_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node_case__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .nodetype as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .hash as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .module as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .dsc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .ref_ as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .exts as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1__bindgen_ty_1>(
            )))
            .priv_ as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node_case__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_case__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_case__bindgen_ty_1>(),
        80usize,
        concat!("Size of: ", stringify!(lysc_node_case__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_case__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_case__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysc_node_case__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_case() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_case>(),
        96usize,
        concat!("Size of: ", stringify!(lysc_node_case))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_case>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_case))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case>())).child as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_case>())).when as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_case),
            "::",
            stringify!(when)
        )
    );
}
impl Default for lysc_node_case {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_node_choice {
    pub __bindgen_anon_1: lysc_node_choice__bindgen_ty_1,
    pub cases: *mut lysc_node_case,
    pub when: *mut *mut lysc_when,
    pub dflt: *mut lysc_node_case,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_node_choice__bindgen_ty_1 {
    pub node: lysc_node,
    pub __bindgen_anon_1: lysc_node_choice__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node_choice__bindgen_ty_1__bindgen_ty_1 {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node,
    pub prev: *mut lysc_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node_choice__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_choice__bindgen_ty_1__bindgen_ty_1>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_choice__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . nodetype as * const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . flags as * const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . hash as * const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . module as * const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . parent as * const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . next as * const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . prev as * const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . name as * const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . dsc as * const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . ref_ as * const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . exts as * const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            & (* (:: std :: ptr :: null :: < lysc_node_choice__bindgen_ty_1__bindgen_ty_1 > ())) . priv_ as * const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node_choice__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_choice__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_choice__bindgen_ty_1>(),
        80usize,
        concat!("Size of: ", stringify!(lysc_node_choice__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_choice__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_choice__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_choice__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysc_node_choice__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_choice() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_choice>(),
        104usize,
        concat!("Size of: ", stringify!(lysc_node_choice))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_choice>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_choice))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_choice>())).cases as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice),
            "::",
            stringify!(cases)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_choice>())).when as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_choice>())).dflt as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_choice),
            "::",
            stringify!(dflt)
        )
    );
}
impl Default for lysc_node_choice {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_node_leaf {
    pub __bindgen_anon_1: lysc_node_leaf__bindgen_ty_1,
    pub musts: *mut lysc_must,
    pub when: *mut *mut lysc_when,
    pub type_: *mut lysc_type,
    pub units: *const ::std::os::raw::c_char,
    pub dflt: *mut lyd_value,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_node_leaf__bindgen_ty_1 {
    pub node: lysc_node,
    pub __bindgen_anon_1: lysc_node_leaf__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node_leaf__bindgen_ty_1__bindgen_ty_1 {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node,
    pub prev: *mut lysc_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node_leaf__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .nodetype as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .hash as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .module as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .dsc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .ref_ as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .exts as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1__bindgen_ty_1>(
            )))
            .priv_ as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node_leaf__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_leaf__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_leaf__bindgen_ty_1>(),
        80usize,
        concat!("Size of: ", stringify!(lysc_node_leaf__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_leaf__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_leaf__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysc_node_leaf__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_leaf() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_leaf>(),
        120usize,
        concat!("Size of: ", stringify!(lysc_node_leaf))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_leaf>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_leaf))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf>())).musts as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf>())).when as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf>())).type_ as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf>())).units as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf),
            "::",
            stringify!(units)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaf>())).dflt as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaf),
            "::",
            stringify!(dflt)
        )
    );
}
impl Default for lysc_node_leaf {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_node_leaflist {
    pub __bindgen_anon_1: lysc_node_leaflist__bindgen_ty_1,
    pub musts: *mut lysc_must,
    pub when: *mut *mut lysc_when,
    pub type_: *mut lysc_type,
    pub units: *const ::std::os::raw::c_char,
    pub dflts: *mut *mut lyd_value,
    pub min: u32,
    pub max: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_node_leaflist__bindgen_ty_1 {
    pub node: lysc_node,
    pub __bindgen_anon_1: lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1 {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node,
    pub prev: *mut lysc_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1>(
        ),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .nodetype as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .flags as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .hash as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .module as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .dsc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .ref_ as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .exts as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1,
            >()))
            .priv_ as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node_leaflist__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_leaflist__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_leaflist__bindgen_ty_1>(),
        80usize,
        concat!("Size of: ", stringify!(lysc_node_leaflist__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_leaflist__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_leaflist__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaflist__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysc_node_leaflist__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_leaflist() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_leaflist>(),
        128usize,
        concat!("Size of: ", stringify!(lysc_node_leaflist))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_leaflist>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_leaflist))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaflist>())).musts as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaflist>())).when as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaflist>())).type_ as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaflist>())).units as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist),
            "::",
            stringify!(units)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaflist>())).dflts as *const _
                as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist),
            "::",
            stringify!(dflts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaflist>())).min as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_leaflist>())).max as *const _
                as usize
        },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_leaflist),
            "::",
            stringify!(max)
        )
    );
}
impl Default for lysc_node_leaflist {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_node_list {
    pub __bindgen_anon_1: lysc_node_list__bindgen_ty_1,
    pub child: *mut lysc_node,
    pub musts: *mut lysc_must,
    pub when: *mut *mut lysc_when,
    pub actions: *mut lysc_node_action,
    pub notifs: *mut lysc_node_notif,
    pub uniques: *mut *mut *mut lysc_node_leaf,
    pub min: u32,
    pub max: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_node_list__bindgen_ty_1 {
    pub node: lysc_node,
    pub __bindgen_anon_1: lysc_node_list__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node_list__bindgen_ty_1__bindgen_ty_1 {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node,
    pub prev: *mut lysc_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node_list__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .nodetype as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .hash as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .module as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .dsc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .ref_ as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .exts as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1__bindgen_ty_1>(
            )))
            .priv_ as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node_list__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_list__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_list__bindgen_ty_1>(),
        80usize,
        concat!("Size of: ", stringify!(lysc_node_list__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_list__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_list__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysc_node_list__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_list() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_list>(),
        136usize,
        concat!("Size of: ", stringify!(lysc_node_list))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_list>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_list))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list>())).child as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list>())).musts as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list>())).when as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list),
            "::",
            stringify!(when)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list>())).actions as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list),
            "::",
            stringify!(actions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list>())).notifs as *const _
                as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list),
            "::",
            stringify!(notifs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list>())).uniques as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list),
            "::",
            stringify!(uniques)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list>())).min as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_list>())).max as *const _ as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_list),
            "::",
            stringify!(max)
        )
    );
}
impl Default for lysc_node_list {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lysc_node_anydata {
    pub __bindgen_anon_1: lysc_node_anydata__bindgen_ty_1,
    pub musts: *mut lysc_must,
    pub when: *mut *mut lysc_when,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lysc_node_anydata__bindgen_ty_1 {
    pub node: lysc_node,
    pub __bindgen_anon_1: lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_node_anydata__bindgen_ty_1__bindgen_ty_1 {
    pub nodetype: u16,
    pub flags: u16,
    pub hash: [u8; 4usize],
    pub module: *mut lys_module,
    pub parent: *mut lysc_node,
    pub next: *mut lysc_node,
    pub prev: *mut lysc_node,
    pub name: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub exts: *mut lysc_ext_instance,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lysc_node_anydata__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_anydata__bindgen_ty_1__bindgen_ty_1>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_anydata__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .nodetype as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nodetype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .flags as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .hash as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .module as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .dsc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .ref_ as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .exts as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(exts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                lysc_node_anydata__bindgen_ty_1__bindgen_ty_1,
            >()))
            .priv_ as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lysc_node_anydata__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_anydata__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_anydata__bindgen_ty_1>(),
        80usize,
        concat!("Size of: ", stringify!(lysc_node_anydata__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_anydata__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_anydata__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_anydata__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lysc_node_anydata__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lysc_node_anydata() {
    assert_eq!(
        ::std::mem::size_of::<lysc_node_anydata>(),
        96usize,
        concat!("Size of: ", stringify!(lysc_node_anydata))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_node_anydata>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_node_anydata))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_anydata>())).musts as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata),
            "::",
            stringify!(musts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_node_anydata>())).when as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_node_anydata),
            "::",
            stringify!(when)
        )
    );
}
impl Default for lysc_node_anydata {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lysc_module {
    pub mod_: *mut lys_module,
    pub data: *mut lysc_node,
    pub rpcs: *mut lysc_node_action,
    pub notifs: *mut lysc_node_notif,
    pub exts: *mut lysc_ext_instance,
}
#[test]
fn bindgen_test_layout_lysc_module() {
    assert_eq!(
        ::std::mem::size_of::<lysc_module>(),
        40usize,
        concat!("Size of: ", stringify!(lysc_module))
    );
    assert_eq!(
        ::std::mem::align_of::<lysc_module>(),
        8usize,
        concat!("Alignment of ", stringify!(lysc_module))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_module>())).mod_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_module),
            "::",
            stringify!(mod_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_module>())).data as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_module),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_module>())).rpcs as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_module),
            "::",
            stringify!(rpcs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_module>())).notifs as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_module),
            "::",
            stringify!(notifs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lysc_module>())).exts as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lysc_module),
            "::",
            stringify!(exts)
        )
    );
}
impl Default for lysc_module {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn lysc_has_when(node: *const lysc_node) -> *const lysc_when;
}
extern "C" {
    pub fn lysp_node_groupings(node: *const lysp_node) -> *const lysp_node_grp;
}
extern "C" {
    pub fn lysp_node_typedefs(node: *const lysp_node) -> *const lysp_tpdf;
}
extern "C" {
    pub fn lysp_node_actions(node: *const lysp_node)
        -> *const lysp_node_action;
}
extern "C" {
    pub fn lysp_node_notifs(node: *const lysp_node) -> *const lysp_node_notif;
}
extern "C" {
    pub fn lysp_node_child(node: *const lysp_node) -> *const lysp_node;
}
extern "C" {
    pub fn lysc_node_actions(node: *const lysc_node)
        -> *const lysc_node_action;
}
extern "C" {
    pub fn lysc_node_notifs(node: *const lysc_node) -> *const lysc_node_notif;
}
extern "C" {
    pub fn lysc_node_child(node: *const lysc_node) -> *const lysc_node;
}
extern "C" {
    pub fn lysc_node_musts(node: *const lysc_node) -> *mut lysc_must;
}
extern "C" {
    pub fn lysc_node_when(node: *const lysc_node) -> *mut *mut lysc_when;
}
pub type lysc_dfs_clb = ::std::option::Option<
    unsafe extern "C" fn(
        node: *mut lysc_node,
        data: *mut ::std::os::raw::c_void,
        dfs_continue: *mut ly_bool,
    ) -> LY_ERR::Type,
>;
extern "C" {
    pub fn lysc_tree_dfs_full(
        root: *const lysc_node,
        dfs_clb: lysc_dfs_clb,
        data: *mut ::std::os::raw::c_void,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lysc_module_dfs_full(
        mod_: *const lys_module,
        dfs_clb: lysc_dfs_clb,
        data: *mut ::std::os::raw::c_void,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lysc_iffeature_value(iff: *const lysc_iffeature) -> LY_ERR::Type;
}
extern "C" {
    pub fn lysp_feature_next(
        last: *const lysp_feature,
        pmod: *const lysp_module,
        idx: *mut u32,
    ) -> *mut lysp_feature;
}
extern "C" {
    pub fn lysc_ext_substmt(
        ext: *const lysc_ext_instance,
        substmt: ly_stmt::Type,
        instance_p: *mut *mut ::std::os::raw::c_void,
        cardinality_p: *mut ly_stmt_cardinality::Type,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_find_xpath_atoms(
        ctx: *const ly_ctx,
        ctx_node: *const lysc_node,
        xpath: *const ::std::os::raw::c_char,
        options: u32,
        set: *mut *mut ly_set,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_find_expr_atoms(
        ctx_node: *const lysc_node,
        cur_mod: *const lys_module,
        expr: *const lyxp_expr,
        prefixes: *const lysc_prefix,
        options: u32,
        set: *mut *mut ly_set,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_find_xpath(
        ctx: *const ly_ctx,
        ctx_node: *const lysc_node,
        xpath: *const ::std::os::raw::c_char,
        options: u32,
        set: *mut *mut ly_set,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_find_lypath_atoms(
        path: *const ly_path,
        set: *mut *mut ly_set,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_find_path_atoms(
        ctx: *const ly_ctx,
        ctx_node: *const lysc_node,
        path: *const ::std::os::raw::c_char,
        output: ly_bool,
        set: *mut *mut ly_set,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_find_path(
        ctx: *const ly_ctx,
        ctx_node: *const lysc_node,
        path: *const ::std::os::raw::c_char,
        output: ly_bool,
    ) -> *const lysc_node;
}
pub mod LYSC_PATH_TYPE {
    pub type Type = ::std::os::raw::c_uint;
    pub const LYSC_PATH_LOG: Type = 0;
    pub const LYSC_PATH_DATA: Type = 1;
}
extern "C" {
    pub fn lysc_path(
        node: *const lysc_node,
        pathtype: LYSC_PATH_TYPE::Type,
        buffer: *mut ::std::os::raw::c_char,
        buflen: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lys_module {
    pub ctx: *mut ly_ctx,
    pub name: *const ::std::os::raw::c_char,
    pub revision: *const ::std::os::raw::c_char,
    pub ns: *const ::std::os::raw::c_char,
    pub prefix: *const ::std::os::raw::c_char,
    pub filepath: *const ::std::os::raw::c_char,
    pub org: *const ::std::os::raw::c_char,
    pub contact: *const ::std::os::raw::c_char,
    pub dsc: *const ::std::os::raw::c_char,
    pub ref_: *const ::std::os::raw::c_char,
    pub parsed: *mut lysp_module,
    pub compiled: *mut lysc_module,
    pub identities: *mut lysc_ident,
    pub augmented_by: *mut *mut lys_module,
    pub deviated_by: *mut *mut lys_module,
    pub implemented: ly_bool,
    pub to_compile: ly_bool,
    pub latest_revision: u8,
}
#[test]
fn bindgen_test_layout_lys_module() {
    assert_eq!(
        ::std::mem::size_of::<lys_module>(),
        128usize,
        concat!("Size of: ", stringify!(lys_module))
    );
    assert_eq!(
        ::std::mem::align_of::<lys_module>(),
        8usize,
        concat!("Alignment of ", stringify!(lys_module))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).ctx as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(ctx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).revision as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(revision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).ns as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(ns)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).prefix as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(prefix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).filepath as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(filepath)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).org as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(org)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).contact as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(contact)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).dsc as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(dsc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).ref_ as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).parsed as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(parsed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).compiled as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(compiled)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).identities as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(identities)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).augmented_by as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(augmented_by)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).deviated_by as *const _
                as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(deviated_by)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).implemented as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(implemented)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).to_compile as *const _
                as usize
        },
        121usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(to_compile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lys_module>())).latest_revision as *const _
                as usize
        },
        122usize,
        concat!(
            "Offset of field: ",
            stringify!(lys_module),
            "::",
            stringify!(latest_revision)
        )
    );
}
impl Default for lys_module {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn lys_feature_value(
        module: *const lys_module,
        feature: *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_getnext(
        last: *const lysc_node,
        parent: *const lysc_node,
        module: *const lysc_module,
        options: u32,
    ) -> *const lysc_node;
}
extern "C" {
    pub fn lys_getnext_ext(
        last: *const lysc_node,
        parent: *const lysc_node,
        ext: *const lysc_ext_instance,
        options: u32,
    ) -> *const lysc_node;
}
extern "C" {
    pub fn lys_find_child(
        parent: *const lysc_node,
        module: *const lys_module,
        name: *const ::std::os::raw::c_char,
        name_len: size_t,
        nodetype: u16,
        options: u32,
    ) -> *const lysc_node;
}
extern "C" {
    pub fn lys_set_implemented(
        mod_: *mut lys_module,
        features: *mut *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_nodetype2str(nodetype: u16) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn lyxp_get_expr(
        path: *const lyxp_expr,
    ) -> *const ::std::os::raw::c_char;
}
pub mod LYD_FORMAT {
    pub type Type = ::std::os::raw::c_uint;
    pub const LYD_UNKNOWN: Type = 0;
    pub const LYD_XML: Type = 1;
    pub const LYD_JSON: Type = 2;
    pub const LYD_LYB: Type = 3;
}
pub mod LYD_ANYDATA_VALUETYPE {
    pub type Type = ::std::os::raw::c_uint;
    pub const LYD_ANYDATA_DATATREE: Type = 0;
    pub const LYD_ANYDATA_STRING: Type = 1;
    pub const LYD_ANYDATA_XML: Type = 2;
    pub const LYD_ANYDATA_JSON: Type = 3;
    pub const LYD_ANYDATA_LYB: Type = 4;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_value {
    pub _canonical: *const ::std::os::raw::c_char,
    pub realtype: *const lysc_type,
    pub __bindgen_anon_1: lyd_value__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lyd_value__bindgen_ty_1 {
    pub boolean: i8,
    pub dec64: i64,
    pub int8: i8,
    pub int16: i16,
    pub int32: i32,
    pub int64: i64,
    pub uint8: u8,
    pub uint16: u16,
    pub uint32: u32,
    pub uint64: u64,
    pub enum_item: *mut lysc_type_bitenum_item,
    pub ident: *mut lysc_ident,
    pub target: *mut ly_path,
    pub subvalue: *mut lyd_value_union,
    pub dyn_mem: *mut ::std::os::raw::c_void,
    pub fixed_mem: [u8; 24usize],
    _bindgen_union_align: [u64; 3usize],
}
#[test]
fn bindgen_test_layout_lyd_value__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(lyd_value__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_value__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).boolean
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(boolean)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).dec64
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(dec64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).int8 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(int8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).int16
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(int16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).int32
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(int32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).int64
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(int64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).uint8
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(uint8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).uint16
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(uint16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).uint32
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(uint32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).uint64
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(uint64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).enum_item
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(enum_item)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).ident
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(ident)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).target
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).subvalue
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(subvalue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).dyn_mem
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(dyn_mem)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value__bindgen_ty_1>())).fixed_mem
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value__bindgen_ty_1),
            "::",
            stringify!(fixed_mem)
        )
    );
}
impl Default for lyd_value__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lyd_value() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value>(),
        40usize,
        concat!("Size of: ", stringify!(lyd_value))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_value))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value>()))._canonical as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value),
            "::",
            stringify!(_canonical)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value>())).realtype as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value),
            "::",
            stringify!(realtype)
        )
    );
}
impl Default for lyd_value {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_value_union {
    pub value: lyd_value,
    pub original: *mut ::std::os::raw::c_void,
    pub orig_len: size_t,
    pub hints: u32,
    pub format: LY_VALUE_FORMAT::Type,
    pub prefix_data: *mut ::std::os::raw::c_void,
    pub ctx_node: *const lysc_node,
}
#[test]
fn bindgen_test_layout_lyd_value_union() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value_union>(),
        80usize,
        concat!("Size of: ", stringify!(lyd_value_union))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value_union>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_value_union))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_union>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_union),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_union>())).original as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_union),
            "::",
            stringify!(original)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_union>())).orig_len as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_union),
            "::",
            stringify!(orig_len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_union>())).hints as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_union),
            "::",
            stringify!(hints)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_union>())).format as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_union),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_union>())).prefix_data as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_union),
            "::",
            stringify!(prefix_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_union>())).ctx_node as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_union),
            "::",
            stringify!(ctx_node)
        )
    );
}
impl Default for lyd_value_union {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lyd_value_bits {
    pub bitmap: *mut ::std::os::raw::c_char,
    pub items: *mut *mut lysc_type_bitenum_item,
}
#[test]
fn bindgen_test_layout_lyd_value_bits() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value_bits>(),
        16usize,
        concat!("Size of: ", stringify!(lyd_value_bits))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value_bits>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_value_bits))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_bits>())).bitmap as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_bits),
            "::",
            stringify!(bitmap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_bits>())).items as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_bits),
            "::",
            stringify!(items)
        )
    );
}
impl Default for lyd_value_bits {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lyd_value_binary {
    pub data: *mut ::std::os::raw::c_void,
    pub size: size_t,
}
#[test]
fn bindgen_test_layout_lyd_value_binary() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value_binary>(),
        16usize,
        concat!("Size of: ", stringify!(lyd_value_binary))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value_binary>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_value_binary))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_binary>())).data as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_binary),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_binary>())).size as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_binary),
            "::",
            stringify!(size)
        )
    );
}
impl Default for lyd_value_binary {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct lyd_value_ipv4_address_no_zone {
    pub addr: in_addr,
}
#[test]
fn bindgen_test_layout_lyd_value_ipv4_address_no_zone() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value_ipv4_address_no_zone>(),
        4usize,
        concat!("Size of: ", stringify!(lyd_value_ipv4_address_no_zone))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value_ipv4_address_no_zone>(),
        4usize,
        concat!("Alignment of ", stringify!(lyd_value_ipv4_address_no_zone))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_ipv4_address_no_zone>())).addr
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_ipv4_address_no_zone),
            "::",
            stringify!(addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lyd_value_ipv4_address {
    pub addr: in_addr,
    pub zone: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_lyd_value_ipv4_address() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value_ipv4_address>(),
        16usize,
        concat!("Size of: ", stringify!(lyd_value_ipv4_address))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value_ipv4_address>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_value_ipv4_address))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_ipv4_address>())).addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_ipv4_address),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_ipv4_address>())).zone as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_ipv4_address),
            "::",
            stringify!(zone)
        )
    );
}
impl Default for lyd_value_ipv4_address {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct lyd_value_ipv4_prefix {
    pub addr: in_addr,
    pub prefix: u8,
}
#[test]
fn bindgen_test_layout_lyd_value_ipv4_prefix() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value_ipv4_prefix>(),
        8usize,
        concat!("Size of: ", stringify!(lyd_value_ipv4_prefix))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value_ipv4_prefix>(),
        4usize,
        concat!("Alignment of ", stringify!(lyd_value_ipv4_prefix))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_ipv4_prefix>())).addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_ipv4_prefix),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_ipv4_prefix>())).prefix as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_ipv4_prefix),
            "::",
            stringify!(prefix)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_value_ipv6_address_no_zone {
    pub addr: in6_addr,
}
#[test]
fn bindgen_test_layout_lyd_value_ipv6_address_no_zone() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value_ipv6_address_no_zone>(),
        16usize,
        concat!("Size of: ", stringify!(lyd_value_ipv6_address_no_zone))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value_ipv6_address_no_zone>(),
        4usize,
        concat!("Alignment of ", stringify!(lyd_value_ipv6_address_no_zone))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_ipv6_address_no_zone>())).addr
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_ipv6_address_no_zone),
            "::",
            stringify!(addr)
        )
    );
}
impl Default for lyd_value_ipv6_address_no_zone {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_value_ipv6_address {
    pub addr: in6_addr,
    pub zone: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_lyd_value_ipv6_address() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value_ipv6_address>(),
        24usize,
        concat!("Size of: ", stringify!(lyd_value_ipv6_address))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value_ipv6_address>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_value_ipv6_address))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_ipv6_address>())).addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_ipv6_address),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_ipv6_address>())).zone as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_ipv6_address),
            "::",
            stringify!(zone)
        )
    );
}
impl Default for lyd_value_ipv6_address {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_value_ipv6_prefix {
    pub addr: in6_addr,
    pub prefix: u8,
}
#[test]
fn bindgen_test_layout_lyd_value_ipv6_prefix() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value_ipv6_prefix>(),
        20usize,
        concat!("Size of: ", stringify!(lyd_value_ipv6_prefix))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value_ipv6_prefix>(),
        4usize,
        concat!("Alignment of ", stringify!(lyd_value_ipv6_prefix))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_ipv6_prefix>())).addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_ipv6_prefix),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_ipv6_prefix>())).prefix as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_ipv6_prefix),
            "::",
            stringify!(prefix)
        )
    );
}
impl Default for lyd_value_ipv6_prefix {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lyd_value_date_and_time {
    pub time: time_t,
    pub fractions_s: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_lyd_value_date_and_time() {
    assert_eq!(
        ::std::mem::size_of::<lyd_value_date_and_time>(),
        16usize,
        concat!("Size of: ", stringify!(lyd_value_date_and_time))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_value_date_and_time>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_value_date_and_time))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_date_and_time>())).time as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_date_and_time),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_value_date_and_time>())).fractions_s
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_value_date_and_time),
            "::",
            stringify!(fractions_s)
        )
    );
}
impl Default for lyd_value_date_and_time {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_meta {
    pub parent: *mut lyd_node,
    pub next: *mut lyd_meta,
    pub annotation: *mut lysc_ext_instance,
    pub name: *const ::std::os::raw::c_char,
    pub value: lyd_value,
}
#[test]
fn bindgen_test_layout_lyd_meta() {
    assert_eq!(
        ::std::mem::size_of::<lyd_meta>(),
        72usize,
        concat!("Size of: ", stringify!(lyd_meta))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_meta>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_meta))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_meta>())).parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_meta),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_meta>())).next as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_meta),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_meta>())).annotation as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_meta),
            "::",
            stringify!(annotation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_meta>())).name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_meta),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_meta>())).value as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_meta),
            "::",
            stringify!(value)
        )
    );
}
impl Default for lyd_meta {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ly_opaq_name {
    pub name: *const ::std::os::raw::c_char,
    pub prefix: *const ::std::os::raw::c_char,
    pub __bindgen_anon_1: ly_opaq_name__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ly_opaq_name__bindgen_ty_1 {
    pub module_ns: *const ::std::os::raw::c_char,
    pub module_name: *const ::std::os::raw::c_char,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_ly_opaq_name__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<ly_opaq_name__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(ly_opaq_name__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<ly_opaq_name__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(ly_opaq_name__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_opaq_name__bindgen_ty_1>())).module_ns
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_opaq_name__bindgen_ty_1),
            "::",
            stringify!(module_ns)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_opaq_name__bindgen_ty_1>())).module_name
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_opaq_name__bindgen_ty_1),
            "::",
            stringify!(module_name)
        )
    );
}
impl Default for ly_opaq_name__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_ly_opaq_name() {
    assert_eq!(
        ::std::mem::size_of::<ly_opaq_name>(),
        24usize,
        concat!("Size of: ", stringify!(ly_opaq_name))
    );
    assert_eq!(
        ::std::mem::align_of::<ly_opaq_name>(),
        8usize,
        concat!("Alignment of ", stringify!(ly_opaq_name))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_opaq_name>())).name as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_opaq_name),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_opaq_name>())).prefix as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_opaq_name),
            "::",
            stringify!(prefix)
        )
    );
}
impl Default for ly_opaq_name {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_attr {
    pub parent: *mut lyd_node_opaq,
    pub next: *mut lyd_attr,
    pub name: ly_opaq_name,
    pub value: *const ::std::os::raw::c_char,
    pub hints: u32,
    pub format: LY_VALUE_FORMAT::Type,
    pub val_prefix_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lyd_attr() {
    assert_eq!(
        ::std::mem::size_of::<lyd_attr>(),
        64usize,
        concat!("Size of: ", stringify!(lyd_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_attr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_attr>())).parent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_attr),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_attr>())).next as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_attr),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_attr>())).name as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_attr),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_attr>())).value as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_attr),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_attr>())).hints as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_attr),
            "::",
            stringify!(hints)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_attr>())).format as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_attr),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_attr>())).val_prefix_data as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_attr),
            "::",
            stringify!(val_prefix_data)
        )
    );
}
impl Default for lyd_attr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lyd_node {
    pub hash: u32,
    pub flags: u32,
    pub schema: *const lysc_node,
    pub parent: *mut lyd_node_inner,
    pub next: *mut lyd_node,
    pub prev: *mut lyd_node,
    pub meta: *mut lyd_meta,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lyd_node() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node>(),
        56usize,
        concat!("Size of: ", stringify!(lyd_node))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_node))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node>())).hash as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node>())).flags as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node>())).schema as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node),
            "::",
            stringify!(schema)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node>())).parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node>())).next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node>())).prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node>())).meta as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node),
            "::",
            stringify!(meta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node>())).priv_ as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lyd_node {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_node_inner {
    pub __bindgen_anon_1: lyd_node_inner__bindgen_ty_1,
    pub child: *mut lyd_node,
    pub children_ht: *mut hash_table,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lyd_node_inner__bindgen_ty_1 {
    pub node: lyd_node,
    pub __bindgen_anon_1: lyd_node_inner__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lyd_node_inner__bindgen_ty_1__bindgen_ty_1 {
    pub hash: u32,
    pub flags: u32,
    pub schema: *const lysc_node,
    pub parent: *mut lyd_node_inner,
    pub next: *mut lyd_node,
    pub prev: *mut lyd_node,
    pub meta: *mut lyd_meta,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lyd_node_inner__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_inner__bindgen_ty_1__bindgen_ty_1>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(lyd_node_inner__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_inner__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lyd_node_inner__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner__bindgen_ty_1__bindgen_ty_1>(
            )))
            .hash as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner__bindgen_ty_1__bindgen_ty_1>(
            )))
            .schema as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(schema)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner__bindgen_ty_1__bindgen_ty_1>(
            )))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner__bindgen_ty_1__bindgen_ty_1>(
            )))
            .meta as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(meta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner__bindgen_ty_1__bindgen_ty_1>(
            )))
            .priv_ as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lyd_node_inner__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lyd_node_inner__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_inner__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(lyd_node_inner__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_inner__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_node_inner__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lyd_node_inner__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lyd_node_inner() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_inner>(),
        72usize,
        concat!("Size of: ", stringify!(lyd_node_inner))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_inner>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_node_inner))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner>())).child as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_inner>())).children_ht as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_inner),
            "::",
            stringify!(children_ht)
        )
    );
}
impl Default for lyd_node_inner {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_node_term {
    pub __bindgen_anon_1: lyd_node_term__bindgen_ty_1,
    pub value: lyd_value,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lyd_node_term__bindgen_ty_1 {
    pub node: lyd_node,
    pub __bindgen_anon_1: lyd_node_term__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lyd_node_term__bindgen_ty_1__bindgen_ty_1 {
    pub hash: u32,
    pub flags: u32,
    pub schema: *const lysc_node,
    pub parent: *mut lyd_node_inner,
    pub next: *mut lyd_node,
    pub prev: *mut lyd_node,
    pub meta: *mut lyd_meta,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lyd_node_term__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_term__bindgen_ty_1__bindgen_ty_1>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(lyd_node_term__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_term__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lyd_node_term__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_term__bindgen_ty_1__bindgen_ty_1>(
            )))
            .hash as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_term__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_term__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_term__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_term__bindgen_ty_1__bindgen_ty_1>(
            )))
            .schema as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_term__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(schema)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_term__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_term__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_term__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_term__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_term__bindgen_ty_1__bindgen_ty_1>(
            )))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_term__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_term__bindgen_ty_1__bindgen_ty_1>(
            )))
            .meta as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_term__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(meta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_term__bindgen_ty_1__bindgen_ty_1>(
            )))
            .priv_ as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_term__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lyd_node_term__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lyd_node_term__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_term__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(lyd_node_term__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_term__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_node_term__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_term__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_term__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lyd_node_term__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lyd_node_term() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_term>(),
        96usize,
        concat!("Size of: ", stringify!(lyd_node_term))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_term>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_node_term))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_term>())).value as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_term),
            "::",
            stringify!(value)
        )
    );
}
impl Default for lyd_node_term {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lyd_any_value {
    pub tree: *mut lyd_node,
    pub str_: *const ::std::os::raw::c_char,
    pub xml: *const ::std::os::raw::c_char,
    pub json: *const ::std::os::raw::c_char,
    pub mem: *mut ::std::os::raw::c_char,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_lyd_any_value() {
    assert_eq!(
        ::std::mem::size_of::<lyd_any_value>(),
        8usize,
        concat!("Size of: ", stringify!(lyd_any_value))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_any_value>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_any_value))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_any_value>())).tree as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_any_value),
            "::",
            stringify!(tree)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_any_value>())).str_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_any_value),
            "::",
            stringify!(str_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_any_value>())).xml as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_any_value),
            "::",
            stringify!(xml)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_any_value>())).json as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_any_value),
            "::",
            stringify!(json)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_any_value>())).mem as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_any_value),
            "::",
            stringify!(mem)
        )
    );
}
impl Default for lyd_any_value {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_node_any {
    pub __bindgen_anon_1: lyd_node_any__bindgen_ty_1,
    pub value: lyd_any_value,
    pub value_type: LYD_ANYDATA_VALUETYPE::Type,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lyd_node_any__bindgen_ty_1 {
    pub node: lyd_node,
    pub __bindgen_anon_1: lyd_node_any__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lyd_node_any__bindgen_ty_1__bindgen_ty_1 {
    pub hash: u32,
    pub flags: u32,
    pub schema: *const lysc_node,
    pub parent: *mut lyd_node_inner,
    pub next: *mut lyd_node,
    pub prev: *mut lyd_node,
    pub meta: *mut lyd_meta,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lyd_node_any__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_any__bindgen_ty_1__bindgen_ty_1>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(lyd_node_any__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_any__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lyd_node_any__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any__bindgen_ty_1__bindgen_ty_1>()))
                .hash as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any__bindgen_ty_1__bindgen_ty_1>()))
                .flags as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any__bindgen_ty_1__bindgen_ty_1>()))
                .schema as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(schema)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any__bindgen_ty_1__bindgen_ty_1>()))
                .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any__bindgen_ty_1__bindgen_ty_1>()))
                .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any__bindgen_ty_1__bindgen_ty_1>()))
                .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any__bindgen_ty_1__bindgen_ty_1>()))
                .meta as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(meta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any__bindgen_ty_1__bindgen_ty_1>()))
                .priv_ as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lyd_node_any__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lyd_node_any__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_any__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(lyd_node_any__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_any__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_node_any__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lyd_node_any__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lyd_node_any() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_any>(),
        72usize,
        concat!("Size of: ", stringify!(lyd_node_any))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_any>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_node_any))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any>())).value as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_any>())).value_type as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_any),
            "::",
            stringify!(value_type)
        )
    );
}
impl Default for lyd_node_any {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct lyd_node_opaq {
    pub __bindgen_anon_1: lyd_node_opaq__bindgen_ty_1,
    pub child: *mut lyd_node,
    pub name: ly_opaq_name,
    pub value: *const ::std::os::raw::c_char,
    pub hints: u32,
    pub format: LY_VALUE_FORMAT::Type,
    pub val_prefix_data: *mut ::std::os::raw::c_void,
    pub attr: *mut lyd_attr,
    pub ctx: *const ly_ctx,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union lyd_node_opaq__bindgen_ty_1 {
    pub node: lyd_node,
    pub __bindgen_anon_1: lyd_node_opaq__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lyd_node_opaq__bindgen_ty_1__bindgen_ty_1 {
    pub hash: u32,
    pub flags: u32,
    pub schema: *const lysc_node,
    pub parent: *mut lyd_node_inner,
    pub next: *mut lyd_node,
    pub prev: *mut lyd_node,
    pub meta: *mut lyd_meta,
    pub priv_: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_lyd_node_opaq__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_opaq__bindgen_ty_1__bindgen_ty_1>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(lyd_node_opaq__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_opaq__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(lyd_node_opaq__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq__bindgen_ty_1__bindgen_ty_1>(
            )))
            .hash as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq__bindgen_ty_1__bindgen_ty_1>(
            )))
            .flags as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq__bindgen_ty_1__bindgen_ty_1>(
            )))
            .schema as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(schema)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq__bindgen_ty_1__bindgen_ty_1>(
            )))
            .parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq__bindgen_ty_1__bindgen_ty_1>(
            )))
            .next as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq__bindgen_ty_1__bindgen_ty_1>(
            )))
            .prev as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq__bindgen_ty_1__bindgen_ty_1>(
            )))
            .meta as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(meta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq__bindgen_ty_1__bindgen_ty_1>(
            )))
            .priv_ as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(priv_)
        )
    );
}
impl Default for lyd_node_opaq__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lyd_node_opaq__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_opaq__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(lyd_node_opaq__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_opaq__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_node_opaq__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq__bindgen_ty_1>())).node
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq__bindgen_ty_1),
            "::",
            stringify!(node)
        )
    );
}
impl Default for lyd_node_opaq__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_lyd_node_opaq() {
    assert_eq!(
        ::std::mem::size_of::<lyd_node_opaq>(),
        128usize,
        concat!("Size of: ", stringify!(lyd_node_opaq))
    );
    assert_eq!(
        ::std::mem::align_of::<lyd_node_opaq>(),
        8usize,
        concat!("Alignment of ", stringify!(lyd_node_opaq))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq>())).child as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq>())).name as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq>())).value as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq>())).hints as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq),
            "::",
            stringify!(hints)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq>())).format as *const _
                as usize
        },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq>())).val_prefix_data
                as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq),
            "::",
            stringify!(val_prefix_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq>())).attr as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq),
            "::",
            stringify!(attr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lyd_node_opaq>())).ctx as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(lyd_node_opaq),
            "::",
            stringify!(ctx)
        )
    );
}
impl Default for lyd_node_opaq {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn lyd_child_no_keys(node: *const lyd_node) -> *mut lyd_node;
}
extern "C" {
    pub fn lyd_owner_module(node: *const lyd_node) -> *const lys_module;
}
extern "C" {
    pub fn lyd_is_default(node: *const lyd_node) -> ly_bool;
}
extern "C" {
    pub fn lyd_list_pos(instance: *const lyd_node) -> u32;
}
extern "C" {
    pub fn lyd_first_sibling(node: *const lyd_node) -> *mut lyd_node;
}
extern "C" {
    pub fn lyd_lyb_data_length(
        data: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lyd_value_get_canonical(
        ctx: *const ly_ctx,
        value: *const lyd_value,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn lyd_any_value_str(
        any: *const lyd_node,
        value_str: *mut *mut ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_any_copy_value(
        trg: *mut lyd_node,
        value: *const lyd_any_value,
        value_type: LYD_ANYDATA_VALUETYPE::Type,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_inner(
        parent: *mut lyd_node,
        module: *const lys_module,
        name: *const ::std::os::raw::c_char,
        output: ly_bool,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_ext_inner(
        ext: *const lysc_ext_instance,
        name: *const ::std::os::raw::c_char,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_list(
        parent: *mut lyd_node,
        module: *const lys_module,
        name: *const ::std::os::raw::c_char,
        output: ly_bool,
        node: *mut *mut lyd_node,
        ...
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_ext_list(
        ext: *const lysc_ext_instance,
        name: *const ::std::os::raw::c_char,
        node: *mut *mut lyd_node,
        ...
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_list2(
        parent: *mut lyd_node,
        module: *const lys_module,
        name: *const ::std::os::raw::c_char,
        keys: *const ::std::os::raw::c_char,
        output: ly_bool,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_term(
        parent: *mut lyd_node,
        module: *const lys_module,
        name: *const ::std::os::raw::c_char,
        val_str: *const ::std::os::raw::c_char,
        output: ly_bool,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_term_bin(
        parent: *mut lyd_node,
        module: *const lys_module,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_void,
        value_len: size_t,
        output: ly_bool,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_term_canon(
        parent: *mut lyd_node,
        module: *const lys_module,
        name: *const ::std::os::raw::c_char,
        val_str: *const ::std::os::raw::c_char,
        output: ly_bool,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_ext_term(
        ext: *const lysc_ext_instance,
        name: *const ::std::os::raw::c_char,
        val_str: *const ::std::os::raw::c_char,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_any(
        parent: *mut lyd_node,
        module: *const lys_module,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_void,
        use_value: ly_bool,
        value_type: LYD_ANYDATA_VALUETYPE::Type,
        output: ly_bool,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_ext_any(
        ext: *const lysc_ext_instance,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_void,
        use_value: ly_bool,
        value_type: LYD_ANYDATA_VALUETYPE::Type,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_meta(
        ctx: *const ly_ctx,
        parent: *mut lyd_node,
        module: *const lys_module,
        name: *const ::std::os::raw::c_char,
        val_str: *const ::std::os::raw::c_char,
        clear_dflt: ly_bool,
        meta: *mut *mut lyd_meta,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_meta2(
        ctx: *const ly_ctx,
        parent: *mut lyd_node,
        clear_dflt: ly_bool,
        attr: *const lyd_attr,
        meta: *mut *mut lyd_meta,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_opaq(
        parent: *mut lyd_node,
        ctx: *const ly_ctx,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        prefix: *const ::std::os::raw::c_char,
        module_name: *const ::std::os::raw::c_char,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_opaq2(
        parent: *mut lyd_node,
        ctx: *const ly_ctx,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        prefix: *const ::std::os::raw::c_char,
        module_ns: *const ::std::os::raw::c_char,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_attr(
        parent: *mut lyd_node,
        module_name: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        attr: *mut *mut lyd_attr,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_attr2(
        parent: *mut lyd_node,
        module_ns: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        attr: *mut *mut lyd_attr,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_path(
        parent: *mut lyd_node,
        ctx: *const ly_ctx,
        path: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        options: u32,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_path2(
        parent: *mut lyd_node,
        ctx: *const ly_ctx,
        path: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_void,
        value_len: size_t,
        value_type: LYD_ANYDATA_VALUETYPE::Type,
        options: u32,
        new_parent: *mut *mut lyd_node,
        new_node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_ext_path(
        parent: *mut lyd_node,
        ext: *const lysc_ext_instance,
        path: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_void,
        options: u32,
        node: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_implicit_tree(
        tree: *mut lyd_node,
        implicit_options: u32,
        diff: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_implicit_all(
        tree: *mut *mut lyd_node,
        ctx: *const ly_ctx,
        implicit_options: u32,
        diff: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_new_implicit_module(
        tree: *mut *mut lyd_node,
        module: *const lys_module,
        implicit_options: u32,
        diff: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_change_term(
        term: *mut lyd_node,
        val_str: *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_change_term_bin(
        term: *mut lyd_node,
        value: *const ::std::os::raw::c_void,
        value_len: size_t,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_change_term_canon(
        term: *mut lyd_node,
        val_str: *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_change_meta(
        meta: *mut lyd_meta,
        val_str: *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_insert_child(
        parent: *mut lyd_node,
        node: *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_insert_sibling(
        sibling: *mut lyd_node,
        node: *mut lyd_node,
        first: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_insert_before(
        sibling: *mut lyd_node,
        node: *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_insert_after(
        sibling: *mut lyd_node,
        node: *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_unlink_tree(node: *mut lyd_node);
}
extern "C" {
    pub fn lyd_free_all(node: *mut lyd_node);
}
extern "C" {
    pub fn lyd_free_siblings(node: *mut lyd_node);
}
extern "C" {
    pub fn lyd_free_tree(node: *mut lyd_node);
}
extern "C" {
    pub fn lyd_free_meta_single(meta: *mut lyd_meta);
}
extern "C" {
    pub fn lyd_free_meta_siblings(meta: *mut lyd_meta);
}
extern "C" {
    pub fn lyd_free_attr_single(ctx: *const ly_ctx, attr: *mut lyd_attr);
}
extern "C" {
    pub fn lyd_free_attr_siblings(ctx: *const ly_ctx, attr: *mut lyd_attr);
}
extern "C" {
    pub fn lyd_value_validate(
        ctx: *const ly_ctx,
        schema: *const lysc_node,
        value: *const ::std::os::raw::c_char,
        value_len: size_t,
        ctx_node: *const lyd_node,
        realtype: *mut *const lysc_type,
        canonical: *mut *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_value_compare(
        node: *const lyd_node_term,
        value: *const ::std::os::raw::c_char,
        value_len: size_t,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_compare_single(
        node1: *const lyd_node,
        node2: *const lyd_node,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_compare_siblings(
        node1: *const lyd_node,
        node2: *const lyd_node,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_compare_meta(
        meta1: *const lyd_meta,
        meta2: *const lyd_meta,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_dup_single(
        node: *const lyd_node,
        parent: *mut lyd_node_inner,
        options: u32,
        dup: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_dup_siblings(
        node: *const lyd_node,
        parent: *mut lyd_node_inner,
        options: u32,
        dup: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_dup_meta_single(
        meta: *const lyd_meta,
        parent: *mut lyd_node,
        dup: *mut *mut lyd_meta,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_merge_tree(
        target: *mut *mut lyd_node,
        source: *const lyd_node,
        options: u16,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_merge_siblings(
        target: *mut *mut lyd_node,
        source: *const lyd_node,
        options: u16,
    ) -> LY_ERR::Type;
}
pub type lyd_merge_cb = ::std::option::Option<
    unsafe extern "C" fn(
        trg_node: *mut lyd_node,
        src_node: *const lyd_node,
        cb_data: *mut ::std::os::raw::c_void,
    ) -> LY_ERR::Type,
>;
extern "C" {
    pub fn lyd_merge_module(
        target: *mut *mut lyd_node,
        source: *const lyd_node,
        mod_: *const lys_module,
        merge_cb: lyd_merge_cb,
        cb_data: *mut ::std::os::raw::c_void,
        options: u16,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_diff_tree(
        first: *const lyd_node,
        second: *const lyd_node,
        options: u16,
        diff: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_diff_siblings(
        first: *const lyd_node,
        second: *const lyd_node,
        options: u16,
        diff: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
pub type lyd_diff_cb = ::std::option::Option<
    unsafe extern "C" fn(
        diff_node: *const lyd_node,
        data_node: *mut lyd_node,
        cb_data: *mut ::std::os::raw::c_void,
    ) -> LY_ERR::Type,
>;
extern "C" {
    pub fn lyd_diff_apply_module(
        data: *mut *mut lyd_node,
        diff: *const lyd_node,
        mod_: *const lys_module,
        diff_cb: lyd_diff_cb,
        cb_data: *mut ::std::os::raw::c_void,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_diff_apply_all(
        data: *mut *mut lyd_node,
        diff: *const lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_diff_merge_module(
        diff: *mut *mut lyd_node,
        src_diff: *const lyd_node,
        mod_: *const lys_module,
        diff_cb: lyd_diff_cb,
        cb_data: *mut ::std::os::raw::c_void,
        options: u16,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_diff_merge_tree(
        diff_first: *mut *mut lyd_node,
        diff_parent: *mut lyd_node,
        src_sibling: *const lyd_node,
        diff_cb: lyd_diff_cb,
        cb_data: *mut ::std::os::raw::c_void,
        options: u16,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_diff_merge_all(
        diff: *mut *mut lyd_node,
        src_diff: *const lyd_node,
        options: u16,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_diff_reverse_all(
        src_diff: *const lyd_node,
        diff: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_target(
        path: *const ly_path,
        tree: *const lyd_node,
    ) -> *const lyd_node_term;
}
pub mod LYD_PATH_TYPE {
    pub type Type = ::std::os::raw::c_uint;
    pub const LYD_PATH_STD: Type = 0;
    pub const LYD_PATH_STD_NO_LAST_PRED: Type = 1;
}
extern "C" {
    pub fn lyd_path(
        node: *const lyd_node,
        pathtype: LYD_PATH_TYPE::Type,
        buffer: *mut ::std::os::raw::c_char,
        buflen: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn lyd_find_meta(
        first: *const lyd_meta,
        module: *const lys_module,
        name: *const ::std::os::raw::c_char,
    ) -> *mut lyd_meta;
}
extern "C" {
    pub fn lyd_find_sibling_first(
        siblings: *const lyd_node,
        target: *const lyd_node,
        match_: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_find_sibling_val(
        siblings: *const lyd_node,
        schema: *const lysc_node,
        key_or_value: *const ::std::os::raw::c_char,
        val_len: size_t,
        match_: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_find_sibling_dup_inst_set(
        siblings: *const lyd_node,
        target: *const lyd_node,
        set: *mut *mut ly_set,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_find_sibling_opaq_next(
        first: *const lyd_node,
        name: *const ::std::os::raw::c_char,
        match_: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_find_xpath(
        ctx_node: *const lyd_node,
        xpath: *const ::std::os::raw::c_char,
        set: *mut *mut ly_set,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_find_path(
        ctx_node: *const lyd_node,
        path: *const ::std::os::raw::c_char,
        output: ly_bool,
        match_: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_time_str2time(
        value: *const ::std::os::raw::c_char,
        time: *mut time_t,
        fractions_s: *mut *mut ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_time_time2str(
        time: time_t,
        fractions_s: *const ::std::os::raw::c_char,
        str_: *mut *mut ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_time_str2ts(
        value: *const ::std::os::raw::c_char,
        ts: *mut timespec,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_time_ts2str(
        ts: *const timespec,
        str_: *mut *mut ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_new(
        search_dir: *const ::std::os::raw::c_char,
        options: u16,
        new_ctx: *mut *mut ly_ctx,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_new_ylpath(
        search_dir: *const ::std::os::raw::c_char,
        path: *const ::std::os::raw::c_char,
        format: LYD_FORMAT::Type,
        options: ::std::os::raw::c_int,
        ctx: *mut *mut ly_ctx,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_new_ylmem(
        search_dir: *const ::std::os::raw::c_char,
        data: *const ::std::os::raw::c_char,
        format: LYD_FORMAT::Type,
        options: ::std::os::raw::c_int,
        ctx: *mut *mut ly_ctx,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_compile(ctx: *mut ly_ctx) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_set_searchdir(
        ctx: *mut ly_ctx,
        search_dir: *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_unset_searchdir(
        ctx: *mut ly_ctx,
        value: *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_unset_searchdir_last(
        ctx: *mut ly_ctx,
        count: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_get_searchdirs(
        ctx: *const ly_ctx,
    ) -> *const *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn ly_ctx_get_options(ctx: *const ly_ctx) -> u16;
}
extern "C" {
    pub fn ly_ctx_set_options(ctx: *mut ly_ctx, option: u16) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_unset_options(ctx: *mut ly_ctx, option: u16) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_get_change_count(ctx: *const ly_ctx) -> u16;
}
pub type ly_module_imp_data_free_clb = ::std::option::Option<
    unsafe extern "C" fn(
        module_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type ly_module_imp_clb = ::std::option::Option<
    unsafe extern "C" fn(
        mod_name: *const ::std::os::raw::c_char,
        mod_rev: *const ::std::os::raw::c_char,
        submod_name: *const ::std::os::raw::c_char,
        submod_rev: *const ::std::os::raw::c_char,
        user_data: *mut ::std::os::raw::c_void,
        format: *mut LYS_INFORMAT::Type,
        module_data: *mut *const ::std::os::raw::c_char,
        free_module_data: *mut ly_module_imp_data_free_clb,
    ) -> LY_ERR::Type,
>;
extern "C" {
    pub fn ly_ctx_get_module_imp_clb(
        ctx: *const ly_ctx,
        user_data: *mut *mut ::std::os::raw::c_void,
    ) -> ly_module_imp_clb;
}
extern "C" {
    pub fn ly_ctx_set_module_imp_clb(
        ctx: *mut ly_ctx,
        clb: ly_module_imp_clb,
        user_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn ly_ctx_get_module(
        ctx: *const ly_ctx,
        name: *const ::std::os::raw::c_char,
        revision: *const ::std::os::raw::c_char,
    ) -> *mut lys_module;
}
extern "C" {
    pub fn ly_ctx_get_module_latest(
        ctx: *const ly_ctx,
        name: *const ::std::os::raw::c_char,
    ) -> *mut lys_module;
}
extern "C" {
    pub fn ly_ctx_get_module_implemented(
        ctx: *const ly_ctx,
        name: *const ::std::os::raw::c_char,
    ) -> *mut lys_module;
}
extern "C" {
    pub fn ly_ctx_get_module_iter(
        ctx: *const ly_ctx,
        index: *mut u32,
    ) -> *const lys_module;
}
extern "C" {
    pub fn ly_ctx_get_module_ns(
        ctx: *const ly_ctx,
        ns: *const ::std::os::raw::c_char,
        revision: *const ::std::os::raw::c_char,
    ) -> *mut lys_module;
}
extern "C" {
    pub fn ly_ctx_get_module_latest_ns(
        ctx: *const ly_ctx,
        ns: *const ::std::os::raw::c_char,
    ) -> *mut lys_module;
}
extern "C" {
    pub fn ly_ctx_get_module_implemented_ns(
        ctx: *const ly_ctx,
        ns: *const ::std::os::raw::c_char,
    ) -> *mut lys_module;
}
extern "C" {
    pub fn ly_ctx_get_submodule(
        ctx: *const ly_ctx,
        submodule: *const ::std::os::raw::c_char,
        revision: *const ::std::os::raw::c_char,
    ) -> *const lysp_submodule;
}
extern "C" {
    pub fn ly_ctx_get_submodule_latest(
        ctx: *const ly_ctx,
        submodule: *const ::std::os::raw::c_char,
    ) -> *const lysp_submodule;
}
extern "C" {
    pub fn ly_ctx_get_submodule2(
        module: *const lys_module,
        submodule: *const ::std::os::raw::c_char,
        revision: *const ::std::os::raw::c_char,
    ) -> *const lysp_submodule;
}
extern "C" {
    pub fn ly_ctx_get_submodule2_latest(
        module: *const lys_module,
        submodule: *const ::std::os::raw::c_char,
    ) -> *const lysp_submodule;
}
extern "C" {
    pub fn ly_ctx_reset_latests(ctx: *mut ly_ctx);
}
extern "C" {
    pub fn ly_ctx_internal_modules_count(ctx: *const ly_ctx) -> u32;
}
extern "C" {
    pub fn ly_ctx_load_module(
        ctx: *mut ly_ctx,
        name: *const ::std::os::raw::c_char,
        revision: *const ::std::os::raw::c_char,
        features: *mut *const ::std::os::raw::c_char,
    ) -> *const lys_module;
}
extern "C" {
    pub fn ly_ctx_get_yanglib_data(
        ctx: *const ly_ctx,
        root: *mut *mut lyd_node,
        content_id_format: *const ::std::os::raw::c_char,
        ...
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_ctx_destroy(ctx: *mut ly_ctx);
}
extern "C" {
    pub fn memcpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memccpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __s: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strcoll_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __l: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm_l(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
        __l: locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn strdup(
        __s: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __string: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __reject: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strstr(
        __haystack: *const ::std::os::raw::c_char,
        __needle: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(
        __s: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strnlen(
        __string: *const ::std::os::raw::c_char,
        __maxlen: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn strerror(
        __errnum: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}__xpg_strerror_r"]
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strerror_l(
        __errnum: ::std::os::raw::c_int,
        __l: locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcopy(
        __src: *const ::std::os::raw::c_void,
        __dest: *mut ::std::os::raw::c_void,
        __n: size_t,
    );
}
extern "C" {
    pub fn bzero(
        __s: *mut ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    );
}
extern "C" {
    pub fn index(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(__i: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsl(__l: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsll(__ll: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __loc: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: size_t,
        __loc: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn explicit_bzero(__s: *mut ::std::os::raw::c_void, __n: size_t);
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strsignal(
        __sig: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn lydict_insert(
        ctx: *const ly_ctx,
        value: *const ::std::os::raw::c_char,
        len: size_t,
        str_p: *mut *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lydict_insert_zc(
        ctx: *const ly_ctx,
        value: *mut ::std::os::raw::c_char,
        str_p: *mut *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lydict_remove(
        ctx: *const ly_ctx,
        value: *const ::std::os::raw::c_char,
    ) -> LY_ERR::Type;
}
pub mod LY_IN_TYPE {
    pub type Type = ::std::os::raw::c_int;
    pub const LY_IN_ERROR: Type = -1;
    pub const LY_IN_FD: Type = 0;
    pub const LY_IN_FILE: Type = 1;
    pub const LY_IN_FILEPATH: Type = 2;
    pub const LY_IN_MEMORY: Type = 3;
}
extern "C" {
    pub fn ly_in_type(in_: *const ly_in) -> LY_IN_TYPE::Type;
}
extern "C" {
    pub fn ly_in_reset(in_: *mut ly_in) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_in_new_fd(
        fd: ::std::os::raw::c_int,
        in_: *mut *mut ly_in,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_in_fd(
        in_: *mut ly_in,
        fd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ly_in_new_file(f: *mut FILE, in_: *mut *mut ly_in) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_in_file(in_: *mut ly_in, f: *mut FILE) -> *mut FILE;
}
extern "C" {
    pub fn ly_in_new_memory(
        str_: *const ::std::os::raw::c_char,
        in_: *mut *mut ly_in,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_in_memory(
        in_: *mut ly_in,
        str_: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn ly_in_new_filepath(
        filepath: *const ::std::os::raw::c_char,
        len: size_t,
        in_: *mut *mut ly_in,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_in_filepath(
        in_: *mut ly_in,
        filepath: *const ::std::os::raw::c_char,
        len: size_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn ly_in_parsed(in_: *const ly_in) -> size_t;
}
extern "C" {
    pub fn ly_in_free(in_: *mut ly_in, destroy: ly_bool);
}
pub type useconds_t = __useconds_t;
extern "C" {
    pub fn access(
        __name: *const ::std::os::raw::c_char,
        __type: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faccessat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __type: ::std::os::raw::c_int,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lseek(
        __fd: ::std::os::raw::c_int,
        __offset: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> __off_t;
}
extern "C" {
    pub fn close(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn read(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __nbytes: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn write(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pread(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __nbytes: size_t,
        __offset: __off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pwrite(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: size_t,
        __offset: __off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pipe(__pipedes: *mut ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn alarm(__seconds: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn sleep(__seconds: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn ualarm(
        __value: __useconds_t,
        __interval: __useconds_t,
    ) -> __useconds_t;
}
extern "C" {
    pub fn usleep(__useconds: __useconds_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pause() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chown(
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchown(
        __fd: ::std::os::raw::c_int,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchown(
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchownat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chdir(
        __path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchdir(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getcwd(
        __buf: *mut ::std::os::raw::c_char,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getwd(
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn dup(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup2(
        __fd: ::std::os::raw::c_int,
        __fd2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut __environ: *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn execve(
        __path: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
        __envp: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fexecve(
        __fd: ::std::os::raw::c_int,
        __argv: *const *mut ::std::os::raw::c_char,
        __envp: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execv(
        __path: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execle(
        __path: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execl(
        __path: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execvp(
        __file: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execlp(
        __file: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nice(__inc: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _exit(__status: ::std::os::raw::c_int);
}
pub mod _bindgen_ty_7 {
    pub type Type = ::std::os::raw::c_uint;
    pub const _PC_LINK_MAX: Type = 0;
    pub const _PC_MAX_CANON: Type = 1;
    pub const _PC_MAX_INPUT: Type = 2;
    pub const _PC_NAME_MAX: Type = 3;
    pub const _PC_PATH_MAX: Type = 4;
    pub const _PC_PIPE_BUF: Type = 5;
    pub const _PC_CHOWN_RESTRICTED: Type = 6;
    pub const _PC_NO_TRUNC: Type = 7;
    pub const _PC_VDISABLE: Type = 8;
    pub const _PC_SYNC_IO: Type = 9;
    pub const _PC_ASYNC_IO: Type = 10;
    pub const _PC_PRIO_IO: Type = 11;
    pub const _PC_SOCK_MAXBUF: Type = 12;
    pub const _PC_FILESIZEBITS: Type = 13;
    pub const _PC_REC_INCR_XFER_SIZE: Type = 14;
    pub const _PC_REC_MAX_XFER_SIZE: Type = 15;
    pub const _PC_REC_MIN_XFER_SIZE: Type = 16;
    pub const _PC_REC_XFER_ALIGN: Type = 17;
    pub const _PC_ALLOC_SIZE_MIN: Type = 18;
    pub const _PC_SYMLINK_MAX: Type = 19;
    pub const _PC_2_SYMLINKS: Type = 20;
}
pub mod _bindgen_ty_8 {
    pub type Type = ::std::os::raw::c_uint;
    pub const _SC_ARG_MAX: Type = 0;
    pub const _SC_CHILD_MAX: Type = 1;
    pub const _SC_CLK_TCK: Type = 2;
    pub const _SC_NGROUPS_MAX: Type = 3;
    pub const _SC_OPEN_MAX: Type = 4;
    pub const _SC_STREAM_MAX: Type = 5;
    pub const _SC_TZNAME_MAX: Type = 6;
    pub const _SC_JOB_CONTROL: Type = 7;
    pub const _SC_SAVED_IDS: Type = 8;
    pub const _SC_REALTIME_SIGNALS: Type = 9;
    pub const _SC_PRIORITY_SCHEDULING: Type = 10;
    pub const _SC_TIMERS: Type = 11;
    pub const _SC_ASYNCHRONOUS_IO: Type = 12;
    pub const _SC_PRIORITIZED_IO: Type = 13;
    pub const _SC_SYNCHRONIZED_IO: Type = 14;
    pub const _SC_FSYNC: Type = 15;
    pub const _SC_MAPPED_FILES: Type = 16;
    pub const _SC_MEMLOCK: Type = 17;
    pub const _SC_MEMLOCK_RANGE: Type = 18;
    pub const _SC_MEMORY_PROTECTION: Type = 19;
    pub const _SC_MESSAGE_PASSING: Type = 20;
    pub const _SC_SEMAPHORES: Type = 21;
    pub const _SC_SHARED_MEMORY_OBJECTS: Type = 22;
    pub const _SC_AIO_LISTIO_MAX: Type = 23;
    pub const _SC_AIO_MAX: Type = 24;
    pub const _SC_AIO_PRIO_DELTA_MAX: Type = 25;
    pub const _SC_DELAYTIMER_MAX: Type = 26;
    pub const _SC_MQ_OPEN_MAX: Type = 27;
    pub const _SC_MQ_PRIO_MAX: Type = 28;
    pub const _SC_VERSION: Type = 29;
    pub const _SC_PAGESIZE: Type = 30;
    pub const _SC_RTSIG_MAX: Type = 31;
    pub const _SC_SEM_NSEMS_MAX: Type = 32;
    pub const _SC_SEM_VALUE_MAX: Type = 33;
    pub const _SC_SIGQUEUE_MAX: Type = 34;
    pub const _SC_TIMER_MAX: Type = 35;
    pub const _SC_BC_BASE_MAX: Type = 36;
    pub const _SC_BC_DIM_MAX: Type = 37;
    pub const _SC_BC_SCALE_MAX: Type = 38;
    pub const _SC_BC_STRING_MAX: Type = 39;
    pub const _SC_COLL_WEIGHTS_MAX: Type = 40;
    pub const _SC_EQUIV_CLASS_MAX: Type = 41;
    pub const _SC_EXPR_NEST_MAX: Type = 42;
    pub const _SC_LINE_MAX: Type = 43;
    pub const _SC_RE_DUP_MAX: Type = 44;
    pub const _SC_CHARCLASS_NAME_MAX: Type = 45;
    pub const _SC_2_VERSION: Type = 46;
    pub const _SC_2_C_BIND: Type = 47;
    pub const _SC_2_C_DEV: Type = 48;
    pub const _SC_2_FORT_DEV: Type = 49;
    pub const _SC_2_FORT_RUN: Type = 50;
    pub const _SC_2_SW_DEV: Type = 51;
    pub const _SC_2_LOCALEDEF: Type = 52;
    pub const _SC_PII: Type = 53;
    pub const _SC_PII_XTI: Type = 54;
    pub const _SC_PII_SOCKET: Type = 55;
    pub const _SC_PII_INTERNET: Type = 56;
    pub const _SC_PII_OSI: Type = 57;
    pub const _SC_POLL: Type = 58;
    pub const _SC_SELECT: Type = 59;
    pub const _SC_UIO_MAXIOV: Type = 60;
    pub const _SC_IOV_MAX: Type = 60;
    pub const _SC_PII_INTERNET_STREAM: Type = 61;
    pub const _SC_PII_INTERNET_DGRAM: Type = 62;
    pub const _SC_PII_OSI_COTS: Type = 63;
    pub const _SC_PII_OSI_CLTS: Type = 64;
    pub const _SC_PII_OSI_M: Type = 65;
    pub const _SC_T_IOV_MAX: Type = 66;
    pub const _SC_THREADS: Type = 67;
    pub const _SC_THREAD_SAFE_FUNCTIONS: Type = 68;
    pub const _SC_GETGR_R_SIZE_MAX: Type = 69;
    pub const _SC_GETPW_R_SIZE_MAX: Type = 70;
    pub const _SC_LOGIN_NAME_MAX: Type = 71;
    pub const _SC_TTY_NAME_MAX: Type = 72;
    pub const _SC_THREAD_DESTRUCTOR_ITERATIONS: Type = 73;
    pub const _SC_THREAD_KEYS_MAX: Type = 74;
    pub const _SC_THREAD_STACK_MIN: Type = 75;
    pub const _SC_THREAD_THREADS_MAX: Type = 76;
    pub const _SC_THREAD_ATTR_STACKADDR: Type = 77;
    pub const _SC_THREAD_ATTR_STACKSIZE: Type = 78;
    pub const _SC_THREAD_PRIORITY_SCHEDULING: Type = 79;
    pub const _SC_THREAD_PRIO_INHERIT: Type = 80;
    pub const _SC_THREAD_PRIO_PROTECT: Type = 81;
    pub const _SC_THREAD_PROCESS_SHARED: Type = 82;
    pub const _SC_NPROCESSORS_CONF: Type = 83;
    pub const _SC_NPROCESSORS_ONLN: Type = 84;
    pub const _SC_PHYS_PAGES: Type = 85;
    pub const _SC_AVPHYS_PAGES: Type = 86;
    pub const _SC_ATEXIT_MAX: Type = 87;
    pub const _SC_PASS_MAX: Type = 88;
    pub const _SC_XOPEN_VERSION: Type = 89;
    pub const _SC_XOPEN_XCU_VERSION: Type = 90;
    pub const _SC_XOPEN_UNIX: Type = 91;
    pub const _SC_XOPEN_CRYPT: Type = 92;
    pub const _SC_XOPEN_ENH_I18N: Type = 93;
    pub const _SC_XOPEN_SHM: Type = 94;
    pub const _SC_2_CHAR_TERM: Type = 95;
    pub const _SC_2_C_VERSION: Type = 96;
    pub const _SC_2_UPE: Type = 97;
    pub const _SC_XOPEN_XPG2: Type = 98;
    pub const _SC_XOPEN_XPG3: Type = 99;
    pub const _SC_XOPEN_XPG4: Type = 100;
    pub const _SC_CHAR_BIT: Type = 101;
    pub const _SC_CHAR_MAX: Type = 102;
    pub const _SC_CHAR_MIN: Type = 103;
    pub const _SC_INT_MAX: Type = 104;
    pub const _SC_INT_MIN: Type = 105;
    pub const _SC_LONG_BIT: Type = 106;
    pub const _SC_WORD_BIT: Type = 107;
    pub const _SC_MB_LEN_MAX: Type = 108;
    pub const _SC_NZERO: Type = 109;
    pub const _SC_SSIZE_MAX: Type = 110;
    pub const _SC_SCHAR_MAX: Type = 111;
    pub const _SC_SCHAR_MIN: Type = 112;
    pub const _SC_SHRT_MAX: Type = 113;
    pub const _SC_SHRT_MIN: Type = 114;
    pub const _SC_UCHAR_MAX: Type = 115;
    pub const _SC_UINT_MAX: Type = 116;
    pub const _SC_ULONG_MAX: Type = 117;
    pub const _SC_USHRT_MAX: Type = 118;
    pub const _SC_NL_ARGMAX: Type = 119;
    pub const _SC_NL_LANGMAX: Type = 120;
    pub const _SC_NL_MSGMAX: Type = 121;
    pub const _SC_NL_NMAX: Type = 122;
    pub const _SC_NL_SETMAX: Type = 123;
    pub const _SC_NL_TEXTMAX: Type = 124;
    pub const _SC_XBS5_ILP32_OFF32: Type = 125;
    pub const _SC_XBS5_ILP32_OFFBIG: Type = 126;
    pub const _SC_XBS5_LP64_OFF64: Type = 127;
    pub const _SC_XBS5_LPBIG_OFFBIG: Type = 128;
    pub const _SC_XOPEN_LEGACY: Type = 129;
    pub const _SC_XOPEN_REALTIME: Type = 130;
    pub const _SC_XOPEN_REALTIME_THREADS: Type = 131;
    pub const _SC_ADVISORY_INFO: Type = 132;
    pub const _SC_BARRIERS: Type = 133;
    pub const _SC_BASE: Type = 134;
    pub const _SC_C_LANG_SUPPORT: Type = 135;
    pub const _SC_C_LANG_SUPPORT_R: Type = 136;
    pub const _SC_CLOCK_SELECTION: Type = 137;
    pub const _SC_CPUTIME: Type = 138;
    pub const _SC_THREAD_CPUTIME: Type = 139;
    pub const _SC_DEVICE_IO: Type = 140;
    pub const _SC_DEVICE_SPECIFIC: Type = 141;
    pub const _SC_DEVICE_SPECIFIC_R: Type = 142;
    pub const _SC_FD_MGMT: Type = 143;
    pub const _SC_FIFO: Type = 144;
    pub const _SC_PIPE: Type = 145;
    pub const _SC_FILE_ATTRIBUTES: Type = 146;
    pub const _SC_FILE_LOCKING: Type = 147;
    pub const _SC_FILE_SYSTEM: Type = 148;
    pub const _SC_MONOTONIC_CLOCK: Type = 149;
    pub const _SC_MULTI_PROCESS: Type = 150;
    pub const _SC_SINGLE_PROCESS: Type = 151;
    pub const _SC_NETWORKING: Type = 152;
    pub const _SC_READER_WRITER_LOCKS: Type = 153;
    pub const _SC_SPIN_LOCKS: Type = 154;
    pub const _SC_REGEXP: Type = 155;
    pub const _SC_REGEX_VERSION: Type = 156;
    pub const _SC_SHELL: Type = 157;
    pub const _SC_SIGNALS: Type = 158;
    pub const _SC_SPAWN: Type = 159;
    pub const _SC_SPORADIC_SERVER: Type = 160;
    pub const _SC_THREAD_SPORADIC_SERVER: Type = 161;
    pub const _SC_SYSTEM_DATABASE: Type = 162;
    pub const _SC_SYSTEM_DATABASE_R: Type = 163;
    pub const _SC_TIMEOUTS: Type = 164;
    pub const _SC_TYPED_MEMORY_OBJECTS: Type = 165;
    pub const _SC_USER_GROUPS: Type = 166;
    pub const _SC_USER_GROUPS_R: Type = 167;
    pub const _SC_2_PBS: Type = 168;
    pub const _SC_2_PBS_ACCOUNTING: Type = 169;
    pub const _SC_2_PBS_LOCATE: Type = 170;
    pub const _SC_2_PBS_MESSAGE: Type = 171;
    pub const _SC_2_PBS_TRACK: Type = 172;
    pub const _SC_SYMLOOP_MAX: Type = 173;
    pub const _SC_STREAMS: Type = 174;
    pub const _SC_2_PBS_CHECKPOINT: Type = 175;
    pub const _SC_V6_ILP32_OFF32: Type = 176;
    pub const _SC_V6_ILP32_OFFBIG: Type = 177;
    pub const _SC_V6_LP64_OFF64: Type = 178;
    pub const _SC_V6_LPBIG_OFFBIG: Type = 179;
    pub const _SC_HOST_NAME_MAX: Type = 180;
    pub const _SC_TRACE: Type = 181;
    pub const _SC_TRACE_EVENT_FILTER: Type = 182;
    pub const _SC_TRACE_INHERIT: Type = 183;
    pub const _SC_TRACE_LOG: Type = 184;
    pub const _SC_LEVEL1_ICACHE_SIZE: Type = 185;
    pub const _SC_LEVEL1_ICACHE_ASSOC: Type = 186;
    pub const _SC_LEVEL1_ICACHE_LINESIZE: Type = 187;
    pub const _SC_LEVEL1_DCACHE_SIZE: Type = 188;
    pub const _SC_LEVEL1_DCACHE_ASSOC: Type = 189;
    pub const _SC_LEVEL1_DCACHE_LINESIZE: Type = 190;
    pub const _SC_LEVEL2_CACHE_SIZE: Type = 191;
    pub const _SC_LEVEL2_CACHE_ASSOC: Type = 192;
    pub const _SC_LEVEL2_CACHE_LINESIZE: Type = 193;
    pub const _SC_LEVEL3_CACHE_SIZE: Type = 194;
    pub const _SC_LEVEL3_CACHE_ASSOC: Type = 195;
    pub const _SC_LEVEL3_CACHE_LINESIZE: Type = 196;
    pub const _SC_LEVEL4_CACHE_SIZE: Type = 197;
    pub const _SC_LEVEL4_CACHE_ASSOC: Type = 198;
    pub const _SC_LEVEL4_CACHE_LINESIZE: Type = 199;
    pub const _SC_IPV6: Type = 235;
    pub const _SC_RAW_SOCKETS: Type = 236;
    pub const _SC_V7_ILP32_OFF32: Type = 237;
    pub const _SC_V7_ILP32_OFFBIG: Type = 238;
    pub const _SC_V7_LP64_OFF64: Type = 239;
    pub const _SC_V7_LPBIG_OFFBIG: Type = 240;
    pub const _SC_SS_REPL_MAX: Type = 241;
    pub const _SC_TRACE_EVENT_NAME_MAX: Type = 242;
    pub const _SC_TRACE_NAME_MAX: Type = 243;
    pub const _SC_TRACE_SYS_MAX: Type = 244;
    pub const _SC_TRACE_USER_EVENT_MAX: Type = 245;
    pub const _SC_XOPEN_STREAMS: Type = 246;
    pub const _SC_THREAD_ROBUST_PRIO_INHERIT: Type = 247;
    pub const _SC_THREAD_ROBUST_PRIO_PROTECT: Type = 248;
}
pub mod _bindgen_ty_9 {
    pub type Type = ::std::os::raw::c_uint;
    pub const _CS_PATH: Type = 0;
    pub const _CS_V6_WIDTH_RESTRICTED_ENVS: Type = 1;
    pub const _CS_GNU_LIBC_VERSION: Type = 2;
    pub const _CS_GNU_LIBPTHREAD_VERSION: Type = 3;
    pub const _CS_V5_WIDTH_RESTRICTED_ENVS: Type = 4;
    pub const _CS_V7_WIDTH_RESTRICTED_ENVS: Type = 5;
    pub const _CS_LFS_CFLAGS: Type = 1000;
    pub const _CS_LFS_LDFLAGS: Type = 1001;
    pub const _CS_LFS_LIBS: Type = 1002;
    pub const _CS_LFS_LINTFLAGS: Type = 1003;
    pub const _CS_LFS64_CFLAGS: Type = 1004;
    pub const _CS_LFS64_LDFLAGS: Type = 1005;
    pub const _CS_LFS64_LIBS: Type = 1006;
    pub const _CS_LFS64_LINTFLAGS: Type = 1007;
    pub const _CS_XBS5_ILP32_OFF32_CFLAGS: Type = 1100;
    pub const _CS_XBS5_ILP32_OFF32_LDFLAGS: Type = 1101;
    pub const _CS_XBS5_ILP32_OFF32_LIBS: Type = 1102;
    pub const _CS_XBS5_ILP32_OFF32_LINTFLAGS: Type = 1103;
    pub const _CS_XBS5_ILP32_OFFBIG_CFLAGS: Type = 1104;
    pub const _CS_XBS5_ILP32_OFFBIG_LDFLAGS: Type = 1105;
    pub const _CS_XBS5_ILP32_OFFBIG_LIBS: Type = 1106;
    pub const _CS_XBS5_ILP32_OFFBIG_LINTFLAGS: Type = 1107;
    pub const _CS_XBS5_LP64_OFF64_CFLAGS: Type = 1108;
    pub const _CS_XBS5_LP64_OFF64_LDFLAGS: Type = 1109;
    pub const _CS_XBS5_LP64_OFF64_LIBS: Type = 1110;
    pub const _CS_XBS5_LP64_OFF64_LINTFLAGS: Type = 1111;
    pub const _CS_XBS5_LPBIG_OFFBIG_CFLAGS: Type = 1112;
    pub const _CS_XBS5_LPBIG_OFFBIG_LDFLAGS: Type = 1113;
    pub const _CS_XBS5_LPBIG_OFFBIG_LIBS: Type = 1114;
    pub const _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS: Type = 1115;
    pub const _CS_POSIX_V6_ILP32_OFF32_CFLAGS: Type = 1116;
    pub const _CS_POSIX_V6_ILP32_OFF32_LDFLAGS: Type = 1117;
    pub const _CS_POSIX_V6_ILP32_OFF32_LIBS: Type = 1118;
    pub const _CS_POSIX_V6_ILP32_OFF32_LINTFLAGS: Type = 1119;
    pub const _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS: Type = 1120;
    pub const _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS: Type = 1121;
    pub const _CS_POSIX_V6_ILP32_OFFBIG_LIBS: Type = 1122;
    pub const _CS_POSIX_V6_ILP32_OFFBIG_LINTFLAGS: Type = 1123;
    pub const _CS_POSIX_V6_LP64_OFF64_CFLAGS: Type = 1124;
    pub const _CS_POSIX_V6_LP64_OFF64_LDFLAGS: Type = 1125;
    pub const _CS_POSIX_V6_LP64_OFF64_LIBS: Type = 1126;
    pub const _CS_POSIX_V6_LP64_OFF64_LINTFLAGS: Type = 1127;
    pub const _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS: Type = 1128;
    pub const _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS: Type = 1129;
    pub const _CS_POSIX_V6_LPBIG_OFFBIG_LIBS: Type = 1130;
    pub const _CS_POSIX_V6_LPBIG_OFFBIG_LINTFLAGS: Type = 1131;
    pub const _CS_POSIX_V7_ILP32_OFF32_CFLAGS: Type = 1132;
    pub const _CS_POSIX_V7_ILP32_OFF32_LDFLAGS: Type = 1133;
    pub const _CS_POSIX_V7_ILP32_OFF32_LIBS: Type = 1134;
    pub const _CS_POSIX_V7_ILP32_OFF32_LINTFLAGS: Type = 1135;
    pub const _CS_POSIX_V7_ILP32_OFFBIG_CFLAGS: Type = 1136;
    pub const _CS_POSIX_V7_ILP32_OFFBIG_LDFLAGS: Type = 1137;
    pub const _CS_POSIX_V7_ILP32_OFFBIG_LIBS: Type = 1138;
    pub const _CS_POSIX_V7_ILP32_OFFBIG_LINTFLAGS: Type = 1139;
    pub const _CS_POSIX_V7_LP64_OFF64_CFLAGS: Type = 1140;
    pub const _CS_POSIX_V7_LP64_OFF64_LDFLAGS: Type = 1141;
    pub const _CS_POSIX_V7_LP64_OFF64_LIBS: Type = 1142;
    pub const _CS_POSIX_V7_LP64_OFF64_LINTFLAGS: Type = 1143;
    pub const _CS_POSIX_V7_LPBIG_OFFBIG_CFLAGS: Type = 1144;
    pub const _CS_POSIX_V7_LPBIG_OFFBIG_LDFLAGS: Type = 1145;
    pub const _CS_POSIX_V7_LPBIG_OFFBIG_LIBS: Type = 1146;
    pub const _CS_POSIX_V7_LPBIG_OFFBIG_LINTFLAGS: Type = 1147;
    pub const _CS_V6_ENV: Type = 1148;
    pub const _CS_V7_ENV: Type = 1149;
}
extern "C" {
    pub fn pathconf(
        __path: *const ::std::os::raw::c_char,
        __name: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn fpathconf(
        __fd: ::std::os::raw::c_int,
        __name: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn sysconf(__name: ::std::os::raw::c_int) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn confstr(
        __name: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn getpid() -> __pid_t;
}
extern "C" {
    pub fn getppid() -> __pid_t;
}
extern "C" {
    pub fn getpgrp() -> __pid_t;
}
extern "C" {
    pub fn __getpgid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn getpgid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn setpgid(__pid: __pid_t, __pgid: __pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpgrp() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsid() -> __pid_t;
}
extern "C" {
    pub fn getsid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn getuid() -> __uid_t;
}
extern "C" {
    pub fn geteuid() -> __uid_t;
}
extern "C" {
    pub fn getgid() -> __gid_t;
}
extern "C" {
    pub fn getegid() -> __gid_t;
}
extern "C" {
    pub fn getgroups(
        __size: ::std::os::raw::c_int,
        __list: *mut __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setuid(__uid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setreuid(__ruid: __uid_t, __euid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seteuid(__uid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setgid(__gid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setregid(__rgid: __gid_t, __egid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setegid(__gid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fork() -> __pid_t;
}
extern "C" {
    pub fn vfork() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyname(__fd: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ttyname_r(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isatty(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyslot() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn link(
        __from: *const ::std::os::raw::c_char,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn linkat(
        __fromfd: ::std::os::raw::c_int,
        __from: *const ::std::os::raw::c_char,
        __tofd: ::std::os::raw::c_int,
        __to: *const ::std::os::raw::c_char,
        __flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn symlink(
        __from: *const ::std::os::raw::c_char,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlink(
        __path: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn symlinkat(
        __from: *const ::std::os::raw::c_char,
        __tofd: ::std::os::raw::c_int,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlinkat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn unlink(
        __name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlinkat(
        __fd: ::std::os::raw::c_int,
        __name: *const ::std::os::raw::c_char,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rmdir(
        __path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcgetpgrp(__fd: ::std::os::raw::c_int) -> __pid_t;
}
extern "C" {
    pub fn tcsetpgrp(
        __fd: ::std::os::raw::c_int,
        __pgrp_id: __pid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getlogin() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getlogin_r(
        __name: *mut ::std::os::raw::c_char,
        __name_len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setlogin(
        __name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optarg: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut optind: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut opterr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optopt: ::std::os::raw::c_int;
}
extern "C" {
    pub fn getopt(
        ___argc: ::std::os::raw::c_int,
        ___argv: *const *mut ::std::os::raw::c_char,
        __shortopts: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostname(
        __name: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostname(
        __name: *const ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostid(__id: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdomainname(
        __name: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setdomainname(
        __name: *const ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vhangup() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn revoke(
        __file: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn profil(
        __sample_buffer: *mut ::std::os::raw::c_ushort,
        __size: size_t,
        __offset: size_t,
        __scale: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acct(__name: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getusershell() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn endusershell();
}
extern "C" {
    pub fn setusershell();
}
extern "C" {
    pub fn daemon(
        __nochdir: ::std::os::raw::c_int,
        __noclose: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chroot(
        __path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpass(
        __prompt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fsync(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostid() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn sync();
}
extern "C" {
    pub fn getpagesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdtablesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn truncate(
        __file: *const ::std::os::raw::c_char,
        __length: __off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftruncate(
        __fd: ::std::os::raw::c_int,
        __length: __off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn brk(__addr: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sbrk(__delta: isize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn syscall(
        __sysno: ::std::os::raw::c_long,
        ...
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lockf(
        __fd: ::std::os::raw::c_int,
        __cmd: ::std::os::raw::c_int,
        __len: __off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fdatasync(__fildes: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn crypt(
        __key: *const ::std::os::raw::c_char,
        __salt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getentropy(
        __buffer: *mut ::std::os::raw::c_void,
        __length: size_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ly_out {
    _unused: [u8; 0],
}
pub mod LY_OUT_TYPE {
    pub type Type = ::std::os::raw::c_int;
    pub const LY_OUT_ERROR: Type = -1;
    pub const LY_OUT_FD: Type = 0;
    pub const LY_OUT_FDSTREAM: Type = 1;
    pub const LY_OUT_FILE: Type = 2;
    pub const LY_OUT_FILEPATH: Type = 3;
    pub const LY_OUT_MEMORY: Type = 4;
    pub const LY_OUT_CALLBACK: Type = 5;
}
extern "C" {
    pub fn ly_out_type(out: *const ly_out) -> LY_OUT_TYPE::Type;
}
extern "C" {
    pub fn ly_out_reset(out: *mut ly_out) -> LY_ERR::Type;
}
pub type ly_write_clb = ::std::option::Option<
    unsafe extern "C" fn(
        user_data: *mut ::std::os::raw::c_void,
        buf: *const ::std::os::raw::c_void,
        count: size_t,
    ) -> ssize_t,
>;
extern "C" {
    pub fn ly_out_new_clb(
        writeclb: ly_write_clb,
        user_data: *mut ::std::os::raw::c_void,
        out: *mut *mut ly_out,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_out_clb(out: *mut ly_out, writeclb: ly_write_clb)
        -> ly_write_clb;
}
extern "C" {
    pub fn ly_out_clb_arg(
        out: *mut ly_out,
        arg: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ly_out_new_fd(
        fd: ::std::os::raw::c_int,
        out: *mut *mut ly_out,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_out_fd(
        out: *mut ly_out,
        fd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ly_out_new_file(f: *mut FILE, out: *mut *mut ly_out)
        -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_out_file(out: *mut ly_out, f: *mut FILE) -> *mut FILE;
}
extern "C" {
    pub fn ly_out_new_memory(
        strp: *mut *mut ::std::os::raw::c_char,
        size: size_t,
        out: *mut *mut ly_out,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_out_memory(
        out: *mut ly_out,
        strp: *mut *mut ::std::os::raw::c_char,
        size: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ly_out_new_filepath(
        filepath: *const ::std::os::raw::c_char,
        out: *mut *mut ly_out,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_out_filepath(
        out: *mut ly_out,
        filepath: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn ly_print(
        out: *mut ly_out,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_print_flush(out: *mut ly_out);
}
extern "C" {
    pub fn ly_write(
        out: *mut ly_out,
        buf: *const ::std::os::raw::c_char,
        len: size_t,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_out_printed(out: *const ly_out) -> size_t;
}
extern "C" {
    pub fn ly_out_free(
        out: *mut ly_out,
        clb_arg_destructor: ::std::option::Option<
            unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void),
        >,
        destroy: ly_bool,
    );
}
extern "C" {
    pub fn lyd_parse_data(
        ctx: *const ly_ctx,
        parent: *mut lyd_node,
        in_: *mut ly_in,
        format: LYD_FORMAT::Type,
        parse_options: u32,
        validate_options: u32,
        tree: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_parse_data_mem(
        ctx: *const ly_ctx,
        data: *const ::std::os::raw::c_char,
        format: LYD_FORMAT::Type,
        parse_options: u32,
        validate_options: u32,
        tree: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_parse_data_fd(
        ctx: *const ly_ctx,
        fd: ::std::os::raw::c_int,
        format: LYD_FORMAT::Type,
        parse_options: u32,
        validate_options: u32,
        tree: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_parse_data_path(
        ctx: *const ly_ctx,
        path: *const ::std::os::raw::c_char,
        format: LYD_FORMAT::Type,
        parse_options: u32,
        validate_options: u32,
        tree: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_parse_ext_data(
        ext: *const lysc_ext_instance,
        parent: *mut lyd_node,
        in_: *mut ly_in,
        format: LYD_FORMAT::Type,
        parse_options: u32,
        validate_options: u32,
        tree: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
pub mod lyd_type {
    pub type Type = ::std::os::raw::c_uint;
    pub const LYD_TYPE_DATA_YANG: Type = 0;
    pub const LYD_TYPE_RPC_YANG: Type = 1;
    pub const LYD_TYPE_NOTIF_YANG: Type = 2;
    pub const LYD_TYPE_REPLY_YANG: Type = 3;
    pub const LYD_TYPE_RPC_NETCONF: Type = 4;
    pub const LYD_TYPE_NOTIF_NETCONF: Type = 5;
    pub const LYD_TYPE_REPLY_NETCONF: Type = 6;
}
extern "C" {
    pub fn lyd_parse_op(
        ctx: *const ly_ctx,
        parent: *mut lyd_node,
        in_: *mut ly_in,
        format: LYD_FORMAT::Type,
        data_type: lyd_type::Type,
        tree: *mut *mut lyd_node,
        op: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_parse_ext_op(
        ext: *const lysc_ext_instance,
        parent: *mut lyd_node,
        in_: *mut ly_in,
        format: LYD_FORMAT::Type,
        data_type: lyd_type::Type,
        tree: *mut *mut lyd_node,
        op: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_validate_all(
        tree: *mut *mut lyd_node,
        ctx: *const ly_ctx,
        val_opts: u32,
        diff: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_validate_module(
        tree: *mut *mut lyd_node,
        module: *const lys_module,
        val_opts: u32,
        diff: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_validate_op(
        op_tree: *mut lyd_node,
        dep_tree: *const lyd_node,
        data_type: lyd_type::Type,
        diff: *mut *mut lyd_node,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_print_all(
        out: *mut ly_out,
        root: *const lyd_node,
        format: LYD_FORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_print_tree(
        out: *mut ly_out,
        root: *const lyd_node,
        format: LYD_FORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_print_mem(
        strp: *mut *mut ::std::os::raw::c_char,
        root: *const lyd_node,
        format: LYD_FORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_print_fd(
        fd: ::std::os::raw::c_int,
        root: *const lyd_node,
        format: LYD_FORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_print_file(
        f: *mut FILE,
        root: *const lyd_node,
        format: LYD_FORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_print_path(
        path: *const ::std::os::raw::c_char,
        root: *const lyd_node,
        format: LYD_FORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lyd_print_clb(
        writeclb: ly_write_clb,
        user_data: *mut ::std::os::raw::c_void,
        root: *const lyd_node,
        format: LYD_FORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
pub mod LYS_OUTFORMAT {
    pub type Type = ::std::os::raw::c_uint;
    pub const LYS_OUT_UNKNOWN: Type = 0;
    pub const LYS_OUT_YANG: Type = 1;
    pub const LYS_OUT_YANG_COMPILED: Type = 2;
    pub const LYS_OUT_YIN: Type = 3;
    pub const LYS_OUT_TREE: Type = 4;
}
extern "C" {
    pub fn lys_print_module(
        out: *mut ly_out,
        module: *const lys_module,
        format: LYS_OUTFORMAT::Type,
        line_length: size_t,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_print_submodule(
        out: *mut ly_out,
        submodule: *const lysp_submodule,
        format: LYS_OUTFORMAT::Type,
        line_length: size_t,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_print_mem(
        strp: *mut *mut ::std::os::raw::c_char,
        module: *const lys_module,
        format: LYS_OUTFORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_print_fd(
        fd: ::std::os::raw::c_int,
        module: *const lys_module,
        format: LYS_OUTFORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_print_file(
        f: *mut FILE,
        module: *const lys_module,
        format: LYS_OUTFORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_print_path(
        path: *const ::std::os::raw::c_char,
        module: *const lys_module,
        format: LYS_OUTFORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_print_clb(
        writeclb: ly_write_clb,
        user_data: *mut ::std::os::raw::c_void,
        module: *const lys_module,
        format: LYS_OUTFORMAT::Type,
        options: u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn lys_print_node(
        out: *mut ly_out,
        node: *const lysc_node,
        format: LYS_OUTFORMAT::Type,
        line_length: size_t,
        options: u32,
    ) -> LY_ERR::Type;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ly_set {
    pub size: u32,
    pub count: u32,
    pub __bindgen_anon_1: ly_set__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ly_set__bindgen_ty_1 {
    pub dnodes: *mut *mut lyd_node,
    pub snodes: *mut *mut lysc_node,
    pub objs: *mut *mut ::std::os::raw::c_void,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_ly_set__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<ly_set__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(ly_set__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<ly_set__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(ly_set__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_set__bindgen_ty_1>())).dnodes as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_set__bindgen_ty_1),
            "::",
            stringify!(dnodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_set__bindgen_ty_1>())).snodes as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_set__bindgen_ty_1),
            "::",
            stringify!(snodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_set__bindgen_ty_1>())).objs as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_set__bindgen_ty_1),
            "::",
            stringify!(objs)
        )
    );
}
impl Default for ly_set__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_ly_set() {
    assert_eq!(
        ::std::mem::size_of::<ly_set>(),
        16usize,
        concat!("Size of: ", stringify!(ly_set))
    );
    assert_eq!(
        ::std::mem::align_of::<ly_set>(),
        8usize,
        concat!("Alignment of ", stringify!(ly_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ly_set>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_set),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ly_set>())).count as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ly_set),
            "::",
            stringify!(count)
        )
    );
}
impl Default for ly_set {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn ly_set_new(set_p: *mut *mut ly_set) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_set_dup(
        set: *const ly_set,
        duplicator: ::std::option::Option<
            unsafe extern "C" fn(
                obj: *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void,
        >,
        newset_p: *mut *mut ly_set,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_set_add(
        set: *mut ly_set,
        object: *mut ::std::os::raw::c_void,
        list: ly_bool,
        index_p: *mut u32,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_set_merge(
        trg: *mut ly_set,
        src: *const ly_set,
        list: ly_bool,
        duplicator: ::std::option::Option<
            unsafe extern "C" fn(
                obj: *mut ::std::os::raw::c_void,
            ) -> *mut ::std::os::raw::c_void,
        >,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_set_contains(
        set: *const ly_set,
        object: *mut ::std::os::raw::c_void,
        index_p: *mut u32,
    ) -> ly_bool;
}
extern "C" {
    pub fn ly_set_clean(
        set: *mut ly_set,
        destructor: ::std::option::Option<
            unsafe extern "C" fn(obj: *mut ::std::os::raw::c_void),
        >,
    );
}
extern "C" {
    pub fn ly_set_rm(
        set: *mut ly_set,
        object: *mut ::std::os::raw::c_void,
        destructor: ::std::option::Option<
            unsafe extern "C" fn(obj: *mut ::std::os::raw::c_void),
        >,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_set_rm_index(
        set: *mut ly_set,
        index: u32,
        destructor: ::std::option::Option<
            unsafe extern "C" fn(obj: *mut ::std::os::raw::c_void),
        >,
    ) -> LY_ERR::Type;
}
extern "C" {
    pub fn ly_set_free(
        set: *mut ly_set,
        destructor: ::std::option::Option<
            unsafe extern "C" fn(obj: *mut ::std::os::raw::c_void),
        >,
    );
}
extern "C" {
    pub fn ly_set_erase(
        set: *mut ly_set,
        destructor: ::std::option::Option<
            unsafe extern "C" fn(obj: *mut ::std::os::raw::c_void),
        >,
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __locale_data {
    pub _address: u8,
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__va_list_tag>())).gp_offset as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__va_list_tag>())).fp_offset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__va_list_tag>())).overflow_arg_area
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__va_list_tag>())).reg_save_area as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
impl Default for __va_list_tag {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct lyplg_ext {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct lyplg_type {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct hash_table {
    pub _address: u8,
}
