/* automatically generated by rust-bindgen 0.58.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const __GNUC_VA_LIST: u32 = 1;
pub const _STDIO_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 31;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __LONG_DOUBLE_USES_FLOAT128: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_TYPES_H: u32 = 1;
pub const __TIMESIZE: u32 = 64;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _____fpos_t_defined: u32 = 1;
pub const ____mbstate_t_defined: u32 = 1;
pub const _____fpos64_t_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const __FILE_defined: u32 = 1;
pub const __struct_FILE_defined: u32 = 1;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const EOF: i32 = -1;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const P_tmpdir: &'static [u8; 5usize] = b"/tmp\0";
pub const _BITS_STDIO_LIM_H: u32 = 1;
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const _STDINT_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const _BITS_ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const _BITS_ENDIANNESS_H: u32 = 1;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __FD_ZERO_STOS: &'static [u8; 6usize] = b"stosq\0";
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const _THREAD_MUTEX_INTERNAL_H: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const __BITS_PER_LONG: u32 = 64;
pub const BPF_LD: u32 = 0;
pub const BPF_LDX: u32 = 1;
pub const BPF_ST: u32 = 2;
pub const BPF_STX: u32 = 3;
pub const BPF_ALU: u32 = 4;
pub const BPF_JMP: u32 = 5;
pub const BPF_RET: u32 = 6;
pub const BPF_MISC: u32 = 7;
pub const BPF_W: u32 = 0;
pub const BPF_H: u32 = 8;
pub const BPF_B: u32 = 16;
pub const BPF_IMM: u32 = 0;
pub const BPF_ABS: u32 = 32;
pub const BPF_IND: u32 = 64;
pub const BPF_MEM: u32 = 96;
pub const BPF_LEN: u32 = 128;
pub const BPF_MSH: u32 = 160;
pub const BPF_ADD: u32 = 0;
pub const BPF_SUB: u32 = 16;
pub const BPF_MUL: u32 = 32;
pub const BPF_DIV: u32 = 48;
pub const BPF_OR: u32 = 64;
pub const BPF_AND: u32 = 80;
pub const BPF_LSH: u32 = 96;
pub const BPF_RSH: u32 = 112;
pub const BPF_NEG: u32 = 128;
pub const BPF_MOD: u32 = 144;
pub const BPF_XOR: u32 = 160;
pub const BPF_JA: u32 = 0;
pub const BPF_JEQ: u32 = 16;
pub const BPF_JGT: u32 = 32;
pub const BPF_JGE: u32 = 48;
pub const BPF_JSET: u32 = 64;
pub const BPF_K: u32 = 0;
pub const BPF_X: u32 = 8;
pub const BPF_MAXINSNS: u32 = 4096;
pub const BPF_JMP32: u32 = 6;
pub const BPF_ALU64: u32 = 7;
pub const BPF_DW: u32 = 24;
pub const BPF_XADD: u32 = 192;
pub const BPF_MOV: u32 = 176;
pub const BPF_ARSH: u32 = 192;
pub const BPF_END: u32 = 208;
pub const BPF_TO_LE: u32 = 0;
pub const BPF_TO_BE: u32 = 8;
pub const BPF_FROM_LE: u32 = 0;
pub const BPF_FROM_BE: u32 = 8;
pub const BPF_JNE: u32 = 80;
pub const BPF_JLT: u32 = 160;
pub const BPF_JLE: u32 = 176;
pub const BPF_JSGT: u32 = 96;
pub const BPF_JSGE: u32 = 112;
pub const BPF_JSLT: u32 = 192;
pub const BPF_JSLE: u32 = 208;
pub const BPF_CALL: u32 = 128;
pub const BPF_EXIT: u32 = 144;
pub const BPF_F_ALLOW_OVERRIDE: u32 = 1;
pub const BPF_F_ALLOW_MULTI: u32 = 2;
pub const BPF_F_STRICT_ALIGNMENT: u32 = 1;
pub const BPF_F_ANY_ALIGNMENT: u32 = 2;
pub const BPF_F_TEST_RND_HI32: u32 = 4;
pub const BPF_F_TEST_STATE_FREQ: u32 = 8;
pub const BPF_PSEUDO_MAP_FD: u32 = 1;
pub const BPF_PSEUDO_MAP_VALUE: u32 = 2;
pub const BPF_PSEUDO_CALL: u32 = 1;
pub const BPF_ANY: u32 = 0;
pub const BPF_NOEXIST: u32 = 1;
pub const BPF_EXIST: u32 = 2;
pub const BPF_F_LOCK: u32 = 4;
pub const BPF_F_NO_PREALLOC: u32 = 1;
pub const BPF_F_NO_COMMON_LRU: u32 = 2;
pub const BPF_F_NUMA_NODE: u32 = 4;
pub const BPF_OBJ_NAME_LEN: u32 = 16;
pub const BPF_F_RDONLY: u32 = 8;
pub const BPF_F_WRONLY: u32 = 16;
pub const BPF_F_STACK_BUILD_ID: u32 = 32;
pub const BPF_F_ZERO_SEED: u32 = 64;
pub const BPF_F_RDONLY_PROG: u32 = 128;
pub const BPF_F_WRONLY_PROG: u32 = 256;
pub const BPF_F_CLONE: u32 = 512;
pub const BPF_F_QUERY_EFFECTIVE: u32 = 1;
pub const BPF_BUILD_ID_SIZE: u32 = 20;
pub const BPF_F_RECOMPUTE_CSUM: u32 = 1;
pub const BPF_F_INVALIDATE_HASH: u32 = 2;
pub const BPF_F_HDR_FIELD_MASK: u32 = 15;
pub const BPF_F_PSEUDO_HDR: u32 = 16;
pub const BPF_F_MARK_MANGLED_0: u32 = 32;
pub const BPF_F_MARK_ENFORCE: u32 = 64;
pub const BPF_F_INGRESS: u32 = 1;
pub const BPF_F_TUNINFO_IPV6: u32 = 1;
pub const BPF_F_SKIP_FIELD_MASK: u32 = 255;
pub const BPF_F_USER_STACK: u32 = 256;
pub const BPF_F_FAST_STACK_CMP: u32 = 512;
pub const BPF_F_REUSE_STACKID: u32 = 1024;
pub const BPF_F_USER_BUILD_ID: u32 = 2048;
pub const BPF_F_ZERO_CSUM_TX: u32 = 2;
pub const BPF_F_DONT_FRAGMENT: u32 = 4;
pub const BPF_F_SEQ_NUMBER: u32 = 8;
pub const BPF_F_INDEX_MASK: u32 = 4294967295;
pub const BPF_F_CURRENT_CPU: u32 = 4294967295;
pub const BPF_F_CTXLEN_MASK: u64 = 4503595332403200;
pub const BPF_F_CURRENT_NETNS: i32 = -1;
pub const BPF_F_ADJ_ROOM_FIXED_GSO: u32 = 1;
pub const BPF_ADJ_ROOM_ENCAP_L2_MASK: u32 = 255;
pub const BPF_ADJ_ROOM_ENCAP_L2_SHIFT: u32 = 56;
pub const BPF_F_ADJ_ROOM_ENCAP_L3_IPV4: u32 = 2;
pub const BPF_F_ADJ_ROOM_ENCAP_L3_IPV6: u32 = 4;
pub const BPF_F_ADJ_ROOM_ENCAP_L4_GRE: u32 = 8;
pub const BPF_F_ADJ_ROOM_ENCAP_L4_UDP: u32 = 16;
pub const BPF_F_SYSCTL_BASE_NAME: u32 = 1;
pub const BPF_SK_STORAGE_GET_F_CREATE: u32 = 1;
pub const XDP_PACKET_HEADROOM: u32 = 256;
pub const BPF_TAG_SIZE: u32 = 8;
pub const BPF_SOCK_OPS_RTO_CB_FLAG: u32 = 1;
pub const BPF_SOCK_OPS_RETRANS_CB_FLAG: u32 = 2;
pub const BPF_SOCK_OPS_STATE_CB_FLAG: u32 = 4;
pub const BPF_SOCK_OPS_RTT_CB_FLAG: u32 = 8;
pub const BPF_SOCK_OPS_ALL_CB_FLAGS: u32 = 15;
pub const TCP_BPF_IW: u32 = 1001;
pub const TCP_BPF_SNDCWND_CLAMP: u32 = 1002;
pub const BPF_DEVCG_ACC_MKNOD: u32 = 1;
pub const BPF_DEVCG_ACC_READ: u32 = 2;
pub const BPF_DEVCG_ACC_WRITE: u32 = 4;
pub const BPF_DEVCG_DEV_BLOCK: u32 = 1;
pub const BPF_DEVCG_DEV_CHAR: u32 = 2;
pub const BPF_FIB_LOOKUP_DIRECT: u32 = 1;
pub const BPF_FIB_LOOKUP_OUTPUT: u32 = 2;
pub const BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG: u32 = 1;
pub const BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL: u32 = 2;
pub const BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP: u32 = 4;
pub const _STRING_H: u32 = 1;
pub const _BITS_TYPES_LOCALE_T_H: u32 = 1;
pub const _BITS_TYPES___LOCALE_T_H: u32 = 1;
pub const _STRINGS_H: u32 = 1;
pub const XDP_DEFAULT_RUN_PRIO: u32 = 50;
pub const MAPS_RELAX_COMPAT: u32 = 1;
pub const BPF_LOG_BUF_SIZE: u32 = 16777215;
pub const XDP_BPFFS_ENVVAR: &'static [u8; 13usize] = b"LIBXDP_BPFFS\0";
pub const XDP_OBJECT_ENVVAR: &'static [u8; 19usize] = b"LIBXDP_OBJECT_PATH\0";
pub const XDP_METADATA_SECTION: &'static [u8; 13usize] = b"xdp_metadata\0";
pub const XDP_DISPATCHER_VERSION: u32 = 1;
pub const XDP_DISPATCHER_RETVAL: u32 = 31;
pub const MAX_DISPATCHER_ACTIONS: u32 = 10;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
pub type size_t = ::std::os::raw::c_ulong;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
}
#[test]
fn bindgen_test_layout___mbstate_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wchb as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wchb)
        )
    );
}
impl Default for __mbstate_t__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        8usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__value)
        )
    );
}
impl Default for __mbstate_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__state)
        )
    );
}
impl Default for _G_fpos_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __fpos_t = _G_fpos_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos64_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos64_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__state)
        )
    );
}
impl Default for _G_fpos64_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __fpos64_t = _G_fpos64_t;
pub type __FILE = _IO_FILE;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: size_t,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_end as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_base as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_base as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_end as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_base as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_end as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_base as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_backup_base as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_end as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._markers as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._chain as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._fileno as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags2 as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._old_offset as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._cur_column as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._vtable_offset as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._shortbuf as *const _ as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._lock as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._codecvt as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_codecvt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._wide_data as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_wide_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._freeres_list as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._freeres_buf as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad5 as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._mode as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._unused2 as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
impl Default for _IO_FILE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type off_t = __off_t;
pub type ssize_t = __ssize_t;
pub type fpos_t = __fpos_t;
extern "C" {
    pub static mut stdin: *mut FILE;
}
extern "C" {
    pub static mut stdout: *mut FILE;
}
extern "C" {
    pub static mut stderr: *mut FILE;
}
extern "C" {
    pub fn remove(__filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameat(
        __oldfd: ::std::os::raw::c_int,
        __old: *const ::std::os::raw::c_char,
        __newfd: ::std::os::raw::c_int,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpnam_r(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn freopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
        __stream: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fdopen(__fd: ::std::os::raw::c_int, __modes: *const ::std::os::raw::c_char)
        -> *mut FILE;
}
extern "C" {
    pub fn fmemopen(
        __s: *mut ::std::os::raw::c_void,
        __len: size_t,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufloc: *mut *mut ::std::os::raw::c_char,
        __sizeloc: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub fn setbuf(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        __stream: *mut FILE,
        __buf: *mut ::std::os::raw::c_char,
        __modes: ::std::os::raw::c_int,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char, __size: size_t);
}
extern "C" {
    pub fn setlinebuf(__stream: *mut FILE);
}
extern "C" {
    pub fn fprintf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_fscanf"]
    pub fn fscanf1(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_scanf"]
    pub fn scanf1(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_sscanf"]
    pub fn sscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vfscanf"]
    pub fn vfscanf1(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vscanf"]
    pub fn vscanf1(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vsscanf"]
    pub fn vsscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(__w: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        __s: *mut ::std::os::raw::c_char,
        __n: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getline(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn fputs(__s: *const ::std::os::raw::c_char, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __s: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fread_unlocked(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fwrite_unlocked(
        __ptr: *const ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fseek(
        __stream: *mut FILE,
        __off: ::std::os::raw::c_long,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(__stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rewind(__stream: *mut FILE);
}
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __off: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> __off_t;
}
extern "C" {
    pub fn fgetpos(__stream: *mut FILE, __pos: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(__stream: *mut FILE, __pos: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr(__stream: *mut FILE);
}
extern "C" {
    pub fn feof(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr_unlocked(__stream: *mut FILE);
}
extern "C" {
    pub fn feof_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(__s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub static mut sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn fileno(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        __command: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn pclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn flockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn __uflow(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __overflow(arg1: *mut FILE, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = __uint8_t;
pub type u_int16_t = __uint16_t;
pub type u_int32_t = __uint32_t;
pub type u_int64_t = __uint64_t;
pub type register_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).__fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(__fds_bits)
        )
    );
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
impl Default for __pthread_internal_list {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct __pthread_internal_slist {
    pub __next: *mut __pthread_internal_slist,
}
#[test]
fn bindgen_test_layout___pthread_internal_slist() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_slist>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_internal_slist))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_slist>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_slist))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_slist>())).__next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_slist),
            "::",
            stringify!(__next)
        )
    );
}
impl Default for __pthread_internal_slist {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __pthread_slist_t = __pthread_internal_slist;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_mutex_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__owner as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__nusers as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__kind as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__spins as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__elision as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__list as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
impl Default for __pthread_mutex_s {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_rwlock_arch_t() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_rwlock_arch_t>(),
        56usize,
        concat!("Size of: ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_rwlock_arch_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__readers as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__wrphase_futex as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__wrphase_futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers_futex as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers_futex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad3 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad4 as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__cur_writer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__cur_writer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__shared as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__rwelision as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__rwelision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad1 as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad2 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __bindgen_anon_1: __pthread_cond_s__bindgen_ty_1,
    pub __bindgen_anon_2: __pthread_cond_s__bindgen_ty_2,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_1 {
    pub __wseq: ::std::os::raw::c_ulonglong,
    pub __wseq32: __pthread_cond_s__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq32 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq32)
        )
    );
}
impl Default for __pthread_cond_s__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_2 {
    pub __g1_start: ::std::os::raw::c_ulonglong,
    pub __g1_start32: __pthread_cond_s__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start32 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start32)
        )
    );
}
impl Default for __pthread_cond_s__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout___pthread_cond_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s>(),
        48usize,
        concat!("Size of: ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_refs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g1_orig_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g1_orig_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__wrefs as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__wrefs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_signals as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_signals)
        )
    );
}
impl Default for __pthread_cond_s {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_mutexattr_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_condattr_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_attr_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_mutex_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_cond_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_rwlock_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_rwlockattr_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_barrier_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_barrierattr_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __s8 = ::std::os::raw::c_schar;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___kernel_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__kernel_fd_set>())).fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_old_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ulong;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::std::os::raw::c_uint;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_int;
pub type __kernel_uid_t = ::std::os::raw::c_uint;
pub type __kernel_gid_t = ::std::os::raw::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___kernel_fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__kernel_fsid_t>())).val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_fsid_t),
            "::",
            stringify!(val)
        )
    );
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_time64_t = ::std::os::raw::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __poll_t = ::std::os::raw::c_uint;
pub const BPF_REG_0: ::std::os::raw::c_uint = 0;
pub const BPF_REG_1: ::std::os::raw::c_uint = 1;
pub const BPF_REG_2: ::std::os::raw::c_uint = 2;
pub const BPF_REG_3: ::std::os::raw::c_uint = 3;
pub const BPF_REG_4: ::std::os::raw::c_uint = 4;
pub const BPF_REG_5: ::std::os::raw::c_uint = 5;
pub const BPF_REG_6: ::std::os::raw::c_uint = 6;
pub const BPF_REG_7: ::std::os::raw::c_uint = 7;
pub const BPF_REG_8: ::std::os::raw::c_uint = 8;
pub const BPF_REG_9: ::std::os::raw::c_uint = 9;
pub const BPF_REG_10: ::std::os::raw::c_uint = 10;
pub const __MAX_BPF_REG: ::std::os::raw::c_uint = 11;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_insn {
    pub code: __u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub off: __s16,
    pub imm: __s32,
}
#[test]
fn bindgen_test_layout_bpf_insn() {
    assert_eq!(
        ::std::mem::size_of::<bpf_insn>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_insn))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_insn>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_insn))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_insn>())).code as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_insn),
            "::",
            stringify!(code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_insn>())).off as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_insn),
            "::",
            stringify!(off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_insn>())).imm as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_insn),
            "::",
            stringify!(imm)
        )
    );
}
impl bpf_insn {
    #[inline]
    pub fn dst_reg(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_dst_reg(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn src_reg(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_src_reg(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(dst_reg: __u8, src_reg: __u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let dst_reg: u8 = unsafe { ::std::mem::transmute(dst_reg) };
            dst_reg as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let src_reg: u8 = unsafe { ::std::mem::transmute(src_reg) };
            src_reg as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bpf_lpm_trie_key {
    pub prefixlen: __u32,
    pub data: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bpf_lpm_trie_key() {
    assert_eq!(
        ::std::mem::size_of::<bpf_lpm_trie_key>(),
        4usize,
        concat!("Size of: ", stringify!(bpf_lpm_trie_key))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_lpm_trie_key>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_lpm_trie_key))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_lpm_trie_key>())).prefixlen as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_lpm_trie_key),
            "::",
            stringify!(prefixlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_lpm_trie_key>())).data as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_lpm_trie_key),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_cgroup_storage_key {
    pub cgroup_inode_id: __u64,
    pub attach_type: __u32,
}
#[test]
fn bindgen_test_layout_bpf_cgroup_storage_key() {
    assert_eq!(
        ::std::mem::size_of::<bpf_cgroup_storage_key>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_cgroup_storage_key))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_cgroup_storage_key>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_cgroup_storage_key))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_cgroup_storage_key>())).cgroup_inode_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_cgroup_storage_key),
            "::",
            stringify!(cgroup_inode_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_cgroup_storage_key>())).attach_type as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_cgroup_storage_key),
            "::",
            stringify!(attach_type)
        )
    );
}
pub const bpf_cmd_BPF_MAP_CREATE: bpf_cmd = 0;
pub const bpf_cmd_BPF_MAP_LOOKUP_ELEM: bpf_cmd = 1;
pub const bpf_cmd_BPF_MAP_UPDATE_ELEM: bpf_cmd = 2;
pub const bpf_cmd_BPF_MAP_DELETE_ELEM: bpf_cmd = 3;
pub const bpf_cmd_BPF_MAP_GET_NEXT_KEY: bpf_cmd = 4;
pub const bpf_cmd_BPF_PROG_LOAD: bpf_cmd = 5;
pub const bpf_cmd_BPF_OBJ_PIN: bpf_cmd = 6;
pub const bpf_cmd_BPF_OBJ_GET: bpf_cmd = 7;
pub const bpf_cmd_BPF_PROG_ATTACH: bpf_cmd = 8;
pub const bpf_cmd_BPF_PROG_DETACH: bpf_cmd = 9;
pub const bpf_cmd_BPF_PROG_TEST_RUN: bpf_cmd = 10;
pub const bpf_cmd_BPF_PROG_GET_NEXT_ID: bpf_cmd = 11;
pub const bpf_cmd_BPF_MAP_GET_NEXT_ID: bpf_cmd = 12;
pub const bpf_cmd_BPF_PROG_GET_FD_BY_ID: bpf_cmd = 13;
pub const bpf_cmd_BPF_MAP_GET_FD_BY_ID: bpf_cmd = 14;
pub const bpf_cmd_BPF_OBJ_GET_INFO_BY_FD: bpf_cmd = 15;
pub const bpf_cmd_BPF_PROG_QUERY: bpf_cmd = 16;
pub const bpf_cmd_BPF_RAW_TRACEPOINT_OPEN: bpf_cmd = 17;
pub const bpf_cmd_BPF_BTF_LOAD: bpf_cmd = 18;
pub const bpf_cmd_BPF_BTF_GET_FD_BY_ID: bpf_cmd = 19;
pub const bpf_cmd_BPF_TASK_FD_QUERY: bpf_cmd = 20;
pub const bpf_cmd_BPF_MAP_LOOKUP_AND_DELETE_ELEM: bpf_cmd = 21;
pub const bpf_cmd_BPF_MAP_FREEZE: bpf_cmd = 22;
pub const bpf_cmd_BPF_BTF_GET_NEXT_ID: bpf_cmd = 23;
pub type bpf_cmd = ::std::os::raw::c_uint;
pub const bpf_map_type_BPF_MAP_TYPE_UNSPEC: bpf_map_type = 0;
pub const bpf_map_type_BPF_MAP_TYPE_HASH: bpf_map_type = 1;
pub const bpf_map_type_BPF_MAP_TYPE_ARRAY: bpf_map_type = 2;
pub const bpf_map_type_BPF_MAP_TYPE_PROG_ARRAY: bpf_map_type = 3;
pub const bpf_map_type_BPF_MAP_TYPE_PERF_EVENT_ARRAY: bpf_map_type = 4;
pub const bpf_map_type_BPF_MAP_TYPE_PERCPU_HASH: bpf_map_type = 5;
pub const bpf_map_type_BPF_MAP_TYPE_PERCPU_ARRAY: bpf_map_type = 6;
pub const bpf_map_type_BPF_MAP_TYPE_STACK_TRACE: bpf_map_type = 7;
pub const bpf_map_type_BPF_MAP_TYPE_CGROUP_ARRAY: bpf_map_type = 8;
pub const bpf_map_type_BPF_MAP_TYPE_LRU_HASH: bpf_map_type = 9;
pub const bpf_map_type_BPF_MAP_TYPE_LRU_PERCPU_HASH: bpf_map_type = 10;
pub const bpf_map_type_BPF_MAP_TYPE_LPM_TRIE: bpf_map_type = 11;
pub const bpf_map_type_BPF_MAP_TYPE_ARRAY_OF_MAPS: bpf_map_type = 12;
pub const bpf_map_type_BPF_MAP_TYPE_HASH_OF_MAPS: bpf_map_type = 13;
pub const bpf_map_type_BPF_MAP_TYPE_DEVMAP: bpf_map_type = 14;
pub const bpf_map_type_BPF_MAP_TYPE_SOCKMAP: bpf_map_type = 15;
pub const bpf_map_type_BPF_MAP_TYPE_CPUMAP: bpf_map_type = 16;
pub const bpf_map_type_BPF_MAP_TYPE_XSKMAP: bpf_map_type = 17;
pub const bpf_map_type_BPF_MAP_TYPE_SOCKHASH: bpf_map_type = 18;
pub const bpf_map_type_BPF_MAP_TYPE_CGROUP_STORAGE: bpf_map_type = 19;
pub const bpf_map_type_BPF_MAP_TYPE_REUSEPORT_SOCKARRAY: bpf_map_type = 20;
pub const bpf_map_type_BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE: bpf_map_type = 21;
pub const bpf_map_type_BPF_MAP_TYPE_QUEUE: bpf_map_type = 22;
pub const bpf_map_type_BPF_MAP_TYPE_STACK: bpf_map_type = 23;
pub const bpf_map_type_BPF_MAP_TYPE_SK_STORAGE: bpf_map_type = 24;
pub const bpf_map_type_BPF_MAP_TYPE_DEVMAP_HASH: bpf_map_type = 25;
pub type bpf_map_type = ::std::os::raw::c_uint;
pub const bpf_prog_type_BPF_PROG_TYPE_UNSPEC: bpf_prog_type = 0;
pub const bpf_prog_type_BPF_PROG_TYPE_SOCKET_FILTER: bpf_prog_type = 1;
pub const bpf_prog_type_BPF_PROG_TYPE_KPROBE: bpf_prog_type = 2;
pub const bpf_prog_type_BPF_PROG_TYPE_SCHED_CLS: bpf_prog_type = 3;
pub const bpf_prog_type_BPF_PROG_TYPE_SCHED_ACT: bpf_prog_type = 4;
pub const bpf_prog_type_BPF_PROG_TYPE_TRACEPOINT: bpf_prog_type = 5;
pub const bpf_prog_type_BPF_PROG_TYPE_XDP: bpf_prog_type = 6;
pub const bpf_prog_type_BPF_PROG_TYPE_PERF_EVENT: bpf_prog_type = 7;
pub const bpf_prog_type_BPF_PROG_TYPE_CGROUP_SKB: bpf_prog_type = 8;
pub const bpf_prog_type_BPF_PROG_TYPE_CGROUP_SOCK: bpf_prog_type = 9;
pub const bpf_prog_type_BPF_PROG_TYPE_LWT_IN: bpf_prog_type = 10;
pub const bpf_prog_type_BPF_PROG_TYPE_LWT_OUT: bpf_prog_type = 11;
pub const bpf_prog_type_BPF_PROG_TYPE_LWT_XMIT: bpf_prog_type = 12;
pub const bpf_prog_type_BPF_PROG_TYPE_SOCK_OPS: bpf_prog_type = 13;
pub const bpf_prog_type_BPF_PROG_TYPE_SK_SKB: bpf_prog_type = 14;
pub const bpf_prog_type_BPF_PROG_TYPE_CGROUP_DEVICE: bpf_prog_type = 15;
pub const bpf_prog_type_BPF_PROG_TYPE_SK_MSG: bpf_prog_type = 16;
pub const bpf_prog_type_BPF_PROG_TYPE_RAW_TRACEPOINT: bpf_prog_type = 17;
pub const bpf_prog_type_BPF_PROG_TYPE_CGROUP_SOCK_ADDR: bpf_prog_type = 18;
pub const bpf_prog_type_BPF_PROG_TYPE_LWT_SEG6LOCAL: bpf_prog_type = 19;
pub const bpf_prog_type_BPF_PROG_TYPE_LIRC_MODE2: bpf_prog_type = 20;
pub const bpf_prog_type_BPF_PROG_TYPE_SK_REUSEPORT: bpf_prog_type = 21;
pub const bpf_prog_type_BPF_PROG_TYPE_FLOW_DISSECTOR: bpf_prog_type = 22;
pub const bpf_prog_type_BPF_PROG_TYPE_CGROUP_SYSCTL: bpf_prog_type = 23;
pub const bpf_prog_type_BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE: bpf_prog_type = 24;
pub const bpf_prog_type_BPF_PROG_TYPE_CGROUP_SOCKOPT: bpf_prog_type = 25;
pub type bpf_prog_type = ::std::os::raw::c_uint;
pub const bpf_attach_type_BPF_CGROUP_INET_INGRESS: bpf_attach_type = 0;
pub const bpf_attach_type_BPF_CGROUP_INET_EGRESS: bpf_attach_type = 1;
pub const bpf_attach_type_BPF_CGROUP_INET_SOCK_CREATE: bpf_attach_type = 2;
pub const bpf_attach_type_BPF_CGROUP_SOCK_OPS: bpf_attach_type = 3;
pub const bpf_attach_type_BPF_SK_SKB_STREAM_PARSER: bpf_attach_type = 4;
pub const bpf_attach_type_BPF_SK_SKB_STREAM_VERDICT: bpf_attach_type = 5;
pub const bpf_attach_type_BPF_CGROUP_DEVICE: bpf_attach_type = 6;
pub const bpf_attach_type_BPF_SK_MSG_VERDICT: bpf_attach_type = 7;
pub const bpf_attach_type_BPF_CGROUP_INET4_BIND: bpf_attach_type = 8;
pub const bpf_attach_type_BPF_CGROUP_INET6_BIND: bpf_attach_type = 9;
pub const bpf_attach_type_BPF_CGROUP_INET4_CONNECT: bpf_attach_type = 10;
pub const bpf_attach_type_BPF_CGROUP_INET6_CONNECT: bpf_attach_type = 11;
pub const bpf_attach_type_BPF_CGROUP_INET4_POST_BIND: bpf_attach_type = 12;
pub const bpf_attach_type_BPF_CGROUP_INET6_POST_BIND: bpf_attach_type = 13;
pub const bpf_attach_type_BPF_CGROUP_UDP4_SENDMSG: bpf_attach_type = 14;
pub const bpf_attach_type_BPF_CGROUP_UDP6_SENDMSG: bpf_attach_type = 15;
pub const bpf_attach_type_BPF_LIRC_MODE2: bpf_attach_type = 16;
pub const bpf_attach_type_BPF_FLOW_DISSECTOR: bpf_attach_type = 17;
pub const bpf_attach_type_BPF_CGROUP_SYSCTL: bpf_attach_type = 18;
pub const bpf_attach_type_BPF_CGROUP_UDP4_RECVMSG: bpf_attach_type = 19;
pub const bpf_attach_type_BPF_CGROUP_UDP6_RECVMSG: bpf_attach_type = 20;
pub const bpf_attach_type_BPF_CGROUP_GETSOCKOPT: bpf_attach_type = 21;
pub const bpf_attach_type_BPF_CGROUP_SETSOCKOPT: bpf_attach_type = 22;
pub const bpf_attach_type___MAX_BPF_ATTACH_TYPE: bpf_attach_type = 23;
pub type bpf_attach_type = ::std::os::raw::c_uint;
pub const bpf_stack_build_id_status_BPF_STACK_BUILD_ID_EMPTY: bpf_stack_build_id_status = 0;
pub const bpf_stack_build_id_status_BPF_STACK_BUILD_ID_VALID: bpf_stack_build_id_status = 1;
pub const bpf_stack_build_id_status_BPF_STACK_BUILD_ID_IP: bpf_stack_build_id_status = 2;
pub type bpf_stack_build_id_status = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_stack_build_id {
    pub status: __s32,
    pub build_id: [::std::os::raw::c_uchar; 20usize],
    pub __bindgen_anon_1: bpf_stack_build_id__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_stack_build_id__bindgen_ty_1 {
    pub offset: __u64,
    pub ip: __u64,
}
#[test]
fn bindgen_test_layout_bpf_stack_build_id__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_stack_build_id__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_stack_build_id__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_stack_build_id__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_stack_build_id__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_stack_build_id__bindgen_ty_1>())).offset as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_stack_build_id__bindgen_ty_1),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_stack_build_id__bindgen_ty_1>())).ip as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_stack_build_id__bindgen_ty_1),
            "::",
            stringify!(ip)
        )
    );
}
impl Default for bpf_stack_build_id__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_bpf_stack_build_id() {
    assert_eq!(
        ::std::mem::size_of::<bpf_stack_build_id>(),
        32usize,
        concat!("Size of: ", stringify!(bpf_stack_build_id))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_stack_build_id>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_stack_build_id))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_stack_build_id>())).status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_stack_build_id),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_stack_build_id>())).build_id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_stack_build_id),
            "::",
            stringify!(build_id)
        )
    );
}
impl Default for bpf_stack_build_id {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr {
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_1,
    pub __bindgen_anon_2: bpf_attr__bindgen_ty_2,
    pub __bindgen_anon_3: bpf_attr__bindgen_ty_3,
    pub __bindgen_anon_4: bpf_attr__bindgen_ty_4,
    pub __bindgen_anon_5: bpf_attr__bindgen_ty_5,
    pub test: bpf_attr__bindgen_ty_6,
    pub __bindgen_anon_6: bpf_attr__bindgen_ty_7,
    pub info: bpf_attr__bindgen_ty_8,
    pub query: bpf_attr__bindgen_ty_9,
    pub raw_tracepoint: bpf_attr__bindgen_ty_10,
    pub __bindgen_anon_7: bpf_attr__bindgen_ty_11,
    pub task_fd_query: bpf_attr__bindgen_ty_12,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_attr__bindgen_ty_1 {
    pub map_type: __u32,
    pub key_size: __u32,
    pub value_size: __u32,
    pub max_entries: __u32,
    pub map_flags: __u32,
    pub inner_map_fd: __u32,
    pub numa_node: __u32,
    pub map_name: [::std::os::raw::c_char; 16usize],
    pub map_ifindex: __u32,
    pub btf_fd: __u32,
    pub btf_key_type_id: __u32,
    pub btf_value_type_id: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_1>(),
        60usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).map_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(map_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).key_size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(key_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).value_size as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(value_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).max_entries as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(max_entries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).map_flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(map_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).inner_map_fd as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(inner_map_fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).numa_node as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(numa_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).map_name as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(map_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).map_ifindex as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(map_ifindex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).btf_fd as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(btf_fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).btf_key_type_id as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(btf_key_type_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_1>())).btf_value_type_id as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_1),
            "::",
            stringify!(btf_value_type_id)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_attr__bindgen_ty_2 {
    pub map_fd: __u32,
    pub key: __u64,
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_2__bindgen_ty_1,
    pub flags: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr__bindgen_ty_2__bindgen_ty_1 {
    pub value: __u64,
    pub next_key: __u64,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(bpf_attr__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_attr__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_2__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_2__bindgen_ty_1>())).next_key as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(next_key)
        )
    );
}
impl Default for bpf_attr__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_2>(),
        32usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_2>())).map_fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_2),
            "::",
            stringify!(map_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_2>())).key as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_2),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_2>())).flags as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_2),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for bpf_attr__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_attr__bindgen_ty_3 {
    pub prog_type: __u32,
    pub insn_cnt: __u32,
    pub insns: __u64,
    pub license: __u64,
    pub log_level: __u32,
    pub log_size: __u32,
    pub log_buf: __u64,
    pub kern_version: __u32,
    pub prog_flags: __u32,
    pub prog_name: [::std::os::raw::c_char; 16usize],
    pub prog_ifindex: __u32,
    pub expected_attach_type: __u32,
    pub prog_btf_fd: __u32,
    pub func_info_rec_size: __u32,
    pub func_info: __u64,
    pub func_info_cnt: __u32,
    pub line_info_rec_size: __u32,
    pub line_info: __u64,
    pub line_info_cnt: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_3>(),
        112usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_3>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_3))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).prog_type as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(prog_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).insn_cnt as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(insn_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).insns as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(insns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).license as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(license)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).log_level as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(log_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).log_size as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(log_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).log_buf as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(log_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).kern_version as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(kern_version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).prog_flags as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(prog_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).prog_name as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(prog_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).prog_ifindex as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(prog_ifindex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).expected_attach_type as *const _
                as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(expected_attach_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).prog_btf_fd as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(prog_btf_fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).func_info_rec_size as *const _
                as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(func_info_rec_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).func_info as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(func_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).func_info_cnt as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(func_info_cnt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).line_info_rec_size as *const _
                as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(line_info_rec_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).line_info as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(line_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_3>())).line_info_cnt as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_3),
            "::",
            stringify!(line_info_cnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_attr__bindgen_ty_4 {
    pub pathname: __u64,
    pub bpf_fd: __u32,
    pub file_flags: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_4>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_4>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_4))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_4>())).pathname as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_4),
            "::",
            stringify!(pathname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_4>())).bpf_fd as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_4),
            "::",
            stringify!(bpf_fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_4>())).file_flags as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_4),
            "::",
            stringify!(file_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_attr__bindgen_ty_5 {
    pub target_fd: __u32,
    pub attach_bpf_fd: __u32,
    pub attach_type: __u32,
    pub attach_flags: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_5() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_5>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_5))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_5>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_5))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_5>())).target_fd as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_5),
            "::",
            stringify!(target_fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_5>())).attach_bpf_fd as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_5),
            "::",
            stringify!(attach_bpf_fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_5>())).attach_type as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_5),
            "::",
            stringify!(attach_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_5>())).attach_flags as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_5),
            "::",
            stringify!(attach_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_attr__bindgen_ty_6 {
    pub prog_fd: __u32,
    pub retval: __u32,
    pub data_size_in: __u32,
    pub data_size_out: __u32,
    pub data_in: __u64,
    pub data_out: __u64,
    pub repeat: __u32,
    pub duration: __u32,
    pub ctx_size_in: __u32,
    pub ctx_size_out: __u32,
    pub ctx_in: __u64,
    pub ctx_out: __u64,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_6() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_6>(),
        64usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_6))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_6>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_6))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).prog_fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(prog_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).retval as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(retval)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).data_size_in as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(data_size_in)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).data_size_out as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(data_size_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).data_in as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(data_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).data_out as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(data_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).repeat as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(repeat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).duration as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(duration)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).ctx_size_in as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(ctx_size_in)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).ctx_size_out as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(ctx_size_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).ctx_in as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(ctx_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_6>())).ctx_out as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_6),
            "::",
            stringify!(ctx_out)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_attr__bindgen_ty_7 {
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_7__bindgen_ty_1,
    pub next_id: __u32,
    pub open_flags: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr__bindgen_ty_7__bindgen_ty_1 {
    pub start_id: __u32,
    pub prog_id: __u32,
    pub map_id: __u32,
    pub btf_id: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_7__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_7__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(bpf_attr__bindgen_ty_7__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_7__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_attr__bindgen_ty_7__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_7__bindgen_ty_1>())).start_id as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_7__bindgen_ty_1),
            "::",
            stringify!(start_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_7__bindgen_ty_1>())).prog_id as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_7__bindgen_ty_1),
            "::",
            stringify!(prog_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_7__bindgen_ty_1>())).map_id as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_7__bindgen_ty_1),
            "::",
            stringify!(map_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_7__bindgen_ty_1>())).btf_id as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_7__bindgen_ty_1),
            "::",
            stringify!(btf_id)
        )
    );
}
impl Default for bpf_attr__bindgen_ty_7__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_7() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_7>(),
        12usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_7))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_7>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_7))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_7>())).next_id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_7),
            "::",
            stringify!(next_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_7>())).open_flags as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_7),
            "::",
            stringify!(open_flags)
        )
    );
}
impl Default for bpf_attr__bindgen_ty_7 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_attr__bindgen_ty_8 {
    pub bpf_fd: __u32,
    pub info_len: __u32,
    pub info: __u64,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_8() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_8>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_8))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_8>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_8))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_8>())).bpf_fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_8),
            "::",
            stringify!(bpf_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_8>())).info_len as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_8),
            "::",
            stringify!(info_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_8>())).info as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_8),
            "::",
            stringify!(info)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_attr__bindgen_ty_9 {
    pub target_fd: __u32,
    pub attach_type: __u32,
    pub query_flags: __u32,
    pub attach_flags: __u32,
    pub prog_ids: __u64,
    pub prog_cnt: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_9() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_9>(),
        32usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_9))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_9>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_9))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_9>())).target_fd as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_9),
            "::",
            stringify!(target_fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_9>())).attach_type as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_9),
            "::",
            stringify!(attach_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_9>())).query_flags as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_9),
            "::",
            stringify!(query_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_9>())).attach_flags as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_9),
            "::",
            stringify!(attach_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_9>())).prog_ids as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_9),
            "::",
            stringify!(prog_ids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_9>())).prog_cnt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_9),
            "::",
            stringify!(prog_cnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_attr__bindgen_ty_10 {
    pub name: __u64,
    pub prog_fd: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_10() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_10>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_10))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_10>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_10))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_10>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_10),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_10>())).prog_fd as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_10),
            "::",
            stringify!(prog_fd)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_attr__bindgen_ty_11 {
    pub btf: __u64,
    pub btf_log_buf: __u64,
    pub btf_size: __u32,
    pub btf_log_size: __u32,
    pub btf_log_level: __u32,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_11() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_11>(),
        32usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_11))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_11>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_11))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_11>())).btf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_11),
            "::",
            stringify!(btf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_11>())).btf_log_buf as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_11),
            "::",
            stringify!(btf_log_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_11>())).btf_size as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_11),
            "::",
            stringify!(btf_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_11>())).btf_log_size as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_11),
            "::",
            stringify!(btf_log_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_11>())).btf_log_level as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_11),
            "::",
            stringify!(btf_log_level)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_attr__bindgen_ty_12 {
    pub pid: __u32,
    pub fd: __u32,
    pub flags: __u32,
    pub buf_len: __u32,
    pub buf: __u64,
    pub prog_id: __u32,
    pub fd_type: __u32,
    pub probe_offset: __u64,
    pub probe_addr: __u64,
}
#[test]
fn bindgen_test_layout_bpf_attr__bindgen_ty_12() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr__bindgen_ty_12>(),
        48usize,
        concat!("Size of: ", stringify!(bpf_attr__bindgen_ty_12))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr__bindgen_ty_12>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr__bindgen_ty_12))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_12>())).pid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_12),
            "::",
            stringify!(pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_12>())).fd as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_12),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_12>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_12),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_12>())).buf_len as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_12),
            "::",
            stringify!(buf_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_12>())).buf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_12),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_12>())).prog_id as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_12),
            "::",
            stringify!(prog_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr__bindgen_ty_12>())).fd_type as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_12),
            "::",
            stringify!(fd_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_12>())).probe_offset as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_12),
            "::",
            stringify!(probe_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_attr__bindgen_ty_12>())).probe_addr as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr__bindgen_ty_12),
            "::",
            stringify!(probe_addr)
        )
    );
}
#[test]
fn bindgen_test_layout_bpf_attr() {
    assert_eq!(
        ::std::mem::size_of::<bpf_attr>(),
        112usize,
        concat!("Size of: ", stringify!(bpf_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr>())).test as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr),
            "::",
            stringify!(test)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr>())).info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr>())).query as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr),
            "::",
            stringify!(query)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr>())).raw_tracepoint as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr),
            "::",
            stringify!(raw_tracepoint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_attr>())).task_fd_query as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_attr),
            "::",
            stringify!(task_fd_query)
        )
    );
}
impl Default for bpf_attr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub const bpf_func_id_BPF_FUNC_unspec: bpf_func_id = 0;
pub const bpf_func_id_BPF_FUNC_map_lookup_elem: bpf_func_id = 1;
pub const bpf_func_id_BPF_FUNC_map_update_elem: bpf_func_id = 2;
pub const bpf_func_id_BPF_FUNC_map_delete_elem: bpf_func_id = 3;
pub const bpf_func_id_BPF_FUNC_probe_read: bpf_func_id = 4;
pub const bpf_func_id_BPF_FUNC_ktime_get_ns: bpf_func_id = 5;
pub const bpf_func_id_BPF_FUNC_trace_printk: bpf_func_id = 6;
pub const bpf_func_id_BPF_FUNC_get_prandom_u32: bpf_func_id = 7;
pub const bpf_func_id_BPF_FUNC_get_smp_processor_id: bpf_func_id = 8;
pub const bpf_func_id_BPF_FUNC_skb_store_bytes: bpf_func_id = 9;
pub const bpf_func_id_BPF_FUNC_l3_csum_replace: bpf_func_id = 10;
pub const bpf_func_id_BPF_FUNC_l4_csum_replace: bpf_func_id = 11;
pub const bpf_func_id_BPF_FUNC_tail_call: bpf_func_id = 12;
pub const bpf_func_id_BPF_FUNC_clone_redirect: bpf_func_id = 13;
pub const bpf_func_id_BPF_FUNC_get_current_pid_tgid: bpf_func_id = 14;
pub const bpf_func_id_BPF_FUNC_get_current_uid_gid: bpf_func_id = 15;
pub const bpf_func_id_BPF_FUNC_get_current_comm: bpf_func_id = 16;
pub const bpf_func_id_BPF_FUNC_get_cgroup_classid: bpf_func_id = 17;
pub const bpf_func_id_BPF_FUNC_skb_vlan_push: bpf_func_id = 18;
pub const bpf_func_id_BPF_FUNC_skb_vlan_pop: bpf_func_id = 19;
pub const bpf_func_id_BPF_FUNC_skb_get_tunnel_key: bpf_func_id = 20;
pub const bpf_func_id_BPF_FUNC_skb_set_tunnel_key: bpf_func_id = 21;
pub const bpf_func_id_BPF_FUNC_perf_event_read: bpf_func_id = 22;
pub const bpf_func_id_BPF_FUNC_redirect: bpf_func_id = 23;
pub const bpf_func_id_BPF_FUNC_get_route_realm: bpf_func_id = 24;
pub const bpf_func_id_BPF_FUNC_perf_event_output: bpf_func_id = 25;
pub const bpf_func_id_BPF_FUNC_skb_load_bytes: bpf_func_id = 26;
pub const bpf_func_id_BPF_FUNC_get_stackid: bpf_func_id = 27;
pub const bpf_func_id_BPF_FUNC_csum_diff: bpf_func_id = 28;
pub const bpf_func_id_BPF_FUNC_skb_get_tunnel_opt: bpf_func_id = 29;
pub const bpf_func_id_BPF_FUNC_skb_set_tunnel_opt: bpf_func_id = 30;
pub const bpf_func_id_BPF_FUNC_skb_change_proto: bpf_func_id = 31;
pub const bpf_func_id_BPF_FUNC_skb_change_type: bpf_func_id = 32;
pub const bpf_func_id_BPF_FUNC_skb_under_cgroup: bpf_func_id = 33;
pub const bpf_func_id_BPF_FUNC_get_hash_recalc: bpf_func_id = 34;
pub const bpf_func_id_BPF_FUNC_get_current_task: bpf_func_id = 35;
pub const bpf_func_id_BPF_FUNC_probe_write_user: bpf_func_id = 36;
pub const bpf_func_id_BPF_FUNC_current_task_under_cgroup: bpf_func_id = 37;
pub const bpf_func_id_BPF_FUNC_skb_change_tail: bpf_func_id = 38;
pub const bpf_func_id_BPF_FUNC_skb_pull_data: bpf_func_id = 39;
pub const bpf_func_id_BPF_FUNC_csum_update: bpf_func_id = 40;
pub const bpf_func_id_BPF_FUNC_set_hash_invalid: bpf_func_id = 41;
pub const bpf_func_id_BPF_FUNC_get_numa_node_id: bpf_func_id = 42;
pub const bpf_func_id_BPF_FUNC_skb_change_head: bpf_func_id = 43;
pub const bpf_func_id_BPF_FUNC_xdp_adjust_head: bpf_func_id = 44;
pub const bpf_func_id_BPF_FUNC_probe_read_str: bpf_func_id = 45;
pub const bpf_func_id_BPF_FUNC_get_socket_cookie: bpf_func_id = 46;
pub const bpf_func_id_BPF_FUNC_get_socket_uid: bpf_func_id = 47;
pub const bpf_func_id_BPF_FUNC_set_hash: bpf_func_id = 48;
pub const bpf_func_id_BPF_FUNC_setsockopt: bpf_func_id = 49;
pub const bpf_func_id_BPF_FUNC_skb_adjust_room: bpf_func_id = 50;
pub const bpf_func_id_BPF_FUNC_redirect_map: bpf_func_id = 51;
pub const bpf_func_id_BPF_FUNC_sk_redirect_map: bpf_func_id = 52;
pub const bpf_func_id_BPF_FUNC_sock_map_update: bpf_func_id = 53;
pub const bpf_func_id_BPF_FUNC_xdp_adjust_meta: bpf_func_id = 54;
pub const bpf_func_id_BPF_FUNC_perf_event_read_value: bpf_func_id = 55;
pub const bpf_func_id_BPF_FUNC_perf_prog_read_value: bpf_func_id = 56;
pub const bpf_func_id_BPF_FUNC_getsockopt: bpf_func_id = 57;
pub const bpf_func_id_BPF_FUNC_override_return: bpf_func_id = 58;
pub const bpf_func_id_BPF_FUNC_sock_ops_cb_flags_set: bpf_func_id = 59;
pub const bpf_func_id_BPF_FUNC_msg_redirect_map: bpf_func_id = 60;
pub const bpf_func_id_BPF_FUNC_msg_apply_bytes: bpf_func_id = 61;
pub const bpf_func_id_BPF_FUNC_msg_cork_bytes: bpf_func_id = 62;
pub const bpf_func_id_BPF_FUNC_msg_pull_data: bpf_func_id = 63;
pub const bpf_func_id_BPF_FUNC_bind: bpf_func_id = 64;
pub const bpf_func_id_BPF_FUNC_xdp_adjust_tail: bpf_func_id = 65;
pub const bpf_func_id_BPF_FUNC_skb_get_xfrm_state: bpf_func_id = 66;
pub const bpf_func_id_BPF_FUNC_get_stack: bpf_func_id = 67;
pub const bpf_func_id_BPF_FUNC_skb_load_bytes_relative: bpf_func_id = 68;
pub const bpf_func_id_BPF_FUNC_fib_lookup: bpf_func_id = 69;
pub const bpf_func_id_BPF_FUNC_sock_hash_update: bpf_func_id = 70;
pub const bpf_func_id_BPF_FUNC_msg_redirect_hash: bpf_func_id = 71;
pub const bpf_func_id_BPF_FUNC_sk_redirect_hash: bpf_func_id = 72;
pub const bpf_func_id_BPF_FUNC_lwt_push_encap: bpf_func_id = 73;
pub const bpf_func_id_BPF_FUNC_lwt_seg6_store_bytes: bpf_func_id = 74;
pub const bpf_func_id_BPF_FUNC_lwt_seg6_adjust_srh: bpf_func_id = 75;
pub const bpf_func_id_BPF_FUNC_lwt_seg6_action: bpf_func_id = 76;
pub const bpf_func_id_BPF_FUNC_rc_repeat: bpf_func_id = 77;
pub const bpf_func_id_BPF_FUNC_rc_keydown: bpf_func_id = 78;
pub const bpf_func_id_BPF_FUNC_skb_cgroup_id: bpf_func_id = 79;
pub const bpf_func_id_BPF_FUNC_get_current_cgroup_id: bpf_func_id = 80;
pub const bpf_func_id_BPF_FUNC_get_local_storage: bpf_func_id = 81;
pub const bpf_func_id_BPF_FUNC_sk_select_reuseport: bpf_func_id = 82;
pub const bpf_func_id_BPF_FUNC_skb_ancestor_cgroup_id: bpf_func_id = 83;
pub const bpf_func_id_BPF_FUNC_sk_lookup_tcp: bpf_func_id = 84;
pub const bpf_func_id_BPF_FUNC_sk_lookup_udp: bpf_func_id = 85;
pub const bpf_func_id_BPF_FUNC_sk_release: bpf_func_id = 86;
pub const bpf_func_id_BPF_FUNC_map_push_elem: bpf_func_id = 87;
pub const bpf_func_id_BPF_FUNC_map_pop_elem: bpf_func_id = 88;
pub const bpf_func_id_BPF_FUNC_map_peek_elem: bpf_func_id = 89;
pub const bpf_func_id_BPF_FUNC_msg_push_data: bpf_func_id = 90;
pub const bpf_func_id_BPF_FUNC_msg_pop_data: bpf_func_id = 91;
pub const bpf_func_id_BPF_FUNC_rc_pointer_rel: bpf_func_id = 92;
pub const bpf_func_id_BPF_FUNC_spin_lock: bpf_func_id = 93;
pub const bpf_func_id_BPF_FUNC_spin_unlock: bpf_func_id = 94;
pub const bpf_func_id_BPF_FUNC_sk_fullsock: bpf_func_id = 95;
pub const bpf_func_id_BPF_FUNC_tcp_sock: bpf_func_id = 96;
pub const bpf_func_id_BPF_FUNC_skb_ecn_set_ce: bpf_func_id = 97;
pub const bpf_func_id_BPF_FUNC_get_listener_sock: bpf_func_id = 98;
pub const bpf_func_id_BPF_FUNC_skc_lookup_tcp: bpf_func_id = 99;
pub const bpf_func_id_BPF_FUNC_tcp_check_syncookie: bpf_func_id = 100;
pub const bpf_func_id_BPF_FUNC_sysctl_get_name: bpf_func_id = 101;
pub const bpf_func_id_BPF_FUNC_sysctl_get_current_value: bpf_func_id = 102;
pub const bpf_func_id_BPF_FUNC_sysctl_get_new_value: bpf_func_id = 103;
pub const bpf_func_id_BPF_FUNC_sysctl_set_new_value: bpf_func_id = 104;
pub const bpf_func_id_BPF_FUNC_strtol: bpf_func_id = 105;
pub const bpf_func_id_BPF_FUNC_strtoul: bpf_func_id = 106;
pub const bpf_func_id_BPF_FUNC_sk_storage_get: bpf_func_id = 107;
pub const bpf_func_id_BPF_FUNC_sk_storage_delete: bpf_func_id = 108;
pub const bpf_func_id_BPF_FUNC_send_signal: bpf_func_id = 109;
pub const bpf_func_id_BPF_FUNC_tcp_gen_syncookie: bpf_func_id = 110;
pub const bpf_func_id___BPF_FUNC_MAX_ID: bpf_func_id = 111;
pub type bpf_func_id = ::std::os::raw::c_uint;
pub const bpf_adj_room_mode_BPF_ADJ_ROOM_NET: bpf_adj_room_mode = 0;
pub const bpf_adj_room_mode_BPF_ADJ_ROOM_MAC: bpf_adj_room_mode = 1;
pub type bpf_adj_room_mode = ::std::os::raw::c_uint;
pub const bpf_hdr_start_off_BPF_HDR_START_MAC: bpf_hdr_start_off = 0;
pub const bpf_hdr_start_off_BPF_HDR_START_NET: bpf_hdr_start_off = 1;
pub type bpf_hdr_start_off = ::std::os::raw::c_uint;
pub const bpf_lwt_encap_mode_BPF_LWT_ENCAP_SEG6: bpf_lwt_encap_mode = 0;
pub const bpf_lwt_encap_mode_BPF_LWT_ENCAP_SEG6_INLINE: bpf_lwt_encap_mode = 1;
pub const bpf_lwt_encap_mode_BPF_LWT_ENCAP_IP: bpf_lwt_encap_mode = 2;
pub type bpf_lwt_encap_mode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sk_buff {
    pub len: __u32,
    pub pkt_type: __u32,
    pub mark: __u32,
    pub queue_mapping: __u32,
    pub protocol: __u32,
    pub vlan_present: __u32,
    pub vlan_tci: __u32,
    pub vlan_proto: __u32,
    pub priority: __u32,
    pub ingress_ifindex: __u32,
    pub ifindex: __u32,
    pub tc_index: __u32,
    pub cb: [__u32; 5usize],
    pub hash: __u32,
    pub tc_classid: __u32,
    pub data: __u32,
    pub data_end: __u32,
    pub napi_id: __u32,
    pub family: __u32,
    pub remote_ip4: __u32,
    pub local_ip4: __u32,
    pub remote_ip6: [__u32; 4usize],
    pub local_ip6: [__u32; 4usize],
    pub remote_port: __u32,
    pub local_port: __u32,
    pub data_meta: __u32,
    pub __bindgen_anon_1: __sk_buff__bindgen_ty_1,
    pub tstamp: __u64,
    pub wire_len: __u32,
    pub gso_segs: __u32,
    pub __bindgen_anon_2: __sk_buff__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sk_buff__bindgen_ty_1 {
    pub flow_keys: *mut bpf_flow_keys,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout___sk_buff__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__sk_buff__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__sk_buff__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__sk_buff__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(__sk_buff__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__sk_buff__bindgen_ty_1>())).flow_keys as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff__bindgen_ty_1),
            "::",
            stringify!(flow_keys)
        )
    );
}
impl Default for __sk_buff__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl __sk_buff__bindgen_ty_1 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sk_buff__bindgen_ty_2 {
    pub sk: *mut bpf_sock,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout___sk_buff__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<__sk_buff__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(__sk_buff__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<__sk_buff__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(__sk_buff__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff__bindgen_ty_2>())).sk as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff__bindgen_ty_2),
            "::",
            stringify!(sk)
        )
    );
}
impl Default for __sk_buff__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl __sk_buff__bindgen_ty_2 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout___sk_buff() {
    assert_eq!(
        ::std::mem::size_of::<__sk_buff>(),
        176usize,
        concat!("Size of: ", stringify!(__sk_buff))
    );
    assert_eq!(
        ::std::mem::align_of::<__sk_buff>(),
        8usize,
        concat!("Alignment of ", stringify!(__sk_buff))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).pkt_type as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(pkt_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).mark as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(mark)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).queue_mapping as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(queue_mapping)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).protocol as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(protocol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).vlan_present as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(vlan_present)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).vlan_tci as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(vlan_tci)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).vlan_proto as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(vlan_proto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).priority as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(priority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).ingress_ifindex as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(ingress_ifindex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).ifindex as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(ifindex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).tc_index as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(tc_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).cb as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).hash as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).tc_classid as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(tc_classid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).data as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).data_end as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(data_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).napi_id as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(napi_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).family as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).remote_ip4 as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(remote_ip4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).local_ip4 as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(local_ip4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).remote_ip6 as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(remote_ip6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).local_ip6 as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(local_ip6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).remote_port as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(remote_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).local_port as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(local_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).data_meta as *const _ as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(data_meta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).tstamp as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(tstamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).wire_len as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(wire_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sk_buff>())).gso_segs as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(__sk_buff),
            "::",
            stringify!(gso_segs)
        )
    );
}
impl Default for __sk_buff {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_tunnel_key {
    pub tunnel_id: __u32,
    pub __bindgen_anon_1: bpf_tunnel_key__bindgen_ty_1,
    pub tunnel_tos: __u8,
    pub tunnel_ttl: __u8,
    pub tunnel_ext: __u16,
    pub tunnel_label: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_tunnel_key__bindgen_ty_1 {
    pub remote_ipv4: __u32,
    pub remote_ipv6: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_bpf_tunnel_key__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_tunnel_key__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_tunnel_key__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_tunnel_key__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_tunnel_key__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_tunnel_key__bindgen_ty_1>())).remote_ipv4 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key__bindgen_ty_1),
            "::",
            stringify!(remote_ipv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_tunnel_key__bindgen_ty_1>())).remote_ipv6 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key__bindgen_ty_1),
            "::",
            stringify!(remote_ipv6)
        )
    );
}
impl Default for bpf_tunnel_key__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_bpf_tunnel_key() {
    assert_eq!(
        ::std::mem::size_of::<bpf_tunnel_key>(),
        28usize,
        concat!("Size of: ", stringify!(bpf_tunnel_key))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_tunnel_key>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_tunnel_key))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tunnel_key>())).tunnel_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key),
            "::",
            stringify!(tunnel_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tunnel_key>())).tunnel_tos as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key),
            "::",
            stringify!(tunnel_tos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tunnel_key>())).tunnel_ttl as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key),
            "::",
            stringify!(tunnel_ttl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tunnel_key>())).tunnel_ext as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key),
            "::",
            stringify!(tunnel_ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tunnel_key>())).tunnel_label as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tunnel_key),
            "::",
            stringify!(tunnel_label)
        )
    );
}
impl Default for bpf_tunnel_key {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_xfrm_state {
    pub reqid: __u32,
    pub spi: __u32,
    pub family: __u16,
    pub ext: __u16,
    pub __bindgen_anon_1: bpf_xfrm_state__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_xfrm_state__bindgen_ty_1 {
    pub remote_ipv4: __u32,
    pub remote_ipv6: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_bpf_xfrm_state__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_xfrm_state__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_xfrm_state__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_xfrm_state__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_xfrm_state__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_xfrm_state__bindgen_ty_1>())).remote_ipv4 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_xfrm_state__bindgen_ty_1),
            "::",
            stringify!(remote_ipv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_xfrm_state__bindgen_ty_1>())).remote_ipv6 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_xfrm_state__bindgen_ty_1),
            "::",
            stringify!(remote_ipv6)
        )
    );
}
impl Default for bpf_xfrm_state__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_bpf_xfrm_state() {
    assert_eq!(
        ::std::mem::size_of::<bpf_xfrm_state>(),
        28usize,
        concat!("Size of: ", stringify!(bpf_xfrm_state))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_xfrm_state>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_xfrm_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_xfrm_state>())).reqid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_xfrm_state),
            "::",
            stringify!(reqid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_xfrm_state>())).spi as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_xfrm_state),
            "::",
            stringify!(spi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_xfrm_state>())).family as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_xfrm_state),
            "::",
            stringify!(family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_xfrm_state>())).ext as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_xfrm_state),
            "::",
            stringify!(ext)
        )
    );
}
impl Default for bpf_xfrm_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub const bpf_ret_code_BPF_OK: bpf_ret_code = 0;
pub const bpf_ret_code_BPF_DROP: bpf_ret_code = 2;
pub const bpf_ret_code_BPF_REDIRECT: bpf_ret_code = 7;
pub const bpf_ret_code_BPF_LWT_REROUTE: bpf_ret_code = 128;
pub type bpf_ret_code = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_sock {
    pub bound_dev_if: __u32,
    pub family: __u32,
    pub type_: __u32,
    pub protocol: __u32,
    pub mark: __u32,
    pub priority: __u32,
    pub src_ip4: __u32,
    pub src_ip6: [__u32; 4usize],
    pub src_port: __u32,
    pub dst_port: __u32,
    pub dst_ip4: __u32,
    pub dst_ip6: [__u32; 4usize],
    pub state: __u32,
}
#[test]
fn bindgen_test_layout_bpf_sock() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sock>(),
        76usize,
        concat!("Size of: ", stringify!(bpf_sock))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sock>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_sock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).bound_dev_if as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(bound_dev_if)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).family as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).protocol as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(protocol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).mark as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(mark)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).priority as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(priority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).src_ip4 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(src_ip4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).src_ip6 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(src_ip6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).src_port as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(src_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).dst_port as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(dst_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).dst_ip4 as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(dst_ip4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).dst_ip6 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(dst_ip6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock>())).state as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock),
            "::",
            stringify!(state)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_tcp_sock {
    pub snd_cwnd: __u32,
    pub srtt_us: __u32,
    pub rtt_min: __u32,
    pub snd_ssthresh: __u32,
    pub rcv_nxt: __u32,
    pub snd_nxt: __u32,
    pub snd_una: __u32,
    pub mss_cache: __u32,
    pub ecn_flags: __u32,
    pub rate_delivered: __u32,
    pub rate_interval_us: __u32,
    pub packets_out: __u32,
    pub retrans_out: __u32,
    pub total_retrans: __u32,
    pub segs_in: __u32,
    pub data_segs_in: __u32,
    pub segs_out: __u32,
    pub data_segs_out: __u32,
    pub lost_out: __u32,
    pub sacked_out: __u32,
    pub bytes_received: __u64,
    pub bytes_acked: __u64,
    pub dsack_dups: __u32,
    pub delivered: __u32,
    pub delivered_ce: __u32,
    pub icsk_retransmits: __u32,
}
#[test]
fn bindgen_test_layout_bpf_tcp_sock() {
    assert_eq!(
        ::std::mem::size_of::<bpf_tcp_sock>(),
        112usize,
        concat!("Size of: ", stringify!(bpf_tcp_sock))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_tcp_sock>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_tcp_sock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).snd_cwnd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(snd_cwnd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).srtt_us as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(srtt_us)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).rtt_min as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(rtt_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).snd_ssthresh as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(snd_ssthresh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).rcv_nxt as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(rcv_nxt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).snd_nxt as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(snd_nxt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).snd_una as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(snd_una)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).mss_cache as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(mss_cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).ecn_flags as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(ecn_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).rate_delivered as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(rate_delivered)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).rate_interval_us as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(rate_interval_us)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).packets_out as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(packets_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).retrans_out as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(retrans_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).total_retrans as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(total_retrans)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).segs_in as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(segs_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).data_segs_in as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(data_segs_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).segs_out as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(segs_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).data_segs_out as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(data_segs_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).lost_out as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(lost_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).sacked_out as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(sacked_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).bytes_received as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(bytes_received)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).bytes_acked as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(bytes_acked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).dsack_dups as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(dsack_dups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).delivered as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(delivered)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).delivered_ce as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(delivered_ce)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_tcp_sock>())).icsk_retransmits as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_tcp_sock),
            "::",
            stringify!(icsk_retransmits)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_sock_tuple {
    pub __bindgen_anon_1: bpf_sock_tuple__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sock_tuple__bindgen_ty_1 {
    pub ipv4: bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1,
    pub ipv6: bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1 {
    pub saddr: __be32,
    pub daddr: __be32,
    pub sport: __be16,
    pub dport: __be16,
}
#[test]
fn bindgen_test_layout_bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1>())).saddr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(saddr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1>())).daddr as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(daddr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1>())).sport as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(sport)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1>())).dport as *const _
                as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(dport)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2 {
    pub saddr: [__be32; 4usize],
    pub daddr: [__be32; 4usize],
    pub sport: __be16,
    pub dport: __be16,
}
#[test]
fn bindgen_test_layout_bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2>())).saddr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(saddr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2>())).daddr as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(daddr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2>())).sport as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(sport)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2>())).dport as *const _
                as usize
        },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(dport)
        )
    );
}
#[test]
fn bindgen_test_layout_bpf_sock_tuple__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sock_tuple__bindgen_ty_1>(),
        36usize,
        concat!("Size of: ", stringify!(bpf_sock_tuple__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sock_tuple__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_sock_tuple__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_tuple__bindgen_ty_1>())).ipv4 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1),
            "::",
            stringify!(ipv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_tuple__bindgen_ty_1>())).ipv6 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_tuple__bindgen_ty_1),
            "::",
            stringify!(ipv6)
        )
    );
}
impl Default for bpf_sock_tuple__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_bpf_sock_tuple() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sock_tuple>(),
        36usize,
        concat!("Size of: ", stringify!(bpf_sock_tuple))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sock_tuple>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_sock_tuple))
    );
}
impl Default for bpf_sock_tuple {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_xdp_sock {
    pub queue_id: __u32,
}
#[test]
fn bindgen_test_layout_bpf_xdp_sock() {
    assert_eq!(
        ::std::mem::size_of::<bpf_xdp_sock>(),
        4usize,
        concat!("Size of: ", stringify!(bpf_xdp_sock))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_xdp_sock>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_xdp_sock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_xdp_sock>())).queue_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_xdp_sock),
            "::",
            stringify!(queue_id)
        )
    );
}
pub const xdp_action_XDP_ABORTED: xdp_action = 0;
pub const xdp_action_XDP_DROP: xdp_action = 1;
pub const xdp_action_XDP_PASS: xdp_action = 2;
pub const xdp_action_XDP_TX: xdp_action = 3;
pub const xdp_action_XDP_REDIRECT: xdp_action = 4;
pub type xdp_action = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct xdp_md {
    pub data: __u32,
    pub data_end: __u32,
    pub data_meta: __u32,
    pub ingress_ifindex: __u32,
    pub rx_queue_index: __u32,
}
#[test]
fn bindgen_test_layout_xdp_md() {
    assert_eq!(
        ::std::mem::size_of::<xdp_md>(),
        20usize,
        concat!("Size of: ", stringify!(xdp_md))
    );
    assert_eq!(
        ::std::mem::align_of::<xdp_md>(),
        4usize,
        concat!("Alignment of ", stringify!(xdp_md))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_md>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_md),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_md>())).data_end as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_md),
            "::",
            stringify!(data_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_md>())).data_meta as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_md),
            "::",
            stringify!(data_meta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_md>())).ingress_ifindex as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_md),
            "::",
            stringify!(ingress_ifindex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_md>())).rx_queue_index as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_md),
            "::",
            stringify!(rx_queue_index)
        )
    );
}
pub const sk_action_SK_DROP: sk_action = 0;
pub const sk_action_SK_PASS: sk_action = 1;
pub type sk_action = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sk_msg_md {
    pub __bindgen_anon_1: sk_msg_md__bindgen_ty_1,
    pub __bindgen_anon_2: sk_msg_md__bindgen_ty_2,
    pub family: __u32,
    pub remote_ip4: __u32,
    pub local_ip4: __u32,
    pub remote_ip6: [__u32; 4usize],
    pub local_ip6: [__u32; 4usize],
    pub remote_port: __u32,
    pub local_port: __u32,
    pub size: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sk_msg_md__bindgen_ty_1 {
    pub data: *mut ::std::os::raw::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_sk_msg_md__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sk_msg_md__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(sk_msg_md__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sk_msg_md__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(sk_msg_md__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_msg_md__bindgen_ty_1>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_msg_md__bindgen_ty_1),
            "::",
            stringify!(data)
        )
    );
}
impl Default for sk_msg_md__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl sk_msg_md__bindgen_ty_1 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sk_msg_md__bindgen_ty_2 {
    pub data_end: *mut ::std::os::raw::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_sk_msg_md__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<sk_msg_md__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(sk_msg_md__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<sk_msg_md__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(sk_msg_md__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sk_msg_md__bindgen_ty_2>())).data_end as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_msg_md__bindgen_ty_2),
            "::",
            stringify!(data_end)
        )
    );
}
impl Default for sk_msg_md__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl sk_msg_md__bindgen_ty_2 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_sk_msg_md() {
    assert_eq!(
        ::std::mem::size_of::<sk_msg_md>(),
        72usize,
        concat!("Size of: ", stringify!(sk_msg_md))
    );
    assert_eq!(
        ::std::mem::align_of::<sk_msg_md>(),
        8usize,
        concat!("Alignment of ", stringify!(sk_msg_md))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_msg_md>())).family as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_msg_md),
            "::",
            stringify!(family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_msg_md>())).remote_ip4 as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_msg_md),
            "::",
            stringify!(remote_ip4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_msg_md>())).local_ip4 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_msg_md),
            "::",
            stringify!(local_ip4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_msg_md>())).remote_ip6 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_msg_md),
            "::",
            stringify!(remote_ip6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_msg_md>())).local_ip6 as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_msg_md),
            "::",
            stringify!(local_ip6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_msg_md>())).remote_port as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_msg_md),
            "::",
            stringify!(remote_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_msg_md>())).local_port as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_msg_md),
            "::",
            stringify!(local_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_msg_md>())).size as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_msg_md),
            "::",
            stringify!(size)
        )
    );
}
impl Default for sk_msg_md {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sk_reuseport_md {
    pub __bindgen_anon_1: sk_reuseport_md__bindgen_ty_1,
    pub __bindgen_anon_2: sk_reuseport_md__bindgen_ty_2,
    pub len: __u32,
    pub eth_protocol: __u32,
    pub ip_protocol: __u32,
    pub bind_inany: __u32,
    pub hash: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sk_reuseport_md__bindgen_ty_1 {
    pub data: *mut ::std::os::raw::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_sk_reuseport_md__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sk_reuseport_md__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(sk_reuseport_md__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sk_reuseport_md__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(sk_reuseport_md__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sk_reuseport_md__bindgen_ty_1>())).data as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_reuseport_md__bindgen_ty_1),
            "::",
            stringify!(data)
        )
    );
}
impl Default for sk_reuseport_md__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl sk_reuseport_md__bindgen_ty_1 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sk_reuseport_md__bindgen_ty_2 {
    pub data_end: *mut ::std::os::raw::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_sk_reuseport_md__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<sk_reuseport_md__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(sk_reuseport_md__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<sk_reuseport_md__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(sk_reuseport_md__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sk_reuseport_md__bindgen_ty_2>())).data_end as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_reuseport_md__bindgen_ty_2),
            "::",
            stringify!(data_end)
        )
    );
}
impl Default for sk_reuseport_md__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl sk_reuseport_md__bindgen_ty_2 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_sk_reuseport_md() {
    assert_eq!(
        ::std::mem::size_of::<sk_reuseport_md>(),
        40usize,
        concat!("Size of: ", stringify!(sk_reuseport_md))
    );
    assert_eq!(
        ::std::mem::align_of::<sk_reuseport_md>(),
        8usize,
        concat!("Alignment of ", stringify!(sk_reuseport_md))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_reuseport_md>())).len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_reuseport_md),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_reuseport_md>())).eth_protocol as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_reuseport_md),
            "::",
            stringify!(eth_protocol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_reuseport_md>())).ip_protocol as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_reuseport_md),
            "::",
            stringify!(ip_protocol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_reuseport_md>())).bind_inany as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_reuseport_md),
            "::",
            stringify!(bind_inany)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sk_reuseport_md>())).hash as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sk_reuseport_md),
            "::",
            stringify!(hash)
        )
    );
}
impl Default for sk_reuseport_md {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_prog_info {
    pub type_: __u32,
    pub id: __u32,
    pub tag: [__u8; 8usize],
    pub jited_prog_len: __u32,
    pub xlated_prog_len: __u32,
    pub jited_prog_insns: __u64,
    pub xlated_prog_insns: __u64,
    pub load_time: __u64,
    pub created_by_uid: __u32,
    pub nr_map_ids: __u32,
    pub map_ids: __u64,
    pub name: [::std::os::raw::c_char; 16usize],
    pub ifindex: __u32,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub netns_dev: __u64,
    pub netns_ino: __u64,
    pub nr_jited_ksyms: __u32,
    pub nr_jited_func_lens: __u32,
    pub jited_ksyms: __u64,
    pub jited_func_lens: __u64,
    pub btf_id: __u32,
    pub func_info_rec_size: __u32,
    pub func_info: __u64,
    pub nr_func_info: __u32,
    pub nr_line_info: __u32,
    pub line_info: __u64,
    pub jited_line_info: __u64,
    pub nr_jited_line_info: __u32,
    pub line_info_rec_size: __u32,
    pub jited_line_info_rec_size: __u32,
    pub nr_prog_tags: __u32,
    pub prog_tags: __u64,
    pub run_time_ns: __u64,
    pub run_cnt: __u64,
}
#[test]
fn bindgen_test_layout_bpf_prog_info() {
    assert_eq!(
        ::std::mem::size_of::<bpf_prog_info>(),
        208usize,
        concat!("Size of: ", stringify!(bpf_prog_info))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_prog_info>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_prog_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).tag as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).jited_prog_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(jited_prog_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).xlated_prog_len as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(xlated_prog_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).jited_prog_insns as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(jited_prog_insns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).xlated_prog_insns as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(xlated_prog_insns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).load_time as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(load_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).created_by_uid as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(created_by_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).nr_map_ids as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(nr_map_ids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).map_ids as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(map_ids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).name as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).ifindex as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(ifindex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).netns_dev as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(netns_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).netns_ino as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(netns_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).nr_jited_ksyms as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(nr_jited_ksyms)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_info>())).nr_jited_func_lens as *const _ as usize
        },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(nr_jited_func_lens)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).jited_ksyms as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(jited_ksyms)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).jited_func_lens as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(jited_func_lens)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).btf_id as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(btf_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_info>())).func_info_rec_size as *const _ as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(func_info_rec_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).func_info as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(func_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).nr_func_info as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(nr_func_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).nr_line_info as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(nr_line_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).line_info as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(line_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).jited_line_info as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(jited_line_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_info>())).nr_jited_line_info as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(nr_jited_line_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_info>())).line_info_rec_size as *const _ as usize
        },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(line_info_rec_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_info>())).jited_line_info_rec_size as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(jited_line_info_rec_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).nr_prog_tags as *const _ as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(nr_prog_tags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).prog_tags as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(prog_tags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).run_time_ns as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(run_time_ns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info>())).run_cnt as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info),
            "::",
            stringify!(run_cnt)
        )
    );
}
impl bpf_prog_info {
    #[inline]
    pub fn gpl_compatible(&self) -> __u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gpl_compatible(&mut self, val: __u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(gpl_compatible: __u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let gpl_compatible: u32 = unsafe { ::std::mem::transmute(gpl_compatible) };
            gpl_compatible as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_map_info {
    pub type_: __u32,
    pub id: __u32,
    pub key_size: __u32,
    pub value_size: __u32,
    pub max_entries: __u32,
    pub map_flags: __u32,
    pub name: [::std::os::raw::c_char; 16usize],
    pub ifindex: __u32,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub netns_dev: __u64,
    pub netns_ino: __u64,
    pub btf_id: __u32,
    pub btf_key_type_id: __u32,
    pub btf_value_type_id: __u32,
}
#[test]
fn bindgen_test_layout_bpf_map_info() {
    assert_eq!(
        ::std::mem::size_of::<bpf_map_info>(),
        80usize,
        concat!("Size of: ", stringify!(bpf_map_info))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_map_info>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_map_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).key_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(key_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).value_size as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(value_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).max_entries as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(max_entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).map_flags as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(map_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).name as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).ifindex as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(ifindex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).netns_dev as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(netns_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).netns_ino as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(netns_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).btf_id as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(btf_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).btf_key_type_id as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(btf_key_type_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_info>())).btf_value_type_id as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_info),
            "::",
            stringify!(btf_value_type_id)
        )
    );
}
impl bpf_map_info {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_btf_info {
    pub btf: __u64,
    pub btf_size: __u32,
    pub id: __u32,
}
#[test]
fn bindgen_test_layout_bpf_btf_info() {
    assert_eq!(
        ::std::mem::size_of::<bpf_btf_info>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_btf_info))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_btf_info>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_btf_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_btf_info>())).btf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_btf_info),
            "::",
            stringify!(btf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_btf_info>())).btf_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_btf_info),
            "::",
            stringify!(btf_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_btf_info>())).id as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_btf_info),
            "::",
            stringify!(id)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_sock_addr {
    pub user_family: __u32,
    pub user_ip4: __u32,
    pub user_ip6: [__u32; 4usize],
    pub user_port: __u32,
    pub family: __u32,
    pub type_: __u32,
    pub protocol: __u32,
    pub msg_src_ip4: __u32,
    pub msg_src_ip6: [__u32; 4usize],
    pub __bindgen_anon_1: bpf_sock_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sock_addr__bindgen_ty_1 {
    pub sk: *mut bpf_sock,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bpf_sock_addr__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sock_addr__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_sock_addr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sock_addr__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_sock_addr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_addr__bindgen_ty_1>())).sk as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_addr__bindgen_ty_1),
            "::",
            stringify!(sk)
        )
    );
}
impl Default for bpf_sock_addr__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl bpf_sock_addr__bindgen_ty_1 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_bpf_sock_addr() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sock_addr>(),
        72usize,
        concat!("Size of: ", stringify!(bpf_sock_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sock_addr>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_sock_addr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_addr>())).user_family as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_addr),
            "::",
            stringify!(user_family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_addr>())).user_ip4 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_addr),
            "::",
            stringify!(user_ip4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_addr>())).user_ip6 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_addr),
            "::",
            stringify!(user_ip6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_addr>())).user_port as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_addr),
            "::",
            stringify!(user_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_addr>())).family as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_addr),
            "::",
            stringify!(family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_addr>())).type_ as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_addr),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_addr>())).protocol as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_addr),
            "::",
            stringify!(protocol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_addr>())).msg_src_ip4 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_addr),
            "::",
            stringify!(msg_src_ip4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_addr>())).msg_src_ip6 as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_addr),
            "::",
            stringify!(msg_src_ip6)
        )
    );
}
impl Default for bpf_sock_addr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_sock_ops {
    pub op: __u32,
    pub __bindgen_anon_1: bpf_sock_ops__bindgen_ty_1,
    pub family: __u32,
    pub remote_ip4: __u32,
    pub local_ip4: __u32,
    pub remote_ip6: [__u32; 4usize],
    pub local_ip6: [__u32; 4usize],
    pub remote_port: __u32,
    pub local_port: __u32,
    pub is_fullsock: __u32,
    pub snd_cwnd: __u32,
    pub srtt_us: __u32,
    pub bpf_sock_ops_cb_flags: __u32,
    pub state: __u32,
    pub rtt_min: __u32,
    pub snd_ssthresh: __u32,
    pub rcv_nxt: __u32,
    pub snd_nxt: __u32,
    pub snd_una: __u32,
    pub mss_cache: __u32,
    pub ecn_flags: __u32,
    pub rate_delivered: __u32,
    pub rate_interval_us: __u32,
    pub packets_out: __u32,
    pub retrans_out: __u32,
    pub total_retrans: __u32,
    pub segs_in: __u32,
    pub data_segs_in: __u32,
    pub segs_out: __u32,
    pub data_segs_out: __u32,
    pub lost_out: __u32,
    pub sacked_out: __u32,
    pub sk_txhash: __u32,
    pub bytes_received: __u64,
    pub bytes_acked: __u64,
    pub __bindgen_anon_2: bpf_sock_ops__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sock_ops__bindgen_ty_1 {
    pub args: [__u32; 4usize],
    pub reply: __u32,
    pub replylong: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_bpf_sock_ops__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sock_ops__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_sock_ops__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sock_ops__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_sock_ops__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops__bindgen_ty_1>())).args as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops__bindgen_ty_1),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_ops__bindgen_ty_1>())).reply as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops__bindgen_ty_1),
            "::",
            stringify!(reply)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_ops__bindgen_ty_1>())).replylong as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops__bindgen_ty_1),
            "::",
            stringify!(replylong)
        )
    );
}
impl Default for bpf_sock_ops__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sock_ops__bindgen_ty_2 {
    pub sk: *mut bpf_sock,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bpf_sock_ops__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sock_ops__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_sock_ops__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sock_ops__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_sock_ops__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops__bindgen_ty_2>())).sk as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops__bindgen_ty_2),
            "::",
            stringify!(sk)
        )
    );
}
impl Default for bpf_sock_ops__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl bpf_sock_ops__bindgen_ty_2 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_bpf_sock_ops() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sock_ops>(),
        192usize,
        concat!("Size of: ", stringify!(bpf_sock_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sock_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_sock_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).family as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).remote_ip4 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(remote_ip4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).local_ip4 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(local_ip4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).remote_ip6 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(remote_ip6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).local_ip6 as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(local_ip6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).remote_port as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(remote_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).local_port as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(local_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).is_fullsock as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(is_fullsock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).snd_cwnd as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(snd_cwnd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).srtt_us as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(srtt_us)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sock_ops>())).bpf_sock_ops_cb_flags as *const _ as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(bpf_sock_ops_cb_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).state as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).rtt_min as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(rtt_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).snd_ssthresh as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(snd_ssthresh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).rcv_nxt as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(rcv_nxt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).snd_nxt as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(snd_nxt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).snd_una as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(snd_una)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).mss_cache as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(mss_cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).ecn_flags as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(ecn_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).rate_delivered as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(rate_delivered)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).rate_interval_us as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(rate_interval_us)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).packets_out as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(packets_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).retrans_out as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(retrans_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).total_retrans as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(total_retrans)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).segs_in as *const _ as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(segs_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).data_segs_in as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(data_segs_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).segs_out as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(segs_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).data_segs_out as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(data_segs_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).lost_out as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(lost_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).sacked_out as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(sacked_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).sk_txhash as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(sk_txhash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).bytes_received as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(bytes_received)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sock_ops>())).bytes_acked as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sock_ops),
            "::",
            stringify!(bytes_acked)
        )
    );
}
impl Default for bpf_sock_ops {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub const BPF_SOCK_OPS_VOID: ::std::os::raw::c_uint = 0;
pub const BPF_SOCK_OPS_TIMEOUT_INIT: ::std::os::raw::c_uint = 1;
pub const BPF_SOCK_OPS_RWND_INIT: ::std::os::raw::c_uint = 2;
pub const BPF_SOCK_OPS_TCP_CONNECT_CB: ::std::os::raw::c_uint = 3;
pub const BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB: ::std::os::raw::c_uint = 4;
pub const BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB: ::std::os::raw::c_uint = 5;
pub const BPF_SOCK_OPS_NEEDS_ECN: ::std::os::raw::c_uint = 6;
pub const BPF_SOCK_OPS_BASE_RTT: ::std::os::raw::c_uint = 7;
pub const BPF_SOCK_OPS_RTO_CB: ::std::os::raw::c_uint = 8;
pub const BPF_SOCK_OPS_RETRANS_CB: ::std::os::raw::c_uint = 9;
pub const BPF_SOCK_OPS_STATE_CB: ::std::os::raw::c_uint = 10;
pub const BPF_SOCK_OPS_TCP_LISTEN_CB: ::std::os::raw::c_uint = 11;
pub const BPF_SOCK_OPS_RTT_CB: ::std::os::raw::c_uint = 12;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
pub const BPF_TCP_ESTABLISHED: ::std::os::raw::c_uint = 1;
pub const BPF_TCP_SYN_SENT: ::std::os::raw::c_uint = 2;
pub const BPF_TCP_SYN_RECV: ::std::os::raw::c_uint = 3;
pub const BPF_TCP_FIN_WAIT1: ::std::os::raw::c_uint = 4;
pub const BPF_TCP_FIN_WAIT2: ::std::os::raw::c_uint = 5;
pub const BPF_TCP_TIME_WAIT: ::std::os::raw::c_uint = 6;
pub const BPF_TCP_CLOSE: ::std::os::raw::c_uint = 7;
pub const BPF_TCP_CLOSE_WAIT: ::std::os::raw::c_uint = 8;
pub const BPF_TCP_LAST_ACK: ::std::os::raw::c_uint = 9;
pub const BPF_TCP_LISTEN: ::std::os::raw::c_uint = 10;
pub const BPF_TCP_CLOSING: ::std::os::raw::c_uint = 11;
pub const BPF_TCP_NEW_SYN_RECV: ::std::os::raw::c_uint = 12;
pub const BPF_TCP_MAX_STATES: ::std::os::raw::c_uint = 13;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_perf_event_value {
    pub counter: __u64,
    pub enabled: __u64,
    pub running: __u64,
}
#[test]
fn bindgen_test_layout_bpf_perf_event_value() {
    assert_eq!(
        ::std::mem::size_of::<bpf_perf_event_value>(),
        24usize,
        concat!("Size of: ", stringify!(bpf_perf_event_value))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_perf_event_value>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_perf_event_value))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_perf_event_value>())).counter as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_perf_event_value),
            "::",
            stringify!(counter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_perf_event_value>())).enabled as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_perf_event_value),
            "::",
            stringify!(enabled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_perf_event_value>())).running as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_perf_event_value),
            "::",
            stringify!(running)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_cgroup_dev_ctx {
    pub access_type: __u32,
    pub major: __u32,
    pub minor: __u32,
}
#[test]
fn bindgen_test_layout_bpf_cgroup_dev_ctx() {
    assert_eq!(
        ::std::mem::size_of::<bpf_cgroup_dev_ctx>(),
        12usize,
        concat!("Size of: ", stringify!(bpf_cgroup_dev_ctx))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_cgroup_dev_ctx>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_cgroup_dev_ctx))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_cgroup_dev_ctx>())).access_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_cgroup_dev_ctx),
            "::",
            stringify!(access_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_cgroup_dev_ctx>())).major as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_cgroup_dev_ctx),
            "::",
            stringify!(major)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_cgroup_dev_ctx>())).minor as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_cgroup_dev_ctx),
            "::",
            stringify!(minor)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bpf_raw_tracepoint_args {
    pub args: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_bpf_raw_tracepoint_args() {
    assert_eq!(
        ::std::mem::size_of::<bpf_raw_tracepoint_args>(),
        0usize,
        concat!("Size of: ", stringify!(bpf_raw_tracepoint_args))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_raw_tracepoint_args>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_raw_tracepoint_args))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_raw_tracepoint_args>())).args as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_raw_tracepoint_args),
            "::",
            stringify!(args)
        )
    );
}
pub const BPF_FIB_LKUP_RET_SUCCESS: ::std::os::raw::c_uint = 0;
pub const BPF_FIB_LKUP_RET_BLACKHOLE: ::std::os::raw::c_uint = 1;
pub const BPF_FIB_LKUP_RET_UNREACHABLE: ::std::os::raw::c_uint = 2;
pub const BPF_FIB_LKUP_RET_PROHIBIT: ::std::os::raw::c_uint = 3;
pub const BPF_FIB_LKUP_RET_NOT_FWDED: ::std::os::raw::c_uint = 4;
pub const BPF_FIB_LKUP_RET_FWD_DISABLED: ::std::os::raw::c_uint = 5;
pub const BPF_FIB_LKUP_RET_UNSUPP_LWT: ::std::os::raw::c_uint = 6;
pub const BPF_FIB_LKUP_RET_NO_NEIGH: ::std::os::raw::c_uint = 7;
pub const BPF_FIB_LKUP_RET_FRAG_NEEDED: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_fib_lookup {
    pub family: __u8,
    pub l4_protocol: __u8,
    pub sport: __be16,
    pub dport: __be16,
    pub tot_len: __u16,
    pub ifindex: __u32,
    pub __bindgen_anon_1: bpf_fib_lookup__bindgen_ty_1,
    pub __bindgen_anon_2: bpf_fib_lookup__bindgen_ty_2,
    pub __bindgen_anon_3: bpf_fib_lookup__bindgen_ty_3,
    pub h_vlan_proto: __be16,
    pub h_vlan_TCI: __be16,
    pub smac: [__u8; 6usize],
    pub dmac: [__u8; 6usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_fib_lookup__bindgen_ty_1 {
    pub tos: __u8,
    pub flowinfo: __be32,
    pub rt_metric: __u32,
}
#[test]
fn bindgen_test_layout_bpf_fib_lookup__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_fib_lookup__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(bpf_fib_lookup__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_fib_lookup__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_fib_lookup__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_fib_lookup__bindgen_ty_1>())).tos as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup__bindgen_ty_1),
            "::",
            stringify!(tos)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_fib_lookup__bindgen_ty_1>())).flowinfo as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup__bindgen_ty_1),
            "::",
            stringify!(flowinfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_fib_lookup__bindgen_ty_1>())).rt_metric as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup__bindgen_ty_1),
            "::",
            stringify!(rt_metric)
        )
    );
}
impl Default for bpf_fib_lookup__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_fib_lookup__bindgen_ty_2 {
    pub ipv4_src: __be32,
    pub ipv6_src: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_bpf_fib_lookup__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<bpf_fib_lookup__bindgen_ty_2>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_fib_lookup__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_fib_lookup__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_fib_lookup__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_fib_lookup__bindgen_ty_2>())).ipv4_src as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup__bindgen_ty_2),
            "::",
            stringify!(ipv4_src)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_fib_lookup__bindgen_ty_2>())).ipv6_src as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup__bindgen_ty_2),
            "::",
            stringify!(ipv6_src)
        )
    );
}
impl Default for bpf_fib_lookup__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_fib_lookup__bindgen_ty_3 {
    pub ipv4_dst: __be32,
    pub ipv6_dst: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_bpf_fib_lookup__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<bpf_fib_lookup__bindgen_ty_3>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_fib_lookup__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_fib_lookup__bindgen_ty_3>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_fib_lookup__bindgen_ty_3))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_fib_lookup__bindgen_ty_3>())).ipv4_dst as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup__bindgen_ty_3),
            "::",
            stringify!(ipv4_dst)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_fib_lookup__bindgen_ty_3>())).ipv6_dst as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup__bindgen_ty_3),
            "::",
            stringify!(ipv6_dst)
        )
    );
}
impl Default for bpf_fib_lookup__bindgen_ty_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_bpf_fib_lookup() {
    assert_eq!(
        ::std::mem::size_of::<bpf_fib_lookup>(),
        64usize,
        concat!("Size of: ", stringify!(bpf_fib_lookup))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_fib_lookup>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_fib_lookup))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_fib_lookup>())).family as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup),
            "::",
            stringify!(family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_fib_lookup>())).l4_protocol as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup),
            "::",
            stringify!(l4_protocol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_fib_lookup>())).sport as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup),
            "::",
            stringify!(sport)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_fib_lookup>())).dport as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup),
            "::",
            stringify!(dport)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_fib_lookup>())).tot_len as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup),
            "::",
            stringify!(tot_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_fib_lookup>())).ifindex as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup),
            "::",
            stringify!(ifindex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_fib_lookup>())).h_vlan_proto as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup),
            "::",
            stringify!(h_vlan_proto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_fib_lookup>())).h_vlan_TCI as *const _ as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup),
            "::",
            stringify!(h_vlan_TCI)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_fib_lookup>())).smac as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup),
            "::",
            stringify!(smac)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_fib_lookup>())).dmac as *const _ as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_fib_lookup),
            "::",
            stringify!(dmac)
        )
    );
}
impl Default for bpf_fib_lookup {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub const bpf_task_fd_type_BPF_FD_TYPE_RAW_TRACEPOINT: bpf_task_fd_type = 0;
pub const bpf_task_fd_type_BPF_FD_TYPE_TRACEPOINT: bpf_task_fd_type = 1;
pub const bpf_task_fd_type_BPF_FD_TYPE_KPROBE: bpf_task_fd_type = 2;
pub const bpf_task_fd_type_BPF_FD_TYPE_KRETPROBE: bpf_task_fd_type = 3;
pub const bpf_task_fd_type_BPF_FD_TYPE_UPROBE: bpf_task_fd_type = 4;
pub const bpf_task_fd_type_BPF_FD_TYPE_URETPROBE: bpf_task_fd_type = 5;
pub type bpf_task_fd_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_flow_keys {
    pub nhoff: __u16,
    pub thoff: __u16,
    pub addr_proto: __u16,
    pub is_frag: __u8,
    pub is_first_frag: __u8,
    pub is_encap: __u8,
    pub ip_proto: __u8,
    pub n_proto: __be16,
    pub sport: __be16,
    pub dport: __be16,
    pub __bindgen_anon_1: bpf_flow_keys__bindgen_ty_1,
    pub flags: __u32,
    pub flow_label: __be32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_flow_keys__bindgen_ty_1 {
    pub __bindgen_anon_1: bpf_flow_keys__bindgen_ty_1__bindgen_ty_1,
    pub __bindgen_anon_2: bpf_flow_keys__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_flow_keys__bindgen_ty_1__bindgen_ty_1 {
    pub ipv4_src: __be32,
    pub ipv4_dst: __be32,
}
#[test]
fn bindgen_test_layout_bpf_flow_keys__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_flow_keys__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(bpf_flow_keys__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_flow_keys__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_flow_keys__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_flow_keys__bindgen_ty_1__bindgen_ty_1>())).ipv4_src
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ipv4_src)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_flow_keys__bindgen_ty_1__bindgen_ty_1>())).ipv4_dst
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ipv4_dst)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_flow_keys__bindgen_ty_1__bindgen_ty_2 {
    pub ipv6_src: [__u32; 4usize],
    pub ipv6_dst: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_bpf_flow_keys__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<bpf_flow_keys__bindgen_ty_1__bindgen_ty_2>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(bpf_flow_keys__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_flow_keys__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_flow_keys__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_flow_keys__bindgen_ty_1__bindgen_ty_2>())).ipv6_src
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(ipv6_src)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_flow_keys__bindgen_ty_1__bindgen_ty_2>())).ipv6_dst
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(ipv6_dst)
        )
    );
}
#[test]
fn bindgen_test_layout_bpf_flow_keys__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_flow_keys__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(bpf_flow_keys__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_flow_keys__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_flow_keys__bindgen_ty_1))
    );
}
impl Default for bpf_flow_keys__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_bpf_flow_keys() {
    assert_eq!(
        ::std::mem::size_of::<bpf_flow_keys>(),
        56usize,
        concat!("Size of: ", stringify!(bpf_flow_keys))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_flow_keys>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_flow_keys))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).nhoff as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(nhoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).thoff as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(thoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).addr_proto as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(addr_proto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).is_frag as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(is_frag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).is_first_frag as *const _ as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(is_first_frag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).is_encap as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(is_encap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).ip_proto as *const _ as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(ip_proto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).n_proto as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(n_proto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).sport as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(sport)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).dport as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(dport)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_flow_keys>())).flow_label as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_flow_keys),
            "::",
            stringify!(flow_label)
        )
    );
}
impl Default for bpf_flow_keys {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_func_info {
    pub insn_off: __u32,
    pub type_id: __u32,
}
#[test]
fn bindgen_test_layout_bpf_func_info() {
    assert_eq!(
        ::std::mem::size_of::<bpf_func_info>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_func_info))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_func_info>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_func_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_func_info>())).insn_off as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_func_info),
            "::",
            stringify!(insn_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_func_info>())).type_id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_func_info),
            "::",
            stringify!(type_id)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_line_info {
    pub insn_off: __u32,
    pub file_name_off: __u32,
    pub line_off: __u32,
    pub line_col: __u32,
}
#[test]
fn bindgen_test_layout_bpf_line_info() {
    assert_eq!(
        ::std::mem::size_of::<bpf_line_info>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_line_info))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_line_info>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_line_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_line_info>())).insn_off as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_line_info),
            "::",
            stringify!(insn_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_line_info>())).file_name_off as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_line_info),
            "::",
            stringify!(file_name_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_line_info>())).line_off as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_line_info),
            "::",
            stringify!(line_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_line_info>())).line_col as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_line_info),
            "::",
            stringify!(line_col)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_spin_lock {
    pub val: __u32,
}
#[test]
fn bindgen_test_layout_bpf_spin_lock() {
    assert_eq!(
        ::std::mem::size_of::<bpf_spin_lock>(),
        4usize,
        concat!("Size of: ", stringify!(bpf_spin_lock))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_spin_lock>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_spin_lock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_spin_lock>())).val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_spin_lock),
            "::",
            stringify!(val)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_sysctl {
    pub write: __u32,
    pub file_pos: __u32,
}
#[test]
fn bindgen_test_layout_bpf_sysctl() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sysctl>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_sysctl))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sysctl>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_sysctl))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sysctl>())).write as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sysctl),
            "::",
            stringify!(write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sysctl>())).file_pos as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sysctl),
            "::",
            stringify!(file_pos)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_sockopt {
    pub __bindgen_anon_1: bpf_sockopt__bindgen_ty_1,
    pub __bindgen_anon_2: bpf_sockopt__bindgen_ty_2,
    pub __bindgen_anon_3: bpf_sockopt__bindgen_ty_3,
    pub level: __s32,
    pub optname: __s32,
    pub optlen: __s32,
    pub retval: __s32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sockopt__bindgen_ty_1 {
    pub sk: *mut bpf_sock,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bpf_sockopt__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sockopt__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_sockopt__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sockopt__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_sockopt__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sockopt__bindgen_ty_1>())).sk as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sockopt__bindgen_ty_1),
            "::",
            stringify!(sk)
        )
    );
}
impl Default for bpf_sockopt__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl bpf_sockopt__bindgen_ty_1 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sockopt__bindgen_ty_2 {
    pub optval: *mut ::std::os::raw::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bpf_sockopt__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sockopt__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_sockopt__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sockopt__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_sockopt__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sockopt__bindgen_ty_2>())).optval as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sockopt__bindgen_ty_2),
            "::",
            stringify!(optval)
        )
    );
}
impl Default for bpf_sockopt__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl bpf_sockopt__bindgen_ty_2 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sockopt__bindgen_ty_3 {
    pub optval_end: *mut ::std::os::raw::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bpf_sockopt__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sockopt__bindgen_ty_3>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_sockopt__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sockopt__bindgen_ty_3>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_sockopt__bindgen_ty_3))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_sockopt__bindgen_ty_3>())).optval_end as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sockopt__bindgen_ty_3),
            "::",
            stringify!(optval_end)
        )
    );
}
impl Default for bpf_sockopt__bindgen_ty_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl bpf_sockopt__bindgen_ty_3 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_bpf_sockopt() {
    assert_eq!(
        ::std::mem::size_of::<bpf_sockopt>(),
        40usize,
        concat!("Size of: ", stringify!(bpf_sockopt))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_sockopt>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_sockopt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sockopt>())).level as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sockopt),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sockopt>())).optname as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sockopt),
            "::",
            stringify!(optname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sockopt>())).optlen as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sockopt),
            "::",
            stringify!(optlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_sockopt>())).retval as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_sockopt),
            "::",
            stringify!(retval)
        )
    );
}
impl Default for bpf_sockopt {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn memcpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memccpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __s: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct __locale_struct {
    pub __locales: [*mut __locale_data; 13usize],
    pub __ctype_b: *const ::std::os::raw::c_ushort,
    pub __ctype_tolower: *const ::std::os::raw::c_int,
    pub __ctype_toupper: *const ::std::os::raw::c_int,
    pub __names: [*const ::std::os::raw::c_char; 13usize],
}
#[test]
fn bindgen_test_layout___locale_struct() {
    assert_eq!(
        ::std::mem::size_of::<__locale_struct>(),
        232usize,
        concat!("Size of: ", stringify!(__locale_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<__locale_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(__locale_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__locales as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__locales)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_b as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_tolower as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_tolower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_toupper as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_toupper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__names as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__names)
        )
    );
}
impl Default for __locale_struct {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __locale_t = *mut __locale_struct;
pub type locale_t = __locale_t;
extern "C" {
    pub fn strcoll_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __l: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm_l(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
        __l: locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn strdup(__s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __string: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __reject: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strstr(
        __haystack: *const ::std::os::raw::c_char,
        __needle: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strnlen(__string: *const ::std::os::raw::c_char, __maxlen: size_t) -> size_t;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}__xpg_strerror_r"]
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strerror_l(
        __errnum: ::std::os::raw::c_int,
        __l: locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcopy(
        __src: *const ::std::os::raw::c_void,
        __dest: *mut ::std::os::raw::c_void,
        __n: size_t,
    );
}
extern "C" {
    pub fn bzero(__s: *mut ::std::os::raw::c_void, __n: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn index(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(__i: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsl(__l: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsll(__ll: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __loc: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: size_t,
        __loc: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn explicit_bzero(__s: *mut ::std::os::raw::c_void, __n: size_t);
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
pub const libbpf_errno___LIBBPF_ERRNO__START: libbpf_errno = 4000;
pub const libbpf_errno_LIBBPF_ERRNO__LIBELF: libbpf_errno = 4000;
pub const libbpf_errno_LIBBPF_ERRNO__FORMAT: libbpf_errno = 4001;
pub const libbpf_errno_LIBBPF_ERRNO__KVERSION: libbpf_errno = 4002;
pub const libbpf_errno_LIBBPF_ERRNO__ENDIAN: libbpf_errno = 4003;
pub const libbpf_errno_LIBBPF_ERRNO__INTERNAL: libbpf_errno = 4004;
pub const libbpf_errno_LIBBPF_ERRNO__RELOC: libbpf_errno = 4005;
pub const libbpf_errno_LIBBPF_ERRNO__LOAD: libbpf_errno = 4006;
pub const libbpf_errno_LIBBPF_ERRNO__VERIFY: libbpf_errno = 4007;
pub const libbpf_errno_LIBBPF_ERRNO__PROG2BIG: libbpf_errno = 4008;
pub const libbpf_errno_LIBBPF_ERRNO__KVER: libbpf_errno = 4009;
pub const libbpf_errno_LIBBPF_ERRNO__PROGTYPE: libbpf_errno = 4010;
pub const libbpf_errno_LIBBPF_ERRNO__WRNGPID: libbpf_errno = 4011;
pub const libbpf_errno_LIBBPF_ERRNO__INVSEQ: libbpf_errno = 4012;
pub const libbpf_errno_LIBBPF_ERRNO__NLPARSE: libbpf_errno = 4013;
pub const libbpf_errno___LIBBPF_ERRNO__END: libbpf_errno = 4014;
pub type libbpf_errno = ::std::os::raw::c_uint;
extern "C" {
    pub fn libbpf_strerror(
        err: ::std::os::raw::c_int,
        buf: *mut ::std::os::raw::c_char,
        size: size_t,
    ) -> ::std::os::raw::c_int;
}
pub const libbpf_print_level_LIBBPF_WARN: libbpf_print_level = 0;
pub const libbpf_print_level_LIBBPF_INFO: libbpf_print_level = 1;
pub const libbpf_print_level_LIBBPF_DEBUG: libbpf_print_level = 2;
pub type libbpf_print_level = ::std::os::raw::c_uint;
pub type libbpf_print_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        level: libbpf_print_level,
        arg1: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn libbpf_set_print(fn_: libbpf_print_fn_t) -> libbpf_print_fn_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_object {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_object_open_attr {
    pub file: *const ::std::os::raw::c_char,
    pub prog_type: bpf_prog_type,
}
#[test]
fn bindgen_test_layout_bpf_object_open_attr() {
    assert_eq!(
        ::std::mem::size_of::<bpf_object_open_attr>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_object_open_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_object_open_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_object_open_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_open_attr>())).file as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_open_attr),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_open_attr>())).prog_type as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_open_attr),
            "::",
            stringify!(prog_type)
        )
    );
}
impl Default for bpf_object_open_attr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_object_open_opts {
    pub sz: size_t,
    pub object_name: *const ::std::os::raw::c_char,
    pub relaxed_maps: bool,
    pub relaxed_core_relocs: bool,
    pub pin_root_path: *const ::std::os::raw::c_char,
    pub attach_prog_fd: __u32,
    pub kconfig: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_bpf_object_open_opts() {
    assert_eq!(
        ::std::mem::size_of::<bpf_object_open_opts>(),
        48usize,
        concat!("Size of: ", stringify!(bpf_object_open_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_object_open_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_object_open_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_open_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_open_opts),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_object_open_opts>())).object_name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_open_opts),
            "::",
            stringify!(object_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_object_open_opts>())).relaxed_maps as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_open_opts),
            "::",
            stringify!(relaxed_maps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_object_open_opts>())).relaxed_core_relocs as *const _
                as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_open_opts),
            "::",
            stringify!(relaxed_core_relocs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_object_open_opts>())).pin_root_path as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_open_opts),
            "::",
            stringify!(pin_root_path)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_object_open_opts>())).attach_prog_fd as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_open_opts),
            "::",
            stringify!(attach_prog_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_open_opts>())).kconfig as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_open_opts),
            "::",
            stringify!(kconfig)
        )
    );
}
impl Default for bpf_object_open_opts {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn bpf_object__open(path: *const ::std::os::raw::c_char) -> *mut bpf_object;
}
extern "C" {
    pub fn bpf_object__open_file(
        path: *const ::std::os::raw::c_char,
        opts: *const bpf_object_open_opts,
    ) -> *mut bpf_object;
}
extern "C" {
    pub fn bpf_object__open_mem(
        obj_buf: *const ::std::os::raw::c_void,
        obj_buf_sz: size_t,
        opts: *const bpf_object_open_opts,
    ) -> *mut bpf_object;
}
extern "C" {
    pub fn bpf_object__open_buffer(
        obj_buf: *const ::std::os::raw::c_void,
        obj_buf_sz: size_t,
        name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_object;
}
extern "C" {
    pub fn bpf_object__open_xattr(attr: *mut bpf_object_open_attr) -> *mut bpf_object;
}
pub const libbpf_pin_type_LIBBPF_PIN_NONE: libbpf_pin_type = 0;
pub const libbpf_pin_type_LIBBPF_PIN_BY_NAME: libbpf_pin_type = 1;
pub type libbpf_pin_type = ::std::os::raw::c_uint;
extern "C" {
    pub fn bpf_object__pin_maps(
        obj: *mut bpf_object,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__unpin_maps(
        obj: *mut bpf_object,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__pin_programs(
        obj: *mut bpf_object,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__unpin_programs(
        obj: *mut bpf_object,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__pin(
        object: *mut bpf_object,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__close(object: *mut bpf_object);
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_object_load_attr {
    pub obj: *mut bpf_object,
    pub log_level: ::std::os::raw::c_int,
    pub target_btf_path: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_bpf_object_load_attr() {
    assert_eq!(
        ::std::mem::size_of::<bpf_object_load_attr>(),
        24usize,
        concat!("Size of: ", stringify!(bpf_object_load_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_object_load_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_object_load_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_load_attr>())).obj as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_load_attr),
            "::",
            stringify!(obj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_load_attr>())).log_level as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_load_attr),
            "::",
            stringify!(log_level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_object_load_attr>())).target_btf_path as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_load_attr),
            "::",
            stringify!(target_btf_path)
        )
    );
}
impl Default for bpf_object_load_attr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn bpf_object__load(obj: *mut bpf_object) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__load_xattr(attr: *mut bpf_object_load_attr) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__unload(obj: *mut bpf_object) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__name(obj: *const bpf_object) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_object__kversion(obj: *const bpf_object) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn bpf_object__set_kversion(
        obj: *mut bpf_object,
        kern_version: __u32,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btf {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_object__btf(obj: *const bpf_object) -> *mut btf;
}
extern "C" {
    pub fn bpf_object__btf_fd(obj: *const bpf_object) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_program {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_object__find_program_by_title(
        obj: *const bpf_object,
        title: *const ::std::os::raw::c_char,
    ) -> *mut bpf_program;
}
extern "C" {
    pub fn bpf_object__find_program_by_name(
        obj: *const bpf_object,
        name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_program;
}
extern "C" {
    pub fn bpf_object__next(prev: *mut bpf_object) -> *mut bpf_object;
}
pub type bpf_object_clear_priv_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut bpf_object, arg2: *mut ::std::os::raw::c_void),
>;
extern "C" {
    pub fn bpf_object__set_priv(
        obj: *mut bpf_object,
        priv_: *mut ::std::os::raw::c_void,
        clear_priv: bpf_object_clear_priv_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__priv(prog: *const bpf_object) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn libbpf_prog_type_by_name(
        name: *const ::std::os::raw::c_char,
        prog_type: *mut bpf_prog_type,
        expected_attach_type: *mut bpf_attach_type,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn libbpf_attach_type_by_name(
        name: *const ::std::os::raw::c_char,
        attach_type: *mut bpf_attach_type,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn libbpf_find_vmlinux_btf_id(
        name: *const ::std::os::raw::c_char,
        attach_type: bpf_attach_type,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__next(prog: *mut bpf_program, obj: *const bpf_object) -> *mut bpf_program;
}
extern "C" {
    pub fn bpf_program__prev(prog: *mut bpf_program, obj: *const bpf_object) -> *mut bpf_program;
}
pub type bpf_program_clear_priv_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut bpf_program, arg2: *mut ::std::os::raw::c_void),
>;
extern "C" {
    pub fn bpf_program__set_priv(
        prog: *mut bpf_program,
        priv_: *mut ::std::os::raw::c_void,
        clear_priv: bpf_program_clear_priv_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__priv(prog: *const bpf_program) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_program__set_ifindex(prog: *mut bpf_program, ifindex: __u32);
}
extern "C" {
    pub fn bpf_program__name(prog: *const bpf_program) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_program__section_name(prog: *const bpf_program) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_program__title(
        prog: *const bpf_program,
        needs_copy: bool,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_program__autoload(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__set_autoload(
        prog: *mut bpf_program,
        autoload: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__size(prog: *const bpf_program) -> size_t;
}
extern "C" {
    pub fn bpf_program__load(
        prog: *mut bpf_program,
        license: *mut ::std::os::raw::c_char,
        kern_version: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__fd(prog: *const bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__pin_instance(
        prog: *mut bpf_program,
        path: *const ::std::os::raw::c_char,
        instance: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__unpin_instance(
        prog: *mut bpf_program,
        path: *const ::std::os::raw::c_char,
        instance: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__pin(
        prog: *mut bpf_program,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__unpin(
        prog: *mut bpf_program,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__unload(prog: *mut bpf_program);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_link {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_link__open(path: *const ::std::os::raw::c_char) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_link__fd(link: *const bpf_link) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link__pin_path(link: *const bpf_link) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_link__pin(
        link: *mut bpf_link,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link__unpin(link: *mut bpf_link) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link__update_program(
        link: *mut bpf_link,
        prog: *mut bpf_program,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link__disconnect(link: *mut bpf_link);
}
extern "C" {
    pub fn bpf_link__detach(link: *mut bpf_link) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link__destroy(link: *mut bpf_link) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__attach(prog: *mut bpf_program) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_perf_event(
        prog: *mut bpf_program,
        pfd: ::std::os::raw::c_int,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_kprobe(
        prog: *mut bpf_program,
        retprobe: bool,
        func_name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_uprobe(
        prog: *mut bpf_program,
        retprobe: bool,
        pid: pid_t,
        binary_path: *const ::std::os::raw::c_char,
        func_offset: size_t,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_tracepoint(
        prog: *mut bpf_program,
        tp_category: *const ::std::os::raw::c_char,
        tp_name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_raw_tracepoint(
        prog: *mut bpf_program,
        tp_name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_trace(prog: *mut bpf_program) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_lsm(prog: *mut bpf_program) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_cgroup(
        prog: *mut bpf_program,
        cgroup_fd: ::std::os::raw::c_int,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_netns(
        prog: *mut bpf_program,
        netns_fd: ::std::os::raw::c_int,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_xdp(
        prog: *mut bpf_program,
        ifindex: ::std::os::raw::c_int,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_freplace(
        prog: *mut bpf_program,
        target_fd: ::std::os::raw::c_int,
        attach_func_name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_link;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_map {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_map__attach_struct_ops(map: *mut bpf_map) -> *mut bpf_link;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_iter_attach_opts {
    pub sz: size_t,
    pub link_info: *mut bpf_iter_link_info,
    pub link_info_len: __u32,
}
#[test]
fn bindgen_test_layout_bpf_iter_attach_opts() {
    assert_eq!(
        ::std::mem::size_of::<bpf_iter_attach_opts>(),
        24usize,
        concat!("Size of: ", stringify!(bpf_iter_attach_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_iter_attach_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_iter_attach_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_iter_attach_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_iter_attach_opts),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_iter_attach_opts>())).link_info as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_iter_attach_opts),
            "::",
            stringify!(link_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_iter_attach_opts>())).link_info_len as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_iter_attach_opts),
            "::",
            stringify!(link_info_len)
        )
    );
}
impl Default for bpf_iter_attach_opts {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn bpf_program__attach_iter(
        prog: *mut bpf_program,
        opts: *const bpf_iter_attach_opts,
    ) -> *mut bpf_link;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_prog_prep_result {
    pub new_insn_ptr: *mut bpf_insn,
    pub new_insn_cnt: ::std::os::raw::c_int,
    pub pfd: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bpf_prog_prep_result() {
    assert_eq!(
        ::std::mem::size_of::<bpf_prog_prep_result>(),
        24usize,
        concat!("Size of: ", stringify!(bpf_prog_prep_result))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_prog_prep_result>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_prog_prep_result))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_prep_result>())).new_insn_ptr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_prep_result),
            "::",
            stringify!(new_insn_ptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_prep_result>())).new_insn_cnt as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_prep_result),
            "::",
            stringify!(new_insn_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_prep_result>())).pfd as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_prep_result),
            "::",
            stringify!(pfd)
        )
    );
}
impl Default for bpf_prog_prep_result {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type bpf_program_prep_t = ::std::option::Option<
    unsafe extern "C" fn(
        prog: *mut bpf_program,
        n: ::std::os::raw::c_int,
        insns: *mut bpf_insn,
        insns_cnt: ::std::os::raw::c_int,
        res: *mut bpf_prog_prep_result,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bpf_program__set_prep(
        prog: *mut bpf_program,
        nr_instance: ::std::os::raw::c_int,
        prep: bpf_program_prep_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__nth_fd(
        prog: *const bpf_program,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_socket_filter(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_tracepoint(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_raw_tracepoint(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_kprobe(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_lsm(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_sched_cls(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_sched_act(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_xdp(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_perf_event(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_tracing(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_struct_ops(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_extension(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_sk_lookup(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__get_type(prog: *const bpf_program) -> bpf_prog_type;
}
extern "C" {
    pub fn bpf_program__set_type(prog: *mut bpf_program, type_: bpf_prog_type);
}
extern "C" {
    pub fn bpf_program__get_expected_attach_type(prog: *const bpf_program) -> bpf_attach_type;
}
extern "C" {
    pub fn bpf_program__set_expected_attach_type(prog: *mut bpf_program, type_: bpf_attach_type);
}
extern "C" {
    pub fn bpf_program__set_attach_target(
        prog: *mut bpf_program,
        attach_prog_fd: ::std::os::raw::c_int,
        attach_func_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__is_socket_filter(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_tracepoint(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_raw_tracepoint(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_kprobe(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_lsm(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_sched_cls(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_sched_act(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_xdp(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_perf_event(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_tracing(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_struct_ops(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_extension(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_sk_lookup(prog: *const bpf_program) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_map_def {
    pub type_: ::std::os::raw::c_uint,
    pub key_size: ::std::os::raw::c_uint,
    pub value_size: ::std::os::raw::c_uint,
    pub max_entries: ::std::os::raw::c_uint,
    pub map_flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_bpf_map_def() {
    assert_eq!(
        ::std::mem::size_of::<bpf_map_def>(),
        20usize,
        concat!("Size of: ", stringify!(bpf_map_def))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_map_def>(),
        4usize,
        concat!("Alignment of ", stringify!(bpf_map_def))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_def>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_def),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_def>())).key_size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_def),
            "::",
            stringify!(key_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_def>())).value_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_def),
            "::",
            stringify!(value_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_def>())).max_entries as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_def),
            "::",
            stringify!(max_entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_def>())).map_flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_def),
            "::",
            stringify!(map_flags)
        )
    );
}
extern "C" {
    pub fn bpf_object__find_map_by_name(
        obj: *const bpf_object,
        name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_map;
}
extern "C" {
    pub fn bpf_object__find_map_fd_by_name(
        obj: *const bpf_object,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__find_map_by_offset(obj: *mut bpf_object, offset: size_t) -> *mut bpf_map;
}
extern "C" {
    pub fn bpf_map__next(map: *const bpf_map, obj: *const bpf_object) -> *mut bpf_map;
}
extern "C" {
    pub fn bpf_map__prev(map: *const bpf_map, obj: *const bpf_object) -> *mut bpf_map;
}
extern "C" {
    pub fn bpf_map__fd(map: *const bpf_map) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__reuse_fd(map: *mut bpf_map, fd: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__def(map: *const bpf_map) -> *const bpf_map_def;
}
extern "C" {
    pub fn bpf_map__name(map: *const bpf_map) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_map__type(map: *const bpf_map) -> bpf_map_type;
}
extern "C" {
    pub fn bpf_map__set_type(map: *mut bpf_map, type_: bpf_map_type) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__max_entries(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_max_entries(map: *mut bpf_map, max_entries: __u32)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__resize(map: *mut bpf_map, max_entries: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__map_flags(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_map_flags(map: *mut bpf_map, flags: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__numa_node(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_numa_node(map: *mut bpf_map, numa_node: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__key_size(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_key_size(map: *mut bpf_map, size: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__value_size(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_value_size(map: *mut bpf_map, size: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__btf_key_type_id(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__btf_value_type_id(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__ifindex(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_ifindex(map: *mut bpf_map, ifindex: __u32) -> ::std::os::raw::c_int;
}
pub type bpf_map_clear_priv_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut bpf_map, arg2: *mut ::std::os::raw::c_void),
>;
extern "C" {
    pub fn bpf_map__set_priv(
        map: *mut bpf_map,
        priv_: *mut ::std::os::raw::c_void,
        clear_priv: bpf_map_clear_priv_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__priv(map: *const bpf_map) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_map__set_initial_value(
        map: *mut bpf_map,
        data: *const ::std::os::raw::c_void,
        size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__is_offload_neutral(map: *const bpf_map) -> bool;
}
extern "C" {
    pub fn bpf_map__is_internal(map: *const bpf_map) -> bool;
}
extern "C" {
    pub fn bpf_map__set_pin_path(
        map: *mut bpf_map,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__get_pin_path(map: *const bpf_map) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_map__is_pinned(map: *const bpf_map) -> bool;
}
extern "C" {
    pub fn bpf_map__pin(
        map: *mut bpf_map,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__unpin(
        map: *mut bpf_map,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__set_inner_map_fd(
        map: *mut bpf_map,
        fd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn libbpf_get_error(ptr: *const ::std::os::raw::c_void) -> ::std::os::raw::c_long;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_prog_load_attr {
    pub file: *const ::std::os::raw::c_char,
    pub prog_type: bpf_prog_type,
    pub expected_attach_type: bpf_attach_type,
    pub ifindex: ::std::os::raw::c_int,
    pub log_level: ::std::os::raw::c_int,
    pub prog_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bpf_prog_load_attr() {
    assert_eq!(
        ::std::mem::size_of::<bpf_prog_load_attr>(),
        32usize,
        concat!("Size of: ", stringify!(bpf_prog_load_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_prog_load_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_prog_load_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_load_attr>())).file as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_load_attr),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_load_attr>())).prog_type as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_load_attr),
            "::",
            stringify!(prog_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_load_attr>())).expected_attach_type as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_load_attr),
            "::",
            stringify!(expected_attach_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_load_attr>())).ifindex as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_load_attr),
            "::",
            stringify!(ifindex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_load_attr>())).log_level as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_load_attr),
            "::",
            stringify!(log_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_load_attr>())).prog_flags as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_load_attr),
            "::",
            stringify!(prog_flags)
        )
    );
}
impl Default for bpf_prog_load_attr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn bpf_prog_load_xattr(
        attr: *const bpf_prog_load_attr,
        pobj: *mut *mut bpf_object,
        prog_fd: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_load(
        file: *const ::std::os::raw::c_char,
        type_: bpf_prog_type,
        pobj: *mut *mut bpf_object,
        prog_fd: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct xdp_link_info {
    pub prog_id: __u32,
    pub drv_prog_id: __u32,
    pub hw_prog_id: __u32,
    pub skb_prog_id: __u32,
    pub attach_mode: __u8,
}
#[test]
fn bindgen_test_layout_xdp_link_info() {
    assert_eq!(
        ::std::mem::size_of::<xdp_link_info>(),
        20usize,
        concat!("Size of: ", stringify!(xdp_link_info))
    );
    assert_eq!(
        ::std::mem::align_of::<xdp_link_info>(),
        4usize,
        concat!("Alignment of ", stringify!(xdp_link_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_link_info>())).prog_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_link_info),
            "::",
            stringify!(prog_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_link_info>())).drv_prog_id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_link_info),
            "::",
            stringify!(drv_prog_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_link_info>())).hw_prog_id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_link_info),
            "::",
            stringify!(hw_prog_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_link_info>())).skb_prog_id as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_link_info),
            "::",
            stringify!(skb_prog_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_link_info>())).attach_mode as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_link_info),
            "::",
            stringify!(attach_mode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_xdp_set_link_opts {
    pub sz: size_t,
    pub old_fd: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bpf_xdp_set_link_opts() {
    assert_eq!(
        ::std::mem::size_of::<bpf_xdp_set_link_opts>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_xdp_set_link_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_xdp_set_link_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_xdp_set_link_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_xdp_set_link_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_xdp_set_link_opts),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_xdp_set_link_opts>())).old_fd as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_xdp_set_link_opts),
            "::",
            stringify!(old_fd)
        )
    );
}
extern "C" {
    pub fn bpf_set_link_xdp_fd(
        ifindex: ::std::os::raw::c_int,
        fd: ::std::os::raw::c_int,
        flags: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_set_link_xdp_fd_opts(
        ifindex: ::std::os::raw::c_int,
        fd: ::std::os::raw::c_int,
        flags: __u32,
        opts: *const bpf_xdp_set_link_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_get_link_xdp_id(
        ifindex: ::std::os::raw::c_int,
        prog_id: *mut __u32,
        flags: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_get_link_xdp_info(
        ifindex: ::std::os::raw::c_int,
        info: *mut xdp_link_info,
        info_size: size_t,
        flags: __u32,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ring_buffer {
    _unused: [u8; 0],
}
pub type ring_buffer_sample_fn = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        data: *mut ::std::os::raw::c_void,
        size: size_t,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ring_buffer_opts {
    pub sz: size_t,
}
#[test]
fn bindgen_test_layout_ring_buffer_opts() {
    assert_eq!(
        ::std::mem::size_of::<ring_buffer_opts>(),
        8usize,
        concat!("Size of: ", stringify!(ring_buffer_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<ring_buffer_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(ring_buffer_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ring_buffer_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ring_buffer_opts),
            "::",
            stringify!(sz)
        )
    );
}
extern "C" {
    pub fn ring_buffer__new(
        map_fd: ::std::os::raw::c_int,
        sample_cb: ring_buffer_sample_fn,
        ctx: *mut ::std::os::raw::c_void,
        opts: *const ring_buffer_opts,
    ) -> *mut ring_buffer;
}
extern "C" {
    pub fn ring_buffer__free(rb: *mut ring_buffer);
}
extern "C" {
    pub fn ring_buffer__add(
        rb: *mut ring_buffer,
        map_fd: ::std::os::raw::c_int,
        sample_cb: ring_buffer_sample_fn,
        ctx: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ring_buffer__poll(
        rb: *mut ring_buffer,
        timeout_ms: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ring_buffer__consume(rb: *mut ring_buffer) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ring_buffer__epoll_fd(rb: *const ring_buffer) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct perf_buffer {
    _unused: [u8; 0],
}
pub type perf_buffer_sample_fn = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        cpu: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        size: __u32,
    ),
>;
pub type perf_buffer_lost_fn = ::std::option::Option<
    unsafe extern "C" fn(ctx: *mut ::std::os::raw::c_void, cpu: ::std::os::raw::c_int, cnt: __u64),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct perf_buffer_opts {
    pub sample_cb: perf_buffer_sample_fn,
    pub lost_cb: perf_buffer_lost_fn,
    pub ctx: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_perf_buffer_opts() {
    assert_eq!(
        ::std::mem::size_of::<perf_buffer_opts>(),
        24usize,
        concat!("Size of: ", stringify!(perf_buffer_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<perf_buffer_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(perf_buffer_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<perf_buffer_opts>())).sample_cb as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(perf_buffer_opts),
            "::",
            stringify!(sample_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<perf_buffer_opts>())).lost_cb as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(perf_buffer_opts),
            "::",
            stringify!(lost_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<perf_buffer_opts>())).ctx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(perf_buffer_opts),
            "::",
            stringify!(ctx)
        )
    );
}
impl Default for perf_buffer_opts {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn perf_buffer__new(
        map_fd: ::std::os::raw::c_int,
        page_cnt: size_t,
        opts: *const perf_buffer_opts,
    ) -> *mut perf_buffer;
}
pub const bpf_perf_event_ret_LIBBPF_PERF_EVENT_DONE: bpf_perf_event_ret = 0;
pub const bpf_perf_event_ret_LIBBPF_PERF_EVENT_ERROR: bpf_perf_event_ret = -1;
pub const bpf_perf_event_ret_LIBBPF_PERF_EVENT_CONT: bpf_perf_event_ret = -2;
pub type bpf_perf_event_ret = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct perf_event_header {
    _unused: [u8; 0],
}
pub type perf_buffer_event_fn = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        cpu: ::std::os::raw::c_int,
        event: *mut perf_event_header,
    ) -> bpf_perf_event_ret,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct perf_buffer_raw_opts {
    pub attr: *mut perf_event_attr,
    pub event_cb: perf_buffer_event_fn,
    pub ctx: *mut ::std::os::raw::c_void,
    pub cpu_cnt: ::std::os::raw::c_int,
    pub cpus: *mut ::std::os::raw::c_int,
    pub map_keys: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_perf_buffer_raw_opts() {
    assert_eq!(
        ::std::mem::size_of::<perf_buffer_raw_opts>(),
        48usize,
        concat!("Size of: ", stringify!(perf_buffer_raw_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<perf_buffer_raw_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(perf_buffer_raw_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<perf_buffer_raw_opts>())).attr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(perf_buffer_raw_opts),
            "::",
            stringify!(attr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<perf_buffer_raw_opts>())).event_cb as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(perf_buffer_raw_opts),
            "::",
            stringify!(event_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<perf_buffer_raw_opts>())).ctx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(perf_buffer_raw_opts),
            "::",
            stringify!(ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<perf_buffer_raw_opts>())).cpu_cnt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(perf_buffer_raw_opts),
            "::",
            stringify!(cpu_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<perf_buffer_raw_opts>())).cpus as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(perf_buffer_raw_opts),
            "::",
            stringify!(cpus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<perf_buffer_raw_opts>())).map_keys as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(perf_buffer_raw_opts),
            "::",
            stringify!(map_keys)
        )
    );
}
impl Default for perf_buffer_raw_opts {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn perf_buffer__new_raw(
        map_fd: ::std::os::raw::c_int,
        page_cnt: size_t,
        opts: *const perf_buffer_raw_opts,
    ) -> *mut perf_buffer;
}
extern "C" {
    pub fn perf_buffer__free(pb: *mut perf_buffer);
}
extern "C" {
    pub fn perf_buffer__epoll_fd(pb: *const perf_buffer) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_buffer__poll(
        pb: *mut perf_buffer,
        timeout_ms: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_buffer__consume(pb: *mut perf_buffer) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_buffer__consume_buffer(
        pb: *mut perf_buffer,
        buf_idx: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_buffer__buffer_cnt(pb: *const perf_buffer) -> size_t;
}
extern "C" {
    pub fn perf_buffer__buffer_fd(pb: *const perf_buffer, buf_idx: size_t)
        -> ::std::os::raw::c_int;
}
pub type bpf_perf_event_print_t = ::std::option::Option<
    unsafe extern "C" fn(
        hdr: *mut perf_event_header,
        private_data: *mut ::std::os::raw::c_void,
    ) -> bpf_perf_event_ret,
>;
extern "C" {
    pub fn bpf_perf_event_read_simple(
        mmap_mem: *mut ::std::os::raw::c_void,
        mmap_size: size_t,
        page_size: size_t,
        copy_mem: *mut *mut ::std::os::raw::c_void,
        copy_size: *mut size_t,
        fn_: bpf_perf_event_print_t,
        private_data: *mut ::std::os::raw::c_void,
    ) -> bpf_perf_event_ret;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_prog_linfo {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_prog_linfo__free(prog_linfo: *mut bpf_prog_linfo);
}
extern "C" {
    pub fn bpf_prog_linfo__new(info: *const bpf_prog_info) -> *mut bpf_prog_linfo;
}
extern "C" {
    pub fn bpf_prog_linfo__lfind_addr_func(
        prog_linfo: *const bpf_prog_linfo,
        addr: __u64,
        func_idx: __u32,
        nr_skip: __u32,
    ) -> *const bpf_line_info;
}
extern "C" {
    pub fn bpf_prog_linfo__lfind(
        prog_linfo: *const bpf_prog_linfo,
        insn_off: __u32,
        nr_skip: __u32,
    ) -> *const bpf_line_info;
}
extern "C" {
    pub fn bpf_probe_prog_type(prog_type: bpf_prog_type, ifindex: __u32) -> bool;
}
extern "C" {
    pub fn bpf_probe_map_type(map_type: bpf_map_type, ifindex: __u32) -> bool;
}
extern "C" {
    pub fn bpf_probe_helper(id: bpf_func_id, prog_type: bpf_prog_type, ifindex: __u32) -> bool;
}
extern "C" {
    pub fn bpf_probe_large_insn_limit(ifindex: __u32) -> bool;
}
pub const bpf_prog_info_array_BPF_PROG_INFO_FIRST_ARRAY: bpf_prog_info_array = 0;
pub const bpf_prog_info_array_BPF_PROG_INFO_JITED_INSNS: bpf_prog_info_array = 0;
pub const bpf_prog_info_array_BPF_PROG_INFO_XLATED_INSNS: bpf_prog_info_array = 1;
pub const bpf_prog_info_array_BPF_PROG_INFO_MAP_IDS: bpf_prog_info_array = 2;
pub const bpf_prog_info_array_BPF_PROG_INFO_JITED_KSYMS: bpf_prog_info_array = 3;
pub const bpf_prog_info_array_BPF_PROG_INFO_JITED_FUNC_LENS: bpf_prog_info_array = 4;
pub const bpf_prog_info_array_BPF_PROG_INFO_FUNC_INFO: bpf_prog_info_array = 5;
pub const bpf_prog_info_array_BPF_PROG_INFO_LINE_INFO: bpf_prog_info_array = 6;
pub const bpf_prog_info_array_BPF_PROG_INFO_JITED_LINE_INFO: bpf_prog_info_array = 7;
pub const bpf_prog_info_array_BPF_PROG_INFO_PROG_TAGS: bpf_prog_info_array = 8;
pub const bpf_prog_info_array_BPF_PROG_INFO_LAST_ARRAY: bpf_prog_info_array = 9;
pub type bpf_prog_info_array = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default)]
pub struct bpf_prog_info_linear {
    pub info_len: __u32,
    pub data_len: __u32,
    pub arrays: __u64,
    pub info: bpf_prog_info,
    pub data: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bpf_prog_info_linear() {
    assert_eq!(
        ::std::mem::size_of::<bpf_prog_info_linear>(),
        224usize,
        concat!("Size of: ", stringify!(bpf_prog_info_linear))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_prog_info_linear>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_prog_info_linear))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info_linear>())).info_len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info_linear),
            "::",
            stringify!(info_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info_linear>())).data_len as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info_linear),
            "::",
            stringify!(data_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info_linear>())).arrays as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info_linear),
            "::",
            stringify!(arrays)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info_linear>())).info as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info_linear),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_info_linear>())).data as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_info_linear),
            "::",
            stringify!(data)
        )
    );
}
extern "C" {
    pub fn bpf_program__get_prog_info_linear(
        fd: ::std::os::raw::c_int,
        arrays: __u64,
    ) -> *mut bpf_prog_info_linear;
}
extern "C" {
    pub fn bpf_program__bpil_addr_to_offs(info_linear: *mut bpf_prog_info_linear);
}
extern "C" {
    pub fn bpf_program__bpil_offs_to_addr(info_linear: *mut bpf_prog_info_linear);
}
extern "C" {
    pub fn libbpf_num_possible_cpus() -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_map_skeleton {
    pub name: *const ::std::os::raw::c_char,
    pub map: *mut *mut bpf_map,
    pub mmaped: *mut *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_bpf_map_skeleton() {
    assert_eq!(
        ::std::mem::size_of::<bpf_map_skeleton>(),
        24usize,
        concat!("Size of: ", stringify!(bpf_map_skeleton))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_map_skeleton>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_map_skeleton))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_skeleton>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_skeleton),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_skeleton>())).map as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_skeleton),
            "::",
            stringify!(map)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_skeleton>())).mmaped as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_skeleton),
            "::",
            stringify!(mmaped)
        )
    );
}
impl Default for bpf_map_skeleton {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_prog_skeleton {
    pub name: *const ::std::os::raw::c_char,
    pub prog: *mut *mut bpf_program,
    pub link: *mut *mut bpf_link,
}
#[test]
fn bindgen_test_layout_bpf_prog_skeleton() {
    assert_eq!(
        ::std::mem::size_of::<bpf_prog_skeleton>(),
        24usize,
        concat!("Size of: ", stringify!(bpf_prog_skeleton))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_prog_skeleton>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_prog_skeleton))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_skeleton>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_skeleton),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_skeleton>())).prog as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_skeleton),
            "::",
            stringify!(prog)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_skeleton>())).link as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_skeleton),
            "::",
            stringify!(link)
        )
    );
}
impl Default for bpf_prog_skeleton {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_object_skeleton {
    pub sz: size_t,
    pub name: *const ::std::os::raw::c_char,
    pub data: *mut ::std::os::raw::c_void,
    pub data_sz: size_t,
    pub obj: *mut *mut bpf_object,
    pub map_cnt: ::std::os::raw::c_int,
    pub map_skel_sz: ::std::os::raw::c_int,
    pub maps: *mut bpf_map_skeleton,
    pub prog_cnt: ::std::os::raw::c_int,
    pub prog_skel_sz: ::std::os::raw::c_int,
    pub progs: *mut bpf_prog_skeleton,
}
#[test]
fn bindgen_test_layout_bpf_object_skeleton() {
    assert_eq!(
        ::std::mem::size_of::<bpf_object_skeleton>(),
        72usize,
        concat!("Size of: ", stringify!(bpf_object_skeleton))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_object_skeleton>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_object_skeleton))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_skeleton>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_skeleton>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_skeleton>())).data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_skeleton>())).data_sz as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(data_sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_skeleton>())).obj as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(obj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_skeleton>())).map_cnt as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(map_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_skeleton>())).map_skel_sz as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(map_skel_sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_skeleton>())).maps as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(maps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_skeleton>())).prog_cnt as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(prog_cnt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_object_skeleton>())).prog_skel_sz as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(prog_skel_sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_object_skeleton>())).progs as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_object_skeleton),
            "::",
            stringify!(progs)
        )
    );
}
impl Default for bpf_object_skeleton {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn bpf_object__open_skeleton(
        s: *mut bpf_object_skeleton,
        opts: *const bpf_object_open_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__load_skeleton(s: *mut bpf_object_skeleton) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__attach_skeleton(s: *mut bpf_object_skeleton) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__detach_skeleton(s: *mut bpf_object_skeleton);
}
extern "C" {
    pub fn bpf_object__destroy_skeleton(s: *mut bpf_object_skeleton);
}
pub const libbpf_tristate_TRI_NO: libbpf_tristate = 0;
pub const libbpf_tristate_TRI_YES: libbpf_tristate = 1;
pub const libbpf_tristate_TRI_MODULE: libbpf_tristate = 2;
pub type libbpf_tristate = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_linker_opts {
    pub sz: size_t,
}
#[test]
fn bindgen_test_layout_bpf_linker_opts() {
    assert_eq!(
        ::std::mem::size_of::<bpf_linker_opts>(),
        8usize,
        concat!("Size of: ", stringify!(bpf_linker_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_linker_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_linker_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_linker_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_linker_opts),
            "::",
            stringify!(sz)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_linker {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_linker__new(
        filename: *const ::std::os::raw::c_char,
        opts: *mut bpf_linker_opts,
    ) -> *mut bpf_linker;
}
extern "C" {
    pub fn bpf_linker__add_file(
        linker: *mut bpf_linker,
        filename: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_linker__finalize(linker: *mut bpf_linker) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_linker__free(linker: *mut bpf_linker);
}
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[test]
fn bindgen_test_layout_max_align_t() {
    assert_eq!(
        ::std::mem::size_of::<max_align_t>(),
        32usize,
        concat!("Size of: ", stringify!(max_align_t))
    );
    assert_eq!(
        ::std::mem::align_of::<max_align_t>(),
        16usize,
        concat!("Alignment of ", stringify!(max_align_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce1 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce2)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_create_map_attr {
    pub name: *const ::std::os::raw::c_char,
    pub map_type: bpf_map_type,
    pub map_flags: __u32,
    pub key_size: __u32,
    pub value_size: __u32,
    pub max_entries: __u32,
    pub numa_node: __u32,
    pub btf_fd: __u32,
    pub btf_key_type_id: __u32,
    pub btf_value_type_id: __u32,
    pub map_ifindex: __u32,
    pub __bindgen_anon_1: bpf_create_map_attr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_create_map_attr__bindgen_ty_1 {
    pub inner_map_fd: __u32,
    pub btf_vmlinux_value_type_id: __u32,
}
#[test]
fn bindgen_test_layout_bpf_create_map_attr__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_create_map_attr__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(bpf_create_map_attr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_create_map_attr__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_create_map_attr__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_create_map_attr__bindgen_ty_1>())).inner_map_fd as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr__bindgen_ty_1),
            "::",
            stringify!(inner_map_fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_create_map_attr__bindgen_ty_1>())).btf_vmlinux_value_type_id
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr__bindgen_ty_1),
            "::",
            stringify!(btf_vmlinux_value_type_id)
        )
    );
}
impl Default for bpf_create_map_attr__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_bpf_create_map_attr() {
    assert_eq!(
        ::std::mem::size_of::<bpf_create_map_attr>(),
        56usize,
        concat!("Size of: ", stringify!(bpf_create_map_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_create_map_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_create_map_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_create_map_attr>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_create_map_attr>())).map_type as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(map_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_create_map_attr>())).map_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(map_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_create_map_attr>())).key_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(key_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_create_map_attr>())).value_size as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(value_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_create_map_attr>())).max_entries as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(max_entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_create_map_attr>())).numa_node as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(numa_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_create_map_attr>())).btf_fd as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(btf_fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_create_map_attr>())).btf_key_type_id as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(btf_key_type_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_create_map_attr>())).btf_value_type_id as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(btf_value_type_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_create_map_attr>())).map_ifindex as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_create_map_attr),
            "::",
            stringify!(map_ifindex)
        )
    );
}
impl Default for bpf_create_map_attr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn bpf_create_map_xattr(create_attr: *const bpf_create_map_attr) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_create_map_node(
        map_type: bpf_map_type,
        name: *const ::std::os::raw::c_char,
        key_size: ::std::os::raw::c_int,
        value_size: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: __u32,
        node: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_create_map_name(
        map_type: bpf_map_type,
        name: *const ::std::os::raw::c_char,
        key_size: ::std::os::raw::c_int,
        value_size: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_create_map(
        map_type: bpf_map_type,
        key_size: ::std::os::raw::c_int,
        value_size: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_create_map_in_map_node(
        map_type: bpf_map_type,
        name: *const ::std::os::raw::c_char,
        key_size: ::std::os::raw::c_int,
        inner_map_fd: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: __u32,
        node: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_create_map_in_map(
        map_type: bpf_map_type,
        name: *const ::std::os::raw::c_char,
        key_size: ::std::os::raw::c_int,
        inner_map_fd: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: __u32,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_load_program_attr {
    pub prog_type: bpf_prog_type,
    pub expected_attach_type: bpf_attach_type,
    pub name: *const ::std::os::raw::c_char,
    pub insns: *const bpf_insn,
    pub insns_cnt: size_t,
    pub license: *const ::std::os::raw::c_char,
    pub __bindgen_anon_1: bpf_load_program_attr__bindgen_ty_1,
    pub __bindgen_anon_2: bpf_load_program_attr__bindgen_ty_2,
    pub prog_btf_fd: __u32,
    pub func_info_rec_size: __u32,
    pub func_info: *const ::std::os::raw::c_void,
    pub func_info_cnt: __u32,
    pub line_info_rec_size: __u32,
    pub line_info: *const ::std::os::raw::c_void,
    pub line_info_cnt: __u32,
    pub log_level: __u32,
    pub prog_flags: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_load_program_attr__bindgen_ty_1 {
    pub kern_version: __u32,
    pub attach_prog_fd: __u32,
}
#[test]
fn bindgen_test_layout_bpf_load_program_attr__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bpf_load_program_attr__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(bpf_load_program_attr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_load_program_attr__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_load_program_attr__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr__bindgen_ty_1>())).kern_version as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr__bindgen_ty_1),
            "::",
            stringify!(kern_version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr__bindgen_ty_1>())).attach_prog_fd
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr__bindgen_ty_1),
            "::",
            stringify!(attach_prog_fd)
        )
    );
}
impl Default for bpf_load_program_attr__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_load_program_attr__bindgen_ty_2 {
    pub prog_ifindex: __u32,
    pub attach_btf_id: __u32,
}
#[test]
fn bindgen_test_layout_bpf_load_program_attr__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<bpf_load_program_attr__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(bpf_load_program_attr__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_load_program_attr__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(bpf_load_program_attr__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr__bindgen_ty_2>())).prog_ifindex as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr__bindgen_ty_2),
            "::",
            stringify!(prog_ifindex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr__bindgen_ty_2>())).attach_btf_id
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr__bindgen_ty_2),
            "::",
            stringify!(attach_btf_id)
        )
    );
}
impl Default for bpf_load_program_attr__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_bpf_load_program_attr() {
    assert_eq!(
        ::std::mem::size_of::<bpf_load_program_attr>(),
        96usize,
        concat!("Size of: ", stringify!(bpf_load_program_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_load_program_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_load_program_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_load_program_attr>())).prog_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(prog_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr>())).expected_attach_type as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(expected_attach_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_load_program_attr>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_load_program_attr>())).insns as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(insns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_load_program_attr>())).insns_cnt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(insns_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_load_program_attr>())).license as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(license)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr>())).prog_btf_fd as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(prog_btf_fd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr>())).func_info_rec_size as *const _
                as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(func_info_rec_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_load_program_attr>())).func_info as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(func_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr>())).func_info_cnt as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(func_info_cnt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr>())).line_info_rec_size as *const _
                as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(line_info_rec_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_load_program_attr>())).line_info as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(line_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr>())).line_info_cnt as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(line_info_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_load_program_attr>())).log_level as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(log_level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_load_program_attr>())).prog_flags as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_load_program_attr),
            "::",
            stringify!(prog_flags)
        )
    );
}
impl Default for bpf_load_program_attr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn bpf_load_program_xattr(
        load_attr: *const bpf_load_program_attr,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_sz: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_load_program(
        type_: bpf_prog_type,
        insns: *const bpf_insn,
        insns_cnt: size_t,
        license: *const ::std::os::raw::c_char,
        kern_version: __u32,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_sz: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_verify_program(
        type_: bpf_prog_type,
        insns: *const bpf_insn,
        insns_cnt: size_t,
        prog_flags: __u32,
        license: *const ::std::os::raw::c_char,
        kern_version: __u32,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_sz: size_t,
        log_level: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_update_elem(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        value: *const ::std::os::raw::c_void,
        flags: __u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_elem(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_elem_flags(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
        flags: __u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_and_delete_elem(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_delete_elem(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_get_next_key(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        next_key: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_freeze(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_map_batch_opts {
    pub sz: size_t,
    pub elem_flags: __u64,
    pub flags: __u64,
}
#[test]
fn bindgen_test_layout_bpf_map_batch_opts() {
    assert_eq!(
        ::std::mem::size_of::<bpf_map_batch_opts>(),
        24usize,
        concat!("Size of: ", stringify!(bpf_map_batch_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_map_batch_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_map_batch_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_batch_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_batch_opts),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_batch_opts>())).elem_flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_batch_opts),
            "::",
            stringify!(elem_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_map_batch_opts>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_map_batch_opts),
            "::",
            stringify!(flags)
        )
    );
}
extern "C" {
    pub fn bpf_map_delete_batch(
        fd: ::std::os::raw::c_int,
        keys: *mut ::std::os::raw::c_void,
        count: *mut __u32,
        opts: *const bpf_map_batch_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_batch(
        fd: ::std::os::raw::c_int,
        in_batch: *mut ::std::os::raw::c_void,
        out_batch: *mut ::std::os::raw::c_void,
        keys: *mut ::std::os::raw::c_void,
        values: *mut ::std::os::raw::c_void,
        count: *mut __u32,
        opts: *const bpf_map_batch_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_and_delete_batch(
        fd: ::std::os::raw::c_int,
        in_batch: *mut ::std::os::raw::c_void,
        out_batch: *mut ::std::os::raw::c_void,
        keys: *mut ::std::os::raw::c_void,
        values: *mut ::std::os::raw::c_void,
        count: *mut __u32,
        opts: *const bpf_map_batch_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_update_batch(
        fd: ::std::os::raw::c_int,
        keys: *mut ::std::os::raw::c_void,
        values: *mut ::std::os::raw::c_void,
        count: *mut __u32,
        opts: *const bpf_map_batch_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_obj_pin(
        fd: ::std::os::raw::c_int,
        pathname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_obj_get(pathname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_prog_attach_opts {
    pub sz: size_t,
    pub flags: ::std::os::raw::c_uint,
    pub replace_prog_fd: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bpf_prog_attach_opts() {
    assert_eq!(
        ::std::mem::size_of::<bpf_prog_attach_opts>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_prog_attach_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_prog_attach_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_prog_attach_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_attach_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_attach_opts),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_attach_opts>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_attach_opts),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_attach_opts>())).replace_prog_fd as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_attach_opts),
            "::",
            stringify!(replace_prog_fd)
        )
    );
}
extern "C" {
    pub fn bpf_prog_attach(
        prog_fd: ::std::os::raw::c_int,
        attachable_fd: ::std::os::raw::c_int,
        type_: bpf_attach_type,
        flags: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_attach_xattr(
        prog_fd: ::std::os::raw::c_int,
        attachable_fd: ::std::os::raw::c_int,
        type_: bpf_attach_type,
        opts: *const bpf_prog_attach_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_detach(
        attachable_fd: ::std::os::raw::c_int,
        type_: bpf_attach_type,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_detach2(
        prog_fd: ::std::os::raw::c_int,
        attachable_fd: ::std::os::raw::c_int,
        type_: bpf_attach_type,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_iter_link_info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_link_create_opts {
    pub sz: size_t,
    pub flags: __u32,
    pub iter_info: *mut bpf_iter_link_info,
    pub iter_info_len: __u32,
    pub target_btf_id: __u32,
}
#[test]
fn bindgen_test_layout_bpf_link_create_opts() {
    assert_eq!(
        ::std::mem::size_of::<bpf_link_create_opts>(),
        32usize,
        concat!("Size of: ", stringify!(bpf_link_create_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_link_create_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_link_create_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_link_create_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_link_create_opts),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_link_create_opts>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_link_create_opts),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_link_create_opts>())).iter_info as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_link_create_opts),
            "::",
            stringify!(iter_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_link_create_opts>())).iter_info_len as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_link_create_opts),
            "::",
            stringify!(iter_info_len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_link_create_opts>())).target_btf_id as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_link_create_opts),
            "::",
            stringify!(target_btf_id)
        )
    );
}
impl Default for bpf_link_create_opts {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn bpf_link_create(
        prog_fd: ::std::os::raw::c_int,
        target_fd: ::std::os::raw::c_int,
        attach_type: bpf_attach_type,
        opts: *const bpf_link_create_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link_detach(link_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_link_update_opts {
    pub sz: size_t,
    pub flags: __u32,
    pub old_prog_fd: __u32,
}
#[test]
fn bindgen_test_layout_bpf_link_update_opts() {
    assert_eq!(
        ::std::mem::size_of::<bpf_link_update_opts>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_link_update_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_link_update_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_link_update_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_link_update_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_link_update_opts),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_link_update_opts>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_link_update_opts),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_link_update_opts>())).old_prog_fd as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_link_update_opts),
            "::",
            stringify!(old_prog_fd)
        )
    );
}
extern "C" {
    pub fn bpf_link_update(
        link_fd: ::std::os::raw::c_int,
        new_prog_fd: ::std::os::raw::c_int,
        opts: *const bpf_link_update_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_iter_create(link_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_prog_test_run_attr {
    pub prog_fd: ::std::os::raw::c_int,
    pub repeat: ::std::os::raw::c_int,
    pub data_in: *const ::std::os::raw::c_void,
    pub data_size_in: __u32,
    pub data_out: *mut ::std::os::raw::c_void,
    pub data_size_out: __u32,
    pub retval: __u32,
    pub duration: __u32,
    pub ctx_in: *const ::std::os::raw::c_void,
    pub ctx_size_in: __u32,
    pub ctx_out: *mut ::std::os::raw::c_void,
    pub ctx_size_out: __u32,
}
#[test]
fn bindgen_test_layout_bpf_prog_test_run_attr() {
    assert_eq!(
        ::std::mem::size_of::<bpf_prog_test_run_attr>(),
        80usize,
        concat!("Size of: ", stringify!(bpf_prog_test_run_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_prog_test_run_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_prog_test_run_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).prog_fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(prog_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).repeat as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(repeat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).data_in as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(data_in)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).data_size_in as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(data_size_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).data_out as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(data_out)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).data_size_out as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(data_size_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).retval as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(retval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).duration as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(duration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).ctx_in as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(ctx_in)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).ctx_size_in as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(ctx_size_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).ctx_out as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(ctx_out)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<bpf_prog_test_run_attr>())).ctx_size_out as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_test_run_attr),
            "::",
            stringify!(ctx_size_out)
        )
    );
}
impl Default for bpf_prog_test_run_attr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn bpf_prog_test_run_xattr(test_attr: *mut bpf_prog_test_run_attr)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_test_run(
        prog_fd: ::std::os::raw::c_int,
        repeat: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        size: __u32,
        data_out: *mut ::std::os::raw::c_void,
        size_out: *mut __u32,
        retval: *mut __u32,
        duration: *mut __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_get_next_id(start_id: __u32, next_id: *mut __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_get_next_id(start_id: __u32, next_id: *mut __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_btf_get_next_id(start_id: __u32, next_id: *mut __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link_get_next_id(start_id: __u32, next_id: *mut __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_get_fd_by_id(id: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_get_fd_by_id(id: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_btf_get_fd_by_id(id: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link_get_fd_by_id(id: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_obj_get_info_by_fd(
        bpf_fd: ::std::os::raw::c_int,
        info: *mut ::std::os::raw::c_void,
        info_len: *mut __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_query(
        target_fd: ::std::os::raw::c_int,
        type_: bpf_attach_type,
        query_flags: __u32,
        attach_flags: *mut __u32,
        prog_ids: *mut __u32,
        prog_cnt: *mut __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_raw_tracepoint_open(
        name: *const ::std::os::raw::c_char,
        prog_fd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_load_btf(
        btf: *const ::std::os::raw::c_void,
        btf_size: __u32,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_size: __u32,
        do_log: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_task_fd_query(
        pid: ::std::os::raw::c_int,
        fd: ::std::os::raw::c_int,
        flags: __u32,
        buf: *mut ::std::os::raw::c_char,
        buf_len: *mut __u32,
        prog_id: *mut __u32,
        fd_type: *mut __u32,
        probe_offset: *mut __u64,
        probe_addr: *mut __u64,
    ) -> ::std::os::raw::c_int;
}
pub type bpf_stats_type = i32;
extern "C" {
    pub fn bpf_enable_stats(type_: bpf_stats_type) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct bpf_prog_bind_opts {
    pub sz: size_t,
    pub flags: __u32,
}
#[test]
fn bindgen_test_layout_bpf_prog_bind_opts() {
    assert_eq!(
        ::std::mem::size_of::<bpf_prog_bind_opts>(),
        16usize,
        concat!("Size of: ", stringify!(bpf_prog_bind_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_prog_bind_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_prog_bind_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_bind_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_bind_opts),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_prog_bind_opts>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_prog_bind_opts),
            "::",
            stringify!(flags)
        )
    );
}
extern "C" {
    pub fn bpf_prog_bind_map(
        prog_fd: ::std::os::raw::c_int,
        map_fd: ::std::os::raw::c_int,
        opts: *const bpf_prog_bind_opts,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct bpf_test_run_opts {
    pub sz: size_t,
    pub data_in: *const ::std::os::raw::c_void,
    pub data_out: *mut ::std::os::raw::c_void,
    pub data_size_in: __u32,
    pub data_size_out: __u32,
    pub ctx_in: *const ::std::os::raw::c_void,
    pub ctx_out: *mut ::std::os::raw::c_void,
    pub ctx_size_in: __u32,
    pub ctx_size_out: __u32,
    pub retval: __u32,
    pub repeat: ::std::os::raw::c_int,
    pub duration: __u32,
    pub flags: __u32,
    pub cpu: __u32,
}
#[test]
fn bindgen_test_layout_bpf_test_run_opts() {
    assert_eq!(
        ::std::mem::size_of::<bpf_test_run_opts>(),
        80usize,
        concat!("Size of: ", stringify!(bpf_test_run_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<bpf_test_run_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bpf_test_run_opts))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).sz as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).data_in as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(data_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).data_out as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(data_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).data_size_in as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(data_size_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).data_size_out as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(data_size_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).ctx_in as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(ctx_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).ctx_out as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(ctx_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).ctx_size_in as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(ctx_size_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).ctx_size_out as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(ctx_size_out)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).retval as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(retval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).repeat as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(repeat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).duration as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(duration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).flags as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bpf_test_run_opts>())).cpu as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bpf_test_run_opts),
            "::",
            stringify!(cpu)
        )
    );
}
impl Default for bpf_test_run_opts {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn bpf_prog_test_run_opts(
        prog_fd: ::std::os::raw::c_int,
        opts: *mut bpf_test_run_opts,
    ) -> ::std::os::raw::c_int;
}
pub const xdp_attach_mode_XDP_MODE_UNSPEC: xdp_attach_mode = 0;
pub const xdp_attach_mode_XDP_MODE_NATIVE: xdp_attach_mode = 1;
pub const xdp_attach_mode_XDP_MODE_SKB: xdp_attach_mode = 2;
pub const xdp_attach_mode_XDP_MODE_HW: xdp_attach_mode = 3;
pub type xdp_attach_mode = ::std::os::raw::c_uint;
pub const libxdp_print_level_LIBXDP_WARN: libxdp_print_level = 0;
pub const libxdp_print_level_LIBXDP_INFO: libxdp_print_level = 1;
pub const libxdp_print_level_LIBXDP_DEBUG: libxdp_print_level = 2;
pub type libxdp_print_level = ::std::os::raw::c_uint;
pub type libxdp_print_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        level: libxdp_print_level,
        arg1: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn libxdp_set_print(fn_: libxdp_print_fn_t) -> libxdp_print_fn_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xdp_program {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xdp_multiprog {
    _unused: [u8; 0],
}
extern "C" {
    pub fn libxdp_get_error(ptr: *const ::std::os::raw::c_void) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn libxdp_strerror(
        err: ::std::os::raw::c_int,
        buf: *mut ::std::os::raw::c_char,
        size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn libxdp_clean_references(ifindex: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_program__from_bpf_obj(
        obj: *mut bpf_object,
        section_name: *const ::std::os::raw::c_char,
    ) -> *mut xdp_program;
}
extern "C" {
    pub fn xdp_program__find_file(
        filename: *const ::std::os::raw::c_char,
        section_name: *const ::std::os::raw::c_char,
        opts: *mut bpf_object_open_opts,
    ) -> *mut xdp_program;
}
extern "C" {
    pub fn xdp_program__open_file(
        filename: *const ::std::os::raw::c_char,
        section_name: *const ::std::os::raw::c_char,
        opts: *mut bpf_object_open_opts,
    ) -> *mut xdp_program;
}
extern "C" {
    pub fn xdp_program__from_fd(fd: ::std::os::raw::c_int) -> *mut xdp_program;
}
extern "C" {
    pub fn xdp_program__from_id(prog_id: __u32) -> *mut xdp_program;
}
extern "C" {
    pub fn xdp_program__from_pin(pin_path: *const ::std::os::raw::c_char) -> *mut xdp_program;
}
extern "C" {
    pub fn xdp_program__close(xdp_prog: *mut xdp_program);
}
extern "C" {
    pub fn xdp_program__is_attached(
        xdp_prog: *const xdp_program,
        ifindex: ::std::os::raw::c_int,
    ) -> xdp_attach_mode;
}
extern "C" {
    pub fn xdp_program__name(xdp_prog: *const xdp_program) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn xdp_program__tag(xdp_prog: *const xdp_program) -> *const ::std::os::raw::c_uchar;
}
extern "C" {
    pub fn xdp_program__bpf_obj(xdp_prog: *mut xdp_program) -> *mut bpf_object;
}
extern "C" {
    pub fn xdp_program__btf(xdp_prog: *mut xdp_program) -> *const btf;
}
extern "C" {
    pub fn xdp_program__id(xdp_prog: *const xdp_program) -> u32;
}
extern "C" {
    pub fn xdp_program__fd(xdp_prog: *const xdp_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_program__run_prio(xdp_prog: *const xdp_program) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn xdp_program__set_run_prio(
        xdp_prog: *mut xdp_program,
        run_prio: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_program__chain_call_enabled(
        xdp_prog: *const xdp_program,
        action: xdp_action,
    ) -> bool;
}
extern "C" {
    pub fn xdp_program__set_chain_call_enabled(
        prog: *mut xdp_program,
        action: ::std::os::raw::c_uint,
        enabled: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_program__print_chain_call_actions(
        prog: *const xdp_program,
        buf: *mut ::std::os::raw::c_char,
        buf_len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_program__pin(
        xdp_prog: *mut xdp_program,
        pin_path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_program__attach(
        xdp_prog: *mut xdp_program,
        ifindex: ::std::os::raw::c_int,
        mode: xdp_attach_mode,
        flags: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_program__attach_multi(
        progs: *mut *mut xdp_program,
        num_progs: size_t,
        ifindex: ::std::os::raw::c_int,
        mode: xdp_attach_mode,
        flags: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_program__detach(
        xdp_prog: *mut xdp_program,
        ifindex: ::std::os::raw::c_int,
        mode: xdp_attach_mode,
        flags: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_program__detach_multi(
        progs: *mut *mut xdp_program,
        num_progs: size_t,
        ifindex: ::std::os::raw::c_int,
        mode: xdp_attach_mode,
        flags: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_multiprog__get_from_ifindex(ifindex: ::std::os::raw::c_int) -> *mut xdp_multiprog;
}
extern "C" {
    pub fn xdp_multiprog__next_prog(
        prog: *const xdp_program,
        mp: *const xdp_multiprog,
    ) -> *mut xdp_program;
}
extern "C" {
    pub fn xdp_multiprog__close(mp: *mut xdp_multiprog);
}
extern "C" {
    pub fn xdp_multiprog__detach(mp: *mut xdp_multiprog) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xdp_multiprog__attach_mode(mp: *const xdp_multiprog) -> xdp_attach_mode;
}
extern "C" {
    pub fn xdp_multiprog__main_prog(mp: *const xdp_multiprog) -> *mut xdp_program;
}
extern "C" {
    pub fn xdp_multiprog__hw_prog(mp: *const xdp_multiprog) -> *mut xdp_program;
}
extern "C" {
    pub fn xdp_multiprog__is_legacy(mp: *const xdp_multiprog) -> bool;
}
extern "C" {
    pub fn xdp_multiprog__program_count(mp: *const xdp_multiprog) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct xdp_dispatcher_config {
    pub num_progs_enabled: __u8,
    pub chain_call_actions: [__u32; 10usize],
    pub run_prios: [__u32; 10usize],
}
#[test]
fn bindgen_test_layout_xdp_dispatcher_config() {
    assert_eq!(
        ::std::mem::size_of::<xdp_dispatcher_config>(),
        84usize,
        concat!("Size of: ", stringify!(xdp_dispatcher_config))
    );
    assert_eq!(
        ::std::mem::align_of::<xdp_dispatcher_config>(),
        4usize,
        concat!("Alignment of ", stringify!(xdp_dispatcher_config))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xdp_dispatcher_config>())).num_progs_enabled as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_dispatcher_config),
            "::",
            stringify!(num_progs_enabled)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xdp_dispatcher_config>())).chain_call_actions as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_dispatcher_config),
            "::",
            stringify!(chain_call_actions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xdp_dispatcher_config>())).run_prios as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(xdp_dispatcher_config),
            "::",
            stringify!(run_prios)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct datarec {
    pub rx_packets: __u64,
    pub rx_bytes: __u64,
}
#[test]
fn bindgen_test_layout_datarec() {
    assert_eq!(
        ::std::mem::size_of::<datarec>(),
        16usize,
        concat!("Size of: ", stringify!(datarec))
    );
    assert_eq!(
        ::std::mem::align_of::<datarec>(),
        8usize,
        concat!("Alignment of ", stringify!(datarec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<datarec>())).rx_packets as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(datarec),
            "::",
            stringify!(rx_packets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<datarec>())).rx_bytes as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(datarec),
            "::",
            stringify!(rx_bytes)
        )
    );
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).gp_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).fp_offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).overflow_arg_area as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).reg_save_area as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
impl Default for __va_list_tag {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __locale_data {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct perf_event_attr {
    pub _address: u8,
}
