/*
    libxbku-common
    Copyright (C) 2021 AluminiumTech

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
 */

pub enum XbkuError {
    HardwareNotSupported,
    OperatingSystemNotSupported,
    InvalidSourceList,
    InvalidSource,
    InvalidNetworkConnection,
    InvalidNetworkConfiguration,
    InvalidArguments,
    NoError
}

pub enum XbkuCommand {
    Help,
    CheckForXbkuUpdates,
    CheckForKernelUpdates,
    CheckForKernelUpdatesAndNotifyCurrentUser,
    ListOfAvailableMainlineKernels,
    ListOfInstalledKernels,
    InstallLatestMainlineKernel,
    InstallLatestKernelUpdateForPointSeries,
    InstallSpecificMainlineKernel,
    RemoveSpecifiedKernel,
    PurgeOlderDownloads,
    DownloadPackageForSpecifiedKernel,
    CleanApplicationCache,
    Undefined,
    InvalidCommand
}


impl XbkuCommand {
    pub fn convert_string_to_enum(input: &str) -> XbkuCommand {
        return match input{
            "-h" | "--help" | "--h" => XbkuCommand::Help,
            "--check-app-updates" | "--check-updates" | "--check-xbku-updates" | "--update-xbku" => XbkuCommand::CheckForXbkuUpdates,
            "--check-kernel-update" | "--check-kernel" | "--kernel-check" | "-kc" | "--kc" => XbkuCommand::CheckForKernelUpdates,
            "--check-kernel-updates-notify-current-user" | "--kernel-check-notify" | "--check-kernel-notify" => XbkuCommand::CheckForKernelUpdatesAndNotifyCurrentUser,
            "--clean-application-cache" | "--clean-app-cache" | "--clean-cache" | "--clear-app-cache" | "--clear-cache" => XbkuCommand::CleanApplicationCache,
            "--download-package" | "--download" | "--download-specific" => XbkuCommand::DownloadPackageForSpecifiedKernel,
            "--install-latest-mainline" | "--install-latest-kernel" | "--install-latest" => XbkuCommand::InstallLatestMainlineKernel,
            "--install-latest-point-update" | "--install-point-update" => XbkuCommand::InstallLatestKernelUpdateForPointSeries,
            "--install-specific-kernel" | "--install-specific" => XbkuCommand::InstallSpecificMainlineKernel,
            "--list-available-kernels" | "--list-available" | "--list-available-mainline" | "--list-mainline" => XbkuCommand::ListOfAvailableMainlineKernels,
            "--list-installed-kernels" => XbkuCommand::ListOfInstalledKernels,
            "--purge-old-kernels" | "--purge-legacy-kernels" | "--purge-older-kernels" | "--purge-downloads" => XbkuCommand::PurgeOlderDownloads,
            "--remove" | "--remove-kernel" | "--purge-kernel" => XbkuCommand::RemoveSpecifiedKernel,
            _=> XbkuCommand::Undefined
        }
    }
}

pub enum XbkuKernelVariants {
    LowLatency,
    Generic,
    GenericLPAE,
    Snapdragon,
    Custom,
    Undefined,
    InvalidKernelVariant
}


impl XbkuKernelVariants{
    pub fn convert_string_to_enum(input: &str) -> XbkuKernelVariants {

        /*
        if input.to_string().to_lowercase().contains("low") ||
            input.to_string().to_lowercase().contains("latency") ||
            input.to_string().to_lowercase().contains("low") && input.to_string().to_lowercase().contains("latency")
        {
            let input: &str = "lowlatency";
        }
        else if input.to_string().to_lowercase().contains("generic") && input.to_string().to_lowercase().contains("lpae"){
            let input: &str = "lpae";
        }
        else if input.to_string().to_lowercase().contains("generic") && !input.to_string().to_lowercase().contains("lpae"){
            let input: &str = "generic";
        }
        */

        return match input {
            "generic" => XbkuKernelVariants::Generic,
            "lowlatency" => XbkuKernelVariants::LowLatency,
            "lpae" => XbkuKernelVariants::GenericLPAE,
            "qualcomm" | "snapdragon" => XbkuKernelVariants::Snapdragon,
            _=> XbkuKernelVariants::Undefined
        }
    }
}