/*
    libxbku-common
    Copyright (C) 2021 AluminiumTech

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
 */

pub enum SupportStatus{
    InitialSupport,
    ReintroducedSupport,
    FullSupport,
    PartialSupport,
    LimitedSupport,
    LimitedSupportFinalVersion,
    SupportEnded,
    NotCurrentlySupported,
    NotDetected,
    NotSupported
}

pub enum ReleaseStatus{
    Stable,
    ReleaseCandidate,
    Beta,
    Alpha,
    //Similar in meaning to pre-alpha.
    Testing,
    Development
}

pub enum CompatibilityStatus{
    NativeCompatibility,
    NonNativeCompatibility,
    UnknownCompatibility,
    NotCompatible
}