/*
    libxbku-common
    Copyright (C) 2021 AluminiumTech

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
 */

use crate::xbku_enums::{XbkuCommand, ProcessorArchitecture, XbkuKernelVariants};

impl XbkuKernelVariants{
    pub fn convert_string_to_enum(input: &str) -> XbkuKernelVariants {

        /*
        if input.to_string().to_lowercase().contains("low") ||
            input.to_string().to_lowercase().contains("latency") ||
            input.to_string().to_lowercase().contains("low") && input.to_string().to_lowercase().contains("latency")
        {
            let input: &str = "lowlatency";
        }
        else if input.to_string().to_lowercase().contains("generic") && input.to_string().to_lowercase().contains("lpae"){
            let input: &str = "lpae";
        }
        else if input.to_string().to_lowercase().contains("generic") && !input.to_string().to_lowercase().contains("lpae"){
            let input: &str = "generic";
        }
        */

        return match input {
            "generic" => XbkuKernelVariants::Generic,
            "lowlatency" => XbkuKernelVariants::LowLatency,
            "lpae" => XbkuKernelVariants::GenericLPAE,
            "qualcomm" | "snapdragon" => XbkuKernelVariants::Snapdragon,
            _=> XbkuKernelVariants::Undefined
        }
    }
}

impl ProcessorArchitecture {
    pub fn convert_string_to_enum(input: &str) -> ProcessorArchitecture {

  /*      if input.to_string().to_lowercase().contains("ppc") && input.to_string().to_lowercase().contains("64")
        {
             let input: &str = "ppc64";
        }
        else if input.to_string().to_lowercase().contains("ppc") && !input.to_string().to_lowercase().contains("64"){
            let input: &str = "ppc32";
        }
*/
        return match input {
            "x86" | "i386" => ProcessorArchitecture::X86,
            "x64" | "amd64" | "x86-x64" => ProcessorArchitecture::X64,
            "ia32" => ProcessorArchitecture::IA32,
            "ia64"  => ProcessorArchitecture::IA64,
            "armel" | "arm32el" => ProcessorArchitecture::ARM32EL,
            "armv7" | "arm32" | "aarch32" | "armv7-a" | "armhf" => ProcessorArchitecture::ARM32HF,
            "lpae" => ProcessorArchitecture::ARM64,
            "ppc32" | "ppc" => ProcessorArchitecture::PowerPC32,
            "ppc64" => ProcessorArchitecture::PowerPC64EL,
            "s390x" => ProcessorArchitecture::S390X,
            _=> ProcessorArchitecture::Undefined
        }
    }
}

impl XbkuCommand {
    pub fn convert_string_to_enum(input: &str) -> XbkuCommand {
        return match input{
            "-h" | "--help" | "--h" => XbkuCommand::Help,
            "--check-app-updates" | "--check-updates" | "--check-xbku-updates" | "--update-xbku" => XbkuCommand::CheckForXbkuUpdates,
            "--check-kernel-update" | "--check-kernel" | "--kernel-check" | "-kc" | "--kc" => XbkuCommand::CheckForKernelUpdates,
            "--check-kernel-updates-notify-current-user" | "--kernel-check-notify" | "--check-kernel-notify" => XbkuCommand::CheckForKernelUpdatesAndNotifyCurrentUser,
            "--clean-application-cache" | "--clean-app-cache" | "--clean-cache" | "--clear-app-cache" | "--clear-cache" => XbkuCommand::CleanApplicationCache,
            "--download-package" | "--download" | "--download-specific" => XbkuCommand::DownloadPackageForSpecifiedKernel,
            "--install-latest-mainline" | "--install-latest-kernel" | "--install-latest" => XbkuCommand::InstallLatestMainlineKernel,
            "--install-latest-point-update" | "--install-point-update" => XbkuCommand::InstallLatestKernelUpdateForPointSeries,
            "--install-specific-kernel" | "--install-specific" => XbkuCommand::InstallSpecificMainlineKernel,
            "--list-available-kernels" | "--list-available" | "--list-available-mainline" | "--list-mainline" => XbkuCommand::ListOfAvailableMainlineKernels,
            "--list-installed-kernels" => XbkuCommand::ListOfInstalledKernels,
            "--purge-old-kernels" | "--purge-legacy-kernels" | "--purge-older-kernels" | "--purge-downloads" => XbkuCommand::PurgeOlderDownloads,
            "--remove" | "--remove-kernel" | "--purge-kernel" => XbkuCommand::RemoveSpecifiedKernel,
            _=> XbkuCommand::Undefined
        }
    }
}