/*
    libxbku-common
    Copyright (C) 2021 AluminiumTech

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
 */

 pub enum XbkuCommand {
        Help,
        CheckForXbkuUpdates,
        CheckForKernelUpdates,
        CheckForKernelUpdatesAndNotifyCurrentUser,
        ListOfAvailableMainlineKernels,
        ListOfInstalledKernels,
        InstallLatestMainlineKernel,
        InstallLatestKernelUpdateForPointSeries,
        InstallSpecificMainlineKernel,
        RemoveSpecifiedKernel,
        PurgeOlderDownloads,
        DownloadPackageForSpecifiedKernel,
        CleanApplicationCache,
        Undefined,
        InvalidCommand
    }
    
    pub enum XbkuError {
        HardwareNotSupported,
        OperatingSystemNotSupported,
        InvalidSourceList,
        InvalidSource,
        InvalidNetworkConnection,
        InvalidNetworkConfiguration,
        InvalidArguments,
        NoError
    }

    pub enum CompatibilityStatus{
        NativeCompatibility,
        NonNativeCompatibility,
        UnknownCompatibility,
        NotCompatible
    }

    pub enum SupportStatus{
        InitialSupport,
        ReintroducedSupport,
        FullSupport,
        PartialSupport,
        LimitedSupport,
        LimitedSupportFinalVersion,
        SupportEnded,
        NotCurrentlySupported,
        NotDetected,
        NotSupported
    }

    pub enum ProcessorArchitecture {
        X86,
        X64,
        ARM32,
        ARM32EL,
        ARM32HF,
        ARM64,
        S390X,
        IA32,
        IA64,
        PowerPC32,
        PowerPC64,
        PowerPC64EL,
        MIPS32,
        MIPS32EL,
        MIPS64,
        MIPS64EL,
        Undefined,
        InvalidArchitecture
    }

    pub enum XbkuKernelVariants {
        LowLatency,
        Generic,
        GenericLPAE,
        Snapdragon,
        Custom,
        Undefined,
        InvalidKernelVariant
    }

    pub enum XbkuKernelType{
        Mainline,
        NonMainline,
        NonMainlineModified,
        Custom
    }

    pub enum KernelSupportType{
        LongTermSupport,
        ShortTermSupport,
        Custom
    }

    pub enum ReleaseStatus{
        Stable,
        ReleaseCandidate,
        Beta,
        Alpha,
        Testing,
        Development
    }