/*
    libxbku-common
    Copyright (C) 2021 AluminiumTech

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
 */

 pub enum XbkuCommand {
        Help,
        CheckForXbkuUpdates,
        CheckForKernelUpdates,
        CheckForKernelUpdatesAndNotifyCurrentUser,
        ListOfAvailableMainlineKernels,
        ListOfInstalledKernels,
        InstallLatestMainlineKernel,
        InstallLatestKernelUpdateForPointSeries,
        InstallSpecificMainlineKernel,
        RemoveSpecifiedKernel,
        PurgeOlderDownloads,
        DownloadPackageForSpecifiedKernel,
        CleanApplicationCache,
        Undefined,
        InvalidCommand
    }
    
    pub enum XbkuError {
        HardwareNotSupported,
        OperatingSystemNotSupported,
        InvalidSourceList,
        InvalidSource,
        InvalidNetworkConnection,
        InvalidNetworkConfiguration,
        InvalidArguments,
        NoError
    }

    pub enum SupportStatus{
        InitialSupport,
        ReintroducedSupport,
        FullSupport,
        PartialSupport,
        LimitedSupport,
        LimitedSupportFinalVersion,
        SupportEnded,
        NotCurrentlySupported,
        NotSupported
    }

    pub enum XbkuKernelArchitecture {
        X86,
        X64,
        ARM32EL,
        ARM32HF,
        ARM64,
        PPC64EL,
        S390X,
        IA32,
        IA64,
        PPC32,
        MIPS,
        Undefined,
        InvalidArchitecture
    }

    pub enum XbkuKernelType {
        LowLatency,
        Generic,
        GenericLPAE,
        Snapdragon,
        Undefined,
        InvalidKernelType
    }