# libwebp-sys

[bindgen](https://github.com/servo/rust-bindgen)'d FFI bindings to [libwebp](https://developers.google.com/speed/webp/docs/api).

libwebp itself is built with cmake and linked statically.

## Add manul ffi.rs

add ffi.rs that generated by bindgen manually to avoid install llvm and clang in server

## Usage

Add the following to the Cargo.toml in your project:

```
[dependencies]
libwebp-sys = "0.3"
```

## Example

### Encode:

```
pub fn encode_webp(input_image: &[u8], width: u32, height: u32, quality: i32) -> Result<Vec<u8>> {
    unsafe {
	    let mut out_buf = Box::into_raw(Box::new(0u8)) as *mut _;
	    let stride = width as i32 * 4;
	    let len = WebPEncodeRGBA(input_image.as_ptr(), width as i32, height as i32, stride, quality as f32, &mut out_buf as *mut _);
	    Ok(Vec::from_raw_parts(out_buf, len as usize, len as usize))
    }
}
```

### Decode:
```
pub fn decode_webp(buf: &[u8]) -> Result<Vec<u8>> {
	let mut width = 0;
	let mut height = 0;
	let len = buf.len();
	unsafe {
		WebPGetInfo(buf.as_ptr(), len, &mut width, &mut height);
		let out_buf = WebPDecodeRGBA(buf.as_ptr(), len, &mut width, &mut height);
	}
	let len = width * height * 4;
	Ok(Vec::from_raw_parts(out_buf, len, len))
}
```
