/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const G_ANALYZER_ANALYZING: u32 = 0;
pub const FALSE: u32 = 0;
pub const _BSD_SOURCE: u32 = 1;
pub const _XOPEN_SOURCE: u32 = 700;
pub const PAGESIZE: u32 = 4096;
pub const LONG_BIT: u32 = 64;
pub const LONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const CHAR_MIN: i32 = -128;
pub const CHAR_MAX: u32 = 127;
pub const CHAR_BIT: u32 = 8;
pub const SCHAR_MIN: i32 = -128;
pub const SCHAR_MAX: u32 = 127;
pub const UCHAR_MAX: u32 = 255;
pub const SHRT_MIN: i32 = -32768;
pub const SHRT_MAX: u32 = 32767;
pub const USHRT_MAX: u32 = 65535;
pub const INT_MIN: i32 = -2147483648;
pub const INT_MAX: u32 = 2147483647;
pub const UINT_MAX: u32 = 4294967295;
pub const LONG_MIN: i64 = -9223372036854775808;
pub const ULONG_MAX: i32 = -1;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const MB_LEN_MAX: u32 = 4;
pub const PIPE_BUF: u32 = 4096;
pub const FILESIZEBITS: u32 = 64;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const NGROUPS_MAX: u32 = 32;
pub const ARG_MAX: u32 = 131072;
pub const IOV_MAX: u32 = 1024;
pub const SYMLOOP_MAX: u32 = 40;
pub const WORD_BIT: u32 = 32;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const TZNAME_MAX: u32 = 6;
pub const TTY_NAME_MAX: u32 = 32;
pub const HOST_NAME_MAX: u32 = 255;
pub const PTHREAD_KEYS_MAX: u32 = 128;
pub const PTHREAD_STACK_MIN: u32 = 2048;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const SEM_VALUE_MAX: u32 = 2147483647;
pub const SEM_NSEMS_MAX: u32 = 256;
pub const DELAYTIMER_MAX: u32 = 2147483647;
pub const MQ_PRIO_MAX: u32 = 32768;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const CHARCLASS_NAME_MAX: u32 = 14;
pub const COLL_WEIGHTS_MAX: u32 = 2;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 4096;
pub const RE_DUP_MAX: u32 = 255;
pub const NL_ARGMAX: u32 = 9;
pub const NL_MSGMAX: u32 = 32767;
pub const NL_SETMAX: u32 = 255;
pub const NL_TEXTMAX: u32 = 2048;
pub const PAGE_SIZE: u32 = 4096;
pub const NZERO: u32 = 20;
pub const NL_LANGMAX: u32 = 32;
pub const NL_NMAX: u32 = 16;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SS_REPL_MAX: u32 = 4;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TRACE_EVENT_NAME_MAX: u32 = 30;
pub const _POSIX_TRACE_NAME_MAX: u32 = 8;
pub const _POSIX_TRACE_SYS_MAX: u32 = 8;
pub const _POSIX_TRACE_USER_EVENT_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _XOPEN_IOV_MAX: u32 = 16;
pub const _XOPEN_NAME_MAX: u32 = 255;
pub const _XOPEN_PATH_MAX: u32 = 1024;
pub const FLT_RADIX: u32 = 2;
pub const FLT_MANT_DIG: u32 = 24;
pub const FLT_MIN_EXP: i32 = -125;
pub const FLT_MAX_EXP: u32 = 128;
pub const FLT_HAS_SUBNORM: u32 = 1;
pub const FLT_DIG: u32 = 6;
pub const FLT_DECIMAL_DIG: u32 = 9;
pub const FLT_MIN_10_EXP: i32 = -37;
pub const FLT_MAX_10_EXP: u32 = 38;
pub const DBL_MANT_DIG: u32 = 53;
pub const DBL_MIN_EXP: i32 = -1021;
pub const DBL_MAX_EXP: u32 = 1024;
pub const DBL_HAS_SUBNORM: u32 = 1;
pub const DBL_DIG: u32 = 15;
pub const DBL_DECIMAL_DIG: u32 = 17;
pub const DBL_MIN_10_EXP: i32 = -307;
pub const DBL_MAX_10_EXP: u32 = 308;
pub const LDBL_HAS_SUBNORM: u32 = 1;
pub const LDBL_MANT_DIG: u32 = 64;
pub const LDBL_MIN_EXP: i32 = -16381;
pub const LDBL_MAX_EXP: u32 = 16384;
pub const LDBL_DIG: u32 = 18;
pub const LDBL_MIN_10_EXP: i32 = -4931;
pub const LDBL_MAX_10_EXP: u32 = 4932;
pub const DECIMAL_DIG: u32 = 21;
pub const G_MINSHORT: i32 = -32768;
pub const G_MAXSHORT: u32 = 32767;
pub const G_MAXUSHORT: u32 = 65535;
pub const G_MININT: i32 = -2147483648;
pub const G_MAXINT: u32 = 2147483647;
pub const G_MAXUINT: u32 = 4294967295;
pub const G_MINLONG: i64 = -9223372036854775808;
pub const G_MAXLONG: u64 = 9223372036854775807;
pub const G_MAXULONG: i32 = -1;
pub const G_GINT16_MODIFIER: &'static [u8; 2usize] = b"h\0";
pub const G_GINT16_FORMAT: &'static [u8; 3usize] = b"hi\0";
pub const G_GUINT16_FORMAT: &'static [u8; 3usize] = b"hu\0";
pub const G_GINT32_MODIFIER: &'static [u8; 1usize] = b"\0";
pub const G_GINT32_FORMAT: &'static [u8; 2usize] = b"i\0";
pub const G_GUINT32_FORMAT: &'static [u8; 2usize] = b"u\0";
pub const G_HAVE_GINT64: u32 = 1;
pub const G_GINT64_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const G_GINT64_FORMAT: &'static [u8; 3usize] = b"li\0";
pub const G_GUINT64_FORMAT: &'static [u8; 3usize] = b"lu\0";
pub const GLIB_SIZEOF_VOID_P: u32 = 8;
pub const GLIB_SIZEOF_LONG: u32 = 8;
pub const GLIB_SIZEOF_SIZE_T: u32 = 8;
pub const GLIB_SIZEOF_SSIZE_T: u32 = 8;
pub const G_GSIZE_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const G_GSSIZE_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const G_GSIZE_FORMAT: &'static [u8; 3usize] = b"lu\0";
pub const G_GSSIZE_FORMAT: &'static [u8; 3usize] = b"li\0";
pub const G_MAXSIZE: i32 = -1;
pub const G_MINSSIZE: i64 = -9223372036854775808;
pub const G_MAXSSIZE: u64 = 9223372036854775807;
pub const G_GOFFSET_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const G_GOFFSET_FORMAT: &'static [u8; 3usize] = b"li\0";
pub const G_POLLFD_FORMAT: &'static [u8; 3usize] = b"%d\0";
pub const G_GINTPTR_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const G_GINTPTR_FORMAT: &'static [u8; 3usize] = b"li\0";
pub const G_GUINTPTR_FORMAT: &'static [u8; 3usize] = b"lu\0";
pub const GLIB_MAJOR_VERSION: u32 = 2;
pub const GLIB_MINOR_VERSION: u32 = 64;
pub const GLIB_MICRO_VERSION: u32 = 5;
pub const G_VA_COPY_AS_ARRAY: u32 = 1;
pub const G_HAVE_ISO_VARARGS: u32 = 1;
pub const G_HAVE_GROWING_STACK: u32 = 0;
pub const G_HAVE_GNUC_VISIBILITY: u32 = 1;
pub const G_HAVE_GNUC_VARARGS: u32 = 1;
pub const G_MODULE_SUFFIX: &'static [u8; 3usize] = b"so\0";
pub const G_PID_FORMAT: &'static [u8; 2usize] = b"i\0";
pub const GLIB_SYSDEF_AF_UNIX: u32 = 1;
pub const GLIB_SYSDEF_AF_INET: u32 = 2;
pub const GLIB_SYSDEF_AF_INET6: u32 = 10;
pub const GLIB_SYSDEF_MSG_OOB: u32 = 1;
pub const GLIB_SYSDEF_MSG_PEEK: u32 = 2;
pub const GLIB_SYSDEF_MSG_DONTROUTE: u32 = 4;
pub const G_DIR_SEPARATOR: u8 = 47u8;
pub const G_DIR_SEPARATOR_S: &'static [u8; 2usize] = b"/\0";
pub const G_SEARCHPATH_SEPARATOR: u8 = 58u8;
pub const G_SEARCHPATH_SEPARATOR_S: &'static [u8; 2usize] = b":\0";
pub const CLOCKS_PER_SEC: u32 = 1000000;
pub const TIME_UTC: u32 = 1;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_MONOTONIC: u32 = 1;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 2;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 3;
pub const CLOCK_MONOTONIC_RAW: u32 = 4;
pub const CLOCK_REALTIME_COARSE: u32 = 5;
pub const CLOCK_MONOTONIC_COARSE: u32 = 6;
pub const CLOCK_BOOTTIME: u32 = 7;
pub const CLOCK_REALTIME_ALARM: u32 = 8;
pub const CLOCK_BOOTTIME_ALARM: u32 = 9;
pub const CLOCK_SGI_CYCLE: u32 = 10;
pub const CLOCK_TAI: u32 = 11;
pub const TIMER_ABSTIME: u32 = 1;
pub const G_E: f64 = 2.718281828459045;
pub const G_LN2: f64 = 0.6931471805599453;
pub const G_LN10: f64 = 2.302585092994046;
pub const G_PI: f64 = 3.141592653589793;
pub const G_PI_2: f64 = 1.5707963267948966;
pub const G_PI_4: f64 = 0.7853981633974483;
pub const G_SQRT2: f64 = 1.4142135623730951;
pub const G_LITTLE_ENDIAN: u32 = 1234;
pub const G_BIG_ENDIAN: u32 = 4321;
pub const G_PDP_ENDIAN: u32 = 3412;
pub const G_IEEE754_FLOAT_BIAS: u32 = 127;
pub const G_IEEE754_DOUBLE_BIAS: u32 = 1023;
pub const G_LOG_2_BASE_10: f64 = 0.3010299956639812;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const RAND_MAX: u32 = 2147483647;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const SI_ASYNCNL: i32 = -60;
pub const SI_TKILL: i32 = -6;
pub const SI_SIGIO: i32 = -5;
pub const SI_ASYNCIO: i32 = -4;
pub const SI_MESGQ: i32 = -3;
pub const SI_TIMER: i32 = -2;
pub const SI_QUEUE: i32 = -1;
pub const SI_USER: u32 = 0;
pub const SI_KERNEL: u32 = 128;
pub const MINSIGSTKSZ: u32 = 2048;
pub const SIGSTKSZ: u32 = 8192;
pub const SA_NOCLDSTOP: u32 = 1;
pub const SA_NOCLDWAIT: u32 = 2;
pub const SA_SIGINFO: u32 = 4;
pub const SA_ONSTACK: u32 = 134217728;
pub const SA_RESTART: u32 = 268435456;
pub const SA_NODEFER: u32 = 1073741824;
pub const SA_RESETHAND: u32 = 2147483648;
pub const SA_RESTORER: u32 = 67108864;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGBUS: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGUSR1: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGUSR2: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGSTKFLT: u32 = 16;
pub const SIGCHLD: u32 = 17;
pub const SIGCONT: u32 = 18;
pub const SIGSTOP: u32 = 19;
pub const SIGTSTP: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGURG: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 29;
pub const SIGPOLL: u32 = 29;
pub const SIGPWR: u32 = 30;
pub const SIGSYS: u32 = 31;
pub const SIGUNUSED: u32 = 31;
pub const _NSIG: u32 = 65;
pub const FPE_INTDIV: u32 = 1;
pub const FPE_INTOVF: u32 = 2;
pub const FPE_FLTDIV: u32 = 3;
pub const FPE_FLTOVF: u32 = 4;
pub const FPE_FLTUND: u32 = 5;
pub const FPE_FLTRES: u32 = 6;
pub const FPE_FLTINV: u32 = 7;
pub const FPE_FLTSUB: u32 = 8;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLOPN: u32 = 2;
pub const ILL_ILLADR: u32 = 3;
pub const ILL_ILLTRP: u32 = 4;
pub const ILL_PRVOPC: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const SEGV_BNDERR: u32 = 3;
pub const SEGV_PKUERR: u32 = 4;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const BUS_MCEERR_AR: u32 = 4;
pub const BUS_MCEERR_AO: u32 = 5;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const SIGEV_SIGNAL: u32 = 0;
pub const SIGEV_NONE: u32 = 1;
pub const SIGEV_THREAD: u32 = 2;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const TRAP_BRANCH: u32 = 3;
pub const TRAP_HWBKPT: u32 = 4;
pub const TRAP_UNK: u32 = 5;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 2;
pub const SS_AUTODISARM: u32 = 2147483648;
pub const SS_FLAG_BITS: u32 = 2147483648;
pub const NSIG: u32 = 65;
pub const G_DATALIST_FLAGS_MASK: u32 = 3;
pub const G_DATE_BAD_JULIAN: u32 = 0;
pub const G_DATE_BAD_DAY: u32 = 0;
pub const G_DATE_BAD_YEAR: u32 = 0;
pub const DT_UNKNOWN: u32 = 0;
pub const DT_FIFO: u32 = 1;
pub const DT_CHR: u32 = 2;
pub const DT_DIR: u32 = 4;
pub const DT_BLK: u32 = 6;
pub const DT_REG: u32 = 8;
pub const DT_LNK: u32 = 10;
pub const DT_SOCK: u32 = 12;
pub const DT_WHT: u32 = 14;
pub const G_MEM_ALIGN: u32 = 8;
pub const G_HOOK_FLAG_USER_SHIFT: u32 = 4;
pub const G_PRIORITY_HIGH: i32 = -100;
pub const G_PRIORITY_DEFAULT: u32 = 0;
pub const G_PRIORITY_HIGH_IDLE: u32 = 100;
pub const G_PRIORITY_DEFAULT_IDLE: u32 = 200;
pub const G_PRIORITY_LOW: u32 = 300;
pub const G_SOURCE_REMOVE: u32 = 0;
pub const G_UNICHAR_MAX_DECOMPOSITION_LENGTH: u32 = 18;
pub const G_KEY_FILE_DESKTOP_GROUP: &'static [u8; 14usize] = b"Desktop Entry\0";
pub const G_KEY_FILE_DESKTOP_KEY_TYPE: &'static [u8; 5usize] = b"Type\0";
pub const G_KEY_FILE_DESKTOP_KEY_VERSION: &'static [u8; 8usize] = b"Version\0";
pub const G_KEY_FILE_DESKTOP_KEY_NAME: &'static [u8; 5usize] = b"Name\0";
pub const G_KEY_FILE_DESKTOP_KEY_GENERIC_NAME: &'static [u8; 12usize] = b"GenericName\0";
pub const G_KEY_FILE_DESKTOP_KEY_NO_DISPLAY: &'static [u8; 10usize] = b"NoDisplay\0";
pub const G_KEY_FILE_DESKTOP_KEY_COMMENT: &'static [u8; 8usize] = b"Comment\0";
pub const G_KEY_FILE_DESKTOP_KEY_ICON: &'static [u8; 5usize] = b"Icon\0";
pub const G_KEY_FILE_DESKTOP_KEY_HIDDEN: &'static [u8; 7usize] = b"Hidden\0";
pub const G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN: &'static [u8; 11usize] = b"OnlyShowIn\0";
pub const G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN: &'static [u8; 10usize] = b"NotShowIn\0";
pub const G_KEY_FILE_DESKTOP_KEY_TRY_EXEC: &'static [u8; 8usize] = b"TryExec\0";
pub const G_KEY_FILE_DESKTOP_KEY_EXEC: &'static [u8; 5usize] = b"Exec\0";
pub const G_KEY_FILE_DESKTOP_KEY_PATH: &'static [u8; 5usize] = b"Path\0";
pub const G_KEY_FILE_DESKTOP_KEY_TERMINAL: &'static [u8; 9usize] = b"Terminal\0";
pub const G_KEY_FILE_DESKTOP_KEY_MIME_TYPE: &'static [u8; 9usize] = b"MimeType\0";
pub const G_KEY_FILE_DESKTOP_KEY_CATEGORIES: &'static [u8; 11usize] = b"Categories\0";
pub const G_KEY_FILE_DESKTOP_KEY_STARTUP_NOTIFY: &'static [u8; 14usize] = b"StartupNotify\0";
pub const G_KEY_FILE_DESKTOP_KEY_STARTUP_WM_CLASS: &'static [u8; 15usize] = b"StartupWMClass\0";
pub const G_KEY_FILE_DESKTOP_KEY_URL: &'static [u8; 4usize] = b"URL\0";
pub const G_KEY_FILE_DESKTOP_KEY_DBUS_ACTIVATABLE: &'static [u8; 16usize] = b"DBusActivatable\0";
pub const G_KEY_FILE_DESKTOP_KEY_ACTIONS: &'static [u8; 8usize] = b"Actions\0";
pub const G_KEY_FILE_DESKTOP_TYPE_APPLICATION: &'static [u8; 12usize] = b"Application\0";
pub const G_KEY_FILE_DESKTOP_TYPE_LINK: &'static [u8; 5usize] = b"Link\0";
pub const G_KEY_FILE_DESKTOP_TYPE_DIRECTORY: &'static [u8; 10usize] = b"Directory\0";
pub const G_LOG_LEVEL_USER_SHIFT: u32 = 8;
pub const G_OPTION_REMAINING: &'static [u8; 1usize] = b"\0";
pub const G_CSET_A_2_Z: &'static [u8; 27usize] = b"ABCDEFGHIJKLMNOPQRSTUVWXYZ\0";
pub const G_CSET_a_2_z: &'static [u8; 27usize] = b"abcdefghijklmnopqrstuvwxyz\0";
pub const G_CSET_DIGITS: &'static [u8; 11usize] = b"0123456789\0";
pub const G_CSET_LATINC: [u8; 31usize] = [
    192u8, 193u8, 194u8, 195u8, 196u8, 197u8, 198u8, 199u8, 200u8, 201u8, 202u8, 203u8, 204u8,
    205u8, 206u8, 207u8, 208u8, 209u8, 210u8, 211u8, 212u8, 213u8, 214u8, 216u8, 217u8, 218u8,
    219u8, 220u8, 221u8, 222u8, 0u8,
];
pub const G_CSET_LATINS: [u8; 33usize] = [
    223u8, 224u8, 225u8, 226u8, 227u8, 228u8, 229u8, 230u8, 231u8, 232u8, 233u8, 234u8, 235u8,
    236u8, 237u8, 238u8, 239u8, 240u8, 241u8, 242u8, 243u8, 244u8, 245u8, 246u8, 248u8, 249u8,
    250u8, 251u8, 252u8, 253u8, 254u8, 255u8, 0u8,
];
pub const G_STR_DELIMITERS: &'static [u8; 8usize] = b"_-|> <.\0";
pub const G_ASCII_DTOSTR_BUF_SIZE: u32 = 39;
pub const G_TEST_OPTION_ISOLATE_DIRS: &'static [u8; 13usize] = b"isolate_dirs\0";
pub const G_USEC_PER_SEC: u32 = 1000000;
pub const G_URI_RESERVED_CHARS_GENERIC_DELIMITERS: &'static [u8; 8usize] = b":/?#[]@\0";
pub const G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS: &'static [u8; 12usize] = b"!$&'()*+,;=\0";
pub const G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT: &'static [u8; 14usize] = b"!$&'()*+,;=:@\0";
pub const G_URI_RESERVED_CHARS_ALLOWED_IN_PATH: &'static [u8; 15usize] = b"!$&'()*+,;=:@/\0";
pub const G_URI_RESERVED_CHARS_ALLOWED_IN_USERINFO: &'static [u8; 13usize] = b"!$&'()*+,;=:\0";
pub const G_ALLOC_ONLY: u32 = 1;
pub const G_ALLOC_AND_FREE: u32 = 2;
pub const G_ALLOCATOR_LIST: u32 = 1;
pub const G_ALLOCATOR_SLIST: u32 = 2;
pub const G_ALLOCATOR_NODE: u32 = 3;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const BIG_ENDIAN: u32 = 4321;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const PDP_ENDIAN: u32 = 3412;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST64_MAX: i32 = -1;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INTMAX_MIN: i64 = -9223372036854775808;
pub const INTMAX_MAX: u64 = 9223372036854775807;
pub const UINTMAX_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const INT_FAST16_MIN: i32 = -2147483648;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST16_MAX: u32 = 2147483647;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const UINT_FAST16_MAX: u32 = 4294967295;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIZE_MAX: i32 = -1;
pub const FD_SETSIZE: u32 = 1024;
pub const SCHED_OTHER: u32 = 0;
pub const SCHED_FIFO: u32 = 1;
pub const SCHED_RR: u32 = 2;
pub const SCHED_BATCH: u32 = 3;
pub const SCHED_IDLE: u32 = 5;
pub const SCHED_DEADLINE: u32 = 6;
pub const SCHED_RESET_ON_FORK: u32 = 1073741824;
pub const PTHREAD_CREATE_JOINABLE: u32 = 0;
pub const PTHREAD_CREATE_DETACHED: u32 = 1;
pub const PTHREAD_MUTEX_NORMAL: u32 = 0;
pub const PTHREAD_MUTEX_DEFAULT: u32 = 0;
pub const PTHREAD_MUTEX_RECURSIVE: u32 = 1;
pub const PTHREAD_MUTEX_ERRORCHECK: u32 = 2;
pub const PTHREAD_MUTEX_STALLED: u32 = 0;
pub const PTHREAD_MUTEX_ROBUST: u32 = 1;
pub const PTHREAD_PRIO_NONE: u32 = 0;
pub const PTHREAD_PRIO_INHERIT: u32 = 1;
pub const PTHREAD_PRIO_PROTECT: u32 = 2;
pub const PTHREAD_INHERIT_SCHED: u32 = 0;
pub const PTHREAD_EXPLICIT_SCHED: u32 = 1;
pub const PTHREAD_SCOPE_SYSTEM: u32 = 0;
pub const PTHREAD_SCOPE_PROCESS: u32 = 1;
pub const PTHREAD_PROCESS_PRIVATE: u32 = 0;
pub const PTHREAD_PROCESS_SHARED: u32 = 1;
pub const PTHREAD_ONCE_INIT: u32 = 0;
pub const PTHREAD_CANCEL_ENABLE: u32 = 0;
pub const PTHREAD_CANCEL_DISABLE: u32 = 1;
pub const PTHREAD_CANCEL_MASKED: u32 = 2;
pub const PTHREAD_CANCEL_DEFERRED: u32 = 0;
pub const PTHREAD_CANCEL_ASYNCHRONOUS: u32 = 1;
pub const PTHREAD_BARRIER_SERIAL_THREAD: i32 = -1;
pub const EOF: i32 = -1;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 1024;
pub const FILENAME_MAX: u32 = 4096;
pub const FOPEN_MAX: u32 = 1000;
pub const TMP_MAX: u32 = 10000;
pub const L_tmpnam: u32 = 20;
pub const L_ctermid: u32 = 20;
pub const P_tmpdir: &'static [u8; 5usize] = b"/tmp\0";
pub const L_cuserid: u32 = 20;
pub const S_IFMT: u32 = 61440;
pub const S_IFDIR: u32 = 16384;
pub const S_IFCHR: u32 = 8192;
pub const S_IFBLK: u32 = 24576;
pub const S_IFREG: u32 = 32768;
pub const S_IFIFO: u32 = 4096;
pub const S_IFLNK: u32 = 40960;
pub const S_IFSOCK: u32 = 49152;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXU: u32 = 448;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXG: u32 = 56;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const S_IRWXO: u32 = 7;
pub const UTIME_NOW: u32 = 1073741823;
pub const UTIME_OMIT: u32 = 1073741822;
pub const S_IREAD: u32 = 256;
pub const S_IWRITE: u32 = 128;
pub const S_IEXEC: u32 = 64;
pub const G_TYPE_FUNDAMENTAL_SHIFT: u32 = 2;
pub const G_TYPE_RESERVED_GLIB_FIRST: u32 = 22;
pub const G_TYPE_RESERVED_GLIB_LAST: u32 = 31;
pub const G_TYPE_RESERVED_BSE_FIRST: u32 = 32;
pub const G_TYPE_RESERVED_BSE_LAST: u32 = 48;
pub const G_TYPE_RESERVED_USER_FIRST: u32 = 49;
pub const G_VALUE_NOCOPY_CONTENTS: u32 = 134217728;
pub const G_PARAM_MASK: u32 = 255;
pub const G_PARAM_USER_SHIFT: u32 = 8;
pub const G_SIGNAL_FLAGS_MASK: u32 = 511;
pub const G_SIGNAL_MATCH_MASK: u32 = 63;
pub const STDIN_FILENO: u32 = 0;
pub const STDOUT_FILENO: u32 = 1;
pub const STDERR_FILENO: u32 = 2;
pub const F_OK: u32 = 0;
pub const R_OK: u32 = 4;
pub const W_OK: u32 = 2;
pub const X_OK: u32 = 1;
pub const F_ULOCK: u32 = 0;
pub const F_LOCK: u32 = 1;
pub const F_TLOCK: u32 = 2;
pub const F_TEST: u32 = 3;
pub const L_SET: u32 = 0;
pub const L_INCR: u32 = 1;
pub const L_XTND: u32 = 2;
pub const POSIX_CLOSE_RESTART: u32 = 0;
pub const _XOPEN_VERSION: u32 = 700;
pub const _XOPEN_UNIX: u32 = 1;
pub const _XOPEN_ENH_I18N: u32 = 1;
pub const _POSIX_VERSION: u32 = 200809;
pub const _POSIX2_VERSION: u32 = 200809;
pub const _POSIX_ADVISORY_INFO: u32 = 200809;
pub const _POSIX_CHOWN_RESTRICTED: u32 = 1;
pub const _POSIX_IPV6: u32 = 200809;
pub const _POSIX_JOB_CONTROL: u32 = 1;
pub const _POSIX_MAPPED_FILES: u32 = 200809;
pub const _POSIX_MEMLOCK: u32 = 200809;
pub const _POSIX_MEMLOCK_RANGE: u32 = 200809;
pub const _POSIX_MEMORY_PROTECTION: u32 = 200809;
pub const _POSIX_MESSAGE_PASSING: u32 = 200809;
pub const _POSIX_FSYNC: u32 = 200809;
pub const _POSIX_NO_TRUNC: u32 = 1;
pub const _POSIX_RAW_SOCKETS: u32 = 200809;
pub const _POSIX_REALTIME_SIGNALS: u32 = 200809;
pub const _POSIX_REGEXP: u32 = 1;
pub const _POSIX_SAVED_IDS: u32 = 1;
pub const _POSIX_SHELL: u32 = 1;
pub const _POSIX_SPAWN: u32 = 200809;
pub const _POSIX_VDISABLE: u32 = 0;
pub const _POSIX_THREADS: u32 = 200809;
pub const _POSIX_THREAD_PROCESS_SHARED: u32 = 200809;
pub const _POSIX_THREAD_SAFE_FUNCTIONS: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKADDR: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKSIZE: u32 = 200809;
pub const _POSIX_THREAD_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_THREAD_CPUTIME: u32 = 200809;
pub const _POSIX_TIMERS: u32 = 200809;
pub const _POSIX_TIMEOUTS: u32 = 200809;
pub const _POSIX_MONOTONIC_CLOCK: u32 = 200809;
pub const _POSIX_CPUTIME: u32 = 200809;
pub const _POSIX_CLOCK_SELECTION: u32 = 200809;
pub const _POSIX_BARRIERS: u32 = 200809;
pub const _POSIX_SPIN_LOCKS: u32 = 200809;
pub const _POSIX_READER_WRITER_LOCKS: u32 = 200809;
pub const _POSIX_ASYNCHRONOUS_IO: u32 = 200809;
pub const _POSIX_SEMAPHORES: u32 = 200809;
pub const _POSIX_SHARED_MEMORY_OBJECTS: u32 = 200809;
pub const _POSIX2_C_BIND: u32 = 200809;
pub const _POSIX_V6_LP64_OFF64: u32 = 1;
pub const _POSIX_V7_LP64_OFF64: u32 = 1;
pub const _PC_LINK_MAX: u32 = 0;
pub const _PC_MAX_CANON: u32 = 1;
pub const _PC_MAX_INPUT: u32 = 2;
pub const _PC_NAME_MAX: u32 = 3;
pub const _PC_PATH_MAX: u32 = 4;
pub const _PC_PIPE_BUF: u32 = 5;
pub const _PC_CHOWN_RESTRICTED: u32 = 6;
pub const _PC_NO_TRUNC: u32 = 7;
pub const _PC_VDISABLE: u32 = 8;
pub const _PC_SYNC_IO: u32 = 9;
pub const _PC_ASYNC_IO: u32 = 10;
pub const _PC_PRIO_IO: u32 = 11;
pub const _PC_SOCK_MAXBUF: u32 = 12;
pub const _PC_FILESIZEBITS: u32 = 13;
pub const _PC_REC_INCR_XFER_SIZE: u32 = 14;
pub const _PC_REC_MAX_XFER_SIZE: u32 = 15;
pub const _PC_REC_MIN_XFER_SIZE: u32 = 16;
pub const _PC_REC_XFER_ALIGN: u32 = 17;
pub const _PC_ALLOC_SIZE_MIN: u32 = 18;
pub const _PC_SYMLINK_MAX: u32 = 19;
pub const _PC_2_SYMLINKS: u32 = 20;
pub const _SC_ARG_MAX: u32 = 0;
pub const _SC_CHILD_MAX: u32 = 1;
pub const _SC_CLK_TCK: u32 = 2;
pub const _SC_NGROUPS_MAX: u32 = 3;
pub const _SC_OPEN_MAX: u32 = 4;
pub const _SC_STREAM_MAX: u32 = 5;
pub const _SC_TZNAME_MAX: u32 = 6;
pub const _SC_JOB_CONTROL: u32 = 7;
pub const _SC_SAVED_IDS: u32 = 8;
pub const _SC_REALTIME_SIGNALS: u32 = 9;
pub const _SC_PRIORITY_SCHEDULING: u32 = 10;
pub const _SC_TIMERS: u32 = 11;
pub const _SC_ASYNCHRONOUS_IO: u32 = 12;
pub const _SC_PRIORITIZED_IO: u32 = 13;
pub const _SC_SYNCHRONIZED_IO: u32 = 14;
pub const _SC_FSYNC: u32 = 15;
pub const _SC_MAPPED_FILES: u32 = 16;
pub const _SC_MEMLOCK: u32 = 17;
pub const _SC_MEMLOCK_RANGE: u32 = 18;
pub const _SC_MEMORY_PROTECTION: u32 = 19;
pub const _SC_MESSAGE_PASSING: u32 = 20;
pub const _SC_SEMAPHORES: u32 = 21;
pub const _SC_SHARED_MEMORY_OBJECTS: u32 = 22;
pub const _SC_AIO_LISTIO_MAX: u32 = 23;
pub const _SC_AIO_MAX: u32 = 24;
pub const _SC_AIO_PRIO_DELTA_MAX: u32 = 25;
pub const _SC_DELAYTIMER_MAX: u32 = 26;
pub const _SC_MQ_OPEN_MAX: u32 = 27;
pub const _SC_MQ_PRIO_MAX: u32 = 28;
pub const _SC_VERSION: u32 = 29;
pub const _SC_PAGE_SIZE: u32 = 30;
pub const _SC_PAGESIZE: u32 = 30;
pub const _SC_RTSIG_MAX: u32 = 31;
pub const _SC_SEM_NSEMS_MAX: u32 = 32;
pub const _SC_SEM_VALUE_MAX: u32 = 33;
pub const _SC_SIGQUEUE_MAX: u32 = 34;
pub const _SC_TIMER_MAX: u32 = 35;
pub const _SC_BC_BASE_MAX: u32 = 36;
pub const _SC_BC_DIM_MAX: u32 = 37;
pub const _SC_BC_SCALE_MAX: u32 = 38;
pub const _SC_BC_STRING_MAX: u32 = 39;
pub const _SC_COLL_WEIGHTS_MAX: u32 = 40;
pub const _SC_EXPR_NEST_MAX: u32 = 42;
pub const _SC_LINE_MAX: u32 = 43;
pub const _SC_RE_DUP_MAX: u32 = 44;
pub const _SC_2_VERSION: u32 = 46;
pub const _SC_2_C_BIND: u32 = 47;
pub const _SC_2_C_DEV: u32 = 48;
pub const _SC_2_FORT_DEV: u32 = 49;
pub const _SC_2_FORT_RUN: u32 = 50;
pub const _SC_2_SW_DEV: u32 = 51;
pub const _SC_2_LOCALEDEF: u32 = 52;
pub const _SC_UIO_MAXIOV: u32 = 60;
pub const _SC_IOV_MAX: u32 = 60;
pub const _SC_THREADS: u32 = 67;
pub const _SC_THREAD_SAFE_FUNCTIONS: u32 = 68;
pub const _SC_GETGR_R_SIZE_MAX: u32 = 69;
pub const _SC_GETPW_R_SIZE_MAX: u32 = 70;
pub const _SC_LOGIN_NAME_MAX: u32 = 71;
pub const _SC_TTY_NAME_MAX: u32 = 72;
pub const _SC_THREAD_DESTRUCTOR_ITERATIONS: u32 = 73;
pub const _SC_THREAD_KEYS_MAX: u32 = 74;
pub const _SC_THREAD_STACK_MIN: u32 = 75;
pub const _SC_THREAD_THREADS_MAX: u32 = 76;
pub const _SC_THREAD_ATTR_STACKADDR: u32 = 77;
pub const _SC_THREAD_ATTR_STACKSIZE: u32 = 78;
pub const _SC_THREAD_PRIORITY_SCHEDULING: u32 = 79;
pub const _SC_THREAD_PRIO_INHERIT: u32 = 80;
pub const _SC_THREAD_PRIO_PROTECT: u32 = 81;
pub const _SC_THREAD_PROCESS_SHARED: u32 = 82;
pub const _SC_NPROCESSORS_CONF: u32 = 83;
pub const _SC_NPROCESSORS_ONLN: u32 = 84;
pub const _SC_PHYS_PAGES: u32 = 85;
pub const _SC_AVPHYS_PAGES: u32 = 86;
pub const _SC_ATEXIT_MAX: u32 = 87;
pub const _SC_PASS_MAX: u32 = 88;
pub const _SC_XOPEN_VERSION: u32 = 89;
pub const _SC_XOPEN_XCU_VERSION: u32 = 90;
pub const _SC_XOPEN_UNIX: u32 = 91;
pub const _SC_XOPEN_CRYPT: u32 = 92;
pub const _SC_XOPEN_ENH_I18N: u32 = 93;
pub const _SC_XOPEN_SHM: u32 = 94;
pub const _SC_2_CHAR_TERM: u32 = 95;
pub const _SC_2_UPE: u32 = 97;
pub const _SC_XOPEN_XPG2: u32 = 98;
pub const _SC_XOPEN_XPG3: u32 = 99;
pub const _SC_XOPEN_XPG4: u32 = 100;
pub const _SC_NZERO: u32 = 109;
pub const _SC_XBS5_ILP32_OFF32: u32 = 125;
pub const _SC_XBS5_ILP32_OFFBIG: u32 = 126;
pub const _SC_XBS5_LP64_OFF64: u32 = 127;
pub const _SC_XBS5_LPBIG_OFFBIG: u32 = 128;
pub const _SC_XOPEN_LEGACY: u32 = 129;
pub const _SC_XOPEN_REALTIME: u32 = 130;
pub const _SC_XOPEN_REALTIME_THREADS: u32 = 131;
pub const _SC_ADVISORY_INFO: u32 = 132;
pub const _SC_BARRIERS: u32 = 133;
pub const _SC_CLOCK_SELECTION: u32 = 137;
pub const _SC_CPUTIME: u32 = 138;
pub const _SC_THREAD_CPUTIME: u32 = 139;
pub const _SC_MONOTONIC_CLOCK: u32 = 149;
pub const _SC_READER_WRITER_LOCKS: u32 = 153;
pub const _SC_SPIN_LOCKS: u32 = 154;
pub const _SC_REGEXP: u32 = 155;
pub const _SC_SHELL: u32 = 157;
pub const _SC_SPAWN: u32 = 159;
pub const _SC_SPORADIC_SERVER: u32 = 160;
pub const _SC_THREAD_SPORADIC_SERVER: u32 = 161;
pub const _SC_TIMEOUTS: u32 = 164;
pub const _SC_TYPED_MEMORY_OBJECTS: u32 = 165;
pub const _SC_2_PBS: u32 = 168;
pub const _SC_2_PBS_ACCOUNTING: u32 = 169;
pub const _SC_2_PBS_LOCATE: u32 = 170;
pub const _SC_2_PBS_MESSAGE: u32 = 171;
pub const _SC_2_PBS_TRACK: u32 = 172;
pub const _SC_SYMLOOP_MAX: u32 = 173;
pub const _SC_STREAMS: u32 = 174;
pub const _SC_2_PBS_CHECKPOINT: u32 = 175;
pub const _SC_V6_ILP32_OFF32: u32 = 176;
pub const _SC_V6_ILP32_OFFBIG: u32 = 177;
pub const _SC_V6_LP64_OFF64: u32 = 178;
pub const _SC_V6_LPBIG_OFFBIG: u32 = 179;
pub const _SC_HOST_NAME_MAX: u32 = 180;
pub const _SC_TRACE: u32 = 181;
pub const _SC_TRACE_EVENT_FILTER: u32 = 182;
pub const _SC_TRACE_INHERIT: u32 = 183;
pub const _SC_TRACE_LOG: u32 = 184;
pub const _SC_IPV6: u32 = 235;
pub const _SC_RAW_SOCKETS: u32 = 236;
pub const _SC_V7_ILP32_OFF32: u32 = 237;
pub const _SC_V7_ILP32_OFFBIG: u32 = 238;
pub const _SC_V7_LP64_OFF64: u32 = 239;
pub const _SC_V7_LPBIG_OFFBIG: u32 = 240;
pub const _SC_SS_REPL_MAX: u32 = 241;
pub const _SC_TRACE_EVENT_NAME_MAX: u32 = 242;
pub const _SC_TRACE_NAME_MAX: u32 = 243;
pub const _SC_TRACE_SYS_MAX: u32 = 244;
pub const _SC_TRACE_USER_EVENT_MAX: u32 = 245;
pub const _SC_XOPEN_STREAMS: u32 = 246;
pub const _SC_THREAD_ROBUST_PRIO_INHERIT: u32 = 247;
pub const _SC_THREAD_ROBUST_PRIO_PROTECT: u32 = 248;
pub const _CS_PATH: u32 = 0;
pub const _CS_POSIX_V6_WIDTH_RESTRICTED_ENVS: u32 = 1;
pub const _CS_GNU_LIBC_VERSION: u32 = 2;
pub const _CS_GNU_LIBPTHREAD_VERSION: u32 = 3;
pub const _CS_POSIX_V5_WIDTH_RESTRICTED_ENVS: u32 = 4;
pub const _CS_POSIX_V7_WIDTH_RESTRICTED_ENVS: u32 = 5;
pub const _CS_POSIX_V6_ILP32_OFF32_CFLAGS: u32 = 1116;
pub const _CS_POSIX_V6_ILP32_OFF32_LDFLAGS: u32 = 1117;
pub const _CS_POSIX_V6_ILP32_OFF32_LIBS: u32 = 1118;
pub const _CS_POSIX_V6_ILP32_OFF32_LINTFLAGS: u32 = 1119;
pub const _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS: u32 = 1120;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS: u32 = 1121;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LIBS: u32 = 1122;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LINTFLAGS: u32 = 1123;
pub const _CS_POSIX_V6_LP64_OFF64_CFLAGS: u32 = 1124;
pub const _CS_POSIX_V6_LP64_OFF64_LDFLAGS: u32 = 1125;
pub const _CS_POSIX_V6_LP64_OFF64_LIBS: u32 = 1126;
pub const _CS_POSIX_V6_LP64_OFF64_LINTFLAGS: u32 = 1127;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS: u32 = 1128;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS: u32 = 1129;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LIBS: u32 = 1130;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LINTFLAGS: u32 = 1131;
pub const _CS_POSIX_V7_ILP32_OFF32_CFLAGS: u32 = 1132;
pub const _CS_POSIX_V7_ILP32_OFF32_LDFLAGS: u32 = 1133;
pub const _CS_POSIX_V7_ILP32_OFF32_LIBS: u32 = 1134;
pub const _CS_POSIX_V7_ILP32_OFF32_LINTFLAGS: u32 = 1135;
pub const _CS_POSIX_V7_ILP32_OFFBIG_CFLAGS: u32 = 1136;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LDFLAGS: u32 = 1137;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LIBS: u32 = 1138;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LINTFLAGS: u32 = 1139;
pub const _CS_POSIX_V7_LP64_OFF64_CFLAGS: u32 = 1140;
pub const _CS_POSIX_V7_LP64_OFF64_LDFLAGS: u32 = 1141;
pub const _CS_POSIX_V7_LP64_OFF64_LIBS: u32 = 1142;
pub const _CS_POSIX_V7_LP64_OFF64_LINTFLAGS: u32 = 1143;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_CFLAGS: u32 = 1144;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LDFLAGS: u32 = 1145;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LIBS: u32 = 1146;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LINTFLAGS: u32 = 1147;
pub const _CS_V6_ENV: u32 = 1148;
pub const _CS_V7_ENV: u32 = 1149;
pub const G_DRIVE_IDENTIFIER_KIND_UNIX_DEVICE: &'static [u8; 12usize] = b"unix-device\0";
pub const G_FILE_ATTRIBUTE_STANDARD_TYPE: &'static [u8; 15usize] = b"standard::type\0";
pub const G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN: &'static [u8; 20usize] = b"standard::is-hidden\0";
pub const G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP: &'static [u8; 20usize] = b"standard::is-backup\0";
pub const G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK: &'static [u8; 21usize] = b"standard::is-symlink\0";
pub const G_FILE_ATTRIBUTE_STANDARD_IS_VIRTUAL: &'static [u8; 21usize] = b"standard::is-virtual\0";
pub const G_FILE_ATTRIBUTE_STANDARD_IS_VOLATILE: &'static [u8; 22usize] =
    b"standard::is-volatile\0";
pub const G_FILE_ATTRIBUTE_STANDARD_NAME: &'static [u8; 15usize] = b"standard::name\0";
pub const G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME: &'static [u8; 23usize] =
    b"standard::display-name\0";
pub const G_FILE_ATTRIBUTE_STANDARD_EDIT_NAME: &'static [u8; 20usize] = b"standard::edit-name\0";
pub const G_FILE_ATTRIBUTE_STANDARD_COPY_NAME: &'static [u8; 20usize] = b"standard::copy-name\0";
pub const G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION: &'static [u8; 22usize] =
    b"standard::description\0";
pub const G_FILE_ATTRIBUTE_STANDARD_ICON: &'static [u8; 15usize] = b"standard::icon\0";
pub const G_FILE_ATTRIBUTE_STANDARD_SYMBOLIC_ICON: &'static [u8; 24usize] =
    b"standard::symbolic-icon\0";
pub const G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE: &'static [u8; 23usize] =
    b"standard::content-type\0";
pub const G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE: &'static [u8; 28usize] =
    b"standard::fast-content-type\0";
pub const G_FILE_ATTRIBUTE_STANDARD_SIZE: &'static [u8; 15usize] = b"standard::size\0";
pub const G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE: &'static [u8; 25usize] =
    b"standard::allocated-size\0";
pub const G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET: &'static [u8; 25usize] =
    b"standard::symlink-target\0";
pub const G_FILE_ATTRIBUTE_STANDARD_TARGET_URI: &'static [u8; 21usize] = b"standard::target-uri\0";
pub const G_FILE_ATTRIBUTE_STANDARD_SORT_ORDER: &'static [u8; 21usize] = b"standard::sort-order\0";
pub const G_FILE_ATTRIBUTE_ETAG_VALUE: &'static [u8; 12usize] = b"etag::value\0";
pub const G_FILE_ATTRIBUTE_ID_FILE: &'static [u8; 9usize] = b"id::file\0";
pub const G_FILE_ATTRIBUTE_ID_FILESYSTEM: &'static [u8; 15usize] = b"id::filesystem\0";
pub const G_FILE_ATTRIBUTE_ACCESS_CAN_READ: &'static [u8; 17usize] = b"access::can-read\0";
pub const G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE: &'static [u8; 18usize] = b"access::can-write\0";
pub const G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE: &'static [u8; 20usize] = b"access::can-execute\0";
pub const G_FILE_ATTRIBUTE_ACCESS_CAN_DELETE: &'static [u8; 19usize] = b"access::can-delete\0";
pub const G_FILE_ATTRIBUTE_ACCESS_CAN_TRASH: &'static [u8; 18usize] = b"access::can-trash\0";
pub const G_FILE_ATTRIBUTE_ACCESS_CAN_RENAME: &'static [u8; 19usize] = b"access::can-rename\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_CAN_MOUNT: &'static [u8; 21usize] = b"mountable::can-mount\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT: &'static [u8; 23usize] =
    b"mountable::can-unmount\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_CAN_EJECT: &'static [u8; 21usize] = b"mountable::can-eject\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE: &'static [u8; 23usize] =
    b"mountable::unix-device\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE_FILE: &'static [u8; 28usize] =
    b"mountable::unix-device-file\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_HAL_UDI: &'static [u8; 19usize] = b"mountable::hal-udi\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_CAN_START: &'static [u8; 21usize] = b"mountable::can-start\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_CAN_START_DEGRADED: &'static [u8; 30usize] =
    b"mountable::can-start-degraded\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_CAN_STOP: &'static [u8; 20usize] = b"mountable::can-stop\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_START_STOP_TYPE: &'static [u8; 27usize] =
    b"mountable::start-stop-type\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_CAN_POLL: &'static [u8; 20usize] = b"mountable::can-poll\0";
pub const G_FILE_ATTRIBUTE_MOUNTABLE_IS_MEDIA_CHECK_AUTOMATIC: &'static [u8; 36usize] =
    b"mountable::is-media-check-automatic\0";
pub const G_FILE_ATTRIBUTE_TIME_MODIFIED: &'static [u8; 15usize] = b"time::modified\0";
pub const G_FILE_ATTRIBUTE_TIME_MODIFIED_USEC: &'static [u8; 20usize] = b"time::modified-usec\0";
pub const G_FILE_ATTRIBUTE_TIME_ACCESS: &'static [u8; 13usize] = b"time::access\0";
pub const G_FILE_ATTRIBUTE_TIME_ACCESS_USEC: &'static [u8; 18usize] = b"time::access-usec\0";
pub const G_FILE_ATTRIBUTE_TIME_CHANGED: &'static [u8; 14usize] = b"time::changed\0";
pub const G_FILE_ATTRIBUTE_TIME_CHANGED_USEC: &'static [u8; 19usize] = b"time::changed-usec\0";
pub const G_FILE_ATTRIBUTE_TIME_CREATED: &'static [u8; 14usize] = b"time::created\0";
pub const G_FILE_ATTRIBUTE_TIME_CREATED_USEC: &'static [u8; 19usize] = b"time::created-usec\0";
pub const G_FILE_ATTRIBUTE_UNIX_DEVICE: &'static [u8; 13usize] = b"unix::device\0";
pub const G_FILE_ATTRIBUTE_UNIX_INODE: &'static [u8; 12usize] = b"unix::inode\0";
pub const G_FILE_ATTRIBUTE_UNIX_MODE: &'static [u8; 11usize] = b"unix::mode\0";
pub const G_FILE_ATTRIBUTE_UNIX_NLINK: &'static [u8; 12usize] = b"unix::nlink\0";
pub const G_FILE_ATTRIBUTE_UNIX_UID: &'static [u8; 10usize] = b"unix::uid\0";
pub const G_FILE_ATTRIBUTE_UNIX_GID: &'static [u8; 10usize] = b"unix::gid\0";
pub const G_FILE_ATTRIBUTE_UNIX_RDEV: &'static [u8; 11usize] = b"unix::rdev\0";
pub const G_FILE_ATTRIBUTE_UNIX_BLOCK_SIZE: &'static [u8; 17usize] = b"unix::block-size\0";
pub const G_FILE_ATTRIBUTE_UNIX_BLOCKS: &'static [u8; 13usize] = b"unix::blocks\0";
pub const G_FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT: &'static [u8; 20usize] = b"unix::is-mountpoint\0";
pub const G_FILE_ATTRIBUTE_DOS_IS_ARCHIVE: &'static [u8; 16usize] = b"dos::is-archive\0";
pub const G_FILE_ATTRIBUTE_DOS_IS_SYSTEM: &'static [u8; 15usize] = b"dos::is-system\0";
pub const G_FILE_ATTRIBUTE_DOS_IS_MOUNTPOINT: &'static [u8; 19usize] = b"dos::is-mountpoint\0";
pub const G_FILE_ATTRIBUTE_DOS_REPARSE_POINT_TAG: &'static [u8; 23usize] =
    b"dos::reparse-point-tag\0";
pub const G_FILE_ATTRIBUTE_OWNER_USER: &'static [u8; 12usize] = b"owner::user\0";
pub const G_FILE_ATTRIBUTE_OWNER_USER_REAL: &'static [u8; 17usize] = b"owner::user-real\0";
pub const G_FILE_ATTRIBUTE_OWNER_GROUP: &'static [u8; 13usize] = b"owner::group\0";
pub const G_FILE_ATTRIBUTE_THUMBNAIL_PATH: &'static [u8; 16usize] = b"thumbnail::path\0";
pub const G_FILE_ATTRIBUTE_THUMBNAILING_FAILED: &'static [u8; 18usize] = b"thumbnail::failed\0";
pub const G_FILE_ATTRIBUTE_THUMBNAIL_IS_VALID: &'static [u8; 20usize] = b"thumbnail::is-valid\0";
pub const G_FILE_ATTRIBUTE_PREVIEW_ICON: &'static [u8; 14usize] = b"preview::icon\0";
pub const G_FILE_ATTRIBUTE_FILESYSTEM_SIZE: &'static [u8; 17usize] = b"filesystem::size\0";
pub const G_FILE_ATTRIBUTE_FILESYSTEM_FREE: &'static [u8; 17usize] = b"filesystem::free\0";
pub const G_FILE_ATTRIBUTE_FILESYSTEM_USED: &'static [u8; 17usize] = b"filesystem::used\0";
pub const G_FILE_ATTRIBUTE_FILESYSTEM_TYPE: &'static [u8; 17usize] = b"filesystem::type\0";
pub const G_FILE_ATTRIBUTE_FILESYSTEM_READONLY: &'static [u8; 21usize] = b"filesystem::readonly\0";
pub const G_FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW: &'static [u8; 24usize] =
    b"filesystem::use-preview\0";
pub const G_FILE_ATTRIBUTE_FILESYSTEM_REMOTE: &'static [u8; 19usize] = b"filesystem::remote\0";
pub const G_FILE_ATTRIBUTE_GVFS_BACKEND: &'static [u8; 14usize] = b"gvfs::backend\0";
pub const G_FILE_ATTRIBUTE_SELINUX_CONTEXT: &'static [u8; 17usize] = b"selinux::context\0";
pub const G_FILE_ATTRIBUTE_TRASH_ITEM_COUNT: &'static [u8; 18usize] = b"trash::item-count\0";
pub const G_FILE_ATTRIBUTE_TRASH_ORIG_PATH: &'static [u8; 17usize] = b"trash::orig-path\0";
pub const G_FILE_ATTRIBUTE_TRASH_DELETION_DATE: &'static [u8; 21usize] = b"trash::deletion-date\0";
pub const G_FILE_ATTRIBUTE_RECENT_MODIFIED: &'static [u8; 17usize] = b"recent::modified\0";
pub const G_MEMORY_MONITOR_EXTENSION_POINT_NAME: &'static [u8; 19usize] = b"gio-memory-monitor\0";
pub const G_MENU_ATTRIBUTE_ACTION: &'static [u8; 7usize] = b"action\0";
pub const G_MENU_ATTRIBUTE_ACTION_NAMESPACE: &'static [u8; 17usize] = b"action-namespace\0";
pub const G_MENU_ATTRIBUTE_TARGET: &'static [u8; 7usize] = b"target\0";
pub const G_MENU_ATTRIBUTE_LABEL: &'static [u8; 6usize] = b"label\0";
pub const G_MENU_ATTRIBUTE_ICON: &'static [u8; 5usize] = b"icon\0";
pub const G_MENU_LINK_SUBMENU: &'static [u8; 8usize] = b"submenu\0";
pub const G_MENU_LINK_SECTION: &'static [u8; 8usize] = b"section\0";
pub const G_VOLUME_MONITOR_EXTENSION_POINT_NAME: &'static [u8; 19usize] = b"gio-volume-monitor\0";
pub const G_NATIVE_VOLUME_MONITOR_EXTENSION_POINT_NAME: &'static [u8; 26usize] =
    b"gio-native-volume-monitor\0";
pub const G_NETWORK_MONITOR_EXTENSION_POINT_NAME: &'static [u8; 20usize] = b"gio-network-monitor\0";
pub const G_PROXY_EXTENSION_POINT_NAME: &'static [u8; 10usize] = b"gio-proxy\0";
pub const G_PROXY_RESOLVER_EXTENSION_POINT_NAME: &'static [u8; 19usize] = b"gio-proxy-resolver\0";
pub const G_TLS_BACKEND_EXTENSION_POINT_NAME: &'static [u8; 16usize] = b"gio-tls-backend\0";
pub const G_TLS_DATABASE_PURPOSE_AUTHENTICATE_SERVER: &'static [u8; 18usize] =
    b"1.3.6.1.5.5.7.3.1\0";
pub const G_TLS_DATABASE_PURPOSE_AUTHENTICATE_CLIENT: &'static [u8; 18usize] =
    b"1.3.6.1.5.5.7.3.2\0";
pub const G_VFS_EXTENSION_POINT_NAME: &'static [u8; 8usize] = b"gio-vfs\0";
pub const G_VOLUME_IDENTIFIER_KIND_HAL_UDI: &'static [u8; 8usize] = b"hal-udi\0";
pub const G_VOLUME_IDENTIFIER_KIND_UNIX_DEVICE: &'static [u8; 12usize] = b"unix-device\0";
pub const G_VOLUME_IDENTIFIER_KIND_LABEL: &'static [u8; 6usize] = b"label\0";
pub const G_VOLUME_IDENTIFIER_KIND_UUID: &'static [u8; 5usize] = b"uuid\0";
pub const G_VOLUME_IDENTIFIER_KIND_NFS_MOUNT: &'static [u8; 10usize] = b"nfs-mount\0";
pub const G_VOLUME_IDENTIFIER_KIND_CLASS: &'static [u8; 6usize] = b"class\0";
pub const MATH_ERRNO: u32 = 1;
pub const MATH_ERREXCEPT: u32 = 2;
pub const math_errhandling: u32 = 2;
pub const FP_ILOGBNAN: i32 = -2147483648;
pub const FP_ILOGB0: i32 = -2147483648;
pub const M_E: f64 = 2.718281828459045;
pub const M_LOG2E: f64 = 1.4426950408889634;
pub const M_LOG10E: f64 = 0.4342944819032518;
pub const M_LN2: f64 = 0.6931471805599453;
pub const M_LN10: f64 = 2.302585092994046;
pub const M_PI: f64 = 3.141592653589793;
pub const M_PI_2: f64 = 1.5707963267948966;
pub const M_PI_4: f64 = 0.7853981633974483;
pub const M_1_PI: f64 = 0.3183098861837907;
pub const M_2_PI: f64 = 0.6366197723675814;
pub const M_2_SQRTPI: f64 = 1.1283791670955126;
pub const M_SQRT2: f64 = 1.4142135623730951;
pub const M_SQRT1_2: f64 = 0.7071067811865476;
pub const VIPS_PI: f64 = 3.141592653589793;
pub const VIPS_PATH_MAX: u32 = 4096;
pub const VIPS_TARGET_BUFFER_SIZE: u32 = 8500;
pub const VIPS_TARGET_CUSTOM_BUFFER_SIZE: u32 = 4096;
pub const VIPS_SBUF_BUFFER_SIZE: u32 = 4096;
pub const VIPS_VERSION: &'static [u8; 7usize] = b"8.10.1\0";
pub const VIPS_VERSION_STRING: &'static [u8; 36usize] = b"8.10.1-Fri Sep  4 11:40:49 UTC 2020\0";
pub const VIPS_MAJOR_VERSION: u32 = 8;
pub const VIPS_MINOR_VERSION: u32 = 10;
pub const VIPS_MICRO_VERSION: u32 = 1;
pub const VIPS_LIBRARY_CURRENT: u32 = 54;
pub const VIPS_LIBRARY_REVISION: u32 = 3;
pub const VIPS_LIBRARY_AGE: u32 = 12;
pub const VIPS_CONFIG : & 'static [ u8 ; 1204usize ] = b"native win32: no, native OS X: no, open files in binary mode: no, enable debug: no, enable deprecated library components: yes, enable docs with gtkdoc: no, gobject introspection: yes, enable radiance support: yes, enable analyze support: yes, enable PPM support: yes, use fftw3 for FFT: yes, Magick package: none, Magick API version: none, load with libMagick: no, save with libMagick: no, accelerate loops with orc: yes, ICC profile support with lcms: yes (lcms2), file import with niftiio: no, file import with libheif: yes, file import with OpenEXR: no, file import with OpenSlide: no, file import with matio: no, PDF import with PDFium: no, PDF import with poppler-glib: no, SVG import with librsvg-2.0: yes, zlib: yes, file import with cfitsio: no, file import/export with libwebp: yes, text rendering with pangoft2: yes, file import/export with libspng: no, file import/export with libpng: yes (pkg-config libpng >= 1.2.9), support 8bpp PNG quantisation: yes, file import/export with libtiff: yes (pkg-config libtiff-4), file import/export with giflib: yes (found by search), file import/export with libjpeg: yes (pkg-config), image pyramid export: yes, use libexif to load/save JPEG metadata: yes\0" ;
pub const VIPS_SONAME: &'static [u8; 14usize] = b"libvips.so.42\0";
pub const VIPS_EXEEXT: &'static [u8; 1usize] = b"\0";
pub const VIPS_ENABLE_DEPRECATED: u32 = 1;
pub const VIPS_SPARE: u32 = 8;
pub const VIPS__WINDOW_MARGIN_PIXELS: u32 = 128;
pub const VIPS__WINDOW_MARGIN_BYTES: u32 = 10485760;
pub const VIPS_SIZEOF_HEADER: u32 = 64;
pub const VIPS__TILE_WIDTH: u32 = 128;
pub const VIPS__TILE_HEIGHT: u32 = 128;
pub const VIPS__THINSTRIP_HEIGHT: u32 = 1;
pub const VIPS__FATSTRIP_HEIGHT: u32 = 16;
pub const VIPS_MAGIC_INTEL: u32 = 3064394248;
pub const VIPS_MAGIC_SPARC: u32 = 150120118;
pub const VIPS_MAX_COORD: u32 = 10000000;
pub const VIPS_TRANSFORM_SHIFT: u32 = 6;
pub const VIPS_TRANSFORM_SCALE: u32 = 64;
pub const VIPS_INTERPOLATE_SHIFT: u32 = 12;
pub const VIPS_INTERPOLATE_SCALE: u32 = 4096;
pub const VIPS_META_EXIF_NAME: &'static [u8; 10usize] = b"exif-data\0";
pub const VIPS_META_XMP_NAME: &'static [u8; 9usize] = b"xmp-data\0";
pub const VIPS_META_IPTC_NAME: &'static [u8; 10usize] = b"iptc-data\0";
pub const VIPS_META_PHOTOSHOP_NAME: &'static [u8; 15usize] = b"photoshop-data\0";
pub const VIPS_META_ICC_NAME: &'static [u8; 17usize] = b"icc-profile-data\0";
pub const VIPS_META_IMAGEDESCRIPTION: &'static [u8; 18usize] = b"image-description\0";
pub const VIPS_META_RESOLUTION_UNIT: &'static [u8; 16usize] = b"resolution-unit\0";
pub const VIPS_META_LOADER: &'static [u8; 12usize] = b"vips-loader\0";
pub const VIPS_META_SEQUENTIAL: &'static [u8; 16usize] = b"vips-sequential\0";
pub const VIPS_META_ORIENTATION: &'static [u8; 12usize] = b"orientation\0";
pub const VIPS_META_PAGE_HEIGHT: &'static [u8; 12usize] = b"page-height\0";
pub const VIPS_META_N_PAGES: &'static [u8; 8usize] = b"n-pages\0";
pub const VIPS_META_N_SUBIFDS: &'static [u8; 10usize] = b"n-subifds\0";
pub const VIPS_D93_X0: f64 = 89.74;
pub const VIPS_D93_Y0: f64 = 100.0;
pub const VIPS_D93_Z0: f64 = 130.77;
pub const VIPS_D75_X0: f64 = 94.9682;
pub const VIPS_D75_Y0: f64 = 100.0;
pub const VIPS_D75_Z0: f64 = 122.571;
pub const VIPS_D65_X0: f64 = 95.047;
pub const VIPS_D65_Y0: f64 = 100.0;
pub const VIPS_D65_Z0: f64 = 108.8827;
pub const VIPS_D55_X0: f64 = 95.6831;
pub const VIPS_D55_Y0: f64 = 100.0;
pub const VIPS_D55_Z0: f64 = 92.0871;
pub const VIPS_D50_X0: f64 = 96.425;
pub const VIPS_D50_Y0: f64 = 100.0;
pub const VIPS_D50_Z0: f64 = 82.468;
pub const VIPS_A_X0: f64 = 109.8503;
pub const VIPS_A_Y0: f64 = 100.0;
pub const VIPS_A_Z0: f64 = 35.5849;
pub const VIPS_B_X0: f64 = 99.072;
pub const VIPS_B_Y0: f64 = 100.0;
pub const VIPS_B_Z0: f64 = 85.223;
pub const VIPS_C_X0: f64 = 98.07;
pub const VIPS_C_Y0: f64 = 100.0;
pub const VIPS_C_Z0: f64 = 118.23;
pub const VIPS_E_X0: f64 = 100.0;
pub const VIPS_E_Y0: f64 = 100.0;
pub const VIPS_E_Z0: f64 = 100.0;
pub const VIPS_D3250_X0: f64 = 105.659;
pub const VIPS_D3250_Y0: f64 = 100.0;
pub const VIPS_D3250_Z0: f64 = 45.8501;
pub type wchar_t = ::std::os::raw::c_int;
pub type size_t = ::std::os::raw::c_ulong;
extern "C" {
    pub fn __flt_rounds() -> ::std::os::raw::c_int;
}
pub type gint8 = ::std::os::raw::c_schar;
pub type guint8 = ::std::os::raw::c_uchar;
pub type gint16 = ::std::os::raw::c_short;
pub type guint16 = ::std::os::raw::c_ushort;
pub type gint32 = ::std::os::raw::c_int;
pub type guint32 = ::std::os::raw::c_uint;
pub type gint64 = ::std::os::raw::c_long;
pub type guint64 = ::std::os::raw::c_ulong;
pub type gssize = ::std::os::raw::c_long;
pub type gsize = ::std::os::raw::c_ulong;
pub type goffset = gint64;
pub type gintptr = ::std::os::raw::c_long;
pub type guintptr = ::std::os::raw::c_ulong;
pub type GPid = ::std::os::raw::c_int;
pub type time_t = ::std::os::raw::c_long;
pub type timer_t = *mut ::std::os::raw::c_void;
pub type clockid_t = ::std::os::raw::c_int;
pub type clock_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct timespec {
    pub tv_sec: time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
pub type pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_struct {
    _unused: [u8; 0],
}
pub type locale_t = *mut __locale_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_tm() {
    assert_eq!(
        ::std::mem::size_of::<tm>(),
        56usize,
        concat!("Size of: ", stringify!(tm))
    );
    assert_eq!(
        ::std::mem::align_of::<tm>(),
        8usize,
        concat!("Alignment of ", stringify!(tm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_min as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_hour as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_hour)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mday as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mon as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_year as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_year)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_wday as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_wday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_yday as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_yday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_isdst as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_isdst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_gmtoff as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_gmtoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_zone as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_zone)
        )
    );
}
extern "C" {
    pub fn clock() -> clock_t;
}
extern "C" {
    pub fn time(arg1: *mut time_t) -> time_t;
}
extern "C" {
    pub fn difftime(arg1: time_t, arg2: time_t) -> f64;
}
extern "C" {
    pub fn mktime(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn strftime(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const tm,
    ) -> size_t;
}
extern "C" {
    pub fn gmtime(arg1: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn localtime(arg1: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn asctime(arg1: *const tm) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime(arg1: *const time_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn timespec_get(arg1: *mut timespec, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strftime_l(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const tm,
        arg5: locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn gmtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn localtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn asctime_r(
        arg1: *const tm,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime_r(
        arg1: *const time_t,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tzset();
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct itimerspec {
    pub it_interval: timespec,
    pub it_value: timespec,
}
#[test]
fn bindgen_test_layout_itimerspec() {
    assert_eq!(
        ::std::mem::size_of::<itimerspec>(),
        32usize,
        concat!("Size of: ", stringify!(itimerspec))
    );
    assert_eq!(
        ::std::mem::align_of::<itimerspec>(),
        8usize,
        concat!("Alignment of ", stringify!(itimerspec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<itimerspec>())).it_interval as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerspec),
            "::",
            stringify!(it_interval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<itimerspec>())).it_value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerspec),
            "::",
            stringify!(it_value)
        )
    );
}
extern "C" {
    pub fn nanosleep(arg1: *const timespec, arg2: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getres(arg1: clockid_t, arg2: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime(arg1: clockid_t, arg2: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_settime(arg1: clockid_t, arg2: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_nanosleep(
        arg1: clockid_t,
        arg2: ::std::os::raw::c_int,
        arg3: *const timespec,
        arg4: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getcpuclockid(arg1: pid_t, arg2: *mut clockid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_create(
        arg1: clockid_t,
        arg2: *mut sigevent,
        arg3: *mut timer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_delete(arg1: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_settime(
        arg1: timer_t,
        arg2: ::std::os::raw::c_int,
        arg3: *const itimerspec,
        arg4: *mut itimerspec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_gettime(arg1: timer_t, arg2: *mut itimerspec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_getoverrun(arg1: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 2usize];
}
extern "C" {
    pub fn strptime(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut tm,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut getdate_err: ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdate(arg1: *const ::std::os::raw::c_char) -> *mut tm;
}
extern "C" {
    pub fn stime(arg1: *const time_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timegm(arg1: *mut tm) -> time_t;
}
pub type gchar = ::std::os::raw::c_char;
pub type gshort = ::std::os::raw::c_short;
pub type glong = ::std::os::raw::c_long;
pub type gint = ::std::os::raw::c_int;
pub type gboolean = gint;
pub type guchar = ::std::os::raw::c_uchar;
pub type gushort = ::std::os::raw::c_ushort;
pub type gulong = ::std::os::raw::c_ulong;
pub type guint = ::std::os::raw::c_uint;
pub type gfloat = f32;
pub type gdouble = f64;
pub type gpointer = *mut ::std::os::raw::c_void;
pub type gconstpointer = *const ::std::os::raw::c_void;
pub type GCompareFunc =
    ::std::option::Option<unsafe extern "C" fn(a: gconstpointer, b: gconstpointer) -> gint>;
pub type GCompareDataFunc = ::std::option::Option<
    unsafe extern "C" fn(a: gconstpointer, b: gconstpointer, user_data: gpointer) -> gint,
>;
pub type GEqualFunc =
    ::std::option::Option<unsafe extern "C" fn(a: gconstpointer, b: gconstpointer) -> gboolean>;
pub type GDestroyNotify = ::std::option::Option<unsafe extern "C" fn(data: gpointer)>;
pub type GFunc = ::std::option::Option<unsafe extern "C" fn(data: gpointer, user_data: gpointer)>;
pub type GHashFunc = ::std::option::Option<unsafe extern "C" fn(key: gconstpointer) -> guint>;
pub type GHFunc = ::std::option::Option<
    unsafe extern "C" fn(key: gpointer, value: gpointer, user_data: gpointer),
>;
pub type GCopyFunc =
    ::std::option::Option<unsafe extern "C" fn(src: gconstpointer, data: gpointer) -> gpointer>;
pub type GFreeFunc = ::std::option::Option<unsafe extern "C" fn(data: gpointer)>;
pub type GTranslateFunc =
    ::std::option::Option<unsafe extern "C" fn(str: *const gchar, data: gpointer) -> *const gchar>;
pub type GDoubleIEEE754 = _GDoubleIEEE754;
pub type GFloatIEEE754 = _GFloatIEEE754;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GFloatIEEE754 {
    pub v_float: gfloat,
    pub mpn: _GFloatIEEE754__bindgen_ty_1,
    _bindgen_union_align: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GFloatIEEE754__bindgen_ty_1 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
}
#[test]
fn bindgen_test_layout__GFloatIEEE754__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_GFloatIEEE754__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(_GFloatIEEE754__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_GFloatIEEE754__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(_GFloatIEEE754__bindgen_ty_1))
    );
}
impl _GFloatIEEE754__bindgen_ty_1 {
    #[inline]
    pub fn mantissa(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 23u8) as u32) }
    }
    #[inline]
    pub fn set_mantissa(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 23u8, val as u64)
        }
    }
    #[inline]
    pub fn biased_exponent(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_biased_exponent(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn sign(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mantissa: guint,
        biased_exponent: guint,
        sign: guint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 23u8, {
            let mantissa: u32 = unsafe { ::std::mem::transmute(mantissa) };
            mantissa as u64
        });
        __bindgen_bitfield_unit.set(23usize, 8u8, {
            let biased_exponent: u32 = unsafe { ::std::mem::transmute(biased_exponent) };
            biased_exponent as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let sign: u32 = unsafe { ::std::mem::transmute(sign) };
            sign as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__GFloatIEEE754() {
    assert_eq!(
        ::std::mem::size_of::<_GFloatIEEE754>(),
        4usize,
        concat!("Size of: ", stringify!(_GFloatIEEE754))
    );
    assert_eq!(
        ::std::mem::align_of::<_GFloatIEEE754>(),
        4usize,
        concat!("Alignment of ", stringify!(_GFloatIEEE754))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GFloatIEEE754>())).v_float as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFloatIEEE754),
            "::",
            stringify!(v_float)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GFloatIEEE754>())).mpn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFloatIEEE754),
            "::",
            stringify!(mpn)
        )
    );
}
impl ::std::fmt::Debug for _GFloatIEEE754 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GFloatIEEE754 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GDoubleIEEE754 {
    pub v_double: gdouble,
    pub mpn: _GDoubleIEEE754__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GDoubleIEEE754__bindgen_ty_1 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize], u32>,
}
#[test]
fn bindgen_test_layout__GDoubleIEEE754__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_GDoubleIEEE754__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_GDoubleIEEE754__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_GDoubleIEEE754__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(_GDoubleIEEE754__bindgen_ty_1))
    );
}
impl _GDoubleIEEE754__bindgen_ty_1 {
    #[inline]
    pub fn mantissa_low(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_mantissa_low(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn mantissa_high(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_mantissa_high(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub fn biased_exponent(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(52usize, 11u8) as u32) }
    }
    #[inline]
    pub fn set_biased_exponent(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(52usize, 11u8, val as u64)
        }
    }
    #[inline]
    pub fn sign(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(63usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(63usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mantissa_low: guint,
        mantissa_high: guint,
        biased_exponent: guint,
        sign: guint,
    ) -> __BindgenBitfieldUnit<[u8; 8usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 32u8, {
            let mantissa_low: u32 = unsafe { ::std::mem::transmute(mantissa_low) };
            mantissa_low as u64
        });
        __bindgen_bitfield_unit.set(32usize, 20u8, {
            let mantissa_high: u32 = unsafe { ::std::mem::transmute(mantissa_high) };
            mantissa_high as u64
        });
        __bindgen_bitfield_unit.set(52usize, 11u8, {
            let biased_exponent: u32 = unsafe { ::std::mem::transmute(biased_exponent) };
            biased_exponent as u64
        });
        __bindgen_bitfield_unit.set(63usize, 1u8, {
            let sign: u32 = unsafe { ::std::mem::transmute(sign) };
            sign as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__GDoubleIEEE754() {
    assert_eq!(
        ::std::mem::size_of::<_GDoubleIEEE754>(),
        8usize,
        concat!("Size of: ", stringify!(_GDoubleIEEE754))
    );
    assert_eq!(
        ::std::mem::align_of::<_GDoubleIEEE754>(),
        8usize,
        concat!("Alignment of ", stringify!(_GDoubleIEEE754))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GDoubleIEEE754>())).v_double as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GDoubleIEEE754),
            "::",
            stringify!(v_double)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GDoubleIEEE754>())).mpn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GDoubleIEEE754),
            "::",
            stringify!(mpn)
        )
    );
}
impl ::std::fmt::Debug for _GDoubleIEEE754 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GDoubleIEEE754 {{ union }}")
    }
}
pub type GTimeVal = _GTimeVal;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTimeVal {
    pub tv_sec: glong,
    pub tv_usec: glong,
}
#[test]
fn bindgen_test_layout__GTimeVal() {
    assert_eq!(
        ::std::mem::size_of::<_GTimeVal>(),
        16usize,
        concat!("Size of: ", stringify!(_GTimeVal))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTimeVal>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTimeVal))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTimeVal>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTimeVal),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTimeVal>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTimeVal),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type grefcount = gint;
pub type gatomicrefcount = gint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GBytes {
    _unused: [u8; 0],
}
pub type GBytes = _GBytes;
pub type GArray = _GArray;
pub type GByteArray = _GByteArray;
pub type GPtrArray = _GPtrArray;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GArray {
    pub data: *mut gchar,
    pub len: guint,
}
#[test]
fn bindgen_test_layout__GArray() {
    assert_eq!(
        ::std::mem::size_of::<_GArray>(),
        16usize,
        concat!("Size of: ", stringify!(_GArray))
    );
    assert_eq!(
        ::std::mem::align_of::<_GArray>(),
        8usize,
        concat!("Alignment of ", stringify!(_GArray))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GArray>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GArray),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GArray>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GArray),
            "::",
            stringify!(len)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GByteArray {
    pub data: *mut guint8,
    pub len: guint,
}
#[test]
fn bindgen_test_layout__GByteArray() {
    assert_eq!(
        ::std::mem::size_of::<_GByteArray>(),
        16usize,
        concat!("Size of: ", stringify!(_GByteArray))
    );
    assert_eq!(
        ::std::mem::align_of::<_GByteArray>(),
        8usize,
        concat!("Alignment of ", stringify!(_GByteArray))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GByteArray>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GByteArray),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GByteArray>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GByteArray),
            "::",
            stringify!(len)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GPtrArray {
    pub pdata: *mut gpointer,
    pub len: guint,
}
#[test]
fn bindgen_test_layout__GPtrArray() {
    assert_eq!(
        ::std::mem::size_of::<_GPtrArray>(),
        16usize,
        concat!("Size of: ", stringify!(_GPtrArray))
    );
    assert_eq!(
        ::std::mem::align_of::<_GPtrArray>(),
        8usize,
        concat!("Alignment of ", stringify!(_GPtrArray))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GPtrArray>())).pdata as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GPtrArray),
            "::",
            stringify!(pdata)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GPtrArray>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GPtrArray),
            "::",
            stringify!(len)
        )
    );
}
extern "C" {
    pub fn g_array_new(
        zero_terminated: gboolean,
        clear_: gboolean,
        element_size: guint,
    ) -> *mut GArray;
}
extern "C" {
    pub fn g_array_steal(array: *mut GArray, len: *mut gsize) -> gpointer;
}
extern "C" {
    pub fn g_array_sized_new(
        zero_terminated: gboolean,
        clear_: gboolean,
        element_size: guint,
        reserved_size: guint,
    ) -> *mut GArray;
}
extern "C" {
    pub fn g_array_copy(array: *mut GArray) -> *mut GArray;
}
extern "C" {
    pub fn g_array_free(array: *mut GArray, free_segment: gboolean) -> *mut gchar;
}
extern "C" {
    pub fn g_array_ref(array: *mut GArray) -> *mut GArray;
}
extern "C" {
    pub fn g_array_unref(array: *mut GArray);
}
extern "C" {
    pub fn g_array_get_element_size(array: *mut GArray) -> guint;
}
extern "C" {
    pub fn g_array_append_vals(array: *mut GArray, data: gconstpointer, len: guint) -> *mut GArray;
}
extern "C" {
    pub fn g_array_prepend_vals(array: *mut GArray, data: gconstpointer, len: guint)
        -> *mut GArray;
}
extern "C" {
    pub fn g_array_insert_vals(
        array: *mut GArray,
        index_: guint,
        data: gconstpointer,
        len: guint,
    ) -> *mut GArray;
}
extern "C" {
    pub fn g_array_set_size(array: *mut GArray, length: guint) -> *mut GArray;
}
extern "C" {
    pub fn g_array_remove_index(array: *mut GArray, index_: guint) -> *mut GArray;
}
extern "C" {
    pub fn g_array_remove_index_fast(array: *mut GArray, index_: guint) -> *mut GArray;
}
extern "C" {
    pub fn g_array_remove_range(array: *mut GArray, index_: guint, length: guint) -> *mut GArray;
}
extern "C" {
    pub fn g_array_sort(array: *mut GArray, compare_func: GCompareFunc);
}
extern "C" {
    pub fn g_array_sort_with_data(
        array: *mut GArray,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_array_binary_search(
        array: *mut GArray,
        target: gconstpointer,
        compare_func: GCompareFunc,
        out_match_index: *mut guint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_array_set_clear_func(array: *mut GArray, clear_func: GDestroyNotify);
}
extern "C" {
    pub fn g_ptr_array_new() -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_new_with_free_func(element_free_func: GDestroyNotify) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_steal(array: *mut GPtrArray, len: *mut gsize) -> *mut gpointer;
}
extern "C" {
    pub fn g_ptr_array_copy(
        array: *mut GPtrArray,
        func: GCopyFunc,
        user_data: gpointer,
    ) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_sized_new(reserved_size: guint) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_new_full(
        reserved_size: guint,
        element_free_func: GDestroyNotify,
    ) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_free(array: *mut GPtrArray, free_seg: gboolean) -> *mut gpointer;
}
extern "C" {
    pub fn g_ptr_array_ref(array: *mut GPtrArray) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_unref(array: *mut GPtrArray);
}
extern "C" {
    pub fn g_ptr_array_set_free_func(array: *mut GPtrArray, element_free_func: GDestroyNotify);
}
extern "C" {
    pub fn g_ptr_array_set_size(array: *mut GPtrArray, length: gint);
}
extern "C" {
    pub fn g_ptr_array_remove_index(array: *mut GPtrArray, index_: guint) -> gpointer;
}
extern "C" {
    pub fn g_ptr_array_remove_index_fast(array: *mut GPtrArray, index_: guint) -> gpointer;
}
extern "C" {
    pub fn g_ptr_array_steal_index(array: *mut GPtrArray, index_: guint) -> gpointer;
}
extern "C" {
    pub fn g_ptr_array_steal_index_fast(array: *mut GPtrArray, index_: guint) -> gpointer;
}
extern "C" {
    pub fn g_ptr_array_remove(array: *mut GPtrArray, data: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_ptr_array_remove_fast(array: *mut GPtrArray, data: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_ptr_array_remove_range(
        array: *mut GPtrArray,
        index_: guint,
        length: guint,
    ) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_add(array: *mut GPtrArray, data: gpointer);
}
extern "C" {
    pub fn g_ptr_array_extend(
        array_to_extend: *mut GPtrArray,
        array: *mut GPtrArray,
        func: GCopyFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_ptr_array_extend_and_steal(array_to_extend: *mut GPtrArray, array: *mut GPtrArray);
}
extern "C" {
    pub fn g_ptr_array_insert(array: *mut GPtrArray, index_: gint, data: gpointer);
}
extern "C" {
    pub fn g_ptr_array_sort(array: *mut GPtrArray, compare_func: GCompareFunc);
}
extern "C" {
    pub fn g_ptr_array_sort_with_data(
        array: *mut GPtrArray,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_ptr_array_foreach(array: *mut GPtrArray, func: GFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_ptr_array_find(
        haystack: *mut GPtrArray,
        needle: gconstpointer,
        index_: *mut guint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_ptr_array_find_with_equal_func(
        haystack: *mut GPtrArray,
        needle: gconstpointer,
        equal_func: GEqualFunc,
        index_: *mut guint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_byte_array_new() -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_new_take(data: *mut guint8, len: gsize) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_steal(array: *mut GByteArray, len: *mut gsize) -> *mut guint8;
}
extern "C" {
    pub fn g_byte_array_sized_new(reserved_size: guint) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_free(array: *mut GByteArray, free_segment: gboolean) -> *mut guint8;
}
extern "C" {
    pub fn g_byte_array_free_to_bytes(array: *mut GByteArray) -> *mut GBytes;
}
extern "C" {
    pub fn g_byte_array_ref(array: *mut GByteArray) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_unref(array: *mut GByteArray);
}
extern "C" {
    pub fn g_byte_array_append(
        array: *mut GByteArray,
        data: *const guint8,
        len: guint,
    ) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_prepend(
        array: *mut GByteArray,
        data: *const guint8,
        len: guint,
    ) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_set_size(array: *mut GByteArray, length: guint) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_remove_index(array: *mut GByteArray, index_: guint) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_remove_index_fast(array: *mut GByteArray, index_: guint)
        -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_remove_range(
        array: *mut GByteArray,
        index_: guint,
        length: guint,
    ) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_sort(array: *mut GByteArray, compare_func: GCompareFunc);
}
extern "C" {
    pub fn g_byte_array_sort_with_data(
        array: *mut GByteArray,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_atomic_int_get(atomic: *const gint) -> gint;
}
extern "C" {
    pub fn g_atomic_int_set(atomic: *mut gint, newval: gint);
}
extern "C" {
    pub fn g_atomic_int_inc(atomic: *mut gint);
}
extern "C" {
    pub fn g_atomic_int_dec_and_test(atomic: *mut gint) -> gboolean;
}
extern "C" {
    pub fn g_atomic_int_compare_and_exchange(
        atomic: *mut gint,
        oldval: gint,
        newval: gint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_atomic_int_add(atomic: *mut gint, val: gint) -> gint;
}
extern "C" {
    pub fn g_atomic_int_and(atomic: *mut guint, val: guint) -> guint;
}
extern "C" {
    pub fn g_atomic_int_or(atomic: *mut guint, val: guint) -> guint;
}
extern "C" {
    pub fn g_atomic_int_xor(atomic: *mut guint, val: guint) -> guint;
}
extern "C" {
    pub fn g_atomic_pointer_get(atomic: *const ::std::os::raw::c_void) -> gpointer;
}
extern "C" {
    pub fn g_atomic_pointer_set(atomic: *mut ::std::os::raw::c_void, newval: gpointer);
}
extern "C" {
    pub fn g_atomic_pointer_compare_and_exchange(
        atomic: *mut ::std::os::raw::c_void,
        oldval: gpointer,
        newval: gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_atomic_pointer_add(atomic: *mut ::std::os::raw::c_void, val: gssize) -> gssize;
}
extern "C" {
    pub fn g_atomic_pointer_and(atomic: *mut ::std::os::raw::c_void, val: gsize) -> gsize;
}
extern "C" {
    pub fn g_atomic_pointer_or(atomic: *mut ::std::os::raw::c_void, val: gsize) -> gsize;
}
extern "C" {
    pub fn g_atomic_pointer_xor(atomic: *mut ::std::os::raw::c_void, val: gsize) -> gsize;
}
extern "C" {
    pub fn g_atomic_int_exchange_and_add(atomic: *mut gint, val: gint) -> gint;
}
pub type va_list = __builtin_va_list;
pub type GQuark = guint32;
extern "C" {
    pub fn g_quark_try_string(string: *const gchar) -> GQuark;
}
extern "C" {
    pub fn g_quark_from_static_string(string: *const gchar) -> GQuark;
}
extern "C" {
    pub fn g_quark_from_string(string: *const gchar) -> GQuark;
}
extern "C" {
    pub fn g_quark_to_string(quark: GQuark) -> *const gchar;
}
extern "C" {
    pub fn g_intern_string(string: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_intern_static_string(string: *const gchar) -> *const gchar;
}
pub type GError = _GError;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GError {
    pub domain: GQuark,
    pub code: gint,
    pub message: *mut gchar,
}
#[test]
fn bindgen_test_layout__GError() {
    assert_eq!(
        ::std::mem::size_of::<_GError>(),
        16usize,
        concat!("Size of: ", stringify!(_GError))
    );
    assert_eq!(
        ::std::mem::align_of::<_GError>(),
        8usize,
        concat!("Alignment of ", stringify!(_GError))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GError>())).domain as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GError),
            "::",
            stringify!(domain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GError>())).code as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_GError),
            "::",
            stringify!(code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GError>())).message as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GError),
            "::",
            stringify!(message)
        )
    );
}
extern "C" {
    pub fn g_error_new(domain: GQuark, code: gint, format: *const gchar, ...) -> *mut GError;
}
extern "C" {
    pub fn g_error_new_literal(domain: GQuark, code: gint, message: *const gchar) -> *mut GError;
}
extern "C" {
    pub fn g_error_new_valist(
        domain: GQuark,
        code: gint,
        format: *const gchar,
        args: *mut __va_list_tag,
    ) -> *mut GError;
}
extern "C" {
    pub fn g_error_free(error: *mut GError);
}
extern "C" {
    pub fn g_error_copy(error: *const GError) -> *mut GError;
}
extern "C" {
    pub fn g_error_matches(error: *const GError, domain: GQuark, code: gint) -> gboolean;
}
extern "C" {
    pub fn g_set_error(
        err: *mut *mut GError,
        domain: GQuark,
        code: gint,
        format: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_set_error_literal(
        err: *mut *mut GError,
        domain: GQuark,
        code: gint,
        message: *const gchar,
    );
}
extern "C" {
    pub fn g_propagate_error(dest: *mut *mut GError, src: *mut GError);
}
extern "C" {
    pub fn g_clear_error(err: *mut *mut GError);
}
extern "C" {
    pub fn g_prefix_error(err: *mut *mut GError, format: *const gchar, ...);
}
extern "C" {
    pub fn g_propagate_prefixed_error(
        dest: *mut *mut GError,
        src: *mut GError,
        format: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_get_user_name() -> *const gchar;
}
extern "C" {
    pub fn g_get_real_name() -> *const gchar;
}
extern "C" {
    pub fn g_get_home_dir() -> *const gchar;
}
extern "C" {
    pub fn g_get_tmp_dir() -> *const gchar;
}
extern "C" {
    pub fn g_get_host_name() -> *const gchar;
}
extern "C" {
    pub fn g_get_prgname() -> *const gchar;
}
extern "C" {
    pub fn g_set_prgname(prgname: *const gchar);
}
extern "C" {
    pub fn g_get_application_name() -> *const gchar;
}
extern "C" {
    pub fn g_set_application_name(application_name: *const gchar);
}
extern "C" {
    pub fn g_get_os_info(key_name: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_reload_user_special_dirs_cache();
}
extern "C" {
    pub fn g_get_user_data_dir() -> *const gchar;
}
extern "C" {
    pub fn g_get_user_config_dir() -> *const gchar;
}
extern "C" {
    pub fn g_get_user_cache_dir() -> *const gchar;
}
extern "C" {
    pub fn g_get_system_data_dirs() -> *const *const gchar;
}
extern "C" {
    pub fn g_get_system_config_dirs() -> *const *const gchar;
}
extern "C" {
    pub fn g_get_user_runtime_dir() -> *const gchar;
}
pub const GUserDirectory_G_USER_DIRECTORY_DESKTOP: GUserDirectory = 0;
pub const GUserDirectory_G_USER_DIRECTORY_DOCUMENTS: GUserDirectory = 1;
pub const GUserDirectory_G_USER_DIRECTORY_DOWNLOAD: GUserDirectory = 2;
pub const GUserDirectory_G_USER_DIRECTORY_MUSIC: GUserDirectory = 3;
pub const GUserDirectory_G_USER_DIRECTORY_PICTURES: GUserDirectory = 4;
pub const GUserDirectory_G_USER_DIRECTORY_PUBLIC_SHARE: GUserDirectory = 5;
pub const GUserDirectory_G_USER_DIRECTORY_TEMPLATES: GUserDirectory = 6;
pub const GUserDirectory_G_USER_DIRECTORY_VIDEOS: GUserDirectory = 7;
pub const GUserDirectory_G_USER_N_DIRECTORIES: GUserDirectory = 8;
pub type GUserDirectory = u32;
extern "C" {
    pub fn g_get_user_special_dir(directory: GUserDirectory) -> *const gchar;
}
pub type GDebugKey = _GDebugKey;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GDebugKey {
    pub key: *const gchar,
    pub value: guint,
}
#[test]
fn bindgen_test_layout__GDebugKey() {
    assert_eq!(
        ::std::mem::size_of::<_GDebugKey>(),
        16usize,
        concat!("Size of: ", stringify!(_GDebugKey))
    );
    assert_eq!(
        ::std::mem::align_of::<_GDebugKey>(),
        8usize,
        concat!("Alignment of ", stringify!(_GDebugKey))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GDebugKey>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GDebugKey),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GDebugKey>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GDebugKey),
            "::",
            stringify!(value)
        )
    );
}
extern "C" {
    pub fn g_parse_debug_string(
        string: *const gchar,
        keys: *const GDebugKey,
        nkeys: guint,
    ) -> guint;
}
extern "C" {
    pub fn g_snprintf(string: *mut gchar, n: gulong, format: *const gchar, ...) -> gint;
}
extern "C" {
    pub fn g_vsnprintf(
        string: *mut gchar,
        n: gulong,
        format: *const gchar,
        args: *mut __va_list_tag,
    ) -> gint;
}
extern "C" {
    pub fn g_nullify_pointer(nullify_location: *mut gpointer);
}
pub const GFormatSizeFlags_G_FORMAT_SIZE_DEFAULT: GFormatSizeFlags = 0;
pub const GFormatSizeFlags_G_FORMAT_SIZE_LONG_FORMAT: GFormatSizeFlags = 1;
pub const GFormatSizeFlags_G_FORMAT_SIZE_IEC_UNITS: GFormatSizeFlags = 2;
pub const GFormatSizeFlags_G_FORMAT_SIZE_BITS: GFormatSizeFlags = 4;
pub type GFormatSizeFlags = u32;
extern "C" {
    pub fn g_format_size_full(size: guint64, flags: GFormatSizeFlags) -> *mut gchar;
}
extern "C" {
    pub fn g_format_size(size: guint64) -> *mut gchar;
}
extern "C" {
    pub fn g_format_size_for_display(size: goffset) -> *mut gchar;
}
pub type GVoidFunc = ::std::option::Option<unsafe extern "C" fn()>;
extern "C" {
    pub fn g_atexit(func: GVoidFunc);
}
extern "C" {
    pub fn g_find_program_in_path(program: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_bit_nth_lsf(mask: gulong, nth_bit: gint) -> gint;
}
extern "C" {
    pub fn g_bit_nth_msf(mask: gulong, nth_bit: gint) -> gint;
}
extern "C" {
    pub fn g_bit_storage(number: gulong) -> guint;
}
extern "C" {
    pub fn atoi(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn atof(arg1: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn strtof(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtod(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtold(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtol(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoul(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoll(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoull(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn malloc(arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        arg1: ::std::os::raw::c_ulong,
        arg2: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn realloc(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn aligned_alloc(arg1: size_t, arg2: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn atexit(arg1: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _Exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn at_quick_exit(
        arg1: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn quick_exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn system(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bsearch(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: size_t,
        arg4: size_t,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qsort(
        arg1: *mut ::std::os::raw::c_void,
        arg2: size_t,
        arg3: size_t,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn abs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llabs(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn div(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn ldiv(arg1: ::std::os::raw::c_long, arg2: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn lldiv(arg1: ::std::os::raw::c_longlong, arg2: ::std::os::raw::c_longlong) -> lldiv_t;
}
extern "C" {
    pub fn mblen(arg1: *const ::std::os::raw::c_char, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbtowc(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wctomb(arg1: *mut ::std::os::raw::c_char, arg2: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcstombs(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const wchar_t,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn __ctype_get_mb_cur_max() -> size_t;
}
extern "C" {
    pub fn posix_memalign(
        arg1: *mut *mut ::std::os::raw::c_void,
        arg2: size_t,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setenv(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemp(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkostemp(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getsubopt(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rand_r(arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn realpath(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srandom(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn initstate(
        arg1: ::std::os::raw::c_uint,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setstate(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn putenv(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn posix_openpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn grantpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlockpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ptsname(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn l64a(arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn a64l(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn setkey(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn erand48(arg1: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srand48(arg1: ::std::os::raw::c_long);
}
extern "C" {
    pub fn seed48(arg1: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn lcong48(arg1: *mut ::std::os::raw::c_ushort);
}
extern "C" {
    pub fn __builtin_alloca(arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn mktemp(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemps(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkostemps(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn valloc(arg1: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memalign(arg1: size_t, arg2: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn getloadavg(arg1: *mut f64, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_thread_error_quark() -> GQuark;
}
pub const GThreadError_G_THREAD_ERROR_AGAIN: GThreadError = 0;
pub type GThreadError = u32;
pub type GThreadFunc = ::std::option::Option<unsafe extern "C" fn(data: gpointer) -> gpointer>;
pub type GThread = _GThread;
pub type GMutex = _GMutex;
pub type GRecMutex = _GRecMutex;
pub type GRWLock = _GRWLock;
pub type GCond = _GCond;
pub type GPrivate = _GPrivate;
pub type GOnce = _GOnce;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GMutex {
    pub p: gpointer,
    pub i: [guint; 2usize],
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout__GMutex() {
    assert_eq!(
        ::std::mem::size_of::<_GMutex>(),
        8usize,
        concat!("Size of: ", stringify!(_GMutex))
    );
    assert_eq!(
        ::std::mem::align_of::<_GMutex>(),
        8usize,
        concat!("Alignment of ", stringify!(_GMutex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMutex>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMutex),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMutex>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMutex),
            "::",
            stringify!(i)
        )
    );
}
impl ::std::fmt::Debug for _GMutex {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GMutex {{ union }}")
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GRWLock {
    pub p: gpointer,
    pub i: [guint; 2usize],
}
#[test]
fn bindgen_test_layout__GRWLock() {
    assert_eq!(
        ::std::mem::size_of::<_GRWLock>(),
        16usize,
        concat!("Size of: ", stringify!(_GRWLock))
    );
    assert_eq!(
        ::std::mem::align_of::<_GRWLock>(),
        8usize,
        concat!("Alignment of ", stringify!(_GRWLock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GRWLock>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GRWLock),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GRWLock>())).i as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GRWLock),
            "::",
            stringify!(i)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GCond {
    pub p: gpointer,
    pub i: [guint; 2usize],
}
#[test]
fn bindgen_test_layout__GCond() {
    assert_eq!(
        ::std::mem::size_of::<_GCond>(),
        16usize,
        concat!("Size of: ", stringify!(_GCond))
    );
    assert_eq!(
        ::std::mem::align_of::<_GCond>(),
        8usize,
        concat!("Alignment of ", stringify!(_GCond))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCond>())).p as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(_GCond), "::", stringify!(p))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCond>())).i as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(_GCond), "::", stringify!(i))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GRecMutex {
    pub p: gpointer,
    pub i: [guint; 2usize],
}
#[test]
fn bindgen_test_layout__GRecMutex() {
    assert_eq!(
        ::std::mem::size_of::<_GRecMutex>(),
        16usize,
        concat!("Size of: ", stringify!(_GRecMutex))
    );
    assert_eq!(
        ::std::mem::align_of::<_GRecMutex>(),
        8usize,
        concat!("Alignment of ", stringify!(_GRecMutex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GRecMutex>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GRecMutex),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GRecMutex>())).i as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GRecMutex),
            "::",
            stringify!(i)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GPrivate {
    pub p: gpointer,
    pub notify: GDestroyNotify,
    pub future: [gpointer; 2usize],
}
#[test]
fn bindgen_test_layout__GPrivate() {
    assert_eq!(
        ::std::mem::size_of::<_GPrivate>(),
        32usize,
        concat!("Size of: ", stringify!(_GPrivate))
    );
    assert_eq!(
        ::std::mem::align_of::<_GPrivate>(),
        8usize,
        concat!("Alignment of ", stringify!(_GPrivate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GPrivate>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GPrivate),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GPrivate>())).notify as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GPrivate),
            "::",
            stringify!(notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GPrivate>())).future as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GPrivate),
            "::",
            stringify!(future)
        )
    );
}
pub const GOnceStatus_G_ONCE_STATUS_NOTCALLED: GOnceStatus = 0;
pub const GOnceStatus_G_ONCE_STATUS_PROGRESS: GOnceStatus = 1;
pub const GOnceStatus_G_ONCE_STATUS_READY: GOnceStatus = 2;
pub type GOnceStatus = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GOnce {
    pub status: GOnceStatus,
    pub retval: gpointer,
}
#[test]
fn bindgen_test_layout__GOnce() {
    assert_eq!(
        ::std::mem::size_of::<_GOnce>(),
        16usize,
        concat!("Size of: ", stringify!(_GOnce))
    );
    assert_eq!(
        ::std::mem::align_of::<_GOnce>(),
        8usize,
        concat!("Alignment of ", stringify!(_GOnce))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOnce>())).status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOnce),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOnce>())).retval as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOnce),
            "::",
            stringify!(retval)
        )
    );
}
extern "C" {
    pub fn g_thread_ref(thread: *mut GThread) -> *mut GThread;
}
extern "C" {
    pub fn g_thread_unref(thread: *mut GThread);
}
extern "C" {
    pub fn g_thread_new(name: *const gchar, func: GThreadFunc, data: gpointer) -> *mut GThread;
}
extern "C" {
    pub fn g_thread_try_new(
        name: *const gchar,
        func: GThreadFunc,
        data: gpointer,
        error: *mut *mut GError,
    ) -> *mut GThread;
}
extern "C" {
    pub fn g_thread_self() -> *mut GThread;
}
extern "C" {
    pub fn g_thread_exit(retval: gpointer);
}
extern "C" {
    pub fn g_thread_join(thread: *mut GThread) -> gpointer;
}
extern "C" {
    pub fn g_thread_yield();
}
extern "C" {
    pub fn g_mutex_init(mutex: *mut GMutex);
}
extern "C" {
    pub fn g_mutex_clear(mutex: *mut GMutex);
}
extern "C" {
    pub fn g_mutex_lock(mutex: *mut GMutex);
}
extern "C" {
    pub fn g_mutex_trylock(mutex: *mut GMutex) -> gboolean;
}
extern "C" {
    pub fn g_mutex_unlock(mutex: *mut GMutex);
}
extern "C" {
    pub fn g_rw_lock_init(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rw_lock_clear(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rw_lock_writer_lock(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rw_lock_writer_trylock(rw_lock: *mut GRWLock) -> gboolean;
}
extern "C" {
    pub fn g_rw_lock_writer_unlock(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rw_lock_reader_lock(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rw_lock_reader_trylock(rw_lock: *mut GRWLock) -> gboolean;
}
extern "C" {
    pub fn g_rw_lock_reader_unlock(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rec_mutex_init(rec_mutex: *mut GRecMutex);
}
extern "C" {
    pub fn g_rec_mutex_clear(rec_mutex: *mut GRecMutex);
}
extern "C" {
    pub fn g_rec_mutex_lock(rec_mutex: *mut GRecMutex);
}
extern "C" {
    pub fn g_rec_mutex_trylock(rec_mutex: *mut GRecMutex) -> gboolean;
}
extern "C" {
    pub fn g_rec_mutex_unlock(rec_mutex: *mut GRecMutex);
}
extern "C" {
    pub fn g_cond_init(cond: *mut GCond);
}
extern "C" {
    pub fn g_cond_clear(cond: *mut GCond);
}
extern "C" {
    pub fn g_cond_wait(cond: *mut GCond, mutex: *mut GMutex);
}
extern "C" {
    pub fn g_cond_signal(cond: *mut GCond);
}
extern "C" {
    pub fn g_cond_broadcast(cond: *mut GCond);
}
extern "C" {
    pub fn g_cond_wait_until(cond: *mut GCond, mutex: *mut GMutex, end_time: gint64) -> gboolean;
}
extern "C" {
    pub fn g_private_get(key: *mut GPrivate) -> gpointer;
}
extern "C" {
    pub fn g_private_set(key: *mut GPrivate, value: gpointer);
}
extern "C" {
    pub fn g_private_replace(key: *mut GPrivate, value: gpointer);
}
extern "C" {
    pub fn g_once_impl(once: *mut GOnce, func: GThreadFunc, arg: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_once_init_enter(location: *mut ::std::os::raw::c_void) -> gboolean;
}
extern "C" {
    pub fn g_once_init_leave(location: *mut ::std::os::raw::c_void, result: gsize);
}
extern "C" {
    pub fn g_get_num_processors() -> guint;
}
pub type GMutexLocker = ::std::os::raw::c_void;
pub type GRecMutexLocker = ::std::os::raw::c_void;
pub type GRWLockWriterLocker = ::std::os::raw::c_void;
pub type GRWLockReaderLocker = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GAsyncQueue {
    _unused: [u8; 0],
}
pub type GAsyncQueue = _GAsyncQueue;
extern "C" {
    pub fn g_async_queue_new() -> *mut GAsyncQueue;
}
extern "C" {
    pub fn g_async_queue_new_full(item_free_func: GDestroyNotify) -> *mut GAsyncQueue;
}
extern "C" {
    pub fn g_async_queue_lock(queue: *mut GAsyncQueue);
}
extern "C" {
    pub fn g_async_queue_unlock(queue: *mut GAsyncQueue);
}
extern "C" {
    pub fn g_async_queue_ref(queue: *mut GAsyncQueue) -> *mut GAsyncQueue;
}
extern "C" {
    pub fn g_async_queue_unref(queue: *mut GAsyncQueue);
}
extern "C" {
    pub fn g_async_queue_ref_unlocked(queue: *mut GAsyncQueue);
}
extern "C" {
    pub fn g_async_queue_unref_and_unlock(queue: *mut GAsyncQueue);
}
extern "C" {
    pub fn g_async_queue_push(queue: *mut GAsyncQueue, data: gpointer);
}
extern "C" {
    pub fn g_async_queue_push_unlocked(queue: *mut GAsyncQueue, data: gpointer);
}
extern "C" {
    pub fn g_async_queue_push_sorted(
        queue: *mut GAsyncQueue,
        data: gpointer,
        func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_async_queue_push_sorted_unlocked(
        queue: *mut GAsyncQueue,
        data: gpointer,
        func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_async_queue_pop(queue: *mut GAsyncQueue) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_pop_unlocked(queue: *mut GAsyncQueue) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_try_pop(queue: *mut GAsyncQueue) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_try_pop_unlocked(queue: *mut GAsyncQueue) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_timeout_pop(queue: *mut GAsyncQueue, timeout: guint64) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_timeout_pop_unlocked(
        queue: *mut GAsyncQueue,
        timeout: guint64,
    ) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_length(queue: *mut GAsyncQueue) -> gint;
}
extern "C" {
    pub fn g_async_queue_length_unlocked(queue: *mut GAsyncQueue) -> gint;
}
extern "C" {
    pub fn g_async_queue_sort(queue: *mut GAsyncQueue, func: GCompareDataFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_async_queue_sort_unlocked(
        queue: *mut GAsyncQueue,
        func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_async_queue_remove(queue: *mut GAsyncQueue, item: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_async_queue_remove_unlocked(queue: *mut GAsyncQueue, item: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_async_queue_push_front(queue: *mut GAsyncQueue, item: gpointer);
}
extern "C" {
    pub fn g_async_queue_push_front_unlocked(queue: *mut GAsyncQueue, item: gpointer);
}
extern "C" {
    pub fn g_async_queue_timed_pop(queue: *mut GAsyncQueue, end_time: *mut GTimeVal) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_timed_pop_unlocked(
        queue: *mut GAsyncQueue,
        end_time: *mut GTimeVal,
    ) -> gpointer;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pthread_attr_t {
    pub __u: pthread_attr_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t__bindgen_ty_1 {
    pub __i: [::std::os::raw::c_int; 14usize],
    pub __vi: [::std::os::raw::c_int; 14usize],
    pub __s: [::std::os::raw::c_ulong; 7usize],
    _bindgen_union_align: [u64; 7usize],
}
#[test]
fn bindgen_test_layout_pthread_attr_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_attr_t__bindgen_ty_1>())).__i as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t__bindgen_ty_1),
            "::",
            stringify!(__i)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_attr_t__bindgen_ty_1>())).__vi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t__bindgen_ty_1),
            "::",
            stringify!(__vi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_attr_t__bindgen_ty_1>())).__s as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t__bindgen_ty_1),
            "::",
            stringify!(__s)
        )
    );
}
impl ::std::fmt::Debug for pthread_attr_t__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_attr_t__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__u)
        )
    );
}
impl ::std::fmt::Debug for pthread_attr_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_attr_t {{ __u: {:?} }}", self.__u)
    }
}
pub type uid_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread {
    _unused: [u8; 0],
}
pub type pthread_t = *mut __pthread;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct __sigset_t {
    pub __bits: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__bits)
        )
    );
}
pub type sigset_t = __sigset_t;
pub type stack_t = sigaltstack;
pub type greg_t = ::std::os::raw::c_longlong;
pub type gregset_t = [::std::os::raw::c_longlong; 23usize];
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _fpstate {
    pub cwd: ::std::os::raw::c_ushort,
    pub swd: ::std::os::raw::c_ushort,
    pub ftw: ::std::os::raw::c_ushort,
    pub fop: ::std::os::raw::c_ushort,
    pub rip: ::std::os::raw::c_ulonglong,
    pub rdp: ::std::os::raw::c_ulonglong,
    pub mxcsr: ::std::os::raw::c_uint,
    pub mxcr_mask: ::std::os::raw::c_uint,
    pub _st: [_fpstate__bindgen_ty_1; 8usize],
    pub _xmm: [_fpstate__bindgen_ty_2; 16usize],
    pub padding: [::std::os::raw::c_uint; 24usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _fpstate__bindgen_ty_1 {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
    pub padding: [::std::os::raw::c_ushort; 3usize],
}
#[test]
fn bindgen_test_layout__fpstate__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_fpstate__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(_fpstate__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpstate__bindgen_ty_1>(),
        2usize,
        concat!("Alignment of ", stringify!(_fpstate__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_fpstate__bindgen_ty_1>())).significand as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate__bindgen_ty_1),
            "::",
            stringify!(significand)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate__bindgen_ty_1>())).exponent as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate__bindgen_ty_1),
            "::",
            stringify!(exponent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate__bindgen_ty_1>())).padding as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate__bindgen_ty_1),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _fpstate__bindgen_ty_2 {
    pub element: [::std::os::raw::c_uint; 4usize],
}
#[test]
fn bindgen_test_layout__fpstate__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<_fpstate__bindgen_ty_2>(),
        16usize,
        concat!("Size of: ", stringify!(_fpstate__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpstate__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(_fpstate__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate__bindgen_ty_2>())).element as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate__bindgen_ty_2),
            "::",
            stringify!(element)
        )
    );
}
#[test]
fn bindgen_test_layout__fpstate() {
    assert_eq!(
        ::std::mem::size_of::<_fpstate>(),
        512usize,
        concat!("Size of: ", stringify!(_fpstate))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpstate>(),
        8usize,
        concat!("Alignment of ", stringify!(_fpstate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).cwd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(cwd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).swd as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(swd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).ftw as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(ftw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).fop as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(fop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).rip as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).rdp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(rdp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).mxcsr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(mxcsr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).mxcr_mask as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(mxcr_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>()))._st as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(_st)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>()))._xmm as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(_xmm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).padding as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(padding)
        )
    );
}
pub type fpregset_t = *mut _fpstate;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct sigcontext {
    pub r8: ::std::os::raw::c_ulong,
    pub r9: ::std::os::raw::c_ulong,
    pub r10: ::std::os::raw::c_ulong,
    pub r11: ::std::os::raw::c_ulong,
    pub r12: ::std::os::raw::c_ulong,
    pub r13: ::std::os::raw::c_ulong,
    pub r14: ::std::os::raw::c_ulong,
    pub r15: ::std::os::raw::c_ulong,
    pub rdi: ::std::os::raw::c_ulong,
    pub rsi: ::std::os::raw::c_ulong,
    pub rbp: ::std::os::raw::c_ulong,
    pub rbx: ::std::os::raw::c_ulong,
    pub rdx: ::std::os::raw::c_ulong,
    pub rax: ::std::os::raw::c_ulong,
    pub rcx: ::std::os::raw::c_ulong,
    pub rsp: ::std::os::raw::c_ulong,
    pub rip: ::std::os::raw::c_ulong,
    pub eflags: ::std::os::raw::c_ulong,
    pub cs: ::std::os::raw::c_ushort,
    pub gs: ::std::os::raw::c_ushort,
    pub fs: ::std::os::raw::c_ushort,
    pub __pad0: ::std::os::raw::c_ushort,
    pub err: ::std::os::raw::c_ulong,
    pub trapno: ::std::os::raw::c_ulong,
    pub oldmask: ::std::os::raw::c_ulong,
    pub cr2: ::std::os::raw::c_ulong,
    pub fpstate: *mut _fpstate,
    pub __reserved1: [::std::os::raw::c_ulong; 8usize],
}
#[test]
fn bindgen_test_layout_sigcontext() {
    assert_eq!(
        ::std::mem::size_of::<sigcontext>(),
        256usize,
        concat!("Size of: ", stringify!(sigcontext))
    );
    assert_eq!(
        ::std::mem::align_of::<sigcontext>(),
        8usize,
        concat!("Alignment of ", stringify!(sigcontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r9 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r9)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r10 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r10)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r11 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r11)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r12 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r12)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r13 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r13)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r14 as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r14)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r15 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r15)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rdi as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rdi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rsi as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rsi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rbp as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rbp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rbx as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rbx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rdx as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rdx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rax as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rcx as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rcx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rsp as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rsp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rip as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).eflags as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(eflags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).cs as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).gs as *const _ as usize },
        146usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(gs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).fs as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).__pad0 as *const _ as usize },
        150usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(__pad0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).err as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(err)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).trapno as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(trapno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).oldmask as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(oldmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).cr2 as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(cr2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).fpstate as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(fpstate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).__reserved1 as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(__reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct mcontext_t {
    pub gregs: gregset_t,
    pub fpregs: fpregset_t,
    pub __reserved1: [::std::os::raw::c_ulonglong; 8usize],
}
#[test]
fn bindgen_test_layout_mcontext_t() {
    assert_eq!(
        ::std::mem::size_of::<mcontext_t>(),
        256usize,
        concat!("Size of: ", stringify!(mcontext_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mcontext_t>(),
        8usize,
        concat!("Alignment of ", stringify!(mcontext_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mcontext_t>())).gregs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mcontext_t),
            "::",
            stringify!(gregs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mcontext_t>())).fpregs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(mcontext_t),
            "::",
            stringify!(fpregs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mcontext_t>())).__reserved1 as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(mcontext_t),
            "::",
            stringify!(__reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_flags: ::std::os::raw::c_int,
    pub ss_size: size_t,
}
#[test]
fn bindgen_test_layout_sigaltstack() {
    assert_eq!(
        ::std::mem::size_of::<sigaltstack>(),
        24usize,
        concat!("Size of: ", stringify!(sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaltstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaltstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaltstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaltstack>())).ss_flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaltstack>())).ss_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __ucontext {
    pub uc_flags: ::std::os::raw::c_ulong,
    pub uc_link: *mut __ucontext,
    pub uc_stack: stack_t,
    pub uc_mcontext: mcontext_t,
    pub uc_sigmask: sigset_t,
    pub __fpregs_mem: [::std::os::raw::c_ulong; 64usize],
}
#[test]
fn bindgen_test_layout___ucontext() {
    assert_eq!(
        ::std::mem::size_of::<__ucontext>(),
        936usize,
        concat!("Size of: ", stringify!(__ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<__ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(__ucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__ucontext>())).uc_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ucontext),
            "::",
            stringify!(uc_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__ucontext>())).uc_link as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__ucontext>())).uc_stack as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__ucontext>())).uc_mcontext as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__ucontext>())).uc_sigmask as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__ucontext),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__ucontext>())).__fpregs_mem as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__ucontext),
            "::",
            stringify!(__fpregs_mem)
        )
    );
}
impl ::std::fmt::Debug for __ucontext {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! ( f , "__ucontext {{ uc_flags: {:?}, uc_link: {:?}, uc_stack: {:?}, uc_mcontext: {:?}, uc_sigmask: {:?}, __fpregs_mem: [{}] }}" , self . uc_flags , self . uc_link , self . uc_stack , self . uc_mcontext , self . uc_sigmask , self . __fpregs_mem . iter ( ) . enumerate ( ) . map ( | ( i , v ) | format ! ( "{}{:?}" , if i > 0 { ", " } else { "" } , v ) ) . collect :: < String > ( ) )
    }
}
impl ::std::cmp::PartialEq for __ucontext {
    fn eq(&self, other: &__ucontext) -> bool {
        self.uc_flags == other.uc_flags
            && self.uc_link == other.uc_link
            && self.uc_stack == other.uc_stack
            && self.uc_mcontext == other.uc_mcontext
            && self.uc_sigmask == other.uc_sigmask
            && &self.__fpregs_mem[..] == &other.__fpregs_mem[..]
    }
}
pub type ucontext_t = __ucontext;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_sigval() {
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
impl ::std::fmt::Debug for sigval {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "sigval {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub __si_fields: siginfo_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1 {
    pub __pad: [::std::os::raw::c_char; 112usize],
    pub __si_common: siginfo_t__bindgen_ty_1__bindgen_ty_1,
    pub __sigfault: siginfo_t__bindgen_ty_1__bindgen_ty_2,
    pub __sigpoll: siginfo_t__bindgen_ty_1__bindgen_ty_3,
    pub __sigsys: siginfo_t__bindgen_ty_1__bindgen_ty_4,
    _bindgen_union_align: [u64; 14usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_1 {
    pub __first: siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
    pub __second: siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    pub __piduid: siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
    pub __timer: siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2,
    _bindgen_union_align: [u32; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    pub si_pid: pid_t,
    pub si_uid: uid_t,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
            >()))
            .si_pid as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
            >()))
            .si_uid as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_uid)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2 {
    pub si_timerid: ::std::os::raw::c_int,
    pub si_overrun: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2,
            >()))
            .si_timerid as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_timerid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2,
            >()))
            .si_overrun as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_overrun)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>())).__piduid
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__piduid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>())).__timer
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__timer)
        )
    );
}
impl ::std::fmt::Debug for siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {{ union }}"
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2 {
    pub si_value: sigval,
    pub __sigchld: siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
    _bindgen_union_align: [u64; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    pub si_status: ::std::os::raw::c_int,
    pub si_utime: clock_t,
    pub si_stime: clock_t,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
            >()))
            .si_status as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(si_status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
            >()))
            .si_utime as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(si_utime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
            >()))
            .si_stime as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(si_stime)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2>())).si_value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2>()))
                .__sigchld as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(__sigchld)
        )
    );
}
impl ::std::fmt::Debug for siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "siginfo_t__bindgen_ty_1__bindgen_ty_1__bindgen_ty_2 {{ union }}"
        )
    }
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_1>())).__first as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__first)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_1>())).__second as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__second)
        )
    );
}
impl ::std::fmt::Debug for siginfo_t__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "siginfo_t__bindgen_ty_1__bindgen_ty_1 {{ __first: {:?}, __second: {:?} }}",
            self.__first, self.__second
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_2 {
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_addr_lsb: ::std::os::raw::c_short,
    pub __first: siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    pub __addr_bnd: siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
    pub si_pkey: ::std::os::raw::c_uint,
    _bindgen_union_align: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1 {
    pub si_lower: *mut ::std::os::raw::c_void,
    pub si_upper: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
            >()))
            .si_lower as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_lower)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
            >()))
            .si_upper as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_upper)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1>()))
                .__addr_bnd as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__addr_bnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1>())).si_pkey
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(si_pkey)
        )
    );
}
impl ::std::fmt::Debug for siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "siginfo_t__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {{ union }}"
        )
    }
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_2>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2>())).si_addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2>())).si_addr_lsb
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_addr_lsb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2>())).__first as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(__first)
        )
    );
}
impl ::std::fmt::Debug for siginfo_t__bindgen_ty_1__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! ( f , "siginfo_t__bindgen_ty_1__bindgen_ty_2 {{ si_addr: {:?}, si_addr_lsb: {:?}, __first: {:?} }}" , self . si_addr , self . si_addr_lsb , self . __first )
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_3 {
    pub si_band: ::std::os::raw::c_long,
    pub si_fd: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_3>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_3>())).si_band as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(si_band)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_3>())).si_fd as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(si_fd)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_4 {
    pub si_call_addr: *mut ::std::os::raw::c_void,
    pub si_syscall: ::std::os::raw::c_int,
    pub si_arch: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_4>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_4>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_call_addr
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_call_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_syscall as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_syscall)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_arch as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_arch)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1>(),
        112usize,
        concat!("Size of: ", stringify!(siginfo_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(siginfo_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>())).__pad as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(__pad)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>())).__si_common as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(__si_common)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>())).__sigfault as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(__sigfault)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>())).__sigpoll as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(__sigpoll)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>())).__sigsys as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(__sigsys)
        )
    );
}
impl ::std::fmt::Debug for siginfo_t__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "siginfo_t__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_siginfo_t() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t>(),
        128usize,
        concat!("Size of: ", stringify!(siginfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(siginfo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).si_signo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).si_errno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).si_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).__si_fields as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(__si_fields)
        )
    );
}
impl ::std::fmt::Debug for siginfo_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "siginfo_t {{ si_signo: {:?}, si_errno: {:?}, si_code: {:?}, __si_fields: {:?} }}",
            self.si_signo, self.si_errno, self.si_code, self.__si_fields
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sa_handler: sigaction__bindgen_ty_1,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
    pub sa_restorer: ::std::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigaction__bindgen_ty_1 {
    pub sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut siginfo_t,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_sigaction__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sigaction__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(sigaction__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigaction__bindgen_ty_1>())).sa_handler as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction__bindgen_ty_1),
            "::",
            stringify!(sa_handler)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigaction__bindgen_ty_1>())).sa_sigaction as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction__bindgen_ty_1),
            "::",
            stringify!(sa_sigaction)
        )
    );
}
impl ::std::fmt::Debug for sigaction__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "sigaction__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_sigaction() {
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        152usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).__sa_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sa_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_flags as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_restorer as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_restorer)
        )
    );
}
impl ::std::fmt::Debug for sigaction {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "sigaction {{ __sa_handler: {:?}, sa_mask: {:?}, sa_flags: {:?}, sa_restorer: {:?} }}",
            self.__sa_handler, self.sa_mask, self.sa_flags, self.sa_restorer
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_value: sigval,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
    pub __pad: [::std::os::raw::c_char; 32usize],
}
#[test]
fn bindgen_test_layout_sigevent() {
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        64usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_signo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify_function as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_function)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent>())).sigev_notify_attributes as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_attributes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).__pad as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(__pad)
        )
    );
}
impl ::std::fmt::Debug for sigevent {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! ( f , "sigevent {{ sigev_value: {:?}, sigev_signo: {:?}, sigev_notify: {:?}, sigev_notify_function: {:?}, sigev_notify_attributes: {:?}, __pad: [{}] }}" , self . sigev_value , self . sigev_signo , self . sigev_notify , self . sigev_notify_function , self . sigev_notify_attributes , self . __pad . iter ( ) . enumerate ( ) . map ( | ( i , v ) | format ! ( "{}{:?}" , if i > 0 { ", " } else { "" } , v ) ) . collect :: < String > ( ) )
    }
}
extern "C" {
    pub fn __libc_current_sigrtmin() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __libc_current_sigrtmax() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn kill(arg1: pid_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigemptyset(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigfillset(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaddset(arg1: *mut sigset_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigdelset(arg1: *mut sigset_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigismember(arg1: *const sigset_t, arg2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigprocmask(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigset_t,
        arg3: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsuspend(arg1: *const sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaction(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigaction,
        arg3: *mut sigaction,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpending(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwait(
        arg1: *const sigset_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwaitinfo(arg1: *const sigset_t, arg2: *mut siginfo_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigtimedwait(
        arg1: *const sigset_t,
        arg2: *mut siginfo_t,
        arg3: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigqueue(
        arg1: pid_t,
        arg2: ::std::os::raw::c_int,
        arg3: sigval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_sigmask(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigset_t,
        arg3: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_kill(arg1: pthread_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psiginfo(arg1: *const siginfo_t, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn psignal(arg1: ::std::os::raw::c_int, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn killpg(arg1: pid_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaltstack(arg1: *const stack_t, arg2: *mut stack_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sighold(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigignore(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn siginterrupt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpause(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigrelse(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigset(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type sig_atomic_t = ::std::os::raw::c_int;
extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
extern "C" {
    pub fn raise(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_on_error_query(prg_name: *const gchar);
}
extern "C" {
    pub fn g_on_error_stack_trace(prg_name: *const gchar);
}
extern "C" {
    pub fn g_base64_encode_step(
        in_: *const guchar,
        len: gsize,
        break_lines: gboolean,
        out: *mut gchar,
        state: *mut gint,
        save: *mut gint,
    ) -> gsize;
}
extern "C" {
    pub fn g_base64_encode_close(
        break_lines: gboolean,
        out: *mut gchar,
        state: *mut gint,
        save: *mut gint,
    ) -> gsize;
}
extern "C" {
    pub fn g_base64_encode(data: *const guchar, len: gsize) -> *mut gchar;
}
extern "C" {
    pub fn g_base64_decode_step(
        in_: *const gchar,
        len: gsize,
        out: *mut guchar,
        state: *mut gint,
        save: *mut guint,
    ) -> gsize;
}
extern "C" {
    pub fn g_base64_decode(text: *const gchar, out_len: *mut gsize) -> *mut guchar;
}
extern "C" {
    pub fn g_base64_decode_inplace(text: *mut gchar, out_len: *mut gsize) -> *mut guchar;
}
extern "C" {
    pub fn g_bit_lock(address: *mut gint, lock_bit: gint);
}
extern "C" {
    pub fn g_bit_trylock(address: *mut gint, lock_bit: gint) -> gboolean;
}
extern "C" {
    pub fn g_bit_unlock(address: *mut gint, lock_bit: gint);
}
extern "C" {
    pub fn g_pointer_bit_lock(address: *mut ::std::os::raw::c_void, lock_bit: gint);
}
extern "C" {
    pub fn g_pointer_bit_trylock(address: *mut ::std::os::raw::c_void, lock_bit: gint) -> gboolean;
}
extern "C" {
    pub fn g_pointer_bit_unlock(address: *mut ::std::os::raw::c_void, lock_bit: gint);
}
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_INVALID_URI: GBookmarkFileError = 0;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_INVALID_VALUE: GBookmarkFileError = 1;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED: GBookmarkFileError = 2;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND: GBookmarkFileError = 3;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_READ: GBookmarkFileError = 4;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_UNKNOWN_ENCODING: GBookmarkFileError = 5;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_WRITE: GBookmarkFileError = 6;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_FILE_NOT_FOUND: GBookmarkFileError = 7;
pub type GBookmarkFileError = u32;
extern "C" {
    pub fn g_bookmark_file_error_quark() -> GQuark;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GBookmarkFile {
    _unused: [u8; 0],
}
pub type GBookmarkFile = _GBookmarkFile;
extern "C" {
    pub fn g_bookmark_file_new() -> *mut GBookmarkFile;
}
extern "C" {
    pub fn g_bookmark_file_free(bookmark: *mut GBookmarkFile);
}
extern "C" {
    pub fn g_bookmark_file_load_from_file(
        bookmark: *mut GBookmarkFile,
        filename: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_load_from_data(
        bookmark: *mut GBookmarkFile,
        data: *const gchar,
        length: gsize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_load_from_data_dirs(
        bookmark: *mut GBookmarkFile,
        file: *const gchar,
        full_path: *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_to_data(
        bookmark: *mut GBookmarkFile,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_to_file(
        bookmark: *mut GBookmarkFile,
        filename: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_set_title(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        title: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_title(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_set_description(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        description: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_description(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_set_mime_type(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        mime_type: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_mime_type(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_set_groups(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        groups: *mut *const gchar,
        length: gsize,
    );
}
extern "C" {
    pub fn g_bookmark_file_add_group(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        group: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_has_group(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        group: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_get_groups(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_add_application(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        name: *const gchar,
        exec: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_has_application(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        name: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_get_applications(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_set_app_info(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        name: *const gchar,
        exec: *const gchar,
        count: gint,
        stamp: time_t,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_get_app_info(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        name: *const gchar,
        exec: *mut *mut gchar,
        count: *mut guint,
        stamp: *mut time_t,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_set_is_private(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        is_private: gboolean,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_is_private(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_set_icon(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        href: *const gchar,
        mime_type: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_icon(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        href: *mut *mut gchar,
        mime_type: *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_set_added(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        added: time_t,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_added(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> time_t;
}
extern "C" {
    pub fn g_bookmark_file_set_modified(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        modified: time_t,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_modified(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> time_t;
}
extern "C" {
    pub fn g_bookmark_file_set_visited(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        visited: time_t,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_visited(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> time_t;
}
extern "C" {
    pub fn g_bookmark_file_has_item(bookmark: *mut GBookmarkFile, uri: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_get_size(bookmark: *mut GBookmarkFile) -> gint;
}
extern "C" {
    pub fn g_bookmark_file_get_uris(
        bookmark: *mut GBookmarkFile,
        length: *mut gsize,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_remove_group(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        group: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_remove_application(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        name: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_remove_item(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_move_item(
        bookmark: *mut GBookmarkFile,
        old_uri: *const gchar,
        new_uri: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bytes_new(data: gconstpointer, size: gsize) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_new_take(data: gpointer, size: gsize) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_new_static(data: gconstpointer, size: gsize) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_new_with_free_func(
        data: gconstpointer,
        size: gsize,
        free_func: GDestroyNotify,
        user_data: gpointer,
    ) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_new_from_bytes(bytes: *mut GBytes, offset: gsize, length: gsize) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_get_data(bytes: *mut GBytes, size: *mut gsize) -> gconstpointer;
}
extern "C" {
    pub fn g_bytes_get_size(bytes: *mut GBytes) -> gsize;
}
extern "C" {
    pub fn g_bytes_ref(bytes: *mut GBytes) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_unref(bytes: *mut GBytes);
}
extern "C" {
    pub fn g_bytes_unref_to_data(bytes: *mut GBytes, size: *mut gsize) -> gpointer;
}
extern "C" {
    pub fn g_bytes_unref_to_array(bytes: *mut GBytes) -> *mut GByteArray;
}
extern "C" {
    pub fn g_bytes_hash(bytes: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_bytes_equal(bytes1: gconstpointer, bytes2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_bytes_compare(bytes1: gconstpointer, bytes2: gconstpointer) -> gint;
}
extern "C" {
    pub fn g_get_charset(charset: *mut *const ::std::os::raw::c_char) -> gboolean;
}
extern "C" {
    pub fn g_get_codeset() -> *mut gchar;
}
extern "C" {
    pub fn g_get_console_charset(charset: *mut *const ::std::os::raw::c_char) -> gboolean;
}
extern "C" {
    pub fn g_get_language_names() -> *const *const gchar;
}
extern "C" {
    pub fn g_get_language_names_with_category(category_name: *const gchar) -> *const *const gchar;
}
extern "C" {
    pub fn g_get_locale_variants(locale: *const gchar) -> *mut *mut gchar;
}
pub const GChecksumType_G_CHECKSUM_MD5: GChecksumType = 0;
pub const GChecksumType_G_CHECKSUM_SHA1: GChecksumType = 1;
pub const GChecksumType_G_CHECKSUM_SHA256: GChecksumType = 2;
pub const GChecksumType_G_CHECKSUM_SHA512: GChecksumType = 3;
pub const GChecksumType_G_CHECKSUM_SHA384: GChecksumType = 4;
pub type GChecksumType = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GChecksum {
    _unused: [u8; 0],
}
pub type GChecksum = _GChecksum;
extern "C" {
    pub fn g_checksum_type_get_length(checksum_type: GChecksumType) -> gssize;
}
extern "C" {
    pub fn g_checksum_new(checksum_type: GChecksumType) -> *mut GChecksum;
}
extern "C" {
    pub fn g_checksum_reset(checksum: *mut GChecksum);
}
extern "C" {
    pub fn g_checksum_copy(checksum: *const GChecksum) -> *mut GChecksum;
}
extern "C" {
    pub fn g_checksum_free(checksum: *mut GChecksum);
}
extern "C" {
    pub fn g_checksum_update(checksum: *mut GChecksum, data: *const guchar, length: gssize);
}
extern "C" {
    pub fn g_checksum_get_string(checksum: *mut GChecksum) -> *const gchar;
}
extern "C" {
    pub fn g_checksum_get_digest(
        checksum: *mut GChecksum,
        buffer: *mut guint8,
        digest_len: *mut gsize,
    );
}
extern "C" {
    pub fn g_compute_checksum_for_data(
        checksum_type: GChecksumType,
        data: *const guchar,
        length: gsize,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_compute_checksum_for_string(
        checksum_type: GChecksumType,
        str: *const gchar,
        length: gssize,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_compute_checksum_for_bytes(
        checksum_type: GChecksumType,
        data: *mut GBytes,
    ) -> *mut gchar;
}
pub const GConvertError_G_CONVERT_ERROR_NO_CONVERSION: GConvertError = 0;
pub const GConvertError_G_CONVERT_ERROR_ILLEGAL_SEQUENCE: GConvertError = 1;
pub const GConvertError_G_CONVERT_ERROR_FAILED: GConvertError = 2;
pub const GConvertError_G_CONVERT_ERROR_PARTIAL_INPUT: GConvertError = 3;
pub const GConvertError_G_CONVERT_ERROR_BAD_URI: GConvertError = 4;
pub const GConvertError_G_CONVERT_ERROR_NOT_ABSOLUTE_PATH: GConvertError = 5;
pub const GConvertError_G_CONVERT_ERROR_NO_MEMORY: GConvertError = 6;
pub const GConvertError_G_CONVERT_ERROR_EMBEDDED_NUL: GConvertError = 7;
pub type GConvertError = u32;
extern "C" {
    pub fn g_convert_error_quark() -> GQuark;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GIConv {
    _unused: [u8; 0],
}
pub type GIConv = *mut _GIConv;
extern "C" {
    pub fn g_iconv_open(to_codeset: *const gchar, from_codeset: *const gchar) -> GIConv;
}
extern "C" {
    pub fn g_iconv(
        converter: GIConv,
        inbuf: *mut *mut gchar,
        inbytes_left: *mut gsize,
        outbuf: *mut *mut gchar,
        outbytes_left: *mut gsize,
    ) -> gsize;
}
extern "C" {
    pub fn g_iconv_close(converter: GIConv) -> gint;
}
extern "C" {
    pub fn g_convert(
        str: *const gchar,
        len: gssize,
        to_codeset: *const gchar,
        from_codeset: *const gchar,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_convert_with_iconv(
        str: *const gchar,
        len: gssize,
        converter: GIConv,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_convert_with_fallback(
        str: *const gchar,
        len: gssize,
        to_codeset: *const gchar,
        from_codeset: *const gchar,
        fallback: *const gchar,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_locale_to_utf8(
        opsysstring: *const gchar,
        len: gssize,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_locale_from_utf8(
        utf8string: *const gchar,
        len: gssize,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_filename_to_utf8(
        opsysstring: *const gchar,
        len: gssize,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_filename_from_utf8(
        utf8string: *const gchar,
        len: gssize,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_filename_from_uri(
        uri: *const gchar,
        hostname: *mut *mut gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_filename_to_uri(
        filename: *const gchar,
        hostname: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_filename_display_name(filename: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_get_filename_charsets(filename_charsets: *mut *mut *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_filename_display_basename(filename: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_uri_list_extract_uris(uri_list: *const gchar) -> *mut *mut gchar;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GData {
    _unused: [u8; 0],
}
pub type GData = _GData;
pub type GDataForeachFunc = ::std::option::Option<
    unsafe extern "C" fn(key_id: GQuark, data: gpointer, user_data: gpointer),
>;
extern "C" {
    pub fn g_datalist_init(datalist: *mut *mut GData);
}
extern "C" {
    pub fn g_datalist_clear(datalist: *mut *mut GData);
}
extern "C" {
    pub fn g_datalist_id_get_data(datalist: *mut *mut GData, key_id: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_datalist_id_set_data_full(
        datalist: *mut *mut GData,
        key_id: GQuark,
        data: gpointer,
        destroy_func: GDestroyNotify,
    );
}
pub type GDuplicateFunc =
    ::std::option::Option<unsafe extern "C" fn(data: gpointer, user_data: gpointer) -> gpointer>;
extern "C" {
    pub fn g_datalist_id_dup_data(
        datalist: *mut *mut GData,
        key_id: GQuark,
        dup_func: GDuplicateFunc,
        user_data: gpointer,
    ) -> gpointer;
}
extern "C" {
    pub fn g_datalist_id_replace_data(
        datalist: *mut *mut GData,
        key_id: GQuark,
        oldval: gpointer,
        newval: gpointer,
        destroy: GDestroyNotify,
        old_destroy: *mut GDestroyNotify,
    ) -> gboolean;
}
extern "C" {
    pub fn g_datalist_id_remove_no_notify(datalist: *mut *mut GData, key_id: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_datalist_foreach(
        datalist: *mut *mut GData,
        func: GDataForeachFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_datalist_set_flags(datalist: *mut *mut GData, flags: guint);
}
extern "C" {
    pub fn g_datalist_unset_flags(datalist: *mut *mut GData, flags: guint);
}
extern "C" {
    pub fn g_datalist_get_flags(datalist: *mut *mut GData) -> guint;
}
extern "C" {
    pub fn g_dataset_destroy(dataset_location: gconstpointer);
}
extern "C" {
    pub fn g_dataset_id_get_data(dataset_location: gconstpointer, key_id: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_datalist_get_data(datalist: *mut *mut GData, key: *const gchar) -> gpointer;
}
extern "C" {
    pub fn g_dataset_id_set_data_full(
        dataset_location: gconstpointer,
        key_id: GQuark,
        data: gpointer,
        destroy_func: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_dataset_id_remove_no_notify(
        dataset_location: gconstpointer,
        key_id: GQuark,
    ) -> gpointer;
}
extern "C" {
    pub fn g_dataset_foreach(
        dataset_location: gconstpointer,
        func: GDataForeachFunc,
        user_data: gpointer,
    );
}
pub type GTime = gint32;
pub type GDateYear = guint16;
pub type GDateDay = guint8;
pub type GDate = _GDate;
pub const GDateDMY_G_DATE_DAY: GDateDMY = 0;
pub const GDateDMY_G_DATE_MONTH: GDateDMY = 1;
pub const GDateDMY_G_DATE_YEAR: GDateDMY = 2;
pub type GDateDMY = u32;
pub const GDateWeekday_G_DATE_BAD_WEEKDAY: GDateWeekday = 0;
pub const GDateWeekday_G_DATE_MONDAY: GDateWeekday = 1;
pub const GDateWeekday_G_DATE_TUESDAY: GDateWeekday = 2;
pub const GDateWeekday_G_DATE_WEDNESDAY: GDateWeekday = 3;
pub const GDateWeekday_G_DATE_THURSDAY: GDateWeekday = 4;
pub const GDateWeekday_G_DATE_FRIDAY: GDateWeekday = 5;
pub const GDateWeekday_G_DATE_SATURDAY: GDateWeekday = 6;
pub const GDateWeekday_G_DATE_SUNDAY: GDateWeekday = 7;
pub type GDateWeekday = u32;
pub const GDateMonth_G_DATE_BAD_MONTH: GDateMonth = 0;
pub const GDateMonth_G_DATE_JANUARY: GDateMonth = 1;
pub const GDateMonth_G_DATE_FEBRUARY: GDateMonth = 2;
pub const GDateMonth_G_DATE_MARCH: GDateMonth = 3;
pub const GDateMonth_G_DATE_APRIL: GDateMonth = 4;
pub const GDateMonth_G_DATE_MAY: GDateMonth = 5;
pub const GDateMonth_G_DATE_JUNE: GDateMonth = 6;
pub const GDateMonth_G_DATE_JULY: GDateMonth = 7;
pub const GDateMonth_G_DATE_AUGUST: GDateMonth = 8;
pub const GDateMonth_G_DATE_SEPTEMBER: GDateMonth = 9;
pub const GDateMonth_G_DATE_OCTOBER: GDateMonth = 10;
pub const GDateMonth_G_DATE_NOVEMBER: GDateMonth = 11;
pub const GDateMonth_G_DATE_DECEMBER: GDateMonth = 12;
pub type GDateMonth = u32;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GDate {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize], u32>,
}
#[test]
fn bindgen_test_layout__GDate() {
    assert_eq!(
        ::std::mem::size_of::<_GDate>(),
        8usize,
        concat!("Size of: ", stringify!(_GDate))
    );
    assert_eq!(
        ::std::mem::align_of::<_GDate>(),
        4usize,
        concat!("Alignment of ", stringify!(_GDate))
    );
}
impl _GDate {
    #[inline]
    pub fn julian_days(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_julian_days(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn julian(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_julian(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dmy(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(33usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dmy(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(33usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn day(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(34usize, 6u8) as u32) }
    }
    #[inline]
    pub fn set_day(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(34usize, 6u8, val as u64)
        }
    }
    #[inline]
    pub fn month(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(40usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_month(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(40usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn year(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(44usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_year(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(44usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        julian_days: guint,
        julian: guint,
        dmy: guint,
        day: guint,
        month: guint,
        year: guint,
    ) -> __BindgenBitfieldUnit<[u8; 8usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 32u8, {
            let julian_days: u32 = unsafe { ::std::mem::transmute(julian_days) };
            julian_days as u64
        });
        __bindgen_bitfield_unit.set(32usize, 1u8, {
            let julian: u32 = unsafe { ::std::mem::transmute(julian) };
            julian as u64
        });
        __bindgen_bitfield_unit.set(33usize, 1u8, {
            let dmy: u32 = unsafe { ::std::mem::transmute(dmy) };
            dmy as u64
        });
        __bindgen_bitfield_unit.set(34usize, 6u8, {
            let day: u32 = unsafe { ::std::mem::transmute(day) };
            day as u64
        });
        __bindgen_bitfield_unit.set(40usize, 4u8, {
            let month: u32 = unsafe { ::std::mem::transmute(month) };
            month as u64
        });
        __bindgen_bitfield_unit.set(44usize, 16u8, {
            let year: u32 = unsafe { ::std::mem::transmute(year) };
            year as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn g_date_new() -> *mut GDate;
}
extern "C" {
    pub fn g_date_new_dmy(day: GDateDay, month: GDateMonth, year: GDateYear) -> *mut GDate;
}
extern "C" {
    pub fn g_date_new_julian(julian_day: guint32) -> *mut GDate;
}
extern "C" {
    pub fn g_date_free(date: *mut GDate);
}
extern "C" {
    pub fn g_date_copy(date: *const GDate) -> *mut GDate;
}
extern "C" {
    pub fn g_date_valid(date: *const GDate) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_day(day: GDateDay) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_month(month: GDateMonth) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_year(year: GDateYear) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_weekday(weekday: GDateWeekday) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_julian(julian_date: guint32) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_dmy(day: GDateDay, month: GDateMonth, year: GDateYear) -> gboolean;
}
extern "C" {
    pub fn g_date_get_weekday(date: *const GDate) -> GDateWeekday;
}
extern "C" {
    pub fn g_date_get_month(date: *const GDate) -> GDateMonth;
}
extern "C" {
    pub fn g_date_get_year(date: *const GDate) -> GDateYear;
}
extern "C" {
    pub fn g_date_get_day(date: *const GDate) -> GDateDay;
}
extern "C" {
    pub fn g_date_get_julian(date: *const GDate) -> guint32;
}
extern "C" {
    pub fn g_date_get_day_of_year(date: *const GDate) -> guint;
}
extern "C" {
    pub fn g_date_get_monday_week_of_year(date: *const GDate) -> guint;
}
extern "C" {
    pub fn g_date_get_sunday_week_of_year(date: *const GDate) -> guint;
}
extern "C" {
    pub fn g_date_get_iso8601_week_of_year(date: *const GDate) -> guint;
}
extern "C" {
    pub fn g_date_clear(date: *mut GDate, n_dates: guint);
}
extern "C" {
    pub fn g_date_set_parse(date: *mut GDate, str: *const gchar);
}
extern "C" {
    pub fn g_date_set_time_t(date: *mut GDate, timet: time_t);
}
extern "C" {
    pub fn g_date_set_time_val(date: *mut GDate, timeval: *mut GTimeVal);
}
extern "C" {
    pub fn g_date_set_time(date: *mut GDate, time_: GTime);
}
extern "C" {
    pub fn g_date_set_month(date: *mut GDate, month: GDateMonth);
}
extern "C" {
    pub fn g_date_set_day(date: *mut GDate, day: GDateDay);
}
extern "C" {
    pub fn g_date_set_year(date: *mut GDate, year: GDateYear);
}
extern "C" {
    pub fn g_date_set_dmy(date: *mut GDate, day: GDateDay, month: GDateMonth, y: GDateYear);
}
extern "C" {
    pub fn g_date_set_julian(date: *mut GDate, julian_date: guint32);
}
extern "C" {
    pub fn g_date_is_first_of_month(date: *const GDate) -> gboolean;
}
extern "C" {
    pub fn g_date_is_last_of_month(date: *const GDate) -> gboolean;
}
extern "C" {
    pub fn g_date_add_days(date: *mut GDate, n_days: guint);
}
extern "C" {
    pub fn g_date_subtract_days(date: *mut GDate, n_days: guint);
}
extern "C" {
    pub fn g_date_add_months(date: *mut GDate, n_months: guint);
}
extern "C" {
    pub fn g_date_subtract_months(date: *mut GDate, n_months: guint);
}
extern "C" {
    pub fn g_date_add_years(date: *mut GDate, n_years: guint);
}
extern "C" {
    pub fn g_date_subtract_years(date: *mut GDate, n_years: guint);
}
extern "C" {
    pub fn g_date_is_leap_year(year: GDateYear) -> gboolean;
}
extern "C" {
    pub fn g_date_get_days_in_month(month: GDateMonth, year: GDateYear) -> guint8;
}
extern "C" {
    pub fn g_date_get_monday_weeks_in_year(year: GDateYear) -> guint8;
}
extern "C" {
    pub fn g_date_get_sunday_weeks_in_year(year: GDateYear) -> guint8;
}
extern "C" {
    pub fn g_date_days_between(date1: *const GDate, date2: *const GDate) -> gint;
}
extern "C" {
    pub fn g_date_compare(lhs: *const GDate, rhs: *const GDate) -> gint;
}
extern "C" {
    pub fn g_date_to_struct_tm(date: *const GDate, tm: *mut tm);
}
extern "C" {
    pub fn g_date_clamp(date: *mut GDate, min_date: *const GDate, max_date: *const GDate);
}
extern "C" {
    pub fn g_date_order(date1: *mut GDate, date2: *mut GDate);
}
extern "C" {
    pub fn g_date_strftime(
        s: *mut gchar,
        slen: gsize,
        format: *const gchar,
        date: *const GDate,
    ) -> gsize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTimeZone {
    _unused: [u8; 0],
}
pub type GTimeZone = _GTimeZone;
pub const GTimeType_G_TIME_TYPE_STANDARD: GTimeType = 0;
pub const GTimeType_G_TIME_TYPE_DAYLIGHT: GTimeType = 1;
pub const GTimeType_G_TIME_TYPE_UNIVERSAL: GTimeType = 2;
pub type GTimeType = u32;
extern "C" {
    pub fn g_time_zone_new(identifier: *const gchar) -> *mut GTimeZone;
}
extern "C" {
    pub fn g_time_zone_new_utc() -> *mut GTimeZone;
}
extern "C" {
    pub fn g_time_zone_new_local() -> *mut GTimeZone;
}
extern "C" {
    pub fn g_time_zone_new_offset(seconds: gint32) -> *mut GTimeZone;
}
extern "C" {
    pub fn g_time_zone_ref(tz: *mut GTimeZone) -> *mut GTimeZone;
}
extern "C" {
    pub fn g_time_zone_unref(tz: *mut GTimeZone);
}
extern "C" {
    pub fn g_time_zone_find_interval(tz: *mut GTimeZone, type_: GTimeType, time_: gint64) -> gint;
}
extern "C" {
    pub fn g_time_zone_adjust_time(
        tz: *mut GTimeZone,
        type_: GTimeType,
        time_: *mut gint64,
    ) -> gint;
}
extern "C" {
    pub fn g_time_zone_get_abbreviation(tz: *mut GTimeZone, interval: gint) -> *const gchar;
}
extern "C" {
    pub fn g_time_zone_get_offset(tz: *mut GTimeZone, interval: gint) -> gint32;
}
extern "C" {
    pub fn g_time_zone_is_dst(tz: *mut GTimeZone, interval: gint) -> gboolean;
}
extern "C" {
    pub fn g_time_zone_get_identifier(tz: *mut GTimeZone) -> *const gchar;
}
pub type GTimeSpan = gint64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDateTime {
    _unused: [u8; 0],
}
pub type GDateTime = _GDateTime;
extern "C" {
    pub fn g_date_time_unref(datetime: *mut GDateTime);
}
extern "C" {
    pub fn g_date_time_ref(datetime: *mut GDateTime) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_now(tz: *mut GTimeZone) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_now_local() -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_now_utc() -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_from_unix_local(t: gint64) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_from_unix_utc(t: gint64) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_from_timeval_local(tv: *const GTimeVal) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_from_timeval_utc(tv: *const GTimeVal) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_from_iso8601(
        text: *const gchar,
        default_tz: *mut GTimeZone,
    ) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new(
        tz: *mut GTimeZone,
        year: gint,
        month: gint,
        day: gint,
        hour: gint,
        minute: gint,
        seconds: gdouble,
    ) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_local(
        year: gint,
        month: gint,
        day: gint,
        hour: gint,
        minute: gint,
        seconds: gdouble,
    ) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_utc(
        year: gint,
        month: gint,
        day: gint,
        hour: gint,
        minute: gint,
        seconds: gdouble,
    ) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add(datetime: *mut GDateTime, timespan: GTimeSpan) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_years(datetime: *mut GDateTime, years: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_months(datetime: *mut GDateTime, months: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_weeks(datetime: *mut GDateTime, weeks: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_days(datetime: *mut GDateTime, days: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_hours(datetime: *mut GDateTime, hours: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_minutes(datetime: *mut GDateTime, minutes: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_seconds(datetime: *mut GDateTime, seconds: gdouble) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_full(
        datetime: *mut GDateTime,
        years: gint,
        months: gint,
        days: gint,
        hours: gint,
        minutes: gint,
        seconds: gdouble,
    ) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_compare(dt1: gconstpointer, dt2: gconstpointer) -> gint;
}
extern "C" {
    pub fn g_date_time_difference(end: *mut GDateTime, begin: *mut GDateTime) -> GTimeSpan;
}
extern "C" {
    pub fn g_date_time_hash(datetime: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_date_time_equal(dt1: gconstpointer, dt2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_date_time_get_ymd(
        datetime: *mut GDateTime,
        year: *mut gint,
        month: *mut gint,
        day: *mut gint,
    );
}
extern "C" {
    pub fn g_date_time_get_year(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_month(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_day_of_month(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_week_numbering_year(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_week_of_year(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_day_of_week(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_day_of_year(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_hour(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_minute(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_second(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_microsecond(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_seconds(datetime: *mut GDateTime) -> gdouble;
}
extern "C" {
    pub fn g_date_time_to_unix(datetime: *mut GDateTime) -> gint64;
}
extern "C" {
    pub fn g_date_time_to_timeval(datetime: *mut GDateTime, tv: *mut GTimeVal) -> gboolean;
}
extern "C" {
    pub fn g_date_time_get_utc_offset(datetime: *mut GDateTime) -> GTimeSpan;
}
extern "C" {
    pub fn g_date_time_get_timezone(datetime: *mut GDateTime) -> *mut GTimeZone;
}
extern "C" {
    pub fn g_date_time_get_timezone_abbreviation(datetime: *mut GDateTime) -> *const gchar;
}
extern "C" {
    pub fn g_date_time_is_daylight_savings(datetime: *mut GDateTime) -> gboolean;
}
extern "C" {
    pub fn g_date_time_to_timezone(datetime: *mut GDateTime, tz: *mut GTimeZone) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_to_local(datetime: *mut GDateTime) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_to_utc(datetime: *mut GDateTime) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_format(datetime: *mut GDateTime, format: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_date_time_format_iso8601(datetime: *mut GDateTime) -> *mut gchar;
}
pub type off_t = ::std::os::raw::c_long;
pub type ino_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __dirstream {
    _unused: [u8; 0],
}
pub type DIR = __dirstream;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct dirent {
    pub d_ino: ino_t,
    pub d_off: off_t,
    pub d_reclen: ::std::os::raw::c_ushort,
    pub d_type: ::std::os::raw::c_uchar,
    pub d_name: [::std::os::raw::c_char; 256usize],
}
#[test]
fn bindgen_test_layout_dirent() {
    assert_eq!(
        ::std::mem::size_of::<dirent>(),
        280usize,
        concat!("Size of: ", stringify!(dirent))
    );
    assert_eq!(
        ::std::mem::align_of::<dirent>(),
        8usize,
        concat!("Alignment of ", stringify!(dirent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_ino as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_off as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_reclen as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_reclen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_type as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_name as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_name)
        )
    );
}
impl ::std::fmt::Debug for dirent {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "dirent {{ d_ino: {:?}, d_off: {:?}, d_reclen: {:?}, d_type: {:?}, d_name: [{}] }}",
            self.d_ino,
            self.d_off,
            self.d_reclen,
            self.d_type,
            self.d_name
                .iter()
                .enumerate()
                .map(|(i, v)| format!("{}{:?}", if i > 0 { ", " } else { "" }, v))
                .collect::<String>()
        )
    }
}
impl ::std::cmp::PartialEq for dirent {
    fn eq(&self, other: &dirent) -> bool {
        self.d_ino == other.d_ino
            && self.d_off == other.d_off
            && self.d_reclen == other.d_reclen
            && self.d_type == other.d_type
            && &self.d_name[..] == &other.d_name[..]
    }
}
extern "C" {
    pub fn closedir(arg1: *mut DIR) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fdopendir(arg1: ::std::os::raw::c_int) -> *mut DIR;
}
extern "C" {
    pub fn opendir(arg1: *const ::std::os::raw::c_char) -> *mut DIR;
}
extern "C" {
    pub fn readdir(arg1: *mut DIR) -> *mut dirent;
}
extern "C" {
    pub fn readdir_r(
        arg1: *mut DIR,
        arg2: *mut dirent,
        arg3: *mut *mut dirent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rewinddir(arg1: *mut DIR);
}
extern "C" {
    pub fn dirfd(arg1: *mut DIR) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn alphasort(arg1: *mut *const dirent, arg2: *mut *const dirent) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scandir(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut *mut dirent,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const dirent) -> ::std::os::raw::c_int,
        >,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut *const dirent,
                arg2: *mut *const dirent,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seekdir(arg1: *mut DIR, arg2: ::std::os::raw::c_long);
}
extern "C" {
    pub fn telldir(arg1: *mut DIR) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn getdents(
        arg1: ::std::os::raw::c_int,
        arg2: *mut dirent,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDir {
    _unused: [u8; 0],
}
pub type GDir = _GDir;
extern "C" {
    pub fn g_dir_open(path: *const gchar, flags: guint, error: *mut *mut GError) -> *mut GDir;
}
extern "C" {
    pub fn g_dir_read_name(dir: *mut GDir) -> *const gchar;
}
extern "C" {
    pub fn g_dir_rewind(dir: *mut GDir);
}
extern "C" {
    pub fn g_dir_close(dir: *mut GDir);
}
extern "C" {
    pub fn g_getenv(variable: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_setenv(variable: *const gchar, value: *const gchar, overwrite: gboolean) -> gboolean;
}
extern "C" {
    pub fn g_unsetenv(variable: *const gchar);
}
extern "C" {
    pub fn g_listenv() -> *mut *mut gchar;
}
extern "C" {
    pub fn g_get_environ() -> *mut *mut gchar;
}
extern "C" {
    pub fn g_environ_getenv(envp: *mut *mut gchar, variable: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_environ_setenv(
        envp: *mut *mut gchar,
        variable: *const gchar,
        value: *const gchar,
        overwrite: gboolean,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_environ_unsetenv(envp: *mut *mut gchar, variable: *const gchar) -> *mut *mut gchar;
}
pub const GFileError_G_FILE_ERROR_EXIST: GFileError = 0;
pub const GFileError_G_FILE_ERROR_ISDIR: GFileError = 1;
pub const GFileError_G_FILE_ERROR_ACCES: GFileError = 2;
pub const GFileError_G_FILE_ERROR_NAMETOOLONG: GFileError = 3;
pub const GFileError_G_FILE_ERROR_NOENT: GFileError = 4;
pub const GFileError_G_FILE_ERROR_NOTDIR: GFileError = 5;
pub const GFileError_G_FILE_ERROR_NXIO: GFileError = 6;
pub const GFileError_G_FILE_ERROR_NODEV: GFileError = 7;
pub const GFileError_G_FILE_ERROR_ROFS: GFileError = 8;
pub const GFileError_G_FILE_ERROR_TXTBSY: GFileError = 9;
pub const GFileError_G_FILE_ERROR_FAULT: GFileError = 10;
pub const GFileError_G_FILE_ERROR_LOOP: GFileError = 11;
pub const GFileError_G_FILE_ERROR_NOSPC: GFileError = 12;
pub const GFileError_G_FILE_ERROR_NOMEM: GFileError = 13;
pub const GFileError_G_FILE_ERROR_MFILE: GFileError = 14;
pub const GFileError_G_FILE_ERROR_NFILE: GFileError = 15;
pub const GFileError_G_FILE_ERROR_BADF: GFileError = 16;
pub const GFileError_G_FILE_ERROR_INVAL: GFileError = 17;
pub const GFileError_G_FILE_ERROR_PIPE: GFileError = 18;
pub const GFileError_G_FILE_ERROR_AGAIN: GFileError = 19;
pub const GFileError_G_FILE_ERROR_INTR: GFileError = 20;
pub const GFileError_G_FILE_ERROR_IO: GFileError = 21;
pub const GFileError_G_FILE_ERROR_PERM: GFileError = 22;
pub const GFileError_G_FILE_ERROR_NOSYS: GFileError = 23;
pub const GFileError_G_FILE_ERROR_FAILED: GFileError = 24;
pub type GFileError = u32;
pub const GFileTest_G_FILE_TEST_IS_REGULAR: GFileTest = 1;
pub const GFileTest_G_FILE_TEST_IS_SYMLINK: GFileTest = 2;
pub const GFileTest_G_FILE_TEST_IS_DIR: GFileTest = 4;
pub const GFileTest_G_FILE_TEST_IS_EXECUTABLE: GFileTest = 8;
pub const GFileTest_G_FILE_TEST_EXISTS: GFileTest = 16;
pub type GFileTest = u32;
extern "C" {
    pub fn g_file_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_file_error_from_errno(err_no: gint) -> GFileError;
}
extern "C" {
    pub fn g_file_test(filename: *const gchar, test: GFileTest) -> gboolean;
}
extern "C" {
    pub fn g_file_get_contents(
        filename: *const gchar,
        contents: *mut *mut gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_file_set_contents(
        filename: *const gchar,
        contents: *const gchar,
        length: gssize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_file_read_link(filename: *const gchar, error: *mut *mut GError) -> *mut gchar;
}
extern "C" {
    pub fn g_mkdtemp(tmpl: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_mkdtemp_full(tmpl: *mut gchar, mode: gint) -> *mut gchar;
}
extern "C" {
    pub fn g_mkstemp(tmpl: *mut gchar) -> gint;
}
extern "C" {
    pub fn g_mkstemp_full(tmpl: *mut gchar, flags: gint, mode: gint) -> gint;
}
extern "C" {
    pub fn g_file_open_tmp(
        tmpl: *const gchar,
        name_used: *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gint;
}
extern "C" {
    pub fn g_dir_make_tmp(tmpl: *const gchar, error: *mut *mut GError) -> *mut gchar;
}
extern "C" {
    pub fn g_build_path(separator: *const gchar, first_element: *const gchar, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_build_pathv(separator: *const gchar, args: *mut *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_build_filename(first_element: *const gchar, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_build_filenamev(args: *mut *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_build_filename_valist(first_element: *const gchar, args: *mut va_list) -> *mut gchar;
}
extern "C" {
    pub fn g_mkdir_with_parents(pathname: *const gchar, mode: gint) -> gint;
}
extern "C" {
    pub fn g_path_is_absolute(file_name: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_path_skip_root(file_name: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_basename(file_name: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_get_current_dir() -> *mut gchar;
}
extern "C" {
    pub fn g_path_get_basename(file_name: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_path_get_dirname(file_name: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_canonicalize_filename(filename: *const gchar, relative_to: *const gchar)
        -> *mut gchar;
}
extern "C" {
    pub fn g_strip_context(msgid: *const gchar, msgval: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_dgettext(domain: *const gchar, msgid: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_dcgettext(domain: *const gchar, msgid: *const gchar, category: gint) -> *const gchar;
}
extern "C" {
    pub fn g_dngettext(
        domain: *const gchar,
        msgid: *const gchar,
        msgid_plural: *const gchar,
        n: gulong,
    ) -> *const gchar;
}
extern "C" {
    pub fn g_dpgettext(
        domain: *const gchar,
        msgctxtid: *const gchar,
        msgidoffset: gsize,
    ) -> *const gchar;
}
extern "C" {
    pub fn g_dpgettext2(
        domain: *const gchar,
        context: *const gchar,
        msgid: *const gchar,
    ) -> *const gchar;
}
pub type GMemVTable = _GMemVTable;
extern "C" {
    pub fn g_free(mem: gpointer);
}
extern "C" {
    pub fn g_clear_pointer(pp: *mut gpointer, destroy: GDestroyNotify);
}
extern "C" {
    pub fn g_malloc(n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_malloc0(n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_realloc(mem: gpointer, n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_malloc(n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_malloc0(n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_realloc(mem: gpointer, n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_malloc_n(n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_malloc0_n(n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_realloc_n(mem: gpointer, n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_malloc_n(n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_malloc0_n(n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_realloc_n(mem: gpointer, n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GMemVTable {
    pub malloc: ::std::option::Option<unsafe extern "C" fn(n_bytes: gsize) -> gpointer>,
    pub realloc:
        ::std::option::Option<unsafe extern "C" fn(mem: gpointer, n_bytes: gsize) -> gpointer>,
    pub free: ::std::option::Option<unsafe extern "C" fn(mem: gpointer)>,
    pub calloc: ::std::option::Option<
        unsafe extern "C" fn(n_blocks: gsize, n_block_bytes: gsize) -> gpointer,
    >,
    pub try_malloc: ::std::option::Option<unsafe extern "C" fn(n_bytes: gsize) -> gpointer>,
    pub try_realloc:
        ::std::option::Option<unsafe extern "C" fn(mem: gpointer, n_bytes: gsize) -> gpointer>,
}
#[test]
fn bindgen_test_layout__GMemVTable() {
    assert_eq!(
        ::std::mem::size_of::<_GMemVTable>(),
        48usize,
        concat!("Size of: ", stringify!(_GMemVTable))
    );
    assert_eq!(
        ::std::mem::align_of::<_GMemVTable>(),
        8usize,
        concat!("Alignment of ", stringify!(_GMemVTable))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMemVTable>())).malloc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMemVTable),
            "::",
            stringify!(malloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMemVTable>())).realloc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMemVTable),
            "::",
            stringify!(realloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMemVTable>())).free as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMemVTable),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMemVTable>())).calloc as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMemVTable),
            "::",
            stringify!(calloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMemVTable>())).try_malloc as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMemVTable),
            "::",
            stringify!(try_malloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMemVTable>())).try_realloc as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMemVTable),
            "::",
            stringify!(try_realloc)
        )
    );
}
extern "C" {
    pub fn g_mem_set_vtable(vtable: *mut GMemVTable);
}
extern "C" {
    pub fn g_mem_is_system_malloc() -> gboolean;
}
extern "C" {
    pub static mut g_mem_gc_friendly: gboolean;
}
extern "C" {
    pub static mut glib_mem_profiler_table: *mut GMemVTable;
}
extern "C" {
    pub fn g_mem_profile();
}
pub type GNode = _GNode;
pub const GTraverseFlags_G_TRAVERSE_LEAVES: GTraverseFlags = 1;
pub const GTraverseFlags_G_TRAVERSE_NON_LEAVES: GTraverseFlags = 2;
pub const GTraverseFlags_G_TRAVERSE_ALL: GTraverseFlags = 3;
pub const GTraverseFlags_G_TRAVERSE_MASK: GTraverseFlags = 3;
pub const GTraverseFlags_G_TRAVERSE_LEAFS: GTraverseFlags = 1;
pub const GTraverseFlags_G_TRAVERSE_NON_LEAFS: GTraverseFlags = 2;
pub type GTraverseFlags = u32;
pub const GTraverseType_G_IN_ORDER: GTraverseType = 0;
pub const GTraverseType_G_PRE_ORDER: GTraverseType = 1;
pub const GTraverseType_G_POST_ORDER: GTraverseType = 2;
pub const GTraverseType_G_LEVEL_ORDER: GTraverseType = 3;
pub type GTraverseType = u32;
pub type GNodeTraverseFunc =
    ::std::option::Option<unsafe extern "C" fn(node: *mut GNode, data: gpointer) -> gboolean>;
pub type GNodeForeachFunc =
    ::std::option::Option<unsafe extern "C" fn(node: *mut GNode, data: gpointer)>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GNode {
    pub data: gpointer,
    pub next: *mut GNode,
    pub prev: *mut GNode,
    pub parent: *mut GNode,
    pub children: *mut GNode,
}
#[test]
fn bindgen_test_layout__GNode() {
    assert_eq!(
        ::std::mem::size_of::<_GNode>(),
        40usize,
        concat!("Size of: ", stringify!(_GNode))
    );
    assert_eq!(
        ::std::mem::align_of::<_GNode>(),
        8usize,
        concat!("Alignment of ", stringify!(_GNode))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GNode>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GNode),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GNode>())).next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GNode),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GNode>())).prev as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GNode),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GNode>())).parent as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GNode),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GNode>())).children as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GNode),
            "::",
            stringify!(children)
        )
    );
}
extern "C" {
    pub fn g_node_new(data: gpointer) -> *mut GNode;
}
extern "C" {
    pub fn g_node_destroy(root: *mut GNode);
}
extern "C" {
    pub fn g_node_unlink(node: *mut GNode);
}
extern "C" {
    pub fn g_node_copy_deep(node: *mut GNode, copy_func: GCopyFunc, data: gpointer) -> *mut GNode;
}
extern "C" {
    pub fn g_node_copy(node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_insert(parent: *mut GNode, position: gint, node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_insert_before(
        parent: *mut GNode,
        sibling: *mut GNode,
        node: *mut GNode,
    ) -> *mut GNode;
}
extern "C" {
    pub fn g_node_insert_after(
        parent: *mut GNode,
        sibling: *mut GNode,
        node: *mut GNode,
    ) -> *mut GNode;
}
extern "C" {
    pub fn g_node_prepend(parent: *mut GNode, node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_n_nodes(root: *mut GNode, flags: GTraverseFlags) -> guint;
}
extern "C" {
    pub fn g_node_get_root(node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_is_ancestor(node: *mut GNode, descendant: *mut GNode) -> gboolean;
}
extern "C" {
    pub fn g_node_depth(node: *mut GNode) -> guint;
}
extern "C" {
    pub fn g_node_find(
        root: *mut GNode,
        order: GTraverseType,
        flags: GTraverseFlags,
        data: gpointer,
    ) -> *mut GNode;
}
extern "C" {
    pub fn g_node_traverse(
        root: *mut GNode,
        order: GTraverseType,
        flags: GTraverseFlags,
        max_depth: gint,
        func: GNodeTraverseFunc,
        data: gpointer,
    );
}
extern "C" {
    pub fn g_node_max_height(root: *mut GNode) -> guint;
}
extern "C" {
    pub fn g_node_children_foreach(
        node: *mut GNode,
        flags: GTraverseFlags,
        func: GNodeForeachFunc,
        data: gpointer,
    );
}
extern "C" {
    pub fn g_node_reverse_children(node: *mut GNode);
}
extern "C" {
    pub fn g_node_n_children(node: *mut GNode) -> guint;
}
extern "C" {
    pub fn g_node_nth_child(node: *mut GNode, n: guint) -> *mut GNode;
}
extern "C" {
    pub fn g_node_last_child(node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_find_child(node: *mut GNode, flags: GTraverseFlags, data: gpointer)
        -> *mut GNode;
}
extern "C" {
    pub fn g_node_child_position(node: *mut GNode, child: *mut GNode) -> gint;
}
extern "C" {
    pub fn g_node_child_index(node: *mut GNode, data: gpointer) -> gint;
}
extern "C" {
    pub fn g_node_first_sibling(node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_last_sibling(node: *mut GNode) -> *mut GNode;
}
pub type GList = _GList;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GList {
    pub data: gpointer,
    pub next: *mut GList,
    pub prev: *mut GList,
}
#[test]
fn bindgen_test_layout__GList() {
    assert_eq!(
        ::std::mem::size_of::<_GList>(),
        24usize,
        concat!("Size of: ", stringify!(_GList))
    );
    assert_eq!(
        ::std::mem::align_of::<_GList>(),
        8usize,
        concat!("Alignment of ", stringify!(_GList))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GList>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GList),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GList>())).next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GList),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GList>())).prev as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GList),
            "::",
            stringify!(prev)
        )
    );
}
extern "C" {
    pub fn g_list_alloc() -> *mut GList;
}
extern "C" {
    pub fn g_list_free(list: *mut GList);
}
extern "C" {
    pub fn g_list_free_1(list: *mut GList);
}
extern "C" {
    pub fn g_list_free_full(list: *mut GList, free_func: GDestroyNotify);
}
extern "C" {
    pub fn g_list_append(list: *mut GList, data: gpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_prepend(list: *mut GList, data: gpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_insert(list: *mut GList, data: gpointer, position: gint) -> *mut GList;
}
extern "C" {
    pub fn g_list_insert_sorted(list: *mut GList, data: gpointer, func: GCompareFunc)
        -> *mut GList;
}
extern "C" {
    pub fn g_list_insert_sorted_with_data(
        list: *mut GList,
        data: gpointer,
        func: GCompareDataFunc,
        user_data: gpointer,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_list_insert_before(
        list: *mut GList,
        sibling: *mut GList,
        data: gpointer,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_list_insert_before_link(
        list: *mut GList,
        sibling: *mut GList,
        link_: *mut GList,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_list_concat(list1: *mut GList, list2: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_remove(list: *mut GList, data: gconstpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_remove_all(list: *mut GList, data: gconstpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_remove_link(list: *mut GList, llink: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_delete_link(list: *mut GList, link_: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_reverse(list: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_copy(list: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_copy_deep(list: *mut GList, func: GCopyFunc, user_data: gpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_nth(list: *mut GList, n: guint) -> *mut GList;
}
extern "C" {
    pub fn g_list_nth_prev(list: *mut GList, n: guint) -> *mut GList;
}
extern "C" {
    pub fn g_list_find(list: *mut GList, data: gconstpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_find_custom(
        list: *mut GList,
        data: gconstpointer,
        func: GCompareFunc,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_list_position(list: *mut GList, llink: *mut GList) -> gint;
}
extern "C" {
    pub fn g_list_index(list: *mut GList, data: gconstpointer) -> gint;
}
extern "C" {
    pub fn g_list_last(list: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_first(list: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_length(list: *mut GList) -> guint;
}
extern "C" {
    pub fn g_list_foreach(list: *mut GList, func: GFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_list_sort(list: *mut GList, compare_func: GCompareFunc) -> *mut GList;
}
extern "C" {
    pub fn g_list_sort_with_data(
        list: *mut GList,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_list_nth_data(list: *mut GList, n: guint) -> gpointer;
}
extern "C" {
    pub fn g_clear_list(list_ptr: *mut *mut GList, destroy: GDestroyNotify);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GHashTable {
    _unused: [u8; 0],
}
pub type GHashTable = _GHashTable;
pub type GHRFunc = ::std::option::Option<
    unsafe extern "C" fn(key: gpointer, value: gpointer, user_data: gpointer) -> gboolean,
>;
pub type GHashTableIter = _GHashTableIter;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GHashTableIter {
    pub dummy1: gpointer,
    pub dummy2: gpointer,
    pub dummy3: gpointer,
    pub dummy4: ::std::os::raw::c_int,
    pub dummy5: gboolean,
    pub dummy6: gpointer,
}
#[test]
fn bindgen_test_layout__GHashTableIter() {
    assert_eq!(
        ::std::mem::size_of::<_GHashTableIter>(),
        40usize,
        concat!("Size of: ", stringify!(_GHashTableIter))
    );
    assert_eq!(
        ::std::mem::align_of::<_GHashTableIter>(),
        8usize,
        concat!("Alignment of ", stringify!(_GHashTableIter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHashTableIter>())).dummy1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHashTableIter),
            "::",
            stringify!(dummy1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHashTableIter>())).dummy2 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHashTableIter),
            "::",
            stringify!(dummy2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHashTableIter>())).dummy3 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHashTableIter),
            "::",
            stringify!(dummy3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHashTableIter>())).dummy4 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHashTableIter),
            "::",
            stringify!(dummy4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHashTableIter>())).dummy5 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHashTableIter),
            "::",
            stringify!(dummy5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHashTableIter>())).dummy6 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHashTableIter),
            "::",
            stringify!(dummy6)
        )
    );
}
extern "C" {
    pub fn g_hash_table_new(hash_func: GHashFunc, key_equal_func: GEqualFunc) -> *mut GHashTable;
}
extern "C" {
    pub fn g_hash_table_new_full(
        hash_func: GHashFunc,
        key_equal_func: GEqualFunc,
        key_destroy_func: GDestroyNotify,
        value_destroy_func: GDestroyNotify,
    ) -> *mut GHashTable;
}
extern "C" {
    pub fn g_hash_table_destroy(hash_table: *mut GHashTable);
}
extern "C" {
    pub fn g_hash_table_insert(
        hash_table: *mut GHashTable,
        key: gpointer,
        value: gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_replace(
        hash_table: *mut GHashTable,
        key: gpointer,
        value: gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_add(hash_table: *mut GHashTable, key: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_remove(hash_table: *mut GHashTable, key: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_remove_all(hash_table: *mut GHashTable);
}
extern "C" {
    pub fn g_hash_table_steal(hash_table: *mut GHashTable, key: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_steal_extended(
        hash_table: *mut GHashTable,
        lookup_key: gconstpointer,
        stolen_key: *mut gpointer,
        stolen_value: *mut gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_steal_all(hash_table: *mut GHashTable);
}
extern "C" {
    pub fn g_hash_table_lookup(hash_table: *mut GHashTable, key: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_hash_table_contains(hash_table: *mut GHashTable, key: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_lookup_extended(
        hash_table: *mut GHashTable,
        lookup_key: gconstpointer,
        orig_key: *mut gpointer,
        value: *mut gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_foreach(hash_table: *mut GHashTable, func: GHFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_hash_table_find(
        hash_table: *mut GHashTable,
        predicate: GHRFunc,
        user_data: gpointer,
    ) -> gpointer;
}
extern "C" {
    pub fn g_hash_table_foreach_remove(
        hash_table: *mut GHashTable,
        func: GHRFunc,
        user_data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_hash_table_foreach_steal(
        hash_table: *mut GHashTable,
        func: GHRFunc,
        user_data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_hash_table_size(hash_table: *mut GHashTable) -> guint;
}
extern "C" {
    pub fn g_hash_table_get_keys(hash_table: *mut GHashTable) -> *mut GList;
}
extern "C" {
    pub fn g_hash_table_get_values(hash_table: *mut GHashTable) -> *mut GList;
}
extern "C" {
    pub fn g_hash_table_get_keys_as_array(
        hash_table: *mut GHashTable,
        length: *mut guint,
    ) -> *mut gpointer;
}
extern "C" {
    pub fn g_hash_table_iter_init(iter: *mut GHashTableIter, hash_table: *mut GHashTable);
}
extern "C" {
    pub fn g_hash_table_iter_next(
        iter: *mut GHashTableIter,
        key: *mut gpointer,
        value: *mut gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_iter_get_hash_table(iter: *mut GHashTableIter) -> *mut GHashTable;
}
extern "C" {
    pub fn g_hash_table_iter_remove(iter: *mut GHashTableIter);
}
extern "C" {
    pub fn g_hash_table_iter_replace(iter: *mut GHashTableIter, value: gpointer);
}
extern "C" {
    pub fn g_hash_table_iter_steal(iter: *mut GHashTableIter);
}
extern "C" {
    pub fn g_hash_table_ref(hash_table: *mut GHashTable) -> *mut GHashTable;
}
extern "C" {
    pub fn g_hash_table_unref(hash_table: *mut GHashTable);
}
extern "C" {
    pub fn g_str_equal(v1: gconstpointer, v2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_str_hash(v: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_int_equal(v1: gconstpointer, v2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_int_hash(v: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_int64_equal(v1: gconstpointer, v2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_int64_hash(v: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_double_equal(v1: gconstpointer, v2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_double_hash(v: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_direct_hash(v: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_direct_equal(v1: gconstpointer, v2: gconstpointer) -> gboolean;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GHmac {
    _unused: [u8; 0],
}
pub type GHmac = _GHmac;
extern "C" {
    pub fn g_hmac_new(digest_type: GChecksumType, key: *const guchar, key_len: gsize)
        -> *mut GHmac;
}
extern "C" {
    pub fn g_hmac_copy(hmac: *const GHmac) -> *mut GHmac;
}
extern "C" {
    pub fn g_hmac_ref(hmac: *mut GHmac) -> *mut GHmac;
}
extern "C" {
    pub fn g_hmac_unref(hmac: *mut GHmac);
}
extern "C" {
    pub fn g_hmac_update(hmac: *mut GHmac, data: *const guchar, length: gssize);
}
extern "C" {
    pub fn g_hmac_get_string(hmac: *mut GHmac) -> *const gchar;
}
extern "C" {
    pub fn g_hmac_get_digest(hmac: *mut GHmac, buffer: *mut guint8, digest_len: *mut gsize);
}
extern "C" {
    pub fn g_compute_hmac_for_data(
        digest_type: GChecksumType,
        key: *const guchar,
        key_len: gsize,
        data: *const guchar,
        length: gsize,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_compute_hmac_for_string(
        digest_type: GChecksumType,
        key: *const guchar,
        key_len: gsize,
        str: *const gchar,
        length: gssize,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_compute_hmac_for_bytes(
        digest_type: GChecksumType,
        key: *mut GBytes,
        data: *mut GBytes,
    ) -> *mut gchar;
}
pub type GHook = _GHook;
pub type GHookList = _GHookList;
pub type GHookCompareFunc =
    ::std::option::Option<unsafe extern "C" fn(new_hook: *mut GHook, sibling: *mut GHook) -> gint>;
pub type GHookFindFunc =
    ::std::option::Option<unsafe extern "C" fn(hook: *mut GHook, data: gpointer) -> gboolean>;
pub type GHookMarshaller =
    ::std::option::Option<unsafe extern "C" fn(hook: *mut GHook, marshal_data: gpointer)>;
pub type GHookCheckMarshaller = ::std::option::Option<
    unsafe extern "C" fn(hook: *mut GHook, marshal_data: gpointer) -> gboolean,
>;
pub type GHookFunc = ::std::option::Option<unsafe extern "C" fn(data: gpointer)>;
pub type GHookCheckFunc = ::std::option::Option<unsafe extern "C" fn(data: gpointer) -> gboolean>;
pub type GHookFinalizeFunc =
    ::std::option::Option<unsafe extern "C" fn(hook_list: *mut GHookList, hook: *mut GHook)>;
pub const GHookFlagMask_G_HOOK_FLAG_ACTIVE: GHookFlagMask = 1;
pub const GHookFlagMask_G_HOOK_FLAG_IN_CALL: GHookFlagMask = 2;
pub const GHookFlagMask_G_HOOK_FLAG_MASK: GHookFlagMask = 15;
pub type GHookFlagMask = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GHookList {
    pub seq_id: gulong,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u16>,
    pub hooks: *mut GHook,
    pub dummy3: gpointer,
    pub finalize_hook: GHookFinalizeFunc,
    pub dummy: [gpointer; 2usize],
}
#[test]
fn bindgen_test_layout__GHookList() {
    assert_eq!(
        ::std::mem::size_of::<_GHookList>(),
        56usize,
        concat!("Size of: ", stringify!(_GHookList))
    );
    assert_eq!(
        ::std::mem::align_of::<_GHookList>(),
        8usize,
        concat!("Alignment of ", stringify!(_GHookList))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHookList>())).seq_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHookList),
            "::",
            stringify!(seq_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHookList>())).hooks as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHookList),
            "::",
            stringify!(hooks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHookList>())).dummy3 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHookList),
            "::",
            stringify!(dummy3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHookList>())).finalize_hook as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHookList),
            "::",
            stringify!(finalize_hook)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHookList>())).dummy as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHookList),
            "::",
            stringify!(dummy)
        )
    );
}
impl _GHookList {
    #[inline]
    pub fn hook_size(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_hook_size(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn is_setup(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_setup(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        hook_size: guint,
        is_setup: guint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u16> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u16> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let hook_size: u32 = unsafe { ::std::mem::transmute(hook_size) };
            hook_size as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let is_setup: u32 = unsafe { ::std::mem::transmute(is_setup) };
            is_setup as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GHook {
    pub data: gpointer,
    pub next: *mut GHook,
    pub prev: *mut GHook,
    pub ref_count: guint,
    pub hook_id: gulong,
    pub flags: guint,
    pub func: gpointer,
    pub destroy: GDestroyNotify,
}
#[test]
fn bindgen_test_layout__GHook() {
    assert_eq!(
        ::std::mem::size_of::<_GHook>(),
        64usize,
        concat!("Size of: ", stringify!(_GHook))
    );
    assert_eq!(
        ::std::mem::align_of::<_GHook>(),
        8usize,
        concat!("Alignment of ", stringify!(_GHook))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHook>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHook),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHook>())).next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHook),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHook>())).prev as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHook),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHook>())).ref_count as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHook),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHook>())).hook_id as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHook),
            "::",
            stringify!(hook_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHook>())).flags as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHook),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHook>())).func as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHook),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GHook>())).destroy as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GHook),
            "::",
            stringify!(destroy)
        )
    );
}
extern "C" {
    pub fn g_hook_list_init(hook_list: *mut GHookList, hook_size: guint);
}
extern "C" {
    pub fn g_hook_list_clear(hook_list: *mut GHookList);
}
extern "C" {
    pub fn g_hook_alloc(hook_list: *mut GHookList) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_free(hook_list: *mut GHookList, hook: *mut GHook);
}
extern "C" {
    pub fn g_hook_ref(hook_list: *mut GHookList, hook: *mut GHook) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_unref(hook_list: *mut GHookList, hook: *mut GHook);
}
extern "C" {
    pub fn g_hook_destroy(hook_list: *mut GHookList, hook_id: gulong) -> gboolean;
}
extern "C" {
    pub fn g_hook_destroy_link(hook_list: *mut GHookList, hook: *mut GHook);
}
extern "C" {
    pub fn g_hook_prepend(hook_list: *mut GHookList, hook: *mut GHook);
}
extern "C" {
    pub fn g_hook_insert_before(hook_list: *mut GHookList, sibling: *mut GHook, hook: *mut GHook);
}
extern "C" {
    pub fn g_hook_insert_sorted(
        hook_list: *mut GHookList,
        hook: *mut GHook,
        func: GHookCompareFunc,
    );
}
extern "C" {
    pub fn g_hook_get(hook_list: *mut GHookList, hook_id: gulong) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_find(
        hook_list: *mut GHookList,
        need_valids: gboolean,
        func: GHookFindFunc,
        data: gpointer,
    ) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_find_data(
        hook_list: *mut GHookList,
        need_valids: gboolean,
        data: gpointer,
    ) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_find_func(
        hook_list: *mut GHookList,
        need_valids: gboolean,
        func: gpointer,
    ) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_find_func_data(
        hook_list: *mut GHookList,
        need_valids: gboolean,
        func: gpointer,
        data: gpointer,
    ) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_first_valid(hook_list: *mut GHookList, may_be_in_call: gboolean) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_next_valid(
        hook_list: *mut GHookList,
        hook: *mut GHook,
        may_be_in_call: gboolean,
    ) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_compare_ids(new_hook: *mut GHook, sibling: *mut GHook) -> gint;
}
extern "C" {
    pub fn g_hook_list_invoke(hook_list: *mut GHookList, may_recurse: gboolean);
}
extern "C" {
    pub fn g_hook_list_invoke_check(hook_list: *mut GHookList, may_recurse: gboolean);
}
extern "C" {
    pub fn g_hook_list_marshal(
        hook_list: *mut GHookList,
        may_recurse: gboolean,
        marshaller: GHookMarshaller,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_hook_list_marshal_check(
        hook_list: *mut GHookList,
        may_recurse: gboolean,
        marshaller: GHookCheckMarshaller,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_hostname_is_non_ascii(hostname: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_hostname_is_ascii_encoded(hostname: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_hostname_is_ip_address(hostname: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_hostname_to_ascii(hostname: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_hostname_to_unicode(hostname: *const gchar) -> *mut gchar;
}
pub type GPollFD = _GPollFD;
pub type GPollFunc = ::std::option::Option<
    unsafe extern "C" fn(ufds: *mut GPollFD, nfsd: guint, timeout_: gint) -> gint,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GPollFD {
    pub fd: gint,
    pub events: gushort,
    pub revents: gushort,
}
#[test]
fn bindgen_test_layout__GPollFD() {
    assert_eq!(
        ::std::mem::size_of::<_GPollFD>(),
        8usize,
        concat!("Size of: ", stringify!(_GPollFD))
    );
    assert_eq!(
        ::std::mem::align_of::<_GPollFD>(),
        4usize,
        concat!("Alignment of ", stringify!(_GPollFD))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GPollFD>())).fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GPollFD),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GPollFD>())).events as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_GPollFD),
            "::",
            stringify!(events)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GPollFD>())).revents as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_GPollFD),
            "::",
            stringify!(revents)
        )
    );
}
extern "C" {
    pub fn g_poll(fds: *mut GPollFD, nfds: guint, timeout: gint) -> gint;
}
pub type GSList = _GSList;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GSList {
    pub data: gpointer,
    pub next: *mut GSList,
}
#[test]
fn bindgen_test_layout__GSList() {
    assert_eq!(
        ::std::mem::size_of::<_GSList>(),
        16usize,
        concat!("Size of: ", stringify!(_GSList))
    );
    assert_eq!(
        ::std::mem::align_of::<_GSList>(),
        8usize,
        concat!("Alignment of ", stringify!(_GSList))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSList>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSList),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSList>())).next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSList),
            "::",
            stringify!(next)
        )
    );
}
extern "C" {
    pub fn g_slist_alloc() -> *mut GSList;
}
extern "C" {
    pub fn g_slist_free(list: *mut GSList);
}
extern "C" {
    pub fn g_slist_free_1(list: *mut GSList);
}
extern "C" {
    pub fn g_slist_free_full(list: *mut GSList, free_func: GDestroyNotify);
}
extern "C" {
    pub fn g_slist_append(list: *mut GSList, data: gpointer) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_prepend(list: *mut GSList, data: gpointer) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_insert(list: *mut GSList, data: gpointer, position: gint) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_insert_sorted(
        list: *mut GSList,
        data: gpointer,
        func: GCompareFunc,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_insert_sorted_with_data(
        list: *mut GSList,
        data: gpointer,
        func: GCompareDataFunc,
        user_data: gpointer,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_insert_before(
        slist: *mut GSList,
        sibling: *mut GSList,
        data: gpointer,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_concat(list1: *mut GSList, list2: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_remove(list: *mut GSList, data: gconstpointer) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_remove_all(list: *mut GSList, data: gconstpointer) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_remove_link(list: *mut GSList, link_: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_delete_link(list: *mut GSList, link_: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_reverse(list: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_copy(list: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_copy_deep(
        list: *mut GSList,
        func: GCopyFunc,
        user_data: gpointer,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_nth(list: *mut GSList, n: guint) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_find(list: *mut GSList, data: gconstpointer) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_find_custom(
        list: *mut GSList,
        data: gconstpointer,
        func: GCompareFunc,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_position(list: *mut GSList, llink: *mut GSList) -> gint;
}
extern "C" {
    pub fn g_slist_index(list: *mut GSList, data: gconstpointer) -> gint;
}
extern "C" {
    pub fn g_slist_last(list: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_length(list: *mut GSList) -> guint;
}
extern "C" {
    pub fn g_slist_foreach(list: *mut GSList, func: GFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_slist_sort(list: *mut GSList, compare_func: GCompareFunc) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_sort_with_data(
        list: *mut GSList,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_nth_data(list: *mut GSList, n: guint) -> gpointer;
}
extern "C" {
    pub fn g_clear_slist(slist_ptr: *mut *mut GSList, destroy: GDestroyNotify);
}
pub const GIOCondition_G_IO_IN: GIOCondition = 1;
pub const GIOCondition_G_IO_OUT: GIOCondition = 4;
pub const GIOCondition_G_IO_PRI: GIOCondition = 2;
pub const GIOCondition_G_IO_ERR: GIOCondition = 8;
pub const GIOCondition_G_IO_HUP: GIOCondition = 16;
pub const GIOCondition_G_IO_NVAL: GIOCondition = 32;
pub type GIOCondition = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMainContext {
    _unused: [u8; 0],
}
pub type GMainContext = _GMainContext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMainLoop {
    _unused: [u8; 0],
}
pub type GMainLoop = _GMainLoop;
pub type GSource = _GSource;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSourcePrivate {
    _unused: [u8; 0],
}
pub type GSourcePrivate = _GSourcePrivate;
pub type GSourceCallbackFuncs = _GSourceCallbackFuncs;
pub type GSourceFuncs = _GSourceFuncs;
pub type GSourceFunc = ::std::option::Option<unsafe extern "C" fn(user_data: gpointer) -> gboolean>;
pub type GChildWatchFunc =
    ::std::option::Option<unsafe extern "C" fn(pid: GPid, status: gint, user_data: gpointer)>;
pub type GSourceDisposeFunc = ::std::option::Option<unsafe extern "C" fn(source: *mut GSource)>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GSource {
    pub callback_data: gpointer,
    pub callback_funcs: *mut GSourceCallbackFuncs,
    pub source_funcs: *const GSourceFuncs,
    pub ref_count: guint,
    pub context: *mut GMainContext,
    pub priority: gint,
    pub flags: guint,
    pub source_id: guint,
    pub poll_fds: *mut GSList,
    pub prev: *mut GSource,
    pub next: *mut GSource,
    pub name: *mut ::std::os::raw::c_char,
    pub priv_: *mut GSourcePrivate,
}
#[test]
fn bindgen_test_layout__GSource() {
    assert_eq!(
        ::std::mem::size_of::<_GSource>(),
        96usize,
        concat!("Size of: ", stringify!(_GSource))
    );
    assert_eq!(
        ::std::mem::align_of::<_GSource>(),
        8usize,
        concat!("Alignment of ", stringify!(_GSource))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).callback_data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(callback_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).callback_funcs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(callback_funcs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).source_funcs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(source_funcs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).ref_count as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).context as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).priority as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(priority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).flags as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).source_id as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(source_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).poll_fds as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(poll_fds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).prev as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).next as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).name as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSource>())).priv_ as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSource),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GSourceCallbackFuncs {
    pub ref_: ::std::option::Option<unsafe extern "C" fn(cb_data: gpointer)>,
    pub unref: ::std::option::Option<unsafe extern "C" fn(cb_data: gpointer)>,
    pub get: ::std::option::Option<
        unsafe extern "C" fn(
            cb_data: gpointer,
            source: *mut GSource,
            func: *mut GSourceFunc,
            data: *mut gpointer,
        ),
    >,
}
#[test]
fn bindgen_test_layout__GSourceCallbackFuncs() {
    assert_eq!(
        ::std::mem::size_of::<_GSourceCallbackFuncs>(),
        24usize,
        concat!("Size of: ", stringify!(_GSourceCallbackFuncs))
    );
    assert_eq!(
        ::std::mem::align_of::<_GSourceCallbackFuncs>(),
        8usize,
        concat!("Alignment of ", stringify!(_GSourceCallbackFuncs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSourceCallbackFuncs>())).ref_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSourceCallbackFuncs),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSourceCallbackFuncs>())).unref as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSourceCallbackFuncs),
            "::",
            stringify!(unref)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSourceCallbackFuncs>())).get as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSourceCallbackFuncs),
            "::",
            stringify!(get)
        )
    );
}
pub type GSourceDummyMarshal = ::std::option::Option<unsafe extern "C" fn()>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GSourceFuncs {
    pub prepare: ::std::option::Option<
        unsafe extern "C" fn(source: *mut GSource, timeout_: *mut gint) -> gboolean,
    >,
    pub check: ::std::option::Option<unsafe extern "C" fn(source: *mut GSource) -> gboolean>,
    pub dispatch: ::std::option::Option<
        unsafe extern "C" fn(
            source: *mut GSource,
            callback: GSourceFunc,
            user_data: gpointer,
        ) -> gboolean,
    >,
    pub finalize: ::std::option::Option<unsafe extern "C" fn(source: *mut GSource)>,
    pub closure_callback: GSourceFunc,
    pub closure_marshal: GSourceDummyMarshal,
}
#[test]
fn bindgen_test_layout__GSourceFuncs() {
    assert_eq!(
        ::std::mem::size_of::<_GSourceFuncs>(),
        48usize,
        concat!("Size of: ", stringify!(_GSourceFuncs))
    );
    assert_eq!(
        ::std::mem::align_of::<_GSourceFuncs>(),
        8usize,
        concat!("Alignment of ", stringify!(_GSourceFuncs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSourceFuncs>())).prepare as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSourceFuncs),
            "::",
            stringify!(prepare)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSourceFuncs>())).check as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSourceFuncs),
            "::",
            stringify!(check)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSourceFuncs>())).dispatch as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSourceFuncs),
            "::",
            stringify!(dispatch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSourceFuncs>())).finalize as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSourceFuncs),
            "::",
            stringify!(finalize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSourceFuncs>())).closure_callback as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSourceFuncs),
            "::",
            stringify!(closure_callback)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSourceFuncs>())).closure_marshal as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSourceFuncs),
            "::",
            stringify!(closure_marshal)
        )
    );
}
extern "C" {
    pub fn g_main_context_new() -> *mut GMainContext;
}
extern "C" {
    pub fn g_main_context_ref(context: *mut GMainContext) -> *mut GMainContext;
}
extern "C" {
    pub fn g_main_context_unref(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_default() -> *mut GMainContext;
}
extern "C" {
    pub fn g_main_context_iteration(context: *mut GMainContext, may_block: gboolean) -> gboolean;
}
extern "C" {
    pub fn g_main_context_pending(context: *mut GMainContext) -> gboolean;
}
extern "C" {
    pub fn g_main_context_find_source_by_id(
        context: *mut GMainContext,
        source_id: guint,
    ) -> *mut GSource;
}
extern "C" {
    pub fn g_main_context_find_source_by_user_data(
        context: *mut GMainContext,
        user_data: gpointer,
    ) -> *mut GSource;
}
extern "C" {
    pub fn g_main_context_find_source_by_funcs_user_data(
        context: *mut GMainContext,
        funcs: *mut GSourceFuncs,
        user_data: gpointer,
    ) -> *mut GSource;
}
extern "C" {
    pub fn g_main_context_wakeup(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_acquire(context: *mut GMainContext) -> gboolean;
}
extern "C" {
    pub fn g_main_context_release(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_is_owner(context: *mut GMainContext) -> gboolean;
}
extern "C" {
    pub fn g_main_context_wait(
        context: *mut GMainContext,
        cond: *mut GCond,
        mutex: *mut GMutex,
    ) -> gboolean;
}
extern "C" {
    pub fn g_main_context_prepare(context: *mut GMainContext, priority: *mut gint) -> gboolean;
}
extern "C" {
    pub fn g_main_context_query(
        context: *mut GMainContext,
        max_priority: gint,
        timeout_: *mut gint,
        fds: *mut GPollFD,
        n_fds: gint,
    ) -> gint;
}
extern "C" {
    pub fn g_main_context_check(
        context: *mut GMainContext,
        max_priority: gint,
        fds: *mut GPollFD,
        n_fds: gint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_main_context_dispatch(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_set_poll_func(context: *mut GMainContext, func: GPollFunc);
}
extern "C" {
    pub fn g_main_context_get_poll_func(context: *mut GMainContext) -> GPollFunc;
}
extern "C" {
    pub fn g_main_context_add_poll(context: *mut GMainContext, fd: *mut GPollFD, priority: gint);
}
extern "C" {
    pub fn g_main_context_remove_poll(context: *mut GMainContext, fd: *mut GPollFD);
}
extern "C" {
    pub fn g_main_depth() -> gint;
}
extern "C" {
    pub fn g_main_current_source() -> *mut GSource;
}
extern "C" {
    pub fn g_main_context_push_thread_default(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_pop_thread_default(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_get_thread_default() -> *mut GMainContext;
}
extern "C" {
    pub fn g_main_context_ref_thread_default() -> *mut GMainContext;
}
pub type GMainContextPusher = ::std::os::raw::c_void;
extern "C" {
    pub fn g_main_loop_new(context: *mut GMainContext, is_running: gboolean) -> *mut GMainLoop;
}
extern "C" {
    pub fn g_main_loop_run(loop_: *mut GMainLoop);
}
extern "C" {
    pub fn g_main_loop_quit(loop_: *mut GMainLoop);
}
extern "C" {
    pub fn g_main_loop_ref(loop_: *mut GMainLoop) -> *mut GMainLoop;
}
extern "C" {
    pub fn g_main_loop_unref(loop_: *mut GMainLoop);
}
extern "C" {
    pub fn g_main_loop_is_running(loop_: *mut GMainLoop) -> gboolean;
}
extern "C" {
    pub fn g_main_loop_get_context(loop_: *mut GMainLoop) -> *mut GMainContext;
}
extern "C" {
    pub fn g_source_new(source_funcs: *mut GSourceFuncs, struct_size: guint) -> *mut GSource;
}
extern "C" {
    pub fn g_source_set_dispose_function(source: *mut GSource, dispose: GSourceDisposeFunc);
}
extern "C" {
    pub fn g_source_ref(source: *mut GSource) -> *mut GSource;
}
extern "C" {
    pub fn g_source_unref(source: *mut GSource);
}
extern "C" {
    pub fn g_source_attach(source: *mut GSource, context: *mut GMainContext) -> guint;
}
extern "C" {
    pub fn g_source_destroy(source: *mut GSource);
}
extern "C" {
    pub fn g_source_set_priority(source: *mut GSource, priority: gint);
}
extern "C" {
    pub fn g_source_get_priority(source: *mut GSource) -> gint;
}
extern "C" {
    pub fn g_source_set_can_recurse(source: *mut GSource, can_recurse: gboolean);
}
extern "C" {
    pub fn g_source_get_can_recurse(source: *mut GSource) -> gboolean;
}
extern "C" {
    pub fn g_source_get_id(source: *mut GSource) -> guint;
}
extern "C" {
    pub fn g_source_get_context(source: *mut GSource) -> *mut GMainContext;
}
extern "C" {
    pub fn g_source_set_callback(
        source: *mut GSource,
        func: GSourceFunc,
        data: gpointer,
        notify: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_source_set_funcs(source: *mut GSource, funcs: *mut GSourceFuncs);
}
extern "C" {
    pub fn g_source_is_destroyed(source: *mut GSource) -> gboolean;
}
extern "C" {
    pub fn g_source_set_name(source: *mut GSource, name: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_source_get_name(source: *mut GSource) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_source_set_name_by_id(tag: guint, name: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_source_set_ready_time(source: *mut GSource, ready_time: gint64);
}
extern "C" {
    pub fn g_source_get_ready_time(source: *mut GSource) -> gint64;
}
extern "C" {
    pub fn g_source_add_unix_fd(source: *mut GSource, fd: gint, events: GIOCondition) -> gpointer;
}
extern "C" {
    pub fn g_source_modify_unix_fd(source: *mut GSource, tag: gpointer, new_events: GIOCondition);
}
extern "C" {
    pub fn g_source_remove_unix_fd(source: *mut GSource, tag: gpointer);
}
extern "C" {
    pub fn g_source_query_unix_fd(source: *mut GSource, tag: gpointer) -> GIOCondition;
}
extern "C" {
    pub fn g_source_set_callback_indirect(
        source: *mut GSource,
        callback_data: gpointer,
        callback_funcs: *mut GSourceCallbackFuncs,
    );
}
extern "C" {
    pub fn g_source_add_poll(source: *mut GSource, fd: *mut GPollFD);
}
extern "C" {
    pub fn g_source_remove_poll(source: *mut GSource, fd: *mut GPollFD);
}
extern "C" {
    pub fn g_source_add_child_source(source: *mut GSource, child_source: *mut GSource);
}
extern "C" {
    pub fn g_source_remove_child_source(source: *mut GSource, child_source: *mut GSource);
}
extern "C" {
    pub fn g_source_get_current_time(source: *mut GSource, timeval: *mut GTimeVal);
}
extern "C" {
    pub fn g_source_get_time(source: *mut GSource) -> gint64;
}
extern "C" {
    pub fn g_idle_source_new() -> *mut GSource;
}
extern "C" {
    pub fn g_child_watch_source_new(pid: GPid) -> *mut GSource;
}
extern "C" {
    pub fn g_timeout_source_new(interval: guint) -> *mut GSource;
}
extern "C" {
    pub fn g_timeout_source_new_seconds(interval: guint) -> *mut GSource;
}
extern "C" {
    pub fn g_get_current_time(result: *mut GTimeVal);
}
extern "C" {
    pub fn g_get_monotonic_time() -> gint64;
}
extern "C" {
    pub fn g_get_real_time() -> gint64;
}
extern "C" {
    pub fn g_source_remove(tag: guint) -> gboolean;
}
extern "C" {
    pub fn g_source_remove_by_user_data(user_data: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_source_remove_by_funcs_user_data(
        funcs: *mut GSourceFuncs,
        user_data: gpointer,
    ) -> gboolean;
}
pub type GClearHandleFunc = ::std::option::Option<unsafe extern "C" fn(handle_id: guint)>;
extern "C" {
    pub fn g_clear_handle_id(tag_ptr: *mut guint, clear_func: GClearHandleFunc);
}
extern "C" {
    pub fn g_timeout_add_full(
        priority: gint,
        interval: guint,
        function: GSourceFunc,
        data: gpointer,
        notify: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_timeout_add(interval: guint, function: GSourceFunc, data: gpointer) -> guint;
}
extern "C" {
    pub fn g_timeout_add_seconds_full(
        priority: gint,
        interval: guint,
        function: GSourceFunc,
        data: gpointer,
        notify: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_timeout_add_seconds(interval: guint, function: GSourceFunc, data: gpointer) -> guint;
}
extern "C" {
    pub fn g_child_watch_add_full(
        priority: gint,
        pid: GPid,
        function: GChildWatchFunc,
        data: gpointer,
        notify: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_child_watch_add(pid: GPid, function: GChildWatchFunc, data: gpointer) -> guint;
}
extern "C" {
    pub fn g_idle_add(function: GSourceFunc, data: gpointer) -> guint;
}
extern "C" {
    pub fn g_idle_add_full(
        priority: gint,
        function: GSourceFunc,
        data: gpointer,
        notify: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_idle_remove_by_data(data: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_main_context_invoke_full(
        context: *mut GMainContext,
        priority: gint,
        function: GSourceFunc,
        data: gpointer,
        notify: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_main_context_invoke(context: *mut GMainContext, function: GSourceFunc, data: gpointer);
}
extern "C" {
    pub static mut g_timeout_funcs: GSourceFuncs;
}
extern "C" {
    pub static mut g_child_watch_funcs: GSourceFuncs;
}
extern "C" {
    pub static mut g_idle_funcs: GSourceFuncs;
}
extern "C" {
    pub static mut g_unix_signal_funcs: GSourceFuncs;
}
extern "C" {
    pub static mut g_unix_fd_source_funcs: GSourceFuncs;
}
pub type gunichar = guint32;
pub type gunichar2 = guint16;
pub const GUnicodeType_G_UNICODE_CONTROL: GUnicodeType = 0;
pub const GUnicodeType_G_UNICODE_FORMAT: GUnicodeType = 1;
pub const GUnicodeType_G_UNICODE_UNASSIGNED: GUnicodeType = 2;
pub const GUnicodeType_G_UNICODE_PRIVATE_USE: GUnicodeType = 3;
pub const GUnicodeType_G_UNICODE_SURROGATE: GUnicodeType = 4;
pub const GUnicodeType_G_UNICODE_LOWERCASE_LETTER: GUnicodeType = 5;
pub const GUnicodeType_G_UNICODE_MODIFIER_LETTER: GUnicodeType = 6;
pub const GUnicodeType_G_UNICODE_OTHER_LETTER: GUnicodeType = 7;
pub const GUnicodeType_G_UNICODE_TITLECASE_LETTER: GUnicodeType = 8;
pub const GUnicodeType_G_UNICODE_UPPERCASE_LETTER: GUnicodeType = 9;
pub const GUnicodeType_G_UNICODE_SPACING_MARK: GUnicodeType = 10;
pub const GUnicodeType_G_UNICODE_ENCLOSING_MARK: GUnicodeType = 11;
pub const GUnicodeType_G_UNICODE_NON_SPACING_MARK: GUnicodeType = 12;
pub const GUnicodeType_G_UNICODE_DECIMAL_NUMBER: GUnicodeType = 13;
pub const GUnicodeType_G_UNICODE_LETTER_NUMBER: GUnicodeType = 14;
pub const GUnicodeType_G_UNICODE_OTHER_NUMBER: GUnicodeType = 15;
pub const GUnicodeType_G_UNICODE_CONNECT_PUNCTUATION: GUnicodeType = 16;
pub const GUnicodeType_G_UNICODE_DASH_PUNCTUATION: GUnicodeType = 17;
pub const GUnicodeType_G_UNICODE_CLOSE_PUNCTUATION: GUnicodeType = 18;
pub const GUnicodeType_G_UNICODE_FINAL_PUNCTUATION: GUnicodeType = 19;
pub const GUnicodeType_G_UNICODE_INITIAL_PUNCTUATION: GUnicodeType = 20;
pub const GUnicodeType_G_UNICODE_OTHER_PUNCTUATION: GUnicodeType = 21;
pub const GUnicodeType_G_UNICODE_OPEN_PUNCTUATION: GUnicodeType = 22;
pub const GUnicodeType_G_UNICODE_CURRENCY_SYMBOL: GUnicodeType = 23;
pub const GUnicodeType_G_UNICODE_MODIFIER_SYMBOL: GUnicodeType = 24;
pub const GUnicodeType_G_UNICODE_MATH_SYMBOL: GUnicodeType = 25;
pub const GUnicodeType_G_UNICODE_OTHER_SYMBOL: GUnicodeType = 26;
pub const GUnicodeType_G_UNICODE_LINE_SEPARATOR: GUnicodeType = 27;
pub const GUnicodeType_G_UNICODE_PARAGRAPH_SEPARATOR: GUnicodeType = 28;
pub const GUnicodeType_G_UNICODE_SPACE_SEPARATOR: GUnicodeType = 29;
pub type GUnicodeType = u32;
pub const GUnicodeBreakType_G_UNICODE_BREAK_MANDATORY: GUnicodeBreakType = 0;
pub const GUnicodeBreakType_G_UNICODE_BREAK_CARRIAGE_RETURN: GUnicodeBreakType = 1;
pub const GUnicodeBreakType_G_UNICODE_BREAK_LINE_FEED: GUnicodeBreakType = 2;
pub const GUnicodeBreakType_G_UNICODE_BREAK_COMBINING_MARK: GUnicodeBreakType = 3;
pub const GUnicodeBreakType_G_UNICODE_BREAK_SURROGATE: GUnicodeBreakType = 4;
pub const GUnicodeBreakType_G_UNICODE_BREAK_ZERO_WIDTH_SPACE: GUnicodeBreakType = 5;
pub const GUnicodeBreakType_G_UNICODE_BREAK_INSEPARABLE: GUnicodeBreakType = 6;
pub const GUnicodeBreakType_G_UNICODE_BREAK_NON_BREAKING_GLUE: GUnicodeBreakType = 7;
pub const GUnicodeBreakType_G_UNICODE_BREAK_CONTINGENT: GUnicodeBreakType = 8;
pub const GUnicodeBreakType_G_UNICODE_BREAK_SPACE: GUnicodeBreakType = 9;
pub const GUnicodeBreakType_G_UNICODE_BREAK_AFTER: GUnicodeBreakType = 10;
pub const GUnicodeBreakType_G_UNICODE_BREAK_BEFORE: GUnicodeBreakType = 11;
pub const GUnicodeBreakType_G_UNICODE_BREAK_BEFORE_AND_AFTER: GUnicodeBreakType = 12;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HYPHEN: GUnicodeBreakType = 13;
pub const GUnicodeBreakType_G_UNICODE_BREAK_NON_STARTER: GUnicodeBreakType = 14;
pub const GUnicodeBreakType_G_UNICODE_BREAK_OPEN_PUNCTUATION: GUnicodeBreakType = 15;
pub const GUnicodeBreakType_G_UNICODE_BREAK_CLOSE_PUNCTUATION: GUnicodeBreakType = 16;
pub const GUnicodeBreakType_G_UNICODE_BREAK_QUOTATION: GUnicodeBreakType = 17;
pub const GUnicodeBreakType_G_UNICODE_BREAK_EXCLAMATION: GUnicodeBreakType = 18;
pub const GUnicodeBreakType_G_UNICODE_BREAK_IDEOGRAPHIC: GUnicodeBreakType = 19;
pub const GUnicodeBreakType_G_UNICODE_BREAK_NUMERIC: GUnicodeBreakType = 20;
pub const GUnicodeBreakType_G_UNICODE_BREAK_INFIX_SEPARATOR: GUnicodeBreakType = 21;
pub const GUnicodeBreakType_G_UNICODE_BREAK_SYMBOL: GUnicodeBreakType = 22;
pub const GUnicodeBreakType_G_UNICODE_BREAK_ALPHABETIC: GUnicodeBreakType = 23;
pub const GUnicodeBreakType_G_UNICODE_BREAK_PREFIX: GUnicodeBreakType = 24;
pub const GUnicodeBreakType_G_UNICODE_BREAK_POSTFIX: GUnicodeBreakType = 25;
pub const GUnicodeBreakType_G_UNICODE_BREAK_COMPLEX_CONTEXT: GUnicodeBreakType = 26;
pub const GUnicodeBreakType_G_UNICODE_BREAK_AMBIGUOUS: GUnicodeBreakType = 27;
pub const GUnicodeBreakType_G_UNICODE_BREAK_UNKNOWN: GUnicodeBreakType = 28;
pub const GUnicodeBreakType_G_UNICODE_BREAK_NEXT_LINE: GUnicodeBreakType = 29;
pub const GUnicodeBreakType_G_UNICODE_BREAK_WORD_JOINER: GUnicodeBreakType = 30;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HANGUL_L_JAMO: GUnicodeBreakType = 31;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HANGUL_V_JAMO: GUnicodeBreakType = 32;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HANGUL_T_JAMO: GUnicodeBreakType = 33;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HANGUL_LV_SYLLABLE: GUnicodeBreakType = 34;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HANGUL_LVT_SYLLABLE: GUnicodeBreakType = 35;
pub const GUnicodeBreakType_G_UNICODE_BREAK_CLOSE_PARANTHESIS: GUnicodeBreakType = 36;
pub const GUnicodeBreakType_G_UNICODE_BREAK_CONDITIONAL_JAPANESE_STARTER: GUnicodeBreakType = 37;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HEBREW_LETTER: GUnicodeBreakType = 38;
pub const GUnicodeBreakType_G_UNICODE_BREAK_REGIONAL_INDICATOR: GUnicodeBreakType = 39;
pub const GUnicodeBreakType_G_UNICODE_BREAK_EMOJI_BASE: GUnicodeBreakType = 40;
pub const GUnicodeBreakType_G_UNICODE_BREAK_EMOJI_MODIFIER: GUnicodeBreakType = 41;
pub const GUnicodeBreakType_G_UNICODE_BREAK_ZERO_WIDTH_JOINER: GUnicodeBreakType = 42;
pub type GUnicodeBreakType = u32;
pub const GUnicodeScript_G_UNICODE_SCRIPT_INVALID_CODE: GUnicodeScript = -1;
pub const GUnicodeScript_G_UNICODE_SCRIPT_COMMON: GUnicodeScript = 0;
pub const GUnicodeScript_G_UNICODE_SCRIPT_INHERITED: GUnicodeScript = 1;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ARABIC: GUnicodeScript = 2;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ARMENIAN: GUnicodeScript = 3;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BENGALI: GUnicodeScript = 4;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BOPOMOFO: GUnicodeScript = 5;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CHEROKEE: GUnicodeScript = 6;
pub const GUnicodeScript_G_UNICODE_SCRIPT_COPTIC: GUnicodeScript = 7;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CYRILLIC: GUnicodeScript = 8;
pub const GUnicodeScript_G_UNICODE_SCRIPT_DESERET: GUnicodeScript = 9;
pub const GUnicodeScript_G_UNICODE_SCRIPT_DEVANAGARI: GUnicodeScript = 10;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ETHIOPIC: GUnicodeScript = 11;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GEORGIAN: GUnicodeScript = 12;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GOTHIC: GUnicodeScript = 13;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GREEK: GUnicodeScript = 14;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GUJARATI: GUnicodeScript = 15;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GURMUKHI: GUnicodeScript = 16;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HAN: GUnicodeScript = 17;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HANGUL: GUnicodeScript = 18;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HEBREW: GUnicodeScript = 19;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HIRAGANA: GUnicodeScript = 20;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KANNADA: GUnicodeScript = 21;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KATAKANA: GUnicodeScript = 22;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KHMER: GUnicodeScript = 23;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LAO: GUnicodeScript = 24;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LATIN: GUnicodeScript = 25;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MALAYALAM: GUnicodeScript = 26;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MONGOLIAN: GUnicodeScript = 27;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MYANMAR: GUnicodeScript = 28;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OGHAM: GUnicodeScript = 29;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_ITALIC: GUnicodeScript = 30;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ORIYA: GUnicodeScript = 31;
pub const GUnicodeScript_G_UNICODE_SCRIPT_RUNIC: GUnicodeScript = 32;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SINHALA: GUnicodeScript = 33;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SYRIAC: GUnicodeScript = 34;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAMIL: GUnicodeScript = 35;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TELUGU: GUnicodeScript = 36;
pub const GUnicodeScript_G_UNICODE_SCRIPT_THAANA: GUnicodeScript = 37;
pub const GUnicodeScript_G_UNICODE_SCRIPT_THAI: GUnicodeScript = 38;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TIBETAN: GUnicodeScript = 39;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL: GUnicodeScript = 40;
pub const GUnicodeScript_G_UNICODE_SCRIPT_YI: GUnicodeScript = 41;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAGALOG: GUnicodeScript = 42;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HANUNOO: GUnicodeScript = 43;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BUHID: GUnicodeScript = 44;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAGBANWA: GUnicodeScript = 45;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BRAILLE: GUnicodeScript = 46;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CYPRIOT: GUnicodeScript = 47;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LIMBU: GUnicodeScript = 48;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OSMANYA: GUnicodeScript = 49;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SHAVIAN: GUnicodeScript = 50;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LINEAR_B: GUnicodeScript = 51;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAI_LE: GUnicodeScript = 52;
pub const GUnicodeScript_G_UNICODE_SCRIPT_UGARITIC: GUnicodeScript = 53;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NEW_TAI_LUE: GUnicodeScript = 54;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BUGINESE: GUnicodeScript = 55;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GLAGOLITIC: GUnicodeScript = 56;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TIFINAGH: GUnicodeScript = 57;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SYLOTI_NAGRI: GUnicodeScript = 58;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_PERSIAN: GUnicodeScript = 59;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KHAROSHTHI: GUnicodeScript = 60;
pub const GUnicodeScript_G_UNICODE_SCRIPT_UNKNOWN: GUnicodeScript = 61;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BALINESE: GUnicodeScript = 62;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CUNEIFORM: GUnicodeScript = 63;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PHOENICIAN: GUnicodeScript = 64;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PHAGS_PA: GUnicodeScript = 65;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NKO: GUnicodeScript = 66;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KAYAH_LI: GUnicodeScript = 67;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LEPCHA: GUnicodeScript = 68;
pub const GUnicodeScript_G_UNICODE_SCRIPT_REJANG: GUnicodeScript = 69;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SUNDANESE: GUnicodeScript = 70;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SAURASHTRA: GUnicodeScript = 71;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CHAM: GUnicodeScript = 72;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OL_CHIKI: GUnicodeScript = 73;
pub const GUnicodeScript_G_UNICODE_SCRIPT_VAI: GUnicodeScript = 74;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CARIAN: GUnicodeScript = 75;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LYCIAN: GUnicodeScript = 76;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LYDIAN: GUnicodeScript = 77;
pub const GUnicodeScript_G_UNICODE_SCRIPT_AVESTAN: GUnicodeScript = 78;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BAMUM: GUnicodeScript = 79;
pub const GUnicodeScript_G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS: GUnicodeScript = 80;
pub const GUnicodeScript_G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC: GUnicodeScript = 81;
pub const GUnicodeScript_G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI: GUnicodeScript = 82;
pub const GUnicodeScript_G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN: GUnicodeScript = 83;
pub const GUnicodeScript_G_UNICODE_SCRIPT_JAVANESE: GUnicodeScript = 84;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KAITHI: GUnicodeScript = 85;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LISU: GUnicodeScript = 86;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MEETEI_MAYEK: GUnicodeScript = 87;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN: GUnicodeScript = 88;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_TURKIC: GUnicodeScript = 89;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SAMARITAN: GUnicodeScript = 90;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAI_THAM: GUnicodeScript = 91;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAI_VIET: GUnicodeScript = 92;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BATAK: GUnicodeScript = 93;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BRAHMI: GUnicodeScript = 94;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MANDAIC: GUnicodeScript = 95;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CHAKMA: GUnicodeScript = 96;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MEROITIC_CURSIVE: GUnicodeScript = 97;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS: GUnicodeScript = 98;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MIAO: GUnicodeScript = 99;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SHARADA: GUnicodeScript = 100;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SORA_SOMPENG: GUnicodeScript = 101;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAKRI: GUnicodeScript = 102;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BASSA_VAH: GUnicodeScript = 103;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN: GUnicodeScript = 104;
pub const GUnicodeScript_G_UNICODE_SCRIPT_DUPLOYAN: GUnicodeScript = 105;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ELBASAN: GUnicodeScript = 106;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GRANTHA: GUnicodeScript = 107;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KHOJKI: GUnicodeScript = 108;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KHUDAWADI: GUnicodeScript = 109;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LINEAR_A: GUnicodeScript = 110;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MAHAJANI: GUnicodeScript = 111;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MANICHAEAN: GUnicodeScript = 112;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MENDE_KIKAKUI: GUnicodeScript = 113;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MODI: GUnicodeScript = 114;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MRO: GUnicodeScript = 115;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NABATAEAN: GUnicodeScript = 116;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN: GUnicodeScript = 117;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_PERMIC: GUnicodeScript = 118;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PAHAWH_HMONG: GUnicodeScript = 119;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PALMYRENE: GUnicodeScript = 120;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PAU_CIN_HAU: GUnicodeScript = 121;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PSALTER_PAHLAVI: GUnicodeScript = 122;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SIDDHAM: GUnicodeScript = 123;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TIRHUTA: GUnicodeScript = 124;
pub const GUnicodeScript_G_UNICODE_SCRIPT_WARANG_CITI: GUnicodeScript = 125;
pub const GUnicodeScript_G_UNICODE_SCRIPT_AHOM: GUnicodeScript = 126;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS: GUnicodeScript = 127;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HATRAN: GUnicodeScript = 128;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MULTANI: GUnicodeScript = 129;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_HUNGARIAN: GUnicodeScript = 130;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SIGNWRITING: GUnicodeScript = 131;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ADLAM: GUnicodeScript = 132;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BHAIKSUKI: GUnicodeScript = 133;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MARCHEN: GUnicodeScript = 134;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NEWA: GUnicodeScript = 135;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OSAGE: GUnicodeScript = 136;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TANGUT: GUnicodeScript = 137;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MASARAM_GONDI: GUnicodeScript = 138;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NUSHU: GUnicodeScript = 139;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SOYOMBO: GUnicodeScript = 140;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ZANABAZAR_SQUARE: GUnicodeScript = 141;
pub const GUnicodeScript_G_UNICODE_SCRIPT_DOGRA: GUnicodeScript = 142;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GUNJALA_GONDI: GUnicodeScript = 143;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HANIFI_ROHINGYA: GUnicodeScript = 144;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MAKASAR: GUnicodeScript = 145;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MEDEFAIDRIN: GUnicodeScript = 146;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_SOGDIAN: GUnicodeScript = 147;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SOGDIAN: GUnicodeScript = 148;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ELYMAIC: GUnicodeScript = 149;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NANDINAGARI: GUnicodeScript = 150;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NYIAKENG_PUACHUE_HMONG: GUnicodeScript = 151;
pub const GUnicodeScript_G_UNICODE_SCRIPT_WANCHO: GUnicodeScript = 152;
pub type GUnicodeScript = i32;
extern "C" {
    pub fn g_unicode_script_to_iso15924(script: GUnicodeScript) -> guint32;
}
extern "C" {
    pub fn g_unicode_script_from_iso15924(iso15924: guint32) -> GUnicodeScript;
}
extern "C" {
    pub fn g_unichar_isalnum(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isalpha(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_iscntrl(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isdigit(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isgraph(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_islower(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isprint(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_ispunct(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isspace(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isupper(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isxdigit(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_istitle(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isdefined(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_iswide(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_iswide_cjk(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_iszerowidth(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_ismark(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_toupper(c: gunichar) -> gunichar;
}
extern "C" {
    pub fn g_unichar_tolower(c: gunichar) -> gunichar;
}
extern "C" {
    pub fn g_unichar_totitle(c: gunichar) -> gunichar;
}
extern "C" {
    pub fn g_unichar_digit_value(c: gunichar) -> gint;
}
extern "C" {
    pub fn g_unichar_xdigit_value(c: gunichar) -> gint;
}
extern "C" {
    pub fn g_unichar_type(c: gunichar) -> GUnicodeType;
}
extern "C" {
    pub fn g_unichar_break_type(c: gunichar) -> GUnicodeBreakType;
}
extern "C" {
    pub fn g_unichar_combining_class(uc: gunichar) -> gint;
}
extern "C" {
    pub fn g_unichar_get_mirror_char(ch: gunichar, mirrored_ch: *mut gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_get_script(ch: gunichar) -> GUnicodeScript;
}
extern "C" {
    pub fn g_unichar_validate(ch: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_compose(a: gunichar, b: gunichar, ch: *mut gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_decompose(ch: gunichar, a: *mut gunichar, b: *mut gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_fully_decompose(
        ch: gunichar,
        compat: gboolean,
        result: *mut gunichar,
        result_len: gsize,
    ) -> gsize;
}
extern "C" {
    pub fn g_unicode_canonical_ordering(string: *mut gunichar, len: gsize);
}
extern "C" {
    pub fn g_unicode_canonical_decomposition(ch: gunichar, result_len: *mut gsize)
        -> *mut gunichar;
}
extern "C" {
    pub static g_utf8_skip: *const gchar;
}
extern "C" {
    pub fn g_utf8_get_char(p: *const gchar) -> gunichar;
}
extern "C" {
    pub fn g_utf8_get_char_validated(p: *const gchar, max_len: gssize) -> gunichar;
}
extern "C" {
    pub fn g_utf8_offset_to_pointer(str: *const gchar, offset: glong) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_pointer_to_offset(str: *const gchar, pos: *const gchar) -> glong;
}
extern "C" {
    pub fn g_utf8_prev_char(p: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_find_next_char(p: *const gchar, end: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_find_prev_char(str: *const gchar, p: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strlen(p: *const gchar, max: gssize) -> glong;
}
extern "C" {
    pub fn g_utf8_substring(str: *const gchar, start_pos: glong, end_pos: glong) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strncpy(dest: *mut gchar, src: *const gchar, n: gsize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strchr(p: *const gchar, len: gssize, c: gunichar) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strrchr(p: *const gchar, len: gssize, c: gunichar) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strreverse(str: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_to_utf16(
        str: *const gchar,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gunichar2;
}
extern "C" {
    pub fn g_utf8_to_ucs4(
        str: *const gchar,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gunichar;
}
extern "C" {
    pub fn g_utf8_to_ucs4_fast(
        str: *const gchar,
        len: glong,
        items_written: *mut glong,
    ) -> *mut gunichar;
}
extern "C" {
    pub fn g_utf16_to_ucs4(
        str: *const gunichar2,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gunichar;
}
extern "C" {
    pub fn g_utf16_to_utf8(
        str: *const gunichar2,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_ucs4_to_utf16(
        str: *const gunichar,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gunichar2;
}
extern "C" {
    pub fn g_ucs4_to_utf8(
        str: *const gunichar,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_unichar_to_utf8(c: gunichar, outbuf: *mut gchar) -> gint;
}
extern "C" {
    pub fn g_utf8_validate(str: *const gchar, max_len: gssize, end: *mut *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_utf8_validate_len(
        str: *const gchar,
        max_len: gsize,
        end: *mut *const gchar,
    ) -> gboolean;
}
extern "C" {
    pub fn g_utf8_strup(str: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strdown(str: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_casefold(str: *const gchar, len: gssize) -> *mut gchar;
}
pub const GNormalizeMode_G_NORMALIZE_DEFAULT: GNormalizeMode = 0;
pub const GNormalizeMode_G_NORMALIZE_NFD: GNormalizeMode = 0;
pub const GNormalizeMode_G_NORMALIZE_DEFAULT_COMPOSE: GNormalizeMode = 1;
pub const GNormalizeMode_G_NORMALIZE_NFC: GNormalizeMode = 1;
pub const GNormalizeMode_G_NORMALIZE_ALL: GNormalizeMode = 2;
pub const GNormalizeMode_G_NORMALIZE_NFKD: GNormalizeMode = 2;
pub const GNormalizeMode_G_NORMALIZE_ALL_COMPOSE: GNormalizeMode = 3;
pub const GNormalizeMode_G_NORMALIZE_NFKC: GNormalizeMode = 3;
pub type GNormalizeMode = u32;
extern "C" {
    pub fn g_utf8_normalize(str: *const gchar, len: gssize, mode: GNormalizeMode) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_collate(str1: *const gchar, str2: *const gchar) -> gint;
}
extern "C" {
    pub fn g_utf8_collate_key(str: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_collate_key_for_filename(str: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_make_valid(str: *const gchar, len: gssize) -> *mut gchar;
}
pub type GString = _GString;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GString {
    pub str: *mut gchar,
    pub len: gsize,
    pub allocated_len: gsize,
}
#[test]
fn bindgen_test_layout__GString() {
    assert_eq!(
        ::std::mem::size_of::<_GString>(),
        24usize,
        concat!("Size of: ", stringify!(_GString))
    );
    assert_eq!(
        ::std::mem::align_of::<_GString>(),
        8usize,
        concat!("Alignment of ", stringify!(_GString))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GString>())).str as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GString),
            "::",
            stringify!(str)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GString>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GString),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GString>())).allocated_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GString),
            "::",
            stringify!(allocated_len)
        )
    );
}
extern "C" {
    pub fn g_string_new(init: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_new_len(init: *const gchar, len: gssize) -> *mut GString;
}
extern "C" {
    pub fn g_string_sized_new(dfl_size: gsize) -> *mut GString;
}
extern "C" {
    pub fn g_string_free(string: *mut GString, free_segment: gboolean) -> *mut gchar;
}
extern "C" {
    pub fn g_string_free_to_bytes(string: *mut GString) -> *mut GBytes;
}
extern "C" {
    pub fn g_string_equal(v: *const GString, v2: *const GString) -> gboolean;
}
extern "C" {
    pub fn g_string_hash(str: *const GString) -> guint;
}
extern "C" {
    pub fn g_string_assign(string: *mut GString, rval: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_truncate(string: *mut GString, len: gsize) -> *mut GString;
}
extern "C" {
    pub fn g_string_set_size(string: *mut GString, len: gsize) -> *mut GString;
}
extern "C" {
    pub fn g_string_insert_len(
        string: *mut GString,
        pos: gssize,
        val: *const gchar,
        len: gssize,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_string_append(string: *mut GString, val: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_append_len(
        string: *mut GString,
        val: *const gchar,
        len: gssize,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_string_append_c(string: *mut GString, c: gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_append_unichar(string: *mut GString, wc: gunichar) -> *mut GString;
}
extern "C" {
    pub fn g_string_prepend(string: *mut GString, val: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_prepend_c(string: *mut GString, c: gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_prepend_unichar(string: *mut GString, wc: gunichar) -> *mut GString;
}
extern "C" {
    pub fn g_string_prepend_len(
        string: *mut GString,
        val: *const gchar,
        len: gssize,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_string_insert(string: *mut GString, pos: gssize, val: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_insert_c(string: *mut GString, pos: gssize, c: gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_insert_unichar(string: *mut GString, pos: gssize, wc: gunichar)
        -> *mut GString;
}
extern "C" {
    pub fn g_string_overwrite(string: *mut GString, pos: gsize, val: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_overwrite_len(
        string: *mut GString,
        pos: gsize,
        val: *const gchar,
        len: gssize,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_string_erase(string: *mut GString, pos: gssize, len: gssize) -> *mut GString;
}
extern "C" {
    pub fn g_string_ascii_down(string: *mut GString) -> *mut GString;
}
extern "C" {
    pub fn g_string_ascii_up(string: *mut GString) -> *mut GString;
}
extern "C" {
    pub fn g_string_vprintf(string: *mut GString, format: *const gchar, args: *mut __va_list_tag);
}
extern "C" {
    pub fn g_string_printf(string: *mut GString, format: *const gchar, ...);
}
extern "C" {
    pub fn g_string_append_vprintf(
        string: *mut GString,
        format: *const gchar,
        args: *mut __va_list_tag,
    );
}
extern "C" {
    pub fn g_string_append_printf(string: *mut GString, format: *const gchar, ...);
}
extern "C" {
    pub fn g_string_append_uri_escaped(
        string: *mut GString,
        unescaped: *const gchar,
        reserved_chars_allowed: *const gchar,
        allow_utf8: gboolean,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_string_down(string: *mut GString) -> *mut GString;
}
extern "C" {
    pub fn g_string_up(string: *mut GString) -> *mut GString;
}
pub type GIOChannel = _GIOChannel;
pub type GIOFuncs = _GIOFuncs;
pub const GIOError_G_IO_ERROR_NONE: GIOError = 0;
pub const GIOError_G_IO_ERROR_AGAIN: GIOError = 1;
pub const GIOError_G_IO_ERROR_INVAL: GIOError = 2;
pub const GIOError_G_IO_ERROR_UNKNOWN: GIOError = 3;
pub type GIOError = u32;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_FBIG: GIOChannelError = 0;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_INVAL: GIOChannelError = 1;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_IO: GIOChannelError = 2;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_ISDIR: GIOChannelError = 3;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_NOSPC: GIOChannelError = 4;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_NXIO: GIOChannelError = 5;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_OVERFLOW: GIOChannelError = 6;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_PIPE: GIOChannelError = 7;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_FAILED: GIOChannelError = 8;
pub type GIOChannelError = u32;
pub const GIOStatus_G_IO_STATUS_ERROR: GIOStatus = 0;
pub const GIOStatus_G_IO_STATUS_NORMAL: GIOStatus = 1;
pub const GIOStatus_G_IO_STATUS_EOF: GIOStatus = 2;
pub const GIOStatus_G_IO_STATUS_AGAIN: GIOStatus = 3;
pub type GIOStatus = u32;
pub const GSeekType_G_SEEK_CUR: GSeekType = 0;
pub const GSeekType_G_SEEK_SET: GSeekType = 1;
pub const GSeekType_G_SEEK_END: GSeekType = 2;
pub type GSeekType = u32;
pub const GIOFlags_G_IO_FLAG_APPEND: GIOFlags = 1;
pub const GIOFlags_G_IO_FLAG_NONBLOCK: GIOFlags = 2;
pub const GIOFlags_G_IO_FLAG_IS_READABLE: GIOFlags = 4;
pub const GIOFlags_G_IO_FLAG_IS_WRITABLE: GIOFlags = 8;
pub const GIOFlags_G_IO_FLAG_IS_WRITEABLE: GIOFlags = 8;
pub const GIOFlags_G_IO_FLAG_IS_SEEKABLE: GIOFlags = 16;
pub const GIOFlags_G_IO_FLAG_MASK: GIOFlags = 31;
pub const GIOFlags_G_IO_FLAG_GET_MASK: GIOFlags = 31;
pub const GIOFlags_G_IO_FLAG_SET_MASK: GIOFlags = 3;
pub type GIOFlags = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GIOChannel {
    pub ref_count: gint,
    pub funcs: *mut GIOFuncs,
    pub encoding: *mut gchar,
    pub read_cd: GIConv,
    pub write_cd: GIConv,
    pub line_term: *mut gchar,
    pub line_term_len: guint,
    pub buf_size: gsize,
    pub read_buf: *mut GString,
    pub encoded_read_buf: *mut GString,
    pub write_buf: *mut GString,
    pub partial_write_buf: [gchar; 6usize],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub reserved1: gpointer,
    pub reserved2: gpointer,
}
#[test]
fn bindgen_test_layout__GIOChannel() {
    assert_eq!(
        ::std::mem::size_of::<_GIOChannel>(),
        112usize,
        concat!("Size of: ", stringify!(_GIOChannel))
    );
    assert_eq!(
        ::std::mem::align_of::<_GIOChannel>(),
        8usize,
        concat!("Alignment of ", stringify!(_GIOChannel))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).ref_count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).funcs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(funcs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).encoding as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(encoding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).read_cd as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(read_cd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).write_cd as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(write_cd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).line_term as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(line_term)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).line_term_len as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(line_term_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).buf_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(buf_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).read_buf as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(read_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).encoded_read_buf as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(encoded_read_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).write_buf as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(write_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).partial_write_buf as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(partial_write_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).reserved1 as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOChannel>())).reserved2 as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOChannel),
            "::",
            stringify!(reserved2)
        )
    );
}
impl _GIOChannel {
    #[inline]
    pub fn use_buffer(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_use_buffer(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn do_encode(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_do_encode(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn close_on_unref(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_close_on_unref(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_readable(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_readable(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_writeable(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_writeable(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_seekable(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_seekable(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        use_buffer: guint,
        do_encode: guint,
        close_on_unref: guint,
        is_readable: guint,
        is_writeable: guint,
        is_seekable: guint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let use_buffer: u32 = unsafe { ::std::mem::transmute(use_buffer) };
            use_buffer as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let do_encode: u32 = unsafe { ::std::mem::transmute(do_encode) };
            do_encode as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let close_on_unref: u32 = unsafe { ::std::mem::transmute(close_on_unref) };
            close_on_unref as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_readable: u32 = unsafe { ::std::mem::transmute(is_readable) };
            is_readable as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_writeable: u32 = unsafe { ::std::mem::transmute(is_writeable) };
            is_writeable as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let is_seekable: u32 = unsafe { ::std::mem::transmute(is_seekable) };
            is_seekable as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type GIOFunc = ::std::option::Option<
    unsafe extern "C" fn(
        source: *mut GIOChannel,
        condition: GIOCondition,
        data: gpointer,
    ) -> gboolean,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GIOFuncs {
    pub io_read: ::std::option::Option<
        unsafe extern "C" fn(
            channel: *mut GIOChannel,
            buf: *mut gchar,
            count: gsize,
            bytes_read: *mut gsize,
            err: *mut *mut GError,
        ) -> GIOStatus,
    >,
    pub io_write: ::std::option::Option<
        unsafe extern "C" fn(
            channel: *mut GIOChannel,
            buf: *const gchar,
            count: gsize,
            bytes_written: *mut gsize,
            err: *mut *mut GError,
        ) -> GIOStatus,
    >,
    pub io_seek: ::std::option::Option<
        unsafe extern "C" fn(
            channel: *mut GIOChannel,
            offset: gint64,
            type_: GSeekType,
            err: *mut *mut GError,
        ) -> GIOStatus,
    >,
    pub io_close: ::std::option::Option<
        unsafe extern "C" fn(channel: *mut GIOChannel, err: *mut *mut GError) -> GIOStatus,
    >,
    pub io_create_watch: ::std::option::Option<
        unsafe extern "C" fn(channel: *mut GIOChannel, condition: GIOCondition) -> *mut GSource,
    >,
    pub io_free: ::std::option::Option<unsafe extern "C" fn(channel: *mut GIOChannel)>,
    pub io_set_flags: ::std::option::Option<
        unsafe extern "C" fn(
            channel: *mut GIOChannel,
            flags: GIOFlags,
            err: *mut *mut GError,
        ) -> GIOStatus,
    >,
    pub io_get_flags:
        ::std::option::Option<unsafe extern "C" fn(channel: *mut GIOChannel) -> GIOFlags>,
}
#[test]
fn bindgen_test_layout__GIOFuncs() {
    assert_eq!(
        ::std::mem::size_of::<_GIOFuncs>(),
        64usize,
        concat!("Size of: ", stringify!(_GIOFuncs))
    );
    assert_eq!(
        ::std::mem::align_of::<_GIOFuncs>(),
        8usize,
        concat!("Alignment of ", stringify!(_GIOFuncs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOFuncs>())).io_read as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOFuncs),
            "::",
            stringify!(io_read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOFuncs>())).io_write as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOFuncs),
            "::",
            stringify!(io_write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOFuncs>())).io_seek as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOFuncs),
            "::",
            stringify!(io_seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOFuncs>())).io_close as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOFuncs),
            "::",
            stringify!(io_close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOFuncs>())).io_create_watch as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOFuncs),
            "::",
            stringify!(io_create_watch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOFuncs>())).io_free as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOFuncs),
            "::",
            stringify!(io_free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOFuncs>())).io_set_flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOFuncs),
            "::",
            stringify!(io_set_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GIOFuncs>())).io_get_flags as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GIOFuncs),
            "::",
            stringify!(io_get_flags)
        )
    );
}
extern "C" {
    pub fn g_io_channel_init(channel: *mut GIOChannel);
}
extern "C" {
    pub fn g_io_channel_ref(channel: *mut GIOChannel) -> *mut GIOChannel;
}
extern "C" {
    pub fn g_io_channel_unref(channel: *mut GIOChannel);
}
extern "C" {
    pub fn g_io_channel_read(
        channel: *mut GIOChannel,
        buf: *mut gchar,
        count: gsize,
        bytes_read: *mut gsize,
    ) -> GIOError;
}
extern "C" {
    pub fn g_io_channel_write(
        channel: *mut GIOChannel,
        buf: *const gchar,
        count: gsize,
        bytes_written: *mut gsize,
    ) -> GIOError;
}
extern "C" {
    pub fn g_io_channel_seek(
        channel: *mut GIOChannel,
        offset: gint64,
        type_: GSeekType,
    ) -> GIOError;
}
extern "C" {
    pub fn g_io_channel_close(channel: *mut GIOChannel);
}
extern "C" {
    pub fn g_io_channel_shutdown(
        channel: *mut GIOChannel,
        flush: gboolean,
        err: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_add_watch_full(
        channel: *mut GIOChannel,
        priority: gint,
        condition: GIOCondition,
        func: GIOFunc,
        user_data: gpointer,
        notify: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_io_create_watch(channel: *mut GIOChannel, condition: GIOCondition) -> *mut GSource;
}
extern "C" {
    pub fn g_io_add_watch(
        channel: *mut GIOChannel,
        condition: GIOCondition,
        func: GIOFunc,
        user_data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_io_channel_set_buffer_size(channel: *mut GIOChannel, size: gsize);
}
extern "C" {
    pub fn g_io_channel_get_buffer_size(channel: *mut GIOChannel) -> gsize;
}
extern "C" {
    pub fn g_io_channel_get_buffer_condition(channel: *mut GIOChannel) -> GIOCondition;
}
extern "C" {
    pub fn g_io_channel_set_flags(
        channel: *mut GIOChannel,
        flags: GIOFlags,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_get_flags(channel: *mut GIOChannel) -> GIOFlags;
}
extern "C" {
    pub fn g_io_channel_set_line_term(
        channel: *mut GIOChannel,
        line_term: *const gchar,
        length: gint,
    );
}
extern "C" {
    pub fn g_io_channel_get_line_term(channel: *mut GIOChannel, length: *mut gint) -> *const gchar;
}
extern "C" {
    pub fn g_io_channel_set_buffered(channel: *mut GIOChannel, buffered: gboolean);
}
extern "C" {
    pub fn g_io_channel_get_buffered(channel: *mut GIOChannel) -> gboolean;
}
extern "C" {
    pub fn g_io_channel_set_encoding(
        channel: *mut GIOChannel,
        encoding: *const gchar,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_get_encoding(channel: *mut GIOChannel) -> *const gchar;
}
extern "C" {
    pub fn g_io_channel_set_close_on_unref(channel: *mut GIOChannel, do_close: gboolean);
}
extern "C" {
    pub fn g_io_channel_get_close_on_unref(channel: *mut GIOChannel) -> gboolean;
}
extern "C" {
    pub fn g_io_channel_flush(channel: *mut GIOChannel, error: *mut *mut GError) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_read_line(
        channel: *mut GIOChannel,
        str_return: *mut *mut gchar,
        length: *mut gsize,
        terminator_pos: *mut gsize,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_read_line_string(
        channel: *mut GIOChannel,
        buffer: *mut GString,
        terminator_pos: *mut gsize,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_read_to_end(
        channel: *mut GIOChannel,
        str_return: *mut *mut gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_read_chars(
        channel: *mut GIOChannel,
        buf: *mut gchar,
        count: gsize,
        bytes_read: *mut gsize,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_read_unichar(
        channel: *mut GIOChannel,
        thechar: *mut gunichar,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_write_chars(
        channel: *mut GIOChannel,
        buf: *const gchar,
        count: gssize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_write_unichar(
        channel: *mut GIOChannel,
        thechar: gunichar,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_seek_position(
        channel: *mut GIOChannel,
        offset: gint64,
        type_: GSeekType,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_new_file(
        filename: *const gchar,
        mode: *const gchar,
        error: *mut *mut GError,
    ) -> *mut GIOChannel;
}
extern "C" {
    pub fn g_io_channel_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_io_channel_error_from_errno(en: gint) -> GIOChannelError;
}
extern "C" {
    pub fn g_io_channel_unix_new(fd: ::std::os::raw::c_int) -> *mut GIOChannel;
}
extern "C" {
    pub fn g_io_channel_unix_get_fd(channel: *mut GIOChannel) -> gint;
}
extern "C" {
    pub static mut g_io_watch_funcs: GSourceFuncs;
}
pub const GKeyFileError_G_KEY_FILE_ERROR_UNKNOWN_ENCODING: GKeyFileError = 0;
pub const GKeyFileError_G_KEY_FILE_ERROR_PARSE: GKeyFileError = 1;
pub const GKeyFileError_G_KEY_FILE_ERROR_NOT_FOUND: GKeyFileError = 2;
pub const GKeyFileError_G_KEY_FILE_ERROR_KEY_NOT_FOUND: GKeyFileError = 3;
pub const GKeyFileError_G_KEY_FILE_ERROR_GROUP_NOT_FOUND: GKeyFileError = 4;
pub const GKeyFileError_G_KEY_FILE_ERROR_INVALID_VALUE: GKeyFileError = 5;
pub type GKeyFileError = u32;
extern "C" {
    pub fn g_key_file_error_quark() -> GQuark;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GKeyFile {
    _unused: [u8; 0],
}
pub type GKeyFile = _GKeyFile;
pub const GKeyFileFlags_G_KEY_FILE_NONE: GKeyFileFlags = 0;
pub const GKeyFileFlags_G_KEY_FILE_KEEP_COMMENTS: GKeyFileFlags = 1;
pub const GKeyFileFlags_G_KEY_FILE_KEEP_TRANSLATIONS: GKeyFileFlags = 2;
pub type GKeyFileFlags = u32;
extern "C" {
    pub fn g_key_file_new() -> *mut GKeyFile;
}
extern "C" {
    pub fn g_key_file_ref(key_file: *mut GKeyFile) -> *mut GKeyFile;
}
extern "C" {
    pub fn g_key_file_unref(key_file: *mut GKeyFile);
}
extern "C" {
    pub fn g_key_file_free(key_file: *mut GKeyFile);
}
extern "C" {
    pub fn g_key_file_set_list_separator(key_file: *mut GKeyFile, separator: gchar);
}
extern "C" {
    pub fn g_key_file_load_from_file(
        key_file: *mut GKeyFile,
        file: *const gchar,
        flags: GKeyFileFlags,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_load_from_data(
        key_file: *mut GKeyFile,
        data: *const gchar,
        length: gsize,
        flags: GKeyFileFlags,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_load_from_bytes(
        key_file: *mut GKeyFile,
        bytes: *mut GBytes,
        flags: GKeyFileFlags,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_load_from_dirs(
        key_file: *mut GKeyFile,
        file: *const gchar,
        search_dirs: *mut *const gchar,
        full_path: *mut *mut gchar,
        flags: GKeyFileFlags,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_load_from_data_dirs(
        key_file: *mut GKeyFile,
        file: *const gchar,
        full_path: *mut *mut gchar,
        flags: GKeyFileFlags,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_to_data(
        key_file: *mut GKeyFile,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_save_to_file(
        key_file: *mut GKeyFile,
        filename: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_get_start_group(key_file: *mut GKeyFile) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_get_groups(key_file: *mut GKeyFile, length: *mut gsize) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_key_file_get_keys(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_key_file_has_group(key_file: *mut GKeyFile, group_name: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_key_file_has_key(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_get_value(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_set_value(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: *const gchar,
    );
}
extern "C" {
    pub fn g_key_file_get_string(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_set_string(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        string: *const gchar,
    );
}
extern "C" {
    pub fn g_key_file_get_locale_string(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        locale: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_get_locale_for_key(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        locale: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_set_locale_string(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        locale: *const gchar,
        string: *const gchar,
    );
}
extern "C" {
    pub fn g_key_file_get_boolean(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_set_boolean(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: gboolean,
    );
}
extern "C" {
    pub fn g_key_file_get_integer(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gint;
}
extern "C" {
    pub fn g_key_file_set_integer(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: gint,
    );
}
extern "C" {
    pub fn g_key_file_get_int64(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gint64;
}
extern "C" {
    pub fn g_key_file_set_int64(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: gint64,
    );
}
extern "C" {
    pub fn g_key_file_get_uint64(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> guint64;
}
extern "C" {
    pub fn g_key_file_set_uint64(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: guint64,
    );
}
extern "C" {
    pub fn g_key_file_get_double(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gdouble;
}
extern "C" {
    pub fn g_key_file_set_double(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: gdouble,
    );
}
extern "C" {
    pub fn g_key_file_get_string_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_key_file_set_string_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        list: *const *const gchar,
        length: gsize,
    );
}
extern "C" {
    pub fn g_key_file_get_locale_string_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        locale: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_key_file_set_locale_string_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        locale: *const gchar,
        list: *const *const gchar,
        length: gsize,
    );
}
extern "C" {
    pub fn g_key_file_get_boolean_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gboolean;
}
extern "C" {
    pub fn g_key_file_set_boolean_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        list: *mut gboolean,
        length: gsize,
    );
}
extern "C" {
    pub fn g_key_file_get_integer_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gint;
}
extern "C" {
    pub fn g_key_file_set_double_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        list: *mut gdouble,
        length: gsize,
    );
}
extern "C" {
    pub fn g_key_file_get_double_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gdouble;
}
extern "C" {
    pub fn g_key_file_set_integer_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        list: *mut gint,
        length: gsize,
    );
}
extern "C" {
    pub fn g_key_file_set_comment(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        comment: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_get_comment(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_remove_comment(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_remove_key(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_remove_group(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMappedFile {
    _unused: [u8; 0],
}
pub type GMappedFile = _GMappedFile;
extern "C" {
    pub fn g_mapped_file_new(
        filename: *const gchar,
        writable: gboolean,
        error: *mut *mut GError,
    ) -> *mut GMappedFile;
}
extern "C" {
    pub fn g_mapped_file_new_from_fd(
        fd: gint,
        writable: gboolean,
        error: *mut *mut GError,
    ) -> *mut GMappedFile;
}
extern "C" {
    pub fn g_mapped_file_get_length(file: *mut GMappedFile) -> gsize;
}
extern "C" {
    pub fn g_mapped_file_get_contents(file: *mut GMappedFile) -> *mut gchar;
}
extern "C" {
    pub fn g_mapped_file_get_bytes(file: *mut GMappedFile) -> *mut GBytes;
}
extern "C" {
    pub fn g_mapped_file_ref(file: *mut GMappedFile) -> *mut GMappedFile;
}
extern "C" {
    pub fn g_mapped_file_unref(file: *mut GMappedFile);
}
extern "C" {
    pub fn g_mapped_file_free(file: *mut GMappedFile);
}
pub const GMarkupError_G_MARKUP_ERROR_BAD_UTF8: GMarkupError = 0;
pub const GMarkupError_G_MARKUP_ERROR_EMPTY: GMarkupError = 1;
pub const GMarkupError_G_MARKUP_ERROR_PARSE: GMarkupError = 2;
pub const GMarkupError_G_MARKUP_ERROR_UNKNOWN_ELEMENT: GMarkupError = 3;
pub const GMarkupError_G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE: GMarkupError = 4;
pub const GMarkupError_G_MARKUP_ERROR_INVALID_CONTENT: GMarkupError = 5;
pub const GMarkupError_G_MARKUP_ERROR_MISSING_ATTRIBUTE: GMarkupError = 6;
pub type GMarkupError = u32;
extern "C" {
    pub fn g_markup_error_quark() -> GQuark;
}
pub const GMarkupParseFlags_G_MARKUP_DO_NOT_USE_THIS_UNSUPPORTED_FLAG: GMarkupParseFlags = 1;
pub const GMarkupParseFlags_G_MARKUP_TREAT_CDATA_AS_TEXT: GMarkupParseFlags = 2;
pub const GMarkupParseFlags_G_MARKUP_PREFIX_ERROR_POSITION: GMarkupParseFlags = 4;
pub const GMarkupParseFlags_G_MARKUP_IGNORE_QUALIFIED: GMarkupParseFlags = 8;
pub type GMarkupParseFlags = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMarkupParseContext {
    _unused: [u8; 0],
}
pub type GMarkupParseContext = _GMarkupParseContext;
pub type GMarkupParser = _GMarkupParser;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GMarkupParser {
    pub start_element: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GMarkupParseContext,
            element_name: *const gchar,
            attribute_names: *mut *const gchar,
            attribute_values: *mut *const gchar,
            user_data: gpointer,
            error: *mut *mut GError,
        ),
    >,
    pub end_element: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GMarkupParseContext,
            element_name: *const gchar,
            user_data: gpointer,
            error: *mut *mut GError,
        ),
    >,
    pub text: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GMarkupParseContext,
            text: *const gchar,
            text_len: gsize,
            user_data: gpointer,
            error: *mut *mut GError,
        ),
    >,
    pub passthrough: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GMarkupParseContext,
            passthrough_text: *const gchar,
            text_len: gsize,
            user_data: gpointer,
            error: *mut *mut GError,
        ),
    >,
    pub error: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GMarkupParseContext,
            error: *mut GError,
            user_data: gpointer,
        ),
    >,
}
#[test]
fn bindgen_test_layout__GMarkupParser() {
    assert_eq!(
        ::std::mem::size_of::<_GMarkupParser>(),
        40usize,
        concat!("Size of: ", stringify!(_GMarkupParser))
    );
    assert_eq!(
        ::std::mem::align_of::<_GMarkupParser>(),
        8usize,
        concat!("Alignment of ", stringify!(_GMarkupParser))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMarkupParser>())).start_element as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMarkupParser),
            "::",
            stringify!(start_element)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMarkupParser>())).end_element as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMarkupParser),
            "::",
            stringify!(end_element)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMarkupParser>())).text as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMarkupParser),
            "::",
            stringify!(text)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMarkupParser>())).passthrough as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMarkupParser),
            "::",
            stringify!(passthrough)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GMarkupParser>())).error as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GMarkupParser),
            "::",
            stringify!(error)
        )
    );
}
extern "C" {
    pub fn g_markup_parse_context_new(
        parser: *const GMarkupParser,
        flags: GMarkupParseFlags,
        user_data: gpointer,
        user_data_dnotify: GDestroyNotify,
    ) -> *mut GMarkupParseContext;
}
extern "C" {
    pub fn g_markup_parse_context_ref(
        context: *mut GMarkupParseContext,
    ) -> *mut GMarkupParseContext;
}
extern "C" {
    pub fn g_markup_parse_context_unref(context: *mut GMarkupParseContext);
}
extern "C" {
    pub fn g_markup_parse_context_free(context: *mut GMarkupParseContext);
}
extern "C" {
    pub fn g_markup_parse_context_parse(
        context: *mut GMarkupParseContext,
        text: *const gchar,
        text_len: gssize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_markup_parse_context_push(
        context: *mut GMarkupParseContext,
        parser: *const GMarkupParser,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_markup_parse_context_pop(context: *mut GMarkupParseContext) -> gpointer;
}
extern "C" {
    pub fn g_markup_parse_context_end_parse(
        context: *mut GMarkupParseContext,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_markup_parse_context_get_element(context: *mut GMarkupParseContext) -> *const gchar;
}
extern "C" {
    pub fn g_markup_parse_context_get_element_stack(
        context: *mut GMarkupParseContext,
    ) -> *const GSList;
}
extern "C" {
    pub fn g_markup_parse_context_get_position(
        context: *mut GMarkupParseContext,
        line_number: *mut gint,
        char_number: *mut gint,
    );
}
extern "C" {
    pub fn g_markup_parse_context_get_user_data(context: *mut GMarkupParseContext) -> gpointer;
}
extern "C" {
    pub fn g_markup_escape_text(text: *const gchar, length: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_markup_printf_escaped(format: *const ::std::os::raw::c_char, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_markup_vprintf_escaped(
        format: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    ) -> *mut gchar;
}
pub const GMarkupCollectType_G_MARKUP_COLLECT_INVALID: GMarkupCollectType = 0;
pub const GMarkupCollectType_G_MARKUP_COLLECT_STRING: GMarkupCollectType = 1;
pub const GMarkupCollectType_G_MARKUP_COLLECT_STRDUP: GMarkupCollectType = 2;
pub const GMarkupCollectType_G_MARKUP_COLLECT_BOOLEAN: GMarkupCollectType = 3;
pub const GMarkupCollectType_G_MARKUP_COLLECT_TRISTATE: GMarkupCollectType = 4;
pub const GMarkupCollectType_G_MARKUP_COLLECT_OPTIONAL: GMarkupCollectType = 65536;
pub type GMarkupCollectType = u32;
extern "C" {
    pub fn g_markup_collect_attributes(
        element_name: *const gchar,
        attribute_names: *mut *const gchar,
        attribute_values: *mut *const gchar,
        error: *mut *mut GError,
        first_type: GMarkupCollectType,
        first_attr: *const gchar,
        ...
    ) -> gboolean;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GVariantType {
    _unused: [u8; 0],
}
pub type GVariantType = _GVariantType;
extern "C" {
    pub fn g_variant_type_string_is_valid(type_string: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_string_scan(
        string: *const gchar,
        limit: *const gchar,
        endptr: *mut *const gchar,
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_free(type_: *mut GVariantType);
}
extern "C" {
    pub fn g_variant_type_copy(type_: *const GVariantType) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_new(type_string: *const gchar) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_get_string_length(type_: *const GVariantType) -> gsize;
}
extern "C" {
    pub fn g_variant_type_peek_string(type_: *const GVariantType) -> *const gchar;
}
extern "C" {
    pub fn g_variant_type_dup_string(type_: *const GVariantType) -> *mut gchar;
}
extern "C" {
    pub fn g_variant_type_is_definite(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_container(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_basic(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_maybe(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_array(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_tuple(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_dict_entry(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_variant(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_hash(type_: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_variant_type_equal(type1: gconstpointer, type2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_subtype_of(
        type_: *const GVariantType,
        supertype: *const GVariantType,
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_element(type_: *const GVariantType) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_first(type_: *const GVariantType) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_next(type_: *const GVariantType) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_n_items(type_: *const GVariantType) -> gsize;
}
extern "C" {
    pub fn g_variant_type_key(type_: *const GVariantType) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_value(type_: *const GVariantType) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_new_array(element: *const GVariantType) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_new_maybe(element: *const GVariantType) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_new_tuple(
        items: *const *const GVariantType,
        length: gint,
    ) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_new_dict_entry(
        key: *const GVariantType,
        value: *const GVariantType,
    ) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_checked_(arg1: *const gchar) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_string_get_depth_(type_string: *const gchar) -> gsize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GVariant {
    _unused: [u8; 0],
}
pub type GVariant = _GVariant;
pub const GVariantClass_G_VARIANT_CLASS_BOOLEAN: GVariantClass = 98;
pub const GVariantClass_G_VARIANT_CLASS_BYTE: GVariantClass = 121;
pub const GVariantClass_G_VARIANT_CLASS_INT16: GVariantClass = 110;
pub const GVariantClass_G_VARIANT_CLASS_UINT16: GVariantClass = 113;
pub const GVariantClass_G_VARIANT_CLASS_INT32: GVariantClass = 105;
pub const GVariantClass_G_VARIANT_CLASS_UINT32: GVariantClass = 117;
pub const GVariantClass_G_VARIANT_CLASS_INT64: GVariantClass = 120;
pub const GVariantClass_G_VARIANT_CLASS_UINT64: GVariantClass = 116;
pub const GVariantClass_G_VARIANT_CLASS_HANDLE: GVariantClass = 104;
pub const GVariantClass_G_VARIANT_CLASS_DOUBLE: GVariantClass = 100;
pub const GVariantClass_G_VARIANT_CLASS_STRING: GVariantClass = 115;
pub const GVariantClass_G_VARIANT_CLASS_OBJECT_PATH: GVariantClass = 111;
pub const GVariantClass_G_VARIANT_CLASS_SIGNATURE: GVariantClass = 103;
pub const GVariantClass_G_VARIANT_CLASS_VARIANT: GVariantClass = 118;
pub const GVariantClass_G_VARIANT_CLASS_MAYBE: GVariantClass = 109;
pub const GVariantClass_G_VARIANT_CLASS_ARRAY: GVariantClass = 97;
pub const GVariantClass_G_VARIANT_CLASS_TUPLE: GVariantClass = 40;
pub const GVariantClass_G_VARIANT_CLASS_DICT_ENTRY: GVariantClass = 123;
pub type GVariantClass = u32;
extern "C" {
    pub fn g_variant_unref(value: *mut GVariant);
}
extern "C" {
    pub fn g_variant_ref(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_ref_sink(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_is_floating(value: *mut GVariant) -> gboolean;
}
extern "C" {
    pub fn g_variant_take_ref(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_type(value: *mut GVariant) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_get_type_string(value: *mut GVariant) -> *const gchar;
}
extern "C" {
    pub fn g_variant_is_of_type(value: *mut GVariant, type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_is_container(value: *mut GVariant) -> gboolean;
}
extern "C" {
    pub fn g_variant_classify(value: *mut GVariant) -> GVariantClass;
}
extern "C" {
    pub fn g_variant_new_boolean(value: gboolean) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_byte(value: guint8) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_int16(value: gint16) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_uint16(value: guint16) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_int32(value: gint32) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_uint32(value: guint32) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_int64(value: gint64) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_uint64(value: guint64) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_handle(value: gint32) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_double(value: gdouble) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_string(string: *const gchar) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_take_string(string: *mut gchar) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_printf(format_string: *const gchar, ...) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_object_path(object_path: *const gchar) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_is_object_path(string: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_variant_new_signature(signature: *const gchar) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_is_signature(string: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_variant_new_variant(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_strv(strv: *const *const gchar, length: gssize) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_objv(strv: *const *const gchar, length: gssize) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_bytestring(string: *const gchar) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_bytestring_array(
        strv: *const *const gchar,
        length: gssize,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_fixed_array(
        element_type: *const GVariantType,
        elements: gconstpointer,
        n_elements: gsize,
        element_size: gsize,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_boolean(value: *mut GVariant) -> gboolean;
}
extern "C" {
    pub fn g_variant_get_byte(value: *mut GVariant) -> guint8;
}
extern "C" {
    pub fn g_variant_get_int16(value: *mut GVariant) -> gint16;
}
extern "C" {
    pub fn g_variant_get_uint16(value: *mut GVariant) -> guint16;
}
extern "C" {
    pub fn g_variant_get_int32(value: *mut GVariant) -> gint32;
}
extern "C" {
    pub fn g_variant_get_uint32(value: *mut GVariant) -> guint32;
}
extern "C" {
    pub fn g_variant_get_int64(value: *mut GVariant) -> gint64;
}
extern "C" {
    pub fn g_variant_get_uint64(value: *mut GVariant) -> guint64;
}
extern "C" {
    pub fn g_variant_get_handle(value: *mut GVariant) -> gint32;
}
extern "C" {
    pub fn g_variant_get_double(value: *mut GVariant) -> gdouble;
}
extern "C" {
    pub fn g_variant_get_variant(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_string(value: *mut GVariant, length: *mut gsize) -> *const gchar;
}
extern "C" {
    pub fn g_variant_dup_string(value: *mut GVariant, length: *mut gsize) -> *mut gchar;
}
extern "C" {
    pub fn g_variant_get_strv(value: *mut GVariant, length: *mut gsize) -> *mut *const gchar;
}
extern "C" {
    pub fn g_variant_dup_strv(value: *mut GVariant, length: *mut gsize) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_variant_get_objv(value: *mut GVariant, length: *mut gsize) -> *mut *const gchar;
}
extern "C" {
    pub fn g_variant_dup_objv(value: *mut GVariant, length: *mut gsize) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_variant_get_bytestring(value: *mut GVariant) -> *const gchar;
}
extern "C" {
    pub fn g_variant_dup_bytestring(value: *mut GVariant, length: *mut gsize) -> *mut gchar;
}
extern "C" {
    pub fn g_variant_get_bytestring_array(
        value: *mut GVariant,
        length: *mut gsize,
    ) -> *mut *const gchar;
}
extern "C" {
    pub fn g_variant_dup_bytestring_array(
        value: *mut GVariant,
        length: *mut gsize,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_variant_new_maybe(
        child_type: *const GVariantType,
        child: *mut GVariant,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_array(
        child_type: *const GVariantType,
        children: *const *mut GVariant,
        n_children: gsize,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_tuple(children: *const *mut GVariant, n_children: gsize) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_dict_entry(key: *mut GVariant, value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_maybe(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_n_children(value: *mut GVariant) -> gsize;
}
extern "C" {
    pub fn g_variant_get_child(
        value: *mut GVariant,
        index_: gsize,
        format_string: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_variant_get_child_value(value: *mut GVariant, index_: gsize) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_lookup(
        dictionary: *mut GVariant,
        key: *const gchar,
        format_string: *const gchar,
        ...
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_lookup_value(
        dictionary: *mut GVariant,
        key: *const gchar,
        expected_type: *const GVariantType,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_fixed_array(
        value: *mut GVariant,
        n_elements: *mut gsize,
        element_size: gsize,
    ) -> gconstpointer;
}
extern "C" {
    pub fn g_variant_get_size(value: *mut GVariant) -> gsize;
}
extern "C" {
    pub fn g_variant_get_data(value: *mut GVariant) -> gconstpointer;
}
extern "C" {
    pub fn g_variant_get_data_as_bytes(value: *mut GVariant) -> *mut GBytes;
}
extern "C" {
    pub fn g_variant_store(value: *mut GVariant, data: gpointer);
}
extern "C" {
    pub fn g_variant_print(value: *mut GVariant, type_annotate: gboolean) -> *mut gchar;
}
extern "C" {
    pub fn g_variant_print_string(
        value: *mut GVariant,
        string: *mut GString,
        type_annotate: gboolean,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_variant_hash(value: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_variant_equal(one: gconstpointer, two: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_variant_get_normal_form(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_is_normal_form(value: *mut GVariant) -> gboolean;
}
extern "C" {
    pub fn g_variant_byteswap(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_from_bytes(
        type_: *const GVariantType,
        bytes: *mut GBytes,
        trusted: gboolean,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_from_data(
        type_: *const GVariantType,
        data: gconstpointer,
        size: gsize,
        trusted: gboolean,
        notify: GDestroyNotify,
        user_data: gpointer,
    ) -> *mut GVariant;
}
pub type GVariantIter = _GVariantIter;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GVariantIter {
    pub x: [gsize; 16usize],
}
#[test]
fn bindgen_test_layout__GVariantIter() {
    assert_eq!(
        ::std::mem::size_of::<_GVariantIter>(),
        128usize,
        concat!("Size of: ", stringify!(_GVariantIter))
    );
    assert_eq!(
        ::std::mem::align_of::<_GVariantIter>(),
        8usize,
        concat!("Alignment of ", stringify!(_GVariantIter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GVariantIter>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantIter),
            "::",
            stringify!(x)
        )
    );
}
extern "C" {
    pub fn g_variant_iter_new(value: *mut GVariant) -> *mut GVariantIter;
}
extern "C" {
    pub fn g_variant_iter_init(iter: *mut GVariantIter, value: *mut GVariant) -> gsize;
}
extern "C" {
    pub fn g_variant_iter_copy(iter: *mut GVariantIter) -> *mut GVariantIter;
}
extern "C" {
    pub fn g_variant_iter_n_children(iter: *mut GVariantIter) -> gsize;
}
extern "C" {
    pub fn g_variant_iter_free(iter: *mut GVariantIter);
}
extern "C" {
    pub fn g_variant_iter_next_value(iter: *mut GVariantIter) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_iter_next(
        iter: *mut GVariantIter,
        format_string: *const gchar,
        ...
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_iter_loop(
        iter: *mut GVariantIter,
        format_string: *const gchar,
        ...
    ) -> gboolean;
}
pub type GVariantBuilder = _GVariantBuilder;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GVariantBuilder {
    pub u: _GVariantBuilder__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GVariantBuilder__bindgen_ty_1 {
    pub s: _GVariantBuilder__bindgen_ty_1__bindgen_ty_1,
    pub x: [gsize; 16usize],
    _bindgen_union_align: [u64; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GVariantBuilder__bindgen_ty_1__bindgen_ty_1 {
    pub partial_magic: gsize,
    pub type_: *const GVariantType,
    pub y: [gsize; 14usize],
}
#[test]
fn bindgen_test_layout__GVariantBuilder__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_GVariantBuilder__bindgen_ty_1__bindgen_ty_1>(),
        128usize,
        concat!(
            "Size of: ",
            stringify!(_GVariantBuilder__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_GVariantBuilder__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_GVariantBuilder__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GVariantBuilder__bindgen_ty_1__bindgen_ty_1>())).partial_magic
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantBuilder__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(partial_magic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GVariantBuilder__bindgen_ty_1__bindgen_ty_1>())).type_
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantBuilder__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GVariantBuilder__bindgen_ty_1__bindgen_ty_1>())).y as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantBuilder__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(y)
        )
    );
}
#[test]
fn bindgen_test_layout__GVariantBuilder__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_GVariantBuilder__bindgen_ty_1>(),
        128usize,
        concat!("Size of: ", stringify!(_GVariantBuilder__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_GVariantBuilder__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_GVariantBuilder__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GVariantBuilder__bindgen_ty_1>())).s as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantBuilder__bindgen_ty_1),
            "::",
            stringify!(s)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GVariantBuilder__bindgen_ty_1>())).x as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantBuilder__bindgen_ty_1),
            "::",
            stringify!(x)
        )
    );
}
impl ::std::fmt::Debug for _GVariantBuilder__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GVariantBuilder__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout__GVariantBuilder() {
    assert_eq!(
        ::std::mem::size_of::<_GVariantBuilder>(),
        128usize,
        concat!("Size of: ", stringify!(_GVariantBuilder))
    );
    assert_eq!(
        ::std::mem::align_of::<_GVariantBuilder>(),
        8usize,
        concat!("Alignment of ", stringify!(_GVariantBuilder))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GVariantBuilder>())).u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantBuilder),
            "::",
            stringify!(u)
        )
    );
}
impl ::std::fmt::Debug for _GVariantBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GVariantBuilder {{ u: {:?} }}", self.u)
    }
}
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_FAILED: GVariantParseError = 0;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_BASIC_TYPE_EXPECTED: GVariantParseError = 1;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_CANNOT_INFER_TYPE: GVariantParseError = 2;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_DEFINITE_TYPE_EXPECTED: GVariantParseError = 3;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INPUT_NOT_AT_END: GVariantParseError = 4;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INVALID_CHARACTER: GVariantParseError = 5;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INVALID_FORMAT_STRING: GVariantParseError = 6;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INVALID_OBJECT_PATH: GVariantParseError = 7;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INVALID_SIGNATURE: GVariantParseError = 8;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INVALID_TYPE_STRING: GVariantParseError = 9;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_NO_COMMON_TYPE: GVariantParseError = 10;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_NUMBER_OUT_OF_RANGE: GVariantParseError = 11;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_NUMBER_TOO_BIG: GVariantParseError = 12;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_TYPE_ERROR: GVariantParseError = 13;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_UNEXPECTED_TOKEN: GVariantParseError = 14;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_UNKNOWN_KEYWORD: GVariantParseError = 15;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_UNTERMINATED_STRING_CONSTANT:
    GVariantParseError = 16;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_VALUE_EXPECTED: GVariantParseError = 17;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_RECURSION: GVariantParseError = 18;
pub type GVariantParseError = u32;
extern "C" {
    pub fn g_variant_parser_get_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_variant_parse_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_variant_builder_new(type_: *const GVariantType) -> *mut GVariantBuilder;
}
extern "C" {
    pub fn g_variant_builder_unref(builder: *mut GVariantBuilder);
}
extern "C" {
    pub fn g_variant_builder_ref(builder: *mut GVariantBuilder) -> *mut GVariantBuilder;
}
extern "C" {
    pub fn g_variant_builder_init(builder: *mut GVariantBuilder, type_: *const GVariantType);
}
extern "C" {
    pub fn g_variant_builder_end(builder: *mut GVariantBuilder) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_builder_clear(builder: *mut GVariantBuilder);
}
extern "C" {
    pub fn g_variant_builder_open(builder: *mut GVariantBuilder, type_: *const GVariantType);
}
extern "C" {
    pub fn g_variant_builder_close(builder: *mut GVariantBuilder);
}
extern "C" {
    pub fn g_variant_builder_add_value(builder: *mut GVariantBuilder, value: *mut GVariant);
}
extern "C" {
    pub fn g_variant_builder_add(builder: *mut GVariantBuilder, format_string: *const gchar, ...);
}
extern "C" {
    pub fn g_variant_builder_add_parsed(builder: *mut GVariantBuilder, format: *const gchar, ...);
}
extern "C" {
    pub fn g_variant_new(format_string: *const gchar, ...) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get(value: *mut GVariant, format_string: *const gchar, ...);
}
extern "C" {
    pub fn g_variant_new_va(
        format_string: *const gchar,
        endptr: *mut *const gchar,
        app: *mut va_list,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_va(
        value: *mut GVariant,
        format_string: *const gchar,
        endptr: *mut *const gchar,
        app: *mut va_list,
    );
}
extern "C" {
    pub fn g_variant_check_format_string(
        value: *mut GVariant,
        format_string: *const gchar,
        copy_only: gboolean,
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_parse(
        type_: *const GVariantType,
        text: *const gchar,
        limit: *const gchar,
        endptr: *mut *const gchar,
        error: *mut *mut GError,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_parsed(format: *const gchar, ...) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_parsed_va(format: *const gchar, app: *mut va_list) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_parse_error_print_context(
        error: *mut GError,
        source_str: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_variant_compare(one: gconstpointer, two: gconstpointer) -> gint;
}
pub type GVariantDict = _GVariantDict;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GVariantDict {
    pub u: _GVariantDict__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GVariantDict__bindgen_ty_1 {
    pub s: _GVariantDict__bindgen_ty_1__bindgen_ty_1,
    pub x: [gsize; 16usize],
    _bindgen_union_align: [u64; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GVariantDict__bindgen_ty_1__bindgen_ty_1 {
    pub asv: *mut GVariant,
    pub partial_magic: gsize,
    pub y: [gsize; 14usize],
}
#[test]
fn bindgen_test_layout__GVariantDict__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_GVariantDict__bindgen_ty_1__bindgen_ty_1>(),
        128usize,
        concat!(
            "Size of: ",
            stringify!(_GVariantDict__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_GVariantDict__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_GVariantDict__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GVariantDict__bindgen_ty_1__bindgen_ty_1>())).asv as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantDict__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(asv)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GVariantDict__bindgen_ty_1__bindgen_ty_1>())).partial_magic
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantDict__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(partial_magic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GVariantDict__bindgen_ty_1__bindgen_ty_1>())).y as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantDict__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(y)
        )
    );
}
#[test]
fn bindgen_test_layout__GVariantDict__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_GVariantDict__bindgen_ty_1>(),
        128usize,
        concat!("Size of: ", stringify!(_GVariantDict__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_GVariantDict__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_GVariantDict__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GVariantDict__bindgen_ty_1>())).s as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantDict__bindgen_ty_1),
            "::",
            stringify!(s)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GVariantDict__bindgen_ty_1>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantDict__bindgen_ty_1),
            "::",
            stringify!(x)
        )
    );
}
impl ::std::fmt::Debug for _GVariantDict__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GVariantDict__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout__GVariantDict() {
    assert_eq!(
        ::std::mem::size_of::<_GVariantDict>(),
        128usize,
        concat!("Size of: ", stringify!(_GVariantDict))
    );
    assert_eq!(
        ::std::mem::align_of::<_GVariantDict>(),
        8usize,
        concat!("Alignment of ", stringify!(_GVariantDict))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GVariantDict>())).u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GVariantDict),
            "::",
            stringify!(u)
        )
    );
}
impl ::std::fmt::Debug for _GVariantDict {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GVariantDict {{ u: {:?} }}", self.u)
    }
}
extern "C" {
    pub fn g_variant_dict_new(from_asv: *mut GVariant) -> *mut GVariantDict;
}
extern "C" {
    pub fn g_variant_dict_init(dict: *mut GVariantDict, from_asv: *mut GVariant);
}
extern "C" {
    pub fn g_variant_dict_lookup(
        dict: *mut GVariantDict,
        key: *const gchar,
        format_string: *const gchar,
        ...
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_dict_lookup_value(
        dict: *mut GVariantDict,
        key: *const gchar,
        expected_type: *const GVariantType,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_dict_contains(dict: *mut GVariantDict, key: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_variant_dict_insert(
        dict: *mut GVariantDict,
        key: *const gchar,
        format_string: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_variant_dict_insert_value(
        dict: *mut GVariantDict,
        key: *const gchar,
        value: *mut GVariant,
    );
}
extern "C" {
    pub fn g_variant_dict_remove(dict: *mut GVariantDict, key: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_variant_dict_clear(dict: *mut GVariantDict);
}
extern "C" {
    pub fn g_variant_dict_end(dict: *mut GVariantDict) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_dict_ref(dict: *mut GVariantDict) -> *mut GVariantDict;
}
extern "C" {
    pub fn g_variant_dict_unref(dict: *mut GVariantDict);
}
extern "C" {
    pub fn g_printf_string_upper_bound(format: *const gchar, args: *mut __va_list_tag) -> gsize;
}
pub const GLogLevelFlags_G_LOG_FLAG_RECURSION: GLogLevelFlags = 1;
pub const GLogLevelFlags_G_LOG_FLAG_FATAL: GLogLevelFlags = 2;
pub const GLogLevelFlags_G_LOG_LEVEL_ERROR: GLogLevelFlags = 4;
pub const GLogLevelFlags_G_LOG_LEVEL_CRITICAL: GLogLevelFlags = 8;
pub const GLogLevelFlags_G_LOG_LEVEL_WARNING: GLogLevelFlags = 16;
pub const GLogLevelFlags_G_LOG_LEVEL_MESSAGE: GLogLevelFlags = 32;
pub const GLogLevelFlags_G_LOG_LEVEL_INFO: GLogLevelFlags = 64;
pub const GLogLevelFlags_G_LOG_LEVEL_DEBUG: GLogLevelFlags = 128;
pub const GLogLevelFlags_G_LOG_LEVEL_MASK: GLogLevelFlags = -4;
pub type GLogLevelFlags = i32;
pub type GLogFunc = ::std::option::Option<
    unsafe extern "C" fn(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        message: *const gchar,
        user_data: gpointer,
    ),
>;
extern "C" {
    pub fn g_log_set_handler(
        log_domain: *const gchar,
        log_levels: GLogLevelFlags,
        log_func: GLogFunc,
        user_data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_log_set_handler_full(
        log_domain: *const gchar,
        log_levels: GLogLevelFlags,
        log_func: GLogFunc,
        user_data: gpointer,
        destroy: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_log_remove_handler(log_domain: *const gchar, handler_id: guint);
}
extern "C" {
    pub fn g_log_default_handler(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        message: *const gchar,
        unused_data: gpointer,
    );
}
extern "C" {
    pub fn g_log_set_default_handler(log_func: GLogFunc, user_data: gpointer) -> GLogFunc;
}
extern "C" {
    pub fn g_log(log_domain: *const gchar, log_level: GLogLevelFlags, format: *const gchar, ...);
}
extern "C" {
    pub fn g_logv(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        format: *const gchar,
        args: *mut __va_list_tag,
    );
}
extern "C" {
    pub fn g_log_set_fatal_mask(
        log_domain: *const gchar,
        fatal_mask: GLogLevelFlags,
    ) -> GLogLevelFlags;
}
extern "C" {
    pub fn g_log_set_always_fatal(fatal_mask: GLogLevelFlags) -> GLogLevelFlags;
}
pub const GLogWriterOutput_G_LOG_WRITER_HANDLED: GLogWriterOutput = 1;
pub const GLogWriterOutput_G_LOG_WRITER_UNHANDLED: GLogWriterOutput = 0;
pub type GLogWriterOutput = u32;
pub type GLogField = _GLogField;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GLogField {
    pub key: *const gchar,
    pub value: gconstpointer,
    pub length: gssize,
}
#[test]
fn bindgen_test_layout__GLogField() {
    assert_eq!(
        ::std::mem::size_of::<_GLogField>(),
        24usize,
        concat!("Size of: ", stringify!(_GLogField))
    );
    assert_eq!(
        ::std::mem::align_of::<_GLogField>(),
        8usize,
        concat!("Alignment of ", stringify!(_GLogField))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GLogField>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GLogField),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GLogField>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GLogField),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GLogField>())).length as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GLogField),
            "::",
            stringify!(length)
        )
    );
}
pub type GLogWriterFunc = ::std::option::Option<
    unsafe extern "C" fn(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
        user_data: gpointer,
    ) -> GLogWriterOutput,
>;
extern "C" {
    pub fn g_log_structured(log_domain: *const gchar, log_level: GLogLevelFlags, ...);
}
extern "C" {
    pub fn g_log_structured_array(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
    );
}
extern "C" {
    pub fn g_log_variant(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        fields: *mut GVariant,
    );
}
extern "C" {
    pub fn g_log_set_writer_func(
        func: GLogWriterFunc,
        user_data: gpointer,
        user_data_free: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_log_writer_supports_color(output_fd: gint) -> gboolean;
}
extern "C" {
    pub fn g_log_writer_is_journald(output_fd: gint) -> gboolean;
}
extern "C" {
    pub fn g_log_writer_format_fields(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
        use_color: gboolean,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_log_writer_journald(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
        user_data: gpointer,
    ) -> GLogWriterOutput;
}
extern "C" {
    pub fn g_log_writer_standard_streams(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
        user_data: gpointer,
    ) -> GLogWriterOutput;
}
extern "C" {
    pub fn g_log_writer_default(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
        user_data: gpointer,
    ) -> GLogWriterOutput;
}
extern "C" {
    pub fn _g_log_fallback_handler(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        message: *const gchar,
        unused_data: gpointer,
    );
}
extern "C" {
    pub fn g_return_if_fail_warning(
        log_domain: *const ::std::os::raw::c_char,
        pretty_function: *const ::std::os::raw::c_char,
        expression: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_warn_message(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        warnexpr: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assert_warning(
        log_domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        pretty_function: *const ::std::os::raw::c_char,
        expression: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_log_structured_standard(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        file: *const gchar,
        line: *const gchar,
        func: *const gchar,
        message_format: *const gchar,
        ...
    );
}
pub type GPrintFunc = ::std::option::Option<unsafe extern "C" fn(string: *const gchar)>;
extern "C" {
    pub fn g_print(format: *const gchar, ...);
}
extern "C" {
    pub fn g_set_print_handler(func: GPrintFunc) -> GPrintFunc;
}
extern "C" {
    pub fn g_printerr(format: *const gchar, ...);
}
extern "C" {
    pub fn g_set_printerr_handler(func: GPrintFunc) -> GPrintFunc;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GOptionContext {
    _unused: [u8; 0],
}
pub type GOptionContext = _GOptionContext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GOptionGroup {
    _unused: [u8; 0],
}
pub type GOptionGroup = _GOptionGroup;
pub type GOptionEntry = _GOptionEntry;
pub const GOptionFlags_G_OPTION_FLAG_NONE: GOptionFlags = 0;
pub const GOptionFlags_G_OPTION_FLAG_HIDDEN: GOptionFlags = 1;
pub const GOptionFlags_G_OPTION_FLAG_IN_MAIN: GOptionFlags = 2;
pub const GOptionFlags_G_OPTION_FLAG_REVERSE: GOptionFlags = 4;
pub const GOptionFlags_G_OPTION_FLAG_NO_ARG: GOptionFlags = 8;
pub const GOptionFlags_G_OPTION_FLAG_FILENAME: GOptionFlags = 16;
pub const GOptionFlags_G_OPTION_FLAG_OPTIONAL_ARG: GOptionFlags = 32;
pub const GOptionFlags_G_OPTION_FLAG_NOALIAS: GOptionFlags = 64;
pub type GOptionFlags = u32;
pub const GOptionArg_G_OPTION_ARG_NONE: GOptionArg = 0;
pub const GOptionArg_G_OPTION_ARG_STRING: GOptionArg = 1;
pub const GOptionArg_G_OPTION_ARG_INT: GOptionArg = 2;
pub const GOptionArg_G_OPTION_ARG_CALLBACK: GOptionArg = 3;
pub const GOptionArg_G_OPTION_ARG_FILENAME: GOptionArg = 4;
pub const GOptionArg_G_OPTION_ARG_STRING_ARRAY: GOptionArg = 5;
pub const GOptionArg_G_OPTION_ARG_FILENAME_ARRAY: GOptionArg = 6;
pub const GOptionArg_G_OPTION_ARG_DOUBLE: GOptionArg = 7;
pub const GOptionArg_G_OPTION_ARG_INT64: GOptionArg = 8;
pub type GOptionArg = u32;
pub type GOptionArgFunc = ::std::option::Option<
    unsafe extern "C" fn(
        option_name: *const gchar,
        value: *const gchar,
        data: gpointer,
        error: *mut *mut GError,
    ) -> gboolean,
>;
pub type GOptionParseFunc = ::std::option::Option<
    unsafe extern "C" fn(
        context: *mut GOptionContext,
        group: *mut GOptionGroup,
        data: gpointer,
        error: *mut *mut GError,
    ) -> gboolean,
>;
pub type GOptionErrorFunc = ::std::option::Option<
    unsafe extern "C" fn(
        context: *mut GOptionContext,
        group: *mut GOptionGroup,
        data: gpointer,
        error: *mut *mut GError,
    ),
>;
pub const GOptionError_G_OPTION_ERROR_UNKNOWN_OPTION: GOptionError = 0;
pub const GOptionError_G_OPTION_ERROR_BAD_VALUE: GOptionError = 1;
pub const GOptionError_G_OPTION_ERROR_FAILED: GOptionError = 2;
pub type GOptionError = u32;
extern "C" {
    pub fn g_option_error_quark() -> GQuark;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GOptionEntry {
    pub long_name: *const gchar,
    pub short_name: gchar,
    pub flags: gint,
    pub arg: GOptionArg,
    pub arg_data: gpointer,
    pub description: *const gchar,
    pub arg_description: *const gchar,
}
#[test]
fn bindgen_test_layout__GOptionEntry() {
    assert_eq!(
        ::std::mem::size_of::<_GOptionEntry>(),
        48usize,
        concat!("Size of: ", stringify!(_GOptionEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<_GOptionEntry>(),
        8usize,
        concat!("Alignment of ", stringify!(_GOptionEntry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOptionEntry>())).long_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOptionEntry),
            "::",
            stringify!(long_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOptionEntry>())).short_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOptionEntry),
            "::",
            stringify!(short_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOptionEntry>())).flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOptionEntry),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOptionEntry>())).arg as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOptionEntry),
            "::",
            stringify!(arg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOptionEntry>())).arg_data as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOptionEntry),
            "::",
            stringify!(arg_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOptionEntry>())).description as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOptionEntry),
            "::",
            stringify!(description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOptionEntry>())).arg_description as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOptionEntry),
            "::",
            stringify!(arg_description)
        )
    );
}
extern "C" {
    pub fn g_option_context_new(parameter_string: *const gchar) -> *mut GOptionContext;
}
extern "C" {
    pub fn g_option_context_set_summary(context: *mut GOptionContext, summary: *const gchar);
}
extern "C" {
    pub fn g_option_context_get_summary(context: *mut GOptionContext) -> *const gchar;
}
extern "C" {
    pub fn g_option_context_set_description(
        context: *mut GOptionContext,
        description: *const gchar,
    );
}
extern "C" {
    pub fn g_option_context_get_description(context: *mut GOptionContext) -> *const gchar;
}
extern "C" {
    pub fn g_option_context_free(context: *mut GOptionContext);
}
extern "C" {
    pub fn g_option_context_set_help_enabled(context: *mut GOptionContext, help_enabled: gboolean);
}
extern "C" {
    pub fn g_option_context_get_help_enabled(context: *mut GOptionContext) -> gboolean;
}
extern "C" {
    pub fn g_option_context_set_ignore_unknown_options(
        context: *mut GOptionContext,
        ignore_unknown: gboolean,
    );
}
extern "C" {
    pub fn g_option_context_get_ignore_unknown_options(context: *mut GOptionContext) -> gboolean;
}
extern "C" {
    pub fn g_option_context_set_strict_posix(context: *mut GOptionContext, strict_posix: gboolean);
}
extern "C" {
    pub fn g_option_context_get_strict_posix(context: *mut GOptionContext) -> gboolean;
}
extern "C" {
    pub fn g_option_context_add_main_entries(
        context: *mut GOptionContext,
        entries: *const GOptionEntry,
        translation_domain: *const gchar,
    );
}
extern "C" {
    pub fn g_option_context_parse(
        context: *mut GOptionContext,
        argc: *mut gint,
        argv: *mut *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_option_context_parse_strv(
        context: *mut GOptionContext,
        arguments: *mut *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_option_context_set_translate_func(
        context: *mut GOptionContext,
        func: GTranslateFunc,
        data: gpointer,
        destroy_notify: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_option_context_set_translation_domain(
        context: *mut GOptionContext,
        domain: *const gchar,
    );
}
extern "C" {
    pub fn g_option_context_add_group(context: *mut GOptionContext, group: *mut GOptionGroup);
}
extern "C" {
    pub fn g_option_context_set_main_group(context: *mut GOptionContext, group: *mut GOptionGroup);
}
extern "C" {
    pub fn g_option_context_get_main_group(context: *mut GOptionContext) -> *mut GOptionGroup;
}
extern "C" {
    pub fn g_option_context_get_help(
        context: *mut GOptionContext,
        main_help: gboolean,
        group: *mut GOptionGroup,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_option_group_new(
        name: *const gchar,
        description: *const gchar,
        help_description: *const gchar,
        user_data: gpointer,
        destroy: GDestroyNotify,
    ) -> *mut GOptionGroup;
}
extern "C" {
    pub fn g_option_group_set_parse_hooks(
        group: *mut GOptionGroup,
        pre_parse_func: GOptionParseFunc,
        post_parse_func: GOptionParseFunc,
    );
}
extern "C" {
    pub fn g_option_group_set_error_hook(group: *mut GOptionGroup, error_func: GOptionErrorFunc);
}
extern "C" {
    pub fn g_option_group_free(group: *mut GOptionGroup);
}
extern "C" {
    pub fn g_option_group_ref(group: *mut GOptionGroup) -> *mut GOptionGroup;
}
extern "C" {
    pub fn g_option_group_unref(group: *mut GOptionGroup);
}
extern "C" {
    pub fn g_option_group_add_entries(group: *mut GOptionGroup, entries: *const GOptionEntry);
}
extern "C" {
    pub fn g_option_group_set_translate_func(
        group: *mut GOptionGroup,
        func: GTranslateFunc,
        data: gpointer,
        destroy_notify: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_option_group_set_translation_domain(group: *mut GOptionGroup, domain: *const gchar);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GPatternSpec {
    _unused: [u8; 0],
}
pub type GPatternSpec = _GPatternSpec;
extern "C" {
    pub fn g_pattern_spec_new(pattern: *const gchar) -> *mut GPatternSpec;
}
extern "C" {
    pub fn g_pattern_spec_free(pspec: *mut GPatternSpec);
}
extern "C" {
    pub fn g_pattern_spec_equal(pspec1: *mut GPatternSpec, pspec2: *mut GPatternSpec) -> gboolean;
}
extern "C" {
    pub fn g_pattern_match(
        pspec: *mut GPatternSpec,
        string_length: guint,
        string: *const gchar,
        string_reversed: *const gchar,
    ) -> gboolean;
}
extern "C" {
    pub fn g_pattern_match_string(pspec: *mut GPatternSpec, string: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_pattern_match_simple(pattern: *const gchar, string: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_spaced_primes_closest(num: guint) -> guint;
}
extern "C" {
    pub fn g_qsort_with_data(
        pbase: gconstpointer,
        total_elems: gint,
        size: gsize,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    );
}
pub type GQueue = _GQueue;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GQueue {
    pub head: *mut GList,
    pub tail: *mut GList,
    pub length: guint,
}
#[test]
fn bindgen_test_layout__GQueue() {
    assert_eq!(
        ::std::mem::size_of::<_GQueue>(),
        24usize,
        concat!("Size of: ", stringify!(_GQueue))
    );
    assert_eq!(
        ::std::mem::align_of::<_GQueue>(),
        8usize,
        concat!("Alignment of ", stringify!(_GQueue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GQueue>())).head as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GQueue),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GQueue>())).tail as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GQueue),
            "::",
            stringify!(tail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GQueue>())).length as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GQueue),
            "::",
            stringify!(length)
        )
    );
}
extern "C" {
    pub fn g_queue_new() -> *mut GQueue;
}
extern "C" {
    pub fn g_queue_free(queue: *mut GQueue);
}
extern "C" {
    pub fn g_queue_free_full(queue: *mut GQueue, free_func: GDestroyNotify);
}
extern "C" {
    pub fn g_queue_init(queue: *mut GQueue);
}
extern "C" {
    pub fn g_queue_clear(queue: *mut GQueue);
}
extern "C" {
    pub fn g_queue_is_empty(queue: *mut GQueue) -> gboolean;
}
extern "C" {
    pub fn g_queue_clear_full(queue: *mut GQueue, free_func: GDestroyNotify);
}
extern "C" {
    pub fn g_queue_get_length(queue: *mut GQueue) -> guint;
}
extern "C" {
    pub fn g_queue_reverse(queue: *mut GQueue);
}
extern "C" {
    pub fn g_queue_copy(queue: *mut GQueue) -> *mut GQueue;
}
extern "C" {
    pub fn g_queue_foreach(queue: *mut GQueue, func: GFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_queue_find(queue: *mut GQueue, data: gconstpointer) -> *mut GList;
}
extern "C" {
    pub fn g_queue_find_custom(
        queue: *mut GQueue,
        data: gconstpointer,
        func: GCompareFunc,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_queue_sort(queue: *mut GQueue, compare_func: GCompareDataFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_queue_push_head(queue: *mut GQueue, data: gpointer);
}
extern "C" {
    pub fn g_queue_push_tail(queue: *mut GQueue, data: gpointer);
}
extern "C" {
    pub fn g_queue_push_nth(queue: *mut GQueue, data: gpointer, n: gint);
}
extern "C" {
    pub fn g_queue_pop_head(queue: *mut GQueue) -> gpointer;
}
extern "C" {
    pub fn g_queue_pop_tail(queue: *mut GQueue) -> gpointer;
}
extern "C" {
    pub fn g_queue_pop_nth(queue: *mut GQueue, n: guint) -> gpointer;
}
extern "C" {
    pub fn g_queue_peek_head(queue: *mut GQueue) -> gpointer;
}
extern "C" {
    pub fn g_queue_peek_tail(queue: *mut GQueue) -> gpointer;
}
extern "C" {
    pub fn g_queue_peek_nth(queue: *mut GQueue, n: guint) -> gpointer;
}
extern "C" {
    pub fn g_queue_index(queue: *mut GQueue, data: gconstpointer) -> gint;
}
extern "C" {
    pub fn g_queue_remove(queue: *mut GQueue, data: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_queue_remove_all(queue: *mut GQueue, data: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_queue_insert_before(queue: *mut GQueue, sibling: *mut GList, data: gpointer);
}
extern "C" {
    pub fn g_queue_insert_before_link(queue: *mut GQueue, sibling: *mut GList, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_insert_after(queue: *mut GQueue, sibling: *mut GList, data: gpointer);
}
extern "C" {
    pub fn g_queue_insert_after_link(queue: *mut GQueue, sibling: *mut GList, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_insert_sorted(
        queue: *mut GQueue,
        data: gpointer,
        func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_queue_push_head_link(queue: *mut GQueue, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_push_tail_link(queue: *mut GQueue, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_push_nth_link(queue: *mut GQueue, n: gint, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_pop_head_link(queue: *mut GQueue) -> *mut GList;
}
extern "C" {
    pub fn g_queue_pop_tail_link(queue: *mut GQueue) -> *mut GList;
}
extern "C" {
    pub fn g_queue_pop_nth_link(queue: *mut GQueue, n: guint) -> *mut GList;
}
extern "C" {
    pub fn g_queue_peek_head_link(queue: *mut GQueue) -> *mut GList;
}
extern "C" {
    pub fn g_queue_peek_tail_link(queue: *mut GQueue) -> *mut GList;
}
extern "C" {
    pub fn g_queue_peek_nth_link(queue: *mut GQueue, n: guint) -> *mut GList;
}
extern "C" {
    pub fn g_queue_link_index(queue: *mut GQueue, link_: *mut GList) -> gint;
}
extern "C" {
    pub fn g_queue_unlink(queue: *mut GQueue, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_delete_link(queue: *mut GQueue, link_: *mut GList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GRand {
    _unused: [u8; 0],
}
pub type GRand = _GRand;
extern "C" {
    pub fn g_rand_new_with_seed(seed: guint32) -> *mut GRand;
}
extern "C" {
    pub fn g_rand_new_with_seed_array(seed: *const guint32, seed_length: guint) -> *mut GRand;
}
extern "C" {
    pub fn g_rand_new() -> *mut GRand;
}
extern "C" {
    pub fn g_rand_free(rand_: *mut GRand);
}
extern "C" {
    pub fn g_rand_copy(rand_: *mut GRand) -> *mut GRand;
}
extern "C" {
    pub fn g_rand_set_seed(rand_: *mut GRand, seed: guint32);
}
extern "C" {
    pub fn g_rand_set_seed_array(rand_: *mut GRand, seed: *const guint32, seed_length: guint);
}
extern "C" {
    pub fn g_rand_int(rand_: *mut GRand) -> guint32;
}
extern "C" {
    pub fn g_rand_int_range(rand_: *mut GRand, begin: gint32, end: gint32) -> gint32;
}
extern "C" {
    pub fn g_rand_double(rand_: *mut GRand) -> gdouble;
}
extern "C" {
    pub fn g_rand_double_range(rand_: *mut GRand, begin: gdouble, end: gdouble) -> gdouble;
}
extern "C" {
    pub fn g_random_set_seed(seed: guint32);
}
extern "C" {
    pub fn g_random_int() -> guint32;
}
extern "C" {
    pub fn g_random_int_range(begin: gint32, end: gint32) -> gint32;
}
extern "C" {
    pub fn g_random_double() -> gdouble;
}
extern "C" {
    pub fn g_random_double_range(begin: gdouble, end: gdouble) -> gdouble;
}
extern "C" {
    pub fn g_rc_box_alloc(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_rc_box_alloc0(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_rc_box_dup(block_size: gsize, mem_block: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_rc_box_acquire(mem_block: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_rc_box_release(mem_block: gpointer);
}
extern "C" {
    pub fn g_rc_box_release_full(mem_block: gpointer, clear_func: GDestroyNotify);
}
extern "C" {
    pub fn g_rc_box_get_size(mem_block: gpointer) -> gsize;
}
extern "C" {
    pub fn g_atomic_rc_box_alloc(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_atomic_rc_box_alloc0(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_atomic_rc_box_dup(block_size: gsize, mem_block: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_atomic_rc_box_acquire(mem_block: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_atomic_rc_box_release(mem_block: gpointer);
}
extern "C" {
    pub fn g_atomic_rc_box_release_full(mem_block: gpointer, clear_func: GDestroyNotify);
}
extern "C" {
    pub fn g_atomic_rc_box_get_size(mem_block: gpointer) -> gsize;
}
extern "C" {
    pub fn g_ref_count_init(rc: *mut grefcount);
}
extern "C" {
    pub fn g_ref_count_inc(rc: *mut grefcount);
}
extern "C" {
    pub fn g_ref_count_dec(rc: *mut grefcount) -> gboolean;
}
extern "C" {
    pub fn g_ref_count_compare(rc: *mut grefcount, val: gint) -> gboolean;
}
extern "C" {
    pub fn g_atomic_ref_count_init(arc: *mut gatomicrefcount);
}
extern "C" {
    pub fn g_atomic_ref_count_inc(arc: *mut gatomicrefcount);
}
extern "C" {
    pub fn g_atomic_ref_count_dec(arc: *mut gatomicrefcount) -> gboolean;
}
extern "C" {
    pub fn g_atomic_ref_count_compare(arc: *mut gatomicrefcount, val: gint) -> gboolean;
}
extern "C" {
    pub fn g_ref_string_new(str: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_ref_string_new_len(
        str: *const ::std::os::raw::c_char,
        len: gssize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_ref_string_new_intern(
        str: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_ref_string_acquire(str: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_ref_string_release(str: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_ref_string_length(str: *mut ::std::os::raw::c_char) -> gsize;
}
pub type GRefString = ::std::os::raw::c_char;
pub const GRegexError_G_REGEX_ERROR_COMPILE: GRegexError = 0;
pub const GRegexError_G_REGEX_ERROR_OPTIMIZE: GRegexError = 1;
pub const GRegexError_G_REGEX_ERROR_REPLACE: GRegexError = 2;
pub const GRegexError_G_REGEX_ERROR_MATCH: GRegexError = 3;
pub const GRegexError_G_REGEX_ERROR_INTERNAL: GRegexError = 4;
pub const GRegexError_G_REGEX_ERROR_STRAY_BACKSLASH: GRegexError = 101;
pub const GRegexError_G_REGEX_ERROR_MISSING_CONTROL_CHAR: GRegexError = 102;
pub const GRegexError_G_REGEX_ERROR_UNRECOGNIZED_ESCAPE: GRegexError = 103;
pub const GRegexError_G_REGEX_ERROR_QUANTIFIERS_OUT_OF_ORDER: GRegexError = 104;
pub const GRegexError_G_REGEX_ERROR_QUANTIFIER_TOO_BIG: GRegexError = 105;
pub const GRegexError_G_REGEX_ERROR_UNTERMINATED_CHARACTER_CLASS: GRegexError = 106;
pub const GRegexError_G_REGEX_ERROR_INVALID_ESCAPE_IN_CHARACTER_CLASS: GRegexError = 107;
pub const GRegexError_G_REGEX_ERROR_RANGE_OUT_OF_ORDER: GRegexError = 108;
pub const GRegexError_G_REGEX_ERROR_NOTHING_TO_REPEAT: GRegexError = 109;
pub const GRegexError_G_REGEX_ERROR_UNRECOGNIZED_CHARACTER: GRegexError = 112;
pub const GRegexError_G_REGEX_ERROR_POSIX_NAMED_CLASS_OUTSIDE_CLASS: GRegexError = 113;
pub const GRegexError_G_REGEX_ERROR_UNMATCHED_PARENTHESIS: GRegexError = 114;
pub const GRegexError_G_REGEX_ERROR_INEXISTENT_SUBPATTERN_REFERENCE: GRegexError = 115;
pub const GRegexError_G_REGEX_ERROR_UNTERMINATED_COMMENT: GRegexError = 118;
pub const GRegexError_G_REGEX_ERROR_EXPRESSION_TOO_LARGE: GRegexError = 120;
pub const GRegexError_G_REGEX_ERROR_MEMORY_ERROR: GRegexError = 121;
pub const GRegexError_G_REGEX_ERROR_VARIABLE_LENGTH_LOOKBEHIND: GRegexError = 125;
pub const GRegexError_G_REGEX_ERROR_MALFORMED_CONDITION: GRegexError = 126;
pub const GRegexError_G_REGEX_ERROR_TOO_MANY_CONDITIONAL_BRANCHES: GRegexError = 127;
pub const GRegexError_G_REGEX_ERROR_ASSERTION_EXPECTED: GRegexError = 128;
pub const GRegexError_G_REGEX_ERROR_UNKNOWN_POSIX_CLASS_NAME: GRegexError = 130;
pub const GRegexError_G_REGEX_ERROR_POSIX_COLLATING_ELEMENTS_NOT_SUPPORTED: GRegexError = 131;
pub const GRegexError_G_REGEX_ERROR_HEX_CODE_TOO_LARGE: GRegexError = 134;
pub const GRegexError_G_REGEX_ERROR_INVALID_CONDITION: GRegexError = 135;
pub const GRegexError_G_REGEX_ERROR_SINGLE_BYTE_MATCH_IN_LOOKBEHIND: GRegexError = 136;
pub const GRegexError_G_REGEX_ERROR_INFINITE_LOOP: GRegexError = 140;
pub const GRegexError_G_REGEX_ERROR_MISSING_SUBPATTERN_NAME_TERMINATOR: GRegexError = 142;
pub const GRegexError_G_REGEX_ERROR_DUPLICATE_SUBPATTERN_NAME: GRegexError = 143;
pub const GRegexError_G_REGEX_ERROR_MALFORMED_PROPERTY: GRegexError = 146;
pub const GRegexError_G_REGEX_ERROR_UNKNOWN_PROPERTY: GRegexError = 147;
pub const GRegexError_G_REGEX_ERROR_SUBPATTERN_NAME_TOO_LONG: GRegexError = 148;
pub const GRegexError_G_REGEX_ERROR_TOO_MANY_SUBPATTERNS: GRegexError = 149;
pub const GRegexError_G_REGEX_ERROR_INVALID_OCTAL_VALUE: GRegexError = 151;
pub const GRegexError_G_REGEX_ERROR_TOO_MANY_BRANCHES_IN_DEFINE: GRegexError = 154;
pub const GRegexError_G_REGEX_ERROR_DEFINE_REPETION: GRegexError = 155;
pub const GRegexError_G_REGEX_ERROR_INCONSISTENT_NEWLINE_OPTIONS: GRegexError = 156;
pub const GRegexError_G_REGEX_ERROR_MISSING_BACK_REFERENCE: GRegexError = 157;
pub const GRegexError_G_REGEX_ERROR_INVALID_RELATIVE_REFERENCE: GRegexError = 158;
pub const GRegexError_G_REGEX_ERROR_BACKTRACKING_CONTROL_VERB_ARGUMENT_FORBIDDEN: GRegexError = 159;
pub const GRegexError_G_REGEX_ERROR_UNKNOWN_BACKTRACKING_CONTROL_VERB: GRegexError = 160;
pub const GRegexError_G_REGEX_ERROR_NUMBER_TOO_BIG: GRegexError = 161;
pub const GRegexError_G_REGEX_ERROR_MISSING_SUBPATTERN_NAME: GRegexError = 162;
pub const GRegexError_G_REGEX_ERROR_MISSING_DIGIT: GRegexError = 163;
pub const GRegexError_G_REGEX_ERROR_INVALID_DATA_CHARACTER: GRegexError = 164;
pub const GRegexError_G_REGEX_ERROR_EXTRA_SUBPATTERN_NAME: GRegexError = 165;
pub const GRegexError_G_REGEX_ERROR_BACKTRACKING_CONTROL_VERB_ARGUMENT_REQUIRED: GRegexError = 166;
pub const GRegexError_G_REGEX_ERROR_INVALID_CONTROL_CHAR: GRegexError = 168;
pub const GRegexError_G_REGEX_ERROR_MISSING_NAME: GRegexError = 169;
pub const GRegexError_G_REGEX_ERROR_NOT_SUPPORTED_IN_CLASS: GRegexError = 171;
pub const GRegexError_G_REGEX_ERROR_TOO_MANY_FORWARD_REFERENCES: GRegexError = 172;
pub const GRegexError_G_REGEX_ERROR_NAME_TOO_LONG: GRegexError = 175;
pub const GRegexError_G_REGEX_ERROR_CHARACTER_VALUE_TOO_LARGE: GRegexError = 176;
pub type GRegexError = u32;
extern "C" {
    pub fn g_regex_error_quark() -> GQuark;
}
pub const GRegexCompileFlags_G_REGEX_CASELESS: GRegexCompileFlags = 1;
pub const GRegexCompileFlags_G_REGEX_MULTILINE: GRegexCompileFlags = 2;
pub const GRegexCompileFlags_G_REGEX_DOTALL: GRegexCompileFlags = 4;
pub const GRegexCompileFlags_G_REGEX_EXTENDED: GRegexCompileFlags = 8;
pub const GRegexCompileFlags_G_REGEX_ANCHORED: GRegexCompileFlags = 16;
pub const GRegexCompileFlags_G_REGEX_DOLLAR_ENDONLY: GRegexCompileFlags = 32;
pub const GRegexCompileFlags_G_REGEX_UNGREEDY: GRegexCompileFlags = 512;
pub const GRegexCompileFlags_G_REGEX_RAW: GRegexCompileFlags = 2048;
pub const GRegexCompileFlags_G_REGEX_NO_AUTO_CAPTURE: GRegexCompileFlags = 4096;
pub const GRegexCompileFlags_G_REGEX_OPTIMIZE: GRegexCompileFlags = 8192;
pub const GRegexCompileFlags_G_REGEX_FIRSTLINE: GRegexCompileFlags = 262144;
pub const GRegexCompileFlags_G_REGEX_DUPNAMES: GRegexCompileFlags = 524288;
pub const GRegexCompileFlags_G_REGEX_NEWLINE_CR: GRegexCompileFlags = 1048576;
pub const GRegexCompileFlags_G_REGEX_NEWLINE_LF: GRegexCompileFlags = 2097152;
pub const GRegexCompileFlags_G_REGEX_NEWLINE_CRLF: GRegexCompileFlags = 3145728;
pub const GRegexCompileFlags_G_REGEX_NEWLINE_ANYCRLF: GRegexCompileFlags = 5242880;
pub const GRegexCompileFlags_G_REGEX_BSR_ANYCRLF: GRegexCompileFlags = 8388608;
pub const GRegexCompileFlags_G_REGEX_JAVASCRIPT_COMPAT: GRegexCompileFlags = 33554432;
pub type GRegexCompileFlags = u32;
pub const GRegexMatchFlags_G_REGEX_MATCH_ANCHORED: GRegexMatchFlags = 16;
pub const GRegexMatchFlags_G_REGEX_MATCH_NOTBOL: GRegexMatchFlags = 128;
pub const GRegexMatchFlags_G_REGEX_MATCH_NOTEOL: GRegexMatchFlags = 256;
pub const GRegexMatchFlags_G_REGEX_MATCH_NOTEMPTY: GRegexMatchFlags = 1024;
pub const GRegexMatchFlags_G_REGEX_MATCH_PARTIAL: GRegexMatchFlags = 32768;
pub const GRegexMatchFlags_G_REGEX_MATCH_NEWLINE_CR: GRegexMatchFlags = 1048576;
pub const GRegexMatchFlags_G_REGEX_MATCH_NEWLINE_LF: GRegexMatchFlags = 2097152;
pub const GRegexMatchFlags_G_REGEX_MATCH_NEWLINE_CRLF: GRegexMatchFlags = 3145728;
pub const GRegexMatchFlags_G_REGEX_MATCH_NEWLINE_ANY: GRegexMatchFlags = 4194304;
pub const GRegexMatchFlags_G_REGEX_MATCH_NEWLINE_ANYCRLF: GRegexMatchFlags = 5242880;
pub const GRegexMatchFlags_G_REGEX_MATCH_BSR_ANYCRLF: GRegexMatchFlags = 8388608;
pub const GRegexMatchFlags_G_REGEX_MATCH_BSR_ANY: GRegexMatchFlags = 16777216;
pub const GRegexMatchFlags_G_REGEX_MATCH_PARTIAL_SOFT: GRegexMatchFlags = 32768;
pub const GRegexMatchFlags_G_REGEX_MATCH_PARTIAL_HARD: GRegexMatchFlags = 134217728;
pub const GRegexMatchFlags_G_REGEX_MATCH_NOTEMPTY_ATSTART: GRegexMatchFlags = 268435456;
pub type GRegexMatchFlags = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GRegex {
    _unused: [u8; 0],
}
pub type GRegex = _GRegex;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMatchInfo {
    _unused: [u8; 0],
}
pub type GMatchInfo = _GMatchInfo;
pub type GRegexEvalCallback = ::std::option::Option<
    unsafe extern "C" fn(
        match_info: *const GMatchInfo,
        result: *mut GString,
        user_data: gpointer,
    ) -> gboolean,
>;
extern "C" {
    pub fn g_regex_new(
        pattern: *const gchar,
        compile_options: GRegexCompileFlags,
        match_options: GRegexMatchFlags,
        error: *mut *mut GError,
    ) -> *mut GRegex;
}
extern "C" {
    pub fn g_regex_ref(regex: *mut GRegex) -> *mut GRegex;
}
extern "C" {
    pub fn g_regex_unref(regex: *mut GRegex);
}
extern "C" {
    pub fn g_regex_get_pattern(regex: *const GRegex) -> *const gchar;
}
extern "C" {
    pub fn g_regex_get_max_backref(regex: *const GRegex) -> gint;
}
extern "C" {
    pub fn g_regex_get_capture_count(regex: *const GRegex) -> gint;
}
extern "C" {
    pub fn g_regex_get_has_cr_or_lf(regex: *const GRegex) -> gboolean;
}
extern "C" {
    pub fn g_regex_get_max_lookbehind(regex: *const GRegex) -> gint;
}
extern "C" {
    pub fn g_regex_get_string_number(regex: *const GRegex, name: *const gchar) -> gint;
}
extern "C" {
    pub fn g_regex_escape_string(string: *const gchar, length: gint) -> *mut gchar;
}
extern "C" {
    pub fn g_regex_escape_nul(string: *const gchar, length: gint) -> *mut gchar;
}
extern "C" {
    pub fn g_regex_get_compile_flags(regex: *const GRegex) -> GRegexCompileFlags;
}
extern "C" {
    pub fn g_regex_get_match_flags(regex: *const GRegex) -> GRegexMatchFlags;
}
extern "C" {
    pub fn g_regex_match_simple(
        pattern: *const gchar,
        string: *const gchar,
        compile_options: GRegexCompileFlags,
        match_options: GRegexMatchFlags,
    ) -> gboolean;
}
extern "C" {
    pub fn g_regex_match(
        regex: *const GRegex,
        string: *const gchar,
        match_options: GRegexMatchFlags,
        match_info: *mut *mut GMatchInfo,
    ) -> gboolean;
}
extern "C" {
    pub fn g_regex_match_full(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        match_options: GRegexMatchFlags,
        match_info: *mut *mut GMatchInfo,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_regex_match_all(
        regex: *const GRegex,
        string: *const gchar,
        match_options: GRegexMatchFlags,
        match_info: *mut *mut GMatchInfo,
    ) -> gboolean;
}
extern "C" {
    pub fn g_regex_match_all_full(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        match_options: GRegexMatchFlags,
        match_info: *mut *mut GMatchInfo,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_regex_split_simple(
        pattern: *const gchar,
        string: *const gchar,
        compile_options: GRegexCompileFlags,
        match_options: GRegexMatchFlags,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_regex_split(
        regex: *const GRegex,
        string: *const gchar,
        match_options: GRegexMatchFlags,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_regex_split_full(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        match_options: GRegexMatchFlags,
        max_tokens: gint,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_regex_replace(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        replacement: *const gchar,
        match_options: GRegexMatchFlags,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_regex_replace_literal(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        replacement: *const gchar,
        match_options: GRegexMatchFlags,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_regex_replace_eval(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        match_options: GRegexMatchFlags,
        eval: GRegexEvalCallback,
        user_data: gpointer,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_regex_check_replacement(
        replacement: *const gchar,
        has_references: *mut gboolean,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_match_info_get_regex(match_info: *const GMatchInfo) -> *mut GRegex;
}
extern "C" {
    pub fn g_match_info_get_string(match_info: *const GMatchInfo) -> *const gchar;
}
extern "C" {
    pub fn g_match_info_ref(match_info: *mut GMatchInfo) -> *mut GMatchInfo;
}
extern "C" {
    pub fn g_match_info_unref(match_info: *mut GMatchInfo);
}
extern "C" {
    pub fn g_match_info_free(match_info: *mut GMatchInfo);
}
extern "C" {
    pub fn g_match_info_next(match_info: *mut GMatchInfo, error: *mut *mut GError) -> gboolean;
}
extern "C" {
    pub fn g_match_info_matches(match_info: *const GMatchInfo) -> gboolean;
}
extern "C" {
    pub fn g_match_info_get_match_count(match_info: *const GMatchInfo) -> gint;
}
extern "C" {
    pub fn g_match_info_is_partial_match(match_info: *const GMatchInfo) -> gboolean;
}
extern "C" {
    pub fn g_match_info_expand_references(
        match_info: *const GMatchInfo,
        string_to_expand: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_match_info_fetch(match_info: *const GMatchInfo, match_num: gint) -> *mut gchar;
}
extern "C" {
    pub fn g_match_info_fetch_pos(
        match_info: *const GMatchInfo,
        match_num: gint,
        start_pos: *mut gint,
        end_pos: *mut gint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_match_info_fetch_named(
        match_info: *const GMatchInfo,
        name: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_match_info_fetch_named_pos(
        match_info: *const GMatchInfo,
        name: *const gchar,
        start_pos: *mut gint,
        end_pos: *mut gint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_match_info_fetch_all(match_info: *const GMatchInfo) -> *mut *mut gchar;
}
pub type GScanner = _GScanner;
pub type GScannerConfig = _GScannerConfig;
pub type GTokenValue = _GTokenValue;
pub type GScannerMsgFunc = ::std::option::Option<
    unsafe extern "C" fn(scanner: *mut GScanner, message: *mut gchar, error: gboolean),
>;
pub const GErrorType_G_ERR_UNKNOWN: GErrorType = 0;
pub const GErrorType_G_ERR_UNEXP_EOF: GErrorType = 1;
pub const GErrorType_G_ERR_UNEXP_EOF_IN_STRING: GErrorType = 2;
pub const GErrorType_G_ERR_UNEXP_EOF_IN_COMMENT: GErrorType = 3;
pub const GErrorType_G_ERR_NON_DIGIT_IN_CONST: GErrorType = 4;
pub const GErrorType_G_ERR_DIGIT_RADIX: GErrorType = 5;
pub const GErrorType_G_ERR_FLOAT_RADIX: GErrorType = 6;
pub const GErrorType_G_ERR_FLOAT_MALFORMED: GErrorType = 7;
pub type GErrorType = u32;
pub const GTokenType_G_TOKEN_EOF: GTokenType = 0;
pub const GTokenType_G_TOKEN_LEFT_PAREN: GTokenType = 40;
pub const GTokenType_G_TOKEN_RIGHT_PAREN: GTokenType = 41;
pub const GTokenType_G_TOKEN_LEFT_CURLY: GTokenType = 123;
pub const GTokenType_G_TOKEN_RIGHT_CURLY: GTokenType = 125;
pub const GTokenType_G_TOKEN_LEFT_BRACE: GTokenType = 91;
pub const GTokenType_G_TOKEN_RIGHT_BRACE: GTokenType = 93;
pub const GTokenType_G_TOKEN_EQUAL_SIGN: GTokenType = 61;
pub const GTokenType_G_TOKEN_COMMA: GTokenType = 44;
pub const GTokenType_G_TOKEN_NONE: GTokenType = 256;
pub const GTokenType_G_TOKEN_ERROR: GTokenType = 257;
pub const GTokenType_G_TOKEN_CHAR: GTokenType = 258;
pub const GTokenType_G_TOKEN_BINARY: GTokenType = 259;
pub const GTokenType_G_TOKEN_OCTAL: GTokenType = 260;
pub const GTokenType_G_TOKEN_INT: GTokenType = 261;
pub const GTokenType_G_TOKEN_HEX: GTokenType = 262;
pub const GTokenType_G_TOKEN_FLOAT: GTokenType = 263;
pub const GTokenType_G_TOKEN_STRING: GTokenType = 264;
pub const GTokenType_G_TOKEN_SYMBOL: GTokenType = 265;
pub const GTokenType_G_TOKEN_IDENTIFIER: GTokenType = 266;
pub const GTokenType_G_TOKEN_IDENTIFIER_NULL: GTokenType = 267;
pub const GTokenType_G_TOKEN_COMMENT_SINGLE: GTokenType = 268;
pub const GTokenType_G_TOKEN_COMMENT_MULTI: GTokenType = 269;
pub const GTokenType_G_TOKEN_LAST: GTokenType = 270;
pub type GTokenType = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GTokenValue {
    pub v_symbol: gpointer,
    pub v_identifier: *mut gchar,
    pub v_binary: gulong,
    pub v_octal: gulong,
    pub v_int: gulong,
    pub v_int64: guint64,
    pub v_float: gdouble,
    pub v_hex: gulong,
    pub v_string: *mut gchar,
    pub v_comment: *mut gchar,
    pub v_char: guchar,
    pub v_error: guint,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout__GTokenValue() {
    assert_eq!(
        ::std::mem::size_of::<_GTokenValue>(),
        8usize,
        concat!("Size of: ", stringify!(_GTokenValue))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTokenValue>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTokenValue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_symbol as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_symbol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_identifier as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_identifier)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_binary as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_binary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_octal as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_octal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_int64 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_int64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_float as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_float)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_hex as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_hex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_string as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_string)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_comment as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_comment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_char as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_char)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTokenValue>())).v_error as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTokenValue),
            "::",
            stringify!(v_error)
        )
    );
}
impl ::std::fmt::Debug for _GTokenValue {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GTokenValue {{ union }}")
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GScannerConfig {
    pub cset_skip_characters: *mut gchar,
    pub cset_identifier_first: *mut gchar,
    pub cset_identifier_nth: *mut gchar,
    pub cpair_comment_single: *mut gchar,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize], u8>,
    pub padding_dummy: guint,
}
#[test]
fn bindgen_test_layout__GScannerConfig() {
    assert_eq!(
        ::std::mem::size_of::<_GScannerConfig>(),
        40usize,
        concat!("Size of: ", stringify!(_GScannerConfig))
    );
    assert_eq!(
        ::std::mem::align_of::<_GScannerConfig>(),
        8usize,
        concat!("Alignment of ", stringify!(_GScannerConfig))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GScannerConfig>())).cset_skip_characters as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScannerConfig),
            "::",
            stringify!(cset_skip_characters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GScannerConfig>())).cset_identifier_first as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScannerConfig),
            "::",
            stringify!(cset_identifier_first)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GScannerConfig>())).cset_identifier_nth as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScannerConfig),
            "::",
            stringify!(cset_identifier_nth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GScannerConfig>())).cpair_comment_single as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScannerConfig),
            "::",
            stringify!(cpair_comment_single)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScannerConfig>())).padding_dummy as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScannerConfig),
            "::",
            stringify!(padding_dummy)
        )
    );
}
impl _GScannerConfig {
    #[inline]
    pub fn case_sensitive(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_case_sensitive(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn skip_comment_multi(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_skip_comment_multi(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn skip_comment_single(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_skip_comment_single(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_comment_multi(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_comment_multi(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_identifier(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_identifier(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_identifier_1char(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_identifier_1char(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_identifier_NULL(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_identifier_NULL(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_symbols(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_symbols(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_binary(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_binary(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_octal(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_octal(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_float(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_float(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_hex(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_hex(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_hex_dollar(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_hex_dollar(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_string_sq(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_string_sq(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_string_dq(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_string_dq(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn numbers_2_int(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_numbers_2_int(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn int_2_float(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_int_2_float(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn identifier_2_string(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_identifier_2_string(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn char_2_token(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_char_2_token(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn symbol_2_token(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_symbol_2_token(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scope_0_fallback(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scope_0_fallback(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn store_int64(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_store_int64(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        case_sensitive: guint,
        skip_comment_multi: guint,
        skip_comment_single: guint,
        scan_comment_multi: guint,
        scan_identifier: guint,
        scan_identifier_1char: guint,
        scan_identifier_NULL: guint,
        scan_symbols: guint,
        scan_binary: guint,
        scan_octal: guint,
        scan_float: guint,
        scan_hex: guint,
        scan_hex_dollar: guint,
        scan_string_sq: guint,
        scan_string_dq: guint,
        numbers_2_int: guint,
        int_2_float: guint,
        identifier_2_string: guint,
        char_2_token: guint,
        symbol_2_token: guint,
        scope_0_fallback: guint,
        store_int64: guint,
    ) -> __BindgenBitfieldUnit<[u8; 3usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let case_sensitive: u32 = unsafe { ::std::mem::transmute(case_sensitive) };
            case_sensitive as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let skip_comment_multi: u32 = unsafe { ::std::mem::transmute(skip_comment_multi) };
            skip_comment_multi as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let skip_comment_single: u32 = unsafe { ::std::mem::transmute(skip_comment_single) };
            skip_comment_single as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let scan_comment_multi: u32 = unsafe { ::std::mem::transmute(scan_comment_multi) };
            scan_comment_multi as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let scan_identifier: u32 = unsafe { ::std::mem::transmute(scan_identifier) };
            scan_identifier as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let scan_identifier_1char: u32 =
                unsafe { ::std::mem::transmute(scan_identifier_1char) };
            scan_identifier_1char as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let scan_identifier_NULL: u32 = unsafe { ::std::mem::transmute(scan_identifier_NULL) };
            scan_identifier_NULL as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let scan_symbols: u32 = unsafe { ::std::mem::transmute(scan_symbols) };
            scan_symbols as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let scan_binary: u32 = unsafe { ::std::mem::transmute(scan_binary) };
            scan_binary as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let scan_octal: u32 = unsafe { ::std::mem::transmute(scan_octal) };
            scan_octal as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let scan_float: u32 = unsafe { ::std::mem::transmute(scan_float) };
            scan_float as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let scan_hex: u32 = unsafe { ::std::mem::transmute(scan_hex) };
            scan_hex as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let scan_hex_dollar: u32 = unsafe { ::std::mem::transmute(scan_hex_dollar) };
            scan_hex_dollar as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let scan_string_sq: u32 = unsafe { ::std::mem::transmute(scan_string_sq) };
            scan_string_sq as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let scan_string_dq: u32 = unsafe { ::std::mem::transmute(scan_string_dq) };
            scan_string_dq as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let numbers_2_int: u32 = unsafe { ::std::mem::transmute(numbers_2_int) };
            numbers_2_int as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let int_2_float: u32 = unsafe { ::std::mem::transmute(int_2_float) };
            int_2_float as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let identifier_2_string: u32 = unsafe { ::std::mem::transmute(identifier_2_string) };
            identifier_2_string as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let char_2_token: u32 = unsafe { ::std::mem::transmute(char_2_token) };
            char_2_token as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let symbol_2_token: u32 = unsafe { ::std::mem::transmute(symbol_2_token) };
            symbol_2_token as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let scope_0_fallback: u32 = unsafe { ::std::mem::transmute(scope_0_fallback) };
            scope_0_fallback as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let store_int64: u32 = unsafe { ::std::mem::transmute(store_int64) };
            store_int64 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GScanner {
    pub user_data: gpointer,
    pub max_parse_errors: guint,
    pub parse_errors: guint,
    pub input_name: *const gchar,
    pub qdata: *mut GData,
    pub config: *mut GScannerConfig,
    pub token: GTokenType,
    pub value: GTokenValue,
    pub line: guint,
    pub position: guint,
    pub next_token: GTokenType,
    pub next_value: GTokenValue,
    pub next_line: guint,
    pub next_position: guint,
    pub symbol_table: *mut GHashTable,
    pub input_fd: gint,
    pub text: *const gchar,
    pub text_end: *const gchar,
    pub buffer: *mut gchar,
    pub scope_id: guint,
    pub msg_handler: GScannerMsgFunc,
}
#[test]
fn bindgen_test_layout__GScanner() {
    assert_eq!(
        ::std::mem::size_of::<_GScanner>(),
        144usize,
        concat!("Size of: ", stringify!(_GScanner))
    );
    assert_eq!(
        ::std::mem::align_of::<_GScanner>(),
        8usize,
        concat!("Alignment of ", stringify!(_GScanner))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).user_data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(user_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).max_parse_errors as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(max_parse_errors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).parse_errors as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(parse_errors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).input_name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(input_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).qdata as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(qdata)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).config as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(config)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).token as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(token)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).value as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).line as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).position as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(position)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).next_token as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(next_token)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).next_value as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(next_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).next_line as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(next_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).next_position as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(next_position)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).symbol_table as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(symbol_table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).input_fd as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(input_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).text as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(text)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).text_end as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(text_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).buffer as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).scope_id as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(scope_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GScanner>())).msg_handler as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_GScanner),
            "::",
            stringify!(msg_handler)
        )
    );
}
impl ::std::fmt::Debug for _GScanner {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! ( f , "_GScanner {{ user_data: {:?}, max_parse_errors: {:?}, parse_errors: {:?}, input_name: {:?}, qdata: {:?}, config: {:?}, token: {:?}, value: {:?}, line: {:?}, position: {:?}, next_token: {:?}, next_value: {:?}, next_line: {:?}, next_position: {:?}, symbol_table: {:?}, input_fd: {:?}, text: {:?}, text_end: {:?}, buffer: {:?}, scope_id: {:?}, msg_handler: {:?} }}" , self . user_data , self . max_parse_errors , self . parse_errors , self . input_name , self . qdata , self . config , self . token , self . value , self . line , self . position , self . next_token , self . next_value , self . next_line , self . next_position , self . symbol_table , self . input_fd , self . text , self . text_end , self . buffer , self . scope_id , self . msg_handler )
    }
}
extern "C" {
    pub fn g_scanner_new(config_templ: *const GScannerConfig) -> *mut GScanner;
}
extern "C" {
    pub fn g_scanner_destroy(scanner: *mut GScanner);
}
extern "C" {
    pub fn g_scanner_input_file(scanner: *mut GScanner, input_fd: gint);
}
extern "C" {
    pub fn g_scanner_sync_file_offset(scanner: *mut GScanner);
}
extern "C" {
    pub fn g_scanner_input_text(scanner: *mut GScanner, text: *const gchar, text_len: guint);
}
extern "C" {
    pub fn g_scanner_get_next_token(scanner: *mut GScanner) -> GTokenType;
}
extern "C" {
    pub fn g_scanner_peek_next_token(scanner: *mut GScanner) -> GTokenType;
}
extern "C" {
    pub fn g_scanner_cur_token(scanner: *mut GScanner) -> GTokenType;
}
extern "C" {
    pub fn g_scanner_cur_value(scanner: *mut GScanner) -> GTokenValue;
}
extern "C" {
    pub fn g_scanner_cur_line(scanner: *mut GScanner) -> guint;
}
extern "C" {
    pub fn g_scanner_cur_position(scanner: *mut GScanner) -> guint;
}
extern "C" {
    pub fn g_scanner_eof(scanner: *mut GScanner) -> gboolean;
}
extern "C" {
    pub fn g_scanner_set_scope(scanner: *mut GScanner, scope_id: guint) -> guint;
}
extern "C" {
    pub fn g_scanner_scope_add_symbol(
        scanner: *mut GScanner,
        scope_id: guint,
        symbol: *const gchar,
        value: gpointer,
    );
}
extern "C" {
    pub fn g_scanner_scope_remove_symbol(
        scanner: *mut GScanner,
        scope_id: guint,
        symbol: *const gchar,
    );
}
extern "C" {
    pub fn g_scanner_scope_lookup_symbol(
        scanner: *mut GScanner,
        scope_id: guint,
        symbol: *const gchar,
    ) -> gpointer;
}
extern "C" {
    pub fn g_scanner_scope_foreach_symbol(
        scanner: *mut GScanner,
        scope_id: guint,
        func: GHFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_scanner_lookup_symbol(scanner: *mut GScanner, symbol: *const gchar) -> gpointer;
}
extern "C" {
    pub fn g_scanner_unexp_token(
        scanner: *mut GScanner,
        expected_token: GTokenType,
        identifier_spec: *const gchar,
        symbol_spec: *const gchar,
        symbol_name: *const gchar,
        message: *const gchar,
        is_error: gint,
    );
}
extern "C" {
    pub fn g_scanner_error(scanner: *mut GScanner, format: *const gchar, ...);
}
extern "C" {
    pub fn g_scanner_warn(scanner: *mut GScanner, format: *const gchar, ...);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSequence {
    _unused: [u8; 0],
}
pub type GSequence = _GSequence;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSequenceNode {
    _unused: [u8; 0],
}
pub type GSequenceIter = _GSequenceNode;
pub type GSequenceIterCompareFunc = ::std::option::Option<
    unsafe extern "C" fn(a: *mut GSequenceIter, b: *mut GSequenceIter, data: gpointer) -> gint,
>;
extern "C" {
    pub fn g_sequence_new(data_destroy: GDestroyNotify) -> *mut GSequence;
}
extern "C" {
    pub fn g_sequence_free(seq: *mut GSequence);
}
extern "C" {
    pub fn g_sequence_get_length(seq: *mut GSequence) -> gint;
}
extern "C" {
    pub fn g_sequence_foreach(seq: *mut GSequence, func: GFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_sequence_foreach_range(
        begin: *mut GSequenceIter,
        end: *mut GSequenceIter,
        func: GFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_sequence_sort(seq: *mut GSequence, cmp_func: GCompareDataFunc, cmp_data: gpointer);
}
extern "C" {
    pub fn g_sequence_sort_iter(
        seq: *mut GSequence,
        cmp_func: GSequenceIterCompareFunc,
        cmp_data: gpointer,
    );
}
extern "C" {
    pub fn g_sequence_is_empty(seq: *mut GSequence) -> gboolean;
}
extern "C" {
    pub fn g_sequence_get_begin_iter(seq: *mut GSequence) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_get_end_iter(seq: *mut GSequence) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_get_iter_at_pos(seq: *mut GSequence, pos: gint) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_append(seq: *mut GSequence, data: gpointer) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_prepend(seq: *mut GSequence, data: gpointer) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_insert_before(iter: *mut GSequenceIter, data: gpointer)
        -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_move(src: *mut GSequenceIter, dest: *mut GSequenceIter);
}
extern "C" {
    pub fn g_sequence_swap(a: *mut GSequenceIter, b: *mut GSequenceIter);
}
extern "C" {
    pub fn g_sequence_insert_sorted(
        seq: *mut GSequence,
        data: gpointer,
        cmp_func: GCompareDataFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_insert_sorted_iter(
        seq: *mut GSequence,
        data: gpointer,
        iter_cmp: GSequenceIterCompareFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_sort_changed(
        iter: *mut GSequenceIter,
        cmp_func: GCompareDataFunc,
        cmp_data: gpointer,
    );
}
extern "C" {
    pub fn g_sequence_sort_changed_iter(
        iter: *mut GSequenceIter,
        iter_cmp: GSequenceIterCompareFunc,
        cmp_data: gpointer,
    );
}
extern "C" {
    pub fn g_sequence_remove(iter: *mut GSequenceIter);
}
extern "C" {
    pub fn g_sequence_remove_range(begin: *mut GSequenceIter, end: *mut GSequenceIter);
}
extern "C" {
    pub fn g_sequence_move_range(
        dest: *mut GSequenceIter,
        begin: *mut GSequenceIter,
        end: *mut GSequenceIter,
    );
}
extern "C" {
    pub fn g_sequence_search(
        seq: *mut GSequence,
        data: gpointer,
        cmp_func: GCompareDataFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_search_iter(
        seq: *mut GSequence,
        data: gpointer,
        iter_cmp: GSequenceIterCompareFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_lookup(
        seq: *mut GSequence,
        data: gpointer,
        cmp_func: GCompareDataFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_lookup_iter(
        seq: *mut GSequence,
        data: gpointer,
        iter_cmp: GSequenceIterCompareFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_get(iter: *mut GSequenceIter) -> gpointer;
}
extern "C" {
    pub fn g_sequence_set(iter: *mut GSequenceIter, data: gpointer);
}
extern "C" {
    pub fn g_sequence_iter_is_begin(iter: *mut GSequenceIter) -> gboolean;
}
extern "C" {
    pub fn g_sequence_iter_is_end(iter: *mut GSequenceIter) -> gboolean;
}
extern "C" {
    pub fn g_sequence_iter_next(iter: *mut GSequenceIter) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_iter_prev(iter: *mut GSequenceIter) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_iter_get_position(iter: *mut GSequenceIter) -> gint;
}
extern "C" {
    pub fn g_sequence_iter_move(iter: *mut GSequenceIter, delta: gint) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_iter_get_sequence(iter: *mut GSequenceIter) -> *mut GSequence;
}
extern "C" {
    pub fn g_sequence_iter_compare(a: *mut GSequenceIter, b: *mut GSequenceIter) -> gint;
}
extern "C" {
    pub fn g_sequence_range_get_midpoint(
        begin: *mut GSequenceIter,
        end: *mut GSequenceIter,
    ) -> *mut GSequenceIter;
}
pub const GShellError_G_SHELL_ERROR_BAD_QUOTING: GShellError = 0;
pub const GShellError_G_SHELL_ERROR_EMPTY_STRING: GShellError = 1;
pub const GShellError_G_SHELL_ERROR_FAILED: GShellError = 2;
pub type GShellError = u32;
extern "C" {
    pub fn g_shell_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_shell_quote(unquoted_string: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_shell_unquote(quoted_string: *const gchar, error: *mut *mut GError) -> *mut gchar;
}
extern "C" {
    pub fn g_shell_parse_argv(
        command_line: *const gchar,
        argcp: *mut gint,
        argvp: *mut *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_slice_alloc(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_slice_alloc0(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_slice_copy(block_size: gsize, mem_block: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_slice_free1(block_size: gsize, mem_block: gpointer);
}
extern "C" {
    pub fn g_slice_free_chain_with_offset(
        block_size: gsize,
        mem_chain: gpointer,
        next_offset: gsize,
    );
}
pub const GSliceConfig_G_SLICE_CONFIG_ALWAYS_MALLOC: GSliceConfig = 1;
pub const GSliceConfig_G_SLICE_CONFIG_BYPASS_MAGAZINES: GSliceConfig = 2;
pub const GSliceConfig_G_SLICE_CONFIG_WORKING_SET_MSECS: GSliceConfig = 3;
pub const GSliceConfig_G_SLICE_CONFIG_COLOR_INCREMENT: GSliceConfig = 4;
pub const GSliceConfig_G_SLICE_CONFIG_CHUNK_SIZES: GSliceConfig = 5;
pub const GSliceConfig_G_SLICE_CONFIG_CONTENTION_COUNTER: GSliceConfig = 6;
pub type GSliceConfig = u32;
extern "C" {
    pub fn g_slice_set_config(ckey: GSliceConfig, value: gint64);
}
extern "C" {
    pub fn g_slice_get_config(ckey: GSliceConfig) -> gint64;
}
extern "C" {
    pub fn g_slice_get_config_state(
        ckey: GSliceConfig,
        address: gint64,
        n_values: *mut guint,
    ) -> *mut gint64;
}
pub const GSpawnError_G_SPAWN_ERROR_FORK: GSpawnError = 0;
pub const GSpawnError_G_SPAWN_ERROR_READ: GSpawnError = 1;
pub const GSpawnError_G_SPAWN_ERROR_CHDIR: GSpawnError = 2;
pub const GSpawnError_G_SPAWN_ERROR_ACCES: GSpawnError = 3;
pub const GSpawnError_G_SPAWN_ERROR_PERM: GSpawnError = 4;
pub const GSpawnError_G_SPAWN_ERROR_TOO_BIG: GSpawnError = 5;
pub const GSpawnError_G_SPAWN_ERROR_2BIG: GSpawnError = 5;
pub const GSpawnError_G_SPAWN_ERROR_NOEXEC: GSpawnError = 6;
pub const GSpawnError_G_SPAWN_ERROR_NAMETOOLONG: GSpawnError = 7;
pub const GSpawnError_G_SPAWN_ERROR_NOENT: GSpawnError = 8;
pub const GSpawnError_G_SPAWN_ERROR_NOMEM: GSpawnError = 9;
pub const GSpawnError_G_SPAWN_ERROR_NOTDIR: GSpawnError = 10;
pub const GSpawnError_G_SPAWN_ERROR_LOOP: GSpawnError = 11;
pub const GSpawnError_G_SPAWN_ERROR_TXTBUSY: GSpawnError = 12;
pub const GSpawnError_G_SPAWN_ERROR_IO: GSpawnError = 13;
pub const GSpawnError_G_SPAWN_ERROR_NFILE: GSpawnError = 14;
pub const GSpawnError_G_SPAWN_ERROR_MFILE: GSpawnError = 15;
pub const GSpawnError_G_SPAWN_ERROR_INVAL: GSpawnError = 16;
pub const GSpawnError_G_SPAWN_ERROR_ISDIR: GSpawnError = 17;
pub const GSpawnError_G_SPAWN_ERROR_LIBBAD: GSpawnError = 18;
pub const GSpawnError_G_SPAWN_ERROR_FAILED: GSpawnError = 19;
pub type GSpawnError = u32;
pub type GSpawnChildSetupFunc = ::std::option::Option<unsafe extern "C" fn(user_data: gpointer)>;
pub const GSpawnFlags_G_SPAWN_DEFAULT: GSpawnFlags = 0;
pub const GSpawnFlags_G_SPAWN_LEAVE_DESCRIPTORS_OPEN: GSpawnFlags = 1;
pub const GSpawnFlags_G_SPAWN_DO_NOT_REAP_CHILD: GSpawnFlags = 2;
pub const GSpawnFlags_G_SPAWN_SEARCH_PATH: GSpawnFlags = 4;
pub const GSpawnFlags_G_SPAWN_STDOUT_TO_DEV_NULL: GSpawnFlags = 8;
pub const GSpawnFlags_G_SPAWN_STDERR_TO_DEV_NULL: GSpawnFlags = 16;
pub const GSpawnFlags_G_SPAWN_CHILD_INHERITS_STDIN: GSpawnFlags = 32;
pub const GSpawnFlags_G_SPAWN_FILE_AND_ARGV_ZERO: GSpawnFlags = 64;
pub const GSpawnFlags_G_SPAWN_SEARCH_PATH_FROM_ENVP: GSpawnFlags = 128;
pub const GSpawnFlags_G_SPAWN_CLOEXEC_PIPES: GSpawnFlags = 256;
pub type GSpawnFlags = u32;
extern "C" {
    pub fn g_spawn_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_spawn_exit_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_spawn_async(
        working_directory: *const gchar,
        argv: *mut *mut gchar,
        envp: *mut *mut gchar,
        flags: GSpawnFlags,
        child_setup: GSpawnChildSetupFunc,
        user_data: gpointer,
        child_pid: *mut GPid,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_async_with_pipes(
        working_directory: *const gchar,
        argv: *mut *mut gchar,
        envp: *mut *mut gchar,
        flags: GSpawnFlags,
        child_setup: GSpawnChildSetupFunc,
        user_data: gpointer,
        child_pid: *mut GPid,
        standard_input: *mut gint,
        standard_output: *mut gint,
        standard_error: *mut gint,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_async_with_fds(
        working_directory: *const gchar,
        argv: *mut *mut gchar,
        envp: *mut *mut gchar,
        flags: GSpawnFlags,
        child_setup: GSpawnChildSetupFunc,
        user_data: gpointer,
        child_pid: *mut GPid,
        stdin_fd: gint,
        stdout_fd: gint,
        stderr_fd: gint,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_sync(
        working_directory: *const gchar,
        argv: *mut *mut gchar,
        envp: *mut *mut gchar,
        flags: GSpawnFlags,
        child_setup: GSpawnChildSetupFunc,
        user_data: gpointer,
        standard_output: *mut *mut gchar,
        standard_error: *mut *mut gchar,
        exit_status: *mut gint,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_command_line_sync(
        command_line: *const gchar,
        standard_output: *mut *mut gchar,
        standard_error: *mut *mut gchar,
        exit_status: *mut gint,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_command_line_async(
        command_line: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_check_exit_status(exit_status: gint, error: *mut *mut GError) -> gboolean;
}
extern "C" {
    pub fn g_spawn_close_pid(pid: GPid);
}
pub const GAsciiType_G_ASCII_ALNUM: GAsciiType = 1;
pub const GAsciiType_G_ASCII_ALPHA: GAsciiType = 2;
pub const GAsciiType_G_ASCII_CNTRL: GAsciiType = 4;
pub const GAsciiType_G_ASCII_DIGIT: GAsciiType = 8;
pub const GAsciiType_G_ASCII_GRAPH: GAsciiType = 16;
pub const GAsciiType_G_ASCII_LOWER: GAsciiType = 32;
pub const GAsciiType_G_ASCII_PRINT: GAsciiType = 64;
pub const GAsciiType_G_ASCII_PUNCT: GAsciiType = 128;
pub const GAsciiType_G_ASCII_SPACE: GAsciiType = 256;
pub const GAsciiType_G_ASCII_UPPER: GAsciiType = 512;
pub const GAsciiType_G_ASCII_XDIGIT: GAsciiType = 1024;
pub type GAsciiType = u32;
extern "C" {
    pub static g_ascii_table: *const guint16;
}
extern "C" {
    pub fn g_ascii_tolower(c: gchar) -> gchar;
}
extern "C" {
    pub fn g_ascii_toupper(c: gchar) -> gchar;
}
extern "C" {
    pub fn g_ascii_digit_value(c: gchar) -> gint;
}
extern "C" {
    pub fn g_ascii_xdigit_value(c: gchar) -> gint;
}
extern "C" {
    pub fn g_strdelimit(
        string: *mut gchar,
        delimiters: *const gchar,
        new_delimiter: gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_strcanon(
        string: *mut gchar,
        valid_chars: *const gchar,
        substitutor: gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_strerror(errnum: gint) -> *const gchar;
}
extern "C" {
    pub fn g_strsignal(signum: gint) -> *const gchar;
}
extern "C" {
    pub fn g_strreverse(string: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strlcpy(dest: *mut gchar, src: *const gchar, dest_size: gsize) -> gsize;
}
extern "C" {
    pub fn g_strlcat(dest: *mut gchar, src: *const gchar, dest_size: gsize) -> gsize;
}
extern "C" {
    pub fn g_strstr_len(
        haystack: *const gchar,
        haystack_len: gssize,
        needle: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_strrstr(haystack: *const gchar, needle: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strrstr_len(
        haystack: *const gchar,
        haystack_len: gssize,
        needle: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_str_has_suffix(str: *const gchar, suffix: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_str_has_prefix(str: *const gchar, prefix: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_strtod(nptr: *const gchar, endptr: *mut *mut gchar) -> gdouble;
}
extern "C" {
    pub fn g_ascii_strtod(nptr: *const gchar, endptr: *mut *mut gchar) -> gdouble;
}
extern "C" {
    pub fn g_ascii_strtoull(nptr: *const gchar, endptr: *mut *mut gchar, base: guint) -> guint64;
}
extern "C" {
    pub fn g_ascii_strtoll(nptr: *const gchar, endptr: *mut *mut gchar, base: guint) -> gint64;
}
extern "C" {
    pub fn g_ascii_dtostr(buffer: *mut gchar, buf_len: gint, d: gdouble) -> *mut gchar;
}
extern "C" {
    pub fn g_ascii_formatd(
        buffer: *mut gchar,
        buf_len: gint,
        format: *const gchar,
        d: gdouble,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_strchug(string: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strchomp(string: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_ascii_strcasecmp(s1: *const gchar, s2: *const gchar) -> gint;
}
extern "C" {
    pub fn g_ascii_strncasecmp(s1: *const gchar, s2: *const gchar, n: gsize) -> gint;
}
extern "C" {
    pub fn g_ascii_strdown(str: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_ascii_strup(str: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_str_is_ascii(str: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_strcasecmp(s1: *const gchar, s2: *const gchar) -> gint;
}
extern "C" {
    pub fn g_strncasecmp(s1: *const gchar, s2: *const gchar, n: guint) -> gint;
}
extern "C" {
    pub fn g_strdown(string: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strup(string: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strdup(str: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strdup_printf(format: *const gchar, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_strdup_vprintf(format: *const gchar, args: *mut __va_list_tag) -> *mut gchar;
}
extern "C" {
    pub fn g_strndup(str: *const gchar, n: gsize) -> *mut gchar;
}
extern "C" {
    pub fn g_strnfill(length: gsize, fill_char: gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strconcat(string1: *const gchar, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_strjoin(separator: *const gchar, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_strcompress(source: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strescape(source: *const gchar, exceptions: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_memdup(mem: gconstpointer, byte_size: guint) -> gpointer;
}
pub type GStrv = *mut *mut gchar;
extern "C" {
    pub fn g_strsplit(
        string: *const gchar,
        delimiter: *const gchar,
        max_tokens: gint,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_strsplit_set(
        string: *const gchar,
        delimiters: *const gchar,
        max_tokens: gint,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_strjoinv(separator: *const gchar, str_array: *mut *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strfreev(str_array: *mut *mut gchar);
}
extern "C" {
    pub fn g_strdupv(str_array: *mut *mut gchar) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_strv_length(str_array: *mut *mut gchar) -> guint;
}
extern "C" {
    pub fn g_stpcpy(dest: *mut gchar, src: *const ::std::os::raw::c_char) -> *mut gchar;
}
extern "C" {
    pub fn g_str_to_ascii(str: *const gchar, from_locale: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_str_tokenize_and_fold(
        string: *const gchar,
        translit_locale: *const gchar,
        ascii_alternates: *mut *mut *mut gchar,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_str_match_string(
        search_term: *const gchar,
        potential_hit: *const gchar,
        accept_alternates: gboolean,
    ) -> gboolean;
}
extern "C" {
    pub fn g_strv_contains(strv: *const *const gchar, str: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_strv_equal(strv1: *const *const gchar, strv2: *const *const gchar) -> gboolean;
}
pub const GNumberParserError_G_NUMBER_PARSER_ERROR_INVALID: GNumberParserError = 0;
pub const GNumberParserError_G_NUMBER_PARSER_ERROR_OUT_OF_BOUNDS: GNumberParserError = 1;
pub type GNumberParserError = u32;
extern "C" {
    pub fn g_number_parser_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_ascii_string_to_signed(
        str: *const gchar,
        base: guint,
        min: gint64,
        max: gint64,
        out_num: *mut gint64,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_ascii_string_to_unsigned(
        str: *const gchar,
        base: guint,
        min: guint64,
        max: guint64,
        out_num: *mut guint64,
        error: *mut *mut GError,
    ) -> gboolean;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GStringChunk {
    _unused: [u8; 0],
}
pub type GStringChunk = _GStringChunk;
extern "C" {
    pub fn g_string_chunk_new(size: gsize) -> *mut GStringChunk;
}
extern "C" {
    pub fn g_string_chunk_free(chunk: *mut GStringChunk);
}
extern "C" {
    pub fn g_string_chunk_clear(chunk: *mut GStringChunk);
}
extern "C" {
    pub fn g_string_chunk_insert(chunk: *mut GStringChunk, string: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_string_chunk_insert_len(
        chunk: *mut GStringChunk,
        string: *const gchar,
        len: gssize,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_string_chunk_insert_const(
        chunk: *mut GStringChunk,
        string: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn memcpy(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcpy(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncpy(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcat(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncat(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strchr(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strspn(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strpbrk(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strstr(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strerror(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcmp(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcopy(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    );
}
extern "C" {
    pub fn bzero(arg1: *mut ::std::os::raw::c_void, arg2: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn index(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp_l(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp_l(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
        arg4: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strtok_r(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strerror_r(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn stpcpy(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnlen(arg1: *const ::std::os::raw::c_char, arg2: size_t) -> size_t;
}
extern "C" {
    pub fn strdup(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strsignal(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strerror_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcoll_l(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm_l(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
        arg4: locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn memccpy(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strsep(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlcat(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strlcpy(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn explicit_bzero(arg1: *mut ::std::os::raw::c_void, arg2: size_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GTestCase {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GTestSuite {
    _unused: [u8; 0],
}
pub type GTestFunc = ::std::option::Option<unsafe extern "C" fn()>;
pub type GTestDataFunc = ::std::option::Option<unsafe extern "C" fn(user_data: gconstpointer)>;
pub type GTestFixtureFunc =
    ::std::option::Option<unsafe extern "C" fn(fixture: gpointer, user_data: gconstpointer)>;
extern "C" {
    pub fn g_strcmp0(
        str1: *const ::std::os::raw::c_char,
        str2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_test_minimized_result(
        minimized_quantity: f64,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn g_test_maximized_result(
        maximized_quantity: f64,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn g_test_init(
        argc: *mut ::std::os::raw::c_int,
        argv: *mut *mut *mut ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn g_test_subprocess() -> gboolean;
}
extern "C" {
    pub fn g_test_run() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_test_add_func(testpath: *const ::std::os::raw::c_char, test_func: GTestFunc);
}
extern "C" {
    pub fn g_test_add_data_func(
        testpath: *const ::std::os::raw::c_char,
        test_data: gconstpointer,
        test_func: GTestDataFunc,
    );
}
extern "C" {
    pub fn g_test_add_data_func_full(
        testpath: *const ::std::os::raw::c_char,
        test_data: gpointer,
        test_func: GTestDataFunc,
        data_free_func: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_test_fail();
}
extern "C" {
    pub fn g_test_incomplete(msg: *const gchar);
}
extern "C" {
    pub fn g_test_skip(msg: *const gchar);
}
extern "C" {
    pub fn g_test_failed() -> gboolean;
}
extern "C" {
    pub fn g_test_set_nonfatal_assertions();
}
extern "C" {
    pub fn g_test_message(format: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn g_test_bug_base(uri_pattern: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_test_bug(bug_uri_snippet: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_test_summary(summary: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_test_timer_start();
}
extern "C" {
    pub fn g_test_timer_elapsed() -> f64;
}
extern "C" {
    pub fn g_test_timer_last() -> f64;
}
extern "C" {
    pub fn g_test_queue_free(gfree_pointer: gpointer);
}
extern "C" {
    pub fn g_test_queue_destroy(destroy_func: GDestroyNotify, destroy_data: gpointer);
}
pub const GTestTrapFlags_G_TEST_TRAP_SILENCE_STDOUT: GTestTrapFlags = 128;
pub const GTestTrapFlags_G_TEST_TRAP_SILENCE_STDERR: GTestTrapFlags = 256;
pub const GTestTrapFlags_G_TEST_TRAP_INHERIT_STDIN: GTestTrapFlags = 512;
pub type GTestTrapFlags = u32;
extern "C" {
    pub fn g_test_trap_fork(usec_timeout: guint64, test_trap_flags: GTestTrapFlags) -> gboolean;
}
pub const GTestSubprocessFlags_G_TEST_SUBPROCESS_INHERIT_STDIN: GTestSubprocessFlags = 1;
pub const GTestSubprocessFlags_G_TEST_SUBPROCESS_INHERIT_STDOUT: GTestSubprocessFlags = 2;
pub const GTestSubprocessFlags_G_TEST_SUBPROCESS_INHERIT_STDERR: GTestSubprocessFlags = 4;
pub type GTestSubprocessFlags = u32;
extern "C" {
    pub fn g_test_trap_subprocess(
        test_path: *const ::std::os::raw::c_char,
        usec_timeout: guint64,
        test_flags: GTestSubprocessFlags,
    );
}
extern "C" {
    pub fn g_test_trap_has_passed() -> gboolean;
}
extern "C" {
    pub fn g_test_trap_reached_timeout() -> gboolean;
}
extern "C" {
    pub fn g_test_rand_int() -> gint32;
}
extern "C" {
    pub fn g_test_rand_int_range(begin: gint32, end: gint32) -> gint32;
}
extern "C" {
    pub fn g_test_rand_double() -> f64;
}
extern "C" {
    pub fn g_test_rand_double_range(range_start: f64, range_end: f64) -> f64;
}
extern "C" {
    pub fn g_test_create_case(
        test_name: *const ::std::os::raw::c_char,
        data_size: gsize,
        test_data: gconstpointer,
        data_setup: GTestFixtureFunc,
        data_test: GTestFixtureFunc,
        data_teardown: GTestFixtureFunc,
    ) -> *mut GTestCase;
}
extern "C" {
    pub fn g_test_create_suite(suite_name: *const ::std::os::raw::c_char) -> *mut GTestSuite;
}
extern "C" {
    pub fn g_test_get_root() -> *mut GTestSuite;
}
extern "C" {
    pub fn g_test_suite_add(suite: *mut GTestSuite, test_case: *mut GTestCase);
}
extern "C" {
    pub fn g_test_suite_add_suite(suite: *mut GTestSuite, nestedsuite: *mut GTestSuite);
}
extern "C" {
    pub fn g_test_run_suite(suite: *mut GTestSuite) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_test_trap_assertions(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        assertion_flags: guint64,
        pattern: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assertion_message(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        message: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assertion_message_expr(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        expr: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assertion_message_cmpstr(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        expr: *const ::std::os::raw::c_char,
        arg1: *const ::std::os::raw::c_char,
        cmp: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assertion_message_cmpnum(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        expr: *const ::std::os::raw::c_char,
        arg1: u128,
        cmp: *const ::std::os::raw::c_char,
        arg2: u128,
        numtype: ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assertion_message_error(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        expr: *const ::std::os::raw::c_char,
        error: *const GError,
        error_domain: GQuark,
        error_code: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn g_test_add_vtable(
        testpath: *const ::std::os::raw::c_char,
        data_size: gsize,
        test_data: gconstpointer,
        data_setup: GTestFixtureFunc,
        data_test: GTestFixtureFunc,
        data_teardown: GTestFixtureFunc,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct GTestConfig {
    pub test_initialized: gboolean,
    pub test_quick: gboolean,
    pub test_perf: gboolean,
    pub test_verbose: gboolean,
    pub test_quiet: gboolean,
    pub test_undefined: gboolean,
}
#[test]
fn bindgen_test_layout_GTestConfig() {
    assert_eq!(
        ::std::mem::size_of::<GTestConfig>(),
        24usize,
        concat!("Size of: ", stringify!(GTestConfig))
    );
    assert_eq!(
        ::std::mem::align_of::<GTestConfig>(),
        4usize,
        concat!("Alignment of ", stringify!(GTestConfig))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestConfig>())).test_initialized as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestConfig),
            "::",
            stringify!(test_initialized)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestConfig>())).test_quick as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestConfig),
            "::",
            stringify!(test_quick)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestConfig>())).test_perf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestConfig),
            "::",
            stringify!(test_perf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestConfig>())).test_verbose as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestConfig),
            "::",
            stringify!(test_verbose)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestConfig>())).test_quiet as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestConfig),
            "::",
            stringify!(test_quiet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestConfig>())).test_undefined as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestConfig),
            "::",
            stringify!(test_undefined)
        )
    );
}
extern "C" {
    pub static g_test_config_vars: *const GTestConfig;
}
pub const GTestResult_G_TEST_RUN_SUCCESS: GTestResult = 0;
pub const GTestResult_G_TEST_RUN_SKIPPED: GTestResult = 1;
pub const GTestResult_G_TEST_RUN_FAILURE: GTestResult = 2;
pub const GTestResult_G_TEST_RUN_INCOMPLETE: GTestResult = 3;
pub type GTestResult = u32;
pub const GTestLogType_G_TEST_LOG_NONE: GTestLogType = 0;
pub const GTestLogType_G_TEST_LOG_ERROR: GTestLogType = 1;
pub const GTestLogType_G_TEST_LOG_START_BINARY: GTestLogType = 2;
pub const GTestLogType_G_TEST_LOG_LIST_CASE: GTestLogType = 3;
pub const GTestLogType_G_TEST_LOG_SKIP_CASE: GTestLogType = 4;
pub const GTestLogType_G_TEST_LOG_START_CASE: GTestLogType = 5;
pub const GTestLogType_G_TEST_LOG_STOP_CASE: GTestLogType = 6;
pub const GTestLogType_G_TEST_LOG_MIN_RESULT: GTestLogType = 7;
pub const GTestLogType_G_TEST_LOG_MAX_RESULT: GTestLogType = 8;
pub const GTestLogType_G_TEST_LOG_MESSAGE: GTestLogType = 9;
pub const GTestLogType_G_TEST_LOG_START_SUITE: GTestLogType = 10;
pub const GTestLogType_G_TEST_LOG_STOP_SUITE: GTestLogType = 11;
pub type GTestLogType = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct GTestLogMsg {
    pub log_type: GTestLogType,
    pub n_strings: guint,
    pub strings: *mut *mut gchar,
    pub n_nums: guint,
    pub nums: *mut u128,
}
#[test]
fn bindgen_test_layout_GTestLogMsg() {
    assert_eq!(
        ::std::mem::size_of::<GTestLogMsg>(),
        32usize,
        concat!("Size of: ", stringify!(GTestLogMsg))
    );
    assert_eq!(
        ::std::mem::align_of::<GTestLogMsg>(),
        8usize,
        concat!("Alignment of ", stringify!(GTestLogMsg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestLogMsg>())).log_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestLogMsg),
            "::",
            stringify!(log_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestLogMsg>())).n_strings as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestLogMsg),
            "::",
            stringify!(n_strings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestLogMsg>())).strings as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestLogMsg),
            "::",
            stringify!(strings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestLogMsg>())).n_nums as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestLogMsg),
            "::",
            stringify!(n_nums)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestLogMsg>())).nums as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestLogMsg),
            "::",
            stringify!(nums)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct GTestLogBuffer {
    pub data: *mut GString,
    pub msgs: *mut GSList,
}
#[test]
fn bindgen_test_layout_GTestLogBuffer() {
    assert_eq!(
        ::std::mem::size_of::<GTestLogBuffer>(),
        16usize,
        concat!("Size of: ", stringify!(GTestLogBuffer))
    );
    assert_eq!(
        ::std::mem::align_of::<GTestLogBuffer>(),
        8usize,
        concat!("Alignment of ", stringify!(GTestLogBuffer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestLogBuffer>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestLogBuffer),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GTestLogBuffer>())).msgs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GTestLogBuffer),
            "::",
            stringify!(msgs)
        )
    );
}
extern "C" {
    pub fn g_test_log_type_name(log_type: GTestLogType) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_test_log_buffer_new() -> *mut GTestLogBuffer;
}
extern "C" {
    pub fn g_test_log_buffer_free(tbuffer: *mut GTestLogBuffer);
}
extern "C" {
    pub fn g_test_log_buffer_push(
        tbuffer: *mut GTestLogBuffer,
        n_bytes: guint,
        bytes: *const guint8,
    );
}
extern "C" {
    pub fn g_test_log_buffer_pop(tbuffer: *mut GTestLogBuffer) -> *mut GTestLogMsg;
}
extern "C" {
    pub fn g_test_log_msg_free(tmsg: *mut GTestLogMsg);
}
pub type GTestLogFatalFunc = ::std::option::Option<
    unsafe extern "C" fn(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        message: *const gchar,
        user_data: gpointer,
    ) -> gboolean,
>;
extern "C" {
    pub fn g_test_log_set_fatal_handler(log_func: GTestLogFatalFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_test_expect_message(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        pattern: *const gchar,
    );
}
extern "C" {
    pub fn g_test_assert_expected_messages_internal(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
    );
}
pub const GTestFileType_G_TEST_DIST: GTestFileType = 0;
pub const GTestFileType_G_TEST_BUILT: GTestFileType = 1;
pub type GTestFileType = u32;
extern "C" {
    pub fn g_test_build_filename(
        file_type: GTestFileType,
        first_path: *const gchar,
        ...
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_test_get_dir(file_type: GTestFileType) -> *const gchar;
}
extern "C" {
    pub fn g_test_get_filename(
        file_type: GTestFileType,
        first_path: *const gchar,
        ...
    ) -> *const gchar;
}
pub type GThreadPool = _GThreadPool;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GThreadPool {
    pub func: GFunc,
    pub user_data: gpointer,
    pub exclusive: gboolean,
}
#[test]
fn bindgen_test_layout__GThreadPool() {
    assert_eq!(
        ::std::mem::size_of::<_GThreadPool>(),
        24usize,
        concat!("Size of: ", stringify!(_GThreadPool))
    );
    assert_eq!(
        ::std::mem::align_of::<_GThreadPool>(),
        8usize,
        concat!("Alignment of ", stringify!(_GThreadPool))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadPool>())).func as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadPool),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadPool>())).user_data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadPool),
            "::",
            stringify!(user_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadPool>())).exclusive as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadPool),
            "::",
            stringify!(exclusive)
        )
    );
}
extern "C" {
    pub fn g_thread_pool_new(
        func: GFunc,
        user_data: gpointer,
        max_threads: gint,
        exclusive: gboolean,
        error: *mut *mut GError,
    ) -> *mut GThreadPool;
}
extern "C" {
    pub fn g_thread_pool_free(pool: *mut GThreadPool, immediate: gboolean, wait_: gboolean);
}
extern "C" {
    pub fn g_thread_pool_push(
        pool: *mut GThreadPool,
        data: gpointer,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_thread_pool_unprocessed(pool: *mut GThreadPool) -> guint;
}
extern "C" {
    pub fn g_thread_pool_set_sort_function(
        pool: *mut GThreadPool,
        func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_thread_pool_move_to_front(pool: *mut GThreadPool, data: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_thread_pool_set_max_threads(
        pool: *mut GThreadPool,
        max_threads: gint,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_thread_pool_get_max_threads(pool: *mut GThreadPool) -> gint;
}
extern "C" {
    pub fn g_thread_pool_get_num_threads(pool: *mut GThreadPool) -> guint;
}
extern "C" {
    pub fn g_thread_pool_set_max_unused_threads(max_threads: gint);
}
extern "C" {
    pub fn g_thread_pool_get_max_unused_threads() -> gint;
}
extern "C" {
    pub fn g_thread_pool_get_num_unused_threads() -> guint;
}
extern "C" {
    pub fn g_thread_pool_stop_unused_threads();
}
extern "C" {
    pub fn g_thread_pool_set_max_idle_time(interval: guint);
}
extern "C" {
    pub fn g_thread_pool_get_max_idle_time() -> guint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTimer {
    _unused: [u8; 0],
}
pub type GTimer = _GTimer;
extern "C" {
    pub fn g_timer_new() -> *mut GTimer;
}
extern "C" {
    pub fn g_timer_destroy(timer: *mut GTimer);
}
extern "C" {
    pub fn g_timer_start(timer: *mut GTimer);
}
extern "C" {
    pub fn g_timer_stop(timer: *mut GTimer);
}
extern "C" {
    pub fn g_timer_reset(timer: *mut GTimer);
}
extern "C" {
    pub fn g_timer_continue(timer: *mut GTimer);
}
extern "C" {
    pub fn g_timer_elapsed(timer: *mut GTimer, microseconds: *mut gulong) -> gdouble;
}
extern "C" {
    pub fn g_timer_is_active(timer: *mut GTimer) -> gboolean;
}
extern "C" {
    pub fn g_usleep(microseconds: gulong);
}
extern "C" {
    pub fn g_time_val_add(time_: *mut GTimeVal, microseconds: glong);
}
extern "C" {
    pub fn g_time_val_from_iso8601(iso_date: *const gchar, time_: *mut GTimeVal) -> gboolean;
}
extern "C" {
    pub fn g_time_val_to_iso8601(time_: *mut GTimeVal) -> *mut gchar;
}
pub type GTrashStack = _GTrashStack;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTrashStack {
    pub next: *mut GTrashStack,
}
#[test]
fn bindgen_test_layout__GTrashStack() {
    assert_eq!(
        ::std::mem::size_of::<_GTrashStack>(),
        8usize,
        concat!("Size of: ", stringify!(_GTrashStack))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTrashStack>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTrashStack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTrashStack>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTrashStack),
            "::",
            stringify!(next)
        )
    );
}
extern "C" {
    pub fn g_trash_stack_push(stack_p: *mut *mut GTrashStack, data_p: gpointer);
}
extern "C" {
    pub fn g_trash_stack_pop(stack_p: *mut *mut GTrashStack) -> gpointer;
}
extern "C" {
    pub fn g_trash_stack_peek(stack_p: *mut *mut GTrashStack) -> gpointer;
}
extern "C" {
    pub fn g_trash_stack_height(stack_p: *mut *mut GTrashStack) -> guint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTree {
    _unused: [u8; 0],
}
pub type GTree = _GTree;
pub type GTraverseFunc = ::std::option::Option<
    unsafe extern "C" fn(key: gpointer, value: gpointer, data: gpointer) -> gboolean,
>;
extern "C" {
    pub fn g_tree_new(key_compare_func: GCompareFunc) -> *mut GTree;
}
extern "C" {
    pub fn g_tree_new_with_data(
        key_compare_func: GCompareDataFunc,
        key_compare_data: gpointer,
    ) -> *mut GTree;
}
extern "C" {
    pub fn g_tree_new_full(
        key_compare_func: GCompareDataFunc,
        key_compare_data: gpointer,
        key_destroy_func: GDestroyNotify,
        value_destroy_func: GDestroyNotify,
    ) -> *mut GTree;
}
extern "C" {
    pub fn g_tree_ref(tree: *mut GTree) -> *mut GTree;
}
extern "C" {
    pub fn g_tree_unref(tree: *mut GTree);
}
extern "C" {
    pub fn g_tree_destroy(tree: *mut GTree);
}
extern "C" {
    pub fn g_tree_insert(tree: *mut GTree, key: gpointer, value: gpointer);
}
extern "C" {
    pub fn g_tree_replace(tree: *mut GTree, key: gpointer, value: gpointer);
}
extern "C" {
    pub fn g_tree_remove(tree: *mut GTree, key: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_tree_steal(tree: *mut GTree, key: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_tree_lookup(tree: *mut GTree, key: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_tree_lookup_extended(
        tree: *mut GTree,
        lookup_key: gconstpointer,
        orig_key: *mut gpointer,
        value: *mut gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_tree_foreach(tree: *mut GTree, func: GTraverseFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_tree_traverse(
        tree: *mut GTree,
        traverse_func: GTraverseFunc,
        traverse_type: GTraverseType,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_tree_search(
        tree: *mut GTree,
        search_func: GCompareFunc,
        user_data: gconstpointer,
    ) -> gpointer;
}
extern "C" {
    pub fn g_tree_height(tree: *mut GTree) -> gint;
}
extern "C" {
    pub fn g_tree_nnodes(tree: *mut GTree) -> gint;
}
extern "C" {
    pub fn g_uri_unescape_string(
        escaped_string: *const ::std::os::raw::c_char,
        illegal_characters: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_uri_unescape_segment(
        escaped_string: *const ::std::os::raw::c_char,
        escaped_string_end: *const ::std::os::raw::c_char,
        illegal_characters: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_uri_parse_scheme(uri: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_uri_escape_string(
        unescaped: *const ::std::os::raw::c_char,
        reserved_chars_allowed: *const ::std::os::raw::c_char,
        allow_utf8: gboolean,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_uuid_string_is_valid(str: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_uuid_string_random() -> *mut gchar;
}
extern "C" {
    pub static glib_major_version: guint;
}
extern "C" {
    pub static glib_minor_version: guint;
}
extern "C" {
    pub static glib_micro_version: guint;
}
extern "C" {
    pub static glib_interface_age: guint;
}
extern "C" {
    pub static glib_binary_age: guint;
}
extern "C" {
    pub fn glib_check_version(
        required_major: guint,
        required_minor: guint,
        required_micro: guint,
    ) -> *const gchar;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GAllocator {
    _unused: [u8; 0],
}
pub type GAllocator = _GAllocator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMemChunk {
    _unused: [u8; 0],
}
pub type GMemChunk = _GMemChunk;
extern "C" {
    pub fn g_mem_chunk_new(
        name: *const gchar,
        atom_size: gint,
        area_size: gsize,
        type_: gint,
    ) -> *mut GMemChunk;
}
extern "C" {
    pub fn g_mem_chunk_destroy(mem_chunk: *mut GMemChunk);
}
extern "C" {
    pub fn g_mem_chunk_alloc(mem_chunk: *mut GMemChunk) -> gpointer;
}
extern "C" {
    pub fn g_mem_chunk_alloc0(mem_chunk: *mut GMemChunk) -> gpointer;
}
extern "C" {
    pub fn g_mem_chunk_free(mem_chunk: *mut GMemChunk, mem: gpointer);
}
extern "C" {
    pub fn g_mem_chunk_clean(mem_chunk: *mut GMemChunk);
}
extern "C" {
    pub fn g_mem_chunk_reset(mem_chunk: *mut GMemChunk);
}
extern "C" {
    pub fn g_mem_chunk_print(mem_chunk: *mut GMemChunk);
}
extern "C" {
    pub fn g_mem_chunk_info();
}
extern "C" {
    pub fn g_blow_chunks();
}
extern "C" {
    pub fn g_allocator_new(name: *const gchar, n_preallocs: guint) -> *mut GAllocator;
}
extern "C" {
    pub fn g_allocator_free(allocator: *mut GAllocator);
}
extern "C" {
    pub fn g_list_push_allocator(allocator: *mut GAllocator);
}
extern "C" {
    pub fn g_list_pop_allocator();
}
extern "C" {
    pub fn g_slist_push_allocator(allocator: *mut GAllocator);
}
extern "C" {
    pub fn g_slist_pop_allocator();
}
extern "C" {
    pub fn g_node_push_allocator(allocator: *mut GAllocator);
}
extern "C" {
    pub fn g_node_pop_allocator();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GCache {
    _unused: [u8; 0],
}
pub type GCache = _GCache;
pub type GCacheNewFunc = ::std::option::Option<unsafe extern "C" fn(key: gpointer) -> gpointer>;
pub type GCacheDupFunc = ::std::option::Option<unsafe extern "C" fn(value: gpointer) -> gpointer>;
pub type GCacheDestroyFunc = ::std::option::Option<unsafe extern "C" fn(value: gpointer)>;
extern "C" {
    pub fn g_cache_new(
        value_new_func: GCacheNewFunc,
        value_destroy_func: GCacheDestroyFunc,
        key_dup_func: GCacheDupFunc,
        key_destroy_func: GCacheDestroyFunc,
        hash_key_func: GHashFunc,
        hash_value_func: GHashFunc,
        key_equal_func: GEqualFunc,
    ) -> *mut GCache;
}
extern "C" {
    pub fn g_cache_destroy(cache: *mut GCache);
}
extern "C" {
    pub fn g_cache_insert(cache: *mut GCache, key: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_cache_remove(cache: *mut GCache, value: gconstpointer);
}
extern "C" {
    pub fn g_cache_key_foreach(cache: *mut GCache, func: GHFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_cache_value_foreach(cache: *mut GCache, func: GHFunc, user_data: gpointer);
}
pub type GCompletion = _GCompletion;
pub type GCompletionFunc =
    ::std::option::Option<unsafe extern "C" fn(arg1: gpointer) -> *mut gchar>;
pub type GCompletionStrncmpFunc = ::std::option::Option<
    unsafe extern "C" fn(s1: *const gchar, s2: *const gchar, n: gsize) -> gint,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GCompletion {
    pub items: *mut GList,
    pub func: GCompletionFunc,
    pub prefix: *mut gchar,
    pub cache: *mut GList,
    pub strncmp_func: GCompletionStrncmpFunc,
}
#[test]
fn bindgen_test_layout__GCompletion() {
    assert_eq!(
        ::std::mem::size_of::<_GCompletion>(),
        40usize,
        concat!("Size of: ", stringify!(_GCompletion))
    );
    assert_eq!(
        ::std::mem::align_of::<_GCompletion>(),
        8usize,
        concat!("Alignment of ", stringify!(_GCompletion))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCompletion>())).items as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCompletion),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCompletion>())).func as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCompletion),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCompletion>())).prefix as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCompletion),
            "::",
            stringify!(prefix)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCompletion>())).cache as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCompletion),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCompletion>())).strncmp_func as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCompletion),
            "::",
            stringify!(strncmp_func)
        )
    );
}
extern "C" {
    pub fn g_completion_new(func: GCompletionFunc) -> *mut GCompletion;
}
extern "C" {
    pub fn g_completion_add_items(cmp: *mut GCompletion, items: *mut GList);
}
extern "C" {
    pub fn g_completion_remove_items(cmp: *mut GCompletion, items: *mut GList);
}
extern "C" {
    pub fn g_completion_clear_items(cmp: *mut GCompletion);
}
extern "C" {
    pub fn g_completion_complete(
        cmp: *mut GCompletion,
        prefix: *const gchar,
        new_prefix: *mut *mut gchar,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_completion_complete_utf8(
        cmp: *mut GCompletion,
        prefix: *const gchar,
        new_prefix: *mut *mut gchar,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_completion_set_compare(cmp: *mut GCompletion, strncmp_func: GCompletionStrncmpFunc);
}
extern "C" {
    pub fn g_completion_free(cmp: *mut GCompletion);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GRelation {
    _unused: [u8; 0],
}
pub type GRelation = _GRelation;
pub type GTuples = _GTuples;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTuples {
    pub len: guint,
}
#[test]
fn bindgen_test_layout__GTuples() {
    assert_eq!(
        ::std::mem::size_of::<_GTuples>(),
        4usize,
        concat!("Size of: ", stringify!(_GTuples))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTuples>(),
        4usize,
        concat!("Alignment of ", stringify!(_GTuples))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTuples>())).len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTuples),
            "::",
            stringify!(len)
        )
    );
}
extern "C" {
    pub fn g_relation_new(fields: gint) -> *mut GRelation;
}
extern "C" {
    pub fn g_relation_destroy(relation: *mut GRelation);
}
extern "C" {
    pub fn g_relation_index(
        relation: *mut GRelation,
        field: gint,
        hash_func: GHashFunc,
        key_equal_func: GEqualFunc,
    );
}
extern "C" {
    pub fn g_relation_insert(relation: *mut GRelation, ...);
}
extern "C" {
    pub fn g_relation_delete(relation: *mut GRelation, key: gconstpointer, field: gint) -> gint;
}
extern "C" {
    pub fn g_relation_select(
        relation: *mut GRelation,
        key: gconstpointer,
        field: gint,
    ) -> *mut GTuples;
}
extern "C" {
    pub fn g_relation_count(relation: *mut GRelation, key: gconstpointer, field: gint) -> gint;
}
extern "C" {
    pub fn g_relation_exists(relation: *mut GRelation, ...) -> gboolean;
}
extern "C" {
    pub fn g_relation_print(relation: *mut GRelation);
}
extern "C" {
    pub fn g_tuples_destroy(tuples: *mut GTuples);
}
extern "C" {
    pub fn g_tuples_index(tuples: *mut GTuples, index_: gint, field: gint) -> gpointer;
}
pub const GThreadPriority_G_THREAD_PRIORITY_LOW: GThreadPriority = 0;
pub const GThreadPriority_G_THREAD_PRIORITY_NORMAL: GThreadPriority = 1;
pub const GThreadPriority_G_THREAD_PRIORITY_HIGH: GThreadPriority = 2;
pub const GThreadPriority_G_THREAD_PRIORITY_URGENT: GThreadPriority = 3;
pub type GThreadPriority = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GThread {
    pub func: GThreadFunc,
    pub data: gpointer,
    pub joinable: gboolean,
    pub priority: GThreadPriority,
}
#[test]
fn bindgen_test_layout__GThread() {
    assert_eq!(
        ::std::mem::size_of::<_GThread>(),
        24usize,
        concat!("Size of: ", stringify!(_GThread))
    );
    assert_eq!(
        ::std::mem::align_of::<_GThread>(),
        8usize,
        concat!("Alignment of ", stringify!(_GThread))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThread>())).func as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThread),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThread>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThread),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThread>())).joinable as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThread),
            "::",
            stringify!(joinable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThread>())).priority as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThread),
            "::",
            stringify!(priority)
        )
    );
}
pub type GThreadFunctions = _GThreadFunctions;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GThreadFunctions {
    pub mutex_new: ::std::option::Option<unsafe extern "C" fn() -> *mut GMutex>,
    pub mutex_lock: ::std::option::Option<unsafe extern "C" fn(mutex: *mut GMutex)>,
    pub mutex_trylock: ::std::option::Option<unsafe extern "C" fn(mutex: *mut GMutex) -> gboolean>,
    pub mutex_unlock: ::std::option::Option<unsafe extern "C" fn(mutex: *mut GMutex)>,
    pub mutex_free: ::std::option::Option<unsafe extern "C" fn(mutex: *mut GMutex)>,
    pub cond_new: ::std::option::Option<unsafe extern "C" fn() -> *mut GCond>,
    pub cond_signal: ::std::option::Option<unsafe extern "C" fn(cond: *mut GCond)>,
    pub cond_broadcast: ::std::option::Option<unsafe extern "C" fn(cond: *mut GCond)>,
    pub cond_wait:
        ::std::option::Option<unsafe extern "C" fn(cond: *mut GCond, mutex: *mut GMutex)>,
    pub cond_timed_wait: ::std::option::Option<
        unsafe extern "C" fn(
            cond: *mut GCond,
            mutex: *mut GMutex,
            end_time: *mut GTimeVal,
        ) -> gboolean,
    >,
    pub cond_free: ::std::option::Option<unsafe extern "C" fn(cond: *mut GCond)>,
    pub private_new:
        ::std::option::Option<unsafe extern "C" fn(destructor: GDestroyNotify) -> *mut GPrivate>,
    pub private_get:
        ::std::option::Option<unsafe extern "C" fn(private_key: *mut GPrivate) -> gpointer>,
    pub private_set:
        ::std::option::Option<unsafe extern "C" fn(private_key: *mut GPrivate, data: gpointer)>,
    pub thread_create: ::std::option::Option<
        unsafe extern "C" fn(
            func: GThreadFunc,
            data: gpointer,
            stack_size: gulong,
            joinable: gboolean,
            bound: gboolean,
            priority: GThreadPriority,
            thread: gpointer,
            error: *mut *mut GError,
        ),
    >,
    pub thread_yield: ::std::option::Option<unsafe extern "C" fn()>,
    pub thread_join: ::std::option::Option<unsafe extern "C" fn(thread: gpointer)>,
    pub thread_exit: ::std::option::Option<unsafe extern "C" fn()>,
    pub thread_set_priority:
        ::std::option::Option<unsafe extern "C" fn(thread: gpointer, priority: GThreadPriority)>,
    pub thread_self: ::std::option::Option<unsafe extern "C" fn(thread: gpointer)>,
    pub thread_equal: ::std::option::Option<
        unsafe extern "C" fn(thread1: gpointer, thread2: gpointer) -> gboolean,
    >,
}
#[test]
fn bindgen_test_layout__GThreadFunctions() {
    assert_eq!(
        ::std::mem::size_of::<_GThreadFunctions>(),
        168usize,
        concat!("Size of: ", stringify!(_GThreadFunctions))
    );
    assert_eq!(
        ::std::mem::align_of::<_GThreadFunctions>(),
        8usize,
        concat!("Alignment of ", stringify!(_GThreadFunctions))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).mutex_new as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(mutex_new)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).mutex_lock as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(mutex_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).mutex_trylock as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(mutex_trylock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).mutex_unlock as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(mutex_unlock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).mutex_free as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(mutex_free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).cond_new as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(cond_new)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).cond_signal as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(cond_signal)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GThreadFunctions>())).cond_broadcast as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(cond_broadcast)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).cond_wait as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(cond_wait)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GThreadFunctions>())).cond_timed_wait as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(cond_timed_wait)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).cond_free as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(cond_free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).private_new as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(private_new)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).private_get as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(private_get)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).private_set as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(private_set)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).thread_create as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(thread_create)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).thread_yield as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(thread_yield)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).thread_join as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(thread_join)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).thread_exit as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(thread_exit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GThreadFunctions>())).thread_set_priority as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(thread_set_priority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).thread_self as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(thread_self)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GThreadFunctions>())).thread_equal as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_GThreadFunctions),
            "::",
            stringify!(thread_equal)
        )
    );
}
extern "C" {
    pub static mut g_thread_functions_for_glib_use: GThreadFunctions;
}
extern "C" {
    pub static mut g_thread_use_default_impl: gboolean;
}
extern "C" {
    pub static mut g_thread_gettime: ::std::option::Option<unsafe extern "C" fn() -> guint64>;
}
extern "C" {
    pub fn g_thread_create(
        func: GThreadFunc,
        data: gpointer,
        joinable: gboolean,
        error: *mut *mut GError,
    ) -> *mut GThread;
}
extern "C" {
    pub fn g_thread_create_full(
        func: GThreadFunc,
        data: gpointer,
        stack_size: gulong,
        joinable: gboolean,
        bound: gboolean,
        priority: GThreadPriority,
        error: *mut *mut GError,
    ) -> *mut GThread;
}
extern "C" {
    pub fn g_thread_set_priority(thread: *mut GThread, priority: GThreadPriority);
}
extern "C" {
    pub fn g_thread_foreach(thread_func: GFunc, user_data: gpointer);
}
pub type suseconds_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pthread_mutex_t {
    pub __u: pthread_mutex_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t__bindgen_ty_1 {
    pub __i: [::std::os::raw::c_int; 10usize],
    pub __vi: [::std::os::raw::c_int; 10usize],
    pub __p: [*mut ::std::os::raw::c_void; 5usize],
    _bindgen_union_align: [u64; 5usize],
}
#[test]
fn bindgen_test_layout_pthread_mutex_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t__bindgen_ty_1>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t__bindgen_ty_1>())).__i as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t__bindgen_ty_1),
            "::",
            stringify!(__i)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t__bindgen_ty_1>())).__vi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t__bindgen_ty_1),
            "::",
            stringify!(__vi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t__bindgen_ty_1>())).__p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t__bindgen_ty_1),
            "::",
            stringify!(__p)
        )
    );
}
impl ::std::fmt::Debug for pthread_mutex_t__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_mutex_t__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__u)
        )
    );
}
impl ::std::fmt::Debug for pthread_mutex_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_mutex_t {{ __u: {:?} }}", self.__u)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pthread_cond_t {
    pub __u: pthread_cond_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t__bindgen_ty_1 {
    pub __i: [::std::os::raw::c_int; 12usize],
    pub __vi: [::std::os::raw::c_int; 12usize],
    pub __p: [*mut ::std::os::raw::c_void; 6usize],
    _bindgen_union_align: [u64; 6usize],
}
#[test]
fn bindgen_test_layout_pthread_cond_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__i as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__i)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__vi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__vi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__p)
        )
    );
}
impl ::std::fmt::Debug for pthread_cond_t__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_cond_t__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__u)
        )
    );
}
impl ::std::fmt::Debug for pthread_cond_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_cond_t {{ __u: {:?} }}", self.__u)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pthread_rwlock_t {
    pub __u: pthread_rwlock_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t__bindgen_ty_1 {
    pub __i: [::std::os::raw::c_int; 14usize],
    pub __vi: [::std::os::raw::c_int; 14usize],
    pub __p: [*mut ::std::os::raw::c_void; 7usize],
    _bindgen_union_align: [u64; 7usize],
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__i as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__i)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__vi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__vi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__p)
        )
    );
}
impl ::std::fmt::Debug for pthread_rwlock_t__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_rwlock_t__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__u)
        )
    );
}
impl ::std::fmt::Debug for pthread_rwlock_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_rwlock_t {{ __u: {:?} }}", self.__u)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pthread_barrier_t {
    pub __u: pthread_barrier_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t__bindgen_ty_1 {
    pub __i: [::std::os::raw::c_int; 8usize],
    pub __vi: [::std::os::raw::c_int; 8usize],
    pub __p: [*mut ::std::os::raw::c_void; 4usize],
    _bindgen_union_align: [u64; 4usize],
}
#[test]
fn bindgen_test_layout_pthread_barrier_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_barrier_t__bindgen_ty_1>())).__i as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t__bindgen_ty_1),
            "::",
            stringify!(__i)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_barrier_t__bindgen_ty_1>())).__vi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t__bindgen_ty_1),
            "::",
            stringify!(__vi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_barrier_t__bindgen_ty_1>())).__p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t__bindgen_ty_1),
            "::",
            stringify!(__p)
        )
    );
}
impl ::std::fmt::Debug for pthread_barrier_t__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_barrier_t__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__u)
        )
    );
}
impl ::std::fmt::Debug for pthread_barrier_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_barrier_t {{ __u: {:?} }}", self.__u)
    }
}
pub type ssize_t = ::std::os::raw::c_long;
pub type register_t = ::std::os::raw::c_long;
pub type u_int64_t = ::std::os::raw::c_ulong;
pub type mode_t = ::std::os::raw::c_uint;
pub type nlink_t = ::std::os::raw::c_ulong;
pub type dev_t = ::std::os::raw::c_ulong;
pub type blksize_t = ::std::os::raw::c_long;
pub type blkcnt_t = ::std::os::raw::c_long;
pub type fsblkcnt_t = ::std::os::raw::c_ulong;
pub type fsfilcnt_t = ::std::os::raw::c_ulong;
pub type id_t = ::std::os::raw::c_uint;
pub type gid_t = ::std::os::raw::c_uint;
pub type key_t = ::std::os::raw::c_int;
pub type useconds_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct pthread_mutexattr_t {
    pub __attr: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__attr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__attr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct pthread_condattr_t {
    pub __attr: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__attr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__attr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct pthread_barrierattr_t {
    pub __attr: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__attr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__attr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct pthread_rwlockattr_t {
    pub __attr: [::std::os::raw::c_uint; 2usize],
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__attr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__attr)
        )
    );
}
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type caddr_t = *mut ::std::os::raw::c_char;
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type ushort = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type uint = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type ulong = ::std::os::raw::c_ulong;
pub type quad_t = ::std::os::raw::c_longlong;
pub type u_quad_t = ::std::os::raw::c_ulonglong;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub type int_fast8_t = i8;
pub type int_fast64_t = i64;
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast64_t = u64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast16_t = i32;
pub type int_fast32_t = i32;
pub type uint_fast16_t = u32;
pub type uint_fast32_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct timeval {
    pub tv_sec: time_t,
    pub tv_usec: suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type fd_mask = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
extern "C" {
    pub fn select(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *const timespec,
        arg6: *const sigset_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct sched_param {
    pub sched_priority: ::std::os::raw::c_int,
    pub __reserved1: ::std::os::raw::c_int,
    pub __reserved2: [sched_param__bindgen_ty_1; 2usize],
    pub __reserved3: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct sched_param__bindgen_ty_1 {
    pub __reserved1: time_t,
    pub __reserved2: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_sched_param__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sched_param__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(sched_param__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sched_param__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(sched_param__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sched_param__bindgen_ty_1>())).__reserved1 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sched_param__bindgen_ty_1),
            "::",
            stringify!(__reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sched_param__bindgen_ty_1>())).__reserved2 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sched_param__bindgen_ty_1),
            "::",
            stringify!(__reserved2)
        )
    );
}
#[test]
fn bindgen_test_layout_sched_param() {
    assert_eq!(
        ::std::mem::size_of::<sched_param>(),
        48usize,
        concat!("Size of: ", stringify!(sched_param))
    );
    assert_eq!(
        ::std::mem::align_of::<sched_param>(),
        8usize,
        concat!("Alignment of ", stringify!(sched_param))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sched_param>())).sched_priority as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sched_param),
            "::",
            stringify!(sched_priority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sched_param>())).__reserved1 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sched_param),
            "::",
            stringify!(__reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sched_param>())).__reserved2 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sched_param),
            "::",
            stringify!(__reserved2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sched_param>())).__reserved3 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(sched_param),
            "::",
            stringify!(__reserved3)
        )
    );
}
extern "C" {
    pub fn sched_get_priority_max(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_get_priority_min(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_getparam(arg1: pid_t, arg2: *mut sched_param) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_getscheduler(arg1: pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_rr_get_interval(arg1: pid_t, arg2: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_setparam(arg1: pid_t, arg2: *const sched_param) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_setscheduler(
        arg1: pid_t,
        arg2: ::std::os::raw::c_int,
        arg3: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_yield() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_create(
        arg1: *mut pthread_t,
        arg2: *const pthread_attr_t,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_detach(arg1: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_exit(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn pthread_join(
        arg1: pthread_t,
        arg2: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_self() -> pthread_t;
}
extern "C" {
    pub fn pthread_equal(arg1: pthread_t, arg2: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setcancelstate(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setcanceltype(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_testcancel();
}
extern "C" {
    pub fn pthread_cancel(arg1: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getschedparam(
        arg1: pthread_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: *mut sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setschedparam(
        arg1: pthread_t,
        arg2: ::std::os::raw::c_int,
        arg3: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setschedprio(
        arg1: pthread_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_once(
        arg1: *mut pthread_once_t,
        arg2: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_init(
        arg1: *mut pthread_mutex_t,
        arg2: *const pthread_mutexattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_lock(arg1: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_unlock(arg1: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_trylock(arg1: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_timedlock(
        arg1: *mut pthread_mutex_t,
        arg2: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_destroy(arg1: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_consistent(arg1: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_getprioceiling(
        arg1: *const pthread_mutex_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_setprioceiling(
        arg1: *mut pthread_mutex_t,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_init(
        arg1: *mut pthread_cond_t,
        arg2: *const pthread_condattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_destroy(arg1: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_wait(
        arg1: *mut pthread_cond_t,
        arg2: *mut pthread_mutex_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_timedwait(
        arg1: *mut pthread_cond_t,
        arg2: *mut pthread_mutex_t,
        arg3: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_broadcast(arg1: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_signal(arg1: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_init(
        arg1: *mut pthread_rwlock_t,
        arg2: *const pthread_rwlockattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_destroy(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_rdlock(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_tryrdlock(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_timedrdlock(
        arg1: *mut pthread_rwlock_t,
        arg2: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_wrlock(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_trywrlock(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_timedwrlock(
        arg1: *mut pthread_rwlock_t,
        arg2: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_unlock(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_init(
        arg1: *mut pthread_spinlock_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_destroy(arg1: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_lock(arg1: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_trylock(arg1: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_unlock(arg1: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrier_init(
        arg1: *mut pthread_barrier_t,
        arg2: *const pthread_barrierattr_t,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrier_destroy(arg1: *mut pthread_barrier_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrier_wait(arg1: *mut pthread_barrier_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_key_create(
        arg1: *mut pthread_key_t,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_key_delete(arg1: pthread_key_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getspecific(arg1: pthread_key_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn pthread_setspecific(
        arg1: pthread_key_t,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_init(arg1: *mut pthread_attr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_destroy(arg1: *mut pthread_attr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getguardsize(
        arg1: *const pthread_attr_t,
        arg2: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setguardsize(
        arg1: *mut pthread_attr_t,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstacksize(
        arg1: *const pthread_attr_t,
        arg2: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstacksize(
        arg1: *mut pthread_attr_t,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getdetachstate(
        arg1: *const pthread_attr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setdetachstate(
        arg1: *mut pthread_attr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstack(
        arg1: *const pthread_attr_t,
        arg2: *mut *mut ::std::os::raw::c_void,
        arg3: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstack(
        arg1: *mut pthread_attr_t,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getscope(
        arg1: *const pthread_attr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setscope(
        arg1: *mut pthread_attr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getschedpolicy(
        arg1: *const pthread_attr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setschedpolicy(
        arg1: *mut pthread_attr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getschedparam(
        arg1: *const pthread_attr_t,
        arg2: *mut sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setschedparam(
        arg1: *mut pthread_attr_t,
        arg2: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getinheritsched(
        arg1: *const pthread_attr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setinheritsched(
        arg1: *mut pthread_attr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_destroy(arg1: *mut pthread_mutexattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getprioceiling(
        arg1: *const pthread_mutexattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getprotocol(
        arg1: *const pthread_mutexattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getpshared(
        arg1: *const pthread_mutexattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getrobust(
        arg1: *const pthread_mutexattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_gettype(
        arg1: *const pthread_mutexattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_init(arg1: *mut pthread_mutexattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setprioceiling(
        arg1: *mut pthread_mutexattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setprotocol(
        arg1: *mut pthread_mutexattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setpshared(
        arg1: *mut pthread_mutexattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setrobust(
        arg1: *mut pthread_mutexattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_settype(
        arg1: *mut pthread_mutexattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_init(arg1: *mut pthread_condattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_destroy(arg1: *mut pthread_condattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_setclock(
        arg1: *mut pthread_condattr_t,
        arg2: clockid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_setpshared(
        arg1: *mut pthread_condattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_getclock(
        arg1: *const pthread_condattr_t,
        arg2: *mut clockid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_getpshared(
        arg1: *const pthread_condattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_init(arg1: *mut pthread_rwlockattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_destroy(arg1: *mut pthread_rwlockattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_setpshared(
        arg1: *mut pthread_rwlockattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_getpshared(
        arg1: *const pthread_rwlockattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_destroy(arg1: *mut pthread_barrierattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_getpshared(
        arg1: *const pthread_barrierattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_init(arg1: *mut pthread_barrierattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_setpshared(
        arg1: *mut pthread_barrierattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_atfork(
        arg1: ::std::option::Option<unsafe extern "C" fn()>,
        arg2: ::std::option::Option<unsafe extern "C" fn()>,
        arg3: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getconcurrency() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setconcurrency(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getcpuclockid(arg1: pthread_t, arg2: *mut clockid_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct __ptcb {
    pub __f: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __x: *mut ::std::os::raw::c_void,
    pub __next: *mut __ptcb,
}
#[test]
fn bindgen_test_layout___ptcb() {
    assert_eq!(
        ::std::mem::size_of::<__ptcb>(),
        24usize,
        concat!("Size of: ", stringify!(__ptcb))
    );
    assert_eq!(
        ::std::mem::align_of::<__ptcb>(),
        8usize,
        concat!("Alignment of ", stringify!(__ptcb))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__ptcb>())).__f as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ptcb),
            "::",
            stringify!(__f)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__ptcb>())).__x as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__ptcb),
            "::",
            stringify!(__x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__ptcb>())).__next as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__ptcb),
            "::",
            stringify!(__next)
        )
    );
}
extern "C" {
    pub fn _pthread_cleanup_push(
        arg1: *mut __ptcb,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        arg3: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn _pthread_cleanup_pop(arg1: *mut __ptcb, arg2: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GStaticMutex {
    pub mutex: *mut GMutex,
    pub unused: pthread_mutex_t,
}
#[test]
fn bindgen_test_layout_GStaticMutex() {
    assert_eq!(
        ::std::mem::size_of::<GStaticMutex>(),
        48usize,
        concat!("Size of: ", stringify!(GStaticMutex))
    );
    assert_eq!(
        ::std::mem::align_of::<GStaticMutex>(),
        8usize,
        concat!("Alignment of ", stringify!(GStaticMutex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GStaticMutex>())).mutex as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GStaticMutex),
            "::",
            stringify!(mutex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GStaticMutex>())).unused as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GStaticMutex),
            "::",
            stringify!(unused)
        )
    );
}
impl ::std::fmt::Debug for GStaticMutex {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "GStaticMutex {{ mutex: {:?}, unused: {:?} }}",
            self.mutex, self.unused
        )
    }
}
extern "C" {
    pub fn g_static_mutex_init(mutex: *mut GStaticMutex);
}
extern "C" {
    pub fn g_static_mutex_free(mutex: *mut GStaticMutex);
}
extern "C" {
    pub fn g_static_mutex_get_mutex_impl(mutex: *mut GStaticMutex) -> *mut GMutex;
}
pub type GStaticRecMutex = _GStaticRecMutex;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GStaticRecMutex {
    pub mutex: GStaticMutex,
    pub depth: guint,
    pub unused: _GStaticRecMutex__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GStaticRecMutex__bindgen_ty_1 {
    pub owner: pthread_t,
    pub dummy: gdouble,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout__GStaticRecMutex__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_GStaticRecMutex__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_GStaticRecMutex__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_GStaticRecMutex__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_GStaticRecMutex__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GStaticRecMutex__bindgen_ty_1>())).owner as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRecMutex__bindgen_ty_1),
            "::",
            stringify!(owner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GStaticRecMutex__bindgen_ty_1>())).dummy as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRecMutex__bindgen_ty_1),
            "::",
            stringify!(dummy)
        )
    );
}
impl ::std::fmt::Debug for _GStaticRecMutex__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GStaticRecMutex__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout__GStaticRecMutex() {
    assert_eq!(
        ::std::mem::size_of::<_GStaticRecMutex>(),
        64usize,
        concat!("Size of: ", stringify!(_GStaticRecMutex))
    );
    assert_eq!(
        ::std::mem::align_of::<_GStaticRecMutex>(),
        8usize,
        concat!("Alignment of ", stringify!(_GStaticRecMutex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticRecMutex>())).mutex as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRecMutex),
            "::",
            stringify!(mutex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticRecMutex>())).depth as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRecMutex),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticRecMutex>())).unused as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRecMutex),
            "::",
            stringify!(unused)
        )
    );
}
impl ::std::fmt::Debug for _GStaticRecMutex {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "_GStaticRecMutex {{ mutex: {:?}, depth: {:?}, unused: {:?} }}",
            self.mutex, self.depth, self.unused
        )
    }
}
extern "C" {
    pub fn g_static_rec_mutex_init(mutex: *mut GStaticRecMutex);
}
extern "C" {
    pub fn g_static_rec_mutex_lock(mutex: *mut GStaticRecMutex);
}
extern "C" {
    pub fn g_static_rec_mutex_trylock(mutex: *mut GStaticRecMutex) -> gboolean;
}
extern "C" {
    pub fn g_static_rec_mutex_unlock(mutex: *mut GStaticRecMutex);
}
extern "C" {
    pub fn g_static_rec_mutex_lock_full(mutex: *mut GStaticRecMutex, depth: guint);
}
extern "C" {
    pub fn g_static_rec_mutex_unlock_full(mutex: *mut GStaticRecMutex) -> guint;
}
extern "C" {
    pub fn g_static_rec_mutex_free(mutex: *mut GStaticRecMutex);
}
pub type GStaticRWLock = _GStaticRWLock;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GStaticRWLock {
    pub mutex: GStaticMutex,
    pub read_cond: *mut GCond,
    pub write_cond: *mut GCond,
    pub read_counter: guint,
    pub have_writer: gboolean,
    pub want_to_read: guint,
    pub want_to_write: guint,
}
#[test]
fn bindgen_test_layout__GStaticRWLock() {
    assert_eq!(
        ::std::mem::size_of::<_GStaticRWLock>(),
        80usize,
        concat!("Size of: ", stringify!(_GStaticRWLock))
    );
    assert_eq!(
        ::std::mem::align_of::<_GStaticRWLock>(),
        8usize,
        concat!("Alignment of ", stringify!(_GStaticRWLock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticRWLock>())).mutex as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRWLock),
            "::",
            stringify!(mutex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticRWLock>())).read_cond as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRWLock),
            "::",
            stringify!(read_cond)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticRWLock>())).write_cond as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRWLock),
            "::",
            stringify!(write_cond)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticRWLock>())).read_counter as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRWLock),
            "::",
            stringify!(read_counter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticRWLock>())).have_writer as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRWLock),
            "::",
            stringify!(have_writer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticRWLock>())).want_to_read as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRWLock),
            "::",
            stringify!(want_to_read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticRWLock>())).want_to_write as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticRWLock),
            "::",
            stringify!(want_to_write)
        )
    );
}
impl ::std::fmt::Debug for _GStaticRWLock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! ( f , "_GStaticRWLock {{ mutex: {:?}, read_cond: {:?}, write_cond: {:?}, read_counter: {:?}, have_writer: {:?}, want_to_read: {:?}, want_to_write: {:?} }}" , self . mutex , self . read_cond , self . write_cond , self . read_counter , self . have_writer , self . want_to_read , self . want_to_write )
    }
}
extern "C" {
    pub fn g_static_rw_lock_init(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_static_rw_lock_reader_lock(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_static_rw_lock_reader_trylock(lock: *mut GStaticRWLock) -> gboolean;
}
extern "C" {
    pub fn g_static_rw_lock_reader_unlock(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_static_rw_lock_writer_lock(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_static_rw_lock_writer_trylock(lock: *mut GStaticRWLock) -> gboolean;
}
extern "C" {
    pub fn g_static_rw_lock_writer_unlock(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_static_rw_lock_free(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_private_new(notify: GDestroyNotify) -> *mut GPrivate;
}
pub type GStaticPrivate = _GStaticPrivate;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GStaticPrivate {
    pub index: guint,
}
#[test]
fn bindgen_test_layout__GStaticPrivate() {
    assert_eq!(
        ::std::mem::size_of::<_GStaticPrivate>(),
        4usize,
        concat!("Size of: ", stringify!(_GStaticPrivate))
    );
    assert_eq!(
        ::std::mem::align_of::<_GStaticPrivate>(),
        4usize,
        concat!("Alignment of ", stringify!(_GStaticPrivate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GStaticPrivate>())).index as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GStaticPrivate),
            "::",
            stringify!(index)
        )
    );
}
extern "C" {
    pub fn g_static_private_init(private_key: *mut GStaticPrivate);
}
extern "C" {
    pub fn g_static_private_get(private_key: *mut GStaticPrivate) -> gpointer;
}
extern "C" {
    pub fn g_static_private_set(
        private_key: *mut GStaticPrivate,
        data: gpointer,
        notify: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_static_private_free(private_key: *mut GStaticPrivate);
}
extern "C" {
    pub fn g_once_init_enter_impl(location: *mut gsize) -> gboolean;
}
extern "C" {
    pub fn g_thread_init(vtable: gpointer);
}
extern "C" {
    pub fn g_thread_init_with_errorcheck_mutexes(vtable: gpointer);
}
extern "C" {
    pub fn g_thread_get_initialized() -> gboolean;
}
extern "C" {
    pub static mut g_threads_got_initialized: gboolean;
}
extern "C" {
    pub fn g_mutex_new() -> *mut GMutex;
}
extern "C" {
    pub fn g_mutex_free(mutex: *mut GMutex);
}
extern "C" {
    pub fn g_cond_new() -> *mut GCond;
}
extern "C" {
    pub fn g_cond_free(cond: *mut GCond);
}
extern "C" {
    pub fn g_cond_timed_wait(
        cond: *mut GCond,
        mutex: *mut GMutex,
        timeval: *mut GTimeVal,
    ) -> gboolean;
}
pub type GAsyncQueue_autoptr = *mut GAsyncQueue;
pub type GAsyncQueue_listautoptr = *mut GList;
pub type GAsyncQueue_slistautoptr = *mut GSList;
pub type GAsyncQueue_queueautoptr = *mut GQueue;
pub type GBookmarkFile_autoptr = *mut GBookmarkFile;
pub type GBookmarkFile_listautoptr = *mut GList;
pub type GBookmarkFile_slistautoptr = *mut GSList;
pub type GBookmarkFile_queueautoptr = *mut GQueue;
pub type GBytes_autoptr = *mut GBytes;
pub type GBytes_listautoptr = *mut GList;
pub type GBytes_slistautoptr = *mut GSList;
pub type GBytes_queueautoptr = *mut GQueue;
pub type GChecksum_autoptr = *mut GChecksum;
pub type GChecksum_listautoptr = *mut GList;
pub type GChecksum_slistautoptr = *mut GSList;
pub type GChecksum_queueautoptr = *mut GQueue;
pub type GDateTime_autoptr = *mut GDateTime;
pub type GDateTime_listautoptr = *mut GList;
pub type GDateTime_slistautoptr = *mut GSList;
pub type GDateTime_queueautoptr = *mut GQueue;
pub type GDate_autoptr = *mut GDate;
pub type GDate_listautoptr = *mut GList;
pub type GDate_slistautoptr = *mut GSList;
pub type GDate_queueautoptr = *mut GQueue;
pub type GDir_autoptr = *mut GDir;
pub type GDir_listautoptr = *mut GList;
pub type GDir_slistautoptr = *mut GSList;
pub type GDir_queueautoptr = *mut GQueue;
pub type GError_autoptr = *mut GError;
pub type GError_listautoptr = *mut GList;
pub type GError_slistautoptr = *mut GSList;
pub type GError_queueautoptr = *mut GQueue;
pub type GHashTable_autoptr = *mut GHashTable;
pub type GHashTable_listautoptr = *mut GList;
pub type GHashTable_slistautoptr = *mut GSList;
pub type GHashTable_queueautoptr = *mut GQueue;
pub type GHmac_autoptr = *mut GHmac;
pub type GHmac_listautoptr = *mut GList;
pub type GHmac_slistautoptr = *mut GSList;
pub type GHmac_queueautoptr = *mut GQueue;
pub type GIOChannel_autoptr = *mut GIOChannel;
pub type GIOChannel_listautoptr = *mut GList;
pub type GIOChannel_slistautoptr = *mut GSList;
pub type GIOChannel_queueautoptr = *mut GQueue;
pub type GKeyFile_autoptr = *mut GKeyFile;
pub type GKeyFile_listautoptr = *mut GList;
pub type GKeyFile_slistautoptr = *mut GSList;
pub type GKeyFile_queueautoptr = *mut GQueue;
pub type GList_autoptr = *mut GList;
pub type GList_listautoptr = *mut GList;
pub type GList_slistautoptr = *mut GSList;
pub type GList_queueautoptr = *mut GQueue;
pub type GArray_autoptr = *mut GArray;
pub type GArray_listautoptr = *mut GList;
pub type GArray_slistautoptr = *mut GSList;
pub type GArray_queueautoptr = *mut GQueue;
pub type GPtrArray_autoptr = *mut GPtrArray;
pub type GPtrArray_listautoptr = *mut GList;
pub type GPtrArray_slistautoptr = *mut GSList;
pub type GPtrArray_queueautoptr = *mut GQueue;
pub type GByteArray_autoptr = *mut GByteArray;
pub type GByteArray_listautoptr = *mut GList;
pub type GByteArray_slistautoptr = *mut GSList;
pub type GByteArray_queueautoptr = *mut GQueue;
pub type GMainContext_autoptr = *mut GMainContext;
pub type GMainContext_listautoptr = *mut GList;
pub type GMainContext_slistautoptr = *mut GSList;
pub type GMainContext_queueautoptr = *mut GQueue;
pub type GMainContextPusher_autoptr = *mut GMainContextPusher;
pub type GMainContextPusher_listautoptr = *mut GList;
pub type GMainContextPusher_slistautoptr = *mut GSList;
pub type GMainContextPusher_queueautoptr = *mut GQueue;
pub type GMainLoop_autoptr = *mut GMainLoop;
pub type GMainLoop_listautoptr = *mut GList;
pub type GMainLoop_slistautoptr = *mut GSList;
pub type GMainLoop_queueautoptr = *mut GQueue;
pub type GSource_autoptr = *mut GSource;
pub type GSource_listautoptr = *mut GList;
pub type GSource_slistautoptr = *mut GSList;
pub type GSource_queueautoptr = *mut GQueue;
pub type GMappedFile_autoptr = *mut GMappedFile;
pub type GMappedFile_listautoptr = *mut GList;
pub type GMappedFile_slistautoptr = *mut GSList;
pub type GMappedFile_queueautoptr = *mut GQueue;
pub type GMarkupParseContext_autoptr = *mut GMarkupParseContext;
pub type GMarkupParseContext_listautoptr = *mut GList;
pub type GMarkupParseContext_slistautoptr = *mut GSList;
pub type GMarkupParseContext_queueautoptr = *mut GQueue;
pub type GNode_autoptr = *mut GNode;
pub type GNode_listautoptr = *mut GList;
pub type GNode_slistautoptr = *mut GSList;
pub type GNode_queueautoptr = *mut GQueue;
pub type GOptionContext_autoptr = *mut GOptionContext;
pub type GOptionContext_listautoptr = *mut GList;
pub type GOptionContext_slistautoptr = *mut GSList;
pub type GOptionContext_queueautoptr = *mut GQueue;
pub type GOptionGroup_autoptr = *mut GOptionGroup;
pub type GOptionGroup_listautoptr = *mut GList;
pub type GOptionGroup_slistautoptr = *mut GSList;
pub type GOptionGroup_queueautoptr = *mut GQueue;
pub type GPatternSpec_autoptr = *mut GPatternSpec;
pub type GPatternSpec_listautoptr = *mut GList;
pub type GPatternSpec_slistautoptr = *mut GSList;
pub type GPatternSpec_queueautoptr = *mut GQueue;
pub type GQueue_autoptr = *mut GQueue;
pub type GQueue_listautoptr = *mut GList;
pub type GQueue_slistautoptr = *mut GSList;
pub type GQueue_queueautoptr = *mut GQueue;
pub type GRand_autoptr = *mut GRand;
pub type GRand_listautoptr = *mut GList;
pub type GRand_slistautoptr = *mut GSList;
pub type GRand_queueautoptr = *mut GQueue;
pub type GRegex_autoptr = *mut GRegex;
pub type GRegex_listautoptr = *mut GList;
pub type GRegex_slistautoptr = *mut GSList;
pub type GRegex_queueautoptr = *mut GQueue;
pub type GMatchInfo_autoptr = *mut GMatchInfo;
pub type GMatchInfo_listautoptr = *mut GList;
pub type GMatchInfo_slistautoptr = *mut GSList;
pub type GMatchInfo_queueautoptr = *mut GQueue;
pub type GScanner_autoptr = *mut GScanner;
pub type GScanner_listautoptr = *mut GList;
pub type GScanner_slistautoptr = *mut GSList;
pub type GScanner_queueautoptr = *mut GQueue;
pub type GSequence_autoptr = *mut GSequence;
pub type GSequence_listautoptr = *mut GList;
pub type GSequence_slistautoptr = *mut GSList;
pub type GSequence_queueautoptr = *mut GQueue;
pub type GSList_autoptr = *mut GSList;
pub type GSList_listautoptr = *mut GList;
pub type GSList_slistautoptr = *mut GSList;
pub type GSList_queueautoptr = *mut GQueue;
pub type GString_autoptr = *mut GString;
pub type GString_listautoptr = *mut GList;
pub type GString_slistautoptr = *mut GSList;
pub type GString_queueautoptr = *mut GQueue;
pub type GStringChunk_autoptr = *mut GStringChunk;
pub type GStringChunk_listautoptr = *mut GList;
pub type GStringChunk_slistautoptr = *mut GSList;
pub type GStringChunk_queueautoptr = *mut GQueue;
pub type GThread_autoptr = *mut GThread;
pub type GThread_listautoptr = *mut GList;
pub type GThread_slistautoptr = *mut GSList;
pub type GThread_queueautoptr = *mut GQueue;
pub type GMutexLocker_autoptr = *mut GMutexLocker;
pub type GMutexLocker_listautoptr = *mut GList;
pub type GMutexLocker_slistautoptr = *mut GSList;
pub type GMutexLocker_queueautoptr = *mut GQueue;
pub type GRecMutexLocker_autoptr = *mut GRecMutexLocker;
pub type GRecMutexLocker_listautoptr = *mut GList;
pub type GRecMutexLocker_slistautoptr = *mut GSList;
pub type GRecMutexLocker_queueautoptr = *mut GQueue;
pub type GRWLockWriterLocker_autoptr = *mut GRWLockWriterLocker;
pub type GRWLockWriterLocker_listautoptr = *mut GList;
pub type GRWLockWriterLocker_slistautoptr = *mut GSList;
pub type GRWLockWriterLocker_queueautoptr = *mut GQueue;
pub type GRWLockReaderLocker_autoptr = *mut GRWLockReaderLocker;
pub type GRWLockReaderLocker_listautoptr = *mut GList;
pub type GRWLockReaderLocker_slistautoptr = *mut GSList;
pub type GRWLockReaderLocker_queueautoptr = *mut GQueue;
pub type GTimer_autoptr = *mut GTimer;
pub type GTimer_listautoptr = *mut GList;
pub type GTimer_slistautoptr = *mut GSList;
pub type GTimer_queueautoptr = *mut GQueue;
pub type GTimeZone_autoptr = *mut GTimeZone;
pub type GTimeZone_listautoptr = *mut GList;
pub type GTimeZone_slistautoptr = *mut GSList;
pub type GTimeZone_queueautoptr = *mut GQueue;
pub type GTree_autoptr = *mut GTree;
pub type GTree_listautoptr = *mut GList;
pub type GTree_slistautoptr = *mut GSList;
pub type GTree_queueautoptr = *mut GQueue;
pub type GVariant_autoptr = *mut GVariant;
pub type GVariant_listautoptr = *mut GList;
pub type GVariant_slistautoptr = *mut GSList;
pub type GVariant_queueautoptr = *mut GQueue;
pub type GVariantBuilder_autoptr = *mut GVariantBuilder;
pub type GVariantBuilder_listautoptr = *mut GList;
pub type GVariantBuilder_slistautoptr = *mut GSList;
pub type GVariantBuilder_queueautoptr = *mut GQueue;
pub type GVariantIter_autoptr = *mut GVariantIter;
pub type GVariantIter_listautoptr = *mut GList;
pub type GVariantIter_slistautoptr = *mut GSList;
pub type GVariantIter_queueautoptr = *mut GQueue;
pub type GVariantDict_autoptr = *mut GVariantDict;
pub type GVariantDict_listautoptr = *mut GList;
pub type GVariantDict_slistautoptr = *mut GSList;
pub type GVariantDict_queueautoptr = *mut GQueue;
pub type GVariantType_autoptr = *mut GVariantType;
pub type GVariantType_listautoptr = *mut GList;
pub type GVariantType_slistautoptr = *mut GSList;
pub type GVariantType_queueautoptr = *mut GQueue;
pub type GRefString_autoptr = *mut GRefString;
pub type GRefString_listautoptr = *mut GList;
pub type GRefString_slistautoptr = *mut GSList;
pub type GRefString_queueautoptr = *mut GQueue;
pub type __isoc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    _unused: [u8; 0],
}
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _G_fpos64_t {
    pub __opaque: [::std::os::raw::c_char; 16usize],
    pub __lldata: ::std::os::raw::c_longlong,
    pub __align: f64,
    _bindgen_union_align: [u64; 2usize],
}
#[test]
fn bindgen_test_layout__G_fpos64_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos64_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__opaque as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__opaque)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__lldata as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__lldata)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__align)
        )
    );
}
impl ::std::fmt::Debug for _G_fpos64_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_G_fpos64_t {{ union }}")
    }
}
pub type fpos_t = _G_fpos64_t;
extern "C" {
    pub static stdin: *mut FILE;
}
extern "C" {
    pub static stdout: *mut FILE;
}
extern "C" {
    pub static stderr: *mut FILE;
}
extern "C" {
    pub fn fopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn freopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn remove(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn feof(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr(arg1: *mut FILE);
}
extern "C" {
    pub fn fseek(
        arg1: *mut FILE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(arg1: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rewind(arg1: *mut FILE);
}
extern "C" {
    pub fn fgetpos(arg1: *mut FILE, arg2: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(arg1: *mut FILE, arg2: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_ulong,
        arg3: ::std::os::raw::c_ulong,
        arg4: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fwrite(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_ulong,
        arg3: ::std::os::raw::c_ulong,
        arg4: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fgetc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fputs(arg1: *const ::std::os::raw::c_char, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_ulong,
        arg3: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_ulong,
        arg3: *const ::std::os::raw::c_char,
        arg4: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuf(arg1: *mut FILE, arg2: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn tmpnam(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn fmemopen(
        arg1: *mut ::std::os::raw::c_void,
        arg2: size_t,
        arg3: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(arg1: *mut *mut ::std::os::raw::c_char, arg2: *mut size_t) -> *mut FILE;
}
extern "C" {
    pub fn fdopen(arg1: ::std::os::raw::c_int, arg2: *const ::std::os::raw::c_char) -> *mut FILE;
}
extern "C" {
    pub fn popen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn pclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fseeko(
        arg1: *mut FILE,
        arg2: off_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(arg1: *mut FILE) -> off_t;
}
extern "C" {
    pub fn dprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flockfile(arg1: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(arg1: *mut FILE);
}
extern "C" {
    pub fn getc_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdelim(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut size_t,
        arg3: ::std::os::raw::c_int,
        arg4: *mut FILE,
    ) -> ssize_t;
}
extern "C" {
    pub fn getline(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut size_t,
        arg3: *mut FILE,
    ) -> ssize_t;
}
extern "C" {
    pub fn renameat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tempnam(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn cuserid(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setlinebuf(arg1: *mut FILE);
}
extern "C" {
    pub fn setbuffer(arg1: *mut FILE, arg2: *mut ::std::os::raw::c_char, arg3: size_t);
}
extern "C" {
    pub fn fgetc_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc_unlocked(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread_unlocked(
        arg1: *mut ::std::os::raw::c_void,
        arg2: size_t,
        arg3: size_t,
        arg4: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fwrite_unlocked(
        arg1: *const ::std::os::raw::c_void,
        arg2: size_t,
        arg3: size_t,
        arg4: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn clearerr_unlocked(arg1: *mut FILE);
}
extern "C" {
    pub fn feof_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetln(arg1: *mut FILE, arg2: *mut size_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn asprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vasprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_printf(format: *const gchar, ...) -> gint;
}
extern "C" {
    pub fn g_fprintf(file: *mut FILE, format: *const gchar, ...) -> gint;
}
extern "C" {
    pub fn g_sprintf(string: *mut gchar, format: *const gchar, ...) -> gint;
}
extern "C" {
    pub fn g_vprintf(format: *const gchar, args: *mut __va_list_tag) -> gint;
}
extern "C" {
    pub fn g_vfprintf(file: *mut FILE, format: *const gchar, args: *mut __va_list_tag) -> gint;
}
extern "C" {
    pub fn g_vsprintf(string: *mut gchar, format: *const gchar, args: *mut __va_list_tag) -> gint;
}
extern "C" {
    pub fn g_vasprintf(
        string: *mut *mut gchar,
        format: *const gchar,
        args: *mut __va_list_tag,
    ) -> gint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct stat {
    pub st_dev: dev_t,
    pub st_ino: ino_t,
    pub st_nlink: nlink_t,
    pub st_mode: mode_t,
    pub st_uid: uid_t,
    pub st_gid: gid_t,
    pub __pad0: ::std::os::raw::c_uint,
    pub st_rdev: dev_t,
    pub st_size: off_t,
    pub st_blksize: blksize_t,
    pub st_blocks: blkcnt_t,
    pub st_atim: timespec,
    pub st_mtim: timespec,
    pub st_ctim: timespec,
    pub __unused: [::std::os::raw::c_long; 3usize],
}
#[test]
fn bindgen_test_layout_stat() {
    assert_eq!(
        ::std::mem::size_of::<stat>(),
        144usize,
        concat!("Size of: ", stringify!(stat))
    );
    assert_eq!(
        ::std::mem::align_of::<stat>(),
        8usize,
        concat!("Alignment of ", stringify!(stat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_nlink as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_mode as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_uid as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_gid as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).__pad0 as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(__pad0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_rdev as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_size as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_blksize as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_blocks as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_atim as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_atim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_mtim as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_mtim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_ctim as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_ctim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).__unused as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(__unused)
        )
    );
}
extern "C" {
    pub fn stat(arg1: *const ::std::os::raw::c_char, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstat(arg1: ::std::os::raw::c_int, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lstat(arg1: *const ::std::os::raw::c_char, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstatat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut stat,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chmod(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchmod(arg1: ::std::os::raw::c_int, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchmodat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: mode_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn umask(arg1: mode_t) -> mode_t;
}
extern "C" {
    pub fn mkdir(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkfifo(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdirat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkfifoat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mknod(
        arg1: *const ::std::os::raw::c_char,
        arg2: mode_t,
        arg3: dev_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mknodat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: mode_t,
        arg4: dev_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn futimens(arg1: ::std::os::raw::c_int, arg2: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn utimensat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const timespec,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchmod(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
pub type GStatBuf = stat;
extern "C" {
    pub fn g_access(filename: *const gchar, mode: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_chdir(path: *const gchar) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_unlink(filename: *const gchar) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_rmdir(filename: *const gchar) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_close(fd: gint, error: *mut *mut GError) -> gboolean;
}
pub const GModuleFlags_G_MODULE_BIND_LAZY: GModuleFlags = 1;
pub const GModuleFlags_G_MODULE_BIND_LOCAL: GModuleFlags = 2;
pub const GModuleFlags_G_MODULE_BIND_MASK: GModuleFlags = 3;
pub type GModuleFlags = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GModule {
    _unused: [u8; 0],
}
pub type GModule = _GModule;
pub type GModuleCheckInit =
    ::std::option::Option<unsafe extern "C" fn(module: *mut GModule) -> *const gchar>;
pub type GModuleUnload = ::std::option::Option<unsafe extern "C" fn(module: *mut GModule)>;
extern "C" {
    pub fn g_module_supported() -> gboolean;
}
extern "C" {
    pub fn g_module_open(file_name: *const gchar, flags: GModuleFlags) -> *mut GModule;
}
extern "C" {
    pub fn g_module_close(module: *mut GModule) -> gboolean;
}
extern "C" {
    pub fn g_module_make_resident(module: *mut GModule);
}
extern "C" {
    pub fn g_module_error() -> *const gchar;
}
extern "C" {
    pub fn g_module_symbol(
        module: *mut GModule,
        symbol_name: *const gchar,
        symbol: *mut gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_module_name(module: *mut GModule) -> *const gchar;
}
extern "C" {
    pub fn g_module_build_path(directory: *const gchar, module_name: *const gchar) -> *mut gchar;
}
pub type GType = gsize;
pub type GValue = _GValue;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GTypeCValue {
    _unused: [u8; 0],
}
impl ::std::fmt::Debug for _GTypeCValue {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GTypeCValue {{ union }}")
    }
}
pub type GTypeCValue = _GTypeCValue;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTypePlugin {
    _unused: [u8; 0],
}
pub type GTypePlugin = _GTypePlugin;
pub type GTypeClass = _GTypeClass;
pub type GTypeInterface = _GTypeInterface;
pub type GTypeInstance = _GTypeInstance;
pub type GTypeInfo = _GTypeInfo;
pub type GTypeFundamentalInfo = _GTypeFundamentalInfo;
pub type GInterfaceInfo = _GInterfaceInfo;
pub type GTypeValueTable = _GTypeValueTable;
pub type GTypeQuery = _GTypeQuery;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTypeClass {
    pub g_type: GType,
}
#[test]
fn bindgen_test_layout__GTypeClass() {
    assert_eq!(
        ::std::mem::size_of::<_GTypeClass>(),
        8usize,
        concat!("Size of: ", stringify!(_GTypeClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTypeClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTypeClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeClass>())).g_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeClass),
            "::",
            stringify!(g_type)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTypeInstance {
    pub g_class: *mut GTypeClass,
}
#[test]
fn bindgen_test_layout__GTypeInstance() {
    assert_eq!(
        ::std::mem::size_of::<_GTypeInstance>(),
        8usize,
        concat!("Size of: ", stringify!(_GTypeInstance))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTypeInstance>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTypeInstance))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInstance>())).g_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInstance),
            "::",
            stringify!(g_class)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTypeInterface {
    pub g_type: GType,
    pub g_instance_type: GType,
}
#[test]
fn bindgen_test_layout__GTypeInterface() {
    assert_eq!(
        ::std::mem::size_of::<_GTypeInterface>(),
        16usize,
        concat!("Size of: ", stringify!(_GTypeInterface))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTypeInterface>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTypeInterface))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInterface>())).g_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInterface),
            "::",
            stringify!(g_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInterface>())).g_instance_type as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInterface),
            "::",
            stringify!(g_instance_type)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTypeQuery {
    pub type_: GType,
    pub type_name: *const gchar,
    pub class_size: guint,
    pub instance_size: guint,
}
#[test]
fn bindgen_test_layout__GTypeQuery() {
    assert_eq!(
        ::std::mem::size_of::<_GTypeQuery>(),
        24usize,
        concat!("Size of: ", stringify!(_GTypeQuery))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTypeQuery>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTypeQuery))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeQuery>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeQuery),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeQuery>())).type_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeQuery),
            "::",
            stringify!(type_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeQuery>())).class_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeQuery),
            "::",
            stringify!(class_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeQuery>())).instance_size as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeQuery),
            "::",
            stringify!(instance_size)
        )
    );
}
pub const GTypeDebugFlags_G_TYPE_DEBUG_NONE: GTypeDebugFlags = 0;
pub const GTypeDebugFlags_G_TYPE_DEBUG_OBJECTS: GTypeDebugFlags = 1;
pub const GTypeDebugFlags_G_TYPE_DEBUG_SIGNALS: GTypeDebugFlags = 2;
pub const GTypeDebugFlags_G_TYPE_DEBUG_INSTANCE_COUNT: GTypeDebugFlags = 4;
pub const GTypeDebugFlags_G_TYPE_DEBUG_MASK: GTypeDebugFlags = 7;
pub type GTypeDebugFlags = u32;
extern "C" {
    pub fn g_type_init();
}
extern "C" {
    pub fn g_type_init_with_debug_flags(debug_flags: GTypeDebugFlags);
}
extern "C" {
    pub fn g_type_name(type_: GType) -> *const gchar;
}
extern "C" {
    pub fn g_type_qname(type_: GType) -> GQuark;
}
extern "C" {
    pub fn g_type_from_name(name: *const gchar) -> GType;
}
extern "C" {
    pub fn g_type_parent(type_: GType) -> GType;
}
extern "C" {
    pub fn g_type_depth(type_: GType) -> guint;
}
extern "C" {
    pub fn g_type_next_base(leaf_type: GType, root_type: GType) -> GType;
}
extern "C" {
    pub fn g_type_is_a(type_: GType, is_a_type: GType) -> gboolean;
}
extern "C" {
    pub fn g_type_class_ref(type_: GType) -> gpointer;
}
extern "C" {
    pub fn g_type_class_peek(type_: GType) -> gpointer;
}
extern "C" {
    pub fn g_type_class_peek_static(type_: GType) -> gpointer;
}
extern "C" {
    pub fn g_type_class_unref(g_class: gpointer);
}
extern "C" {
    pub fn g_type_class_peek_parent(g_class: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_type_interface_peek(instance_class: gpointer, iface_type: GType) -> gpointer;
}
extern "C" {
    pub fn g_type_interface_peek_parent(g_iface: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_type_default_interface_ref(g_type: GType) -> gpointer;
}
extern "C" {
    pub fn g_type_default_interface_peek(g_type: GType) -> gpointer;
}
extern "C" {
    pub fn g_type_default_interface_unref(g_iface: gpointer);
}
extern "C" {
    pub fn g_type_children(type_: GType, n_children: *mut guint) -> *mut GType;
}
extern "C" {
    pub fn g_type_interfaces(type_: GType, n_interfaces: *mut guint) -> *mut GType;
}
extern "C" {
    pub fn g_type_set_qdata(type_: GType, quark: GQuark, data: gpointer);
}
extern "C" {
    pub fn g_type_get_qdata(type_: GType, quark: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_type_query(type_: GType, query: *mut GTypeQuery);
}
extern "C" {
    pub fn g_type_get_instance_count(type_: GType) -> ::std::os::raw::c_int;
}
pub type GBaseInitFunc = ::std::option::Option<unsafe extern "C" fn(g_class: gpointer)>;
pub type GBaseFinalizeFunc = ::std::option::Option<unsafe extern "C" fn(g_class: gpointer)>;
pub type GClassInitFunc =
    ::std::option::Option<unsafe extern "C" fn(g_class: gpointer, class_data: gpointer)>;
pub type GClassFinalizeFunc =
    ::std::option::Option<unsafe extern "C" fn(g_class: gpointer, class_data: gpointer)>;
pub type GInstanceInitFunc =
    ::std::option::Option<unsafe extern "C" fn(instance: *mut GTypeInstance, g_class: gpointer)>;
pub type GInterfaceInitFunc =
    ::std::option::Option<unsafe extern "C" fn(g_iface: gpointer, iface_data: gpointer)>;
pub type GInterfaceFinalizeFunc =
    ::std::option::Option<unsafe extern "C" fn(g_iface: gpointer, iface_data: gpointer)>;
pub type GTypeClassCacheFunc = ::std::option::Option<
    unsafe extern "C" fn(cache_data: gpointer, g_class: *mut GTypeClass) -> gboolean,
>;
pub type GTypeInterfaceCheckFunc =
    ::std::option::Option<unsafe extern "C" fn(check_data: gpointer, g_iface: gpointer)>;
pub const GTypeFundamentalFlags_G_TYPE_FLAG_CLASSED: GTypeFundamentalFlags = 1;
pub const GTypeFundamentalFlags_G_TYPE_FLAG_INSTANTIATABLE: GTypeFundamentalFlags = 2;
pub const GTypeFundamentalFlags_G_TYPE_FLAG_DERIVABLE: GTypeFundamentalFlags = 4;
pub const GTypeFundamentalFlags_G_TYPE_FLAG_DEEP_DERIVABLE: GTypeFundamentalFlags = 8;
pub type GTypeFundamentalFlags = u32;
pub const GTypeFlags_G_TYPE_FLAG_ABSTRACT: GTypeFlags = 16;
pub const GTypeFlags_G_TYPE_FLAG_VALUE_ABSTRACT: GTypeFlags = 32;
pub type GTypeFlags = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTypeInfo {
    pub class_size: guint16,
    pub base_init: GBaseInitFunc,
    pub base_finalize: GBaseFinalizeFunc,
    pub class_init: GClassInitFunc,
    pub class_finalize: GClassFinalizeFunc,
    pub class_data: gconstpointer,
    pub instance_size: guint16,
    pub n_preallocs: guint16,
    pub instance_init: GInstanceInitFunc,
    pub value_table: *const GTypeValueTable,
}
#[test]
fn bindgen_test_layout__GTypeInfo() {
    assert_eq!(
        ::std::mem::size_of::<_GTypeInfo>(),
        72usize,
        concat!("Size of: ", stringify!(_GTypeInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTypeInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTypeInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInfo>())).class_size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInfo),
            "::",
            stringify!(class_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInfo>())).base_init as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInfo),
            "::",
            stringify!(base_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInfo>())).base_finalize as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInfo),
            "::",
            stringify!(base_finalize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInfo>())).class_init as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInfo),
            "::",
            stringify!(class_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInfo>())).class_finalize as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInfo),
            "::",
            stringify!(class_finalize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInfo>())).class_data as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInfo),
            "::",
            stringify!(class_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInfo>())).instance_size as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInfo),
            "::",
            stringify!(instance_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInfo>())).n_preallocs as *const _ as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInfo),
            "::",
            stringify!(n_preallocs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInfo>())).instance_init as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInfo),
            "::",
            stringify!(instance_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeInfo>())).value_table as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeInfo),
            "::",
            stringify!(value_table)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTypeFundamentalInfo {
    pub type_flags: GTypeFundamentalFlags,
}
#[test]
fn bindgen_test_layout__GTypeFundamentalInfo() {
    assert_eq!(
        ::std::mem::size_of::<_GTypeFundamentalInfo>(),
        4usize,
        concat!("Size of: ", stringify!(_GTypeFundamentalInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTypeFundamentalInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(_GTypeFundamentalInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GTypeFundamentalInfo>())).type_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeFundamentalInfo),
            "::",
            stringify!(type_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GInterfaceInfo {
    pub interface_init: GInterfaceInitFunc,
    pub interface_finalize: GInterfaceFinalizeFunc,
    pub interface_data: gpointer,
}
#[test]
fn bindgen_test_layout__GInterfaceInfo() {
    assert_eq!(
        ::std::mem::size_of::<_GInterfaceInfo>(),
        24usize,
        concat!("Size of: ", stringify!(_GInterfaceInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<_GInterfaceInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(_GInterfaceInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInterfaceInfo>())).interface_init as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInterfaceInfo),
            "::",
            stringify!(interface_init)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GInterfaceInfo>())).interface_finalize as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInterfaceInfo),
            "::",
            stringify!(interface_finalize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInterfaceInfo>())).interface_data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInterfaceInfo),
            "::",
            stringify!(interface_data)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTypeValueTable {
    pub value_init: ::std::option::Option<unsafe extern "C" fn(value: *mut GValue)>,
    pub value_free: ::std::option::Option<unsafe extern "C" fn(value: *mut GValue)>,
    pub value_copy: ::std::option::Option<
        unsafe extern "C" fn(src_value: *const GValue, dest_value: *mut GValue),
    >,
    pub value_peek_pointer:
        ::std::option::Option<unsafe extern "C" fn(value: *const GValue) -> gpointer>,
    pub collect_format: *const gchar,
    pub collect_value: ::std::option::Option<
        unsafe extern "C" fn(
            value: *mut GValue,
            n_collect_values: guint,
            collect_values: *mut GTypeCValue,
            collect_flags: guint,
        ) -> *mut gchar,
    >,
    pub lcopy_format: *const gchar,
    pub lcopy_value: ::std::option::Option<
        unsafe extern "C" fn(
            value: *const GValue,
            n_collect_values: guint,
            collect_values: *mut GTypeCValue,
            collect_flags: guint,
        ) -> *mut gchar,
    >,
}
#[test]
fn bindgen_test_layout__GTypeValueTable() {
    assert_eq!(
        ::std::mem::size_of::<_GTypeValueTable>(),
        64usize,
        concat!("Size of: ", stringify!(_GTypeValueTable))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTypeValueTable>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTypeValueTable))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeValueTable>())).value_init as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeValueTable),
            "::",
            stringify!(value_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeValueTable>())).value_free as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeValueTable),
            "::",
            stringify!(value_free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeValueTable>())).value_copy as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeValueTable),
            "::",
            stringify!(value_copy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GTypeValueTable>())).value_peek_pointer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeValueTable),
            "::",
            stringify!(value_peek_pointer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeValueTable>())).collect_format as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeValueTable),
            "::",
            stringify!(collect_format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeValueTable>())).collect_value as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeValueTable),
            "::",
            stringify!(collect_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeValueTable>())).lcopy_format as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeValueTable),
            "::",
            stringify!(lcopy_format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeValueTable>())).lcopy_value as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeValueTable),
            "::",
            stringify!(lcopy_value)
        )
    );
}
extern "C" {
    pub fn g_type_register_static(
        parent_type: GType,
        type_name: *const gchar,
        info: *const GTypeInfo,
        flags: GTypeFlags,
    ) -> GType;
}
extern "C" {
    pub fn g_type_register_static_simple(
        parent_type: GType,
        type_name: *const gchar,
        class_size: guint,
        class_init: GClassInitFunc,
        instance_size: guint,
        instance_init: GInstanceInitFunc,
        flags: GTypeFlags,
    ) -> GType;
}
extern "C" {
    pub fn g_type_register_dynamic(
        parent_type: GType,
        type_name: *const gchar,
        plugin: *mut GTypePlugin,
        flags: GTypeFlags,
    ) -> GType;
}
extern "C" {
    pub fn g_type_register_fundamental(
        type_id: GType,
        type_name: *const gchar,
        info: *const GTypeInfo,
        finfo: *const GTypeFundamentalInfo,
        flags: GTypeFlags,
    ) -> GType;
}
extern "C" {
    pub fn g_type_add_interface_static(
        instance_type: GType,
        interface_type: GType,
        info: *const GInterfaceInfo,
    );
}
extern "C" {
    pub fn g_type_add_interface_dynamic(
        instance_type: GType,
        interface_type: GType,
        plugin: *mut GTypePlugin,
    );
}
extern "C" {
    pub fn g_type_interface_add_prerequisite(interface_type: GType, prerequisite_type: GType);
}
extern "C" {
    pub fn g_type_interface_prerequisites(
        interface_type: GType,
        n_prerequisites: *mut guint,
    ) -> *mut GType;
}
extern "C" {
    pub fn g_type_class_add_private(g_class: gpointer, private_size: gsize);
}
extern "C" {
    pub fn g_type_add_instance_private(class_type: GType, private_size: gsize) -> gint;
}
extern "C" {
    pub fn g_type_instance_get_private(
        instance: *mut GTypeInstance,
        private_type: GType,
    ) -> gpointer;
}
extern "C" {
    pub fn g_type_class_adjust_private_offset(g_class: gpointer, private_size_or_offset: *mut gint);
}
extern "C" {
    pub fn g_type_add_class_private(class_type: GType, private_size: gsize);
}
extern "C" {
    pub fn g_type_class_get_private(klass: *mut GTypeClass, private_type: GType) -> gpointer;
}
extern "C" {
    pub fn g_type_class_get_instance_private_offset(g_class: gpointer) -> gint;
}
extern "C" {
    pub fn g_type_ensure(type_: GType);
}
extern "C" {
    pub fn g_type_get_type_registration_serial() -> guint;
}
extern "C" {
    pub fn g_type_get_plugin(type_: GType) -> *mut GTypePlugin;
}
extern "C" {
    pub fn g_type_interface_get_plugin(
        instance_type: GType,
        interface_type: GType,
    ) -> *mut GTypePlugin;
}
extern "C" {
    pub fn g_type_fundamental_next() -> GType;
}
extern "C" {
    pub fn g_type_fundamental(type_id: GType) -> GType;
}
extern "C" {
    pub fn g_type_create_instance(type_: GType) -> *mut GTypeInstance;
}
extern "C" {
    pub fn g_type_free_instance(instance: *mut GTypeInstance);
}
extern "C" {
    pub fn g_type_add_class_cache_func(cache_data: gpointer, cache_func: GTypeClassCacheFunc);
}
extern "C" {
    pub fn g_type_remove_class_cache_func(cache_data: gpointer, cache_func: GTypeClassCacheFunc);
}
extern "C" {
    pub fn g_type_class_unref_uncached(g_class: gpointer);
}
extern "C" {
    pub fn g_type_add_interface_check(check_data: gpointer, check_func: GTypeInterfaceCheckFunc);
}
extern "C" {
    pub fn g_type_remove_interface_check(check_data: gpointer, check_func: GTypeInterfaceCheckFunc);
}
extern "C" {
    pub fn g_type_value_table_peek(type_: GType) -> *mut GTypeValueTable;
}
extern "C" {
    pub fn g_type_check_instance(instance: *mut GTypeInstance) -> gboolean;
}
extern "C" {
    pub fn g_type_check_instance_cast(
        instance: *mut GTypeInstance,
        iface_type: GType,
    ) -> *mut GTypeInstance;
}
extern "C" {
    pub fn g_type_check_instance_is_a(instance: *mut GTypeInstance, iface_type: GType) -> gboolean;
}
extern "C" {
    pub fn g_type_check_instance_is_fundamentally_a(
        instance: *mut GTypeInstance,
        fundamental_type: GType,
    ) -> gboolean;
}
extern "C" {
    pub fn g_type_check_class_cast(g_class: *mut GTypeClass, is_a_type: GType) -> *mut GTypeClass;
}
extern "C" {
    pub fn g_type_check_class_is_a(g_class: *mut GTypeClass, is_a_type: GType) -> gboolean;
}
extern "C" {
    pub fn g_type_check_is_value_type(type_: GType) -> gboolean;
}
extern "C" {
    pub fn g_type_check_value(value: *const GValue) -> gboolean;
}
extern "C" {
    pub fn g_type_check_value_holds(value: *const GValue, type_: GType) -> gboolean;
}
extern "C" {
    pub fn g_type_test_flags(type_: GType, flags: guint) -> gboolean;
}
extern "C" {
    pub fn g_type_name_from_instance(instance: *mut GTypeInstance) -> *const gchar;
}
extern "C" {
    pub fn g_type_name_from_class(g_class: *mut GTypeClass) -> *const gchar;
}
pub type GValueTransform =
    ::std::option::Option<unsafe extern "C" fn(src_value: *const GValue, dest_value: *mut GValue)>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GValue {
    pub g_type: GType,
    pub data: [_GValue__bindgen_ty_1; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GValue__bindgen_ty_1 {
    pub v_int: gint,
    pub v_uint: guint,
    pub v_long: glong,
    pub v_ulong: gulong,
    pub v_int64: gint64,
    pub v_uint64: guint64,
    pub v_float: gfloat,
    pub v_double: gdouble,
    pub v_pointer: gpointer,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout__GValue__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_GValue__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_GValue__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_GValue__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_GValue__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue__bindgen_ty_1>())).v_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue__bindgen_ty_1),
            "::",
            stringify!(v_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue__bindgen_ty_1>())).v_uint as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue__bindgen_ty_1),
            "::",
            stringify!(v_uint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue__bindgen_ty_1>())).v_long as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue__bindgen_ty_1),
            "::",
            stringify!(v_long)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue__bindgen_ty_1>())).v_ulong as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue__bindgen_ty_1),
            "::",
            stringify!(v_ulong)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue__bindgen_ty_1>())).v_int64 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue__bindgen_ty_1),
            "::",
            stringify!(v_int64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue__bindgen_ty_1>())).v_uint64 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue__bindgen_ty_1),
            "::",
            stringify!(v_uint64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue__bindgen_ty_1>())).v_float as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue__bindgen_ty_1),
            "::",
            stringify!(v_float)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue__bindgen_ty_1>())).v_double as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue__bindgen_ty_1),
            "::",
            stringify!(v_double)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue__bindgen_ty_1>())).v_pointer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue__bindgen_ty_1),
            "::",
            stringify!(v_pointer)
        )
    );
}
impl ::std::fmt::Debug for _GValue__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "_GValue__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout__GValue() {
    assert_eq!(
        ::std::mem::size_of::<_GValue>(),
        24usize,
        concat!("Size of: ", stringify!(_GValue))
    );
    assert_eq!(
        ::std::mem::align_of::<_GValue>(),
        8usize,
        concat!("Alignment of ", stringify!(_GValue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue>())).g_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue),
            "::",
            stringify!(g_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValue>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValue),
            "::",
            stringify!(data)
        )
    );
}
impl ::std::fmt::Debug for _GValue {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "_GValue {{ g_type: {:?}, data: {:?} }}",
            self.g_type, self.data
        )
    }
}
extern "C" {
    pub fn g_value_init(value: *mut GValue, g_type: GType) -> *mut GValue;
}
extern "C" {
    pub fn g_value_copy(src_value: *const GValue, dest_value: *mut GValue);
}
extern "C" {
    pub fn g_value_reset(value: *mut GValue) -> *mut GValue;
}
extern "C" {
    pub fn g_value_unset(value: *mut GValue);
}
extern "C" {
    pub fn g_value_set_instance(value: *mut GValue, instance: gpointer);
}
extern "C" {
    pub fn g_value_init_from_instance(value: *mut GValue, instance: gpointer);
}
extern "C" {
    pub fn g_value_fits_pointer(value: *const GValue) -> gboolean;
}
extern "C" {
    pub fn g_value_peek_pointer(value: *const GValue) -> gpointer;
}
extern "C" {
    pub fn g_value_type_compatible(src_type: GType, dest_type: GType) -> gboolean;
}
extern "C" {
    pub fn g_value_type_transformable(src_type: GType, dest_type: GType) -> gboolean;
}
extern "C" {
    pub fn g_value_transform(src_value: *const GValue, dest_value: *mut GValue) -> gboolean;
}
extern "C" {
    pub fn g_value_register_transform_func(
        src_type: GType,
        dest_type: GType,
        transform_func: GValueTransform,
    );
}
pub const GParamFlags_G_PARAM_READABLE: GParamFlags = 1;
pub const GParamFlags_G_PARAM_WRITABLE: GParamFlags = 2;
pub const GParamFlags_G_PARAM_READWRITE: GParamFlags = 3;
pub const GParamFlags_G_PARAM_CONSTRUCT: GParamFlags = 4;
pub const GParamFlags_G_PARAM_CONSTRUCT_ONLY: GParamFlags = 8;
pub const GParamFlags_G_PARAM_LAX_VALIDATION: GParamFlags = 16;
pub const GParamFlags_G_PARAM_STATIC_NAME: GParamFlags = 32;
pub const GParamFlags_G_PARAM_PRIVATE: GParamFlags = 32;
pub const GParamFlags_G_PARAM_STATIC_NICK: GParamFlags = 64;
pub const GParamFlags_G_PARAM_STATIC_BLURB: GParamFlags = 128;
pub const GParamFlags_G_PARAM_EXPLICIT_NOTIFY: GParamFlags = 1073741824;
pub const GParamFlags_G_PARAM_DEPRECATED: GParamFlags = -2147483648;
pub type GParamFlags = i32;
pub type GParamSpec = _GParamSpec;
pub type GParamSpecClass = _GParamSpecClass;
pub type GParameter = _GParameter;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GParamSpecPool {
    _unused: [u8; 0],
}
pub type GParamSpecPool = _GParamSpecPool;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpec {
    pub g_type_instance: GTypeInstance,
    pub name: *const gchar,
    pub flags: GParamFlags,
    pub value_type: GType,
    pub owner_type: GType,
    pub _nick: *mut gchar,
    pub _blurb: *mut gchar,
    pub qdata: *mut GData,
    pub ref_count: guint,
    pub param_id: guint,
}
#[test]
fn bindgen_test_layout__GParamSpec() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpec>(),
        72usize,
        concat!("Size of: ", stringify!(_GParamSpec))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpec>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpec>())).g_type_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpec),
            "::",
            stringify!(g_type_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpec>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpec),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpec>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpec),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpec>())).value_type as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpec),
            "::",
            stringify!(value_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpec>())).owner_type as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpec),
            "::",
            stringify!(owner_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpec>()))._nick as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpec),
            "::",
            stringify!(_nick)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpec>()))._blurb as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpec),
            "::",
            stringify!(_blurb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpec>())).qdata as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpec),
            "::",
            stringify!(qdata)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpec>())).ref_count as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpec),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpec>())).param_id as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpec),
            "::",
            stringify!(param_id)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecClass {
    pub g_type_class: GTypeClass,
    pub value_type: GType,
    pub finalize: ::std::option::Option<unsafe extern "C" fn(pspec: *mut GParamSpec)>,
    pub value_set_default:
        ::std::option::Option<unsafe extern "C" fn(pspec: *mut GParamSpec, value: *mut GValue)>,
    pub value_validate: ::std::option::Option<
        unsafe extern "C" fn(pspec: *mut GParamSpec, value: *mut GValue) -> gboolean,
    >,
    pub values_cmp: ::std::option::Option<
        unsafe extern "C" fn(
            pspec: *mut GParamSpec,
            value1: *const GValue,
            value2: *const GValue,
        ) -> gint,
    >,
    pub dummy: [gpointer; 4usize],
}
#[test]
fn bindgen_test_layout__GParamSpecClass() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecClass>(),
        80usize,
        concat!("Size of: ", stringify!(_GParamSpecClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecClass>())).g_type_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecClass),
            "::",
            stringify!(g_type_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecClass>())).value_type as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecClass),
            "::",
            stringify!(value_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecClass>())).finalize as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecClass),
            "::",
            stringify!(finalize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecClass>())).value_set_default as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecClass),
            "::",
            stringify!(value_set_default)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecClass>())).value_validate as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecClass),
            "::",
            stringify!(value_validate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecClass>())).values_cmp as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecClass),
            "::",
            stringify!(values_cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecClass>())).dummy as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecClass),
            "::",
            stringify!(dummy)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GParameter {
    pub name: *const gchar,
    pub value: GValue,
}
#[test]
fn bindgen_test_layout__GParameter() {
    assert_eq!(
        ::std::mem::size_of::<_GParameter>(),
        32usize,
        concat!("Size of: ", stringify!(_GParameter))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParameter>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParameter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParameter>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParameter),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParameter>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParameter),
            "::",
            stringify!(value)
        )
    );
}
impl ::std::fmt::Debug for _GParameter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "_GParameter {{ name: {:?}, value: {:?} }}",
            self.name, self.value
        )
    }
}
extern "C" {
    pub fn g_param_spec_ref(pspec: *mut GParamSpec) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_unref(pspec: *mut GParamSpec);
}
extern "C" {
    pub fn g_param_spec_sink(pspec: *mut GParamSpec);
}
extern "C" {
    pub fn g_param_spec_ref_sink(pspec: *mut GParamSpec) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_get_qdata(pspec: *mut GParamSpec, quark: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_param_spec_set_qdata(pspec: *mut GParamSpec, quark: GQuark, data: gpointer);
}
extern "C" {
    pub fn g_param_spec_set_qdata_full(
        pspec: *mut GParamSpec,
        quark: GQuark,
        data: gpointer,
        destroy: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_param_spec_steal_qdata(pspec: *mut GParamSpec, quark: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_param_spec_get_redirect_target(pspec: *mut GParamSpec) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_value_set_default(pspec: *mut GParamSpec, value: *mut GValue);
}
extern "C" {
    pub fn g_param_value_defaults(pspec: *mut GParamSpec, value: *const GValue) -> gboolean;
}
extern "C" {
    pub fn g_param_value_validate(pspec: *mut GParamSpec, value: *mut GValue) -> gboolean;
}
extern "C" {
    pub fn g_param_value_convert(
        pspec: *mut GParamSpec,
        src_value: *const GValue,
        dest_value: *mut GValue,
        strict_validation: gboolean,
    ) -> gboolean;
}
extern "C" {
    pub fn g_param_values_cmp(
        pspec: *mut GParamSpec,
        value1: *const GValue,
        value2: *const GValue,
    ) -> gint;
}
extern "C" {
    pub fn g_param_spec_get_name(pspec: *mut GParamSpec) -> *const gchar;
}
extern "C" {
    pub fn g_param_spec_get_nick(pspec: *mut GParamSpec) -> *const gchar;
}
extern "C" {
    pub fn g_param_spec_get_blurb(pspec: *mut GParamSpec) -> *const gchar;
}
extern "C" {
    pub fn g_value_set_param(value: *mut GValue, param: *mut GParamSpec);
}
extern "C" {
    pub fn g_value_get_param(value: *const GValue) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_value_dup_param(value: *const GValue) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_value_take_param(value: *mut GValue, param: *mut GParamSpec);
}
extern "C" {
    pub fn g_value_set_param_take_ownership(value: *mut GValue, param: *mut GParamSpec);
}
extern "C" {
    pub fn g_param_spec_get_default_value(pspec: *mut GParamSpec) -> *const GValue;
}
extern "C" {
    pub fn g_param_spec_get_name_quark(pspec: *mut GParamSpec) -> GQuark;
}
pub type GParamSpecTypeInfo = _GParamSpecTypeInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecTypeInfo {
    pub instance_size: guint16,
    pub n_preallocs: guint16,
    pub instance_init: ::std::option::Option<unsafe extern "C" fn(pspec: *mut GParamSpec)>,
    pub value_type: GType,
    pub finalize: ::std::option::Option<unsafe extern "C" fn(pspec: *mut GParamSpec)>,
    pub value_set_default:
        ::std::option::Option<unsafe extern "C" fn(pspec: *mut GParamSpec, value: *mut GValue)>,
    pub value_validate: ::std::option::Option<
        unsafe extern "C" fn(pspec: *mut GParamSpec, value: *mut GValue) -> gboolean,
    >,
    pub values_cmp: ::std::option::Option<
        unsafe extern "C" fn(
            pspec: *mut GParamSpec,
            value1: *const GValue,
            value2: *const GValue,
        ) -> gint,
    >,
}
#[test]
fn bindgen_test_layout__GParamSpecTypeInfo() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecTypeInfo>(),
        56usize,
        concat!("Size of: ", stringify!(_GParamSpecTypeInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecTypeInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecTypeInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecTypeInfo>())).instance_size as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecTypeInfo),
            "::",
            stringify!(instance_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecTypeInfo>())).n_preallocs as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecTypeInfo),
            "::",
            stringify!(n_preallocs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecTypeInfo>())).instance_init as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecTypeInfo),
            "::",
            stringify!(instance_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecTypeInfo>())).value_type as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecTypeInfo),
            "::",
            stringify!(value_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecTypeInfo>())).finalize as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecTypeInfo),
            "::",
            stringify!(finalize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecTypeInfo>())).value_set_default as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecTypeInfo),
            "::",
            stringify!(value_set_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecTypeInfo>())).value_validate as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecTypeInfo),
            "::",
            stringify!(value_validate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecTypeInfo>())).values_cmp as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecTypeInfo),
            "::",
            stringify!(values_cmp)
        )
    );
}
extern "C" {
    pub fn g_param_type_register_static(
        name: *const gchar,
        pspec_info: *const GParamSpecTypeInfo,
    ) -> GType;
}
extern "C" {
    pub fn _g_param_type_register_static_constant(
        name: *const gchar,
        pspec_info: *const GParamSpecTypeInfo,
        opt_type: GType,
    ) -> GType;
}
extern "C" {
    pub fn g_param_spec_internal(
        param_type: GType,
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        flags: GParamFlags,
    ) -> gpointer;
}
extern "C" {
    pub fn g_param_spec_pool_new(type_prefixing: gboolean) -> *mut GParamSpecPool;
}
extern "C" {
    pub fn g_param_spec_pool_insert(
        pool: *mut GParamSpecPool,
        pspec: *mut GParamSpec,
        owner_type: GType,
    );
}
extern "C" {
    pub fn g_param_spec_pool_remove(pool: *mut GParamSpecPool, pspec: *mut GParamSpec);
}
extern "C" {
    pub fn g_param_spec_pool_lookup(
        pool: *mut GParamSpecPool,
        param_name: *const gchar,
        owner_type: GType,
        walk_ancestors: gboolean,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_pool_list_owned(pool: *mut GParamSpecPool, owner_type: GType)
        -> *mut GList;
}
extern "C" {
    pub fn g_param_spec_pool_list(
        pool: *mut GParamSpecPool,
        owner_type: GType,
        n_pspecs_p: *mut guint,
    ) -> *mut *mut GParamSpec;
}
pub type GClosure = _GClosure;
pub type GClosureNotifyData = _GClosureNotifyData;
pub type GCallback = ::std::option::Option<unsafe extern "C" fn()>;
pub type GClosureNotify =
    ::std::option::Option<unsafe extern "C" fn(data: gpointer, closure: *mut GClosure)>;
pub type GClosureMarshal = ::std::option::Option<
    unsafe extern "C" fn(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    ),
>;
pub type GVaClosureMarshal = ::std::option::Option<
    unsafe extern "C" fn(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    ),
>;
pub type GCClosure = _GCClosure;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GClosureNotifyData {
    pub data: gpointer,
    pub notify: GClosureNotify,
}
#[test]
fn bindgen_test_layout__GClosureNotifyData() {
    assert_eq!(
        ::std::mem::size_of::<_GClosureNotifyData>(),
        16usize,
        concat!("Size of: ", stringify!(_GClosureNotifyData))
    );
    assert_eq!(
        ::std::mem::align_of::<_GClosureNotifyData>(),
        8usize,
        concat!("Alignment of ", stringify!(_GClosureNotifyData))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GClosureNotifyData>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GClosureNotifyData),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GClosureNotifyData>())).notify as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GClosureNotifyData),
            "::",
            stringify!(notify)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GClosure {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u16>,
    pub marshal: ::std::option::Option<
        unsafe extern "C" fn(
            closure: *mut GClosure,
            return_value: *mut GValue,
            n_param_values: guint,
            param_values: *const GValue,
            invocation_hint: gpointer,
            marshal_data: gpointer,
        ),
    >,
    pub data: gpointer,
    pub notifiers: *mut GClosureNotifyData,
}
#[test]
fn bindgen_test_layout__GClosure() {
    assert_eq!(
        ::std::mem::size_of::<_GClosure>(),
        32usize,
        concat!("Size of: ", stringify!(_GClosure))
    );
    assert_eq!(
        ::std::mem::align_of::<_GClosure>(),
        8usize,
        concat!("Alignment of ", stringify!(_GClosure))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GClosure>())).marshal as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GClosure),
            "::",
            stringify!(marshal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GClosure>())).data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GClosure),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GClosure>())).notifiers as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GClosure),
            "::",
            stringify!(notifiers)
        )
    );
}
impl _GClosure {
    #[inline]
    pub fn ref_count(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_ref_count(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn meta_marshal_nouse(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_meta_marshal_nouse(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn n_guards(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_n_guards(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn n_fnotifiers(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_n_fnotifiers(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn n_inotifiers(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_n_inotifiers(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn in_inotify(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_in_inotify(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn floating(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_floating(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn derivative_flag(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_derivative_flag(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn in_marshal(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_in_marshal(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_invalid(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_invalid(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ref_count: guint,
        meta_marshal_nouse: guint,
        n_guards: guint,
        n_fnotifiers: guint,
        n_inotifiers: guint,
        in_inotify: guint,
        floating: guint,
        derivative_flag: guint,
        in_marshal: guint,
        is_invalid: guint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u16> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u16> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 15u8, {
            let ref_count: u32 = unsafe { ::std::mem::transmute(ref_count) };
            ref_count as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let meta_marshal_nouse: u32 = unsafe { ::std::mem::transmute(meta_marshal_nouse) };
            meta_marshal_nouse as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let n_guards: u32 = unsafe { ::std::mem::transmute(n_guards) };
            n_guards as u64
        });
        __bindgen_bitfield_unit.set(17usize, 2u8, {
            let n_fnotifiers: u32 = unsafe { ::std::mem::transmute(n_fnotifiers) };
            n_fnotifiers as u64
        });
        __bindgen_bitfield_unit.set(19usize, 8u8, {
            let n_inotifiers: u32 = unsafe { ::std::mem::transmute(n_inotifiers) };
            n_inotifiers as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let in_inotify: u32 = unsafe { ::std::mem::transmute(in_inotify) };
            in_inotify as u64
        });
        __bindgen_bitfield_unit.set(28usize, 1u8, {
            let floating: u32 = unsafe { ::std::mem::transmute(floating) };
            floating as u64
        });
        __bindgen_bitfield_unit.set(29usize, 1u8, {
            let derivative_flag: u32 = unsafe { ::std::mem::transmute(derivative_flag) };
            derivative_flag as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let in_marshal: u32 = unsafe { ::std::mem::transmute(in_marshal) };
            in_marshal as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let is_invalid: u32 = unsafe { ::std::mem::transmute(is_invalid) };
            is_invalid as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GCClosure {
    pub closure: GClosure,
    pub callback: gpointer,
}
#[test]
fn bindgen_test_layout__GCClosure() {
    assert_eq!(
        ::std::mem::size_of::<_GCClosure>(),
        40usize,
        concat!("Size of: ", stringify!(_GCClosure))
    );
    assert_eq!(
        ::std::mem::align_of::<_GCClosure>(),
        8usize,
        concat!("Alignment of ", stringify!(_GCClosure))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCClosure>())).closure as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCClosure),
            "::",
            stringify!(closure)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCClosure>())).callback as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCClosure),
            "::",
            stringify!(callback)
        )
    );
}
extern "C" {
    pub fn g_cclosure_new(
        callback_func: GCallback,
        user_data: gpointer,
        destroy_data: GClosureNotify,
    ) -> *mut GClosure;
}
extern "C" {
    pub fn g_cclosure_new_swap(
        callback_func: GCallback,
        user_data: gpointer,
        destroy_data: GClosureNotify,
    ) -> *mut GClosure;
}
extern "C" {
    pub fn g_signal_type_cclosure_new(itype: GType, struct_offset: guint) -> *mut GClosure;
}
extern "C" {
    pub fn g_closure_ref(closure: *mut GClosure) -> *mut GClosure;
}
extern "C" {
    pub fn g_closure_sink(closure: *mut GClosure);
}
extern "C" {
    pub fn g_closure_unref(closure: *mut GClosure);
}
extern "C" {
    pub fn g_closure_new_simple(sizeof_closure: guint, data: gpointer) -> *mut GClosure;
}
extern "C" {
    pub fn g_closure_add_finalize_notifier(
        closure: *mut GClosure,
        notify_data: gpointer,
        notify_func: GClosureNotify,
    );
}
extern "C" {
    pub fn g_closure_remove_finalize_notifier(
        closure: *mut GClosure,
        notify_data: gpointer,
        notify_func: GClosureNotify,
    );
}
extern "C" {
    pub fn g_closure_add_invalidate_notifier(
        closure: *mut GClosure,
        notify_data: gpointer,
        notify_func: GClosureNotify,
    );
}
extern "C" {
    pub fn g_closure_remove_invalidate_notifier(
        closure: *mut GClosure,
        notify_data: gpointer,
        notify_func: GClosureNotify,
    );
}
extern "C" {
    pub fn g_closure_add_marshal_guards(
        closure: *mut GClosure,
        pre_marshal_data: gpointer,
        pre_marshal_notify: GClosureNotify,
        post_marshal_data: gpointer,
        post_marshal_notify: GClosureNotify,
    );
}
extern "C" {
    pub fn g_closure_set_marshal(closure: *mut GClosure, marshal: GClosureMarshal);
}
extern "C" {
    pub fn g_closure_set_meta_marshal(
        closure: *mut GClosure,
        marshal_data: gpointer,
        meta_marshal: GClosureMarshal,
    );
}
extern "C" {
    pub fn g_closure_invalidate(closure: *mut GClosure);
}
extern "C" {
    pub fn g_closure_invoke(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_generic(
        closure: *mut GClosure,
        return_gvalue: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_generic_va(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args_list: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__VOID(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__VOIDv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__BOOLEAN(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__BOOLEANv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__CHAR(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__CHARv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__UCHAR(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__UCHARv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__INT(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__INTv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__UINT(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__UINTv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__LONG(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__LONGv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__ULONG(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__ULONGv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__ENUM(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__ENUMv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__FLAGS(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__FLAGSv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__FLOAT(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__FLOATv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__DOUBLE(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__DOUBLEv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__STRING(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__STRINGv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__PARAM(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__PARAMv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__BOXED(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__BOXEDv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__POINTER(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__POINTERv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__OBJECT(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__OBJECTv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__VARIANT(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__VARIANTv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__UINT_POINTER(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_VOID__UINT_POINTERv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_BOOLEAN__FLAGS(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_BOOLEAN__FLAGSv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_STRING__OBJECT_POINTER(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_STRING__OBJECT_POINTERv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_BOOLEAN__BOXED_BOXED(
        closure: *mut GClosure,
        return_value: *mut GValue,
        n_param_values: guint,
        param_values: *const GValue,
        invocation_hint: gpointer,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_cclosure_marshal_BOOLEAN__BOXED_BOXEDv(
        closure: *mut GClosure,
        return_value: *mut GValue,
        instance: gpointer,
        args: *mut __va_list_tag,
        marshal_data: gpointer,
        n_params: ::std::os::raw::c_int,
        param_types: *mut GType,
    );
}
pub type GSignalQuery = _GSignalQuery;
pub type GSignalInvocationHint = _GSignalInvocationHint;
pub type GSignalCMarshaller = GClosureMarshal;
pub type GSignalCVaMarshaller = GVaClosureMarshal;
pub type GSignalEmissionHook = ::std::option::Option<
    unsafe extern "C" fn(
        ihint: *mut GSignalInvocationHint,
        n_param_values: guint,
        param_values: *const GValue,
        data: gpointer,
    ) -> gboolean,
>;
pub type GSignalAccumulator = ::std::option::Option<
    unsafe extern "C" fn(
        ihint: *mut GSignalInvocationHint,
        return_accu: *mut GValue,
        handler_return: *const GValue,
        data: gpointer,
    ) -> gboolean,
>;
pub const GSignalFlags_G_SIGNAL_RUN_FIRST: GSignalFlags = 1;
pub const GSignalFlags_G_SIGNAL_RUN_LAST: GSignalFlags = 2;
pub const GSignalFlags_G_SIGNAL_RUN_CLEANUP: GSignalFlags = 4;
pub const GSignalFlags_G_SIGNAL_NO_RECURSE: GSignalFlags = 8;
pub const GSignalFlags_G_SIGNAL_DETAILED: GSignalFlags = 16;
pub const GSignalFlags_G_SIGNAL_ACTION: GSignalFlags = 32;
pub const GSignalFlags_G_SIGNAL_NO_HOOKS: GSignalFlags = 64;
pub const GSignalFlags_G_SIGNAL_MUST_COLLECT: GSignalFlags = 128;
pub const GSignalFlags_G_SIGNAL_DEPRECATED: GSignalFlags = 256;
pub type GSignalFlags = u32;
pub const GConnectFlags_G_CONNECT_AFTER: GConnectFlags = 1;
pub const GConnectFlags_G_CONNECT_SWAPPED: GConnectFlags = 2;
pub type GConnectFlags = u32;
pub const GSignalMatchType_G_SIGNAL_MATCH_ID: GSignalMatchType = 1;
pub const GSignalMatchType_G_SIGNAL_MATCH_DETAIL: GSignalMatchType = 2;
pub const GSignalMatchType_G_SIGNAL_MATCH_CLOSURE: GSignalMatchType = 4;
pub const GSignalMatchType_G_SIGNAL_MATCH_FUNC: GSignalMatchType = 8;
pub const GSignalMatchType_G_SIGNAL_MATCH_DATA: GSignalMatchType = 16;
pub const GSignalMatchType_G_SIGNAL_MATCH_UNBLOCKED: GSignalMatchType = 32;
pub type GSignalMatchType = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GSignalInvocationHint {
    pub signal_id: guint,
    pub detail: GQuark,
    pub run_type: GSignalFlags,
}
#[test]
fn bindgen_test_layout__GSignalInvocationHint() {
    assert_eq!(
        ::std::mem::size_of::<_GSignalInvocationHint>(),
        12usize,
        concat!("Size of: ", stringify!(_GSignalInvocationHint))
    );
    assert_eq!(
        ::std::mem::align_of::<_GSignalInvocationHint>(),
        4usize,
        concat!("Alignment of ", stringify!(_GSignalInvocationHint))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GSignalInvocationHint>())).signal_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSignalInvocationHint),
            "::",
            stringify!(signal_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSignalInvocationHint>())).detail as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSignalInvocationHint),
            "::",
            stringify!(detail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSignalInvocationHint>())).run_type as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSignalInvocationHint),
            "::",
            stringify!(run_type)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GSignalQuery {
    pub signal_id: guint,
    pub signal_name: *const gchar,
    pub itype: GType,
    pub signal_flags: GSignalFlags,
    pub return_type: GType,
    pub n_params: guint,
    pub param_types: *const GType,
}
#[test]
fn bindgen_test_layout__GSignalQuery() {
    assert_eq!(
        ::std::mem::size_of::<_GSignalQuery>(),
        56usize,
        concat!("Size of: ", stringify!(_GSignalQuery))
    );
    assert_eq!(
        ::std::mem::align_of::<_GSignalQuery>(),
        8usize,
        concat!("Alignment of ", stringify!(_GSignalQuery))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSignalQuery>())).signal_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSignalQuery),
            "::",
            stringify!(signal_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSignalQuery>())).signal_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSignalQuery),
            "::",
            stringify!(signal_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSignalQuery>())).itype as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSignalQuery),
            "::",
            stringify!(itype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSignalQuery>())).signal_flags as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSignalQuery),
            "::",
            stringify!(signal_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSignalQuery>())).return_type as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSignalQuery),
            "::",
            stringify!(return_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSignalQuery>())).n_params as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSignalQuery),
            "::",
            stringify!(n_params)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GSignalQuery>())).param_types as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSignalQuery),
            "::",
            stringify!(param_types)
        )
    );
}
extern "C" {
    pub fn g_signal_newv(
        signal_name: *const gchar,
        itype: GType,
        signal_flags: GSignalFlags,
        class_closure: *mut GClosure,
        accumulator: GSignalAccumulator,
        accu_data: gpointer,
        c_marshaller: GSignalCMarshaller,
        return_type: GType,
        n_params: guint,
        param_types: *mut GType,
    ) -> guint;
}
extern "C" {
    pub fn g_signal_new_valist(
        signal_name: *const gchar,
        itype: GType,
        signal_flags: GSignalFlags,
        class_closure: *mut GClosure,
        accumulator: GSignalAccumulator,
        accu_data: gpointer,
        c_marshaller: GSignalCMarshaller,
        return_type: GType,
        n_params: guint,
        args: *mut __va_list_tag,
    ) -> guint;
}
extern "C" {
    pub fn g_signal_new(
        signal_name: *const gchar,
        itype: GType,
        signal_flags: GSignalFlags,
        class_offset: guint,
        accumulator: GSignalAccumulator,
        accu_data: gpointer,
        c_marshaller: GSignalCMarshaller,
        return_type: GType,
        n_params: guint,
        ...
    ) -> guint;
}
extern "C" {
    pub fn g_signal_new_class_handler(
        signal_name: *const gchar,
        itype: GType,
        signal_flags: GSignalFlags,
        class_handler: GCallback,
        accumulator: GSignalAccumulator,
        accu_data: gpointer,
        c_marshaller: GSignalCMarshaller,
        return_type: GType,
        n_params: guint,
        ...
    ) -> guint;
}
extern "C" {
    pub fn g_signal_set_va_marshaller(
        signal_id: guint,
        instance_type: GType,
        va_marshaller: GSignalCVaMarshaller,
    );
}
extern "C" {
    pub fn g_signal_emitv(
        instance_and_params: *const GValue,
        signal_id: guint,
        detail: GQuark,
        return_value: *mut GValue,
    );
}
extern "C" {
    pub fn g_signal_emit_valist(
        instance: gpointer,
        signal_id: guint,
        detail: GQuark,
        var_args: *mut __va_list_tag,
    );
}
extern "C" {
    pub fn g_signal_emit(instance: gpointer, signal_id: guint, detail: GQuark, ...);
}
extern "C" {
    pub fn g_signal_emit_by_name(instance: gpointer, detailed_signal: *const gchar, ...);
}
extern "C" {
    pub fn g_signal_lookup(name: *const gchar, itype: GType) -> guint;
}
extern "C" {
    pub fn g_signal_name(signal_id: guint) -> *const gchar;
}
extern "C" {
    pub fn g_signal_query(signal_id: guint, query: *mut GSignalQuery);
}
extern "C" {
    pub fn g_signal_list_ids(itype: GType, n_ids: *mut guint) -> *mut guint;
}
extern "C" {
    pub fn g_signal_parse_name(
        detailed_signal: *const gchar,
        itype: GType,
        signal_id_p: *mut guint,
        detail_p: *mut GQuark,
        force_detail_quark: gboolean,
    ) -> gboolean;
}
extern "C" {
    pub fn g_signal_get_invocation_hint(instance: gpointer) -> *mut GSignalInvocationHint;
}
extern "C" {
    pub fn g_signal_stop_emission(instance: gpointer, signal_id: guint, detail: GQuark);
}
extern "C" {
    pub fn g_signal_stop_emission_by_name(instance: gpointer, detailed_signal: *const gchar);
}
extern "C" {
    pub fn g_signal_add_emission_hook(
        signal_id: guint,
        detail: GQuark,
        hook_func: GSignalEmissionHook,
        hook_data: gpointer,
        data_destroy: GDestroyNotify,
    ) -> gulong;
}
extern "C" {
    pub fn g_signal_remove_emission_hook(signal_id: guint, hook_id: gulong);
}
extern "C" {
    pub fn g_signal_has_handler_pending(
        instance: gpointer,
        signal_id: guint,
        detail: GQuark,
        may_be_blocked: gboolean,
    ) -> gboolean;
}
extern "C" {
    pub fn g_signal_connect_closure_by_id(
        instance: gpointer,
        signal_id: guint,
        detail: GQuark,
        closure: *mut GClosure,
        after: gboolean,
    ) -> gulong;
}
extern "C" {
    pub fn g_signal_connect_closure(
        instance: gpointer,
        detailed_signal: *const gchar,
        closure: *mut GClosure,
        after: gboolean,
    ) -> gulong;
}
extern "C" {
    pub fn g_signal_connect_data(
        instance: gpointer,
        detailed_signal: *const gchar,
        c_handler: GCallback,
        data: gpointer,
        destroy_data: GClosureNotify,
        connect_flags: GConnectFlags,
    ) -> gulong;
}
extern "C" {
    pub fn g_signal_handler_block(instance: gpointer, handler_id: gulong);
}
extern "C" {
    pub fn g_signal_handler_unblock(instance: gpointer, handler_id: gulong);
}
extern "C" {
    pub fn g_signal_handler_disconnect(instance: gpointer, handler_id: gulong);
}
extern "C" {
    pub fn g_signal_handler_is_connected(instance: gpointer, handler_id: gulong) -> gboolean;
}
extern "C" {
    pub fn g_signal_handler_find(
        instance: gpointer,
        mask: GSignalMatchType,
        signal_id: guint,
        detail: GQuark,
        closure: *mut GClosure,
        func: gpointer,
        data: gpointer,
    ) -> gulong;
}
extern "C" {
    pub fn g_signal_handlers_block_matched(
        instance: gpointer,
        mask: GSignalMatchType,
        signal_id: guint,
        detail: GQuark,
        closure: *mut GClosure,
        func: gpointer,
        data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_signal_handlers_unblock_matched(
        instance: gpointer,
        mask: GSignalMatchType,
        signal_id: guint,
        detail: GQuark,
        closure: *mut GClosure,
        func: gpointer,
        data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_signal_handlers_disconnect_matched(
        instance: gpointer,
        mask: GSignalMatchType,
        signal_id: guint,
        detail: GQuark,
        closure: *mut GClosure,
        func: gpointer,
        data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_clear_signal_handler(handler_id_ptr: *mut gulong, instance: gpointer);
}
extern "C" {
    pub fn g_signal_override_class_closure(
        signal_id: guint,
        instance_type: GType,
        class_closure: *mut GClosure,
    );
}
extern "C" {
    pub fn g_signal_override_class_handler(
        signal_name: *const gchar,
        instance_type: GType,
        class_handler: GCallback,
    );
}
extern "C" {
    pub fn g_signal_chain_from_overridden(
        instance_and_params: *const GValue,
        return_value: *mut GValue,
    );
}
extern "C" {
    pub fn g_signal_chain_from_overridden_handler(instance: gpointer, ...);
}
extern "C" {
    pub fn g_signal_accumulator_true_handled(
        ihint: *mut GSignalInvocationHint,
        return_accu: *mut GValue,
        handler_return: *const GValue,
        dummy: gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_signal_accumulator_first_wins(
        ihint: *mut GSignalInvocationHint,
        return_accu: *mut GValue,
        handler_return: *const GValue,
        dummy: gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_signal_handlers_destroy(instance: gpointer);
}
extern "C" {
    pub fn _g_signals_destroy(itype: GType);
}
extern "C" {
    pub fn g_date_get_type() -> GType;
}
extern "C" {
    pub fn g_strv_get_type() -> GType;
}
extern "C" {
    pub fn g_gstring_get_type() -> GType;
}
extern "C" {
    pub fn g_hash_table_get_type() -> GType;
}
extern "C" {
    pub fn g_array_get_type() -> GType;
}
extern "C" {
    pub fn g_byte_array_get_type() -> GType;
}
extern "C" {
    pub fn g_ptr_array_get_type() -> GType;
}
extern "C" {
    pub fn g_bytes_get_type() -> GType;
}
extern "C" {
    pub fn g_variant_type_get_gtype() -> GType;
}
extern "C" {
    pub fn g_regex_get_type() -> GType;
}
extern "C" {
    pub fn g_match_info_get_type() -> GType;
}
extern "C" {
    pub fn g_error_get_type() -> GType;
}
extern "C" {
    pub fn g_date_time_get_type() -> GType;
}
extern "C" {
    pub fn g_time_zone_get_type() -> GType;
}
extern "C" {
    pub fn g_io_channel_get_type() -> GType;
}
extern "C" {
    pub fn g_io_condition_get_type() -> GType;
}
extern "C" {
    pub fn g_variant_builder_get_type() -> GType;
}
extern "C" {
    pub fn g_variant_dict_get_type() -> GType;
}
extern "C" {
    pub fn g_key_file_get_type() -> GType;
}
extern "C" {
    pub fn g_main_loop_get_type() -> GType;
}
extern "C" {
    pub fn g_main_context_get_type() -> GType;
}
extern "C" {
    pub fn g_source_get_type() -> GType;
}
extern "C" {
    pub fn g_pollfd_get_type() -> GType;
}
extern "C" {
    pub fn g_thread_get_type() -> GType;
}
extern "C" {
    pub fn g_checksum_get_type() -> GType;
}
extern "C" {
    pub fn g_markup_parse_context_get_type() -> GType;
}
extern "C" {
    pub fn g_mapped_file_get_type() -> GType;
}
extern "C" {
    pub fn g_option_group_get_type() -> GType;
}
extern "C" {
    pub fn g_variant_get_gtype() -> GType;
}
pub type GBoxedCopyFunc = ::std::option::Option<unsafe extern "C" fn(boxed: gpointer) -> gpointer>;
pub type GBoxedFreeFunc = ::std::option::Option<unsafe extern "C" fn(boxed: gpointer)>;
extern "C" {
    pub fn g_boxed_copy(boxed_type: GType, src_boxed: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_boxed_free(boxed_type: GType, boxed: gpointer);
}
extern "C" {
    pub fn g_value_set_boxed(value: *mut GValue, v_boxed: gconstpointer);
}
extern "C" {
    pub fn g_value_set_static_boxed(value: *mut GValue, v_boxed: gconstpointer);
}
extern "C" {
    pub fn g_value_take_boxed(value: *mut GValue, v_boxed: gconstpointer);
}
extern "C" {
    pub fn g_value_set_boxed_take_ownership(value: *mut GValue, v_boxed: gconstpointer);
}
extern "C" {
    pub fn g_value_get_boxed(value: *const GValue) -> gpointer;
}
extern "C" {
    pub fn g_value_dup_boxed(value: *const GValue) -> gpointer;
}
extern "C" {
    pub fn g_boxed_type_register_static(
        name: *const gchar,
        boxed_copy: GBoxedCopyFunc,
        boxed_free: GBoxedFreeFunc,
    ) -> GType;
}
extern "C" {
    pub fn g_closure_get_type() -> GType;
}
extern "C" {
    pub fn g_value_get_type() -> GType;
}
pub type GObject = _GObject;
pub type GObjectClass = _GObjectClass;
pub type GInitiallyUnowned = _GObject;
pub type GInitiallyUnownedClass = _GObjectClass;
pub type GObjectConstructParam = _GObjectConstructParam;
pub type GObjectGetPropertyFunc = ::std::option::Option<
    unsafe extern "C" fn(
        object: *mut GObject,
        property_id: guint,
        value: *mut GValue,
        pspec: *mut GParamSpec,
    ),
>;
pub type GObjectSetPropertyFunc = ::std::option::Option<
    unsafe extern "C" fn(
        object: *mut GObject,
        property_id: guint,
        value: *const GValue,
        pspec: *mut GParamSpec,
    ),
>;
pub type GObjectFinalizeFunc = ::std::option::Option<unsafe extern "C" fn(object: *mut GObject)>;
pub type GWeakNotify =
    ::std::option::Option<unsafe extern "C" fn(data: gpointer, where_the_object_was: *mut GObject)>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GObject {
    pub g_type_instance: GTypeInstance,
    pub ref_count: guint,
    pub qdata: *mut GData,
}
#[test]
fn bindgen_test_layout__GObject() {
    assert_eq!(
        ::std::mem::size_of::<_GObject>(),
        24usize,
        concat!("Size of: ", stringify!(_GObject))
    );
    assert_eq!(
        ::std::mem::align_of::<_GObject>(),
        8usize,
        concat!("Alignment of ", stringify!(_GObject))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObject>())).g_type_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObject),
            "::",
            stringify!(g_type_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObject>())).ref_count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObject),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObject>())).qdata as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObject),
            "::",
            stringify!(qdata)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GObjectClass {
    pub g_type_class: GTypeClass,
    pub construct_properties: *mut GSList,
    pub constructor: ::std::option::Option<
        unsafe extern "C" fn(
            type_: GType,
            n_construct_properties: guint,
            construct_properties: *mut GObjectConstructParam,
        ) -> *mut GObject,
    >,
    pub set_property: ::std::option::Option<
        unsafe extern "C" fn(
            object: *mut GObject,
            property_id: guint,
            value: *const GValue,
            pspec: *mut GParamSpec,
        ),
    >,
    pub get_property: ::std::option::Option<
        unsafe extern "C" fn(
            object: *mut GObject,
            property_id: guint,
            value: *mut GValue,
            pspec: *mut GParamSpec,
        ),
    >,
    pub dispose: ::std::option::Option<unsafe extern "C" fn(object: *mut GObject)>,
    pub finalize: ::std::option::Option<unsafe extern "C" fn(object: *mut GObject)>,
    pub dispatch_properties_changed: ::std::option::Option<
        unsafe extern "C" fn(object: *mut GObject, n_pspecs: guint, pspecs: *mut *mut GParamSpec),
    >,
    pub notify:
        ::std::option::Option<unsafe extern "C" fn(object: *mut GObject, pspec: *mut GParamSpec)>,
    pub constructed: ::std::option::Option<unsafe extern "C" fn(object: *mut GObject)>,
    pub flags: gsize,
    pub pdummy: [gpointer; 6usize],
}
#[test]
fn bindgen_test_layout__GObjectClass() {
    assert_eq!(
        ::std::mem::size_of::<_GObjectClass>(),
        136usize,
        concat!("Size of: ", stringify!(_GObjectClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GObjectClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GObjectClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectClass>())).g_type_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(g_type_class)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GObjectClass>())).construct_properties as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(construct_properties)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectClass>())).constructor as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(constructor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectClass>())).set_property as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(set_property)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectClass>())).get_property as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(get_property)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectClass>())).dispose as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(dispose)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectClass>())).finalize as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(finalize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GObjectClass>())).dispatch_properties_changed as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(dispatch_properties_changed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectClass>())).notify as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectClass>())).constructed as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(constructed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectClass>())).flags as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectClass>())).pdummy as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectClass),
            "::",
            stringify!(pdummy)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GObjectConstructParam {
    pub pspec: *mut GParamSpec,
    pub value: *mut GValue,
}
#[test]
fn bindgen_test_layout__GObjectConstructParam() {
    assert_eq!(
        ::std::mem::size_of::<_GObjectConstructParam>(),
        16usize,
        concat!("Size of: ", stringify!(_GObjectConstructParam))
    );
    assert_eq!(
        ::std::mem::align_of::<_GObjectConstructParam>(),
        8usize,
        concat!("Alignment of ", stringify!(_GObjectConstructParam))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectConstructParam>())).pspec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectConstructParam),
            "::",
            stringify!(pspec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GObjectConstructParam>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GObjectConstructParam),
            "::",
            stringify!(value)
        )
    );
}
extern "C" {
    pub fn g_initially_unowned_get_type() -> GType;
}
extern "C" {
    pub fn g_object_class_install_property(
        oclass: *mut GObjectClass,
        property_id: guint,
        pspec: *mut GParamSpec,
    );
}
extern "C" {
    pub fn g_object_class_find_property(
        oclass: *mut GObjectClass,
        property_name: *const gchar,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_object_class_list_properties(
        oclass: *mut GObjectClass,
        n_properties: *mut guint,
    ) -> *mut *mut GParamSpec;
}
extern "C" {
    pub fn g_object_class_override_property(
        oclass: *mut GObjectClass,
        property_id: guint,
        name: *const gchar,
    );
}
extern "C" {
    pub fn g_object_class_install_properties(
        oclass: *mut GObjectClass,
        n_pspecs: guint,
        pspecs: *mut *mut GParamSpec,
    );
}
extern "C" {
    pub fn g_object_interface_install_property(g_iface: gpointer, pspec: *mut GParamSpec);
}
extern "C" {
    pub fn g_object_interface_find_property(
        g_iface: gpointer,
        property_name: *const gchar,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_object_interface_list_properties(
        g_iface: gpointer,
        n_properties_p: *mut guint,
    ) -> *mut *mut GParamSpec;
}
extern "C" {
    pub fn g_object_get_type() -> GType;
}
extern "C" {
    pub fn g_object_new(object_type: GType, first_property_name: *const gchar, ...) -> gpointer;
}
extern "C" {
    pub fn g_object_new_with_properties(
        object_type: GType,
        n_properties: guint,
        names: *mut *const ::std::os::raw::c_char,
        values: *const GValue,
    ) -> *mut GObject;
}
extern "C" {
    pub fn g_object_newv(
        object_type: GType,
        n_parameters: guint,
        parameters: *mut GParameter,
    ) -> gpointer;
}
extern "C" {
    pub fn g_object_new_valist(
        object_type: GType,
        first_property_name: *const gchar,
        var_args: *mut __va_list_tag,
    ) -> *mut GObject;
}
extern "C" {
    pub fn g_object_set(object: gpointer, first_property_name: *const gchar, ...);
}
extern "C" {
    pub fn g_object_get(object: gpointer, first_property_name: *const gchar, ...);
}
extern "C" {
    pub fn g_object_connect(object: gpointer, signal_spec: *const gchar, ...) -> gpointer;
}
extern "C" {
    pub fn g_object_disconnect(object: gpointer, signal_spec: *const gchar, ...);
}
extern "C" {
    pub fn g_object_setv(
        object: *mut GObject,
        n_properties: guint,
        names: *mut *const gchar,
        values: *const GValue,
    );
}
extern "C" {
    pub fn g_object_set_valist(
        object: *mut GObject,
        first_property_name: *const gchar,
        var_args: *mut __va_list_tag,
    );
}
extern "C" {
    pub fn g_object_getv(
        object: *mut GObject,
        n_properties: guint,
        names: *mut *const gchar,
        values: *mut GValue,
    );
}
extern "C" {
    pub fn g_object_get_valist(
        object: *mut GObject,
        first_property_name: *const gchar,
        var_args: *mut __va_list_tag,
    );
}
extern "C" {
    pub fn g_object_set_property(
        object: *mut GObject,
        property_name: *const gchar,
        value: *const GValue,
    );
}
extern "C" {
    pub fn g_object_get_property(
        object: *mut GObject,
        property_name: *const gchar,
        value: *mut GValue,
    );
}
extern "C" {
    pub fn g_object_freeze_notify(object: *mut GObject);
}
extern "C" {
    pub fn g_object_notify(object: *mut GObject, property_name: *const gchar);
}
extern "C" {
    pub fn g_object_notify_by_pspec(object: *mut GObject, pspec: *mut GParamSpec);
}
extern "C" {
    pub fn g_object_thaw_notify(object: *mut GObject);
}
extern "C" {
    pub fn g_object_is_floating(object: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_object_ref_sink(object: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_object_ref(object: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_object_unref(object: gpointer);
}
extern "C" {
    pub fn g_object_weak_ref(object: *mut GObject, notify: GWeakNotify, data: gpointer);
}
extern "C" {
    pub fn g_object_weak_unref(object: *mut GObject, notify: GWeakNotify, data: gpointer);
}
extern "C" {
    pub fn g_object_add_weak_pointer(object: *mut GObject, weak_pointer_location: *mut gpointer);
}
extern "C" {
    pub fn g_object_remove_weak_pointer(object: *mut GObject, weak_pointer_location: *mut gpointer);
}
pub type GToggleNotify = ::std::option::Option<
    unsafe extern "C" fn(data: gpointer, object: *mut GObject, is_last_ref: gboolean),
>;
extern "C" {
    pub fn g_object_add_toggle_ref(object: *mut GObject, notify: GToggleNotify, data: gpointer);
}
extern "C" {
    pub fn g_object_remove_toggle_ref(object: *mut GObject, notify: GToggleNotify, data: gpointer);
}
extern "C" {
    pub fn g_object_get_qdata(object: *mut GObject, quark: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_object_set_qdata(object: *mut GObject, quark: GQuark, data: gpointer);
}
extern "C" {
    pub fn g_object_set_qdata_full(
        object: *mut GObject,
        quark: GQuark,
        data: gpointer,
        destroy: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_object_steal_qdata(object: *mut GObject, quark: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_object_dup_qdata(
        object: *mut GObject,
        quark: GQuark,
        dup_func: GDuplicateFunc,
        user_data: gpointer,
    ) -> gpointer;
}
extern "C" {
    pub fn g_object_replace_qdata(
        object: *mut GObject,
        quark: GQuark,
        oldval: gpointer,
        newval: gpointer,
        destroy: GDestroyNotify,
        old_destroy: *mut GDestroyNotify,
    ) -> gboolean;
}
extern "C" {
    pub fn g_object_get_data(object: *mut GObject, key: *const gchar) -> gpointer;
}
extern "C" {
    pub fn g_object_set_data(object: *mut GObject, key: *const gchar, data: gpointer);
}
extern "C" {
    pub fn g_object_set_data_full(
        object: *mut GObject,
        key: *const gchar,
        data: gpointer,
        destroy: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_object_steal_data(object: *mut GObject, key: *const gchar) -> gpointer;
}
extern "C" {
    pub fn g_object_dup_data(
        object: *mut GObject,
        key: *const gchar,
        dup_func: GDuplicateFunc,
        user_data: gpointer,
    ) -> gpointer;
}
extern "C" {
    pub fn g_object_replace_data(
        object: *mut GObject,
        key: *const gchar,
        oldval: gpointer,
        newval: gpointer,
        destroy: GDestroyNotify,
        old_destroy: *mut GDestroyNotify,
    ) -> gboolean;
}
extern "C" {
    pub fn g_object_watch_closure(object: *mut GObject, closure: *mut GClosure);
}
extern "C" {
    pub fn g_cclosure_new_object(callback_func: GCallback, object: *mut GObject) -> *mut GClosure;
}
extern "C" {
    pub fn g_cclosure_new_object_swap(
        callback_func: GCallback,
        object: *mut GObject,
    ) -> *mut GClosure;
}
extern "C" {
    pub fn g_closure_new_object(sizeof_closure: guint, object: *mut GObject) -> *mut GClosure;
}
extern "C" {
    pub fn g_value_set_object(value: *mut GValue, v_object: gpointer);
}
extern "C" {
    pub fn g_value_get_object(value: *const GValue) -> gpointer;
}
extern "C" {
    pub fn g_value_dup_object(value: *const GValue) -> gpointer;
}
extern "C" {
    pub fn g_signal_connect_object(
        instance: gpointer,
        detailed_signal: *const gchar,
        c_handler: GCallback,
        gobject: gpointer,
        connect_flags: GConnectFlags,
    ) -> gulong;
}
extern "C" {
    pub fn g_object_force_floating(object: *mut GObject);
}
extern "C" {
    pub fn g_object_run_dispose(object: *mut GObject);
}
extern "C" {
    pub fn g_value_take_object(value: *mut GValue, v_object: gpointer);
}
extern "C" {
    pub fn g_value_set_object_take_ownership(value: *mut GValue, v_object: gpointer);
}
extern "C" {
    pub fn g_object_compat_control(what: gsize, data: gpointer) -> gsize;
}
extern "C" {
    pub fn g_clear_object(object_ptr: *mut *mut GObject);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GWeakRef {
    pub priv_: GWeakRef__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union GWeakRef__bindgen_ty_1 {
    pub p: gpointer,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_GWeakRef__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<GWeakRef__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(GWeakRef__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<GWeakRef__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(GWeakRef__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GWeakRef__bindgen_ty_1>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GWeakRef__bindgen_ty_1),
            "::",
            stringify!(p)
        )
    );
}
impl ::std::fmt::Debug for GWeakRef__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "GWeakRef__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_GWeakRef() {
    assert_eq!(
        ::std::mem::size_of::<GWeakRef>(),
        8usize,
        concat!("Size of: ", stringify!(GWeakRef))
    );
    assert_eq!(
        ::std::mem::align_of::<GWeakRef>(),
        8usize,
        concat!("Alignment of ", stringify!(GWeakRef))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GWeakRef>())).priv_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GWeakRef),
            "::",
            stringify!(priv_)
        )
    );
}
impl ::std::fmt::Debug for GWeakRef {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "GWeakRef {{ priv: {:?} }}", self.priv_)
    }
}
extern "C" {
    pub fn g_weak_ref_init(weak_ref: *mut GWeakRef, object: gpointer);
}
extern "C" {
    pub fn g_weak_ref_clear(weak_ref: *mut GWeakRef);
}
extern "C" {
    pub fn g_weak_ref_get(weak_ref: *mut GWeakRef) -> gpointer;
}
extern "C" {
    pub fn g_weak_ref_set(weak_ref: *mut GWeakRef, object: gpointer);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GBinding {
    _unused: [u8; 0],
}
pub type GBinding = _GBinding;
pub type GBindingTransformFunc = ::std::option::Option<
    unsafe extern "C" fn(
        binding: *mut GBinding,
        from_value: *const GValue,
        to_value: *mut GValue,
        user_data: gpointer,
    ) -> gboolean,
>;
pub const GBindingFlags_G_BINDING_DEFAULT: GBindingFlags = 0;
pub const GBindingFlags_G_BINDING_BIDIRECTIONAL: GBindingFlags = 1;
pub const GBindingFlags_G_BINDING_SYNC_CREATE: GBindingFlags = 2;
pub const GBindingFlags_G_BINDING_INVERT_BOOLEAN: GBindingFlags = 4;
pub type GBindingFlags = u32;
extern "C" {
    pub fn g_binding_flags_get_type() -> GType;
}
extern "C" {
    pub fn g_binding_get_type() -> GType;
}
extern "C" {
    pub fn g_binding_get_flags(binding: *mut GBinding) -> GBindingFlags;
}
extern "C" {
    pub fn g_binding_get_source(binding: *mut GBinding) -> *mut GObject;
}
extern "C" {
    pub fn g_binding_get_target(binding: *mut GBinding) -> *mut GObject;
}
extern "C" {
    pub fn g_binding_get_source_property(binding: *mut GBinding) -> *const gchar;
}
extern "C" {
    pub fn g_binding_get_target_property(binding: *mut GBinding) -> *const gchar;
}
extern "C" {
    pub fn g_binding_unbind(binding: *mut GBinding);
}
extern "C" {
    pub fn g_object_bind_property(
        source: gpointer,
        source_property: *const gchar,
        target: gpointer,
        target_property: *const gchar,
        flags: GBindingFlags,
    ) -> *mut GBinding;
}
extern "C" {
    pub fn g_object_bind_property_full(
        source: gpointer,
        source_property: *const gchar,
        target: gpointer,
        target_property: *const gchar,
        flags: GBindingFlags,
        transform_to: GBindingTransformFunc,
        transform_from: GBindingTransformFunc,
        user_data: gpointer,
        notify: GDestroyNotify,
    ) -> *mut GBinding;
}
extern "C" {
    pub fn g_object_bind_property_with_closures(
        source: gpointer,
        source_property: *const gchar,
        target: gpointer,
        target_property: *const gchar,
        flags: GBindingFlags,
        transform_to: *mut GClosure,
        transform_from: *mut GClosure,
    ) -> *mut GBinding;
}
pub type GEnumClass = _GEnumClass;
pub type GFlagsClass = _GFlagsClass;
pub type GEnumValue = _GEnumValue;
pub type GFlagsValue = _GFlagsValue;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GEnumClass {
    pub g_type_class: GTypeClass,
    pub minimum: gint,
    pub maximum: gint,
    pub n_values: guint,
    pub values: *mut GEnumValue,
}
#[test]
fn bindgen_test_layout__GEnumClass() {
    assert_eq!(
        ::std::mem::size_of::<_GEnumClass>(),
        32usize,
        concat!("Size of: ", stringify!(_GEnumClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GEnumClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GEnumClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEnumClass>())).g_type_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEnumClass),
            "::",
            stringify!(g_type_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEnumClass>())).minimum as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEnumClass),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEnumClass>())).maximum as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEnumClass),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEnumClass>())).n_values as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEnumClass),
            "::",
            stringify!(n_values)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEnumClass>())).values as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEnumClass),
            "::",
            stringify!(values)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GFlagsClass {
    pub g_type_class: GTypeClass,
    pub mask: guint,
    pub n_values: guint,
    pub values: *mut GFlagsValue,
}
#[test]
fn bindgen_test_layout__GFlagsClass() {
    assert_eq!(
        ::std::mem::size_of::<_GFlagsClass>(),
        24usize,
        concat!("Size of: ", stringify!(_GFlagsClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GFlagsClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GFlagsClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GFlagsClass>())).g_type_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFlagsClass),
            "::",
            stringify!(g_type_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GFlagsClass>())).mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFlagsClass),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GFlagsClass>())).n_values as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFlagsClass),
            "::",
            stringify!(n_values)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GFlagsClass>())).values as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFlagsClass),
            "::",
            stringify!(values)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GEnumValue {
    pub value: gint,
    pub value_name: *const gchar,
    pub value_nick: *const gchar,
}
#[test]
fn bindgen_test_layout__GEnumValue() {
    assert_eq!(
        ::std::mem::size_of::<_GEnumValue>(),
        24usize,
        concat!("Size of: ", stringify!(_GEnumValue))
    );
    assert_eq!(
        ::std::mem::align_of::<_GEnumValue>(),
        8usize,
        concat!("Alignment of ", stringify!(_GEnumValue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEnumValue>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEnumValue),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEnumValue>())).value_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEnumValue),
            "::",
            stringify!(value_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEnumValue>())).value_nick as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEnumValue),
            "::",
            stringify!(value_nick)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GFlagsValue {
    pub value: guint,
    pub value_name: *const gchar,
    pub value_nick: *const gchar,
}
#[test]
fn bindgen_test_layout__GFlagsValue() {
    assert_eq!(
        ::std::mem::size_of::<_GFlagsValue>(),
        24usize,
        concat!("Size of: ", stringify!(_GFlagsValue))
    );
    assert_eq!(
        ::std::mem::align_of::<_GFlagsValue>(),
        8usize,
        concat!("Alignment of ", stringify!(_GFlagsValue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GFlagsValue>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFlagsValue),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GFlagsValue>())).value_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFlagsValue),
            "::",
            stringify!(value_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GFlagsValue>())).value_nick as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFlagsValue),
            "::",
            stringify!(value_nick)
        )
    );
}
extern "C" {
    pub fn g_enum_get_value(enum_class: *mut GEnumClass, value: gint) -> *mut GEnumValue;
}
extern "C" {
    pub fn g_enum_get_value_by_name(
        enum_class: *mut GEnumClass,
        name: *const gchar,
    ) -> *mut GEnumValue;
}
extern "C" {
    pub fn g_enum_get_value_by_nick(
        enum_class: *mut GEnumClass,
        nick: *const gchar,
    ) -> *mut GEnumValue;
}
extern "C" {
    pub fn g_flags_get_first_value(flags_class: *mut GFlagsClass, value: guint)
        -> *mut GFlagsValue;
}
extern "C" {
    pub fn g_flags_get_value_by_name(
        flags_class: *mut GFlagsClass,
        name: *const gchar,
    ) -> *mut GFlagsValue;
}
extern "C" {
    pub fn g_flags_get_value_by_nick(
        flags_class: *mut GFlagsClass,
        nick: *const gchar,
    ) -> *mut GFlagsValue;
}
extern "C" {
    pub fn g_enum_to_string(g_enum_type: GType, value: gint) -> *mut gchar;
}
extern "C" {
    pub fn g_flags_to_string(flags_type: GType, value: guint) -> *mut gchar;
}
extern "C" {
    pub fn g_value_set_enum(value: *mut GValue, v_enum: gint);
}
extern "C" {
    pub fn g_value_get_enum(value: *const GValue) -> gint;
}
extern "C" {
    pub fn g_value_set_flags(value: *mut GValue, v_flags: guint);
}
extern "C" {
    pub fn g_value_get_flags(value: *const GValue) -> guint;
}
extern "C" {
    pub fn g_enum_register_static(
        name: *const gchar,
        const_static_values: *const GEnumValue,
    ) -> GType;
}
extern "C" {
    pub fn g_flags_register_static(
        name: *const gchar,
        const_static_values: *const GFlagsValue,
    ) -> GType;
}
extern "C" {
    pub fn g_enum_complete_type_info(
        g_enum_type: GType,
        info: *mut GTypeInfo,
        const_values: *const GEnumValue,
    );
}
extern "C" {
    pub fn g_flags_complete_type_info(
        g_flags_type: GType,
        info: *mut GTypeInfo,
        const_values: *const GFlagsValue,
    );
}
extern "C" {
    pub fn g_unicode_type_get_type() -> GType;
}
extern "C" {
    pub fn g_unicode_break_type_get_type() -> GType;
}
extern "C" {
    pub fn g_unicode_script_get_type() -> GType;
}
extern "C" {
    pub fn g_normalize_mode_get_type() -> GType;
}
pub type GParamSpecChar = _GParamSpecChar;
pub type GParamSpecUChar = _GParamSpecUChar;
pub type GParamSpecBoolean = _GParamSpecBoolean;
pub type GParamSpecInt = _GParamSpecInt;
pub type GParamSpecUInt = _GParamSpecUInt;
pub type GParamSpecLong = _GParamSpecLong;
pub type GParamSpecULong = _GParamSpecULong;
pub type GParamSpecInt64 = _GParamSpecInt64;
pub type GParamSpecUInt64 = _GParamSpecUInt64;
pub type GParamSpecUnichar = _GParamSpecUnichar;
pub type GParamSpecEnum = _GParamSpecEnum;
pub type GParamSpecFlags = _GParamSpecFlags;
pub type GParamSpecFloat = _GParamSpecFloat;
pub type GParamSpecDouble = _GParamSpecDouble;
pub type GParamSpecString = _GParamSpecString;
pub type GParamSpecParam = _GParamSpecParam;
pub type GParamSpecBoxed = _GParamSpecBoxed;
pub type GParamSpecPointer = _GParamSpecPointer;
pub type GParamSpecValueArray = _GParamSpecValueArray;
pub type GParamSpecObject = _GParamSpecObject;
pub type GParamSpecOverride = _GParamSpecOverride;
pub type GParamSpecGType = _GParamSpecGType;
pub type GParamSpecVariant = _GParamSpecVariant;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecChar {
    pub parent_instance: GParamSpec,
    pub minimum: gint8,
    pub maximum: gint8,
    pub default_value: gint8,
}
#[test]
fn bindgen_test_layout__GParamSpecChar() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecChar>(),
        80usize,
        concat!("Size of: ", stringify!(_GParamSpecChar))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecChar>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecChar))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecChar>())).parent_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecChar),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecChar>())).minimum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecChar),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecChar>())).maximum as *const _ as usize },
        73usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecChar),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecChar>())).default_value as *const _ as usize },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecChar),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecUChar {
    pub parent_instance: GParamSpec,
    pub minimum: guint8,
    pub maximum: guint8,
    pub default_value: guint8,
}
#[test]
fn bindgen_test_layout__GParamSpecUChar() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecUChar>(),
        80usize,
        concat!("Size of: ", stringify!(_GParamSpecUChar))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecUChar>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecUChar))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecUChar>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUChar),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecUChar>())).minimum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUChar),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecUChar>())).maximum as *const _ as usize },
        73usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUChar),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecUChar>())).default_value as *const _ as usize },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUChar),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecBoolean {
    pub parent_instance: GParamSpec,
    pub default_value: gboolean,
}
#[test]
fn bindgen_test_layout__GParamSpecBoolean() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecBoolean>(),
        80usize,
        concat!("Size of: ", stringify!(_GParamSpecBoolean))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecBoolean>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecBoolean))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecBoolean>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecBoolean),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecBoolean>())).default_value as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecBoolean),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecInt {
    pub parent_instance: GParamSpec,
    pub minimum: gint,
    pub maximum: gint,
    pub default_value: gint,
}
#[test]
fn bindgen_test_layout__GParamSpecInt() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecInt>(),
        88usize,
        concat!("Size of: ", stringify!(_GParamSpecInt))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecInt>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecInt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecInt>())).parent_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecInt),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecInt>())).minimum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecInt),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecInt>())).maximum as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecInt),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecInt>())).default_value as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecInt),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecUInt {
    pub parent_instance: GParamSpec,
    pub minimum: guint,
    pub maximum: guint,
    pub default_value: guint,
}
#[test]
fn bindgen_test_layout__GParamSpecUInt() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecUInt>(),
        88usize,
        concat!("Size of: ", stringify!(_GParamSpecUInt))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecUInt>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecUInt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecUInt>())).parent_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUInt),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecUInt>())).minimum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUInt),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecUInt>())).maximum as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUInt),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecUInt>())).default_value as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUInt),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecLong {
    pub parent_instance: GParamSpec,
    pub minimum: glong,
    pub maximum: glong,
    pub default_value: glong,
}
#[test]
fn bindgen_test_layout__GParamSpecLong() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecLong>(),
        96usize,
        concat!("Size of: ", stringify!(_GParamSpecLong))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecLong>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecLong))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecLong>())).parent_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecLong),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecLong>())).minimum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecLong),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecLong>())).maximum as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecLong),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecLong>())).default_value as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecLong),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecULong {
    pub parent_instance: GParamSpec,
    pub minimum: gulong,
    pub maximum: gulong,
    pub default_value: gulong,
}
#[test]
fn bindgen_test_layout__GParamSpecULong() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecULong>(),
        96usize,
        concat!("Size of: ", stringify!(_GParamSpecULong))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecULong>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecULong))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecULong>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecULong),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecULong>())).minimum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecULong),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecULong>())).maximum as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecULong),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecULong>())).default_value as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecULong),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecInt64 {
    pub parent_instance: GParamSpec,
    pub minimum: gint64,
    pub maximum: gint64,
    pub default_value: gint64,
}
#[test]
fn bindgen_test_layout__GParamSpecInt64() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecInt64>(),
        96usize,
        concat!("Size of: ", stringify!(_GParamSpecInt64))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecInt64>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecInt64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecInt64>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecInt64),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecInt64>())).minimum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecInt64),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecInt64>())).maximum as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecInt64),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecInt64>())).default_value as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecInt64),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecUInt64 {
    pub parent_instance: GParamSpec,
    pub minimum: guint64,
    pub maximum: guint64,
    pub default_value: guint64,
}
#[test]
fn bindgen_test_layout__GParamSpecUInt64() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecUInt64>(),
        96usize,
        concat!("Size of: ", stringify!(_GParamSpecUInt64))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecUInt64>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecUInt64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecUInt64>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUInt64),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecUInt64>())).minimum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUInt64),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecUInt64>())).maximum as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUInt64),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecUInt64>())).default_value as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUInt64),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecUnichar {
    pub parent_instance: GParamSpec,
    pub default_value: gunichar,
}
#[test]
fn bindgen_test_layout__GParamSpecUnichar() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecUnichar>(),
        80usize,
        concat!("Size of: ", stringify!(_GParamSpecUnichar))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecUnichar>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecUnichar))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecUnichar>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUnichar),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecUnichar>())).default_value as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecUnichar),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecEnum {
    pub parent_instance: GParamSpec,
    pub enum_class: *mut GEnumClass,
    pub default_value: gint,
}
#[test]
fn bindgen_test_layout__GParamSpecEnum() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecEnum>(),
        88usize,
        concat!("Size of: ", stringify!(_GParamSpecEnum))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecEnum>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecEnum))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecEnum>())).parent_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecEnum),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecEnum>())).enum_class as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecEnum),
            "::",
            stringify!(enum_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecEnum>())).default_value as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecEnum),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecFlags {
    pub parent_instance: GParamSpec,
    pub flags_class: *mut GFlagsClass,
    pub default_value: guint,
}
#[test]
fn bindgen_test_layout__GParamSpecFlags() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecFlags>(),
        88usize,
        concat!("Size of: ", stringify!(_GParamSpecFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecFlags>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecFlags))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecFlags>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecFlags),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecFlags>())).flags_class as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecFlags),
            "::",
            stringify!(flags_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecFlags>())).default_value as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecFlags),
            "::",
            stringify!(default_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct _GParamSpecFloat {
    pub parent_instance: GParamSpec,
    pub minimum: gfloat,
    pub maximum: gfloat,
    pub default_value: gfloat,
    pub epsilon: gfloat,
}
#[test]
fn bindgen_test_layout__GParamSpecFloat() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecFloat>(),
        88usize,
        concat!("Size of: ", stringify!(_GParamSpecFloat))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecFloat>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecFloat))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecFloat>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecFloat),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecFloat>())).minimum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecFloat),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecFloat>())).maximum as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecFloat),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecFloat>())).default_value as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecFloat),
            "::",
            stringify!(default_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecFloat>())).epsilon as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecFloat),
            "::",
            stringify!(epsilon)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct _GParamSpecDouble {
    pub parent_instance: GParamSpec,
    pub minimum: gdouble,
    pub maximum: gdouble,
    pub default_value: gdouble,
    pub epsilon: gdouble,
}
#[test]
fn bindgen_test_layout__GParamSpecDouble() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecDouble>(),
        104usize,
        concat!("Size of: ", stringify!(_GParamSpecDouble))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecDouble>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecDouble))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecDouble>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecDouble),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecDouble>())).minimum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecDouble),
            "::",
            stringify!(minimum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecDouble>())).maximum as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecDouble),
            "::",
            stringify!(maximum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecDouble>())).default_value as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecDouble),
            "::",
            stringify!(default_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecDouble>())).epsilon as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecDouble),
            "::",
            stringify!(epsilon)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecString {
    pub parent_instance: GParamSpec,
    pub default_value: *mut gchar,
    pub cset_first: *mut gchar,
    pub cset_nth: *mut gchar,
    pub substitutor: gchar,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub __bindgen_padding_0: [u16; 3usize],
}
#[test]
fn bindgen_test_layout__GParamSpecString() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecString>(),
        104usize,
        concat!("Size of: ", stringify!(_GParamSpecString))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecString>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecString))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecString>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecString),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecString>())).default_value as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecString),
            "::",
            stringify!(default_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecString>())).cset_first as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecString),
            "::",
            stringify!(cset_first)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecString>())).cset_nth as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecString),
            "::",
            stringify!(cset_nth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecString>())).substitutor as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecString),
            "::",
            stringify!(substitutor)
        )
    );
}
impl _GParamSpecString {
    #[inline]
    pub fn null_fold_if_empty(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_null_fold_if_empty(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ensure_non_null(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ensure_non_null(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        null_fold_if_empty: guint,
        ensure_non_null: guint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let null_fold_if_empty: u32 = unsafe { ::std::mem::transmute(null_fold_if_empty) };
            null_fold_if_empty as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let ensure_non_null: u32 = unsafe { ::std::mem::transmute(ensure_non_null) };
            ensure_non_null as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecParam {
    pub parent_instance: GParamSpec,
}
#[test]
fn bindgen_test_layout__GParamSpecParam() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecParam>(),
        72usize,
        concat!("Size of: ", stringify!(_GParamSpecParam))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecParam>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecParam))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecParam>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecParam),
            "::",
            stringify!(parent_instance)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecBoxed {
    pub parent_instance: GParamSpec,
}
#[test]
fn bindgen_test_layout__GParamSpecBoxed() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecBoxed>(),
        72usize,
        concat!("Size of: ", stringify!(_GParamSpecBoxed))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecBoxed>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecBoxed))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecBoxed>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecBoxed),
            "::",
            stringify!(parent_instance)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecPointer {
    pub parent_instance: GParamSpec,
}
#[test]
fn bindgen_test_layout__GParamSpecPointer() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecPointer>(),
        72usize,
        concat!("Size of: ", stringify!(_GParamSpecPointer))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecPointer>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecPointer))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecPointer>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecPointer),
            "::",
            stringify!(parent_instance)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecValueArray {
    pub parent_instance: GParamSpec,
    pub element_spec: *mut GParamSpec,
    pub fixed_n_elements: guint,
}
#[test]
fn bindgen_test_layout__GParamSpecValueArray() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecValueArray>(),
        88usize,
        concat!("Size of: ", stringify!(_GParamSpecValueArray))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecValueArray>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecValueArray))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecValueArray>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecValueArray),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecValueArray>())).element_spec as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecValueArray),
            "::",
            stringify!(element_spec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecValueArray>())).fixed_n_elements as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecValueArray),
            "::",
            stringify!(fixed_n_elements)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecObject {
    pub parent_instance: GParamSpec,
}
#[test]
fn bindgen_test_layout__GParamSpecObject() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecObject>(),
        72usize,
        concat!("Size of: ", stringify!(_GParamSpecObject))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecObject>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecObject))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecObject>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecObject),
            "::",
            stringify!(parent_instance)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecOverride {
    pub parent_instance: GParamSpec,
    pub overridden: *mut GParamSpec,
}
#[test]
fn bindgen_test_layout__GParamSpecOverride() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecOverride>(),
        80usize,
        concat!("Size of: ", stringify!(_GParamSpecOverride))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecOverride>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecOverride))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecOverride>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecOverride),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecOverride>())).overridden as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecOverride),
            "::",
            stringify!(overridden)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecGType {
    pub parent_instance: GParamSpec,
    pub is_a_type: GType,
}
#[test]
fn bindgen_test_layout__GParamSpecGType() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecGType>(),
        80usize,
        concat!("Size of: ", stringify!(_GParamSpecGType))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecGType>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecGType))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecGType>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecGType),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecGType>())).is_a_type as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecGType),
            "::",
            stringify!(is_a_type)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GParamSpecVariant {
    pub parent_instance: GParamSpec,
    pub type_: *mut GVariantType,
    pub default_value: *mut GVariant,
    pub padding: [gpointer; 4usize],
}
#[test]
fn bindgen_test_layout__GParamSpecVariant() {
    assert_eq!(
        ::std::mem::size_of::<_GParamSpecVariant>(),
        120usize,
        concat!("Size of: ", stringify!(_GParamSpecVariant))
    );
    assert_eq!(
        ::std::mem::align_of::<_GParamSpecVariant>(),
        8usize,
        concat!("Alignment of ", stringify!(_GParamSpecVariant))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecVariant>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecVariant),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecVariant>())).type_ as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecVariant),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GParamSpecVariant>())).default_value as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecVariant),
            "::",
            stringify!(default_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GParamSpecVariant>())).padding as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GParamSpecVariant),
            "::",
            stringify!(padding)
        )
    );
}
extern "C" {
    pub fn g_param_spec_char(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        minimum: gint8,
        maximum: gint8,
        default_value: gint8,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_uchar(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        minimum: guint8,
        maximum: guint8,
        default_value: guint8,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_boolean(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        default_value: gboolean,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_int(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        minimum: gint,
        maximum: gint,
        default_value: gint,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_uint(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        minimum: guint,
        maximum: guint,
        default_value: guint,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_long(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        minimum: glong,
        maximum: glong,
        default_value: glong,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_ulong(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        minimum: gulong,
        maximum: gulong,
        default_value: gulong,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_int64(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        minimum: gint64,
        maximum: gint64,
        default_value: gint64,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_uint64(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        minimum: guint64,
        maximum: guint64,
        default_value: guint64,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_unichar(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        default_value: gunichar,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_enum(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        enum_type: GType,
        default_value: gint,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_flags(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        flags_type: GType,
        default_value: guint,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_float(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        minimum: gfloat,
        maximum: gfloat,
        default_value: gfloat,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_double(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        minimum: gdouble,
        maximum: gdouble,
        default_value: gdouble,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_string(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        default_value: *const gchar,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_param(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        param_type: GType,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_boxed(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        boxed_type: GType,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_pointer(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_value_array(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        element_spec: *mut GParamSpec,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_object(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        object_type: GType,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_override(
        name: *const gchar,
        overridden: *mut GParamSpec,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_gtype(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        is_a_type: GType,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub fn g_param_spec_variant(
        name: *const gchar,
        nick: *const gchar,
        blurb: *const gchar,
        type_: *const GVariantType,
        default_value: *mut GVariant,
        flags: GParamFlags,
    ) -> *mut GParamSpec;
}
extern "C" {
    pub static mut g_param_spec_types: *mut GType;
}
extern "C" {
    pub fn g_source_set_closure(source: *mut GSource, closure: *mut GClosure);
}
extern "C" {
    pub fn g_source_set_dummy_callback(source: *mut GSource);
}
pub type GTypeModule = _GTypeModule;
pub type GTypeModuleClass = _GTypeModuleClass;
pub type GTypeModule_autoptr = *mut GTypeModule;
pub type GTypeModule_listautoptr = *mut GList;
pub type GTypeModule_slistautoptr = *mut GSList;
pub type GTypeModule_queueautoptr = *mut GQueue;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTypeModule {
    pub parent_instance: GObject,
    pub use_count: guint,
    pub type_infos: *mut GSList,
    pub interface_infos: *mut GSList,
    pub name: *mut gchar,
}
#[test]
fn bindgen_test_layout__GTypeModule() {
    assert_eq!(
        ::std::mem::size_of::<_GTypeModule>(),
        56usize,
        concat!("Size of: ", stringify!(_GTypeModule))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTypeModule>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTypeModule))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModule>())).parent_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModule),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModule>())).use_count as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModule),
            "::",
            stringify!(use_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModule>())).type_infos as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModule),
            "::",
            stringify!(type_infos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModule>())).interface_infos as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModule),
            "::",
            stringify!(interface_infos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModule>())).name as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModule),
            "::",
            stringify!(name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTypeModuleClass {
    pub parent_class: GObjectClass,
    pub load: ::std::option::Option<unsafe extern "C" fn(module: *mut GTypeModule) -> gboolean>,
    pub unload: ::std::option::Option<unsafe extern "C" fn(module: *mut GTypeModule)>,
    pub reserved1: ::std::option::Option<unsafe extern "C" fn()>,
    pub reserved2: ::std::option::Option<unsafe extern "C" fn()>,
    pub reserved3: ::std::option::Option<unsafe extern "C" fn()>,
    pub reserved4: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GTypeModuleClass() {
    assert_eq!(
        ::std::mem::size_of::<_GTypeModuleClass>(),
        184usize,
        concat!("Size of: ", stringify!(_GTypeModuleClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTypeModuleClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTypeModuleClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModuleClass>())).parent_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModuleClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModuleClass>())).load as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModuleClass),
            "::",
            stringify!(load)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModuleClass>())).unload as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModuleClass),
            "::",
            stringify!(unload)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModuleClass>())).reserved1 as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModuleClass),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModuleClass>())).reserved2 as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModuleClass),
            "::",
            stringify!(reserved2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModuleClass>())).reserved3 as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModuleClass),
            "::",
            stringify!(reserved3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypeModuleClass>())).reserved4 as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypeModuleClass),
            "::",
            stringify!(reserved4)
        )
    );
}
extern "C" {
    pub fn g_type_module_get_type() -> GType;
}
extern "C" {
    pub fn g_type_module_use(module: *mut GTypeModule) -> gboolean;
}
extern "C" {
    pub fn g_type_module_unuse(module: *mut GTypeModule);
}
extern "C" {
    pub fn g_type_module_set_name(module: *mut GTypeModule, name: *const gchar);
}
extern "C" {
    pub fn g_type_module_register_type(
        module: *mut GTypeModule,
        parent_type: GType,
        type_name: *const gchar,
        type_info: *const GTypeInfo,
        flags: GTypeFlags,
    ) -> GType;
}
extern "C" {
    pub fn g_type_module_add_interface(
        module: *mut GTypeModule,
        instance_type: GType,
        interface_type: GType,
        interface_info: *const GInterfaceInfo,
    );
}
extern "C" {
    pub fn g_type_module_register_enum(
        module: *mut GTypeModule,
        name: *const gchar,
        const_static_values: *const GEnumValue,
    ) -> GType;
}
extern "C" {
    pub fn g_type_module_register_flags(
        module: *mut GTypeModule,
        name: *const gchar,
        const_static_values: *const GFlagsValue,
    ) -> GType;
}
pub type GTypePluginClass = _GTypePluginClass;
pub type GTypePluginUse = ::std::option::Option<unsafe extern "C" fn(plugin: *mut GTypePlugin)>;
pub type GTypePluginUnuse = ::std::option::Option<unsafe extern "C" fn(plugin: *mut GTypePlugin)>;
pub type GTypePluginCompleteTypeInfo = ::std::option::Option<
    unsafe extern "C" fn(
        plugin: *mut GTypePlugin,
        g_type: GType,
        info: *mut GTypeInfo,
        value_table: *mut GTypeValueTable,
    ),
>;
pub type GTypePluginCompleteInterfaceInfo = ::std::option::Option<
    unsafe extern "C" fn(
        plugin: *mut GTypePlugin,
        instance_type: GType,
        interface_type: GType,
        info: *mut GInterfaceInfo,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GTypePluginClass {
    pub base_iface: GTypeInterface,
    pub use_plugin: GTypePluginUse,
    pub unuse_plugin: GTypePluginUnuse,
    pub complete_type_info: GTypePluginCompleteTypeInfo,
    pub complete_interface_info: GTypePluginCompleteInterfaceInfo,
}
#[test]
fn bindgen_test_layout__GTypePluginClass() {
    assert_eq!(
        ::std::mem::size_of::<_GTypePluginClass>(),
        48usize,
        concat!("Size of: ", stringify!(_GTypePluginClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GTypePluginClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GTypePluginClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypePluginClass>())).base_iface as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypePluginClass),
            "::",
            stringify!(base_iface)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypePluginClass>())).use_plugin as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypePluginClass),
            "::",
            stringify!(use_plugin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GTypePluginClass>())).unuse_plugin as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypePluginClass),
            "::",
            stringify!(unuse_plugin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GTypePluginClass>())).complete_type_info as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypePluginClass),
            "::",
            stringify!(complete_type_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GTypePluginClass>())).complete_interface_info as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GTypePluginClass),
            "::",
            stringify!(complete_interface_info)
        )
    );
}
extern "C" {
    pub fn g_type_plugin_get_type() -> GType;
}
extern "C" {
    pub fn g_type_plugin_use(plugin: *mut GTypePlugin);
}
extern "C" {
    pub fn g_type_plugin_unuse(plugin: *mut GTypePlugin);
}
extern "C" {
    pub fn g_type_plugin_complete_type_info(
        plugin: *mut GTypePlugin,
        g_type: GType,
        info: *mut GTypeInfo,
        value_table: *mut GTypeValueTable,
    );
}
extern "C" {
    pub fn g_type_plugin_complete_interface_info(
        plugin: *mut GTypePlugin,
        instance_type: GType,
        interface_type: GType,
        info: *mut GInterfaceInfo,
    );
}
pub type GValueArray = _GValueArray;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GValueArray {
    pub n_values: guint,
    pub values: *mut GValue,
    pub n_prealloced: guint,
}
#[test]
fn bindgen_test_layout__GValueArray() {
    assert_eq!(
        ::std::mem::size_of::<_GValueArray>(),
        24usize,
        concat!("Size of: ", stringify!(_GValueArray))
    );
    assert_eq!(
        ::std::mem::align_of::<_GValueArray>(),
        8usize,
        concat!("Alignment of ", stringify!(_GValueArray))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValueArray>())).n_values as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValueArray),
            "::",
            stringify!(n_values)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValueArray>())).values as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValueArray),
            "::",
            stringify!(values)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GValueArray>())).n_prealloced as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GValueArray),
            "::",
            stringify!(n_prealloced)
        )
    );
}
extern "C" {
    pub fn g_value_array_get_type() -> GType;
}
extern "C" {
    pub fn g_value_array_get_nth(value_array: *mut GValueArray, index_: guint) -> *mut GValue;
}
extern "C" {
    pub fn g_value_array_new(n_prealloced: guint) -> *mut GValueArray;
}
extern "C" {
    pub fn g_value_array_free(value_array: *mut GValueArray);
}
extern "C" {
    pub fn g_value_array_copy(value_array: *const GValueArray) -> *mut GValueArray;
}
extern "C" {
    pub fn g_value_array_prepend(
        value_array: *mut GValueArray,
        value: *const GValue,
    ) -> *mut GValueArray;
}
extern "C" {
    pub fn g_value_array_append(
        value_array: *mut GValueArray,
        value: *const GValue,
    ) -> *mut GValueArray;
}
extern "C" {
    pub fn g_value_array_insert(
        value_array: *mut GValueArray,
        index_: guint,
        value: *const GValue,
    ) -> *mut GValueArray;
}
extern "C" {
    pub fn g_value_array_remove(value_array: *mut GValueArray, index_: guint) -> *mut GValueArray;
}
extern "C" {
    pub fn g_value_array_sort(
        value_array: *mut GValueArray,
        compare_func: GCompareFunc,
    ) -> *mut GValueArray;
}
extern "C" {
    pub fn g_value_array_sort_with_data(
        value_array: *mut GValueArray,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    ) -> *mut GValueArray;
}
extern "C" {
    pub fn g_value_set_char(value: *mut GValue, v_char: gchar);
}
extern "C" {
    pub fn g_value_get_char(value: *const GValue) -> gchar;
}
extern "C" {
    pub fn g_value_set_schar(value: *mut GValue, v_char: gint8);
}
extern "C" {
    pub fn g_value_get_schar(value: *const GValue) -> gint8;
}
extern "C" {
    pub fn g_value_set_uchar(value: *mut GValue, v_uchar: guchar);
}
extern "C" {
    pub fn g_value_get_uchar(value: *const GValue) -> guchar;
}
extern "C" {
    pub fn g_value_set_boolean(value: *mut GValue, v_boolean: gboolean);
}
extern "C" {
    pub fn g_value_get_boolean(value: *const GValue) -> gboolean;
}
extern "C" {
    pub fn g_value_set_int(value: *mut GValue, v_int: gint);
}
extern "C" {
    pub fn g_value_get_int(value: *const GValue) -> gint;
}
extern "C" {
    pub fn g_value_set_uint(value: *mut GValue, v_uint: guint);
}
extern "C" {
    pub fn g_value_get_uint(value: *const GValue) -> guint;
}
extern "C" {
    pub fn g_value_set_long(value: *mut GValue, v_long: glong);
}
extern "C" {
    pub fn g_value_get_long(value: *const GValue) -> glong;
}
extern "C" {
    pub fn g_value_set_ulong(value: *mut GValue, v_ulong: gulong);
}
extern "C" {
    pub fn g_value_get_ulong(value: *const GValue) -> gulong;
}
extern "C" {
    pub fn g_value_set_int64(value: *mut GValue, v_int64: gint64);
}
extern "C" {
    pub fn g_value_get_int64(value: *const GValue) -> gint64;
}
extern "C" {
    pub fn g_value_set_uint64(value: *mut GValue, v_uint64: guint64);
}
extern "C" {
    pub fn g_value_get_uint64(value: *const GValue) -> guint64;
}
extern "C" {
    pub fn g_value_set_float(value: *mut GValue, v_float: gfloat);
}
extern "C" {
    pub fn g_value_get_float(value: *const GValue) -> gfloat;
}
extern "C" {
    pub fn g_value_set_double(value: *mut GValue, v_double: gdouble);
}
extern "C" {
    pub fn g_value_get_double(value: *const GValue) -> gdouble;
}
extern "C" {
    pub fn g_value_set_string(value: *mut GValue, v_string: *const gchar);
}
extern "C" {
    pub fn g_value_set_static_string(value: *mut GValue, v_string: *const gchar);
}
extern "C" {
    pub fn g_value_get_string(value: *const GValue) -> *const gchar;
}
extern "C" {
    pub fn g_value_dup_string(value: *const GValue) -> *mut gchar;
}
extern "C" {
    pub fn g_value_set_pointer(value: *mut GValue, v_pointer: gpointer);
}
extern "C" {
    pub fn g_value_get_pointer(value: *const GValue) -> gpointer;
}
extern "C" {
    pub fn g_gtype_get_type() -> GType;
}
extern "C" {
    pub fn g_value_set_gtype(value: *mut GValue, v_gtype: GType);
}
extern "C" {
    pub fn g_value_get_gtype(value: *const GValue) -> GType;
}
extern "C" {
    pub fn g_value_set_variant(value: *mut GValue, variant: *mut GVariant);
}
extern "C" {
    pub fn g_value_take_variant(value: *mut GValue, variant: *mut GVariant);
}
extern "C" {
    pub fn g_value_get_variant(value: *const GValue) -> *mut GVariant;
}
extern "C" {
    pub fn g_value_dup_variant(value: *const GValue) -> *mut GVariant;
}
extern "C" {
    pub fn g_pointer_type_register_static(name: *const gchar) -> GType;
}
extern "C" {
    pub fn g_strdup_value_contents(value: *const GValue) -> *mut gchar;
}
extern "C" {
    pub fn g_value_take_string(value: *mut GValue, v_string: *mut gchar);
}
extern "C" {
    pub fn g_value_set_string_take_ownership(value: *mut GValue, v_string: *mut gchar);
}
pub type gchararray = *mut gchar;
pub type GClosure_autoptr = *mut GClosure;
pub type GClosure_listautoptr = *mut GList;
pub type GClosure_slistautoptr = *mut GSList;
pub type GClosure_queueautoptr = *mut GQueue;
pub type GEnumClass_autoptr = *mut GEnumClass;
pub type GEnumClass_listautoptr = *mut GList;
pub type GEnumClass_slistautoptr = *mut GSList;
pub type GEnumClass_queueautoptr = *mut GQueue;
pub type GFlagsClass_autoptr = *mut GFlagsClass;
pub type GFlagsClass_listautoptr = *mut GList;
pub type GFlagsClass_slistautoptr = *mut GSList;
pub type GFlagsClass_queueautoptr = *mut GQueue;
pub type GObject_autoptr = *mut GObject;
pub type GObject_listautoptr = *mut GList;
pub type GObject_slistautoptr = *mut GSList;
pub type GObject_queueautoptr = *mut GQueue;
pub type GInitiallyUnowned_autoptr = *mut GInitiallyUnowned;
pub type GInitiallyUnowned_listautoptr = *mut GList;
pub type GInitiallyUnowned_slistautoptr = *mut GSList;
pub type GInitiallyUnowned_queueautoptr = *mut GQueue;
pub type GParamSpec_autoptr = *mut GParamSpec;
pub type GParamSpec_listautoptr = *mut GList;
pub type GParamSpec_slistautoptr = *mut GSList;
pub type GParamSpec_queueautoptr = *mut GQueue;
pub type GTypeClass_autoptr = *mut GTypeClass;
pub type GTypeClass_listautoptr = *mut GList;
pub type GTypeClass_slistautoptr = *mut GSList;
pub type GTypeClass_queueautoptr = *mut GQueue;
pub const GAppInfoCreateFlags_G_APP_INFO_CREATE_NONE: GAppInfoCreateFlags = 0;
pub const GAppInfoCreateFlags_G_APP_INFO_CREATE_NEEDS_TERMINAL: GAppInfoCreateFlags = 1;
pub const GAppInfoCreateFlags_G_APP_INFO_CREATE_SUPPORTS_URIS: GAppInfoCreateFlags = 2;
pub const GAppInfoCreateFlags_G_APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION: GAppInfoCreateFlags =
    4;
pub type GAppInfoCreateFlags = u32;
pub const GConverterFlags_G_CONVERTER_NO_FLAGS: GConverterFlags = 0;
pub const GConverterFlags_G_CONVERTER_INPUT_AT_END: GConverterFlags = 1;
pub const GConverterFlags_G_CONVERTER_FLUSH: GConverterFlags = 2;
pub type GConverterFlags = u32;
pub const GConverterResult_G_CONVERTER_ERROR: GConverterResult = 0;
pub const GConverterResult_G_CONVERTER_CONVERTED: GConverterResult = 1;
pub const GConverterResult_G_CONVERTER_FINISHED: GConverterResult = 2;
pub const GConverterResult_G_CONVERTER_FLUSHED: GConverterResult = 3;
pub type GConverterResult = u32;
pub const GDataStreamByteOrder_G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN: GDataStreamByteOrder = 0;
pub const GDataStreamByteOrder_G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN: GDataStreamByteOrder = 1;
pub const GDataStreamByteOrder_G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN: GDataStreamByteOrder = 2;
pub type GDataStreamByteOrder = u32;
pub const GDataStreamNewlineType_G_DATA_STREAM_NEWLINE_TYPE_LF: GDataStreamNewlineType = 0;
pub const GDataStreamNewlineType_G_DATA_STREAM_NEWLINE_TYPE_CR: GDataStreamNewlineType = 1;
pub const GDataStreamNewlineType_G_DATA_STREAM_NEWLINE_TYPE_CR_LF: GDataStreamNewlineType = 2;
pub const GDataStreamNewlineType_G_DATA_STREAM_NEWLINE_TYPE_ANY: GDataStreamNewlineType = 3;
pub type GDataStreamNewlineType = u32;
pub const GFileAttributeType_G_FILE_ATTRIBUTE_TYPE_INVALID: GFileAttributeType = 0;
pub const GFileAttributeType_G_FILE_ATTRIBUTE_TYPE_STRING: GFileAttributeType = 1;
pub const GFileAttributeType_G_FILE_ATTRIBUTE_TYPE_BYTE_STRING: GFileAttributeType = 2;
pub const GFileAttributeType_G_FILE_ATTRIBUTE_TYPE_BOOLEAN: GFileAttributeType = 3;
pub const GFileAttributeType_G_FILE_ATTRIBUTE_TYPE_UINT32: GFileAttributeType = 4;
pub const GFileAttributeType_G_FILE_ATTRIBUTE_TYPE_INT32: GFileAttributeType = 5;
pub const GFileAttributeType_G_FILE_ATTRIBUTE_TYPE_UINT64: GFileAttributeType = 6;
pub const GFileAttributeType_G_FILE_ATTRIBUTE_TYPE_INT64: GFileAttributeType = 7;
pub const GFileAttributeType_G_FILE_ATTRIBUTE_TYPE_OBJECT: GFileAttributeType = 8;
pub const GFileAttributeType_G_FILE_ATTRIBUTE_TYPE_STRINGV: GFileAttributeType = 9;
pub type GFileAttributeType = u32;
pub const GFileAttributeInfoFlags_G_FILE_ATTRIBUTE_INFO_NONE: GFileAttributeInfoFlags = 0;
pub const GFileAttributeInfoFlags_G_FILE_ATTRIBUTE_INFO_COPY_WITH_FILE: GFileAttributeInfoFlags = 1;
pub const GFileAttributeInfoFlags_G_FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED: GFileAttributeInfoFlags =
    2;
pub type GFileAttributeInfoFlags = u32;
pub const GFileAttributeStatus_G_FILE_ATTRIBUTE_STATUS_UNSET: GFileAttributeStatus = 0;
pub const GFileAttributeStatus_G_FILE_ATTRIBUTE_STATUS_SET: GFileAttributeStatus = 1;
pub const GFileAttributeStatus_G_FILE_ATTRIBUTE_STATUS_ERROR_SETTING: GFileAttributeStatus = 2;
pub type GFileAttributeStatus = u32;
pub const GFileQueryInfoFlags_G_FILE_QUERY_INFO_NONE: GFileQueryInfoFlags = 0;
pub const GFileQueryInfoFlags_G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS: GFileQueryInfoFlags = 1;
pub type GFileQueryInfoFlags = u32;
pub const GFileCreateFlags_G_FILE_CREATE_NONE: GFileCreateFlags = 0;
pub const GFileCreateFlags_G_FILE_CREATE_PRIVATE: GFileCreateFlags = 1;
pub const GFileCreateFlags_G_FILE_CREATE_REPLACE_DESTINATION: GFileCreateFlags = 2;
pub type GFileCreateFlags = u32;
pub const GFileMeasureFlags_G_FILE_MEASURE_NONE: GFileMeasureFlags = 0;
pub const GFileMeasureFlags_G_FILE_MEASURE_REPORT_ANY_ERROR: GFileMeasureFlags = 2;
pub const GFileMeasureFlags_G_FILE_MEASURE_APPARENT_SIZE: GFileMeasureFlags = 4;
pub const GFileMeasureFlags_G_FILE_MEASURE_NO_XDEV: GFileMeasureFlags = 8;
pub type GFileMeasureFlags = u32;
pub const GMountMountFlags_G_MOUNT_MOUNT_NONE: GMountMountFlags = 0;
pub type GMountMountFlags = u32;
pub const GMountUnmountFlags_G_MOUNT_UNMOUNT_NONE: GMountUnmountFlags = 0;
pub const GMountUnmountFlags_G_MOUNT_UNMOUNT_FORCE: GMountUnmountFlags = 1;
pub type GMountUnmountFlags = u32;
pub const GDriveStartFlags_G_DRIVE_START_NONE: GDriveStartFlags = 0;
pub type GDriveStartFlags = u32;
pub const GDriveStartStopType_G_DRIVE_START_STOP_TYPE_UNKNOWN: GDriveStartStopType = 0;
pub const GDriveStartStopType_G_DRIVE_START_STOP_TYPE_SHUTDOWN: GDriveStartStopType = 1;
pub const GDriveStartStopType_G_DRIVE_START_STOP_TYPE_NETWORK: GDriveStartStopType = 2;
pub const GDriveStartStopType_G_DRIVE_START_STOP_TYPE_MULTIDISK: GDriveStartStopType = 3;
pub const GDriveStartStopType_G_DRIVE_START_STOP_TYPE_PASSWORD: GDriveStartStopType = 4;
pub type GDriveStartStopType = u32;
pub const GFileCopyFlags_G_FILE_COPY_NONE: GFileCopyFlags = 0;
pub const GFileCopyFlags_G_FILE_COPY_OVERWRITE: GFileCopyFlags = 1;
pub const GFileCopyFlags_G_FILE_COPY_BACKUP: GFileCopyFlags = 2;
pub const GFileCopyFlags_G_FILE_COPY_NOFOLLOW_SYMLINKS: GFileCopyFlags = 4;
pub const GFileCopyFlags_G_FILE_COPY_ALL_METADATA: GFileCopyFlags = 8;
pub const GFileCopyFlags_G_FILE_COPY_NO_FALLBACK_FOR_MOVE: GFileCopyFlags = 16;
pub const GFileCopyFlags_G_FILE_COPY_TARGET_DEFAULT_PERMS: GFileCopyFlags = 32;
pub type GFileCopyFlags = u32;
pub const GFileMonitorFlags_G_FILE_MONITOR_NONE: GFileMonitorFlags = 0;
pub const GFileMonitorFlags_G_FILE_MONITOR_WATCH_MOUNTS: GFileMonitorFlags = 1;
pub const GFileMonitorFlags_G_FILE_MONITOR_SEND_MOVED: GFileMonitorFlags = 2;
pub const GFileMonitorFlags_G_FILE_MONITOR_WATCH_HARD_LINKS: GFileMonitorFlags = 4;
pub const GFileMonitorFlags_G_FILE_MONITOR_WATCH_MOVES: GFileMonitorFlags = 8;
pub type GFileMonitorFlags = u32;
pub const GFileType_G_FILE_TYPE_UNKNOWN: GFileType = 0;
pub const GFileType_G_FILE_TYPE_REGULAR: GFileType = 1;
pub const GFileType_G_FILE_TYPE_DIRECTORY: GFileType = 2;
pub const GFileType_G_FILE_TYPE_SYMBOLIC_LINK: GFileType = 3;
pub const GFileType_G_FILE_TYPE_SPECIAL: GFileType = 4;
pub const GFileType_G_FILE_TYPE_SHORTCUT: GFileType = 5;
pub const GFileType_G_FILE_TYPE_MOUNTABLE: GFileType = 6;
pub type GFileType = u32;
pub const GFilesystemPreviewType_G_FILESYSTEM_PREVIEW_TYPE_IF_ALWAYS: GFilesystemPreviewType = 0;
pub const GFilesystemPreviewType_G_FILESYSTEM_PREVIEW_TYPE_IF_LOCAL: GFilesystemPreviewType = 1;
pub const GFilesystemPreviewType_G_FILESYSTEM_PREVIEW_TYPE_NEVER: GFilesystemPreviewType = 2;
pub type GFilesystemPreviewType = u32;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_CHANGED: GFileMonitorEvent = 0;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT: GFileMonitorEvent = 1;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_DELETED: GFileMonitorEvent = 2;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_CREATED: GFileMonitorEvent = 3;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED: GFileMonitorEvent = 4;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_PRE_UNMOUNT: GFileMonitorEvent = 5;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_UNMOUNTED: GFileMonitorEvent = 6;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_MOVED: GFileMonitorEvent = 7;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_RENAMED: GFileMonitorEvent = 8;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_MOVED_IN: GFileMonitorEvent = 9;
pub const GFileMonitorEvent_G_FILE_MONITOR_EVENT_MOVED_OUT: GFileMonitorEvent = 10;
pub type GFileMonitorEvent = u32;
pub const GIOErrorEnum_G_IO_ERROR_FAILED: GIOErrorEnum = 0;
pub const GIOErrorEnum_G_IO_ERROR_NOT_FOUND: GIOErrorEnum = 1;
pub const GIOErrorEnum_G_IO_ERROR_EXISTS: GIOErrorEnum = 2;
pub const GIOErrorEnum_G_IO_ERROR_IS_DIRECTORY: GIOErrorEnum = 3;
pub const GIOErrorEnum_G_IO_ERROR_NOT_DIRECTORY: GIOErrorEnum = 4;
pub const GIOErrorEnum_G_IO_ERROR_NOT_EMPTY: GIOErrorEnum = 5;
pub const GIOErrorEnum_G_IO_ERROR_NOT_REGULAR_FILE: GIOErrorEnum = 6;
pub const GIOErrorEnum_G_IO_ERROR_NOT_SYMBOLIC_LINK: GIOErrorEnum = 7;
pub const GIOErrorEnum_G_IO_ERROR_NOT_MOUNTABLE_FILE: GIOErrorEnum = 8;
pub const GIOErrorEnum_G_IO_ERROR_FILENAME_TOO_LONG: GIOErrorEnum = 9;
pub const GIOErrorEnum_G_IO_ERROR_INVALID_FILENAME: GIOErrorEnum = 10;
pub const GIOErrorEnum_G_IO_ERROR_TOO_MANY_LINKS: GIOErrorEnum = 11;
pub const GIOErrorEnum_G_IO_ERROR_NO_SPACE: GIOErrorEnum = 12;
pub const GIOErrorEnum_G_IO_ERROR_INVALID_ARGUMENT: GIOErrorEnum = 13;
pub const GIOErrorEnum_G_IO_ERROR_PERMISSION_DENIED: GIOErrorEnum = 14;
pub const GIOErrorEnum_G_IO_ERROR_NOT_SUPPORTED: GIOErrorEnum = 15;
pub const GIOErrorEnum_G_IO_ERROR_NOT_MOUNTED: GIOErrorEnum = 16;
pub const GIOErrorEnum_G_IO_ERROR_ALREADY_MOUNTED: GIOErrorEnum = 17;
pub const GIOErrorEnum_G_IO_ERROR_CLOSED: GIOErrorEnum = 18;
pub const GIOErrorEnum_G_IO_ERROR_CANCELLED: GIOErrorEnum = 19;
pub const GIOErrorEnum_G_IO_ERROR_PENDING: GIOErrorEnum = 20;
pub const GIOErrorEnum_G_IO_ERROR_READ_ONLY: GIOErrorEnum = 21;
pub const GIOErrorEnum_G_IO_ERROR_CANT_CREATE_BACKUP: GIOErrorEnum = 22;
pub const GIOErrorEnum_G_IO_ERROR_WRONG_ETAG: GIOErrorEnum = 23;
pub const GIOErrorEnum_G_IO_ERROR_TIMED_OUT: GIOErrorEnum = 24;
pub const GIOErrorEnum_G_IO_ERROR_WOULD_RECURSE: GIOErrorEnum = 25;
pub const GIOErrorEnum_G_IO_ERROR_BUSY: GIOErrorEnum = 26;
pub const GIOErrorEnum_G_IO_ERROR_WOULD_BLOCK: GIOErrorEnum = 27;
pub const GIOErrorEnum_G_IO_ERROR_HOST_NOT_FOUND: GIOErrorEnum = 28;
pub const GIOErrorEnum_G_IO_ERROR_WOULD_MERGE: GIOErrorEnum = 29;
pub const GIOErrorEnum_G_IO_ERROR_FAILED_HANDLED: GIOErrorEnum = 30;
pub const GIOErrorEnum_G_IO_ERROR_TOO_MANY_OPEN_FILES: GIOErrorEnum = 31;
pub const GIOErrorEnum_G_IO_ERROR_NOT_INITIALIZED: GIOErrorEnum = 32;
pub const GIOErrorEnum_G_IO_ERROR_ADDRESS_IN_USE: GIOErrorEnum = 33;
pub const GIOErrorEnum_G_IO_ERROR_PARTIAL_INPUT: GIOErrorEnum = 34;
pub const GIOErrorEnum_G_IO_ERROR_INVALID_DATA: GIOErrorEnum = 35;
pub const GIOErrorEnum_G_IO_ERROR_DBUS_ERROR: GIOErrorEnum = 36;
pub const GIOErrorEnum_G_IO_ERROR_HOST_UNREACHABLE: GIOErrorEnum = 37;
pub const GIOErrorEnum_G_IO_ERROR_NETWORK_UNREACHABLE: GIOErrorEnum = 38;
pub const GIOErrorEnum_G_IO_ERROR_CONNECTION_REFUSED: GIOErrorEnum = 39;
pub const GIOErrorEnum_G_IO_ERROR_PROXY_FAILED: GIOErrorEnum = 40;
pub const GIOErrorEnum_G_IO_ERROR_PROXY_AUTH_FAILED: GIOErrorEnum = 41;
pub const GIOErrorEnum_G_IO_ERROR_PROXY_NEED_AUTH: GIOErrorEnum = 42;
pub const GIOErrorEnum_G_IO_ERROR_PROXY_NOT_ALLOWED: GIOErrorEnum = 43;
pub const GIOErrorEnum_G_IO_ERROR_BROKEN_PIPE: GIOErrorEnum = 44;
pub const GIOErrorEnum_G_IO_ERROR_CONNECTION_CLOSED: GIOErrorEnum = 44;
pub const GIOErrorEnum_G_IO_ERROR_NOT_CONNECTED: GIOErrorEnum = 45;
pub const GIOErrorEnum_G_IO_ERROR_MESSAGE_TOO_LARGE: GIOErrorEnum = 46;
pub type GIOErrorEnum = u32;
pub const GAskPasswordFlags_G_ASK_PASSWORD_NEED_PASSWORD: GAskPasswordFlags = 1;
pub const GAskPasswordFlags_G_ASK_PASSWORD_NEED_USERNAME: GAskPasswordFlags = 2;
pub const GAskPasswordFlags_G_ASK_PASSWORD_NEED_DOMAIN: GAskPasswordFlags = 4;
pub const GAskPasswordFlags_G_ASK_PASSWORD_SAVING_SUPPORTED: GAskPasswordFlags = 8;
pub const GAskPasswordFlags_G_ASK_PASSWORD_ANONYMOUS_SUPPORTED: GAskPasswordFlags = 16;
pub const GAskPasswordFlags_G_ASK_PASSWORD_TCRYPT: GAskPasswordFlags = 32;
pub type GAskPasswordFlags = u32;
pub const GPasswordSave_G_PASSWORD_SAVE_NEVER: GPasswordSave = 0;
pub const GPasswordSave_G_PASSWORD_SAVE_FOR_SESSION: GPasswordSave = 1;
pub const GPasswordSave_G_PASSWORD_SAVE_PERMANENTLY: GPasswordSave = 2;
pub type GPasswordSave = u32;
pub const GMountOperationResult_G_MOUNT_OPERATION_HANDLED: GMountOperationResult = 0;
pub const GMountOperationResult_G_MOUNT_OPERATION_ABORTED: GMountOperationResult = 1;
pub const GMountOperationResult_G_MOUNT_OPERATION_UNHANDLED: GMountOperationResult = 2;
pub type GMountOperationResult = u32;
pub const GOutputStreamSpliceFlags_G_OUTPUT_STREAM_SPLICE_NONE: GOutputStreamSpliceFlags = 0;
pub const GOutputStreamSpliceFlags_G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE: GOutputStreamSpliceFlags =
    1;
pub const GOutputStreamSpliceFlags_G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET: GOutputStreamSpliceFlags =
    2;
pub type GOutputStreamSpliceFlags = u32;
pub const GIOStreamSpliceFlags_G_IO_STREAM_SPLICE_NONE: GIOStreamSpliceFlags = 0;
pub const GIOStreamSpliceFlags_G_IO_STREAM_SPLICE_CLOSE_STREAM1: GIOStreamSpliceFlags = 1;
pub const GIOStreamSpliceFlags_G_IO_STREAM_SPLICE_CLOSE_STREAM2: GIOStreamSpliceFlags = 2;
pub const GIOStreamSpliceFlags_G_IO_STREAM_SPLICE_WAIT_FOR_BOTH: GIOStreamSpliceFlags = 4;
pub type GIOStreamSpliceFlags = u32;
pub const GEmblemOrigin_G_EMBLEM_ORIGIN_UNKNOWN: GEmblemOrigin = 0;
pub const GEmblemOrigin_G_EMBLEM_ORIGIN_DEVICE: GEmblemOrigin = 1;
pub const GEmblemOrigin_G_EMBLEM_ORIGIN_LIVEMETADATA: GEmblemOrigin = 2;
pub const GEmblemOrigin_G_EMBLEM_ORIGIN_TAG: GEmblemOrigin = 3;
pub type GEmblemOrigin = u32;
pub const GResolverError_G_RESOLVER_ERROR_NOT_FOUND: GResolverError = 0;
pub const GResolverError_G_RESOLVER_ERROR_TEMPORARY_FAILURE: GResolverError = 1;
pub const GResolverError_G_RESOLVER_ERROR_INTERNAL: GResolverError = 2;
pub type GResolverError = u32;
pub const GResolverRecordType_G_RESOLVER_RECORD_SRV: GResolverRecordType = 1;
pub const GResolverRecordType_G_RESOLVER_RECORD_MX: GResolverRecordType = 2;
pub const GResolverRecordType_G_RESOLVER_RECORD_TXT: GResolverRecordType = 3;
pub const GResolverRecordType_G_RESOLVER_RECORD_SOA: GResolverRecordType = 4;
pub const GResolverRecordType_G_RESOLVER_RECORD_NS: GResolverRecordType = 5;
pub type GResolverRecordType = u32;
pub const GResourceError_G_RESOURCE_ERROR_NOT_FOUND: GResourceError = 0;
pub const GResourceError_G_RESOURCE_ERROR_INTERNAL: GResourceError = 1;
pub type GResourceError = u32;
pub const GResourceFlags_G_RESOURCE_FLAGS_NONE: GResourceFlags = 0;
pub const GResourceFlags_G_RESOURCE_FLAGS_COMPRESSED: GResourceFlags = 1;
pub type GResourceFlags = u32;
pub const GResourceLookupFlags_G_RESOURCE_LOOKUP_FLAGS_NONE: GResourceLookupFlags = 0;
pub type GResourceLookupFlags = u32;
pub const GSocketFamily_G_SOCKET_FAMILY_INVALID: GSocketFamily = 0;
pub const GSocketFamily_G_SOCKET_FAMILY_UNIX: GSocketFamily = 1;
pub const GSocketFamily_G_SOCKET_FAMILY_IPV4: GSocketFamily = 2;
pub const GSocketFamily_G_SOCKET_FAMILY_IPV6: GSocketFamily = 10;
pub type GSocketFamily = u32;
pub const GSocketType_G_SOCKET_TYPE_INVALID: GSocketType = 0;
pub const GSocketType_G_SOCKET_TYPE_STREAM: GSocketType = 1;
pub const GSocketType_G_SOCKET_TYPE_DATAGRAM: GSocketType = 2;
pub const GSocketType_G_SOCKET_TYPE_SEQPACKET: GSocketType = 3;
pub type GSocketType = u32;
pub const GSocketMsgFlags_G_SOCKET_MSG_NONE: GSocketMsgFlags = 0;
pub const GSocketMsgFlags_G_SOCKET_MSG_OOB: GSocketMsgFlags = 1;
pub const GSocketMsgFlags_G_SOCKET_MSG_PEEK: GSocketMsgFlags = 2;
pub const GSocketMsgFlags_G_SOCKET_MSG_DONTROUTE: GSocketMsgFlags = 4;
pub type GSocketMsgFlags = u32;
pub const GSocketProtocol_G_SOCKET_PROTOCOL_UNKNOWN: GSocketProtocol = -1;
pub const GSocketProtocol_G_SOCKET_PROTOCOL_DEFAULT: GSocketProtocol = 0;
pub const GSocketProtocol_G_SOCKET_PROTOCOL_TCP: GSocketProtocol = 6;
pub const GSocketProtocol_G_SOCKET_PROTOCOL_UDP: GSocketProtocol = 17;
pub const GSocketProtocol_G_SOCKET_PROTOCOL_SCTP: GSocketProtocol = 132;
pub type GSocketProtocol = i32;
pub const GZlibCompressorFormat_G_ZLIB_COMPRESSOR_FORMAT_ZLIB: GZlibCompressorFormat = 0;
pub const GZlibCompressorFormat_G_ZLIB_COMPRESSOR_FORMAT_GZIP: GZlibCompressorFormat = 1;
pub const GZlibCompressorFormat_G_ZLIB_COMPRESSOR_FORMAT_RAW: GZlibCompressorFormat = 2;
pub type GZlibCompressorFormat = u32;
pub const GUnixSocketAddressType_G_UNIX_SOCKET_ADDRESS_INVALID: GUnixSocketAddressType = 0;
pub const GUnixSocketAddressType_G_UNIX_SOCKET_ADDRESS_ANONYMOUS: GUnixSocketAddressType = 1;
pub const GUnixSocketAddressType_G_UNIX_SOCKET_ADDRESS_PATH: GUnixSocketAddressType = 2;
pub const GUnixSocketAddressType_G_UNIX_SOCKET_ADDRESS_ABSTRACT: GUnixSocketAddressType = 3;
pub const GUnixSocketAddressType_G_UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED: GUnixSocketAddressType = 4;
pub type GUnixSocketAddressType = u32;
pub const GBusType_G_BUS_TYPE_STARTER: GBusType = -1;
pub const GBusType_G_BUS_TYPE_NONE: GBusType = 0;
pub const GBusType_G_BUS_TYPE_SYSTEM: GBusType = 1;
pub const GBusType_G_BUS_TYPE_SESSION: GBusType = 2;
pub type GBusType = i32;
pub const GBusNameOwnerFlags_G_BUS_NAME_OWNER_FLAGS_NONE: GBusNameOwnerFlags = 0;
pub const GBusNameOwnerFlags_G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT: GBusNameOwnerFlags = 1;
pub const GBusNameOwnerFlags_G_BUS_NAME_OWNER_FLAGS_REPLACE: GBusNameOwnerFlags = 2;
pub const GBusNameOwnerFlags_G_BUS_NAME_OWNER_FLAGS_DO_NOT_QUEUE: GBusNameOwnerFlags = 4;
pub type GBusNameOwnerFlags = u32;
pub const GBusNameWatcherFlags_G_BUS_NAME_WATCHER_FLAGS_NONE: GBusNameWatcherFlags = 0;
pub const GBusNameWatcherFlags_G_BUS_NAME_WATCHER_FLAGS_AUTO_START: GBusNameWatcherFlags = 1;
pub type GBusNameWatcherFlags = u32;
pub const GDBusProxyFlags_G_DBUS_PROXY_FLAGS_NONE: GDBusProxyFlags = 0;
pub const GDBusProxyFlags_G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES: GDBusProxyFlags = 1;
pub const GDBusProxyFlags_G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS: GDBusProxyFlags = 2;
pub const GDBusProxyFlags_G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START: GDBusProxyFlags = 4;
pub const GDBusProxyFlags_G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES: GDBusProxyFlags = 8;
pub const GDBusProxyFlags_G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START_AT_CONSTRUCTION: GDBusProxyFlags =
    16;
pub type GDBusProxyFlags = u32;
pub const GDBusError_G_DBUS_ERROR_FAILED: GDBusError = 0;
pub const GDBusError_G_DBUS_ERROR_NO_MEMORY: GDBusError = 1;
pub const GDBusError_G_DBUS_ERROR_SERVICE_UNKNOWN: GDBusError = 2;
pub const GDBusError_G_DBUS_ERROR_NAME_HAS_NO_OWNER: GDBusError = 3;
pub const GDBusError_G_DBUS_ERROR_NO_REPLY: GDBusError = 4;
pub const GDBusError_G_DBUS_ERROR_IO_ERROR: GDBusError = 5;
pub const GDBusError_G_DBUS_ERROR_BAD_ADDRESS: GDBusError = 6;
pub const GDBusError_G_DBUS_ERROR_NOT_SUPPORTED: GDBusError = 7;
pub const GDBusError_G_DBUS_ERROR_LIMITS_EXCEEDED: GDBusError = 8;
pub const GDBusError_G_DBUS_ERROR_ACCESS_DENIED: GDBusError = 9;
pub const GDBusError_G_DBUS_ERROR_AUTH_FAILED: GDBusError = 10;
pub const GDBusError_G_DBUS_ERROR_NO_SERVER: GDBusError = 11;
pub const GDBusError_G_DBUS_ERROR_TIMEOUT: GDBusError = 12;
pub const GDBusError_G_DBUS_ERROR_NO_NETWORK: GDBusError = 13;
pub const GDBusError_G_DBUS_ERROR_ADDRESS_IN_USE: GDBusError = 14;
pub const GDBusError_G_DBUS_ERROR_DISCONNECTED: GDBusError = 15;
pub const GDBusError_G_DBUS_ERROR_INVALID_ARGS: GDBusError = 16;
pub const GDBusError_G_DBUS_ERROR_FILE_NOT_FOUND: GDBusError = 17;
pub const GDBusError_G_DBUS_ERROR_FILE_EXISTS: GDBusError = 18;
pub const GDBusError_G_DBUS_ERROR_UNKNOWN_METHOD: GDBusError = 19;
pub const GDBusError_G_DBUS_ERROR_TIMED_OUT: GDBusError = 20;
pub const GDBusError_G_DBUS_ERROR_MATCH_RULE_NOT_FOUND: GDBusError = 21;
pub const GDBusError_G_DBUS_ERROR_MATCH_RULE_INVALID: GDBusError = 22;
pub const GDBusError_G_DBUS_ERROR_SPAWN_EXEC_FAILED: GDBusError = 23;
pub const GDBusError_G_DBUS_ERROR_SPAWN_FORK_FAILED: GDBusError = 24;
pub const GDBusError_G_DBUS_ERROR_SPAWN_CHILD_EXITED: GDBusError = 25;
pub const GDBusError_G_DBUS_ERROR_SPAWN_CHILD_SIGNALED: GDBusError = 26;
pub const GDBusError_G_DBUS_ERROR_SPAWN_FAILED: GDBusError = 27;
pub const GDBusError_G_DBUS_ERROR_SPAWN_SETUP_FAILED: GDBusError = 28;
pub const GDBusError_G_DBUS_ERROR_SPAWN_CONFIG_INVALID: GDBusError = 29;
pub const GDBusError_G_DBUS_ERROR_SPAWN_SERVICE_INVALID: GDBusError = 30;
pub const GDBusError_G_DBUS_ERROR_SPAWN_SERVICE_NOT_FOUND: GDBusError = 31;
pub const GDBusError_G_DBUS_ERROR_SPAWN_PERMISSIONS_INVALID: GDBusError = 32;
pub const GDBusError_G_DBUS_ERROR_SPAWN_FILE_INVALID: GDBusError = 33;
pub const GDBusError_G_DBUS_ERROR_SPAWN_NO_MEMORY: GDBusError = 34;
pub const GDBusError_G_DBUS_ERROR_UNIX_PROCESS_ID_UNKNOWN: GDBusError = 35;
pub const GDBusError_G_DBUS_ERROR_INVALID_SIGNATURE: GDBusError = 36;
pub const GDBusError_G_DBUS_ERROR_INVALID_FILE_CONTENT: GDBusError = 37;
pub const GDBusError_G_DBUS_ERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN: GDBusError = 38;
pub const GDBusError_G_DBUS_ERROR_ADT_AUDIT_DATA_UNKNOWN: GDBusError = 39;
pub const GDBusError_G_DBUS_ERROR_OBJECT_PATH_IN_USE: GDBusError = 40;
pub const GDBusError_G_DBUS_ERROR_UNKNOWN_OBJECT: GDBusError = 41;
pub const GDBusError_G_DBUS_ERROR_UNKNOWN_INTERFACE: GDBusError = 42;
pub const GDBusError_G_DBUS_ERROR_UNKNOWN_PROPERTY: GDBusError = 43;
pub const GDBusError_G_DBUS_ERROR_PROPERTY_READ_ONLY: GDBusError = 44;
pub type GDBusError = u32;
pub const GDBusConnectionFlags_G_DBUS_CONNECTION_FLAGS_NONE: GDBusConnectionFlags = 0;
pub const GDBusConnectionFlags_G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT: GDBusConnectionFlags =
    1;
pub const GDBusConnectionFlags_G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER: GDBusConnectionFlags =
    2;
pub const GDBusConnectionFlags_G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS:
    GDBusConnectionFlags = 4;
pub const GDBusConnectionFlags_G_DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION:
    GDBusConnectionFlags = 8;
pub const GDBusConnectionFlags_G_DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING:
    GDBusConnectionFlags = 16;
pub type GDBusConnectionFlags = u32;
pub const GDBusCapabilityFlags_G_DBUS_CAPABILITY_FLAGS_NONE: GDBusCapabilityFlags = 0;
pub const GDBusCapabilityFlags_G_DBUS_CAPABILITY_FLAGS_UNIX_FD_PASSING: GDBusCapabilityFlags = 1;
pub type GDBusCapabilityFlags = u32;
pub const GDBusCallFlags_G_DBUS_CALL_FLAGS_NONE: GDBusCallFlags = 0;
pub const GDBusCallFlags_G_DBUS_CALL_FLAGS_NO_AUTO_START: GDBusCallFlags = 1;
pub const GDBusCallFlags_G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION: GDBusCallFlags = 2;
pub type GDBusCallFlags = u32;
pub const GDBusMessageType_G_DBUS_MESSAGE_TYPE_INVALID: GDBusMessageType = 0;
pub const GDBusMessageType_G_DBUS_MESSAGE_TYPE_METHOD_CALL: GDBusMessageType = 1;
pub const GDBusMessageType_G_DBUS_MESSAGE_TYPE_METHOD_RETURN: GDBusMessageType = 2;
pub const GDBusMessageType_G_DBUS_MESSAGE_TYPE_ERROR: GDBusMessageType = 3;
pub const GDBusMessageType_G_DBUS_MESSAGE_TYPE_SIGNAL: GDBusMessageType = 4;
pub type GDBusMessageType = u32;
pub const GDBusMessageFlags_G_DBUS_MESSAGE_FLAGS_NONE: GDBusMessageFlags = 0;
pub const GDBusMessageFlags_G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED: GDBusMessageFlags = 1;
pub const GDBusMessageFlags_G_DBUS_MESSAGE_FLAGS_NO_AUTO_START: GDBusMessageFlags = 2;
pub const GDBusMessageFlags_G_DBUS_MESSAGE_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION:
    GDBusMessageFlags = 4;
pub type GDBusMessageFlags = u32;
pub const GDBusMessageHeaderField_G_DBUS_MESSAGE_HEADER_FIELD_INVALID: GDBusMessageHeaderField = 0;
pub const GDBusMessageHeaderField_G_DBUS_MESSAGE_HEADER_FIELD_PATH: GDBusMessageHeaderField = 1;
pub const GDBusMessageHeaderField_G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE: GDBusMessageHeaderField =
    2;
pub const GDBusMessageHeaderField_G_DBUS_MESSAGE_HEADER_FIELD_MEMBER: GDBusMessageHeaderField = 3;
pub const GDBusMessageHeaderField_G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME: GDBusMessageHeaderField =
    4;
pub const GDBusMessageHeaderField_G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL:
    GDBusMessageHeaderField = 5;
pub const GDBusMessageHeaderField_G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION: GDBusMessageHeaderField =
    6;
pub const GDBusMessageHeaderField_G_DBUS_MESSAGE_HEADER_FIELD_SENDER: GDBusMessageHeaderField = 7;
pub const GDBusMessageHeaderField_G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE: GDBusMessageHeaderField =
    8;
pub const GDBusMessageHeaderField_G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS:
    GDBusMessageHeaderField = 9;
pub type GDBusMessageHeaderField = u32;
pub const GDBusPropertyInfoFlags_G_DBUS_PROPERTY_INFO_FLAGS_NONE: GDBusPropertyInfoFlags = 0;
pub const GDBusPropertyInfoFlags_G_DBUS_PROPERTY_INFO_FLAGS_READABLE: GDBusPropertyInfoFlags = 1;
pub const GDBusPropertyInfoFlags_G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE: GDBusPropertyInfoFlags = 2;
pub type GDBusPropertyInfoFlags = u32;
pub const GDBusSubtreeFlags_G_DBUS_SUBTREE_FLAGS_NONE: GDBusSubtreeFlags = 0;
pub const GDBusSubtreeFlags_G_DBUS_SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES: GDBusSubtreeFlags =
    1;
pub type GDBusSubtreeFlags = u32;
pub const GDBusServerFlags_G_DBUS_SERVER_FLAGS_NONE: GDBusServerFlags = 0;
pub const GDBusServerFlags_G_DBUS_SERVER_FLAGS_RUN_IN_THREAD: GDBusServerFlags = 1;
pub const GDBusServerFlags_G_DBUS_SERVER_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS: GDBusServerFlags = 2;
pub type GDBusServerFlags = u32;
pub const GDBusSignalFlags_G_DBUS_SIGNAL_FLAGS_NONE: GDBusSignalFlags = 0;
pub const GDBusSignalFlags_G_DBUS_SIGNAL_FLAGS_NO_MATCH_RULE: GDBusSignalFlags = 1;
pub const GDBusSignalFlags_G_DBUS_SIGNAL_FLAGS_MATCH_ARG0_NAMESPACE: GDBusSignalFlags = 2;
pub const GDBusSignalFlags_G_DBUS_SIGNAL_FLAGS_MATCH_ARG0_PATH: GDBusSignalFlags = 4;
pub type GDBusSignalFlags = u32;
pub const GDBusSendMessageFlags_G_DBUS_SEND_MESSAGE_FLAGS_NONE: GDBusSendMessageFlags = 0;
pub const GDBusSendMessageFlags_G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL: GDBusSendMessageFlags =
    1;
pub type GDBusSendMessageFlags = u32;
pub const GCredentialsType_G_CREDENTIALS_TYPE_INVALID: GCredentialsType = 0;
pub const GCredentialsType_G_CREDENTIALS_TYPE_LINUX_UCRED: GCredentialsType = 1;
pub const GCredentialsType_G_CREDENTIALS_TYPE_FREEBSD_CMSGCRED: GCredentialsType = 2;
pub const GCredentialsType_G_CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED: GCredentialsType = 3;
pub const GCredentialsType_G_CREDENTIALS_TYPE_SOLARIS_UCRED: GCredentialsType = 4;
pub const GCredentialsType_G_CREDENTIALS_TYPE_NETBSD_UNPCBID: GCredentialsType = 5;
pub type GCredentialsType = u32;
pub const GDBusMessageByteOrder_G_DBUS_MESSAGE_BYTE_ORDER_BIG_ENDIAN: GDBusMessageByteOrder = 66;
pub const GDBusMessageByteOrder_G_DBUS_MESSAGE_BYTE_ORDER_LITTLE_ENDIAN: GDBusMessageByteOrder =
    108;
pub type GDBusMessageByteOrder = u32;
pub const GApplicationFlags_G_APPLICATION_FLAGS_NONE: GApplicationFlags = 0;
pub const GApplicationFlags_G_APPLICATION_IS_SERVICE: GApplicationFlags = 1;
pub const GApplicationFlags_G_APPLICATION_IS_LAUNCHER: GApplicationFlags = 2;
pub const GApplicationFlags_G_APPLICATION_HANDLES_OPEN: GApplicationFlags = 4;
pub const GApplicationFlags_G_APPLICATION_HANDLES_COMMAND_LINE: GApplicationFlags = 8;
pub const GApplicationFlags_G_APPLICATION_SEND_ENVIRONMENT: GApplicationFlags = 16;
pub const GApplicationFlags_G_APPLICATION_NON_UNIQUE: GApplicationFlags = 32;
pub const GApplicationFlags_G_APPLICATION_CAN_OVERRIDE_APP_ID: GApplicationFlags = 64;
pub const GApplicationFlags_G_APPLICATION_ALLOW_REPLACEMENT: GApplicationFlags = 128;
pub const GApplicationFlags_G_APPLICATION_REPLACE: GApplicationFlags = 256;
pub type GApplicationFlags = u32;
pub const GTlsError_G_TLS_ERROR_UNAVAILABLE: GTlsError = 0;
pub const GTlsError_G_TLS_ERROR_MISC: GTlsError = 1;
pub const GTlsError_G_TLS_ERROR_BAD_CERTIFICATE: GTlsError = 2;
pub const GTlsError_G_TLS_ERROR_NOT_TLS: GTlsError = 3;
pub const GTlsError_G_TLS_ERROR_HANDSHAKE: GTlsError = 4;
pub const GTlsError_G_TLS_ERROR_CERTIFICATE_REQUIRED: GTlsError = 5;
pub const GTlsError_G_TLS_ERROR_EOF: GTlsError = 6;
pub const GTlsError_G_TLS_ERROR_INAPPROPRIATE_FALLBACK: GTlsError = 7;
pub type GTlsError = u32;
pub const GTlsCertificateFlags_G_TLS_CERTIFICATE_UNKNOWN_CA: GTlsCertificateFlags = 1;
pub const GTlsCertificateFlags_G_TLS_CERTIFICATE_BAD_IDENTITY: GTlsCertificateFlags = 2;
pub const GTlsCertificateFlags_G_TLS_CERTIFICATE_NOT_ACTIVATED: GTlsCertificateFlags = 4;
pub const GTlsCertificateFlags_G_TLS_CERTIFICATE_EXPIRED: GTlsCertificateFlags = 8;
pub const GTlsCertificateFlags_G_TLS_CERTIFICATE_REVOKED: GTlsCertificateFlags = 16;
pub const GTlsCertificateFlags_G_TLS_CERTIFICATE_INSECURE: GTlsCertificateFlags = 32;
pub const GTlsCertificateFlags_G_TLS_CERTIFICATE_GENERIC_ERROR: GTlsCertificateFlags = 64;
pub const GTlsCertificateFlags_G_TLS_CERTIFICATE_VALIDATE_ALL: GTlsCertificateFlags = 127;
pub type GTlsCertificateFlags = u32;
pub const GTlsAuthenticationMode_G_TLS_AUTHENTICATION_NONE: GTlsAuthenticationMode = 0;
pub const GTlsAuthenticationMode_G_TLS_AUTHENTICATION_REQUESTED: GTlsAuthenticationMode = 1;
pub const GTlsAuthenticationMode_G_TLS_AUTHENTICATION_REQUIRED: GTlsAuthenticationMode = 2;
pub type GTlsAuthenticationMode = u32;
pub const GTlsRehandshakeMode_G_TLS_REHANDSHAKE_NEVER: GTlsRehandshakeMode = 0;
pub const GTlsRehandshakeMode_G_TLS_REHANDSHAKE_SAFELY: GTlsRehandshakeMode = 1;
pub const GTlsRehandshakeMode_G_TLS_REHANDSHAKE_UNSAFELY: GTlsRehandshakeMode = 2;
pub type GTlsRehandshakeMode = u32;
pub const _GTlsPasswordFlags_G_TLS_PASSWORD_NONE: _GTlsPasswordFlags = 0;
pub const _GTlsPasswordFlags_G_TLS_PASSWORD_RETRY: _GTlsPasswordFlags = 2;
pub const _GTlsPasswordFlags_G_TLS_PASSWORD_MANY_TRIES: _GTlsPasswordFlags = 4;
pub const _GTlsPasswordFlags_G_TLS_PASSWORD_FINAL_TRY: _GTlsPasswordFlags = 8;
pub type _GTlsPasswordFlags = u32;
pub use self::_GTlsPasswordFlags as GTlsPasswordFlags;
pub const GTlsInteractionResult_G_TLS_INTERACTION_UNHANDLED: GTlsInteractionResult = 0;
pub const GTlsInteractionResult_G_TLS_INTERACTION_HANDLED: GTlsInteractionResult = 1;
pub const GTlsInteractionResult_G_TLS_INTERACTION_FAILED: GTlsInteractionResult = 2;
pub type GTlsInteractionResult = u32;
pub const GDBusInterfaceSkeletonFlags_G_DBUS_INTERFACE_SKELETON_FLAGS_NONE:
    GDBusInterfaceSkeletonFlags = 0;
pub const GDBusInterfaceSkeletonFlags_G_DBUS_INTERFACE_SKELETON_FLAGS_HANDLE_METHOD_INVOCATIONS_IN_THREAD : GDBusInterfaceSkeletonFlags = 1 ;
pub type GDBusInterfaceSkeletonFlags = u32;
pub const GDBusObjectManagerClientFlags_G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE:
    GDBusObjectManagerClientFlags = 0;
pub const GDBusObjectManagerClientFlags_G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_DO_NOT_AUTO_START:
    GDBusObjectManagerClientFlags = 1;
pub type GDBusObjectManagerClientFlags = u32;
pub const GTlsDatabaseVerifyFlags_G_TLS_DATABASE_VERIFY_NONE: GTlsDatabaseVerifyFlags = 0;
pub type GTlsDatabaseVerifyFlags = u32;
pub const GTlsDatabaseLookupFlags_G_TLS_DATABASE_LOOKUP_NONE: GTlsDatabaseLookupFlags = 0;
pub const GTlsDatabaseLookupFlags_G_TLS_DATABASE_LOOKUP_KEYPAIR: GTlsDatabaseLookupFlags = 1;
pub type GTlsDatabaseLookupFlags = u32;
pub const GTlsCertificateRequestFlags_G_TLS_CERTIFICATE_REQUEST_NONE: GTlsCertificateRequestFlags =
    0;
pub type GTlsCertificateRequestFlags = u32;
pub const GIOModuleScopeFlags_G_IO_MODULE_SCOPE_NONE: GIOModuleScopeFlags = 0;
pub const GIOModuleScopeFlags_G_IO_MODULE_SCOPE_BLOCK_DUPLICATES: GIOModuleScopeFlags = 1;
pub type GIOModuleScopeFlags = u32;
pub const GSocketClientEvent_G_SOCKET_CLIENT_RESOLVING: GSocketClientEvent = 0;
pub const GSocketClientEvent_G_SOCKET_CLIENT_RESOLVED: GSocketClientEvent = 1;
pub const GSocketClientEvent_G_SOCKET_CLIENT_CONNECTING: GSocketClientEvent = 2;
pub const GSocketClientEvent_G_SOCKET_CLIENT_CONNECTED: GSocketClientEvent = 3;
pub const GSocketClientEvent_G_SOCKET_CLIENT_PROXY_NEGOTIATING: GSocketClientEvent = 4;
pub const GSocketClientEvent_G_SOCKET_CLIENT_PROXY_NEGOTIATED: GSocketClientEvent = 5;
pub const GSocketClientEvent_G_SOCKET_CLIENT_TLS_HANDSHAKING: GSocketClientEvent = 6;
pub const GSocketClientEvent_G_SOCKET_CLIENT_TLS_HANDSHAKED: GSocketClientEvent = 7;
pub const GSocketClientEvent_G_SOCKET_CLIENT_COMPLETE: GSocketClientEvent = 8;
pub type GSocketClientEvent = u32;
pub const GSocketListenerEvent_G_SOCKET_LISTENER_BINDING: GSocketListenerEvent = 0;
pub const GSocketListenerEvent_G_SOCKET_LISTENER_BOUND: GSocketListenerEvent = 1;
pub const GSocketListenerEvent_G_SOCKET_LISTENER_LISTENING: GSocketListenerEvent = 2;
pub const GSocketListenerEvent_G_SOCKET_LISTENER_LISTENED: GSocketListenerEvent = 3;
pub type GSocketListenerEvent = u32;
pub const GTestDBusFlags_G_TEST_DBUS_NONE: GTestDBusFlags = 0;
pub type GTestDBusFlags = u32;
pub const GSubprocessFlags_G_SUBPROCESS_FLAGS_NONE: GSubprocessFlags = 0;
pub const GSubprocessFlags_G_SUBPROCESS_FLAGS_STDIN_PIPE: GSubprocessFlags = 1;
pub const GSubprocessFlags_G_SUBPROCESS_FLAGS_STDIN_INHERIT: GSubprocessFlags = 2;
pub const GSubprocessFlags_G_SUBPROCESS_FLAGS_STDOUT_PIPE: GSubprocessFlags = 4;
pub const GSubprocessFlags_G_SUBPROCESS_FLAGS_STDOUT_SILENCE: GSubprocessFlags = 8;
pub const GSubprocessFlags_G_SUBPROCESS_FLAGS_STDERR_PIPE: GSubprocessFlags = 16;
pub const GSubprocessFlags_G_SUBPROCESS_FLAGS_STDERR_SILENCE: GSubprocessFlags = 32;
pub const GSubprocessFlags_G_SUBPROCESS_FLAGS_STDERR_MERGE: GSubprocessFlags = 64;
pub const GSubprocessFlags_G_SUBPROCESS_FLAGS_INHERIT_FDS: GSubprocessFlags = 128;
pub type GSubprocessFlags = u32;
pub const GNotificationPriority_G_NOTIFICATION_PRIORITY_NORMAL: GNotificationPriority = 0;
pub const GNotificationPriority_G_NOTIFICATION_PRIORITY_LOW: GNotificationPriority = 1;
pub const GNotificationPriority_G_NOTIFICATION_PRIORITY_HIGH: GNotificationPriority = 2;
pub const GNotificationPriority_G_NOTIFICATION_PRIORITY_URGENT: GNotificationPriority = 3;
pub type GNotificationPriority = u32;
pub const GNetworkConnectivity_G_NETWORK_CONNECTIVITY_LOCAL: GNetworkConnectivity = 1;
pub const GNetworkConnectivity_G_NETWORK_CONNECTIVITY_LIMITED: GNetworkConnectivity = 2;
pub const GNetworkConnectivity_G_NETWORK_CONNECTIVITY_PORTAL: GNetworkConnectivity = 3;
pub const GNetworkConnectivity_G_NETWORK_CONNECTIVITY_FULL: GNetworkConnectivity = 4;
pub type GNetworkConnectivity = u32;
pub const GPollableReturn_G_POLLABLE_RETURN_FAILED: GPollableReturn = 0;
pub const GPollableReturn_G_POLLABLE_RETURN_OK: GPollableReturn = 1;
pub const GPollableReturn_G_POLLABLE_RETURN_WOULD_BLOCK: GPollableReturn = -27;
pub type GPollableReturn = i32;
pub const GMemoryMonitorWarningLevel_G_MEMORY_MONITOR_WARNING_LEVEL_LOW:
    GMemoryMonitorWarningLevel = 50;
pub const GMemoryMonitorWarningLevel_G_MEMORY_MONITOR_WARNING_LEVEL_MEDIUM:
    GMemoryMonitorWarningLevel = 100;
pub const GMemoryMonitorWarningLevel_G_MEMORY_MONITOR_WARNING_LEVEL_CRITICAL:
    GMemoryMonitorWarningLevel = 255;
pub type GMemoryMonitorWarningLevel = u32;
pub type GAppLaunchContext = _GAppLaunchContext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GAppInfo {
    _unused: [u8; 0],
}
pub type GAppInfo = _GAppInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GAsyncResult {
    _unused: [u8; 0],
}
pub type GAsyncResult = _GAsyncResult;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GAsyncInitable {
    _unused: [u8; 0],
}
pub type GAsyncInitable = _GAsyncInitable;
pub type GBufferedInputStream = _GBufferedInputStream;
pub type GBufferedOutputStream = _GBufferedOutputStream;
pub type GCancellable = _GCancellable;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GCharsetConverter {
    _unused: [u8; 0],
}
pub type GCharsetConverter = _GCharsetConverter;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GConverter {
    _unused: [u8; 0],
}
pub type GConverter = _GConverter;
pub type GConverterInputStream = _GConverterInputStream;
pub type GConverterOutputStream = _GConverterOutputStream;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDatagramBased {
    _unused: [u8; 0],
}
pub type GDatagramBased = _GDatagramBased;
pub type GDataInputStream = _GDataInputStream;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSimplePermission {
    _unused: [u8; 0],
}
pub type GSimplePermission = _GSimplePermission;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GZlibCompressor {
    _unused: [u8; 0],
}
pub type GZlibCompressor = _GZlibCompressor;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GZlibDecompressor {
    _unused: [u8; 0],
}
pub type GZlibDecompressor = _GZlibDecompressor;
pub type GSimpleActionGroup = _GSimpleActionGroup;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GRemoteActionGroup {
    _unused: [u8; 0],
}
pub type GRemoteActionGroup = _GRemoteActionGroup;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDBusActionGroup {
    _unused: [u8; 0],
}
pub type GDBusActionGroup = _GDBusActionGroup;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GActionMap {
    _unused: [u8; 0],
}
pub type GActionMap = _GActionMap;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GActionGroup {
    _unused: [u8; 0],
}
pub type GActionGroup = _GActionGroup;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GPropertyAction {
    _unused: [u8; 0],
}
pub type GPropertyAction = _GPropertyAction;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSimpleAction {
    _unused: [u8; 0],
}
pub type GSimpleAction = _GSimpleAction;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GAction {
    _unused: [u8; 0],
}
pub type GAction = _GAction;
pub type GApplication = _GApplication;
pub type GApplicationCommandLine = _GApplicationCommandLine;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSettingsBackend {
    _unused: [u8; 0],
}
pub type GSettingsBackend = _GSettingsBackend;
pub type GSettings = _GSettings;
pub type GPermission = _GPermission;
pub type GMenuModel = _GMenuModel;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GNotification {
    _unused: [u8; 0],
}
pub type GNotification = _GNotification;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDrive {
    _unused: [u8; 0],
}
pub type GDrive = _GDrive;
pub type GFileEnumerator = _GFileEnumerator;
pub type GFileMonitor = _GFileMonitor;
pub type GFilterInputStream = _GFilterInputStream;
pub type GFilterOutputStream = _GFilterOutputStream;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GFile {
    _unused: [u8; 0],
}
pub type GFile = _GFile;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GFileInfo {
    _unused: [u8; 0],
}
pub type GFileInfo = _GFileInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GFileAttributeMatcher {
    _unused: [u8; 0],
}
pub type GFileAttributeMatcher = _GFileAttributeMatcher;
pub type GFileAttributeInfo = _GFileAttributeInfo;
pub type GFileAttributeInfoList = _GFileAttributeInfoList;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GFileDescriptorBased {
    _unused: [u8; 0],
}
pub type GFileDescriptorBased = _GFileDescriptorBased;
pub type GFileInputStream = _GFileInputStream;
pub type GFileOutputStream = _GFileOutputStream;
pub type GFileIOStream = _GFileIOStream;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GFileIcon {
    _unused: [u8; 0],
}
pub type GFileIcon = _GFileIcon;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GFilenameCompleter {
    _unused: [u8; 0],
}
pub type GFilenameCompleter = _GFilenameCompleter;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GIcon {
    _unused: [u8; 0],
}
pub type GIcon = _GIcon;
pub type GInetAddress = _GInetAddress;
pub type GInetAddressMask = _GInetAddressMask;
pub type GInetSocketAddress = _GInetSocketAddress;
pub type GNativeSocketAddress = _GNativeSocketAddress;
pub type GInputStream = _GInputStream;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GInitable {
    _unused: [u8; 0],
}
pub type GInitable = _GInitable;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GIOModule {
    _unused: [u8; 0],
}
pub type GIOModule = _GIOModule;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GIOExtensionPoint {
    _unused: [u8; 0],
}
pub type GIOExtensionPoint = _GIOExtensionPoint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GIOExtension {
    _unused: [u8; 0],
}
pub type GIOExtension = _GIOExtension;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GIOSchedulerJob {
    _unused: [u8; 0],
}
pub type GIOSchedulerJob = _GIOSchedulerJob;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GIOStreamAdapter {
    _unused: [u8; 0],
}
pub type GIOStreamAdapter = _GIOStreamAdapter;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GLoadableIcon {
    _unused: [u8; 0],
}
pub type GLoadableIcon = _GLoadableIcon;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GBytesIcon {
    _unused: [u8; 0],
}
pub type GBytesIcon = _GBytesIcon;
pub type GMemoryInputStream = _GMemoryInputStream;
pub type GMemoryOutputStream = _GMemoryOutputStream;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMount {
    _unused: [u8; 0],
}
pub type GMount = _GMount;
pub type GMountOperation = _GMountOperation;
pub type GNetworkAddress = _GNetworkAddress;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GNetworkMonitor {
    _unused: [u8; 0],
}
pub type GNetworkMonitor = _GNetworkMonitor;
pub type GNetworkService = _GNetworkService;
pub type GOutputStream = _GOutputStream;
pub type GIOStream = _GIOStream;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSimpleIOStream {
    _unused: [u8; 0],
}
pub type GSimpleIOStream = _GSimpleIOStream;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GPollableInputStream {
    _unused: [u8; 0],
}
pub type GPollableInputStream = _GPollableInputStream;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GPollableOutputStream {
    _unused: [u8; 0],
}
pub type GPollableOutputStream = _GPollableOutputStream;
pub type GResolver = _GResolver;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GResource {
    _unused: [u8; 0],
}
pub type GResource = _GResource;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSeekable {
    _unused: [u8; 0],
}
pub type GSeekable = _GSeekable;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSimpleAsyncResult {
    _unused: [u8; 0],
}
pub type GSimpleAsyncResult = _GSimpleAsyncResult;
pub type GSocket = _GSocket;
pub type GSocketControlMessage = _GSocketControlMessage;
pub type GSocketClient = _GSocketClient;
pub type GSocketConnection = _GSocketConnection;
pub type GSocketListener = _GSocketListener;
pub type GSocketService = _GSocketService;
pub type GSocketAddress = _GSocketAddress;
pub type GSocketAddressEnumerator = _GSocketAddressEnumerator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSocketConnectable {
    _unused: [u8; 0],
}
pub type GSocketConnectable = _GSocketConnectable;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSrvTarget {
    _unused: [u8; 0],
}
pub type GSrvTarget = _GSrvTarget;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTask {
    _unused: [u8; 0],
}
pub type GTask = _GTask;
pub type GTcpConnection = _GTcpConnection;
pub type GTcpWrapperConnection = _GTcpWrapperConnection;
pub type GThreadedSocketService = _GThreadedSocketService;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDtlsConnection {
    _unused: [u8; 0],
}
pub type GDtlsConnection = _GDtlsConnection;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDtlsClientConnection {
    _unused: [u8; 0],
}
pub type GDtlsClientConnection = _GDtlsClientConnection;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDtlsServerConnection {
    _unused: [u8; 0],
}
pub type GDtlsServerConnection = _GDtlsServerConnection;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GThemedIcon {
    _unused: [u8; 0],
}
pub type GThemedIcon = _GThemedIcon;
pub type GTlsCertificate = _GTlsCertificate;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTlsClientConnection {
    _unused: [u8; 0],
}
pub type GTlsClientConnection = _GTlsClientConnection;
pub type GTlsConnection = _GTlsConnection;
pub type GTlsDatabase = _GTlsDatabase;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTlsFileDatabase {
    _unused: [u8; 0],
}
pub type GTlsFileDatabase = _GTlsFileDatabase;
pub type GTlsInteraction = _GTlsInteraction;
pub type GTlsPassword = _GTlsPassword;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTlsServerConnection {
    _unused: [u8; 0],
}
pub type GTlsServerConnection = _GTlsServerConnection;
pub type GVfs = _GVfs;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GProxyResolver {
    _unused: [u8; 0],
}
pub type GProxyResolver = _GProxyResolver;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GProxy {
    _unused: [u8; 0],
}
pub type GProxy = _GProxy;
pub type GProxyAddress = _GProxyAddress;
pub type GProxyAddressEnumerator = _GProxyAddressEnumerator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GVolume {
    _unused: [u8; 0],
}
pub type GVolume = _GVolume;
pub type GVolumeMonitor = _GVolumeMonitor;
pub type GAsyncReadyCallback = ::std::option::Option<
    unsafe extern "C" fn(source_object: *mut GObject, res: *mut GAsyncResult, user_data: gpointer),
>;
pub type GFileProgressCallback = ::std::option::Option<
    unsafe extern "C" fn(current_num_bytes: goffset, total_num_bytes: goffset, user_data: gpointer),
>;
pub type GFileReadMoreCallback = ::std::option::Option<
    unsafe extern "C" fn(
        file_contents: *const ::std::os::raw::c_char,
        file_size: goffset,
        callback_data: gpointer,
    ) -> gboolean,
>;
pub type GFileMeasureProgressCallback = ::std::option::Option<
    unsafe extern "C" fn(
        reporting: gboolean,
        current_size: guint64,
        num_dirs: guint64,
        num_files: guint64,
        user_data: gpointer,
    ),
>;
pub type GIOSchedulerJobFunc = ::std::option::Option<
    unsafe extern "C" fn(
        job: *mut GIOSchedulerJob,
        cancellable: *mut GCancellable,
        user_data: gpointer,
    ) -> gboolean,
>;
pub type GSimpleAsyncThreadFunc = ::std::option::Option<
    unsafe extern "C" fn(
        res: *mut GSimpleAsyncResult,
        object: *mut GObject,
        cancellable: *mut GCancellable,
    ),
>;
pub type GSocketSourceFunc = ::std::option::Option<
    unsafe extern "C" fn(
        socket: *mut GSocket,
        condition: GIOCondition,
        user_data: gpointer,
    ) -> gboolean,
>;
pub type GDatagramBasedSourceFunc = ::std::option::Option<
    unsafe extern "C" fn(
        datagram_based: *mut GDatagramBased,
        condition: GIOCondition,
        user_data: gpointer,
    ) -> gboolean,
>;
pub type GInputVector = _GInputVector;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GInputVector {
    pub buffer: gpointer,
    pub size: gsize,
}
#[test]
fn bindgen_test_layout__GInputVector() {
    assert_eq!(
        ::std::mem::size_of::<_GInputVector>(),
        16usize,
        concat!("Size of: ", stringify!(_GInputVector))
    );
    assert_eq!(
        ::std::mem::align_of::<_GInputVector>(),
        8usize,
        concat!("Alignment of ", stringify!(_GInputVector))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputVector>())).buffer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputVector),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputVector>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputVector),
            "::",
            stringify!(size)
        )
    );
}
pub type GInputMessage = _GInputMessage;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GInputMessage {
    pub address: *mut *mut GSocketAddress,
    pub vectors: *mut GInputVector,
    pub num_vectors: guint,
    pub bytes_received: gsize,
    pub flags: gint,
    pub control_messages: *mut *mut *mut GSocketControlMessage,
    pub num_control_messages: *mut guint,
}
#[test]
fn bindgen_test_layout__GInputMessage() {
    assert_eq!(
        ::std::mem::size_of::<_GInputMessage>(),
        56usize,
        concat!("Size of: ", stringify!(_GInputMessage))
    );
    assert_eq!(
        ::std::mem::align_of::<_GInputMessage>(),
        8usize,
        concat!("Alignment of ", stringify!(_GInputMessage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputMessage>())).address as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputMessage),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputMessage>())).vectors as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputMessage),
            "::",
            stringify!(vectors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputMessage>())).num_vectors as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputMessage),
            "::",
            stringify!(num_vectors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputMessage>())).bytes_received as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputMessage),
            "::",
            stringify!(bytes_received)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputMessage>())).flags as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputMessage),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputMessage>())).control_messages as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputMessage),
            "::",
            stringify!(control_messages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GInputMessage>())).num_control_messages as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputMessage),
            "::",
            stringify!(num_control_messages)
        )
    );
}
pub type GOutputVector = _GOutputVector;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GOutputVector {
    pub buffer: gconstpointer,
    pub size: gsize,
}
#[test]
fn bindgen_test_layout__GOutputVector() {
    assert_eq!(
        ::std::mem::size_of::<_GOutputVector>(),
        16usize,
        concat!("Size of: ", stringify!(_GOutputVector))
    );
    assert_eq!(
        ::std::mem::align_of::<_GOutputVector>(),
        8usize,
        concat!("Alignment of ", stringify!(_GOutputVector))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputVector>())).buffer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputVector),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputVector>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputVector),
            "::",
            stringify!(size)
        )
    );
}
pub type GOutputMessage = _GOutputMessage;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GOutputMessage {
    pub address: *mut GSocketAddress,
    pub vectors: *mut GOutputVector,
    pub num_vectors: guint,
    pub bytes_sent: guint,
    pub control_messages: *mut *mut GSocketControlMessage,
    pub num_control_messages: guint,
}
#[test]
fn bindgen_test_layout__GOutputMessage() {
    assert_eq!(
        ::std::mem::size_of::<_GOutputMessage>(),
        40usize,
        concat!("Size of: ", stringify!(_GOutputMessage))
    );
    assert_eq!(
        ::std::mem::align_of::<_GOutputMessage>(),
        8usize,
        concat!("Alignment of ", stringify!(_GOutputMessage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputMessage>())).address as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputMessage),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputMessage>())).vectors as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputMessage),
            "::",
            stringify!(vectors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputMessage>())).num_vectors as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputMessage),
            "::",
            stringify!(num_vectors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputMessage>())).bytes_sent as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputMessage),
            "::",
            stringify!(bytes_sent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputMessage>())).control_messages as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputMessage),
            "::",
            stringify!(control_messages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputMessage>())).num_control_messages as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputMessage),
            "::",
            stringify!(num_control_messages)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GCredentials {
    _unused: [u8; 0],
}
pub type GCredentials = _GCredentials;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GUnixCredentialsMessage {
    _unused: [u8; 0],
}
pub type GUnixCredentialsMessage = _GUnixCredentialsMessage;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GUnixFDList {
    _unused: [u8; 0],
}
pub type GUnixFDList = _GUnixFDList;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDBusMessage {
    _unused: [u8; 0],
}
pub type GDBusMessage = _GDBusMessage;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDBusConnection {
    _unused: [u8; 0],
}
pub type GDBusConnection = _GDBusConnection;
pub type GDBusProxy = _GDBusProxy;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDBusMethodInvocation {
    _unused: [u8; 0],
}
pub type GDBusMethodInvocation = _GDBusMethodInvocation;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDBusServer {
    _unused: [u8; 0],
}
pub type GDBusServer = _GDBusServer;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDBusAuthObserver {
    _unused: [u8; 0],
}
pub type GDBusAuthObserver = _GDBusAuthObserver;
pub type GDBusErrorEntry = _GDBusErrorEntry;
pub type GDBusInterfaceVTable = _GDBusInterfaceVTable;
pub type GDBusSubtreeVTable = _GDBusSubtreeVTable;
pub type GDBusAnnotationInfo = _GDBusAnnotationInfo;
pub type GDBusArgInfo = _GDBusArgInfo;
pub type GDBusMethodInfo = _GDBusMethodInfo;
pub type GDBusSignalInfo = _GDBusSignalInfo;
pub type GDBusPropertyInfo = _GDBusPropertyInfo;
pub type GDBusInterfaceInfo = _GDBusInterfaceInfo;
pub type GDBusNodeInfo = _GDBusNodeInfo;
pub type GCancellableSourceFunc = ::std::option::Option<
    unsafe extern "C" fn(cancellable: *mut GCancellable, user_data: gpointer) -> gboolean,
>;
pub type GPollableSourceFunc = ::std::option::Option<
    unsafe extern "C" fn(pollable_stream: *mut GObject, user_data: gpointer) -> gboolean,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDBusInterface {
    _unused: [u8; 0],
}
pub type GDBusInterface = _GDBusInterface;
pub type GDBusInterfaceSkeleton = _GDBusInterfaceSkeleton;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDBusObject {
    _unused: [u8; 0],
}
pub type GDBusObject = _GDBusObject;
pub type GDBusObjectSkeleton = _GDBusObjectSkeleton;
pub type GDBusObjectProxy = _GDBusObjectProxy;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDBusObjectManager {
    _unused: [u8; 0],
}
pub type GDBusObjectManager = _GDBusObjectManager;
pub type GDBusObjectManagerClient = _GDBusObjectManagerClient;
pub type GDBusObjectManagerServer = _GDBusObjectManagerServer;
pub type GDBusProxyTypeFunc = ::std::option::Option<
    unsafe extern "C" fn(
        manager: *mut GDBusObjectManagerClient,
        object_path: *const gchar,
        interface_name: *const gchar,
        user_data: gpointer,
    ) -> GType,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTestDBus {
    _unused: [u8; 0],
}
pub type GTestDBus = _GTestDBus;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSubprocess {
    _unused: [u8; 0],
}
pub type GSubprocess = _GSubprocess;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSubprocessLauncher {
    _unused: [u8; 0],
}
pub type GSubprocessLauncher = _GSubprocessLauncher;
pub type GActionInterface = _GActionInterface;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GActionInterface {
    pub g_iface: GTypeInterface,
    pub get_name: ::std::option::Option<unsafe extern "C" fn(action: *mut GAction) -> *const gchar>,
    pub get_parameter_type:
        ::std::option::Option<unsafe extern "C" fn(action: *mut GAction) -> *const GVariantType>,
    pub get_state_type:
        ::std::option::Option<unsafe extern "C" fn(action: *mut GAction) -> *const GVariantType>,
    pub get_state_hint:
        ::std::option::Option<unsafe extern "C" fn(action: *mut GAction) -> *mut GVariant>,
    pub get_enabled: ::std::option::Option<unsafe extern "C" fn(action: *mut GAction) -> gboolean>,
    pub get_state:
        ::std::option::Option<unsafe extern "C" fn(action: *mut GAction) -> *mut GVariant>,
    pub change_state:
        ::std::option::Option<unsafe extern "C" fn(action: *mut GAction, value: *mut GVariant)>,
    pub activate:
        ::std::option::Option<unsafe extern "C" fn(action: *mut GAction, parameter: *mut GVariant)>,
}
#[test]
fn bindgen_test_layout__GActionInterface() {
    assert_eq!(
        ::std::mem::size_of::<_GActionInterface>(),
        80usize,
        concat!("Size of: ", stringify!(_GActionInterface))
    );
    assert_eq!(
        ::std::mem::align_of::<_GActionInterface>(),
        8usize,
        concat!("Alignment of ", stringify!(_GActionInterface))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionInterface>())).g_iface as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionInterface),
            "::",
            stringify!(g_iface)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionInterface>())).get_name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionInterface),
            "::",
            stringify!(get_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionInterface>())).get_parameter_type as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionInterface),
            "::",
            stringify!(get_parameter_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionInterface>())).get_state_type as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionInterface),
            "::",
            stringify!(get_state_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionInterface>())).get_state_hint as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionInterface),
            "::",
            stringify!(get_state_hint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionInterface>())).get_enabled as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionInterface),
            "::",
            stringify!(get_enabled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionInterface>())).get_state as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionInterface),
            "::",
            stringify!(get_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionInterface>())).change_state as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionInterface),
            "::",
            stringify!(change_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionInterface>())).activate as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionInterface),
            "::",
            stringify!(activate)
        )
    );
}
extern "C" {
    pub fn g_action_get_type() -> GType;
}
extern "C" {
    pub fn g_action_get_name(action: *mut GAction) -> *const gchar;
}
extern "C" {
    pub fn g_action_get_parameter_type(action: *mut GAction) -> *const GVariantType;
}
extern "C" {
    pub fn g_action_get_state_type(action: *mut GAction) -> *const GVariantType;
}
extern "C" {
    pub fn g_action_get_state_hint(action: *mut GAction) -> *mut GVariant;
}
extern "C" {
    pub fn g_action_get_enabled(action: *mut GAction) -> gboolean;
}
extern "C" {
    pub fn g_action_get_state(action: *mut GAction) -> *mut GVariant;
}
extern "C" {
    pub fn g_action_change_state(action: *mut GAction, value: *mut GVariant);
}
extern "C" {
    pub fn g_action_activate(action: *mut GAction, parameter: *mut GVariant);
}
extern "C" {
    pub fn g_action_name_is_valid(action_name: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_action_parse_detailed_name(
        detailed_name: *const gchar,
        action_name: *mut *mut gchar,
        target_value: *mut *mut GVariant,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_action_print_detailed_name(
        action_name: *const gchar,
        target_value: *mut GVariant,
    ) -> *mut gchar;
}
pub type GActionGroupInterface = _GActionGroupInterface;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GActionGroupInterface {
    pub g_iface: GTypeInterface,
    pub has_action: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
        ) -> gboolean,
    >,
    pub list_actions: ::std::option::Option<
        unsafe extern "C" fn(action_group: *mut GActionGroup) -> *mut *mut gchar,
    >,
    pub get_action_enabled: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
        ) -> gboolean,
    >,
    pub get_action_parameter_type: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
        ) -> *const GVariantType,
    >,
    pub get_action_state_type: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
        ) -> *const GVariantType,
    >,
    pub get_action_state_hint: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
        ) -> *mut GVariant,
    >,
    pub get_action_state: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
        ) -> *mut GVariant,
    >,
    pub change_action_state: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
            value: *mut GVariant,
        ),
    >,
    pub activate_action: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
            parameter: *mut GVariant,
        ),
    >,
    pub action_added: ::std::option::Option<
        unsafe extern "C" fn(action_group: *mut GActionGroup, action_name: *const gchar),
    >,
    pub action_removed: ::std::option::Option<
        unsafe extern "C" fn(action_group: *mut GActionGroup, action_name: *const gchar),
    >,
    pub action_enabled_changed: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
            enabled: gboolean,
        ),
    >,
    pub action_state_changed: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
            state: *mut GVariant,
        ),
    >,
    pub query_action: ::std::option::Option<
        unsafe extern "C" fn(
            action_group: *mut GActionGroup,
            action_name: *const gchar,
            enabled: *mut gboolean,
            parameter_type: *mut *const GVariantType,
            state_type: *mut *const GVariantType,
            state_hint: *mut *mut GVariant,
            state: *mut *mut GVariant,
        ) -> gboolean,
    >,
}
#[test]
fn bindgen_test_layout__GActionGroupInterface() {
    assert_eq!(
        ::std::mem::size_of::<_GActionGroupInterface>(),
        128usize,
        concat!("Size of: ", stringify!(_GActionGroupInterface))
    );
    assert_eq!(
        ::std::mem::align_of::<_GActionGroupInterface>(),
        8usize,
        concat!("Alignment of ", stringify!(_GActionGroupInterface))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionGroupInterface>())).g_iface as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(g_iface)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).has_action as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(has_action)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).list_actions as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(list_actions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).get_action_enabled as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(get_action_enabled)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).get_action_parameter_type as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(get_action_parameter_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).get_action_state_type as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(get_action_state_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).get_action_state_hint as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(get_action_state_hint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).get_action_state as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(get_action_state)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).change_action_state as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(change_action_state)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).activate_action as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(activate_action)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).action_added as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(action_added)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).action_removed as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(action_removed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).action_enabled_changed as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(action_enabled_changed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).action_state_changed as *const _
                as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(action_state_changed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionGroupInterface>())).query_action as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionGroupInterface),
            "::",
            stringify!(query_action)
        )
    );
}
extern "C" {
    pub fn g_action_group_get_type() -> GType;
}
extern "C" {
    pub fn g_action_group_has_action(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
    ) -> gboolean;
}
extern "C" {
    pub fn g_action_group_list_actions(action_group: *mut GActionGroup) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_action_group_get_action_parameter_type(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
    ) -> *const GVariantType;
}
extern "C" {
    pub fn g_action_group_get_action_state_type(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
    ) -> *const GVariantType;
}
extern "C" {
    pub fn g_action_group_get_action_state_hint(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_action_group_get_action_enabled(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
    ) -> gboolean;
}
extern "C" {
    pub fn g_action_group_get_action_state(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_action_group_change_action_state(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
        value: *mut GVariant,
    );
}
extern "C" {
    pub fn g_action_group_activate_action(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
        parameter: *mut GVariant,
    );
}
extern "C" {
    pub fn g_action_group_action_added(action_group: *mut GActionGroup, action_name: *const gchar);
}
extern "C" {
    pub fn g_action_group_action_removed(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
    );
}
extern "C" {
    pub fn g_action_group_action_enabled_changed(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
        enabled: gboolean,
    );
}
extern "C" {
    pub fn g_action_group_action_state_changed(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
        state: *mut GVariant,
    );
}
extern "C" {
    pub fn g_action_group_query_action(
        action_group: *mut GActionGroup,
        action_name: *const gchar,
        enabled: *mut gboolean,
        parameter_type: *mut *const GVariantType,
        state_type: *mut *const GVariantType,
        state_hint: *mut *mut GVariant,
        state: *mut *mut GVariant,
    ) -> gboolean;
}
extern "C" {
    pub fn g_dbus_connection_export_action_group(
        connection: *mut GDBusConnection,
        object_path: *const gchar,
        action_group: *mut GActionGroup,
        error: *mut *mut GError,
    ) -> guint;
}
extern "C" {
    pub fn g_dbus_connection_unexport_action_group(
        connection: *mut GDBusConnection,
        export_id: guint,
    );
}
pub type GActionMapInterface = _GActionMapInterface;
pub type GActionEntry = _GActionEntry;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GActionMapInterface {
    pub g_iface: GTypeInterface,
    pub lookup_action: ::std::option::Option<
        unsafe extern "C" fn(
            action_map: *mut GActionMap,
            action_name: *const gchar,
        ) -> *mut GAction,
    >,
    pub add_action: ::std::option::Option<
        unsafe extern "C" fn(action_map: *mut GActionMap, action: *mut GAction),
    >,
    pub remove_action: ::std::option::Option<
        unsafe extern "C" fn(action_map: *mut GActionMap, action_name: *const gchar),
    >,
}
#[test]
fn bindgen_test_layout__GActionMapInterface() {
    assert_eq!(
        ::std::mem::size_of::<_GActionMapInterface>(),
        40usize,
        concat!("Size of: ", stringify!(_GActionMapInterface))
    );
    assert_eq!(
        ::std::mem::align_of::<_GActionMapInterface>(),
        8usize,
        concat!("Alignment of ", stringify!(_GActionMapInterface))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionMapInterface>())).g_iface as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionMapInterface),
            "::",
            stringify!(g_iface)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionMapInterface>())).lookup_action as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionMapInterface),
            "::",
            stringify!(lookup_action)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionMapInterface>())).add_action as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionMapInterface),
            "::",
            stringify!(add_action)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GActionMapInterface>())).remove_action as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionMapInterface),
            "::",
            stringify!(remove_action)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GActionEntry {
    pub name: *const gchar,
    pub activate: ::std::option::Option<
        unsafe extern "C" fn(
            action: *mut GSimpleAction,
            parameter: *mut GVariant,
            user_data: gpointer,
        ),
    >,
    pub parameter_type: *const gchar,
    pub state: *const gchar,
    pub change_state: ::std::option::Option<
        unsafe extern "C" fn(action: *mut GSimpleAction, value: *mut GVariant, user_data: gpointer),
    >,
    pub padding: [gsize; 3usize],
}
#[test]
fn bindgen_test_layout__GActionEntry() {
    assert_eq!(
        ::std::mem::size_of::<_GActionEntry>(),
        64usize,
        concat!("Size of: ", stringify!(_GActionEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<_GActionEntry>(),
        8usize,
        concat!("Alignment of ", stringify!(_GActionEntry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionEntry>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionEntry),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionEntry>())).activate as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionEntry),
            "::",
            stringify!(activate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionEntry>())).parameter_type as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionEntry),
            "::",
            stringify!(parameter_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionEntry>())).state as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionEntry),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionEntry>())).change_state as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionEntry),
            "::",
            stringify!(change_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GActionEntry>())).padding as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GActionEntry),
            "::",
            stringify!(padding)
        )
    );
}
extern "C" {
    pub fn g_action_map_get_type() -> GType;
}
extern "C" {
    pub fn g_action_map_lookup_action(
        action_map: *mut GActionMap,
        action_name: *const gchar,
    ) -> *mut GAction;
}
extern "C" {
    pub fn g_action_map_add_action(action_map: *mut GActionMap, action: *mut GAction);
}
extern "C" {
    pub fn g_action_map_remove_action(action_map: *mut GActionMap, action_name: *const gchar);
}
extern "C" {
    pub fn g_action_map_add_action_entries(
        action_map: *mut GActionMap,
        entries: *const GActionEntry,
        n_entries: gint,
        user_data: gpointer,
    );
}
pub type GAppLaunchContextClass = _GAppLaunchContextClass;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GAppLaunchContextPrivate {
    _unused: [u8; 0],
}
pub type GAppLaunchContextPrivate = _GAppLaunchContextPrivate;
pub type GAppInfoIface = _GAppInfoIface;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GAppInfoIface {
    pub g_iface: GTypeInterface,
    pub dup: ::std::option::Option<unsafe extern "C" fn(appinfo: *mut GAppInfo) -> *mut GAppInfo>,
    pub equal: ::std::option::Option<
        unsafe extern "C" fn(appinfo1: *mut GAppInfo, appinfo2: *mut GAppInfo) -> gboolean,
    >,
    pub get_id: ::std::option::Option<
        unsafe extern "C" fn(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char,
    >,
    pub get_name: ::std::option::Option<
        unsafe extern "C" fn(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char,
    >,
    pub get_description: ::std::option::Option<
        unsafe extern "C" fn(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char,
    >,
    pub get_executable: ::std::option::Option<
        unsafe extern "C" fn(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char,
    >,
    pub get_icon: ::std::option::Option<unsafe extern "C" fn(appinfo: *mut GAppInfo) -> *mut GIcon>,
    pub launch: ::std::option::Option<
        unsafe extern "C" fn(
            appinfo: *mut GAppInfo,
            files: *mut GList,
            context: *mut GAppLaunchContext,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub supports_uris:
        ::std::option::Option<unsafe extern "C" fn(appinfo: *mut GAppInfo) -> gboolean>,
    pub supports_files:
        ::std::option::Option<unsafe extern "C" fn(appinfo: *mut GAppInfo) -> gboolean>,
    pub launch_uris: ::std::option::Option<
        unsafe extern "C" fn(
            appinfo: *mut GAppInfo,
            uris: *mut GList,
            context: *mut GAppLaunchContext,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub should_show:
        ::std::option::Option<unsafe extern "C" fn(appinfo: *mut GAppInfo) -> gboolean>,
    pub set_as_default_for_type: ::std::option::Option<
        unsafe extern "C" fn(
            appinfo: *mut GAppInfo,
            content_type: *const ::std::os::raw::c_char,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub set_as_default_for_extension: ::std::option::Option<
        unsafe extern "C" fn(
            appinfo: *mut GAppInfo,
            extension: *const ::std::os::raw::c_char,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub add_supports_type: ::std::option::Option<
        unsafe extern "C" fn(
            appinfo: *mut GAppInfo,
            content_type: *const ::std::os::raw::c_char,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub can_remove_supports_type:
        ::std::option::Option<unsafe extern "C" fn(appinfo: *mut GAppInfo) -> gboolean>,
    pub remove_supports_type: ::std::option::Option<
        unsafe extern "C" fn(
            appinfo: *mut GAppInfo,
            content_type: *const ::std::os::raw::c_char,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub can_delete: ::std::option::Option<unsafe extern "C" fn(appinfo: *mut GAppInfo) -> gboolean>,
    pub do_delete: ::std::option::Option<unsafe extern "C" fn(appinfo: *mut GAppInfo) -> gboolean>,
    pub get_commandline: ::std::option::Option<
        unsafe extern "C" fn(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char,
    >,
    pub get_display_name: ::std::option::Option<
        unsafe extern "C" fn(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char,
    >,
    pub set_as_last_used_for_type: ::std::option::Option<
        unsafe extern "C" fn(
            appinfo: *mut GAppInfo,
            content_type: *const ::std::os::raw::c_char,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub get_supported_types: ::std::option::Option<
        unsafe extern "C" fn(appinfo: *mut GAppInfo) -> *mut *const ::std::os::raw::c_char,
    >,
    pub launch_uris_async: ::std::option::Option<
        unsafe extern "C" fn(
            appinfo: *mut GAppInfo,
            uris: *mut GList,
            context: *mut GAppLaunchContext,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub launch_uris_finish: ::std::option::Option<
        unsafe extern "C" fn(
            appinfo: *mut GAppInfo,
            result: *mut GAsyncResult,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
}
#[test]
fn bindgen_test_layout__GAppInfoIface() {
    assert_eq!(
        ::std::mem::size_of::<_GAppInfoIface>(),
        216usize,
        concat!("Size of: ", stringify!(_GAppInfoIface))
    );
    assert_eq!(
        ::std::mem::align_of::<_GAppInfoIface>(),
        8usize,
        concat!("Alignment of ", stringify!(_GAppInfoIface))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).g_iface as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(g_iface)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).dup as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(dup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).equal as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(equal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).get_id as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(get_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).get_name as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(get_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).get_description as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(get_description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).get_executable as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(get_executable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).get_icon as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(get_icon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).launch as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(launch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).supports_uris as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(supports_uris)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).supports_files as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(supports_files)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).launch_uris as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(launch_uris)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).should_show as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(should_show)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppInfoIface>())).set_as_default_for_type as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(set_as_default_for_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppInfoIface>())).set_as_default_for_extension as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(set_as_default_for_extension)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppInfoIface>())).add_supports_type as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(add_supports_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppInfoIface>())).can_remove_supports_type as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(can_remove_supports_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppInfoIface>())).remove_supports_type as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(remove_supports_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).can_delete as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(can_delete)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).do_delete as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(do_delete)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).get_commandline as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(get_commandline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppInfoIface>())).get_display_name as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(get_display_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppInfoIface>())).set_as_last_used_for_type as *const _
                as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(set_as_last_used_for_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppInfoIface>())).get_supported_types as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(get_supported_types)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppInfoIface>())).launch_uris_async as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(launch_uris_async)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppInfoIface>())).launch_uris_finish as *const _ as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppInfoIface),
            "::",
            stringify!(launch_uris_finish)
        )
    );
}
extern "C" {
    pub fn g_app_info_get_type() -> GType;
}
extern "C" {
    pub fn g_app_info_create_from_commandline(
        commandline: *const ::std::os::raw::c_char,
        application_name: *const ::std::os::raw::c_char,
        flags: GAppInfoCreateFlags,
        error: *mut *mut GError,
    ) -> *mut GAppInfo;
}
extern "C" {
    pub fn g_app_info_dup(appinfo: *mut GAppInfo) -> *mut GAppInfo;
}
extern "C" {
    pub fn g_app_info_equal(appinfo1: *mut GAppInfo, appinfo2: *mut GAppInfo) -> gboolean;
}
extern "C" {
    pub fn g_app_info_get_id(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_app_info_get_name(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_app_info_get_display_name(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_app_info_get_description(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_app_info_get_executable(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_app_info_get_commandline(appinfo: *mut GAppInfo) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_app_info_get_icon(appinfo: *mut GAppInfo) -> *mut GIcon;
}
extern "C" {
    pub fn g_app_info_launch(
        appinfo: *mut GAppInfo,
        files: *mut GList,
        context: *mut GAppLaunchContext,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_app_info_supports_uris(appinfo: *mut GAppInfo) -> gboolean;
}
extern "C" {
    pub fn g_app_info_supports_files(appinfo: *mut GAppInfo) -> gboolean;
}
extern "C" {
    pub fn g_app_info_launch_uris(
        appinfo: *mut GAppInfo,
        uris: *mut GList,
        context: *mut GAppLaunchContext,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_app_info_launch_uris_async(
        appinfo: *mut GAppInfo,
        uris: *mut GList,
        context: *mut GAppLaunchContext,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_app_info_launch_uris_finish(
        appinfo: *mut GAppInfo,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_app_info_should_show(appinfo: *mut GAppInfo) -> gboolean;
}
extern "C" {
    pub fn g_app_info_set_as_default_for_type(
        appinfo: *mut GAppInfo,
        content_type: *const ::std::os::raw::c_char,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_app_info_set_as_default_for_extension(
        appinfo: *mut GAppInfo,
        extension: *const ::std::os::raw::c_char,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_app_info_add_supports_type(
        appinfo: *mut GAppInfo,
        content_type: *const ::std::os::raw::c_char,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_app_info_can_remove_supports_type(appinfo: *mut GAppInfo) -> gboolean;
}
extern "C" {
    pub fn g_app_info_remove_supports_type(
        appinfo: *mut GAppInfo,
        content_type: *const ::std::os::raw::c_char,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_app_info_get_supported_types(
        appinfo: *mut GAppInfo,
    ) -> *mut *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_app_info_can_delete(appinfo: *mut GAppInfo) -> gboolean;
}
extern "C" {
    pub fn g_app_info_delete(appinfo: *mut GAppInfo) -> gboolean;
}
extern "C" {
    pub fn g_app_info_set_as_last_used_for_type(
        appinfo: *mut GAppInfo,
        content_type: *const ::std::os::raw::c_char,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_app_info_get_all() -> *mut GList;
}
extern "C" {
    pub fn g_app_info_get_all_for_type(content_type: *const ::std::os::raw::c_char) -> *mut GList;
}
extern "C" {
    pub fn g_app_info_get_recommended_for_type(content_type: *const gchar) -> *mut GList;
}
extern "C" {
    pub fn g_app_info_get_fallback_for_type(content_type: *const gchar) -> *mut GList;
}
extern "C" {
    pub fn g_app_info_reset_type_associations(content_type: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_app_info_get_default_for_type(
        content_type: *const ::std::os::raw::c_char,
        must_support_uris: gboolean,
    ) -> *mut GAppInfo;
}
extern "C" {
    pub fn g_app_info_get_default_for_uri_scheme(
        uri_scheme: *const ::std::os::raw::c_char,
    ) -> *mut GAppInfo;
}
extern "C" {
    pub fn g_app_info_launch_default_for_uri(
        uri: *const ::std::os::raw::c_char,
        context: *mut GAppLaunchContext,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_app_info_launch_default_for_uri_async(
        uri: *const ::std::os::raw::c_char,
        context: *mut GAppLaunchContext,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_app_info_launch_default_for_uri_finish(
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gboolean;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GAppLaunchContext {
    pub parent_instance: GObject,
    pub priv_: *mut GAppLaunchContextPrivate,
}
#[test]
fn bindgen_test_layout__GAppLaunchContext() {
    assert_eq!(
        ::std::mem::size_of::<_GAppLaunchContext>(),
        32usize,
        concat!("Size of: ", stringify!(_GAppLaunchContext))
    );
    assert_eq!(
        ::std::mem::align_of::<_GAppLaunchContext>(),
        8usize,
        concat!("Alignment of ", stringify!(_GAppLaunchContext))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppLaunchContext>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContext),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAppLaunchContext>())).priv_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContext),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GAppLaunchContextClass {
    pub parent_class: GObjectClass,
    pub get_display: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GAppLaunchContext,
            info: *mut GAppInfo,
            files: *mut GList,
        ) -> *mut ::std::os::raw::c_char,
    >,
    pub get_startup_notify_id: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GAppLaunchContext,
            info: *mut GAppInfo,
            files: *mut GList,
        ) -> *mut ::std::os::raw::c_char,
    >,
    pub launch_failed: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GAppLaunchContext,
            startup_notify_id: *const ::std::os::raw::c_char,
        ),
    >,
    pub launched: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GAppLaunchContext,
            info: *mut GAppInfo,
            platform_data: *mut GVariant,
        ),
    >,
    pub _g_reserved1: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved2: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved3: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved4: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GAppLaunchContextClass() {
    assert_eq!(
        ::std::mem::size_of::<_GAppLaunchContextClass>(),
        200usize,
        concat!("Size of: ", stringify!(_GAppLaunchContextClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GAppLaunchContextClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GAppLaunchContextClass))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppLaunchContextClass>())).parent_class as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContextClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppLaunchContextClass>())).get_display as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContextClass),
            "::",
            stringify!(get_display)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppLaunchContextClass>())).get_startup_notify_id as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContextClass),
            "::",
            stringify!(get_startup_notify_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppLaunchContextClass>())).launch_failed as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContextClass),
            "::",
            stringify!(launch_failed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppLaunchContextClass>())).launched as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContextClass),
            "::",
            stringify!(launched)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppLaunchContextClass>()))._g_reserved1 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContextClass),
            "::",
            stringify!(_g_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppLaunchContextClass>()))._g_reserved2 as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContextClass),
            "::",
            stringify!(_g_reserved2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppLaunchContextClass>()))._g_reserved3 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContextClass),
            "::",
            stringify!(_g_reserved3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAppLaunchContextClass>()))._g_reserved4 as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAppLaunchContextClass),
            "::",
            stringify!(_g_reserved4)
        )
    );
}
extern "C" {
    pub fn g_app_launch_context_get_type() -> GType;
}
extern "C" {
    pub fn g_app_launch_context_new() -> *mut GAppLaunchContext;
}
extern "C" {
    pub fn g_app_launch_context_setenv(
        context: *mut GAppLaunchContext,
        variable: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_app_launch_context_unsetenv(
        context: *mut GAppLaunchContext,
        variable: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_app_launch_context_get_environment(
        context: *mut GAppLaunchContext,
    ) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_app_launch_context_get_display(
        context: *mut GAppLaunchContext,
        info: *mut GAppInfo,
        files: *mut GList,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_app_launch_context_get_startup_notify_id(
        context: *mut GAppLaunchContext,
        info: *mut GAppInfo,
        files: *mut GList,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_app_launch_context_launch_failed(
        context: *mut GAppLaunchContext,
        startup_notify_id: *const ::std::os::raw::c_char,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GAppInfoMonitor {
    _unused: [u8; 0],
}
pub type GAppInfoMonitor = _GAppInfoMonitor;
extern "C" {
    pub fn g_app_info_monitor_get_type() -> GType;
}
extern "C" {
    pub fn g_app_info_monitor_get() -> *mut GAppInfoMonitor;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GApplicationPrivate {
    _unused: [u8; 0],
}
pub type GApplicationPrivate = _GApplicationPrivate;
pub type GApplicationClass = _GApplicationClass;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GApplication {
    pub parent_instance: GObject,
    pub priv_: *mut GApplicationPrivate,
}
#[test]
fn bindgen_test_layout__GApplication() {
    assert_eq!(
        ::std::mem::size_of::<_GApplication>(),
        32usize,
        concat!("Size of: ", stringify!(_GApplication))
    );
    assert_eq!(
        ::std::mem::align_of::<_GApplication>(),
        8usize,
        concat!("Alignment of ", stringify!(_GApplication))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplication>())).parent_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplication),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplication>())).priv_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplication),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GApplicationClass {
    pub parent_class: GObjectClass,
    pub startup: ::std::option::Option<unsafe extern "C" fn(application: *mut GApplication)>,
    pub activate: ::std::option::Option<unsafe extern "C" fn(application: *mut GApplication)>,
    pub open: ::std::option::Option<
        unsafe extern "C" fn(
            application: *mut GApplication,
            files: *mut *mut GFile,
            n_files: gint,
            hint: *const gchar,
        ),
    >,
    pub command_line: ::std::option::Option<
        unsafe extern "C" fn(
            application: *mut GApplication,
            command_line: *mut GApplicationCommandLine,
        ) -> ::std::os::raw::c_int,
    >,
    pub local_command_line: ::std::option::Option<
        unsafe extern "C" fn(
            application: *mut GApplication,
            arguments: *mut *mut *mut gchar,
            exit_status: *mut ::std::os::raw::c_int,
        ) -> gboolean,
    >,
    pub before_emit: ::std::option::Option<
        unsafe extern "C" fn(application: *mut GApplication, platform_data: *mut GVariant),
    >,
    pub after_emit: ::std::option::Option<
        unsafe extern "C" fn(application: *mut GApplication, platform_data: *mut GVariant),
    >,
    pub add_platform_data: ::std::option::Option<
        unsafe extern "C" fn(application: *mut GApplication, builder: *mut GVariantBuilder),
    >,
    pub quit_mainloop: ::std::option::Option<unsafe extern "C" fn(application: *mut GApplication)>,
    pub run_mainloop: ::std::option::Option<unsafe extern "C" fn(application: *mut GApplication)>,
    pub shutdown: ::std::option::Option<unsafe extern "C" fn(application: *mut GApplication)>,
    pub dbus_register: ::std::option::Option<
        unsafe extern "C" fn(
            application: *mut GApplication,
            connection: *mut GDBusConnection,
            object_path: *const gchar,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub dbus_unregister: ::std::option::Option<
        unsafe extern "C" fn(
            application: *mut GApplication,
            connection: *mut GDBusConnection,
            object_path: *const gchar,
        ),
    >,
    pub handle_local_options: ::std::option::Option<
        unsafe extern "C" fn(application: *mut GApplication, options: *mut GVariantDict) -> gint,
    >,
    pub name_lost:
        ::std::option::Option<unsafe extern "C" fn(application: *mut GApplication) -> gboolean>,
    pub padding: [gpointer; 7usize],
}
#[test]
fn bindgen_test_layout__GApplicationClass() {
    assert_eq!(
        ::std::mem::size_of::<_GApplicationClass>(),
        312usize,
        concat!("Size of: ", stringify!(_GApplicationClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GApplicationClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GApplicationClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).parent_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).startup as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(startup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).activate as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(activate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).open as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(open)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).command_line as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(command_line)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationClass>())).local_command_line as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(local_command_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).before_emit as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(before_emit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).after_emit as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(after_emit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationClass>())).add_platform_data as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(add_platform_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationClass>())).quit_mainloop as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(quit_mainloop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).run_mainloop as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(run_mainloop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).shutdown as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(shutdown)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationClass>())).dbus_register as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(dbus_register)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationClass>())).dbus_unregister as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(dbus_unregister)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationClass>())).handle_local_options as *const _ as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(handle_local_options)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).name_lost as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(name_lost)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationClass>())).padding as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationClass),
            "::",
            stringify!(padding)
        )
    );
}
extern "C" {
    pub fn g_application_get_type() -> GType;
}
extern "C" {
    pub fn g_application_id_is_valid(application_id: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_application_new(
        application_id: *const gchar,
        flags: GApplicationFlags,
    ) -> *mut GApplication;
}
extern "C" {
    pub fn g_application_get_application_id(application: *mut GApplication) -> *const gchar;
}
extern "C" {
    pub fn g_application_set_application_id(
        application: *mut GApplication,
        application_id: *const gchar,
    );
}
extern "C" {
    pub fn g_application_get_dbus_connection(
        application: *mut GApplication,
    ) -> *mut GDBusConnection;
}
extern "C" {
    pub fn g_application_get_dbus_object_path(application: *mut GApplication) -> *const gchar;
}
extern "C" {
    pub fn g_application_get_inactivity_timeout(application: *mut GApplication) -> guint;
}
extern "C" {
    pub fn g_application_set_inactivity_timeout(
        application: *mut GApplication,
        inactivity_timeout: guint,
    );
}
extern "C" {
    pub fn g_application_get_flags(application: *mut GApplication) -> GApplicationFlags;
}
extern "C" {
    pub fn g_application_set_flags(application: *mut GApplication, flags: GApplicationFlags);
}
extern "C" {
    pub fn g_application_get_resource_base_path(application: *mut GApplication) -> *const gchar;
}
extern "C" {
    pub fn g_application_set_resource_base_path(
        application: *mut GApplication,
        resource_path: *const gchar,
    );
}
extern "C" {
    pub fn g_application_set_action_group(
        application: *mut GApplication,
        action_group: *mut GActionGroup,
    );
}
extern "C" {
    pub fn g_application_add_main_option_entries(
        application: *mut GApplication,
        entries: *const GOptionEntry,
    );
}
extern "C" {
    pub fn g_application_add_main_option(
        application: *mut GApplication,
        long_name: *const ::std::os::raw::c_char,
        short_name: ::std::os::raw::c_char,
        flags: GOptionFlags,
        arg: GOptionArg,
        description: *const ::std::os::raw::c_char,
        arg_description: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_application_add_option_group(application: *mut GApplication, group: *mut GOptionGroup);
}
extern "C" {
    pub fn g_application_set_option_context_parameter_string(
        application: *mut GApplication,
        parameter_string: *const gchar,
    );
}
extern "C" {
    pub fn g_application_set_option_context_summary(
        application: *mut GApplication,
        summary: *const gchar,
    );
}
extern "C" {
    pub fn g_application_set_option_context_description(
        application: *mut GApplication,
        description: *const gchar,
    );
}
extern "C" {
    pub fn g_application_get_is_registered(application: *mut GApplication) -> gboolean;
}
extern "C" {
    pub fn g_application_get_is_remote(application: *mut GApplication) -> gboolean;
}
extern "C" {
    pub fn g_application_register(
        application: *mut GApplication,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_application_hold(application: *mut GApplication);
}
extern "C" {
    pub fn g_application_release(application: *mut GApplication);
}
extern "C" {
    pub fn g_application_activate(application: *mut GApplication);
}
extern "C" {
    pub fn g_application_open(
        application: *mut GApplication,
        files: *mut *mut GFile,
        n_files: gint,
        hint: *const gchar,
    );
}
extern "C" {
    pub fn g_application_run(
        application: *mut GApplication,
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_application_quit(application: *mut GApplication);
}
extern "C" {
    pub fn g_application_get_default() -> *mut GApplication;
}
extern "C" {
    pub fn g_application_set_default(application: *mut GApplication);
}
extern "C" {
    pub fn g_application_mark_busy(application: *mut GApplication);
}
extern "C" {
    pub fn g_application_unmark_busy(application: *mut GApplication);
}
extern "C" {
    pub fn g_application_get_is_busy(application: *mut GApplication) -> gboolean;
}
extern "C" {
    pub fn g_application_send_notification(
        application: *mut GApplication,
        id: *const gchar,
        notification: *mut GNotification,
    );
}
extern "C" {
    pub fn g_application_withdraw_notification(application: *mut GApplication, id: *const gchar);
}
extern "C" {
    pub fn g_application_bind_busy_property(
        application: *mut GApplication,
        object: gpointer,
        property: *const gchar,
    );
}
extern "C" {
    pub fn g_application_unbind_busy_property(
        application: *mut GApplication,
        object: gpointer,
        property: *const gchar,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GApplicationCommandLinePrivate {
    _unused: [u8; 0],
}
pub type GApplicationCommandLinePrivate = _GApplicationCommandLinePrivate;
pub type GApplicationCommandLineClass = _GApplicationCommandLineClass;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GApplicationCommandLine {
    pub parent_instance: GObject,
    pub priv_: *mut GApplicationCommandLinePrivate,
}
#[test]
fn bindgen_test_layout__GApplicationCommandLine() {
    assert_eq!(
        ::std::mem::size_of::<_GApplicationCommandLine>(),
        32usize,
        concat!("Size of: ", stringify!(_GApplicationCommandLine))
    );
    assert_eq!(
        ::std::mem::align_of::<_GApplicationCommandLine>(),
        8usize,
        concat!("Alignment of ", stringify!(_GApplicationCommandLine))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationCommandLine>())).parent_instance as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationCommandLine),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GApplicationCommandLine>())).priv_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationCommandLine),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GApplicationCommandLineClass {
    pub parent_class: GObjectClass,
    pub print_literal: ::std::option::Option<
        unsafe extern "C" fn(cmdline: *mut GApplicationCommandLine, message: *const gchar),
    >,
    pub printerr_literal: ::std::option::Option<
        unsafe extern "C" fn(cmdline: *mut GApplicationCommandLine, message: *const gchar),
    >,
    pub get_stdin: ::std::option::Option<
        unsafe extern "C" fn(cmdline: *mut GApplicationCommandLine) -> *mut GInputStream,
    >,
    pub padding: [gpointer; 11usize],
}
#[test]
fn bindgen_test_layout__GApplicationCommandLineClass() {
    assert_eq!(
        ::std::mem::size_of::<_GApplicationCommandLineClass>(),
        248usize,
        concat!("Size of: ", stringify!(_GApplicationCommandLineClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GApplicationCommandLineClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GApplicationCommandLineClass))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationCommandLineClass>())).parent_class as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationCommandLineClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationCommandLineClass>())).print_literal as *const _
                as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationCommandLineClass),
            "::",
            stringify!(print_literal)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationCommandLineClass>())).printerr_literal as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationCommandLineClass),
            "::",
            stringify!(printerr_literal)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationCommandLineClass>())).get_stdin as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationCommandLineClass),
            "::",
            stringify!(get_stdin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GApplicationCommandLineClass>())).padding as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_GApplicationCommandLineClass),
            "::",
            stringify!(padding)
        )
    );
}
extern "C" {
    pub fn g_application_command_line_get_type() -> GType;
}
extern "C" {
    pub fn g_application_command_line_get_arguments(
        cmdline: *mut GApplicationCommandLine,
        argc: *mut ::std::os::raw::c_int,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_application_command_line_get_options_dict(
        cmdline: *mut GApplicationCommandLine,
    ) -> *mut GVariantDict;
}
extern "C" {
    pub fn g_application_command_line_get_stdin(
        cmdline: *mut GApplicationCommandLine,
    ) -> *mut GInputStream;
}
extern "C" {
    pub fn g_application_command_line_get_environ(
        cmdline: *mut GApplicationCommandLine,
    ) -> *const *const gchar;
}
extern "C" {
    pub fn g_application_command_line_getenv(
        cmdline: *mut GApplicationCommandLine,
        name: *const gchar,
    ) -> *const gchar;
}
extern "C" {
    pub fn g_application_command_line_get_cwd(
        cmdline: *mut GApplicationCommandLine,
    ) -> *const gchar;
}
extern "C" {
    pub fn g_application_command_line_get_is_remote(
        cmdline: *mut GApplicationCommandLine,
    ) -> gboolean;
}
extern "C" {
    pub fn g_application_command_line_print(
        cmdline: *mut GApplicationCommandLine,
        format: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_application_command_line_printerr(
        cmdline: *mut GApplicationCommandLine,
        format: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_application_command_line_get_exit_status(
        cmdline: *mut GApplicationCommandLine,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_application_command_line_set_exit_status(
        cmdline: *mut GApplicationCommandLine,
        exit_status: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn g_application_command_line_get_platform_data(
        cmdline: *mut GApplicationCommandLine,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_application_command_line_create_file_for_arg(
        cmdline: *mut GApplicationCommandLine,
        arg: *const gchar,
    ) -> *mut GFile;
}
pub type GInitableIface = _GInitableIface;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GInitableIface {
    pub g_iface: GTypeInterface,
    pub init: ::std::option::Option<
        unsafe extern "C" fn(
            initable: *mut GInitable,
            cancellable: *mut GCancellable,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
}
#[test]
fn bindgen_test_layout__GInitableIface() {
    assert_eq!(
        ::std::mem::size_of::<_GInitableIface>(),
        24usize,
        concat!("Size of: ", stringify!(_GInitableIface))
    );
    assert_eq!(
        ::std::mem::align_of::<_GInitableIface>(),
        8usize,
        concat!("Alignment of ", stringify!(_GInitableIface))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInitableIface>())).g_iface as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInitableIface),
            "::",
            stringify!(g_iface)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInitableIface>())).init as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInitableIface),
            "::",
            stringify!(init)
        )
    );
}
extern "C" {
    pub fn g_initable_get_type() -> GType;
}
extern "C" {
    pub fn g_initable_init(
        initable: *mut GInitable,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_initable_new(
        object_type: GType,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
        first_property_name: *const gchar,
        ...
    ) -> gpointer;
}
extern "C" {
    pub fn g_initable_newv(
        object_type: GType,
        n_parameters: guint,
        parameters: *mut GParameter,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gpointer;
}
extern "C" {
    pub fn g_initable_new_valist(
        object_type: GType,
        first_property_name: *const gchar,
        var_args: *mut __va_list_tag,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> *mut GObject;
}
pub type GAsyncInitableIface = _GAsyncInitableIface;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GAsyncInitableIface {
    pub g_iface: GTypeInterface,
    pub init_async: ::std::option::Option<
        unsafe extern "C" fn(
            initable: *mut GAsyncInitable,
            io_priority: ::std::os::raw::c_int,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub init_finish: ::std::option::Option<
        unsafe extern "C" fn(
            initable: *mut GAsyncInitable,
            res: *mut GAsyncResult,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
}
#[test]
fn bindgen_test_layout__GAsyncInitableIface() {
    assert_eq!(
        ::std::mem::size_of::<_GAsyncInitableIface>(),
        32usize,
        concat!("Size of: ", stringify!(_GAsyncInitableIface))
    );
    assert_eq!(
        ::std::mem::align_of::<_GAsyncInitableIface>(),
        8usize,
        concat!("Alignment of ", stringify!(_GAsyncInitableIface))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAsyncInitableIface>())).g_iface as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAsyncInitableIface),
            "::",
            stringify!(g_iface)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAsyncInitableIface>())).init_async as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAsyncInitableIface),
            "::",
            stringify!(init_async)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAsyncInitableIface>())).init_finish as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAsyncInitableIface),
            "::",
            stringify!(init_finish)
        )
    );
}
extern "C" {
    pub fn g_async_initable_get_type() -> GType;
}
extern "C" {
    pub fn g_async_initable_init_async(
        initable: *mut GAsyncInitable,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_async_initable_init_finish(
        initable: *mut GAsyncInitable,
        res: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_async_initable_new_async(
        object_type: GType,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
        first_property_name: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_async_initable_newv_async(
        object_type: GType,
        n_parameters: guint,
        parameters: *mut GParameter,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_async_initable_new_valist_async(
        object_type: GType,
        first_property_name: *const gchar,
        var_args: *mut __va_list_tag,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_async_initable_new_finish(
        initable: *mut GAsyncInitable,
        res: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> *mut GObject;
}
pub type GAsyncResultIface = _GAsyncResultIface;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GAsyncResultIface {
    pub g_iface: GTypeInterface,
    pub get_user_data:
        ::std::option::Option<unsafe extern "C" fn(res: *mut GAsyncResult) -> gpointer>,
    pub get_source_object:
        ::std::option::Option<unsafe extern "C" fn(res: *mut GAsyncResult) -> *mut GObject>,
    pub is_tagged: ::std::option::Option<
        unsafe extern "C" fn(res: *mut GAsyncResult, source_tag: gpointer) -> gboolean,
    >,
}
#[test]
fn bindgen_test_layout__GAsyncResultIface() {
    assert_eq!(
        ::std::mem::size_of::<_GAsyncResultIface>(),
        40usize,
        concat!("Size of: ", stringify!(_GAsyncResultIface))
    );
    assert_eq!(
        ::std::mem::align_of::<_GAsyncResultIface>(),
        8usize,
        concat!("Alignment of ", stringify!(_GAsyncResultIface))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAsyncResultIface>())).g_iface as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAsyncResultIface),
            "::",
            stringify!(g_iface)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAsyncResultIface>())).get_user_data as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAsyncResultIface),
            "::",
            stringify!(get_user_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GAsyncResultIface>())).get_source_object as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAsyncResultIface),
            "::",
            stringify!(get_source_object)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GAsyncResultIface>())).is_tagged as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GAsyncResultIface),
            "::",
            stringify!(is_tagged)
        )
    );
}
extern "C" {
    pub fn g_async_result_get_type() -> GType;
}
extern "C" {
    pub fn g_async_result_get_user_data(res: *mut GAsyncResult) -> gpointer;
}
extern "C" {
    pub fn g_async_result_get_source_object(res: *mut GAsyncResult) -> *mut GObject;
}
extern "C" {
    pub fn g_async_result_legacy_propagate_error(
        res: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_async_result_is_tagged(res: *mut GAsyncResult, source_tag: gpointer) -> gboolean;
}
pub type GInputStreamClass = _GInputStreamClass;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GInputStreamPrivate {
    _unused: [u8; 0],
}
pub type GInputStreamPrivate = _GInputStreamPrivate;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GInputStream {
    pub parent_instance: GObject,
    pub priv_: *mut GInputStreamPrivate,
}
#[test]
fn bindgen_test_layout__GInputStream() {
    assert_eq!(
        ::std::mem::size_of::<_GInputStream>(),
        32usize,
        concat!("Size of: ", stringify!(_GInputStream))
    );
    assert_eq!(
        ::std::mem::align_of::<_GInputStream>(),
        8usize,
        concat!("Alignment of ", stringify!(_GInputStream))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStream>())).parent_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStream),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStream>())).priv_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStream),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GInputStreamClass {
    pub parent_class: GObjectClass,
    pub read_fn: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GInputStream,
            buffer: *mut ::std::os::raw::c_void,
            count: gsize,
            cancellable: *mut GCancellable,
            error: *mut *mut GError,
        ) -> gssize,
    >,
    pub skip: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GInputStream,
            count: gsize,
            cancellable: *mut GCancellable,
            error: *mut *mut GError,
        ) -> gssize,
    >,
    pub close_fn: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GInputStream,
            cancellable: *mut GCancellable,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub read_async: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GInputStream,
            buffer: *mut ::std::os::raw::c_void,
            count: gsize,
            io_priority: ::std::os::raw::c_int,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub read_finish: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GInputStream,
            result: *mut GAsyncResult,
            error: *mut *mut GError,
        ) -> gssize,
    >,
    pub skip_async: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GInputStream,
            count: gsize,
            io_priority: ::std::os::raw::c_int,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub skip_finish: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GInputStream,
            result: *mut GAsyncResult,
            error: *mut *mut GError,
        ) -> gssize,
    >,
    pub close_async: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GInputStream,
            io_priority: ::std::os::raw::c_int,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub close_finish: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GInputStream,
            result: *mut GAsyncResult,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub _g_reserved1: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved2: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved3: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved4: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved5: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GInputStreamClass() {
    assert_eq!(
        ::std::mem::size_of::<_GInputStreamClass>(),
        248usize,
        concat!("Size of: ", stringify!(_GInputStreamClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GInputStreamClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GInputStreamClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>())).parent_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>())).read_fn as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(read_fn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>())).skip as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(skip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>())).close_fn as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(close_fn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>())).read_async as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(read_async)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>())).read_finish as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(read_finish)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>())).skip_async as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(skip_async)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>())).skip_finish as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(skip_finish)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>())).close_async as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(close_async)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>())).close_finish as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(close_finish)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>()))._g_reserved1 as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(_g_reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>()))._g_reserved2 as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(_g_reserved2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>()))._g_reserved3 as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(_g_reserved3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>()))._g_reserved4 as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(_g_reserved4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GInputStreamClass>()))._g_reserved5 as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_GInputStreamClass),
            "::",
            stringify!(_g_reserved5)
        )
    );
}
extern "C" {
    pub fn g_input_stream_get_type() -> GType;
}
extern "C" {
    pub fn g_input_stream_read(
        stream: *mut GInputStream,
        buffer: *mut ::std::os::raw::c_void,
        count: gsize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_input_stream_read_all(
        stream: *mut GInputStream,
        buffer: *mut ::std::os::raw::c_void,
        count: gsize,
        bytes_read: *mut gsize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_input_stream_read_bytes(
        stream: *mut GInputStream,
        count: gsize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> *mut GBytes;
}
extern "C" {
    pub fn g_input_stream_skip(
        stream: *mut GInputStream,
        count: gsize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_input_stream_close(
        stream: *mut GInputStream,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_input_stream_read_async(
        stream: *mut GInputStream,
        buffer: *mut ::std::os::raw::c_void,
        count: gsize,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_input_stream_read_finish(
        stream: *mut GInputStream,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_input_stream_read_all_async(
        stream: *mut GInputStream,
        buffer: *mut ::std::os::raw::c_void,
        count: gsize,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_input_stream_read_all_finish(
        stream: *mut GInputStream,
        result: *mut GAsyncResult,
        bytes_read: *mut gsize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_input_stream_read_bytes_async(
        stream: *mut GInputStream,
        count: gsize,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_input_stream_read_bytes_finish(
        stream: *mut GInputStream,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> *mut GBytes;
}
extern "C" {
    pub fn g_input_stream_skip_async(
        stream: *mut GInputStream,
        count: gsize,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_input_stream_skip_finish(
        stream: *mut GInputStream,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_input_stream_close_async(
        stream: *mut GInputStream,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_input_stream_close_finish(
        stream: *mut GInputStream,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_input_stream_is_closed(stream: *mut GInputStream) -> gboolean;
}
extern "C" {
    pub fn g_input_stream_has_pending(stream: *mut GInputStream) -> gboolean;
}
extern "C" {
    pub fn g_input_stream_set_pending(
        stream: *mut GInputStream,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_input_stream_clear_pending(stream: *mut GInputStream);
}
pub type GFilterInputStreamClass = _GFilterInputStreamClass;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GFilterInputStream {
    pub parent_instance: GInputStream,
    pub base_stream: *mut GInputStream,
}
#[test]
fn bindgen_test_layout__GFilterInputStream() {
    assert_eq!(
        ::std::mem::size_of::<_GFilterInputStream>(),
        40usize,
        concat!("Size of: ", stringify!(_GFilterInputStream))
    );
    assert_eq!(
        ::std::mem::align_of::<_GFilterInputStream>(),
        8usize,
        concat!("Alignment of ", stringify!(_GFilterInputStream))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterInputStream>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterInputStream),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GFilterInputStream>())).base_stream as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterInputStream),
            "::",
            stringify!(base_stream)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GFilterInputStreamClass {
    pub parent_class: GInputStreamClass,
    pub _g_reserved1: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved2: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved3: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GFilterInputStreamClass() {
    assert_eq!(
        ::std::mem::size_of::<_GFilterInputStreamClass>(),
        272usize,
        concat!("Size of: ", stringify!(_GFilterInputStreamClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GFilterInputStreamClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GFilterInputStreamClass))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterInputStreamClass>())).parent_class as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterInputStreamClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterInputStreamClass>()))._g_reserved1 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterInputStreamClass),
            "::",
            stringify!(_g_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterInputStreamClass>()))._g_reserved2 as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterInputStreamClass),
            "::",
            stringify!(_g_reserved2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterInputStreamClass>()))._g_reserved3 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterInputStreamClass),
            "::",
            stringify!(_g_reserved3)
        )
    );
}
extern "C" {
    pub fn g_filter_input_stream_get_type() -> GType;
}
extern "C" {
    pub fn g_filter_input_stream_get_base_stream(
        stream: *mut GFilterInputStream,
    ) -> *mut GInputStream;
}
extern "C" {
    pub fn g_filter_input_stream_get_close_base_stream(stream: *mut GFilterInputStream)
        -> gboolean;
}
extern "C" {
    pub fn g_filter_input_stream_set_close_base_stream(
        stream: *mut GFilterInputStream,
        close_base: gboolean,
    );
}
pub type GBufferedInputStreamClass = _GBufferedInputStreamClass;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GBufferedInputStreamPrivate {
    _unused: [u8; 0],
}
pub type GBufferedInputStreamPrivate = _GBufferedInputStreamPrivate;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GBufferedInputStream {
    pub parent_instance: GFilterInputStream,
    pub priv_: *mut GBufferedInputStreamPrivate,
}
#[test]
fn bindgen_test_layout__GBufferedInputStream() {
    assert_eq!(
        ::std::mem::size_of::<_GBufferedInputStream>(),
        48usize,
        concat!("Size of: ", stringify!(_GBufferedInputStream))
    );
    assert_eq!(
        ::std::mem::align_of::<_GBufferedInputStream>(),
        8usize,
        concat!("Alignment of ", stringify!(_GBufferedInputStream))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedInputStream>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStream),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GBufferedInputStream>())).priv_ as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStream),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GBufferedInputStreamClass {
    pub parent_class: GFilterInputStreamClass,
    pub fill: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GBufferedInputStream,
            count: gssize,
            cancellable: *mut GCancellable,
            error: *mut *mut GError,
        ) -> gssize,
    >,
    pub fill_async: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GBufferedInputStream,
            count: gssize,
            io_priority: ::std::os::raw::c_int,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub fill_finish: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GBufferedInputStream,
            result: *mut GAsyncResult,
            error: *mut *mut GError,
        ) -> gssize,
    >,
    pub _g_reserved1: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved2: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved3: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved4: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved5: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GBufferedInputStreamClass() {
    assert_eq!(
        ::std::mem::size_of::<_GBufferedInputStreamClass>(),
        336usize,
        concat!("Size of: ", stringify!(_GBufferedInputStreamClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GBufferedInputStreamClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GBufferedInputStreamClass))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedInputStreamClass>())).parent_class as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStreamClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GBufferedInputStreamClass>())).fill as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStreamClass),
            "::",
            stringify!(fill)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedInputStreamClass>())).fill_async as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStreamClass),
            "::",
            stringify!(fill_async)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedInputStreamClass>())).fill_finish as *const _ as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStreamClass),
            "::",
            stringify!(fill_finish)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedInputStreamClass>()))._g_reserved1 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStreamClass),
            "::",
            stringify!(_g_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedInputStreamClass>()))._g_reserved2 as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStreamClass),
            "::",
            stringify!(_g_reserved2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedInputStreamClass>()))._g_reserved3 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStreamClass),
            "::",
            stringify!(_g_reserved3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedInputStreamClass>()))._g_reserved4 as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStreamClass),
            "::",
            stringify!(_g_reserved4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedInputStreamClass>()))._g_reserved5 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedInputStreamClass),
            "::",
            stringify!(_g_reserved5)
        )
    );
}
extern "C" {
    pub fn g_buffered_input_stream_get_type() -> GType;
}
extern "C" {
    pub fn g_buffered_input_stream_new(base_stream: *mut GInputStream) -> *mut GInputStream;
}
extern "C" {
    pub fn g_buffered_input_stream_new_sized(
        base_stream: *mut GInputStream,
        size: gsize,
    ) -> *mut GInputStream;
}
extern "C" {
    pub fn g_buffered_input_stream_get_buffer_size(stream: *mut GBufferedInputStream) -> gsize;
}
extern "C" {
    pub fn g_buffered_input_stream_set_buffer_size(stream: *mut GBufferedInputStream, size: gsize);
}
extern "C" {
    pub fn g_buffered_input_stream_get_available(stream: *mut GBufferedInputStream) -> gsize;
}
extern "C" {
    pub fn g_buffered_input_stream_peek(
        stream: *mut GBufferedInputStream,
        buffer: *mut ::std::os::raw::c_void,
        offset: gsize,
        count: gsize,
    ) -> gsize;
}
extern "C" {
    pub fn g_buffered_input_stream_peek_buffer(
        stream: *mut GBufferedInputStream,
        count: *mut gsize,
    ) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn g_buffered_input_stream_fill(
        stream: *mut GBufferedInputStream,
        count: gssize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_buffered_input_stream_fill_async(
        stream: *mut GBufferedInputStream,
        count: gssize,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_buffered_input_stream_fill_finish(
        stream: *mut GBufferedInputStream,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_buffered_input_stream_read_byte(
        stream: *mut GBufferedInputStream,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> ::std::os::raw::c_int;
}
pub type GOutputStreamClass = _GOutputStreamClass;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GOutputStreamPrivate {
    _unused: [u8; 0],
}
pub type GOutputStreamPrivate = _GOutputStreamPrivate;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GOutputStream {
    pub parent_instance: GObject,
    pub priv_: *mut GOutputStreamPrivate,
}
#[test]
fn bindgen_test_layout__GOutputStream() {
    assert_eq!(
        ::std::mem::size_of::<_GOutputStream>(),
        32usize,
        concat!("Size of: ", stringify!(_GOutputStream))
    );
    assert_eq!(
        ::std::mem::align_of::<_GOutputStream>(),
        8usize,
        concat!("Alignment of ", stringify!(_GOutputStream))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputStream>())).parent_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStream),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputStream>())).priv_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStream),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GOutputStreamClass {
    pub parent_class: GObjectClass,
    pub write_fn: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            buffer: *const ::std::os::raw::c_void,
            count: gsize,
            cancellable: *mut GCancellable,
            error: *mut *mut GError,
        ) -> gssize,
    >,
    pub splice: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            source: *mut GInputStream,
            flags: GOutputStreamSpliceFlags,
            cancellable: *mut GCancellable,
            error: *mut *mut GError,
        ) -> gssize,
    >,
    pub flush: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            cancellable: *mut GCancellable,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub close_fn: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            cancellable: *mut GCancellable,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub write_async: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            buffer: *const ::std::os::raw::c_void,
            count: gsize,
            io_priority: ::std::os::raw::c_int,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub write_finish: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            result: *mut GAsyncResult,
            error: *mut *mut GError,
        ) -> gssize,
    >,
    pub splice_async: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            source: *mut GInputStream,
            flags: GOutputStreamSpliceFlags,
            io_priority: ::std::os::raw::c_int,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub splice_finish: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            result: *mut GAsyncResult,
            error: *mut *mut GError,
        ) -> gssize,
    >,
    pub flush_async: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            io_priority: ::std::os::raw::c_int,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub flush_finish: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            result: *mut GAsyncResult,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub close_async: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            io_priority: ::std::os::raw::c_int,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub close_finish: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            result: *mut GAsyncResult,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub writev_fn: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            vectors: *const GOutputVector,
            n_vectors: gsize,
            bytes_written: *mut gsize,
            cancellable: *mut GCancellable,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub writev_async: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            vectors: *const GOutputVector,
            n_vectors: gsize,
            io_priority: ::std::os::raw::c_int,
            cancellable: *mut GCancellable,
            callback: GAsyncReadyCallback,
            user_data: gpointer,
        ),
    >,
    pub writev_finish: ::std::option::Option<
        unsafe extern "C" fn(
            stream: *mut GOutputStream,
            result: *mut GAsyncResult,
            bytes_written: *mut gsize,
            error: *mut *mut GError,
        ) -> gboolean,
    >,
    pub _g_reserved4: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved5: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved6: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved7: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved8: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GOutputStreamClass() {
    assert_eq!(
        ::std::mem::size_of::<_GOutputStreamClass>(),
        296usize,
        concat!("Size of: ", stringify!(_GOutputStreamClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GOutputStreamClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GOutputStreamClass))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>())).parent_class as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputStreamClass>())).write_fn as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(write_fn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputStreamClass>())).splice as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(splice)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputStreamClass>())).flush as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(flush)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputStreamClass>())).close_fn as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(close_fn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputStreamClass>())).write_async as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(write_async)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>())).write_finish as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(write_finish)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>())).splice_async as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(splice_async)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>())).splice_finish as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(splice_finish)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputStreamClass>())).flush_async as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(flush_async)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>())).flush_finish as *const _ as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(flush_finish)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputStreamClass>())).close_async as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(close_async)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>())).close_finish as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(close_finish)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GOutputStreamClass>())).writev_fn as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(writev_fn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>())).writev_async as *const _ as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(writev_async)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>())).writev_finish as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(writev_finish)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>()))._g_reserved4 as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(_g_reserved4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>()))._g_reserved5 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(_g_reserved5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>()))._g_reserved6 as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(_g_reserved6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>()))._g_reserved7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(_g_reserved7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GOutputStreamClass>()))._g_reserved8 as *const _ as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_GOutputStreamClass),
            "::",
            stringify!(_g_reserved8)
        )
    );
}
extern "C" {
    pub fn g_output_stream_get_type() -> GType;
}
extern "C" {
    pub fn g_output_stream_write(
        stream: *mut GOutputStream,
        buffer: *const ::std::os::raw::c_void,
        count: gsize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_output_stream_write_all(
        stream: *mut GOutputStream,
        buffer: *const ::std::os::raw::c_void,
        count: gsize,
        bytes_written: *mut gsize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_writev(
        stream: *mut GOutputStream,
        vectors: *const GOutputVector,
        n_vectors: gsize,
        bytes_written: *mut gsize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_writev_all(
        stream: *mut GOutputStream,
        vectors: *mut GOutputVector,
        n_vectors: gsize,
        bytes_written: *mut gsize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_printf(
        stream: *mut GOutputStream,
        bytes_written: *mut gsize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
        format: *const gchar,
        ...
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_vprintf(
        stream: *mut GOutputStream,
        bytes_written: *mut gsize,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
        format: *const gchar,
        args: *mut __va_list_tag,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_write_bytes(
        stream: *mut GOutputStream,
        bytes: *mut GBytes,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_output_stream_splice(
        stream: *mut GOutputStream,
        source: *mut GInputStream,
        flags: GOutputStreamSpliceFlags,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_output_stream_flush(
        stream: *mut GOutputStream,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_close(
        stream: *mut GOutputStream,
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_write_async(
        stream: *mut GOutputStream,
        buffer: *const ::std::os::raw::c_void,
        count: gsize,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_output_stream_write_finish(
        stream: *mut GOutputStream,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_output_stream_write_all_async(
        stream: *mut GOutputStream,
        buffer: *const ::std::os::raw::c_void,
        count: gsize,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_output_stream_write_all_finish(
        stream: *mut GOutputStream,
        result: *mut GAsyncResult,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_writev_async(
        stream: *mut GOutputStream,
        vectors: *const GOutputVector,
        n_vectors: gsize,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_output_stream_writev_finish(
        stream: *mut GOutputStream,
        result: *mut GAsyncResult,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_writev_all_async(
        stream: *mut GOutputStream,
        vectors: *mut GOutputVector,
        n_vectors: gsize,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_output_stream_writev_all_finish(
        stream: *mut GOutputStream,
        result: *mut GAsyncResult,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_write_bytes_async(
        stream: *mut GOutputStream,
        bytes: *mut GBytes,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_output_stream_write_bytes_finish(
        stream: *mut GOutputStream,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_output_stream_splice_async(
        stream: *mut GOutputStream,
        source: *mut GInputStream,
        flags: GOutputStreamSpliceFlags,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_output_stream_splice_finish(
        stream: *mut GOutputStream,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gssize;
}
extern "C" {
    pub fn g_output_stream_flush_async(
        stream: *mut GOutputStream,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_output_stream_flush_finish(
        stream: *mut GOutputStream,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_close_async(
        stream: *mut GOutputStream,
        io_priority: ::std::os::raw::c_int,
        cancellable: *mut GCancellable,
        callback: GAsyncReadyCallback,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_output_stream_close_finish(
        stream: *mut GOutputStream,
        result: *mut GAsyncResult,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_is_closed(stream: *mut GOutputStream) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_is_closing(stream: *mut GOutputStream) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_has_pending(stream: *mut GOutputStream) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_set_pending(
        stream: *mut GOutputStream,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_output_stream_clear_pending(stream: *mut GOutputStream);
}
pub type GFilterOutputStreamClass = _GFilterOutputStreamClass;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GFilterOutputStream {
    pub parent_instance: GOutputStream,
    pub base_stream: *mut GOutputStream,
}
#[test]
fn bindgen_test_layout__GFilterOutputStream() {
    assert_eq!(
        ::std::mem::size_of::<_GFilterOutputStream>(),
        40usize,
        concat!("Size of: ", stringify!(_GFilterOutputStream))
    );
    assert_eq!(
        ::std::mem::align_of::<_GFilterOutputStream>(),
        8usize,
        concat!("Alignment of ", stringify!(_GFilterOutputStream))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterOutputStream>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterOutputStream),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterOutputStream>())).base_stream as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterOutputStream),
            "::",
            stringify!(base_stream)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GFilterOutputStreamClass {
    pub parent_class: GOutputStreamClass,
    pub _g_reserved1: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved2: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved3: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GFilterOutputStreamClass() {
    assert_eq!(
        ::std::mem::size_of::<_GFilterOutputStreamClass>(),
        320usize,
        concat!("Size of: ", stringify!(_GFilterOutputStreamClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GFilterOutputStreamClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GFilterOutputStreamClass))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterOutputStreamClass>())).parent_class as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterOutputStreamClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterOutputStreamClass>()))._g_reserved1 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterOutputStreamClass),
            "::",
            stringify!(_g_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterOutputStreamClass>()))._g_reserved2 as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterOutputStreamClass),
            "::",
            stringify!(_g_reserved2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GFilterOutputStreamClass>()))._g_reserved3 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(_GFilterOutputStreamClass),
            "::",
            stringify!(_g_reserved3)
        )
    );
}
extern "C" {
    pub fn g_filter_output_stream_get_type() -> GType;
}
extern "C" {
    pub fn g_filter_output_stream_get_base_stream(
        stream: *mut GFilterOutputStream,
    ) -> *mut GOutputStream;
}
extern "C" {
    pub fn g_filter_output_stream_get_close_base_stream(
        stream: *mut GFilterOutputStream,
    ) -> gboolean;
}
extern "C" {
    pub fn g_filter_output_stream_set_close_base_stream(
        stream: *mut GFilterOutputStream,
        close_base: gboolean,
    );
}
pub type GBufferedOutputStreamClass = _GBufferedOutputStreamClass;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GBufferedOutputStreamPrivate {
    _unused: [u8; 0],
}
pub type GBufferedOutputStreamPrivate = _GBufferedOutputStreamPrivate;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GBufferedOutputStream {
    pub parent_instance: GFilterOutputStream,
    pub priv_: *mut GBufferedOutputStreamPrivate,
}
#[test]
fn bindgen_test_layout__GBufferedOutputStream() {
    assert_eq!(
        ::std::mem::size_of::<_GBufferedOutputStream>(),
        48usize,
        concat!("Size of: ", stringify!(_GBufferedOutputStream))
    );
    assert_eq!(
        ::std::mem::align_of::<_GBufferedOutputStream>(),
        8usize,
        concat!("Alignment of ", stringify!(_GBufferedOutputStream))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedOutputStream>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedOutputStream),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GBufferedOutputStream>())).priv_ as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedOutputStream),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GBufferedOutputStreamClass {
    pub parent_class: GFilterOutputStreamClass,
    pub _g_reserved1: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved2: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GBufferedOutputStreamClass() {
    assert_eq!(
        ::std::mem::size_of::<_GBufferedOutputStreamClass>(),
        336usize,
        concat!("Size of: ", stringify!(_GBufferedOutputStreamClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GBufferedOutputStreamClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GBufferedOutputStreamClass))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedOutputStreamClass>())).parent_class as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedOutputStreamClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedOutputStreamClass>()))._g_reserved1 as *const _
                as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedOutputStreamClass),
            "::",
            stringify!(_g_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GBufferedOutputStreamClass>()))._g_reserved2 as *const _
                as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(_GBufferedOutputStreamClass),
            "::",
            stringify!(_g_reserved2)
        )
    );
}
extern "C" {
    pub fn g_buffered_output_stream_get_type() -> GType;
}
extern "C" {
    pub fn g_buffered_output_stream_new(base_stream: *mut GOutputStream) -> *mut GOutputStream;
}
extern "C" {
    pub fn g_buffered_output_stream_new_sized(
        base_stream: *mut GOutputStream,
        size: gsize,
    ) -> *mut GOutputStream;
}
extern "C" {
    pub fn g_buffered_output_stream_get_buffer_size(stream: *mut GBufferedOutputStream) -> gsize;
}
extern "C" {
    pub fn g_buffered_output_stream_set_buffer_size(
        stream: *mut GBufferedOutputStream,
        size: gsize,
    );
}
extern "C" {
    pub fn g_buffered_output_stream_get_auto_grow(stream: *mut GBufferedOutputStream) -> gboolean;
}
extern "C" {
    pub fn g_buffered_output_stream_set_auto_grow(
        stream: *mut GBufferedOutputStream,
        auto_grow: gboolean,
    );
}
extern "C" {
    pub fn g_bytes_icon_get_type() -> GType;
}
extern "C" {
    pub fn g_bytes_icon_new(bytes: *mut GBytes) -> *mut GIcon;
}
extern "C" {
    pub fn g_bytes_icon_get_bytes(icon: *mut GBytesIcon) -> *mut GBytes;
}
pub type GCancellableClass = _GCancellableClass;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GCancellablePrivate {
    _unused: [u8; 0],
}
pub type GCancellablePrivate = _GCancellablePrivate;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GCancellable {
    pub parent_instance: GObject,
    pub priv_: *mut GCancellablePrivate,
}
#[test]
fn bindgen_test_layout__GCancellable() {
    assert_eq!(
        ::std::mem::size_of::<_GCancellable>(),
        32usize,
        concat!("Size of: ", stringify!(_GCancellable))
    );
    assert_eq!(
        ::std::mem::align_of::<_GCancellable>(),
        8usize,
        concat!("Alignment of ", stringify!(_GCancellable))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCancellable>())).parent_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCancellable),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCancellable>())).priv_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCancellable),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GCancellableClass {
    pub parent_class: GObjectClass,
    pub cancelled: ::std::option::Option<unsafe extern "C" fn(cancellable: *mut GCancellable)>,
    pub _g_reserved1: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved2: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved3: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved4: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved5: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GCancellableClass() {
    assert_eq!(
        ::std::mem::size_of::<_GCancellableClass>(),
        184usize,
        concat!("Size of: ", stringify!(_GCancellableClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GCancellableClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GCancellableClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCancellableClass>())).parent_class as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCancellableClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCancellableClass>())).cancelled as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCancellableClass),
            "::",
            stringify!(cancelled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCancellableClass>()))._g_reserved1 as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCancellableClass),
            "::",
            stringify!(_g_reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCancellableClass>()))._g_reserved2 as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCancellableClass),
            "::",
            stringify!(_g_reserved2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCancellableClass>()))._g_reserved3 as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCancellableClass),
            "::",
            stringify!(_g_reserved3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCancellableClass>()))._g_reserved4 as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCancellableClass),
            "::",
            stringify!(_g_reserved4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GCancellableClass>()))._g_reserved5 as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCancellableClass),
            "::",
            stringify!(_g_reserved5)
        )
    );
}
extern "C" {
    pub fn g_cancellable_get_type() -> GType;
}
extern "C" {
    pub fn g_cancellable_new() -> *mut GCancellable;
}
extern "C" {
    pub fn g_cancellable_is_cancelled(cancellable: *mut GCancellable) -> gboolean;
}
extern "C" {
    pub fn g_cancellable_set_error_if_cancelled(
        cancellable: *mut GCancellable,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_cancellable_get_fd(cancellable: *mut GCancellable) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_cancellable_make_pollfd(
        cancellable: *mut GCancellable,
        pollfd: *mut GPollFD,
    ) -> gboolean;
}
extern "C" {
    pub fn g_cancellable_release_fd(cancellable: *mut GCancellable);
}
extern "C" {
    pub fn g_cancellable_source_new(cancellable: *mut GCancellable) -> *mut GSource;
}
extern "C" {
    pub fn g_cancellable_get_current() -> *mut GCancellable;
}
extern "C" {
    pub fn g_cancellable_push_current(cancellable: *mut GCancellable);
}
extern "C" {
    pub fn g_cancellable_pop_current(cancellable: *mut GCancellable);
}
extern "C" {
    pub fn g_cancellable_reset(cancellable: *mut GCancellable);
}
extern "C" {
    pub fn g_cancellable_connect(
        cancellable: *mut GCancellable,
        callback: GCallback,
        data: gpointer,
        data_destroy_func: GDestroyNotify,
    ) -> gulong;
}
extern "C" {
    pub fn g_cancellable_disconnect(cancellable: *mut GCancellable, handler_id: gulong);
}
extern "C" {
    pub fn g_cancellable_cancel(cancellable: *mut GCancellable);
}
pub type GConverterIface = _GConverterIface;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GConverterIface {
    pub g_iface: GTypeInterface,
    pub convert: ::std::option::Option<
        unsafe extern "C" fn(
            converter: *mut GConverter,
            inbuf: *const ::std::os::raw::c_void,
            inbuf_size: gsize,
            outbuf: *mut ::std::os::raw::c_void,
            outbuf_size: gsize,
            flags: GConverterFlags,
            bytes_read: *mut gsize,
            bytes_written: *mut gsize,
            error: *mut *mut GError,
        ) -> GConverterResult,
    >,
    pub reset: ::std::option::Option<unsafe extern "C" fn(converter: *mut GConverter)>,
}
#[test]
fn bindgen_test_layout__GConverterIface() {
    assert_eq!(
        ::std::mem::size_of::<_GConverterIface>(),
        32usize,
        concat!("Size of: ", stringify!(_GConverterIface))
    );
    assert_eq!(
        ::std::mem::align_of::<_GConverterIface>(),
        8usize,
        concat!("Alignment of ", stringify!(_GConverterIface))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GConverterIface>())).g_iface as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterIface),
            "::",
            stringify!(g_iface)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GConverterIface>())).convert as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterIface),
            "::",
            stringify!(convert)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GConverterIface>())).reset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterIface),
            "::",
            stringify!(reset)
        )
    );
}
extern "C" {
    pub fn g_converter_get_type() -> GType;
}
extern "C" {
    pub fn g_converter_convert(
        converter: *mut GConverter,
        inbuf: *const ::std::os::raw::c_void,
        inbuf_size: gsize,
        outbuf: *mut ::std::os::raw::c_void,
        outbuf_size: gsize,
        flags: GConverterFlags,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> GConverterResult;
}
extern "C" {
    pub fn g_converter_reset(converter: *mut GConverter);
}
pub type GCharsetConverterClass = _GCharsetConverterClass;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GCharsetConverterClass {
    pub parent_class: GObjectClass,
}
#[test]
fn bindgen_test_layout__GCharsetConverterClass() {
    assert_eq!(
        ::std::mem::size_of::<_GCharsetConverterClass>(),
        136usize,
        concat!("Size of: ", stringify!(_GCharsetConverterClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GCharsetConverterClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GCharsetConverterClass))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GCharsetConverterClass>())).parent_class as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GCharsetConverterClass),
            "::",
            stringify!(parent_class)
        )
    );
}
extern "C" {
    pub fn g_charset_converter_get_type() -> GType;
}
extern "C" {
    pub fn g_charset_converter_new(
        to_charset: *const gchar,
        from_charset: *const gchar,
        error: *mut *mut GError,
    ) -> *mut GCharsetConverter;
}
extern "C" {
    pub fn g_charset_converter_set_use_fallback(
        converter: *mut GCharsetConverter,
        use_fallback: gboolean,
    );
}
extern "C" {
    pub fn g_charset_converter_get_use_fallback(converter: *mut GCharsetConverter) -> gboolean;
}
extern "C" {
    pub fn g_charset_converter_get_num_fallbacks(converter: *mut GCharsetConverter) -> guint;
}
extern "C" {
    pub fn g_content_type_equals(type1: *const gchar, type2: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_content_type_is_a(type_: *const gchar, supertype: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_content_type_is_mime_type(type_: *const gchar, mime_type: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_content_type_is_unknown(type_: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_content_type_get_description(type_: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_content_type_get_mime_type(type_: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_content_type_get_icon(type_: *const gchar) -> *mut GIcon;
}
extern "C" {
    pub fn g_content_type_get_symbolic_icon(type_: *const gchar) -> *mut GIcon;
}
extern "C" {
    pub fn g_content_type_get_generic_icon_name(type_: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_content_type_can_be_executable(type_: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_content_type_from_mime_type(mime_type: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_content_type_guess(
        filename: *const gchar,
        data: *const guchar,
        data_size: gsize,
        result_uncertain: *mut gboolean,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_content_type_guess_for_tree(root: *mut GFile) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_content_types_get_registered() -> *mut GList;
}
extern "C" {
    pub fn g_content_type_get_mime_dirs() -> *const *const gchar;
}
extern "C" {
    pub fn g_content_type_set_mime_dirs(dirs: *const *const gchar);
}
pub type GConverterInputStreamClass = _GConverterInputStreamClass;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GConverterInputStreamPrivate {
    _unused: [u8; 0],
}
pub type GConverterInputStreamPrivate = _GConverterInputStreamPrivate;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GConverterInputStream {
    pub parent_instance: GFilterInputStream,
    pub priv_: *mut GConverterInputStreamPrivate,
}
#[test]
fn bindgen_test_layout__GConverterInputStream() {
    assert_eq!(
        ::std::mem::size_of::<_GConverterInputStream>(),
        48usize,
        concat!("Size of: ", stringify!(_GConverterInputStream))
    );
    assert_eq!(
        ::std::mem::align_of::<_GConverterInputStream>(),
        8usize,
        concat!("Alignment of ", stringify!(_GConverterInputStream))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterInputStream>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterInputStream),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GConverterInputStream>())).priv_ as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterInputStream),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GConverterInputStreamClass {
    pub parent_class: GFilterInputStreamClass,
    pub _g_reserved1: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved2: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved3: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved4: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved5: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GConverterInputStreamClass() {
    assert_eq!(
        ::std::mem::size_of::<_GConverterInputStreamClass>(),
        312usize,
        concat!("Size of: ", stringify!(_GConverterInputStreamClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GConverterInputStreamClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GConverterInputStreamClass))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterInputStreamClass>())).parent_class as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterInputStreamClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterInputStreamClass>()))._g_reserved1 as *const _
                as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterInputStreamClass),
            "::",
            stringify!(_g_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterInputStreamClass>()))._g_reserved2 as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterInputStreamClass),
            "::",
            stringify!(_g_reserved2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterInputStreamClass>()))._g_reserved3 as *const _
                as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterInputStreamClass),
            "::",
            stringify!(_g_reserved3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterInputStreamClass>()))._g_reserved4 as *const _
                as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterInputStreamClass),
            "::",
            stringify!(_g_reserved4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterInputStreamClass>()))._g_reserved5 as *const _
                as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterInputStreamClass),
            "::",
            stringify!(_g_reserved5)
        )
    );
}
extern "C" {
    pub fn g_converter_input_stream_get_type() -> GType;
}
extern "C" {
    pub fn g_converter_input_stream_new(
        base_stream: *mut GInputStream,
        converter: *mut GConverter,
    ) -> *mut GInputStream;
}
extern "C" {
    pub fn g_converter_input_stream_get_converter(
        converter_stream: *mut GConverterInputStream,
    ) -> *mut GConverter;
}
pub type GConverterOutputStreamClass = _GConverterOutputStreamClass;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GConverterOutputStreamPrivate {
    _unused: [u8; 0],
}
pub type GConverterOutputStreamPrivate = _GConverterOutputStreamPrivate;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GConverterOutputStream {
    pub parent_instance: GFilterOutputStream,
    pub priv_: *mut GConverterOutputStreamPrivate,
}
#[test]
fn bindgen_test_layout__GConverterOutputStream() {
    assert_eq!(
        ::std::mem::size_of::<_GConverterOutputStream>(),
        48usize,
        concat!("Size of: ", stringify!(_GConverterOutputStream))
    );
    assert_eq!(
        ::std::mem::align_of::<_GConverterOutputStream>(),
        8usize,
        concat!("Alignment of ", stringify!(_GConverterOutputStream))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterOutputStream>())).parent_instance as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterOutputStream),
            "::",
            stringify!(parent_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GConverterOutputStream>())).priv_ as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterOutputStream),
            "::",
            stringify!(priv_)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _GConverterOutputStreamClass {
    pub parent_class: GFilterOutputStreamClass,
    pub _g_reserved1: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved2: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved3: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved4: ::std::option::Option<unsafe extern "C" fn()>,
    pub _g_reserved5: ::std::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout__GConverterOutputStreamClass() {
    assert_eq!(
        ::std::mem::size_of::<_GConverterOutputStreamClass>(),
        360usize,
        concat!("Size of: ", stringify!(_GConverterOutputStreamClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_GConverterOutputStreamClass>(),
        8usize,
        concat!("Alignment of ", stringify!(_GConverterOutputStreamClass))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterOutputStreamClass>())).parent_class as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterOutputStreamClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterOutputStreamClass>()))._g_reserved1 as *const _
                as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterOutputStreamClass),
            "::",
            stringify!(_g_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterOutputStreamClass>()))._g_reserved2 as *const _
                as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterOutputStreamClass),
            "::",
            stringify!(_g_reserved2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterOutputStreamClass>()))._g_reserved3 as *const _
                as usize
        },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterOutputStreamClass),
            "::",
            stringify!(_g_reserved3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterOutputStreamClass>()))._g_reserved4 as *const _
                as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterOutputStreamClass),
            "::",
            stringify!(_g_reserved4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_GConverterOutputStreamClass>()))._g_reserved5 as *const _
                as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(_GConverterOutputStreamClass),
            "::",
            stringify!(_g_reserved5)
        )
    );
}
extern "C" {
    pub fn g_converter_output_stream_get_type() -> GType;
}
extern "C" {
    pub fn g_converter_output_stream_new(
        base_stream: *mut GOutputStream,
        converter: *mut GConverter,
    ) -> *mut GOutputStream;
}
extern "C" {
    pub fn g_converter_output_stream_get_converter(
        converter_stream: *mut GConverterOutputStream,
    ) -> *mut GConverter;
}
extern "C" {
    pub fn pipe(arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pipe2(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn close(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn posix_close(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup2(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup3(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lseek(arg1: ::std::os::raw::c_int, arg2: off_t, arg3: ::std::os::raw::c_int) -> off_t;
}
extern "C" {
    pub fn fsync(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fdatasync(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn read(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn write(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pread(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
        arg4: off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pwrite(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: size_t,
        arg4: off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn chown(
        arg1: *const ::std::os::raw::c_char,
        arg2: uid_t,
        arg3: gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchown(arg1: ::std::os::raw::c_int, arg2: uid_t, arg3: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchown(
        arg1: *const ::std::os::raw::c_char,
        arg2: uid_t,
        arg3: gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchownat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: uid_t,
        arg4: gid_t,
        arg5: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn link(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn linkat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn symlink(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn symlinkat(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlink(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn readlinkat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_char,
        arg4: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn unlink(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlinkat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rmdir(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn truncate(arg1: *const ::std::os::raw::c_char, arg2: off_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftruncate(arg1: ::std::os::raw::c_int, arg2: off_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn access(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faccessat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chdir(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchdir(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getcwd(arg1: *mut ::std::os::raw::c_char, arg2: size_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn alarm(arg1: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn sleep(arg1: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn pause() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fork() -> pid_t;
}
extern "C" {
    pub fn execve(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execv(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execle(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execl(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execvp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execlp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fexecve(
        arg1: ::std::os::raw::c_int,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getpid() -> pid_t;
}
extern "C" {
    pub fn getppid() -> pid_t;
}
extern "C" {
    pub fn getpgrp() -> pid_t;
}
extern "C" {
    pub fn getpgid(arg1: pid_t) -> pid_t;
}
extern "C" {
    pub fn setpgid(arg1: pid_t, arg2: pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsid() -> pid_t;
}
extern "C" {
    pub fn getsid(arg1: pid_t) -> pid_t;
}
extern "C" {
    pub fn ttyname(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ttyname_r(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isatty(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcgetpgrp(arg1: ::std::os::raw::c_int) -> pid_t;
}
extern "C" {
    pub fn tcsetpgrp(arg1: ::std::os::raw::c_int, arg2: pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getuid() -> uid_t;
}
extern "C" {
    pub fn geteuid() -> uid_t;
}
extern "C" {
    pub fn getgid() -> gid_t;
}
extern "C" {
    pub fn getegid() -> gid_t;
}
extern "C" {
    pub fn getgroups(arg1: ::std::os::raw::c_int, arg2: *mut gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setuid(arg1: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seteuid(arg1: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setgid(arg1: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setegid(arg1: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getlogin() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getlogin_r(arg1: *mut ::std::os::raw::c_char, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostname(arg1: *mut ::std::os::raw::c_char, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getopt(
        arg1: ::std::os::raw::c_int,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optarg: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut optind: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut opterr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optopt: ::std::os::raw::c_int;
}
extern "C" {
    pub fn pathconf(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn fpathconf(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn sysconf(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn confstr(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn setreuid(arg1: uid_t, arg2: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setregid(arg1: gid_t, arg2: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lockf(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostid() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sync();
}
extern "C" {
    pub fn setpgrp() -> pid_t;
}
extern "C" {
    pub fn crypt(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn encrypt(arg1: *mut ::std::os::raw::c_char, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn swab(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ssize_t,
    );
}
extern "C" {
    pub fn usleep(arg1: ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ualarm(
        arg1: ::std::os::raw::c_uint,
        arg2: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn brk(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sbrk(arg1: isize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn vfork() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vhangup() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chroot(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpagesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdtablesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostname(arg1: *const ::std::os::raw::c_char, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdomainname(arg1: *mut ::std::os::raw::c_char, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setdomainname(
        arg1: *const ::std::os::raw::c_char,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setgroups(arg1: size_t, arg2: *const gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpass(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn daemon(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setusershell();
}
extern "C" {
    pub fn endusershell();
}
extern "C" {
    pub fn getusershell() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn acct(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn syscall(arg1: ::std::os::raw::c_long, ...) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn execvpe(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn issetugid() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getentropy(arg1: *mut ::std::os::raw::c_void, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optreset: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GCredentialsClass {
    _unused: [u8; 0],
}
pub type GCredentialsClass = _GCredentialsClass;
extern "C" {
    pub fn g_credentials_get_type() -> GType;
}
extern "C" {
    pub fn g_credentials_new() -> *mut GCredentials;
}
extern "C" {
    pub fn g_credentials_to_string(credentials: *mut GCredentials) -> *mut gchar;
}
extern "C" {
    pub fn g_credentials_get_native(
        credentials: *mut GCredentials,
        native_type: GCredentialsType,
    ) -> gpointer;
}
extern "C" {
    pub fn g_credentials_set_native(
        credentials: *mut GCredentials,
        native_type: GCredentialsType,
        native: gpointer,
    );
}
extern "C" {
    pub fn g_credentials_is_same_user(
        credentials: *mut GCredentials,
        other_credentials: *mut GCredentials,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_credentials_get_unix_pid(
        credentials: *mut GCredentials,
        error: *mut *mut GError,
    ) -> pid_t;
}
extern "C" {
    pub fn g_credentials_get_unix_user(
        credentials: *mut GCredentials,
        error: *mut *mut GError,
    ) -> uid_t;
}
extern "C" {
    pub fn g_credentials_set_unix_user(
        credentials: *mut GCredentials,
        uid: uid_t,
        error: *mut *mut GError,
    ) -> gboolean;
}
pub type GDatagramBasedInterface = _GDatagramBasedInterface;
#[repr(C)]
#[derive(Debug, Copy, Clone, Part