/* automatically generated by rust-bindgen 0.58.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const _STDIO_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 33;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __LDOUBLE_REDIRECTS_TO_FLOAT128_ABI: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const __GNUC_VA_LIST: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const __TIMESIZE: u32 = 64;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __KERNEL_OLD_TIMEVAL_MATCHES_TIMEVAL64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _____fpos_t_defined: u32 = 1;
pub const ____mbstate_t_defined: u32 = 1;
pub const _____fpos64_t_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const __FILE_defined: u32 = 1;
pub const __struct_FILE_defined: u32 = 1;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const EOF: i32 = -1;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const P_tmpdir: &'static [u8; 5usize] = b"/tmp\0";
pub const _BITS_STDIO_LIM_H: u32 = 1;
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const __HAVE_FLOAT128: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128: u32 = 0;
pub const __HAVE_FLOAT64X: u32 = 1;
pub const __HAVE_FLOAT64X_LONG_DOUBLE: u32 = 1;
pub const __HAVE_FLOAT16: u32 = 0;
pub const __HAVE_FLOAT32: u32 = 1;
pub const __HAVE_FLOAT64: u32 = 1;
pub const __HAVE_FLOAT32X: u32 = 1;
pub const __HAVE_FLOAT128X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT16: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128X: u32 = 0;
pub const __HAVE_FLOATN_NOT_TYPEDEF: u32 = 0;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const _BITS_ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const _BITS_ENDIANNESS_H: u32 = 1;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const _THREAD_MUTEX_INTERNAL_H: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const _ALLOCA_H: u32 = 1;
pub const _UNISTD_H: u32 = 1;
pub const _POSIX_VERSION: u32 = 200809;
pub const __POSIX2_THIS_VERSION: u32 = 200809;
pub const _POSIX2_VERSION: u32 = 200809;
pub const _POSIX2_C_VERSION: u32 = 200809;
pub const _POSIX2_C_BIND: u32 = 200809;
pub const _POSIX2_C_DEV: u32 = 200809;
pub const _POSIX2_SW_DEV: u32 = 200809;
pub const _POSIX2_LOCALEDEF: u32 = 200809;
pub const _XOPEN_VERSION: u32 = 700;
pub const _XOPEN_XCU_VERSION: u32 = 4;
pub const _XOPEN_XPG2: u32 = 1;
pub const _XOPEN_XPG3: u32 = 1;
pub const _XOPEN_XPG4: u32 = 1;
pub const _XOPEN_UNIX: u32 = 1;
pub const _XOPEN_ENH_I18N: u32 = 1;
pub const _XOPEN_LEGACY: u32 = 1;
pub const _BITS_POSIX_OPT_H: u32 = 1;
pub const _POSIX_JOB_CONTROL: u32 = 1;
pub const _POSIX_SAVED_IDS: u32 = 1;
pub const _POSIX_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_SYNCHRONIZED_IO: u32 = 200809;
pub const _POSIX_FSYNC: u32 = 200809;
pub const _POSIX_MAPPED_FILES: u32 = 200809;
pub const _POSIX_MEMLOCK: u32 = 200809;
pub const _POSIX_MEMLOCK_RANGE: u32 = 200809;
pub const _POSIX_MEMORY_PROTECTION: u32 = 200809;
pub const _POSIX_CHOWN_RESTRICTED: u32 = 0;
pub const _POSIX_VDISABLE: u8 = 0u8;
pub const _POSIX_NO_TRUNC: u32 = 1;
pub const _XOPEN_REALTIME: u32 = 1;
pub const _XOPEN_REALTIME_THREADS: u32 = 1;
pub const _XOPEN_SHM: u32 = 1;
pub const _POSIX_THREADS: u32 = 200809;
pub const _POSIX_REENTRANT_FUNCTIONS: u32 = 1;
pub const _POSIX_THREAD_SAFE_FUNCTIONS: u32 = 200809;
pub const _POSIX_THREAD_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKSIZE: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKADDR: u32 = 200809;
pub const _POSIX_THREAD_PRIO_INHERIT: u32 = 200809;
pub const _POSIX_THREAD_PRIO_PROTECT: u32 = 200809;
pub const _POSIX_THREAD_ROBUST_PRIO_INHERIT: u32 = 200809;
pub const _POSIX_THREAD_ROBUST_PRIO_PROTECT: i32 = -1;
pub const _POSIX_SEMAPHORES: u32 = 200809;
pub const _POSIX_REALTIME_SIGNALS: u32 = 200809;
pub const _POSIX_ASYNCHRONOUS_IO: u32 = 200809;
pub const _POSIX_ASYNC_IO: u32 = 1;
pub const _LFS_ASYNCHRONOUS_IO: u32 = 1;
pub const _POSIX_PRIORITIZED_IO: u32 = 200809;
pub const _LFS64_ASYNCHRONOUS_IO: u32 = 1;
pub const _LFS_LARGEFILE: u32 = 1;
pub const _LFS64_LARGEFILE: u32 = 1;
pub const _LFS64_STDIO: u32 = 1;
pub const _POSIX_SHARED_MEMORY_OBJECTS: u32 = 200809;
pub const _POSIX_CPUTIME: u32 = 0;
pub const _POSIX_THREAD_CPUTIME: u32 = 0;
pub const _POSIX_REGEXP: u32 = 1;
pub const _POSIX_READER_WRITER_LOCKS: u32 = 200809;
pub const _POSIX_SHELL: u32 = 1;
pub const _POSIX_TIMEOUTS: u32 = 200809;
pub const _POSIX_SPIN_LOCKS: u32 = 200809;
pub const _POSIX_SPAWN: u32 = 200809;
pub const _POSIX_TIMERS: u32 = 200809;
pub const _POSIX_BARRIERS: u32 = 200809;
pub const _POSIX_MESSAGE_PASSING: u32 = 200809;
pub const _POSIX_THREAD_PROCESS_SHARED: u32 = 200809;
pub const _POSIX_MONOTONIC_CLOCK: u32 = 0;
pub const _POSIX_CLOCK_SELECTION: u32 = 200809;
pub const _POSIX_ADVISORY_INFO: u32 = 200809;
pub const _POSIX_IPV6: u32 = 200809;
pub const _POSIX_RAW_SOCKETS: u32 = 200809;
pub const _POSIX2_CHAR_TERM: u32 = 200809;
pub const _POSIX_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_THREAD_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_TRACE: i32 = -1;
pub const _POSIX_TRACE_EVENT_FILTER: i32 = -1;
pub const _POSIX_TRACE_INHERIT: i32 = -1;
pub const _POSIX_TRACE_LOG: i32 = -1;
pub const _POSIX_TYPED_MEMORY_OBJECTS: i32 = -1;
pub const _POSIX_V7_LPBIG_OFFBIG: i32 = -1;
pub const _POSIX_V6_LPBIG_OFFBIG: i32 = -1;
pub const _XBS5_LPBIG_OFFBIG: i32 = -1;
pub const _POSIX_V7_LP64_OFF64: u32 = 1;
pub const _POSIX_V6_LP64_OFF64: u32 = 1;
pub const _XBS5_LP64_OFF64: u32 = 1;
pub const __ILP32_OFF32_CFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __ILP32_OFF32_LDFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __ILP32_OFFBIG_CFLAGS: &'static [u8; 48usize] =
    b"-m32 -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64\0";
pub const __ILP32_OFFBIG_LDFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __LP64_OFF64_CFLAGS: &'static [u8; 5usize] = b"-m64\0";
pub const __LP64_OFF64_LDFLAGS: &'static [u8; 5usize] = b"-m64\0";
pub const STDIN_FILENO: u32 = 0;
pub const STDOUT_FILENO: u32 = 1;
pub const STDERR_FILENO: u32 = 2;
pub const R_OK: u32 = 4;
pub const W_OK: u32 = 2;
pub const X_OK: u32 = 1;
pub const F_OK: u32 = 0;
pub const L_SET: u32 = 0;
pub const L_INCR: u32 = 1;
pub const L_XTND: u32 = 2;
pub const _GETOPT_POSIX_H: u32 = 1;
pub const _GETOPT_CORE_H: u32 = 1;
pub const F_ULOCK: u32 = 0;
pub const F_LOCK: u32 = 1;
pub const F_TLOCK: u32 = 2;
pub const F_TEST: u32 = 3;
pub const _FCNTL_H: u32 = 1;
pub const __O_LARGEFILE: u32 = 0;
pub const F_GETLK64: u32 = 5;
pub const F_SETLK64: u32 = 6;
pub const F_SETLKW64: u32 = 7;
pub const O_ACCMODE: u32 = 3;
pub const O_RDONLY: u32 = 0;
pub const O_WRONLY: u32 = 1;
pub const O_RDWR: u32 = 2;
pub const O_CREAT: u32 = 64;
pub const O_EXCL: u32 = 128;
pub const O_NOCTTY: u32 = 256;
pub const O_TRUNC: u32 = 512;
pub const O_APPEND: u32 = 1024;
pub const O_NONBLOCK: u32 = 2048;
pub const O_NDELAY: u32 = 2048;
pub const O_SYNC: u32 = 1052672;
pub const O_FSYNC: u32 = 1052672;
pub const O_ASYNC: u32 = 8192;
pub const __O_DIRECTORY: u32 = 65536;
pub const __O_NOFOLLOW: u32 = 131072;
pub const __O_CLOEXEC: u32 = 524288;
pub const __O_DIRECT: u32 = 16384;
pub const __O_NOATIME: u32 = 262144;
pub const __O_PATH: u32 = 2097152;
pub const __O_DSYNC: u32 = 4096;
pub const __O_TMPFILE: u32 = 4259840;
pub const F_GETLK: u32 = 5;
pub const F_SETLK: u32 = 6;
pub const F_SETLKW: u32 = 7;
pub const O_DIRECTORY: u32 = 65536;
pub const O_NOFOLLOW: u32 = 131072;
pub const O_CLOEXEC: u32 = 524288;
pub const O_DSYNC: u32 = 4096;
pub const O_RSYNC: u32 = 1052672;
pub const F_DUPFD: u32 = 0;
pub const F_GETFD: u32 = 1;
pub const F_SETFD: u32 = 2;
pub const F_GETFL: u32 = 3;
pub const F_SETFL: u32 = 4;
pub const __F_SETOWN: u32 = 8;
pub const __F_GETOWN: u32 = 9;
pub const F_SETOWN: u32 = 8;
pub const F_GETOWN: u32 = 9;
pub const __F_SETSIG: u32 = 10;
pub const __F_GETSIG: u32 = 11;
pub const __F_SETOWN_EX: u32 = 15;
pub const __F_GETOWN_EX: u32 = 16;
pub const F_DUPFD_CLOEXEC: u32 = 1030;
pub const FD_CLOEXEC: u32 = 1;
pub const F_RDLCK: u32 = 0;
pub const F_WRLCK: u32 = 1;
pub const F_UNLCK: u32 = 2;
pub const F_EXLCK: u32 = 4;
pub const F_SHLCK: u32 = 8;
pub const LOCK_SH: u32 = 1;
pub const LOCK_EX: u32 = 2;
pub const LOCK_NB: u32 = 4;
pub const LOCK_UN: u32 = 8;
pub const FAPPEND: u32 = 1024;
pub const FFSYNC: u32 = 1052672;
pub const FASYNC: u32 = 8192;
pub const FNONBLOCK: u32 = 2048;
pub const FNDELAY: u32 = 2048;
pub const __POSIX_FADV_DONTNEED: u32 = 4;
pub const __POSIX_FADV_NOREUSE: u32 = 5;
pub const POSIX_FADV_NORMAL: u32 = 0;
pub const POSIX_FADV_RANDOM: u32 = 1;
pub const POSIX_FADV_SEQUENTIAL: u32 = 2;
pub const POSIX_FADV_WILLNEED: u32 = 3;
pub const POSIX_FADV_DONTNEED: u32 = 4;
pub const POSIX_FADV_NOREUSE: u32 = 5;
pub const _BITS_STAT_H: u32 = 1;
pub const _BITS_STRUCT_STAT_H: u32 = 1;
pub const __S_IFMT: u32 = 61440;
pub const __S_IFDIR: u32 = 16384;
pub const __S_IFCHR: u32 = 8192;
pub const __S_IFBLK: u32 = 24576;
pub const __S_IFREG: u32 = 32768;
pub const __S_IFIFO: u32 = 4096;
pub const __S_IFLNK: u32 = 40960;
pub const __S_IFSOCK: u32 = 49152;
pub const __S_ISUID: u32 = 2048;
pub const __S_ISGID: u32 = 1024;
pub const __S_ISVTX: u32 = 512;
pub const __S_IREAD: u32 = 256;
pub const __S_IWRITE: u32 = 128;
pub const __S_IEXEC: u32 = 64;
pub const UTIME_NOW: u32 = 1073741823;
pub const UTIME_OMIT: u32 = 1073741822;
pub const S_IFMT: u32 = 61440;
pub const S_IFDIR: u32 = 16384;
pub const S_IFCHR: u32 = 8192;
pub const S_IFBLK: u32 = 24576;
pub const S_IFREG: u32 = 32768;
pub const S_IFIFO: u32 = 4096;
pub const S_IFLNK: u32 = 40960;
pub const S_IFSOCK: u32 = 49152;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXU: u32 = 448;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXG: u32 = 56;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const S_IRWXO: u32 = 7;
pub const AT_FDCWD: i32 = -100;
pub const AT_SYMLINK_NOFOLLOW: u32 = 256;
pub const AT_REMOVEDIR: u32 = 512;
pub const AT_SYMLINK_FOLLOW: u32 = 1024;
pub const AT_EACCESS: u32 = 512;
pub const _STDINT_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const VA_MAJOR_VERSION: u32 = 1;
pub const VA_MINOR_VERSION: u32 = 12;
pub const VA_MICRO_VERSION: u32 = 0;
pub const VA_VERSION_S: &'static [u8; 7usize] = b"1.12.0\0";
pub const VA_VERSION_HEX: u32 = 17563648;
pub const VA_STATUS_SUCCESS: u32 = 0;
pub const VA_STATUS_ERROR_OPERATION_FAILED: u32 = 1;
pub const VA_STATUS_ERROR_ALLOCATION_FAILED: u32 = 2;
pub const VA_STATUS_ERROR_INVALID_DISPLAY: u32 = 3;
pub const VA_STATUS_ERROR_INVALID_CONFIG: u32 = 4;
pub const VA_STATUS_ERROR_INVALID_CONTEXT: u32 = 5;
pub const VA_STATUS_ERROR_INVALID_SURFACE: u32 = 6;
pub const VA_STATUS_ERROR_INVALID_BUFFER: u32 = 7;
pub const VA_STATUS_ERROR_INVALID_IMAGE: u32 = 8;
pub const VA_STATUS_ERROR_INVALID_SUBPICTURE: u32 = 9;
pub const VA_STATUS_ERROR_ATTR_NOT_SUPPORTED: u32 = 10;
pub const VA_STATUS_ERROR_MAX_NUM_EXCEEDED: u32 = 11;
pub const VA_STATUS_ERROR_UNSUPPORTED_PROFILE: u32 = 12;
pub const VA_STATUS_ERROR_UNSUPPORTED_ENTRYPOINT: u32 = 13;
pub const VA_STATUS_ERROR_UNSUPPORTED_RT_FORMAT: u32 = 14;
pub const VA_STATUS_ERROR_UNSUPPORTED_BUFFERTYPE: u32 = 15;
pub const VA_STATUS_ERROR_SURFACE_BUSY: u32 = 16;
pub const VA_STATUS_ERROR_FLAG_NOT_SUPPORTED: u32 = 17;
pub const VA_STATUS_ERROR_INVALID_PARAMETER: u32 = 18;
pub const VA_STATUS_ERROR_RESOLUTION_NOT_SUPPORTED: u32 = 19;
pub const VA_STATUS_ERROR_UNIMPLEMENTED: u32 = 20;
pub const VA_STATUS_ERROR_SURFACE_IN_DISPLAYING: u32 = 21;
pub const VA_STATUS_ERROR_INVALID_IMAGE_FORMAT: u32 = 22;
pub const VA_STATUS_ERROR_DECODING_ERROR: u32 = 23;
pub const VA_STATUS_ERROR_ENCODING_ERROR: u32 = 24;
pub const VA_STATUS_ERROR_INVALID_VALUE: u32 = 25;
pub const VA_STATUS_ERROR_UNSUPPORTED_FILTER: u32 = 32;
pub const VA_STATUS_ERROR_INVALID_FILTER_CHAIN: u32 = 33;
pub const VA_STATUS_ERROR_HW_BUSY: u32 = 34;
pub const VA_STATUS_ERROR_UNSUPPORTED_MEMORY_TYPE: u32 = 36;
pub const VA_STATUS_ERROR_NOT_ENOUGH_BUFFER: u32 = 37;
pub const VA_STATUS_ERROR_TIMEDOUT: u32 = 38;
pub const VA_STATUS_ERROR_UNKNOWN: u32 = 4294967295;
pub const VA_FRAME_PICTURE: u32 = 0;
pub const VA_TOP_FIELD: u32 = 1;
pub const VA_BOTTOM_FIELD: u32 = 2;
pub const VA_TOP_FIELD_FIRST: u32 = 4;
pub const VA_BOTTOM_FIELD_FIRST: u32 = 8;
pub const VA_ENABLE_BLEND: u32 = 4;
pub const VA_CLEAR_DRAWABLE: u32 = 8;
pub const VA_SRC_COLOR_MASK: u32 = 240;
pub const VA_SRC_BT601: u32 = 16;
pub const VA_SRC_BT709: u32 = 32;
pub const VA_SRC_SMPTE_240: u32 = 64;
pub const VA_FILTER_SCALING_DEFAULT: u32 = 0;
pub const VA_FILTER_SCALING_FAST: u32 = 256;
pub const VA_FILTER_SCALING_HQ: u32 = 512;
pub const VA_FILTER_SCALING_NL_ANAMORPHIC: u32 = 768;
pub const VA_FILTER_SCALING_MASK: u32 = 3840;
pub const VA_FILTER_INTERPOLATION_DEFAULT: u32 = 0;
pub const VA_FILTER_INTERPOLATION_NEAREST_NEIGHBOR: u32 = 4096;
pub const VA_FILTER_INTERPOLATION_BILINEAR: u32 = 8192;
pub const VA_FILTER_INTERPOLATION_ADVANCED: u32 = 12288;
pub const VA_FILTER_INTERPOLATION_MASK: u32 = 61440;
pub const VA_PADDING_LOW: u32 = 4;
pub const VA_PADDING_MEDIUM: u32 = 8;
pub const VA_PADDING_HIGH: u32 = 16;
pub const VA_PADDING_LARGE: u32 = 32;
pub const VA_EXEC_SYNC: u32 = 0;
pub const VA_EXEC_ASYNC: u32 = 1;
pub const VA_EXEC_MODE_DEFAULT: u32 = 0;
pub const VA_EXEC_MODE_POWER_SAVING: u32 = 1;
pub const VA_EXEC_MODE_PERFORMANCE: u32 = 2;
pub const VA_FEATURE_NOT_SUPPORTED: u32 = 0;
pub const VA_FEATURE_SUPPORTED: u32 = 1;
pub const VA_FEATURE_REQUIRED: u32 = 2;
pub const VA_RT_FORMAT_YUV420: u32 = 1;
pub const VA_RT_FORMAT_YUV422: u32 = 2;
pub const VA_RT_FORMAT_YUV444: u32 = 4;
pub const VA_RT_FORMAT_YUV411: u32 = 8;
pub const VA_RT_FORMAT_YUV400: u32 = 16;
pub const VA_RT_FORMAT_YUV420_10: u32 = 256;
pub const VA_RT_FORMAT_YUV422_10: u32 = 512;
pub const VA_RT_FORMAT_YUV444_10: u32 = 1024;
pub const VA_RT_FORMAT_YUV420_12: u32 = 4096;
pub const VA_RT_FORMAT_YUV422_12: u32 = 8192;
pub const VA_RT_FORMAT_YUV444_12: u32 = 16384;
pub const VA_RT_FORMAT_RGB16: u32 = 65536;
pub const VA_RT_FORMAT_RGB32: u32 = 131072;
pub const VA_RT_FORMAT_RGBP: u32 = 1048576;
pub const VA_RT_FORMAT_RGB32_10: u32 = 2097152;
pub const VA_RT_FORMAT_PROTECTED: u32 = 2147483648;
pub const VA_RT_FORMAT_RGB32_10BPP: u32 = 2097152;
pub const VA_RT_FORMAT_YUV420_10BPP: u32 = 256;
pub const VA_RC_NONE: u32 = 1;
pub const VA_RC_CBR: u32 = 2;
pub const VA_RC_VBR: u32 = 4;
pub const VA_RC_VCM: u32 = 8;
pub const VA_RC_CQP: u32 = 16;
pub const VA_RC_VBR_CONSTRAINED: u32 = 32;
pub const VA_RC_ICQ: u32 = 64;
pub const VA_RC_MB: u32 = 128;
pub const VA_RC_CFS: u32 = 256;
pub const VA_RC_PARALLEL: u32 = 512;
pub const VA_RC_QVBR: u32 = 1024;
pub const VA_RC_AVBR: u32 = 2048;
pub const VA_RC_TCBRC: u32 = 4096;
pub const VA_DEC_SLICE_MODE_NORMAL: u32 = 1;
pub const VA_DEC_SLICE_MODE_BASE: u32 = 2;
pub const VA_DEC_PROCESSING_NONE: u32 = 0;
pub const VA_DEC_PROCESSING: u32 = 1;
pub const VA_ENC_PACKED_HEADER_NONE: u32 = 0;
pub const VA_ENC_PACKED_HEADER_SEQUENCE: u32 = 1;
pub const VA_ENC_PACKED_HEADER_PICTURE: u32 = 2;
pub const VA_ENC_PACKED_HEADER_SLICE: u32 = 4;
pub const VA_ENC_PACKED_HEADER_MISC: u32 = 8;
pub const VA_ENC_PACKED_HEADER_RAW_DATA: u32 = 16;
pub const VA_ENC_INTERLACED_NONE: u32 = 0;
pub const VA_ENC_INTERLACED_FRAME: u32 = 1;
pub const VA_ENC_INTERLACED_FIELD: u32 = 2;
pub const VA_ENC_INTERLACED_MBAFF: u32 = 4;
pub const VA_ENC_INTERLACED_PAFF: u32 = 8;
pub const VA_ENC_SLICE_STRUCTURE_POWER_OF_TWO_ROWS: u32 = 1;
pub const VA_ENC_SLICE_STRUCTURE_ARBITRARY_MACROBLOCKS: u32 = 2;
pub const VA_ENC_SLICE_STRUCTURE_EQUAL_ROWS: u32 = 4;
pub const VA_ENC_SLICE_STRUCTURE_MAX_SLICE_SIZE: u32 = 8;
pub const VA_ENC_SLICE_STRUCTURE_ARBITRARY_ROWS: u32 = 16;
pub const VA_ENC_SLICE_STRUCTURE_EQUAL_MULTI_ROWS: u32 = 32;
pub const VA_ENC_QUANTIZATION_NONE: u32 = 0;
pub const VA_ENC_QUANTIZATION_TRELLIS_SUPPORTED: u32 = 1;
pub const VA_PREDICTION_DIRECTION_PREVIOUS: u32 = 1;
pub const VA_PREDICTION_DIRECTION_FUTURE: u32 = 2;
pub const VA_PREDICTION_DIRECTION_BI_NOT_EMPTY: u32 = 4;
pub const VA_ENC_INTRA_REFRESH_NONE: u32 = 0;
pub const VA_ENC_INTRA_REFRESH_ROLLING_COLUMN: u32 = 1;
pub const VA_ENC_INTRA_REFRESH_ROLLING_ROW: u32 = 2;
pub const VA_ENC_INTRA_REFRESH_ADAPTIVE: u32 = 16;
pub const VA_ENC_INTRA_REFRESH_CYCLIC: u32 = 32;
pub const VA_ENC_INTRA_REFRESH_P_FRAME: u32 = 65536;
pub const VA_ENC_INTRA_REFRESH_B_FRAME: u32 = 131072;
pub const VA_ENC_INTRA_REFRESH_MULTI_REF: u32 = 262144;
pub const VA_PC_CIPHER_AES: u32 = 1;
pub const VA_PC_BLOCK_SIZE_128: u32 = 1;
pub const VA_PC_BLOCK_SIZE_192: u32 = 2;
pub const VA_PC_BLOCK_SIZE_256: u32 = 4;
pub const VA_PC_CIPHER_MODE_ECB: u32 = 1;
pub const VA_PC_CIPHER_MODE_CBC: u32 = 2;
pub const VA_PC_CIPHER_MODE_CTR: u32 = 4;
pub const VA_PC_SAMPLE_TYPE_FULLSAMPLE: u32 = 1;
pub const VA_PC_SAMPLE_TYPE_SUBSAMPLE: u32 = 2;
pub const VA_PC_USAGE_DEFAULT: u32 = 0;
pub const VA_PC_USAGE_WIDEVINE: u32 = 1;
pub const VA_PROCESSING_RATE_NONE: u32 = 0;
pub const VA_PROCESSING_RATE_ENCODE: u32 = 1;
pub const VA_PROCESSING_RATE_DECODE: u32 = 2;
pub const VA_ATTRIB_NOT_SUPPORTED: u32 = 2147483648;
pub const VA_INVALID_ID: u32 = 4294967295;
pub const VA_INVALID_SURFACE: u32 = 4294967295;
pub const VA_SURFACE_ATTRIB_NOT_SUPPORTED: u32 = 0;
pub const VA_SURFACE_ATTRIB_GETTABLE: u32 = 1;
pub const VA_SURFACE_ATTRIB_SETTABLE: u32 = 2;
pub const VA_SURFACE_ATTRIB_MEM_TYPE_VA: u32 = 1;
pub const VA_SURFACE_ATTRIB_MEM_TYPE_V4L2: u32 = 2;
pub const VA_SURFACE_ATTRIB_MEM_TYPE_USER_PTR: u32 = 4;
pub const VA_SURFACE_EXTBUF_DESC_ENABLE_TILING: u32 = 1;
pub const VA_SURFACE_EXTBUF_DESC_CACHED: u32 = 2;
pub const VA_SURFACE_EXTBUF_DESC_UNCACHED: u32 = 4;
pub const VA_SURFACE_EXTBUF_DESC_WC: u32 = 8;
pub const VA_SURFACE_EXTBUF_DESC_PROTECTED: u32 = 2147483648;
pub const VA_SURFACE_ATTRIB_USAGE_HINT_GENERIC: u32 = 0;
pub const VA_SURFACE_ATTRIB_USAGE_HINT_DECODER: u32 = 1;
pub const VA_SURFACE_ATTRIB_USAGE_HINT_ENCODER: u32 = 2;
pub const VA_SURFACE_ATTRIB_USAGE_HINT_VPP_READ: u32 = 4;
pub const VA_SURFACE_ATTRIB_USAGE_HINT_VPP_WRITE: u32 = 8;
pub const VA_SURFACE_ATTRIB_USAGE_HINT_DISPLAY: u32 = 16;
pub const VA_SURFACE_ATTRIB_USAGE_HINT_EXPORT: u32 = 32;
pub const VA_PROGRESSIVE: u32 = 1;
pub const VA_ENCRYPTION_TYPE_FULLSAMPLE_CTR: u32 = 1;
pub const VA_ENCRYPTION_TYPE_FULLSAMPLE_CBC: u32 = 2;
pub const VA_ENCRYPTION_TYPE_SUBSAMPLE_CTR: u32 = 4;
pub const VA_ENCRYPTION_TYPE_SUBSAMPLE_CBC: u32 = 8;
pub const VA_SLICE_DATA_FLAG_ALL: u32 = 0;
pub const VA_SLICE_DATA_FLAG_BEGIN: u32 = 1;
pub const VA_SLICE_DATA_FLAG_MIDDLE: u32 = 2;
pub const VA_SLICE_DATA_FLAG_END: u32 = 4;
pub const VA_MB_TYPE_MOTION_FORWARD: u32 = 2;
pub const VA_MB_TYPE_MOTION_BACKWARD: u32 = 4;
pub const VA_MB_TYPE_MOTION_PATTERN: u32 = 8;
pub const VA_MB_TYPE_MOTION_INTRA: u32 = 16;
pub const VA_PICTURE_H264_INVALID: u32 = 1;
pub const VA_PICTURE_H264_TOP_FIELD: u32 = 2;
pub const VA_PICTURE_H264_BOTTOM_FIELD: u32 = 4;
pub const VA_PICTURE_H264_SHORT_TERM_REFERENCE: u32 = 8;
pub const VA_PICTURE_H264_LONG_TERM_REFERENCE: u32 = 16;
pub const VA_CODED_BUF_STATUS_PICTURE_AVE_QP_MASK: u32 = 255;
pub const VA_CODED_BUF_STATUS_LARGE_SLICE_MASK: u32 = 256;
pub const VA_CODED_BUF_STATUS_SLICE_OVERFLOW_MASK: u32 = 512;
pub const VA_CODED_BUF_STATUS_BITRATE_OVERFLOW: u32 = 1024;
pub const VA_CODED_BUF_STATUS_BITRATE_HIGH: u32 = 2048;
pub const VA_CODED_BUF_STATUS_FRAME_SIZE_OVERFLOW: u32 = 4096;
pub const VA_CODED_BUF_STATUS_BAD_BITSTREAM: u32 = 32768;
pub const VA_CODED_BUF_STATUS_AIR_MB_OVER_THRESHOLD: u32 = 16711680;
pub const VA_CODED_BUF_STATUS_NUMBER_PASSES_MASK: u32 = 251658240;
pub const VA_CODED_BUF_STATUS_SINGLE_NALU: u32 = 268435456;
pub const VA_EXPORT_SURFACE_READ_ONLY: u32 = 1;
pub const VA_EXPORT_SURFACE_WRITE_ONLY: u32 = 2;
pub const VA_EXPORT_SURFACE_READ_WRITE: u32 = 3;
pub const VA_EXPORT_SURFACE_SEPARATE_LAYERS: u32 = 4;
pub const VA_EXPORT_SURFACE_COMPOSED_LAYERS: u32 = 8;
pub const VA_TIMEOUT_INFINITE: i32 = -1;
pub const VA_FOURCC_NV12: u32 = 842094158;
pub const VA_FOURCC_NV21: u32 = 825382478;
pub const VA_FOURCC_AI44: u32 = 875839817;
pub const VA_FOURCC_RGBA: u32 = 1094862674;
pub const VA_FOURCC_RGBX: u32 = 1480738642;
pub const VA_FOURCC_BGRA: u32 = 1095911234;
pub const VA_FOURCC_BGRX: u32 = 1481787202;
pub const VA_FOURCC_ARGB: u32 = 1111970369;
pub const VA_FOURCC_XRGB: u32 = 1111970392;
pub const VA_FOURCC_ABGR: u32 = 1380401729;
pub const VA_FOURCC_XBGR: u32 = 1380401752;
pub const VA_FOURCC_UYVY: u32 = 1498831189;
pub const VA_FOURCC_YUY2: u32 = 844715353;
pub const VA_FOURCC_AYUV: u32 = 1448433985;
pub const VA_FOURCC_NV11: u32 = 825316942;
pub const VA_FOURCC_YV12: u32 = 842094169;
pub const VA_FOURCC_P208: u32 = 942682704;
pub const VA_FOURCC_I420: u32 = 808596553;
pub const VA_FOURCC_YV24: u32 = 875714137;
pub const VA_FOURCC_YV32: u32 = 842225241;
pub const VA_FOURCC_Y800: u32 = 808466521;
pub const VA_FOURCC_IMC3: u32 = 860048713;
pub const VA_FOURCC_411P: u32 = 1345401140;
pub const VA_FOURCC_411R: u32 = 1378955572;
pub const VA_FOURCC_422H: u32 = 1211249204;
pub const VA_FOURCC_422V: u32 = 1446130228;
pub const VA_FOURCC_444P: u32 = 1345598516;
pub const VA_FOURCC_RGBP: u32 = 1346520914;
pub const VA_FOURCC_BGRP: u32 = 1347569474;
pub const VA_FOURCC_RGB565: u32 = 909199186;
pub const VA_FOURCC_BGR565: u32 = 909199170;
pub const VA_FOURCC_Y210: u32 = 808530521;
pub const VA_FOURCC_Y212: u32 = 842084953;
pub const VA_FOURCC_Y216: u32 = 909193817;
pub const VA_FOURCC_Y410: u32 = 808531033;
pub const VA_FOURCC_Y412: u32 = 842085465;
pub const VA_FOURCC_Y416: u32 = 909194329;
pub const VA_FOURCC_YV16: u32 = 909203033;
pub const VA_FOURCC_P010: u32 = 808530000;
pub const VA_FOURCC_P012: u32 = 842084432;
pub const VA_FOURCC_P016: u32 = 909193296;
pub const VA_FOURCC_I010: u32 = 808529993;
pub const VA_FOURCC_IYUV: u32 = 1448433993;
pub const VA_FOURCC_A2R10G10B10: u32 = 808669761;
pub const VA_FOURCC_A2B10G10R10: u32 = 808665665;
pub const VA_FOURCC_X2R10G10B10: u32 = 808669784;
pub const VA_FOURCC_X2B10G10R10: u32 = 808665688;
pub const VA_FOURCC_Y8: u32 = 538982489;
pub const VA_FOURCC_Y16: u32 = 540422489;
pub const VA_FOURCC_VYUY: u32 = 1498765654;
pub const VA_FOURCC_YVYU: u32 = 1431918169;
pub const VA_FOURCC_ARGB64: u32 = 877089345;
pub const VA_FOURCC_ABGR64: u32 = 877085249;
pub const VA_LSB_FIRST: u32 = 1;
pub const VA_MSB_FIRST: u32 = 2;
pub const VA_SUBPICTURE_CHROMA_KEYING: u32 = 1;
pub const VA_SUBPICTURE_GLOBAL_ALPHA: u32 = 2;
pub const VA_SUBPICTURE_DESTINATION_IS_SCREEN_COORD: u32 = 4;
pub const VA_ROTATION_NONE: u32 = 0;
pub const VA_ROTATION_90: u32 = 1;
pub const VA_ROTATION_180: u32 = 2;
pub const VA_ROTATION_270: u32 = 3;
pub const VA_MIRROR_NONE: u32 = 0;
pub const VA_MIRROR_HORIZONTAL: u32 = 1;
pub const VA_MIRROR_VERTICAL: u32 = 2;
pub const VA_OOL_DEBLOCKING_FALSE: u32 = 0;
pub const VA_OOL_DEBLOCKING_TRUE: u32 = 1;
pub const VA_RENDER_MODE_UNDEFINED: u32 = 0;
pub const VA_RENDER_MODE_LOCAL_OVERLAY: u32 = 1;
pub const VA_RENDER_MODE_LOCAL_GPU: u32 = 2;
pub const VA_RENDER_MODE_EXTERNAL_OVERLAY: u32 = 4;
pub const VA_RENDER_MODE_EXTERNAL_GPU: u32 = 8;
pub const VA_RENDER_DEVICE_UNDEFINED: u32 = 0;
pub const VA_RENDER_DEVICE_LOCAL: u32 = 1;
pub const VA_RENDER_DEVICE_EXTERNAL: u32 = 2;
pub const VA_DISPLAY_ATTRIB_NOT_SUPPORTED: u32 = 0;
pub const VA_DISPLAY_ATTRIB_GETTABLE: u32 = 1;
pub const VA_DISPLAY_ATTRIB_SETTABLE: u32 = 2;
pub const VA_PICTURE_HEVC_INVALID: u32 = 1;
pub const VA_PICTURE_HEVC_FIELD_PIC: u32 = 2;
pub const VA_PICTURE_HEVC_BOTTOM_FIELD: u32 = 4;
pub const VA_PICTURE_HEVC_LONG_TERM_REFERENCE: u32 = 8;
pub const VA_PICTURE_HEVC_RPS_ST_CURR_BEFORE: u32 = 16;
pub const VA_PICTURE_HEVC_RPS_ST_CURR_AFTER: u32 = 32;
pub const VA_PICTURE_HEVC_RPS_LT_CURR: u32 = 64;
pub const HEVC_LAST_PICTURE_EOSEQ: u32 = 1;
pub const HEVC_LAST_PICTURE_EOSTREAM: u32 = 2;
pub const VA_FEI_FUNCTION_ENC: u32 = 1;
pub const VA_FEI_FUNCTION_PAK: u32 = 2;
pub const VA_FEI_FUNCTION_ENC_PAK: u32 = 4;
pub const VA_PICTURE_STATS_INVALID: u32 = 1;
pub const VA_PICTURE_STATS_PROGRESSIVE: u32 = 0;
pub const VA_PICTURE_STATS_TOP_FIELD: u32 = 2;
pub const VA_PICTURE_STATS_BOTTOM_FIELD: u32 = 4;
pub const VA_PICTURE_STATS_CONTENT_UPDATED: u32 = 16;
pub const H264_LAST_PICTURE_EOSEQ: u32 = 1;
pub const H264_LAST_PICTURE_EOSTREAM: u32 = 2;
pub const VA_MB_PRED_AVAIL_TOP_LEFT: u32 = 4;
pub const VA_MB_PRED_AVAIL_TOP: u32 = 16;
pub const VA_MB_PRED_AVAIL_TOP_RIGHT: u32 = 8;
pub const VA_MB_PRED_AVAIL_LEFT: u32 = 64;
pub const VA_BLEND_GLOBAL_ALPHA: u32 = 1;
pub const VA_BLEND_PREMULTIPLIED_ALPHA: u32 = 2;
pub const VA_BLEND_LUMA_KEY: u32 = 16;
pub const VA_PROC_PIPELINE_SUBPICTURES: u32 = 1;
pub const VA_PROC_PIPELINE_FAST: u32 = 2;
pub const VA_PROC_FILTER_MANDATORY: u32 = 1;
pub const VA_PIPELINE_FLAG_END: u32 = 4;
pub const VA_CHROMA_SITING_UNKNOWN: u32 = 0;
pub const VA_CHROMA_SITING_VERTICAL_TOP: u32 = 1;
pub const VA_CHROMA_SITING_VERTICAL_CENTER: u32 = 2;
pub const VA_CHROMA_SITING_VERTICAL_BOTTOM: u32 = 3;
pub const VA_CHROMA_SITING_HORIZONTAL_LEFT: u32 = 4;
pub const VA_CHROMA_SITING_HORIZONTAL_CENTER: u32 = 8;
pub const VA_SOURCE_RANGE_UNKNOWN: u32 = 0;
pub const VA_SOURCE_RANGE_REDUCED: u32 = 1;
pub const VA_SOURCE_RANGE_FULL: u32 = 2;
pub const VA_TONE_MAPPING_HDR_TO_HDR: u32 = 1;
pub const VA_TONE_MAPPING_HDR_TO_SDR: u32 = 2;
pub const VA_TONE_MAPPING_HDR_TO_EDR: u32 = 4;
pub const VA_TONE_MAPPING_SDR_TO_HDR: u32 = 8;
pub const VA_DEINTERLACING_BOTTOM_FIELD_FIRST: u32 = 1;
pub const VA_DEINTERLACING_BOTTOM_FIELD: u32 = 2;
pub const VA_DEINTERLACING_ONE_FIELD: u32 = 4;
pub const VA_DEINTERLACING_FMD_ENABLE: u32 = 8;
pub const VA_DEINTERLACING_SCD_ENABLE: u32 = 16;
pub const VA_PROC_HVS_DENOISE_DEFAULT: u32 = 0;
pub const VA_PROC_HVS_DENOISE_AUTO_BDRATE: u32 = 1;
pub const VA_PROC_HVS_DENOISE_AUTO_SUBJECTIVE: u32 = 2;
pub const VA_PROC_HVS_DENOISE_MANUAL: u32 = 3;
pub const VA_3DLUT_CHANNEL_UNKNOWN: u32 = 0;
pub const VA_3DLUT_CHANNEL_RGB_RGB: u32 = 1;
pub const VA_3DLUT_CHANNEL_YUV_RGB: u32 = 2;
pub const VA_3DLUT_CHANNEL_VUY_RGB: u32 = 4;
pub type size_t = ::std::os::raw::c_ulong;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __suseconds64_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
}
#[test]
fn bindgen_test_layout___mbstate_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wchb as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wchb)
        )
    );
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        8usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__state)
        )
    );
}
pub type __fpos_t = _G_fpos_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos64_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos64_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__state)
        )
    );
}
pub type __fpos64_t = _G_fpos64_t;
pub type __FILE = _IO_FILE;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: size_t,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_end as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_base as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_base as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_end as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_base as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_end as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_base as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_backup_base as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_end as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._markers as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._chain as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._fileno as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags2 as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._old_offset as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._cur_column as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._vtable_offset as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._shortbuf as *const _ as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._lock as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._codecvt as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_codecvt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._wide_data as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_wide_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._freeres_list as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._freeres_buf as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad5 as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._mode as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._unused2 as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
pub type off_t = __off_t;
pub type ssize_t = __ssize_t;
pub type fpos_t = __fpos_t;
extern "C" {
    pub static mut stdin: *mut FILE;
}
extern "C" {
    pub static mut stdout: *mut FILE;
}
extern "C" {
    pub static mut stderr: *mut FILE;
}
extern "C" {
    pub fn remove(__filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameat(
        __oldfd: ::std::os::raw::c_int,
        __old: *const ::std::os::raw::c_char,
        __newfd: ::std::os::raw::c_int,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpnam_r(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn freopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
        __stream: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fdopen(__fd: ::std::os::raw::c_int, __modes: *const ::std::os::raw::c_char)
        -> *mut FILE;
}
extern "C" {
    pub fn fmemopen(
        __s: *mut ::std::os::raw::c_void,
        __len: size_t,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufloc: *mut *mut ::std::os::raw::c_char,
        __sizeloc: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub fn setbuf(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        __stream: *mut FILE,
        __buf: *mut ::std::os::raw::c_char,
        __modes: ::std::os::raw::c_int,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char, __size: size_t);
}
extern "C" {
    pub fn setlinebuf(__stream: *mut FILE);
}
extern "C" {
    pub fn fprintf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
pub type _Float32 = f32;
pub type _Float64 = f64;
pub type _Float32x = f64;
pub type _Float64x = u128;
extern "C" {
    #[link_name = "\u{1}__isoc99_fscanf"]
    pub fn fscanf1(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_scanf"]
    pub fn scanf1(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_sscanf"]
    pub fn sscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vfscanf"]
    pub fn vfscanf1(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vscanf"]
    pub fn vscanf1(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vsscanf"]
    pub fn vsscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(__w: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        __s: *mut ::std::os::raw::c_char,
        __n: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getline(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn fputs(__s: *const ::std::os::raw::c_char, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __s: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fread_unlocked(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fwrite_unlocked(
        __ptr: *const ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fseek(
        __stream: *mut FILE,
        __off: ::std::os::raw::c_long,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(__stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rewind(__stream: *mut FILE);
}
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __off: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> __off_t;
}
extern "C" {
    pub fn fgetpos(__stream: *mut FILE, __pos: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(__stream: *mut FILE, __pos: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr(__stream: *mut FILE);
}
extern "C" {
    pub fn feof(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr_unlocked(__stream: *mut FILE);
}
extern "C" {
    pub fn feof_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(__s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn fileno(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        __command: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn pclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn flockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn __uflow(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __overflow(arg1: *mut FILE, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn __ctype_get_mb_cur_max() -> size_t;
}
extern "C" {
    pub fn atof(__nptr: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtod(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtold(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtol(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoul(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn strtoll(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoull(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn l64a(__n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn a64l(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = __uint8_t;
pub type u_int16_t = __uint16_t;
pub type u_int32_t = __uint32_t;
pub type u_int64_t = __uint64_t;
pub type register_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).__fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(__fds_bits)
        )
    );
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_slist {
    pub __next: *mut __pthread_internal_slist,
}
#[test]
fn bindgen_test_layout___pthread_internal_slist() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_slist>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_internal_slist))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_slist>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_slist))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_slist>())).__next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_slist),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_slist_t = __pthread_internal_slist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_mutex_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__owner as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__nusers as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__kind as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__spins as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__elision as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__list as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_rwlock_arch_t() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_rwlock_arch_t>(),
        56usize,
        concat!("Size of: ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_rwlock_arch_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__readers as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__wrphase_futex as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__wrphase_futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers_futex as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers_futex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad3 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad4 as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__cur_writer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__cur_writer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__shared as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__rwelision as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__rwelision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad1 as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad2 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __bindgen_anon_1: __pthread_cond_s__bindgen_ty_1,
    pub __bindgen_anon_2: __pthread_cond_s__bindgen_ty_2,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_1 {
    pub __wseq: ::std::os::raw::c_ulonglong,
    pub __wseq32: __pthread_cond_s__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq32 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq32)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_2 {
    pub __g1_start: ::std::os::raw::c_ulonglong,
    pub __g1_start32: __pthread_cond_s__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start32 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start32)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s>(),
        48usize,
        concat!("Size of: ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_refs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g1_orig_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g1_orig_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__wrefs as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__wrefs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_signals as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_signals)
        )
    );
}
pub type __tss_t = ::std::os::raw::c_uint;
pub type __thrd_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __once_flag {
    pub __data: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___once_flag() {
    assert_eq!(
        ::std::mem::size_of::<__once_flag>(),
        4usize,
        concat!("Size of: ", stringify!(__once_flag))
    );
    assert_eq!(
        ::std::mem::align_of::<__once_flag>(),
        4usize,
        concat!("Alignment of ", stringify!(__once_flag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__once_flag>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__once_flag),
            "::",
            stringify!(__data)
        )
    );
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__align)
        )
    );
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srandom(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn initstate(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setstate(__statebuf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
#[test]
fn bindgen_test_layout_random_data() {
    assert_eq!(
        ::std::mem::size_of::<random_data>(),
        48usize,
        concat!("Size of: ", stringify!(random_data))
    );
    assert_eq!(
        ::std::mem::align_of::<random_data>(),
        8usize,
        concat!("Alignment of ", stringify!(random_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).fptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(fptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).state as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_type as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_deg as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_deg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_sep as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_sep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).end_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(end_ptr)
        )
    );
}
extern "C" {
    pub fn random_r(__buf: *mut random_data, __result: *mut i32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srandom_r(
        __seed: ::std::os::raw::c_uint,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate_r(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setstate_r(
        __statebuf: *mut ::std::os::raw::c_char,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn rand_r(__seed: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn erand48(__xsubi: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srand48(__seedval: ::std::os::raw::c_long);
}
extern "C" {
    pub fn seed48(__seed16v: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn lcong48(__param: *mut ::std::os::raw::c_ushort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
#[test]
fn bindgen_test_layout_drand48_data() {
    assert_eq!(
        ::std::mem::size_of::<drand48_data>(),
        24usize,
        concat!("Size of: ", stringify!(drand48_data))
    );
    assert_eq!(
        ::std::mem::align_of::<drand48_data>(),
        8usize,
        concat!("Alignment of ", stringify!(drand48_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__old_x as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__old_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__c as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__init as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__a as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__a)
        )
    );
}
extern "C" {
    pub fn drand48_r(__buffer: *mut drand48_data, __result: *mut f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn erand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand48_r(
        __seedval: ::std::os::raw::c_long,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seed48_r(
        __seed16v: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lcong48_r(
        __param: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __nmemb: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn reallocarray(
        __ptr: *mut ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn alloca(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(__size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn aligned_alloc(__alignment: size_t, __size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn atexit(__func: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn at_quick_exit(
        __func: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn on_exit(
        __func: ::std::option::Option<
            unsafe extern "C" fn(
                __status: ::std::os::raw::c_int,
                __arg: *mut ::std::os::raw::c_void,
            ),
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn quick_exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _Exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(__name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn putenv(__string: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __replace: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mktemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(__template: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        __template: *mut ::std::os::raw::c_char,
        __suffixlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn system(__command: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn realpath(
        __name: *const ::std::os::raw::c_char,
        __resolved: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    );
}
extern "C" {
    pub fn abs(__x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(__x: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llabs(__x: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn div(__numer: ::std::os::raw::c_int, __denom: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn ldiv(__numer: ::std::os::raw::c_long, __denom: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn lldiv(
        __numer: ::std::os::raw::c_longlong,
        __denom: ::std::os::raw::c_longlong,
    ) -> lldiv_t;
}
extern "C" {
    pub fn ecvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qecvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qfcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qgcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ecvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fcvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qecvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qfcvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbtowc(
        __pwc: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wctomb(__s: *mut ::std::os::raw::c_char, __wchar: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        __pwcs: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcstombs(
        __s: *mut ::std::os::raw::c_char,
        __pwcs: *const wchar_t,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn rpmatch(__response: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsubopt(
        __optionp: *mut *mut ::std::os::raw::c_char,
        __tokens: *const *mut ::std::os::raw::c_char,
        __valuep: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getloadavg(__loadavg: *mut f64, __nelem: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
pub type useconds_t = __useconds_t;
pub type socklen_t = __socklen_t;
extern "C" {
    pub fn access(
        __name: *const ::std::os::raw::c_char,
        __type: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faccessat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __type: ::std::os::raw::c_int,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lseek(
        __fd: ::std::os::raw::c_int,
        __offset: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> __off_t;
}
extern "C" {
    pub fn close(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn read(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __nbytes: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn write(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pread(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __nbytes: size_t,
        __offset: __off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pwrite(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: size_t,
        __offset: __off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pipe(__pipedes: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn alarm(__seconds: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn sleep(__seconds: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn ualarm(__value: __useconds_t, __interval: __useconds_t) -> __useconds_t;
}
extern "C" {
    pub fn usleep(__useconds: __useconds_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pause() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chown(
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchown(
        __fd: ::std::os::raw::c_int,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchown(
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchownat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chdir(__path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchdir(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getcwd(
        __buf: *mut ::std::os::raw::c_char,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getwd(__buf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn dup(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup2(__fd: ::std::os::raw::c_int, __fd2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut __environ: *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn execve(
        __path: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
        __envp: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fexecve(
        __fd: ::std::os::raw::c_int,
        __argv: *const *mut ::std::os::raw::c_char,
        __envp: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execv(
        __path: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execle(
        __path: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execl(
        __path: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execvp(
        __file: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execlp(
        __file: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nice(__inc: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _exit(__status: ::std::os::raw::c_int);
}
pub const _PC_LINK_MAX: ::std::os::raw::c_uint = 0;
pub const _PC_MAX_CANON: ::std::os::raw::c_uint = 1;
pub const _PC_MAX_INPUT: ::std::os::raw::c_uint = 2;
pub const _PC_NAME_MAX: ::std::os::raw::c_uint = 3;
pub const _PC_PATH_MAX: ::std::os::raw::c_uint = 4;
pub const _PC_PIPE_BUF: ::std::os::raw::c_uint = 5;
pub const _PC_CHOWN_RESTRICTED: ::std::os::raw::c_uint = 6;
pub const _PC_NO_TRUNC: ::std::os::raw::c_uint = 7;
pub const _PC_VDISABLE: ::std::os::raw::c_uint = 8;
pub const _PC_SYNC_IO: ::std::os::raw::c_uint = 9;
pub const _PC_ASYNC_IO: ::std::os::raw::c_uint = 10;
pub const _PC_PRIO_IO: ::std::os::raw::c_uint = 11;
pub const _PC_SOCK_MAXBUF: ::std::os::raw::c_uint = 12;
pub const _PC_FILESIZEBITS: ::std::os::raw::c_uint = 13;
pub const _PC_REC_INCR_XFER_SIZE: ::std::os::raw::c_uint = 14;
pub const _PC_REC_MAX_XFER_SIZE: ::std::os::raw::c_uint = 15;
pub const _PC_REC_MIN_XFER_SIZE: ::std::os::raw::c_uint = 16;
pub const _PC_REC_XFER_ALIGN: ::std::os::raw::c_uint = 17;
pub const _PC_ALLOC_SIZE_MIN: ::std::os::raw::c_uint = 18;
pub const _PC_SYMLINK_MAX: ::std::os::raw::c_uint = 19;
pub const _PC_2_SYMLINKS: ::std::os::raw::c_uint = 20;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
pub const _SC_ARG_MAX: ::std::os::raw::c_uint = 0;
pub const _SC_CHILD_MAX: ::std::os::raw::c_uint = 1;
pub const _SC_CLK_TCK: ::std::os::raw::c_uint = 2;
pub const _SC_NGROUPS_MAX: ::std::os::raw::c_uint = 3;
pub const _SC_OPEN_MAX: ::std::os::raw::c_uint = 4;
pub const _SC_STREAM_MAX: ::std::os::raw::c_uint = 5;
pub const _SC_TZNAME_MAX: ::std::os::raw::c_uint = 6;
pub const _SC_JOB_CONTROL: ::std::os::raw::c_uint = 7;
pub const _SC_SAVED_IDS: ::std::os::raw::c_uint = 8;
pub const _SC_REALTIME_SIGNALS: ::std::os::raw::c_uint = 9;
pub const _SC_PRIORITY_SCHEDULING: ::std::os::raw::c_uint = 10;
pub const _SC_TIMERS: ::std::os::raw::c_uint = 11;
pub const _SC_ASYNCHRONOUS_IO: ::std::os::raw::c_uint = 12;
pub const _SC_PRIORITIZED_IO: ::std::os::raw::c_uint = 13;
pub const _SC_SYNCHRONIZED_IO: ::std::os::raw::c_uint = 14;
pub const _SC_FSYNC: ::std::os::raw::c_uint = 15;
pub const _SC_MAPPED_FILES: ::std::os::raw::c_uint = 16;
pub const _SC_MEMLOCK: ::std::os::raw::c_uint = 17;
pub const _SC_MEMLOCK_RANGE: ::std::os::raw::c_uint = 18;
pub const _SC_MEMORY_PROTECTION: ::std::os::raw::c_uint = 19;
pub const _SC_MESSAGE_PASSING: ::std::os::raw::c_uint = 20;
pub const _SC_SEMAPHORES: ::std::os::raw::c_uint = 21;
pub const _SC_SHARED_MEMORY_OBJECTS: ::std::os::raw::c_uint = 22;
pub const _SC_AIO_LISTIO_MAX: ::std::os::raw::c_uint = 23;
pub const _SC_AIO_MAX: ::std::os::raw::c_uint = 24;
pub const _SC_AIO_PRIO_DELTA_MAX: ::std::os::raw::c_uint = 25;
pub const _SC_DELAYTIMER_MAX: ::std::os::raw::c_uint = 26;
pub const _SC_MQ_OPEN_MAX: ::std::os::raw::c_uint = 27;
pub const _SC_MQ_PRIO_MAX: ::std::os::raw::c_uint = 28;
pub const _SC_VERSION: ::std::os::raw::c_uint = 29;
pub const _SC_PAGESIZE: ::std::os::raw::c_uint = 30;
pub const _SC_RTSIG_MAX: ::std::os::raw::c_uint = 31;
pub const _SC_SEM_NSEMS_MAX: ::std::os::raw::c_uint = 32;
pub const _SC_SEM_VALUE_MAX: ::std::os::raw::c_uint = 33;
pub const _SC_SIGQUEUE_MAX: ::std::os::raw::c_uint = 34;
pub const _SC_TIMER_MAX: ::std::os::raw::c_uint = 35;
pub const _SC_BC_BASE_MAX: ::std::os::raw::c_uint = 36;
pub const _SC_BC_DIM_MAX: ::std::os::raw::c_uint = 37;
pub const _SC_BC_SCALE_MAX: ::std::os::raw::c_uint = 38;
pub const _SC_BC_STRING_MAX: ::std::os::raw::c_uint = 39;
pub const _SC_COLL_WEIGHTS_MAX: ::std::os::raw::c_uint = 40;
pub const _SC_EQUIV_CLASS_MAX: ::std::os::raw::c_uint = 41;
pub const _SC_EXPR_NEST_MAX: ::std::os::raw::c_uint = 42;
pub const _SC_LINE_MAX: ::std::os::raw::c_uint = 43;
pub const _SC_RE_DUP_MAX: ::std::os::raw::c_uint = 44;
pub const _SC_CHARCLASS_NAME_MAX: ::std::os::raw::c_uint = 45;
pub const _SC_2_VERSION: ::std::os::raw::c_uint = 46;
pub const _SC_2_C_BIND: ::std::os::raw::c_uint = 47;
pub const _SC_2_C_DEV: ::std::os::raw::c_uint = 48;
pub const _SC_2_FORT_DEV: ::std::os::raw::c_uint = 49;
pub const _SC_2_FORT_RUN: ::std::os::raw::c_uint = 50;
pub const _SC_2_SW_DEV: ::std::os::raw::c_uint = 51;
pub const _SC_2_LOCALEDEF: ::std::os::raw::c_uint = 52;
pub const _SC_PII: ::std::os::raw::c_uint = 53;
pub const _SC_PII_XTI: ::std::os::raw::c_uint = 54;
pub const _SC_PII_SOCKET: ::std::os::raw::c_uint = 55;
pub const _SC_PII_INTERNET: ::std::os::raw::c_uint = 56;
pub const _SC_PII_OSI: ::std::os::raw::c_uint = 57;
pub const _SC_POLL: ::std::os::raw::c_uint = 58;
pub const _SC_SELECT: ::std::os::raw::c_uint = 59;
pub const _SC_UIO_MAXIOV: ::std::os::raw::c_uint = 60;
pub const _SC_IOV_MAX: ::std::os::raw::c_uint = 60;
pub const _SC_PII_INTERNET_STREAM: ::std::os::raw::c_uint = 61;
pub const _SC_PII_INTERNET_DGRAM: ::std::os::raw::c_uint = 62;
pub const _SC_PII_OSI_COTS: ::std::os::raw::c_uint = 63;
pub const _SC_PII_OSI_CLTS: ::std::os::raw::c_uint = 64;
pub const _SC_PII_OSI_M: ::std::os::raw::c_uint = 65;
pub const _SC_T_IOV_MAX: ::std::os::raw::c_uint = 66;
pub const _SC_THREADS: ::std::os::raw::c_uint = 67;
pub const _SC_THREAD_SAFE_FUNCTIONS: ::std::os::raw::c_uint = 68;
pub const _SC_GETGR_R_SIZE_MAX: ::std::os::raw::c_uint = 69;
pub const _SC_GETPW_R_SIZE_MAX: ::std::os::raw::c_uint = 70;
pub const _SC_LOGIN_NAME_MAX: ::std::os::raw::c_uint = 71;
pub const _SC_TTY_NAME_MAX: ::std::os::raw::c_uint = 72;
pub const _SC_THREAD_DESTRUCTOR_ITERATIONS: ::std::os::raw::c_uint = 73;
pub const _SC_THREAD_KEYS_MAX: ::std::os::raw::c_uint = 74;
pub const _SC_THREAD_STACK_MIN: ::std::os::raw::c_uint = 75;
pub const _SC_THREAD_THREADS_MAX: ::std::os::raw::c_uint = 76;
pub const _SC_THREAD_ATTR_STACKADDR: ::std::os::raw::c_uint = 77;
pub const _SC_THREAD_ATTR_STACKSIZE: ::std::os::raw::c_uint = 78;
pub const _SC_THREAD_PRIORITY_SCHEDULING: ::std::os::raw::c_uint = 79;
pub const _SC_THREAD_PRIO_INHERIT: ::std::os::raw::c_uint = 80;
pub const _SC_THREAD_PRIO_PROTECT: ::std::os::raw::c_uint = 81;
pub const _SC_THREAD_PROCESS_SHARED: ::std::os::raw::c_uint = 82;
pub const _SC_NPROCESSORS_CONF: ::std::os::raw::c_uint = 83;
pub const _SC_NPROCESSORS_ONLN: ::std::os::raw::c_uint = 84;
pub const _SC_PHYS_PAGES: ::std::os::raw::c_uint = 85;
pub const _SC_AVPHYS_PAGES: ::std::os::raw::c_uint = 86;
pub const _SC_ATEXIT_MAX: ::std::os::raw::c_uint = 87;
pub const _SC_PASS_MAX: ::std::os::raw::c_uint = 88;
pub const _SC_XOPEN_VERSION: ::std::os::raw::c_uint = 89;
pub const _SC_XOPEN_XCU_VERSION: ::std::os::raw::c_uint = 90;
pub const _SC_XOPEN_UNIX: ::std::os::raw::c_uint = 91;
pub const _SC_XOPEN_CRYPT: ::std::os::raw::c_uint = 92;
pub const _SC_XOPEN_ENH_I18N: ::std::os::raw::c_uint = 93;
pub const _SC_XOPEN_SHM: ::std::os::raw::c_uint = 94;
pub const _SC_2_CHAR_TERM: ::std::os::raw::c_uint = 95;
pub const _SC_2_C_VERSION: ::std::os::raw::c_uint = 96;
pub const _SC_2_UPE: ::std::os::raw::c_uint = 97;
pub const _SC_XOPEN_XPG2: ::std::os::raw::c_uint = 98;
pub const _SC_XOPEN_XPG3: ::std::os::raw::c_uint = 99;
pub const _SC_XOPEN_XPG4: ::std::os::raw::c_uint = 100;
pub const _SC_CHAR_BIT: ::std::os::raw::c_uint = 101;
pub const _SC_CHAR_MAX: ::std::os::raw::c_uint = 102;
pub const _SC_CHAR_MIN: ::std::os::raw::c_uint = 103;
pub const _SC_INT_MAX: ::std::os::raw::c_uint = 104;
pub const _SC_INT_MIN: ::std::os::raw::c_uint = 105;
pub const _SC_LONG_BIT: ::std::os::raw::c_uint = 106;
pub const _SC_WORD_BIT: ::std::os::raw::c_uint = 107;
pub const _SC_MB_LEN_MAX: ::std::os::raw::c_uint = 108;
pub const _SC_NZERO: ::std::os::raw::c_uint = 109;
pub const _SC_SSIZE_MAX: ::std::os::raw::c_uint = 110;
pub const _SC_SCHAR_MAX: ::std::os::raw::c_uint = 111;
pub const _SC_SCHAR_MIN: ::std::os::raw::c_uint = 112;
pub const _SC_SHRT_MAX: ::std::os::raw::c_uint = 113;
pub const _SC_SHRT_MIN: ::std::os::raw::c_uint = 114;
pub const _SC_UCHAR_MAX: ::std::os::raw::c_uint = 115;
pub const _SC_UINT_MAX: ::std::os::raw::c_uint = 116;
pub const _SC_ULONG_MAX: ::std::os::raw::c_uint = 117;
pub const _SC_USHRT_MAX: ::std::os::raw::c_uint = 118;
pub const _SC_NL_ARGMAX: ::std::os::raw::c_uint = 119;
pub const _SC_NL_LANGMAX: ::std::os::raw::c_uint = 120;
pub const _SC_NL_MSGMAX: ::std::os::raw::c_uint = 121;
pub const _SC_NL_NMAX: ::std::os::raw::c_uint = 122;
pub const _SC_NL_SETMAX: ::std::os::raw::c_uint = 123;
pub const _SC_NL_TEXTMAX: ::std::os::raw::c_uint = 124;
pub const _SC_XBS5_ILP32_OFF32: ::std::os::raw::c_uint = 125;
pub const _SC_XBS5_ILP32_OFFBIG: ::std::os::raw::c_uint = 126;
pub const _SC_XBS5_LP64_OFF64: ::std::os::raw::c_uint = 127;
pub const _SC_XBS5_LPBIG_OFFBIG: ::std::os::raw::c_uint = 128;
pub const _SC_XOPEN_LEGACY: ::std::os::raw::c_uint = 129;
pub const _SC_XOPEN_REALTIME: ::std::os::raw::c_uint = 130;
pub const _SC_XOPEN_REALTIME_THREADS: ::std::os::raw::c_uint = 131;
pub const _SC_ADVISORY_INFO: ::std::os::raw::c_uint = 132;
pub const _SC_BARRIERS: ::std::os::raw::c_uint = 133;
pub const _SC_BASE: ::std::os::raw::c_uint = 134;
pub const _SC_C_LANG_SUPPORT: ::std::os::raw::c_uint = 135;
pub const _SC_C_LANG_SUPPORT_R: ::std::os::raw::c_uint = 136;
pub const _SC_CLOCK_SELECTION: ::std::os::raw::c_uint = 137;
pub const _SC_CPUTIME: ::std::os::raw::c_uint = 138;
pub const _SC_THREAD_CPUTIME: ::std::os::raw::c_uint = 139;
pub const _SC_DEVICE_IO: ::std::os::raw::c_uint = 140;
pub const _SC_DEVICE_SPECIFIC: ::std::os::raw::c_uint = 141;
pub const _SC_DEVICE_SPECIFIC_R: ::std::os::raw::c_uint = 142;
pub const _SC_FD_MGMT: ::std::os::raw::c_uint = 143;
pub const _SC_FIFO: ::std::os::raw::c_uint = 144;
pub const _SC_PIPE: ::std::os::raw::c_uint = 145;
pub const _SC_FILE_ATTRIBUTES: ::std::os::raw::c_uint = 146;
pub const _SC_FILE_LOCKING: ::std::os::raw::c_uint = 147;
pub const _SC_FILE_SYSTEM: ::std::os::raw::c_uint = 148;
pub const _SC_MONOTONIC_CLOCK: ::std::os::raw::c_uint = 149;
pub const _SC_MULTI_PROCESS: ::std::os::raw::c_uint = 150;
pub const _SC_SINGLE_PROCESS: ::std::os::raw::c_uint = 151;
pub const _SC_NETWORKING: ::std::os::raw::c_uint = 152;
pub const _SC_READER_WRITER_LOCKS: ::std::os::raw::c_uint = 153;
pub const _SC_SPIN_LOCKS: ::std::os::raw::c_uint = 154;
pub const _SC_REGEXP: ::std::os::raw::c_uint = 155;
pub const _SC_REGEX_VERSION: ::std::os::raw::c_uint = 156;
pub const _SC_SHELL: ::std::os::raw::c_uint = 157;
pub const _SC_SIGNALS: ::std::os::raw::c_uint = 158;
pub const _SC_SPAWN: ::std::os::raw::c_uint = 159;
pub const _SC_SPORADIC_SERVER: ::std::os::raw::c_uint = 160;
pub const _SC_THREAD_SPORADIC_SERVER: ::std::os::raw::c_uint = 161;
pub const _SC_SYSTEM_DATABASE: ::std::os::raw::c_uint = 162;
pub const _SC_SYSTEM_DATABASE_R: ::std::os::raw::c_uint = 163;
pub const _SC_TIMEOUTS: ::std::os::raw::c_uint = 164;
pub const _SC_TYPED_MEMORY_OBJECTS: ::std::os::raw::c_uint = 165;
pub const _SC_USER_GROUPS: ::std::os::raw::c_uint = 166;
pub const _SC_USER_GROUPS_R: ::std::os::raw::c_uint = 167;
pub const _SC_2_PBS: ::std::os::raw::c_uint = 168;
pub const _SC_2_PBS_ACCOUNTING: ::std::os::raw::c_uint = 169;
pub const _SC_2_PBS_LOCATE: ::std::os::raw::c_uint = 170;
pub const _SC_2_PBS_MESSAGE: ::std::os::raw::c_uint = 171;
pub const _SC_2_PBS_TRACK: ::std::os::raw::c_uint = 172;
pub const _SC_SYMLOOP_MAX: ::std::os::raw::c_uint = 173;
pub const _SC_STREAMS: ::std::os::raw::c_uint = 174;
pub const _SC_2_PBS_CHECKPOINT: ::std::os::raw::c_uint = 175;
pub const _SC_V6_ILP32_OFF32: ::std::os::raw::c_uint = 176;
pub const _SC_V6_ILP32_OFFBIG: ::std::os::raw::c_uint = 177;
pub const _SC_V6_LP64_OFF64: ::std::os::raw::c_uint = 178;
pub const _SC_V6_LPBIG_OFFBIG: ::std::os::raw::c_uint = 179;
pub const _SC_HOST_NAME_MAX: ::std::os::raw::c_uint = 180;
pub const _SC_TRACE: ::std::os::raw::c_uint = 181;
pub const _SC_TRACE_EVENT_FILTER: ::std::os::raw::c_uint = 182;
pub const _SC_TRACE_INHERIT: ::std::os::raw::c_uint = 183;
pub const _SC_TRACE_LOG: ::std::os::raw::c_uint = 184;
pub const _SC_LEVEL1_ICACHE_SIZE: ::std::os::raw::c_uint = 185;
pub const _SC_LEVEL1_ICACHE_ASSOC: ::std::os::raw::c_uint = 186;
pub const _SC_LEVEL1_ICACHE_LINESIZE: ::std::os::raw::c_uint = 187;
pub const _SC_LEVEL1_DCACHE_SIZE: ::std::os::raw::c_uint = 188;
pub const _SC_LEVEL1_DCACHE_ASSOC: ::std::os::raw::c_uint = 189;
pub const _SC_LEVEL1_DCACHE_LINESIZE: ::std::os::raw::c_uint = 190;
pub const _SC_LEVEL2_CACHE_SIZE: ::std::os::raw::c_uint = 191;
pub const _SC_LEVEL2_CACHE_ASSOC: ::std::os::raw::c_uint = 192;
pub const _SC_LEVEL2_CACHE_LINESIZE: ::std::os::raw::c_uint = 193;
pub const _SC_LEVEL3_CACHE_SIZE: ::std::os::raw::c_uint = 194;
pub const _SC_LEVEL3_CACHE_ASSOC: ::std::os::raw::c_uint = 195;
pub const _SC_LEVEL3_CACHE_LINESIZE: ::std::os::raw::c_uint = 196;
pub const _SC_LEVEL4_CACHE_SIZE: ::std::os::raw::c_uint = 197;
pub const _SC_LEVEL4_CACHE_ASSOC: ::std::os::raw::c_uint = 198;
pub const _SC_LEVEL4_CACHE_LINESIZE: ::std::os::raw::c_uint = 199;
pub const _SC_IPV6: ::std::os::raw::c_uint = 235;
pub const _SC_RAW_SOCKETS: ::std::os::raw::c_uint = 236;
pub const _SC_V7_ILP32_OFF32: ::std::os::raw::c_uint = 237;
pub const _SC_V7_ILP32_OFFBIG: ::std::os::raw::c_uint = 238;
pub const _SC_V7_LP64_OFF64: ::std::os::raw::c_uint = 239;
pub const _SC_V7_LPBIG_OFFBIG: ::std::os::raw::c_uint = 240;
pub const _SC_SS_REPL_MAX: ::std::os::raw::c_uint = 241;
pub const _SC_TRACE_EVENT_NAME_MAX: ::std::os::raw::c_uint = 242;
pub const _SC_TRACE_NAME_MAX: ::std::os::raw::c_uint = 243;
pub const _SC_TRACE_SYS_MAX: ::std::os::raw::c_uint = 244;
pub const _SC_TRACE_USER_EVENT_MAX: ::std::os::raw::c_uint = 245;
pub const _SC_XOPEN_STREAMS: ::std::os::raw::c_uint = 246;
pub const _SC_THREAD_ROBUST_PRIO_INHERIT: ::std::os::raw::c_uint = 247;
pub const _SC_THREAD_ROBUST_PRIO_PROTECT: ::std::os::raw::c_uint = 248;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
pub const _CS_PATH: ::std::os::raw::c_uint = 0;
pub const _CS_V6_WIDTH_RESTRICTED_ENVS: ::std::os::raw::c_uint = 1;
pub const _CS_GNU_LIBC_VERSION: ::std::os::raw::c_uint = 2;
pub const _CS_GNU_LIBPTHREAD_VERSION: ::std::os::raw::c_uint = 3;
pub const _CS_V5_WIDTH_RESTRICTED_ENVS: ::std::os::raw::c_uint = 4;
pub const _CS_V7_WIDTH_RESTRICTED_ENVS: ::std::os::raw::c_uint = 5;
pub const _CS_LFS_CFLAGS: ::std::os::raw::c_uint = 1000;
pub const _CS_LFS_LDFLAGS: ::std::os::raw::c_uint = 1001;
pub const _CS_LFS_LIBS: ::std::os::raw::c_uint = 1002;
pub const _CS_LFS_LINTFLAGS: ::std::os::raw::c_uint = 1003;
pub const _CS_LFS64_CFLAGS: ::std::os::raw::c_uint = 1004;
pub const _CS_LFS64_LDFLAGS: ::std::os::raw::c_uint = 1005;
pub const _CS_LFS64_LIBS: ::std::os::raw::c_uint = 1006;
pub const _CS_LFS64_LINTFLAGS: ::std::os::raw::c_uint = 1007;
pub const _CS_XBS5_ILP32_OFF32_CFLAGS: ::std::os::raw::c_uint = 1100;
pub const _CS_XBS5_ILP32_OFF32_LDFLAGS: ::std::os::raw::c_uint = 1101;
pub const _CS_XBS5_ILP32_OFF32_LIBS: ::std::os::raw::c_uint = 1102;
pub const _CS_XBS5_ILP32_OFF32_LINTFLAGS: ::std::os::raw::c_uint = 1103;
pub const _CS_XBS5_ILP32_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1104;
pub const _CS_XBS5_ILP32_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1105;
pub const _CS_XBS5_ILP32_OFFBIG_LIBS: ::std::os::raw::c_uint = 1106;
pub const _CS_XBS5_ILP32_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1107;
pub const _CS_XBS5_LP64_OFF64_CFLAGS: ::std::os::raw::c_uint = 1108;
pub const _CS_XBS5_LP64_OFF64_LDFLAGS: ::std::os::raw::c_uint = 1109;
pub const _CS_XBS5_LP64_OFF64_LIBS: ::std::os::raw::c_uint = 1110;
pub const _CS_XBS5_LP64_OFF64_LINTFLAGS: ::std::os::raw::c_uint = 1111;
pub const _CS_XBS5_LPBIG_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1112;
pub const _CS_XBS5_LPBIG_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1113;
pub const _CS_XBS5_LPBIG_OFFBIG_LIBS: ::std::os::raw::c_uint = 1114;
pub const _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1115;
pub const _CS_POSIX_V6_ILP32_OFF32_CFLAGS: ::std::os::raw::c_uint = 1116;
pub const _CS_POSIX_V6_ILP32_OFF32_LDFLAGS: ::std::os::raw::c_uint = 1117;
pub const _CS_POSIX_V6_ILP32_OFF32_LIBS: ::std::os::raw::c_uint = 1118;
pub const _CS_POSIX_V6_ILP32_OFF32_LINTFLAGS: ::std::os::raw::c_uint = 1119;
pub const _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1120;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1121;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LIBS: ::std::os::raw::c_uint = 1122;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1123;
pub const _CS_POSIX_V6_LP64_OFF64_CFLAGS: ::std::os::raw::c_uint = 1124;
pub const _CS_POSIX_V6_LP64_OFF64_LDFLAGS: ::std::os::raw::c_uint = 1125;
pub const _CS_POSIX_V6_LP64_OFF64_LIBS: ::std::os::raw::c_uint = 1126;
pub const _CS_POSIX_V6_LP64_OFF64_LINTFLAGS: ::std::os::raw::c_uint = 1127;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1128;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1129;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LIBS: ::std::os::raw::c_uint = 1130;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1131;
pub const _CS_POSIX_V7_ILP32_OFF32_CFLAGS: ::std::os::raw::c_uint = 1132;
pub const _CS_POSIX_V7_ILP32_OFF32_LDFLAGS: ::std::os::raw::c_uint = 1133;
pub const _CS_POSIX_V7_ILP32_OFF32_LIBS: ::std::os::raw::c_uint = 1134;
pub const _CS_POSIX_V7_ILP32_OFF32_LINTFLAGS: ::std::os::raw::c_uint = 1135;
pub const _CS_POSIX_V7_ILP32_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1136;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1137;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LIBS: ::std::os::raw::c_uint = 1138;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1139;
pub const _CS_POSIX_V7_LP64_OFF64_CFLAGS: ::std::os::raw::c_uint = 1140;
pub const _CS_POSIX_V7_LP64_OFF64_LDFLAGS: ::std::os::raw::c_uint = 1141;
pub const _CS_POSIX_V7_LP64_OFF64_LIBS: ::std::os::raw::c_uint = 1142;
pub const _CS_POSIX_V7_LP64_OFF64_LINTFLAGS: ::std::os::raw::c_uint = 1143;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1144;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1145;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LIBS: ::std::os::raw::c_uint = 1146;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1147;
pub const _CS_V6_ENV: ::std::os::raw::c_uint = 1148;
pub const _CS_V7_ENV: ::std::os::raw::c_uint = 1149;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
extern "C" {
    pub fn pathconf(
        __path: *const ::std::os::raw::c_char,
        __name: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn fpathconf(
        __fd: ::std::os::raw::c_int,
        __name: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn sysconf(__name: ::std::os::raw::c_int) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn confstr(
        __name: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn getpid() -> __pid_t;
}
extern "C" {
    pub fn getppid() -> __pid_t;
}
extern "C" {
    pub fn getpgrp() -> __pid_t;
}
extern "C" {
    pub fn __getpgid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn getpgid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn setpgid(__pid: __pid_t, __pgid: __pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpgrp() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsid() -> __pid_t;
}
extern "C" {
    pub fn getsid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn getuid() -> __uid_t;
}
extern "C" {
    pub fn geteuid() -> __uid_t;
}
extern "C" {
    pub fn getgid() -> __gid_t;
}
extern "C" {
    pub fn getegid() -> __gid_t;
}
extern "C" {
    pub fn getgroups(__size: ::std::os::raw::c_int, __list: *mut __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setuid(__uid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setreuid(__ruid: __uid_t, __euid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seteuid(__uid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setgid(__gid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setregid(__rgid: __gid_t, __egid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setegid(__gid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fork() -> __pid_t;
}
extern "C" {
    pub fn vfork() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyname(__fd: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ttyname_r(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isatty(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyslot() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn link(
        __from: *const ::std::os::raw::c_char,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn linkat(
        __fromfd: ::std::os::raw::c_int,
        __from: *const ::std::os::raw::c_char,
        __tofd: ::std::os::raw::c_int,
        __to: *const ::std::os::raw::c_char,
        __flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn symlink(
        __from: *const ::std::os::raw::c_char,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlink(
        __path: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn symlinkat(
        __from: *const ::std::os::raw::c_char,
        __tofd: ::std::os::raw::c_int,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlinkat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn unlink(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlinkat(
        __fd: ::std::os::raw::c_int,
        __name: *const ::std::os::raw::c_char,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rmdir(__path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcgetpgrp(__fd: ::std::os::raw::c_int) -> __pid_t;
}
extern "C" {
    pub fn tcsetpgrp(__fd: ::std::os::raw::c_int, __pgrp_id: __pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getlogin() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getlogin_r(
        __name: *mut ::std::os::raw::c_char,
        __name_len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setlogin(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optarg: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut optind: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut opterr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optopt: ::std::os::raw::c_int;
}
extern "C" {
    pub fn getopt(
        ___argc: ::std::os::raw::c_int,
        ___argv: *const *mut ::std::os::raw::c_char,
        __shortopts: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostname(__name: *mut ::std::os::raw::c_char, __len: size_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostname(
        __name: *const ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostid(__id: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdomainname(
        __name: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setdomainname(
        __name: *const ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vhangup() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn revoke(__file: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn profil(
        __sample_buffer: *mut ::std::os::raw::c_ushort,
        __size: size_t,
        __offset: size_t,
        __scale: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acct(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getusershell() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn endusershell();
}
extern "C" {
    pub fn setusershell();
}
extern "C" {
    pub fn daemon(
        __nochdir: ::std::os::raw::c_int,
        __noclose: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chroot(__path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpass(__prompt: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fsync(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostid() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn sync();
}
extern "C" {
    pub fn getpagesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdtablesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn truncate(
        __file: *const ::std::os::raw::c_char,
        __length: __off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftruncate(__fd: ::std::os::raw::c_int, __length: __off_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn brk(__addr: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sbrk(__delta: isize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn syscall(__sysno: ::std::os::raw::c_long, ...) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lockf(
        __fd: ::std::os::raw::c_int,
        __cmd: ::std::os::raw::c_int,
        __len: __off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fdatasync(__fildes: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn crypt(
        __key: *const ::std::os::raw::c_char,
        __salt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getentropy(
        __buffer: *mut ::std::os::raw::c_void,
        __length: size_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct flock {
    pub l_type: ::std::os::raw::c_short,
    pub l_whence: ::std::os::raw::c_short,
    pub l_start: __off_t,
    pub l_len: __off_t,
    pub l_pid: __pid_t,
}
#[test]
fn bindgen_test_layout_flock() {
    assert_eq!(
        ::std::mem::size_of::<flock>(),
        32usize,
        concat!("Size of: ", stringify!(flock))
    );
    assert_eq!(
        ::std::mem::align_of::<flock>(),
        8usize,
        concat!("Alignment of ", stringify!(flock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flock>())).l_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(flock),
            "::",
            stringify!(l_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flock>())).l_whence as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(flock),
            "::",
            stringify!(l_whence)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flock>())).l_start as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(flock),
            "::",
            stringify!(l_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flock>())).l_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(flock),
            "::",
            stringify!(l_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<flock>())).l_pid as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(flock),
            "::",
            stringify!(l_pid)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stat {
    pub st_dev: __dev_t,
    pub st_ino: __ino_t,
    pub st_nlink: __nlink_t,
    pub st_mode: __mode_t,
    pub st_uid: __uid_t,
    pub st_gid: __gid_t,
    pub __pad0: ::std::os::raw::c_int,
    pub st_rdev: __dev_t,
    pub st_size: __off_t,
    pub st_blksize: __blksize_t,
    pub st_blocks: __blkcnt_t,
    pub st_atim: timespec,
    pub st_mtim: timespec,
    pub st_ctim: timespec,
    pub __glibc_reserved: [__syscall_slong_t; 3usize],
}
#[test]
fn bindgen_test_layout_stat() {
    assert_eq!(
        ::std::mem::size_of::<stat>(),
        144usize,
        concat!("Size of: ", stringify!(stat))
    );
    assert_eq!(
        ::std::mem::align_of::<stat>(),
        8usize,
        concat!("Alignment of ", stringify!(stat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_nlink as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_mode as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_uid as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_gid as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).__pad0 as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(__pad0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_rdev as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_size as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_blksize as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_blocks as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_atim as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_atim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_mtim as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_mtim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_ctim as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_ctim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).__glibc_reserved as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(__glibc_reserved)
        )
    );
}
extern "C" {
    pub fn fcntl(
        __fd: ::std::os::raw::c_int,
        __cmd: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn open(
        __file: *const ::std::os::raw::c_char,
        __oflag: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn openat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __oflag: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn creat(__file: *const ::std::os::raw::c_char, __mode: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn posix_fadvise(
        __fd: ::std::os::raw::c_int,
        __offset: off_t,
        __len: off_t,
        __advise: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn posix_fallocate(
        __fd: ::std::os::raw::c_int,
        __offset: off_t,
        __len: off_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[test]
fn bindgen_test_layout_max_align_t() {
    assert_eq!(
        ::std::mem::size_of::<max_align_t>(),
        32usize,
        concat!("Size of: ", stringify!(max_align_t))
    );
    assert_eq!(
        ::std::mem::align_of::<max_align_t>(),
        16usize,
        concat!("Alignment of ", stringify!(max_align_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce1 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce2)
        )
    );
}
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub type VADisplay = *mut ::std::os::raw::c_void;
pub type VAStatus = ::std::os::raw::c_int;
extern "C" {
    pub fn vaErrorStr(error_status: VAStatus) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VARectangle {
    pub x: i16,
    pub y: i16,
    pub width: u16,
    pub height: u16,
}
#[test]
fn bindgen_test_layout__VARectangle() {
    assert_eq!(
        ::std::mem::size_of::<_VARectangle>(),
        8usize,
        concat!("Size of: ", stringify!(_VARectangle))
    );
    assert_eq!(
        ::std::mem::align_of::<_VARectangle>(),
        2usize,
        concat!("Alignment of ", stringify!(_VARectangle))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VARectangle>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VARectangle),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VARectangle>())).y as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VARectangle),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VARectangle>())).width as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VARectangle),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VARectangle>())).height as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_VARectangle),
            "::",
            stringify!(height)
        )
    );
}
pub type VARectangle = _VARectangle;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAMotionVector {
    pub mv0: [i16; 2usize],
    pub mv1: [i16; 2usize],
}
#[test]
fn bindgen_test_layout__VAMotionVector() {
    assert_eq!(
        ::std::mem::size_of::<_VAMotionVector>(),
        8usize,
        concat!("Size of: ", stringify!(_VAMotionVector))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAMotionVector>(),
        2usize,
        concat!("Alignment of ", stringify!(_VAMotionVector))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAMotionVector>())).mv0 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMotionVector),
            "::",
            stringify!(mv0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAMotionVector>())).mv1 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMotionVector),
            "::",
            stringify!(mv1)
        )
    );
}
pub type VAMotionVector = _VAMotionVector;
pub type VAMessageCallback = ::std::option::Option<
    unsafe extern "C" fn(
        user_context: *mut ::std::os::raw::c_void,
        message: *const ::std::os::raw::c_char,
    ),
>;
extern "C" {
    pub fn vaSetErrorCallback(
        dpy: VADisplay,
        callback: VAMessageCallback,
        user_context: *mut ::std::os::raw::c_void,
    ) -> VAMessageCallback;
}
extern "C" {
    pub fn vaSetInfoCallback(
        dpy: VADisplay,
        callback: VAMessageCallback,
        user_context: *mut ::std::os::raw::c_void,
    ) -> VAMessageCallback;
}
pub type VANativeDisplay = *mut ::std::os::raw::c_void;
extern "C" {
    pub fn vaDisplayIsValid(dpy: VADisplay) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vaSetDriverName(dpy: VADisplay, driver_name: *mut ::std::os::raw::c_char) -> VAStatus;
}
extern "C" {
    pub fn vaInitialize(
        dpy: VADisplay,
        major_version: *mut ::std::os::raw::c_int,
        minor_version: *mut ::std::os::raw::c_int,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaTerminate(dpy: VADisplay) -> VAStatus;
}
extern "C" {
    pub fn vaQueryVendorString(dpy: VADisplay) -> *const ::std::os::raw::c_char;
}
pub type VAPrivFunc = ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>;
extern "C" {
    pub fn vaGetLibFunc(dpy: VADisplay, func: *const ::std::os::raw::c_char) -> VAPrivFunc;
}
pub const VAProfile_VAProfileNone: VAProfile = -1;
pub const VAProfile_VAProfileMPEG2Simple: VAProfile = 0;
pub const VAProfile_VAProfileMPEG2Main: VAProfile = 1;
pub const VAProfile_VAProfileMPEG4Simple: VAProfile = 2;
pub const VAProfile_VAProfileMPEG4AdvancedSimple: VAProfile = 3;
pub const VAProfile_VAProfileMPEG4Main: VAProfile = 4;
pub const VAProfile_VAProfileH264Baseline: VAProfile = 5;
pub const VAProfile_VAProfileH264Main: VAProfile = 6;
pub const VAProfile_VAProfileH264High: VAProfile = 7;
pub const VAProfile_VAProfileVC1Simple: VAProfile = 8;
pub const VAProfile_VAProfileVC1Main: VAProfile = 9;
pub const VAProfile_VAProfileVC1Advanced: VAProfile = 10;
pub const VAProfile_VAProfileH263Baseline: VAProfile = 11;
pub const VAProfile_VAProfileJPEGBaseline: VAProfile = 12;
pub const VAProfile_VAProfileH264ConstrainedBaseline: VAProfile = 13;
pub const VAProfile_VAProfileVP8Version0_3: VAProfile = 14;
pub const VAProfile_VAProfileH264MultiviewHigh: VAProfile = 15;
pub const VAProfile_VAProfileH264StereoHigh: VAProfile = 16;
pub const VAProfile_VAProfileHEVCMain: VAProfile = 17;
pub const VAProfile_VAProfileHEVCMain10: VAProfile = 18;
pub const VAProfile_VAProfileVP9Profile0: VAProfile = 19;
pub const VAProfile_VAProfileVP9Profile1: VAProfile = 20;
pub const VAProfile_VAProfileVP9Profile2: VAProfile = 21;
pub const VAProfile_VAProfileVP9Profile3: VAProfile = 22;
pub const VAProfile_VAProfileHEVCMain12: VAProfile = 23;
pub const VAProfile_VAProfileHEVCMain422_10: VAProfile = 24;
pub const VAProfile_VAProfileHEVCMain422_12: VAProfile = 25;
pub const VAProfile_VAProfileHEVCMain444: VAProfile = 26;
pub const VAProfile_VAProfileHEVCMain444_10: VAProfile = 27;
pub const VAProfile_VAProfileHEVCMain444_12: VAProfile = 28;
pub const VAProfile_VAProfileHEVCSccMain: VAProfile = 29;
pub const VAProfile_VAProfileHEVCSccMain10: VAProfile = 30;
pub const VAProfile_VAProfileHEVCSccMain444: VAProfile = 31;
pub const VAProfile_VAProfileAV1Profile0: VAProfile = 32;
pub const VAProfile_VAProfileAV1Profile1: VAProfile = 33;
pub const VAProfile_VAProfileHEVCSccMain444_10: VAProfile = 34;
pub const VAProfile_VAProfileProtected: VAProfile = 35;
pub type VAProfile = ::std::os::raw::c_int;
pub const VAEntrypoint_VAEntrypointVLD: VAEntrypoint = 1;
pub const VAEntrypoint_VAEntrypointIZZ: VAEntrypoint = 2;
pub const VAEntrypoint_VAEntrypointIDCT: VAEntrypoint = 3;
pub const VAEntrypoint_VAEntrypointMoComp: VAEntrypoint = 4;
pub const VAEntrypoint_VAEntrypointDeblocking: VAEntrypoint = 5;
pub const VAEntrypoint_VAEntrypointEncSlice: VAEntrypoint = 6;
pub const VAEntrypoint_VAEntrypointEncPicture: VAEntrypoint = 7;
pub const VAEntrypoint_VAEntrypointEncSliceLP: VAEntrypoint = 8;
pub const VAEntrypoint_VAEntrypointVideoProc: VAEntrypoint = 10;
pub const VAEntrypoint_VAEntrypointFEI: VAEntrypoint = 11;
pub const VAEntrypoint_VAEntrypointStats: VAEntrypoint = 12;
pub const VAEntrypoint_VAEntrypointProtectedTEEComm: VAEntrypoint = 13;
pub const VAEntrypoint_VAEntrypointProtectedContent: VAEntrypoint = 14;
pub type VAEntrypoint = ::std::os::raw::c_uint;
pub const VAConfigAttribType_VAConfigAttribRTFormat: VAConfigAttribType = 0;
pub const VAConfigAttribType_VAConfigAttribSpatialResidual: VAConfigAttribType = 1;
pub const VAConfigAttribType_VAConfigAttribSpatialClipping: VAConfigAttribType = 2;
pub const VAConfigAttribType_VAConfigAttribIntraResidual: VAConfigAttribType = 3;
pub const VAConfigAttribType_VAConfigAttribEncryption: VAConfigAttribType = 4;
pub const VAConfigAttribType_VAConfigAttribRateControl: VAConfigAttribType = 5;
pub const VAConfigAttribType_VAConfigAttribDecSliceMode: VAConfigAttribType = 6;
pub const VAConfigAttribType_VAConfigAttribDecJPEG: VAConfigAttribType = 7;
pub const VAConfigAttribType_VAConfigAttribDecProcessing: VAConfigAttribType = 8;
pub const VAConfigAttribType_VAConfigAttribEncPackedHeaders: VAConfigAttribType = 10;
pub const VAConfigAttribType_VAConfigAttribEncInterlaced: VAConfigAttribType = 11;
pub const VAConfigAttribType_VAConfigAttribEncMaxRefFrames: VAConfigAttribType = 13;
pub const VAConfigAttribType_VAConfigAttribEncMaxSlices: VAConfigAttribType = 14;
pub const VAConfigAttribType_VAConfigAttribEncSliceStructure: VAConfigAttribType = 15;
pub const VAConfigAttribType_VAConfigAttribEncMacroblockInfo: VAConfigAttribType = 16;
pub const VAConfigAttribType_VAConfigAttribMaxPictureWidth: VAConfigAttribType = 18;
pub const VAConfigAttribType_VAConfigAttribMaxPictureHeight: VAConfigAttribType = 19;
pub const VAConfigAttribType_VAConfigAttribEncJPEG: VAConfigAttribType = 20;
pub const VAConfigAttribType_VAConfigAttribEncQualityRange: VAConfigAttribType = 21;
pub const VAConfigAttribType_VAConfigAttribEncQuantization: VAConfigAttribType = 22;
pub const VAConfigAttribType_VAConfigAttribEncIntraRefresh: VAConfigAttribType = 23;
pub const VAConfigAttribType_VAConfigAttribEncSkipFrame: VAConfigAttribType = 24;
pub const VAConfigAttribType_VAConfigAttribEncROI: VAConfigAttribType = 25;
pub const VAConfigAttribType_VAConfigAttribEncRateControlExt: VAConfigAttribType = 26;
pub const VAConfigAttribType_VAConfigAttribProcessingRate: VAConfigAttribType = 27;
pub const VAConfigAttribType_VAConfigAttribEncDirtyRect: VAConfigAttribType = 28;
pub const VAConfigAttribType_VAConfigAttribEncParallelRateControl: VAConfigAttribType = 29;
pub const VAConfigAttribType_VAConfigAttribEncDynamicScaling: VAConfigAttribType = 30;
pub const VAConfigAttribType_VAConfigAttribFrameSizeToleranceSupport: VAConfigAttribType = 31;
pub const VAConfigAttribType_VAConfigAttribFEIFunctionType: VAConfigAttribType = 32;
pub const VAConfigAttribType_VAConfigAttribFEIMVPredictors: VAConfigAttribType = 33;
pub const VAConfigAttribType_VAConfigAttribStats: VAConfigAttribType = 34;
pub const VAConfigAttribType_VAConfigAttribEncTileSupport: VAConfigAttribType = 35;
pub const VAConfigAttribType_VAConfigAttribCustomRoundingControl: VAConfigAttribType = 36;
pub const VAConfigAttribType_VAConfigAttribQPBlockSize: VAConfigAttribType = 37;
pub const VAConfigAttribType_VAConfigAttribMaxFrameSize: VAConfigAttribType = 38;
pub const VAConfigAttribType_VAConfigAttribPredictionDirection: VAConfigAttribType = 39;
pub const VAConfigAttribType_VAConfigAttribMultipleFrame: VAConfigAttribType = 40;
pub const VAConfigAttribType_VAConfigAttribContextPriority: VAConfigAttribType = 41;
pub const VAConfigAttribType_VAConfigAttribDecAV1Features: VAConfigAttribType = 42;
pub const VAConfigAttribType_VAConfigAttribTEEType: VAConfigAttribType = 43;
pub const VAConfigAttribType_VAConfigAttribTEETypeClient: VAConfigAttribType = 44;
pub const VAConfigAttribType_VAConfigAttribProtectedContentCipherAlgorithm: VAConfigAttribType = 45;
pub const VAConfigAttribType_VAConfigAttribProtectedContentCipherBlockSize: VAConfigAttribType = 46;
pub const VAConfigAttribType_VAConfigAttribProtectedContentCipherMode: VAConfigAttribType = 47;
pub const VAConfigAttribType_VAConfigAttribProtectedContentCipherSampleType: VAConfigAttribType =
    48;
pub const VAConfigAttribType_VAConfigAttribProtectedContentUsage: VAConfigAttribType = 49;
pub const VAConfigAttribType_VAConfigAttribEncHEVCFeatures: VAConfigAttribType = 50;
pub const VAConfigAttribType_VAConfigAttribEncHEVCBlockSizes: VAConfigAttribType = 51;
pub const VAConfigAttribType_VAConfigAttribTypeMax: VAConfigAttribType = 52;
pub type VAConfigAttribType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAConfigAttrib {
    pub type_: VAConfigAttribType,
    pub value: u32,
}
#[test]
fn bindgen_test_layout__VAConfigAttrib() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttrib>(),
        8usize,
        concat!("Size of: ", stringify!(_VAConfigAttrib))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttrib>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAConfigAttrib))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAConfigAttrib>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttrib),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAConfigAttrib>())).value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttrib),
            "::",
            stringify!(value)
        )
    );
}
pub type VAConfigAttrib = _VAConfigAttrib;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAConfigAttribValDecJPEG {
    pub bits: _VAConfigAttribValDecJPEG__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAConfigAttribValDecJPEG__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAConfigAttribValDecJPEG__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValDecJPEG__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAConfigAttribValDecJPEG__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValDecJPEG__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAConfigAttribValDecJPEG__bindgen_ty_1)
        )
    );
}
impl _VAConfigAttribValDecJPEG__bindgen_ty_1 {
    #[inline]
    pub fn rotation(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_rotation(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(rotation: u32, reserved: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let rotation: u32 = unsafe { ::std::mem::transmute(rotation) };
            rotation as u64
        });
        __bindgen_bitfield_unit.set(4usize, 28u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAConfigAttribValDecJPEG() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValDecJPEG>(),
        4usize,
        concat!("Size of: ", stringify!(_VAConfigAttribValDecJPEG))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValDecJPEG>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAConfigAttribValDecJPEG))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAConfigAttribValDecJPEG>())).bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValDecJPEG),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAConfigAttribValDecJPEG>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValDecJPEG),
            "::",
            stringify!(value)
        )
    );
}
pub type VAConfigAttribValDecJPEG = _VAConfigAttribValDecJPEG;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAConfigAttribValMaxFrameSize {
    pub bits: _VAConfigAttribValMaxFrameSize__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAConfigAttribValMaxFrameSize__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAConfigAttribValMaxFrameSize__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValMaxFrameSize__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAConfigAttribValMaxFrameSize__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValMaxFrameSize__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAConfigAttribValMaxFrameSize__bindgen_ty_1)
        )
    );
}
impl _VAConfigAttribValMaxFrameSize__bindgen_ty_1 {
    #[inline]
    pub fn max_frame_size(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_max_frame_size(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn multiple_pass(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_multiple_pass(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        max_frame_size: u32,
        multiple_pass: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let max_frame_size: u32 = unsafe { ::std::mem::transmute(max_frame_size) };
            max_frame_size as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let multiple_pass: u32 = unsafe { ::std::mem::transmute(multiple_pass) };
            multiple_pass as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAConfigAttribValMaxFrameSize() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValMaxFrameSize>(),
        4usize,
        concat!("Size of: ", stringify!(_VAConfigAttribValMaxFrameSize))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValMaxFrameSize>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAConfigAttribValMaxFrameSize))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAConfigAttribValMaxFrameSize>())).bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValMaxFrameSize),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAConfigAttribValMaxFrameSize>())).value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValMaxFrameSize),
            "::",
            stringify!(value)
        )
    );
}
pub type VAConfigAttribValMaxFrameSize = _VAConfigAttribValMaxFrameSize;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAConfigAttribValEncJPEG {
    pub bits: _VAConfigAttribValEncJPEG__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAConfigAttribValEncJPEG__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout__VAConfigAttribValEncJPEG__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValEncJPEG__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAConfigAttribValEncJPEG__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValEncJPEG__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAConfigAttribValEncJPEG__bindgen_ty_1)
        )
    );
}
impl _VAConfigAttribValEncJPEG__bindgen_ty_1 {
    #[inline]
    pub fn arithmatic_coding_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_arithmatic_coding_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn progressive_dct_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_progressive_dct_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn non_interleaved_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_non_interleaved_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn differential_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_differential_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn max_num_components(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_max_num_components(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn max_num_scans(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_max_num_scans(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn max_num_huffman_tables(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_max_num_huffman_tables(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn max_num_quantization_tables(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_max_num_quantization_tables(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        arithmatic_coding_mode: u32,
        progressive_dct_mode: u32,
        non_interleaved_mode: u32,
        differential_mode: u32,
        max_num_components: u32,
        max_num_scans: u32,
        max_num_huffman_tables: u32,
        max_num_quantization_tables: u32,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let arithmatic_coding_mode: u32 =
                unsafe { ::std::mem::transmute(arithmatic_coding_mode) };
            arithmatic_coding_mode as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let progressive_dct_mode: u32 = unsafe { ::std::mem::transmute(progressive_dct_mode) };
            progressive_dct_mode as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let non_interleaved_mode: u32 = unsafe { ::std::mem::transmute(non_interleaved_mode) };
            non_interleaved_mode as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let differential_mode: u32 = unsafe { ::std::mem::transmute(differential_mode) };
            differential_mode as u64
        });
        __bindgen_bitfield_unit.set(4usize, 3u8, {
            let max_num_components: u32 = unsafe { ::std::mem::transmute(max_num_components) };
            max_num_components as u64
        });
        __bindgen_bitfield_unit.set(7usize, 4u8, {
            let max_num_scans: u32 = unsafe { ::std::mem::transmute(max_num_scans) };
            max_num_scans as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let max_num_huffman_tables: u32 =
                unsafe { ::std::mem::transmute(max_num_huffman_tables) };
            max_num_huffman_tables as u64
        });
        __bindgen_bitfield_unit.set(14usize, 3u8, {
            let max_num_quantization_tables: u32 =
                unsafe { ::std::mem::transmute(max_num_quantization_tables) };
            max_num_quantization_tables as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAConfigAttribValEncJPEG() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValEncJPEG>(),
        4usize,
        concat!("Size of: ", stringify!(_VAConfigAttribValEncJPEG))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValEncJPEG>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAConfigAttribValEncJPEG))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAConfigAttribValEncJPEG>())).bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValEncJPEG),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAConfigAttribValEncJPEG>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValEncJPEG),
            "::",
            stringify!(value)
        )
    );
}
pub type VAConfigAttribValEncJPEG = _VAConfigAttribValEncJPEG;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAConfigAttribValEncROI {
    pub bits: _VAConfigAttribValEncROI__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAConfigAttribValEncROI__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAConfigAttribValEncROI__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValEncROI__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAConfigAttribValEncROI__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValEncROI__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAConfigAttribValEncROI__bindgen_ty_1)
        )
    );
}
impl _VAConfigAttribValEncROI__bindgen_ty_1 {
    #[inline]
    pub fn num_roi_regions(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_num_roi_regions(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn roi_rc_priority_support(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_roi_rc_priority_support(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn roi_rc_qp_delta_support(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_roi_rc_qp_delta_support(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 22u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 22u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        num_roi_regions: u32,
        roi_rc_priority_support: u32,
        roi_rc_qp_delta_support: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let num_roi_regions: u32 = unsafe { ::std::mem::transmute(num_roi_regions) };
            num_roi_regions as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let roi_rc_priority_support: u32 =
                unsafe { ::std::mem::transmute(roi_rc_priority_support) };
            roi_rc_priority_support as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let roi_rc_qp_delta_support: u32 =
                unsafe { ::std::mem::transmute(roi_rc_qp_delta_support) };
            roi_rc_qp_delta_support as u64
        });
        __bindgen_bitfield_unit.set(10usize, 22u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAConfigAttribValEncROI() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValEncROI>(),
        4usize,
        concat!("Size of: ", stringify!(_VAConfigAttribValEncROI))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValEncROI>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAConfigAttribValEncROI))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAConfigAttribValEncROI>())).bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValEncROI),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAConfigAttribValEncROI>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValEncROI),
            "::",
            stringify!(value)
        )
    );
}
pub type VAConfigAttribValEncROI = _VAConfigAttribValEncROI;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAConfigAttribValEncRateControlExt {
    pub bits: _VAConfigAttribValEncRateControlExt__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAConfigAttribValEncRateControlExt__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAConfigAttribValEncRateControlExt__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValEncRateControlExt__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAConfigAttribValEncRateControlExt__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValEncRateControlExt__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAConfigAttribValEncRateControlExt__bindgen_ty_1)
        )
    );
}
impl _VAConfigAttribValEncRateControlExt__bindgen_ty_1 {
    #[inline]
    pub fn max_num_temporal_layers_minus1(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_max_num_temporal_layers_minus1(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn temporal_layer_bitrate_control_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_temporal_layer_bitrate_control_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 23u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 23u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        max_num_temporal_layers_minus1: u32,
        temporal_layer_bitrate_control_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let max_num_temporal_layers_minus1: u32 =
                unsafe { ::std::mem::transmute(max_num_temporal_layers_minus1) };
            max_num_temporal_layers_minus1 as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let temporal_layer_bitrate_control_flag: u32 =
                unsafe { ::std::mem::transmute(temporal_layer_bitrate_control_flag) };
            temporal_layer_bitrate_control_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 23u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAConfigAttribValEncRateControlExt() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValEncRateControlExt>(),
        4usize,
        concat!("Size of: ", stringify!(_VAConfigAttribValEncRateControlExt))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValEncRateControlExt>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAConfigAttribValEncRateControlExt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAConfigAttribValEncRateControlExt>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValEncRateControlExt),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAConfigAttribValEncRateControlExt>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValEncRateControlExt),
            "::",
            stringify!(value)
        )
    );
}
pub type VAConfigAttribValEncRateControlExt = _VAConfigAttribValEncRateControlExt;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAConfigAttribValMultipleFrame {
    pub bits: _VAConfigAttribValMultipleFrame__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAConfigAttribValMultipleFrame__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAConfigAttribValMultipleFrame__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValMultipleFrame__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAConfigAttribValMultipleFrame__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValMultipleFrame__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAConfigAttribValMultipleFrame__bindgen_ty_1)
        )
    );
}
impl _VAConfigAttribValMultipleFrame__bindgen_ty_1 {
    #[inline]
    pub fn max_num_concurrent_frames(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_max_num_concurrent_frames(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn mixed_quality_level(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mixed_quality_level(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 23u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 23u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        max_num_concurrent_frames: u32,
        mixed_quality_level: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let max_num_concurrent_frames: u32 =
                unsafe { ::std::mem::transmute(max_num_concurrent_frames) };
            max_num_concurrent_frames as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let mixed_quality_level: u32 = unsafe { ::std::mem::transmute(mixed_quality_level) };
            mixed_quality_level as u64
        });
        __bindgen_bitfield_unit.set(9usize, 23u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAConfigAttribValMultipleFrame() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValMultipleFrame>(),
        4usize,
        concat!("Size of: ", stringify!(_VAConfigAttribValMultipleFrame))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValMultipleFrame>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAConfigAttribValMultipleFrame))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAConfigAttribValMultipleFrame>())).bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValMultipleFrame),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAConfigAttribValMultipleFrame>())).value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValMultipleFrame),
            "::",
            stringify!(value)
        )
    );
}
pub type VAConfigAttribValMultipleFrame = _VAConfigAttribValMultipleFrame;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAConfigAttribValContextPriority {
    pub bits: _VAConfigAttribValContextPriority__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAConfigAttribValContextPriority__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAConfigAttribValContextPriority__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValContextPriority__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAConfigAttribValContextPriority__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValContextPriority__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAConfigAttribValContextPriority__bindgen_ty_1)
        )
    );
}
impl _VAConfigAttribValContextPriority__bindgen_ty_1 {
    #[inline]
    pub fn priority(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_priority(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(priority: u32, reserved: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let priority: u32 = unsafe { ::std::mem::transmute(priority) };
            priority as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAConfigAttribValContextPriority() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValContextPriority>(),
        4usize,
        concat!("Size of: ", stringify!(_VAConfigAttribValContextPriority))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValContextPriority>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAConfigAttribValContextPriority)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAConfigAttribValContextPriority>())).bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValContextPriority),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAConfigAttribValContextPriority>())).value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValContextPriority),
            "::",
            stringify!(value)
        )
    );
}
pub type VAConfigAttribValContextPriority = _VAConfigAttribValContextPriority;
extern "C" {
    pub fn vaMaxNumProfiles(dpy: VADisplay) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vaMaxNumEntrypoints(dpy: VADisplay) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vaMaxNumConfigAttributes(dpy: VADisplay) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vaQueryConfigProfiles(
        dpy: VADisplay,
        profile_list: *mut VAProfile,
        num_profiles: *mut ::std::os::raw::c_int,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaQueryConfigEntrypoints(
        dpy: VADisplay,
        profile: VAProfile,
        entrypoint_list: *mut VAEntrypoint,
        num_entrypoints: *mut ::std::os::raw::c_int,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaGetConfigAttributes(
        dpy: VADisplay,
        profile: VAProfile,
        entrypoint: VAEntrypoint,
        attrib_list: *mut VAConfigAttrib,
        num_attribs: ::std::os::raw::c_int,
    ) -> VAStatus;
}
pub type VAGenericID = ::std::os::raw::c_uint;
pub type VAConfigID = VAGenericID;
extern "C" {
    pub fn vaCreateConfig(
        dpy: VADisplay,
        profile: VAProfile,
        entrypoint: VAEntrypoint,
        attrib_list: *mut VAConfigAttrib,
        num_attribs: ::std::os::raw::c_int,
        config_id: *mut VAConfigID,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaDestroyConfig(dpy: VADisplay, config_id: VAConfigID) -> VAStatus;
}
extern "C" {
    pub fn vaQueryConfigAttributes(
        dpy: VADisplay,
        config_id: VAConfigID,
        profile: *mut VAProfile,
        entrypoint: *mut VAEntrypoint,
        attrib_list: *mut VAConfigAttrib,
        num_attribs: *mut ::std::os::raw::c_int,
    ) -> VAStatus;
}
pub type VAContextID = VAGenericID;
pub type VASurfaceID = VAGenericID;
pub const VAGenericValueType_VAGenericValueTypeInteger: VAGenericValueType = 1;
pub const VAGenericValueType_VAGenericValueTypeFloat: VAGenericValueType = 2;
pub const VAGenericValueType_VAGenericValueTypePointer: VAGenericValueType = 3;
pub const VAGenericValueType_VAGenericValueTypeFunc: VAGenericValueType = 4;
pub type VAGenericValueType = ::std::os::raw::c_uint;
pub type VAGenericFunc = ::std::option::Option<unsafe extern "C" fn()>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAGenericValue {
    pub type_: VAGenericValueType,
    pub value: _VAGenericValue__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAGenericValue__bindgen_ty_1 {
    pub i: i32,
    pub f: f32,
    pub p: *mut ::std::os::raw::c_void,
    pub fn_: VAGenericFunc,
}
#[test]
fn bindgen_test_layout__VAGenericValue__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAGenericValue__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_VAGenericValue__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAGenericValue__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_VAGenericValue__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAGenericValue__bindgen_ty_1>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAGenericValue__bindgen_ty_1),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAGenericValue__bindgen_ty_1>())).f as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAGenericValue__bindgen_ty_1),
            "::",
            stringify!(f)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAGenericValue__bindgen_ty_1>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAGenericValue__bindgen_ty_1),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAGenericValue__bindgen_ty_1>())).fn_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAGenericValue__bindgen_ty_1),
            "::",
            stringify!(fn_)
        )
    );
}
#[test]
fn bindgen_test_layout__VAGenericValue() {
    assert_eq!(
        ::std::mem::size_of::<_VAGenericValue>(),
        16usize,
        concat!("Size of: ", stringify!(_VAGenericValue))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAGenericValue>(),
        8usize,
        concat!("Alignment of ", stringify!(_VAGenericValue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAGenericValue>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAGenericValue),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAGenericValue>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAGenericValue),
            "::",
            stringify!(value)
        )
    );
}
pub type VAGenericValue = _VAGenericValue;
pub const VASurfaceAttribType_VASurfaceAttribNone: VASurfaceAttribType = 0;
pub const VASurfaceAttribType_VASurfaceAttribPixelFormat: VASurfaceAttribType = 1;
pub const VASurfaceAttribType_VASurfaceAttribMinWidth: VASurfaceAttribType = 2;
pub const VASurfaceAttribType_VASurfaceAttribMaxWidth: VASurfaceAttribType = 3;
pub const VASurfaceAttribType_VASurfaceAttribMinHeight: VASurfaceAttribType = 4;
pub const VASurfaceAttribType_VASurfaceAttribMaxHeight: VASurfaceAttribType = 5;
pub const VASurfaceAttribType_VASurfaceAttribMemoryType: VASurfaceAttribType = 6;
pub const VASurfaceAttribType_VASurfaceAttribExternalBufferDescriptor: VASurfaceAttribType = 7;
pub const VASurfaceAttribType_VASurfaceAttribUsageHint: VASurfaceAttribType = 8;
pub const VASurfaceAttribType_VASurfaceAttribDRMFormatModifiers: VASurfaceAttribType = 9;
pub const VASurfaceAttribType_VASurfaceAttribCount: VASurfaceAttribType = 10;
pub type VASurfaceAttribType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VASurfaceAttrib {
    pub type_: VASurfaceAttribType,
    pub flags: u32,
    pub value: VAGenericValue,
}
#[test]
fn bindgen_test_layout__VASurfaceAttrib() {
    assert_eq!(
        ::std::mem::size_of::<_VASurfaceAttrib>(),
        24usize,
        concat!("Size of: ", stringify!(_VASurfaceAttrib))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASurfaceAttrib>(),
        8usize,
        concat!("Alignment of ", stringify!(_VASurfaceAttrib))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VASurfaceAttrib>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttrib),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VASurfaceAttrib>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttrib),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VASurfaceAttrib>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttrib),
            "::",
            stringify!(value)
        )
    );
}
pub type VASurfaceAttrib = _VASurfaceAttrib;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASurfaceAttribExternalBuffers {
    pub pixel_format: u32,
    pub width: u32,
    pub height: u32,
    pub data_size: u32,
    pub num_planes: u32,
    pub pitches: [u32; 4usize],
    pub offsets: [u32; 4usize],
    pub buffers: *mut usize,
    pub num_buffers: u32,
    pub flags: u32,
    pub private_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout__VASurfaceAttribExternalBuffers() {
    assert_eq!(
        ::std::mem::size_of::<_VASurfaceAttribExternalBuffers>(),
        80usize,
        concat!("Size of: ", stringify!(_VASurfaceAttribExternalBuffers))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASurfaceAttribExternalBuffers>(),
        8usize,
        concat!("Alignment of ", stringify!(_VASurfaceAttribExternalBuffers))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).pixel_format as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(pixel_format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).width as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).height as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).data_size as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).num_planes as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(num_planes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).pitches as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(pitches)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).offsets as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(offsets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).buffers as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(buffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).num_buffers as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(num_buffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).flags as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceAttribExternalBuffers>())).private_data as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceAttribExternalBuffers),
            "::",
            stringify!(private_data)
        )
    );
}
pub type VASurfaceAttribExternalBuffers = _VASurfaceAttribExternalBuffers;
extern "C" {
    pub fn vaQuerySurfaceAttributes(
        dpy: VADisplay,
        config: VAConfigID,
        attrib_list: *mut VASurfaceAttrib,
        num_attribs: *mut ::std::os::raw::c_uint,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaCreateSurfaces(
        dpy: VADisplay,
        format: ::std::os::raw::c_uint,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
        surfaces: *mut VASurfaceID,
        num_surfaces: ::std::os::raw::c_uint,
        attrib_list: *mut VASurfaceAttrib,
        num_attribs: ::std::os::raw::c_uint,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaDestroySurfaces(
        dpy: VADisplay,
        surfaces: *mut VASurfaceID,
        num_surfaces: ::std::os::raw::c_int,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaCreateContext(
        dpy: VADisplay,
        config_id: VAConfigID,
        picture_width: ::std::os::raw::c_int,
        picture_height: ::std::os::raw::c_int,
        flag: ::std::os::raw::c_int,
        render_targets: *mut VASurfaceID,
        num_render_targets: ::std::os::raw::c_int,
        context: *mut VAContextID,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaDestroyContext(dpy: VADisplay, context: VAContextID) -> VAStatus;
}
pub type VAMFContextID = VAGenericID;
extern "C" {
    pub fn vaCreateMFContext(dpy: VADisplay, mf_context: *mut VAMFContextID) -> VAStatus;
}
extern "C" {
    pub fn vaMFAddContext(
        dpy: VADisplay,
        mf_context: VAMFContextID,
        context: VAContextID,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaMFReleaseContext(
        dpy: VADisplay,
        mf_context: VAMFContextID,
        context: VAContextID,
    ) -> VAStatus;
}
pub type VABufferID = VAGenericID;
pub const VABufferType_VAPictureParameterBufferType: VABufferType = 0;
pub const VABufferType_VAIQMatrixBufferType: VABufferType = 1;
pub const VABufferType_VABitPlaneBufferType: VABufferType = 2;
pub const VABufferType_VASliceGroupMapBufferType: VABufferType = 3;
pub const VABufferType_VASliceParameterBufferType: VABufferType = 4;
pub const VABufferType_VASliceDataBufferType: VABufferType = 5;
pub const VABufferType_VAMacroblockParameterBufferType: VABufferType = 6;
pub const VABufferType_VAResidualDataBufferType: VABufferType = 7;
pub const VABufferType_VADeblockingParameterBufferType: VABufferType = 8;
pub const VABufferType_VAImageBufferType: VABufferType = 9;
pub const VABufferType_VAProtectedSliceDataBufferType: VABufferType = 10;
pub const VABufferType_VAQMatrixBufferType: VABufferType = 11;
pub const VABufferType_VAHuffmanTableBufferType: VABufferType = 12;
pub const VABufferType_VAProbabilityBufferType: VABufferType = 13;
pub const VABufferType_VAEncCodedBufferType: VABufferType = 21;
pub const VABufferType_VAEncSequenceParameterBufferType: VABufferType = 22;
pub const VABufferType_VAEncPictureParameterBufferType: VABufferType = 23;
pub const VABufferType_VAEncSliceParameterBufferType: VABufferType = 24;
pub const VABufferType_VAEncPackedHeaderParameterBufferType: VABufferType = 25;
pub const VABufferType_VAEncPackedHeaderDataBufferType: VABufferType = 26;
pub const VABufferType_VAEncMiscParameterBufferType: VABufferType = 27;
pub const VABufferType_VAEncMacroblockParameterBufferType: VABufferType = 28;
pub const VABufferType_VAEncMacroblockMapBufferType: VABufferType = 29;
pub const VABufferType_VAEncQPBufferType: VABufferType = 30;
pub const VABufferType_VAProcPipelineParameterBufferType: VABufferType = 41;
pub const VABufferType_VAProcFilterParameterBufferType: VABufferType = 42;
pub const VABufferType_VAEncFEIMVBufferType: VABufferType = 43;
pub const VABufferType_VAEncFEIMBCodeBufferType: VABufferType = 44;
pub const VABufferType_VAEncFEIDistortionBufferType: VABufferType = 45;
pub const VABufferType_VAEncFEIMBControlBufferType: VABufferType = 46;
pub const VABufferType_VAEncFEIMVPredictorBufferType: VABufferType = 47;
pub const VABufferType_VAStatsStatisticsParameterBufferType: VABufferType = 48;
pub const VABufferType_VAStatsStatisticsBufferType: VABufferType = 49;
pub const VABufferType_VAStatsStatisticsBottomFieldBufferType: VABufferType = 50;
pub const VABufferType_VAStatsMVBufferType: VABufferType = 51;
pub const VABufferType_VAStatsMVPredictorBufferType: VABufferType = 52;
pub const VABufferType_VAEncMacroblockDisableSkipMapBufferType: VABufferType = 53;
pub const VABufferType_VAEncFEICTBCmdBufferType: VABufferType = 54;
pub const VABufferType_VAEncFEICURecordBufferType: VABufferType = 55;
pub const VABufferType_VADecodeStreamoutBufferType: VABufferType = 56;
pub const VABufferType_VASubsetsParameterBufferType: VABufferType = 57;
pub const VABufferType_VAContextParameterUpdateBufferType: VABufferType = 58;
pub const VABufferType_VAProtectedSessionExecuteBufferType: VABufferType = 59;
pub const VABufferType_VAEncryptionParameterBufferType: VABufferType = 60;
pub const VABufferType_VABufferTypeMax: VABufferType = 61;
pub type VABufferType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAContextParameterUpdateBuffer {
    pub flags: _VAContextParameterUpdateBuffer__bindgen_ty_1,
    pub context_priority: VAConfigAttribValContextPriority,
    pub reserved: [u32; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAContextParameterUpdateBuffer__bindgen_ty_1 {
    pub bits: _VAContextParameterUpdateBuffer__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAContextParameterUpdateBuffer__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAContextParameterUpdateBuffer__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAContextParameterUpdateBuffer__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAContextParameterUpdateBuffer__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAContextParameterUpdateBuffer__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAContextParameterUpdateBuffer__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAContextParameterUpdateBuffer__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn context_priority_update(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_context_priority_update(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        context_priority_update: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let context_priority_update: u32 =
                unsafe { ::std::mem::transmute(context_priority_update) };
            context_priority_update as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAContextParameterUpdateBuffer__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAContextParameterUpdateBuffer__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAContextParameterUpdateBuffer__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAContextParameterUpdateBuffer__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAContextParameterUpdateBuffer__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAContextParameterUpdateBuffer__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAContextParameterUpdateBuffer__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAContextParameterUpdateBuffer__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAContextParameterUpdateBuffer__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAContextParameterUpdateBuffer() {
    assert_eq!(
        ::std::mem::size_of::<_VAContextParameterUpdateBuffer>(),
        40usize,
        concat!("Size of: ", stringify!(_VAContextParameterUpdateBuffer))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAContextParameterUpdateBuffer>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAContextParameterUpdateBuffer))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAContextParameterUpdateBuffer>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAContextParameterUpdateBuffer),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAContextParameterUpdateBuffer>())).context_priority as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAContextParameterUpdateBuffer),
            "::",
            stringify!(context_priority)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAContextParameterUpdateBuffer>())).reserved as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAContextParameterUpdateBuffer),
            "::",
            stringify!(reserved)
        )
    );
}
pub type VAContextParameterUpdateBuffer = _VAContextParameterUpdateBuffer;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncryptionSegmentInfo {
    pub segment_start_offset: u32,
    pub segment_length: u32,
    pub partial_aes_block_size: u32,
    pub init_byte_length: u32,
    pub aes_cbc_iv_or_ctr: [u8; 64usize],
    pub va_reserved: [u32; 8usize],
}
#[test]
fn bindgen_test_layout__VAEncryptionSegmentInfo() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncryptionSegmentInfo>(),
        112usize,
        concat!("Size of: ", stringify!(_VAEncryptionSegmentInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncryptionSegmentInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncryptionSegmentInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionSegmentInfo>())).segment_start_offset as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionSegmentInfo),
            "::",
            stringify!(segment_start_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionSegmentInfo>())).segment_length as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionSegmentInfo),
            "::",
            stringify!(segment_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionSegmentInfo>())).partial_aes_block_size as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionSegmentInfo),
            "::",
            stringify!(partial_aes_block_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionSegmentInfo>())).init_byte_length as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionSegmentInfo),
            "::",
            stringify!(init_byte_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionSegmentInfo>())).aes_cbc_iv_or_ctr as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionSegmentInfo),
            "::",
            stringify!(aes_cbc_iv_or_ctr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionSegmentInfo>())).va_reserved as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionSegmentInfo),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncryptionSegmentInfo = _VAEncryptionSegmentInfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncryptionParameters {
    pub encryption_type: u32,
    pub num_segments: u32,
    pub segment_info: *mut VAEncryptionSegmentInfo,
    pub status_report_index: u32,
    pub size_of_length: u32,
    pub wrapped_decrypt_blob: [u8; 64usize],
    pub wrapped_encrypt_blob: [u8; 64usize],
    pub key_blob_size: u32,
    pub blocks_stripe_encrypted: u32,
    pub blocks_stripe_clear: u32,
    pub va_reserved: [u32; 8usize],
}
#[test]
fn bindgen_test_layout__VAEncryptionParameters() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncryptionParameters>(),
        200usize,
        concat!("Size of: ", stringify!(_VAEncryptionParameters))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncryptionParameters>(),
        8usize,
        concat!("Alignment of ", stringify!(_VAEncryptionParameters))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).encryption_type as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(encryption_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).num_segments as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(num_segments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).segment_info as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(segment_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).status_report_index as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(status_report_index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).size_of_length as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(size_of_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).wrapped_decrypt_blob as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(wrapped_decrypt_blob)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).wrapped_encrypt_blob as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(wrapped_encrypt_blob)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).key_blob_size as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(key_blob_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).blocks_stripe_encrypted as *const _
                as usize
        },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(blocks_stripe_encrypted)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).blocks_stripe_clear as *const _
                as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(blocks_stripe_clear)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncryptionParameters>())).va_reserved as *const _ as usize
        },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncryptionParameters),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncryptionParameters = _VAEncryptionParameters;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAProcessingRateParameterEnc {
    pub level_idc: u8,
    pub reserved: [u8; 3usize],
    pub quality_level: u32,
    pub intra_period: u32,
    pub ip_period: u32,
}
#[test]
fn bindgen_test_layout__VAProcessingRateParameterEnc() {
    assert_eq!(
        ::std::mem::size_of::<_VAProcessingRateParameterEnc>(),
        16usize,
        concat!("Size of: ", stringify!(_VAProcessingRateParameterEnc))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAProcessingRateParameterEnc>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAProcessingRateParameterEnc))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProcessingRateParameterEnc>())).level_idc as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProcessingRateParameterEnc),
            "::",
            stringify!(level_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProcessingRateParameterEnc>())).reserved as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProcessingRateParameterEnc),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProcessingRateParameterEnc>())).quality_level as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProcessingRateParameterEnc),
            "::",
            stringify!(quality_level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProcessingRateParameterEnc>())).intra_period as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProcessingRateParameterEnc),
            "::",
            stringify!(intra_period)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProcessingRateParameterEnc>())).ip_period as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProcessingRateParameterEnc),
            "::",
            stringify!(ip_period)
        )
    );
}
pub type VAProcessingRateParameterEnc = _VAProcessingRateParameterEnc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAProcessingRateParameterDec {
    pub level_idc: u8,
    pub reserved0: [u8; 3usize],
    pub reserved: u32,
}
#[test]
fn bindgen_test_layout__VAProcessingRateParameterDec() {
    assert_eq!(
        ::std::mem::size_of::<_VAProcessingRateParameterDec>(),
        8usize,
        concat!("Size of: ", stringify!(_VAProcessingRateParameterDec))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAProcessingRateParameterDec>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAProcessingRateParameterDec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProcessingRateParameterDec>())).level_idc as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProcessingRateParameterDec),
            "::",
            stringify!(level_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProcessingRateParameterDec>())).reserved0 as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProcessingRateParameterDec),
            "::",
            stringify!(reserved0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProcessingRateParameterDec>())).reserved as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProcessingRateParameterDec),
            "::",
            stringify!(reserved)
        )
    );
}
pub type VAProcessingRateParameterDec = _VAProcessingRateParameterDec;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAProcessingRateParameter {
    pub __bindgen_anon_1: _VAProcessingRateParameter__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAProcessingRateParameter__bindgen_ty_1 {
    pub proc_buf_enc: VAProcessingRateParameterEnc,
    pub proc_buf_dec: VAProcessingRateParameterDec,
}
#[test]
fn bindgen_test_layout__VAProcessingRateParameter__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAProcessingRateParameter__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(_VAProcessingRateParameter__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAProcessingRateParameter__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAProcessingRateParameter__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProcessingRateParameter__bindgen_ty_1>())).proc_buf_enc
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProcessingRateParameter__bindgen_ty_1),
            "::",
            stringify!(proc_buf_enc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProcessingRateParameter__bindgen_ty_1>())).proc_buf_dec
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProcessingRateParameter__bindgen_ty_1),
            "::",
            stringify!(proc_buf_dec)
        )
    );
}
#[test]
fn bindgen_test_layout__VAProcessingRateParameter() {
    assert_eq!(
        ::std::mem::size_of::<_VAProcessingRateParameter>(),
        16usize,
        concat!("Size of: ", stringify!(_VAProcessingRateParameter))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAProcessingRateParameter>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAProcessingRateParameter))
    );
}
pub type VAProcessingRateParameter = _VAProcessingRateParameter;
extern "C" {
    pub fn vaQueryProcessingRate(
        dpy: VADisplay,
        config: VAConfigID,
        proc_buf: *mut VAProcessingRateParameter,
        processing_rate: *mut ::std::os::raw::c_uint,
    ) -> VAStatus;
}
pub const VAEncMiscParameterType_VAEncMiscParameterTypeFrameRate: VAEncMiscParameterType = 0;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeRateControl: VAEncMiscParameterType = 1;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeMaxSliceSize: VAEncMiscParameterType = 2;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeAIR: VAEncMiscParameterType = 3;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeMaxFrameSize: VAEncMiscParameterType = 4;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeHRD: VAEncMiscParameterType = 5;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeQualityLevel: VAEncMiscParameterType = 6;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeRIR: VAEncMiscParameterType = 7;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeQuantization: VAEncMiscParameterType = 8;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeSkipFrame: VAEncMiscParameterType = 9;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeROI: VAEncMiscParameterType = 10;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeMultiPassFrameSize: VAEncMiscParameterType =
    11;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeTemporalLayerStructure:
    VAEncMiscParameterType = 12;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeDirtyRect: VAEncMiscParameterType = 13;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeParallelBRC: VAEncMiscParameterType = 14;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeSubMbPartPel: VAEncMiscParameterType = 15;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeEncQuality: VAEncMiscParameterType = 16;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeCustomRoundingControl:
    VAEncMiscParameterType = 17;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeFEIFrameControl: VAEncMiscParameterType = 18;
pub const VAEncMiscParameterType_VAEncMiscParameterTypeExtensionData: VAEncMiscParameterType = 19;
pub type VAEncMiscParameterType = ::std::os::raw::c_uint;
pub const VAEncPackedHeaderType_VAEncPackedHeaderSequence: VAEncPackedHeaderType = 1;
pub const VAEncPackedHeaderType_VAEncPackedHeaderPicture: VAEncPackedHeaderType = 2;
pub const VAEncPackedHeaderType_VAEncPackedHeaderSlice: VAEncPackedHeaderType = 3;
pub const VAEncPackedHeaderType_VAEncPackedHeaderRawData: VAEncPackedHeaderType = 4;
pub const VAEncPackedHeaderType_VAEncPackedHeaderMiscMask: VAEncPackedHeaderType = 2147483648;
pub type VAEncPackedHeaderType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncPackedHeaderParameterBuffer {
    pub type_: u32,
    pub bit_length: u32,
    pub has_emulation_bytes: u8,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncPackedHeaderParameterBuffer() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncPackedHeaderParameterBuffer>(),
        28usize,
        concat!("Size of: ", stringify!(_VAEncPackedHeaderParameterBuffer))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncPackedHeaderParameterBuffer>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncPackedHeaderParameterBuffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPackedHeaderParameterBuffer>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPackedHeaderParameterBuffer),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPackedHeaderParameterBuffer>())).bit_length as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPackedHeaderParameterBuffer),
            "::",
            stringify!(bit_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPackedHeaderParameterBuffer>())).has_emulation_bytes
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPackedHeaderParameterBuffer),
            "::",
            stringify!(has_emulation_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPackedHeaderParameterBuffer>())).va_reserved as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPackedHeaderParameterBuffer),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncPackedHeaderParameterBuffer = _VAEncPackedHeaderParameterBuffer;
#[repr(C)]
#[derive(Debug)]
pub struct _VAEncMiscParameterBuffer {
    pub type_: VAEncMiscParameterType,
    pub data: __IncompleteArrayField<u32>,
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterBuffer() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterBuffer>(),
        4usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterBuffer))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterBuffer>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterBuffer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAEncMiscParameterBuffer>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBuffer),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAEncMiscParameterBuffer>())).data as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBuffer),
            "::",
            stringify!(data)
        )
    );
}
pub type VAEncMiscParameterBuffer = _VAEncMiscParameterBuffer;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterTemporalLayerStructure {
    pub number_of_layers: u32,
    pub periodicity: u32,
    pub layer_id: [u32; 32usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterTemporalLayerStructure() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterTemporalLayerStructure>(),
        152usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterTemporalLayerStructure)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterTemporalLayerStructure>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterTemporalLayerStructure)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterTemporalLayerStructure>())).number_of_layers
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterTemporalLayerStructure),
            "::",
            stringify!(number_of_layers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterTemporalLayerStructure>())).periodicity
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterTemporalLayerStructure),
            "::",
            stringify!(periodicity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterTemporalLayerStructure>())).layer_id
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterTemporalLayerStructure),
            "::",
            stringify!(layer_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterTemporalLayerStructure>())).va_reserved
                as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterTemporalLayerStructure),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterTemporalLayerStructure = _VAEncMiscParameterTemporalLayerStructure;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncMiscParameterRateControl {
    pub bits_per_second: u32,
    pub target_percentage: u32,
    pub window_size: u32,
    pub initial_qp: u32,
    pub min_qp: u32,
    pub basic_unit_size: u32,
    pub rc_flags: _VAEncMiscParameterRateControl__bindgen_ty_1,
    pub ICQ_quality_factor: u32,
    pub max_qp: u32,
    pub quality_factor: u32,
    pub target_frame_size: u32,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncMiscParameterRateControl__bindgen_ty_1 {
    pub bits: _VAEncMiscParameterRateControl__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterRateControl__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterRateControl__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterRateControl__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterRateControl__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterRateControl__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterRateControl__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncMiscParameterRateControl__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn reset(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reset(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn disable_frame_skip(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_disable_frame_skip(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn disable_bit_stuffing(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_disable_bit_stuffing(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mb_rate_control(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_mb_rate_control(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn temporal_id(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_temporal_id(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn cfs_I_frames(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cfs_I_frames(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_parallel_brc(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_parallel_brc(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_dynamic_scaling(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_dynamic_scaling(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_tolerance_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_frame_tolerance_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 12u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 12u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        reset: u32,
        disable_frame_skip: u32,
        disable_bit_stuffing: u32,
        mb_rate_control: u32,
        temporal_id: u32,
        cfs_I_frames: u32,
        enable_parallel_brc: u32,
        enable_dynamic_scaling: u32,
        frame_tolerance_mode: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let reset: u32 = unsafe { ::std::mem::transmute(reset) };
            reset as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let disable_frame_skip: u32 = unsafe { ::std::mem::transmute(disable_frame_skip) };
            disable_frame_skip as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let disable_bit_stuffing: u32 = unsafe { ::std::mem::transmute(disable_bit_stuffing) };
            disable_bit_stuffing as u64
        });
        __bindgen_bitfield_unit.set(3usize, 4u8, {
            let mb_rate_control: u32 = unsafe { ::std::mem::transmute(mb_rate_control) };
            mb_rate_control as u64
        });
        __bindgen_bitfield_unit.set(7usize, 8u8, {
            let temporal_id: u32 = unsafe { ::std::mem::transmute(temporal_id) };
            temporal_id as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let cfs_I_frames: u32 = unsafe { ::std::mem::transmute(cfs_I_frames) };
            cfs_I_frames as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let enable_parallel_brc: u32 = unsafe { ::std::mem::transmute(enable_parallel_brc) };
            enable_parallel_brc as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let enable_dynamic_scaling: u32 =
                unsafe { ::std::mem::transmute(enable_dynamic_scaling) };
            enable_dynamic_scaling as u64
        });
        __bindgen_bitfield_unit.set(18usize, 2u8, {
            let frame_tolerance_mode: u32 = unsafe { ::std::mem::transmute(frame_tolerance_mode) };
            frame_tolerance_mode as u64
        });
        __bindgen_bitfield_unit.set(20usize, 12u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterRateControl__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterRateControl__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterRateControl__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterRateControl__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterRateControl__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterRateControl() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterRateControl>(),
        60usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterRateControl))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterRateControl>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterRateControl))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).bits_per_second as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(bits_per_second)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).target_percentage as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(target_percentage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).window_size as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(window_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).initial_qp as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(initial_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).min_qp as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(min_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).basic_unit_size as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(basic_unit_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).rc_flags as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(rc_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).ICQ_quality_factor
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(ICQ_quality_factor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).max_qp as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(max_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).quality_factor as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(quality_factor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).target_frame_size as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(target_frame_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRateControl>())).va_reserved as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRateControl),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterRateControl = _VAEncMiscParameterRateControl;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncMiscParameterFrameRate {
    pub framerate: u32,
    pub framerate_flags: _VAEncMiscParameterFrameRate__bindgen_ty_1,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncMiscParameterFrameRate__bindgen_ty_1 {
    pub bits: _VAEncMiscParameterFrameRate__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterFrameRate__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterFrameRate__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterFrameRate__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterFrameRate__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterFrameRate__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterFrameRate__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncMiscParameterFrameRate__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn temporal_id(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_temporal_id(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(temporal_id: u32, reserved: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let temporal_id: u32 = unsafe { ::std::mem::transmute(temporal_id) };
            temporal_id as u64
        });
        __bindgen_bitfield_unit.set(8usize, 24u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterFrameRate__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterFrameRate__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterFrameRate__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterFrameRate__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterFrameRate__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterFrameRate__bindgen_ty_1>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterFrameRate__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterFrameRate__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterFrameRate__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterFrameRate() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterFrameRate>(),
        24usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterFrameRate))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterFrameRate>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterFrameRate))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterFrameRate>())).framerate as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterFrameRate),
            "::",
            stringify!(framerate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterFrameRate>())).framerate_flags as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterFrameRate),
            "::",
            stringify!(framerate_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterFrameRate>())).va_reserved as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterFrameRate),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterFrameRate = _VAEncMiscParameterFrameRate;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterMaxSliceSize {
    pub max_slice_size: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterMaxSliceSize() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterMaxSliceSize>(),
        20usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterMaxSliceSize))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterMaxSliceSize>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterMaxSliceSize))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterMaxSliceSize>())).max_slice_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterMaxSliceSize),
            "::",
            stringify!(max_slice_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterMaxSliceSize>())).va_reserved as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterMaxSliceSize),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterMaxSliceSize = _VAEncMiscParameterMaxSliceSize;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterAIR {
    pub air_num_mbs: u32,
    pub air_threshold: u32,
    pub air_auto: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterAIR() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterAIR>(),
        28usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterAIR))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterAIR>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterAIR))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterAIR>())).air_num_mbs as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterAIR),
            "::",
            stringify!(air_num_mbs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterAIR>())).air_threshold as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterAIR),
            "::",
            stringify!(air_threshold)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAEncMiscParameterAIR>())).air_auto as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterAIR),
            "::",
            stringify!(air_auto)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterAIR>())).va_reserved as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterAIR),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterAIR = _VAEncMiscParameterAIR;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncMiscParameterRIR {
    pub rir_flags: _VAEncMiscParameterRIR__bindgen_ty_1,
    pub intra_insertion_location: u16,
    pub intra_insert_size: u16,
    pub qp_delta_for_inserted_intra: u8,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncMiscParameterRIR__bindgen_ty_1 {
    pub bits: _VAEncMiscParameterRIR__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterRIR__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterRIR__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterRIR__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterRIR__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterRIR__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterRIR__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncMiscParameterRIR__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn enable_rir_column(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_rir_column(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_rir_row(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_rir_row(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        enable_rir_column: u32,
        enable_rir_row: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let enable_rir_column: u32 = unsafe { ::std::mem::transmute(enable_rir_column) };
            enable_rir_column as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let enable_rir_row: u32 = unsafe { ::std::mem::transmute(enable_rir_row) };
            enable_rir_row as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterRIR__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterRIR__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterRIR__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterRIR__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterRIR__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRIR__bindgen_ty_1>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRIR__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRIR__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRIR__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterRIR() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterRIR>(),
        28usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterRIR))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterRIR>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterRIR))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRIR>())).rir_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRIR),
            "::",
            stringify!(rir_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRIR>())).intra_insertion_location as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRIR),
            "::",
            stringify!(intra_insertion_location)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRIR>())).intra_insert_size as *const _
                as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRIR),
            "::",
            stringify!(intra_insert_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRIR>())).qp_delta_for_inserted_intra
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRIR),
            "::",
            stringify!(qp_delta_for_inserted_intra)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterRIR>())).va_reserved as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterRIR),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterRIR = _VAEncMiscParameterRIR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterHRD {
    pub initial_buffer_fullness: u32,
    pub buffer_size: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterHRD() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterHRD>(),
        24usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterHRD))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterHRD>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterHRD))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterHRD>())).initial_buffer_fullness as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterHRD),
            "::",
            stringify!(initial_buffer_fullness)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterHRD>())).buffer_size as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterHRD),
            "::",
            stringify!(buffer_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterHRD>())).va_reserved as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterHRD),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterHRD = _VAEncMiscParameterHRD;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterBufferMaxFrameSize {
    pub type_: VAEncMiscParameterType,
    pub max_frame_size: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterBufferMaxFrameSize() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterBufferMaxFrameSize>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterBufferMaxFrameSize)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterBufferMaxFrameSize>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterBufferMaxFrameSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferMaxFrameSize>())).type_ as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferMaxFrameSize),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferMaxFrameSize>())).max_frame_size
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferMaxFrameSize),
            "::",
            stringify!(max_frame_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferMaxFrameSize>())).va_reserved
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferMaxFrameSize),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterBufferMaxFrameSize = _VAEncMiscParameterBufferMaxFrameSize;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterBufferMultiPassFrameSize {
    pub type_: VAEncMiscParameterType,
    pub max_frame_size: u32,
    pub reserved: u32,
    pub num_passes: u8,
    pub delta_qp: *mut u8,
    pub va_reserved: [::std::os::raw::c_ulong; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterBufferMultiPassFrameSize() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterBufferMultiPassFrameSize>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterBufferMultiPassFrameSize)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterBufferMultiPassFrameSize>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterBufferMultiPassFrameSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferMultiPassFrameSize>())).type_
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferMultiPassFrameSize),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferMultiPassFrameSize>())).max_frame_size
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferMultiPassFrameSize),
            "::",
            stringify!(max_frame_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferMultiPassFrameSize>())).reserved
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferMultiPassFrameSize),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferMultiPassFrameSize>())).num_passes
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferMultiPassFrameSize),
            "::",
            stringify!(num_passes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferMultiPassFrameSize>())).delta_qp
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferMultiPassFrameSize),
            "::",
            stringify!(delta_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferMultiPassFrameSize>())).va_reserved
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferMultiPassFrameSize),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterBufferMultiPassFrameSize = _VAEncMiscParameterBufferMultiPassFrameSize;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterBufferQualityLevel {
    pub quality_level: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterBufferQualityLevel() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterBufferQualityLevel>(),
        20usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterBufferQualityLevel)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterBufferQualityLevel>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterBufferQualityLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferQualityLevel>())).quality_level
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferQualityLevel),
            "::",
            stringify!(quality_level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferQualityLevel>())).va_reserved
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferQualityLevel),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterBufferQualityLevel = _VAEncMiscParameterBufferQualityLevel;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncMiscParameterQuantization {
    pub quantization_flags: _VAEncMiscParameterQuantization__bindgen_ty_1,
    pub va_reserved: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncMiscParameterQuantization__bindgen_ty_1 {
    pub bits: _VAEncMiscParameterQuantization__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterQuantization__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterQuantization__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterQuantization__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterQuantization__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterQuantization__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterQuantization__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncMiscParameterQuantization__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn disable_trellis(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_disable_trellis(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_trellis_I(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_trellis_I(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_trellis_P(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_trellis_P(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_trellis_B(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_trellis_B(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        disable_trellis: u32,
        enable_trellis_I: u32,
        enable_trellis_P: u32,
        enable_trellis_B: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let disable_trellis: u32 = unsafe { ::std::mem::transmute(disable_trellis) };
            disable_trellis as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let enable_trellis_I: u32 = unsafe { ::std::mem::transmute(enable_trellis_I) };
            enable_trellis_I as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let enable_trellis_P: u32 = unsafe { ::std::mem::transmute(enable_trellis_P) };
            enable_trellis_P as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let enable_trellis_B: u32 = unsafe { ::std::mem::transmute(enable_trellis_B) };
            enable_trellis_B as u64
        });
        __bindgen_bitfield_unit.set(4usize, 28u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterQuantization__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterQuantization__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterQuantization__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterQuantization__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterQuantization__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterQuantization__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterQuantization__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterQuantization__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterQuantization__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterQuantization() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterQuantization>(),
        8usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterQuantization))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterQuantization>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterQuantization))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterQuantization>())).quantization_flags
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterQuantization),
            "::",
            stringify!(quantization_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterQuantization>())).va_reserved as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterQuantization),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterQuantization = _VAEncMiscParameterQuantization;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterSkipFrame {
    pub skip_frame_flag: u8,
    pub num_skip_frames: u8,
    pub size_skip_frames: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterSkipFrame() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterSkipFrame>(),
        24usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterSkipFrame))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterSkipFrame>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterSkipFrame))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterSkipFrame>())).skip_frame_flag as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterSkipFrame),
            "::",
            stringify!(skip_frame_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterSkipFrame>())).num_skip_frames as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterSkipFrame),
            "::",
            stringify!(num_skip_frames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterSkipFrame>())).size_skip_frames as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterSkipFrame),
            "::",
            stringify!(size_skip_frames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterSkipFrame>())).va_reserved as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterSkipFrame),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterSkipFrame = _VAEncMiscParameterSkipFrame;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncROI {
    pub roi_rectangle: VARectangle,
    pub roi_value: i8,
}
#[test]
fn bindgen_test_layout__VAEncROI() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncROI>(),
        10usize,
        concat!("Size of: ", stringify!(_VAEncROI))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncROI>(),
        2usize,
        concat!("Alignment of ", stringify!(_VAEncROI))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAEncROI>())).roi_rectangle as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncROI),
            "::",
            stringify!(roi_rectangle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAEncROI>())).roi_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncROI),
            "::",
            stringify!(roi_value)
        )
    );
}
pub type VAEncROI = _VAEncROI;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncMiscParameterBufferROI {
    pub num_roi: u32,
    pub max_delta_qp: i8,
    pub min_delta_qp: i8,
    pub roi: *mut VAEncROI,
    pub roi_flags: _VAEncMiscParameterBufferROI__bindgen_ty_1,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncMiscParameterBufferROI__bindgen_ty_1 {
    pub bits: _VAEncMiscParameterBufferROI__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterBufferROI__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterBufferROI__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterBufferROI__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterBufferROI__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterBufferROI__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterBufferROI__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncMiscParameterBufferROI__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn roi_value_is_qp_delta(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_roi_value_is_qp_delta(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        roi_value_is_qp_delta: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let roi_value_is_qp_delta: u32 =
                unsafe { ::std::mem::transmute(roi_value_is_qp_delta) };
            roi_value_is_qp_delta as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterBufferROI__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterBufferROI__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterBufferROI__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterBufferROI__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterBufferROI__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferROI__bindgen_ty_1>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferROI__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferROI__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferROI__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterBufferROI() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterBufferROI>(),
        40usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterBufferROI))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterBufferROI>(),
        8usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterBufferROI))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferROI>())).num_roi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferROI),
            "::",
            stringify!(num_roi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferROI>())).max_delta_qp as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferROI),
            "::",
            stringify!(max_delta_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferROI>())).min_delta_qp as *const _
                as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferROI),
            "::",
            stringify!(min_delta_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferROI>())).roi as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferROI),
            "::",
            stringify!(roi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferROI>())).roi_flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferROI),
            "::",
            stringify!(roi_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferROI>())).va_reserved as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferROI),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncMiscParameterBufferROI = _VAEncMiscParameterBufferROI;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterBufferDirtyRect {
    pub num_roi_rectangle: u32,
    pub roi_rectangle: *mut VARectangle,
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterBufferDirtyRect() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterBufferDirtyRect>(),
        16usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterBufferDirtyRect))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterBufferDirtyRect>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterBufferDirtyRect)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferDirtyRect>())).num_roi_rectangle
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferDirtyRect),
            "::",
            stringify!(num_roi_rectangle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterBufferDirtyRect>())).roi_rectangle as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterBufferDirtyRect),
            "::",
            stringify!(roi_rectangle)
        )
    );
}
pub type VAEncMiscParameterBufferDirtyRect = _VAEncMiscParameterBufferDirtyRect;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterParallelRateControl {
    pub num_layers: u32,
    pub num_b_in_gop: *mut u32,
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterParallelRateControl() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterParallelRateControl>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterParallelRateControl)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterParallelRateControl>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterParallelRateControl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterParallelRateControl>())).num_layers
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterParallelRateControl),
            "::",
            stringify!(num_layers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterParallelRateControl>())).num_b_in_gop
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterParallelRateControl),
            "::",
            stringify!(num_b_in_gop)
        )
    );
}
pub type VAEncMiscParameterParallelRateControl = _VAEncMiscParameterParallelRateControl;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncMiscParameterEncQuality {
    pub __bindgen_anon_1: _VAEncMiscParameterEncQuality__bindgen_ty_1,
    pub FTQSkipThresholdLUT: [u8; 52usize],
    pub NonFTQSkipThresholdLUT: [u16; 52usize],
    pub reserved: [u32; 16usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncMiscParameterEncQuality__bindgen_ty_1 {
    pub __bindgen_anon_1: _VAEncMiscParameterEncQuality__bindgen_ty_1__bindgen_ty_1,
    pub encControls: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterEncQuality__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterEncQuality__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterEncQuality__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterEncQuality__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterEncQuality__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterEncQuality__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncMiscParameterEncQuality__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn useRawPicForRef(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_useRawPicForRef(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn skipCheckDisable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_skipCheckDisable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn FTQOverride(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_FTQOverride(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn FTQEnable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_FTQEnable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn FTQSkipThresholdLUTInput(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_FTQSkipThresholdLUTInput(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn NonFTQSkipThresholdLUTInput(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_NonFTQSkipThresholdLUTInput(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ReservedBit(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ReservedBit(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn directBiasAdjustmentEnable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_directBiasAdjustmentEnable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn globalMotionBiasAdjustmentEnable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_globalMotionBiasAdjustmentEnable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn HMEMVCostScalingFactor(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_HMEMVCostScalingFactor(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn HMEDisable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_HMEDisable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn SuperHMEDisable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_SuperHMEDisable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn UltraHMEDisable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_UltraHMEDisable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn PanicModeDisable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_PanicModeDisable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ForceRepartitionCheck(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_ForceRepartitionCheck(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        useRawPicForRef: u32,
        skipCheckDisable: u32,
        FTQOverride: u32,
        FTQEnable: u32,
        FTQSkipThresholdLUTInput: u32,
        NonFTQSkipThresholdLUTInput: u32,
        ReservedBit: u32,
        directBiasAdjustmentEnable: u32,
        globalMotionBiasAdjustmentEnable: u32,
        HMEMVCostScalingFactor: u32,
        HMEDisable: u32,
        SuperHMEDisable: u32,
        UltraHMEDisable: u32,
        PanicModeDisable: u32,
        ForceRepartitionCheck: u32,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let useRawPicForRef: u32 = unsafe { ::std::mem::transmute(useRawPicForRef) };
            useRawPicForRef as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let skipCheckDisable: u32 = unsafe { ::std::mem::transmute(skipCheckDisable) };
            skipCheckDisable as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let FTQOverride: u32 = unsafe { ::std::mem::transmute(FTQOverride) };
            FTQOverride as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let FTQEnable: u32 = unsafe { ::std::mem::transmute(FTQEnable) };
            FTQEnable as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let FTQSkipThresholdLUTInput: u32 =
                unsafe { ::std::mem::transmute(FTQSkipThresholdLUTInput) };
            FTQSkipThresholdLUTInput as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let NonFTQSkipThresholdLUTInput: u32 =
                unsafe { ::std::mem::transmute(NonFTQSkipThresholdLUTInput) };
            NonFTQSkipThresholdLUTInput as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let ReservedBit: u32 = unsafe { ::std::mem::transmute(ReservedBit) };
            ReservedBit as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let directBiasAdjustmentEnable: u32 =
                unsafe { ::std::mem::transmute(directBiasAdjustmentEnable) };
            directBiasAdjustmentEnable as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let globalMotionBiasAdjustmentEnable: u32 =
                unsafe { ::std::mem::transmute(globalMotionBiasAdjustmentEnable) };
            globalMotionBiasAdjustmentEnable as u64
        });
        __bindgen_bitfield_unit.set(9usize, 2u8, {
            let HMEMVCostScalingFactor: u32 =
                unsafe { ::std::mem::transmute(HMEMVCostScalingFactor) };
            HMEMVCostScalingFactor as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let HMEDisable: u32 = unsafe { ::std::mem::transmute(HMEDisable) };
            HMEDisable as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let SuperHMEDisable: u32 = unsafe { ::std::mem::transmute(SuperHMEDisable) };
            SuperHMEDisable as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let UltraHMEDisable: u32 = unsafe { ::std::mem::transmute(UltraHMEDisable) };
            UltraHMEDisable as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let PanicModeDisable: u32 = unsafe { ::std::mem::transmute(PanicModeDisable) };
            PanicModeDisable as u64
        });
        __bindgen_bitfield_unit.set(15usize, 2u8, {
            let ForceRepartitionCheck: u32 =
                unsafe { ::std::mem::transmute(ForceRepartitionCheck) };
            ForceRepartitionCheck as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterEncQuality__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterEncQuality__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterEncQuality__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterEncQuality__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterEncQuality__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterEncQuality__bindgen_ty_1>())).encControls
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterEncQuality__bindgen_ty_1),
            "::",
            stringify!(encControls)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterEncQuality() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterEncQuality>(),
        224usize,
        concat!("Size of: ", stringify!(_VAEncMiscParameterEncQuality))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterEncQuality>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncMiscParameterEncQuality))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterEncQuality>())).FTQSkipThresholdLUT
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterEncQuality),
            "::",
            stringify!(FTQSkipThresholdLUT)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterEncQuality>())).NonFTQSkipThresholdLUT
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterEncQuality),
            "::",
            stringify!(NonFTQSkipThresholdLUT)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterEncQuality>())).reserved as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterEncQuality),
            "::",
            stringify!(reserved)
        )
    );
}
pub type VAEncMiscParameterEncQuality = _VAEncMiscParameterEncQuality;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncMiscParameterCustomRoundingControl {
    pub rounding_offset_setting: _VAEncMiscParameterCustomRoundingControl__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncMiscParameterCustomRoundingControl__bindgen_ty_1 {
    pub bits: _VAEncMiscParameterCustomRoundingControl__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncMiscParameterCustomRoundingControl__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterCustomRoundingControl__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1__bindgen_ty_1>(
        ),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1__bindgen_ty_1>(
        ),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncMiscParameterCustomRoundingControl__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn enable_custom_rouding_intra(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_custom_rouding_intra(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rounding_offset_intra(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_rounding_offset_intra(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_custom_rounding_inter(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_custom_rounding_inter(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rounding_offset_inter(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_rounding_offset_inter(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        enable_custom_rouding_intra: u32,
        rounding_offset_intra: u32,
        enable_custom_rounding_inter: u32,
        rounding_offset_inter: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let enable_custom_rouding_intra: u32 =
                unsafe { ::std::mem::transmute(enable_custom_rouding_intra) };
            enable_custom_rouding_intra as u64
        });
        __bindgen_bitfield_unit.set(1usize, 7u8, {
            let rounding_offset_intra: u32 =
                unsafe { ::std::mem::transmute(rounding_offset_intra) };
            rounding_offset_intra as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let enable_custom_rounding_inter: u32 =
                unsafe { ::std::mem::transmute(enable_custom_rounding_inter) };
            enable_custom_rounding_inter as u64
        });
        __bindgen_bitfield_unit.set(9usize, 7u8, {
            let rounding_offset_inter: u32 =
                unsafe { ::std::mem::transmute(rounding_offset_inter) };
            rounding_offset_inter as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterCustomRoundingControl__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterCustomRoundingControl__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncMiscParameterCustomRoundingControl() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncMiscParameterCustomRoundingControl>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncMiscParameterCustomRoundingControl)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncMiscParameterCustomRoundingControl>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncMiscParameterCustomRoundingControl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncMiscParameterCustomRoundingControl>()))
                .rounding_offset_setting as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncMiscParameterCustomRoundingControl),
            "::",
            stringify!(rounding_offset_setting)
        )
    );
}
pub type VAEncMiscParameterCustomRoundingControl = _VAEncMiscParameterCustomRoundingControl;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferBase {
    pub slice_data_size: u32,
    pub slice_data_offset: u32,
    pub slice_data_flag: u32,
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferBase() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferBase>(),
        12usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferBase))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferBase>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASliceParameterBufferBase))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferBase>())).slice_data_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferBase),
            "::",
            stringify!(slice_data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferBase>())).slice_data_offset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferBase),
            "::",
            stringify!(slice_data_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferBase>())).slice_data_flag as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferBase),
            "::",
            stringify!(slice_data_flag)
        )
    );
}
pub type VASliceParameterBufferBase = _VASliceParameterBufferBase;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAHuffmanTableBufferJPEGBaseline {
    pub load_huffman_table: [u8; 2usize],
    pub huffman_table: [_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1; 2usize],
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1 {
    pub num_dc_codes: [u8; 16usize],
    pub dc_values: [u8; 12usize],
    pub num_ac_codes: [u8; 16usize],
    pub ac_values: [u8; 162usize],
    pub pad: [u8; 2usize],
}
#[test]
fn bindgen_test_layout__VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1>(),
        208usize,
        concat!(
            "Size of: ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1>())).num_dc_codes
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(num_dc_codes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1>())).dc_values
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(dc_values)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1>())).num_ac_codes
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(num_ac_codes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1>())).ac_values
                as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(ac_values)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1>())).pad
                as *const _ as usize
        },
        206usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
}
#[test]
fn bindgen_test_layout__VAHuffmanTableBufferJPEGBaseline() {
    assert_eq!(
        ::std::mem::size_of::<_VAHuffmanTableBufferJPEGBaseline>(),
        436usize,
        concat!("Size of: ", stringify!(_VAHuffmanTableBufferJPEGBaseline))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAHuffmanTableBufferJPEGBaseline>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAHuffmanTableBufferJPEGBaseline>())).load_huffman_table
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline),
            "::",
            stringify!(load_huffman_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAHuffmanTableBufferJPEGBaseline>())).huffman_table as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline),
            "::",
            stringify!(huffman_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAHuffmanTableBufferJPEGBaseline>())).va_reserved as *const _
                as usize
        },
        420usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAHuffmanTableBufferJPEGBaseline),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAHuffmanTableBufferJPEGBaseline = _VAHuffmanTableBufferJPEGBaseline;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAPictureParameterBufferMPEG2 {
    pub horizontal_size: u16,
    pub vertical_size: u16,
    pub forward_reference_picture: VASurfaceID,
    pub backward_reference_picture: VASurfaceID,
    pub picture_coding_type: i32,
    pub f_code: i32,
    pub picture_coding_extension: _VAPictureParameterBufferMPEG2__bindgen_ty_1,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferMPEG2__bindgen_ty_1 {
    pub bits: _VAPictureParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn intra_dc_precision(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_intra_dc_precision(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn picture_structure(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_picture_structure(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn top_field_first(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_top_field_first(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_pred_frame_dct(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_pred_frame_dct(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn concealment_motion_vectors(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_concealment_motion_vectors(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn q_scale_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_q_scale_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_vlc_format(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_vlc_format(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn alternate_scan(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_alternate_scan(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn repeat_first_field(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_repeat_first_field(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn progressive_frame(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_progressive_frame(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_first_field(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_first_field(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        intra_dc_precision: u32,
        picture_structure: u32,
        top_field_first: u32,
        frame_pred_frame_dct: u32,
        concealment_motion_vectors: u32,
        q_scale_type: u32,
        intra_vlc_format: u32,
        alternate_scan: u32,
        repeat_first_field: u32,
        progressive_frame: u32,
        is_first_field: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let intra_dc_precision: u32 = unsafe { ::std::mem::transmute(intra_dc_precision) };
            intra_dc_precision as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let picture_structure: u32 = unsafe { ::std::mem::transmute(picture_structure) };
            picture_structure as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let top_field_first: u32 = unsafe { ::std::mem::transmute(top_field_first) };
            top_field_first as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let frame_pred_frame_dct: u32 = unsafe { ::std::mem::transmute(frame_pred_frame_dct) };
            frame_pred_frame_dct as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let concealment_motion_vectors: u32 =
                unsafe { ::std::mem::transmute(concealment_motion_vectors) };
            concealment_motion_vectors as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let q_scale_type: u32 = unsafe { ::std::mem::transmute(q_scale_type) };
            q_scale_type as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let intra_vlc_format: u32 = unsafe { ::std::mem::transmute(intra_vlc_format) };
            intra_vlc_format as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let alternate_scan: u32 = unsafe { ::std::mem::transmute(alternate_scan) };
            alternate_scan as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let repeat_first_field: u32 = unsafe { ::std::mem::transmute(repeat_first_field) };
            repeat_first_field as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let progressive_frame: u32 = unsafe { ::std::mem::transmute(progressive_frame) };
            progressive_frame as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let is_first_field: u32 = unsafe { ::std::mem::transmute(is_first_field) };
            is_first_field as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferMPEG2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferMPEG2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferMPEG2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferMPEG2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferMPEG2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG2__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG2__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG2__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG2__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferMPEG2() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferMPEG2>(),
        40usize,
        concat!("Size of: ", stringify!(_VAPictureParameterBufferMPEG2))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferMPEG2>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAPictureParameterBufferMPEG2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG2>())).horizontal_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG2),
            "::",
            stringify!(horizontal_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG2>())).vertical_size as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG2),
            "::",
            stringify!(vertical_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG2>())).forward_reference_picture
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG2),
            "::",
            stringify!(forward_reference_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG2>())).backward_reference_picture
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG2),
            "::",
            stringify!(backward_reference_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG2>())).picture_coding_type
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG2),
            "::",
            stringify!(picture_coding_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG2>())).f_code as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG2),
            "::",
            stringify!(f_code)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG2>())).picture_coding_extension
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG2),
            "::",
            stringify!(picture_coding_extension)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG2>())).va_reserved as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG2),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAPictureParameterBufferMPEG2 = _VAPictureParameterBufferMPEG2;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAIQMatrixBufferMPEG2 {
    pub load_intra_quantiser_matrix: i32,
    pub load_non_intra_quantiser_matrix: i32,
    pub load_chroma_intra_quantiser_matrix: i32,
    pub load_chroma_non_intra_quantiser_matrix: i32,
    pub intra_quantiser_matrix: [u8; 64usize],
    pub non_intra_quantiser_matrix: [u8; 64usize],
    pub chroma_intra_quantiser_matrix: [u8; 64usize],
    pub chroma_non_intra_quantiser_matrix: [u8; 64usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAIQMatrixBufferMPEG2() {
    assert_eq!(
        ::std::mem::size_of::<_VAIQMatrixBufferMPEG2>(),
        288usize,
        concat!("Size of: ", stringify!(_VAIQMatrixBufferMPEG2))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAIQMatrixBufferMPEG2>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAIQMatrixBufferMPEG2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG2>())).load_intra_quantiser_matrix
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG2),
            "::",
            stringify!(load_intra_quantiser_matrix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG2>())).load_non_intra_quantiser_matrix
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG2),
            "::",
            stringify!(load_non_intra_quantiser_matrix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG2>())).load_chroma_intra_quantiser_matrix
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG2),
            "::",
            stringify!(load_chroma_intra_quantiser_matrix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG2>()))
                .load_chroma_non_intra_quantiser_matrix as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG2),
            "::",
            stringify!(load_chroma_non_intra_quantiser_matrix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG2>())).intra_quantiser_matrix as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG2),
            "::",
            stringify!(intra_quantiser_matrix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG2>())).non_intra_quantiser_matrix
                as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG2),
            "::",
            stringify!(non_intra_quantiser_matrix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG2>())).chroma_intra_quantiser_matrix
                as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG2),
            "::",
            stringify!(chroma_intra_quantiser_matrix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG2>())).chroma_non_intra_quantiser_matrix
                as *const _ as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG2),
            "::",
            stringify!(chroma_non_intra_quantiser_matrix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG2>())).va_reserved as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG2),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAIQMatrixBufferMPEG2 = _VAIQMatrixBufferMPEG2;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferMPEG2 {
    pub slice_data_size: u32,
    pub slice_data_offset: u32,
    pub slice_data_flag: u32,
    pub macroblock_offset: u32,
    pub slice_horizontal_position: u32,
    pub slice_vertical_position: u32,
    pub quantiser_scale_code: i32,
    pub intra_slice_flag: i32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferMPEG2() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferMPEG2>(),
        48usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferMPEG2))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferMPEG2>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASliceParameterBufferMPEG2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG2>())).slice_data_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG2),
            "::",
            stringify!(slice_data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG2>())).slice_data_offset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG2),
            "::",
            stringify!(slice_data_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG2>())).slice_data_flag as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG2),
            "::",
            stringify!(slice_data_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG2>())).macroblock_offset as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG2),
            "::",
            stringify!(macroblock_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG2>())).slice_horizontal_position
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG2),
            "::",
            stringify!(slice_horizontal_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG2>())).slice_vertical_position
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG2),
            "::",
            stringify!(slice_vertical_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG2>())).quantiser_scale_code
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG2),
            "::",
            stringify!(quantiser_scale_code)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG2>())).intra_slice_flag as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG2),
            "::",
            stringify!(intra_slice_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG2>())).va_reserved as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG2),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASliceParameterBufferMPEG2 = _VASliceParameterBufferMPEG2;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAMacroblockParameterBufferMPEG2 {
    pub macroblock_address: u16,
    pub macroblock_type: u8,
    pub macroblock_modes: _VAMacroblockParameterBufferMPEG2__bindgen_ty_1,
    pub motion_vertical_field_select: u8,
    pub PMV: [[[i16; 2usize]; 2usize]; 2usize],
    pub coded_block_pattern: u16,
    pub num_skipped_macroblocks: u16,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAMacroblockParameterBufferMPEG2__bindgen_ty_1 {
    pub bits: _VAMacroblockParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAMacroblockParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout__VAMacroblockParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAMacroblockParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAMacroblockParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAMacroblockParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAMacroblockParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAMacroblockParameterBufferMPEG2__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn frame_motion_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_frame_motion_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn field_motion_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_field_motion_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn dct_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dct_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        frame_motion_type: u32,
        field_motion_type: u32,
        dct_type: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let frame_motion_type: u32 = unsafe { ::std::mem::transmute(frame_motion_type) };
            frame_motion_type as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let field_motion_type: u32 = unsafe { ::std::mem::transmute(field_motion_type) };
            field_motion_type as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let dct_type: u32 = unsafe { ::std::mem::transmute(dct_type) };
            dct_type as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAMacroblockParameterBufferMPEG2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAMacroblockParameterBufferMPEG2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAMacroblockParameterBufferMPEG2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAMacroblockParameterBufferMPEG2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAMacroblockParameterBufferMPEG2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAMacroblockParameterBufferMPEG2__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMacroblockParameterBufferMPEG2__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAMacroblockParameterBufferMPEG2__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMacroblockParameterBufferMPEG2__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAMacroblockParameterBufferMPEG2() {
    assert_eq!(
        ::std::mem::size_of::<_VAMacroblockParameterBufferMPEG2>(),
        48usize,
        concat!("Size of: ", stringify!(_VAMacroblockParameterBufferMPEG2))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAMacroblockParameterBufferMPEG2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAMacroblockParameterBufferMPEG2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAMacroblockParameterBufferMPEG2>())).macroblock_address
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMacroblockParameterBufferMPEG2),
            "::",
            stringify!(macroblock_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAMacroblockParameterBufferMPEG2>())).macroblock_type
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMacroblockParameterBufferMPEG2),
            "::",
            stringify!(macroblock_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAMacroblockParameterBufferMPEG2>())).macroblock_modes
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMacroblockParameterBufferMPEG2),
            "::",
            stringify!(macroblock_modes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAMacroblockParameterBufferMPEG2>()))
                .motion_vertical_field_select as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMacroblockParameterBufferMPEG2),
            "::",
            stringify!(motion_vertical_field_select)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAMacroblockParameterBufferMPEG2>())).PMV as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMacroblockParameterBufferMPEG2),
            "::",
            stringify!(PMV)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAMacroblockParameterBufferMPEG2>())).coded_block_pattern
                as *const _ as usize
        },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMacroblockParameterBufferMPEG2),
            "::",
            stringify!(coded_block_pattern)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAMacroblockParameterBufferMPEG2>())).num_skipped_macroblocks
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMacroblockParameterBufferMPEG2),
            "::",
            stringify!(num_skipped_macroblocks)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAMacroblockParameterBufferMPEG2>())).va_reserved as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAMacroblockParameterBufferMPEG2),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAMacroblockParameterBufferMPEG2 = _VAMacroblockParameterBufferMPEG2;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAPictureParameterBufferMPEG4 {
    pub vop_width: u16,
    pub vop_height: u16,
    pub forward_reference_picture: VASurfaceID,
    pub backward_reference_picture: VASurfaceID,
    pub vol_fields: _VAPictureParameterBufferMPEG4__bindgen_ty_1,
    pub no_of_sprite_warping_points: u8,
    pub sprite_trajectory_du: [i16; 3usize],
    pub sprite_trajectory_dv: [i16; 3usize],
    pub quant_precision: u8,
    pub vop_fields: _VAPictureParameterBufferMPEG4__bindgen_ty_2,
    pub vop_fcode_forward: u8,
    pub vop_fcode_backward: u8,
    pub vop_time_increment_resolution: u16,
    pub num_gobs_in_vop: u8,
    pub num_macroblocks_in_gob: u8,
    pub TRB: i16,
    pub TRD: i16,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferMPEG4__bindgen_ty_1 {
    pub bits: _VAPictureParameterBufferMPEG4__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferMPEG4__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferMPEG4__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferMPEG4__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferMPEG4__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferMPEG4__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn short_video_header(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_short_video_header(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_format(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_format(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn interlaced(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_interlaced(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn obmc_disable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_obmc_disable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sprite_enable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_sprite_enable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn sprite_warping_accuracy(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_sprite_warping_accuracy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn quant_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_quant_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn quarter_sample(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_quarter_sample(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_partitioned(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_data_partitioned(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reversible_vlc(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reversible_vlc(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn resync_marker_disable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_resync_marker_disable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        short_video_header: u32,
        chroma_format: u32,
        interlaced: u32,
        obmc_disable: u32,
        sprite_enable: u32,
        sprite_warping_accuracy: u32,
        quant_type: u32,
        quarter_sample: u32,
        data_partitioned: u32,
        reversible_vlc: u32,
        resync_marker_disable: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let short_video_header: u32 = unsafe { ::std::mem::transmute(short_video_header) };
            short_video_header as u64
        });
        __bindgen_bitfield_unit.set(1usize, 2u8, {
            let chroma_format: u32 = unsafe { ::std::mem::transmute(chroma_format) };
            chroma_format as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let interlaced: u32 = unsafe { ::std::mem::transmute(interlaced) };
            interlaced as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let obmc_disable: u32 = unsafe { ::std::mem::transmute(obmc_disable) };
            obmc_disable as u64
        });
        __bindgen_bitfield_unit.set(5usize, 2u8, {
            let sprite_enable: u32 = unsafe { ::std::mem::transmute(sprite_enable) };
            sprite_enable as u64
        });
        __bindgen_bitfield_unit.set(7usize, 2u8, {
            let sprite_warping_accuracy: u32 =
                unsafe { ::std::mem::transmute(sprite_warping_accuracy) };
            sprite_warping_accuracy as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let quant_type: u32 = unsafe { ::std::mem::transmute(quant_type) };
            quant_type as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let quarter_sample: u32 = unsafe { ::std::mem::transmute(quarter_sample) };
            quarter_sample as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let data_partitioned: u32 = unsafe { ::std::mem::transmute(data_partitioned) };
            data_partitioned as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let reversible_vlc: u32 = unsafe { ::std::mem::transmute(reversible_vlc) };
            reversible_vlc as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let resync_marker_disable: u32 =
                unsafe { ::std::mem::transmute(resync_marker_disable) };
            resync_marker_disable as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferMPEG4__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferMPEG4__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferMPEG4__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferMPEG4__bindgen_ty_2 {
    pub bits: _VAPictureParameterBufferMPEG4__bindgen_ty_2__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferMPEG4__bindgen_ty_2__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferMPEG4__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferMPEG4__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferMPEG4__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_2__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferMPEG4__bindgen_ty_2__bindgen_ty_1 {
    #[inline]
    pub fn vop_coding_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_vop_coding_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn backward_reference_vop_coding_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_backward_reference_vop_coding_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn vop_rounding_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vop_rounding_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_dc_vlc_thr(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_intra_dc_vlc_thr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn top_field_first(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_top_field_first(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn alternate_vertical_scan_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_alternate_vertical_scan_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        vop_coding_type: u32,
        backward_reference_vop_coding_type: u32,
        vop_rounding_type: u32,
        intra_dc_vlc_thr: u32,
        top_field_first: u32,
        alternate_vertical_scan_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let vop_coding_type: u32 = unsafe { ::std::mem::transmute(vop_coding_type) };
            vop_coding_type as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let backward_reference_vop_coding_type: u32 =
                unsafe { ::std::mem::transmute(backward_reference_vop_coding_type) };
            backward_reference_vop_coding_type as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let vop_rounding_type: u32 = unsafe { ::std::mem::transmute(vop_rounding_type) };
            vop_rounding_type as u64
        });
        __bindgen_bitfield_unit.set(5usize, 3u8, {
            let intra_dc_vlc_thr: u32 = unsafe { ::std::mem::transmute(intra_dc_vlc_thr) };
            intra_dc_vlc_thr as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let top_field_first: u32 = unsafe { ::std::mem::transmute(top_field_first) };
            top_field_first as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let alternate_vertical_scan_flag: u32 =
                unsafe { ::std::mem::transmute(alternate_vertical_scan_flag) };
            alternate_vertical_scan_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferMPEG4__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferMPEG4__bindgen_ty_2>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferMPEG4__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4__bindgen_ty_2>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_2),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4__bindgen_ty_2>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4__bindgen_ty_2),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferMPEG4() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferMPEG4>(),
        64usize,
        concat!("Size of: ", stringify!(_VAPictureParameterBufferMPEG4))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferMPEG4>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAPictureParameterBufferMPEG4))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).vop_width as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(vop_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).vop_height as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(vop_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).forward_reference_picture
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(forward_reference_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).backward_reference_picture
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(backward_reference_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).vol_fields as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(vol_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).no_of_sprite_warping_points
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(no_of_sprite_warping_points)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).sprite_trajectory_du
                as *const _ as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(sprite_trajectory_du)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).sprite_trajectory_dv
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(sprite_trajectory_dv)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).quant_precision as *const _
                as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(quant_precision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).vop_fields as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(vop_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).vop_fcode_forward as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(vop_fcode_forward)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).vop_fcode_backward
                as *const _ as usize
        },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(vop_fcode_backward)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).vop_time_increment_resolution
                as *const _ as usize
        },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(vop_time_increment_resolution)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).num_gobs_in_vop as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(num_gobs_in_vop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).num_macroblocks_in_gob
                as *const _ as usize
        },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(num_macroblocks_in_gob)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).TRB as *const _ as usize
        },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(TRB)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).TRD as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(TRD)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferMPEG4>())).va_reserved as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferMPEG4),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAPictureParameterBufferMPEG4 = _VAPictureParameterBufferMPEG4;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAIQMatrixBufferMPEG4 {
    pub load_intra_quant_mat: i32,
    pub load_non_intra_quant_mat: i32,
    pub intra_quant_mat: [u8; 64usize],
    pub non_intra_quant_mat: [u8; 64usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAIQMatrixBufferMPEG4() {
    assert_eq!(
        ::std::mem::size_of::<_VAIQMatrixBufferMPEG4>(),
        152usize,
        concat!("Size of: ", stringify!(_VAIQMatrixBufferMPEG4))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAIQMatrixBufferMPEG4>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAIQMatrixBufferMPEG4))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG4>())).load_intra_quant_mat as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG4),
            "::",
            stringify!(load_intra_quant_mat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG4>())).load_non_intra_quant_mat as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG4),
            "::",
            stringify!(load_non_intra_quant_mat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG4>())).intra_quant_mat as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG4),
            "::",
            stringify!(intra_quant_mat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG4>())).non_intra_quant_mat as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG4),
            "::",
            stringify!(non_intra_quant_mat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferMPEG4>())).va_reserved as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferMPEG4),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAIQMatrixBufferMPEG4 = _VAIQMatrixBufferMPEG4;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferMPEG4 {
    pub slice_data_size: u32,
    pub slice_data_offset: u32,
    pub slice_data_flag: u32,
    pub macroblock_offset: u32,
    pub macroblock_number: u32,
    pub quant_scale: i32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferMPEG4() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferMPEG4>(),
        40usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferMPEG4))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferMPEG4>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASliceParameterBufferMPEG4))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG4>())).slice_data_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG4),
            "::",
            stringify!(slice_data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG4>())).slice_data_offset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG4),
            "::",
            stringify!(slice_data_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG4>())).slice_data_flag as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG4),
            "::",
            stringify!(slice_data_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG4>())).macroblock_offset as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG4),
            "::",
            stringify!(macroblock_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG4>())).macroblock_number as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG4),
            "::",
            stringify!(macroblock_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG4>())).quant_scale as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG4),
            "::",
            stringify!(quant_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferMPEG4>())).va_reserved as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferMPEG4),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASliceParameterBufferMPEG4 = _VASliceParameterBufferMPEG4;
pub const VAMvModeVC1_VAMvMode1Mv: VAMvModeVC1 = 0;
pub const VAMvModeVC1_VAMvMode1MvHalfPel: VAMvModeVC1 = 1;
pub const VAMvModeVC1_VAMvMode1MvHalfPelBilinear: VAMvModeVC1 = 2;
pub const VAMvModeVC1_VAMvModeMixedMv: VAMvModeVC1 = 3;
pub const VAMvModeVC1_VAMvModeIntensityCompensation: VAMvModeVC1 = 4;
pub type VAMvModeVC1 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAPictureParameterBufferVC1 {
    pub forward_reference_picture: VASurfaceID,
    pub backward_reference_picture: VASurfaceID,
    pub inloop_decoded_picture: VASurfaceID,
    pub sequence_fields: _VAPictureParameterBufferVC1__bindgen_ty_1,
    pub coded_width: u16,
    pub coded_height: u16,
    pub entrypoint_fields: _VAPictureParameterBufferVC1__bindgen_ty_2,
    pub conditional_overlap_flag: u8,
    pub fast_uvmc_flag: u8,
    pub range_mapping_fields: _VAPictureParameterBufferVC1__bindgen_ty_3,
    pub b_picture_fraction: u8,
    pub cbp_table: u8,
    pub mb_mode_table: u8,
    pub range_reduction_frame: u8,
    pub rounding_control: u8,
    pub post_processing: u8,
    pub picture_resolution_index: u8,
    pub luma_scale: u8,
    pub luma_shift: u8,
    pub picture_fields: _VAPictureParameterBufferVC1__bindgen_ty_4,
    pub raw_coding: _VAPictureParameterBufferVC1__bindgen_ty_5,
    pub bitplane_present: _VAPictureParameterBufferVC1__bindgen_ty_6,
    pub reference_fields: _VAPictureParameterBufferVC1__bindgen_ty_7,
    pub mv_fields: _VAPictureParameterBufferVC1__bindgen_ty_8,
    pub pic_quantizer_fields: _VAPictureParameterBufferVC1__bindgen_ty_9,
    pub transform_fields: _VAPictureParameterBufferVC1__bindgen_ty_10,
    pub luma_scale2: u8,
    pub luma_shift2: u8,
    pub intensity_compensation_field: u8,
    pub va_reserved: [u32; 7usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVC1__bindgen_ty_1 {
    pub bits: _VAPictureParameterBufferVC1__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVC1__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVC1__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn pulldown(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pulldown(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn interlace(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_interlace(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tfcntrflag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tfcntrflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn finterpflag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_finterpflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn psf(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_psf(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn multires(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_multires(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overlap(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overlap(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn syncmarker(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_syncmarker(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rangered(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_rangered(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn max_b_frames(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_max_b_frames(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn profile(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_profile(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pulldown: u32,
        interlace: u32,
        tfcntrflag: u32,
        finterpflag: u32,
        psf: u32,
        multires: u32,
        overlap: u32,
        syncmarker: u32,
        rangered: u32,
        max_b_frames: u32,
        profile: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let pulldown: u32 = unsafe { ::std::mem::transmute(pulldown) };
            pulldown as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let interlace: u32 = unsafe { ::std::mem::transmute(interlace) };
            interlace as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let tfcntrflag: u32 = unsafe { ::std::mem::transmute(tfcntrflag) };
            tfcntrflag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let finterpflag: u32 = unsafe { ::std::mem::transmute(finterpflag) };
            finterpflag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let psf: u32 = unsafe { ::std::mem::transmute(psf) };
            psf as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let multires: u32 = unsafe { ::std::mem::transmute(multires) };
            multires as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let overlap: u32 = unsafe { ::std::mem::transmute(overlap) };
            overlap as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let syncmarker: u32 = unsafe { ::std::mem::transmute(syncmarker) };
            syncmarker as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let rangered: u32 = unsafe { ::std::mem::transmute(rangered) };
            rangered as u64
        });
        __bindgen_bitfield_unit.set(9usize, 3u8, {
            let max_b_frames: u32 = unsafe { ::std::mem::transmute(max_b_frames) };
            max_b_frames as u64
        });
        __bindgen_bitfield_unit.set(12usize, 2u8, {
            let profile: u32 = unsafe { ::std::mem::transmute(profile) };
            profile as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_1>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVC1__bindgen_ty_2 {
    pub bits: _VAPictureParameterBufferVC1__bindgen_ty_2__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVC1__bindgen_ty_2__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_2__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVC1__bindgen_ty_2__bindgen_ty_1 {
    #[inline]
    pub fn broken_link(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_broken_link(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn closed_entry(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_closed_entry(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn panscan_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_panscan_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn loopfilter(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_loopfilter(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        broken_link: u32,
        closed_entry: u32,
        panscan_flag: u32,
        loopfilter: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let broken_link: u32 = unsafe { ::std::mem::transmute(broken_link) };
            broken_link as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let closed_entry: u32 = unsafe { ::std::mem::transmute(closed_entry) };
            closed_entry as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let panscan_flag: u32 = unsafe { ::std::mem::transmute(panscan_flag) };
            panscan_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let loopfilter: u32 = unsafe { ::std::mem::transmute(loopfilter) };
            loopfilter as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_2>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_2),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_2>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_2),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVC1__bindgen_ty_3 {
    pub bits: _VAPictureParameterBufferVC1__bindgen_ty_3__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVC1__bindgen_ty_3__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_3__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_3__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_3__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_3__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_3__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVC1__bindgen_ty_3__bindgen_ty_1 {
    #[inline]
    pub fn luma_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_luma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn luma(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_luma(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_chroma(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        luma_flag: u32,
        luma: u32,
        chroma_flag: u32,
        chroma: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let luma_flag: u32 = unsafe { ::std::mem::transmute(luma_flag) };
            luma_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 3u8, {
            let luma: u32 = unsafe { ::std::mem::transmute(luma) };
            luma as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let chroma_flag: u32 = unsafe { ::std::mem::transmute(chroma_flag) };
            chroma_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 3u8, {
            let chroma: u32 = unsafe { ::std::mem::transmute(chroma) };
            chroma as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_3>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_3>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_3>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_3),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_3>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_3),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVC1__bindgen_ty_4 {
    pub bits: _VAPictureParameterBufferVC1__bindgen_ty_4__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVC1__bindgen_ty_4__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_4__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_4__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_4__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_4__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_4__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVC1__bindgen_ty_4__bindgen_ty_1 {
    #[inline]
    pub fn picture_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_picture_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_coding_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_frame_coding_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn top_field_first(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_top_field_first(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_first_field(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_first_field(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intensity_compensation(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intensity_compensation(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        picture_type: u32,
        frame_coding_mode: u32,
        top_field_first: u32,
        is_first_field: u32,
        intensity_compensation: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let picture_type: u32 = unsafe { ::std::mem::transmute(picture_type) };
            picture_type as u64
        });
        __bindgen_bitfield_unit.set(3usize, 3u8, {
            let frame_coding_mode: u32 = unsafe { ::std::mem::transmute(frame_coding_mode) };
            frame_coding_mode as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let top_field_first: u32 = unsafe { ::std::mem::transmute(top_field_first) };
            top_field_first as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let is_first_field: u32 = unsafe { ::std::mem::transmute(is_first_field) };
            is_first_field as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let intensity_compensation: u32 =
                unsafe { ::std::mem::transmute(intensity_compensation) };
            intensity_compensation as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_4>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_4)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_4>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_4>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_4),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_4>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_4),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVC1__bindgen_ty_5 {
    pub flags: _VAPictureParameterBufferVC1__bindgen_ty_5__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVC1__bindgen_ty_5__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_5__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_5__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_5__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_5__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_5__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVC1__bindgen_ty_5__bindgen_ty_1 {
    #[inline]
    pub fn mv_type_mb(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mv_type_mb(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn direct_mb(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_direct_mb(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn skip_mb(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_skip_mb(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn field_tx(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_field_tx(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn forward_mb(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_forward_mb(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ac_pred(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ac_pred(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overflags(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overflags(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mv_type_mb: u32,
        direct_mb: u32,
        skip_mb: u32,
        field_tx: u32,
        forward_mb: u32,
        ac_pred: u32,
        overflags: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let mv_type_mb: u32 = unsafe { ::std::mem::transmute(mv_type_mb) };
            mv_type_mb as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let direct_mb: u32 = unsafe { ::std::mem::transmute(direct_mb) };
            direct_mb as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let skip_mb: u32 = unsafe { ::std::mem::transmute(skip_mb) };
            skip_mb as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let field_tx: u32 = unsafe { ::std::mem::transmute(field_tx) };
            field_tx as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let forward_mb: u32 = unsafe { ::std::mem::transmute(forward_mb) };
            forward_mb as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let ac_pred: u32 = unsafe { ::std::mem::transmute(ac_pred) };
            ac_pred as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let overflags: u32 = unsafe { ::std::mem::transmute(overflags) };
            overflags as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_5() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_5>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_5)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_5>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_5>())).flags as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_5),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_5>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_5),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVC1__bindgen_ty_6 {
    pub flags: _VAPictureParameterBufferVC1__bindgen_ty_6__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVC1__bindgen_ty_6__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_6__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_6__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_6__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_6__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_6__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVC1__bindgen_ty_6__bindgen_ty_1 {
    #[inline]
    pub fn bp_mv_type_mb(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bp_mv_type_mb(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bp_direct_mb(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bp_direct_mb(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bp_skip_mb(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bp_skip_mb(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bp_field_tx(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bp_field_tx(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bp_forward_mb(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bp_forward_mb(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bp_ac_pred(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bp_ac_pred(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bp_overflags(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bp_overflags(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        bp_mv_type_mb: u32,
        bp_direct_mb: u32,
        bp_skip_mb: u32,
        bp_field_tx: u32,
        bp_forward_mb: u32,
        bp_ac_pred: u32,
        bp_overflags: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let bp_mv_type_mb: u32 = unsafe { ::std::mem::transmute(bp_mv_type_mb) };
            bp_mv_type_mb as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let bp_direct_mb: u32 = unsafe { ::std::mem::transmute(bp_direct_mb) };
            bp_direct_mb as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let bp_skip_mb: u32 = unsafe { ::std::mem::transmute(bp_skip_mb) };
            bp_skip_mb as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let bp_field_tx: u32 = unsafe { ::std::mem::transmute(bp_field_tx) };
            bp_field_tx as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let bp_forward_mb: u32 = unsafe { ::std::mem::transmute(bp_forward_mb) };
            bp_forward_mb as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let bp_ac_pred: u32 = unsafe { ::std::mem::transmute(bp_ac_pred) };
            bp_ac_pred as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let bp_overflags: u32 = unsafe { ::std::mem::transmute(bp_overflags) };
            bp_overflags as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_6() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_6>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_6)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_6>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_6>())).flags as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_6),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_6>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_6),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVC1__bindgen_ty_7 {
    pub bits: _VAPictureParameterBufferVC1__bindgen_ty_7__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVC1__bindgen_ty_7__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_7__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_7__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_7__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_7__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_7__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVC1__bindgen_ty_7__bindgen_ty_1 {
    #[inline]
    pub fn reference_distance_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reference_distance_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reference_distance(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_reference_distance(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn num_reference_pictures(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_num_reference_pictures(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reference_field_pic_indicator(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reference_field_pic_indicator(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        reference_distance_flag: u32,
        reference_distance: u32,
        num_reference_pictures: u32,
        reference_field_pic_indicator: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let reference_distance_flag: u32 =
                unsafe { ::std::mem::transmute(reference_distance_flag) };
            reference_distance_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 5u8, {
            let reference_distance: u32 = unsafe { ::std::mem::transmute(reference_distance) };
            reference_distance as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let num_reference_pictures: u32 =
                unsafe { ::std::mem::transmute(num_reference_pictures) };
            num_reference_pictures as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let reference_field_pic_indicator: u32 =
                unsafe { ::std::mem::transmute(reference_field_pic_indicator) };
            reference_field_pic_indicator as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_7() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_7>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_7)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_7>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_7>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_7),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_7>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_7),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVC1__bindgen_ty_8 {
    pub bits: _VAPictureParameterBufferVC1__bindgen_ty_8__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVC1__bindgen_ty_8__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_8__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_8__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_8__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_8__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_8__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVC1__bindgen_ty_8__bindgen_ty_1 {
    #[inline]
    pub fn mv_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_mv_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn mv_mode2(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_mv_mode2(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn mv_table(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_mv_table(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn two_mv_block_pattern_table(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_two_mv_block_pattern_table(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn four_mv_switch(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_four_mv_switch(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn four_mv_block_pattern_table(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_four_mv_block_pattern_table(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn extended_mv_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_extended_mv_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn extended_mv_range(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_extended_mv_range(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn extended_dmv_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_extended_dmv_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn extended_dmv_range(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_extended_dmv_range(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mv_mode: u32,
        mv_mode2: u32,
        mv_table: u32,
        two_mv_block_pattern_table: u32,
        four_mv_switch: u32,
        four_mv_block_pattern_table: u32,
        extended_mv_flag: u32,
        extended_mv_range: u32,
        extended_dmv_flag: u32,
        extended_dmv_range: u32,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let mv_mode: u32 = unsafe { ::std::mem::transmute(mv_mode) };
            mv_mode as u64
        });
        __bindgen_bitfield_unit.set(3usize, 3u8, {
            let mv_mode2: u32 = unsafe { ::std::mem::transmute(mv_mode2) };
            mv_mode2 as u64
        });
        __bindgen_bitfield_unit.set(6usize, 3u8, {
            let mv_table: u32 = unsafe { ::std::mem::transmute(mv_table) };
            mv_table as u64
        });
        __bindgen_bitfield_unit.set(9usize, 2u8, {
            let two_mv_block_pattern_table: u32 =
                unsafe { ::std::mem::transmute(two_mv_block_pattern_table) };
            two_mv_block_pattern_table as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let four_mv_switch: u32 = unsafe { ::std::mem::transmute(four_mv_switch) };
            four_mv_switch as u64
        });
        __bindgen_bitfield_unit.set(12usize, 2u8, {
            let four_mv_block_pattern_table: u32 =
                unsafe { ::std::mem::transmute(four_mv_block_pattern_table) };
            four_mv_block_pattern_table as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let extended_mv_flag: u32 = unsafe { ::std::mem::transmute(extended_mv_flag) };
            extended_mv_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 2u8, {
            let extended_mv_range: u32 = unsafe { ::std::mem::transmute(extended_mv_range) };
            extended_mv_range as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let extended_dmv_flag: u32 = unsafe { ::std::mem::transmute(extended_dmv_flag) };
            extended_dmv_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 2u8, {
            let extended_dmv_range: u32 = unsafe { ::std::mem::transmute(extended_dmv_range) };
            extended_dmv_range as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_8() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_8>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_8)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_8>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_8>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_8),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_8>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_8),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVC1__bindgen_ty_9 {
    pub bits: _VAPictureParameterBufferVC1__bindgen_ty_9__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVC1__bindgen_ty_9__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_9__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_9__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_9__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_9__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_9__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVC1__bindgen_ty_9__bindgen_ty_1 {
    #[inline]
    pub fn dquant(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_dquant(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn quantizer(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_quantizer(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn half_qp(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_half_qp(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_quantizer_scale(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_pic_quantizer_scale(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_quantizer_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pic_quantizer_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dq_frame(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dq_frame(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dq_profile(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_dq_profile(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn dq_sb_edge(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_dq_sb_edge(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn dq_db_edge(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_dq_db_edge(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn dq_binary_level(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dq_binary_level(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn alt_pic_quantizer(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_alt_pic_quantizer(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        dquant: u32,
        quantizer: u32,
        half_qp: u32,
        pic_quantizer_scale: u32,
        pic_quantizer_type: u32,
        dq_frame: u32,
        dq_profile: u32,
        dq_sb_edge: u32,
        dq_db_edge: u32,
        dq_binary_level: u32,
        alt_pic_quantizer: u32,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let dquant: u32 = unsafe { ::std::mem::transmute(dquant) };
            dquant as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let quantizer: u32 = unsafe { ::std::mem::transmute(quantizer) };
            quantizer as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let half_qp: u32 = unsafe { ::std::mem::transmute(half_qp) };
            half_qp as u64
        });
        __bindgen_bitfield_unit.set(5usize, 5u8, {
            let pic_quantizer_scale: u32 = unsafe { ::std::mem::transmute(pic_quantizer_scale) };
            pic_quantizer_scale as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let pic_quantizer_type: u32 = unsafe { ::std::mem::transmute(pic_quantizer_type) };
            pic_quantizer_type as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let dq_frame: u32 = unsafe { ::std::mem::transmute(dq_frame) };
            dq_frame as u64
        });
        __bindgen_bitfield_unit.set(12usize, 2u8, {
            let dq_profile: u32 = unsafe { ::std::mem::transmute(dq_profile) };
            dq_profile as u64
        });
        __bindgen_bitfield_unit.set(14usize, 2u8, {
            let dq_sb_edge: u32 = unsafe { ::std::mem::transmute(dq_sb_edge) };
            dq_sb_edge as u64
        });
        __bindgen_bitfield_unit.set(16usize, 2u8, {
            let dq_db_edge: u32 = unsafe { ::std::mem::transmute(dq_db_edge) };
            dq_db_edge as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let dq_binary_level: u32 = unsafe { ::std::mem::transmute(dq_binary_level) };
            dq_binary_level as u64
        });
        __bindgen_bitfield_unit.set(19usize, 5u8, {
            let alt_pic_quantizer: u32 = unsafe { ::std::mem::transmute(alt_pic_quantizer) };
            alt_pic_quantizer as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_9() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_9>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_9)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_9>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_9>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_9),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_9>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_9),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVC1__bindgen_ty_10 {
    pub bits: _VAPictureParameterBufferVC1__bindgen_ty_10__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVC1__bindgen_ty_10__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_10__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_10__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_10__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_10__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_10__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVC1__bindgen_ty_10__bindgen_ty_1 {
    #[inline]
    pub fn variable_sized_transform_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_variable_sized_transform_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mb_level_transform_type_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mb_level_transform_type_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_level_transform_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_frame_level_transform_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_ac_codingset_idx1(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_transform_ac_codingset_idx1(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_ac_codingset_idx2(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_transform_ac_codingset_idx2(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_transform_dc_table(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_transform_dc_table(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        variable_sized_transform_flag: u32,
        mb_level_transform_type_flag: u32,
        frame_level_transform_type: u32,
        transform_ac_codingset_idx1: u32,
        transform_ac_codingset_idx2: u32,
        intra_transform_dc_table: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let variable_sized_transform_flag: u32 =
                unsafe { ::std::mem::transmute(variable_sized_transform_flag) };
            variable_sized_transform_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let mb_level_transform_type_flag: u32 =
                unsafe { ::std::mem::transmute(mb_level_transform_type_flag) };
            mb_level_transform_type_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let frame_level_transform_type: u32 =
                unsafe { ::std::mem::transmute(frame_level_transform_type) };
            frame_level_transform_type as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let transform_ac_codingset_idx1: u32 =
                unsafe { ::std::mem::transmute(transform_ac_codingset_idx1) };
            transform_ac_codingset_idx1 as u64
        });
        __bindgen_bitfield_unit.set(6usize, 2u8, {
            let transform_ac_codingset_idx2: u32 =
                unsafe { ::std::mem::transmute(transform_ac_codingset_idx2) };
            transform_ac_codingset_idx2 as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let intra_transform_dc_table: u32 =
                unsafe { ::std::mem::transmute(intra_transform_dc_table) };
            intra_transform_dc_table as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1__bindgen_ty_10() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1__bindgen_ty_10>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_10)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1__bindgen_ty_10>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_10>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_10),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1__bindgen_ty_10>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1__bindgen_ty_10),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVC1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVC1>(),
        104usize,
        concat!("Size of: ", stringify!(_VAPictureParameterBufferVC1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVC1>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAPictureParameterBufferVC1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).forward_reference_picture
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(forward_reference_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).backward_reference_picture
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(backward_reference_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).inloop_decoded_picture
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(inloop_decoded_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).sequence_fields as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(sequence_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).coded_width as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(coded_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).coded_height as *const _
                as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(coded_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).entrypoint_fields as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(entrypoint_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).conditional_overlap_flag
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(conditional_overlap_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).fast_uvmc_flag as *const _
                as usize
        },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(fast_uvmc_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).range_mapping_fields
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(range_mapping_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).b_picture_fraction as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(b_picture_fraction)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).cbp_table as *const _ as usize
        },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(cbp_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).mb_mode_table as *const _
                as usize
        },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(mb_mode_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).range_reduction_frame
                as *const _ as usize
        },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(range_reduction_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).rounding_control as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(rounding_control)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).post_processing as *const _
                as usize
        },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(post_processing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).picture_resolution_index
                as *const _ as usize
        },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(picture_resolution_index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).luma_scale as *const _ as usize
        },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(luma_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).luma_shift as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(luma_shift)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).picture_fields as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(picture_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).raw_coding as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(raw_coding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).bitplane_present as *const _
                as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(bitplane_present)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).reference_fields as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(reference_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).mv_fields as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(mv_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).pic_quantizer_fields
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(pic_quantizer_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).transform_fields as *const _
                as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(transform_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).luma_scale2 as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(luma_scale2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).luma_shift2 as *const _
                as usize
        },
        73usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(luma_shift2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).intensity_compensation_field
                as *const _ as usize
        },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(intensity_compensation_field)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVC1>())).va_reserved as *const _
                as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVC1),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAPictureParameterBufferVC1 = _VAPictureParameterBufferVC1;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferVC1 {
    pub slice_data_size: u32,
    pub slice_data_offset: u32,
    pub slice_data_flag: u32,
    pub macroblock_offset: u32,
    pub slice_vertical_position: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferVC1() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferVC1>(),
        36usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferVC1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferVC1>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASliceParameterBufferVC1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVC1>())).slice_data_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVC1),
            "::",
            stringify!(slice_data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVC1>())).slice_data_offset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVC1),
            "::",
            stringify!(slice_data_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVC1>())).slice_data_flag as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVC1),
            "::",
            stringify!(slice_data_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVC1>())).macroblock_offset as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVC1),
            "::",
            stringify!(macroblock_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVC1>())).slice_vertical_position
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVC1),
            "::",
            stringify!(slice_vertical_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVC1>())).va_reserved as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVC1),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASliceParameterBufferVC1 = _VASliceParameterBufferVC1;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureH264 {
    pub picture_id: VASurfaceID,
    pub frame_idx: u32,
    pub flags: u32,
    pub TopFieldOrderCnt: i32,
    pub BottomFieldOrderCnt: i32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAPictureH264() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureH264>(),
        36usize,
        concat!("Size of: ", stringify!(_VAPictureH264))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureH264>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAPictureH264))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureH264>())).picture_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureH264),
            "::",
            stringify!(picture_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureH264>())).frame_idx as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureH264),
            "::",
            stringify!(frame_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureH264>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureH264),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureH264>())).TopFieldOrderCnt as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureH264),
            "::",
            stringify!(TopFieldOrderCnt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureH264>())).BottomFieldOrderCnt as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureH264),
            "::",
            stringify!(BottomFieldOrderCnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureH264>())).va_reserved as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureH264),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAPictureH264 = _VAPictureH264;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAPictureParameterBufferH264 {
    pub CurrPic: VAPictureH264,
    pub ReferenceFrames: [VAPictureH264; 16usize],
    pub picture_width_in_mbs_minus1: u16,
    pub picture_height_in_mbs_minus1: u16,
    pub bit_depth_luma_minus8: u8,
    pub bit_depth_chroma_minus8: u8,
    pub num_ref_frames: u8,
    pub seq_fields: _VAPictureParameterBufferH264__bindgen_ty_1,
    pub num_slice_groups_minus1: u8,
    pub slice_group_map_type: u8,
    pub slice_group_change_rate_minus1: u16,
    pub pic_init_qp_minus26: i8,
    pub pic_init_qs_minus26: i8,
    pub chroma_qp_index_offset: i8,
    pub second_chroma_qp_index_offset: i8,
    pub pic_fields: _VAPictureParameterBufferH264__bindgen_ty_2,
    pub frame_num: u16,
    pub va_reserved: [u32; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferH264__bindgen_ty_1 {
    pub bits: _VAPictureParameterBufferH264__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferH264__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferH264__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferH264__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferH264__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferH264__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn chroma_format_idc(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_format_idc(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn residual_colour_transform_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_residual_colour_transform_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn gaps_in_frame_num_value_allowed_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gaps_in_frame_num_value_allowed_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_mbs_only_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_mbs_only_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mb_adaptive_frame_field_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mb_adaptive_frame_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn direct_8x8_inference_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_direct_8x8_inference_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn MinLumaBiPredSize8x8(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_MinLumaBiPredSize8x8(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_max_frame_num_minus4(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_log2_max_frame_num_minus4(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_order_cnt_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_pic_order_cnt_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_max_pic_order_cnt_lsb_minus4(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_log2_max_pic_order_cnt_lsb_minus4(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn delta_pic_order_always_zero_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_pic_order_always_zero_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        chroma_format_idc: u32,
        residual_colour_transform_flag: u32,
        gaps_in_frame_num_value_allowed_flag: u32,
        frame_mbs_only_flag: u32,
        mb_adaptive_frame_field_flag: u32,
        direct_8x8_inference_flag: u32,
        MinLumaBiPredSize8x8: u32,
        log2_max_frame_num_minus4: u32,
        pic_order_cnt_type: u32,
        log2_max_pic_order_cnt_lsb_minus4: u32,
        delta_pic_order_always_zero_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let chroma_format_idc: u32 = unsafe { ::std::mem::transmute(chroma_format_idc) };
            chroma_format_idc as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let residual_colour_transform_flag: u32 =
                unsafe { ::std::mem::transmute(residual_colour_transform_flag) };
            residual_colour_transform_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let gaps_in_frame_num_value_allowed_flag: u32 =
                unsafe { ::std::mem::transmute(gaps_in_frame_num_value_allowed_flag) };
            gaps_in_frame_num_value_allowed_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let frame_mbs_only_flag: u32 = unsafe { ::std::mem::transmute(frame_mbs_only_flag) };
            frame_mbs_only_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let mb_adaptive_frame_field_flag: u32 =
                unsafe { ::std::mem::transmute(mb_adaptive_frame_field_flag) };
            mb_adaptive_frame_field_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let direct_8x8_inference_flag: u32 =
                unsafe { ::std::mem::transmute(direct_8x8_inference_flag) };
            direct_8x8_inference_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let MinLumaBiPredSize8x8: u32 = unsafe { ::std::mem::transmute(MinLumaBiPredSize8x8) };
            MinLumaBiPredSize8x8 as u64
        });
        __bindgen_bitfield_unit.set(8usize, 4u8, {
            let log2_max_frame_num_minus4: u32 =
                unsafe { ::std::mem::transmute(log2_max_frame_num_minus4) };
            log2_max_frame_num_minus4 as u64
        });
        __bindgen_bitfield_unit.set(12usize, 2u8, {
            let pic_order_cnt_type: u32 = unsafe { ::std::mem::transmute(pic_order_cnt_type) };
            pic_order_cnt_type as u64
        });
        __bindgen_bitfield_unit.set(14usize, 4u8, {
            let log2_max_pic_order_cnt_lsb_minus4: u32 =
                unsafe { ::std::mem::transmute(log2_max_pic_order_cnt_lsb_minus4) };
            log2_max_pic_order_cnt_lsb_minus4 as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let delta_pic_order_always_zero_flag: u32 =
                unsafe { ::std::mem::transmute(delta_pic_order_always_zero_flag) };
            delta_pic_order_always_zero_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferH264__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferH264__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferH264__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264__bindgen_ty_1>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferH264__bindgen_ty_2 {
    pub bits: _VAPictureParameterBufferH264__bindgen_ty_2__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferH264__bindgen_ty_2__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferH264__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferH264__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferH264__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_2__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferH264__bindgen_ty_2__bindgen_ty_1 {
    #[inline]
    pub fn entropy_coding_mode_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_entropy_coding_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_bipred_idc(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_bipred_idc(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_8x8_mode_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_8x8_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn field_pic_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_field_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constrained_intra_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constrained_intra_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_order_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pic_order_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_control_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_control_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn redundant_pic_cnt_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_redundant_pic_cnt_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reference_pic_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reference_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        entropy_coding_mode_flag: u32,
        weighted_pred_flag: u32,
        weighted_bipred_idc: u32,
        transform_8x8_mode_flag: u32,
        field_pic_flag: u32,
        constrained_intra_pred_flag: u32,
        pic_order_present_flag: u32,
        deblocking_filter_control_present_flag: u32,
        redundant_pic_cnt_present_flag: u32,
        reference_pic_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let entropy_coding_mode_flag: u32 =
                unsafe { ::std::mem::transmute(entropy_coding_mode_flag) };
            entropy_coding_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let weighted_pred_flag: u32 = unsafe { ::std::mem::transmute(weighted_pred_flag) };
            weighted_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let weighted_bipred_idc: u32 = unsafe { ::std::mem::transmute(weighted_bipred_idc) };
            weighted_bipred_idc as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let transform_8x8_mode_flag: u32 =
                unsafe { ::std::mem::transmute(transform_8x8_mode_flag) };
            transform_8x8_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let field_pic_flag: u32 = unsafe { ::std::mem::transmute(field_pic_flag) };
            field_pic_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let constrained_intra_pred_flag: u32 =
                unsafe { ::std::mem::transmute(constrained_intra_pred_flag) };
            constrained_intra_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let pic_order_present_flag: u32 =
                unsafe { ::std::mem::transmute(pic_order_present_flag) };
            pic_order_present_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let deblocking_filter_control_present_flag: u32 =
                unsafe { ::std::mem::transmute(deblocking_filter_control_present_flag) };
            deblocking_filter_control_present_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let redundant_pic_cnt_present_flag: u32 =
                unsafe { ::std::mem::transmute(redundant_pic_cnt_present_flag) };
            redundant_pic_cnt_present_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let reference_pic_flag: u32 = unsafe { ::std::mem::transmute(reference_pic_flag) };
            reference_pic_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferH264__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferH264__bindgen_ty_2>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferH264__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264__bindgen_ty_2>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_2),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264__bindgen_ty_2>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264__bindgen_ty_2),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferH264() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferH264>(),
        672usize,
        concat!("Size of: ", stringify!(_VAPictureParameterBufferH264))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferH264>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAPictureParameterBufferH264))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).CurrPic as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(CurrPic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).ReferenceFrames as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(ReferenceFrames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).picture_width_in_mbs_minus1
                as *const _ as usize
        },
        612usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(picture_width_in_mbs_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).picture_height_in_mbs_minus1
                as *const _ as usize
        },
        614usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(picture_height_in_mbs_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).bit_depth_luma_minus8
                as *const _ as usize
        },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(bit_depth_luma_minus8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).bit_depth_chroma_minus8
                as *const _ as usize
        },
        617usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(bit_depth_chroma_minus8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).num_ref_frames as *const _
                as usize
        },
        618usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(num_ref_frames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).seq_fields as *const _
                as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(seq_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).num_slice_groups_minus1
                as *const _ as usize
        },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(num_slice_groups_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).slice_group_map_type
                as *const _ as usize
        },
        625usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(slice_group_map_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).slice_group_change_rate_minus1
                as *const _ as usize
        },
        626usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(slice_group_change_rate_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).pic_init_qp_minus26
                as *const _ as usize
        },
        628usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(pic_init_qp_minus26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).pic_init_qs_minus26
                as *const _ as usize
        },
        629usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(pic_init_qs_minus26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).chroma_qp_index_offset
                as *const _ as usize
        },
        630usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(chroma_qp_index_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).second_chroma_qp_index_offset
                as *const _ as usize
        },
        631usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(second_chroma_qp_index_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).pic_fields as *const _
                as usize
        },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(pic_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).frame_num as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(frame_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferH264>())).va_reserved as *const _
                as usize
        },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferH264),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAPictureParameterBufferH264 = _VAPictureParameterBufferH264;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAIQMatrixBufferH264 {
    pub ScalingList4x4: [[u8; 16usize]; 6usize],
    pub ScalingList8x8: [[u8; 64usize]; 2usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAIQMatrixBufferH264() {
    assert_eq!(
        ::std::mem::size_of::<_VAIQMatrixBufferH264>(),
        240usize,
        concat!("Size of: ", stringify!(_VAIQMatrixBufferH264))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAIQMatrixBufferH264>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAIQMatrixBufferH264))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferH264>())).ScalingList4x4 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferH264),
            "::",
            stringify!(ScalingList4x4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferH264>())).ScalingList8x8 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferH264),
            "::",
            stringify!(ScalingList8x8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferH264>())).va_reserved as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferH264),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAIQMatrixBufferH264 = _VAIQMatrixBufferH264;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferH264 {
    pub slice_data_size: u32,
    pub slice_data_offset: u32,
    pub slice_data_flag: u32,
    pub slice_data_bit_offset: u16,
    pub first_mb_in_slice: u16,
    pub slice_type: u8,
    pub direct_spatial_mv_pred_flag: u8,
    pub num_ref_idx_l0_active_minus1: u8,
    pub num_ref_idx_l1_active_minus1: u8,
    pub cabac_init_idc: u8,
    pub slice_qp_delta: i8,
    pub disable_deblocking_filter_idc: u8,
    pub slice_alpha_c0_offset_div2: i8,
    pub slice_beta_offset_div2: i8,
    pub RefPicList0: [VAPictureH264; 32usize],
    pub RefPicList1: [VAPictureH264; 32usize],
    pub luma_log2_weight_denom: u8,
    pub chroma_log2_weight_denom: u8,
    pub luma_weight_l0_flag: u8,
    pub luma_weight_l0: [i16; 32usize],
    pub luma_offset_l0: [i16; 32usize],
    pub chroma_weight_l0_flag: u8,
    pub chroma_weight_l0: [[i16; 2usize]; 32usize],
    pub chroma_offset_l0: [[i16; 2usize]; 32usize],
    pub luma_weight_l1_flag: u8,
    pub luma_weight_l1: [i16; 32usize],
    pub luma_offset_l1: [i16; 32usize],
    pub chroma_weight_l1_flag: u8,
    pub chroma_weight_l1: [[i16; 2usize]; 32usize],
    pub chroma_offset_l1: [[i16; 2usize]; 32usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferH264() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferH264>(),
        3128usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferH264))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferH264>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASliceParameterBufferH264))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).slice_data_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(slice_data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).slice_data_offset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(slice_data_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).slice_data_flag as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(slice_data_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).slice_data_bit_offset
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(slice_data_bit_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).first_mb_in_slice as *const _
                as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(first_mb_in_slice)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).slice_type as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(slice_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).direct_spatial_mv_pred_flag
                as *const _ as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(direct_spatial_mv_pred_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).num_ref_idx_l0_active_minus1
                as *const _ as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(num_ref_idx_l0_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).num_ref_idx_l1_active_minus1
                as *const _ as usize
        },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(num_ref_idx_l1_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).cabac_init_idc as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(cabac_init_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).slice_qp_delta as *const _
                as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(slice_qp_delta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).disable_deblocking_filter_idc
                as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(disable_deblocking_filter_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).slice_alpha_c0_offset_div2
                as *const _ as usize
        },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(slice_alpha_c0_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).slice_beta_offset_div2
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(slice_beta_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).RefPicList0 as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(RefPicList0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).RefPicList1 as *const _ as usize
        },
        1180usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(RefPicList1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).luma_log2_weight_denom
                as *const _ as usize
        },
        2332usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(luma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).chroma_log2_weight_denom
                as *const _ as usize
        },
        2333usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(chroma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).luma_weight_l0_flag as *const _
                as usize
        },
        2334usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(luma_weight_l0_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).luma_weight_l0 as *const _
                as usize
        },
        2336usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(luma_weight_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).luma_offset_l0 as *const _
                as usize
        },
        2400usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(luma_offset_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).chroma_weight_l0_flag
                as *const _ as usize
        },
        2464usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(chroma_weight_l0_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).chroma_weight_l0 as *const _
                as usize
        },
        2466usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(chroma_weight_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).chroma_offset_l0 as *const _
                as usize
        },
        2594usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(chroma_offset_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).luma_weight_l1_flag as *const _
                as usize
        },
        2722usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(luma_weight_l1_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).luma_weight_l1 as *const _
                as usize
        },
        2724usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(luma_weight_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).luma_offset_l1 as *const _
                as usize
        },
        2788usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(luma_offset_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).chroma_weight_l1_flag
                as *const _ as usize
        },
        2852usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(chroma_weight_l1_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).chroma_weight_l1 as *const _
                as usize
        },
        2854usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(chroma_weight_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).chroma_offset_l1 as *const _
                as usize
        },
        2982usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(chroma_offset_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferH264>())).va_reserved as *const _ as usize
        },
        3112usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferH264),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASliceParameterBufferH264 = _VASliceParameterBufferH264;
pub const VAEncPictureType_VAEncPictureTypeIntra: VAEncPictureType = 0;
pub const VAEncPictureType_VAEncPictureTypePredictive: VAEncPictureType = 1;
pub const VAEncPictureType_VAEncPictureTypeBidirectional: VAEncPictureType = 2;
pub type VAEncPictureType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncSliceParameterBuffer {
    pub start_row_number: u32,
    pub slice_height: u32,
    pub slice_flags: _VAEncSliceParameterBuffer__bindgen_ty_1,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncSliceParameterBuffer__bindgen_ty_1 {
    pub bits: _VAEncSliceParameterBuffer__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncSliceParameterBuffer__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout__VAEncSliceParameterBuffer__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSliceParameterBuffer__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncSliceParameterBuffer__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSliceParameterBuffer__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSliceParameterBuffer__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncSliceParameterBuffer__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn is_intra(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_intra(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn disable_deblocking_filter_idc(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_disable_deblocking_filter_idc(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_long_term_ref(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_uses_long_term_ref(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_long_term_ref(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_long_term_ref(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_intra: u32,
        disable_deblocking_filter_idc: u32,
        uses_long_term_ref: u32,
        is_long_term_ref: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_intra: u32 = unsafe { ::std::mem::transmute(is_intra) };
            is_intra as u64
        });
        __bindgen_bitfield_unit.set(1usize, 2u8, {
            let disable_deblocking_filter_idc: u32 =
                unsafe { ::std::mem::transmute(disable_deblocking_filter_idc) };
            disable_deblocking_filter_idc as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let uses_long_term_ref: u32 = unsafe { ::std::mem::transmute(uses_long_term_ref) };
            uses_long_term_ref as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_long_term_ref: u32 = unsafe { ::std::mem::transmute(is_long_term_ref) };
            is_long_term_ref as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncSliceParameterBuffer__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSliceParameterBuffer__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncSliceParameterBuffer__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSliceParameterBuffer__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSliceParameterBuffer__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBuffer__bindgen_ty_1>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBuffer__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBuffer__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBuffer__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncSliceParameterBuffer() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSliceParameterBuffer>(),
        28usize,
        concat!("Size of: ", stringify!(_VAEncSliceParameterBuffer))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSliceParameterBuffer>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncSliceParameterBuffer))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBuffer>())).start_row_number as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBuffer),
            "::",
            stringify!(start_row_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBuffer>())).slice_height as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBuffer),
            "::",
            stringify!(slice_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBuffer>())).slice_flags as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBuffer),
            "::",
            stringify!(slice_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBuffer>())).va_reserved as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBuffer),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncSliceParameterBuffer = _VAEncSliceParameterBuffer;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncSequenceParameterBufferH263 {
    pub intra_period: u32,
    pub bits_per_second: u32,
    pub frame_rate: u32,
    pub initial_qp: u32,
    pub min_qp: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncSequenceParameterBufferH263() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSequenceParameterBufferH263>(),
        36usize,
        concat!("Size of: ", stringify!(_VAEncSequenceParameterBufferH263))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSequenceParameterBufferH263>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSequenceParameterBufferH263)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferH263>())).intra_period as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferH263),
            "::",
            stringify!(intra_period)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferH263>())).bits_per_second
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferH263),
            "::",
            stringify!(bits_per_second)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferH263>())).frame_rate as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferH263),
            "::",
            stringify!(frame_rate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferH263>())).initial_qp as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferH263),
            "::",
            stringify!(initial_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferH263>())).min_qp as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferH263),
            "::",
            stringify!(min_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferH263>())).va_reserved as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferH263),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncSequenceParameterBufferH263 = _VAEncSequenceParameterBufferH263;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncPictureParameterBufferH263 {
    pub reference_picture: VASurfaceID,
    pub reconstructed_picture: VASurfaceID,
    pub coded_buf: VABufferID,
    pub picture_width: u16,
    pub picture_height: u16,
    pub picture_type: VAEncPictureType,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncPictureParameterBufferH263() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncPictureParameterBufferH263>(),
        36usize,
        concat!("Size of: ", stringify!(_VAEncPictureParameterBufferH263))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncPictureParameterBufferH263>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncPictureParameterBufferH263)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferH263>())).reference_picture
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferH263),
            "::",
            stringify!(reference_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferH263>())).reconstructed_picture
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferH263),
            "::",
            stringify!(reconstructed_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferH263>())).coded_buf as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferH263),
            "::",
            stringify!(coded_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferH263>())).picture_width as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferH263),
            "::",
            stringify!(picture_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferH263>())).picture_height as *const _
                as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferH263),
            "::",
            stringify!(picture_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferH263>())).picture_type as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferH263),
            "::",
            stringify!(picture_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferH263>())).va_reserved as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferH263),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncPictureParameterBufferH263 = _VAEncPictureParameterBufferH263;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncSequenceParameterBufferMPEG4 {
    pub profile_and_level_indication: u8,
    pub intra_period: u32,
    pub video_object_layer_width: u32,
    pub video_object_layer_height: u32,
    pub vop_time_increment_resolution: u32,
    pub fixed_vop_rate: u32,
    pub fixed_vop_time_increment: u32,
    pub bits_per_second: u32,
    pub frame_rate: u32,
    pub initial_qp: u32,
    pub min_qp: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncSequenceParameterBufferMPEG4() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSequenceParameterBufferMPEG4>(),
        60usize,
        concat!("Size of: ", stringify!(_VAEncSequenceParameterBufferMPEG4))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSequenceParameterBufferMPEG4>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSequenceParameterBufferMPEG4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>()))
                .profile_and_level_indication as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(profile_and_level_indication)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>())).intra_period as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(intra_period)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>())).video_object_layer_width
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(video_object_layer_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>())).video_object_layer_height
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(video_object_layer_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>()))
                .vop_time_increment_resolution as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(vop_time_increment_resolution)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>())).fixed_vop_rate
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(fixed_vop_rate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>())).fixed_vop_time_increment
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(fixed_vop_time_increment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>())).bits_per_second
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(bits_per_second)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>())).frame_rate as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(frame_rate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>())).initial_qp as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(initial_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>())).min_qp as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(min_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferMPEG4>())).va_reserved as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferMPEG4),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncSequenceParameterBufferMPEG4 = _VAEncSequenceParameterBufferMPEG4;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncPictureParameterBufferMPEG4 {
    pub reference_picture: VASurfaceID,
    pub reconstructed_picture: VASurfaceID,
    pub coded_buf: VABufferID,
    pub picture_width: u16,
    pub picture_height: u16,
    pub modulo_time_base: u32,
    pub vop_time_increment: u32,
    pub picture_type: VAEncPictureType,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAEncPictureParameterBufferMPEG4() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncPictureParameterBufferMPEG4>(),
        44usize,
        concat!("Size of: ", stringify!(_VAEncPictureParameterBufferMPEG4))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncPictureParameterBufferMPEG4>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncPictureParameterBufferMPEG4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferMPEG4>())).reference_picture
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferMPEG4),
            "::",
            stringify!(reference_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferMPEG4>())).reconstructed_picture
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferMPEG4),
            "::",
            stringify!(reconstructed_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferMPEG4>())).coded_buf as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferMPEG4),
            "::",
            stringify!(coded_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferMPEG4>())).picture_width as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferMPEG4),
            "::",
            stringify!(picture_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferMPEG4>())).picture_height as *const _
                as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferMPEG4),
            "::",
            stringify!(picture_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferMPEG4>())).modulo_time_base
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferMPEG4),
            "::",
            stringify!(modulo_time_base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferMPEG4>())).vop_time_increment
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferMPEG4),
            "::",
            stringify!(vop_time_increment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferMPEG4>())).picture_type as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferMPEG4),
            "::",
            stringify!(picture_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferMPEG4>())).va_reserved as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferMPEG4),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncPictureParameterBufferMPEG4 = _VAEncPictureParameterBufferMPEG4;
extern "C" {
    pub fn vaCreateBuffer(
        dpy: VADisplay,
        context: VAContextID,
        type_: VABufferType,
        size: ::std::os::raw::c_uint,
        num_elements: ::std::os::raw::c_uint,
        data: *mut ::std::os::raw::c_void,
        buf_id: *mut VABufferID,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaCreateBuffer2(
        dpy: VADisplay,
        context: VAContextID,
        type_: VABufferType,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
        unit_size: *mut ::std::os::raw::c_uint,
        pitch: *mut ::std::os::raw::c_uint,
        buf_id: *mut VABufferID,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaBufferSetNumElements(
        dpy: VADisplay,
        buf_id: VABufferID,
        num_elements: ::std::os::raw::c_uint,
    ) -> VAStatus;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VACodedBufferSegment {
    pub size: u32,
    pub bit_offset: u32,
    pub status: u32,
    pub reserved: u32,
    pub buf: *mut ::std::os::raw::c_void,
    pub next: *mut ::std::os::raw::c_void,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VACodedBufferSegment() {
    assert_eq!(
        ::std::mem::size_of::<_VACodedBufferSegment>(),
        48usize,
        concat!("Size of: ", stringify!(_VACodedBufferSegment))
    );
    assert_eq!(
        ::std::mem::align_of::<_VACodedBufferSegment>(),
        8usize,
        concat!("Alignment of ", stringify!(_VACodedBufferSegment))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VACodedBufferSegment>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACodedBufferSegment),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VACodedBufferSegment>())).bit_offset as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACodedBufferSegment),
            "::",
            stringify!(bit_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VACodedBufferSegment>())).status as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACodedBufferSegment),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VACodedBufferSegment>())).reserved as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACodedBufferSegment),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VACodedBufferSegment>())).buf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACodedBufferSegment),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VACodedBufferSegment>())).next as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACodedBufferSegment),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VACodedBufferSegment>())).va_reserved as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACodedBufferSegment),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VACodedBufferSegment = _VACodedBufferSegment;
extern "C" {
    pub fn vaMapBuffer(
        dpy: VADisplay,
        buf_id: VABufferID,
        pbuf: *mut *mut ::std::os::raw::c_void,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaUnmapBuffer(dpy: VADisplay, buf_id: VABufferID) -> VAStatus;
}
extern "C" {
    pub fn vaDestroyBuffer(dpy: VADisplay, buffer_id: VABufferID) -> VAStatus;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VABufferInfo {
    pub handle: usize,
    pub type_: u32,
    pub mem_type: u32,
    pub mem_size: size_t,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout_VABufferInfo() {
    assert_eq!(
        ::std::mem::size_of::<VABufferInfo>(),
        40usize,
        concat!("Size of: ", stringify!(VABufferInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VABufferInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VABufferInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VABufferInfo>())).handle as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VABufferInfo),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VABufferInfo>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VABufferInfo),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VABufferInfo>())).mem_type as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VABufferInfo),
            "::",
            stringify!(mem_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VABufferInfo>())).mem_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VABufferInfo),
            "::",
            stringify!(mem_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VABufferInfo>())).va_reserved as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VABufferInfo),
            "::",
            stringify!(va_reserved)
        )
    );
}
extern "C" {
    pub fn vaAcquireBufferHandle(
        dpy: VADisplay,
        buf_id: VABufferID,
        buf_info: *mut VABufferInfo,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaReleaseBufferHandle(dpy: VADisplay, buf_id: VABufferID) -> VAStatus;
}
extern "C" {
    pub fn vaExportSurfaceHandle(
        dpy: VADisplay,
        surface_id: VASurfaceID,
        mem_type: u32,
        flags: u32,
        descriptor: *mut ::std::os::raw::c_void,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaBeginPicture(
        dpy: VADisplay,
        context: VAContextID,
        render_target: VASurfaceID,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaRenderPicture(
        dpy: VADisplay,
        context: VAContextID,
        buffers: *mut VABufferID,
        num_buffers: ::std::os::raw::c_int,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaEndPicture(dpy: VADisplay, context: VAContextID) -> VAStatus;
}
extern "C" {
    pub fn vaMFSubmit(
        dpy: VADisplay,
        mf_context: VAMFContextID,
        contexts: *mut VAContextID,
        num_contexts: ::std::os::raw::c_int,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaSyncSurface(dpy: VADisplay, render_target: VASurfaceID) -> VAStatus;
}
extern "C" {
    pub fn vaSyncSurface2(dpy: VADisplay, surface: VASurfaceID, timeout_ns: u64) -> VAStatus;
}
pub const VASurfaceStatus_VASurfaceRendering: VASurfaceStatus = 1;
pub const VASurfaceStatus_VASurfaceDisplaying: VASurfaceStatus = 2;
pub const VASurfaceStatus_VASurfaceReady: VASurfaceStatus = 4;
pub const VASurfaceStatus_VASurfaceSkipped: VASurfaceStatus = 8;
pub type VASurfaceStatus = ::std::os::raw::c_uint;
extern "C" {
    pub fn vaQuerySurfaceStatus(
        dpy: VADisplay,
        render_target: VASurfaceID,
        status: *mut VASurfaceStatus,
    ) -> VAStatus;
}
pub const VADecodeErrorType_VADecodeSliceMissing: VADecodeErrorType = 0;
pub const VADecodeErrorType_VADecodeMBError: VADecodeErrorType = 1;
pub type VADecodeErrorType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASurfaceDecodeMBErrors {
    pub status: i32,
    pub start_mb: u32,
    pub end_mb: u32,
    pub decode_error_type: VADecodeErrorType,
    pub num_mb: u32,
    pub va_reserved: [u32; 3usize],
}
#[test]
fn bindgen_test_layout__VASurfaceDecodeMBErrors() {
    assert_eq!(
        ::std::mem::size_of::<_VASurfaceDecodeMBErrors>(),
        32usize,
        concat!("Size of: ", stringify!(_VASurfaceDecodeMBErrors))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASurfaceDecodeMBErrors>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASurfaceDecodeMBErrors))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VASurfaceDecodeMBErrors>())).status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceDecodeMBErrors),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceDecodeMBErrors>())).start_mb as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceDecodeMBErrors),
            "::",
            stringify!(start_mb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VASurfaceDecodeMBErrors>())).end_mb as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceDecodeMBErrors),
            "::",
            stringify!(end_mb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceDecodeMBErrors>())).decode_error_type as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceDecodeMBErrors),
            "::",
            stringify!(decode_error_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VASurfaceDecodeMBErrors>())).num_mb as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceDecodeMBErrors),
            "::",
            stringify!(num_mb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASurfaceDecodeMBErrors>())).va_reserved as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASurfaceDecodeMBErrors),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASurfaceDecodeMBErrors = _VASurfaceDecodeMBErrors;
extern "C" {
    pub fn vaQuerySurfaceError(
        dpy: VADisplay,
        surface: VASurfaceID,
        error_status: VAStatus,
        error_info: *mut *mut ::std::os::raw::c_void,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaSyncBuffer(dpy: VADisplay, buf_id: VABufferID, timeout_ns: u64) -> VAStatus;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAImageFormat {
    pub fourcc: u32,
    pub byte_order: u32,
    pub bits_per_pixel: u32,
    pub depth: u32,
    pub red_mask: u32,
    pub green_mask: u32,
    pub blue_mask: u32,
    pub alpha_mask: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAImageFormat() {
    assert_eq!(
        ::std::mem::size_of::<_VAImageFormat>(),
        48usize,
        concat!("Size of: ", stringify!(_VAImageFormat))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAImageFormat>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAImageFormat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImageFormat>())).fourcc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImageFormat),
            "::",
            stringify!(fourcc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImageFormat>())).byte_order as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImageFormat),
            "::",
            stringify!(byte_order)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImageFormat>())).bits_per_pixel as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImageFormat),
            "::",
            stringify!(bits_per_pixel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImageFormat>())).depth as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImageFormat),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImageFormat>())).red_mask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImageFormat),
            "::",
            stringify!(red_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImageFormat>())).green_mask as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImageFormat),
            "::",
            stringify!(green_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImageFormat>())).blue_mask as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImageFormat),
            "::",
            stringify!(blue_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImageFormat>())).alpha_mask as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImageFormat),
            "::",
            stringify!(alpha_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImageFormat>())).va_reserved as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImageFormat),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAImageFormat = _VAImageFormat;
pub type VAImageID = VAGenericID;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAImage {
    pub image_id: VAImageID,
    pub format: VAImageFormat,
    pub buf: VABufferID,
    pub width: u16,
    pub height: u16,
    pub data_size: u32,
    pub num_planes: u32,
    pub pitches: [u32; 3usize],
    pub offsets: [u32; 3usize],
    pub num_palette_entries: i32,
    pub entry_bytes: i32,
    pub component_order: [i8; 4usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAImage() {
    assert_eq!(
        ::std::mem::size_of::<_VAImage>(),
        120usize,
        concat!("Size of: ", stringify!(_VAImage))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAImage>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAImage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).image_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(image_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).format as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).buf as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).width as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).height as *const _ as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).data_size as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(data_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).num_planes as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(num_planes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).pitches as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(pitches)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).offsets as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(offsets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).num_palette_entries as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(num_palette_entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).entry_bytes as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(entry_bytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).component_order as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(component_order)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAImage>())).va_reserved as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAImage),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAImage = _VAImage;
extern "C" {
    pub fn vaMaxNumImageFormats(dpy: VADisplay) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vaQueryImageFormats(
        dpy: VADisplay,
        format_list: *mut VAImageFormat,
        num_formats: *mut ::std::os::raw::c_int,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaCreateImage(
        dpy: VADisplay,
        format: *mut VAImageFormat,
        width: ::std::os::raw::c_int,
        height: ::std::os::raw::c_int,
        image: *mut VAImage,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaDestroyImage(dpy: VADisplay, image: VAImageID) -> VAStatus;
}
extern "C" {
    pub fn vaSetImagePalette(
        dpy: VADisplay,
        image: VAImageID,
        palette: *mut ::std::os::raw::c_uchar,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaGetImage(
        dpy: VADisplay,
        surface: VASurfaceID,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
        image: VAImageID,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaPutImage(
        dpy: VADisplay,
        surface: VASurfaceID,
        image: VAImageID,
        src_x: ::std::os::raw::c_int,
        src_y: ::std::os::raw::c_int,
        src_width: ::std::os::raw::c_uint,
        src_height: ::std::os::raw::c_uint,
        dest_x: ::std::os::raw::c_int,
        dest_y: ::std::os::raw::c_int,
        dest_width: ::std::os::raw::c_uint,
        dest_height: ::std::os::raw::c_uint,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaDeriveImage(dpy: VADisplay, surface: VASurfaceID, image: *mut VAImage) -> VAStatus;
}
pub type VASubpictureID = VAGenericID;
extern "C" {
    pub fn vaMaxNumSubpictureFormats(dpy: VADisplay) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vaQuerySubpictureFormats(
        dpy: VADisplay,
        format_list: *mut VAImageFormat,
        flags: *mut ::std::os::raw::c_uint,
        num_formats: *mut ::std::os::raw::c_uint,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaCreateSubpicture(
        dpy: VADisplay,
        image: VAImageID,
        subpicture: *mut VASubpictureID,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaDestroySubpicture(dpy: VADisplay, subpicture: VASubpictureID) -> VAStatus;
}
extern "C" {
    pub fn vaSetSubpictureImage(
        dpy: VADisplay,
        subpicture: VASubpictureID,
        image: VAImageID,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaSetSubpictureChromakey(
        dpy: VADisplay,
        subpicture: VASubpictureID,
        chromakey_min: ::std::os::raw::c_uint,
        chromakey_max: ::std::os::raw::c_uint,
        chromakey_mask: ::std::os::raw::c_uint,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaSetSubpictureGlobalAlpha(
        dpy: VADisplay,
        subpicture: VASubpictureID,
        global_alpha: f32,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaAssociateSubpicture(
        dpy: VADisplay,
        subpicture: VASubpictureID,
        target_surfaces: *mut VASurfaceID,
        num_surfaces: ::std::os::raw::c_int,
        src_x: i16,
        src_y: i16,
        src_width: u16,
        src_height: u16,
        dest_x: i16,
        dest_y: i16,
        dest_width: u16,
        dest_height: u16,
        flags: u32,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaDeassociateSubpicture(
        dpy: VADisplay,
        subpicture: VASubpictureID,
        target_surfaces: *mut VASurfaceID,
        num_surfaces: ::std::os::raw::c_int,
    ) -> VAStatus;
}
pub const VADisplayAttribBLEMode_VADISPLAYATTRIB_BLE_OFF: VADisplayAttribBLEMode = 0;
pub const VADisplayAttribBLEMode_VADISPLAYATTRIB_BLE_LOW: VADisplayAttribBLEMode = 1;
pub const VADisplayAttribBLEMode_VADISPLAYATTRIB_BLE_MEDIUM: VADisplayAttribBLEMode = 2;
pub const VADisplayAttribBLEMode_VADISPLAYATTRIB_BLE_HIGH: VADisplayAttribBLEMode = 3;
pub const VADisplayAttribBLEMode_VADISPLAYATTRIB_BLE_NONE: VADisplayAttribBLEMode = 4;
pub type VADisplayAttribBLEMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VADisplayAttribValSubDevice {
    pub bits: _VADisplayAttribValSubDevice__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VADisplayAttribValSubDevice__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VADisplayAttribValSubDevice__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VADisplayAttribValSubDevice__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VADisplayAttribValSubDevice__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADisplayAttribValSubDevice__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VADisplayAttribValSubDevice__bindgen_ty_1)
        )
    );
}
impl _VADisplayAttribValSubDevice__bindgen_ty_1 {
    #[inline]
    pub fn current_sub_device(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_current_sub_device(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn sub_device_count(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_sub_device_count(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn sub_device_mask(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_sub_device_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        current_sub_device: u32,
        sub_device_count: u32,
        reserved: u32,
        sub_device_mask: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let current_sub_device: u32 = unsafe { ::std::mem::transmute(current_sub_device) };
            current_sub_device as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let sub_device_count: u32 = unsafe { ::std::mem::transmute(sub_device_count) };
            sub_device_count as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let sub_device_mask: u32 = unsafe { ::std::mem::transmute(sub_device_mask) };
            sub_device_mask as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VADisplayAttribValSubDevice() {
    assert_eq!(
        ::std::mem::size_of::<_VADisplayAttribValSubDevice>(),
        4usize,
        concat!("Size of: ", stringify!(_VADisplayAttribValSubDevice))
    );
    assert_eq!(
        ::std::mem::align_of::<_VADisplayAttribValSubDevice>(),
        4usize,
        concat!("Alignment of ", stringify!(_VADisplayAttribValSubDevice))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADisplayAttribValSubDevice>())).bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADisplayAttribValSubDevice),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADisplayAttribValSubDevice>())).value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADisplayAttribValSubDevice),
            "::",
            stringify!(value)
        )
    );
}
pub type VADisplayAttribValSubDevice = _VADisplayAttribValSubDevice;
pub const VADisplayAttribType_VADisplayAttribBrightness: VADisplayAttribType = 0;
pub const VADisplayAttribType_VADisplayAttribContrast: VADisplayAttribType = 1;
pub const VADisplayAttribType_VADisplayAttribHue: VADisplayAttribType = 2;
pub const VADisplayAttribType_VADisplayAttribSaturation: VADisplayAttribType = 3;
pub const VADisplayAttribType_VADisplayAttribBackgroundColor: VADisplayAttribType = 4;
pub const VADisplayAttribType_VADisplayAttribDirectSurface: VADisplayAttribType = 5;
pub const VADisplayAttribType_VADisplayAttribRotation: VADisplayAttribType = 6;
pub const VADisplayAttribType_VADisplayAttribOutofLoopDeblock: VADisplayAttribType = 7;
pub const VADisplayAttribType_VADisplayAttribBLEBlackMode: VADisplayAttribType = 8;
pub const VADisplayAttribType_VADisplayAttribBLEWhiteMode: VADisplayAttribType = 9;
pub const VADisplayAttribType_VADisplayAttribBlueStretch: VADisplayAttribType = 10;
pub const VADisplayAttribType_VADisplayAttribSkinColorCorrection: VADisplayAttribType = 11;
pub const VADisplayAttribType_VADisplayAttribCSCMatrix: VADisplayAttribType = 12;
pub const VADisplayAttribType_VADisplayAttribBlendColor: VADisplayAttribType = 13;
pub const VADisplayAttribType_VADisplayAttribOverlayAutoPaintColorKey: VADisplayAttribType = 14;
pub const VADisplayAttribType_VADisplayAttribOverlayColorKey: VADisplayAttribType = 15;
pub const VADisplayAttribType_VADisplayAttribRenderMode: VADisplayAttribType = 16;
pub const VADisplayAttribType_VADisplayAttribRenderDevice: VADisplayAttribType = 17;
pub const VADisplayAttribType_VADisplayAttribRenderRect: VADisplayAttribType = 18;
pub const VADisplayAttribType_VADisplayAttribSubDevice: VADisplayAttribType = 19;
pub const VADisplayAttribType_VADisplayAttribCopy: VADisplayAttribType = 20;
pub type VADisplayAttribType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VADisplayAttribute {
    pub type_: VADisplayAttribType,
    pub min_value: i32,
    pub max_value: i32,
    pub value: i32,
    pub flags: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VADisplayAttribute() {
    assert_eq!(
        ::std::mem::size_of::<_VADisplayAttribute>(),
        36usize,
        concat!("Size of: ", stringify!(_VADisplayAttribute))
    );
    assert_eq!(
        ::std::mem::align_of::<_VADisplayAttribute>(),
        4usize,
        concat!("Alignment of ", stringify!(_VADisplayAttribute))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VADisplayAttribute>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADisplayAttribute),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VADisplayAttribute>())).min_value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADisplayAttribute),
            "::",
            stringify!(min_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VADisplayAttribute>())).max_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADisplayAttribute),
            "::",
            stringify!(max_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VADisplayAttribute>())).value as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADisplayAttribute),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VADisplayAttribute>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADisplayAttribute),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VADisplayAttribute>())).va_reserved as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADisplayAttribute),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VADisplayAttribute = _VADisplayAttribute;
extern "C" {
    pub fn vaMaxNumDisplayAttributes(dpy: VADisplay) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vaQueryDisplayAttributes(
        dpy: VADisplay,
        attr_list: *mut VADisplayAttribute,
        num_attributes: *mut ::std::os::raw::c_int,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaGetDisplayAttributes(
        dpy: VADisplay,
        attr_list: *mut VADisplayAttribute,
        num_attributes: ::std::os::raw::c_int,
    ) -> VAStatus;
}
extern "C" {
    pub fn vaSetDisplayAttributes(
        dpy: VADisplay,
        attr_list: *mut VADisplayAttribute,
        num_attributes: ::std::os::raw::c_int,
    ) -> VAStatus;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureHEVC {
    pub picture_id: VASurfaceID,
    pub pic_order_cnt: i32,
    pub flags: u32,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAPictureHEVC() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureHEVC>(),
        28usize,
        concat!("Size of: ", stringify!(_VAPictureHEVC))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureHEVC>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAPictureHEVC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureHEVC>())).picture_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureHEVC),
            "::",
            stringify!(picture_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureHEVC>())).pic_order_cnt as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureHEVC),
            "::",
            stringify!(pic_order_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureHEVC>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureHEVC),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureHEVC>())).va_reserved as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureHEVC),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAPictureHEVC = _VAPictureHEVC;
pub const VACopyObjectType_VACopyObjectSurface: VACopyObjectType = 0;
pub const VACopyObjectType_VACopyObjectBuffer: VACopyObjectType = 1;
pub type VACopyObjectType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VACopyObject {
    pub obj_type: VACopyObjectType,
    pub object: _VACopyObject__bindgen_ty_1,
    pub va_reserved: [u32; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VACopyObject__bindgen_ty_1 {
    pub surface_id: VASurfaceID,
    pub buffer_id: VABufferID,
}
#[test]
fn bindgen_test_layout__VACopyObject__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VACopyObject__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(_VACopyObject__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VACopyObject__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(_VACopyObject__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VACopyObject__bindgen_ty_1>())).surface_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACopyObject__bindgen_ty_1),
            "::",
            stringify!(surface_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VACopyObject__bindgen_ty_1>())).buffer_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACopyObject__bindgen_ty_1),
            "::",
            stringify!(buffer_id)
        )
    );
}
#[test]
fn bindgen_test_layout__VACopyObject() {
    assert_eq!(
        ::std::mem::size_of::<_VACopyObject>(),
        40usize,
        concat!("Size of: ", stringify!(_VACopyObject))
    );
    assert_eq!(
        ::std::mem::align_of::<_VACopyObject>(),
        4usize,
        concat!("Alignment of ", stringify!(_VACopyObject))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VACopyObject>())).obj_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACopyObject),
            "::",
            stringify!(obj_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VACopyObject>())).object as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACopyObject),
            "::",
            stringify!(object)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VACopyObject>())).va_reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACopyObject),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VACopyObject = _VACopyObject;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VACopyOption {
    pub bits: _VACopyOption__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VACopyOption__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VACopyOption__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VACopyOption__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(_VACopyOption__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VACopyOption__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(_VACopyOption__bindgen_ty_1))
    );
}
impl _VACopyOption__bindgen_ty_1 {
    #[inline]
    pub fn va_copy_sync(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_va_copy_sync(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn va_copy_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_va_copy_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 26u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 26u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        va_copy_sync: u32,
        va_copy_mode: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let va_copy_sync: u32 = unsafe { ::std::mem::transmute(va_copy_sync) };
            va_copy_sync as u64
        });
        __bindgen_bitfield_unit.set(2usize, 4u8, {
            let va_copy_mode: u32 = unsafe { ::std::mem::transmute(va_copy_mode) };
            va_copy_mode as u64
        });
        __bindgen_bitfield_unit.set(6usize, 26u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VACopyOption() {
    assert_eq!(
        ::std::mem::size_of::<_VACopyOption>(),
        4usize,
        concat!("Size of: ", stringify!(_VACopyOption))
    );
    assert_eq!(
        ::std::mem::align_of::<_VACopyOption>(),
        4usize,
        concat!("Alignment of ", stringify!(_VACopyOption))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VACopyOption>())).bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACopyOption),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VACopyOption>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VACopyOption),
            "::",
            stringify!(value)
        )
    );
}
pub type VACopyOption = _VACopyOption;
extern "C" {
    pub fn vaCopy(
        dpy: VADisplay,
        dst: *mut VACopyObject,
        src: *mut VACopyObject,
        option: VACopyOption,
    ) -> VAStatus;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAPictureParameterBufferHEVC {
    pub CurrPic: VAPictureHEVC,
    pub ReferenceFrames: [VAPictureHEVC; 15usize],
    pub pic_width_in_luma_samples: u16,
    pub pic_height_in_luma_samples: u16,
    pub pic_fields: _VAPictureParameterBufferHEVC__bindgen_ty_1,
    pub sps_max_dec_pic_buffering_minus1: u8,
    pub bit_depth_luma_minus8: u8,
    pub bit_depth_chroma_minus8: u8,
    pub pcm_sample_bit_depth_luma_minus1: u8,
    pub pcm_sample_bit_depth_chroma_minus1: u8,
    pub log2_min_luma_coding_block_size_minus3: u8,
    pub log2_diff_max_min_luma_coding_block_size: u8,
    pub log2_min_transform_block_size_minus2: u8,
    pub log2_diff_max_min_transform_block_size: u8,
    pub log2_min_pcm_luma_coding_block_size_minus3: u8,
    pub log2_diff_max_min_pcm_luma_coding_block_size: u8,
    pub max_transform_hierarchy_depth_intra: u8,
    pub max_transform_hierarchy_depth_inter: u8,
    pub init_qp_minus26: i8,
    pub diff_cu_qp_delta_depth: u8,
    pub pps_cb_qp_offset: i8,
    pub pps_cr_qp_offset: i8,
    pub log2_parallel_merge_level_minus2: u8,
    pub num_tile_columns_minus1: u8,
    pub num_tile_rows_minus1: u8,
    pub column_width_minus1: [u16; 19usize],
    pub row_height_minus1: [u16; 21usize],
    pub slice_parsing_fields: _VAPictureParameterBufferHEVC__bindgen_ty_2,
    pub log2_max_pic_order_cnt_lsb_minus4: u8,
    pub num_short_term_ref_pic_sets: u8,
    pub num_long_term_ref_pic_sps: u8,
    pub num_ref_idx_l0_default_active_minus1: u8,
    pub num_ref_idx_l1_default_active_minus1: u8,
    pub pps_beta_offset_div2: i8,
    pub pps_tc_offset_div2: i8,
    pub num_extra_slice_header_bits: u8,
    pub st_rps_bits: u32,
    pub va_reserved: [u32; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferHEVC__bindgen_ty_1 {
    pub bits: _VAPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn chroma_format_idc(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_format_idc(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_colour_plane_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_separate_colour_plane_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scaling_list_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scaling_list_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn amp_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_amp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn strong_intra_smoothing_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_strong_intra_smoothing_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sign_data_hiding_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign_data_hiding_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constrained_intra_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constrained_intra_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cu_qp_delta_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cu_qp_delta_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_bipred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_bipred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transquant_bypass_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transquant_bypass_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tiles_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tiles_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn entropy_coding_sync_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_entropy_coding_sync_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_loop_filter_across_slices_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_loop_filter_across_slices_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn loop_filter_across_tiles_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_loop_filter_across_tiles_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm_loop_filter_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pcm_loop_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn NoPicReorderingFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_NoPicReorderingFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn NoBiPredFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_NoBiPredFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ReservedBits(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 11u8) as u32) }
    }
    #[inline]
    pub fn set_ReservedBits(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 11u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        chroma_format_idc: u32,
        separate_colour_plane_flag: u32,
        pcm_enabled_flag: u32,
        scaling_list_enabled_flag: u32,
        transform_skip_enabled_flag: u32,
        amp_enabled_flag: u32,
        strong_intra_smoothing_enabled_flag: u32,
        sign_data_hiding_enabled_flag: u32,
        constrained_intra_pred_flag: u32,
        cu_qp_delta_enabled_flag: u32,
        weighted_pred_flag: u32,
        weighted_bipred_flag: u32,
        transquant_bypass_enabled_flag: u32,
        tiles_enabled_flag: u32,
        entropy_coding_sync_enabled_flag: u32,
        pps_loop_filter_across_slices_enabled_flag: u32,
        loop_filter_across_tiles_enabled_flag: u32,
        pcm_loop_filter_disabled_flag: u32,
        NoPicReorderingFlag: u32,
        NoBiPredFlag: u32,
        ReservedBits: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let chroma_format_idc: u32 = unsafe { ::std::mem::transmute(chroma_format_idc) };
            chroma_format_idc as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let separate_colour_plane_flag: u32 =
                unsafe { ::std::mem::transmute(separate_colour_plane_flag) };
            separate_colour_plane_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let pcm_enabled_flag: u32 = unsafe { ::std::mem::transmute(pcm_enabled_flag) };
            pcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let scaling_list_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(scaling_list_enabled_flag) };
            scaling_list_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let transform_skip_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transform_skip_enabled_flag) };
            transform_skip_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let amp_enabled_flag: u32 = unsafe { ::std::mem::transmute(amp_enabled_flag) };
            amp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let strong_intra_smoothing_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(strong_intra_smoothing_enabled_flag) };
            strong_intra_smoothing_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let sign_data_hiding_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sign_data_hiding_enabled_flag) };
            sign_data_hiding_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let constrained_intra_pred_flag: u32 =
                unsafe { ::std::mem::transmute(constrained_intra_pred_flag) };
            constrained_intra_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let cu_qp_delta_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cu_qp_delta_enabled_flag) };
            cu_qp_delta_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let weighted_pred_flag: u32 = unsafe { ::std::mem::transmute(weighted_pred_flag) };
            weighted_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let weighted_bipred_flag: u32 = unsafe { ::std::mem::transmute(weighted_bipred_flag) };
            weighted_bipred_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let transquant_bypass_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transquant_bypass_enabled_flag) };
            transquant_bypass_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let tiles_enabled_flag: u32 = unsafe { ::std::mem::transmute(tiles_enabled_flag) };
            tiles_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let entropy_coding_sync_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(entropy_coding_sync_enabled_flag) };
            entropy_coding_sync_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let pps_loop_filter_across_slices_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(pps_loop_filter_across_slices_enabled_flag) };
            pps_loop_filter_across_slices_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let loop_filter_across_tiles_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(loop_filter_across_tiles_enabled_flag) };
            loop_filter_across_tiles_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let pcm_loop_filter_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(pcm_loop_filter_disabled_flag) };
            pcm_loop_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let NoPicReorderingFlag: u32 = unsafe { ::std::mem::transmute(NoPicReorderingFlag) };
            NoPicReorderingFlag as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let NoBiPredFlag: u32 = unsafe { ::std::mem::transmute(NoBiPredFlag) };
            NoBiPredFlag as u64
        });
        __bindgen_bitfield_unit.set(21usize, 11u8, {
            let ReservedBits: u32 = unsafe { ::std::mem::transmute(ReservedBits) };
            ReservedBits as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVC__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVC__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVC__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC__bindgen_ty_1>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferHEVC__bindgen_ty_2 {
    pub bits: _VAPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1 {
    #[inline]
    pub fn lists_modification_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_lists_modification_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn long_term_ref_pics_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_long_term_ref_pics_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_temporal_mvp_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_temporal_mvp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_init_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_init_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn output_flag_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_output_flag_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dependent_slice_segments_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slice_segments_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_slice_chroma_qp_offsets_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_slice_chroma_qp_offsets_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sample_adaptive_offset_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample_adaptive_offset_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_override_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_override_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_disable_deblocking_filter_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_disable_deblocking_filter_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_segment_header_extension_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_segment_header_extension_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn RapPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_RapPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IdrPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IdrPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IntraPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IntraPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ReservedBits(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 18u8) as u32) }
    }
    #[inline]
    pub fn set_ReservedBits(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 18u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lists_modification_present_flag: u32,
        long_term_ref_pics_present_flag: u32,
        sps_temporal_mvp_enabled_flag: u32,
        cabac_init_present_flag: u32,
        output_flag_present_flag: u32,
        dependent_slice_segments_enabled_flag: u32,
        pps_slice_chroma_qp_offsets_present_flag: u32,
        sample_adaptive_offset_enabled_flag: u32,
        deblocking_filter_override_enabled_flag: u32,
        pps_disable_deblocking_filter_flag: u32,
        slice_segment_header_extension_present_flag: u32,
        RapPicFlag: u32,
        IdrPicFlag: u32,
        IntraPicFlag: u32,
        ReservedBits: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let lists_modification_present_flag: u32 =
                unsafe { ::std::mem::transmute(lists_modification_present_flag) };
            lists_modification_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let long_term_ref_pics_present_flag: u32 =
                unsafe { ::std::mem::transmute(long_term_ref_pics_present_flag) };
            long_term_ref_pics_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let sps_temporal_mvp_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sps_temporal_mvp_enabled_flag) };
            sps_temporal_mvp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let cabac_init_present_flag: u32 =
                unsafe { ::std::mem::transmute(cabac_init_present_flag) };
            cabac_init_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let output_flag_present_flag: u32 =
                unsafe { ::std::mem::transmute(output_flag_present_flag) };
            output_flag_present_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let dependent_slice_segments_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(dependent_slice_segments_enabled_flag) };
            dependent_slice_segments_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let pps_slice_chroma_qp_offsets_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_slice_chroma_qp_offsets_present_flag) };
            pps_slice_chroma_qp_offsets_present_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let sample_adaptive_offset_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sample_adaptive_offset_enabled_flag) };
            sample_adaptive_offset_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let deblocking_filter_override_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(deblocking_filter_override_enabled_flag) };
            deblocking_filter_override_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let pps_disable_deblocking_filter_flag: u32 =
                unsafe { ::std::mem::transmute(pps_disable_deblocking_filter_flag) };
            pps_disable_deblocking_filter_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let slice_segment_header_extension_present_flag: u32 =
                unsafe { ::std::mem::transmute(slice_segment_header_extension_present_flag) };
            slice_segment_header_extension_present_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let RapPicFlag: u32 = unsafe { ::std::mem::transmute(RapPicFlag) };
            RapPicFlag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let IdrPicFlag: u32 = unsafe { ::std::mem::transmute(IdrPicFlag) };
            IdrPicFlag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let IntraPicFlag: u32 = unsafe { ::std::mem::transmute(IntraPicFlag) };
            IntraPicFlag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 18u8, {
            let ReservedBits: u32 = unsafe { ::std::mem::transmute(ReservedBits) };
            ReservedBits as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVC__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVC__bindgen_ty_2>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVC__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC__bindgen_ty_2>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_2),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC__bindgen_ty_2>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC__bindgen_ty_2),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVC() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVC>(),
        604usize,
        concat!("Size of: ", stringify!(_VAPictureParameterBufferHEVC))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVC>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAPictureParameterBufferHEVC))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).CurrPic as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(CurrPic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).ReferenceFrames as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(ReferenceFrames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).pic_width_in_luma_samples
                as *const _ as usize
        },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(pic_width_in_luma_samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).pic_height_in_luma_samples
                as *const _ as usize
        },
        450usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(pic_height_in_luma_samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).pic_fields as *const _
                as usize
        },
        452usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(pic_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .sps_max_dec_pic_buffering_minus1 as *const _ as usize
        },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(sps_max_dec_pic_buffering_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).bit_depth_luma_minus8
                as *const _ as usize
        },
        457usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(bit_depth_luma_minus8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).bit_depth_chroma_minus8
                as *const _ as usize
        },
        458usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(bit_depth_chroma_minus8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .pcm_sample_bit_depth_luma_minus1 as *const _ as usize
        },
        459usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(pcm_sample_bit_depth_luma_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .pcm_sample_bit_depth_chroma_minus1 as *const _ as usize
        },
        460usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(pcm_sample_bit_depth_chroma_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .log2_min_luma_coding_block_size_minus3 as *const _ as usize
        },
        461usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(log2_min_luma_coding_block_size_minus3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .log2_diff_max_min_luma_coding_block_size as *const _ as usize
        },
        462usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(log2_diff_max_min_luma_coding_block_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .log2_min_transform_block_size_minus2 as *const _ as usize
        },
        463usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(log2_min_transform_block_size_minus2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .log2_diff_max_min_transform_block_size as *const _ as usize
        },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(log2_diff_max_min_transform_block_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .log2_min_pcm_luma_coding_block_size_minus3 as *const _ as usize
        },
        465usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(log2_min_pcm_luma_coding_block_size_minus3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .log2_diff_max_min_pcm_luma_coding_block_size as *const _ as usize
        },
        466usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(log2_diff_max_min_pcm_luma_coding_block_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .max_transform_hierarchy_depth_intra as *const _ as usize
        },
        467usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(max_transform_hierarchy_depth_intra)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .max_transform_hierarchy_depth_inter as *const _ as usize
        },
        468usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(max_transform_hierarchy_depth_inter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).init_qp_minus26 as *const _
                as usize
        },
        469usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(init_qp_minus26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).diff_cu_qp_delta_depth
                as *const _ as usize
        },
        470usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(diff_cu_qp_delta_depth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).pps_cb_qp_offset as *const _
                as usize
        },
        471usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(pps_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).pps_cr_qp_offset as *const _
                as usize
        },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(pps_cr_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .log2_parallel_merge_level_minus2 as *const _ as usize
        },
        473usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(log2_parallel_merge_level_minus2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).num_tile_columns_minus1
                as *const _ as usize
        },
        474usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(num_tile_columns_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).num_tile_rows_minus1
                as *const _ as usize
        },
        475usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(num_tile_rows_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).column_width_minus1
                as *const _ as usize
        },
        476usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(column_width_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).row_height_minus1 as *const _
                as usize
        },
        514usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(row_height_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).slice_parsing_fields
                as *const _ as usize
        },
        556usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(slice_parsing_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .log2_max_pic_order_cnt_lsb_minus4 as *const _ as usize
        },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(log2_max_pic_order_cnt_lsb_minus4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).num_short_term_ref_pic_sets
                as *const _ as usize
        },
        561usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(num_short_term_ref_pic_sets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).num_long_term_ref_pic_sps
                as *const _ as usize
        },
        562usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(num_long_term_ref_pic_sps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .num_ref_idx_l0_default_active_minus1 as *const _ as usize
        },
        563usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(num_ref_idx_l0_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>()))
                .num_ref_idx_l1_default_active_minus1 as *const _ as usize
        },
        564usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(num_ref_idx_l1_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).pps_beta_offset_div2
                as *const _ as usize
        },
        565usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(pps_beta_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).pps_tc_offset_div2 as *const _
                as usize
        },
        566usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(pps_tc_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).num_extra_slice_header_bits
                as *const _ as usize
        },
        567usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(num_extra_slice_header_bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).st_rps_bits as *const _
                as usize
        },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(st_rps_bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVC>())).va_reserved as *const _
                as usize
        },
        572usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVC),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAPictureParameterBufferHEVC = _VAPictureParameterBufferHEVC;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAPictureParameterBufferHEVCRext {
    pub range_extension_pic_fields: _VAPictureParameterBufferHEVCRext__bindgen_ty_1,
    pub diff_cu_chroma_qp_offset_depth: u8,
    pub chroma_qp_offset_list_len_minus1: u8,
    pub log2_sao_offset_scale_luma: u8,
    pub log2_sao_offset_scale_chroma: u8,
    pub log2_max_transform_skip_block_size_minus2: u8,
    pub cb_qp_offset_list: [i8; 6usize],
    pub cr_qp_offset_list: [i8; 6usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferHEVCRext__bindgen_ty_1 {
    pub bits: _VAPictureParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn transform_skip_rotation_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_rotation_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_context_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_context_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn implicit_rdpcm_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_implicit_rdpcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_rdpcm_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_rdpcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn extended_precision_processing_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_extended_precision_processing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_smoothing_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_smoothing_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn high_precision_offsets_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_high_precision_offsets_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn persistent_rice_adaptation_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_persistent_rice_adaptation_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_bypass_alignment_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_bypass_alignment_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cross_component_prediction_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cross_component_prediction_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_qp_offset_list_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_qp_offset_list_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 21u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 21u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        transform_skip_rotation_enabled_flag: u32,
        transform_skip_context_enabled_flag: u32,
        implicit_rdpcm_enabled_flag: u32,
        explicit_rdpcm_enabled_flag: u32,
        extended_precision_processing_flag: u32,
        intra_smoothing_disabled_flag: u32,
        high_precision_offsets_enabled_flag: u32,
        persistent_rice_adaptation_enabled_flag: u32,
        cabac_bypass_alignment_enabled_flag: u32,
        cross_component_prediction_enabled_flag: u32,
        chroma_qp_offset_list_enabled_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let transform_skip_rotation_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transform_skip_rotation_enabled_flag) };
            transform_skip_rotation_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let transform_skip_context_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transform_skip_context_enabled_flag) };
            transform_skip_context_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let implicit_rdpcm_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(implicit_rdpcm_enabled_flag) };
            implicit_rdpcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let explicit_rdpcm_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(explicit_rdpcm_enabled_flag) };
            explicit_rdpcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let extended_precision_processing_flag: u32 =
                unsafe { ::std::mem::transmute(extended_precision_processing_flag) };
            extended_precision_processing_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let intra_smoothing_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(intra_smoothing_disabled_flag) };
            intra_smoothing_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let high_precision_offsets_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(high_precision_offsets_enabled_flag) };
            high_precision_offsets_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let persistent_rice_adaptation_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(persistent_rice_adaptation_enabled_flag) };
            persistent_rice_adaptation_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let cabac_bypass_alignment_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cabac_bypass_alignment_enabled_flag) };
            cabac_bypass_alignment_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let cross_component_prediction_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cross_component_prediction_enabled_flag) };
            cross_component_prediction_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let chroma_qp_offset_list_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(chroma_qp_offset_list_enabled_flag) };
            chroma_qp_offset_list_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 21u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVCRext__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVCRext__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferHEVCRext__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVCRext__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVCRext__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCRext__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCRext__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCRext__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCRext__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVCRext() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVCRext>(),
        24usize,
        concat!("Size of: ", stringify!(_VAPictureParameterBufferHEVCRext))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVCRext>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVCRext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCRext>())).range_extension_pic_fields
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCRext),
            "::",
            stringify!(range_extension_pic_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCRext>()))
                .diff_cu_chroma_qp_offset_depth as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCRext),
            "::",
            stringify!(diff_cu_chroma_qp_offset_depth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCRext>()))
                .chroma_qp_offset_list_len_minus1 as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCRext),
            "::",
            stringify!(chroma_qp_offset_list_len_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCRext>())).log2_sao_offset_scale_luma
                as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCRext),
            "::",
            stringify!(log2_sao_offset_scale_luma)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCRext>()))
                .log2_sao_offset_scale_chroma as *const _ as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCRext),
            "::",
            stringify!(log2_sao_offset_scale_chroma)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCRext>()))
                .log2_max_transform_skip_block_size_minus2 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCRext),
            "::",
            stringify!(log2_max_transform_skip_block_size_minus2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCRext>())).cb_qp_offset_list
                as *const _ as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCRext),
            "::",
            stringify!(cb_qp_offset_list)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCRext>())).cr_qp_offset_list
                as *const _ as usize
        },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCRext),
            "::",
            stringify!(cr_qp_offset_list)
        )
    );
}
pub type VAPictureParameterBufferHEVCRext = _VAPictureParameterBufferHEVCRext;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAPictureParameterBufferHEVCScc {
    pub screen_content_pic_fields: _VAPictureParameterBufferHEVCScc__bindgen_ty_1,
    pub palette_max_size: u8,
    pub delta_palette_max_predictor_size: u8,
    pub predictor_palette_size: u8,
    pub predictor_palette_entries: [[u16; 128usize]; 3usize],
    pub pps_act_y_qp_offset_plus5: i8,
    pub pps_act_cb_qp_offset_plus5: i8,
    pub pps_act_cr_qp_offset_plus3: i8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferHEVCScc__bindgen_ty_1 {
    pub bits: _VAPictureParameterBufferHEVCScc__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferHEVCScc__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVCScc__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVCScc__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferHEVCScc__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVCScc__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVCScc__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferHEVCScc__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn pps_curr_pic_ref_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_curr_pic_ref_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn palette_mode_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_palette_mode_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn motion_vector_resolution_control_idc(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_motion_vector_resolution_control_idc(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_boundary_filtering_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_boundary_filtering_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn residual_adaptive_colour_transform_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_residual_adaptive_colour_transform_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_slice_act_qp_offsets_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_slice_act_qp_offsets_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 25u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 25u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pps_curr_pic_ref_enabled_flag: u32,
        palette_mode_enabled_flag: u32,
        motion_vector_resolution_control_idc: u32,
        intra_boundary_filtering_disabled_flag: u32,
        residual_adaptive_colour_transform_enabled_flag: u32,
        pps_slice_act_qp_offsets_present_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let pps_curr_pic_ref_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(pps_curr_pic_ref_enabled_flag) };
            pps_curr_pic_ref_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let palette_mode_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(palette_mode_enabled_flag) };
            palette_mode_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let motion_vector_resolution_control_idc: u32 =
                unsafe { ::std::mem::transmute(motion_vector_resolution_control_idc) };
            motion_vector_resolution_control_idc as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let intra_boundary_filtering_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(intra_boundary_filtering_disabled_flag) };
            intra_boundary_filtering_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let residual_adaptive_colour_transform_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(residual_adaptive_colour_transform_enabled_flag) };
            residual_adaptive_colour_transform_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let pps_slice_act_qp_offsets_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_slice_act_qp_offsets_present_flag) };
            pps_slice_act_qp_offsets_present_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 25u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVCScc__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVCScc__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferHEVCScc__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVCScc__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVCScc__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCScc__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCScc__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCScc__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCScc__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVCScc() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVCScc>(),
        780usize,
        concat!("Size of: ", stringify!(_VAPictureParameterBufferHEVCScc))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVCScc>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVCScc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCScc>())).screen_content_pic_fields
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCScc),
            "::",
            stringify!(screen_content_pic_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCScc>())).palette_max_size
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCScc),
            "::",
            stringify!(palette_max_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCScc>()))
                .delta_palette_max_predictor_size as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCScc),
            "::",
            stringify!(delta_palette_max_predictor_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCScc>())).predictor_palette_size
                as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCScc),
            "::",
            stringify!(predictor_palette_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCScc>())).predictor_palette_entries
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCScc),
            "::",
            stringify!(predictor_palette_entries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCScc>())).pps_act_y_qp_offset_plus5
                as *const _ as usize
        },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCScc),
            "::",
            stringify!(pps_act_y_qp_offset_plus5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCScc>())).pps_act_cb_qp_offset_plus5
                as *const _ as usize
        },
        777usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCScc),
            "::",
            stringify!(pps_act_cb_qp_offset_plus5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCScc>())).pps_act_cr_qp_offset_plus3
                as *const _ as usize
        },
        778usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCScc),
            "::",
            stringify!(pps_act_cr_qp_offset_plus3)
        )
    );
}
pub type VAPictureParameterBufferHEVCScc = _VAPictureParameterBufferHEVCScc;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAPictureParameterBufferHEVCExtension {
    pub base: VAPictureParameterBufferHEVC,
    pub rext: VAPictureParameterBufferHEVCRext,
    pub scc: VAPictureParameterBufferHEVCScc,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferHEVCExtension() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferHEVCExtension>(),
        1408usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferHEVCExtension)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferHEVCExtension>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferHEVCExtension)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCExtension>())).base as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCExtension),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCExtension>())).rext as *const _
                as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCExtension),
            "::",
            stringify!(rext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferHEVCExtension>())).scc as *const _
                as usize
        },
        628usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferHEVCExtension),
            "::",
            stringify!(scc)
        )
    );
}
pub type VAPictureParameterBufferHEVCExtension = _VAPictureParameterBufferHEVCExtension;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VASliceParameterBufferHEVC {
    pub slice_data_size: u32,
    pub slice_data_offset: u32,
    pub slice_data_flag: u32,
    pub slice_data_byte_offset: u32,
    pub slice_segment_address: u32,
    pub RefPicList: [[u8; 15usize]; 2usize],
    pub LongSliceFlags: _VASliceParameterBufferHEVC__bindgen_ty_1,
    pub collocated_ref_idx: u8,
    pub num_ref_idx_l0_active_minus1: u8,
    pub num_ref_idx_l1_active_minus1: u8,
    pub slice_qp_delta: i8,
    pub slice_cb_qp_offset: i8,
    pub slice_cr_qp_offset: i8,
    pub slice_beta_offset_div2: i8,
    pub slice_tc_offset_div2: i8,
    pub luma_log2_weight_denom: u8,
    pub delta_chroma_log2_weight_denom: i8,
    pub delta_luma_weight_l0: [i8; 15usize],
    pub luma_offset_l0: [i8; 15usize],
    pub delta_chroma_weight_l0: [[i8; 2usize]; 15usize],
    pub ChromaOffsetL0: [[i8; 2usize]; 15usize],
    pub delta_luma_weight_l1: [i8; 15usize],
    pub luma_offset_l1: [i8; 15usize],
    pub delta_chroma_weight_l1: [[i8; 2usize]; 15usize],
    pub ChromaOffsetL1: [[i8; 2usize]; 15usize],
    pub five_minus_max_num_merge_cand: u8,
    pub num_entry_point_offsets: u16,
    pub entry_offset_to_subset_array: u16,
    pub slice_data_num_emu_prevn_bytes: u16,
    pub va_reserved: [u32; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VASliceParameterBufferHEVC__bindgen_ty_1 {
    pub value: u32,
    pub fields: _VASliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VASliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VASliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VASliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn LastSliceOfPic(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_LastSliceOfPic(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dependent_slice_segment_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slice_segment_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_slice_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn color_plane_id(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_color_plane_id(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_sao_luma_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_sao_luma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_sao_chroma_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_sao_chroma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mvd_l1_zero_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mvd_l1_zero_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_init_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_init_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_temporal_mvp_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_temporal_mvp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_deblocking_filter_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_deblocking_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn collocated_from_l0_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_collocated_from_l0_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_loop_filter_across_slices_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_loop_filter_across_slices_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 18u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 18u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        LastSliceOfPic: u32,
        dependent_slice_segment_flag: u32,
        slice_type: u32,
        color_plane_id: u32,
        slice_sao_luma_flag: u32,
        slice_sao_chroma_flag: u32,
        mvd_l1_zero_flag: u32,
        cabac_init_flag: u32,
        slice_temporal_mvp_enabled_flag: u32,
        slice_deblocking_filter_disabled_flag: u32,
        collocated_from_l0_flag: u32,
        slice_loop_filter_across_slices_enabled_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let LastSliceOfPic: u32 = unsafe { ::std::mem::transmute(LastSliceOfPic) };
            LastSliceOfPic as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let dependent_slice_segment_flag: u32 =
                unsafe { ::std::mem::transmute(dependent_slice_segment_flag) };
            dependent_slice_segment_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let slice_type: u32 = unsafe { ::std::mem::transmute(slice_type) };
            slice_type as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let color_plane_id: u32 = unsafe { ::std::mem::transmute(color_plane_id) };
            color_plane_id as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let slice_sao_luma_flag: u32 = unsafe { ::std::mem::transmute(slice_sao_luma_flag) };
            slice_sao_luma_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let slice_sao_chroma_flag: u32 =
                unsafe { ::std::mem::transmute(slice_sao_chroma_flag) };
            slice_sao_chroma_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let mvd_l1_zero_flag: u32 = unsafe { ::std::mem::transmute(mvd_l1_zero_flag) };
            mvd_l1_zero_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let cabac_init_flag: u32 = unsafe { ::std::mem::transmute(cabac_init_flag) };
            cabac_init_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let slice_temporal_mvp_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(slice_temporal_mvp_enabled_flag) };
            slice_temporal_mvp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let slice_deblocking_filter_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(slice_deblocking_filter_disabled_flag) };
            slice_deblocking_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let collocated_from_l0_flag: u32 =
                unsafe { ::std::mem::transmute(collocated_from_l0_flag) };
            collocated_from_l0_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let slice_loop_filter_across_slices_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(slice_loop_filter_across_slices_enabled_flag) };
            slice_loop_filter_across_slices_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 18u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferHEVC__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferHEVC__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VASliceParameterBufferHEVC__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferHEVC__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VASliceParameterBufferHEVC__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC__bindgen_ty_1>())).fields as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC__bindgen_ty_1),
            "::",
            stringify!(fields)
        )
    );
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferHEVC() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferHEVC>(),
        264usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferHEVC))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferHEVC>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASliceParameterBufferHEVC))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_data_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_data_offset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_data_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_data_flag as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_data_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_data_byte_offset
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_data_byte_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_segment_address
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_segment_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).RefPicList as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(RefPicList)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).LongSliceFlags as *const _
                as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(LongSliceFlags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).collocated_ref_idx as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(collocated_ref_idx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).num_ref_idx_l0_active_minus1
                as *const _ as usize
        },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(num_ref_idx_l0_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).num_ref_idx_l1_active_minus1
                as *const _ as usize
        },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(num_ref_idx_l1_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_qp_delta as *const _
                as usize
        },
        59usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_qp_delta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_cb_qp_offset as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_cr_qp_offset as *const _
                as usize
        },
        61usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_cr_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_beta_offset_div2
                as *const _ as usize
        },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_beta_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_tc_offset_div2 as *const _
                as usize
        },
        63usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_tc_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).luma_log2_weight_denom
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(luma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).delta_chroma_log2_weight_denom
                as *const _ as usize
        },
        65usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(delta_chroma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).delta_luma_weight_l0 as *const _
                as usize
        },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(delta_luma_weight_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).luma_offset_l0 as *const _
                as usize
        },
        81usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(luma_offset_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).delta_chroma_weight_l0
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(delta_chroma_weight_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).ChromaOffsetL0 as *const _
                as usize
        },
        126usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(ChromaOffsetL0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).delta_luma_weight_l1 as *const _
                as usize
        },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(delta_luma_weight_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).luma_offset_l1 as *const _
                as usize
        },
        171usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(luma_offset_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).delta_chroma_weight_l1
                as *const _ as usize
        },
        186usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(delta_chroma_weight_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).ChromaOffsetL1 as *const _
                as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(ChromaOffsetL1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).five_minus_max_num_merge_cand
                as *const _ as usize
        },
        246usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(five_minus_max_num_merge_cand)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).num_entry_point_offsets
                as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(num_entry_point_offsets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).entry_offset_to_subset_array
                as *const _ as usize
        },
        250usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(entry_offset_to_subset_array)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).slice_data_num_emu_prevn_bytes
                as *const _ as usize
        },
        252usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(slice_data_num_emu_prevn_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVC>())).va_reserved as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVC),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASliceParameterBufferHEVC = _VASliceParameterBufferHEVC;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VASliceParameterBufferHEVCRext {
    pub luma_offset_l0: [i16; 15usize],
    pub ChromaOffsetL0: [[i16; 2usize]; 15usize],
    pub luma_offset_l1: [i16; 15usize],
    pub ChromaOffsetL1: [[i16; 2usize]; 15usize],
    pub slice_ext_flags: _VASliceParameterBufferHEVCRext__bindgen_ty_1,
    pub slice_act_y_qp_offset: i8,
    pub slice_act_cb_qp_offset: i8,
    pub slice_act_cr_qp_offset: i8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VASliceParameterBufferHEVCRext__bindgen_ty_1 {
    pub bits: _VASliceParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VASliceParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VASliceParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VASliceParameterBufferHEVCRext__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn cu_chroma_qp_offset_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cu_chroma_qp_offset_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn use_integer_mv_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_use_integer_mv_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cu_chroma_qp_offset_enabled_flag: u32,
        use_integer_mv_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let cu_chroma_qp_offset_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cu_chroma_qp_offset_enabled_flag) };
            cu_chroma_qp_offset_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let use_integer_mv_flag: u32 = unsafe { ::std::mem::transmute(use_integer_mv_flag) };
            use_integer_mv_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferHEVCRext__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferHEVCRext__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VASliceParameterBufferHEVCRext__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferHEVCRext__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VASliceParameterBufferHEVCRext__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCRext__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCRext__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCRext__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCRext__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferHEVCRext() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferHEVCRext>(),
        188usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferHEVCRext))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferHEVCRext>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASliceParameterBufferHEVCRext))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCRext>())).luma_offset_l0 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCRext),
            "::",
            stringify!(luma_offset_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCRext>())).ChromaOffsetL0 as *const _
                as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCRext),
            "::",
            stringify!(ChromaOffsetL0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCRext>())).luma_offset_l1 as *const _
                as usize
        },
        90usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCRext),
            "::",
            stringify!(luma_offset_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCRext>())).ChromaOffsetL1 as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCRext),
            "::",
            stringify!(ChromaOffsetL1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCRext>())).slice_ext_flags as *const _
                as usize
        },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCRext),
            "::",
            stringify!(slice_ext_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCRext>())).slice_act_y_qp_offset
                as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCRext),
            "::",
            stringify!(slice_act_y_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCRext>())).slice_act_cb_qp_offset
                as *const _ as usize
        },
        185usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCRext),
            "::",
            stringify!(slice_act_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCRext>())).slice_act_cr_qp_offset
                as *const _ as usize
        },
        186usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCRext),
            "::",
            stringify!(slice_act_cr_qp_offset)
        )
    );
}
pub type VASliceParameterBufferHEVCRext = _VASliceParameterBufferHEVCRext;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VASliceParameterBufferHEVCExtension {
    pub base: VASliceParameterBufferHEVC,
    pub rext: VASliceParameterBufferHEVCRext,
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferHEVCExtension() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferHEVCExtension>(),
        452usize,
        concat!(
            "Size of: ",
            stringify!(_VASliceParameterBufferHEVCExtension)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferHEVCExtension>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VASliceParameterBufferHEVCExtension)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCExtension>())).base as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCExtension),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferHEVCExtension>())).rext as *const _
                as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferHEVCExtension),
            "::",
            stringify!(rext)
        )
    );
}
pub type VASliceParameterBufferHEVCExtension = _VASliceParameterBufferHEVCExtension;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAIQMatrixBufferHEVC {
    pub ScalingList4x4: [[u8; 16usize]; 6usize],
    pub ScalingList8x8: [[u8; 64usize]; 6usize],
    pub ScalingList16x16: [[u8; 64usize]; 6usize],
    pub ScalingList32x32: [[u8; 64usize]; 2usize],
    pub ScalingListDC16x16: [u8; 6usize],
    pub ScalingListDC32x32: [u8; 2usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAIQMatrixBufferHEVC() {
    assert_eq!(
        ::std::mem::size_of::<_VAIQMatrixBufferHEVC>(),
        1016usize,
        concat!("Size of: ", stringify!(_VAIQMatrixBufferHEVC))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAIQMatrixBufferHEVC>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAIQMatrixBufferHEVC))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferHEVC>())).ScalingList4x4 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferHEVC),
            "::",
            stringify!(ScalingList4x4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferHEVC>())).ScalingList8x8 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferHEVC),
            "::",
            stringify!(ScalingList8x8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferHEVC>())).ScalingList16x16 as *const _ as usize
        },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferHEVC),
            "::",
            stringify!(ScalingList16x16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferHEVC>())).ScalingList32x32 as *const _ as usize
        },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferHEVC),
            "::",
            stringify!(ScalingList32x32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferHEVC>())).ScalingListDC16x16 as *const _
                as usize
        },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferHEVC),
            "::",
            stringify!(ScalingListDC16x16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferHEVC>())).ScalingListDC32x32 as *const _
                as usize
        },
        998usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferHEVC),
            "::",
            stringify!(ScalingListDC32x32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferHEVC>())).va_reserved as *const _ as usize
        },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferHEVC),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAIQMatrixBufferHEVC = _VAIQMatrixBufferHEVC;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAPictureParameterBufferJPEGBaseline {
    pub picture_width: u16,
    pub picture_height: u16,
    pub components: [_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1; 255usize],
    pub num_components: u8,
    pub color_space: u8,
    pub rotation: u32,
    pub va_reserved: [u32; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferJPEGBaseline__bindgen_ty_1 {
    pub component_id: u8,
    pub h_sampling_factor: u8,
    pub v_sampling_factor: u8,
    pub quantiser_table_selector: u8,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferJPEGBaseline__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1>()))
                .component_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(component_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1>()))
                .h_sampling_factor as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(h_sampling_factor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1>()))
                .v_sampling_factor as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(v_sampling_factor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1>()))
                .quantiser_table_selector as *const _ as usize
        },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(quantiser_table_selector)
        )
    );
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferJPEGBaseline() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferJPEGBaseline>(),
        1060usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferJPEGBaseline>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferJPEGBaseline)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline>())).picture_width
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline),
            "::",
            stringify!(picture_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline>())).picture_height
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline),
            "::",
            stringify!(picture_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline>())).components as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline),
            "::",
            stringify!(components)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline>())).num_components
                as *const _ as usize
        },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline),
            "::",
            stringify!(num_components)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline>())).color_space
                as *const _ as usize
        },
        1025usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline),
            "::",
            stringify!(color_space)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline>())).rotation as *const _
                as usize
        },
        1028usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline),
            "::",
            stringify!(rotation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferJPEGBaseline>())).va_reserved
                as *const _ as usize
        },
        1032usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferJPEGBaseline),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAPictureParameterBufferJPEGBaseline = _VAPictureParameterBufferJPEGBaseline;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAIQMatrixBufferJPEGBaseline {
    pub load_quantiser_table: [u8; 4usize],
    pub quantiser_table: [[u8; 64usize]; 4usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAIQMatrixBufferJPEGBaseline() {
    assert_eq!(
        ::std::mem::size_of::<_VAIQMatrixBufferJPEGBaseline>(),
        276usize,
        concat!("Size of: ", stringify!(_VAIQMatrixBufferJPEGBaseline))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAIQMatrixBufferJPEGBaseline>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAIQMatrixBufferJPEGBaseline))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferJPEGBaseline>())).load_quantiser_table
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferJPEGBaseline),
            "::",
            stringify!(load_quantiser_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferJPEGBaseline>())).quantiser_table as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferJPEGBaseline),
            "::",
            stringify!(quantiser_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferJPEGBaseline>())).va_reserved as *const _
                as usize
        },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferJPEGBaseline),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAIQMatrixBufferJPEGBaseline = _VAIQMatrixBufferJPEGBaseline;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferJPEGBaseline {
    pub slice_data_size: u32,
    pub slice_data_offset: u32,
    pub slice_data_flag: u32,
    pub slice_horizontal_position: u32,
    pub slice_vertical_position: u32,
    pub components: [_VASliceParameterBufferJPEGBaseline__bindgen_ty_1; 4usize],
    pub num_components: u8,
    pub restart_interval: u16,
    pub num_mcus: u32,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferJPEGBaseline__bindgen_ty_1 {
    pub component_selector: u8,
    pub dc_table_selector: u8,
    pub ac_table_selector: u8,
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferJPEGBaseline__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferJPEGBaseline__bindgen_ty_1>(),
        3usize,
        concat!(
            "Size of: ",
            stringify!(_VASliceParameterBufferJPEGBaseline__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferJPEGBaseline__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(_VASliceParameterBufferJPEGBaseline__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline__bindgen_ty_1>()))
                .component_selector as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(component_selector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline__bindgen_ty_1>()))
                .dc_table_selector as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(dc_table_selector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline__bindgen_ty_1>()))
                .ac_table_selector as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline__bindgen_ty_1),
            "::",
            stringify!(ac_table_selector)
        )
    );
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferJPEGBaseline() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferJPEGBaseline>(),
        56usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferJPEGBaseline))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferJPEGBaseline>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VASliceParameterBufferJPEGBaseline)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline>())).slice_data_size
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline),
            "::",
            stringify!(slice_data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline>())).slice_data_offset
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline),
            "::",
            stringify!(slice_data_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline>())).slice_data_flag
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline),
            "::",
            stringify!(slice_data_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline>()))
                .slice_horizontal_position as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline),
            "::",
            stringify!(slice_horizontal_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline>())).slice_vertical_position
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline),
            "::",
            stringify!(slice_vertical_position)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline>())).components as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline),
            "::",
            stringify!(components)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline>())).num_components
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline),
            "::",
            stringify!(num_components)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline>())).restart_interval
                as *const _ as usize
        },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline),
            "::",
            stringify!(restart_interval)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline>())).num_mcus as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline),
            "::",
            stringify!(num_mcus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferJPEGBaseline>())).va_reserved as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferJPEGBaseline),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASliceParameterBufferJPEGBaseline = _VASliceParameterBufferJPEGBaseline;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VABoolCoderContextVPX {
    pub range: u8,
    pub value: u8,
    pub count: u8,
}
#[test]
fn bindgen_test_layout__VABoolCoderContextVPX() {
    assert_eq!(
        ::std::mem::size_of::<_VABoolCoderContextVPX>(),
        3usize,
        concat!("Size of: ", stringify!(_VABoolCoderContextVPX))
    );
    assert_eq!(
        ::std::mem::align_of::<_VABoolCoderContextVPX>(),
        1usize,
        concat!("Alignment of ", stringify!(_VABoolCoderContextVPX))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VABoolCoderContextVPX>())).range as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VABoolCoderContextVPX),
            "::",
            stringify!(range)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VABoolCoderContextVPX>())).value as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(_VABoolCoderContextVPX),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VABoolCoderContextVPX>())).count as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VABoolCoderContextVPX),
            "::",
            stringify!(count)
        )
    );
}
pub type VABoolCoderContextVPX = _VABoolCoderContextVPX;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAPictureParameterBufferVP8 {
    pub frame_width: u32,
    pub frame_height: u32,
    pub last_ref_frame: VASurfaceID,
    pub golden_ref_frame: VASurfaceID,
    pub alt_ref_frame: VASurfaceID,
    pub out_of_loop_frame: VASurfaceID,
    pub pic_fields: _VAPictureParameterBufferVP8__bindgen_ty_1,
    pub mb_segment_tree_probs: [u8; 3usize],
    pub loop_filter_level: [u8; 4usize],
    pub loop_filter_deltas_ref_frame: [i8; 4usize],
    pub loop_filter_deltas_mode: [i8; 4usize],
    pub prob_skip_false: u8,
    pub prob_intra: u8,
    pub prob_last: u8,
    pub prob_gf: u8,
    pub y_mode_probs: [u8; 4usize],
    pub uv_mode_probs: [u8; 3usize],
    pub mv_probs: [[u8; 19usize]; 2usize],
    pub bool_coder_ctx: VABoolCoderContextVPX,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAPictureParameterBufferVP8__bindgen_ty_1 {
    pub bits: _VAPictureParameterBufferVP8__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureParameterBufferVP8__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVP8__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVP8__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVP8__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVP8__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVP8__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAPictureParameterBufferVP8__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn key_frame(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_key_frame(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn version(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_version(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn segmentation_enabled(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_segmentation_enabled(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn update_mb_segmentation_map(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_update_mb_segmentation_map(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn update_segment_feature_data(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_update_segment_feature_data(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn filter_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_filter_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sharpness_level(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_sharpness_level(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn loop_filter_adj_enable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_loop_filter_adj_enable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mode_ref_lf_delta_update(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mode_ref_lf_delta_update(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sign_bias_golden(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign_bias_golden(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sign_bias_alternate(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign_bias_alternate(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mb_no_coeff_skip(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mb_no_coeff_skip(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn loop_filter_disable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_loop_filter_disable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        key_frame: u32,
        version: u32,
        segmentation_enabled: u32,
        update_mb_segmentation_map: u32,
        update_segment_feature_data: u32,
        filter_type: u32,
        sharpness_level: u32,
        loop_filter_adj_enable: u32,
        mode_ref_lf_delta_update: u32,
        sign_bias_golden: u32,
        sign_bias_alternate: u32,
        mb_no_coeff_skip: u32,
        loop_filter_disable: u32,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let key_frame: u32 = unsafe { ::std::mem::transmute(key_frame) };
            key_frame as u64
        });
        __bindgen_bitfield_unit.set(1usize, 3u8, {
            let version: u32 = unsafe { ::std::mem::transmute(version) };
            version as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let segmentation_enabled: u32 = unsafe { ::std::mem::transmute(segmentation_enabled) };
            segmentation_enabled as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let update_mb_segmentation_map: u32 =
                unsafe { ::std::mem::transmute(update_mb_segmentation_map) };
            update_mb_segmentation_map as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let update_segment_feature_data: u32 =
                unsafe { ::std::mem::transmute(update_segment_feature_data) };
            update_segment_feature_data as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let filter_type: u32 = unsafe { ::std::mem::transmute(filter_type) };
            filter_type as u64
        });
        __bindgen_bitfield_unit.set(8usize, 3u8, {
            let sharpness_level: u32 = unsafe { ::std::mem::transmute(sharpness_level) };
            sharpness_level as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let loop_filter_adj_enable: u32 =
                unsafe { ::std::mem::transmute(loop_filter_adj_enable) };
            loop_filter_adj_enable as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let mode_ref_lf_delta_update: u32 =
                unsafe { ::std::mem::transmute(mode_ref_lf_delta_update) };
            mode_ref_lf_delta_update as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let sign_bias_golden: u32 = unsafe { ::std::mem::transmute(sign_bias_golden) };
            sign_bias_golden as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let sign_bias_alternate: u32 = unsafe { ::std::mem::transmute(sign_bias_alternate) };
            sign_bias_alternate as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let mb_no_coeff_skip: u32 = unsafe { ::std::mem::transmute(mb_no_coeff_skip) };
            mb_no_coeff_skip as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let loop_filter_disable: u32 = unsafe { ::std::mem::transmute(loop_filter_disable) };
            loop_filter_disable as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVP8__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVP8__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAPictureParameterBufferVP8__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVP8__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAPictureParameterBufferVP8__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8__bindgen_ty_1>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAPictureParameterBufferVP8() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureParameterBufferVP8>(),
        112usize,
        concat!("Size of: ", stringify!(_VAPictureParameterBufferVP8))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureParameterBufferVP8>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAPictureParameterBufferVP8))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).frame_width as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(frame_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).frame_height as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(frame_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).last_ref_frame as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(last_ref_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).golden_ref_frame as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(golden_ref_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).alt_ref_frame as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(alt_ref_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).out_of_loop_frame as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(out_of_loop_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).pic_fields as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(pic_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).mb_segment_tree_probs
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(mb_segment_tree_probs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).loop_filter_level as *const _
                as usize
        },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(loop_filter_level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).loop_filter_deltas_ref_frame
                as *const _ as usize
        },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(loop_filter_deltas_ref_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).loop_filter_deltas_mode
                as *const _ as usize
        },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(loop_filter_deltas_mode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).prob_skip_false as *const _
                as usize
        },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(prob_skip_false)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).prob_intra as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(prob_intra)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).prob_last as *const _ as usize
        },
        45usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(prob_last)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).prob_gf as *const _ as usize
        },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(prob_gf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).y_mode_probs as *const _
                as usize
        },
        47usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(y_mode_probs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).uv_mode_probs as *const _
                as usize
        },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(uv_mode_probs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).mv_probs as *const _ as usize
        },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(mv_probs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).bool_coder_ctx as *const _
                as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(bool_coder_ctx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAPictureParameterBufferVP8>())).va_reserved as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureParameterBufferVP8),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAPictureParameterBufferVP8 = _VAPictureParameterBufferVP8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferVP8 {
    pub slice_data_size: u32,
    pub slice_data_offset: u32,
    pub slice_data_flag: u32,
    pub macroblock_offset: u32,
    pub num_of_partitions: u8,
    pub partition_size: [u32; 9usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferVP8() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferVP8>(),
        72usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferVP8))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferVP8>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASliceParameterBufferVP8))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP8>())).slice_data_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP8),
            "::",
            stringify!(slice_data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP8>())).slice_data_offset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP8),
            "::",
            stringify!(slice_data_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP8>())).slice_data_flag as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP8),
            "::",
            stringify!(slice_data_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP8>())).macroblock_offset as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP8),
            "::",
            stringify!(macroblock_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP8>())).num_of_partitions as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP8),
            "::",
            stringify!(num_of_partitions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP8>())).partition_size as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP8),
            "::",
            stringify!(partition_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP8>())).va_reserved as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP8),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASliceParameterBufferVP8 = _VASliceParameterBufferVP8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAProbabilityDataBufferVP8 {
    pub dct_coeff_probs: [[[[u8; 11usize]; 3usize]; 8usize]; 4usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAProbabilityDataBufferVP8() {
    assert_eq!(
        ::std::mem::size_of::<_VAProbabilityDataBufferVP8>(),
        1072usize,
        concat!("Size of: ", stringify!(_VAProbabilityDataBufferVP8))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAProbabilityDataBufferVP8>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAProbabilityDataBufferVP8))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProbabilityDataBufferVP8>())).dct_coeff_probs as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProbabilityDataBufferVP8),
            "::",
            stringify!(dct_coeff_probs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAProbabilityDataBufferVP8>())).va_reserved as *const _ as usize
        },
        1056usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAProbabilityDataBufferVP8),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAProbabilityDataBufferVP8 = _VAProbabilityDataBufferVP8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAIQMatrixBufferVP8 {
    pub quantization_index: [[u16; 6usize]; 4usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAIQMatrixBufferVP8() {
    assert_eq!(
        ::std::mem::size_of::<_VAIQMatrixBufferVP8>(),
        64usize,
        concat!("Size of: ", stringify!(_VAIQMatrixBufferVP8))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAIQMatrixBufferVP8>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAIQMatrixBufferVP8))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferVP8>())).quantization_index as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferVP8),
            "::",
            stringify!(quantization_index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAIQMatrixBufferVP8>())).va_reserved as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAIQMatrixBufferVP8),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAIQMatrixBufferVP8 = _VAIQMatrixBufferVP8;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VADecPictureParameterBufferVP9 {
    pub frame_width: u16,
    pub frame_height: u16,
    pub reference_frames: [VASurfaceID; 8usize],
    pub pic_fields: _VADecPictureParameterBufferVP9__bindgen_ty_1,
    pub filter_level: u8,
    pub sharpness_level: u8,
    pub log2_tile_rows: u8,
    pub log2_tile_columns: u8,
    pub frame_header_length_in_bytes: u8,
    pub first_partition_size: u16,
    pub mb_segment_tree_probs: [u8; 7usize],
    pub segment_pred_probs: [u8; 3usize],
    pub profile: u8,
    pub bit_depth: u8,
    pub va_reserved: [u32; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VADecPictureParameterBufferVP9__bindgen_ty_1 {
    pub bits: _VADecPictureParameterBufferVP9__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VADecPictureParameterBufferVP9__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferVP9__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferVP9__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferVP9__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferVP9__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferVP9__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VADecPictureParameterBufferVP9__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn subsampling_x(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_subsampling_x(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn subsampling_y(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_subsampling_y(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn show_frame(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_show_frame(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn error_resilient_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_error_resilient_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_only(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_only(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn allow_high_precision_mv(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_allow_high_precision_mv(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mcomp_filter_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_mcomp_filter_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_parallel_decoding_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_parallel_decoding_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reset_frame_context(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_reset_frame_context(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn refresh_frame_context(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_refresh_frame_context(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_context_idx(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_frame_context_idx(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn segmentation_enabled(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_segmentation_enabled(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn segmentation_temporal_update(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_segmentation_temporal_update(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn segmentation_update_map(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_segmentation_update_map(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn last_ref_frame(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_last_ref_frame(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn last_ref_frame_sign_bias(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_last_ref_frame_sign_bias(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn golden_ref_frame(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_golden_ref_frame(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn golden_ref_frame_sign_bias(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_golden_ref_frame_sign_bias(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn alt_ref_frame(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_alt_ref_frame(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn alt_ref_frame_sign_bias(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_alt_ref_frame_sign_bias(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lossless_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_lossless_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        subsampling_x: u32,
        subsampling_y: u32,
        frame_type: u32,
        show_frame: u32,
        error_resilient_mode: u32,
        intra_only: u32,
        allow_high_precision_mv: u32,
        mcomp_filter_type: u32,
        frame_parallel_decoding_mode: u32,
        reset_frame_context: u32,
        refresh_frame_context: u32,
        frame_context_idx: u32,
        segmentation_enabled: u32,
        segmentation_temporal_update: u32,
        segmentation_update_map: u32,
        last_ref_frame: u32,
        last_ref_frame_sign_bias: u32,
        golden_ref_frame: u32,
        golden_ref_frame_sign_bias: u32,
        alt_ref_frame: u32,
        alt_ref_frame_sign_bias: u32,
        lossless_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let subsampling_x: u32 = unsafe { ::std::mem::transmute(subsampling_x) };
            subsampling_x as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let subsampling_y: u32 = unsafe { ::std::mem::transmute(subsampling_y) };
            subsampling_y as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let frame_type: u32 = unsafe { ::std::mem::transmute(frame_type) };
            frame_type as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let show_frame: u32 = unsafe { ::std::mem::transmute(show_frame) };
            show_frame as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let error_resilient_mode: u32 = unsafe { ::std::mem::transmute(error_resilient_mode) };
            error_resilient_mode as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let intra_only: u32 = unsafe { ::std::mem::transmute(intra_only) };
            intra_only as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let allow_high_precision_mv: u32 =
                unsafe { ::std::mem::transmute(allow_high_precision_mv) };
            allow_high_precision_mv as u64
        });
        __bindgen_bitfield_unit.set(7usize, 3u8, {
            let mcomp_filter_type: u32 = unsafe { ::std::mem::transmute(mcomp_filter_type) };
            mcomp_filter_type as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let frame_parallel_decoding_mode: u32 =
                unsafe { ::std::mem::transmute(frame_parallel_decoding_mode) };
            frame_parallel_decoding_mode as u64
        });
        __bindgen_bitfield_unit.set(11usize, 2u8, {
            let reset_frame_context: u32 = unsafe { ::std::mem::transmute(reset_frame_context) };
            reset_frame_context as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let refresh_frame_context: u32 =
                unsafe { ::std::mem::transmute(refresh_frame_context) };
            refresh_frame_context as u64
        });
        __bindgen_bitfield_unit.set(14usize, 2u8, {
            let frame_context_idx: u32 = unsafe { ::std::mem::transmute(frame_context_idx) };
            frame_context_idx as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let segmentation_enabled: u32 = unsafe { ::std::mem::transmute(segmentation_enabled) };
            segmentation_enabled as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let segmentation_temporal_update: u32 =
                unsafe { ::std::mem::transmute(segmentation_temporal_update) };
            segmentation_temporal_update as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let segmentation_update_map: u32 =
                unsafe { ::std::mem::transmute(segmentation_update_map) };
            segmentation_update_map as u64
        });
        __bindgen_bitfield_unit.set(19usize, 3u8, {
            let last_ref_frame: u32 = unsafe { ::std::mem::transmute(last_ref_frame) };
            last_ref_frame as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let last_ref_frame_sign_bias: u32 =
                unsafe { ::std::mem::transmute(last_ref_frame_sign_bias) };
            last_ref_frame_sign_bias as u64
        });
        __bindgen_bitfield_unit.set(23usize, 3u8, {
            let golden_ref_frame: u32 = unsafe { ::std::mem::transmute(golden_ref_frame) };
            golden_ref_frame as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let golden_ref_frame_sign_bias: u32 =
                unsafe { ::std::mem::transmute(golden_ref_frame_sign_bias) };
            golden_ref_frame_sign_bias as u64
        });
        __bindgen_bitfield_unit.set(27usize, 3u8, {
            let alt_ref_frame: u32 = unsafe { ::std::mem::transmute(alt_ref_frame) };
            alt_ref_frame as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let alt_ref_frame_sign_bias: u32 =
                unsafe { ::std::mem::transmute(alt_ref_frame_sign_bias) };
            alt_ref_frame_sign_bias as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let lossless_flag: u32 = unsafe { ::std::mem::transmute(lossless_flag) };
            lossless_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferVP9__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferVP9__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferVP9__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferVP9__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferVP9__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferVP9() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferVP9>(),
        92usize,
        concat!("Size of: ", stringify!(_VADecPictureParameterBufferVP9))
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferVP9>(),
        4usize,
        concat!("Alignment of ", stringify!(_VADecPictureParameterBufferVP9))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).frame_width as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(frame_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).frame_height as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(frame_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).reference_frames as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(reference_frames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).pic_fields as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(pic_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).filter_level as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(filter_level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).sharpness_level as *const _
                as usize
        },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(sharpness_level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).log2_tile_rows as *const _
                as usize
        },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(log2_tile_rows)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).log2_tile_columns
                as *const _ as usize
        },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(log2_tile_columns)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).frame_header_length_in_bytes
                as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(frame_header_length_in_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).first_partition_size
                as *const _ as usize
        },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(first_partition_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).mb_segment_tree_probs
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(mb_segment_tree_probs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).segment_pred_probs
                as *const _ as usize
        },
        55usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(segment_pred_probs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).profile as *const _ as usize
        },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(profile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).bit_depth as *const _
                as usize
        },
        59usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(bit_depth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferVP9>())).va_reserved as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferVP9),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VADecPictureParameterBufferVP9 = _VADecPictureParameterBufferVP9;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VASegmentParameterVP9 {
    pub segment_flags: _VASegmentParameterVP9__bindgen_ty_1,
    pub filter_level: [[u8; 2usize]; 4usize],
    pub luma_ac_quant_scale: i16,
    pub luma_dc_quant_scale: i16,
    pub chroma_ac_quant_scale: i16,
    pub chroma_dc_quant_scale: i16,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VASegmentParameterVP9__bindgen_ty_1 {
    pub fields: _VASegmentParameterVP9__bindgen_ty_1__bindgen_ty_1,
    pub value: u16,
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct _VASegmentParameterVP9__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout__VASegmentParameterVP9__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VASegmentParameterVP9__bindgen_ty_1__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(_VASegmentParameterVP9__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VASegmentParameterVP9__bindgen_ty_1__bindgen_ty_1>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(_VASegmentParameterVP9__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VASegmentParameterVP9__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn segment_reference_enabled(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_segment_reference_enabled(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn segment_reference(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_segment_reference(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn segment_reference_skipped(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_segment_reference_skipped(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        segment_reference_enabled: u16,
        segment_reference: u16,
        segment_reference_skipped: u16,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let segment_reference_enabled: u16 =
                unsafe { ::std::mem::transmute(segment_reference_enabled) };
            segment_reference_enabled as u64
        });
        __bindgen_bitfield_unit.set(1usize, 2u8, {
            let segment_reference: u16 = unsafe { ::std::mem::transmute(segment_reference) };
            segment_reference as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let segment_reference_skipped: u16 =
                unsafe { ::std::mem::transmute(segment_reference_skipped) };
            segment_reference_skipped as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VASegmentParameterVP9__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VASegmentParameterVP9__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(_VASegmentParameterVP9__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VASegmentParameterVP9__bindgen_ty_1>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(_VASegmentParameterVP9__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentParameterVP9__bindgen_ty_1>())).fields as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentParameterVP9__bindgen_ty_1),
            "::",
            stringify!(fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentParameterVP9__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentParameterVP9__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VASegmentParameterVP9() {
    assert_eq!(
        ::std::mem::size_of::<_VASegmentParameterVP9>(),
        36usize,
        concat!("Size of: ", stringify!(_VASegmentParameterVP9))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASegmentParameterVP9>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASegmentParameterVP9))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentParameterVP9>())).segment_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentParameterVP9),
            "::",
            stringify!(segment_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentParameterVP9>())).filter_level as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentParameterVP9),
            "::",
            stringify!(filter_level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentParameterVP9>())).luma_ac_quant_scale as *const _
                as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentParameterVP9),
            "::",
            stringify!(luma_ac_quant_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentParameterVP9>())).luma_dc_quant_scale as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentParameterVP9),
            "::",
            stringify!(luma_dc_quant_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentParameterVP9>())).chroma_ac_quant_scale as *const _
                as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentParameterVP9),
            "::",
            stringify!(chroma_ac_quant_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentParameterVP9>())).chroma_dc_quant_scale as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentParameterVP9),
            "::",
            stringify!(chroma_dc_quant_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentParameterVP9>())).va_reserved as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentParameterVP9),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASegmentParameterVP9 = _VASegmentParameterVP9;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VASliceParameterBufferVP9 {
    pub slice_data_size: u32,
    pub slice_data_offset: u32,
    pub slice_data_flag: u32,
    pub seg_param: [VASegmentParameterVP9; 8usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferVP9() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferVP9>(),
        316usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferVP9))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferVP9>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASliceParameterBufferVP9))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP9>())).slice_data_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP9),
            "::",
            stringify!(slice_data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP9>())).slice_data_offset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP9),
            "::",
            stringify!(slice_data_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP9>())).slice_data_flag as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP9),
            "::",
            stringify!(slice_data_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP9>())).seg_param as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP9),
            "::",
            stringify!(seg_param)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferVP9>())).va_reserved as *const _ as usize
        },
        300usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferVP9),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASliceParameterBufferVP9 = _VASliceParameterBufferVP9;
#[repr(C)]
#[derive(Copy, Clone)]
pub union VAConfigAttribValDecAV1Features {
    pub bits: VAConfigAttribValDecAV1Features__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct VAConfigAttribValDecAV1Features__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_VAConfigAttribValDecAV1Features__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<VAConfigAttribValDecAV1Features__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(VAConfigAttribValDecAV1Features__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VAConfigAttribValDecAV1Features__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(VAConfigAttribValDecAV1Features__bindgen_ty_1)
        )
    );
}
impl VAConfigAttribValDecAV1Features__bindgen_ty_1 {
    #[inline]
    pub fn lst_support(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_lst_support(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(lst_support: u32, reserved: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let lst_support: u32 = unsafe { ::std::mem::transmute(lst_support) };
            lst_support as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_VAConfigAttribValDecAV1Features() {
    assert_eq!(
        ::std::mem::size_of::<VAConfigAttribValDecAV1Features>(),
        4usize,
        concat!("Size of: ", stringify!(VAConfigAttribValDecAV1Features))
    );
    assert_eq!(
        ::std::mem::align_of::<VAConfigAttribValDecAV1Features>(),
        4usize,
        concat!("Alignment of ", stringify!(VAConfigAttribValDecAV1Features))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VAConfigAttribValDecAV1Features>())).bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VAConfigAttribValDecAV1Features),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VAConfigAttribValDecAV1Features>())).value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VAConfigAttribValDecAV1Features),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VASegmentationStructAV1 {
    pub segment_info_fields: _VASegmentationStructAV1__bindgen_ty_1,
    pub feature_data: [[i16; 8usize]; 8usize],
    pub feature_mask: [u8; 8usize],
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VASegmentationStructAV1__bindgen_ty_1 {
    pub bits: _VASegmentationStructAV1__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VASegmentationStructAV1__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VASegmentationStructAV1__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VASegmentationStructAV1__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VASegmentationStructAV1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VASegmentationStructAV1__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VASegmentationStructAV1__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VASegmentationStructAV1__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn enabled(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enabled(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn update_map(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_update_map(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn temporal_update(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_temporal_update(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn update_data(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_update_data(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        enabled: u32,
        update_map: u32,
        temporal_update: u32,
        update_data: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let enabled: u32 = unsafe { ::std::mem::transmute(enabled) };
            enabled as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let update_map: u32 = unsafe { ::std::mem::transmute(update_map) };
            update_map as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let temporal_update: u32 = unsafe { ::std::mem::transmute(temporal_update) };
            temporal_update as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let update_data: u32 = unsafe { ::std::mem::transmute(update_data) };
            update_data as u64
        });
        __bindgen_bitfield_unit.set(4usize, 28u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VASegmentationStructAV1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VASegmentationStructAV1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VASegmentationStructAV1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VASegmentationStructAV1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VASegmentationStructAV1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentationStructAV1__bindgen_ty_1>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentationStructAV1__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentationStructAV1__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentationStructAV1__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VASegmentationStructAV1() {
    assert_eq!(
        ::std::mem::size_of::<_VASegmentationStructAV1>(),
        156usize,
        concat!("Size of: ", stringify!(_VASegmentationStructAV1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASegmentationStructAV1>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASegmentationStructAV1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentationStructAV1>())).segment_info_fields as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentationStructAV1),
            "::",
            stringify!(segment_info_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentationStructAV1>())).feature_data as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentationStructAV1),
            "::",
            stringify!(feature_data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentationStructAV1>())).feature_mask as *const _ as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentationStructAV1),
            "::",
            stringify!(feature_mask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASegmentationStructAV1>())).va_reserved as *const _ as usize
        },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASegmentationStructAV1),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASegmentationStructAV1 = _VASegmentationStructAV1;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAFilmGrainStructAV1 {
    pub film_grain_info_fields: _VAFilmGrainStructAV1__bindgen_ty_1,
    pub grain_seed: u16,
    pub num_y_points: u8,
    pub point_y_value: [u8; 14usize],
    pub point_y_scaling: [u8; 14usize],
    pub num_cb_points: u8,
    pub point_cb_value: [u8; 10usize],
    pub point_cb_scaling: [u8; 10usize],
    pub num_cr_points: u8,
    pub point_cr_value: [u8; 10usize],
    pub point_cr_scaling: [u8; 10usize],
    pub ar_coeffs_y: [i8; 24usize],
    pub ar_coeffs_cb: [i8; 25usize],
    pub ar_coeffs_cr: [i8; 25usize],
    pub cb_mult: u8,
    pub cb_luma_mult: u8,
    pub cb_offset: u16,
    pub cr_mult: u8,
    pub cr_luma_mult: u8,
    pub cr_offset: u16,
    pub va_reserved: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAFilmGrainStructAV1__bindgen_ty_1 {
    pub bits: _VAFilmGrainStructAV1__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAFilmGrainStructAV1__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAFilmGrainStructAV1__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAFilmGrainStructAV1__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAFilmGrainStructAV1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAFilmGrainStructAV1__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAFilmGrainStructAV1__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAFilmGrainStructAV1__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn apply_grain(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_apply_grain(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_scaling_from_luma(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_scaling_from_luma(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn grain_scaling_minus_8(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_grain_scaling_minus_8(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn ar_coeff_lag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_ar_coeff_lag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn ar_coeff_shift_minus_6(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_ar_coeff_shift_minus_6(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn grain_scale_shift(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_grain_scale_shift(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn overlap_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overlap_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn clip_to_restricted_range(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_clip_to_restricted_range(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        apply_grain: u32,
        chroma_scaling_from_luma: u32,
        grain_scaling_minus_8: u32,
        ar_coeff_lag: u32,
        ar_coeff_shift_minus_6: u32,
        grain_scale_shift: u32,
        overlap_flag: u32,
        clip_to_restricted_range: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let apply_grain: u32 = unsafe { ::std::mem::transmute(apply_grain) };
            apply_grain as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let chroma_scaling_from_luma: u32 =
                unsafe { ::std::mem::transmute(chroma_scaling_from_luma) };
            chroma_scaling_from_luma as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let grain_scaling_minus_8: u32 =
                unsafe { ::std::mem::transmute(grain_scaling_minus_8) };
            grain_scaling_minus_8 as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let ar_coeff_lag: u32 = unsafe { ::std::mem::transmute(ar_coeff_lag) };
            ar_coeff_lag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 2u8, {
            let ar_coeff_shift_minus_6: u32 =
                unsafe { ::std::mem::transmute(ar_coeff_shift_minus_6) };
            ar_coeff_shift_minus_6 as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let grain_scale_shift: u32 = unsafe { ::std::mem::transmute(grain_scale_shift) };
            grain_scale_shift as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let overlap_flag: u32 = unsafe { ::std::mem::transmute(overlap_flag) };
            overlap_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let clip_to_restricted_range: u32 =
                unsafe { ::std::mem::transmute(clip_to_restricted_range) };
            clip_to_restricted_range as u64
        });
        __bindgen_bitfield_unit.set(12usize, 20u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAFilmGrainStructAV1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAFilmGrainStructAV1__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(_VAFilmGrainStructAV1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAFilmGrainStructAV1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAFilmGrainStructAV1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1__bindgen_ty_1>())).bits as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAFilmGrainStructAV1() {
    assert_eq!(
        ::std::mem::size_of::<_VAFilmGrainStructAV1>(),
        176usize,
        concat!("Size of: ", stringify!(_VAFilmGrainStructAV1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAFilmGrainStructAV1>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAFilmGrainStructAV1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).film_grain_info_fields as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(film_grain_info_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).grain_seed as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(grain_seed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).num_y_points as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(num_y_points)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).point_y_value as *const _ as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(point_y_value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).point_y_scaling as *const _ as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(point_y_scaling)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).num_cb_points as *const _ as usize
        },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(num_cb_points)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).point_cb_value as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(point_cb_value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).point_cb_scaling as *const _ as usize
        },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(point_cb_scaling)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).num_cr_points as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(num_cr_points)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).point_cr_value as *const _ as usize
        },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(point_cr_value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).point_cr_scaling as *const _ as usize
        },
        67usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(point_cr_scaling)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).ar_coeffs_y as *const _ as usize
        },
        77usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(ar_coeffs_y)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).ar_coeffs_cb as *const _ as usize
        },
        101usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(ar_coeffs_cb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).ar_coeffs_cr as *const _ as usize
        },
        126usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(ar_coeffs_cr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).cb_mult as *const _ as usize },
        151usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(cb_mult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).cb_luma_mult as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(cb_luma_mult)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).cb_offset as *const _ as usize },
        154usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(cb_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).cr_mult as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(cr_mult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).cr_luma_mult as *const _ as usize
        },
        157usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(cr_luma_mult)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).cr_offset as *const _ as usize },
        158usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(cr_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAFilmGrainStructAV1>())).va_reserved as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAFilmGrainStructAV1),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAFilmGrainStructAV1 = _VAFilmGrainStructAV1;
pub const VAAV1TransformationType_VAAV1TransformationIdentity: VAAV1TransformationType = 0;
pub const VAAV1TransformationType_VAAV1TransformationTranslation: VAAV1TransformationType = 1;
pub const VAAV1TransformationType_VAAV1TransformationRotzoom: VAAV1TransformationType = 2;
pub const VAAV1TransformationType_VAAV1TransformationAffine: VAAV1TransformationType = 3;
pub const VAAV1TransformationType_VAAV1TransformationCount: VAAV1TransformationType = 4;
pub type VAAV1TransformationType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAWarpedMotionParamsAV1 {
    pub wmtype: VAAV1TransformationType,
    pub wmmat: [i32; 8usize],
    pub invalid: u8,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAWarpedMotionParamsAV1() {
    assert_eq!(
        ::std::mem::size_of::<_VAWarpedMotionParamsAV1>(),
        56usize,
        concat!("Size of: ", stringify!(_VAWarpedMotionParamsAV1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAWarpedMotionParamsAV1>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAWarpedMotionParamsAV1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAWarpedMotionParamsAV1>())).wmtype as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAWarpedMotionParamsAV1),
            "::",
            stringify!(wmtype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAWarpedMotionParamsAV1>())).wmmat as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAWarpedMotionParamsAV1),
            "::",
            stringify!(wmmat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAWarpedMotionParamsAV1>())).invalid as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAWarpedMotionParamsAV1),
            "::",
            stringify!(invalid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAWarpedMotionParamsAV1>())).va_reserved as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAWarpedMotionParamsAV1),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAWarpedMotionParamsAV1 = _VAWarpedMotionParamsAV1;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VADecPictureParameterBufferAV1 {
    pub profile: u8,
    pub order_hint_bits_minus_1: u8,
    pub bit_depth_idx: u8,
    pub matrix_coefficients: u8,
    pub seq_info_fields: _VADecPictureParameterBufferAV1__bindgen_ty_1,
    pub current_frame: VASurfaceID,
    pub current_display_picture: VASurfaceID,
    pub anchor_frames_num: u8,
    pub anchor_frames_list: *mut VASurfaceID,
    pub frame_width_minus1: u16,
    pub frame_height_minus1: u16,
    pub output_frame_width_in_tiles_minus_1: u16,
    pub output_frame_height_in_tiles_minus_1: u16,
    pub ref_frame_map: [VASurfaceID; 8usize],
    pub ref_frame_idx: [u8; 7usize],
    pub primary_ref_frame: u8,
    pub order_hint: u8,
    pub seg_info: VASegmentationStructAV1,
    pub film_grain_info: VAFilmGrainStructAV1,
    pub tile_cols: u8,
    pub tile_rows: u8,
    pub width_in_sbs_minus_1: [u16; 63usize],
    pub height_in_sbs_minus_1: [u16; 63usize],
    pub tile_count_minus_1: u16,
    pub context_update_tile_id: u16,
    pub pic_info_fields: _VADecPictureParameterBufferAV1__bindgen_ty_2,
    pub superres_scale_denominator: u8,
    pub interp_filter: u8,
    pub filter_level: [u8; 2usize],
    pub filter_level_u: u8,
    pub filter_level_v: u8,
    pub loop_filter_info_fields: _VADecPictureParameterBufferAV1__bindgen_ty_3,
    pub ref_deltas: [i8; 8usize],
    pub mode_deltas: [i8; 2usize],
    pub base_qindex: u8,
    pub y_dc_delta_q: i8,
    pub u_dc_delta_q: i8,
    pub u_ac_delta_q: i8,
    pub v_dc_delta_q: i8,
    pub v_ac_delta_q: i8,
    pub qmatrix_fields: _VADecPictureParameterBufferAV1__bindgen_ty_4,
    pub mode_control_fields: _VADecPictureParameterBufferAV1__bindgen_ty_5,
    pub cdef_damping_minus_3: u8,
    pub cdef_bits: u8,
    pub cdef_y_strengths: [u8; 8usize],
    pub cdef_uv_strengths: [u8; 8usize],
    pub loop_restoration_fields: _VADecPictureParameterBufferAV1__bindgen_ty_6,
    pub wm: [VAWarpedMotionParamsAV1; 7usize],
    pub va_reserved: [u32; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VADecPictureParameterBufferAV1__bindgen_ty_1 {
    pub fields: _VADecPictureParameterBufferAV1__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VADecPictureParameterBufferAV1__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VADecPictureParameterBufferAV1__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn still_picture(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_still_picture(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn use_128x128_superblock(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_use_128x128_superblock(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_filter_intra(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_filter_intra(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_intra_edge_filter(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_intra_edge_filter(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_interintra_compound(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_interintra_compound(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_masked_compound(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_masked_compound(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_dual_filter(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_dual_filter(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_order_hint(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_order_hint(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_jnt_comp(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_jnt_comp(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_cdef(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_cdef(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mono_chrome(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mono_chrome(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn color_range(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_color_range(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn subsampling_x(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_subsampling_x(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn subsampling_y(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_subsampling_y(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_sample_position(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_sample_position(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn film_grain_params_present(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_film_grain_params_present(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        still_picture: u32,
        use_128x128_superblock: u32,
        enable_filter_intra: u32,
        enable_intra_edge_filter: u32,
        enable_interintra_compound: u32,
        enable_masked_compound: u32,
        enable_dual_filter: u32,
        enable_order_hint: u32,
        enable_jnt_comp: u32,
        enable_cdef: u32,
        mono_chrome: u32,
        color_range: u32,
        subsampling_x: u32,
        subsampling_y: u32,
        chroma_sample_position: u32,
        film_grain_params_present: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let still_picture: u32 = unsafe { ::std::mem::transmute(still_picture) };
            still_picture as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let use_128x128_superblock: u32 =
                unsafe { ::std::mem::transmute(use_128x128_superblock) };
            use_128x128_superblock as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let enable_filter_intra: u32 = unsafe { ::std::mem::transmute(enable_filter_intra) };
            enable_filter_intra as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let enable_intra_edge_filter: u32 =
                unsafe { ::std::mem::transmute(enable_intra_edge_filter) };
            enable_intra_edge_filter as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let enable_interintra_compound: u32 =
                unsafe { ::std::mem::transmute(enable_interintra_compound) };
            enable_interintra_compound as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let enable_masked_compound: u32 =
                unsafe { ::std::mem::transmute(enable_masked_compound) };
            enable_masked_compound as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let enable_dual_filter: u32 = unsafe { ::std::mem::transmute(enable_dual_filter) };
            enable_dual_filter as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let enable_order_hint: u32 = unsafe { ::std::mem::transmute(enable_order_hint) };
            enable_order_hint as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let enable_jnt_comp: u32 = unsafe { ::std::mem::transmute(enable_jnt_comp) };
            enable_jnt_comp as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let enable_cdef: u32 = unsafe { ::std::mem::transmute(enable_cdef) };
            enable_cdef as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let mono_chrome: u32 = unsafe { ::std::mem::transmute(mono_chrome) };
            mono_chrome as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let color_range: u32 = unsafe { ::std::mem::transmute(color_range) };
            color_range as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let subsampling_x: u32 = unsafe { ::std::mem::transmute(subsampling_x) };
            subsampling_x as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let subsampling_y: u32 = unsafe { ::std::mem::transmute(subsampling_y) };
            subsampling_y as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let chroma_sample_position: u32 =
                unsafe { ::std::mem::transmute(chroma_sample_position) };
            chroma_sample_position as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let film_grain_params_present: u32 =
                unsafe { ::std::mem::transmute(film_grain_params_present) };
            film_grain_params_present as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_1>())).fields
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_1),
            "::",
            stringify!(fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VADecPictureParameterBufferAV1__bindgen_ty_2 {
    pub bits: _VADecPictureParameterBufferAV1__bindgen_ty_2__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VADecPictureParameterBufferAV1__bindgen_ty_2__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_2__bindgen_ty_1)
        )
    );
}
impl _VADecPictureParameterBufferAV1__bindgen_ty_2__bindgen_ty_1 {
    #[inline]
    pub fn frame_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_frame_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn show_frame(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_show_frame(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn showable_frame(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_showable_frame(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn error_resilient_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_error_resilient_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn disable_cdf_update(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_disable_cdf_update(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn allow_screen_content_tools(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_allow_screen_content_tools(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn force_integer_mv(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_force_integer_mv(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn allow_intrabc(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_allow_intrabc(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn use_superres(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_use_superres(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn allow_high_precision_mv(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_allow_high_precision_mv(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_motion_mode_switchable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_motion_mode_switchable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn use_ref_frame_mvs(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_use_ref_frame_mvs(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn disable_frame_end_update_cdf(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_disable_frame_end_update_cdf(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uniform_tile_spacing_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_uniform_tile_spacing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn allow_warped_motion(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_allow_warped_motion(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn large_scale_tile(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_large_scale_tile(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        frame_type: u32,
        show_frame: u32,
        showable_frame: u32,
        error_resilient_mode: u32,
        disable_cdf_update: u32,
        allow_screen_content_tools: u32,
        force_integer_mv: u32,
        allow_intrabc: u32,
        use_superres: u32,
        allow_high_precision_mv: u32,
        is_motion_mode_switchable: u32,
        use_ref_frame_mvs: u32,
        disable_frame_end_update_cdf: u32,
        uniform_tile_spacing_flag: u32,
        allow_warped_motion: u32,
        large_scale_tile: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let frame_type: u32 = unsafe { ::std::mem::transmute(frame_type) };
            frame_type as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let show_frame: u32 = unsafe { ::std::mem::transmute(show_frame) };
            show_frame as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let showable_frame: u32 = unsafe { ::std::mem::transmute(showable_frame) };
            showable_frame as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let error_resilient_mode: u32 = unsafe { ::std::mem::transmute(error_resilient_mode) };
            error_resilient_mode as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let disable_cdf_update: u32 = unsafe { ::std::mem::transmute(disable_cdf_update) };
            disable_cdf_update as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let allow_screen_content_tools: u32 =
                unsafe { ::std::mem::transmute(allow_screen_content_tools) };
            allow_screen_content_tools as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let force_integer_mv: u32 = unsafe { ::std::mem::transmute(force_integer_mv) };
            force_integer_mv as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let allow_intrabc: u32 = unsafe { ::std::mem::transmute(allow_intrabc) };
            allow_intrabc as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let use_superres: u32 = unsafe { ::std::mem::transmute(use_superres) };
            use_superres as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let allow_high_precision_mv: u32 =
                unsafe { ::std::mem::transmute(allow_high_precision_mv) };
            allow_high_precision_mv as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let is_motion_mode_switchable: u32 =
                unsafe { ::std::mem::transmute(is_motion_mode_switchable) };
            is_motion_mode_switchable as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let use_ref_frame_mvs: u32 = unsafe { ::std::mem::transmute(use_ref_frame_mvs) };
            use_ref_frame_mvs as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let disable_frame_end_update_cdf: u32 =
                unsafe { ::std::mem::transmute(disable_frame_end_update_cdf) };
            disable_frame_end_update_cdf as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let uniform_tile_spacing_flag: u32 =
                unsafe { ::std::mem::transmute(uniform_tile_spacing_flag) };
            uniform_tile_spacing_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let allow_warped_motion: u32 = unsafe { ::std::mem::transmute(allow_warped_motion) };
            allow_warped_motion as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let large_scale_tile: u32 = unsafe { ::std::mem::transmute(large_scale_tile) };
            large_scale_tile as u64
        });
        __bindgen_bitfield_unit.set(17usize, 15u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_2>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_2),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_2>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_2),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VADecPictureParameterBufferAV1__bindgen_ty_3 {
    pub bits: _VADecPictureParameterBufferAV1__bindgen_ty_3__bindgen_ty_1,
    pub value: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct _VADecPictureParameterBufferAV1__bindgen_ty_3__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_3__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_3__bindgen_ty_1>(),
        1usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_3__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_3__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_3__bindgen_ty_1)
        )
    );
}
impl _VADecPictureParameterBufferAV1__bindgen_ty_3__bindgen_ty_1 {
    #[inline]
    pub fn sharpness_level(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_sharpness_level(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn mode_ref_delta_enabled(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_mode_ref_delta_enabled(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mode_ref_delta_update(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_mode_ref_delta_update(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sharpness_level: u8,
        mode_ref_delta_enabled: u8,
        mode_ref_delta_update: u8,
        reserved: u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let sharpness_level: u8 = unsafe { ::std::mem::transmute(sharpness_level) };
            sharpness_level as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let mode_ref_delta_enabled: u8 =
                unsafe { ::std::mem::transmute(mode_ref_delta_enabled) };
            mode_ref_delta_enabled as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let mode_ref_delta_update: u8 = unsafe { ::std::mem::transmute(mode_ref_delta_update) };
            mode_ref_delta_update as u64
        });
        __bindgen_bitfield_unit.set(5usize, 3u8, {
            let reserved: u8 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_3>(),
        1usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_3>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_3>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_3),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_3>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_3),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VADecPictureParameterBufferAV1__bindgen_ty_4 {
    pub bits: _VADecPictureParameterBufferAV1__bindgen_ty_4__bindgen_ty_1,
    pub value: u16,
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct _VADecPictureParameterBufferAV1__bindgen_ty_4__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_4__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_4__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_4__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_4__bindgen_ty_1>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_4__bindgen_ty_1)
        )
    );
}
impl _VADecPictureParameterBufferAV1__bindgen_ty_4__bindgen_ty_1 {
    #[inline]
    pub fn using_qmatrix(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_using_qmatrix(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn qm_y(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 4u8) as u16) }
    }
    #[inline]
    pub fn set_qm_y(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn qm_u(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 4u8) as u16) }
    }
    #[inline]
    pub fn set_qm_u(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn qm_v(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 4u8) as u16) }
    }
    #[inline]
    pub fn set_qm_v(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        using_qmatrix: u16,
        qm_y: u16,
        qm_u: u16,
        qm_v: u16,
        reserved: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let using_qmatrix: u16 = unsafe { ::std::mem::transmute(using_qmatrix) };
            using_qmatrix as u64
        });
        __bindgen_bitfield_unit.set(1usize, 4u8, {
            let qm_y: u16 = unsafe { ::std::mem::transmute(qm_y) };
            qm_y as u64
        });
        __bindgen_bitfield_unit.set(5usize, 4u8, {
            let qm_u: u16 = unsafe { ::std::mem::transmute(qm_u) };
            qm_u as u64
        });
        __bindgen_bitfield_unit.set(9usize, 4u8, {
            let qm_v: u16 = unsafe { ::std::mem::transmute(qm_v) };
            qm_v as u64
        });
        __bindgen_bitfield_unit.set(13usize, 3u8, {
            let reserved: u16 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_4>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_4)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_4>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_4>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_4),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_4>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_4),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VADecPictureParameterBufferAV1__bindgen_ty_5 {
    pub bits: _VADecPictureParameterBufferAV1__bindgen_ty_5__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VADecPictureParameterBufferAV1__bindgen_ty_5__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_5__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_5__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_5__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_5__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_5__bindgen_ty_1)
        )
    );
}
impl _VADecPictureParameterBufferAV1__bindgen_ty_5__bindgen_ty_1 {
    #[inline]
    pub fn delta_q_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_q_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_delta_q_res(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_log2_delta_q_res(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn delta_lf_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_lf_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_delta_lf_res(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_log2_delta_lf_res(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn delta_lf_multi(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_lf_multi(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tx_mode(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_tx_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn reference_select(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reference_select(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reduced_tx_set_used(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reduced_tx_set_used(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn skip_mode_present(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_skip_mode_present(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        delta_q_present_flag: u32,
        log2_delta_q_res: u32,
        delta_lf_present_flag: u32,
        log2_delta_lf_res: u32,
        delta_lf_multi: u32,
        tx_mode: u32,
        reference_select: u32,
        reduced_tx_set_used: u32,
        skip_mode_present: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let delta_q_present_flag: u32 = unsafe { ::std::mem::transmute(delta_q_present_flag) };
            delta_q_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 2u8, {
            let log2_delta_q_res: u32 = unsafe { ::std::mem::transmute(log2_delta_q_res) };
            log2_delta_q_res as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let delta_lf_present_flag: u32 =
                unsafe { ::std::mem::transmute(delta_lf_present_flag) };
            delta_lf_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let log2_delta_lf_res: u32 = unsafe { ::std::mem::transmute(log2_delta_lf_res) };
            log2_delta_lf_res as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let delta_lf_multi: u32 = unsafe { ::std::mem::transmute(delta_lf_multi) };
            delta_lf_multi as u64
        });
        __bindgen_bitfield_unit.set(7usize, 2u8, {
            let tx_mode: u32 = unsafe { ::std::mem::transmute(tx_mode) };
            tx_mode as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let reference_select: u32 = unsafe { ::std::mem::transmute(reference_select) };
            reference_select as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let reduced_tx_set_used: u32 = unsafe { ::std::mem::transmute(reduced_tx_set_used) };
            reduced_tx_set_used as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let skip_mode_present: u32 = unsafe { ::std::mem::transmute(skip_mode_present) };
            skip_mode_present as u64
        });
        __bindgen_bitfield_unit.set(12usize, 20u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_5() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_5>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_5)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_5>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_5>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_5),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_5>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_5),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VADecPictureParameterBufferAV1__bindgen_ty_6 {
    pub bits: _VADecPictureParameterBufferAV1__bindgen_ty_6__bindgen_ty_1,
    pub value: u16,
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct _VADecPictureParameterBufferAV1__bindgen_ty_6__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_6__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_6__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_6__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_6__bindgen_ty_1>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_6__bindgen_ty_1)
        )
    );
}
impl _VADecPictureParameterBufferAV1__bindgen_ty_6__bindgen_ty_1 {
    #[inline]
    pub fn yframe_restoration_type(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_yframe_restoration_type(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn cbframe_restoration_type(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_cbframe_restoration_type(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn crframe_restoration_type(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_crframe_restoration_type(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn lr_unit_shift(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_lr_unit_shift(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn lr_uv_shift(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_lr_uv_shift(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 7u8) as u16) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        yframe_restoration_type: u16,
        cbframe_restoration_type: u16,
        crframe_restoration_type: u16,
        lr_unit_shift: u16,
        lr_uv_shift: u16,
        reserved: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let yframe_restoration_type: u16 =
                unsafe { ::std::mem::transmute(yframe_restoration_type) };
            yframe_restoration_type as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let cbframe_restoration_type: u16 =
                unsafe { ::std::mem::transmute(cbframe_restoration_type) };
            cbframe_restoration_type as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let crframe_restoration_type: u16 =
                unsafe { ::std::mem::transmute(crframe_restoration_type) };
            crframe_restoration_type as u64
        });
        __bindgen_bitfield_unit.set(6usize, 2u8, {
            let lr_unit_shift: u16 = unsafe { ::std::mem::transmute(lr_unit_shift) };
            lr_unit_shift as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let lr_uv_shift: u16 = unsafe { ::std::mem::transmute(lr_uv_shift) };
            lr_uv_shift as u64
        });
        __bindgen_bitfield_unit.set(9usize, 7u8, {
            let reserved: u16 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1__bindgen_ty_6() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1__bindgen_ty_6>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_6)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1__bindgen_ty_6>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_6>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_6),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1__bindgen_ty_6>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1__bindgen_ty_6),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VADecPictureParameterBufferAV1() {
    assert_eq!(
        ::std::mem::size_of::<_VADecPictureParameterBufferAV1>(),
        1160usize,
        concat!("Size of: ", stringify!(_VADecPictureParameterBufferAV1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VADecPictureParameterBufferAV1>(),
        8usize,
        concat!("Alignment of ", stringify!(_VADecPictureParameterBufferAV1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).profile as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(profile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).order_hint_bits_minus_1
                as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(order_hint_bits_minus_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).bit_depth_idx as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(bit_depth_idx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).matrix_coefficients
                as *const _ as usize
        },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(matrix_coefficients)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).seq_info_fields as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(seq_info_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).current_frame as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(current_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).current_display_picture
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(current_display_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).anchor_frames_num
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(anchor_frames_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).anchor_frames_list
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(anchor_frames_list)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).frame_width_minus1
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(frame_width_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).frame_height_minus1
                as *const _ as usize
        },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(frame_height_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>()))
                .output_frame_width_in_tiles_minus_1 as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(output_frame_width_in_tiles_minus_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>()))
                .output_frame_height_in_tiles_minus_1 as *const _ as usize
        },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(output_frame_height_in_tiles_minus_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).ref_frame_map as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(ref_frame_map)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).ref_frame_idx as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(ref_frame_idx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).primary_ref_frame
                as *const _ as usize
        },
        79usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(primary_ref_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).order_hint as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(order_hint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).seg_info as *const _
                as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(seg_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).film_grain_info as *const _
                as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(film_grain_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).tile_cols as *const _
                as usize
        },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(tile_cols)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).tile_rows as *const _
                as usize
        },
        417usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(tile_rows)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).width_in_sbs_minus_1
                as *const _ as usize
        },
        418usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(width_in_sbs_minus_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).height_in_sbs_minus_1
                as *const _ as usize
        },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(height_in_sbs_minus_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).tile_count_minus_1
                as *const _ as usize
        },
        670usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(tile_count_minus_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).context_update_tile_id
                as *const _ as usize
        },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(context_update_tile_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).pic_info_fields as *const _
                as usize
        },
        676usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(pic_info_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).superres_scale_denominator
                as *const _ as usize
        },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(superres_scale_denominator)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).interp_filter as *const _
                as usize
        },
        681usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(interp_filter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).filter_level as *const _
                as usize
        },
        682usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(filter_level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).filter_level_u as *const _
                as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(filter_level_u)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).filter_level_v as *const _
                as usize
        },
        685usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(filter_level_v)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).loop_filter_info_fields
                as *const _ as usize
        },
        686usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(loop_filter_info_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).ref_deltas as *const _
                as usize
        },
        687usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(ref_deltas)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).mode_deltas as *const _
                as usize
        },
        695usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(mode_deltas)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).base_qindex as *const _
                as usize
        },
        697usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(base_qindex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).y_dc_delta_q as *const _
                as usize
        },
        698usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(y_dc_delta_q)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).u_dc_delta_q as *const _
                as usize
        },
        699usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(u_dc_delta_q)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).u_ac_delta_q as *const _
                as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(u_ac_delta_q)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).v_dc_delta_q as *const _
                as usize
        },
        701usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(v_dc_delta_q)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).v_ac_delta_q as *const _
                as usize
        },
        702usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(v_ac_delta_q)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).qmatrix_fields as *const _
                as usize
        },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(qmatrix_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).mode_control_fields
                as *const _ as usize
        },
        708usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(mode_control_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).cdef_damping_minus_3
                as *const _ as usize
        },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(cdef_damping_minus_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).cdef_bits as *const _
                as usize
        },
        713usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(cdef_bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).cdef_y_strengths as *const _
                as usize
        },
        714usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(cdef_y_strengths)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).cdef_uv_strengths
                as *const _ as usize
        },
        722usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(cdef_uv_strengths)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).loop_restoration_fields
                as *const _ as usize
        },
        730usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(loop_restoration_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).wm as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(wm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VADecPictureParameterBufferAV1>())).va_reserved as *const _
                as usize
        },
        1124usize,
        concat!(
            "Offset of field: ",
            stringify!(_VADecPictureParameterBufferAV1),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VADecPictureParameterBufferAV1 = _VADecPictureParameterBufferAV1;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VASliceParameterBufferAV1 {
    pub slice_data_size: u32,
    pub slice_data_offset: u32,
    pub slice_data_flag: u32,
    pub tile_row: u16,
    pub tile_column: u16,
    pub tg_start: u16,
    pub tg_end: u16,
    pub anchor_frame_idx: u8,
    pub tile_idx_in_tile_list: u16,
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VASliceParameterBufferAV1() {
    assert_eq!(
        ::std::mem::size_of::<_VASliceParameterBufferAV1>(),
        40usize,
        concat!("Size of: ", stringify!(_VASliceParameterBufferAV1))
    );
    assert_eq!(
        ::std::mem::align_of::<_VASliceParameterBufferAV1>(),
        4usize,
        concat!("Alignment of ", stringify!(_VASliceParameterBufferAV1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferAV1>())).slice_data_size as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferAV1),
            "::",
            stringify!(slice_data_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferAV1>())).slice_data_offset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferAV1),
            "::",
            stringify!(slice_data_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferAV1>())).slice_data_flag as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferAV1),
            "::",
            stringify!(slice_data_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferAV1>())).tile_row as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferAV1),
            "::",
            stringify!(tile_row)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferAV1>())).tile_column as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferAV1),
            "::",
            stringify!(tile_column)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferAV1>())).tg_start as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferAV1),
            "::",
            stringify!(tg_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferAV1>())).tg_end as *const _ as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferAV1),
            "::",
            stringify!(tg_end)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferAV1>())).anchor_frame_idx as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferAV1),
            "::",
            stringify!(anchor_frame_idx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferAV1>())).tile_idx_in_tile_list as *const _
                as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferAV1),
            "::",
            stringify!(tile_idx_in_tile_list)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VASliceParameterBufferAV1>())).va_reserved as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VASliceParameterBufferAV1),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VASliceParameterBufferAV1 = _VASliceParameterBufferAV1;
#[repr(C)]
#[derive(Copy, Clone)]
pub union VAConfigAttribValEncHEVCFeatures {
    pub bits: VAConfigAttribValEncHEVCFeatures__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct VAConfigAttribValEncHEVCFeatures__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_VAConfigAttribValEncHEVCFeatures__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<VAConfigAttribValEncHEVCFeatures__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(VAConfigAttribValEncHEVCFeatures__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VAConfigAttribValEncHEVCFeatures__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(VAConfigAttribValEncHEVCFeatures__bindgen_ty_1)
        )
    );
}
impl VAConfigAttribValEncHEVCFeatures__bindgen_ty_1 {
    #[inline]
    pub fn separate_colour_planes(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_separate_colour_planes(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn scaling_lists(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_scaling_lists(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn amp(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_amp(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn sao(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_sao(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_pcm(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn temporal_mvp(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_temporal_mvp(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn strong_intra_smoothing(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_strong_intra_smoothing(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn dependent_slices(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slices(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn sign_data_hiding(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_sign_data_hiding(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn constrained_intra_pred(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_constrained_intra_pred(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn cu_qp_delta(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_cu_qp_delta(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_prediction(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_prediction(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn transquant_bypass(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_transquant_bypass(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_disable(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_disable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        separate_colour_planes: u32,
        scaling_lists: u32,
        amp: u32,
        sao: u32,
        pcm: u32,
        temporal_mvp: u32,
        strong_intra_smoothing: u32,
        dependent_slices: u32,
        sign_data_hiding: u32,
        constrained_intra_pred: u32,
        transform_skip: u32,
        cu_qp_delta: u32,
        weighted_prediction: u32,
        transquant_bypass: u32,
        deblocking_filter_disable: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let separate_colour_planes: u32 =
                unsafe { ::std::mem::transmute(separate_colour_planes) };
            separate_colour_planes as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let scaling_lists: u32 = unsafe { ::std::mem::transmute(scaling_lists) };
            scaling_lists as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let amp: u32 = unsafe { ::std::mem::transmute(amp) };
            amp as u64
        });
        __bindgen_bitfield_unit.set(6usize, 2u8, {
            let sao: u32 = unsafe { ::std::mem::transmute(sao) };
            sao as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let pcm: u32 = unsafe { ::std::mem::transmute(pcm) };
            pcm as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let temporal_mvp: u32 = unsafe { ::std::mem::transmute(temporal_mvp) };
            temporal_mvp as u64
        });
        __bindgen_bitfield_unit.set(12usize, 2u8, {
            let strong_intra_smoothing: u32 =
                unsafe { ::std::mem::transmute(strong_intra_smoothing) };
            strong_intra_smoothing as u64
        });
        __bindgen_bitfield_unit.set(14usize, 2u8, {
            let dependent_slices: u32 = unsafe { ::std::mem::transmute(dependent_slices) };
            dependent_slices as u64
        });
        __bindgen_bitfield_unit.set(16usize, 2u8, {
            let sign_data_hiding: u32 = unsafe { ::std::mem::transmute(sign_data_hiding) };
            sign_data_hiding as u64
        });
        __bindgen_bitfield_unit.set(18usize, 2u8, {
            let constrained_intra_pred: u32 =
                unsafe { ::std::mem::transmute(constrained_intra_pred) };
            constrained_intra_pred as u64
        });
        __bindgen_bitfield_unit.set(20usize, 2u8, {
            let transform_skip: u32 = unsafe { ::std::mem::transmute(transform_skip) };
            transform_skip as u64
        });
        __bindgen_bitfield_unit.set(22usize, 2u8, {
            let cu_qp_delta: u32 = unsafe { ::std::mem::transmute(cu_qp_delta) };
            cu_qp_delta as u64
        });
        __bindgen_bitfield_unit.set(24usize, 2u8, {
            let weighted_prediction: u32 = unsafe { ::std::mem::transmute(weighted_prediction) };
            weighted_prediction as u64
        });
        __bindgen_bitfield_unit.set(26usize, 2u8, {
            let transquant_bypass: u32 = unsafe { ::std::mem::transmute(transquant_bypass) };
            transquant_bypass as u64
        });
        __bindgen_bitfield_unit.set(28usize, 2u8, {
            let deblocking_filter_disable: u32 =
                unsafe { ::std::mem::transmute(deblocking_filter_disable) };
            deblocking_filter_disable as u64
        });
        __bindgen_bitfield_unit.set(30usize, 2u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_VAConfigAttribValEncHEVCFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VAConfigAttribValEncHEVCFeatures>(),
        4usize,
        concat!("Size of: ", stringify!(VAConfigAttribValEncHEVCFeatures))
    );
    assert_eq!(
        ::std::mem::align_of::<VAConfigAttribValEncHEVCFeatures>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(VAConfigAttribValEncHEVCFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VAConfigAttribValEncHEVCFeatures>())).bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VAConfigAttribValEncHEVCFeatures),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VAConfigAttribValEncHEVCFeatures>())).value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VAConfigAttribValEncHEVCFeatures),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VAConfigAttribValEncHEVCBlockSizes {
    pub bits: VAConfigAttribValEncHEVCBlockSizes__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct VAConfigAttribValEncHEVCBlockSizes__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_VAConfigAttribValEncHEVCBlockSizes__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<VAConfigAttribValEncHEVCBlockSizes__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(VAConfigAttribValEncHEVCBlockSizes__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VAConfigAttribValEncHEVCBlockSizes__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(VAConfigAttribValEncHEVCBlockSizes__bindgen_ty_1)
        )
    );
}
impl VAConfigAttribValEncHEVCBlockSizes__bindgen_ty_1 {
    #[inline]
    pub fn log2_max_coding_tree_block_size_minus3(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_log2_max_coding_tree_block_size_minus3(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_min_coding_tree_block_size_minus3(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_log2_min_coding_tree_block_size_minus3(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_min_luma_coding_block_size_minus3(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_log2_min_luma_coding_block_size_minus3(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_max_luma_transform_block_size_minus2(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_log2_max_luma_transform_block_size_minus2(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_min_luma_transform_block_size_minus2(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_log2_min_luma_transform_block_size_minus2(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn max_max_transform_hierarchy_depth_inter(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_max_max_transform_hierarchy_depth_inter(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn min_max_transform_hierarchy_depth_inter(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_min_max_transform_hierarchy_depth_inter(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn max_max_transform_hierarchy_depth_intra(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_max_max_transform_hierarchy_depth_intra(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn min_max_transform_hierarchy_depth_intra(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_min_max_transform_hierarchy_depth_intra(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_max_pcm_coding_block_size_minus3(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_log2_max_pcm_coding_block_size_minus3(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_min_pcm_coding_block_size_minus3(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_log2_min_pcm_coding_block_size_minus3(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 10u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        log2_max_coding_tree_block_size_minus3: u32,
        log2_min_coding_tree_block_size_minus3: u32,
        log2_min_luma_coding_block_size_minus3: u32,
        log2_max_luma_transform_block_size_minus2: u32,
        log2_min_luma_transform_block_size_minus2: u32,
        max_max_transform_hierarchy_depth_inter: u32,
        min_max_transform_hierarchy_depth_inter: u32,
        max_max_transform_hierarchy_depth_intra: u32,
        min_max_transform_hierarchy_depth_intra: u32,
        log2_max_pcm_coding_block_size_minus3: u32,
        log2_min_pcm_coding_block_size_minus3: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let log2_max_coding_tree_block_size_minus3: u32 =
                unsafe { ::std::mem::transmute(log2_max_coding_tree_block_size_minus3) };
            log2_max_coding_tree_block_size_minus3 as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let log2_min_coding_tree_block_size_minus3: u32 =
                unsafe { ::std::mem::transmute(log2_min_coding_tree_block_size_minus3) };
            log2_min_coding_tree_block_size_minus3 as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let log2_min_luma_coding_block_size_minus3: u32 =
                unsafe { ::std::mem::transmute(log2_min_luma_coding_block_size_minus3) };
            log2_min_luma_coding_block_size_minus3 as u64
        });
        __bindgen_bitfield_unit.set(6usize, 2u8, {
            let log2_max_luma_transform_block_size_minus2: u32 =
                unsafe { ::std::mem::transmute(log2_max_luma_transform_block_size_minus2) };
            log2_max_luma_transform_block_size_minus2 as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let log2_min_luma_transform_block_size_minus2: u32 =
                unsafe { ::std::mem::transmute(log2_min_luma_transform_block_size_minus2) };
            log2_min_luma_transform_block_size_minus2 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let max_max_transform_hierarchy_depth_inter: u32 =
                unsafe { ::std::mem::transmute(max_max_transform_hierarchy_depth_inter) };
            max_max_transform_hierarchy_depth_inter as u64
        });
        __bindgen_bitfield_unit.set(12usize, 2u8, {
            let min_max_transform_hierarchy_depth_inter: u32 =
                unsafe { ::std::mem::transmute(min_max_transform_hierarchy_depth_inter) };
            min_max_transform_hierarchy_depth_inter as u64
        });
        __bindgen_bitfield_unit.set(14usize, 2u8, {
            let max_max_transform_hierarchy_depth_intra: u32 =
                unsafe { ::std::mem::transmute(max_max_transform_hierarchy_depth_intra) };
            max_max_transform_hierarchy_depth_intra as u64
        });
        __bindgen_bitfield_unit.set(16usize, 2u8, {
            let min_max_transform_hierarchy_depth_intra: u32 =
                unsafe { ::std::mem::transmute(min_max_transform_hierarchy_depth_intra) };
            min_max_transform_hierarchy_depth_intra as u64
        });
        __bindgen_bitfield_unit.set(18usize, 2u8, {
            let log2_max_pcm_coding_block_size_minus3: u32 =
                unsafe { ::std::mem::transmute(log2_max_pcm_coding_block_size_minus3) };
            log2_max_pcm_coding_block_size_minus3 as u64
        });
        __bindgen_bitfield_unit.set(20usize, 2u8, {
            let log2_min_pcm_coding_block_size_minus3: u32 =
                unsafe { ::std::mem::transmute(log2_min_pcm_coding_block_size_minus3) };
            log2_min_pcm_coding_block_size_minus3 as u64
        });
        __bindgen_bitfield_unit.set(22usize, 10u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_VAConfigAttribValEncHEVCBlockSizes() {
    assert_eq!(
        ::std::mem::size_of::<VAConfigAttribValEncHEVCBlockSizes>(),
        4usize,
        concat!("Size of: ", stringify!(VAConfigAttribValEncHEVCBlockSizes))
    );
    assert_eq!(
        ::std::mem::align_of::<VAConfigAttribValEncHEVCBlockSizes>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(VAConfigAttribValEncHEVCBlockSizes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VAConfigAttribValEncHEVCBlockSizes>())).bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VAConfigAttribValEncHEVCBlockSizes),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VAConfigAttribValEncHEVCBlockSizes>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VAConfigAttribValEncHEVCBlockSizes),
            "::",
            stringify!(value)
        )
    );
}
pub const VAEncPackedHeaderTypeHEVC_VAEncPackedHeaderHEVC_VPS: VAEncPackedHeaderTypeHEVC = 1;
pub const VAEncPackedHeaderTypeHEVC_VAEncPackedHeaderHEVC_SPS: VAEncPackedHeaderTypeHEVC = 1;
pub const VAEncPackedHeaderTypeHEVC_VAEncPackedHeaderHEVC_PPS: VAEncPackedHeaderTypeHEVC = 2;
pub const VAEncPackedHeaderTypeHEVC_VAEncPackedHeaderHEVC_Slice: VAEncPackedHeaderTypeHEVC = 3;
pub const VAEncPackedHeaderTypeHEVC_VAEncPackedHeaderHEVC_SEI: VAEncPackedHeaderTypeHEVC =
    2147483649;
pub type VAEncPackedHeaderTypeHEVC = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncSequenceParameterBufferHEVC {
    pub general_profile_idc: u8,
    pub general_level_idc: u8,
    pub general_tier_flag: u8,
    pub intra_period: u32,
    pub intra_idr_period: u32,
    pub ip_period: u32,
    pub bits_per_second: u32,
    pub pic_width_in_luma_samples: u16,
    pub pic_height_in_luma_samples: u16,
    pub seq_fields: _VAEncSequenceParameterBufferHEVC__bindgen_ty_1,
    pub log2_min_luma_coding_block_size_minus3: u8,
    pub log2_diff_max_min_luma_coding_block_size: u8,
    pub log2_min_transform_block_size_minus2: u8,
    pub log2_diff_max_min_transform_block_size: u8,
    pub max_transform_hierarchy_depth_inter: u8,
    pub max_transform_hierarchy_depth_intra: u8,
    pub pcm_sample_bit_depth_luma_minus1: u32,
    pub pcm_sample_bit_depth_chroma_minus1: u32,
    pub log2_min_pcm_luma_coding_block_size_minus3: u32,
    pub log2_max_pcm_luma_coding_block_size_minus3: u32,
    pub vui_parameters_present_flag: u8,
    pub vui_fields: _VAEncSequenceParameterBufferHEVC__bindgen_ty_2,
    pub aspect_ratio_idc: u8,
    pub sar_width: u32,
    pub sar_height: u32,
    pub vui_num_units_in_tick: u32,
    pub vui_time_scale: u32,
    pub min_spatial_segmentation_idc: u16,
    pub max_bytes_per_pic_denom: u8,
    pub max_bits_per_min_cu_denom: u8,
    pub scc_fields: _VAEncSequenceParameterBufferHEVC__bindgen_ty_3,
    pub va_reserved: [u32; 7usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncSequenceParameterBufferHEVC__bindgen_ty_1 {
    pub bits: _VAEncSequenceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncSequenceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAEncSequenceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncSequenceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn chroma_format_idc(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_format_idc(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_colour_plane_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_separate_colour_plane_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bit_depth_luma_minus8(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_bit_depth_luma_minus8(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn bit_depth_chroma_minus8(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_bit_depth_chroma_minus8(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn scaling_list_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scaling_list_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn strong_intra_smoothing_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_strong_intra_smoothing_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn amp_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_amp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sample_adaptive_offset_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample_adaptive_offset_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm_loop_filter_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pcm_loop_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_temporal_mvp_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_temporal_mvp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn low_delay_seq(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_low_delay_seq(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hierachical_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hierachical_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_bits(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 14u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_bits(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 14u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        chroma_format_idc: u32,
        separate_colour_plane_flag: u32,
        bit_depth_luma_minus8: u32,
        bit_depth_chroma_minus8: u32,
        scaling_list_enabled_flag: u32,
        strong_intra_smoothing_enabled_flag: u32,
        amp_enabled_flag: u32,
        sample_adaptive_offset_enabled_flag: u32,
        pcm_enabled_flag: u32,
        pcm_loop_filter_disabled_flag: u32,
        sps_temporal_mvp_enabled_flag: u32,
        low_delay_seq: u32,
        hierachical_flag: u32,
        reserved_bits: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let chroma_format_idc: u32 = unsafe { ::std::mem::transmute(chroma_format_idc) };
            chroma_format_idc as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let separate_colour_plane_flag: u32 =
                unsafe { ::std::mem::transmute(separate_colour_plane_flag) };
            separate_colour_plane_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 3u8, {
            let bit_depth_luma_minus8: u32 =
                unsafe { ::std::mem::transmute(bit_depth_luma_minus8) };
            bit_depth_luma_minus8 as u64
        });
        __bindgen_bitfield_unit.set(6usize, 3u8, {
            let bit_depth_chroma_minus8: u32 =
                unsafe { ::std::mem::transmute(bit_depth_chroma_minus8) };
            bit_depth_chroma_minus8 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let scaling_list_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(scaling_list_enabled_flag) };
            scaling_list_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let strong_intra_smoothing_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(strong_intra_smoothing_enabled_flag) };
            strong_intra_smoothing_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let amp_enabled_flag: u32 = unsafe { ::std::mem::transmute(amp_enabled_flag) };
            amp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let sample_adaptive_offset_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sample_adaptive_offset_enabled_flag) };
            sample_adaptive_offset_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let pcm_enabled_flag: u32 = unsafe { ::std::mem::transmute(pcm_enabled_flag) };
            pcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let pcm_loop_filter_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(pcm_loop_filter_disabled_flag) };
            pcm_loop_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let sps_temporal_mvp_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sps_temporal_mvp_enabled_flag) };
            sps_temporal_mvp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let low_delay_seq: u32 = unsafe { ::std::mem::transmute(low_delay_seq) };
            low_delay_seq as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let hierachical_flag: u32 = unsafe { ::std::mem::transmute(hierachical_flag) };
            hierachical_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 14u8, {
            let reserved_bits: u32 = unsafe { ::std::mem::transmute(reserved_bits) };
            reserved_bits as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncSequenceParameterBufferHEVC__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncSequenceParameterBufferHEVC__bindgen_ty_2 {
    pub bits: _VAEncSequenceParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncSequenceParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout__VAEncSequenceParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1)
        )
    );
}
impl _VAEncSequenceParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1 {
    #[inline]
    pub fn aspect_ratio_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_aspect_ratio_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn neutral_chroma_indication_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_neutral_chroma_indication_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn field_seq_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_field_seq_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_timing_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bitstream_restriction_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bitstream_restriction_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tiles_fixed_structure_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tiles_fixed_structure_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn motion_vectors_over_pic_boundaries_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_motion_vectors_over_pic_boundaries_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn restricted_ref_pic_lists_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_restricted_ref_pic_lists_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_max_mv_length_horizontal(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_log2_max_mv_length_horizontal(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn log2_max_mv_length_vertical(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_log2_max_mv_length_vertical(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        aspect_ratio_info_present_flag: u32,
        neutral_chroma_indication_flag: u32,
        field_seq_flag: u32,
        vui_timing_info_present_flag: u32,
        bitstream_restriction_flag: u32,
        tiles_fixed_structure_flag: u32,
        motion_vectors_over_pic_boundaries_flag: u32,
        restricted_ref_pic_lists_flag: u32,
        log2_max_mv_length_horizontal: u32,
        log2_max_mv_length_vertical: u32,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let aspect_ratio_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(aspect_ratio_info_present_flag) };
            aspect_ratio_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let neutral_chroma_indication_flag: u32 =
                unsafe { ::std::mem::transmute(neutral_chroma_indication_flag) };
            neutral_chroma_indication_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let field_seq_flag: u32 = unsafe { ::std::mem::transmute(field_seq_flag) };
            field_seq_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let vui_timing_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(vui_timing_info_present_flag) };
            vui_timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let bitstream_restriction_flag: u32 =
                unsafe { ::std::mem::transmute(bitstream_restriction_flag) };
            bitstream_restriction_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let tiles_fixed_structure_flag: u32 =
                unsafe { ::std::mem::transmute(tiles_fixed_structure_flag) };
            tiles_fixed_structure_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let motion_vectors_over_pic_boundaries_flag: u32 =
                unsafe { ::std::mem::transmute(motion_vectors_over_pic_boundaries_flag) };
            motion_vectors_over_pic_boundaries_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let restricted_ref_pic_lists_flag: u32 =
                unsafe { ::std::mem::transmute(restricted_ref_pic_lists_flag) };
            restricted_ref_pic_lists_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 5u8, {
            let log2_max_mv_length_horizontal: u32 =
                unsafe { ::std::mem::transmute(log2_max_mv_length_horizontal) };
            log2_max_mv_length_horizontal as u64
        });
        __bindgen_bitfield_unit.set(13usize, 5u8, {
            let log2_max_mv_length_vertical: u32 =
                unsafe { ::std::mem::transmute(log2_max_mv_length_vertical) };
            log2_max_mv_length_vertical as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncSequenceParameterBufferHEVC__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_2>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_2>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_2),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_2>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_2),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncSequenceParameterBufferHEVC__bindgen_ty_3 {
    pub bits: _VAEncSequenceParameterBufferHEVC__bindgen_ty_3__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncSequenceParameterBufferHEVC__bindgen_ty_3__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAEncSequenceParameterBufferHEVC__bindgen_ty_3__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_3__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_3__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_3__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_3__bindgen_ty_1)
        )
    );
}
impl _VAEncSequenceParameterBufferHEVC__bindgen_ty_3__bindgen_ty_1 {
    #[inline]
    pub fn palette_mode_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_palette_mode_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        palette_mode_enabled_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let palette_mode_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(palette_mode_enabled_flag) };
            palette_mode_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncSequenceParameterBufferHEVC__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_3>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_3>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_3>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_3),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC__bindgen_ty_3>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC__bindgen_ty_3),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncSequenceParameterBufferHEVC() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSequenceParameterBufferHEVC>(),
        116usize,
        concat!("Size of: ", stringify!(_VAEncSequenceParameterBufferHEVC))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSequenceParameterBufferHEVC>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSequenceParameterBufferHEVC)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).general_profile_idc
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(general_profile_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).general_level_idc
                as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(general_level_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).general_tier_flag
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(general_tier_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).intra_period as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(intra_period)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).intra_idr_period
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(intra_idr_period)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).ip_period as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(ip_period)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).bits_per_second
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(bits_per_second)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).pic_width_in_luma_samples
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(pic_width_in_luma_samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).pic_height_in_luma_samples
                as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(pic_height_in_luma_samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).seq_fields as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(seq_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .log2_min_luma_coding_block_size_minus3 as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(log2_min_luma_coding_block_size_minus3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .log2_diff_max_min_luma_coding_block_size as *const _ as usize
        },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(log2_diff_max_min_luma_coding_block_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .log2_min_transform_block_size_minus2 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(log2_min_transform_block_size_minus2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .log2_diff_max_min_transform_block_size as *const _ as usize
        },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(log2_diff_max_min_transform_block_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .max_transform_hierarchy_depth_inter as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(max_transform_hierarchy_depth_inter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .max_transform_hierarchy_depth_intra as *const _ as usize
        },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(max_transform_hierarchy_depth_intra)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .pcm_sample_bit_depth_luma_minus1 as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(pcm_sample_bit_depth_luma_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .pcm_sample_bit_depth_chroma_minus1 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(pcm_sample_bit_depth_chroma_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .log2_min_pcm_luma_coding_block_size_minus3 as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(log2_min_pcm_luma_coding_block_size_minus3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .log2_max_pcm_luma_coding_block_size_minus3 as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(log2_max_pcm_luma_coding_block_size_minus3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .vui_parameters_present_flag as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(vui_parameters_present_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).vui_fields as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(vui_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).aspect_ratio_idc
                as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(aspect_ratio_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).sar_width as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(sar_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).sar_height as *const _
                as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(sar_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).vui_num_units_in_tick
                as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(vui_num_units_in_tick)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).vui_time_scale as *const _
                as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(vui_time_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>()))
                .min_spatial_segmentation_idc as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(min_spatial_segmentation_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).max_bytes_per_pic_denom
                as *const _ as usize
        },
        82usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(max_bytes_per_pic_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).max_bits_per_min_cu_denom
                as *const _ as usize
        },
        83usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(max_bits_per_min_cu_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).scc_fields as *const _
                as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(scc_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSequenceParameterBufferHEVC>())).va_reserved as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSequenceParameterBufferHEVC),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncSequenceParameterBufferHEVC = _VAEncSequenceParameterBufferHEVC;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncPictureParameterBufferHEVC {
    pub decoded_curr_pic: VAPictureHEVC,
    pub reference_frames: [VAPictureHEVC; 15usize],
    pub coded_buf: VABufferID,
    pub collocated_ref_pic_index: u8,
    pub last_picture: u8,
    pub pic_init_qp: u8,
    pub diff_cu_qp_delta_depth: u8,
    pub pps_cb_qp_offset: i8,
    pub pps_cr_qp_offset: i8,
    pub num_tile_columns_minus1: u8,
    pub num_tile_rows_minus1: u8,
    pub column_width_minus1: [u8; 19usize],
    pub row_height_minus1: [u8; 21usize],
    pub log2_parallel_merge_level_minus2: u8,
    pub ctu_max_bitsize_allowed: u8,
    pub num_ref_idx_l0_default_active_minus1: u8,
    pub num_ref_idx_l1_default_active_minus1: u8,
    pub slice_pic_parameter_set_id: u8,
    pub nal_unit_type: u8,
    pub pic_fields: _VAEncPictureParameterBufferHEVC__bindgen_ty_1,
    pub hierarchical_level_plus1: u8,
    pub va_byte_reserved: u8,
    pub scc_fields: _VAEncPictureParameterBufferHEVC__bindgen_ty_2,
    pub va_reserved: [u32; 15usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncPictureParameterBufferHEVC__bindgen_ty_1 {
    pub bits: _VAEncPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAEncPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncPictureParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn idr_pic_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_idr_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn coding_type(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_coding_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn reference_pic_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reference_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dependent_slice_segments_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slice_segments_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sign_data_hiding_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign_data_hiding_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constrained_intra_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constrained_intra_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cu_qp_delta_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cu_qp_delta_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_bipred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_bipred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transquant_bypass_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transquant_bypass_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tiles_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tiles_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn entropy_coding_sync_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_entropy_coding_sync_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn loop_filter_across_tiles_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_loop_filter_across_tiles_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_loop_filter_across_slices_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_loop_filter_across_slices_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scaling_list_data_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scaling_list_data_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn screen_content_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_screen_content_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_gpu_weighted_prediction(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_gpu_weighted_prediction(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_output_of_prior_pics_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_output_of_prior_pics_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 11u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 11u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        idr_pic_flag: u32,
        coding_type: u32,
        reference_pic_flag: u32,
        dependent_slice_segments_enabled_flag: u32,
        sign_data_hiding_enabled_flag: u32,
        constrained_intra_pred_flag: u32,
        transform_skip_enabled_flag: u32,
        cu_qp_delta_enabled_flag: u32,
        weighted_pred_flag: u32,
        weighted_bipred_flag: u32,
        transquant_bypass_enabled_flag: u32,
        tiles_enabled_flag: u32,
        entropy_coding_sync_enabled_flag: u32,
        loop_filter_across_tiles_enabled_flag: u32,
        pps_loop_filter_across_slices_enabled_flag: u32,
        scaling_list_data_present_flag: u32,
        screen_content_flag: u32,
        enable_gpu_weighted_prediction: u32,
        no_output_of_prior_pics_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let idr_pic_flag: u32 = unsafe { ::std::mem::transmute(idr_pic_flag) };
            idr_pic_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 3u8, {
            let coding_type: u32 = unsafe { ::std::mem::transmute(coding_type) };
            coding_type as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let reference_pic_flag: u32 = unsafe { ::std::mem::transmute(reference_pic_flag) };
            reference_pic_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let dependent_slice_segments_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(dependent_slice_segments_enabled_flag) };
            dependent_slice_segments_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let sign_data_hiding_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sign_data_hiding_enabled_flag) };
            sign_data_hiding_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let constrained_intra_pred_flag: u32 =
                unsafe { ::std::mem::transmute(constrained_intra_pred_flag) };
            constrained_intra_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let transform_skip_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transform_skip_enabled_flag) };
            transform_skip_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let cu_qp_delta_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cu_qp_delta_enabled_flag) };
            cu_qp_delta_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let weighted_pred_flag: u32 = unsafe { ::std::mem::transmute(weighted_pred_flag) };
            weighted_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let weighted_bipred_flag: u32 = unsafe { ::std::mem::transmute(weighted_bipred_flag) };
            weighted_bipred_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let transquant_bypass_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transquant_bypass_enabled_flag) };
            transquant_bypass_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let tiles_enabled_flag: u32 = unsafe { ::std::mem::transmute(tiles_enabled_flag) };
            tiles_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let entropy_coding_sync_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(entropy_coding_sync_enabled_flag) };
            entropy_coding_sync_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let loop_filter_across_tiles_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(loop_filter_across_tiles_enabled_flag) };
            loop_filter_across_tiles_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let pps_loop_filter_across_slices_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(pps_loop_filter_across_slices_enabled_flag) };
            pps_loop_filter_across_slices_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let scaling_list_data_present_flag: u32 =
                unsafe { ::std::mem::transmute(scaling_list_data_present_flag) };
            scaling_list_data_present_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let screen_content_flag: u32 = unsafe { ::std::mem::transmute(screen_content_flag) };
            screen_content_flag as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let enable_gpu_weighted_prediction: u32 =
                unsafe { ::std::mem::transmute(enable_gpu_weighted_prediction) };
            enable_gpu_weighted_prediction as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let no_output_of_prior_pics_flag: u32 =
                unsafe { ::std::mem::transmute(no_output_of_prior_pics_flag) };
            no_output_of_prior_pics_flag as u64
        });
        __bindgen_bitfield_unit.set(21usize, 11u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncPictureParameterBufferHEVC__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncPictureParameterBufferHEVC__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncPictureParameterBufferHEVC__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncPictureParameterBufferHEVC__bindgen_ty_2 {
    pub bits: _VAEncPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1,
    pub value: u16,
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout__VAEncPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1)
        )
    );
}
impl _VAEncPictureParameterBufferHEVC__bindgen_ty_2__bindgen_ty_1 {
    #[inline]
    pub fn pps_curr_pic_ref_enabled_flag(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_pps_curr_pic_ref_enabled_flag(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 15u8) as u16) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pps_curr_pic_ref_enabled_flag: u16,
        reserved: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let pps_curr_pic_ref_enabled_flag: u16 =
                unsafe { ::std::mem::transmute(pps_curr_pic_ref_enabled_flag) };
            pps_curr_pic_ref_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 15u8, {
            let reserved: u16 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncPictureParameterBufferHEVC__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncPictureParameterBufferHEVC__bindgen_ty_2>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncPictureParameterBufferHEVC__bindgen_ty_2>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC__bindgen_ty_2>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_2),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC__bindgen_ty_2>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC__bindgen_ty_2),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncPictureParameterBufferHEVC() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncPictureParameterBufferHEVC>(),
        576usize,
        concat!("Size of: ", stringify!(_VAEncPictureParameterBufferHEVC))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncPictureParameterBufferHEVC>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncPictureParameterBufferHEVC)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).decoded_curr_pic
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(decoded_curr_pic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).reference_frames
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(reference_frames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).coded_buf as *const _
                as usize
        },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(coded_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).collocated_ref_pic_index
                as *const _ as usize
        },
        452usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(collocated_ref_pic_index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).last_picture as *const _
                as usize
        },
        453usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(last_picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).pic_init_qp as *const _
                as usize
        },
        454usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(pic_init_qp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).diff_cu_qp_delta_depth
                as *const _ as usize
        },
        455usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(diff_cu_qp_delta_depth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).pps_cb_qp_offset
                as *const _ as usize
        },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(pps_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).pps_cr_qp_offset
                as *const _ as usize
        },
        457usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(pps_cr_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).num_tile_columns_minus1
                as *const _ as usize
        },
        458usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(num_tile_columns_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).num_tile_rows_minus1
                as *const _ as usize
        },
        459usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(num_tile_rows_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).column_width_minus1
                as *const _ as usize
        },
        460usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(column_width_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).row_height_minus1
                as *const _ as usize
        },
        479usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(row_height_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>()))
                .log2_parallel_merge_level_minus2 as *const _ as usize
        },
        500usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(log2_parallel_merge_level_minus2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).ctu_max_bitsize_allowed
                as *const _ as usize
        },
        501usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(ctu_max_bitsize_allowed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>()))
                .num_ref_idx_l0_default_active_minus1 as *const _ as usize
        },
        502usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(num_ref_idx_l0_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>()))
                .num_ref_idx_l1_default_active_minus1 as *const _ as usize
        },
        503usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(num_ref_idx_l1_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).slice_pic_parameter_set_id
                as *const _ as usize
        },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(slice_pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).nal_unit_type as *const _
                as usize
        },
        505usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(nal_unit_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).pic_fields as *const _
                as usize
        },
        508usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(pic_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).hierarchical_level_plus1
                as *const _ as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(hierarchical_level_plus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).va_byte_reserved
                as *const _ as usize
        },
        513usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(va_byte_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).scc_fields as *const _
                as usize
        },
        514usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(scc_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncPictureParameterBufferHEVC>())).va_reserved as *const _
                as usize
        },
        516usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncPictureParameterBufferHEVC),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncPictureParameterBufferHEVC = _VAEncPictureParameterBufferHEVC;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAEncSliceParameterBufferHEVC {
    pub slice_segment_address: u32,
    pub num_ctu_in_slice: u32,
    pub slice_type: u8,
    pub slice_pic_parameter_set_id: u8,
    pub num_ref_idx_l0_active_minus1: u8,
    pub num_ref_idx_l1_active_minus1: u8,
    pub ref_pic_list0: [VAPictureHEVC; 15usize],
    pub ref_pic_list1: [VAPictureHEVC; 15usize],
    pub luma_log2_weight_denom: u8,
    pub delta_chroma_log2_weight_denom: i8,
    pub delta_luma_weight_l0: [i8; 15usize],
    pub luma_offset_l0: [i8; 15usize],
    pub delta_chroma_weight_l0: [[i8; 2usize]; 15usize],
    pub chroma_offset_l0: [[i8; 2usize]; 15usize],
    pub delta_luma_weight_l1: [i8; 15usize],
    pub luma_offset_l1: [i8; 15usize],
    pub delta_chroma_weight_l1: [[i8; 2usize]; 15usize],
    pub chroma_offset_l1: [[i8; 2usize]; 15usize],
    pub max_num_merge_cand: u8,
    pub slice_qp_delta: i8,
    pub slice_cb_qp_offset: i8,
    pub slice_cr_qp_offset: i8,
    pub slice_beta_offset_div2: i8,
    pub slice_tc_offset_div2: i8,
    pub slice_fields: _VAEncSliceParameterBufferHEVC__bindgen_ty_1,
    pub pred_weight_table_bit_offset: u32,
    pub pred_weight_table_bit_length: u32,
    pub va_reserved: [u32; 6usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAEncSliceParameterBufferHEVC__bindgen_ty_1 {
    pub bits: _VAEncSliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAEncSliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout__VAEncSliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncSliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl _VAEncSliceParameterBufferHEVC__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn last_slice_of_pic_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_last_slice_of_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dependent_slice_segment_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slice_segment_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn colour_plane_id(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_colour_plane_id(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_temporal_mvp_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_temporal_mvp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_sao_luma_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_sao_luma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_sao_chroma_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_sao_chroma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn num_ref_idx_active_override_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_num_ref_idx_active_override_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mvd_l1_zero_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mvd_l1_zero_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_init_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_init_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_deblocking_filter_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_slice_deblocking_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_loop_filter_across_slices_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_loop_filter_across_slices_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn collocated_from_l0_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_collocated_from_l0_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        last_slice_of_pic_flag: u32,
        dependent_slice_segment_flag: u32,
        colour_plane_id: u32,
        slice_temporal_mvp_enabled_flag: u32,
        slice_sao_luma_flag: u32,
        slice_sao_chroma_flag: u32,
        num_ref_idx_active_override_flag: u32,
        mvd_l1_zero_flag: u32,
        cabac_init_flag: u32,
        slice_deblocking_filter_disabled_flag: u32,
        slice_loop_filter_across_slices_enabled_flag: u32,
        collocated_from_l0_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let last_slice_of_pic_flag: u32 =
                unsafe { ::std::mem::transmute(last_slice_of_pic_flag) };
            last_slice_of_pic_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let dependent_slice_segment_flag: u32 =
                unsafe { ::std::mem::transmute(dependent_slice_segment_flag) };
            dependent_slice_segment_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let colour_plane_id: u32 = unsafe { ::std::mem::transmute(colour_plane_id) };
            colour_plane_id as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let slice_temporal_mvp_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(slice_temporal_mvp_enabled_flag) };
            slice_temporal_mvp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let slice_sao_luma_flag: u32 = unsafe { ::std::mem::transmute(slice_sao_luma_flag) };
            slice_sao_luma_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let slice_sao_chroma_flag: u32 =
                unsafe { ::std::mem::transmute(slice_sao_chroma_flag) };
            slice_sao_chroma_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let num_ref_idx_active_override_flag: u32 =
                unsafe { ::std::mem::transmute(num_ref_idx_active_override_flag) };
            num_ref_idx_active_override_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let mvd_l1_zero_flag: u32 = unsafe { ::std::mem::transmute(mvd_l1_zero_flag) };
            mvd_l1_zero_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let cabac_init_flag: u32 = unsafe { ::std::mem::transmute(cabac_init_flag) };
            cabac_init_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let slice_deblocking_filter_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(slice_deblocking_filter_disabled_flag) };
            slice_deblocking_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let slice_loop_filter_across_slices_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(slice_loop_filter_across_slices_enabled_flag) };
            slice_loop_filter_across_slices_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let collocated_from_l0_flag: u32 =
                unsafe { ::std::mem::transmute(collocated_from_l0_flag) };
            collocated_from_l0_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAEncSliceParameterBufferHEVC__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSliceParameterBufferHEVC__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAEncSliceParameterBufferHEVC__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSliceParameterBufferHEVC__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAEncSliceParameterBufferHEVC__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC__bindgen_ty_1>())).bits
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC__bindgen_ty_1>())).value
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
}
#[test]
fn bindgen_test_layout__VAEncSliceParameterBufferHEVC() {
    assert_eq!(
        ::std::mem::size_of::<_VAEncSliceParameterBufferHEVC>(),
        1076usize,
        concat!("Size of: ", stringify!(_VAEncSliceParameterBufferHEVC))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAEncSliceParameterBufferHEVC>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAEncSliceParameterBufferHEVC))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).slice_segment_address
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(slice_segment_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).num_ctu_in_slice as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(num_ctu_in_slice)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).slice_type as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(slice_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).slice_pic_parameter_set_id
                as *const _ as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(slice_pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).num_ref_idx_l0_active_minus1
                as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(num_ref_idx_l0_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).num_ref_idx_l1_active_minus1
                as *const _ as usize
        },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(num_ref_idx_l1_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).ref_pic_list0 as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(ref_pic_list0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).ref_pic_list1 as *const _
                as usize
        },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(ref_pic_list1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).luma_log2_weight_denom
                as *const _ as usize
        },
        852usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(luma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>()))
                .delta_chroma_log2_weight_denom as *const _ as usize
        },
        853usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(delta_chroma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).delta_luma_weight_l0
                as *const _ as usize
        },
        854usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(delta_luma_weight_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).luma_offset_l0 as *const _
                as usize
        },
        869usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(luma_offset_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).delta_chroma_weight_l0
                as *const _ as usize
        },
        884usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(delta_chroma_weight_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).chroma_offset_l0 as *const _
                as usize
        },
        914usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(chroma_offset_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).delta_luma_weight_l1
                as *const _ as usize
        },
        944usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(delta_luma_weight_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).luma_offset_l1 as *const _
                as usize
        },
        959usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(luma_offset_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).delta_chroma_weight_l1
                as *const _ as usize
        },
        974usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(delta_chroma_weight_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).chroma_offset_l1 as *const _
                as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(chroma_offset_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).max_num_merge_cand
                as *const _ as usize
        },
        1034usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(max_num_merge_cand)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).slice_qp_delta as *const _
                as usize
        },
        1035usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(slice_qp_delta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).slice_cb_qp_offset
                as *const _ as usize
        },
        1036usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(slice_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).slice_cr_qp_offset
                as *const _ as usize
        },
        1037usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(slice_cr_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).slice_beta_offset_div2
                as *const _ as usize
        },
        1038usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(slice_beta_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).slice_tc_offset_div2
                as *const _ as usize
        },
        1039usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(slice_tc_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).slice_fields as *const _
                as usize
        },
        1040usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(slice_fields)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).pred_weight_table_bit_offset
                as *const _ as usize
        },
        1044usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(pred_weight_table_bit_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).pred_weight_table_bit_length
                as *const _ as usize
        },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(pred_weight_table_bit_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAEncSliceParameterBufferHEVC>())).va_reserved as *const _
                as usize
        },
        1052usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAEncSliceParameterBufferHEVC),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAEncSliceParameterBufferHEVC = _VAEncSliceParameterBufferHEVC;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _VAQMatrixBufferHEVC {
    pub scaling_lists_4x4: [[[u8; 16usize]; 2usize]; 3usize],
    pub scaling_lists_8x8: [[[u8; 64usize]; 2usize]; 3usize],
    pub scaling_lists_16x16: [[[u8; 64usize]; 2usize]; 3usize],
    pub scaling_lists_32x32: [[u8; 64usize]; 2usize],
    pub scaling_list_dc_16x16: [[u8; 2usize]; 3usize],
    pub scaling_list_dc_32x32: [u8; 2usize],
    pub va_reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout__VAQMatrixBufferHEVC() {
    assert_eq!(
        ::std::mem::size_of::<_VAQMatrixBufferHEVC>(),
        1016usize,
        concat!("Size of: ", stringify!(_VAQMatrixBufferHEVC))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAQMatrixBufferHEVC>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAQMatrixBufferHEVC))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAQMatrixBufferHEVC>())).scaling_lists_4x4 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAQMatrixBufferHEVC),
            "::",
            stringify!(scaling_lists_4x4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAQMatrixBufferHEVC>())).scaling_lists_8x8 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAQMatrixBufferHEVC),
            "::",
            stringify!(scaling_lists_8x8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAQMatrixBufferHEVC>())).scaling_lists_16x16 as *const _
                as usize
        },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAQMatrixBufferHEVC),
            "::",
            stringify!(scaling_lists_16x16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAQMatrixBufferHEVC>())).scaling_lists_32x32 as *const _
                as usize
        },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAQMatrixBufferHEVC),
            "::",
            stringify!(scaling_lists_32x32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAQMatrixBufferHEVC>())).scaling_list_dc_16x16 as *const _
                as usize
        },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAQMatrixBufferHEVC),
            "::",
            stringify!(scaling_list_dc_16x16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAQMatrixBufferHEVC>())).scaling_list_dc_32x32 as *const _
                as usize
        },
        998usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAQMatrixBufferHEVC),
            "::",
            stringify!(scaling_list_dc_32x32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAQMatrixBufferHEVC>())).va_reserved as *const _ as usize
        },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAQMatrixBufferHEVC),
            "::",
            stringify!(va_reserved)
        )
    );
}
pub type VAQMatrixBufferHEVC = _VAQMatrixBufferHEVC;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _VAConfigAttribValStats {
    pub bits: _VAConfigAttribValStats__bindgen_ty_1,
    pub value: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _VAConfigAttribValStats__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout__VAConfigAttribValStats__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValStats__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(_VAConfigAttribValStats__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValStats__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_VAConfigAttribValStats__bindgen_ty_1)
        )
    );
}
impl _VAConfigAttribValStats__bindgen_ty_1 {
    #[inline]
    pub fn max_num_past_references(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_max_num_past_references(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn max_num_future_references(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_max_num_future_references(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn num_outputs(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_num_outputs(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn interlaced(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_interlaced(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        max_num_past_references: u32,
        max_num_future_references: u32,
        num_outputs: u32,
        interlaced: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let max_num_past_references: u32 =
                unsafe { ::std::mem::transmute(max_num_past_references) };
            max_num_past_references as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let max_num_future_references: u32 =
                unsafe { ::std::mem::transmute(max_num_future_references) };
            max_num_future_references as u64
        });
        __bindgen_bitfield_unit.set(8usize, 3u8, {
            let num_outputs: u32 = unsafe { ::std::mem::transmute(num_outputs) };
            num_outputs as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let interlaced: u32 = unsafe { ::std::mem::transmute(interlaced) };
            interlaced as u64
        });
        __bindgen_bitfield_unit.set(12usize, 20u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__VAConfigAttribValStats() {
    assert_eq!(
        ::std::mem::size_of::<_VAConfigAttribValStats>(),
        4usize,
        concat!("Size of: ", stringify!(_VAConfigAttribValStats))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAConfigAttribValStats>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAConfigAttribValStats))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAConfigAttribValStats>())).bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValStats),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAConfigAttribValStats>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAConfigAttribValStats),
            "::",
            stringify!(value)
        )
    );
}
pub type VAConfigAttribValStats = _VAConfigAttribValStats;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAPictureStats {
    pub picture_id: VASurfaceID,
    pub flags: u32,
}
#[test]
fn bindgen_test_layout__VAPictureStats() {
    assert_eq!(
        ::std::mem::size_of::<_VAPictureStats>(),
        8usize,
        concat!("Size of: ", stringify!(_VAPictureStats))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAPictureStats>(),
        4usize,
        concat!("Alignment of ", stringify!(_VAPictureStats))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureStats>())).picture_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureStats),
            "::",
            stringify!(picture_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_VAPictureStats>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAPictureStats),
            "::",
            stringify!(flags)
        )
    );
}
pub type VAPictureStats = _VAPictureStats;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _VAStatsStatisticsParameter {
    pub input: VAPictureStats,
    pub past_references: *mut VAPictureStats,
    pub num_past_references: u32,
    pub past_ref_stat_buf: *mut VABufferID,
    pub future_references: *mut VAPictureStats,
    pub num_future_references: u32,
    pub future_ref_stat_buf: *mut VABufferID,
    pub outputs: *mut VABufferID,
    pub mv_predictor: VABufferID,
    pub qp: VABufferID,
}
#[test]
fn bindgen_test_layout__VAStatsStatisticsParameter() {
    assert_eq!(
        ::std::mem::size_of::<_VAStatsStatisticsParameter>(),
        72usize,
        concat!("Size of: ", stringify!(_VAStatsStatisticsParameter))
    );
    assert_eq!(
        ::std::mem::align_of::<_VAStatsStatisticsParameter>(),
        8usize,
        concat!("Alignment of ", stringify!(_VAStatsStatisticsParameter))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAStatsStatisticsParameter>())).input as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAStatsStatisticsParameter),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_VAStatsStatisticsParameter>())).past_references as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_VAStatsStatisticsParameter),
            "::",
            stringify!(p