/* automatically generated by rust-bindgen 0.58.1 */

// Generated from C headers of Spinnaker 2.4.0.143.

#![allow(
    non_camel_case_types,
    non_upper_case_globals,
    non_snake_case
)]

pub type size_t = ::std::os::raw::c_ulong;
pub type bool8_t = u8;
pub const False: bool8_t = 0;
pub const True: bool8_t = 1;

#[doc = " Handle for system functionality. Created by calling"]
#[doc = " spinSystemGetInstance(), which requires a call to"]
#[doc = " spinSystemReleaseInstance() to release."]
pub type spinSystem = *mut ::std::os::raw::c_void;
#[doc = " Handle for interface list functionality. Created by calling"]
#[doc = " spinSystemGetInterfaces(), which requires a call to"]
#[doc = " spinInterfaceListClear() to clear, or spinInterfaceListCreateEmpty(),"]
#[doc = " which requires a call to spinInterfaceListDestroy() to destroy."]
pub type spinInterfaceList = *mut ::std::os::raw::c_void;
#[doc = " Handle for interface functionality. Created by calling"]
#[doc = " spinInterfaceListGet(), which requires a call to"]
#[doc = " spinInterfaceRelease() to release."]
pub type spinInterface = *mut ::std::os::raw::c_void;
#[doc = " Handle for interface functionality. Created by calling"]
#[doc = " spinSystemGetCameras() or spinInterfaceGetCameras(), which require"]
#[doc = " a call to spinCameraListClear() to clear, or"]
#[doc = " spinCameraListCreateEmpty(), which requires a call to"]
#[doc = " spinCameraListDestroy() to destroy."]
pub type spinCameraList = *mut ::std::os::raw::c_void;
#[doc = " Handle for camera functionality. Created by calling"]
#[doc = " spinCameraListGet(), which requires a call to spinCameraRelease() to"]
#[doc = " release."]
pub type spinCamera = *mut ::std::os::raw::c_void;
#[doc = " Handle for image functionality. Created by calling"]
#[doc = " spinCameraGetNextImage() or spinCameraGetNextImageEx(), which require"]
#[doc = " a call to spinImageRelease() to remove from buffer, or"]
#[doc = " spinImageCreateEmpty(), spinImageCreateEx(), or spinImageCreate(),"]
#[doc = " which require a call to spinImageDestroy() to destroy."]
pub type spinImage = *mut ::std::os::raw::c_void;
#[doc = " Handle for image statistics functionality. Created by calling"]
#[doc = " spinImageStatisticsCreate(), which requires a call to"]
#[doc = " spinImageStatisticsDestroy() to destroy."]
pub type spinImageStatistics = *mut ::std::os::raw::c_void;
#[doc = " Handle for device event handler functionality. Created by calling"]
#[doc = " spinDeviceEventHandlerCreate(), which requires a call to spinDeviceEventHandlerDestroy()"]
#[doc = " to destroy."]
pub type spinDeviceEventHandler = *mut ::std::os::raw::c_void;
#[doc = " Handle for image event handler functionality. Created by calling"]
#[doc = " spinImageEventHandlerCreate(), which requires a call to spinImageEventHandlerDestroy()"]
#[doc = " to destroy."]
pub type spinImageEventHandler = *mut ::std::os::raw::c_void;
#[doc = " Handle for arrival event handler functionality. Created by calling"]
#[doc = " spinArrivalEventCreate(), which requires a call to"]
#[doc = " spinDeviceArrivalEventHandlerDestroy() to destroy."]
pub type spinDeviceArrivalEventHandler = *mut ::std::os::raw::c_void;
#[doc = " Handle for removal event handler functionality. Created by calling"]
#[doc = " spinDeviceRemovalEventHandlerCreate(), which requires a call to"]
#[doc = " spinDeviceRemovalEventHandlerDestroy() to destroy."]
pub type spinDeviceRemovalEventHandler = *mut ::std::os::raw::c_void;
#[doc = " Handle for interface event handler functionality. Created by calling"]
#[doc = " spinInterfaceEventHandlerCreate(), which requires a call to"]
#[doc = " spinInterfaceEventHandlerDestroy() to destroy."]
pub type spinInterfaceEventHandler = *mut ::std::os::raw::c_void;
#[doc = " Handle for logging event handler functionality. Created by calling"]
#[doc = " spinLogEventHandlerCreate(), which requires a call to spinLogEventHandlerDestroy()"]
#[doc = " to destroy."]
pub type spinLogEventHandler = *mut ::std::os::raw::c_void;
#[doc = " Handle for logging event data functionality. Received in log event"]
#[doc = " function. No need to release, clear, or destroy."]
pub type spinLogEventData = *mut ::std::os::raw::c_void;
#[doc = " Handle for device event data functionality. Received in device event"]
#[doc = " function. No need to release, clear, or destroy."]
pub type spinDeviceEventData = *mut ::std::os::raw::c_void;
#[doc = " Handle for video recording functionality. Created by calling"]
#[doc = " spinVideoOpenUncompressed(), spinVideoOpenMJPG(), and"]
#[doc = " spinVideoOpenH264(), which require a call to"]
#[doc = " spinVideoClose() to destroy."]
pub type spinVideo = *mut ::std::os::raw::c_void;
#[doc = " Function signatures are used to create and trigger callbacks and"]
#[doc = " events."]
pub type spinDeviceEventFunction = ::std::option::Option<
    unsafe extern "C" fn(
        hEventData: spinDeviceEventData,
        pEventName: *const ::std::os::raw::c_char,
        pUserData: *mut ::std::os::raw::c_void,
    ),
>;
pub type spinImageEventFunction = ::std::option::Option<
    unsafe extern "C" fn(hImage: spinImage, pUserData: *mut ::std::os::raw::c_void),
>;
pub type spinArrivalEventFunction = ::std::option::Option<
    unsafe extern "C" fn(deviceSerialNumber: u64, pUserData: *mut ::std::os::raw::c_void),
>;
pub type spinRemovalEventFunction = ::std::option::Option<
    unsafe extern "C" fn(deviceSerialNumber: u64, pUserData: *mut ::std::os::raw::c_void),
>;
pub type spinLogEventFunction = ::std::option::Option<
    unsafe extern "C" fn(hEventData: spinLogEventData, pUserData: *mut ::std::os::raw::c_void),
>;
#[doc = " An error code of 0 means that the function has run without error."]
pub const _spinError_SPINNAKER_ERR_SUCCESS: _spinError = 0;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_ERROR: _spinError = -1001;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_NOT_INITIALIZED: _spinError = -1002;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_NOT_IMPLEMENTED: _spinError = -1003;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_RESOURCE_IN_USE: _spinError = -1004;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_ACCESS_DENIED: _spinError = -1005;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_INVALID_HANDLE: _spinError = -1006;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_INVALID_ID: _spinError = -1007;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_NO_DATA: _spinError = -1008;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_INVALID_PARAMETER: _spinError = -1009;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_IO: _spinError = -1010;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_TIMEOUT: _spinError = -1011;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_ABORT: _spinError = -1012;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_INVALID_BUFFER: _spinError = -1013;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_NOT_AVAILABLE: _spinError = -1014;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_INVALID_ADDRESS: _spinError = -1015;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_BUFFER_TOO_SMALL: _spinError = -1016;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_INVALID_INDEX: _spinError = -1017;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_PARSING_CHUNK_DATA: _spinError = -1018;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_INVALID_VALUE: _spinError = -1019;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_RESOURCE_EXHAUSTED: _spinError = -1020;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_OUT_OF_MEMORY: _spinError = -1021;
#[doc = " The error codes in the range of -1000 to -1999 are reserved for"]
#[doc = " Spinnaker exceptions."]
pub const _spinError_SPINNAKER_ERR_BUSY: _spinError = -1022;
#[doc = " The error codes in the range of -2000 to -2999 are reserved for"]
#[doc = " Gen API related errors."]
pub const _spinError_GENICAM_ERR_INVALID_ARGUMENT: _spinError = -2001;
#[doc = " The error codes in the range of -2000 to -2999 are reserved for"]
#[doc = " Gen API related errors."]
pub const _spinError_GENICAM_ERR_OUT_OF_RANGE: _spinError = -2002;
#[doc = " The error codes in the range of -2000 to -2999 are reserved for"]
#[doc = " Gen API related errors."]
pub const _spinError_GENICAM_ERR_PROPERTY: _spinError = -2003;
#[doc = " The error codes in the range of -2000 to -2999 are reserved for"]
#[doc = " Gen API related errors."]
pub const _spinError_GENICAM_ERR_RUN_TIME: _spinError = -2004;
#[doc = " The error codes in the range of -2000 to -2999 are reserved for"]
#[doc = " Gen API related errors."]
pub const _spinError_GENICAM_ERR_LOGICAL: _spinError = -2005;
#[doc = " The error codes in the range of -2000 to -2999 are reserved for"]
#[doc = " Gen API related errors."]
pub const _spinError_GENICAM_ERR_ACCESS: _spinError = -2006;
#[doc = " The error codes in the range of -2000 to -2999 are reserved for"]
#[doc = " Gen API related errors."]
pub const _spinError_GENICAM_ERR_TIMEOUT: _spinError = -2007;
#[doc = " The error codes in the range of -2000 to -2999 are reserved for"]
#[doc = " Gen API related errors."]
pub const _spinError_GENICAM_ERR_DYNAMIC_CAST: _spinError = -2008;
#[doc = " The error codes in the range of -2000 to -2999 are reserved for"]
#[doc = " Gen API related errors."]
pub const _spinError_GENICAM_ERR_GENERIC: _spinError = -2009;
#[doc = " The error codes in the range of -2000 to -2999 are reserved for"]
#[doc = " Gen API related errors."]
pub const _spinError_GENICAM_ERR_BAD_ALLOCATION: _spinError = -2010;
#[doc = " The error codes in the range of -3000 to -3999 are reserved for"]
#[doc = " image processing related errors."]
pub const _spinError_SPINNAKER_ERR_IM_CONVERT: _spinError = -3001;
#[doc = " The error codes in the range of -3000 to -3999 are reserved for"]
#[doc = " image processing related errors."]
pub const _spinError_SPINNAKER_ERR_IM_COPY: _spinError = -3002;
#[doc = " The error codes in the range of -3000 to -3999 are reserved for"]
#[doc = " image processing related errors."]
pub const _spinError_SPINNAKER_ERR_IM_MALLOC: _spinError = -3003;
#[doc = " The error codes in the range of -3000 to -3999 are reserved for"]
#[doc = " image processing related errors."]
pub const _spinError_SPINNAKER_ERR_IM_NOT_SUPPORTED: _spinError = -3004;
#[doc = " The error codes in the range of -3000 to -3999 are reserved for"]
#[doc = " image processing related errors."]
pub const _spinError_SPINNAKER_ERR_IM_HISTOGRAM_RANGE: _spinError = -3005;
#[doc = " The error codes in the range of -3000 to -3999 are reserved for"]
#[doc = " image processing related errors."]
pub const _spinError_SPINNAKER_ERR_IM_HISTOGRAM_MEAN: _spinError = -3006;
#[doc = " The error codes in the range of -3000 to -3999 are reserved for"]
#[doc = " image processing related errors."]
pub const _spinError_SPINNAKER_ERR_IM_MIN_MAX: _spinError = -3007;
#[doc = " The error codes in the range of -3000 to -3999 are reserved for"]
#[doc = " image processing related errors."]
pub const _spinError_SPINNAKER_ERR_IM_COLOR_CONVERSION: _spinError = -3008;
#[doc = " Error codes less than -10000 are reserved for user-defined custom"]
#[doc = " errors."]
pub const _spinError_SPINNAKER_ERR_CUSTOM_ID: _spinError = -10000;
#[doc = " The error codes in the range of -2000 to -2999 are reserved"]
#[doc = " for GenICam related errors.  The error codes in the range of -3000 to -3999"]
#[doc = " are reserved for image processing related errors."]
pub type _spinError = ::std::os::raw::c_int;
#[doc = " The error codes in the range of -2000 to -2999 are reserved"]
#[doc = " for GenICam related errors.  The error codes in the range of -3000 to -3999"]
#[doc = " are reserved for image processing related errors."]
pub use self::_spinError as spinError;
#[doc = " Default method."]
pub const _spinColorProcessingAlgorithm_DEFAULT: _spinColorProcessingAlgorithm = 0;
#[doc = " No color processing."]
pub const _spinColorProcessingAlgorithm_NO_COLOR_PROCESSING: _spinColorProcessingAlgorithm = 1;
#[doc = " Fastest but lowest quality. Equivalent to"]
#[doc = " FLYCAPTURE_NEAREST_NEIGHBOR_FAST in FlyCapture."]
pub const _spinColorProcessingAlgorithm_NEAREST_NEIGHBOR: _spinColorProcessingAlgorithm = 2;
#[doc = " Nearest Neighbor with averaged green pixels. Higher quality but slower"]
#[doc = " compared to nearest neighbor without averaging."]
pub const _spinColorProcessingAlgorithm_NEAREST_NEIGHBOR_AVG: _spinColorProcessingAlgorithm = 3;
#[doc = " Weighted average of surrounding 4 pixels in a 2x2 neighborhood."]
pub const _spinColorProcessingAlgorithm_BILINEAR: _spinColorProcessingAlgorithm = 4;
#[doc = " Weights surrounding pixels based on localized edge orientation."]
pub const _spinColorProcessingAlgorithm_EDGE_SENSING: _spinColorProcessingAlgorithm = 5;
#[doc = " Well-balanced speed and quality."]
pub const _spinColorProcessingAlgorithm_HQ_LINEAR: _spinColorProcessingAlgorithm = 6;
#[doc = " Multi-threaded with similar results to edge sensing."]
pub const _spinColorProcessingAlgorithm_IPP: _spinColorProcessingAlgorithm = 7;
#[doc = " Best quality but much faster than rigorous."]
pub const _spinColorProcessingAlgorithm_DIRECTIONAL_FILTER: _spinColorProcessingAlgorithm = 8;
#[doc = " Slowest but produces good results."]
pub const _spinColorProcessingAlgorithm_RIGOROUS: _spinColorProcessingAlgorithm = 9;
#[doc = " Weighted pixel average from different directions."]
pub const _spinColorProcessingAlgorithm_WEIGHTED_DIRECTIONAL_FILTER: _spinColorProcessingAlgorithm =
    10;
#[doc = " Color processing algorithms. Please refer to our knowledge base at"]
#[doc = " article at"]
#[doc = " https://www.flir.com/support-center/iis/machine-vision/knowledge-base/different-color-processing-algorithms-in-flycapture2"]
#[doc = " for complete details for each algorithm."]
pub type _spinColorProcessingAlgorithm = ::std::os::raw::c_uint;
#[doc = " Color processing algorithms. Please refer to our knowledge base at"]
#[doc = " article at"]
#[doc = " https://www.flir.com/support-center/iis/machine-vision/knowledge-base/different-color-processing-algorithms-in-flycapture2"]
#[doc = " for complete details for each algorithm."]
pub use self::_spinColorProcessingAlgorithm as spinColorProcessingAlgorithm;
pub const _spinStatisticsChannel_GREY: _spinStatisticsChannel = 0;
pub const _spinStatisticsChannel_RED: _spinStatisticsChannel = 1;
pub const _spinStatisticsChannel_GREEN: _spinStatisticsChannel = 2;
pub const _spinStatisticsChannel_BLUE: _spinStatisticsChannel = 3;
pub const _spinStatisticsChannel_HUE: _spinStatisticsChannel = 4;
pub const _spinStatisticsChannel_SATURATION: _spinStatisticsChannel = 5;
pub const _spinStatisticsChannel_LIGHTNESS: _spinStatisticsChannel = 6;
pub const _spinStatisticsChannel_NUM_STATISTICS_CHANNELS: _spinStatisticsChannel = 7;
#[doc = " Channels that allow statistics to be calculated."]
pub type _spinStatisticsChannel = ::std::os::raw::c_uint;
#[doc = " Channels that allow statistics to be calculated."]
pub use self::_spinStatisticsChannel as spinStatisticsChannel;
#[doc = "< Determine file format from file extension."]
pub const _spinImageFileFormat_FROM_FILE_EXT: _spinImageFileFormat = -1;
#[doc = "< Portable gray map."]
pub const _spinImageFileFormat_PGM: _spinImageFileFormat = 0;
#[doc = "< Portable pixmap."]
pub const _spinImageFileFormat_PPM: _spinImageFileFormat = 1;
#[doc = "< Bitmap."]
pub const _spinImageFileFormat_BMP: _spinImageFileFormat = 2;
#[doc = "< JPEG."]
pub const _spinImageFileFormat_JPEG: _spinImageFileFormat = 3;
#[doc = "< JPEG 2000."]
pub const _spinImageFileFormat_JPEG2000: _spinImageFileFormat = 4;
#[doc = "< Tagged image file format."]
pub const _spinImageFileFormat_TIFF: _spinImageFileFormat = 5;
#[doc = "< Portable network graphics."]
pub const _spinImageFileFormat_PNG: _spinImageFileFormat = 6;
#[doc = "< Raw data."]
pub const _spinImageFileFormat_RAW: _spinImageFileFormat = 7;
pub const _spinImageFileFormat_IMAGE_FILE_FORMAT_FORCE_32BITS: _spinImageFileFormat = 2147483647;
#[doc = " File formats to be used for saving images to disk."]
pub type _spinImageFileFormat = ::std::os::raw::c_int;
#[doc = " File formats to be used for saving images to disk."]
pub use self::_spinImageFileFormat as spinImageFileFormat;
pub const _spinPixelFormatNamespaceID_SPINNAKER_PIXELFORMAT_NAMESPACE_UNKNOWN:
    _spinPixelFormatNamespaceID = 0;
pub const _spinPixelFormatNamespaceID_SPINNAKER_PIXELFORMAT_NAMESPACE_GEV:
    _spinPixelFormatNamespaceID = 1;
pub const _spinPixelFormatNamespaceID_SPINNAKER_PIXELFORMAT_NAMESPACE_IIDC:
    _spinPixelFormatNamespaceID = 2;
pub const _spinPixelFormatNamespaceID_SPINNAKER_PIXELFORMAT_NAMESPACE_PFNC_16BIT:
    _spinPixelFormatNamespaceID = 3;
pub const _spinPixelFormatNamespaceID_SPINNAKER_PIXELFORMAT_NAMESPACE_PFNC_32BIT:
    _spinPixelFormatNamespaceID = 4;
pub const _spinPixelFormatNamespaceID_SPINNAKER_PIXELFORMAT_NAMESPACE_CUSTOM_ID:
    _spinPixelFormatNamespaceID = 1000;
#[doc = " This enum represents the namespace in which the TL specific pixel format"]
#[doc = " resides. This enum is returned from a captured image when calling"]
#[doc = " spinImageGetTLPixelFormatNamespace().  It can be used to interpret the raw"]
#[doc = " pixel format returned from spinImageGetTLPixelFormat()."]
#[doc = ""]
#[doc = " @see spinImageGetTLPixelFormat()"]
#[doc = ""]
#[doc = " @see spinImageGetTLPixelFormatNamespace()"]
pub type _spinPixelFormatNamespaceID = ::std::os::raw::c_uint;
#[doc = " This enum represents the namespace in which the TL specific pixel format"]
#[doc = " resides. This enum is returned from a captured image when calling"]
#[doc = " spinImageGetTLPixelFormatNamespace().  It can be used to interpret the raw"]
#[doc = " pixel format returned from spinImageGetTLPixelFormat()."]
#[doc = ""]
#[doc = " @see spinImageGetTLPixelFormat()"]
#[doc = ""]
#[doc = " @see spinImageGetTLPixelFormatNamespace()"]
pub use self::_spinPixelFormatNamespaceID as spinPixelFormatNamespaceID;
#[doc = "< Image has an unknown error."]
pub const _spinImageStatus_IMAGE_UNKNOWN_ERROR: _spinImageStatus = -1;
#[doc = "< Image is returned from GetNextImage() call without any errors."]
pub const _spinImageStatus_IMAGE_NO_ERROR: _spinImageStatus = 0;
#[doc = "< Image failed CRC check."]
pub const _spinImageStatus_IMAGE_CRC_CHECK_FAILED: _spinImageStatus = 1;
#[doc = "< Received more data than the size of the image."]
pub const _spinImageStatus_IMAGE_DATA_OVERFLOW: _spinImageStatus = 2;
pub const _spinImageStatus_IMAGE_MISSING_PACKETS: _spinImageStatus = 3;
pub const _spinImageStatus_IMAGE_LEADER_BUFFER_SIZE_INCONSISTENT: _spinImageStatus = 4;
pub const _spinImageStatus_IMAGE_TRAILER_BUFFER_SIZE_INCONSISTENT: _spinImageStatus = 5;
pub const _spinImageStatus_IMAGE_PACKETID_INCONSISTENT: _spinImageStatus = 6;
#[doc = "< Image leader is missing. Could be caused by missing packet(s). See link above."]
pub const _spinImageStatus_IMAGE_MISSING_LEADER: _spinImageStatus = 7;
#[doc = "< Image trailer is missing. Could be caused by missing packet(s). See link above."]
pub const _spinImageStatus_IMAGE_MISSING_TRAILER: _spinImageStatus = 8;
#[doc = "< Image data is incomplete. Could be caused by missing packet(s). See link above."]
pub const _spinImageStatus_IMAGE_DATA_INCOMPLETE: _spinImageStatus = 9;
#[doc = "< Image info is corrupted. Could be caused by missing packet(s). See link above."]
pub const _spinImageStatus_IMAGE_INFO_INCONSISTENT: _spinImageStatus = 10;
#[doc = "< Image chunk data is invalid"]
pub const _spinImageStatus_IMAGE_CHUNK_DATA_INVALID: _spinImageStatus = 11;
#[doc = "< Image cannot be processed due to lack of system"]
#[doc = "resources."]
pub const _spinImageStatus_IMAGE_NO_SYSTEM_RESOURCES: _spinImageStatus = 12;
#[doc = " Status of images returned from spinImageGetStatus() call."]
pub type _spinImageStatus = ::std::os::raw::c_int;
#[doc = " Status of images returned from spinImageGetStatus() call."]
pub use self::_spinImageStatus as spinImageStatus;
pub const _spinLogLevel_LOG_LEVEL_OFF: _spinLogLevel = -1;
pub const _spinLogLevel_LOG_LEVEL_FATAL: _spinLogLevel = 0;
pub const _spinLogLevel_LOG_LEVEL_ALERT: _spinLogLevel = 100;
pub const _spinLogLevel_LOG_LEVEL_CRIT: _spinLogLevel = 200;
pub const _spinLogLevel_LOG_LEVEL_ERROR: _spinLogLevel = 300;
pub const _spinLogLevel_LOG_LEVEL_WARN: _spinLogLevel = 400;
pub const _spinLogLevel_LOG_LEVEL_NOTICE: _spinLogLevel = 500;
pub const _spinLogLevel_LOG_LEVEL_INFO: _spinLogLevel = 600;
pub const _spinLogLevel_LOG_LEVEL_DEBUG: _spinLogLevel = 700;
pub const _spinLogLevel_LOG_LEVEL_NOTSET: _spinLogLevel = 800;
#[doc = " log levels"]
pub type _spinLogLevel = ::std::os::raw::c_int;
#[doc = " log levels"]
pub use self::_spinLogLevel as spinnakerLogLevel;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_UNKNOWN: _spinPayloadTypeInfoIDs = 0;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_IMAGE: _spinPayloadTypeInfoIDs = 1;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_RAW_DATA: _spinPayloadTypeInfoIDs = 2;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_FILE: _spinPayloadTypeInfoIDs = 3;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_CHUNK_DATA: _spinPayloadTypeInfoIDs = 4;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_JPEG: _spinPayloadTypeInfoIDs = 5;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_JPEG2000: _spinPayloadTypeInfoIDs = 6;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_H264: _spinPayloadTypeInfoIDs = 7;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_CHUNK_ONLY: _spinPayloadTypeInfoIDs = 8;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_DEVICE_SPECIFIC: _spinPayloadTypeInfoIDs = 9;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_MULTI_PART: _spinPayloadTypeInfoIDs = 10;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_CUSTOM_ID: _spinPayloadTypeInfoIDs = 1000;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_EXTENDED_CHUNK: _spinPayloadTypeInfoIDs = 1001;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_LOSSLESS_COMPRESSED: _spinPayloadTypeInfoIDs = 1002;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_LOSSY_COMPRESSED: _spinPayloadTypeInfoIDs = 1003;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_JPEG_LOSSLESS_COMPRESSED: _spinPayloadTypeInfoIDs =
    1004;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_CHUNK_DATA_LOSSLESS_COMPRESSED:
    _spinPayloadTypeInfoIDs = 1005;
pub const _spinPayloadTypeInfoIDs_PAYLOAD_TYPE_CHUNK_DATA_LOSSY_COMPRESSED:
    _spinPayloadTypeInfoIDs = 1006;
pub type _spinPayloadTypeInfoIDs = ::std::os::raw::c_uint;
pub use self::_spinPayloadTypeInfoIDs as spinPayloadTypeInfoIDs;
#[doc = " Options for saving PNG images. Used in saving PNG images"]
#[doc = " with a call to spinImageSavePng()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _spinPNGOption {
    #[doc = " Whether to save the PNG as interlaced."]
    pub interlaced: bool8_t,
    #[doc = " Compression level (0-9). 0 is no compression, 9 is best compression."]
    pub compressionLevel: ::std::os::raw::c_uint,
    #[doc = " Reserved for future use."]
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[test]
fn bindgen_test_layout__spinPNGOption() {
    assert_eq!(
        ::std::mem::size_of::<_spinPNGOption>(),
        72usize,
        concat!("Size of: ", stringify!(_spinPNGOption))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinPNGOption>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinPNGOption))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinPNGOption>())).interlaced as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinPNGOption),
            "::",
            stringify!(interlaced)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinPNGOption>())).compressionLevel as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinPNGOption),
            "::",
            stringify!(compressionLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinPNGOption>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinPNGOption),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Options for saving PNG images. Used in saving PNG images"]
#[doc = " with a call to spinImageSavePng()."]
pub type spinPNGOption = _spinPNGOption;
#[doc = " Options for saving PPM images. Used in saving PPM images"]
#[doc = " with a call to spinImageSavePpm()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _spinPPMOption {
    #[doc = " Whether to save the PPM as a binary file."]
    pub binaryFile: bool8_t,
    #[doc = " Reserved for future use."]
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[test]
fn bindgen_test_layout__spinPPMOption() {
    assert_eq!(
        ::std::mem::size_of::<_spinPPMOption>(),
        68usize,
        concat!("Size of: ", stringify!(_spinPPMOption))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinPPMOption>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinPPMOption))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinPPMOption>())).binaryFile as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinPPMOption),
            "::",
            stringify!(binaryFile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinPPMOption>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinPPMOption),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Options for saving PPM images. Used in saving PPM images"]
#[doc = " with a call to spinImageSavePpm()."]
pub type spinPPMOption = _spinPPMOption;
#[doc = " Options for saving PGM images."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _spinPGMOption {
    #[doc = " Whether to save the PPM as a binary file."]
    pub binaryFile: bool8_t,
    #[doc = " Reserved for future use."]
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[test]
fn bindgen_test_layout__spinPGMOption() {
    assert_eq!(
        ::std::mem::size_of::<_spinPGMOption>(),
        68usize,
        concat!("Size of: ", stringify!(_spinPGMOption))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinPGMOption>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinPGMOption))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinPGMOption>())).binaryFile as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinPGMOption),
            "::",
            stringify!(binaryFile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinPGMOption>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinPGMOption),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Options for saving PGM images."]
pub type spinPGMOption = _spinPGMOption;
pub const CompressionMethod_NONE: CompressionMethod = 1;
pub const CompressionMethod_PACKBITS: CompressionMethod = 2;
pub const CompressionMethod_DEFLATE: CompressionMethod = 3;
pub const CompressionMethod_ADOBE_DEFLATE: CompressionMethod = 4;
pub const CompressionMethod_CCITTFAX3: CompressionMethod = 5;
pub const CompressionMethod_CCITTFAX4: CompressionMethod = 6;
pub const CompressionMethod_LZW: CompressionMethod = 7;
pub const CompressionMethod_JPG: CompressionMethod = 8;
#[doc = " Compression method used in saving TIFF images in the spinTIFFOption struct."]
pub type CompressionMethod = ::std::os::raw::c_uint;
#[doc = " Compression method used in saving TIFF images in the spinTIFFOption struct."]
pub use self::CompressionMethod as spinCompressionMethod;
#[doc = " Options for saving TIFF images. Used in saving PPM images"]
#[doc = " with a call to spinImageSaveTiff()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _spinTIFFOption {
    #[doc = " Compression method to use for encoding TIFF images."]
    pub compression: spinCompressionMethod,
    #[doc = " Reserved for future use."]
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[test]
fn bindgen_test_layout__spinTIFFOption() {
    assert_eq!(
        ::std::mem::size_of::<_spinTIFFOption>(),
        68usize,
        concat!("Size of: ", stringify!(_spinTIFFOption))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinTIFFOption>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinTIFFOption))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinTIFFOption>())).compression as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinTIFFOption),
            "::",
            stringify!(compression)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinTIFFOption>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinTIFFOption),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Options for saving TIFF images. Used in saving PPM images"]
#[doc = " with a call to spinImageSaveTiff()."]
pub type spinTIFFOption = _spinTIFFOption;
#[doc = " Options for saving JPEG images. Used in saving PPM images"]
#[doc = " with a call to spinImageSaveJpeg()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _spinJPEGOption {
    #[doc = " Whether to save as a progressive JPEG file."]
    pub progressive: bool8_t,
    #[doc = " JPEG image quality in range (0-100)."]
    #[doc = " - 100 - Superb quality."]
    #[doc = " - 75  - Good quality."]
    #[doc = " - 50  - Normal quality."]
    #[doc = " - 10  - Poor quality."]
    pub quality: ::std::os::raw::c_uint,
    #[doc = " Reserved for future use."]
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[test]
fn bindgen_test_layout__spinJPEGOption() {
    assert_eq!(
        ::std::mem::size_of::<_spinJPEGOption>(),
        72usize,
        concat!("Size of: ", stringify!(_spinJPEGOption))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinJPEGOption>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinJPEGOption))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinJPEGOption>())).progressive as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinJPEGOption),
            "::",
            stringify!(progressive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinJPEGOption>())).quality as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinJPEGOption),
            "::",
            stringify!(quality)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinJPEGOption>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinJPEGOption),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Options for saving JPEG images. Used in saving PPM images"]
#[doc = " with a call to spinImageSaveJpeg()."]
pub type spinJPEGOption = _spinJPEGOption;
#[doc = " Options for saving JPEG 2000 images. Used in saving PPM images"]
#[doc = " with a call to spinImageSaveJpg2()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _spinJPG2Option {
    #[doc = " JPEG saving quality in range (1-512)."]
    pub quality: ::std::os::raw::c_uint,
    #[doc = " Reserved for future use."]
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[test]
fn bindgen_test_layout__spinJPG2Option() {
    assert_eq!(
        ::std::mem::size_of::<_spinJPG2Option>(),
        68usize,
        concat!("Size of: ", stringify!(_spinJPG2Option))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinJPG2Option>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinJPG2Option))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinJPG2Option>())).quality as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinJPG2Option),
            "::",
            stringify!(quality)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinJPG2Option>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinJPG2Option),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Options for saving JPEG 2000 images. Used in saving PPM images"]
#[doc = " with a call to spinImageSaveJpg2()."]
pub type spinJPG2Option = _spinJPG2Option;
#[doc = " Options for saving BMP images. Used in saving PPM images"]
#[doc = " with a call to spinImageSaveBmp()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _spinBMPOption {
    pub indexedColor_8bit: bool8_t,
    #[doc = " Reserved for future use."]
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[test]
fn bindgen_test_layout__spinBMPOption() {
    assert_eq!(
        ::std::mem::size_of::<_spinBMPOption>(),
        68usize,
        concat!("Size of: ", stringify!(_spinBMPOption))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinBMPOption>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinBMPOption))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinBMPOption>())).indexedColor_8bit as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinBMPOption),
            "::",
            stringify!(indexedColor_8bit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinBMPOption>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinBMPOption),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Options for saving BMP images. Used in saving PPM images"]
#[doc = " with a call to spinImageSaveBmp()."]
pub type spinBMPOption = _spinBMPOption;
#[doc = " Options for saving MJPG videos. Used in saving MJPG videos"]
#[doc = " with a call to spinAVIRecorderOpenMJPG()."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _spinMJPGOption {
    #[doc = " Frame rate of the stream"]
    pub frameRate: f32,
    #[doc = " Image quality (1-100)"]
    pub quality: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uint; 256usize],
}
#[test]
fn bindgen_test_layout__spinMJPGOption() {
    assert_eq!(
        ::std::mem::size_of::<_spinMJPGOption>(),
        1032usize,
        concat!("Size of: ", stringify!(_spinMJPGOption))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinMJPGOption>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinMJPGOption))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinMJPGOption>())).frameRate as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinMJPGOption),
            "::",
            stringify!(frameRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinMJPGOption>())).quality as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinMJPGOption),
            "::",
            stringify!(quality)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinMJPGOption>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinMJPGOption),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Options for saving MJPG videos. Used in saving MJPG videos"]
#[doc = " with a call to spinAVIRecorderOpenMJPG()."]
pub type spinMJPGOption = _spinMJPGOption;
#[doc = " Options for saving H264 videos. Used in saving H264 videos"]
#[doc = " with a call to spinAVIRecorderOpenH264()."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _spinH264Option {
    #[doc = " Frame rate of the stream"]
    pub frameRate: f32,
    #[doc = " Width of source image"]
    pub width: ::std::os::raw::c_uint,
    #[doc = " Height of source image"]
    pub height: ::std::os::raw::c_uint,
    #[doc = " Bitrate to encode at"]
    pub bitrate: ::std::os::raw::c_uint,
    #[doc = " Reserved for future use"]
    pub reserved: [::std::os::raw::c_uint; 256usize],
}
#[test]
fn bindgen_test_layout__spinH264Option() {
    assert_eq!(
        ::std::mem::size_of::<_spinH264Option>(),
        1040usize,
        concat!("Size of: ", stringify!(_spinH264Option))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinH264Option>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinH264Option))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinH264Option>())).frameRate as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinH264Option),
            "::",
            stringify!(frameRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinH264Option>())).width as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinH264Option),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinH264Option>())).height as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinH264Option),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinH264Option>())).bitrate as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinH264Option),
            "::",
            stringify!(bitrate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinH264Option>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinH264Option),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Options for saving H264 videos. Used in saving H264 videos"]
#[doc = " with a call to spinAVIRecorderOpenH264()."]
pub type spinH264Option = _spinH264Option;
#[doc = " Options for saving uncompressed videos. Used in saving AVI videos"]
#[doc = " with a call to spinAVIRecorderOpenUncompressed()."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _spinAVIOption {
    #[doc = " Frame rate of the stream"]
    pub frameRate: f32,
    #[doc = " Reserved for future use"]
    pub reserved: [::std::os::raw::c_uint; 256usize],
}
#[test]
fn bindgen_test_layout__spinAVIOption() {
    assert_eq!(
        ::std::mem::size_of::<_spinAVIOption>(),
        1028usize,
        concat!("Size of: ", stringify!(_spinAVIOption))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinAVIOption>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinAVIOption))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinAVIOption>())).frameRate as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinAVIOption),
            "::",
            stringify!(frameRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinAVIOption>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinAVIOption),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Options for saving uncompressed videos. Used in saving AVI videos"]
#[doc = " with a call to spinAVIRecorderOpenUncompressed()."]
pub type spinAVIOption = _spinAVIOption;
#[doc = " Provides easier access to the current version of Spinnaker."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _spinLibraryVersion {
    #[doc = " Major version of the library"]
    pub major: ::std::os::raw::c_uint,
    #[doc = " Minor version of the library"]
    pub minor: ::std::os::raw::c_uint,
    #[doc = " Version type of the library"]
    pub type_: ::std::os::raw::c_uint,
    #[doc = " Build number of the library"]
    pub build: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout__spinLibraryVersion() {
    assert_eq!(
        ::std::mem::size_of::<_spinLibraryVersion>(),
        16usize,
        concat!("Size of: ", stringify!(_spinLibraryVersion))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinLibraryVersion>(),
        4usize,
        concat!("Alignment of ", stringify!(_spinLibraryVersion))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinLibraryVersion>())).major as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinLibraryVersion),
            "::",
            stringify!(major)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinLibraryVersion>())).minor as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinLibraryVersion),
            "::",
            stringify!(minor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinLibraryVersion>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinLibraryVersion),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinLibraryVersion>())).build as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinLibraryVersion),
            "::",
            stringify!(build)
        )
    );
}
#[doc = " Provides easier access to the current version of Spinnaker."]
pub type spinLibraryVersion = _spinLibraryVersion;
#[doc = " The device acknowledged the command."]
pub const _actionCommandStatus_ACTION_COMMAND_STATUS_OK: _actionCommandStatus = 0;
#[doc = " The device acknowledged the command."]
pub const _actionCommandStatus_ACTION_COMMAND_STATUS_NO_REF_TIME: _actionCommandStatus = 32787;
#[doc = " The device acknowledged the command."]
pub const _actionCommandStatus_ACTION_COMMAND_STATUS_OVERFLOW: _actionCommandStatus = 32789;
#[doc = " The device acknowledged the command."]
pub const _actionCommandStatus_ACTION_COMMAND_STATUS_ACTION_LATE: _actionCommandStatus = 32790;
#[doc = " The device acknowledged the command."]
pub const _actionCommandStatus_ACTION_COMMAND_STATUS_ERROR: _actionCommandStatus = 36863;
#[doc = " Possible Status Codes Returned from Action Command."]
pub type _actionCommandStatus = ::std::os::raw::c_uint;
#[doc = " Possible Status Codes Returned from Action Command."]
pub use self::_actionCommandStatus as actionCommandStatus;
#[doc = " Action Command Result."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _actionCommandResult {
    pub DeviceAddress: ::std::os::raw::c_uint,
    pub Status: actionCommandStatus,
}
#[test]
fn bindgen_test_layout__actionCommandResult() {
    assert_eq!(
        ::std::mem::size_of::<_actionCommandResult>(),
        8usize,
        concat!("Size of: ", stringify!(_actionCommandResult))
    );
    assert_eq!(
        ::std::mem::align_of::<_actionCommandResult>(),
        4usize,
        concat!("Alignment of ", stringify!(_actionCommandResult))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_actionCommandResult>())).DeviceAddress as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_actionCommandResult),
            "::",
            stringify!(DeviceAddress)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_actionCommandResult>())).Status as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_actionCommandResult),
            "::",
            stringify!(Status)
        )
    );
}
#[doc = " Action Command Result."]
pub type actionCommandResult = _actionCommandResult;
#[doc = "<"]
#[doc = "This LUT is for re-mapping pixels of all formats"]
#[doc = "(mono, Bayer, red, green and blue)."]
pub const _spinLUTSelectorEnums_LUTSelector_LUT1: _spinLUTSelectorEnums = 0;
pub const _spinLUTSelectorEnums_NUM_LUTSELECTOR: _spinLUTSelectorEnums = 1;
#[doc = "@brief The enum definitions for camera nodes."]
pub type _spinLUTSelectorEnums = ::std::os::raw::c_uint;
#[doc = "@brief The enum definitions for camera nodes."]
pub use self::_spinLUTSelectorEnums as spinLUTSelectorEnums;
#[doc = "<"]
#[doc = "Timed exposure. The exposure time is set using the"]
#[doc = "ExposureTime or ExposureAuto features and the exposure starts with the"]
#[doc = "FrameStart or LineStart."]
pub const _spinExposureModeEnums_ExposureMode_Timed: _spinExposureModeEnums = 0;
#[doc = "<"]
#[doc = "Uses the width of the current Frame trigger signal pulse to control the"]
#[doc = "exposure time."]
pub const _spinExposureModeEnums_ExposureMode_TriggerWidth: _spinExposureModeEnums = 1;
pub const _spinExposureModeEnums_NUM_EXPOSUREMODE: _spinExposureModeEnums = 2;
pub type _spinExposureModeEnums = ::std::os::raw::c_uint;
pub use self::_spinExposureModeEnums as spinExposureModeEnums;
#[doc = "<"]
pub const _spinAcquisitionModeEnums_AcquisitionMode_Continuous: _spinAcquisitionModeEnums = 0;
#[doc = "<"]
pub const _spinAcquisitionModeEnums_AcquisitionMode_SingleFrame: _spinAcquisitionModeEnums = 1;
#[doc = "<"]
pub const _spinAcquisitionModeEnums_AcquisitionMode_MultiFrame: _spinAcquisitionModeEnums = 2;
pub const _spinAcquisitionModeEnums_NUM_ACQUISITIONMODE: _spinAcquisitionModeEnums = 3;
pub type _spinAcquisitionModeEnums = ::std::os::raw::c_uint;
pub use self::_spinAcquisitionModeEnums as spinAcquisitionModeEnums;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_Software: _spinTriggerSourceEnums = 0;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_Line0: _spinTriggerSourceEnums = 1;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_Line1: _spinTriggerSourceEnums = 2;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_Line2: _spinTriggerSourceEnums = 3;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_Line3: _spinTriggerSourceEnums = 4;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_UserOutput0: _spinTriggerSourceEnums = 5;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_UserOutput1: _spinTriggerSourceEnums = 6;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_UserOutput2: _spinTriggerSourceEnums = 7;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_UserOutput3: _spinTriggerSourceEnums = 8;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_Counter0Start: _spinTriggerSourceEnums = 9;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_Counter1Start: _spinTriggerSourceEnums = 10;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_Counter0End: _spinTriggerSourceEnums = 11;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_Counter1End: _spinTriggerSourceEnums = 12;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_LogicBlock0: _spinTriggerSourceEnums = 13;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_LogicBlock1: _spinTriggerSourceEnums = 14;
#[doc = "<"]
pub const _spinTriggerSourceEnums_TriggerSource_Action0: _spinTriggerSourceEnums = 15;
pub const _spinTriggerSourceEnums_NUM_TRIGGERSOURCE: _spinTriggerSourceEnums = 16;
pub type _spinTriggerSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinTriggerSourceEnums as spinTriggerSourceEnums;
#[doc = "<"]
pub const _spinTriggerActivationEnums_TriggerActivation_LevelLow: _spinTriggerActivationEnums = 0;
#[doc = "<"]
pub const _spinTriggerActivationEnums_TriggerActivation_LevelHigh: _spinTriggerActivationEnums = 1;
#[doc = "<"]
pub const _spinTriggerActivationEnums_TriggerActivation_FallingEdge: _spinTriggerActivationEnums =
    2;
#[doc = "<"]
pub const _spinTriggerActivationEnums_TriggerActivation_RisingEdge: _spinTriggerActivationEnums = 3;
#[doc = "<"]
pub const _spinTriggerActivationEnums_TriggerActivation_AnyEdge: _spinTriggerActivationEnums = 4;
pub const _spinTriggerActivationEnums_NUM_TRIGGERACTIVATION: _spinTriggerActivationEnums = 5;
pub type _spinTriggerActivationEnums = ::std::os::raw::c_uint;
pub use self::_spinTriggerActivationEnums as spinTriggerActivationEnums;
#[doc = "<"]
#[doc = "The shutter opens and closes at the same time for all pixels."]
#[doc = "All the pixels are exposed for the same length of time at the same time."]
pub const _spinSensorShutterModeEnums_SensorShutterMode_Global: _spinSensorShutterModeEnums = 0;
#[doc = "<"]
#[doc = "The shutter opens and closes sequentially for groups (typically lines) of pixels."]
#[doc = "All the pixels are exposed for the same length of time but not at the same time."]
pub const _spinSensorShutterModeEnums_SensorShutterMode_Rolling: _spinSensorShutterModeEnums = 1;
#[doc = "<"]
#[doc = "The shutter opens at the same time for all pixels but ends in a sequential manner."]
#[doc = "The pixels are exposed for different lengths of time."]
pub const _spinSensorShutterModeEnums_SensorShutterMode_GlobalReset: _spinSensorShutterModeEnums =
    2;
pub const _spinSensorShutterModeEnums_NUM_SENSORSHUTTERMODE: _spinSensorShutterModeEnums = 3;
pub type _spinSensorShutterModeEnums = ::std::os::raw::c_uint;
pub use self::_spinSensorShutterModeEnums as spinSensorShutterModeEnums;
#[doc = "<"]
pub const _spinTriggerModeEnums_TriggerMode_Off: _spinTriggerModeEnums = 0;
#[doc = "<"]
pub const _spinTriggerModeEnums_TriggerMode_On: _spinTriggerModeEnums = 1;
pub const _spinTriggerModeEnums_NUM_TRIGGERMODE: _spinTriggerModeEnums = 2;
pub type _spinTriggerModeEnums = ::std::os::raw::c_uint;
pub use self::_spinTriggerModeEnums as spinTriggerModeEnums;
#[doc = "<"]
pub const _spinTriggerOverlapEnums_TriggerOverlap_Off: _spinTriggerOverlapEnums = 0;
#[doc = "<"]
pub const _spinTriggerOverlapEnums_TriggerOverlap_ReadOut: _spinTriggerOverlapEnums = 1;
#[doc = "<"]
pub const _spinTriggerOverlapEnums_TriggerOverlap_PreviousFrame: _spinTriggerOverlapEnums = 2;
pub const _spinTriggerOverlapEnums_NUM_TRIGGEROVERLAP: _spinTriggerOverlapEnums = 3;
pub type _spinTriggerOverlapEnums = ::std::os::raw::c_uint;
pub use self::_spinTriggerOverlapEnums as spinTriggerOverlapEnums;
#[doc = "<"]
pub const _spinTriggerSelectorEnums_TriggerSelector_AcquisitionStart: _spinTriggerSelectorEnums = 0;
#[doc = "<"]
pub const _spinTriggerSelectorEnums_TriggerSelector_FrameStart: _spinTriggerSelectorEnums = 1;
#[doc = "<"]
pub const _spinTriggerSelectorEnums_TriggerSelector_FrameBurstStart: _spinTriggerSelectorEnums = 2;
pub const _spinTriggerSelectorEnums_NUM_TRIGGERSELECTOR: _spinTriggerSelectorEnums = 3;
pub type _spinTriggerSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinTriggerSelectorEnums as spinTriggerSelectorEnums;
#[doc = "<"]
#[doc = "Exposure time is manually controlled using ExposureTime"]
pub const _spinExposureAutoEnums_ExposureAuto_Off: _spinExposureAutoEnums = 0;
#[doc = "<"]
#[doc = "Exposure time is adapted once by the device. Once it has converged,"]
#[doc = "it returns to the Off state."]
pub const _spinExposureAutoEnums_ExposureAuto_Once: _spinExposureAutoEnums = 1;
#[doc = "<"]
#[doc = "Exposure time is constantly adapted by the device to maximize the"]
#[doc = "dynamic range."]
pub const _spinExposureAutoEnums_ExposureAuto_Continuous: _spinExposureAutoEnums = 2;
pub const _spinExposureAutoEnums_NUM_EXPOSUREAUTO: _spinExposureAutoEnums = 3;
pub type _spinExposureAutoEnums = ::std::os::raw::c_uint;
pub use self::_spinExposureAutoEnums as spinExposureAutoEnums;
#[doc = "<"]
pub const _spinEventSelectorEnums_EventSelector_Error: _spinEventSelectorEnums = 0;
#[doc = "<"]
pub const _spinEventSelectorEnums_EventSelector_ExposureEnd: _spinEventSelectorEnums = 1;
#[doc = "<"]
pub const _spinEventSelectorEnums_EventSelector_SerialPortReceive: _spinEventSelectorEnums = 2;
pub const _spinEventSelectorEnums_NUM_EVENTSELECTOR: _spinEventSelectorEnums = 3;
pub type _spinEventSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinEventSelectorEnums as spinEventSelectorEnums;
#[doc = "<"]
pub const _spinEventNotificationEnums_EventNotification_On: _spinEventNotificationEnums = 0;
#[doc = "<"]
pub const _spinEventNotificationEnums_EventNotification_Off: _spinEventNotificationEnums = 1;
pub const _spinEventNotificationEnums_NUM_EVENTNOTIFICATION: _spinEventNotificationEnums = 2;
pub type _spinEventNotificationEnums = ::std::os::raw::c_uint;
pub use self::_spinEventNotificationEnums as spinEventNotificationEnums;
#[doc = "<"]
pub const _spinLogicBlockSelectorEnums_LogicBlockSelector_LogicBlock0:
    _spinLogicBlockSelectorEnums = 0;
#[doc = "<"]
pub const _spinLogicBlockSelectorEnums_LogicBlockSelector_LogicBlock1:
    _spinLogicBlockSelectorEnums = 1;
pub const _spinLogicBlockSelectorEnums_NUM_LOGICBLOCKSELECTOR: _spinLogicBlockSelectorEnums = 2;
pub type _spinLogicBlockSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinLogicBlockSelectorEnums as spinLogicBlockSelectorEnums;
#[doc = "<"]
pub const _spinLogicBlockLUTInputActivationEnums_LogicBlockLUTInputActivation_LevelLow:
    _spinLogicBlockLUTInputActivationEnums = 0;
#[doc = "<"]
pub const _spinLogicBlockLUTInputActivationEnums_LogicBlockLUTInputActivation_LevelHigh:
    _spinLogicBlockLUTInputActivationEnums = 1;
#[doc = "<"]
pub const _spinLogicBlockLUTInputActivationEnums_LogicBlockLUTInputActivation_FallingEdge:
    _spinLogicBlockLUTInputActivationEnums = 2;
#[doc = "<"]
pub const _spinLogicBlockLUTInputActivationEnums_LogicBlockLUTInputActivation_RisingEdge:
    _spinLogicBlockLUTInputActivationEnums = 3;
#[doc = "<"]
pub const _spinLogicBlockLUTInputActivationEnums_LogicBlockLUTInputActivation_AnyEdge:
    _spinLogicBlockLUTInputActivationEnums = 4;
pub const _spinLogicBlockLUTInputActivationEnums_NUM_LOGICBLOCKLUTINPUTACTIVATION:
    _spinLogicBlockLUTInputActivationEnums = 5;
pub type _spinLogicBlockLUTInputActivationEnums = ::std::os::raw::c_uint;
pub use self::_spinLogicBlockLUTInputActivationEnums as spinLogicBlockLUTInputActivationEnums;
#[doc = "<"]
pub const _spinLogicBlockLUTInputSelectorEnums_LogicBlockLUTInputSelector_Input0:
    _spinLogicBlockLUTInputSelectorEnums = 0;
#[doc = "<"]
pub const _spinLogicBlockLUTInputSelectorEnums_LogicBlockLUTInputSelector_Input1:
    _spinLogicBlockLUTInputSelectorEnums = 1;
#[doc = "<"]
pub const _spinLogicBlockLUTInputSelectorEnums_LogicBlockLUTInputSelector_Input2:
    _spinLogicBlockLUTInputSelectorEnums = 2;
#[doc = "<"]
pub const _spinLogicBlockLUTInputSelectorEnums_LogicBlockLUTInputSelector_Input3:
    _spinLogicBlockLUTInputSelectorEnums = 3;
pub const _spinLogicBlockLUTInputSelectorEnums_NUM_LOGICBLOCKLUTINPUTSELECTOR:
    _spinLogicBlockLUTInputSelectorEnums = 4;
pub type _spinLogicBlockLUTInputSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinLogicBlockLUTInputSelectorEnums as spinLogicBlockLUTInputSelectorEnums;
#[doc = "< Zero"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_Zero:
    _spinLogicBlockLUTInputSourceEnums = 0;
#[doc = "< Line0"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_Line0:
    _spinLogicBlockLUTInputSourceEnums = 1;
#[doc = "< Line1"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_Line1:
    _spinLogicBlockLUTInputSourceEnums = 2;
#[doc = "< Line2"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_Line2:
    _spinLogicBlockLUTInputSourceEnums = 3;
#[doc = "< Line3"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_Line3:
    _spinLogicBlockLUTInputSourceEnums = 4;
#[doc = "< UserOutput0"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_UserOutput0:
    _spinLogicBlockLUTInputSourceEnums = 5;
#[doc = "< UserOutput1"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_UserOutput1:
    _spinLogicBlockLUTInputSourceEnums = 6;
#[doc = "< UserOutput2"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_UserOutput2:
    _spinLogicBlockLUTInputSourceEnums = 7;
#[doc = "< UserOutput3"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_UserOutput3:
    _spinLogicBlockLUTInputSourceEnums = 8;
#[doc = "< Counter0Start"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_Counter0Start:
    _spinLogicBlockLUTInputSourceEnums = 9;
#[doc = "< Counter1Start"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_Counter1Start:
    _spinLogicBlockLUTInputSourceEnums = 10;
#[doc = "< Counter0End"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_Counter0End:
    _spinLogicBlockLUTInputSourceEnums = 11;
#[doc = "< Counter1End"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_Counter1End:
    _spinLogicBlockLUTInputSourceEnums = 12;
#[doc = "< LogicBlock0"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_LogicBlock0:
    _spinLogicBlockLUTInputSourceEnums = 13;
#[doc = "< LogicBlock1"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_LogicBlock1:
    _spinLogicBlockLUTInputSourceEnums = 14;
#[doc = "< ExposureStart"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_ExposureStart:
    _spinLogicBlockLUTInputSourceEnums = 15;
#[doc = "< ExposureEnd"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_ExposureEnd:
    _spinLogicBlockLUTInputSourceEnums = 16;
#[doc = "< FrameTriggerWait"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_FrameTriggerWait:
    _spinLogicBlockLUTInputSourceEnums = 17;
#[doc = "< AcquisitionActive"]
pub const _spinLogicBlockLUTInputSourceEnums_LogicBlockLUTInputSource_AcquisitionActive:
    _spinLogicBlockLUTInputSourceEnums = 18;
pub const _spinLogicBlockLUTInputSourceEnums_NUM_LOGICBLOCKLUTINPUTSOURCE:
    _spinLogicBlockLUTInputSourceEnums = 19;
pub type _spinLogicBlockLUTInputSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinLogicBlockLUTInputSourceEnums as spinLogicBlockLUTInputSourceEnums;
#[doc = "<"]
pub const _spinLogicBlockLUTSelectorEnums_LogicBlockLUTSelector_Value:
    _spinLogicBlockLUTSelectorEnums = 0;
#[doc = "<"]
pub const _spinLogicBlockLUTSelectorEnums_LogicBlockLUTSelector_Enable:
    _spinLogicBlockLUTSelectorEnums = 1;
pub const _spinLogicBlockLUTSelectorEnums_NUM_LOGICBLOCKLUTSELECTOR:
    _spinLogicBlockLUTSelectorEnums = 2;
pub type _spinLogicBlockLUTSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinLogicBlockLUTSelectorEnums as spinLogicBlockLUTSelectorEnums;
#[doc = "<"]
pub const _spinColorTransformationSelectorEnums_ColorTransformationSelector_RGBtoRGB:
    _spinColorTransformationSelectorEnums = 0;
#[doc = "<"]
pub const _spinColorTransformationSelectorEnums_ColorTransformationSelector_RGBtoYUV:
    _spinColorTransformationSelectorEnums = 1;
pub const _spinColorTransformationSelectorEnums_NUM_COLORTRANSFORMATIONSELECTOR:
    _spinColorTransformationSelectorEnums = 2;
pub type _spinColorTransformationSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinColorTransformationSelectorEnums as spinColorTransformationSelectorEnums;
#[doc = "<"]
#[doc = "Uses a matrix calibrated for a wide range of light sources."]
pub const _spinRgbTransformLightSourceEnums_RgbTransformLightSource_General:
    _spinRgbTransformLightSourceEnums = 0;
#[doc = "<"]
#[doc = "Uses a matrix optimized for tungsten/incandescent light with color temperature 2800K."]
pub const _spinRgbTransformLightSourceEnums_RgbTransformLightSource_Tungsten2800K:
    _spinRgbTransformLightSourceEnums = 1;
#[doc = "<"]
#[doc = "Uses a matrix optimized for a typical warm fluoresecent light with color temperature 3000K."]
pub const _spinRgbTransformLightSourceEnums_RgbTransformLightSource_WarmFluorescent3000K:
    _spinRgbTransformLightSourceEnums = 2;
#[doc = "<"]
#[doc = "Uses a matrix optimized for a typical cool fluoresecent light with color temperature 4000K."]
pub const _spinRgbTransformLightSourceEnums_RgbTransformLightSource_CoolFluorescent4000K:
    _spinRgbTransformLightSourceEnums = 3;
#[doc = "<"]
#[doc = "Uses a matrix optimized for noon Daylight with color temperature 5000K."]
pub const _spinRgbTransformLightSourceEnums_RgbTransformLightSource_Daylight5000K:
    _spinRgbTransformLightSourceEnums = 4;
#[doc = "<"]
#[doc = "Uses a matrix optimized for a cloudy sky with color temperature 6500K."]
pub const _spinRgbTransformLightSourceEnums_RgbTransformLightSource_Cloudy6500K:
    _spinRgbTransformLightSourceEnums = 5;
#[doc = "<"]
#[doc = "Uses a matrix optimized for shade with color temperature 8000K."]
pub const _spinRgbTransformLightSourceEnums_RgbTransformLightSource_Shade8000K:
    _spinRgbTransformLightSourceEnums = 6;
#[doc = "<"]
#[doc = "Uses a custom matrix set by the user through the"]
#[doc = "ColorTransformationValueSelector and ColorTransformationValue controls."]
pub const _spinRgbTransformLightSourceEnums_RgbTransformLightSource_Custom:
    _spinRgbTransformLightSourceEnums = 7;
pub const _spinRgbTransformLightSourceEnums_NUM_RGBTRANSFORMLIGHTSOURCE:
    _spinRgbTransformLightSourceEnums = 8;
pub type _spinRgbTransformLightSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinRgbTransformLightSourceEnums as spinRgbTransformLightSourceEnums;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Gain00:
    _spinColorTransformationValueSelectorEnums = 0;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Gain01:
    _spinColorTransformationValueSelectorEnums = 1;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Gain02:
    _spinColorTransformationValueSelectorEnums = 2;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Gain10:
    _spinColorTransformationValueSelectorEnums = 3;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Gain11:
    _spinColorTransformationValueSelectorEnums = 4;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Gain12:
    _spinColorTransformationValueSelectorEnums = 5;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Gain20:
    _spinColorTransformationValueSelectorEnums = 6;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Gain21:
    _spinColorTransformationValueSelectorEnums = 7;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Gain22:
    _spinColorTransformationValueSelectorEnums = 8;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Offset0:
    _spinColorTransformationValueSelectorEnums = 9;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Offset1:
    _spinColorTransformationValueSelectorEnums = 10;
#[doc = "<"]
pub const _spinColorTransformationValueSelectorEnums_ColorTransformationValueSelector_Offset2:
    _spinColorTransformationValueSelectorEnums = 11;
pub const _spinColorTransformationValueSelectorEnums_NUM_COLORTRANSFORMATIONVALUESELECTOR:
    _spinColorTransformationValueSelectorEnums = 12;
pub type _spinColorTransformationValueSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinColorTransformationValueSelectorEnums as spinColorTransformationValueSelectorEnums;
#[doc = "<"]
pub const _spinDeviceRegistersEndiannessEnums_DeviceRegistersEndianness_Little:
    _spinDeviceRegistersEndiannessEnums = 0;
#[doc = "<"]
pub const _spinDeviceRegistersEndiannessEnums_DeviceRegistersEndianness_Big:
    _spinDeviceRegistersEndiannessEnums = 1;
pub const _spinDeviceRegistersEndiannessEnums_NUM_DEVICEREGISTERSENDIANNESS:
    _spinDeviceRegistersEndiannessEnums = 2;
pub type _spinDeviceRegistersEndiannessEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceRegistersEndiannessEnums as spinDeviceRegistersEndiannessEnums;
#[doc = "<"]
pub const _spinDeviceScanTypeEnums_DeviceScanType_Areascan: _spinDeviceScanTypeEnums = 0;
pub const _spinDeviceScanTypeEnums_NUM_DEVICESCANTYPE: _spinDeviceScanTypeEnums = 1;
pub type _spinDeviceScanTypeEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceScanTypeEnums as spinDeviceScanTypeEnums;
#[doc = "<"]
pub const _spinDeviceCharacterSetEnums_DeviceCharacterSet_UTF8: _spinDeviceCharacterSetEnums = 0;
#[doc = "<"]
pub const _spinDeviceCharacterSetEnums_DeviceCharacterSet_ASCII: _spinDeviceCharacterSetEnums = 1;
pub const _spinDeviceCharacterSetEnums_NUM_DEVICECHARACTERSET: _spinDeviceCharacterSetEnums = 2;
pub type _spinDeviceCharacterSetEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceCharacterSetEnums as spinDeviceCharacterSetEnums;
#[doc = "<"]
pub const _spinDeviceTLTypeEnums_DeviceTLType_GigEVision: _spinDeviceTLTypeEnums = 0;
#[doc = "<"]
pub const _spinDeviceTLTypeEnums_DeviceTLType_CameraLink: _spinDeviceTLTypeEnums = 1;
#[doc = "<"]
pub const _spinDeviceTLTypeEnums_DeviceTLType_CameraLinkHS: _spinDeviceTLTypeEnums = 2;
#[doc = "<"]
pub const _spinDeviceTLTypeEnums_DeviceTLType_CoaXPress: _spinDeviceTLTypeEnums = 3;
#[doc = "<"]
pub const _spinDeviceTLTypeEnums_DeviceTLType_USB3Vision: _spinDeviceTLTypeEnums = 4;
#[doc = "<"]
pub const _spinDeviceTLTypeEnums_DeviceTLType_Custom: _spinDeviceTLTypeEnums = 5;
pub const _spinDeviceTLTypeEnums_NUM_DEVICETLTYPE: _spinDeviceTLTypeEnums = 6;
pub type _spinDeviceTLTypeEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceTLTypeEnums as spinDeviceTLTypeEnums;
#[doc = "<"]
pub const _spinDevicePowerSupplySelectorEnums_DevicePowerSupplySelector_External:
    _spinDevicePowerSupplySelectorEnums = 0;
pub const _spinDevicePowerSupplySelectorEnums_NUM_DEVICEPOWERSUPPLYSELECTOR:
    _spinDevicePowerSupplySelectorEnums = 1;
pub type _spinDevicePowerSupplySelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinDevicePowerSupplySelectorEnums as spinDevicePowerSupplySelectorEnums;
#[doc = "<"]
pub const _spinDeviceTemperatureSelectorEnums_DeviceTemperatureSelector_Sensor:
    _spinDeviceTemperatureSelectorEnums = 0;
pub const _spinDeviceTemperatureSelectorEnums_NUM_DEVICETEMPERATURESELECTOR:
    _spinDeviceTemperatureSelectorEnums = 1;
pub type _spinDeviceTemperatureSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceTemperatureSelectorEnums as spinDeviceTemperatureSelectorEnums;
#[doc = "<"]
pub const _spinDeviceIndicatorModeEnums_DeviceIndicatorMode_Inactive:
    _spinDeviceIndicatorModeEnums = 0;
#[doc = "<"]
pub const _spinDeviceIndicatorModeEnums_DeviceIndicatorMode_Active: _spinDeviceIndicatorModeEnums =
    1;
#[doc = "<"]
pub const _spinDeviceIndicatorModeEnums_DeviceIndicatorMode_ErrorStatus:
    _spinDeviceIndicatorModeEnums = 2;
pub const _spinDeviceIndicatorModeEnums_NUM_DEVICEINDICATORMODE: _spinDeviceIndicatorModeEnums = 3;
pub type _spinDeviceIndicatorModeEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceIndicatorModeEnums as spinDeviceIndicatorModeEnums;
#[doc = "<"]
pub const _spinAutoExposureControlPriorityEnums_AutoExposureControlPriority_Gain:
    _spinAutoExposureControlPriorityEnums = 0;
#[doc = "<"]
pub const _spinAutoExposureControlPriorityEnums_AutoExposureControlPriority_ExposureTime:
    _spinAutoExposureControlPriorityEnums = 1;
pub const _spinAutoExposureControlPriorityEnums_NUM_AUTOEXPOSURECONTROLPRIORITY:
    _spinAutoExposureControlPriorityEnums = 2;
pub type _spinAutoExposureControlPriorityEnums = ::std::os::raw::c_uint;
pub use self::_spinAutoExposureControlPriorityEnums as spinAutoExposureControlPriorityEnums;
#[doc = "<"]
pub const _spinAutoExposureMeteringModeEnums_AutoExposureMeteringMode_Average:
    _spinAutoExposureMeteringModeEnums = 0;
#[doc = "<"]
pub const _spinAutoExposureMeteringModeEnums_AutoExposureMeteringMode_Spot:
    _spinAutoExposureMeteringModeEnums = 1;
#[doc = "<"]
pub const _spinAutoExposureMeteringModeEnums_AutoExposureMeteringMode_Partial:
    _spinAutoExposureMeteringModeEnums = 2;
#[doc = "<"]
pub const _spinAutoExposureMeteringModeEnums_AutoExposureMeteringMode_CenterWeighted:
    _spinAutoExposureMeteringModeEnums = 3;
#[doc = "<"]
pub const _spinAutoExposureMeteringModeEnums_AutoExposureMeteringMode_HistgramPeak:
    _spinAutoExposureMeteringModeEnums = 4;
pub const _spinAutoExposureMeteringModeEnums_NUM_AUTOEXPOSUREMETERINGMODE:
    _spinAutoExposureMeteringModeEnums = 5;
pub type _spinAutoExposureMeteringModeEnums = ::std::os::raw::c_uint;
pub use self::_spinAutoExposureMeteringModeEnums as spinAutoExposureMeteringModeEnums;
#[doc = "< Indoor auto white balance Profile. Can be used to compensate for artificial lighting."]
pub const _spinBalanceWhiteAutoProfileEnums_BalanceWhiteAutoProfile_Indoor:
    _spinBalanceWhiteAutoProfileEnums = 0;
#[doc = "< Outdoor auto white balance profile. Designed for scenes with"]
#[doc = "natural lighting."]
pub const _spinBalanceWhiteAutoProfileEnums_BalanceWhiteAutoProfile_Outdoor:
    _spinBalanceWhiteAutoProfileEnums = 1;
pub const _spinBalanceWhiteAutoProfileEnums_NUM_BALANCEWHITEAUTOPROFILE:
    _spinBalanceWhiteAutoProfileEnums = 2;
pub type _spinBalanceWhiteAutoProfileEnums = ::std::os::raw::c_uint;
pub use self::_spinBalanceWhiteAutoProfileEnums as spinBalanceWhiteAutoProfileEnums;
#[doc = "< Selects the Auto White Balance algorithm."]
pub const _spinAutoAlgorithmSelectorEnums_AutoAlgorithmSelector_Awb:
    _spinAutoAlgorithmSelectorEnums = 0;
#[doc = "< Selects the Auto Exposure algorithm."]
pub const _spinAutoAlgorithmSelectorEnums_AutoAlgorithmSelector_Ae:
    _spinAutoAlgorithmSelectorEnums = 1;
pub const _spinAutoAlgorithmSelectorEnums_NUM_AUTOALGORITHMSELECTOR:
    _spinAutoAlgorithmSelectorEnums = 2;
pub type _spinAutoAlgorithmSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinAutoAlgorithmSelectorEnums as spinAutoAlgorithmSelectorEnums;
#[doc = "< Target grey value is manually controlled"]
pub const _spinAutoExposureTargetGreyValueAutoEnums_AutoExposureTargetGreyValueAuto_Off:
    _spinAutoExposureTargetGreyValueAutoEnums = 0;
#[doc = "< Target grey value is constantly adapted by the device to maximize the dynamic range."]
pub const _spinAutoExposureTargetGreyValueAutoEnums_AutoExposureTargetGreyValueAuto_Continuous:
    _spinAutoExposureTargetGreyValueAutoEnums = 1;
pub const _spinAutoExposureTargetGreyValueAutoEnums_NUM_AUTOEXPOSURETARGETGREYVALUEAUTO:
    _spinAutoExposureTargetGreyValueAutoEnums = 2;
pub type _spinAutoExposureTargetGreyValueAutoEnums = ::std::os::raw::c_uint;
pub use self::_spinAutoExposureTargetGreyValueAutoEnums as spinAutoExposureTargetGreyValueAutoEnums;
#[doc = "<"]
pub const _spinAutoExposureLightingModeEnums_AutoExposureLightingMode_AutoDetect:
    _spinAutoExposureLightingModeEnums = 0;
#[doc = "<"]
pub const _spinAutoExposureLightingModeEnums_AutoExposureLightingMode_Backlight:
    _spinAutoExposureLightingModeEnums = 1;
#[doc = "<"]
pub const _spinAutoExposureLightingModeEnums_AutoExposureLightingMode_Frontlight:
    _spinAutoExposureLightingModeEnums = 2;
#[doc = "<"]
pub const _spinAutoExposureLightingModeEnums_AutoExposureLightingMode_Normal:
    _spinAutoExposureLightingModeEnums = 3;
pub const _spinAutoExposureLightingModeEnums_NUM_AUTOEXPOSURELIGHTINGMODE:
    _spinAutoExposureLightingModeEnums = 4;
pub type _spinAutoExposureLightingModeEnums = ::std::os::raw::c_uint;
pub use self::_spinAutoExposureLightingModeEnums as spinAutoExposureLightingModeEnums;
#[doc = "< Initializing"]
pub const _spinGevIEEE1588StatusEnums_GevIEEE1588Status_Initializing: _spinGevIEEE1588StatusEnums =
    0;
#[doc = "< Faulty"]
pub const _spinGevIEEE1588StatusEnums_GevIEEE1588Status_Faulty: _spinGevIEEE1588StatusEnums = 1;
#[doc = "< Disabled"]
pub const _spinGevIEEE1588StatusEnums_GevIEEE1588Status_Disabled: _spinGevIEEE1588StatusEnums = 2;
#[doc = "< Listening"]
pub const _spinGevIEEE1588StatusEnums_GevIEEE1588Status_Listening: _spinGevIEEE1588StatusEnums = 3;
#[doc = "< Pre Master"]
pub const _spinGevIEEE1588StatusEnums_GevIEEE1588Status_PreMaster: _spinGevIEEE1588StatusEnums = 4;
#[doc = "< Master"]
pub const _spinGevIEEE1588StatusEnums_GevIEEE1588Status_Master: _spinGevIEEE1588StatusEnums = 5;
#[doc = "< Passive"]
pub const _spinGevIEEE1588StatusEnums_GevIEEE1588Status_Passive: _spinGevIEEE1588StatusEnums = 6;
#[doc = "< Uncalibrated"]
pub const _spinGevIEEE1588StatusEnums_GevIEEE1588Status_Uncalibrated: _spinGevIEEE1588StatusEnums =
    7;
#[doc = "< Slave"]
pub const _spinGevIEEE1588StatusEnums_GevIEEE1588Status_Slave: _spinGevIEEE1588StatusEnums = 8;
pub const _spinGevIEEE1588StatusEnums_NUM_GEVIEEE1588STATUS: _spinGevIEEE1588StatusEnums = 9;
pub type _spinGevIEEE1588StatusEnums = ::std::os::raw::c_uint;
pub use self::_spinGevIEEE1588StatusEnums as spinGevIEEE1588StatusEnums;
#[doc = "< Automatic"]
pub const _spinGevIEEE1588ModeEnums_GevIEEE1588Mode_Auto: _spinGevIEEE1588ModeEnums = 0;
#[doc = "< Slave Only"]
pub const _spinGevIEEE1588ModeEnums_GevIEEE1588Mode_SlaveOnly: _spinGevIEEE1588ModeEnums = 1;
pub const _spinGevIEEE1588ModeEnums_NUM_GEVIEEE1588MODE: _spinGevIEEE1588ModeEnums = 2;
pub type _spinGevIEEE1588ModeEnums = ::std::os::raw::c_uint;
pub use self::_spinGevIEEE1588ModeEnums as spinGevIEEE1588ModeEnums;
#[doc = "< Unknown Accuracy"]
pub const _spinGevIEEE1588ClockAccuracyEnums_GevIEEE1588ClockAccuracy_Unknown:
    _spinGevIEEE1588ClockAccuracyEnums = 0;
pub const _spinGevIEEE1588ClockAccuracyEnums_NUM_GEVIEEE1588CLOCKACCURACY:
    _spinGevIEEE1588ClockAccuracyEnums = 1;
pub type _spinGevIEEE1588ClockAccuracyEnums = ::std::os::raw::c_uint;
pub use self::_spinGevIEEE1588ClockAccuracyEnums as spinGevIEEE1588ClockAccuracyEnums;
#[doc = "<"]
pub const _spinGevCCPEnums_GevCCP_OpenAccess: _spinGevCCPEnums = 0;
#[doc = "<"]
pub const _spinGevCCPEnums_GevCCP_ExclusiveAccess: _spinGevCCPEnums = 1;
#[doc = "<"]
pub const _spinGevCCPEnums_GevCCP_ControlAccess: _spinGevCCPEnums = 2;
pub const _spinGevCCPEnums_NUM_GEVCCP: _spinGevCCPEnums = 3;
pub type _spinGevCCPEnums = ::std::os::raw::c_uint;
pub use self::_spinGevCCPEnums as spinGevCCPEnums;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_UserDefinedName:
    _spinGevSupportedOptionSelectorEnums = 0;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_SerialNumber:
    _spinGevSupportedOptionSelectorEnums = 1;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_HeartbeatDisable:
    _spinGevSupportedOptionSelectorEnums = 2;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_LinkSpeed:
    _spinGevSupportedOptionSelectorEnums = 3;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_CCPApplicationSocket:
    _spinGevSupportedOptionSelectorEnums = 4;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_ManifestTable:
    _spinGevSupportedOptionSelectorEnums = 5;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_TestData:
    _spinGevSupportedOptionSelectorEnums = 6;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_DiscoveryAckDelay:
    _spinGevSupportedOptionSelectorEnums = 7;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_DiscoveryAckDelayWritable : _spinGevSupportedOptionSelectorEnums = 8 ;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_ExtendedStatusCodes:
    _spinGevSupportedOptionSelectorEnums = 9;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_Action:
    _spinGevSupportedOptionSelectorEnums = 10;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_PendingAck:
    _spinGevSupportedOptionSelectorEnums = 11;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_EventData:
    _spinGevSupportedOptionSelectorEnums = 12;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_Event:
    _spinGevSupportedOptionSelectorEnums = 13;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_PacketResend:
    _spinGevSupportedOptionSelectorEnums = 14;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_WriteMem:
    _spinGevSupportedOptionSelectorEnums = 15;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_CommandsConcatenation:
    _spinGevSupportedOptionSelectorEnums = 16;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_IPConfigurationLLA:
    _spinGevSupportedOptionSelectorEnums = 17;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_IPConfigurationDHCP:
    _spinGevSupportedOptionSelectorEnums = 18;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_IPConfigurationPersistentIP : _spinGevSupportedOptionSelectorEnums = 19 ;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_StreamChannelSourceSocket : _spinGevSupportedOptionSelectorEnums = 20 ;
#[doc = "<"]
pub const _spinGevSupportedOptionSelectorEnums_GevSupportedOptionSelector_MessageChannelSourceSocket : _spinGevSupportedOptionSelectorEnums = 21 ;
pub const _spinGevSupportedOptionSelectorEnums_NUM_GEVSUPPORTEDOPTIONSELECTOR:
    _spinGevSupportedOptionSelectorEnums = 22;
pub type _spinGevSupportedOptionSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinGevSupportedOptionSelectorEnums as spinGevSupportedOptionSelectorEnums;
#[doc = "<"]
pub const _spinBlackLevelSelectorEnums_BlackLevelSelector_All: _spinBlackLevelSelectorEnums = 0;
#[doc = "<"]
pub const _spinBlackLevelSelectorEnums_BlackLevelSelector_Analog: _spinBlackLevelSelectorEnums = 1;
#[doc = "<"]
pub const _spinBlackLevelSelectorEnums_BlackLevelSelector_Digital: _spinBlackLevelSelectorEnums = 2;
pub const _spinBlackLevelSelectorEnums_NUM_BLACKLEVELSELECTOR: _spinBlackLevelSelectorEnums = 3;
pub type _spinBlackLevelSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinBlackLevelSelectorEnums as spinBlackLevelSelectorEnums;
#[doc = "< Sets operation mode to Off, which is manual control."]
pub const _spinBalanceWhiteAutoEnums_BalanceWhiteAuto_Off: _spinBalanceWhiteAutoEnums = 0;
#[doc = "< Sets operation mode to once. Once runs for a number of iterations and then sets White Balance Auto to Off."]
pub const _spinBalanceWhiteAutoEnums_BalanceWhiteAuto_Once: _spinBalanceWhiteAutoEnums = 1;
#[doc = "< Sets operation mode to continuous. Continuous automatically adjusts values if the colors are imbalanced."]
pub const _spinBalanceWhiteAutoEnums_BalanceWhiteAuto_Continuous: _spinBalanceWhiteAutoEnums = 2;
pub const _spinBalanceWhiteAutoEnums_NUM_BALANCEWHITEAUTO: _spinBalanceWhiteAutoEnums = 3;
pub type _spinBalanceWhiteAutoEnums = ::std::os::raw::c_uint;
pub use self::_spinBalanceWhiteAutoEnums as spinBalanceWhiteAutoEnums;
#[doc = "< Gain is manually controlled"]
pub const _spinGainAutoEnums_GainAuto_Off: _spinGainAutoEnums = 0;
#[doc = "<"]
#[doc = "Gain is adapted once by the device. Once it has converged, it returns to the Off state."]
pub const _spinGainAutoEnums_GainAuto_Once: _spinGainAutoEnums = 1;
#[doc = "<"]
#[doc = "Gain is constantly adapted by the device to maximize the dynamic range."]
pub const _spinGainAutoEnums_GainAuto_Continuous: _spinGainAutoEnums = 2;
pub const _spinGainAutoEnums_NUM_GAINAUTO: _spinGainAutoEnums = 3;
pub type _spinGainAutoEnums = ::std::os::raw::c_uint;
pub use self::_spinGainAutoEnums as spinGainAutoEnums;
#[doc = "<"]
#[doc = "Selects the red balance ratio control for adjustment.  The red balance"]
#[doc = "ratio is relative to the green channel."]
pub const _spinBalanceRatioSelectorEnums_BalanceRatioSelector_Red: _spinBalanceRatioSelectorEnums =
    0;
#[doc = "<"]
#[doc = "Selects the blue balance ratio control for adjustment. The blue balance"]
#[doc = "ratio is relative to the green channel."]
pub const _spinBalanceRatioSelectorEnums_BalanceRatioSelector_Blue: _spinBalanceRatioSelectorEnums =
    1;
pub const _spinBalanceRatioSelectorEnums_NUM_BALANCERATIOSELECTOR: _spinBalanceRatioSelectorEnums =
    2;
pub type _spinBalanceRatioSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinBalanceRatioSelectorEnums as spinBalanceRatioSelectorEnums;
#[doc = "<"]
pub const _spinGainSelectorEnums_GainSelector_All: _spinGainSelectorEnums = 0;
pub const _spinGainSelectorEnums_NUM_GAINSELECTOR: _spinGainSelectorEnums = 1;
pub type _spinGainSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinGainSelectorEnums as spinGainSelectorEnums;
#[doc = "< Pixels are replaced with the average of their neighbours.  This is the normal mode of operation."]
pub const _spinDefectCorrectionModeEnums_DefectCorrectionMode_Average:
    _spinDefectCorrectionModeEnums = 0;
#[doc = "< Pixels are replaced with the maximum pixel value (i.e., 255 for 8-bit images).  Can be used for debugging the table."]
pub const _spinDefectCorrectionModeEnums_DefectCorrectionMode_Highlight:
    _spinDefectCorrectionModeEnums = 1;
#[doc = "< Pixels are replaced by the value zero.  Can be used for testing the table."]
pub const _spinDefectCorrectionModeEnums_DefectCorrectionMode_Zero: _spinDefectCorrectionModeEnums =
    2;
pub const _spinDefectCorrectionModeEnums_NUM_DEFECTCORRECTIONMODE: _spinDefectCorrectionModeEnums =
    3;
pub type _spinDefectCorrectionModeEnums = ::std::os::raw::c_uint;
pub use self::_spinDefectCorrectionModeEnums as spinDefectCorrectionModeEnums;
#[doc = "< Factory default set."]
pub const _spinUserSetSelectorEnums_UserSetSelector_Default: _spinUserSetSelectorEnums = 0;
#[doc = "< User configurable set 0."]
pub const _spinUserSetSelectorEnums_UserSetSelector_UserSet0: _spinUserSetSelectorEnums = 1;
#[doc = "< User configurable set 1."]
pub const _spinUserSetSelectorEnums_UserSetSelector_UserSet1: _spinUserSetSelectorEnums = 2;
pub const _spinUserSetSelectorEnums_NUM_USERSETSELECTOR: _spinUserSetSelectorEnums = 3;
pub type _spinUserSetSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinUserSetSelectorEnums as spinUserSetSelectorEnums;
#[doc = "< Factory default set."]
pub const _spinUserSetDefaultEnums_UserSetDefault_Default: _spinUserSetDefaultEnums = 0;
#[doc = "< User configurable set 0."]
pub const _spinUserSetDefaultEnums_UserSetDefault_UserSet0: _spinUserSetDefaultEnums = 1;
#[doc = "< User configurable set 1."]
pub const _spinUserSetDefaultEnums_UserSetDefault_UserSet1: _spinUserSetDefaultEnums = 2;
pub const _spinUserSetDefaultEnums_NUM_USERSETDEFAULT: _spinUserSetDefaultEnums = 3;
pub type _spinUserSetDefaultEnums = ::std::os::raw::c_uint;
pub use self::_spinUserSetDefaultEnums as spinUserSetDefaultEnums;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud300: _spinSerialPortBaudRateEnums = 0;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud600: _spinSerialPortBaudRateEnums = 1;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud1200: _spinSerialPortBaudRateEnums =
    2;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud2400: _spinSerialPortBaudRateEnums =
    3;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud4800: _spinSerialPortBaudRateEnums =
    4;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud9600: _spinSerialPortBaudRateEnums =
    5;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud14400: _spinSerialPortBaudRateEnums =
    6;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud19200: _spinSerialPortBaudRateEnums =
    7;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud38400: _spinSerialPortBaudRateEnums =
    8;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud57600: _spinSerialPortBaudRateEnums =
    9;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud115200: _spinSerialPortBaudRateEnums =
    10;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud230400: _spinSerialPortBaudRateEnums =
    11;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud460800: _spinSerialPortBaudRateEnums =
    12;
#[doc = "<"]
pub const _spinSerialPortBaudRateEnums_SerialPortBaudRate_Baud921600: _spinSerialPortBaudRateEnums =
    13;
pub const _spinSerialPortBaudRateEnums_NUM_SERIALPORTBAUDRATE: _spinSerialPortBaudRateEnums = 14;
pub type _spinSerialPortBaudRateEnums = ::std::os::raw::c_uint;
pub use self::_spinSerialPortBaudRateEnums as spinSerialPortBaudRateEnums;
#[doc = "<"]
pub const _spinSerialPortParityEnums_SerialPortParity_None: _spinSerialPortParityEnums = 0;
#[doc = "<"]
pub const _spinSerialPortParityEnums_SerialPortParity_Odd: _spinSerialPortParityEnums = 1;
#[doc = "<"]
pub const _spinSerialPortParityEnums_SerialPortParity_Even: _spinSerialPortParityEnums = 2;
#[doc = "<"]
pub const _spinSerialPortParityEnums_SerialPortParity_Mark: _spinSerialPortParityEnums = 3;
#[doc = "<"]
pub const _spinSerialPortParityEnums_SerialPortParity_Space: _spinSerialPortParityEnums = 4;
pub const _spinSerialPortParityEnums_NUM_SERIALPORTPARITY: _spinSerialPortParityEnums = 5;
pub type _spinSerialPortParityEnums = ::std::os::raw::c_uint;
pub use self::_spinSerialPortParityEnums as spinSerialPortParityEnums;
#[doc = "<"]
pub const _spinSerialPortSelectorEnums_SerialPortSelector_SerialPort0:
    _spinSerialPortSelectorEnums = 0;
pub const _spinSerialPortSelectorEnums_NUM_SERIALPORTSELECTOR: _spinSerialPortSelectorEnums = 1;
pub type _spinSerialPortSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinSerialPortSelectorEnums as spinSerialPortSelectorEnums;
#[doc = "<"]
pub const _spinSerialPortStopBitsEnums_SerialPortStopBits_Bits1: _spinSerialPortStopBitsEnums = 0;
#[doc = "<"]
pub const _spinSerialPortStopBitsEnums_SerialPortStopBits_Bits1AndAHalf:
    _spinSerialPortStopBitsEnums = 1;
#[doc = "<"]
pub const _spinSerialPortStopBitsEnums_SerialPortStopBits_Bits2: _spinSerialPortStopBitsEnums = 2;
pub const _spinSerialPortStopBitsEnums_NUM_SERIALPORTSTOPBITS: _spinSerialPortStopBitsEnums = 3;
pub type _spinSerialPortStopBitsEnums = ::std::os::raw::c_uint;
pub use self::_spinSerialPortStopBitsEnums as spinSerialPortStopBitsEnums;
#[doc = "<"]
pub const _spinSerialPortSourceEnums_SerialPortSource_Line0: _spinSerialPortSourceEnums = 0;
#[doc = "<"]
pub const _spinSerialPortSourceEnums_SerialPortSource_Line1: _spinSerialPortSourceEnums = 1;
#[doc = "<"]
pub const _spinSerialPortSourceEnums_SerialPortSource_Line2: _spinSerialPortSourceEnums = 2;
#[doc = "<"]
pub const _spinSerialPortSourceEnums_SerialPortSource_Line3: _spinSerialPortSourceEnums = 3;
#[doc = "<"]
pub const _spinSerialPortSourceEnums_SerialPortSource_Off: _spinSerialPortSourceEnums = 4;
pub const _spinSerialPortSourceEnums_NUM_SERIALPORTSOURCE: _spinSerialPortSourceEnums = 5;
pub type _spinSerialPortSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinSerialPortSourceEnums as spinSerialPortSourceEnums;
#[doc = "<"]
pub const _spinSequencerModeEnums_SequencerMode_Off: _spinSequencerModeEnums = 0;
#[doc = "<"]
pub const _spinSequencerModeEnums_SequencerMode_On: _spinSequencerModeEnums = 1;
pub const _spinSequencerModeEnums_NUM_SEQUENCERMODE: _spinSequencerModeEnums = 2;
pub type _spinSequencerModeEnums = ::std::os::raw::c_uint;
pub use self::_spinSequencerModeEnums as spinSequencerModeEnums;
#[doc = "<"]
pub const _spinSequencerConfigurationValidEnums_SequencerConfigurationValid_No:
    _spinSequencerConfigurationValidEnums = 0;
#[doc = "<"]
pub const _spinSequencerConfigurationValidEnums_SequencerConfigurationValid_Yes:
    _spinSequencerConfigurationValidEnums = 1;
pub const _spinSequencerConfigurationValidEnums_NUM_SEQUENCERCONFIGURATIONVALID:
    _spinSequencerConfigurationValidEnums = 2;
pub type _spinSequencerConfigurationValidEnums = ::std::os::raw::c_uint;
pub use self::_spinSequencerConfigurationValidEnums as spinSequencerConfigurationValidEnums;
#[doc = "<"]
pub const _spinSequencerSetValidEnums_SequencerSetValid_No: _spinSequencerSetValidEnums = 0;
#[doc = "<"]
pub const _spinSequencerSetValidEnums_SequencerSetValid_Yes: _spinSequencerSetValidEnums = 1;
pub const _spinSequencerSetValidEnums_NUM_SEQUENCERSETVALID: _spinSequencerSetValidEnums = 2;
pub type _spinSequencerSetValidEnums = ::std::os::raw::c_uint;
pub use self::_spinSequencerSetValidEnums as spinSequencerSetValidEnums;
#[doc = "<"]
pub const _spinSequencerTriggerActivationEnums_SequencerTriggerActivation_RisingEdge:
    _spinSequencerTriggerActivationEnums = 0;
#[doc = "<"]
pub const _spinSequencerTriggerActivationEnums_SequencerTriggerActivation_FallingEdge:
    _spinSequencerTriggerActivationEnums = 1;
#[doc = "<"]
pub const _spinSequencerTriggerActivationEnums_SequencerTriggerActivation_AnyEdge:
    _spinSequencerTriggerActivationEnums = 2;
#[doc = "<"]
pub const _spinSequencerTriggerActivationEnums_SequencerTriggerActivation_LevelHigh:
    _spinSequencerTriggerActivationEnums = 3;
#[doc = "<"]
pub const _spinSequencerTriggerActivationEnums_SequencerTriggerActivation_LevelLow:
    _spinSequencerTriggerActivationEnums = 4;
pub const _spinSequencerTriggerActivationEnums_NUM_SEQUENCERTRIGGERACTIVATION:
    _spinSequencerTriggerActivationEnums = 5;
pub type _spinSequencerTriggerActivationEnums = ::std::os::raw::c_uint;
pub use self::_spinSequencerTriggerActivationEnums as spinSequencerTriggerActivationEnums;
#[doc = "<"]
pub const _spinSequencerConfigurationModeEnums_SequencerConfigurationMode_Off:
    _spinSequencerConfigurationModeEnums = 0;
#[doc = "<"]
pub const _spinSequencerConfigurationModeEnums_SequencerConfigurationMode_On:
    _spinSequencerConfigurationModeEnums = 1;
pub const _spinSequencerConfigurationModeEnums_NUM_SEQUENCERCONFIGURATIONMODE:
    _spinSequencerConfigurationModeEnums = 2;
pub type _spinSequencerConfigurationModeEnums = ::std::os::raw::c_uint;
pub use self::_spinSequencerConfigurationModeEnums as spinSequencerConfigurationModeEnums;
#[doc = "<"]
pub const _spinSequencerTriggerSourceEnums_SequencerTriggerSource_Off:
    _spinSequencerTriggerSourceEnums = 0;
#[doc = "<"]
pub const _spinSequencerTriggerSourceEnums_SequencerTriggerSource_FrameStart:
    _spinSequencerTriggerSourceEnums = 1;
pub const _spinSequencerTriggerSourceEnums_NUM_SEQUENCERTRIGGERSOURCE:
    _spinSequencerTriggerSourceEnums = 2;
pub type _spinSequencerTriggerSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinSequencerTriggerSourceEnums as spinSequencerTriggerSourceEnums;
#[doc = "< Blocks first In are transferred Out first."]
pub const _spinTransferQueueModeEnums_TransferQueueMode_FirstInFirstOut:
    _spinTransferQueueModeEnums = 0;
pub const _spinTransferQueueModeEnums_NUM_TRANSFERQUEUEMODE: _spinTransferQueueModeEnums = 1;
pub type _spinTransferQueueModeEnums = ::std::os::raw::c_uint;
pub use self::_spinTransferQueueModeEnums as spinTransferQueueModeEnums;
#[doc = "< Continuous"]
pub const _spinTransferOperationModeEnums_TransferOperationMode_Continuous:
    _spinTransferOperationModeEnums = 0;
#[doc = "< Multi Block"]
pub const _spinTransferOperationModeEnums_TransferOperationMode_MultiBlock:
    _spinTransferOperationModeEnums = 1;
pub const _spinTransferOperationModeEnums_NUM_TRANSFEROPERATIONMODE:
    _spinTransferOperationModeEnums = 2;
pub type _spinTransferOperationModeEnums = ::std::os::raw::c_uint;
pub use self::_spinTransferOperationModeEnums as spinTransferOperationModeEnums;
#[doc = "< Basic"]
pub const _spinTransferControlModeEnums_TransferControlMode_Basic: _spinTransferControlModeEnums =
    0;
#[doc = "< Automatic"]
pub const _spinTransferControlModeEnums_TransferControlMode_Automatic:
    _spinTransferControlModeEnums = 1;
#[doc = "< User Controlled"]
pub const _spinTransferControlModeEnums_TransferControlMode_UserControlled:
    _spinTransferControlModeEnums = 2;
pub const _spinTransferControlModeEnums_NUM_TRANSFERCONTROLMODE: _spinTransferControlModeEnums = 3;
pub type _spinTransferControlModeEnums = ::std::os::raw::c_uint;
pub use self::_spinTransferControlModeEnums as spinTransferControlModeEnums;
#[doc = "<"]
pub const _spinChunkGainSelectorEnums_ChunkGainSelector_All: _spinChunkGainSelectorEnums = 0;
#[doc = "<"]
pub const _spinChunkGainSelectorEnums_ChunkGainSelector_Red: _spinChunkGainSelectorEnums = 1;
#[doc = "<"]
pub const _spinChunkGainSelectorEnums_ChunkGainSelector_Green: _spinChunkGainSelectorEnums = 2;
#[doc = "<"]
pub const _spinChunkGainSelectorEnums_ChunkGainSelector_Blue: _spinChunkGainSelectorEnums = 3;
pub const _spinChunkGainSelectorEnums_NUM_CHUNKGAINSELECTOR: _spinChunkGainSelectorEnums = 4;
pub type _spinChunkGainSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkGainSelectorEnums as spinChunkGainSelectorEnums;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_Image: _spinChunkSelectorEnums = 0;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_CRC: _spinChunkSelectorEnums = 1;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_FrameID: _spinChunkSelectorEnums = 2;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_OffsetX: _spinChunkSelectorEnums = 3;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_OffsetY: _spinChunkSelectorEnums = 4;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_Width: _spinChunkSelectorEnums = 5;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_Height: _spinChunkSelectorEnums = 6;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_ExposureTime: _spinChunkSelectorEnums = 7;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_Gain: _spinChunkSelectorEnums = 8;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_BlackLevel: _spinChunkSelectorEnums = 9;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_PixelFormat: _spinChunkSelectorEnums = 10;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_Timestamp: _spinChunkSelectorEnums = 11;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_SequencerSetActive: _spinChunkSelectorEnums = 12;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_SerialData: _spinChunkSelectorEnums = 13;
#[doc = "<"]
pub const _spinChunkSelectorEnums_ChunkSelector_ExposureEndLineStatusAll: _spinChunkSelectorEnums =
    14;
pub const _spinChunkSelectorEnums_NUM_CHUNKSELECTOR: _spinChunkSelectorEnums = 15;
pub type _spinChunkSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkSelectorEnums as spinChunkSelectorEnums;
#[doc = "<"]
pub const _spinChunkBlackLevelSelectorEnums_ChunkBlackLevelSelector_All:
    _spinChunkBlackLevelSelectorEnums = 0;
pub const _spinChunkBlackLevelSelectorEnums_NUM_CHUNKBLACKLEVELSELECTOR:
    _spinChunkBlackLevelSelectorEnums = 1;
pub type _spinChunkBlackLevelSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkBlackLevelSelectorEnums as spinChunkBlackLevelSelectorEnums;
#[doc = "<"]
pub const _spinChunkPixelFormatEnums_ChunkPixelFormat_Mono8: _spinChunkPixelFormatEnums = 0;
#[doc = "<"]
pub const _spinChunkPixelFormatEnums_ChunkPixelFormat_Mono12Packed: _spinChunkPixelFormatEnums = 1;
#[doc = "<"]
pub const _spinChunkPixelFormatEnums_ChunkPixelFormat_Mono16: _spinChunkPixelFormatEnums = 2;
#[doc = "<"]
pub const _spinChunkPixelFormatEnums_ChunkPixelFormat_RGB8Packed: _spinChunkPixelFormatEnums = 3;
#[doc = "<"]
pub const _spinChunkPixelFormatEnums_ChunkPixelFormat_YUV422Packed: _spinChunkPixelFormatEnums = 4;
#[doc = "<"]
pub const _spinChunkPixelFormatEnums_ChunkPixelFormat_BayerGR8: _spinChunkPixelFormatEnums = 5;
#[doc = "<"]
pub const _spinChunkPixelFormatEnums_ChunkPixelFormat_BayerRG8: _spinChunkPixelFormatEnums = 6;
#[doc = "<"]
pub const _spinChunkPixelFormatEnums_ChunkPixelFormat_BayerGB8: _spinChunkPixelFormatEnums = 7;
#[doc = "<"]
pub const _spinChunkPixelFormatEnums_ChunkPixelFormat_BayerBG8: _spinChunkPixelFormatEnums = 8;
#[doc = "<"]
pub const _spinChunkPixelFormatEnums_ChunkPixelFormat_YCbCr601_422_8_CbYCrY:
    _spinChunkPixelFormatEnums = 9;
pub const _spinChunkPixelFormatEnums_NUM_CHUNKPIXELFORMAT: _spinChunkPixelFormatEnums = 10;
pub type _spinChunkPixelFormatEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkPixelFormatEnums as spinChunkPixelFormatEnums;
#[doc = "< File Operation was sucessful."]
pub const _spinFileOperationStatusEnums_FileOperationStatus_Success: _spinFileOperationStatusEnums =
    0;
#[doc = "< File Operation failed."]
pub const _spinFileOperationStatusEnums_FileOperationStatus_Failure: _spinFileOperationStatusEnums =
    1;
#[doc = "< An overflow occurred while executing the File Operation."]
pub const _spinFileOperationStatusEnums_FileOperationStatus_Overflow:
    _spinFileOperationStatusEnums = 2;
pub const _spinFileOperationStatusEnums_NUM_FILEOPERATIONSTATUS: _spinFileOperationStatusEnums = 3;
pub type _spinFileOperationStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinFileOperationStatusEnums as spinFileOperationStatusEnums;
#[doc = "<"]
pub const _spinFileOpenModeEnums_FileOpenMode_Read: _spinFileOpenModeEnums = 0;
#[doc = "<"]
pub const _spinFileOpenModeEnums_FileOpenMode_Write: _spinFileOpenModeEnums = 1;
#[doc = "<"]
pub const _spinFileOpenModeEnums_FileOpenMode_ReadWrite: _spinFileOpenModeEnums = 2;
pub const _spinFileOpenModeEnums_NUM_FILEOPENMODE: _spinFileOpenModeEnums = 3;
pub type _spinFileOpenModeEnums = ::std::os::raw::c_uint;
pub use self::_spinFileOpenModeEnums as spinFileOpenModeEnums;
#[doc = "<"]
pub const _spinFileOperationSelectorEnums_FileOperationSelector_Open:
    _spinFileOperationSelectorEnums = 0;
#[doc = "<"]
pub const _spinFileOperationSelectorEnums_FileOperationSelector_Close:
    _spinFileOperationSelectorEnums = 1;
#[doc = "<"]
pub const _spinFileOperationSelectorEnums_FileOperationSelector_Read:
    _spinFileOperationSelectorEnums = 2;
#[doc = "<"]
pub const _spinFileOperationSelectorEnums_FileOperationSelector_Write:
    _spinFileOperationSelectorEnums = 3;
#[doc = "<"]
pub const _spinFileOperationSelectorEnums_FileOperationSelector_Delete:
    _spinFileOperationSelectorEnums = 4;
pub const _spinFileOperationSelectorEnums_NUM_FILEOPERATIONSELECTOR:
    _spinFileOperationSelectorEnums = 5;
pub type _spinFileOperationSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinFileOperationSelectorEnums as spinFileOperationSelectorEnums;
#[doc = "<"]
pub const _spinFileSelectorEnums_FileSelector_UserSetDefault: _spinFileSelectorEnums = 0;
#[doc = "<"]
pub const _spinFileSelectorEnums_FileSelector_UserSet0: _spinFileSelectorEnums = 1;
#[doc = "<"]
pub const _spinFileSelectorEnums_FileSelector_UserSet1: _spinFileSelectorEnums = 2;
#[doc = "<"]
pub const _spinFileSelectorEnums_FileSelector_UserFile1: _spinFileSelectorEnums = 3;
#[doc = "<"]
pub const _spinFileSelectorEnums_FileSelector_SerialPort0: _spinFileSelectorEnums = 4;
pub const _spinFileSelectorEnums_NUM_FILESELECTOR: _spinFileSelectorEnums = 5;
pub type _spinFileSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinFileSelectorEnums as spinFileSelectorEnums;
#[doc = "<"]
#[doc = "The total amount of binning to be performed on the captured sensor data."]
pub const _spinBinningSelectorEnums_BinningSelector_All: _spinBinningSelectorEnums = 0;
#[doc = "<"]
#[doc = "The portion of binning to be performed on the sensor directly."]
pub const _spinBinningSelectorEnums_BinningSelector_Sensor: _spinBinningSelectorEnums = 1;
#[doc = "<"]
#[doc = "The portion of binning to be performed by the image signal processing"]
#[doc = "engine (ISP) outside of the sensor. Note: the ISP can be disabled."]
pub const _spinBinningSelectorEnums_BinningSelector_ISP: _spinBinningSelectorEnums = 2;
pub const _spinBinningSelectorEnums_NUM_BINNINGSELECTOR: _spinBinningSelectorEnums = 3;
pub type _spinBinningSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinBinningSelectorEnums as spinBinningSelectorEnums;
#[doc = "< TestPattern feature controls the sensor`s test pattern generator."]
pub const _spinTestPatternGeneratorSelectorEnums_TestPatternGeneratorSelector_Sensor:
    _spinTestPatternGeneratorSelectorEnums = 0;
#[doc = "< TestPattern feature controls the test pattern inserted at the start of the image pipeline."]
pub const _spinTestPatternGeneratorSelectorEnums_TestPatternGeneratorSelector_PipelineStart:
    _spinTestPatternGeneratorSelectorEnums = 1;
pub const _spinTestPatternGeneratorSelectorEnums_NUM_TESTPATTERNGENERATORSELECTOR:
    _spinTestPatternGeneratorSelectorEnums = 2;
pub type _spinTestPatternGeneratorSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinTestPatternGeneratorSelectorEnums as spinTestPatternGeneratorSelectorEnums;
#[doc = "< Frames which will cause the MaxDatarateThreshold to be exceeded will not be transmitted. Requires FrameRateEnable to be True"]
pub const _spinCompressionSaturationPriorityEnums_CompressionSaturationPriority_DropFrame:
    _spinCompressionSaturationPriorityEnums = 0;
#[doc = "< AcquisitionFrameRate is dynamically adjusted to the highest possible value without exceeding the MaxDatarateThreshold."]
pub const _spinCompressionSaturationPriorityEnums_CompressionSaturationPriority_ReduceFrameRate:
    _spinCompressionSaturationPriorityEnums = 1;
pub const _spinCompressionSaturationPriorityEnums_NUM_COMPRESSIONSATURATIONPRIORITY:
    _spinCompressionSaturationPriorityEnums = 2;
pub type _spinCompressionSaturationPriorityEnums = ::std::os::raw::c_uint;
pub use self::_spinCompressionSaturationPriorityEnums as spinCompressionSaturationPriorityEnums;
#[doc = "< Test pattern is disabled."]
pub const _spinTestPatternEnums_TestPattern_Off: _spinTestPatternEnums = 0;
#[doc = "< Pixel value increments by 1 for each pixel."]
pub const _spinTestPatternEnums_TestPattern_Increment: _spinTestPatternEnums = 1;
#[doc = "< A test pattern generated by the image sensor.  The pattern varies for different sensor models."]
pub const _spinTestPatternEnums_TestPattern_SensorTestPattern: _spinTestPatternEnums = 2;
pub const _spinTestPatternEnums_NUM_TESTPATTERN: _spinTestPatternEnums = 3;
pub type _spinTestPatternEnums = ::std::os::raw::c_uint;
pub use self::_spinTestPatternEnums as spinTestPatternEnums;
#[doc = "< No color filter."]
pub const _spinPixelColorFilterEnums_PixelColorFilter_None: _spinPixelColorFilterEnums = 0;
#[doc = "< Bayer Red Green filter."]
pub const _spinPixelColorFilterEnums_PixelColorFilter_BayerRG: _spinPixelColorFilterEnums = 1;
#[doc = "< Bayer Green Blue filter."]
pub const _spinPixelColorFilterEnums_PixelColorFilter_BayerGB: _spinPixelColorFilterEnums = 2;
#[doc = "< Bayer Green Red filter."]
pub const _spinPixelColorFilterEnums_PixelColorFilter_BayerGR: _spinPixelColorFilterEnums = 3;
#[doc = "< Bayer Blue Green filter."]
pub const _spinPixelColorFilterEnums_PixelColorFilter_BayerBG: _spinPixelColorFilterEnums = 4;
pub const _spinPixelColorFilterEnums_NUM_PIXELCOLORFILTER: _spinPixelColorFilterEnums = 5;
pub type _spinPixelColorFilterEnums = ::std::os::raw::c_uint;
pub use self::_spinPixelColorFilterEnums as spinPixelColorFilterEnums;
#[doc = "<"]
pub const _spinAdcBitDepthEnums_AdcBitDepth_Bit8: _spinAdcBitDepthEnums = 0;
#[doc = "<"]
pub const _spinAdcBitDepthEnums_AdcBitDepth_Bit10: _spinAdcBitDepthEnums = 1;
#[doc = "<"]
pub const _spinAdcBitDepthEnums_AdcBitDepth_Bit12: _spinAdcBitDepthEnums = 2;
#[doc = "<"]
pub const _spinAdcBitDepthEnums_AdcBitDepth_Bit14: _spinAdcBitDepthEnums = 3;
pub const _spinAdcBitDepthEnums_NUM_ADCBITDEPTH: _spinAdcBitDepthEnums = 4;
pub type _spinAdcBitDepthEnums = ::std::os::raw::c_uint;
pub use self::_spinAdcBitDepthEnums as spinAdcBitDepthEnums;
#[doc = "< The value of every Nth pixel is kept, others are discarded."]
pub const _spinDecimationHorizontalModeEnums_DecimationHorizontalMode_Discard:
    _spinDecimationHorizontalModeEnums = 0;
pub const _spinDecimationHorizontalModeEnums_NUM_DECIMATIONHORIZONTALMODE:
    _spinDecimationHorizontalModeEnums = 1;
pub type _spinDecimationHorizontalModeEnums = ::std::os::raw::c_uint;
pub use self::_spinDecimationHorizontalModeEnums as spinDecimationHorizontalModeEnums;
#[doc = "<"]
#[doc = "The response from the combined vertical cells is added, resulting"]
#[doc = "in increased sensitivity (a brighter image)."]
pub const _spinBinningVerticalModeEnums_BinningVerticalMode_Sum: _spinBinningVerticalModeEnums = 0;
#[doc = "<"]
#[doc = "The response from the combined vertical cells is averaged,"]
#[doc = "resulting in increased signal/noise ratio. Not all sensors support average binning."]
pub const _spinBinningVerticalModeEnums_BinningVerticalMode_Average: _spinBinningVerticalModeEnums =
    1;
pub const _spinBinningVerticalModeEnums_NUM_BINNINGVERTICALMODE: _spinBinningVerticalModeEnums = 2;
pub type _spinBinningVerticalModeEnums = ::std::os::raw::c_uint;
pub use self::_spinBinningVerticalModeEnums as spinBinningVerticalModeEnums;
#[doc = "< 1 bit per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp1: _spinPixelSizeEnums = 0;
#[doc = "< 2 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp2: _spinPixelSizeEnums = 1;
#[doc = "< 4 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp4: _spinPixelSizeEnums = 2;
#[doc = "< 8 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp8: _spinPixelSizeEnums = 3;
#[doc = "< 10 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp10: _spinPixelSizeEnums = 4;
#[doc = "< 12 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp12: _spinPixelSizeEnums = 5;
#[doc = "< 14 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp14: _spinPixelSizeEnums = 6;
#[doc = "< 16 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp16: _spinPixelSizeEnums = 7;
#[doc = "< 20 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp20: _spinPixelSizeEnums = 8;
#[doc = "< 24 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp24: _spinPixelSizeEnums = 9;
#[doc = "< 30 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp30: _spinPixelSizeEnums = 10;
#[doc = "< 32 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp32: _spinPixelSizeEnums = 11;
#[doc = "< 36 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp36: _spinPixelSizeEnums = 12;
#[doc = "< 48 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp48: _spinPixelSizeEnums = 13;
#[doc = "< 64 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp64: _spinPixelSizeEnums = 14;
#[doc = "< 96 bits per pixel."]
pub const _spinPixelSizeEnums_PixelSize_Bpp96: _spinPixelSizeEnums = 15;
pub const _spinPixelSizeEnums_NUM_PIXELSIZE: _spinPixelSizeEnums = 16;
pub type _spinPixelSizeEnums = ::std::os::raw::c_uint;
pub use self::_spinPixelSizeEnums as spinPixelSizeEnums;
#[doc = "< The total amount of decimation to be performed on the captured image data."]
pub const _spinDecimationSelectorEnums_DecimationSelector_All: _spinDecimationSelectorEnums = 0;
#[doc = "< The portion of decimation to be performed on the sensor directly. Currently this is the only decimation layer available and hence is identical to the \"All\" layer.  All decimation modification should therefore be done via the \"All\" layer only."]
pub const _spinDecimationSelectorEnums_DecimationSelector_Sensor: _spinDecimationSelectorEnums = 1;
pub const _spinDecimationSelectorEnums_NUM_DECIMATIONSELECTOR: _spinDecimationSelectorEnums = 2;
pub type _spinDecimationSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinDecimationSelectorEnums as spinDecimationSelectorEnums;
#[doc = "<"]
pub const _spinImageCompressionModeEnums_ImageCompressionMode_Off: _spinImageCompressionModeEnums =
    0;
#[doc = "<"]
pub const _spinImageCompressionModeEnums_ImageCompressionMode_Lossless:
    _spinImageCompressionModeEnums = 1;
pub const _spinImageCompressionModeEnums_NUM_IMAGECOMPRESSIONMODE: _spinImageCompressionModeEnums =
    2;
pub type _spinImageCompressionModeEnums = ::std::os::raw::c_uint;
pub use self::_spinImageCompressionModeEnums as spinImageCompressionModeEnums;
#[doc = "<"]
#[doc = "The response from the combined horizontal cells is added,"]
#[doc = "resulting in increased sensitivity (a brighter image)."]
pub const _spinBinningHorizontalModeEnums_BinningHorizontalMode_Sum:
    _spinBinningHorizontalModeEnums = 0;
#[doc = "<"]
#[doc = "The response from the combined horizontal cells is averaged,"]
#[doc = "resulting in increased signal/noise ratio. Not all sensors support average binning."]
pub const _spinBinningHorizontalModeEnums_BinningHorizontalMode_Average:
    _spinBinningHorizontalModeEnums = 1;
pub const _spinBinningHorizontalModeEnums_NUM_BINNINGHORIZONTALMODE:
    _spinBinningHorizontalModeEnums = 2;
pub type _spinBinningHorizontalModeEnums = ::std::os::raw::c_uint;
pub use self::_spinBinningHorizontalModeEnums as spinBinningHorizontalModeEnums;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_Mono8: _spinPixelFormatEnums = 0;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_Mono16: _spinPixelFormatEnums = 1;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_RGB8Packed: _spinPixelFormatEnums = 2;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGR8: _spinPixelFormatEnums = 3;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRG8: _spinPixelFormatEnums = 4;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGB8: _spinPixelFormatEnums = 5;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerBG8: _spinPixelFormatEnums = 6;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGR16: _spinPixelFormatEnums = 7;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRG16: _spinPixelFormatEnums = 8;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGB16: _spinPixelFormatEnums = 9;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerBG16: _spinPixelFormatEnums = 10;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_Mono12Packed: _spinPixelFormatEnums = 11;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGR12Packed: _spinPixelFormatEnums = 12;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRG12Packed: _spinPixelFormatEnums = 13;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGB12Packed: _spinPixelFormatEnums = 14;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerBG12Packed: _spinPixelFormatEnums = 15;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_YUV411Packed: _spinPixelFormatEnums = 16;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_YUV422Packed: _spinPixelFormatEnums = 17;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_YUV444Packed: _spinPixelFormatEnums = 18;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_Mono12p: _spinPixelFormatEnums = 19;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGR12p: _spinPixelFormatEnums = 20;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRG12p: _spinPixelFormatEnums = 21;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGB12p: _spinPixelFormatEnums = 22;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerBG12p: _spinPixelFormatEnums = 23;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr8: _spinPixelFormatEnums = 24;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr422_8: _spinPixelFormatEnums = 25;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr411_8: _spinPixelFormatEnums = 26;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BGR8: _spinPixelFormatEnums = 27;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BGRa8: _spinPixelFormatEnums = 28;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_Mono10Packed: _spinPixelFormatEnums = 29;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGR10Packed: _spinPixelFormatEnums = 30;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRG10Packed: _spinPixelFormatEnums = 31;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGB10Packed: _spinPixelFormatEnums = 32;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerBG10Packed: _spinPixelFormatEnums = 33;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_Mono10p: _spinPixelFormatEnums = 34;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGR10p: _spinPixelFormatEnums = 35;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRG10p: _spinPixelFormatEnums = 36;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGB10p: _spinPixelFormatEnums = 37;
#[doc = "<"]
pub const _spinPixelFormatEnums_PixelFormat_BayerBG10p: _spinPixelFormatEnums = 38;
#[doc = "< Monochrome 1-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Mono1p: _spinPixelFormatEnums = 39;
#[doc = "< Monochrome 2-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Mono2p: _spinPixelFormatEnums = 40;
#[doc = "< Monochrome 4-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Mono4p: _spinPixelFormatEnums = 41;
#[doc = "< Monochrome 8-bit signed"]
pub const _spinPixelFormatEnums_PixelFormat_Mono8s: _spinPixelFormatEnums = 42;
#[doc = "< Monochrome 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_Mono10: _spinPixelFormatEnums = 43;
#[doc = "< Monochrome 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_Mono12: _spinPixelFormatEnums = 44;
#[doc = "< Monochrome 14-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_Mono14: _spinPixelFormatEnums = 45;
#[doc = "< Monochrome 16-bit signed"]
pub const _spinPixelFormatEnums_PixelFormat_Mono16s: _spinPixelFormatEnums = 46;
#[doc = "< Monochrome 32-bit float"]
pub const _spinPixelFormatEnums_PixelFormat_Mono32f: _spinPixelFormatEnums = 47;
#[doc = "< Bayer Blue-Green 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BayerBG10: _spinPixelFormatEnums = 48;
#[doc = "< Bayer Blue-Green 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BayerBG12: _spinPixelFormatEnums = 49;
#[doc = "< Bayer Green-Blue 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGB10: _spinPixelFormatEnums = 50;
#[doc = "< Bayer Green-Blue 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGB12: _spinPixelFormatEnums = 51;
#[doc = "< Bayer Green-Red 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGR10: _spinPixelFormatEnums = 52;
#[doc = "< Bayer Green-Red 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BayerGR12: _spinPixelFormatEnums = 53;
#[doc = "< Bayer Red-Green 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRG10: _spinPixelFormatEnums = 54;
#[doc = "< Bayer Red-Green 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRG12: _spinPixelFormatEnums = 55;
#[doc = "< Red-Green-Blue-alpha 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_RGBa8: _spinPixelFormatEnums = 56;
#[doc = "< Red-Green-Blue-alpha 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_RGBa10: _spinPixelFormatEnums = 57;
#[doc = "< Red-Green-Blue-alpha 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_RGBa10p: _spinPixelFormatEnums = 58;
#[doc = "< Red-Green-Blue-alpha 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_RGBa12: _spinPixelFormatEnums = 59;
#[doc = "< Red-Green-Blue-alpha 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_RGBa12p: _spinPixelFormatEnums = 60;
#[doc = "< Red-Green-Blue-alpha 14-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_RGBa14: _spinPixelFormatEnums = 61;
#[doc = "< Red-Green-Blue-alpha 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_RGBa16: _spinPixelFormatEnums = 62;
#[doc = "< Red-Green-Blue 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_RGB8: _spinPixelFormatEnums = 63;
#[doc = "< Red-Green-Blue 8-bit planar"]
pub const _spinPixelFormatEnums_PixelFormat_RGB8_Planar: _spinPixelFormatEnums = 64;
#[doc = "< Red-Green-Blue 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_RGB10: _spinPixelFormatEnums = 65;
#[doc = "< Red-Green-Blue 10-bit unpacked planar"]
pub const _spinPixelFormatEnums_PixelFormat_RGB10_Planar: _spinPixelFormatEnums = 66;
#[doc = "< Red-Green-Blue 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_RGB10p: _spinPixelFormatEnums = 67;
#[doc = "< Red-Green-Blue 10-bit packed into 32-bit"]
pub const _spinPixelFormatEnums_PixelFormat_RGB10p32: _spinPixelFormatEnums = 68;
#[doc = "< Red-Green-Blue 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_RGB12: _spinPixelFormatEnums = 69;
#[doc = "< Red-Green-Blue 12-bit unpacked planar"]
pub const _spinPixelFormatEnums_PixelFormat_RGB12_Planar: _spinPixelFormatEnums = 70;
#[doc = "< Red-Green-Blue 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_RGB12p: _spinPixelFormatEnums = 71;
#[doc = "< Red-Green-Blue 14-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_RGB14: _spinPixelFormatEnums = 72;
#[doc = "< Red-Green-Blue 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_RGB16: _spinPixelFormatEnums = 73;
#[doc = "< Red-Green-Blue 16-bit signed"]
pub const _spinPixelFormatEnums_PixelFormat_RGB16s: _spinPixelFormatEnums = 74;
#[doc = "< Red-Green-Blue 32-bit float"]
pub const _spinPixelFormatEnums_PixelFormat_RGB32f: _spinPixelFormatEnums = 75;
#[doc = "< Red-Green-Blue 16-bit planar"]
pub const _spinPixelFormatEnums_PixelFormat_RGB16_Planar: _spinPixelFormatEnums = 76;
#[doc = "< Red-Green-Blue 5/6/5-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_RGB565p: _spinPixelFormatEnums = 77;
#[doc = "< Blue-Green-Red-alpha 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BGRa10: _spinPixelFormatEnums = 78;
#[doc = "< Blue-Green-Red-alpha 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BGRa10p: _spinPixelFormatEnums = 79;
#[doc = "< Blue-Green-Red-alpha 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BGRa12: _spinPixelFormatEnums = 80;
#[doc = "< Blue-Green-Red-alpha 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BGRa12p: _spinPixelFormatEnums = 81;
#[doc = "< Blue-Green-Red-alpha 14-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BGRa14: _spinPixelFormatEnums = 82;
#[doc = "< Blue-Green-Red-alpha 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_BGRa16: _spinPixelFormatEnums = 83;
#[doc = "< Red-Green-Blue-alpha 32-bit float"]
pub const _spinPixelFormatEnums_PixelFormat_RGBa32f: _spinPixelFormatEnums = 84;
#[doc = "< Blue-Green-Red 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BGR10: _spinPixelFormatEnums = 85;
#[doc = "< Blue-Green-Red 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BGR10p: _spinPixelFormatEnums = 86;
#[doc = "< Blue-Green-Red 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BGR12: _spinPixelFormatEnums = 87;
#[doc = "< Blue-Green-Red 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BGR12p: _spinPixelFormatEnums = 88;
#[doc = "< Blue-Green-Red 14-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BGR14: _spinPixelFormatEnums = 89;
#[doc = "< Blue-Green-Red 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_BGR16: _spinPixelFormatEnums = 90;
#[doc = "< Blue-Green-Red 5/6/5-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BGR565p: _spinPixelFormatEnums = 91;
#[doc = "< Red 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_R8: _spinPixelFormatEnums = 92;
#[doc = "< Red 10-bit"]
pub const _spinPixelFormatEnums_PixelFormat_R10: _spinPixelFormatEnums = 93;
#[doc = "< Red 12-bit"]
pub const _spinPixelFormatEnums_PixelFormat_R12: _spinPixelFormatEnums = 94;
#[doc = "< Red 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_R16: _spinPixelFormatEnums = 95;
#[doc = "< Green 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_G8: _spinPixelFormatEnums = 96;
#[doc = "< Green 10-bit"]
pub const _spinPixelFormatEnums_PixelFormat_G10: _spinPixelFormatEnums = 97;
#[doc = "< Green 12-bit"]
pub const _spinPixelFormatEnums_PixelFormat_G12: _spinPixelFormatEnums = 98;
#[doc = "< Green 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_G16: _spinPixelFormatEnums = 99;
#[doc = "< Blue 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_B8: _spinPixelFormatEnums = 100;
#[doc = "< Blue 10-bit"]
pub const _spinPixelFormatEnums_PixelFormat_B10: _spinPixelFormatEnums = 101;
#[doc = "< Blue 12-bit"]
pub const _spinPixelFormatEnums_PixelFormat_B12: _spinPixelFormatEnums = 102;
#[doc = "< Blue 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_B16: _spinPixelFormatEnums = 103;
#[doc = "< 3D coordinate A-B-C 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_ABC8: _spinPixelFormatEnums = 104;
#[doc = "< 3D coordinate A-B-C 8-bit planar"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_ABC8_Planar: _spinPixelFormatEnums = 105;
#[doc = "< 3D coordinate A-B-C 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_ABC10p: _spinPixelFormatEnums = 106;
#[doc = "< 3D coordinate A-B-C 10-bit packed planar"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_ABC10p_Planar: _spinPixelFormatEnums = 107;
#[doc = "< 3D coordinate A-B-C 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_ABC12p: _spinPixelFormatEnums = 108;
#[doc = "< 3D coordinate A-B-C 12-bit packed planar"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_ABC12p_Planar: _spinPixelFormatEnums = 109;
#[doc = "< 3D coordinate A-B-C 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_ABC16: _spinPixelFormatEnums = 110;
#[doc = "< 3D coordinate A-B-C 16-bit planar"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_ABC16_Planar: _spinPixelFormatEnums = 111;
#[doc = "< 3D coordinate A-B-C 32-bit floating point"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_ABC32f: _spinPixelFormatEnums = 112;
#[doc = "< 3D coordinate A-B-C 32-bit floating point planar"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_ABC32f_Planar: _spinPixelFormatEnums = 113;
#[doc = "< 3D coordinate A-C 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_AC8: _spinPixelFormatEnums = 114;
#[doc = "< 3D coordinate A-C 8-bit planar"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_AC8_Planar: _spinPixelFormatEnums = 115;
#[doc = "< 3D coordinate A-C 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_AC10p: _spinPixelFormatEnums = 116;
#[doc = "< 3D coordinate A-C 10-bit packed planar"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_AC10p_Planar: _spinPixelFormatEnums = 117;
#[doc = "< 3D coordinate A-C 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_AC12p: _spinPixelFormatEnums = 118;
#[doc = "< 3D coordinate A-C 12-bit packed planar"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_AC12p_Planar: _spinPixelFormatEnums = 119;
#[doc = "< 3D coordinate A-C 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_AC16: _spinPixelFormatEnums = 120;
#[doc = "< 3D coordinate A-C 16-bit planar"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_AC16_Planar: _spinPixelFormatEnums = 121;
#[doc = "< 3D coordinate A-C 32-bit floating point"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_AC32f: _spinPixelFormatEnums = 122;
#[doc = "< 3D coordinate A-C 32-bit floating point planar"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_AC32f_Planar: _spinPixelFormatEnums = 123;
#[doc = "< 3D coordinate A 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_A8: _spinPixelFormatEnums = 124;
#[doc = "< 3D coordinate A 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_A10p: _spinPixelFormatEnums = 125;
#[doc = "< 3D coordinate A 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_A12p: _spinPixelFormatEnums = 126;
#[doc = "< 3D coordinate A 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_A16: _spinPixelFormatEnums = 127;
#[doc = "< 3D coordinate A 32-bit floating point"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_A32f: _spinPixelFormatEnums = 128;
#[doc = "< 3D coordinate B 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_B8: _spinPixelFormatEnums = 129;
#[doc = "< 3D coordinate B 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_B10p: _spinPixelFormatEnums = 130;
#[doc = "< 3D coordinate B 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_B12p: _spinPixelFormatEnums = 131;
#[doc = "< 3D coordinate B 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_B16: _spinPixelFormatEnums = 132;
#[doc = "< 3D coordinate B 32-bit floating point"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_B32f: _spinPixelFormatEnums = 133;
#[doc = "< 3D coordinate C 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_C8: _spinPixelFormatEnums = 134;
#[doc = "< 3D coordinate C 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_C10p: _spinPixelFormatEnums = 135;
#[doc = "< 3D coordinate C 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_C12p: _spinPixelFormatEnums = 136;
#[doc = "< 3D coordinate C 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_C16: _spinPixelFormatEnums = 137;
#[doc = "< 3D coordinate C 32-bit floating point"]
pub const _spinPixelFormatEnums_PixelFormat_Coord3D_C32f: _spinPixelFormatEnums = 138;
#[doc = "< Confidence 1-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_Confidence1: _spinPixelFormatEnums = 139;
#[doc = "< Confidence 1-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Confidence1p: _spinPixelFormatEnums = 140;
#[doc = "< Confidence 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Confidence8: _spinPixelFormatEnums = 141;
#[doc = "< Confidence 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Confidence16: _spinPixelFormatEnums = 142;
#[doc = "< Confidence 32-bit floating point"]
pub const _spinPixelFormatEnums_PixelFormat_Confidence32f: _spinPixelFormatEnums = 143;
#[doc = "< Bi-color Blue/Green - Red/Green 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_BiColorBGRG8: _spinPixelFormatEnums = 144;
#[doc = "< Bi-color Blue/Green - Red/Green 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BiColorBGRG10: _spinPixelFormatEnums = 145;
#[doc = "< Bi-color Blue/Green - Red/Green 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BiColorBGRG10p: _spinPixelFormatEnums = 146;
#[doc = "< Bi-color Blue/Green - Red/Green 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BiColorBGRG12: _spinPixelFormatEnums = 147;
#[doc = "< Bi-color Blue/Green - Red/Green 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BiColorBGRG12p: _spinPixelFormatEnums = 148;
#[doc = "< Bi-color Red/Green - Blue/Green 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_BiColorRGBG8: _spinPixelFormatEnums = 149;
#[doc = "< Bi-color Red/Green - Blue/Green 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BiColorRGBG10: _spinPixelFormatEnums = 150;
#[doc = "< Bi-color Red/Green - Blue/Green 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BiColorRGBG10p: _spinPixelFormatEnums = 151;
#[doc = "< Bi-color Red/Green - Blue/Green 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_BiColorRGBG12: _spinPixelFormatEnums = 152;
#[doc = "< Bi-color Red/Green - Blue/Green 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BiColorRGBG12p: _spinPixelFormatEnums = 153;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WBWG8: _spinPixelFormatEnums = 154;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WBWG10: _spinPixelFormatEnums = 155;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WBWG10p: _spinPixelFormatEnums = 156;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WBWG12: _spinPixelFormatEnums = 157;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WBWG12p: _spinPixelFormatEnums = 158;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 14-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WBWG14: _spinPixelFormatEnums = 159;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 16-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WBWG16: _spinPixelFormatEnums = 160;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWB8: _spinPixelFormatEnums = 161;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWB10: _spinPixelFormatEnums = 162;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWB10p: _spinPixelFormatEnums = 163;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWB12: _spinPixelFormatEnums = 164;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWB12p: _spinPixelFormatEnums = 165;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 14-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWB14: _spinPixelFormatEnums = 166;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWB16: _spinPixelFormatEnums = 167;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWR8: _spinPixelFormatEnums = 168;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWR10: _spinPixelFormatEnums = 169;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWR10p: _spinPixelFormatEnums = 170;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWR12: _spinPixelFormatEnums = 171;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWR12p: _spinPixelFormatEnums = 172;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 14-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWR14: _spinPixelFormatEnums = 173;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WGWR16: _spinPixelFormatEnums = 174;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WRWG8: _spinPixelFormatEnums = 175;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WRWG10: _spinPixelFormatEnums = 176;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WRWG10p: _spinPixelFormatEnums = 177;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WRWG12: _spinPixelFormatEnums = 178;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WRWG12p: _spinPixelFormatEnums = 179;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 14-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WRWG14: _spinPixelFormatEnums = 180;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_SCF1WRWG16: _spinPixelFormatEnums = 181;
#[doc = "< YCbCr 4:4:4 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr8_CbYCr: _spinPixelFormatEnums = 182;
#[doc = "< YCbCr 4:4:4 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr10_CbYCr: _spinPixelFormatEnums = 183;
#[doc = "< YCbCr 4:4:4 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr10p_CbYCr: _spinPixelFormatEnums = 184;
#[doc = "< YCbCr 4:4:4 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr12_CbYCr: _spinPixelFormatEnums = 185;
#[doc = "< YCbCr 4:4:4 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr12p_CbYCr: _spinPixelFormatEnums = 186;
#[doc = "< YCbCr 4:1:1 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr411_8_CbYYCrYY: _spinPixelFormatEnums = 187;
#[doc = "< YCbCr 4:2:2 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr422_8_CbYCrY: _spinPixelFormatEnums = 188;
#[doc = "< YCbCr 4:2:2 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr422_10: _spinPixelFormatEnums = 189;
#[doc = "< YCbCr 4:2:2 10-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr422_10_CbYCrY: _spinPixelFormatEnums = 190;
#[doc = "< YCbCr 4:2:2 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr422_10p: _spinPixelFormatEnums = 191;
#[doc = "< YCbCr 4:2:2 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr422_10p_CbYCrY: _spinPixelFormatEnums = 192;
#[doc = "< YCbCr 4:2:2 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr422_12: _spinPixelFormatEnums = 193;
#[doc = "< YCbCr 4:2:2 12-bit unpacked"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr422_12_CbYCrY: _spinPixelFormatEnums = 194;
#[doc = "< YCbCr 4:2:2 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr422_12p: _spinPixelFormatEnums = 195;
#[doc = "< YCbCr 4:2:2 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr422_12p_CbYCrY: _spinPixelFormatEnums = 196;
#[doc = "< YCbCr 4:4:4 8-bit BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_8_CbYCr: _spinPixelFormatEnums = 197;
#[doc = "< YCbCr 4:4:4 10-bit unpacked BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_10_CbYCr: _spinPixelFormatEnums = 198;
#[doc = "< YCbCr 4:4:4 10-bit packed BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_10p_CbYCr: _spinPixelFormatEnums = 199;
#[doc = "< YCbCr 4:4:4 12-bit unpacked BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_12_CbYCr: _spinPixelFormatEnums = 200;
#[doc = "< YCbCr 4:4:4 12-bit packed BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_12p_CbYCr: _spinPixelFormatEnums = 201;
#[doc = "< YCbCr 4:1:1 8-bit BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_411_8_CbYYCrYY: _spinPixelFormatEnums = 202;
#[doc = "< YCbCr 4:2:2 8-bit BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_422_8: _spinPixelFormatEnums = 203;
#[doc = "< YCbCr 4:2:2 8-bit BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_422_8_CbYCrY: _spinPixelFormatEnums = 204;
#[doc = "< YCbCr 4:2:2 10-bit unpacked BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_422_10: _spinPixelFormatEnums = 205;
#[doc = "< YCbCr 4:2:2 10-bit unpacked BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_422_10_CbYCrY: _spinPixelFormatEnums = 206;
#[doc = "< YCbCr 4:2:2 10-bit packed BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_422_10p: _spinPixelFormatEnums = 207;
#[doc = "< YCbCr 4:2:2 10-bit packed BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_422_10p_CbYCrY: _spinPixelFormatEnums = 208;
#[doc = "< YCbCr 4:2:2 12-bit unpacked BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_422_12: _spinPixelFormatEnums = 209;
#[doc = "< YCbCr 4:2:2 12-bit unpacked BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_422_12_CbYCrY: _spinPixelFormatEnums = 210;
#[doc = "< YCbCr 4:2:2 12-bit packed BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_422_12p: _spinPixelFormatEnums = 211;
#[doc = "< YCbCr 4:2:2 12-bit packed BT.601"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr601_422_12p_CbYCrY: _spinPixelFormatEnums = 212;
#[doc = "< YCbCr 4:4:4 8-bit BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_8_CbYCr: _spinPixelFormatEnums = 213;
#[doc = "< YCbCr 4:4:4 10-bit unpacked BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_10_CbYCr: _spinPixelFormatEnums = 214;
#[doc = "< YCbCr 4:4:4 10-bit packed BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_10p_CbYCr: _spinPixelFormatEnums = 215;
#[doc = "< YCbCr 4:4:4 12-bit unpacked BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_12_CbYCr: _spinPixelFormatEnums = 216;
#[doc = "< YCbCr 4:4:4 12-bit packed BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_12p_CbYCr: _spinPixelFormatEnums = 217;
#[doc = "< YCbCr 4:1:1 8-bit BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_411_8_CbYYCrYY: _spinPixelFormatEnums = 218;
#[doc = "< YCbCr 4:2:2 8-bit BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_422_8: _spinPixelFormatEnums = 219;
#[doc = "< YCbCr 4:2:2 8-bit BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_422_8_CbYCrY: _spinPixelFormatEnums = 220;
#[doc = "< YCbCr 4:2:2 10-bit unpacked BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_422_10: _spinPixelFormatEnums = 221;
#[doc = "< YCbCr 4:2:2 10-bit unpacked BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_422_10_CbYCrY: _spinPixelFormatEnums = 222;
#[doc = "< YCbCr 4:2:2 10-bit packed BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_422_10p: _spinPixelFormatEnums = 223;
#[doc = "< YCbCr 4:2:2 10-bit packed BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_422_10p_CbYCrY: _spinPixelFormatEnums = 224;
#[doc = "< YCbCr 4:2:2 12-bit unpacked BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_422_12: _spinPixelFormatEnums = 225;
#[doc = "< YCbCr 4:2:2 12-bit unpacked BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_422_12_CbYCrY: _spinPixelFormatEnums = 226;
#[doc = "< YCbCr 4:2:2 12-bit packed BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_422_12p: _spinPixelFormatEnums = 227;
#[doc = "< YCbCr 4:2:2 12-bit packed BT.709"]
pub const _spinPixelFormatEnums_PixelFormat_YCbCr709_422_12p_CbYCrY: _spinPixelFormatEnums = 228;
#[doc = "< YUV 4:4:4 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_YUV8_UYV: _spinPixelFormatEnums = 229;
#[doc = "< YUV 4:1:1 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_YUV411_8_UYYVYY: _spinPixelFormatEnums = 230;
#[doc = "< YUV 4:2:2 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_YUV422_8: _spinPixelFormatEnums = 231;
#[doc = "< YUV 4:2:2 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_YUV422_8_UYVY: _spinPixelFormatEnums = 232;
#[doc = "< Monochrome Polarized 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Polarized8: _spinPixelFormatEnums = 233;
#[doc = "< Monochrome Polarized 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Polarized10p: _spinPixelFormatEnums = 234;
#[doc = "< Monochrome Polarized 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_Polarized12p: _spinPixelFormatEnums = 235;
#[doc = "< Monochrome Polarized 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_Polarized16: _spinPixelFormatEnums = 236;
#[doc = "< Polarized Bayer Red Green filter 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRGPolarized8: _spinPixelFormatEnums = 237;
#[doc = "< Polarized Bayer Red Green filter 10-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRGPolarized10p: _spinPixelFormatEnums = 238;
#[doc = "< Polarized Bayer Red Green filter 12-bit packed"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRGPolarized12p: _spinPixelFormatEnums = 239;
#[doc = "< Polarized Bayer Red Green filter 16-bit"]
pub const _spinPixelFormatEnums_PixelFormat_BayerRGPolarized16: _spinPixelFormatEnums = 240;
#[doc = "< Lossless Compression Monochrome 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_LLCMono8: _spinPixelFormatEnums = 241;
#[doc = "< Lossless Compression Bayer Red Green filter 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_LLCBayerRG8: _spinPixelFormatEnums = 242;
#[doc = "< JPEG Monochrome 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_JPEGMono8: _spinPixelFormatEnums = 243;
#[doc = "< JPEG Color 8-bit"]
pub const _spinPixelFormatEnums_PixelFormat_JPEGColor8: _spinPixelFormatEnums = 244;
#[doc = "< Raw 16 bit."]
pub const _spinPixelFormatEnums_PixelFormat_Raw16: _spinPixelFormatEnums = 245;
#[doc = "< Raw bit."]
pub const _spinPixelFormatEnums_PixelFormat_Raw8: _spinPixelFormatEnums = 246;
#[doc = "< Red 12-bit JPEG."]
pub const _spinPixelFormatEnums_PixelFormat_R12_Jpeg: _spinPixelFormatEnums = 247;
#[doc = "< Green Red 12-bit JPEG."]
pub const _spinPixelFormatEnums_PixelFormat_GR12_Jpeg: _spinPixelFormatEnums = 248;
#[doc = "< Green Blue 12-bit JPEG."]
pub const _spinPixelFormatEnums_PixelFormat_GB12_Jpeg: _spinPixelFormatEnums = 249;
#[doc = "< Blue 12-bit packed JPEG."]
pub const _spinPixelFormatEnums_PixelFormat_B12_Jpeg: _spinPixelFormatEnums = 250;
pub const _spinPixelFormatEnums_UNKNOWN_PIXELFORMAT: _spinPixelFormatEnums = 251;
pub const _spinPixelFormatEnums_NUM_PIXELFORMAT: _spinPixelFormatEnums = 252;
pub type _spinPixelFormatEnums = ::std::os::raw::c_uint;
pub use self::_spinPixelFormatEnums as spinPixelFormatEnums;
#[doc = "< The value of every Nth pixel is kept, others are discarded."]
pub const _spinDecimationVerticalModeEnums_DecimationVerticalMode_Discard:
    _spinDecimationVerticalModeEnums = 0;
pub const _spinDecimationVerticalModeEnums_NUM_DECIMATIONVERTICALMODE:
    _spinDecimationVerticalModeEnums = 1;
pub type _spinDecimationVerticalModeEnums = ::std::os::raw::c_uint;
pub use self::_spinDecimationVerticalModeEnums as spinDecimationVerticalModeEnums;
#[doc = "<"]
pub const _spinLineModeEnums_LineMode_Input: _spinLineModeEnums = 0;
#[doc = "<"]
pub const _spinLineModeEnums_LineMode_Output: _spinLineModeEnums = 1;
pub const _spinLineModeEnums_NUM_LINEMODE: _spinLineModeEnums = 2;
pub type _spinLineModeEnums = ::std::os::raw::c_uint;
pub use self::_spinLineModeEnums as spinLineModeEnums;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_Off: _spinLineSourceEnums = 0;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_Line0: _spinLineSourceEnums = 1;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_Line1: _spinLineSourceEnums = 2;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_Line2: _spinLineSourceEnums = 3;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_Line3: _spinLineSourceEnums = 4;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_UserOutput0: _spinLineSourceEnums = 5;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_UserOutput1: _spinLineSourceEnums = 6;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_UserOutput2: _spinLineSourceEnums = 7;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_UserOutput3: _spinLineSourceEnums = 8;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_Counter0Active: _spinLineSourceEnums = 9;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_Counter1Active: _spinLineSourceEnums = 10;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_LogicBlock0: _spinLineSourceEnums = 11;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_LogicBlock1: _spinLineSourceEnums = 12;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_ExposureActive: _spinLineSourceEnums = 13;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_FrameTriggerWait: _spinLineSourceEnums = 14;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_SerialPort0: _spinLineSourceEnums = 15;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_PPSSignal: _spinLineSourceEnums = 16;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_AllPixel: _spinLineSourceEnums = 17;
#[doc = "<"]
pub const _spinLineSourceEnums_LineSource_AnyPixel: _spinLineSourceEnums = 18;
pub const _spinLineSourceEnums_NUM_LINESOURCE: _spinLineSourceEnums = 19;
pub type _spinLineSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinLineSourceEnums as spinLineSourceEnums;
#[doc = "<"]
pub const _spinLineInputFilterSelectorEnums_LineInputFilterSelector_Deglitch:
    _spinLineInputFilterSelectorEnums = 0;
#[doc = "<"]
pub const _spinLineInputFilterSelectorEnums_LineInputFilterSelector_Debounce:
    _spinLineInputFilterSelectorEnums = 1;
pub const _spinLineInputFilterSelectorEnums_NUM_LINEINPUTFILTERSELECTOR:
    _spinLineInputFilterSelectorEnums = 2;
pub type _spinLineInputFilterSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinLineInputFilterSelectorEnums as spinLineInputFilterSelectorEnums;
#[doc = "<"]
pub const _spinUserOutputSelectorEnums_UserOutputSelector_UserOutput0:
    _spinUserOutputSelectorEnums = 0;
#[doc = "<"]
pub const _spinUserOutputSelectorEnums_UserOutputSelector_UserOutput1:
    _spinUserOutputSelectorEnums = 1;
#[doc = "<"]
pub const _spinUserOutputSelectorEnums_UserOutputSelector_UserOutput2:
    _spinUserOutputSelectorEnums = 2;
#[doc = "<"]
pub const _spinUserOutputSelectorEnums_UserOutputSelector_UserOutput3:
    _spinUserOutputSelectorEnums = 3;
pub const _spinUserOutputSelectorEnums_NUM_USEROUTPUTSELECTOR: _spinUserOutputSelectorEnums = 4;
pub type _spinUserOutputSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinUserOutputSelectorEnums as spinUserOutputSelectorEnums;
#[doc = "<"]
pub const _spinLineFormatEnums_LineFormat_NoConnect: _spinLineFormatEnums = 0;
#[doc = "<"]
pub const _spinLineFormatEnums_LineFormat_TriState: _spinLineFormatEnums = 1;
#[doc = "<"]
pub const _spinLineFormatEnums_LineFormat_TTL: _spinLineFormatEnums = 2;
#[doc = "<"]
pub const _spinLineFormatEnums_LineFormat_LVDS: _spinLineFormatEnums = 3;
#[doc = "<"]
pub const _spinLineFormatEnums_LineFormat_RS422: _spinLineFormatEnums = 4;
#[doc = "<"]
pub const _spinLineFormatEnums_LineFormat_OptoCoupled: _spinLineFormatEnums = 5;
#[doc = "<"]
pub const _spinLineFormatEnums_LineFormat_OpenDrain: _spinLineFormatEnums = 6;
pub const _spinLineFormatEnums_NUM_LINEFORMAT: _spinLineFormatEnums = 7;
pub type _spinLineFormatEnums = ::std::os::raw::c_uint;
pub use self::_spinLineFormatEnums as spinLineFormatEnums;
#[doc = "<"]
pub const _spinLineSelectorEnums_LineSelector_Line0: _spinLineSelectorEnums = 0;
#[doc = "<"]
pub const _spinLineSelectorEnums_LineSelector_Line1: _spinLineSelectorEnums = 1;
#[doc = "<"]
pub const _spinLineSelectorEnums_LineSelector_Line2: _spinLineSelectorEnums = 2;
#[doc = "<"]
pub const _spinLineSelectorEnums_LineSelector_Line3: _spinLineSelectorEnums = 3;
pub const _spinLineSelectorEnums_NUM_LINESELECTOR: _spinLineSelectorEnums = 4;
pub type _spinLineSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinLineSelectorEnums as spinLineSelectorEnums;
#[doc = "<"]
pub const _spinExposureActiveModeEnums_ExposureActiveMode_Line1: _spinExposureActiveModeEnums = 0;
#[doc = "<"]
pub const _spinExposureActiveModeEnums_ExposureActiveMode_AnyPixels: _spinExposureActiveModeEnums =
    1;
#[doc = "<"]
pub const _spinExposureActiveModeEnums_ExposureActiveMode_AllPixels: _spinExposureActiveModeEnums =
    2;
pub const _spinExposureActiveModeEnums_NUM_EXPOSUREACTIVEMODE: _spinExposureActiveModeEnums = 3;
pub type _spinExposureActiveModeEnums = ::std::os::raw::c_uint;
pub use self::_spinExposureActiveModeEnums as spinExposureActiveModeEnums;
#[doc = "<"]
pub const _spinCounterTriggerActivationEnums_CounterTriggerActivation_LevelLow:
    _spinCounterTriggerActivationEnums = 0;
#[doc = "<"]
pub const _spinCounterTriggerActivationEnums_CounterTriggerActivation_LevelHigh:
    _spinCounterTriggerActivationEnums = 1;
#[doc = "<"]
pub const _spinCounterTriggerActivationEnums_CounterTriggerActivation_FallingEdge:
    _spinCounterTriggerActivationEnums = 2;
#[doc = "<"]
pub const _spinCounterTriggerActivationEnums_CounterTriggerActivation_RisingEdge:
    _spinCounterTriggerActivationEnums = 3;
#[doc = "<"]
pub const _spinCounterTriggerActivationEnums_CounterTriggerActivation_AnyEdge:
    _spinCounterTriggerActivationEnums = 4;
pub const _spinCounterTriggerActivationEnums_NUM_COUNTERTRIGGERACTIVATION:
    _spinCounterTriggerActivationEnums = 5;
pub type _spinCounterTriggerActivationEnums = ::std::os::raw::c_uint;
pub use self::_spinCounterTriggerActivationEnums as spinCounterTriggerActivationEnums;
#[doc = "<"]
pub const _spinCounterSelectorEnums_CounterSelector_Counter0: _spinCounterSelectorEnums = 0;
#[doc = "<"]
pub const _spinCounterSelectorEnums_CounterSelector_Counter1: _spinCounterSelectorEnums = 1;
pub const _spinCounterSelectorEnums_NUM_COUNTERSELECTOR: _spinCounterSelectorEnums = 2;
pub type _spinCounterSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinCounterSelectorEnums as spinCounterSelectorEnums;
#[doc = "< The counter is idle."]
pub const _spinCounterStatusEnums_CounterStatus_CounterIdle: _spinCounterStatusEnums = 0;
#[doc = "< The counter is waiting for a start trigger."]
pub const _spinCounterStatusEnums_CounterStatus_CounterTriggerWait: _spinCounterStatusEnums = 1;
#[doc = "< The counter is counting for the specified duration."]
pub const _spinCounterStatusEnums_CounterStatus_CounterActive: _spinCounterStatusEnums = 2;
#[doc = "< The counter reached the CounterDuration count."]
pub const _spinCounterStatusEnums_CounterStatus_CounterCompleted: _spinCounterStatusEnums = 3;
#[doc = "< The counter reached its maximum possible count."]
pub const _spinCounterStatusEnums_CounterStatus_CounterOverflow: _spinCounterStatusEnums = 4;
pub const _spinCounterStatusEnums_NUM_COUNTERSTATUS: _spinCounterStatusEnums = 5;
pub type _spinCounterStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinCounterStatusEnums as spinCounterStatusEnums;
#[doc = "< Off"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_Off: _spinCounterTriggerSourceEnums =
    0;
#[doc = "< Line0"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_Line0:
    _spinCounterTriggerSourceEnums = 1;
#[doc = "< Line1"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_Line1:
    _spinCounterTriggerSourceEnums = 2;
#[doc = "< Line2"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_Line2:
    _spinCounterTriggerSourceEnums = 3;
#[doc = "< Line3"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_Line3:
    _spinCounterTriggerSourceEnums = 4;
#[doc = "< UserOutput0"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_UserOutput0:
    _spinCounterTriggerSourceEnums = 5;
#[doc = "< UserOutput1"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_UserOutput1:
    _spinCounterTriggerSourceEnums = 6;
#[doc = "< UserOutput2"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_UserOutput2:
    _spinCounterTriggerSourceEnums = 7;
#[doc = "< UserOutput3"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_UserOutput3:
    _spinCounterTriggerSourceEnums = 8;
#[doc = "< Counter0Start"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_Counter0Start:
    _spinCounterTriggerSourceEnums = 9;
#[doc = "< Counter1Start"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_Counter1Start:
    _spinCounterTriggerSourceEnums = 10;
#[doc = "< Counter0End"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_Counter0End:
    _spinCounterTriggerSourceEnums = 11;
#[doc = "< Counter1End"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_Counter1End:
    _spinCounterTriggerSourceEnums = 12;
#[doc = "< LogicBlock0"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_LogicBlock0:
    _spinCounterTriggerSourceEnums = 13;
#[doc = "< LogicBlock1"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_LogicBlock1:
    _spinCounterTriggerSourceEnums = 14;
#[doc = "< ExposureStart"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_ExposureStart:
    _spinCounterTriggerSourceEnums = 15;
#[doc = "< ExposureEnd"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_ExposureEnd:
    _spinCounterTriggerSourceEnums = 16;
#[doc = "< FrameTriggerWait"]
pub const _spinCounterTriggerSourceEnums_CounterTriggerSource_FrameTriggerWait:
    _spinCounterTriggerSourceEnums = 17;
pub const _spinCounterTriggerSourceEnums_NUM_COUNTERTRIGGERSOURCE: _spinCounterTriggerSourceEnums =
    18;
pub type _spinCounterTriggerSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinCounterTriggerSourceEnums as spinCounterTriggerSourceEnums;
#[doc = "< Off"]
pub const _spinCounterResetSourceEnums_CounterResetSource_Off: _spinCounterResetSourceEnums = 0;
#[doc = "< Line0"]
pub const _spinCounterResetSourceEnums_CounterResetSource_Line0: _spinCounterResetSourceEnums = 1;
#[doc = "< Line1"]
pub const _spinCounterResetSourceEnums_CounterResetSource_Line1: _spinCounterResetSourceEnums = 2;
#[doc = "< Line2"]
pub const _spinCounterResetSourceEnums_CounterResetSource_Line2: _spinCounterResetSourceEnums = 3;
#[doc = "< Line3"]
pub const _spinCounterResetSourceEnums_CounterResetSource_Line3: _spinCounterResetSourceEnums = 4;
#[doc = "< UserOutput0"]
pub const _spinCounterResetSourceEnums_CounterResetSource_UserOutput0:
    _spinCounterResetSourceEnums = 5;
#[doc = "< UserOutput1"]
pub const _spinCounterResetSourceEnums_CounterResetSource_UserOutput1:
    _spinCounterResetSourceEnums = 6;
#[doc = "< UserOutput2"]
pub const _spinCounterResetSourceEnums_CounterResetSource_UserOutput2:
    _spinCounterResetSourceEnums = 7;
#[doc = "< UserOutput3"]
pub const _spinCounterResetSourceEnums_CounterResetSource_UserOutput3:
    _spinCounterResetSourceEnums = 8;
#[doc = "< Counter0Start"]
pub const _spinCounterResetSourceEnums_CounterResetSource_Counter0Start:
    _spinCounterResetSourceEnums = 9;
#[doc = "< Counter1Start"]
pub const _spinCounterResetSourceEnums_CounterResetSource_Counter1Start:
    _spinCounterResetSourceEnums = 10;
#[doc = "< Counter0End"]
pub const _spinCounterResetSourceEnums_CounterResetSource_Counter0End:
    _spinCounterResetSourceEnums = 11;
#[doc = "< Counter1End"]
pub const _spinCounterResetSourceEnums_CounterResetSource_Counter1End:
    _spinCounterResetSourceEnums = 12;
#[doc = "< LogicBlock0"]
pub const _spinCounterResetSourceEnums_CounterResetSource_LogicBlock0:
    _spinCounterResetSourceEnums = 13;
#[doc = "< LogicBlock1"]
pub const _spinCounterResetSourceEnums_CounterResetSource_LogicBlock1:
    _spinCounterResetSourceEnums = 14;
#[doc = "< ExposureStart"]
pub const _spinCounterResetSourceEnums_CounterResetSource_ExposureStart:
    _spinCounterResetSourceEnums = 15;
#[doc = "< ExposureEnd"]
pub const _spinCounterResetSourceEnums_CounterResetSource_ExposureEnd:
    _spinCounterResetSourceEnums = 16;
#[doc = "< FrameTriggerWait"]
pub const _spinCounterResetSourceEnums_CounterResetSource_FrameTriggerWait:
    _spinCounterResetSourceEnums = 17;
pub const _spinCounterResetSourceEnums_NUM_COUNTERRESETSOURCE: _spinCounterResetSourceEnums = 18;
pub type _spinCounterResetSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinCounterResetSourceEnums as spinCounterResetSourceEnums;
#[doc = "< Off"]
pub const _spinCounterEventSourceEnums_CounterEventSource_Off: _spinCounterEventSourceEnums = 0;
#[doc = "< MHzTick"]
pub const _spinCounterEventSourceEnums_CounterEventSource_MHzTick: _spinCounterEventSourceEnums = 1;
#[doc = "< Line0"]
pub const _spinCounterEventSourceEnums_CounterEventSource_Line0: _spinCounterEventSourceEnums = 2;
#[doc = "< Line1"]
pub const _spinCounterEventSourceEnums_CounterEventSource_Line1: _spinCounterEventSourceEnums = 3;
#[doc = "< Line2"]
pub const _spinCounterEventSourceEnums_CounterEventSource_Line2: _spinCounterEventSourceEnums = 4;
#[doc = "< Line3"]
pub const _spinCounterEventSourceEnums_CounterEventSource_Line3: _spinCounterEventSourceEnums = 5;
#[doc = "< UserOutput0"]
pub const _spinCounterEventSourceEnums_CounterEventSource_UserOutput0:
    _spinCounterEventSourceEnums = 6;
#[doc = "< UserOutput1"]
pub const _spinCounterEventSourceEnums_CounterEventSource_UserOutput1:
    _spinCounterEventSourceEnums = 7;
#[doc = "< UserOutput2"]
pub const _spinCounterEventSourceEnums_CounterEventSource_UserOutput2:
    _spinCounterEventSourceEnums = 8;
#[doc = "< UserOutput3"]
pub const _spinCounterEventSourceEnums_CounterEventSource_UserOutput3:
    _spinCounterEventSourceEnums = 9;
#[doc = "< Counter0Start"]
pub const _spinCounterEventSourceEnums_CounterEventSource_Counter0Start:
    _spinCounterEventSourceEnums = 10;
#[doc = "< Counter1Start"]
pub const _spinCounterEventSourceEnums_CounterEventSource_Counter1Start:
    _spinCounterEventSourceEnums = 11;
#[doc = "< Counter0End"]
pub const _spinCounterEventSourceEnums_CounterEventSource_Counter0End:
    _spinCounterEventSourceEnums = 12;
#[doc = "< Counter1End"]
pub const _spinCounterEventSourceEnums_CounterEventSource_Counter1End:
    _spinCounterEventSourceEnums = 13;
#[doc = "< LogicBlock0"]
pub const _spinCounterEventSourceEnums_CounterEventSource_LogicBlock0:
    _spinCounterEventSourceEnums = 14;
#[doc = "< LogicBlock1"]
pub const _spinCounterEventSourceEnums_CounterEventSource_LogicBlock1:
    _spinCounterEventSourceEnums = 15;
#[doc = "< ExposureStart"]
pub const _spinCounterEventSourceEnums_CounterEventSource_ExposureStart:
    _spinCounterEventSourceEnums = 16;
#[doc = "< ExposureEnd"]
pub const _spinCounterEventSourceEnums_CounterEventSource_ExposureEnd:
    _spinCounterEventSourceEnums = 17;
#[doc = "< FrameTriggerWait"]
pub const _spinCounterEventSourceEnums_CounterEventSource_FrameTriggerWait:
    _spinCounterEventSourceEnums = 18;
pub const _spinCounterEventSourceEnums_NUM_COUNTEREVENTSOURCE: _spinCounterEventSourceEnums = 19;
pub type _spinCounterEventSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinCounterEventSourceEnums as spinCounterEventSourceEnums;
#[doc = "<"]
pub const _spinCounterEventActivationEnums_CounterEventActivation_LevelLow:
    _spinCounterEventActivationEnums = 0;
#[doc = "<"]
pub const _spinCounterEventActivationEnums_CounterEventActivation_LevelHigh:
    _spinCounterEventActivationEnums = 1;
#[doc = "<"]
pub const _spinCounterEventActivationEnums_CounterEventActivation_FallingEdge:
    _spinCounterEventActivationEnums = 2;
#[doc = "<"]
pub const _spinCounterEventActivationEnums_CounterEventActivation_RisingEdge:
    _spinCounterEventActivationEnums = 3;
#[doc = "<"]
pub const _spinCounterEventActivationEnums_CounterEventActivation_AnyEdge:
    _spinCounterEventActivationEnums = 4;
pub const _spinCounterEventActivationEnums_NUM_COUNTEREVENTACTIVATION:
    _spinCounterEventActivationEnums = 5;
pub type _spinCounterEventActivationEnums = ::std::os::raw::c_uint;
pub use self::_spinCounterEventActivationEnums as spinCounterEventActivationEnums;
#[doc = "<"]
pub const _spinCounterResetActivationEnums_CounterResetActivation_LevelLow:
    _spinCounterResetActivationEnums = 0;
#[doc = "<"]
pub const _spinCounterResetActivationEnums_CounterResetActivation_LevelHigh:
    _spinCounterResetActivationEnums = 1;
#[doc = "<"]
pub const _spinCounterResetActivationEnums_CounterResetActivation_FallingEdge:
    _spinCounterResetActivationEnums = 2;
#[doc = "<"]
pub const _spinCounterResetActivationEnums_CounterResetActivation_RisingEdge:
    _spinCounterResetActivationEnums = 3;
#[doc = "<"]
pub const _spinCounterResetActivationEnums_CounterResetActivation_AnyEdge:
    _spinCounterResetActivationEnums = 4;
pub const _spinCounterResetActivationEnums_NUM_COUNTERRESETACTIVATION:
    _spinCounterResetActivationEnums = 5;
pub type _spinCounterResetActivationEnums = ::std::os::raw::c_uint;
pub use self::_spinCounterResetActivationEnums as spinCounterResetActivationEnums;
#[doc = "< Data stream transmitter device."]
pub const _spinDeviceTypeEnums_DeviceType_Transmitter: _spinDeviceTypeEnums = 0;
#[doc = "< Data stream receiver device."]
pub const _spinDeviceTypeEnums_DeviceType_Receiver: _spinDeviceTypeEnums = 1;
#[doc = "< Data stream receiver and transmitter device."]
pub const _spinDeviceTypeEnums_DeviceType_Transceiver: _spinDeviceTypeEnums = 2;
#[doc = "< Controllable device (with no data stream handling)."]
pub const _spinDeviceTypeEnums_DeviceType_Peripheral: _spinDeviceTypeEnums = 3;
pub const _spinDeviceTypeEnums_NUM_DEVICETYPE: _spinDeviceTypeEnums = 4;
pub type _spinDeviceTypeEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceTypeEnums as spinDeviceTypeEnums;
#[doc = "< Connection is in use."]
pub const _spinDeviceConnectionStatusEnums_DeviceConnectionStatus_Active:
    _spinDeviceConnectionStatusEnums = 0;
#[doc = "< Connection is not in use."]
pub const _spinDeviceConnectionStatusEnums_DeviceConnectionStatus_Inactive:
    _spinDeviceConnectionStatusEnums = 1;
pub const _spinDeviceConnectionStatusEnums_NUM_DEVICECONNECTIONSTATUS:
    _spinDeviceConnectionStatusEnums = 2;
pub type _spinDeviceConnectionStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceConnectionStatusEnums as spinDeviceConnectionStatusEnums;
#[doc = "< Enables the DeviceLinkThroughputLimit feature."]
pub const _spinDeviceLinkThroughputLimitModeEnums_DeviceLinkThroughputLimitMode_On:
    _spinDeviceLinkThroughputLimitModeEnums = 0;
#[doc = "< Disables the DeviceLinkThroughputLimit feature."]
pub const _spinDeviceLinkThroughputLimitModeEnums_DeviceLinkThroughputLimitMode_Off:
    _spinDeviceLinkThroughputLimitModeEnums = 1;
pub const _spinDeviceLinkThroughputLimitModeEnums_NUM_DEVICELINKTHROUGHPUTLIMITMODE:
    _spinDeviceLinkThroughputLimitModeEnums = 2;
pub type _spinDeviceLinkThroughputLimitModeEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceLinkThroughputLimitModeEnums as spinDeviceLinkThroughputLimitModeEnums;
#[doc = "< Enables the Link heartbeat."]
pub const _spinDeviceLinkHeartbeatModeEnums_DeviceLinkHeartbeatMode_On:
    _spinDeviceLinkHeartbeatModeEnums = 0;
#[doc = "< Disables the Link heartbeat."]
pub const _spinDeviceLinkHeartbeatModeEnums_DeviceLinkHeartbeatMode_Off:
    _spinDeviceLinkHeartbeatModeEnums = 1;
pub const _spinDeviceLinkHeartbeatModeEnums_NUM_DEVICELINKHEARTBEATMODE:
    _spinDeviceLinkHeartbeatModeEnums = 2;
pub type _spinDeviceLinkHeartbeatModeEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceLinkHeartbeatModeEnums as spinDeviceLinkHeartbeatModeEnums;
#[doc = "< Data stream transmitter channel."]
pub const _spinDeviceStreamChannelTypeEnums_DeviceStreamChannelType_Transmitter:
    _spinDeviceStreamChannelTypeEnums = 0;
#[doc = "< Data stream receiver channel."]
pub const _spinDeviceStreamChannelTypeEnums_DeviceStreamChannelType_Receiver:
    _spinDeviceStreamChannelTypeEnums = 1;
pub const _spinDeviceStreamChannelTypeEnums_NUM_DEVICESTREAMCHANNELTYPE:
    _spinDeviceStreamChannelTypeEnums = 2;
pub type _spinDeviceStreamChannelTypeEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceStreamChannelTypeEnums as spinDeviceStreamChannelTypeEnums;
#[doc = "< Stream channel data is big Endian."]
pub const _spinDeviceStreamChannelEndiannessEnums_DeviceStreamChannelEndianness_Big:
    _spinDeviceStreamChannelEndiannessEnums = 0;
#[doc = "< Stream channel data is little Endian."]
pub const _spinDeviceStreamChannelEndiannessEnums_DeviceStreamChannelEndianness_Little:
    _spinDeviceStreamChannelEndiannessEnums = 1;
pub const _spinDeviceStreamChannelEndiannessEnums_NUM_DEVICESTREAMCHANNELENDIANNESS:
    _spinDeviceStreamChannelEndiannessEnums = 2;
pub type _spinDeviceStreamChannelEndiannessEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceStreamChannelEndiannessEnums as spinDeviceStreamChannelEndiannessEnums;
#[doc = "< Clock frequency of the image sensor of the camera."]
pub const _spinDeviceClockSelectorEnums_DeviceClockSelector_Sensor: _spinDeviceClockSelectorEnums =
    0;
#[doc = "< Clock frequency of the camera A/D conversion stage."]
pub const _spinDeviceClockSelectorEnums_DeviceClockSelector_SensorDigitization:
    _spinDeviceClockSelectorEnums = 1;
#[doc = "< Frequency of the Camera Link clock."]
pub const _spinDeviceClockSelectorEnums_DeviceClockSelector_CameraLink:
    _spinDeviceClockSelectorEnums = 2;
pub const _spinDeviceClockSelectorEnums_NUM_DEVICECLOCKSELECTOR: _spinDeviceClockSelectorEnums = 3;
pub type _spinDeviceClockSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceClockSelectorEnums as spinDeviceClockSelectorEnums;
#[doc = "< Serial port associated to the Camera link connection."]
pub const _spinDeviceSerialPortSelectorEnums_DeviceSerialPortSelector_CameraLink:
    _spinDeviceSerialPortSelectorEnums = 0;
pub const _spinDeviceSerialPortSelectorEnums_NUM_DEVICESERIALPORTSELECTOR:
    _spinDeviceSerialPortSelectorEnums = 1;
pub type _spinDeviceSerialPortSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceSerialPortSelectorEnums as spinDeviceSerialPortSelectorEnums;
#[doc = "< Serial port speed of 9600 baud."]
pub const _spinDeviceSerialPortBaudRateEnums_DeviceSerialPortBaudRate_Baud9600:
    _spinDeviceSerialPortBaudRateEnums = 0;
#[doc = "< Serial port speed of 19200 baud."]
pub const _spinDeviceSerialPortBaudRateEnums_DeviceSerialPortBaudRate_Baud19200:
    _spinDeviceSerialPortBaudRateEnums = 1;
#[doc = "< Serial port speed of 38400 baud."]
pub const _spinDeviceSerialPortBaudRateEnums_DeviceSerialPortBaudRate_Baud38400:
    _spinDeviceSerialPortBaudRateEnums = 2;
#[doc = "< Serial port speed of 57600 baud."]
pub const _spinDeviceSerialPortBaudRateEnums_DeviceSerialPortBaudRate_Baud57600:
    _spinDeviceSerialPortBaudRateEnums = 3;
#[doc = "< Serial port speed of 115200 baud."]
pub const _spinDeviceSerialPortBaudRateEnums_DeviceSerialPortBaudRate_Baud115200:
    _spinDeviceSerialPortBaudRateEnums = 4;
#[doc = "< Serial port speed of 230400 baud."]
pub const _spinDeviceSerialPortBaudRateEnums_DeviceSerialPortBaudRate_Baud230400:
    _spinDeviceSerialPortBaudRateEnums = 5;
#[doc = "< Serial port speed of 460800 baud."]
pub const _spinDeviceSerialPortBaudRateEnums_DeviceSerialPortBaudRate_Baud460800:
    _spinDeviceSerialPortBaudRateEnums = 6;
#[doc = "< Serial port speed of 921600 baud."]
pub const _spinDeviceSerialPortBaudRateEnums_DeviceSerialPortBaudRate_Baud921600:
    _spinDeviceSerialPortBaudRateEnums = 7;
pub const _spinDeviceSerialPortBaudRateEnums_NUM_DEVICESERIALPORTBAUDRATE:
    _spinDeviceSerialPortBaudRateEnums = 8;
pub type _spinDeviceSerialPortBaudRateEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceSerialPortBaudRateEnums as spinDeviceSerialPortBaudRateEnums;
#[doc = "< 1 tap."]
pub const _spinSensorTapsEnums_SensorTaps_One: _spinSensorTapsEnums = 0;
#[doc = "< 2 taps."]
pub const _spinSensorTapsEnums_SensorTaps_Two: _spinSensorTapsEnums = 1;
#[doc = "< 3 taps."]
pub const _spinSensorTapsEnums_SensorTaps_Three: _spinSensorTapsEnums = 2;
#[doc = "< 4 taps."]
pub const _spinSensorTapsEnums_SensorTaps_Four: _spinSensorTapsEnums = 3;
#[doc = "< 8 taps."]
pub const _spinSensorTapsEnums_SensorTaps_Eight: _spinSensorTapsEnums = 4;
#[doc = "< 10 taps."]
pub const _spinSensorTapsEnums_SensorTaps_Ten: _spinSensorTapsEnums = 5;
pub const _spinSensorTapsEnums_NUM_SENSORTAPS: _spinSensorTapsEnums = 6;
pub type _spinSensorTapsEnums = ::std::os::raw::c_uint;
pub use self::_spinSensorTapsEnums as spinSensorTapsEnums;
#[doc = "< 1 tap."]
pub const _spinSensorDigitizationTapsEnums_SensorDigitizationTaps_One:
    _spinSensorDigitizationTapsEnums = 0;
#[doc = "< 2 taps."]
pub const _spinSensorDigitizationTapsEnums_SensorDigitizationTaps_Two:
    _spinSensorDigitizationTapsEnums = 1;
#[doc = "< 3 taps."]
pub const _spinSensorDigitizationTapsEnums_SensorDigitizationTaps_Three:
    _spinSensorDigitizationTapsEnums = 2;
#[doc = "< 4 taps."]
pub const _spinSensorDigitizationTapsEnums_SensorDigitizationTaps_Four:
    _spinSensorDigitizationTapsEnums = 3;
#[doc = "< 8 taps."]
pub const _spinSensorDigitizationTapsEnums_SensorDigitizationTaps_Eight:
    _spinSensorDigitizationTapsEnums = 4;
#[doc = "< 10 taps."]
pub const _spinSensorDigitizationTapsEnums_SensorDigitizationTaps_Ten:
    _spinSensorDigitizationTapsEnums = 5;
pub const _spinSensorDigitizationTapsEnums_NUM_SENSORDIGITIZATIONTAPS:
    _spinSensorDigitizationTapsEnums = 6;
pub type _spinSensorDigitizationTapsEnums = ::std::os::raw::c_uint;
pub use self::_spinSensorDigitizationTapsEnums as spinSensorDigitizationTapsEnums;
#[doc = "< Selected feature will control the region 0."]
pub const _spinRegionSelectorEnums_RegionSelector_Region0: _spinRegionSelectorEnums = 0;
#[doc = "< Selected feature will control the region 1."]
pub const _spinRegionSelectorEnums_RegionSelector_Region1: _spinRegionSelectorEnums = 1;
#[doc = "< Selected feature will control the region 2."]
pub const _spinRegionSelectorEnums_RegionSelector_Region2: _spinRegionSelectorEnums = 2;
#[doc = "< Selected features will control all the regions at the same time."]
pub const _spinRegionSelectorEnums_RegionSelector_All: _spinRegionSelectorEnums = 3;
pub const _spinRegionSelectorEnums_NUM_REGIONSELECTOR: _spinRegionSelectorEnums = 4;
pub type _spinRegionSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinRegionSelectorEnums as spinRegionSelectorEnums;
#[doc = "< Disable the usage of the Region."]
pub const _spinRegionModeEnums_RegionMode_Off: _spinRegionModeEnums = 0;
#[doc = "< Enable the usage of the Region."]
pub const _spinRegionModeEnums_RegionMode_On: _spinRegionModeEnums = 1;
pub const _spinRegionModeEnums_NUM_REGIONMODE: _spinRegionModeEnums = 2;
pub type _spinRegionModeEnums = ::std::os::raw::c_uint;
pub use self::_spinRegionModeEnums as spinRegionModeEnums;
#[doc = "< The destination of the region is the data stream 0."]
pub const _spinRegionDestinationEnums_RegionDestination_Stream0: _spinRegionDestinationEnums = 0;
#[doc = "< The destination of the region is the data stream 1."]
pub const _spinRegionDestinationEnums_RegionDestination_Stream1: _spinRegionDestinationEnums = 1;
#[doc = "< The destination of the region is the data stream 2."]
pub const _spinRegionDestinationEnums_RegionDestination_Stream2: _spinRegionDestinationEnums = 2;
pub const _spinRegionDestinationEnums_NUM_REGIONDESTINATION: _spinRegionDestinationEnums = 3;
pub type _spinRegionDestinationEnums = ::std::os::raw::c_uint;
pub use self::_spinRegionDestinationEnums as spinRegionDestinationEnums;
#[doc = "< The acquisition of intensity of the reflected light is controlled."]
pub const _spinImageComponentSelectorEnums_ImageComponentSelector_Intensity:
    _spinImageComponentSelectorEnums = 0;
#[doc = "< The acquisition of color of the reflected light is controlled"]
pub const _spinImageComponentSelectorEnums_ImageComponentSelector_Color:
    _spinImageComponentSelectorEnums = 1;
#[doc = "< The acquisition of non-visible infrared light is controlled."]
pub const _spinImageComponentSelectorEnums_ImageComponentSelector_Infrared:
    _spinImageComponentSelectorEnums = 2;
#[doc = "< The acquisition of non-visible ultraviolet light is controlled."]
pub const _spinImageComponentSelectorEnums_ImageComponentSelector_Ultraviolet:
    _spinImageComponentSelectorEnums = 3;
#[doc = "< The acquisition of range (distance) data is controlled. The data produced may be only range (2.5D) or a point cloud 3D coordinates depending on the Scan3dControl."]
pub const _spinImageComponentSelectorEnums_ImageComponentSelector_Range:
    _spinImageComponentSelectorEnums = 4;
#[doc = "< The acquisition of stereo camera disparity data is controlled. Disparity is a more specific range format approximately inversely proportional to distance. Disparity is typically given in pixel units."]
pub const _spinImageComponentSelectorEnums_ImageComponentSelector_Disparity:
    _spinImageComponentSelectorEnums = 5;
#[doc = "< The acquisition of confidence map of the acquired image is controlled. Confidence data may be binary (0 - invalid) or an integer where 0 is invalid and increasing value is increased confidence in the data in the corresponding pixel. If floating point representation is used the confidence image is normalized to the range [0,1], for integer representation the maximum possible integer represents maximum confidence."]
pub const _spinImageComponentSelectorEnums_ImageComponentSelector_Confidence:
    _spinImageComponentSelectorEnums = 6;
#[doc = "< The acquisition of data measuring how much light is scattered around the reflected light. In processing this is used as an additional intensity image, often together with the standard intensity."]
pub const _spinImageComponentSelectorEnums_ImageComponentSelector_Scatter:
    _spinImageComponentSelectorEnums = 7;
pub const _spinImageComponentSelectorEnums_NUM_IMAGECOMPONENTSELECTOR:
    _spinImageComponentSelectorEnums = 8;
pub type _spinImageComponentSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinImageComponentSelectorEnums as spinImageComponentSelectorEnums;
#[doc = "< Monochrome 1-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono1p:
    _spinPixelFormatInfoSelectorEnums = 0;
#[doc = "< Monochrome 2-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono2p:
    _spinPixelFormatInfoSelectorEnums = 1;
#[doc = "< Monochrome 4-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono4p:
    _spinPixelFormatInfoSelectorEnums = 2;
#[doc = "< Monochrome 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono8:
    _spinPixelFormatInfoSelectorEnums = 3;
#[doc = "< Monochrome 8-bit signed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono8s:
    _spinPixelFormatInfoSelectorEnums = 4;
#[doc = "< Monochrome 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono10:
    _spinPixelFormatInfoSelectorEnums = 5;
#[doc = "< Monochrome 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono10p:
    _spinPixelFormatInfoSelectorEnums = 6;
#[doc = "< Monochrome 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono12:
    _spinPixelFormatInfoSelectorEnums = 7;
#[doc = "< Monochrome 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono12p:
    _spinPixelFormatInfoSelectorEnums = 8;
#[doc = "< Monochrome 14-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono14:
    _spinPixelFormatInfoSelectorEnums = 9;
#[doc = "< Monochrome 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono16:
    _spinPixelFormatInfoSelectorEnums = 10;
#[doc = "< Monochrome 16-bit signed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono16s:
    _spinPixelFormatInfoSelectorEnums = 11;
#[doc = "< Monochrome 32-bit float"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Mono32f:
    _spinPixelFormatInfoSelectorEnums = 12;
#[doc = "< Bayer Blue-Green 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerBG8:
    _spinPixelFormatInfoSelectorEnums = 13;
#[doc = "< Bayer Blue-Green 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerBG10:
    _spinPixelFormatInfoSelectorEnums = 14;
#[doc = "< Bayer Blue-Green 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerBG10p:
    _spinPixelFormatInfoSelectorEnums = 15;
#[doc = "< Bayer Blue-Green 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerBG12:
    _spinPixelFormatInfoSelectorEnums = 16;
#[doc = "< Bayer Blue-Green 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerBG12p:
    _spinPixelFormatInfoSelectorEnums = 17;
#[doc = "< Bayer Blue-Green 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerBG16:
    _spinPixelFormatInfoSelectorEnums = 18;
#[doc = "< Bayer Green-Blue 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGB8:
    _spinPixelFormatInfoSelectorEnums = 19;
#[doc = "< Bayer Green-Blue 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGB10:
    _spinPixelFormatInfoSelectorEnums = 20;
#[doc = "< Bayer Green-Blue 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGB10p:
    _spinPixelFormatInfoSelectorEnums = 21;
#[doc = "< Bayer Green-Blue 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGB12:
    _spinPixelFormatInfoSelectorEnums = 22;
#[doc = "< Bayer Green-Blue 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGB12p:
    _spinPixelFormatInfoSelectorEnums = 23;
#[doc = "< Bayer Green-Blue 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGB16:
    _spinPixelFormatInfoSelectorEnums = 24;
#[doc = "< Bayer Green-Red 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGR8:
    _spinPixelFormatInfoSelectorEnums = 25;
#[doc = "< Bayer Green-Red 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGR10:
    _spinPixelFormatInfoSelectorEnums = 26;
#[doc = "< Bayer Green-Red 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGR10p:
    _spinPixelFormatInfoSelectorEnums = 27;
#[doc = "< Bayer Green-Red 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGR12:
    _spinPixelFormatInfoSelectorEnums = 28;
#[doc = "< Bayer Green-Red 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGR12p:
    _spinPixelFormatInfoSelectorEnums = 29;
#[doc = "< Bayer Green-Red 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerGR16:
    _spinPixelFormatInfoSelectorEnums = 30;
#[doc = "< Bayer Red-Green 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerRG8:
    _spinPixelFormatInfoSelectorEnums = 31;
#[doc = "< Bayer Red-Green 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerRG10:
    _spinPixelFormatInfoSelectorEnums = 32;
#[doc = "< Bayer Red-Green 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerRG10p:
    _spinPixelFormatInfoSelectorEnums = 33;
#[doc = "< Bayer Red-Green 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerRG12:
    _spinPixelFormatInfoSelectorEnums = 34;
#[doc = "< Bayer Red-Green 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerRG12p:
    _spinPixelFormatInfoSelectorEnums = 35;
#[doc = "< Bayer Red-Green 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerRG16:
    _spinPixelFormatInfoSelectorEnums = 36;
#[doc = "< Red-Green-Blue-alpha 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGBa8:
    _spinPixelFormatInfoSelectorEnums = 37;
#[doc = "< Red-Green-Blue-alpha 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGBa10:
    _spinPixelFormatInfoSelectorEnums = 38;
#[doc = "< Red-Green-Blue-alpha 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGBa10p:
    _spinPixelFormatInfoSelectorEnums = 39;
#[doc = "< Red-Green-Blue-alpha 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGBa12:
    _spinPixelFormatInfoSelectorEnums = 40;
#[doc = "< Red-Green-Blue-alpha 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGBa12p:
    _spinPixelFormatInfoSelectorEnums = 41;
#[doc = "< Red-Green-Blue-alpha 14-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGBa14:
    _spinPixelFormatInfoSelectorEnums = 42;
#[doc = "< Red-Green-Blue-alpha 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGBa16:
    _spinPixelFormatInfoSelectorEnums = 43;
#[doc = "< Red-Green-Blue 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB8:
    _spinPixelFormatInfoSelectorEnums = 44;
#[doc = "< Red-Green-Blue 8-bit planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB8_Planar:
    _spinPixelFormatInfoSelectorEnums = 45;
#[doc = "< Red-Green-Blue 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB10:
    _spinPixelFormatInfoSelectorEnums = 46;
#[doc = "< Red-Green-Blue 10-bit unpacked planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB10_Planar:
    _spinPixelFormatInfoSelectorEnums = 47;
#[doc = "< Red-Green-Blue 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB10p:
    _spinPixelFormatInfoSelectorEnums = 48;
#[doc = "< Red-Green-Blue 10-bit packed into 32-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB10p32:
    _spinPixelFormatInfoSelectorEnums = 49;
#[doc = "< Red-Green-Blue 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB12:
    _spinPixelFormatInfoSelectorEnums = 50;
#[doc = "< Red-Green-Blue 12-bit unpacked planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB12_Planar:
    _spinPixelFormatInfoSelectorEnums = 51;
#[doc = "< Red-Green-Blue 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB12p:
    _spinPixelFormatInfoSelectorEnums = 52;
#[doc = "< Red-Green-Blue 14-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB14:
    _spinPixelFormatInfoSelectorEnums = 53;
#[doc = "< Red-Green-Blue 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB16:
    _spinPixelFormatInfoSelectorEnums = 54;
#[doc = "< Red-Green-Blue 16-bit signed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB16s:
    _spinPixelFormatInfoSelectorEnums = 55;
#[doc = "< Red-Green-Blue 32-bit float"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB32f:
    _spinPixelFormatInfoSelectorEnums = 56;
#[doc = "< Red-Green-Blue 16-bit planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB16_Planar:
    _spinPixelFormatInfoSelectorEnums = 57;
#[doc = "< Red-Green-Blue 5/6/5-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGB565p:
    _spinPixelFormatInfoSelectorEnums = 58;
#[doc = "< Blue-Green-Red-alpha 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGRa8:
    _spinPixelFormatInfoSelectorEnums = 59;
#[doc = "< Blue-Green-Red-alpha 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGRa10:
    _spinPixelFormatInfoSelectorEnums = 60;
#[doc = "< Blue-Green-Red-alpha 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGRa10p:
    _spinPixelFormatInfoSelectorEnums = 61;
#[doc = "< Blue-Green-Red-alpha 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGRa12:
    _spinPixelFormatInfoSelectorEnums = 62;
#[doc = "< Blue-Green-Red-alpha 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGRa12p:
    _spinPixelFormatInfoSelectorEnums = 63;
#[doc = "< Blue-Green-Red-alpha 14-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGRa14:
    _spinPixelFormatInfoSelectorEnums = 64;
#[doc = "< Blue-Green-Red-alpha 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGRa16:
    _spinPixelFormatInfoSelectorEnums = 65;
#[doc = "< Red-Green-Blue-alpha 32-bit float"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_RGBa32f:
    _spinPixelFormatInfoSelectorEnums = 66;
#[doc = "< Blue-Green-Red 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGR8:
    _spinPixelFormatInfoSelectorEnums = 67;
#[doc = "< Blue-Green-Red 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGR10:
    _spinPixelFormatInfoSelectorEnums = 68;
#[doc = "< Blue-Green-Red 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGR10p:
    _spinPixelFormatInfoSelectorEnums = 69;
#[doc = "< Blue-Green-Red 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGR12:
    _spinPixelFormatInfoSelectorEnums = 70;
#[doc = "< Blue-Green-Red 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGR12p:
    _spinPixelFormatInfoSelectorEnums = 71;
#[doc = "< Blue-Green-Red 14-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGR14:
    _spinPixelFormatInfoSelectorEnums = 72;
#[doc = "< Blue-Green-Red 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGR16:
    _spinPixelFormatInfoSelectorEnums = 73;
#[doc = "< Blue-Green-Red 5/6/5-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BGR565p:
    _spinPixelFormatInfoSelectorEnums = 74;
#[doc = "< Red 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_R8:
    _spinPixelFormatInfoSelectorEnums = 75;
#[doc = "< Red 10-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_R10:
    _spinPixelFormatInfoSelectorEnums = 76;
#[doc = "< Red 12-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_R12:
    _spinPixelFormatInfoSelectorEnums = 77;
#[doc = "< Red 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_R16:
    _spinPixelFormatInfoSelectorEnums = 78;
#[doc = "< Green 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_G8:
    _spinPixelFormatInfoSelectorEnums = 79;
#[doc = "< Green 10-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_G10:
    _spinPixelFormatInfoSelectorEnums = 80;
#[doc = "< Green 12-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_G12:
    _spinPixelFormatInfoSelectorEnums = 81;
#[doc = "< Green 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_G16:
    _spinPixelFormatInfoSelectorEnums = 82;
#[doc = "< Blue 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_B8:
    _spinPixelFormatInfoSelectorEnums = 83;
#[doc = "< Blue 10-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_B10:
    _spinPixelFormatInfoSelectorEnums = 84;
#[doc = "< Blue 12-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_B12:
    _spinPixelFormatInfoSelectorEnums = 85;
#[doc = "< Blue 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_B16:
    _spinPixelFormatInfoSelectorEnums = 86;
#[doc = "< 3D coordinate A-B-C 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_ABC8:
    _spinPixelFormatInfoSelectorEnums = 87;
#[doc = "< 3D coordinate A-B-C 8-bit planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_ABC8_Planar:
    _spinPixelFormatInfoSelectorEnums = 88;
#[doc = "< 3D coordinate A-B-C 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_ABC10p:
    _spinPixelFormatInfoSelectorEnums = 89;
#[doc = "< 3D coordinate A-B-C 10-bit packed planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_ABC10p_Planar:
    _spinPixelFormatInfoSelectorEnums = 90;
#[doc = "< 3D coordinate A-B-C 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_ABC12p:
    _spinPixelFormatInfoSelectorEnums = 91;
#[doc = "< 3D coordinate A-B-C 12-bit packed planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_ABC12p_Planar:
    _spinPixelFormatInfoSelectorEnums = 92;
#[doc = "< 3D coordinate A-B-C 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_ABC16:
    _spinPixelFormatInfoSelectorEnums = 93;
#[doc = "< 3D coordinate A-B-C 16-bit planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_ABC16_Planar:
    _spinPixelFormatInfoSelectorEnums = 94;
#[doc = "< 3D coordinate A-B-C 32-bit floating point"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_ABC32f:
    _spinPixelFormatInfoSelectorEnums = 95;
#[doc = "< 3D coordinate A-B-C 32-bit floating point planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_ABC32f_Planar:
    _spinPixelFormatInfoSelectorEnums = 96;
#[doc = "< 3D coordinate A-C 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_AC8:
    _spinPixelFormatInfoSelectorEnums = 97;
#[doc = "< 3D coordinate A-C 8-bit planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_AC8_Planar:
    _spinPixelFormatInfoSelectorEnums = 98;
#[doc = "< 3D coordinate A-C 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_AC10p:
    _spinPixelFormatInfoSelectorEnums = 99;
#[doc = "< 3D coordinate A-C 10-bit packed planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_AC10p_Planar:
    _spinPixelFormatInfoSelectorEnums = 100;
#[doc = "< 3D coordinate A-C 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_AC12p:
    _spinPixelFormatInfoSelectorEnums = 101;
#[doc = "< 3D coordinate A-C 12-bit packed planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_AC12p_Planar:
    _spinPixelFormatInfoSelectorEnums = 102;
#[doc = "< 3D coordinate A-C 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_AC16:
    _spinPixelFormatInfoSelectorEnums = 103;
#[doc = "< 3D coordinate A-C 16-bit planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_AC16_Planar:
    _spinPixelFormatInfoSelectorEnums = 104;
#[doc = "< 3D coordinate A-C 32-bit floating point"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_AC32f:
    _spinPixelFormatInfoSelectorEnums = 105;
#[doc = "< 3D coordinate A-C 32-bit floating point planar"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_AC32f_Planar:
    _spinPixelFormatInfoSelectorEnums = 106;
#[doc = "< 3D coordinate A 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_A8:
    _spinPixelFormatInfoSelectorEnums = 107;
#[doc = "< 3D coordinate A 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_A10p:
    _spinPixelFormatInfoSelectorEnums = 108;
#[doc = "< 3D coordinate A 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_A12p:
    _spinPixelFormatInfoSelectorEnums = 109;
#[doc = "< 3D coordinate A 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_A16:
    _spinPixelFormatInfoSelectorEnums = 110;
#[doc = "< 3D coordinate A 32-bit floating point"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_A32f:
    _spinPixelFormatInfoSelectorEnums = 111;
#[doc = "< 3D coordinate B 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_B8:
    _spinPixelFormatInfoSelectorEnums = 112;
#[doc = "< 3D coordinate B 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_B10p:
    _spinPixelFormatInfoSelectorEnums = 113;
#[doc = "< 3D coordinate B 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_B12p:
    _spinPixelFormatInfoSelectorEnums = 114;
#[doc = "< 3D coordinate B 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_B16:
    _spinPixelFormatInfoSelectorEnums = 115;
#[doc = "< 3D coordinate B 32-bit floating point"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_B32f:
    _spinPixelFormatInfoSelectorEnums = 116;
#[doc = "< 3D coordinate C 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_C8:
    _spinPixelFormatInfoSelectorEnums = 117;
#[doc = "< 3D coordinate C 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_C10p:
    _spinPixelFormatInfoSelectorEnums = 118;
#[doc = "< 3D coordinate C 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_C12p:
    _spinPixelFormatInfoSelectorEnums = 119;
#[doc = "< 3D coordinate C 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_C16:
    _spinPixelFormatInfoSelectorEnums = 120;
#[doc = "< 3D coordinate C 32-bit floating point"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Coord3D_C32f:
    _spinPixelFormatInfoSelectorEnums = 121;
#[doc = "< Confidence 1-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Confidence1:
    _spinPixelFormatInfoSelectorEnums = 122;
#[doc = "< Confidence 1-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Confidence1p:
    _spinPixelFormatInfoSelectorEnums = 123;
#[doc = "< Confidence 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Confidence8:
    _spinPixelFormatInfoSelectorEnums = 124;
#[doc = "< Confidence 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Confidence16:
    _spinPixelFormatInfoSelectorEnums = 125;
#[doc = "< Confidence 32-bit floating point"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Confidence32f:
    _spinPixelFormatInfoSelectorEnums = 126;
#[doc = "< Bi-color Blue/Green - Red/Green 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BiColorBGRG8:
    _spinPixelFormatInfoSelectorEnums = 127;
#[doc = "< Bi-color Blue/Green - Red/Green 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BiColorBGRG10:
    _spinPixelFormatInfoSelectorEnums = 128;
#[doc = "< Bi-color Blue/Green - Red/Green 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BiColorBGRG10p:
    _spinPixelFormatInfoSelectorEnums = 129;
#[doc = "< Bi-color Blue/Green - Red/Green 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BiColorBGRG12:
    _spinPixelFormatInfoSelectorEnums = 130;
#[doc = "< Bi-color Blue/Green - Red/Green 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BiColorBGRG12p:
    _spinPixelFormatInfoSelectorEnums = 131;
#[doc = "< Bi-color Red/Green - Blue/Green 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BiColorRGBG8:
    _spinPixelFormatInfoSelectorEnums = 132;
#[doc = "< Bi-color Red/Green - Blue/Green 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BiColorRGBG10:
    _spinPixelFormatInfoSelectorEnums = 133;
#[doc = "< Bi-color Red/Green - Blue/Green 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BiColorRGBG10p:
    _spinPixelFormatInfoSelectorEnums = 134;
#[doc = "< Bi-color Red/Green - Blue/Green 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BiColorRGBG12:
    _spinPixelFormatInfoSelectorEnums = 135;
#[doc = "< Bi-color Red/Green - Blue/Green 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BiColorRGBG12p:
    _spinPixelFormatInfoSelectorEnums = 136;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WBWG8:
    _spinPixelFormatInfoSelectorEnums = 137;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WBWG10:
    _spinPixelFormatInfoSelectorEnums = 138;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WBWG10p:
    _spinPixelFormatInfoSelectorEnums = 139;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WBWG12:
    _spinPixelFormatInfoSelectorEnums = 140;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WBWG12p:
    _spinPixelFormatInfoSelectorEnums = 141;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 14-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WBWG14:
    _spinPixelFormatInfoSelectorEnums = 142;
#[doc = "< Sparse Color Filter #1 White-Blue-White-Green 16-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WBWG16:
    _spinPixelFormatInfoSelectorEnums = 143;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWB8:
    _spinPixelFormatInfoSelectorEnums = 144;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWB10:
    _spinPixelFormatInfoSelectorEnums = 145;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWB10p:
    _spinPixelFormatInfoSelectorEnums = 146;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWB12:
    _spinPixelFormatInfoSelectorEnums = 147;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWB12p:
    _spinPixelFormatInfoSelectorEnums = 148;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 14-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWB14:
    _spinPixelFormatInfoSelectorEnums = 149;
#[doc = "< Sparse Color Filter #1 White-Green-White-Blue 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWB16:
    _spinPixelFormatInfoSelectorEnums = 150;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWR8:
    _spinPixelFormatInfoSelectorEnums = 151;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWR10:
    _spinPixelFormatInfoSelectorEnums = 152;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWR10p:
    _spinPixelFormatInfoSelectorEnums = 153;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWR12:
    _spinPixelFormatInfoSelectorEnums = 154;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWR12p:
    _spinPixelFormatInfoSelectorEnums = 155;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 14-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWR14:
    _spinPixelFormatInfoSelectorEnums = 156;
#[doc = "< Sparse Color Filter #1 White-Green-White-Red 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WGWR16:
    _spinPixelFormatInfoSelectorEnums = 157;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WRWG8:
    _spinPixelFormatInfoSelectorEnums = 158;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WRWG10:
    _spinPixelFormatInfoSelectorEnums = 159;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WRWG10p:
    _spinPixelFormatInfoSelectorEnums = 160;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WRWG12:
    _spinPixelFormatInfoSelectorEnums = 161;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WRWG12p:
    _spinPixelFormatInfoSelectorEnums = 162;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 14-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WRWG14:
    _spinPixelFormatInfoSelectorEnums = 163;
#[doc = "< Sparse Color Filter #1 White-Red-White-Green 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_SCF1WRWG16:
    _spinPixelFormatInfoSelectorEnums = 164;
#[doc = "< YCbCr 4:4:4 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr8:
    _spinPixelFormatInfoSelectorEnums = 165;
#[doc = "< YCbCr 4:4:4 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr8_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 166;
#[doc = "< YCbCr 4:4:4 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr10_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 167;
#[doc = "< YCbCr 4:4:4 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr10p_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 168;
#[doc = "< YCbCr 4:4:4 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr12_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 169;
#[doc = "< YCbCr 4:4:4 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr12p_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 170;
#[doc = "< YCbCr 4:1:1 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr411_8:
    _spinPixelFormatInfoSelectorEnums = 171;
#[doc = "< YCbCr 4:1:1 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr411_8_CbYYCrYY:
    _spinPixelFormatInfoSelectorEnums = 172;
#[doc = "< YCbCr 4:2:2 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr422_8:
    _spinPixelFormatInfoSelectorEnums = 173;
#[doc = "< YCbCr 4:2:2 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr422_8_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 174;
#[doc = "< YCbCr 4:2:2 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr422_10:
    _spinPixelFormatInfoSelectorEnums = 175;
#[doc = "< YCbCr 4:2:2 10-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr422_10_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 176;
#[doc = "< YCbCr 4:2:2 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr422_10p:
    _spinPixelFormatInfoSelectorEnums = 177;
#[doc = "< YCbCr 4:2:2 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr422_10p_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 178;
#[doc = "< YCbCr 4:2:2 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr422_12:
    _spinPixelFormatInfoSelectorEnums = 179;
#[doc = "< YCbCr 4:2:2 12-bit unpacked"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr422_12_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 180;
#[doc = "< YCbCr 4:2:2 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr422_12p:
    _spinPixelFormatInfoSelectorEnums = 181;
#[doc = "< YCbCr 4:2:2 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr422_12p_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 182;
#[doc = "< YCbCr 4:4:4 8-bit BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_8_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 183;
#[doc = "< YCbCr 4:4:4 10-bit unpacked BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_10_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 184;
#[doc = "< YCbCr 4:4:4 10-bit packed BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_10p_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 185;
#[doc = "< YCbCr 4:4:4 12-bit unpacked BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_12_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 186;
#[doc = "< YCbCr 4:4:4 12-bit packed BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_12p_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 187;
#[doc = "< YCbCr 4:1:1 8-bit BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_411_8_CbYYCrYY:
    _spinPixelFormatInfoSelectorEnums = 188;
#[doc = "< YCbCr 4:2:2 8-bit BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_422_8:
    _spinPixelFormatInfoSelectorEnums = 189;
#[doc = "< YCbCr 4:2:2 8-bit BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_422_8_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 190;
#[doc = "< YCbCr 4:2:2 10-bit unpacked BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_422_10:
    _spinPixelFormatInfoSelectorEnums = 191;
#[doc = "< YCbCr 4:2:2 10-bit unpacked BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_422_10_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 192;
#[doc = "< YCbCr 4:2:2 10-bit packed BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_422_10p:
    _spinPixelFormatInfoSelectorEnums = 193;
#[doc = "< YCbCr 4:2:2 10-bit packed BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_422_10p_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 194;
#[doc = "< YCbCr 4:2:2 12-bit unpacked BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_422_12:
    _spinPixelFormatInfoSelectorEnums = 195;
#[doc = "< YCbCr 4:2:2 12-bit unpacked BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_422_12_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 196;
#[doc = "< YCbCr 4:2:2 12-bit packed BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_422_12p:
    _spinPixelFormatInfoSelectorEnums = 197;
#[doc = "< YCbCr 4:2:2 12-bit packed BT.601"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr601_422_12p_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 198;
#[doc = "< YCbCr 4:4:4 8-bit BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_8_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 199;
#[doc = "< YCbCr 4:4:4 10-bit unpacked BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_10_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 200;
#[doc = "< YCbCr 4:4:4 10-bit packed BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_10p_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 201;
#[doc = "< YCbCr 4:4:4 12-bit unpacked BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_12_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 202;
#[doc = "< YCbCr 4:4:4 12-bit packed BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_12p_CbYCr:
    _spinPixelFormatInfoSelectorEnums = 203;
#[doc = "< YCbCr 4:1:1 8-bit BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_411_8_CbYYCrYY:
    _spinPixelFormatInfoSelectorEnums = 204;
#[doc = "< YCbCr 4:2:2 8-bit BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_422_8:
    _spinPixelFormatInfoSelectorEnums = 205;
#[doc = "< YCbCr 4:2:2 8-bit BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_422_8_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 206;
#[doc = "< YCbCr 4:2:2 10-bit unpacked BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_422_10:
    _spinPixelFormatInfoSelectorEnums = 207;
#[doc = "< YCbCr 4:2:2 10-bit unpacked BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_422_10_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 208;
#[doc = "< YCbCr 4:2:2 10-bit packed BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_422_10p:
    _spinPixelFormatInfoSelectorEnums = 209;
#[doc = "< YCbCr 4:2:2 10-bit packed BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_422_10p_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 210;
#[doc = "< YCbCr 4:2:2 12-bit unpacked BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_422_12:
    _spinPixelFormatInfoSelectorEnums = 211;
#[doc = "< YCbCr 4:2:2 12-bit unpacked BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_422_12_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 212;
#[doc = "< YCbCr 4:2:2 12-bit packed BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_422_12p:
    _spinPixelFormatInfoSelectorEnums = 213;
#[doc = "< YCbCr 4:2:2 12-bit packed BT.709"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YCbCr709_422_12p_CbYCrY:
    _spinPixelFormatInfoSelectorEnums = 214;
#[doc = "< YUV 4:4:4 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YUV8_UYV:
    _spinPixelFormatInfoSelectorEnums = 215;
#[doc = "< YUV 4:1:1 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YUV411_8_UYYVYY:
    _spinPixelFormatInfoSelectorEnums = 216;
#[doc = "< YUV 4:2:2 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YUV422_8:
    _spinPixelFormatInfoSelectorEnums = 217;
#[doc = "< YUV 4:2:2 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_YUV422_8_UYVY:
    _spinPixelFormatInfoSelectorEnums = 218;
#[doc = "< Monochrome Polarized 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Polarized8:
    _spinPixelFormatInfoSelectorEnums = 219;
#[doc = "< Monochrome Polarized 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Polarized10p:
    _spinPixelFormatInfoSelectorEnums = 220;
#[doc = "< Monochrome Polarized 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Polarized12p:
    _spinPixelFormatInfoSelectorEnums = 221;
#[doc = "< Monochrome Polarized 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_Polarized16:
    _spinPixelFormatInfoSelectorEnums = 222;
#[doc = "< Polarized Bayer Red Green filter 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerRGPolarized8:
    _spinPixelFormatInfoSelectorEnums = 223;
#[doc = "< Polarized Bayer Red Green filter 10-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerRGPolarized10p:
    _spinPixelFormatInfoSelectorEnums = 224;
#[doc = "< Polarized Bayer Red Green filter 12-bit packed"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerRGPolarized12p:
    _spinPixelFormatInfoSelectorEnums = 225;
#[doc = "< Polarized Bayer Red Green filter 16-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_BayerRGPolarized16:
    _spinPixelFormatInfoSelectorEnums = 226;
#[doc = "< Lossless Compression Monochrome 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_LLCMono8:
    _spinPixelFormatInfoSelectorEnums = 227;
#[doc = "< Lossless Compression Bayer Red Green filter 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_LLCBayerRG8:
    _spinPixelFormatInfoSelectorEnums = 228;
#[doc = "< JPEG Monochrome 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_JPEGMono8:
    _spinPixelFormatInfoSelectorEnums = 229;
#[doc = "< JPEG Color 8-bit"]
pub const _spinPixelFormatInfoSelectorEnums_PixelFormatInfoSelector_JPEGColor8:
    _spinPixelFormatInfoSelectorEnums = 230;
pub const _spinPixelFormatInfoSelectorEnums_NUM_PIXELFORMATINFOSELECTOR:
    _spinPixelFormatInfoSelectorEnums = 231;
pub type _spinPixelFormatInfoSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinPixelFormatInfoSelectorEnums as spinPixelFormatInfoSelectorEnums;
#[doc = "< The device doesn't perform de-interlacing."]
pub const _spinDeinterlacingEnums_Deinterlacing_Off: _spinDeinterlacingEnums = 0;
#[doc = "< The device performs de-interlacing by outputting each line of each field twice."]
pub const _spinDeinterlacingEnums_Deinterlacing_LineDuplication: _spinDeinterlacingEnums = 1;
#[doc = "< The device performs de-interlacing by interleaving the lines of all fields."]
pub const _spinDeinterlacingEnums_Deinterlacing_Weave: _spinDeinterlacingEnums = 2;
pub const _spinDeinterlacingEnums_NUM_DEINTERLACING: _spinDeinterlacingEnums = 3;
pub type _spinDeinterlacingEnums = ::std::os::raw::c_uint;
pub use self::_spinDeinterlacingEnums as spinDeinterlacingEnums;
#[doc = "< Output stream follows a constant bit rate. Allows easy bandwidth management on the link."]
pub const _spinImageCompressionRateOptionEnums_ImageCompressionRateOption_FixBitrate:
    _spinImageCompressionRateOptionEnums = 0;
#[doc = "< Output stream has a constant image quality. Can be used when image processing algorithms are sensitive to image degradation caused by excessive data compression."]
pub const _spinImageCompressionRateOptionEnums_ImageCompressionRateOption_FixQuality:
    _spinImageCompressionRateOptionEnums = 1;
pub const _spinImageCompressionRateOptionEnums_NUM_IMAGECOMPRESSIONRATEOPTION:
    _spinImageCompressionRateOptionEnums = 2;
pub type _spinImageCompressionRateOptionEnums = ::std::os::raw::c_uint;
pub use self::_spinImageCompressionRateOptionEnums as spinImageCompressionRateOptionEnums;
#[doc = "< Selects lossless JPEG compression based on a predictive coding model."]
pub const _spinImageCompressionJPEGFormatOptionEnums_ImageCompressionJPEGFormatOption_Lossless:
    _spinImageCompressionJPEGFormatOptionEnums = 0;
#[doc = "< Indicates this is a baseline sequential (single-scan) DCT-based JPEG."]
pub const _spinImageCompressionJPEGFormatOptionEnums_ImageCompressionJPEGFormatOption_BaselineStandard : _spinImageCompressionJPEGFormatOptionEnums = 1 ;
#[doc = "< Provides optimized color and slightly better compression than baseline standard by using custom Huffman tables optimized after statistical analysis of the image content."]
pub const _spinImageCompressionJPEGFormatOptionEnums_ImageCompressionJPEGFormatOption_BaselineOptimized : _spinImageCompressionJPEGFormatOptionEnums = 2 ;
#[doc = "< Indicates this is a progressive (multi-scan) DCT-based JPEG."]
pub const _spinImageCompressionJPEGFormatOptionEnums_ImageCompressionJPEGFormatOption_Progressive : _spinImageCompressionJPEGFormatOptionEnums = 3 ;
pub const _spinImageCompressionJPEGFormatOptionEnums_NUM_IMAGECOMPRESSIONJPEGFORMATOPTION:
    _spinImageCompressionJPEGFormatOptionEnums = 4;
pub type _spinImageCompressionJPEGFormatOptionEnums = ::std::os::raw::c_uint;
pub use self::_spinImageCompressionJPEGFormatOptionEnums as spinImageCompressionJPEGFormatOptionEnums;
#[doc = "< Device is currently waiting for a trigger for the capture of one or many frames."]
pub const _spinAcquisitionStatusSelectorEnums_AcquisitionStatusSelector_AcquisitionTriggerWait:
    _spinAcquisitionStatusSelectorEnums = 0;
#[doc = "< Device is currently doing an acquisition of one or many frames."]
pub const _spinAcquisitionStatusSelectorEnums_AcquisitionStatusSelector_AcquisitionActive:
    _spinAcquisitionStatusSelectorEnums = 1;
#[doc = "< Device is currently transferring an acquisition of one or many frames."]
pub const _spinAcquisitionStatusSelectorEnums_AcquisitionStatusSelector_AcquisitionTransfer:
    _spinAcquisitionStatusSelectorEnums = 2;
#[doc = "< Device is currently waiting for a frame start trigger."]
pub const _spinAcquisitionStatusSelectorEnums_AcquisitionStatusSelector_FrameTriggerWait:
    _spinAcquisitionStatusSelectorEnums = 3;
#[doc = "< Device is currently doing the capture of a frame."]
pub const _spinAcquisitionStatusSelectorEnums_AcquisitionStatusSelector_FrameActive:
    _spinAcquisitionStatusSelectorEnums = 4;
#[doc = "< Device is doing the exposure of a frame."]
pub const _spinAcquisitionStatusSelectorEnums_AcquisitionStatusSelector_ExposureActive:
    _spinAcquisitionStatusSelectorEnums = 5;
pub const _spinAcquisitionStatusSelectorEnums_NUM_ACQUISITIONSTATUSSELECTOR:
    _spinAcquisitionStatusSelectorEnums = 6;
pub type _spinAcquisitionStatusSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinAcquisitionStatusSelectorEnums as spinAcquisitionStatusSelectorEnums;
#[doc = "< The exposure time is common to all the color components. The common ExposureTime value to use can be set selecting it with ExposureTimeSelector[Common]."]
pub const _spinExposureTimeModeEnums_ExposureTimeMode_Common: _spinExposureTimeModeEnums = 0;
#[doc = "< The exposure time is individual for each color component. Each individual ExposureTime values to use can be set by selecting them with ExposureTimeSelector."]
pub const _spinExposureTimeModeEnums_ExposureTimeMode_Individual: _spinExposureTimeModeEnums = 1;
pub const _spinExposureTimeModeEnums_NUM_EXPOSURETIMEMODE: _spinExposureTimeModeEnums = 2;
pub type _spinExposureTimeModeEnums = ::std::os::raw::c_uint;
pub use self::_spinExposureTimeModeEnums as spinExposureTimeModeEnums;
#[doc = "< Selects the common ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Common:
    _spinExposureTimeSelectorEnums = 0;
#[doc = "< Selects the red common ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Red: _spinExposureTimeSelectorEnums =
    1;
#[doc = "< Selects the green ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Green:
    _spinExposureTimeSelectorEnums = 2;
#[doc = "< Selects the blue ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Blue: _spinExposureTimeSelectorEnums =
    3;
#[doc = "< Selects the cyan common ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Cyan: _spinExposureTimeSelectorEnums =
    4;
#[doc = "< Selects the magenta ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Magenta:
    _spinExposureTimeSelectorEnums = 5;
#[doc = "< Selects the yellow ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Yellow:
    _spinExposureTimeSelectorEnums = 6;
#[doc = "< Selects the infrared ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Infrared:
    _spinExposureTimeSelectorEnums = 7;
#[doc = "< Selects the ultraviolet ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Ultraviolet:
    _spinExposureTimeSelectorEnums = 8;
#[doc = "< Selects the first stage ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Stage1:
    _spinExposureTimeSelectorEnums = 9;
#[doc = "< Selects the second stage ExposureTime."]
pub const _spinExposureTimeSelectorEnums_ExposureTimeSelector_Stage2:
    _spinExposureTimeSelectorEnums = 10;
pub const _spinExposureTimeSelectorEnums_NUM_EXPOSURETIMESELECTOR: _spinExposureTimeSelectorEnums =
    11;
pub type _spinExposureTimeSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinExposureTimeSelectorEnums as spinExposureTimeSelectorEnums;
#[doc = "< Gain tap balancing is user controlled using Gain ."]
pub const _spinGainAutoBalanceEnums_GainAutoBalance_Off: _spinGainAutoBalanceEnums = 0;
#[doc = "< Gain tap balancing is automatically adjusted once by the device. Once it has converged, it automatically returns to the Off state."]
pub const _spinGainAutoBalanceEnums_GainAutoBalance_Once: _spinGainAutoBalanceEnums = 1;
#[doc = "< Gain tap balancing is constantly adjusted by the device."]
pub const _spinGainAutoBalanceEnums_GainAutoBalance_Continuous: _spinGainAutoBalanceEnums = 2;
pub const _spinGainAutoBalanceEnums_NUM_GAINAUTOBALANCE: _spinGainAutoBalanceEnums = 3;
pub type _spinGainAutoBalanceEnums = ::std::os::raw::c_uint;
pub use self::_spinGainAutoBalanceEnums as spinGainAutoBalanceEnums;
#[doc = "< Analog black level is user controlled using BlackLevel."]
pub const _spinBlackLevelAutoEnums_BlackLevelAuto_Off: _spinBlackLevelAutoEnums = 0;
#[doc = "< Analog black level is automatically adjusted once by the device. Once it has converged, it automatically returns to the Off state."]
pub const _spinBlackLevelAutoEnums_BlackLevelAuto_Once: _spinBlackLevelAutoEnums = 1;
#[doc = "< Analog black level is constantly adjusted by the device."]
pub const _spinBlackLevelAutoEnums_BlackLevelAuto_Continuous: _spinBlackLevelAutoEnums = 2;
pub const _spinBlackLevelAutoEnums_NUM_BLACKLEVELAUTO: _spinBlackLevelAutoEnums = 3;
pub type _spinBlackLevelAutoEnums = ::std::os::raw::c_uint;
pub use self::_spinBlackLevelAutoEnums as spinBlackLevelAutoEnums;
#[doc = "< Black level tap balancing is user controlled using BlackLevel."]
pub const _spinBlackLevelAutoBalanceEnums_BlackLevelAutoBalance_Off:
    _spinBlackLevelAutoBalanceEnums = 0;
#[doc = "< Black level tap balancing is automatically adjusted once by the device. Once it has converged, it automatically returns to the Off state."]
pub const _spinBlackLevelAutoBalanceEnums_BlackLevelAutoBalance_Once:
    _spinBlackLevelAutoBalanceEnums = 1;
#[doc = "< Black level tap balancing is constantly adjusted by the device."]
pub const _spinBlackLevelAutoBalanceEnums_BlackLevelAutoBalance_Continuous:
    _spinBlackLevelAutoBalanceEnums = 2;
pub const _spinBlackLevelAutoBalanceEnums_NUM_BLACKLEVELAUTOBALANCE:
    _spinBlackLevelAutoBalanceEnums = 3;
pub type _spinBlackLevelAutoBalanceEnums = ::std::os::raw::c_uint;
pub use self::_spinBlackLevelAutoBalanceEnums as spinBlackLevelAutoBalanceEnums;
#[doc = "< White Clip will be applied to all channels or taps."]
pub const _spinWhiteClipSelectorEnums_WhiteClipSelector_All: _spinWhiteClipSelectorEnums = 0;
#[doc = "< White Clip will be applied to the red channel."]
pub const _spinWhiteClipSelectorEnums_WhiteClipSelector_Red: _spinWhiteClipSelectorEnums = 1;
#[doc = "< White Clip will be applied to the green channel."]
pub const _spinWhiteClipSelectorEnums_WhiteClipSelector_Green: _spinWhiteClipSelectorEnums = 2;
#[doc = "< White Clip will be applied to the blue channel."]
pub const _spinWhiteClipSelectorEnums_WhiteClipSelector_Blue: _spinWhiteClipSelectorEnums = 3;
#[doc = "< White Clip will be applied to Y channel."]
pub const _spinWhiteClipSelectorEnums_WhiteClipSelector_Y: _spinWhiteClipSelectorEnums = 4;
#[doc = "< White Clip will be applied to U channel."]
pub const _spinWhiteClipSelectorEnums_WhiteClipSelector_U: _spinWhiteClipSelectorEnums = 5;
#[doc = "< White Clip will be applied to V channel."]
pub const _spinWhiteClipSelectorEnums_WhiteClipSelector_V: _spinWhiteClipSelectorEnums = 6;
#[doc = "< White Clip will be applied to Tap 1."]
pub const _spinWhiteClipSelectorEnums_WhiteClipSelector_Tap1: _spinWhiteClipSelectorEnums = 7;
#[doc = "< White Clip will be applied to Tap 2."]
pub const _spinWhiteClipSelectorEnums_WhiteClipSelector_Tap2: _spinWhiteClipSelectorEnums = 8;
pub const _spinWhiteClipSelectorEnums_NUM_WHITECLIPSELECTOR: _spinWhiteClipSelectorEnums = 9;
pub type _spinWhiteClipSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinWhiteClipSelectorEnums as spinWhiteClipSelectorEnums;
#[doc = "< Selects the Timer 0."]
pub const _spinTimerSelectorEnums_TimerSelector_Timer0: _spinTimerSelectorEnums = 0;
#[doc = "< Selects the Timer 1."]
pub const _spinTimerSelectorEnums_TimerSelector_Timer1: _spinTimerSelectorEnums = 1;
#[doc = "< Selects the Timer 2."]
pub const _spinTimerSelectorEnums_TimerSelector_Timer2: _spinTimerSelectorEnums = 2;
pub const _spinTimerSelectorEnums_NUM_TIMERSELECTOR: _spinTimerSelectorEnums = 3;
pub type _spinTimerSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinTimerSelectorEnums as spinTimerSelectorEnums;
#[doc = "< The Timer is idle."]
pub const _spinTimerStatusEnums_TimerStatus_TimerIdle: _spinTimerStatusEnums = 0;
#[doc = "< The Timer is waiting for a start trigger."]
pub const _spinTimerStatusEnums_TimerStatus_TimerTriggerWait: _spinTimerStatusEnums = 1;
#[doc = "< The Timer is counting for the specified duration."]
pub const _spinTimerStatusEnums_TimerStatus_TimerActive: _spinTimerStatusEnums = 2;
#[doc = "< The Timer reached the TimerDuration count."]
pub const _spinTimerStatusEnums_TimerStatus_TimerCompleted: _spinTimerStatusEnums = 3;
pub const _spinTimerStatusEnums_NUM_TIMERSTATUS: _spinTimerStatusEnums = 4;
pub type _spinTimerStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinTimerStatusEnums as spinTimerStatusEnums;
#[doc = "< Disables the Timer trigger."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Off: _spinTimerTriggerSourceEnums = 0;
#[doc = "< Starts with the reception of the Acquisition Trigger."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_AcquisitionTrigger:
    _spinTimerTriggerSourceEnums = 1;
#[doc = "< Starts with the reception of the Acquisition Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_AcquisitionStart:
    _spinTimerTriggerSourceEnums = 2;
#[doc = "< Starts with the reception of the Acquisition End."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_AcquisitionEnd:
    _spinTimerTriggerSourceEnums = 3;
#[doc = "< Starts with the reception of the Frame Start Trigger."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_FrameTrigger:
    _spinTimerTriggerSourceEnums = 4;
#[doc = "< Starts with the reception of the Frame Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_FrameStart: _spinTimerTriggerSourceEnums =
    5;
#[doc = "< Starts with the reception of the Frame End."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_FrameEnd: _spinTimerTriggerSourceEnums =
    6;
#[doc = "< Starts with the reception of the Frame Burst Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_FrameBurstStart:
    _spinTimerTriggerSourceEnums = 7;
#[doc = "< Starts with the reception of the Frame Burst End."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_FrameBurstEnd:
    _spinTimerTriggerSourceEnums = 8;
#[doc = "< Starts with the reception of the Line Start Trigger."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_LineTrigger:
    _spinTimerTriggerSourceEnums = 9;
#[doc = "< Starts with the reception of the Line Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_LineStart: _spinTimerTriggerSourceEnums =
    10;
#[doc = "< Starts with the reception of the Line End."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_LineEnd: _spinTimerTriggerSourceEnums =
    11;
#[doc = "< Starts with the reception of the Exposure Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_ExposureStart:
    _spinTimerTriggerSourceEnums = 12;
#[doc = "< Starts with the reception of the Exposure End."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_ExposureEnd:
    _spinTimerTriggerSourceEnums = 13;
#[doc = "< Starts when the specidfied TimerTriggerActivation condition is met on the chosen I/O Line."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Line0: _spinTimerTriggerSourceEnums = 14;
#[doc = "< Starts when the specidfied TimerTriggerActivation condition is met on the chosen I/O Line."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Line1: _spinTimerTriggerSourceEnums = 15;
#[doc = "< Starts when the specidfied TimerTriggerActivation condition is met on the chosen I/O Line."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Line2: _spinTimerTriggerSourceEnums = 16;
#[doc = "< Specifies which User Output bit signal to use as internal source for the trigger."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_UserOutput0:
    _spinTimerTriggerSourceEnums = 17;
#[doc = "< Specifies which User Output bit signal to use as internal source for the trigger."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_UserOutput1:
    _spinTimerTriggerSourceEnums = 18;
#[doc = "< Specifies which User Output bit signal to use as internal source for the trigger."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_UserOutput2:
    _spinTimerTriggerSourceEnums = 19;
#[doc = "< Starts with the reception of the Counter Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Counter0Start:
    _spinTimerTriggerSourceEnums = 20;
#[doc = "< Starts with the reception of the Counter Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Counter1Start:
    _spinTimerTriggerSourceEnums = 21;
#[doc = "< Starts with the reception of the Counter Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Counter2Start:
    _spinTimerTriggerSourceEnums = 22;
#[doc = "< Starts with the reception of the Counter End."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Counter0End:
    _spinTimerTriggerSourceEnums = 23;
#[doc = "< Starts with the reception of the Counter End."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Counter1End:
    _spinTimerTriggerSourceEnums = 24;
#[doc = "< Starts with the reception of the Counter End."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Counter2End:
    _spinTimerTriggerSourceEnums = 25;
#[doc = "< Starts with the reception of the Timer Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Timer0Start:
    _spinTimerTriggerSourceEnums = 26;
#[doc = "< Starts with the reception of the Timer Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Timer1Start:
    _spinTimerTriggerSourceEnums = 27;
#[doc = "< Starts with the reception of the Timer Start."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Timer2Start:
    _spinTimerTriggerSourceEnums = 28;
#[doc = "< Starts with the reception of the Timer End. Note that a timer can retrigger itself to achieve a free running Timer."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Timer0End: _spinTimerTriggerSourceEnums =
    29;
#[doc = "< Starts with the reception of the Timer End. Note that a timer can retrigger itself to achieve a free running Timer."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Timer1End: _spinTimerTriggerSourceEnums =
    30;
#[doc = "< Starts with the reception of the Timer End. Note that a timer can retrigger itself to achieve a free running Timer."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Timer2End: _spinTimerTriggerSourceEnums =
    31;
#[doc = "< Starts with the reception of the Encoder output signal."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Encoder0: _spinTimerTriggerSourceEnums =
    32;
#[doc = "< Starts with the reception of the Encoder output signal."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Encoder1: _spinTimerTriggerSourceEnums =
    33;
#[doc = "< Starts with the reception of the Encoder output signal."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Encoder2: _spinTimerTriggerSourceEnums =
    34;
#[doc = "< Starts on the reception of the Software Signal."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_SoftwareSignal0:
    _spinTimerTriggerSourceEnums = 35;
#[doc = "< Starts on the reception of the Software Signal."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_SoftwareSignal1:
    _spinTimerTriggerSourceEnums = 36;
#[doc = "< Starts on the reception of the Software Signal."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_SoftwareSignal2:
    _spinTimerTriggerSourceEnums = 37;
#[doc = "< Starts with the assertion of the chosen action signal."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Action0: _spinTimerTriggerSourceEnums =
    38;
#[doc = "< Starts with the assertion of the chosen action signal."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Action1: _spinTimerTriggerSourceEnums =
    39;
#[doc = "< Starts with the assertion of the chosen action signal."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_Action2: _spinTimerTriggerSourceEnums =
    40;
#[doc = "< Starts with the reception of the chosen Link Trigger."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_LinkTrigger0:
    _spinTimerTriggerSourceEnums = 41;
#[doc = "< Starts with the reception of the chosen Link Trigger."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_LinkTrigger1:
    _spinTimerTriggerSourceEnums = 42;
#[doc = "< Starts with the reception of the chosen Link Trigger."]
pub const _spinTimerTriggerSourceEnums_TimerTriggerSource_LinkTrigger2:
    _spinTimerTriggerSourceEnums = 43;
pub const _spinTimerTriggerSourceEnums_NUM_TIMERTRIGGERSOURCE: _spinTimerTriggerSourceEnums = 44;
pub type _spinTimerTriggerSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinTimerTriggerSourceEnums as spinTimerTriggerSourceEnums;
#[doc = "< Starts counting on the Rising Edge of the selected trigger signal."]
pub const _spinTimerTriggerActivationEnums_TimerTriggerActivation_RisingEdge:
    _spinTimerTriggerActivationEnums = 0;
#[doc = "< Starts counting on the Falling Edge of the selected trigger signal."]
pub const _spinTimerTriggerActivationEnums_TimerTriggerActivation_FallingEdge:
    _spinTimerTriggerActivationEnums = 1;
#[doc = "< Starts counting on the Falling or Rising Edge of the selected trigger signal."]
pub const _spinTimerTriggerActivationEnums_TimerTriggerActivation_AnyEdge:
    _spinTimerTriggerActivationEnums = 2;
#[doc = "< Counts as long as the selected trigger signal level is High."]
pub const _spinTimerTriggerActivationEnums_TimerTriggerActivation_LevelHigh:
    _spinTimerTriggerActivationEnums = 3;
#[doc = "< Counts as long as the selected trigger signal level is Low."]
pub const _spinTimerTriggerActivationEnums_TimerTriggerActivation_LevelLow:
    _spinTimerTriggerActivationEnums = 4;
pub const _spinTimerTriggerActivationEnums_NUM_TIMERTRIGGERACTIVATION:
    _spinTimerTriggerActivationEnums = 5;
pub type _spinTimerTriggerActivationEnums = ::std::os::raw::c_uint;
pub use self::_spinTimerTriggerActivationEnums as spinTimerTriggerActivationEnums;
#[doc = "< Selects Encoder 0."]
pub const _spinEncoderSelectorEnums_EncoderSelector_Encoder0: _spinEncoderSelectorEnums = 0;
#[doc = "< Selects Encoder 1."]
pub const _spinEncoderSelectorEnums_EncoderSelector_Encoder1: _spinEncoderSelectorEnums = 1;
#[doc = "< Selects Encoder 2."]
pub const _spinEncoderSelectorEnums_EncoderSelector_Encoder2: _spinEncoderSelectorEnums = 2;
pub const _spinEncoderSelectorEnums_NUM_ENCODERSELECTOR: _spinEncoderSelectorEnums = 3;
pub type _spinEncoderSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinEncoderSelectorEnums as spinEncoderSelectorEnums;
#[doc = "< Counter is stopped."]
pub const _spinEncoderSourceAEnums_EncoderSourceA_Off: _spinEncoderSourceAEnums = 0;
#[doc = "< Encoder Forward input is taken from the chosen I/O Line."]
pub const _spinEncoderSourceAEnums_EncoderSourceA_Line0: _spinEncoderSourceAEnums = 1;
#[doc = "< Encoder Forward input is taken from the chosen I/O Line."]
pub const _spinEncoderSourceAEnums_EncoderSourceA_Line1: _spinEncoderSourceAEnums = 2;
#[doc = "< Encoder Forward input is taken from the chosen I/O Line."]
pub const _spinEncoderSourceAEnums_EncoderSourceA_Line2: _spinEncoderSourceAEnums = 3;
pub const _spinEncoderSourceAEnums_NUM_ENCODERSOURCEA: _spinEncoderSourceAEnums = 4;
pub type _spinEncoderSourceAEnums = ::std::os::raw::c_uint;
pub use self::_spinEncoderSourceAEnums as spinEncoderSourceAEnums;
#[doc = "< Counter is stopped."]
pub const _spinEncoderSourceBEnums_EncoderSourceB_Off: _spinEncoderSourceBEnums = 0;
#[doc = "< Encoder Reverse input is taken from the chosen I/O Line.."]
pub const _spinEncoderSourceBEnums_EncoderSourceB_Line0: _spinEncoderSourceBEnums = 1;
#[doc = "< Encoder Reverse input is taken from the chosen I/O Line.."]
pub const _spinEncoderSourceBEnums_EncoderSourceB_Line1: _spinEncoderSourceBEnums = 2;
#[doc = "< Encoder Reverse input is taken from the chosen I/O Line.."]
pub const _spinEncoderSourceBEnums_EncoderSourceB_Line2: _spinEncoderSourceBEnums = 3;
pub const _spinEncoderSourceBEnums_NUM_ENCODERSOURCEB: _spinEncoderSourceBEnums = 4;
pub type _spinEncoderSourceBEnums = ::std::os::raw::c_uint;
pub use self::_spinEncoderSourceBEnums as spinEncoderSourceBEnums;
#[doc = "< The counter increments or decrements 1 for every full quadrature cycle with jitter filtering."]
pub const _spinEncoderModeEnums_EncoderMode_FourPhase: _spinEncoderModeEnums = 0;
#[doc = "< The counter increments or decrements every quadrature phase for high resolution counting, but without jitter filtering."]
pub const _spinEncoderModeEnums_EncoderMode_HighResolution: _spinEncoderModeEnums = 1;
pub const _spinEncoderModeEnums_NUM_ENCODERMODE: _spinEncoderModeEnums = 2;
pub type _spinEncoderModeEnums = ::std::os::raw::c_uint;
pub use self::_spinEncoderModeEnums as spinEncoderModeEnums;
#[doc = "< No output pulse are generated."]
pub const _spinEncoderOutputModeEnums_EncoderOutputMode_Off: _spinEncoderOutputModeEnums = 0;
#[doc = "< Output pulses are generated at all new positions in the positive direction. If the encoder reverses no output pulse are generated until it has again passed the position where the reversal started."]
pub const _spinEncoderOutputModeEnums_EncoderOutputMode_PositionUp: _spinEncoderOutputModeEnums = 1;
#[doc = "< Output pulses are generated at all new positions in the negative direction. If the encoder reverses no output pulse are generated until it has again passed the position where the reversal started."]
pub const _spinEncoderOutputModeEnums_EncoderOutputMode_PositionDown: _spinEncoderOutputModeEnums =
    2;
#[doc = "< Output pulses are generated at all position increments in the positive direction while ignoring negative direction motion."]
pub const _spinEncoderOutputModeEnums_EncoderOutputMode_DirectionUp: _spinEncoderOutputModeEnums =
    3;
#[doc = "< Output pulses are generated at all position increments in the negative direction while ignoring positive direction motion."]
pub const _spinEncoderOutputModeEnums_EncoderOutputMode_DirectionDown: _spinEncoderOutputModeEnums =
    4;
#[doc = "< Output pulses are generated at all motion increments in both directions."]
pub const _spinEncoderOutputModeEnums_EncoderOutputMode_Motion: _spinEncoderOutputModeEnums = 5;
pub const _spinEncoderOutputModeEnums_NUM_ENCODEROUTPUTMODE: _spinEncoderOutputModeEnums = 6;
pub type _spinEncoderOutputModeEnums = ::std::os::raw::c_uint;
pub use self::_spinEncoderOutputModeEnums as spinEncoderOutputModeEnums;
#[doc = "< The encoder counter last incremented."]
pub const _spinEncoderStatusEnums_EncoderStatus_EncoderUp: _spinEncoderStatusEnums = 0;
#[doc = "< The encoder counter last decremented."]
pub const _spinEncoderStatusEnums_EncoderStatus_EncoderDown: _spinEncoderStatusEnums = 1;
#[doc = "< The encoder is not active."]
pub const _spinEncoderStatusEnums_EncoderStatus_EncoderIdle: _spinEncoderStatusEnums = 2;
#[doc = "< No motion within the EncoderTimeout time."]
pub const _spinEncoderStatusEnums_EncoderStatus_EncoderStatic: _spinEncoderStatusEnums = 3;
pub const _spinEncoderStatusEnums_NUM_ENCODERSTATUS: _spinEncoderStatusEnums = 4;
pub type _spinEncoderStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinEncoderStatusEnums as spinEncoderStatusEnums;
#[doc = "< Disable the Encoder Reset trigger."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Off: _spinEncoderResetSourceEnums = 0;
#[doc = "< Resets with the reception of the Acquisition Trigger."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_AcquisitionTrigger:
    _spinEncoderResetSourceEnums = 1;
#[doc = "< Resets with the reception of the Acquisition Start."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_AcquisitionStart:
    _spinEncoderResetSourceEnums = 2;
#[doc = "< Resets with the reception of the Acquisition End."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_AcquisitionEnd:
    _spinEncoderResetSourceEnums = 3;
#[doc = "< Resets with the reception of the Frame Start Trigger."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_FrameTrigger:
    _spinEncoderResetSourceEnums = 4;
#[doc = "< Resets with the reception of the Frame Start."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_FrameStart: _spinEncoderResetSourceEnums =
    5;
#[doc = "< Resets with the reception of the Frame End."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_FrameEnd: _spinEncoderResetSourceEnums =
    6;
#[doc = "< Resets with the reception of the Exposure Start."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_ExposureStart:
    _spinEncoderResetSourceEnums = 7;
#[doc = "< Resets with the reception of the Exposure End."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_ExposureEnd:
    _spinEncoderResetSourceEnums = 8;
#[doc = "< Resets by the chosen I/O Line."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Line0: _spinEncoderResetSourceEnums = 9;
#[doc = "< Resets by the chosen I/O Line."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Line1: _spinEncoderResetSourceEnums = 10;
#[doc = "< Resets by the chosen I/O Line."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Line2: _spinEncoderResetSourceEnums = 11;
#[doc = "< Resets with the reception of the Counter Start."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Counter0Start:
    _spinEncoderResetSourceEnums = 12;
#[doc = "< Resets with the reception of the Counter Start."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Counter1Start:
    _spinEncoderResetSourceEnums = 13;
#[doc = "< Resets with the reception of the Counter Start."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Counter2Start:
    _spinEncoderResetSourceEnums = 14;
#[doc = "< Resets with the reception of the Counter End."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Counter0End:
    _spinEncoderResetSourceEnums = 15;
#[doc = "< Resets with the reception of the Counter End."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Counter1End:
    _spinEncoderResetSourceEnums = 16;
#[doc = "< Resets with the reception of the Counter End."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Counter2End:
    _spinEncoderResetSourceEnums = 17;
#[doc = "< Resets with the reception of the Timer Start."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Timer0Start:
    _spinEncoderResetSourceEnums = 18;
#[doc = "< Resets with the reception of the Timer Start."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Timer1Start:
    _spinEncoderResetSourceEnums = 19;
#[doc = "< Resets with the reception of the Timer Start."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Timer2Start:
    _spinEncoderResetSourceEnums = 20;
#[doc = "< Resets with the reception of the Timer End."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Timer0End: _spinEncoderResetSourceEnums =
    21;
#[doc = "< Resets with the reception of the Timer End."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Timer1End: _spinEncoderResetSourceEnums =
    22;
#[doc = "< Resets with the reception of the Timer End."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Timer2End: _spinEncoderResetSourceEnums =
    23;
#[doc = "< Resets by the chosen User Output bit."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_UserOutput0:
    _spinEncoderResetSourceEnums = 24;
#[doc = "< Resets by the chosen User Output bit."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_UserOutput1:
    _spinEncoderResetSourceEnums = 25;
#[doc = "< Resets by the chosen User Output bit."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_UserOutput2:
    _spinEncoderResetSourceEnums = 26;
#[doc = "< Resets on the reception of the Software Signal."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_SoftwareSignal0:
    _spinEncoderResetSourceEnums = 27;
#[doc = "< Resets on the reception of the Software Signal."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_SoftwareSignal1:
    _spinEncoderResetSourceEnums = 28;
#[doc = "< Resets on the reception of the Software Signal."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_SoftwareSignal2:
    _spinEncoderResetSourceEnums = 29;
#[doc = "< Resets on assertions of the chosen action signal (Broadcasted signal on the transport layer)."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Action0: _spinEncoderResetSourceEnums =
    30;
#[doc = "< Resets on assertions of the chosen action signal (Broadcasted signal on the transport layer)."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Action1: _spinEncoderResetSourceEnums =
    31;
#[doc = "< Resets on assertions of the chosen action signal (Broadcasted signal on the transport layer)."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_Action2: _spinEncoderResetSourceEnums =
    32;
#[doc = "< Resets on the reception of the chosen Link Trigger (received from the transport layer)."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_LinkTrigger0:
    _spinEncoderResetSourceEnums = 33;
#[doc = "< Resets on the reception of the chosen Link Trigger (received from the transport layer)."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_LinkTrigger1:
    _spinEncoderResetSourceEnums = 34;
#[doc = "< Resets on the reception of the chosen Link Trigger (received from the transport layer)."]
pub const _spinEncoderResetSourceEnums_EncoderResetSource_LinkTrigger2:
    _spinEncoderResetSourceEnums = 35;
pub const _spinEncoderResetSourceEnums_NUM_ENCODERRESETSOURCE: _spinEncoderResetSourceEnums = 36;
pub type _spinEncoderResetSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinEncoderResetSourceEnums as spinEncoderResetSourceEnums;
#[doc = "< Resets the Encoder on the Rising Edge of the signal."]
pub const _spinEncoderResetActivationEnums_EncoderResetActivation_RisingEdge:
    _spinEncoderResetActivationEnums = 0;
#[doc = "< Resets the Encoder on the Falling Edge of the signal."]
pub const _spinEncoderResetActivationEnums_EncoderResetActivation_FallingEdge:
    _spinEncoderResetActivationEnums = 1;
#[doc = "< Resets the Encoder on the Falling or rising Edge of the selected signal."]
pub const _spinEncoderResetActivationEnums_EncoderResetActivation_AnyEdge:
    _spinEncoderResetActivationEnums = 2;
#[doc = "< Resets the Encoder as long as the selected signal level is High."]
pub const _spinEncoderResetActivationEnums_EncoderResetActivation_LevelHigh:
    _spinEncoderResetActivationEnums = 3;
#[doc = "< Resets the Encoder as long as the selected signal level is Low."]
pub const _spinEncoderResetActivationEnums_EncoderResetActivation_LevelLow:
    _spinEncoderResetActivationEnums = 4;
pub const _spinEncoderResetActivationEnums_NUM_ENCODERRESETACTIVATION:
    _spinEncoderResetActivationEnums = 5;
pub type _spinEncoderResetActivationEnums = ::std::os::raw::c_uint;
pub use self::_spinEncoderResetActivationEnums as spinEncoderResetActivationEnums;
#[doc = "< Selects the software generated signal to control."]
pub const _spinSoftwareSignalSelectorEnums_SoftwareSignalSelector_SoftwareSignal0:
    _spinSoftwareSignalSelectorEnums = 0;
#[doc = "< Selects the software generated signal to control."]
pub const _spinSoftwareSignalSelectorEnums_SoftwareSignalSelector_SoftwareSignal1:
    _spinSoftwareSignalSelectorEnums = 1;
#[doc = "< Selects the software generated signal to control."]
pub const _spinSoftwareSignalSelectorEnums_SoftwareSignalSelector_SoftwareSignal2:
    _spinSoftwareSignalSelectorEnums = 2;
pub const _spinSoftwareSignalSelectorEnums_NUM_SOFTWARESIGNALSELECTOR:
    _spinSoftwareSignalSelectorEnums = 3;
pub type _spinSoftwareSignalSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinSoftwareSignalSelectorEnums as spinSoftwareSignalSelectorEnums;
#[doc = "< Unconditional mode is disabled."]
pub const _spinActionUnconditionalModeEnums_ActionUnconditionalMode_Off:
    _spinActionUnconditionalModeEnums = 0;
#[doc = "< Unconditional mode is enabled."]
pub const _spinActionUnconditionalModeEnums_ActionUnconditionalMode_On:
    _spinActionUnconditionalModeEnums = 1;
pub const _spinActionUnconditionalModeEnums_NUM_ACTIONUNCONDITIONALMODE:
    _spinActionUnconditionalModeEnums = 2;
pub type _spinActionUnconditionalModeEnums = ::std::os::raw::c_uint;
pub use self::_spinActionUnconditionalModeEnums as spinActionUnconditionalModeEnums;
#[doc = "< Selects the data source 0."]
pub const _spinSourceSelectorEnums_SourceSelector_Source0: _spinSourceSelectorEnums = 0;
#[doc = "< Selects the data source 1."]
pub const _spinSourceSelectorEnums_SourceSelector_Source1: _spinSourceSelectorEnums = 1;
#[doc = "< Selects the data source 2."]
pub const _spinSourceSelectorEnums_SourceSelector_Source2: _spinSourceSelectorEnums = 2;
#[doc = "< Selects all the data sources."]
pub const _spinSourceSelectorEnums_SourceSelector_All: _spinSourceSelectorEnums = 3;
pub const _spinSourceSelectorEnums_NUM_SOURCESELECTOR: _spinSourceSelectorEnums = 4;
pub type _spinSourceSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinSourceSelectorEnums as spinSourceSelectorEnums;
#[doc = "< The transfer features control the data stream 0."]
pub const _spinTransferSelectorEnums_TransferSelector_Stream0: _spinTransferSelectorEnums = 0;
#[doc = "< The transfer features control the data stream 1."]
pub const _spinTransferSelectorEnums_TransferSelector_Stream1: _spinTransferSelectorEnums = 1;
#[doc = "< The transfer features control the data stream 2."]
pub const _spinTransferSelectorEnums_TransferSelector_Stream2: _spinTransferSelectorEnums = 2;
#[doc = "< The transfer features control all the data streams simulateneously."]
pub const _spinTransferSelectorEnums_TransferSelector_All: _spinTransferSelectorEnums = 3;
pub const _spinTransferSelectorEnums_NUM_TRANSFERSELECTOR: _spinTransferSelectorEnums = 4;
pub type _spinTransferSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinTransferSelectorEnums as spinTransferSelectorEnums;
#[doc = "< Selects a trigger to start the transfers."]
pub const _spinTransferTriggerSelectorEnums_TransferTriggerSelector_TransferStart:
    _spinTransferTriggerSelectorEnums = 0;
#[doc = "< Selects a trigger to stop the transfers."]
pub const _spinTransferTriggerSelectorEnums_TransferTriggerSelector_TransferStop:
    _spinTransferTriggerSelectorEnums = 1;
#[doc = "< Selects a trigger to abort the transfers."]
pub const _spinTransferTriggerSelectorEnums_TransferTriggerSelector_TransferAbort:
    _spinTransferTriggerSelectorEnums = 2;
#[doc = "< Selects a trigger to pause the transfers."]
pub const _spinTransferTriggerSelectorEnums_TransferTriggerSelector_TransferPause:
    _spinTransferTriggerSelectorEnums = 3;
#[doc = "< Selects a trigger to Resume the transfers."]
pub const _spinTransferTriggerSelectorEnums_TransferTriggerSelector_TransferResume:
    _spinTransferTriggerSelectorEnums = 4;
#[doc = "< Selects a trigger to Activate the transfers. This trigger type is used when TriggerActivation is set LevelHigh or levelLow."]
pub const _spinTransferTriggerSelectorEnums_TransferTriggerSelector_TransferActive:
    _spinTransferTriggerSelectorEnums = 5;
#[doc = "< Selects a trigger to start the transfer of a burst of frames specified by TransferBurstCount."]
pub const _spinTransferTriggerSelectorEnums_TransferTriggerSelector_TransferBurstStart:
    _spinTransferTriggerSelectorEnums = 6;
#[doc = "< Selects a trigger to end the transfer of a burst of frames."]
pub const _spinTransferTriggerSelectorEnums_TransferTriggerSelector_TransferBurstStop:
    _spinTransferTriggerSelectorEnums = 7;
pub const _spinTransferTriggerSelectorEnums_NUM_TRANSFERTRIGGERSELECTOR:
    _spinTransferTriggerSelectorEnums = 8;
pub type _spinTransferTriggerSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinTransferTriggerSelectorEnums as spinTransferTriggerSelectorEnums;
#[doc = "< Disables the selected trigger."]
pub const _spinTransferTriggerModeEnums_TransferTriggerMode_Off: _spinTransferTriggerModeEnums = 0;
#[doc = "< Enable the selected trigger."]
pub const _spinTransferTriggerModeEnums_TransferTriggerMode_On: _spinTransferTriggerModeEnums = 1;
pub const _spinTransferTriggerModeEnums_NUM_TRANSFERTRIGGERMODE: _spinTransferTriggerModeEnums = 2;
pub type _spinTransferTriggerModeEnums = ::std::os::raw::c_uint;
pub use self::_spinTransferTriggerModeEnums as spinTransferTriggerModeEnums;
#[doc = "< Specifies which physical line (or pin) and associated I/O control block to use as external source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Line0:
    _spinTransferTriggerSourceEnums = 0;
#[doc = "< Specifies which physical line (or pin) and associated I/O control block to use as external source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Line1:
    _spinTransferTriggerSourceEnums = 1;
#[doc = "< Specifies which physical line (or pin) and associated I/O control block to use as external source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Line2:
    _spinTransferTriggerSourceEnums = 2;
#[doc = "< Specifies which of the Counter signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Counter0Start:
    _spinTransferTriggerSourceEnums = 3;
#[doc = "< Specifies which of the Counter signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Counter1Start:
    _spinTransferTriggerSourceEnums = 4;
#[doc = "< Specifies which of the Counter signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Counter2Start:
    _spinTransferTriggerSourceEnums = 5;
#[doc = "< Specifies which of the Counter signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Counter0End:
    _spinTransferTriggerSourceEnums = 6;
#[doc = "< Specifies which of the Counter signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Counter1End:
    _spinTransferTriggerSourceEnums = 7;
#[doc = "< Specifies which of the Counter signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Counter2End:
    _spinTransferTriggerSourceEnums = 8;
#[doc = "< Specifies which Timer signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Timer0Start:
    _spinTransferTriggerSourceEnums = 9;
#[doc = "< Specifies which Timer signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Timer1Start:
    _spinTransferTriggerSourceEnums = 10;
#[doc = "< Specifies which Timer signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Timer2Start:
    _spinTransferTriggerSourceEnums = 11;
#[doc = "< Specifies which Timer signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Timer0End:
    _spinTransferTriggerSourceEnums = 12;
#[doc = "< Specifies which Timer signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Timer1End:
    _spinTransferTriggerSourceEnums = 13;
#[doc = "< Specifies which Timer signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Timer2End:
    _spinTransferTriggerSourceEnums = 14;
#[doc = "< Specifies which Software Signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_SoftwareSignal0:
    _spinTransferTriggerSourceEnums = 15;
#[doc = "< Specifies which Software Signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_SoftwareSignal1:
    _spinTransferTriggerSourceEnums = 16;
#[doc = "< Specifies which Software Signal to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_SoftwareSignal2:
    _spinTransferTriggerSourceEnums = 17;
#[doc = "< Specifies which Action command to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Action0:
    _spinTransferTriggerSourceEnums = 18;
#[doc = "< Specifies which Action command to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Action1:
    _spinTransferTriggerSourceEnums = 19;
#[doc = "< Specifies which Action command to use as internal source for the transfer control trigger signal."]
pub const _spinTransferTriggerSourceEnums_TransferTriggerSource_Action2:
    _spinTransferTriggerSourceEnums = 20;
pub const _spinTransferTriggerSourceEnums_NUM_TRANSFERTRIGGERSOURCE:
    _spinTransferTriggerSourceEnums = 21;
pub type _spinTransferTriggerSourceEnums = ::std::os::raw::c_uint;
pub use self::_spinTransferTriggerSourceEnums as spinTransferTriggerSourceEnums;
#[doc = "< Specifies that the trigger is considered valid on the rising edge of the source signal."]
pub const _spinTransferTriggerActivationEnums_TransferTriggerActivation_RisingEdge:
    _spinTransferTriggerActivationEnums = 0;
#[doc = "< Specifies that the trigger is considered valid on the falling edge of the source signal."]
pub const _spinTransferTriggerActivationEnums_TransferTriggerActivation_FallingEdge:
    _spinTransferTriggerActivationEnums = 1;
#[doc = "< Specifies that the trigger is considered valid on the falling or rising edge of the source signal."]
pub const _spinTransferTriggerActivationEnums_TransferTriggerActivation_AnyEdge:
    _spinTransferTriggerActivationEnums = 2;
#[doc = "< Specifies that the trigger is considered valid as long as the level of the source signal is high. This can apply to TransferActive and TransferPause trigger."]
pub const _spinTransferTriggerActivationEnums_TransferTriggerActivation_LevelHigh:
    _spinTransferTriggerActivationEnums = 3;
#[doc = "< Specifies that the trigger is considered valid as long as the level of the source signal is low. This can apply to TransferActive and TransferPause trigger."]
pub const _spinTransferTriggerActivationEnums_TransferTriggerActivation_LevelLow:
    _spinTransferTriggerActivationEnums = 4;
pub const _spinTransferTriggerActivationEnums_NUM_TRANSFERTRIGGERACTIVATION:
    _spinTransferTriggerActivationEnums = 5;
pub type _spinTransferTriggerActivationEnums = ::std::os::raw::c_uint;
pub use self::_spinTransferTriggerActivationEnums as spinTransferTriggerActivationEnums;
#[doc = "< Data blocks are transmitted when enough data is available."]
pub const _spinTransferStatusSelectorEnums_TransferStatusSelector_Streaming:
    _spinTransferStatusSelectorEnums = 0;
#[doc = "< Data blocks transmission is suspended immediately."]
pub const _spinTransferStatusSelectorEnums_TransferStatusSelector_Paused:
    _spinTransferStatusSelectorEnums = 1;
#[doc = "< Data blocks transmission is stopping. The current block transmission will be completed and the transfer state will stop."]
pub const _spinTransferStatusSelectorEnums_TransferStatusSelector_Stopping:
    _spinTransferStatusSelectorEnums = 2;
#[doc = "< Data blocks transmission is stopped."]
pub const _spinTransferStatusSelectorEnums_TransferStatusSelector_Stopped:
    _spinTransferStatusSelectorEnums = 3;
#[doc = "< Data blocks queue is in overflow state."]
pub const _spinTransferStatusSelectorEnums_TransferStatusSelector_QueueOverflow:
    _spinTransferStatusSelectorEnums = 4;
pub const _spinTransferStatusSelectorEnums_NUM_TRANSFERSTATUSSELECTOR:
    _spinTransferStatusSelectorEnums = 5;
pub type _spinTransferStatusSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinTransferStatusSelectorEnums as spinTransferStatusSelectorEnums;
#[doc = "< The TransferStreamChannel feature controls the index of the stream channel for the streaming of the red plane of the planar pixel formats."]
pub const _spinTransferComponentSelectorEnums_TransferComponentSelector_Red:
    _spinTransferComponentSelectorEnums = 0;
#[doc = "< The TransferStreamChannel feature controls the index of the stream channel for the streaming of the green plane of the planar pixel formats."]
pub const _spinTransferComponentSelectorEnums_TransferComponentSelector_Green:
    _spinTransferComponentSelectorEnums = 1;
#[doc = "< The TransferStreamChannel feature controls the index of the stream channel for the streaming of blue plane of the planar pixel formats."]
pub const _spinTransferComponentSelectorEnums_TransferComponentSelector_Blue:
    _spinTransferComponentSelectorEnums = 2;
#[doc = "< The TransferStreamChannel feature controls the index of the stream channel for the streaming of all the planes of the planar pixel formats simultaneously or non planar pixel formats."]
pub const _spinTransferComponentSelectorEnums_TransferComponentSelector_All:
    _spinTransferComponentSelectorEnums = 3;
pub const _spinTransferComponentSelectorEnums_NUM_TRANSFERCOMPONENTSELECTOR:
    _spinTransferComponentSelectorEnums = 4;
pub type _spinTransferComponentSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinTransferComponentSelectorEnums as spinTransferComponentSelectorEnums;
#[doc = "< Distance values are in millimeter units (default)."]
pub const _spinScan3dDistanceUnitEnums_Scan3dDistanceUnit_Millimeter: _spinScan3dDistanceUnitEnums =
    0;
#[doc = "< Distance values are in inch units."]
pub const _spinScan3dDistanceUnitEnums_Scan3dDistanceUnit_Inch: _spinScan3dDistanceUnitEnums = 1;
pub const _spinScan3dDistanceUnitEnums_NUM_SCAN3DDISTANCEUNIT: _spinScan3dDistanceUnitEnums = 2;
pub type _spinScan3dDistanceUnitEnums = ::std::os::raw::c_uint;
pub use self::_spinScan3dDistanceUnitEnums as spinScan3dDistanceUnitEnums;
#[doc = "< Default value. 3-axis orthogonal, right-hand X-Y-Z."]
pub const _spinScan3dCoordinateSystemEnums_Scan3dCoordinateSystem_Cartesian:
    _spinScan3dCoordinateSystemEnums = 0;
#[doc = "< A Theta-Phi-Rho coordinate system."]
pub const _spinScan3dCoordinateSystemEnums_Scan3dCoordinateSystem_Spherical:
    _spinScan3dCoordinateSystemEnums = 1;
#[doc = "< A Theta-Y-Rho coordinate system."]
pub const _spinScan3dCoordinateSystemEnums_Scan3dCoordinateSystem_Cylindrical:
    _spinScan3dCoordinateSystemEnums = 2;
pub const _spinScan3dCoordinateSystemEnums_NUM_SCAN3DCOORDINATESYSTEM:
    _spinScan3dCoordinateSystemEnums = 3;
pub type _spinScan3dCoordinateSystemEnums = ::std::os::raw::c_uint;
pub use self::_spinScan3dCoordinateSystemEnums as spinScan3dCoordinateSystemEnums;
#[doc = "< Uncalibrated 2.5D Depth map. The distance data does not represent a physical unit and may be non-linear. The data is a 2.5D range map only."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_UncalibratedC: _spinScan3dOutputModeEnums = 0;
#[doc = "< 3 Coordinates in grid organization. The full 3 coordinate data with the grid array organization from the sensor kept."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_CalibratedABC_Grid:
    _spinScan3dOutputModeEnums = 1;
#[doc = "< 3 Coordinates without organization. The full 3 coordinate data without any organization of data points. Typically only valid points transmitted giving varying image size."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_CalibratedABC_PointCloud:
    _spinScan3dOutputModeEnums = 2;
#[doc = "< 2 Coordinates with fixed B sampling. The data is sent as a A and C coordinates (X,Z or Theta,Rho). The B (Y) axis uses the scale and offset parameters for the B axis."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_CalibratedAC: _spinScan3dOutputModeEnums = 3;
#[doc = "< 2 Coordinates with varying sampling. The data is sent as a A and C coordinates (X,Z or Theta,Rho). The B (Y) axis comes from the encoder chunk value."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_CalibratedAC_Linescan:
    _spinScan3dOutputModeEnums = 4;
#[doc = "< Calibrated 2.5D Depth map. The distance data is expressed in the chosen distance unit. The data is a 2.5D range map. No information on X-Y axes available."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_CalibratedC: _spinScan3dOutputModeEnums = 5;
#[doc = "< Depth Map with varying B sampling. The distance data is expressed in the chosen distance unit. The data is a 2.5D range map. The B (Y) axis comes from the encoder chunk value."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_CalibratedC_Linescan:
    _spinScan3dOutputModeEnums = 6;
#[doc = "< Rectified 2.5D Depth map. The distance data has been rectified to a uniform sampling pattern in the X and Y direction. The data is a 2.5D range map only. If a complete 3D point cloud is rectified but transmitted as explicit coordinates it should be transmitted as one of the \"CalibratedABC\" formats."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_RectifiedC: _spinScan3dOutputModeEnums = 7;
#[doc = "< Rectified 2.5D Depth map with varying B sampling. The data is sent as rectified 1D profiles using Coord3D_C pixels. The B (Y) axis comes from the encoder chunk value."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_RectifiedC_Linescan:
    _spinScan3dOutputModeEnums = 8;
#[doc = "< Disparity 2.5D Depth map. The distance is inversely proportional to the pixel (disparity) value."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_DisparityC: _spinScan3dOutputModeEnums = 9;
#[doc = "< Disparity 2.5D Depth map with varying B sampling. The distance is inversely proportional to the pixel (disparity) value. The B (Y) axis comes from the encoder chunk value."]
pub const _spinScan3dOutputModeEnums_Scan3dOutputMode_DisparityC_Linescan:
    _spinScan3dOutputModeEnums = 10;
pub const _spinScan3dOutputModeEnums_NUM_SCAN3DOUTPUTMODE: _spinScan3dOutputModeEnums = 11;
pub type _spinScan3dOutputModeEnums = ::std::os::raw::c_uint;
pub use self::_spinScan3dOutputModeEnums as spinScan3dOutputModeEnums;
#[doc = "< Default value. Original fixed reference. The coordinate system fixed relative the camera reference point marker is used."]
pub const _spinScan3dCoordinateSystemReferenceEnums_Scan3dCoordinateSystemReference_Anchor:
    _spinScan3dCoordinateSystemReferenceEnums = 0;
#[doc = "< Transformed reference system. The transformed coordinate system is used according to the definition in the rotation and translation matrices."]
pub const _spinScan3dCoordinateSystemReferenceEnums_Scan3dCoordinateSystemReference_Transformed:
    _spinScan3dCoordinateSystemReferenceEnums = 1;
pub const _spinScan3dCoordinateSystemReferenceEnums_NUM_SCAN3DCOORDINATESYSTEMREFERENCE:
    _spinScan3dCoordinateSystemReferenceEnums = 2;
pub type _spinScan3dCoordinateSystemReferenceEnums = ::std::os::raw::c_uint;
pub use self::_spinScan3dCoordinateSystemReferenceEnums as spinScan3dCoordinateSystemReferenceEnums;
#[doc = "< The first (X or Theta) coordinate"]
pub const _spinScan3dCoordinateSelectorEnums_Scan3dCoordinateSelector_CoordinateA:
    _spinScan3dCoordinateSelectorEnums = 0;
#[doc = "< The second (Y or Phi) coordinate"]
pub const _spinScan3dCoordinateSelectorEnums_Scan3dCoordinateSelector_CoordinateB:
    _spinScan3dCoordinateSelectorEnums = 1;
#[doc = "< The third (Z or Rho) coordinate."]
pub const _spinScan3dCoordinateSelectorEnums_Scan3dCoordinateSelector_CoordinateC:
    _spinScan3dCoordinateSelectorEnums = 2;
pub const _spinScan3dCoordinateSelectorEnums_NUM_SCAN3DCOORDINATESELECTOR:
    _spinScan3dCoordinateSelectorEnums = 3;
pub type _spinScan3dCoordinateSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinScan3dCoordinateSelectorEnums as spinScan3dCoordinateSelectorEnums;
#[doc = "< Rotation around X axis."]
pub const _spinScan3dCoordinateTransformSelectorEnums_Scan3dCoordinateTransformSelector_RotationX : _spinScan3dCoordinateTransformSelectorEnums = 0 ;
#[doc = "< Rotation around Y axis."]
pub const _spinScan3dCoordinateTransformSelectorEnums_Scan3dCoordinateTransformSelector_RotationY : _spinScan3dCoordinateTransformSelectorEnums = 1 ;
#[doc = "< Rotation around Z axis."]
pub const _spinScan3dCoordinateTransformSelectorEnums_Scan3dCoordinateTransformSelector_RotationZ : _spinScan3dCoordinateTransformSelectorEnums = 2 ;
#[doc = "< Translation along X axis."]
pub const _spinScan3dCoordinateTransformSelectorEnums_Scan3dCoordinateTransformSelector_TranslationX : _spinScan3dCoordinateTransformSelectorEnums = 3 ;
#[doc = "< Translation along Y axis."]
pub const _spinScan3dCoordinateTransformSelectorEnums_Scan3dCoordinateTransformSelector_TranslationY : _spinScan3dCoordinateTransformSelectorEnums = 4 ;
#[doc = "< Translation along Z axis."]
pub const _spinScan3dCoordinateTransformSelectorEnums_Scan3dCoordinateTransformSelector_TranslationZ : _spinScan3dCoordinateTransformSelectorEnums = 5 ;
pub const _spinScan3dCoordinateTransformSelectorEnums_NUM_SCAN3DCOORDINATETRANSFORMSELECTOR:
    _spinScan3dCoordinateTransformSelectorEnums = 6;
pub type _spinScan3dCoordinateTransformSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinScan3dCoordinateTransformSelectorEnums as spinScan3dCoordinateTransformSelectorEnums;
#[doc = "< Rotation around X axis."]
pub const _spinScan3dCoordinateReferenceSelectorEnums_Scan3dCoordinateReferenceSelector_RotationX : _spinScan3dCoordinateReferenceSelectorEnums = 0 ;
#[doc = "< Rotation around Y axis."]
pub const _spinScan3dCoordinateReferenceSelectorEnums_Scan3dCoordinateReferenceSelector_RotationY : _spinScan3dCoordinateReferenceSelectorEnums = 1 ;
#[doc = "< Rotation around Z axis."]
pub const _spinScan3dCoordinateReferenceSelectorEnums_Scan3dCoordinateReferenceSelector_RotationZ : _spinScan3dCoordinateReferenceSelectorEnums = 2 ;
#[doc = "< X axis translation."]
pub const _spinScan3dCoordinateReferenceSelectorEnums_Scan3dCoordinateReferenceSelector_TranslationX : _spinScan3dCoordinateReferenceSelectorEnums = 3 ;
#[doc = "< Y axis translation."]
pub const _spinScan3dCoordinateReferenceSelectorEnums_Scan3dCoordinateReferenceSelector_TranslationY : _spinScan3dCoordinateReferenceSelectorEnums = 4 ;
#[doc = "< Z axis translation."]
pub const _spinScan3dCoordinateReferenceSelectorEnums_Scan3dCoordinateReferenceSelector_TranslationZ : _spinScan3dCoordinateReferenceSelectorEnums = 5 ;
pub const _spinScan3dCoordinateReferenceSelectorEnums_NUM_SCAN3DCOORDINATEREFERENCESELECTOR:
    _spinScan3dCoordinateReferenceSelectorEnums = 6;
pub type _spinScan3dCoordinateReferenceSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinScan3dCoordinateReferenceSelectorEnums as spinScan3dCoordinateReferenceSelectorEnums;
#[doc = "< The image data is the intensity component."]
pub const _spinChunkImageComponentEnums_ChunkImageComponent_Intensity:
    _spinChunkImageComponentEnums = 0;
#[doc = "< The image data is color component."]
pub const _spinChunkImageComponentEnums_ChunkImageComponent_Color: _spinChunkImageComponentEnums =
    1;
#[doc = "< The image data is infrared component."]
pub const _spinChunkImageComponentEnums_ChunkImageComponent_Infrared:
    _spinChunkImageComponentEnums = 2;
#[doc = "< The image data is the ultraviolet component."]
pub const _spinChunkImageComponentEnums_ChunkImageComponent_Ultraviolet:
    _spinChunkImageComponentEnums = 3;
#[doc = "< The image data is the range (distance) component."]
pub const _spinChunkImageComponentEnums_ChunkImageComponent_Range: _spinChunkImageComponentEnums =
    4;
#[doc = "< The image data is the disparity component."]
pub const _spinChunkImageComponentEnums_ChunkImageComponent_Disparity:
    _spinChunkImageComponentEnums = 5;
#[doc = "< The image data is the confidence map component."]
pub const _spinChunkImageComponentEnums_ChunkImageComponent_Confidence:
    _spinChunkImageComponentEnums = 6;
#[doc = "< The image data is the scatter component."]
pub const _spinChunkImageComponentEnums_ChunkImageComponent_Scatter: _spinChunkImageComponentEnums =
    7;
pub const _spinChunkImageComponentEnums_NUM_CHUNKIMAGECOMPONENT: _spinChunkImageComponentEnums = 8;
pub type _spinChunkImageComponentEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkImageComponentEnums as spinChunkImageComponentEnums;
#[doc = "< Selects the counter 0."]
pub const _spinChunkCounterSelectorEnums_ChunkCounterSelector_Counter0:
    _spinChunkCounterSelectorEnums = 0;
#[doc = "< Selects the counter 1."]
pub const _spinChunkCounterSelectorEnums_ChunkCounterSelector_Counter1:
    _spinChunkCounterSelectorEnums = 1;
#[doc = "< Selects the counter 2."]
pub const _spinChunkCounterSelectorEnums_ChunkCounterSelector_Counter2:
    _spinChunkCounterSelectorEnums = 2;
pub const _spinChunkCounterSelectorEnums_NUM_CHUNKCOUNTERSELECTOR: _spinChunkCounterSelectorEnums =
    3;
pub type _spinChunkCounterSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkCounterSelectorEnums as spinChunkCounterSelectorEnums;
#[doc = "< Selects the first Timer."]
pub const _spinChunkTimerSelectorEnums_ChunkTimerSelector_Timer0: _spinChunkTimerSelectorEnums = 0;
#[doc = "< Selects the first Timer."]
pub const _spinChunkTimerSelectorEnums_ChunkTimerSelector_Timer1: _spinChunkTimerSelectorEnums = 1;
#[doc = "< Selects the second Timer."]
pub const _spinChunkTimerSelectorEnums_ChunkTimerSelector_Timer2: _spinChunkTimerSelectorEnums = 2;
pub const _spinChunkTimerSelectorEnums_NUM_CHUNKTIMERSELECTOR: _spinChunkTimerSelectorEnums = 3;
pub type _spinChunkTimerSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkTimerSelectorEnums as spinChunkTimerSelectorEnums;
#[doc = "< Selects the first Encoder."]
pub const _spinChunkEncoderSelectorEnums_ChunkEncoderSelector_Encoder0:
    _spinChunkEncoderSelectorEnums = 0;
#[doc = "< Selects the first Encoder."]
pub const _spinChunkEncoderSelectorEnums_ChunkEncoderSelector_Encoder1:
    _spinChunkEncoderSelectorEnums = 1;
#[doc = "< Selects the second Encoder."]
pub const _spinChunkEncoderSelectorEnums_ChunkEncoderSelector_Encoder2:
    _spinChunkEncoderSelectorEnums = 2;
pub const _spinChunkEncoderSelectorEnums_NUM_CHUNKENCODERSELECTOR: _spinChunkEncoderSelectorEnums =
    3;
pub type _spinChunkEncoderSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkEncoderSelectorEnums as spinChunkEncoderSelectorEnums;
#[doc = "< The encoder counter last incremented."]
pub const _spinChunkEncoderStatusEnums_ChunkEncoderStatus_EncoderUp: _spinChunkEncoderStatusEnums =
    0;
#[doc = "< The encoder counter last decremented."]
pub const _spinChunkEncoderStatusEnums_ChunkEncoderStatus_EncoderDown:
    _spinChunkEncoderStatusEnums = 1;
#[doc = "< The encoder is not active."]
pub const _spinChunkEncoderStatusEnums_ChunkEncoderStatus_EncoderIdle:
    _spinChunkEncoderStatusEnums = 2;
#[doc = "< No motion within the EncoderTimeout time."]
pub const _spinChunkEncoderStatusEnums_ChunkEncoderStatus_EncoderStatic:
    _spinChunkEncoderStatusEnums = 3;
pub const _spinChunkEncoderStatusEnums_NUM_CHUNKENCODERSTATUS: _spinChunkEncoderStatusEnums = 4;
pub type _spinChunkEncoderStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkEncoderStatusEnums as spinChunkEncoderStatusEnums;
#[doc = "< Selects the common ExposureTime."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Common:
    _spinChunkExposureTimeSelectorEnums = 0;
#[doc = "< Selects the red common ExposureTime."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Red:
    _spinChunkExposureTimeSelectorEnums = 1;
#[doc = "< Selects the green ExposureTime."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Green:
    _spinChunkExposureTimeSelectorEnums = 2;
#[doc = "< Selects the blue ExposureTime."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Blue:
    _spinChunkExposureTimeSelectorEnums = 3;
#[doc = "< Selects the cyan common ExposureTime.."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Cyan:
    _spinChunkExposureTimeSelectorEnums = 4;
#[doc = "< Selects the magenta ExposureTime.."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Magenta:
    _spinChunkExposureTimeSelectorEnums = 5;
#[doc = "< Selects the yellow ExposureTime.."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Yellow:
    _spinChunkExposureTimeSelectorEnums = 6;
#[doc = "< Selects the infrared ExposureTime."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Infrared:
    _spinChunkExposureTimeSelectorEnums = 7;
#[doc = "< Selects the ultraviolet ExposureTime."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Ultraviolet:
    _spinChunkExposureTimeSelectorEnums = 8;
#[doc = "< Selects the first stage ExposureTime."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Stage1:
    _spinChunkExposureTimeSelectorEnums = 9;
#[doc = "< Selects the second stage ExposureTime."]
pub const _spinChunkExposureTimeSelectorEnums_ChunkExposureTimeSelector_Stage2:
    _spinChunkExposureTimeSelectorEnums = 10;
pub const _spinChunkExposureTimeSelectorEnums_NUM_CHUNKEXPOSURETIMESELECTOR:
    _spinChunkExposureTimeSelectorEnums = 11;
pub type _spinChunkExposureTimeSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkExposureTimeSelectorEnums as spinChunkExposureTimeSelectorEnums;
#[doc = "< Image comes from the Source 0."]
pub const _spinChunkSourceIDEnums_ChunkSourceID_Source0: _spinChunkSourceIDEnums = 0;
#[doc = "< Image comes from the Source 1."]
pub const _spinChunkSourceIDEnums_ChunkSourceID_Source1: _spinChunkSourceIDEnums = 1;
#[doc = "< Image comes from the Source 2."]
pub const _spinChunkSourceIDEnums_ChunkSourceID_Source2: _spinChunkSourceIDEnums = 2;
pub const _spinChunkSourceIDEnums_NUM_CHUNKSOURCEID: _spinChunkSourceIDEnums = 3;
pub type _spinChunkSourceIDEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkSourceIDEnums as spinChunkSourceIDEnums;
#[doc = "< Image comes from the Region 0."]
pub const _spinChunkRegionIDEnums_ChunkRegionID_Region0: _spinChunkRegionIDEnums = 0;
#[doc = "< Image comes from the Region 1."]
pub const _spinChunkRegionIDEnums_ChunkRegionID_Region1: _spinChunkRegionIDEnums = 1;
#[doc = "< Image comes from the Region 2."]
pub const _spinChunkRegionIDEnums_ChunkRegionID_Region2: _spinChunkRegionIDEnums = 2;
pub const _spinChunkRegionIDEnums_NUM_CHUNKREGIONID: _spinChunkRegionIDEnums = 3;
pub type _spinChunkRegionIDEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkRegionIDEnums as spinChunkRegionIDEnums;
#[doc = "< Data comes from Stream0."]
pub const _spinChunkTransferStreamIDEnums_ChunkTransferStreamID_Stream0:
    _spinChunkTransferStreamIDEnums = 0;
#[doc = "< Data comes from Stream1."]
pub const _spinChunkTransferStreamIDEnums_ChunkTransferStreamID_Stream1:
    _spinChunkTransferStreamIDEnums = 1;
#[doc = "< Data comes from Stream2."]
pub const _spinChunkTransferStreamIDEnums_ChunkTransferStreamID_Stream2:
    _spinChunkTransferStreamIDEnums = 2;
#[doc = "< Data comes from Stream3."]
pub const _spinChunkTransferStreamIDEnums_ChunkTransferStreamID_Stream3:
    _spinChunkTransferStreamIDEnums = 3;
pub const _spinChunkTransferStreamIDEnums_NUM_CHUNKTRANSFERSTREAMID:
    _spinChunkTransferStreamIDEnums = 4;
pub type _spinChunkTransferStreamIDEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkTransferStreamIDEnums as spinChunkTransferStreamIDEnums;
#[doc = "< Default value. Distance values are in millimeter units."]
pub const _spinChunkScan3dDistanceUnitEnums_ChunkScan3dDistanceUnit_Millimeter:
    _spinChunkScan3dDistanceUnitEnums = 0;
#[doc = "< Distance values are in inch units."]
pub const _spinChunkScan3dDistanceUnitEnums_ChunkScan3dDistanceUnit_Inch:
    _spinChunkScan3dDistanceUnitEnums = 1;
pub const _spinChunkScan3dDistanceUnitEnums_NUM_CHUNKSCAN3DDISTANCEUNIT:
    _spinChunkScan3dDistanceUnitEnums = 2;
pub type _spinChunkScan3dDistanceUnitEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkScan3dDistanceUnitEnums as spinChunkScan3dDistanceUnitEnums;
#[doc = "< Uncalibrated 2.5D Depth map. The distance data does not represent a physical unit and may be non-linear. The data is a 2.5D range map only."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_UncalibratedC:
    _spinChunkScan3dOutputModeEnums = 0;
#[doc = "< 3 Coordinates in grid organization. The full 3 coordinate data with the grid array organization from the sensor kept."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_CalibratedABC_Grid:
    _spinChunkScan3dOutputModeEnums = 1;
#[doc = "< 3 Coordinates without organization. The full 3 coordinate data without any organization of data points. Typically only valid points transmitted giving varying image size."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_CalibratedABC_PointCloud:
    _spinChunkScan3dOutputModeEnums = 2;
#[doc = "< 2 Coordinates with fixed B sampling. The data is sent as a A and C coordinates (X,Z or Theta,Rho). The B (Y) axis uses the scale and offset parameters for the B axis."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_CalibratedAC:
    _spinChunkScan3dOutputModeEnums = 3;
#[doc = "< 2 Coordinates with varying sampling. The data is sent as a A and C coordinates (X,Z or Theta,Rho). The B (Y) axis comes from the encoder chunk value."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_CalibratedAC_Linescan:
    _spinChunkScan3dOutputModeEnums = 4;
#[doc = "< Calibrated 2.5D Depth map. The distance data is expressed in the chosen distance unit. The data is a 2.5D range map. No information on X-Y axes available."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_CalibratedC:
    _spinChunkScan3dOutputModeEnums = 5;
#[doc = "< Depth Map with varying B sampling. The distance data is expressed in the chosen distance unit. The data is a 2.5D range map. The B (Y) axis comes from the encoder chunk value."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_CalibratedC_Linescan:
    _spinChunkScan3dOutputModeEnums = 6;
#[doc = "< Rectified 2.5D Depth map. The distance data has been rectified to a uniform sampling pattern in the X and Y direction. The data is a 2.5D range map only. If a complete 3D point cloud is rectified but transmitted as explicit coordinates it should be transmitted as one of the \"CalibratedABC\" formats."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_RectifiedC:
    _spinChunkScan3dOutputModeEnums = 7;
#[doc = "< Rectified 2.5D Depth map with varying B sampling. The data is sent as rectified 1D profiles using Coord3D_C pixels. The B (Y) axis comes from the encoder chunk value."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_RectifiedC_Linescan:
    _spinChunkScan3dOutputModeEnums = 8;
#[doc = "< Disparity 2.5D Depth map. The distance is inversely proportional to the pixel (disparity) value."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_DisparityC:
    _spinChunkScan3dOutputModeEnums = 9;
#[doc = "< Disparity 2.5D Depth map with varying B sampling. The distance is inversely proportional to the pixel (disparity) value. The B (Y) axis comes from the encoder chunk value."]
pub const _spinChunkScan3dOutputModeEnums_ChunkScan3dOutputMode_DisparityC_Linescan:
    _spinChunkScan3dOutputModeEnums = 10;
pub const _spinChunkScan3dOutputModeEnums_NUM_CHUNKSCAN3DOUTPUTMODE:
    _spinChunkScan3dOutputModeEnums = 11;
pub type _spinChunkScan3dOutputModeEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkScan3dOutputModeEnums as spinChunkScan3dOutputModeEnums;
#[doc = "< Default value. 3-axis orthogonal, right-hand X-Y-Z."]
pub const _spinChunkScan3dCoordinateSystemEnums_ChunkScan3dCoordinateSystem_Cartesian:
    _spinChunkScan3dCoordinateSystemEnums = 0;
#[doc = "< A Theta-Phi-Rho coordinate system."]
pub const _spinChunkScan3dCoordinateSystemEnums_ChunkScan3dCoordinateSystem_Spherical:
    _spinChunkScan3dCoordinateSystemEnums = 1;
#[doc = "< A Theta-Y-Rho coordinate system."]
pub const _spinChunkScan3dCoordinateSystemEnums_ChunkScan3dCoordinateSystem_Cylindrical:
    _spinChunkScan3dCoordinateSystemEnums = 2;
pub const _spinChunkScan3dCoordinateSystemEnums_NUM_CHUNKSCAN3DCOORDINATESYSTEM:
    _spinChunkScan3dCoordinateSystemEnums = 3;
pub type _spinChunkScan3dCoordinateSystemEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkScan3dCoordinateSystemEnums as spinChunkScan3dCoordinateSystemEnums;
#[doc = "< Default value. Original fixed reference. The coordinate system fixed relative the camera reference point marker is used."]
pub const _spinChunkScan3dCoordinateSystemReferenceEnums_ChunkScan3dCoordinateSystemReference_Anchor : _spinChunkScan3dCoordinateSystemReferenceEnums = 0 ;
#[doc = "< Transformed reference system. The transformed coordinate system is used according to the definition in the rotation and translation matrices."]
pub const _spinChunkScan3dCoordinateSystemReferenceEnums_ChunkScan3dCoordinateSystemReference_Transformed : _spinChunkScan3dCoordinateSystemReferenceEnums = 1 ;
pub const _spinChunkScan3dCoordinateSystemReferenceEnums_NUM_CHUNKSCAN3DCOORDINATESYSTEMREFERENCE : _spinChunkScan3dCoordinateSystemReferenceEnums = 2 ;
pub type _spinChunkScan3dCoordinateSystemReferenceEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkScan3dCoordinateSystemReferenceEnums as spinChunkScan3dCoordinateSystemReferenceEnums;
#[doc = "< The first (X or Theta) coordinate"]
pub const _spinChunkScan3dCoordinateSelectorEnums_ChunkScan3dCoordinateSelector_CoordinateA:
    _spinChunkScan3dCoordinateSelectorEnums = 0;
#[doc = "< The second (Y or Phi) coordinate"]
pub const _spinChunkScan3dCoordinateSelectorEnums_ChunkScan3dCoordinateSelector_CoordinateB:
    _spinChunkScan3dCoordinateSelectorEnums = 1;
#[doc = "< The third (Z or Rho) coordinate."]
pub const _spinChunkScan3dCoordinateSelectorEnums_ChunkScan3dCoordinateSelector_CoordinateC:
    _spinChunkScan3dCoordinateSelectorEnums = 2;
pub const _spinChunkScan3dCoordinateSelectorEnums_NUM_CHUNKSCAN3DCOORDINATESELECTOR:
    _spinChunkScan3dCoordinateSelectorEnums = 3;
pub type _spinChunkScan3dCoordinateSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkScan3dCoordinateSelectorEnums as spinChunkScan3dCoordinateSelectorEnums;
#[doc = "< Rotation around X axis."]
pub const _spinChunkScan3dCoordinateTransformSelectorEnums_ChunkScan3dCoordinateTransformSelector_RotationX : _spinChunkScan3dCoordinateTransformSelectorEnums = 0 ;
#[doc = "< Rotation around Y axis."]
pub const _spinChunkScan3dCoordinateTransformSelectorEnums_ChunkScan3dCoordinateTransformSelector_RotationY : _spinChunkScan3dCoordinateTransformSelectorEnums = 1 ;
#[doc = "< Rotation around Z axis."]
pub const _spinChunkScan3dCoordinateTransformSelectorEnums_ChunkScan3dCoordinateTransformSelector_RotationZ : _spinChunkScan3dCoordinateTransformSelectorEnums = 2 ;
#[doc = "< Translation along X axis."]
pub const _spinChunkScan3dCoordinateTransformSelectorEnums_ChunkScan3dCoordinateTransformSelector_TranslationX : _spinChunkScan3dCoordinateTransformSelectorEnums = 3 ;
#[doc = "< Translation along Y axis."]
pub const _spinChunkScan3dCoordinateTransformSelectorEnums_ChunkScan3dCoordinateTransformSelector_TranslationY : _spinChunkScan3dCoordinateTransformSelectorEnums = 4 ;
#[doc = "< Translation along Z axis."]
pub const _spinChunkScan3dCoordinateTransformSelectorEnums_ChunkScan3dCoordinateTransformSelector_TranslationZ : _spinChunkScan3dCoordinateTransformSelectorEnums = 5 ;
pub const _spinChunkScan3dCoordinateTransformSelectorEnums_NUM_CHUNKSCAN3DCOORDINATETRANSFORMSELECTOR : _spinChunkScan3dCoordinateTransformSelectorEnums = 6 ;
pub type _spinChunkScan3dCoordinateTransformSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkScan3dCoordinateTransformSelectorEnums as spinChunkScan3dCoordinateTransformSelectorEnums;
#[doc = "< Rotation around X axis."]
pub const _spinChunkScan3dCoordinateReferenceSelectorEnums_ChunkScan3dCoordinateReferenceSelector_RotationX : _spinChunkScan3dCoordinateReferenceSelectorEnums = 0 ;
#[doc = "< Rotation around Y axis."]
pub const _spinChunkScan3dCoordinateReferenceSelectorEnums_ChunkScan3dCoordinateReferenceSelector_RotationY : _spinChunkScan3dCoordinateReferenceSelectorEnums = 1 ;
#[doc = "< Rotation around Z axis."]
pub const _spinChunkScan3dCoordinateReferenceSelectorEnums_ChunkScan3dCoordinateReferenceSelector_RotationZ : _spinChunkScan3dCoordinateReferenceSelectorEnums = 2 ;
#[doc = "< X axis translation."]
pub const _spinChunkScan3dCoordinateReferenceSelectorEnums_ChunkScan3dCoordinateReferenceSelector_TranslationX : _spinChunkScan3dCoordinateReferenceSelectorEnums = 3 ;
#[doc = "< Y axis translation."]
pub const _spinChunkScan3dCoordinateReferenceSelectorEnums_ChunkScan3dCoordinateReferenceSelector_TranslationY : _spinChunkScan3dCoordinateReferenceSelectorEnums = 4 ;
#[doc = "< Z axis translation."]
pub const _spinChunkScan3dCoordinateReferenceSelectorEnums_ChunkScan3dCoordinateReferenceSelector_TranslationZ : _spinChunkScan3dCoordinateReferenceSelectorEnums = 5 ;
pub const _spinChunkScan3dCoordinateReferenceSelectorEnums_NUM_CHUNKSCAN3DCOORDINATEREFERENCESELECTOR : _spinChunkScan3dCoordinateReferenceSelectorEnums = 6 ;
pub type _spinChunkScan3dCoordinateReferenceSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinChunkScan3dCoordinateReferenceSelectorEnums as spinChunkScan3dCoordinateReferenceSelectorEnums;
#[doc = "< Geometry_1X_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X_1Y:
    _spinDeviceTapGeometryEnums = 0;
#[doc = "< Geometry_1X2_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X2_1Y:
    _spinDeviceTapGeometryEnums = 1;
#[doc = "< Geometry_1X2_1Y2"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X2_1Y2:
    _spinDeviceTapGeometryEnums = 2;
#[doc = "< Geometry_2X_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2X_1Y:
    _spinDeviceTapGeometryEnums = 3;
#[doc = "< Geometry_2X_1Y2Geometry_2XE_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2X_1Y2Geometry_2XE_1Y:
    _spinDeviceTapGeometryEnums = 4;
#[doc = "< Geometry_2XE_1Y2"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2XE_1Y2:
    _spinDeviceTapGeometryEnums = 5;
#[doc = "< Geometry_2XM_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2XM_1Y:
    _spinDeviceTapGeometryEnums = 6;
#[doc = "< Geometry_2XM_1Y2"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2XM_1Y2:
    _spinDeviceTapGeometryEnums = 7;
#[doc = "< Geometry_1X_1Y2"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X_1Y2:
    _spinDeviceTapGeometryEnums = 8;
#[doc = "< Geometry_1X_2YE"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X_2YE:
    _spinDeviceTapGeometryEnums = 9;
#[doc = "< Geometry_1X3_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X3_1Y:
    _spinDeviceTapGeometryEnums = 10;
#[doc = "< Geometry_3X_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_3X_1Y:
    _spinDeviceTapGeometryEnums = 11;
#[doc = "< Geometry_1X"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X: _spinDeviceTapGeometryEnums =
    12;
#[doc = "< Geometry_1X2"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X2: _spinDeviceTapGeometryEnums =
    13;
#[doc = "< Geometry_2X"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2X: _spinDeviceTapGeometryEnums =
    14;
#[doc = "< Geometry_2XE"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2XE: _spinDeviceTapGeometryEnums =
    15;
#[doc = "< Geometry_2XM"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2XM: _spinDeviceTapGeometryEnums =
    16;
#[doc = "< Geometry_1X3"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X3: _spinDeviceTapGeometryEnums =
    17;
#[doc = "< Geometry_3X"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_3X: _spinDeviceTapGeometryEnums =
    18;
#[doc = "< Geometry_1X4_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X4_1Y:
    _spinDeviceTapGeometryEnums = 19;
#[doc = "< Geometry_4X_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_4X_1Y:
    _spinDeviceTapGeometryEnums = 20;
#[doc = "< Geometry_2X2_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2X2_1Y:
    _spinDeviceTapGeometryEnums = 21;
#[doc = "< Geometry_2X2E_1YGeometry_2X2M_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2X2E_1YGeometry_2X2M_1Y:
    _spinDeviceTapGeometryEnums = 22;
#[doc = "< Geometry_1X2_2YE"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X2_2YE:
    _spinDeviceTapGeometryEnums = 23;
#[doc = "< Geometry_2X_2YE"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2X_2YE:
    _spinDeviceTapGeometryEnums = 24;
#[doc = "< Geometry_2XE_2YE"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2XE_2YE:
    _spinDeviceTapGeometryEnums = 25;
#[doc = "< Geometry_2XM_2YE"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2XM_2YE:
    _spinDeviceTapGeometryEnums = 26;
#[doc = "< Geometry_1X4"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X4: _spinDeviceTapGeometryEnums =
    27;
#[doc = "< Geometry_4X"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_4X: _spinDeviceTapGeometryEnums =
    28;
#[doc = "< Geometry_2X2"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2X2: _spinDeviceTapGeometryEnums =
    29;
#[doc = "< Geometry_2X2E"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2X2E: _spinDeviceTapGeometryEnums =
    30;
#[doc = "< Geometry_2X2M"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2X2M: _spinDeviceTapGeometryEnums =
    31;
#[doc = "< Geometry_1X8_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X8_1Y:
    _spinDeviceTapGeometryEnums = 32;
#[doc = "< Geometry_8X_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_8X_1Y:
    _spinDeviceTapGeometryEnums = 33;
#[doc = "< Geometry_4X2_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_4X2_1Y:
    _spinDeviceTapGeometryEnums = 34;
#[doc = "< Geometry_2X2E_2YE"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_2X2E_2YE:
    _spinDeviceTapGeometryEnums = 35;
#[doc = "< Geometry_1X8"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X8: _spinDeviceTapGeometryEnums =
    36;
#[doc = "< Geometry_8X"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_8X: _spinDeviceTapGeometryEnums =
    37;
#[doc = "< Geometry_4X2"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_4X2: _spinDeviceTapGeometryEnums =
    38;
#[doc = "< Geometry_4X2E"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_4X2E: _spinDeviceTapGeometryEnums =
    39;
#[doc = "< Geometry_4X2E_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_4X2E_1Y:
    _spinDeviceTapGeometryEnums = 40;
#[doc = "< Geometry_1X10_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X10_1Y:
    _spinDeviceTapGeometryEnums = 41;
#[doc = "< Geometry_10X_1Y"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_10X_1Y:
    _spinDeviceTapGeometryEnums = 42;
#[doc = "< Geometry_1X10"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_1X10: _spinDeviceTapGeometryEnums =
    43;
#[doc = "< Geometry_10X"]
pub const _spinDeviceTapGeometryEnums_DeviceTapGeometry_Geometry_10X: _spinDeviceTapGeometryEnums =
    44;
pub const _spinDeviceTapGeometryEnums_NUM_DEVICETAPGEOMETRY: _spinDeviceTapGeometryEnums = 45;
pub type _spinDeviceTapGeometryEnums = ::std::os::raw::c_uint;
pub use self::_spinDeviceTapGeometryEnums as spinDeviceTapGeometryEnums;
#[doc = "< Single Link"]
pub const _spinGevPhysicalLinkConfigurationEnums_GevPhysicalLinkConfiguration_SingleLink:
    _spinGevPhysicalLinkConfigurationEnums = 0;
#[doc = "< Multi Link"]
pub const _spinGevPhysicalLinkConfigurationEnums_GevPhysicalLinkConfiguration_MultiLink:
    _spinGevPhysicalLinkConfigurationEnums = 1;
#[doc = "< Static LAG"]
pub const _spinGevPhysicalLinkConfigurationEnums_GevPhysicalLinkConfiguration_StaticLAG:
    _spinGevPhysicalLinkConfigurationEnums = 2;
#[doc = "< Dynamic LAG"]
pub const _spinGevPhysicalLinkConfigurationEnums_GevPhysicalLinkConfiguration_DynamicLAG:
    _spinGevPhysicalLinkConfigurationEnums = 3;
pub const _spinGevPhysicalLinkConfigurationEnums_NUM_GEVPHYSICALLINKCONFIGURATION:
    _spinGevPhysicalLinkConfigurationEnums = 4;
pub type _spinGevPhysicalLinkConfigurationEnums = ::std::os::raw::c_uint;
pub use self::_spinGevPhysicalLinkConfigurationEnums as spinGevPhysicalLinkConfigurationEnums;
#[doc = "< Single Link"]
pub const _spinGevCurrentPhysicalLinkConfigurationEnums_GevCurrentPhysicalLinkConfiguration_SingleLink : _spinGevCurrentPhysicalLinkConfigurationEnums = 0 ;
#[doc = "< Multi Link"]
pub const _spinGevCurrentPhysicalLinkConfigurationEnums_GevCurrentPhysicalLinkConfiguration_MultiLink : _spinGevCurrentPhysicalLinkConfigurationEnums = 1 ;
#[doc = "< Static LAG"]
pub const _spinGevCurrentPhysicalLinkConfigurationEnums_GevCurrentPhysicalLinkConfiguration_StaticLAG : _spinGevCurrentPhysicalLinkConfigurationEnums = 2 ;
#[doc = "< Dynamic LAG"]
pub const _spinGevCurrentPhysicalLinkConfigurationEnums_GevCurrentPhysicalLinkConfiguration_DynamicLAG : _spinGevCurrentPhysicalLinkConfigurationEnums = 3 ;
pub const _spinGevCurrentPhysicalLinkConfigurationEnums_NUM_GEVCURRENTPHYSICALLINKCONFIGURATION:
    _spinGevCurrentPhysicalLinkConfigurationEnums = 4;
pub type _spinGevCurrentPhysicalLinkConfigurationEnums = ::std::os::raw::c_uint;
pub use self::_spinGevCurrentPhysicalLinkConfigurationEnums as spinGevCurrentPhysicalLinkConfigurationEnums;
#[doc = "< None"]
pub const _spinGevIPConfigurationStatusEnums_GevIPConfigurationStatus_None:
    _spinGevIPConfigurationStatusEnums = 0;
#[doc = "< Persistent IP"]
pub const _spinGevIPConfigurationStatusEnums_GevIPConfigurationStatus_PersistentIP:
    _spinGevIPConfigurationStatusEnums = 1;
#[doc = "< DHCP"]
pub const _spinGevIPConfigurationStatusEnums_GevIPConfigurationStatus_DHCP:
    _spinGevIPConfigurationStatusEnums = 2;
#[doc = "< LLA"]
pub const _spinGevIPConfigurationStatusEnums_GevIPConfigurationStatus_LLA:
    _spinGevIPConfigurationStatusEnums = 3;
#[doc = "< Force IP"]
pub const _spinGevIPConfigurationStatusEnums_GevIPConfigurationStatus_ForceIP:
    _spinGevIPConfigurationStatusEnums = 4;
pub const _spinGevIPConfigurationStatusEnums_NUM_GEVIPCONFIGURATIONSTATUS:
    _spinGevIPConfigurationStatusEnums = 5;
pub type _spinGevIPConfigurationStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinGevIPConfigurationStatusEnums as spinGevIPConfigurationStatusEnums;
#[doc = "< Version 1 1"]
pub const _spinGevGVCPExtendedStatusCodesSelectorEnums_GevGVCPExtendedStatusCodesSelector_Version1_1 : _spinGevGVCPExtendedStatusCodesSelectorEnums = 0 ;
#[doc = "< Version 2 0"]
pub const _spinGevGVCPExtendedStatusCodesSelectorEnums_GevGVCPExtendedStatusCodesSelector_Version2_0 : _spinGevGVCPExtendedStatusCodesSelectorEnums = 1 ;
pub const _spinGevGVCPExtendedStatusCodesSelectorEnums_NUM_GEVGVCPEXTENDEDSTATUSCODESSELECTOR:
    _spinGevGVCPExtendedStatusCodesSelectorEnums = 2;
pub type _spinGevGVCPExtendedStatusCodesSelectorEnums = ::std::os::raw::c_uint;
pub use self::_spinGevGVCPExtendedStatusCodesSelectorEnums as spinGevGVCPExtendedStatusCodesSelectorEnums;
#[doc = "< Off"]
pub const _spinGevGVSPExtendedIDModeEnums_GevGVSPExtendedIDMode_Off:
    _spinGevGVSPExtendedIDModeEnums = 0;
#[doc = "< On"]
pub const _spinGevGVSPExtendedIDModeEnums_GevGVSPExtendedIDMode_On:
    _spinGevGVSPExtendedIDModeEnums = 1;
pub const _spinGevGVSPExtendedIDModeEnums_NUM_GEVGVSPEXTENDEDIDMODE:
    _spinGevGVSPExtendedIDModeEnums = 2;
pub type _spinGevGVSPExtendedIDModeEnums = ::std::os::raw::c_uint;
pub use self::_spinGevGVSPExtendedIDModeEnums as spinGevGVSPExtendedIDModeEnums;
#[doc = "< Standard base configuration described by the Camera Link standard."]
pub const _spinClConfigurationEnums_ClConfiguration_Base: _spinClConfigurationEnums = 0;
#[doc = "< Standard medium configuration described by the Camera Link standard."]
pub const _spinClConfigurationEnums_ClConfiguration_Medium: _spinClConfigurationEnums = 1;
#[doc = "< Standard full configuration described by the Camera Link standard."]
pub const _spinClConfigurationEnums_ClConfiguration_Full: _spinClConfigurationEnums = 2;
#[doc = "< The camera streams the data from multiple taps (that do not fit in the standard base configuration) through two Camera Link base ports. It is responsibility of the application or frame grabber to reconstruct the full image. Only one of the ports (fixed) serves as the \"master\" for serial communication and triggering."]
pub const _spinClConfigurationEnums_ClConfiguration_DualBase: _spinClConfigurationEnums = 3;
#[doc = "< Standard 80-bit configuration with 10 taps of 8 bits or 8 taps of 10 bits, as described by the Camera Link standard."]
pub const _spinClConfigurationEnums_ClConfiguration_EightyBit: _spinClConfigurationEnums = 4;
pub const _spinClConfigurationEnums_NUM_CLCONFIGURATION: _spinClConfigurationEnums = 5;
pub type _spinClConfigurationEnums = ::std::os::raw::c_uint;
pub use self::_spinClConfigurationEnums as spinClConfigurationEnums;
#[doc = "< One"]
pub const _spinClTimeSlotsCountEnums_ClTimeSlotsCount_One: _spinClTimeSlotsCountEnums = 0;
#[doc = "< Two"]
pub const _spinClTimeSlotsCountEnums_ClTimeSlotsCount_Two: _spinClTimeSlotsCountEnums = 1;
#[doc = "< Three"]
pub const _spinClTimeSlotsCountEnums_ClTimeSlotsCount_Three: _spinClTimeSlotsCountEnums = 2;
pub const _spinClTimeSlotsCountEnums_NUM_CLTIMESLOTSCOUNT: _spinClTimeSlotsCountEnums = 3;
pub type _spinClTimeSlotsCountEnums = ::std::os::raw::c_uint;
pub use self::_spinClTimeSlotsCountEnums as spinClTimeSlotsCountEnums;
#[doc = "< The Link configuration of the Device is unknown. Either the configuration operation has failed or there is nothing connected."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_None:
    _spinCxpLinkConfigurationStatusEnums = 0;
#[doc = "< The Device is in the process of configuring the Link. The Link cannot be used yet."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_Pending:
    _spinCxpLinkConfigurationStatusEnums = 1;
#[doc = "< 1 Connection operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP1_X1:
    _spinCxpLinkConfigurationStatusEnums = 2;
#[doc = "< 1 Connection operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP2_X1:
    _spinCxpLinkConfigurationStatusEnums = 3;
#[doc = "< 1 Connection operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP3_X1:
    _spinCxpLinkConfigurationStatusEnums = 4;
#[doc = "< 1 Connection operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP5_X1:
    _spinCxpLinkConfigurationStatusEnums = 5;
#[doc = "< 1 Connection operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP6_X1:
    _spinCxpLinkConfigurationStatusEnums = 6;
#[doc = "< 2 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP1_X2:
    _spinCxpLinkConfigurationStatusEnums = 7;
#[doc = "< 2 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP2_X2:
    _spinCxpLinkConfigurationStatusEnums = 8;
#[doc = "< 2 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP3_X2:
    _spinCxpLinkConfigurationStatusEnums = 9;
#[doc = "< 2 Connections operating at CXP-4 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP5_X2:
    _spinCxpLinkConfigurationStatusEnums = 10;
#[doc = "< 3 Connections operating at CXP-5 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP6_X2:
    _spinCxpLinkConfigurationStatusEnums = 11;
#[doc = "< 3 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP1_X3:
    _spinCxpLinkConfigurationStatusEnums = 12;
#[doc = "< 3 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP2_X3:
    _spinCxpLinkConfigurationStatusEnums = 13;
#[doc = "< 3 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP3_X3:
    _spinCxpLinkConfigurationStatusEnums = 14;
#[doc = "< 3 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP5_X3:
    _spinCxpLinkConfigurationStatusEnums = 15;
#[doc = "< 3 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP6_X3:
    _spinCxpLinkConfigurationStatusEnums = 16;
#[doc = "< 4 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP1_X4:
    _spinCxpLinkConfigurationStatusEnums = 17;
#[doc = "< 4 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP2_X4:
    _spinCxpLinkConfigurationStatusEnums = 18;
#[doc = "< 4 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP3_X4:
    _spinCxpLinkConfigurationStatusEnums = 19;
#[doc = "< 4 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP5_X4:
    _spinCxpLinkConfigurationStatusEnums = 20;
#[doc = "< 4 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP6_X4:
    _spinCxpLinkConfigurationStatusEnums = 21;
#[doc = "< 5 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP1_X5:
    _spinCxpLinkConfigurationStatusEnums = 22;
#[doc = "< 5 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP2_X5:
    _spinCxpLinkConfigurationStatusEnums = 23;
#[doc = "< 5 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP3_X5:
    _spinCxpLinkConfigurationStatusEnums = 24;
#[doc = "< 5 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP5_X5:
    _spinCxpLinkConfigurationStatusEnums = 25;
#[doc = "< 5 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP6_X5:
    _spinCxpLinkConfigurationStatusEnums = 26;
#[doc = "< 6 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP1_X6:
    _spinCxpLinkConfigurationStatusEnums = 27;
#[doc = "< 6 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP2_X6:
    _spinCxpLinkConfigurationStatusEnums = 28;
#[doc = "< 6 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP3_X6:
    _spinCxpLinkConfigurationStatusEnums = 29;
#[doc = "< 6 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP5_X6:
    _spinCxpLinkConfigurationStatusEnums = 30;
#[doc = "< 6 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationStatusEnums_CxpLinkConfigurationStatus_CXP6_X6:
    _spinCxpLinkConfigurationStatusEnums = 31;
pub const _spinCxpLinkConfigurationStatusEnums_NUM_CXPLINKCONFIGURATIONSTATUS:
    _spinCxpLinkConfigurationStatusEnums = 32;
pub type _spinCxpLinkConfigurationStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinCxpLinkConfigurationStatusEnums as spinCxpLinkConfigurationStatusEnums;
#[doc = "< 1 Connection operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP1_X1:
    _spinCxpLinkConfigurationPreferredEnums = 0;
#[doc = "< 1 Connection operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP2_X1:
    _spinCxpLinkConfigurationPreferredEnums = 1;
#[doc = "< 1 Connection operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP3_X1:
    _spinCxpLinkConfigurationPreferredEnums = 2;
#[doc = "< 1 Connection operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP5_X1:
    _spinCxpLinkConfigurationPreferredEnums = 3;
#[doc = "< 1 Connection operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP6_X1:
    _spinCxpLinkConfigurationPreferredEnums = 4;
#[doc = "< 2 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP1_X2:
    _spinCxpLinkConfigurationPreferredEnums = 5;
#[doc = "< 2 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP2_X2:
    _spinCxpLinkConfigurationPreferredEnums = 6;
#[doc = "< 2 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP3_X2:
    _spinCxpLinkConfigurationPreferredEnums = 7;
#[doc = "< 2 Connections operating at CXP-4 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP5_X2:
    _spinCxpLinkConfigurationPreferredEnums = 8;
#[doc = "< 3 Connections operating at CXP-5 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP6_X2:
    _spinCxpLinkConfigurationPreferredEnums = 9;
#[doc = "< 3 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP1_X3:
    _spinCxpLinkConfigurationPreferredEnums = 10;
#[doc = "< 3 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP2_X3:
    _spinCxpLinkConfigurationPreferredEnums = 11;
#[doc = "< 3 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP3_X3:
    _spinCxpLinkConfigurationPreferredEnums = 12;
#[doc = "< 3 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP5_X3:
    _spinCxpLinkConfigurationPreferredEnums = 13;
#[doc = "< 3 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP6_X3:
    _spinCxpLinkConfigurationPreferredEnums = 14;
#[doc = "< 4 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP1_X4:
    _spinCxpLinkConfigurationPreferredEnums = 15;
#[doc = "< 4 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP2_X4:
    _spinCxpLinkConfigurationPreferredEnums = 16;
#[doc = "< 4 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP3_X4:
    _spinCxpLinkConfigurationPreferredEnums = 17;
#[doc = "< 4 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP5_X4:
    _spinCxpLinkConfigurationPreferredEnums = 18;
#[doc = "< 4 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP6_X4:
    _spinCxpLinkConfigurationPreferredEnums = 19;
#[doc = "< 5 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP1_X5:
    _spinCxpLinkConfigurationPreferredEnums = 20;
#[doc = "< 5 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP2_X5:
    _spinCxpLinkConfigurationPreferredEnums = 21;
#[doc = "< 5 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP3_X5:
    _spinCxpLinkConfigurationPreferredEnums = 22;
#[doc = "< 5 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP5_X5:
    _spinCxpLinkConfigurationPreferredEnums = 23;
#[doc = "< 5 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP6_X5:
    _spinCxpLinkConfigurationPreferredEnums = 24;
#[doc = "< 6 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP1_X6:
    _spinCxpLinkConfigurationPreferredEnums = 25;
#[doc = "< 6 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP2_X6:
    _spinCxpLinkConfigurationPreferredEnums = 26;
#[doc = "< 6 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP3_X6:
    _spinCxpLinkConfigurationPreferredEnums = 27;
#[doc = "< 6 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP5_X6:
    _spinCxpLinkConfigurationPreferredEnums = 28;
#[doc = "< 6 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationPreferredEnums_CxpLinkConfigurationPreferred_CXP6_X6:
    _spinCxpLinkConfigurationPreferredEnums = 29;
pub const _spinCxpLinkConfigurationPreferredEnums_NUM_CXPLINKCONFIGURATIONPREFERRED:
    _spinCxpLinkConfigurationPreferredEnums = 30;
pub type _spinCxpLinkConfigurationPreferredEnums = ::std::os::raw::c_uint;
pub use self::_spinCxpLinkConfigurationPreferredEnums as spinCxpLinkConfigurationPreferredEnums;
#[doc = "< Sets Automatic discovery for the Link Configuration."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_Auto: _spinCxpLinkConfigurationEnums =
    0;
#[doc = "< Force the Link to 1 Connection operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP1_X1:
    _spinCxpLinkConfigurationEnums = 1;
#[doc = "< Force the Link to 1 Connection operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP2_X1:
    _spinCxpLinkConfigurationEnums = 2;
#[doc = "< Force the Link to 1 Connection operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP3_X1:
    _spinCxpLinkConfigurationEnums = 3;
#[doc = "< Force the Link to 1 Connection operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP5_X1:
    _spinCxpLinkConfigurationEnums = 4;
#[doc = "< Force the Link to 1 Connection operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP6_X1:
    _spinCxpLinkConfigurationEnums = 5;
#[doc = "< Force the Link to 2 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP1_X2:
    _spinCxpLinkConfigurationEnums = 6;
#[doc = "< Force the Link to 2 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP2_X2:
    _spinCxpLinkConfigurationEnums = 7;
#[doc = "< Force the Link to 2 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP3_X2:
    _spinCxpLinkConfigurationEnums = 8;
#[doc = "< Force the Link to 2 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP5_X2:
    _spinCxpLinkConfigurationEnums = 9;
#[doc = "< Force the Link to 3 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP6_X2:
    _spinCxpLinkConfigurationEnums = 10;
#[doc = "< Force the Link to 3 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP1_X3:
    _spinCxpLinkConfigurationEnums = 11;
#[doc = "< Force the Link to 3 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP2_X3:
    _spinCxpLinkConfigurationEnums = 12;
#[doc = "< Force the Link to 3 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP3_X3:
    _spinCxpLinkConfigurationEnums = 13;
#[doc = "< Force the Link to 3 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP5_X3:
    _spinCxpLinkConfigurationEnums = 14;
#[doc = "< Force the Link to 3 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP6_X3:
    _spinCxpLinkConfigurationEnums = 15;
#[doc = "< Force the Link to 4 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP1_X4:
    _spinCxpLinkConfigurationEnums = 16;
#[doc = "< Force the Link to 4 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP2_X4:
    _spinCxpLinkConfigurationEnums = 17;
#[doc = "< Force the Link to 4 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP3_X4:
    _spinCxpLinkConfigurationEnums = 18;
#[doc = "< Force the Link to 4 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP5_X4:
    _spinCxpLinkConfigurationEnums = 19;
#[doc = "< Force the Link to 4 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP6_X4:
    _spinCxpLinkConfigurationEnums = 20;
#[doc = "< Force the Link to 5 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP1_X5:
    _spinCxpLinkConfigurationEnums = 21;
#[doc = "< Force the Link to 5 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP2_X5:
    _spinCxpLinkConfigurationEnums = 22;
#[doc = "< Force the Link to 5 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP3_X5:
    _spinCxpLinkConfigurationEnums = 23;
#[doc = "< Force the Link to 5 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP5_X5:
    _spinCxpLinkConfigurationEnums = 24;
#[doc = "< Force the Link to 5 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP6_X5:
    _spinCxpLinkConfigurationEnums = 25;
#[doc = "< Force the Link to 6 Connections operating at CXP-1 speed (1.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP1_X6:
    _spinCxpLinkConfigurationEnums = 26;
#[doc = "< Force the Link to 6 Connections operating at CXP-2 speed (2.50 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP2_X6:
    _spinCxpLinkConfigurationEnums = 27;
#[doc = "< Force the Link to 6 Connections operating at CXP-3 speed (3.125 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP3_X6:
    _spinCxpLinkConfigurationEnums = 28;
#[doc = "< Force the Link to 6 Connections operating at CXP-5 speed (5.00 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP5_X6:
    _spinCxpLinkConfigurationEnums = 29;
#[doc = "< Force the Link to 6 Connections operating at CXP-6 speed (6.25 Gbps)."]
pub const _spinCxpLinkConfigurationEnums_CxpLinkConfiguration_CXP6_X6:
    _spinCxpLinkConfigurationEnums = 30;
pub const _spinCxpLinkConfigurationEnums_NUM_CXPLINKCONFIGURATION: _spinCxpLinkConfigurationEnums =
    31;
pub type _spinCxpLinkConfigurationEnums = ::std::os::raw::c_uint;
pub use self::_spinCxpLinkConfigurationEnums as spinCxpLinkConfigurationEnums;
#[doc = "< Off"]
pub const _spinCxpConnectionTestModeEnums_CxpConnectionTestMode_Off:
    _spinCxpConnectionTestModeEnums = 0;
#[doc = "< Mode 1"]
pub const _spinCxpConnectionTestModeEnums_CxpConnectionTestMode_Mode1:
    _spinCxpConnectionTestModeEnums = 1;
pub const _spinCxpConnectionTestModeEnums_NUM_CXPCONNECTIONTESTMODE:
    _spinCxpConnectionTestModeEnums = 2;
pub type _spinCxpConnectionTestModeEnums = ::std::os::raw::c_uint;
pub use self::_spinCxpConnectionTestModeEnums as spinCxpConnectionTestModeEnums;
#[doc = "< Normal automatic PoCXP operation."]
pub const _spinCxpPoCxpStatusEnums_CxpPoCxpStatus_Auto: _spinCxpPoCxpStatusEnums = 0;
#[doc = "< PoCXP is forced off."]
pub const _spinCxpPoCxpStatusEnums_CxpPoCxpStatus_Off: _spinCxpPoCxpStatusEnums = 1;
#[doc = "< The Link has shut down because of an over-current trip."]
pub const _spinCxpPoCxpStatusEnums_CxpPoCxpStatus_Tripped: _spinCxpPoCxpStatusEnums = 2;
pub const _spinCxpPoCxpStatusEnums_NUM_CXPPOCXPSTATUS: _spinCxpPoCxpStatusEnums = 3;
pub type _spinCxpPoCxpStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinCxpPoCxpStatusEnums as spinCxpPoCxpStatusEnums;
#[doc = " @brief The type of information that can be obtained from image chunk data."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _spinChunkData {
    pub m_blackLevel: f64,
    pub m_frameID: i64,
    pub m_exposureTime: f64,
    pub m_compressionMode: i64,
    pub m_compressionRatio: f64,
    pub m_timestamp: i64,
    pub m_exposureEndLineStatusAll: i64,
    pub m_width: i64,
    pub m_image: i64,
    pub m_height: i64,
    pub m_gain: f64,
    pub m_sequencerSetActive: i64,
    pub m_cRC: i64,
    pub m_offsetX: i64,
    pub m_offsetY: i64,
    pub m_serialDataLength: i64,
    pub m_partSelector: i64,
    pub m_pixelDynamicRangeMin: i64,
    pub m_pixelDynamicRangeMax: i64,
    pub m_timestampLatchValue: i64,
    pub m_lineStatusAll: i64,
    pub m_counterValue: i64,
    pub m_timerValue: f64,
    pub m_scanLineSelector: i64,
    pub m_encoderValue: i64,
    pub m_linePitch: i64,
    pub m_transferBlockID: i64,
    pub m_transferQueueCurrentBlockCount: i64,
    pub m_streamChannelID: i64,
    pub m_scan3dCoordinateScale: f64,
    pub m_scan3dCoordinateOffset: f64,
    pub m_scan3dInvalidDataValue: f64,
    pub m_scan3dAxisMin: f64,
    pub m_scan3dAxisMax: f64,
    pub m_scan3dTransformValue: f64,
    pub m_scan3dCoordinateReferenceValue: f64,
    pub m_inferenceFrameId: i64,
    pub m_inferenceResult: i64,
    pub m_inferenceConfidence: f64,
}
#[test]
fn bindgen_test_layout__spinChunkData() {
    assert_eq!(
        ::std::mem::size_of::<_spinChunkData>(),
        312usize,
        concat!("Size of: ", stringify!(_spinChunkData))
    );
    assert_eq!(
        ::std::mem::align_of::<_spinChunkData>(),
        8usize,
        concat!("Alignment of ", stringify!(_spinChunkData))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_blackLevel as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_blackLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_frameID as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_frameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_exposureTime as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_exposureTime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_compressionMode as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_compressionMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_compressionRatio as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_compressionRatio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_timestamp as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_timestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_exposureEndLineStatusAll as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_exposureEndLineStatusAll)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_width as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_image as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_image)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_height as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_gain as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_gain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_sequencerSetActive as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_sequencerSetActive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_cRC as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_cRC)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_offsetX as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_offsetX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_offsetY as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_offsetY)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_serialDataLength as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_serialDataLength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_partSelector as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_partSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_pixelDynamicRangeMin as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_pixelDynamicRangeMin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_pixelDynamicRangeMax as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_pixelDynamicRangeMax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_timestampLatchValue as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_timestampLatchValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_lineStatusAll as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_lineStatusAll)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_counterValue as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_counterValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_timerValue as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_timerValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_scanLineSelector as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_scanLineSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_encoderValue as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_encoderValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_linePitch as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_linePitch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_transferBlockID as *const _ as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_transferBlockID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_transferQueueCurrentBlockCount as *const _
                as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_transferQueueCurrentBlockCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_streamChannelID as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_streamChannelID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_scan3dCoordinateScale as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_scan3dCoordinateScale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_scan3dCoordinateOffset as *const _ as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_scan3dCoordinateOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_scan3dInvalidDataValue as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_scan3dInvalidDataValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_scan3dAxisMin as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_scan3dAxisMin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_spinChunkData>())).m_scan3dAxisMax as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_scan3dAxisMax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_scan3dTransformValue as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_scan3dTransformValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_scan3dCoordinateReferenceValue as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_scan3dCoordinateReferenceValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_inferenceFrameId as *const _ as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_inferenceFrameId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_inferenceResult as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_inferenceResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_spinChunkData>())).m_inferenceConfidence as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_spinChunkData),
            "::",
            stringify!(m_inferenceConfidence)
        )
    );
}
#[doc = " @brief The type of information that can be obtained from image chunk data."]
pub type spinChunkData = _spinChunkData;
#[doc = " Handle for nodemap functionality. Created by calling"]
#[doc = " spinCameraGetNodemap(), spinCameraGetTLDeviceNodeMap(),"]
#[doc = " spinCameraGetTLStreamNodeMap() or spinInterfaceGetTLNodeMap(). No need"]
#[doc = " to release, clear, or destroy."]
pub type spinNodeMapHandle = *mut ::std::os::raw::c_void;
#[doc = " Handle for node functionality. Created by calling"]
#[doc = " spinNodeMapGetNode(). No need to release, clear, or destroy."]
pub type spinNodeHandle = *mut ::std::os::raw::c_void;
#[doc = " Handle for callback functionality. Created by calling"]
#[doc = " spinNodeRegisterCallback(), which requires a call to"]
#[doc = " spinNodeUnregisterCallback() destroy."]
pub type spinNodeCallbackHandle = *mut ::std::os::raw::c_void;
#[doc = " Function signatures are used to create and trigger callbacks and"]
#[doc = " events."]
pub type spinNodeCallbackFunction =
    ::std::option::Option<unsafe extern "C" fn(hNode: spinNodeHandle)>;
pub const _spinNodeType_ValueNode: _spinNodeType = 0;
pub const _spinNodeType_BaseNode: _spinNodeType = 1;
pub const _spinNodeType_IntegerNode: _spinNodeType = 2;
pub const _spinNodeType_BooleanNode: _spinNodeType = 3;
pub const _spinNodeType_FloatNode: _spinNodeType = 4;
pub const _spinNodeType_CommandNode: _spinNodeType = 5;
pub const _spinNodeType_StringNode: _spinNodeType = 6;
pub const _spinNodeType_RegisterNode: _spinNodeType = 7;
pub const _spinNodeType_EnumerationNode: _spinNodeType = 8;
pub const _spinNodeType_EnumEntryNode: _spinNodeType = 9;
pub const _spinNodeType_CategoryNode: _spinNodeType = 10;
pub const _spinNodeType_PortNode: _spinNodeType = 11;
pub const _spinNodeType_UnknownNode: _spinNodeType = -1;
pub type _spinNodeType = ::std::os::raw::c_int;
pub use self::_spinNodeType as spinNodeType;
pub const _spinSign_Signed: _spinSign = 0;
pub const _spinSign_Unsigned: _spinSign = 1;
pub const _spinSign__UndefinedSign: _spinSign = 2;
pub type _spinSign = ::std::os::raw::c_uint;
pub use self::_spinSign as spinSign;
pub const _spinAccessMode_NI: _spinAccessMode = 0;
pub const _spinAccessMode_NA: _spinAccessMode = 1;
pub const _spinAccessMode_WO: _spinAccessMode = 2;
pub const _spinAccessMode_RO: _spinAccessMode = 3;
pub const _spinAccessMode_RW: _spinAccessMode = 4;
pub const _spinAccessMode__UndefinedAccesMode: _spinAccessMode = 5;
pub const _spinAccessMode__CycleDetectAccesMode: _spinAccessMode = 6;
pub type _spinAccessMode = ::std::os::raw::c_uint;
pub use self::_spinAccessMode as spinAccessMode;
pub const _spinVisibility_Beginner: _spinVisibility = 0;
pub const _spinVisibility_Expert: _spinVisibility = 1;
pub const _spinVisibility_Guru: _spinVisibility = 2;
pub const _spinVisibility_Invisible: _spinVisibility = 3;
pub const _spinVisibility__UndefinedVisibility: _spinVisibility = 99;
pub type _spinVisibility = ::std::os::raw::c_uint;
pub use self::_spinVisibility as spinVisibility;
pub const _spinCachingMode_NoCache: _spinCachingMode = 0;
pub const _spinCachingMode_WriteThrough: _spinCachingMode = 1;
pub const _spinCachingMode_WriteAround: _spinCachingMode = 2;
pub const _spinCachingMode__UndefinedCachingMode: _spinCachingMode = 3;
pub type _spinCachingMode = ::std::os::raw::c_uint;
pub use self::_spinCachingMode as spinCachingMode;
#[doc = "!< Slider with linear behavior"]
pub const _spinRepresentation_Linear: _spinRepresentation = 0;
#[doc = "!< Slider with logarithmic behaviour"]
pub const _spinRepresentation_Logarithmic: _spinRepresentation = 1;
#[doc = "!< Check box"]
pub const _spinRepresentation_Boolean: _spinRepresentation = 2;
#[doc = "!< Decimal number in an edit control"]
pub const _spinRepresentation_PureNumber: _spinRepresentation = 3;
#[doc = "!< Hex number in an edit control"]
pub const _spinRepresentation_HexNumber: _spinRepresentation = 4;
#[doc = "!< IP-Address"]
pub const _spinRepresentation_IPV4Address: _spinRepresentation = 5;
#[doc = "!< MAC-Address"]
pub const _spinRepresentation_MACAddress: _spinRepresentation = 6;
pub const _spinRepresentation__UndefinedRepresentation: _spinRepresentation = 7;
#[doc = "! recommended representation of a node value"]
pub type _spinRepresentation = ::std::os::raw::c_uint;
#[doc = "! recommended representation of a node value"]
pub use self::_spinRepresentation as spinRepresentation;
#[doc = "!< Register is big endian"]
pub const _spinEndianess_BigEndian: _spinEndianess = 0;
#[doc = "!< Register is little endian"]
pub const _spinEndianess_LittleEndian: _spinEndianess = 1;
#[doc = "!< Object is not yet initialized"]
pub const _spinEndianess__UndefinedEndian: _spinEndianess = 2;
#[doc = "! Endianess of a value in a register"]
pub type _spinEndianess = ::std::os::raw::c_uint;
#[doc = "! Endianess of a value in a register"]
pub use self::_spinEndianess as spinEndianess;
#[doc = "!< name resides in custom namespace"]
pub const _spinNameSpace_Custom: _spinNameSpace = 0;
#[doc = "!< name resides in one of the standard namespaces"]
pub const _spinNameSpace_Standard: _spinNameSpace = 1;
#[doc = "!< Object is not yet initialized"]
pub const _spinNameSpace__UndefinedNameSpace: _spinNameSpace = 2;
#[doc = "! Defines if a node name is standard or custom"]
pub type _spinNameSpace = ::std::os::raw::c_uint;
#[doc = "! Defines if a node name is standard or custom"]
pub use self::_spinNameSpace as spinNameSpace;
#[doc = "!< name resides in custom namespace"]
pub const _spinStandardNameSpace_None: _spinStandardNameSpace = 0;
#[doc = "!< name resides in GigE Vision namespace"]
pub const _spinStandardNameSpace_GEV: _spinStandardNameSpace = 1;
#[doc = "!< name resides in 1394 IIDC namespace"]
pub const _spinStandardNameSpace_IIDC: _spinStandardNameSpace = 2;
#[doc = "!< name resides in camera link namespace"]
pub const _spinStandardNameSpace_CL: _spinStandardNameSpace = 3;
#[doc = "!< name resides in USB namespace"]
pub const _spinStandardNameSpace_USB: _spinStandardNameSpace = 4;
#[doc = "!< Object is not yet initialized"]
pub const _spinStandardNameSpace__UndefinedStandardNameSpace: _spinStandardNameSpace = 5;
#[doc = "! Defines from which standard namespace a node name comes from"]
pub type _spinStandardNameSpace = ::std::os::raw::c_uint;
#[doc = "! Defines from which standard namespace a node name comes from"]
pub use self::_spinStandardNameSpace as spinStandardNameSpace;
#[doc = "!< yes"]
pub const _spinYesNo_Yes: _spinYesNo = 1;
#[doc = "!< no"]
pub const _spinYesNo_No: _spinYesNo = 0;
#[doc = "!< Object is not yet initialized"]
pub const _spinYesNo__UndefinedYesNo: _spinYesNo = 2;
#[doc = "! Defines the chices of a Yes/No alternaitve"]
pub type _spinYesNo = ::std::os::raw::c_uint;
#[doc = "! Defines the chices of a Yes/No alternaitve"]
pub use self::_spinYesNo as spinYesNo;
pub const _spinSlope_Increasing: _spinSlope = 0;
#[doc = "!> strictly monotonous increasing"]
pub const _spinSlope_Decreasing: _spinSlope = 1;
#[doc = "!> strictly monotonous decreasing"]
pub const _spinSlope_Varying: _spinSlope = 2;
#[doc = "!> slope changes, e.g. at run-time"]
pub const _spinSlope_Automatic: _spinSlope = 3;
#[doc = "!< Object is not yet initialized"]
pub const _spinSlope__UndefinedESlope: _spinSlope = 4;
#[doc = "! typedef for fomula type"]
pub type _spinSlope = ::std::os::raw::c_uint;
#[doc = "! typedef for fomula type"]
pub use self::_spinSlope as spinSlope;
pub const _spinXMLValidation_xvLoad: _spinXMLValidation = 1;
#[doc = "!> Creates a dummy node map"]
pub const _spinXMLValidation_xvCycles: _spinXMLValidation = 2;
#[doc = "!> checks for write and dependency cycles (implies xvLoad)"]
pub const _spinXMLValidation_xvSFNC: _spinXMLValidation = 4;
#[doc = "!> checks for conformance with the standard feature naming convention (SFNC)"]
pub const _spinXMLValidation_xvDefault: _spinXMLValidation = 0;
#[doc = "!> checks performed if nothing else is said"]
pub const _spinXMLValidation_xvAll: _spinXMLValidation = 4294967295;
#[doc = "!< Object is not yet initialized"]
pub const _spinXMLValidation__UndefinedEXMLValidation: _spinXMLValidation = 134217728;
#[doc = "! typedef describing the different validity checks which can be performed on an XML file"]
#[doc = "*! The enum values for a bitfield of lenght uint32_t */"]
pub type _spinXMLValidation = ::std::os::raw::c_uint;
#[doc = "! typedef describing the different validity checks which can be performed on an XML file"]
#[doc = "*! The enum values for a bitfield of lenght uint32_t */"]
pub use self::_spinXMLValidation as spinXMLValidation;
pub const _spinDisplayNotation_fnAutomatic: _spinDisplayNotation = 0;
#[doc = "!> the notation if either scientific or fixed depending on what is shorter"]
pub const _spinDisplayNotation_fnFixed: _spinDisplayNotation = 1;
#[doc = "!> the notation is fixed, e.g. 123.4"]
pub const _spinDisplayNotation_fnScientific: _spinDisplayNotation = 2;
#[doc = "!< Object is not yet initialized"]
pub const _spinDisplayNotation__UndefinedEDisplayNotation: _spinDisplayNotation = 3;
#[doc = "! typedef for float notation"]
pub type _spinDisplayNotation = ::std::os::raw::c_uint;
#[doc = "! typedef for float notation"]
pub use self::_spinDisplayNotation as spinDisplayNotation;
pub const _spinInterfaceType_intfIValue: _spinInterfaceType = 0;
#[doc = "!> IValue interface"]
pub const _spinInterfaceType_intfIBase: _spinInterfaceType = 1;
#[doc = "!> IBase interface"]
pub const _spinInterfaceType_intfIInteger: _spinInterfaceType = 2;
#[doc = "!> IInteger interface"]
pub const _spinInterfaceType_intfIBoolean: _spinInterfaceType = 3;
#[doc = "!> IBoolean interface"]
pub const _spinInterfaceType_intfICommand: _spinInterfaceType = 4;
#[doc = "!> ICommand interface"]
pub const _spinInterfaceType_intfIFloat: _spinInterfaceType = 5;
#[doc = "!> IFloat interface"]
pub const _spinInterfaceType_intfIString: _spinInterfaceType = 6;
#[doc = "!> IString interface"]
pub const _spinInterfaceType_intfIRegister: _spinInterfaceType = 7;
#[doc = "!> IRegister interface"]
pub const _spinInterfaceType_intfICategory: _spinInterfaceType = 8;
#[doc = "!> ICategory interface"]
pub const _spinInterfaceType_intfIEnumeration: _spinInterfaceType = 9;
#[doc = "!> IEnumeration interface"]
pub const _spinInterfaceType_intfIEnumEntry: _spinInterfaceType = 10;
#[doc = "!> IEnumEntry interface"]
pub const _spinInterfaceType_intfIPort: _spinInterfaceType = 11;
#[doc = "! typedef for interface type"]
pub type _spinInterfaceType = ::std::os::raw::c_uint;
#[doc = "! typedef for interface type"]
pub use self::_spinInterfaceType as spinInterfaceType;
pub const _spinLinkType_ctAllDependingNodes: _spinLinkType = 0;
#[doc = "!> All nodes which will be invalidated if this node becomes invalid"]
pub const _spinLinkType_ctAllTerminalNodes: _spinLinkType = 1;
#[doc = "!> All terminal nodes which may be written to by this node"]
pub const _spinLinkType_ctInvalidators: _spinLinkType = 2;
#[doc = "!> List of references to nodes which may invalidate this node"]
pub const _spinLinkType_ctReadingChildren: _spinLinkType = 3;
#[doc = "!> All child nodes which influence this node's AccessMode"]
pub const _spinLinkType_ctWritingChildren: _spinLinkType = 4;
#[doc = "!> All child nodes which may be written to"]
pub const _spinLinkType_ctDependingChildren: _spinLinkType = 5;
#[doc = "! typedef for link type"]
pub type _spinLinkType = ::std::os::raw::c_uint;
#[doc = "! typedef for link type"]
pub use self::_spinLinkType as spinLinkType;
pub const _spinIncMode_noIncrement: _spinIncMode = 0;
pub const _spinIncMode_fixedIncrement: _spinIncMode = 1;
pub const _spinIncMode_listIncrement: _spinIncMode = 2;
#[doc = "! typedef for increment mode"]
pub type _spinIncMode = ::std::os::raw::c_uint;
#[doc = "! typedef for increment mode"]
pub use self::_spinIncMode as spinIncMode;
pub const _spinInputDirection_idFrom: _spinInputDirection = 0;
#[doc = "!> Indicates a swiss knife that it is used as worker for a converter computing FROM"]
pub const _spinInputDirection_idTo: _spinInputDirection = 1;
#[doc = "!> Indicates a swiss knife that it is used as worker for a converter computing TO"]
pub const _spinInputDirection_idNone: _spinInputDirection = 2;
#[doc = "! typedef for link type"]
pub type _spinInputDirection = ::std::os::raw::c_uint;
#[doc = "! typedef for link type"]
pub use self::_spinInputDirection as spinInputDirection;
extern "C" {
    #[doc = " Retrieves a node from the nodemap by name"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNodeMap The node map where the node is"]
    #[doc = " @param pName The name of the node"]
    #[doc = " @param phNode The node handle pointer in which the node is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeMapGetNode(
        hNodeMap: spinNodeMapHandle,
        pName: *const ::std::os::raw::c_char,
        phNode: *mut spinNodeHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Gets the number of nodes in the map"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNodeMap The node map where the nodes to be counted are"]
    #[doc = " @param pValue The unsigned integer pointer in which the number of nodes is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeMapGetNumNodes(hNodeMap: spinNodeMapHandle, pValue: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a node from the nodemap by index"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNodeMap The node map where the node is"]
    #[doc = " @param index The index of the node"]
    #[doc = " @param phNode The node handle pointer in which the node is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeMapGetNodeByIndex(
        hNodeMap: spinNodeMapHandle,
        index: size_t,
        phNode: *mut spinNodeHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Releases the entry node handle."]
    #[doc = " Make sure node handle is cleaned up properly by setting it to NULL after the node is released."]
    #[doc = " If this function is not explicitly called, the handle will be released upon the release of the"]
    #[doc = " camera handle."]
    #[doc = " @see spinCameraRelease"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNodeMap The node map from which the node handle is retrieved"]
    #[doc = " @param hNode The node handle to be released"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeMapReleaseNode(hNodeMap: spinNodeMapHandle, hNode: spinNodeHandle) -> spinError;
}
extern "C" {
    #[doc = " Fires nodes which have a polling time"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNodeMap The nodemap to poll"]
    #[doc = " @param timestamp The timestamp"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeMapPoll(hNodeMap: spinNodeMapHandle, timestamp: i64) -> spinError;
}
extern "C" {
    #[doc = " Checks whether a node is implemented"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node to check"]
    #[doc = " @param pbResult The boolean pointer to return whether or not the node is implemented"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeIsImplemented(hNode: spinNodeHandle, pbResult: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Checks whether a node is readable"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node to check"]
    #[doc = " @param pbResult The boolean pointer to return whether or not the node is readable"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeIsReadable(hNode: spinNodeHandle, pbResult: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Checks whether a node is writable"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node to check"]
    #[doc = " @param pbResult The boolean pointer to return whether or not the node is writable"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeIsWritable(hNode: spinNodeHandle, pbResult: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Checks whether a node is available"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node to check"]
    #[doc = " @param pbResult The boolean pointer to return whether or not the node is available"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeIsAvailable(hNode: spinNodeHandle, pbResult: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Checks whether two nodes are equal"]
    #[doc = ""]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNodeFirst The first node to check"]
    #[doc = " @param hNodeSecond The second node to check"]
    #[doc = " @param pbResult The boolean pointer to return whether or not the two nodes are equal"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeIsEqual(
        hNodeFirst: spinNodeHandle,
        hNodeSecond: spinNodeHandle,
        pbResult: *mut bool8_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the access mode of a node (as an enum, spinAccessMode)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinAccessMode"]
    #[doc = ""]
    #[doc = " @param hNode The node of the access mode to retrieve"]
    #[doc = " @param pAccessMode The access mode enum pointer in which the access mode is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetAccessMode(
        hNode: spinNodeHandle,
        pAccessMode: *mut spinAccessMode,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the name of a node (no whitespace)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node of the name to retrieve"]
    #[doc = " @param pBuf The c-string character buffer in which the name of the node is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetName(
        hNode: spinNodeHandle,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieve the namespace of a node (as an enum, spinNameSpace)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinNameSpace"]
    #[doc = ""]
    #[doc = " @param hNode The node of the namespace to retrieve"]
    #[doc = " @param pNamespace The namespace enum pointer in which the namespace is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetNameSpace(hNode: spinNodeHandle, pNamespace: *mut spinNameSpace)
        -> spinError;
}
extern "C" {
    #[doc = " Retrieves the recommended visibility of a node (as an enum, spinVisibility)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinVisibility"]
    #[doc = ""]
    #[doc = " @param hNode The node of the visibility to retrieve"]
    #[doc = " @param pVisibility The visibility enum pointer in which the visibility is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetVisibility(
        hNode: spinNodeHandle,
        pVisibility: *mut spinVisibility,
    ) -> spinError;
}
extern "C" {
    #[doc = " Invalidates a node in case its values may have changed, rendering it no longer valid"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node whose values may have changed"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeInvalidateNode(hNode: spinNodeHandle) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the caching mode of a node (as an enum, spinCachingMode)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinCachingMode"]
    #[doc = ""]
    #[doc = " @param hNode The node of the caching mode to retrieve"]
    #[doc = " @param pCachingMode The caching mode enum pointer in which the caching mode is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetCachingMode(
        hNode: spinNodeHandle,
        pCachingMode: *mut spinCachingMode,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a short description of a node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node of the tooltip to retrieve"]
    #[doc = " @param pBuf The c-string character buffer in which the short description of the node is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetToolTip(
        hNode: spinNodeHandle,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a longer description of a node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node of the description to retrieve"]
    #[doc = " @param pBuf The c-string character buffer in which the longer descrition of the node is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetDescription(
        hNode: spinNodeHandle,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the display name of a node (whitespace possible)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node of the display name to retrieve"]
    #[doc = " @param pBuf The c-string character buffer in which the display name of the node is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetDisplayName(
        hNode: spinNodeHandle,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the type of a node (as an enum, spinNodeType)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinNodeType"]
    #[doc = ""]
    #[doc = " @param hNode The node of the node type to retrieve"]
    #[doc = " @param pType The node type enum pointer in which the type of node is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetType(hNode: spinNodeHandle, pType: *mut spinNodeType) -> spinError;
}
extern "C" {
    #[doc = " Retrieve the polling time of a node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node of the polling time to retrieve"]
    #[doc = " @param pPollingTime The integer pointer in which the polling time is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetPollingTime(hNode: spinNodeHandle, pPollingTime: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Registers a callback to a node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node on which to register the callback"]
    #[doc = " @param pCbFunction The function pointer of the function that will execute when the callback is triggered; must"]
    #[doc = " match signature \"void spinNodeCallbackFunction(spinNodeHandle hNode)\""]
    #[doc = " @param phCb The callback handle pointer in which the callback is returned; used to unregister callbacks"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeRegisterCallback(
        hNode: spinNodeHandle,
        pCbFunction: spinNodeCallbackFunction,
        phCb: *mut spinNodeCallbackHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters a callback from a node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node from which to unregister the callback"]
    #[doc = " @param hCb The callback handle to unregister"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeDeregisterCallback(
        hNode: spinNodeHandle,
        hCb: spinNodeCallbackHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the imposed access mode of a node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node of the imposed access mode to retrieve"]
    #[doc = " @param imposedAccessMode The access mode enum pointer in which the imposed access mode is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetImposedAccessMode(
        hNode: spinNodeHandle,
        imposedAccessMode: spinAccessMode,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the imposed visibility of a node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node of the visibility to impose"]
    #[doc = " @param imposedVisibility The visibility enum pointer in which the imposed visibility is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeGetImposedVisibility(
        hNode: spinNodeHandle,
        imposedVisibility: spinVisibility,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of any node type as a c-string"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node of the value to read"]
    #[doc = " @param pBuf The c-string character buffer in which the value of the node is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeToString(
        hNode: spinNodeHandle,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of any node type as a c-string; manually set whether to verify the node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node of the value to read"]
    #[doc = " @param bVerify The boolean of whether to verify the node"]
    #[doc = " @param pBuf The c-string character buffer in which the value of the node is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeToStringEx(
        hNode: spinNodeHandle,
        bVerify: bool8_t,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of any node type from a c-string; it is important to ensure that the value of the c-string is"]
    #[doc = " appropriate to the node type"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node having its value changed"]
    #[doc = " @param pBuf The c-string of the value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeFromString(
        hNode: spinNodeHandle,
        pBuf: *const ::std::os::raw::c_char,
    ) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of any node type from a c-string; manually set whether to verify the node; ensure the value of the"]
    #[doc = " c-string is appropriate to the node type"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The node having its value changed"]
    #[doc = " @param bVerify The boolean of whether to verify the node"]
    #[doc = " @param pBuf The c-string of the value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinNodeFromStringEx(
        hNode: spinNodeHandle,
        bVerify: bool8_t,
        pBuf: *const ::std::os::raw::c_char,
    ) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of a string node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The string node having its value changed"]
    #[doc = " @param pBuf The c-string of the value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinStringSetValue(
        hNode: spinNodeHandle,
        pBuf: *const ::std::os::raw::c_char,
    ) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of a string node; manually set whether to verify the node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The string node having its value changed"]
    #[doc = " @param bVerify The boolean of whether to verify the node"]
    #[doc = " @param pBuf The c-string of the value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinStringSetValueEx(
        hNode: spinNodeHandle,
        bVerify: bool8_t,
        pBuf: *const ::std::os::raw::c_char,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of a string node as a c-string"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The string node of the value to read"]
    #[doc = " @param pBuf The c-string character buffer in which the value of the node is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinStringGetValue(
        hNode: spinNodeHandle,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of a string node as a cstring; manually set whether to verify the node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The string node of the value to read"]
    #[doc = " @param bVerify The boolean of whether to verify the node"]
    #[doc = " @param pBuf The c-string character buffer in which the value of the node is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinStringGetValueEx(
        hNode: spinNodeHandle,
        bVerify: bool8_t,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the maximum length of the c-string to be returned"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The string node of the length to retrieve"]
    #[doc = " @param pValue The integer pointer in which the maximum length of the c-string is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinStringGetMaxLength(hNode: spinNodeHandle, pValue: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of an integer node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The integer node having its value changed"]
    #[doc = " @param value The integer value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinIntegerSetValue(hNode: spinNodeHandle, value: i64) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of an integer node; manually set whether to verify the node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The integer node having its value changed"]
    #[doc = " @param bVerify The boolean of whether to verify the node"]
    #[doc = " @param value The integer value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinIntegerSetValueEx(hNode: spinNodeHandle, bVerify: bool8_t, value: i64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of an integer node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The integer node of the value to read"]
    #[doc = " @param pValue The integer pointer in which the value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinIntegerGetValue(hNode: spinNodeHandle, pValue: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of an integer node; manually set whether to verify the node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The integer node of the value to read"]
    #[doc = " @param bVerify The boolean of whether to verify the node"]
    #[doc = " @param pValue The integer pointer in which the value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinIntegerGetValueEx(
        hNode: spinNodeHandle,
        bVerify: bool8_t,
        pValue: *mut i64,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the minimum value of an integer node; all potential values must be greater than or equal to the minimum"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The integer node of the minimum value to retrieve"]
    #[doc = " @param pValue The integer pointer in which the minimum value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinIntegerGetMin(hNode: spinNodeHandle, pValue: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the maximum value of an integer node; all potential values must be lesser than or equal to the maximum"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The integer node of the maximum value to retrieve"]
    #[doc = " @param pValue The integer pointer in which the maximum value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinIntegerGetMax(hNode: spinNodeHandle, pValue: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the increment of an integer node; all possible values must be divisible by the increment"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The integer node of the increment to retrieve"]
    #[doc = " @param pValue The integer pointer in which the increment is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinIntegerGetInc(hNode: spinNodeHandle, pValue: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the numerical representation of the value of a node; i.e. linear, logarithmic, hexidecimal, MAC"]
    #[doc = " address, etc."]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The integer node of the numerical representation to retrieve"]
    #[doc = " @param pValue The representation enum pointer in which the type of numerical representation is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinIntegerGetRepresentation(
        hNode: spinNodeHandle,
        pValue: *mut spinRepresentation,
    ) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of a float node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The float node having its value changed"]
    #[doc = " @param value The float value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinFloatSetValue(hNode: spinNodeHandle, value: f64) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of a float node; manually set whether to verify the node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The float node having its value changed"]
    #[doc = " @param bVerify The boolean of whether to verify the node"]
    #[doc = " @param value The float value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinFloatSetValueEx(hNode: spinNodeHandle, bVerify: bool8_t, value: f64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of a float node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The float node of the value to read"]
    #[doc = " @param pValue The double pointer in which the value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinFloatGetValue(hNode: spinNodeHandle, pValue: *mut f64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of a float node; manually set whether to verify the node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The float node of the value to read"]
    #[doc = " @param pValue The double pointer in which the value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinFloatGetValueEx(
        hNode: spinNodeHandle,
        bVerify: bool8_t,
        pValue: *mut f64,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the minimum value of a float node; all potential values must be greater than or equal to the minimum"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The float node of the minimum value to retrieve"]
    #[doc = " @param pValue The double pointer in which the minimum value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinFloatGetMin(hNode: spinNodeHandle, pValue: *mut f64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the maximum value of a float node; all potential values must be lesser than or equal to the maximum"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The float node of the maximum value to retrieve"]
    #[doc = " @param pValue The double pointer in which the maximum value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinFloatGetMax(hNode: spinNodeHandle, pValue: *mut f64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the numerical representation of the value of a node; i.e. linear, logarithmic, hexidecimal, MAC"]
    #[doc = " address, etc."]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The float node of the numerical representation to retrieve"]
    #[doc = " @param pValue The representation enum pointer in which the type of numerical representation is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinFloatGetRepresentation(
        hNode: spinNodeHandle,
        pValue: *mut spinRepresentation,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the units of the float node value"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The float node of the units to retrieve"]
    #[doc = " @param pBuf The c-string character buffer in which the value units are returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinFloatGetUnit(
        hNode: spinNodeHandle,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the number of entries of an enum node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hEnumNode The enum node where the entries to be counted are"]
    #[doc = " @param pValue The unsigned integer pointer in which the number of entries is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinEnumerationGetNumEntries(
        hEnumNode: spinNodeHandle,
        pValue: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves an entry node from an enum node using an index"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hEnumNode The enum node from which the entry node is retrieved"]
    #[doc = " @param index The index of the entry node"]
    #[doc = " @param phEntry The node handle pointer in which the entry node is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinEnumerationGetEntryByIndex(
        hEnumNode: spinNodeHandle,
        index: size_t,
        phEntry: *mut spinNodeHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves an entry node from an enum node using the entry's symbolic"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hEnumNode The enum node from which the entry node is retrieved"]
    #[doc = " @param pName The name of the entry node"]
    #[doc = " @param phEntry The node handle pointer in which the entry node is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinEnumerationGetEntryByName(
        hEnumNode: spinNodeHandle,
        pName: *const ::std::os::raw::c_char,
        phEntry: *mut spinNodeHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the currently selected entry node from an enum node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hEnumNode The enum node from which the current entry node is retrieved"]
    #[doc = " @param phEntry The node handle pointer in which the current entry node is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinEnumerationGetCurrentEntry(
        hEnumNode: spinNodeHandle,
        phEntry: *mut spinNodeHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Releases the entry node from the enum node handle."]
    #[doc = " Make sure node handle is cleaned up properly by setting it to NULL after the node is released"]
    #[doc = " If this function is not explicitly called, the handle will be released upon the release of the"]
    #[doc = " camera handle."]
    #[doc = " @see spinCameraRelease"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hEnumNode The enum node from which the current entry node is retrieved"]
    #[doc = " @param hEntry The entry node handle to be released"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinEnumerationReleaseNode(
        hEnumNode: spinNodeHandle,
        hEntry: spinNodeHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Sets a new entry using its integer value retrieved from a call to spinEnumerationEntryGetIntValue(); note that"]
    #[doc = " enumeration entry int and enum values are different - int values defined on camera, enum values found in"]
    #[doc = " SpinnakerDefsC.h"]
    #[doc = " @see spinEnumerationEntryGetIntValue()"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hEnumNode The enum node having its entry changed"]
    #[doc = " @param value The integer value of the entry node to set; this corresponds to the integer value internal to the"]
    #[doc = " camera"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinEnumerationSetIntValue(hEnumNode: spinNodeHandle, value: i64) -> spinError;
}
extern "C" {
    #[doc = " Sets a new entry using its enum; note that enumeration entry int and enum values are different - int values"]
    #[doc = " defined on camera, enum values found in SpinnakerDefsC.h"]
    #[doc = " @see spinEnumerationEntryGetEnumValue()"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hEnumNode The enum node have its entry changed"]
    #[doc = " @param value The enum value of the entry node to set; this corresponds to its integer value created in the"]
    #[doc = " library"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinEnumerationSetEnumValue(hEnumNode: spinNodeHandle, value: size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the integer value of an entry node; note that enumeration entry int and enum values are different - int"]
    #[doc = " values defined on camera, enum values found in SpinnakerDefsC.h"]
    #[doc = " @see spinEnumerationSetIntValue()"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The entry node of the integer value to retrieve"]
    #[doc = " @param pValue The integer pointer in which the integer value of the entry is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinEnumerationEntryGetIntValue(hNode: spinNodeHandle, pValue: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the enum value (as an integer) of an entry node; note that enumeraiton entry int and enum values are"]
    #[doc = " different - int values defined on camera, enum values found in SpinnakerDefsC.h"]
    #[doc = " @see spinEnumerationSetEnumValue()"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The entry node of the enum value to retrieve"]
    #[doc = " @param pValue The unsigned integer pointer in which the enum value of the entry is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinEnumerationEntryGetEnumValue(
        hNode: spinNodeHandle,
        pValue: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the symbolic of an entry node as a c-string"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The entry node of the symbolic to retrieve"]
    #[doc = " @param pBuf The c-string character buffer in which the symbolic of the entry node is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinEnumerationEntryGetSymbolic(
        hNode: spinNodeHandle,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of a boolean node; boolean values are represented by 'True' (which equals '0') and 'False' (which"]
    #[doc = " equals '1')"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The boolean node having its value changed"]
    #[doc = " @param value The boolean value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinBooleanSetValue(hNode: spinNodeHandle, value: bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of a boolean node; boolean values are represented by 'True' (which equals '0') and 'False'"]
    #[doc = " (which equals '1')"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The boolean node of the value to read"]
    #[doc = " @param pValue The boolean pointer in which the value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinBooleanGetValue(hNode: spinNodeHandle, pbValue: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Executes the action associated to a command node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The command node to execute"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCommandExecute(hNode: spinNodeHandle) -> spinError;
}
extern "C" {
    #[doc = " Retrieves whether or not the action of a command node has completed"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The command node to check"]
    #[doc = " @param pValue The boolean pointer to return whether or not the command has completed"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCommandIsDone(hNode: spinNodeHandle, pbValue: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the number of a features (or child nodes) or a category node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCategoryNode The category node where the features to be counted are"]
    #[doc = " @param pValue The unsigned integer pointer in which the number of features is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCategoryGetNumFeatures(
        hCategoryNode: spinNodeHandle,
        pValue: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a node from a category node using an index"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCategoryNode The category node of the node to retrieve"]
    #[doc = " @param index The index of the feature node"]
    #[doc = " @param phFeature The node handle pointer in which the feature node is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCategoryGetFeatureByIndex(
        hCategoryNode: spinNodeHandle,
        index: size_t,
        phFeature: *mut spinNodeHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Releases the feature node from the category node."]
    #[doc = " Make sure node handle is cleaned up properly by setting it to NULL after the node is released"]
    #[doc = " If this function is not explicitly called, the handle will be released upon the release of the"]
    #[doc = " camera handle."]
    #[doc = " @see spinCameraRelease"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCategoryNode The category node handle from which the feature node is retrieved"]
    #[doc = " @param hFeature The feature node handle to be released"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCategoryReleaseNode(
        hCategoryNode: spinNodeHandle,
        hFeature: spinNodeHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of a register node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The register node of the value to retrieve"]
    #[doc = " @param pBuf The unsigned integer buffer in which the value is returned"]
    #[doc = " @param length The integer pointer in which the length of the register array is returned; the input value is the"]
    #[doc = " maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinRegisterGet(hNode: spinNodeHandle, pBuf: *mut u8, length: i64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the value of a register node; manually set whether to verify the node and whether to ignore the cache"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The register node of the value to retrieve"]
    #[doc = " @param bVerify The boolean of whether to verify the node"]
    #[doc = " @param IgnoreCache The boolean of whether to ignore the cache"]
    #[doc = " @param pBuf The unsigned integer buffer in which the value is returned"]
    #[doc = " @param length The integer pointer in which the length of the register array is returned; the input value is the"]
    #[doc = " maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinRegisterGetEx(
        hNode: spinNodeHandle,
        bVerify: bool8_t,
        bIgnoreCache: bool8_t,
        pBuf: *mut u8,
        length: i64,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the address of a register node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The register node of the address to retrieve"]
    #[doc = " @param pAddress The integer pointer in which the address is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinRegisterGetAddress(hNode: spinNodeHandle, pAddress: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the length (in bytes) of the value of a register node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The register node of the length to retrieve"]
    #[doc = " @param plength The integer in which the number of bytes is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinRegisterGetLength(hNode: spinNodeHandle, pLength: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of a register node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The register node of the value to set"]
    #[doc = " @param pBuf The unsigned integer buffer of the value to set"]
    #[doc = " @param length The number of bytes of the value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinRegisterSet(hNode: spinNodeHandle, pBuf: *const u8, length: i64) -> spinError;
}
extern "C" {
    #[doc = " Sets the value of a register node; manually set whether to verify the node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The register node of the value to set"]
    #[doc = " @param bVerify The boolean of whether to verify the node"]
    #[doc = " @param pBuf The unsigned integer buffer of the value to set"]
    #[doc = " @param length The number of bytes of the value to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinRegisterSetEx(
        hNode: spinNodeHandle,
        bVerify: bool8_t,
        pBuf: *const u8,
        length: i64,
    ) -> spinError;
}
extern "C" {
    #[doc = " Uses a second node as a reference for a register node"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hNode The register node that houses the reference"]
    #[doc = " @param hRef The reference node"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinRegisterSetReference(hNode: spinNodeHandle, hRef: spinNodeHandle) -> spinError;
}
pub type quickSpinStringNode = spinNodeHandle;
pub type quickSpinIntegerNode = spinNodeHandle;
pub type quickSpinFloatNode = spinNodeHandle;
pub type quickSpinBooleanNode = spinNodeHandle;
pub type quickSpinEnumerationNode = spinNodeHandle;
pub type quickSpinCommandNode = spinNodeHandle;
pub type quickSpinRegisterNode = spinNodeHandle;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _quickSpin {
    pub LUTIndex: quickSpinIntegerNode,
    pub LUTEnable: quickSpinBooleanNode,
    pub LUTValue: quickSpinIntegerNode,
    pub LUTSelector: quickSpinEnumerationNode,
    pub ExposureTime: quickSpinFloatNode,
    pub AcquisitionStop: quickSpinCommandNode,
    pub AcquisitionResultingFrameRate: quickSpinFloatNode,
    pub AcquisitionLineRate: quickSpinFloatNode,
    pub AcquisitionStart: quickSpinCommandNode,
    pub TriggerSoftware: quickSpinCommandNode,
    pub ExposureMode: quickSpinEnumerationNode,
    pub AcquisitionMode: quickSpinEnumerationNode,
    pub AcquisitionFrameCount: quickSpinIntegerNode,
    pub TriggerSource: quickSpinEnumerationNode,
    pub TriggerActivation: quickSpinEnumerationNode,
    pub SensorShutterMode: quickSpinEnumerationNode,
    pub TriggerDelay: quickSpinFloatNode,
    pub TriggerMode: quickSpinEnumerationNode,
    pub AcquisitionFrameRate: quickSpinFloatNode,
    pub TriggerOverlap: quickSpinEnumerationNode,
    pub TriggerSelector: quickSpinEnumerationNode,
    pub AcquisitionFrameRateEnable: quickSpinBooleanNode,
    pub ExposureAuto: quickSpinEnumerationNode,
    pub AcquisitionBurstFrameCount: quickSpinIntegerNode,
    pub EventTest: quickSpinIntegerNode,
    pub EventTestTimestamp: quickSpinIntegerNode,
    pub EventExposureEndFrameID: quickSpinIntegerNode,
    pub EventExposureEnd: quickSpinIntegerNode,
    pub EventExposureEndTimestamp: quickSpinIntegerNode,
    pub EventError: quickSpinIntegerNode,
    pub EventErrorTimestamp: quickSpinIntegerNode,
    pub EventErrorCode: quickSpinIntegerNode,
    pub EventErrorFrameID: quickSpinIntegerNode,
    pub EventSelector: quickSpinEnumerationNode,
    pub EventSerialReceiveOverflow: quickSpinBooleanNode,
    pub EventSerialPortReceive: quickSpinIntegerNode,
    pub EventSerialPortReceiveTimestamp: quickSpinIntegerNode,
    pub EventSerialData: quickSpinStringNode,
    pub EventSerialDataLength: quickSpinIntegerNode,
    pub EventNotification: quickSpinEnumerationNode,
    pub LogicBlockLUTRowIndex: quickSpinIntegerNode,
    pub LogicBlockSelector: quickSpinEnumerationNode,
    pub LogicBlockLUTInputActivation: quickSpinEnumerationNode,
    pub LogicBlockLUTInputSelector: quickSpinEnumerationNode,
    pub LogicBlockLUTInputSource: quickSpinEnumerationNode,
    pub LogicBlockLUTOutputValue: quickSpinBooleanNode,
    pub LogicBlockLUTOutputValueAll: quickSpinIntegerNode,
    pub LogicBlockLUTSelector: quickSpinEnumerationNode,
    pub ColorTransformationValue: quickSpinFloatNode,
    pub ColorTransformationEnable: quickSpinBooleanNode,
    pub ColorTransformationSelector: quickSpinEnumerationNode,
    pub RgbTransformLightSource: quickSpinEnumerationNode,
    pub Saturation: quickSpinFloatNode,
    pub SaturationEnable: quickSpinBooleanNode,
    pub ColorTransformationValueSelector: quickSpinEnumerationNode,
    pub TimestampLatchValue: quickSpinIntegerNode,
    pub TimestampReset: quickSpinCommandNode,
    pub DeviceUserID: quickSpinStringNode,
    pub DeviceTemperature: quickSpinFloatNode,
    pub MaxDeviceResetTime: quickSpinIntegerNode,
    pub DeviceTLVersionMinor: quickSpinIntegerNode,
    pub DeviceSerialNumber: quickSpinStringNode,
    pub DeviceVendorName: quickSpinStringNode,
    pub DeviceRegistersEndianness: quickSpinEnumerationNode,
    pub DeviceManufacturerInfo: quickSpinStringNode,
    pub DeviceLinkSpeed: quickSpinIntegerNode,
    pub LinkUptime: quickSpinIntegerNode,
    pub DeviceEventChannelCount: quickSpinIntegerNode,
    pub TimestampLatch: quickSpinCommandNode,
    pub DeviceScanType: quickSpinEnumerationNode,
    pub DeviceReset: quickSpinCommandNode,
    pub DeviceCharacterSet: quickSpinEnumerationNode,
    pub DeviceLinkThroughputLimit: quickSpinIntegerNode,
    pub DeviceFirmwareVersion: quickSpinStringNode,
    pub DeviceStreamChannelCount: quickSpinIntegerNode,
    pub DeviceTLType: quickSpinEnumerationNode,
    pub DeviceVersion: quickSpinStringNode,
    pub DevicePowerSupplySelector: quickSpinEnumerationNode,
    pub SensorDescription: quickSpinStringNode,
    pub DeviceModelName: quickSpinStringNode,
    pub DeviceTLVersionMajor: quickSpinIntegerNode,
    pub DeviceTemperatureSelector: quickSpinEnumerationNode,
    pub EnumerationCount: quickSpinIntegerNode,
    pub PowerSupplyCurrent: quickSpinFloatNode,
    pub DeviceID: quickSpinStringNode,
    pub DeviceUptime: quickSpinIntegerNode,
    pub DeviceLinkCurrentThroughput: quickSpinIntegerNode,
    pub DeviceMaxThroughput: quickSpinIntegerNode,
    pub FactoryReset: quickSpinCommandNode,
    pub PowerSupplyVoltage: quickSpinFloatNode,
    pub DeviceIndicatorMode: quickSpinEnumerationNode,
    pub DeviceLinkBandwidthReserve: quickSpinFloatNode,
    pub AasRoiOffsetY: quickSpinIntegerNode,
    pub AasRoiOffsetX: quickSpinIntegerNode,
    pub AutoExposureControlPriority: quickSpinEnumerationNode,
    pub BalanceWhiteAutoLowerLimit: quickSpinFloatNode,
    pub BalanceWhiteAutoDamping: quickSpinFloatNode,
    pub AasRoiHeight: quickSpinIntegerNode,
    pub AutoExposureGreyValueUpperLimit: quickSpinFloatNode,
    pub AutoExposureTargetGreyValue: quickSpinFloatNode,
    pub AutoExposureGainLowerLimit: quickSpinFloatNode,
    pub AutoExposureGreyValueLowerLimit: quickSpinFloatNode,
    pub AutoExposureMeteringMode: quickSpinEnumerationNode,
    pub AutoExposureExposureTimeUpperLimit: quickSpinFloatNode,
    pub AutoExposureGainUpperLimit: quickSpinFloatNode,
    pub AutoExposureControlLoopDamping: quickSpinFloatNode,
    pub AutoExposureEVCompensation: quickSpinFloatNode,
    pub AutoExposureExposureTimeLowerLimit: quickSpinFloatNode,
    pub BalanceWhiteAutoProfile: quickSpinEnumerationNode,
    pub AutoAlgorithmSelector: quickSpinEnumerationNode,
    pub AutoExposureTargetGreyValueAuto: quickSpinEnumerationNode,
    pub AasRoiEnable: quickSpinBooleanNode,
    pub AutoExposureLightingMode: quickSpinEnumerationNode,
    pub AasRoiWidth: quickSpinIntegerNode,
    pub BalanceWhiteAutoUpperLimit: quickSpinFloatNode,
    pub LinkErrorCount: quickSpinIntegerNode,
    pub GevCurrentIPConfigurationDHCP: quickSpinBooleanNode,
    pub GevInterfaceSelector: quickSpinIntegerNode,
    pub GevSCPD: quickSpinIntegerNode,
    pub GevTimestampTickFrequency: quickSpinIntegerNode,
    pub GevSCPSPacketSize: quickSpinIntegerNode,
    pub GevCurrentDefaultGateway: quickSpinIntegerNode,
    pub GevSCCFGUnconditionalStreaming: quickSpinBooleanNode,
    pub GevMCTT: quickSpinIntegerNode,
    pub GevSCPSDoNotFragment: quickSpinBooleanNode,
    pub GevCurrentSubnetMask: quickSpinIntegerNode,
    pub GevStreamChannelSelector: quickSpinIntegerNode,
    pub GevCurrentIPAddress: quickSpinIntegerNode,
    pub GevMCSP: quickSpinIntegerNode,
    pub GevGVCPPendingTimeout: quickSpinIntegerNode,
    pub GevIEEE1588Status: quickSpinEnumerationNode,
    pub GevFirstURL: quickSpinStringNode,
    pub GevMACAddress: quickSpinIntegerNode,
    pub GevPersistentSubnetMask: quickSpinIntegerNode,
    pub GevMCPHostPort: quickSpinIntegerNode,
    pub GevSCPHostPort: quickSpinIntegerNode,
    pub GevGVCPPendingAck: quickSpinBooleanNode,
    pub GevSCPInterfaceIndex: quickSpinIntegerNode,
    pub GevSupportedOption: quickSpinBooleanNode,
    pub GevIEEE1588Mode: quickSpinEnumerationNode,
    pub GevCurrentIPConfigurationLLA: quickSpinBooleanNode,
    pub GevSCSP: quickSpinIntegerNode,
    pub GevIEEE1588: quickSpinBooleanNode,
    pub GevSCCFGExtendedChunkData: quickSpinBooleanNode,
    pub GevPersistentIPAddress: quickSpinIntegerNode,
    pub GevCurrentIPConfigurationPersistentIP: quickSpinBooleanNode,
    pub GevIEEE1588ClockAccuracy: quickSpinEnumerationNode,
    pub GevHeartbeatTimeout: quickSpinIntegerNode,
    pub GevPersistentDefaultGateway: quickSpinIntegerNode,
    pub GevCCP: quickSpinEnumerationNode,
    pub GevMCDA: quickSpinIntegerNode,
    pub GevSCDA: quickSpinIntegerNode,
    pub GevSCPDirection: quickSpinIntegerNode,
    pub GevSCPSFireTestPacket: quickSpinBooleanNode,
    pub GevSecondURL: quickSpinStringNode,
    pub GevSupportedOptionSelector: quickSpinEnumerationNode,
    pub GevGVCPHeartbeatDisable: quickSpinBooleanNode,
    pub GevMCRC: quickSpinIntegerNode,
    pub GevSCPSBigEndian: quickSpinBooleanNode,
    pub GevNumberOfInterfaces: quickSpinIntegerNode,
    pub TLParamsLocked: quickSpinIntegerNode,
    pub PayloadSize: quickSpinIntegerNode,
    pub PacketResendRequestCount: quickSpinIntegerNode,
    pub SharpeningEnable: quickSpinBooleanNode,
    pub BlackLevelSelector: quickSpinEnumerationNode,
    pub GammaEnable: quickSpinBooleanNode,
    pub SharpeningAuto: quickSpinBooleanNode,
    pub BlackLevelClampingEnable: quickSpinBooleanNode,
    pub BalanceRatio: quickSpinFloatNode,
    pub BalanceWhiteAuto: quickSpinEnumerationNode,
    pub SharpeningThreshold: quickSpinFloatNode,
    pub GainAuto: quickSpinEnumerationNode,
    pub Sharpening: quickSpinFloatNode,
    pub Gain: quickSpinFloatNode,
    pub BalanceRatioSelector: quickSpinEnumerationNode,
    pub GainSelector: quickSpinEnumerationNode,
    pub BlackLevel: quickSpinFloatNode,
    pub BlackLevelRaw: quickSpinIntegerNode,
    pub Gamma: quickSpinFloatNode,
    pub DefectTableIndex: quickSpinIntegerNode,
    pub DefectTableFactoryRestore: quickSpinCommandNode,
    pub DefectTableCoordinateY: quickSpinIntegerNode,
    pub DefectTableSave: quickSpinCommandNode,
    pub DefectCorrectionMode: quickSpinEnumerationNode,
    pub DefectTableCoordinateX: quickSpinIntegerNode,
    pub DefectTablePixelCount: quickSpinIntegerNode,
    pub DefectCorrectStaticEnable: quickSpinBooleanNode,
    pub DefectTableApply: quickSpinCommandNode,
    pub UserSetFeatureEnable: quickSpinBooleanNode,
    pub UserSetSave: quickSpinCommandNode,
    pub UserSetSelector: quickSpinEnumerationNode,
    pub UserSetLoad: quickSpinCommandNode,
    pub UserSetDefault: quickSpinEnumerationNode,
    pub SerialPortBaudRate: quickSpinEnumerationNode,
    pub SerialPortDataBits: quickSpinIntegerNode,
    pub SerialPortParity: quickSpinEnumerationNode,
    pub SerialTransmitQueueMaxCharacterCount: quickSpinIntegerNode,
    pub SerialReceiveQueueCurrentCharacterCount: quickSpinIntegerNode,
    pub SerialPortSelector: quickSpinEnumerationNode,
    pub SerialPortStopBits: quickSpinEnumerationNode,
    pub SerialReceiveQueueClear: quickSpinCommandNode,
    pub SerialReceiveFramingErrorCount: quickSpinIntegerNode,
    pub SerialTransmitQueueCurrentCharacterCount: quickSpinIntegerNode,
    pub SerialReceiveParityErrorCount: quickSpinIntegerNode,
    pub SerialPortSource: quickSpinEnumerationNode,
    pub SerialReceiveQueueMaxCharacterCount: quickSpinIntegerNode,
    pub SequencerSetStart: quickSpinIntegerNode,
    pub SequencerMode: quickSpinEnumerationNode,
    pub SequencerConfigurationValid: quickSpinEnumerationNode,
    pub SequencerSetValid: quickSpinEnumerationNode,
    pub SequencerSetSelector: quickSpinIntegerNode,
    pub SequencerTriggerActivation: quickSpinEnumerationNode,
    pub SequencerConfigurationMode: quickSpinEnumerationNode,
    pub SequencerSetSave: quickSpinCommandNode,
    pub SequencerTriggerSource: quickSpinEnumerationNode,
    pub SequencerSetActive: quickSpinIntegerNode,
    pub SequencerSetNext: quickSpinIntegerNode,
    pub SequencerSetLoad: quickSpinCommandNode,
    pub SequencerPathSelector: quickSpinIntegerNode,
    pub SequencerFeatureEnable: quickSpinBooleanNode,
    pub TransferBlockCount: quickSpinIntegerNode,
    pub TransferStart: quickSpinCommandNode,
    pub TransferQueueMaxBlockCount: quickSpinIntegerNode,
    pub TransferQueueCurrentBlockCount: quickSpinIntegerNode,
    pub TransferQueueMode: quickSpinEnumerationNode,
    pub TransferOperationMode: quickSpinEnumerationNode,
    pub TransferStop: quickSpinCommandNode,
    pub TransferQueueOverflowCount: quickSpinIntegerNode,
    pub TransferControlMode: quickSpinEnumerationNode,
    pub ChunkBlackLevel: quickSpinFloatNode,
    pub ChunkFrameID: quickSpinIntegerNode,
    pub ChunkSerialData: quickSpinStringNode,
    pub ChunkExposureTime: quickSpinFloatNode,
    pub ChunkCompressionMode: quickSpinIntegerNode,
    pub ChunkCompressionRatio: quickSpinFloatNode,
    pub ChunkSerialReceiveOverflow: quickSpinBooleanNode,
    pub ChunkTimestamp: quickSpinIntegerNode,
    pub ChunkModeActive: quickSpinBooleanNode,
    pub ChunkExposureEndLineStatusAll: quickSpinIntegerNode,
    pub ChunkGainSelector: quickSpinEnumerationNode,
    pub ChunkSelector: quickSpinEnumerationNode,
    pub ChunkBlackLevelSelector: quickSpinEnumerationNode,
    pub ChunkWidth: quickSpinIntegerNode,
    pub ChunkImage: quickSpinIntegerNode,
    pub ChunkHeight: quickSpinIntegerNode,
    pub ChunkPixelFormat: quickSpinEnumerationNode,
    pub ChunkGain: quickSpinFloatNode,
    pub ChunkSequencerSetActive: quickSpinIntegerNode,
    pub ChunkCRC: quickSpinIntegerNode,
    pub ChunkOffsetX: quickSpinIntegerNode,
    pub ChunkOffsetY: quickSpinIntegerNode,
    pub ChunkEnable: quickSpinBooleanNode,
    pub ChunkSerialDataLength: quickSpinIntegerNode,
    pub FileAccessOffset: quickSpinIntegerNode,
    pub FileAccessLength: quickSpinIntegerNode,
    pub FileOperationStatus: quickSpinEnumerationNode,
    pub FileOperationExecute: quickSpinCommandNode,
    pub FileOpenMode: quickSpinEnumerationNode,
    pub FileOperationResult: quickSpinIntegerNode,
    pub FileOperationSelector: quickSpinEnumerationNode,
    pub FileSelector: quickSpinEnumerationNode,
    pub FileSize: quickSpinIntegerNode,
    pub BinningSelector: quickSpinEnumerationNode,
    pub PixelDynamicRangeMin: quickSpinIntegerNode,
    pub PixelDynamicRangeMax: quickSpinIntegerNode,
    pub OffsetY: quickSpinIntegerNode,
    pub BinningHorizontal: quickSpinIntegerNode,
    pub Width: quickSpinIntegerNode,
    pub TestPatternGeneratorSelector: quickSpinEnumerationNode,
    pub CompressionRatio: quickSpinFloatNode,
    pub CompressionSaturationPriority: quickSpinEnumerationNode,
    pub ReverseX: quickSpinBooleanNode,
    pub ReverseY: quickSpinBooleanNode,
    pub TestPattern: quickSpinEnumerationNode,
    pub PixelColorFilter: quickSpinEnumerationNode,
    pub WidthMax: quickSpinIntegerNode,
    pub AdcBitDepth: quickSpinEnumerationNode,
    pub BinningVertical: quickSpinIntegerNode,
    pub DecimationHorizontalMode: quickSpinEnumerationNode,
    pub BinningVerticalMode: quickSpinEnumerationNode,
    pub OffsetX: quickSpinIntegerNode,
    pub HeightMax: quickSpinIntegerNode,
    pub DecimationHorizontal: quickSpinIntegerNode,
    pub PixelSize: quickSpinEnumerationNode,
    pub SensorHeight: quickSpinIntegerNode,
    pub DecimationSelector: quickSpinEnumerationNode,
    pub IspEnable: quickSpinBooleanNode,
    pub AdaptiveCompressionEnable: quickSpinBooleanNode,
    pub ImageCompressionMode: quickSpinEnumerationNode,
    pub DecimationVertical: quickSpinIntegerNode,
    pub Height: quickSpinIntegerNode,
    pub BinningHorizontalMode: quickSpinEnumerationNode,
    pub PixelFormat: quickSpinEnumerationNode,
    pub SensorWidth: quickSpinIntegerNode,
    pub DecimationVerticalMode: quickSpinEnumerationNode,
    pub TestEventGenerate: quickSpinCommandNode,
    pub TriggerEventTest: quickSpinCommandNode,
    pub GuiXmlManifestAddress: quickSpinIntegerNode,
    pub Test0001: quickSpinIntegerNode,
    pub V3_3Enable: quickSpinBooleanNode,
    pub LineMode: quickSpinEnumerationNode,
    pub LineSource: quickSpinEnumerationNode,
    pub LineInputFilterSelector: quickSpinEnumerationNode,
    pub UserOutputValue: quickSpinBooleanNode,
    pub UserOutputValueAll: quickSpinIntegerNode,
    pub UserOutputSelector: quickSpinEnumerationNode,
    pub LineStatus: quickSpinBooleanNode,
    pub LineFormat: quickSpinEnumerationNode,
    pub LineStatusAll: quickSpinIntegerNode,
    pub LineSelector: quickSpinEnumerationNode,
    pub ExposureActiveMode: quickSpinEnumerationNode,
    pub LineInverter: quickSpinBooleanNode,
    pub LineFilterWidth: quickSpinFloatNode,
    pub CounterTriggerActivation: quickSpinEnumerationNode,
    pub CounterValue: quickSpinIntegerNode,
    pub CounterSelector: quickSpinEnumerationNode,
    pub CounterValueAtReset: quickSpinIntegerNode,
    pub CounterStatus: quickSpinEnumerationNode,
    pub CounterTriggerSource: quickSpinEnumerationNode,
    pub CounterDelay: quickSpinIntegerNode,
    pub CounterResetSource: quickSpinEnumerationNode,
    pub CounterEventSource: quickSpinEnumerationNode,
    pub CounterEventActivation: quickSpinEnumerationNode,
    pub CounterDuration: quickSpinIntegerNode,
    pub CounterResetActivation: quickSpinEnumerationNode,
    pub DeviceType: quickSpinEnumerationNode,
    pub DeviceFamilyName: quickSpinStringNode,
    pub DeviceSFNCVersionMajor: quickSpinIntegerNode,
    pub DeviceSFNCVersionMinor: quickSpinIntegerNode,
    pub DeviceSFNCVersionSubMinor: quickSpinIntegerNode,
    pub DeviceManifestEntrySelector: quickSpinIntegerNode,
    pub DeviceManifestXMLMajorVersion: quickSpinIntegerNode,
    pub DeviceManifestXMLMinorVersion: quickSpinIntegerNode,
    pub DeviceManifestXMLSubMinorVersion: quickSpinIntegerNode,
    pub DeviceManifestSchemaMajorVersion: quickSpinIntegerNode,
    pub DeviceManifestSchemaMinorVersion: quickSpinIntegerNode,
    pub DeviceManifestPrimaryURL: quickSpinStringNode,
    pub DeviceManifestSecondaryURL: quickSpinStringNode,
    pub DeviceTLVersionSubMinor: quickSpinIntegerNode,
    pub DeviceGenCPVersionMajor: quickSpinIntegerNode,
    pub DeviceGenCPVersionMinor: quickSpinIntegerNode,
    pub DeviceConnectionSelector: quickSpinIntegerNode,
    pub DeviceConnectionSpeed: quickSpinIntegerNode,
    pub DeviceConnectionStatus: quickSpinEnumerationNode,
    pub DeviceLinkSelector: quickSpinIntegerNode,
    pub DeviceLinkThroughputLimitMode: quickSpinEnumerationNode,
    pub DeviceLinkConnectionCount: quickSpinIntegerNode,
    pub DeviceLinkHeartbeatMode: quickSpinEnumerationNode,
    pub DeviceLinkHeartbeatTimeout: quickSpinFloatNode,
    pub DeviceLinkCommandTimeout: quickSpinFloatNode,
    pub DeviceStreamChannelSelector: quickSpinIntegerNode,
    pub DeviceStreamChannelType: quickSpinEnumerationNode,
    pub DeviceStreamChannelLink: quickSpinIntegerNode,
    pub DeviceStreamChannelEndianness: quickSpinEnumerationNode,
    pub DeviceStreamChannelPacketSize: quickSpinIntegerNode,
    pub DeviceFeaturePersistenceStart: quickSpinCommandNode,
    pub DeviceFeaturePersistenceEnd: quickSpinCommandNode,
    pub DeviceRegistersStreamingStart: quickSpinCommandNode,
    pub DeviceRegistersStreamingEnd: quickSpinCommandNode,
    pub DeviceRegistersCheck: quickSpinCommandNode,
    pub DeviceRegistersValid: quickSpinBooleanNode,
    pub DeviceClockSelector: quickSpinEnumerationNode,
    pub DeviceClockFrequency: quickSpinFloatNode,
    pub DeviceSerialPortSelector: quickSpinEnumerationNode,
    pub DeviceSerialPortBaudRate: quickSpinEnumerationNode,
    pub Timestamp: quickSpinIntegerNode,
    pub SensorTaps: quickSpinEnumerationNode,
    pub SensorDigitizationTaps: quickSpinEnumerationNode,
    pub RegionSelector: quickSpinEnumerationNode,
    pub RegionMode: quickSpinEnumerationNode,
    pub RegionDestination: quickSpinEnumerationNode,
    pub ImageComponentSelector: quickSpinEnumerationNode,
    pub ImageComponentEnable: quickSpinBooleanNode,
    pub LinePitch: quickSpinIntegerNode,
    pub PixelFormatInfoSelector: quickSpinEnumerationNode,
    pub PixelFormatInfoID: quickSpinIntegerNode,
    pub Deinterlacing: quickSpinEnumerationNode,
    pub ImageCompressionRateOption: quickSpinEnumerationNode,
    pub ImageCompressionQuality: quickSpinIntegerNode,
    pub ImageCompressionBitrate: quickSpinFloatNode,
    pub ImageCompressionJPEGFormatOption: quickSpinEnumerationNode,
    pub AcquisitionAbort: quickSpinCommandNode,
    pub AcquisitionArm: quickSpinCommandNode,
    pub AcquisitionStatusSelector: quickSpinEnumerationNode,
    pub AcquisitionStatus: quickSpinBooleanNode,
    pub TriggerDivider: quickSpinIntegerNode,
    pub TriggerMultiplier: quickSpinIntegerNode,
    pub ExposureTimeMode: quickSpinEnumerationNode,
    pub ExposureTimeSelector: quickSpinEnumerationNode,
    pub GainAutoBalance: quickSpinEnumerationNode,
    pub BlackLevelAuto: quickSpinEnumerationNode,
    pub BlackLevelAutoBalance: quickSpinEnumerationNode,
    pub WhiteClipSelector: quickSpinEnumerationNode,
    pub WhiteClip: quickSpinFloatNode,
    pub LUTValueAll: quickSpinRegisterNode,
    pub UserOutputValueAllMask: quickSpinIntegerNode,
    pub CounterReset: quickSpinCommandNode,
    pub TimerSelector: quickSpinEnumerationNode,
    pub TimerDuration: quickSpinFloatNode,
    pub TimerDelay: quickSpinFloatNode,
    pub TimerReset: quickSpinCommandNode,
    pub TimerValue: quickSpinFloatNode,
    pub TimerStatus: quickSpinEnumerationNode,
    pub TimerTriggerSource: quickSpinEnumerationNode,
    pub TimerTriggerActivation: quickSpinEnumerationNode,
    pub EncoderSelector: quickSpinEnumerationNode,
    pub EncoderSourceA: quickSpinEnumerationNode,
    pub EncoderSourceB: quickSpinEnumerationNode,
    pub EncoderMode: quickSpinEnumerationNode,
    pub EncoderDivider: quickSpinIntegerNode,
    pub EncoderOutputMode: quickSpinEnumerationNode,
    pub EncoderStatus: quickSpinEnumerationNode,
    pub EncoderTimeout: quickSpinFloatNode,
    pub EncoderResetSource: quickSpinEnumerationNode,
    pub EncoderResetActivation: quickSpinEnumerationNode,
    pub EncoderReset: quickSpinCommandNode,
    pub EncoderValue: quickSpinIntegerNode,
    pub EncoderValueAtReset: quickSpinIntegerNode,
    pub SoftwareSignalSelector: quickSpinEnumerationNode,
    pub SoftwareSignalPulse: quickSpinCommandNode,
    pub ActionUnconditionalMode: quickSpinEnumerationNode,
    pub ActionDeviceKey: quickSpinIntegerNode,
    pub ActionQueueSize: quickSpinIntegerNode,
    pub ActionSelector: quickSpinIntegerNode,
    pub ActionGroupMask: quickSpinIntegerNode,
    pub ActionGroupKey: quickSpinIntegerNode,
    pub EventAcquisitionTrigger: quickSpinIntegerNode,
    pub EventAcquisitionTriggerTimestamp: quickSpinIntegerNode,
    pub EventAcquisitionTriggerFrameID: quickSpinIntegerNode,
    pub EventAcquisitionStart: quickSpinIntegerNode,
    pub EventAcquisitionStartTimestamp: quickSpinIntegerNode,
    pub EventAcquisitionStartFrameID: quickSpinIntegerNode,
    pub EventAcquisitionEnd: quickSpinIntegerNode,
    pub EventAcquisitionEndTimestamp: quickSpinIntegerNode,
    pub EventAcquisitionEndFrameID: quickSpinIntegerNode,
    pub EventAcquisitionTransferStart: quickSpinIntegerNode,
    pub EventAcquisitionTransferStartTimestamp: quickSpinIntegerNode,
    pub EventAcquisitionTransferStartFrameID: quickSpinIntegerNode,
    pub EventAcquisitionTransferEnd: quickSpinIntegerNode,
    pub EventAcquisitionTransferEndTimestamp: quickSpinIntegerNode,
    pub EventAcquisitionTransferEndFrameID: quickSpinIntegerNode,
    pub EventAcquisitionError: quickSpinIntegerNode,
    pub EventAcquisitionErrorTimestamp: quickSpinIntegerNode,
    pub EventAcquisitionErrorFrameID: quickSpinIntegerNode,
    pub EventFrameTrigger: quickSpinIntegerNode,
    pub EventFrameTriggerTimestamp: quickSpinIntegerNode,
    pub EventFrameTriggerFrameID: quickSpinIntegerNode,
    pub EventFrameStart: quickSpinIntegerNode,
    pub EventFrameStartTimestamp: quickSpinIntegerNode,
    pub EventFrameStartFrameID: quickSpinIntegerNode,
    pub EventFrameEnd: quickSpinIntegerNode,
    pub EventFrameEndTimestamp: quickSpinIntegerNode,
    pub EventFrameEndFrameID: quickSpinIntegerNode,
    pub EventFrameBurstStart: quickSpinIntegerNode,
    pub EventFrameBurstStartTimestamp: quickSpinIntegerNode,
    pub EventFrameBurstStartFrameID: quickSpinIntegerNode,
    pub EventFrameBurstEnd: quickSpinIntegerNode,
    pub EventFrameBurstEndTimestamp: quickSpinIntegerNode,
    pub EventFrameBurstEndFrameID: quickSpinIntegerNode,
    pub EventFrameTransferStart: quickSpinIntegerNode,
    pub EventFrameTransferStartTimestamp: quickSpinIntegerNode,
    pub EventFrameTransferStartFrameID: quickSpinIntegerNode,
    pub EventFrameTransferEnd: quickSpinIntegerNode,
    pub EventFrameTransferEndTimestamp: quickSpinIntegerNode,
    pub EventFrameTransferEndFrameID: quickSpinIntegerNode,
    pub EventExposureStart: quickSpinIntegerNode,
    pub EventExposureStartTimestamp: quickSpinIntegerNode,
    pub EventExposureStartFrameID: quickSpinIntegerNode,
    pub EventStream0TransferStart: quickSpinIntegerNode,
    pub EventStream0TransferStartTimestamp: quickSpinIntegerNode,
    pub EventStream0TransferStartFrameID: quickSpinIntegerNode,
    pub EventStream0TransferEnd: quickSpinIntegerNode,
    pub EventStream0TransferEndTimestamp: quickSpinIntegerNode,
    pub EventStream0TransferEndFrameID: quickSpinIntegerNode,
    pub EventStream0TransferPause: quickSpinIntegerNode,
    pub EventStream0TransferPauseTimestamp: quickSpinIntegerNode,
    pub EventStream0TransferPauseFrameID: quickSpinIntegerNode,
    pub EventStream0TransferResume: quickSpinIntegerNode,
    pub EventStream0TransferResumeTimestamp: quickSpinIntegerNode,
    pub EventStream0TransferResumeFrameID: quickSpinIntegerNode,
    pub EventStream0TransferBlockStart: quickSpinIntegerNode,
    pub EventStream0TransferBlockStartTimestamp: quickSpinIntegerNode,
    pub EventStream0TransferBlockStartFrameID: quickSpinIntegerNode,
    pub EventStream0TransferBlockEnd: quickSpinIntegerNode,
    pub EventStream0TransferBlockEndTimestamp: quickSpinIntegerNode,
    pub EventStream0TransferBlockEndFrameID: quickSpinIntegerNode,
    pub EventStream0TransferBlockTrigger: quickSpinIntegerNode,
    pub EventStream0TransferBlockTriggerTimestamp: quickSpinIntegerNode,
    pub EventStream0TransferBlockTriggerFrameID: quickSpinIntegerNode,
    pub EventStream0TransferBurstStart: quickSpinIntegerNode,
    pub EventStream0TransferBurstStartTimestamp: quickSpinIntegerNode,
    pub EventStream0TransferBurstStartFrameID: quickSpinIntegerNode,
    pub EventStream0TransferBurstEnd: quickSpinIntegerNode,
    pub EventStream0TransferBurstEndTimestamp: quickSpinIntegerNode,
    pub EventStream0TransferBurstEndFrameID: quickSpinIntegerNode,
    pub EventStream0TransferOverflow: quickSpinIntegerNode,
    pub EventStream0TransferOverflowTimestamp: quickSpinIntegerNode,
    pub EventStream0TransferOverflowFrameID: quickSpinIntegerNode,
    pub EventSequencerSetChange: quickSpinIntegerNode,
    pub EventSequencerSetChangeTimestamp: quickSpinIntegerNode,
    pub EventSequencerSetChangeFrameID: quickSpinIntegerNode,
    pub EventCounter0Start: quickSpinIntegerNode,
    pub EventCounter0StartTimestamp: quickSpinIntegerNode,
    pub EventCounter0StartFrameID: quickSpinIntegerNode,
    pub EventCounter1Start: quickSpinIntegerNode,
    pub EventCounter1StartTimestamp: quickSpinIntegerNode,
    pub EventCounter1StartFrameID: quickSpinIntegerNode,
    pub EventCounter0End: quickSpinIntegerNode,
    pub EventCounter0EndTimestamp: quickSpinIntegerNode,
    pub EventCounter0EndFrameID: quickSpinIntegerNode,
    pub EventCounter1End: quickSpinIntegerNode,
    pub EventCounter1EndTimestamp: quickSpinIntegerNode,
    pub EventCounter1EndFrameID: quickSpinIntegerNode,
    pub EventTimer0Start: quickSpinIntegerNode,
    pub EventTimer0StartTimestamp: quickSpinIntegerNode,
    pub EventTimer0StartFrameID: quickSpinIntegerNode,
    pub EventTimer1Start: quickSpinIntegerNode,
    pub EventTimer1StartTimestamp: quickSpinIntegerNode,
    pub EventTimer1StartFrameID: quickSpinIntegerNode,
    pub EventTimer0End: quickSpinIntegerNode,
    pub EventTimer0EndTimestamp: quickSpinIntegerNode,
    pub EventTimer0EndFrameID: quickSpinIntegerNode,
    pub EventTimer1End: quickSpinIntegerNode,
    pub EventTimer1EndTimestamp: quickSpinIntegerNode,
    pub EventTimer1EndFrameID: quickSpinIntegerNode,
    pub EventEncoder0Stopped: quickSpinIntegerNode,
    pub EventEncoder0StoppedTimestamp: quickSpinIntegerNode,
    pub EventEncoder0StoppedFrameID: quickSpinIntegerNode,
    pub EventEncoder1Stopped: quickSpinIntegerNode,
    pub EventEncoder1StoppedTimestamp: quickSpinIntegerNode,
    pub EventEncoder1StoppedFrameID: quickSpinIntegerNode,
    pub EventEncoder0Restarted: quickSpinIntegerNode,
    pub EventEncoder0RestartedTimestamp: quickSpinIntegerNode,
    pub EventEncoder0RestartedFrameID: quickSpinIntegerNode,
    pub EventEncoder1Restarted: quickSpinIntegerNode,
    pub EventEncoder1RestartedTimestamp: quickSpinIntegerNode,
    pub EventEncoder1RestartedFrameID: quickSpinIntegerNode,
    pub EventLine0RisingEdge: quickSpinIntegerNode,
    pub EventLine0RisingEdgeTimestamp: quickSpinIntegerNode,
    pub EventLine0RisingEdgeFrameID: quickSpinIntegerNode,
    pub EventLine1RisingEdge: quickSpinIntegerNode,
    pub EventLine1RisingEdgeTimestamp: quickSpinIntegerNode,
    pub EventLine1RisingEdgeFrameID: quickSpinIntegerNode,
    pub EventLine0FallingEdge: quickSpinIntegerNode,
    pub EventLine0FallingEdgeTimestamp: quickSpinIntegerNode,
    pub EventLine0FallingEdgeFrameID: quickSpinIntegerNode,
    pub EventLine1FallingEdge: quickSpinIntegerNode,
    pub EventLine1FallingEdgeTimestamp: quickSpinIntegerNode,
    pub EventLine1FallingEdgeFrameID: quickSpinIntegerNode,
    pub EventLine0AnyEdge: quickSpinIntegerNode,
    pub EventLine0AnyEdgeTimestamp: quickSpinIntegerNode,
    pub EventLine0AnyEdgeFrameID: quickSpinIntegerNode,
    pub EventLine1AnyEdge: quickSpinIntegerNode,
    pub EventLine1AnyEdgeTimestamp: quickSpinIntegerNode,
    pub EventLine1AnyEdgeFrameID: quickSpinIntegerNode,
    pub EventLinkTrigger0: quickSpinIntegerNode,
    pub EventLinkTrigger0Timestamp: quickSpinIntegerNode,
    pub EventLinkTrigger0FrameID: quickSpinIntegerNode,
    pub EventLinkTrigger1: quickSpinIntegerNode,
    pub EventLinkTrigger1Timestamp: quickSpinIntegerNode,
    pub EventLinkTrigger1FrameID: quickSpinIntegerNode,
    pub EventActionLate: quickSpinIntegerNode,
    pub EventActionLateTimestamp: quickSpinIntegerNode,
    pub EventActionLateFrameID: quickSpinIntegerNode,
    pub EventLinkSpeedChange: quickSpinIntegerNode,
    pub EventLinkSpeedChangeTimestamp: quickSpinIntegerNode,
    pub EventLinkSpeedChangeFrameID: quickSpinIntegerNode,
    pub FileAccessBuffer: quickSpinRegisterNode,
    pub SourceCount: quickSpinIntegerNode,
    pub SourceSelector: quickSpinEnumerationNode,
    pub TransferSelector: quickSpinEnumerationNode,
    pub TransferBurstCount: quickSpinIntegerNode,
    pub TransferAbort: quickSpinCommandNode,
    pub TransferPause: quickSpinCommandNode,
    pub TransferResume: quickSpinCommandNode,
    pub TransferTriggerSelector: quickSpinEnumerationNode,
    pub TransferTriggerMode: quickSpinEnumerationNode,
    pub TransferTriggerSource: quickSpinEnumerationNode,
    pub TransferTriggerActivation: quickSpinEnumerationNode,
    pub TransferStatusSelector: quickSpinEnumerationNode,
    pub TransferStatus: quickSpinBooleanNode,
    pub TransferComponentSelector: quickSpinEnumerationNode,
    pub TransferStreamChannel: quickSpinIntegerNode,
    pub Scan3dDistanceUnit: quickSpinEnumerationNode,
    pub Scan3dCoordinateSystem: quickSpinEnumerationNode,
    pub Scan3dOutputMode: quickSpinEnumerationNode,
    pub Scan3dCoordinateSystemReference: quickSpinEnumerationNode,
    pub Scan3dCoordinateSelector: quickSpinEnumerationNode,
    pub Scan3dCoordinateScale: quickSpinFloatNode,
    pub Scan3dCoordinateOffset: quickSpinFloatNode,
    pub Scan3dInvalidDataFlag: quickSpinBooleanNode,
    pub Scan3dInvalidDataValue: quickSpinFloatNode,
    pub Scan3dAxisMin: quickSpinFloatNode,
    pub Scan3dAxisMax: quickSpinFloatNode,
    pub Scan3dCoordinateTransformSelector: quickSpinEnumerationNode,
    pub Scan3dTransformValue: quickSpinFloatNode,
    pub Scan3dCoordinateReferenceSelector: quickSpinEnumerationNode,
    pub Scan3dCoordinateReferenceValue: quickSpinFloatNode,
    pub ChunkPartSelector: quickSpinIntegerNode,
    pub ChunkImageComponent: quickSpinEnumerationNode,
    pub ChunkPixelDynamicRangeMin: quickSpinIntegerNode,
    pub ChunkPixelDynamicRangeMax: quickSpinIntegerNode,
    pub ChunkTimestampLatchValue: quickSpinIntegerNode,
    pub ChunkLineStatusAll: quickSpinIntegerNode,
    pub ChunkCounterSelector: quickSpinEnumerationNode,
    pub ChunkCounterValue: quickSpinIntegerNode,
    pub ChunkTimerSelector: quickSpinEnumerationNode,
    pub ChunkTimerValue: quickSpinFloatNode,
    pub ChunkEncoderSelector: quickSpinEnumerationNode,
    pub ChunkScanLineSelector: quickSpinIntegerNode,
    pub ChunkEncoderValue: quickSpinIntegerNode,
    pub ChunkEncoderStatus: quickSpinEnumerationNode,
    pub ChunkExposureTimeSelector: quickSpinEnumerationNode,
    pub ChunkLinePitch: quickSpinIntegerNode,
    pub ChunkSourceID: quickSpinEnumerationNode,
    pub ChunkRegionID: quickSpinEnumerationNode,
    pub ChunkTransferBlockID: quickSpinIntegerNode,
    pub ChunkTransferStreamID: quickSpinEnumerationNode,
    pub ChunkTransferQueueCurrentBlockCount: quickSpinIntegerNode,
    pub ChunkStreamChannelID: quickSpinIntegerNode,
    pub ChunkScan3dDistanceUnit: quickSpinEnumerationNode,
    pub ChunkScan3dOutputMode: quickSpinEnumerationNode,
    pub ChunkScan3dCoordinateSystem: quickSpinEnumerationNode,
    pub ChunkScan3dCoordinateSystemReference: quickSpinEnumerationNode,
    pub ChunkScan3dCoordinateSelector: quickSpinEnumerationNode,
    pub ChunkScan3dCoordinateScale: quickSpinFloatNode,
    pub ChunkScan3dCoordinateOffset: quickSpinFloatNode,
    pub ChunkScan3dInvalidDataFlag: quickSpinBooleanNode,
    pub ChunkScan3dInvalidDataValue: quickSpinFloatNode,
    pub ChunkScan3dAxisMin: quickSpinFloatNode,
    pub ChunkScan3dAxisMax: quickSpinFloatNode,
    pub ChunkScan3dCoordinateTransformSelector: quickSpinEnumerationNode,
    pub ChunkScan3dTransformValue: quickSpinFloatNode,
    pub ChunkScan3dCoordinateReferenceSelector: quickSpinEnumerationNode,
    pub ChunkScan3dCoordinateReferenceValue: quickSpinFloatNode,
    pub TestPendingAck: quickSpinIntegerNode,
    pub DeviceTapGeometry: quickSpinEnumerationNode,
    pub GevPhysicalLinkConfiguration: quickSpinEnumerationNode,
    pub GevCurrentPhysicalLinkConfiguration: quickSpinEnumerationNode,
    pub GevActiveLinkCount: quickSpinIntegerNode,
    pub GevPAUSEFrameReception: quickSpinBooleanNode,
    pub GevPAUSEFrameTransmission: quickSpinBooleanNode,
    pub GevIPConfigurationStatus: quickSpinEnumerationNode,
    pub GevDiscoveryAckDelay: quickSpinIntegerNode,
    pub GevGVCPExtendedStatusCodesSelector: quickSpinEnumerationNode,
    pub GevGVCPExtendedStatusCodes: quickSpinBooleanNode,
    pub GevPrimaryApplicationSwitchoverKey: quickSpinIntegerNode,
    pub GevGVSPExtendedIDMode: quickSpinEnumerationNode,
    pub GevPrimaryApplicationSocket: quickSpinIntegerNode,
    pub GevPrimaryApplicationIPAddress: quickSpinIntegerNode,
    pub GevSCCFGPacketResendDestination: quickSpinBooleanNode,
    pub GevSCCFGAllInTransmission: quickSpinBooleanNode,
    pub GevSCZoneCount: quickSpinIntegerNode,
    pub GevSCZoneDirectionAll: quickSpinIntegerNode,
    pub GevSCZoneConfigurationLock: quickSpinBooleanNode,
    pub aPAUSEMACCtrlFramesTransmitted: quickSpinIntegerNode,
    pub aPAUSEMACCtrlFramesReceived: quickSpinIntegerNode,
    pub ClConfiguration: quickSpinEnumerationNode,
    pub ClTimeSlotsCount: quickSpinEnumerationNode,
    pub CxpLinkConfigurationStatus: quickSpinEnumerationNode,
    pub CxpLinkConfigurationPreferred: quickSpinEnumerationNode,
    pub CxpLinkConfiguration: quickSpinEnumerationNode,
    pub CxpConnectionSelector: quickSpinIntegerNode,
    pub CxpConnectionTestMode: quickSpinEnumerationNode,
    pub CxpConnectionTestErrorCount: quickSpinIntegerNode,
    pub CxpConnectionTestPacketCount: quickSpinIntegerNode,
    pub CxpPoCxpAuto: quickSpinCommandNode,
    pub CxpPoCxpTurnOff: quickSpinCommandNode,
    pub CxpPoCxpTripReset: quickSpinCommandNode,
    pub CxpPoCxpStatus: quickSpinEnumerationNode,
    pub ChunkInferenceFrameId: quickSpinIntegerNode,
    pub ChunkInferenceResult: quickSpinIntegerNode,
    pub ChunkInferenceConfidence: quickSpinFloatNode,
    pub ChunkInferenceBoundingBoxResult: quickSpinRegisterNode,
}
#[test]
fn bindgen_test_layout__quickSpin() {
    assert_eq!(
        ::std::mem::size_of::<_quickSpin>(),
        5392usize,
        concat!("Size of: ", stringify!(_quickSpin))
    );
    assert_eq!(
        ::std::mem::align_of::<_quickSpin>(),
        8usize,
        concat!("Alignment of ", stringify!(_quickSpin))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LUTIndex as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LUTIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LUTEnable as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LUTEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LUTValue as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LUTValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LUTSelector as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LUTSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ExposureTime as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ExposureTime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AcquisitionStop as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionStop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AcquisitionResultingFrameRate as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionResultingFrameRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AcquisitionLineRate as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionLineRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AcquisitionStart as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionStart)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TriggerSoftware as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TriggerSoftware)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ExposureMode as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ExposureMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AcquisitionMode as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AcquisitionFrameCount as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionFrameCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TriggerSource as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TriggerSource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TriggerActivation as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TriggerActivation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SensorShutterMode as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SensorShutterMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TriggerDelay as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TriggerDelay)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TriggerMode as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TriggerMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AcquisitionFrameRate as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionFrameRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TriggerOverlap as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TriggerOverlap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TriggerSelector as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TriggerSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AcquisitionFrameRateEnable as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionFrameRateEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ExposureAuto as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ExposureAuto)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AcquisitionBurstFrameCount as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionBurstFrameCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventTest as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTest)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventTestTimestamp as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTestTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventExposureEndFrameID as *const _ as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventExposureEndFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventExposureEnd as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventExposureEnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventExposureEndTimestamp as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventExposureEndTimestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventError as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventError)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventErrorTimestamp as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventErrorTimestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventErrorCode as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventErrorCode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventErrorFrameID as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventErrorFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventSelector as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventSerialReceiveOverflow as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventSerialReceiveOverflow)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventSerialPortReceive as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventSerialPortReceive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventSerialPortReceiveTimestamp as *const _
                as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventSerialPortReceiveTimestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventSerialData as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventSerialData)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventSerialDataLength as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventSerialDataLength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventNotification as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventNotification)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).LogicBlockLUTRowIndex as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LogicBlockLUTRowIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LogicBlockSelector as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LogicBlockSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).LogicBlockLUTInputActivation as *const _ as usize
        },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LogicBlockLUTInputActivation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).LogicBlockLUTInputSelector as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LogicBlockLUTInputSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).LogicBlockLUTInputSource as *const _ as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LogicBlockLUTInputSource)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).LogicBlockLUTOutputValue as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LogicBlockLUTOutputValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).LogicBlockLUTOutputValueAll as *const _ as usize
        },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LogicBlockLUTOutputValueAll)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).LogicBlockLUTSelector as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LogicBlockLUTSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ColorTransformationValue as *const _ as usize
        },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ColorTransformationValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ColorTransformationEnable as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ColorTransformationEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ColorTransformationSelector as *const _ as usize
        },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ColorTransformationSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).RgbTransformLightSource as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(RgbTransformLightSource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Saturation as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Saturation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SaturationEnable as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SaturationEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ColorTransformationValueSelector as *const _
                as usize
        },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ColorTransformationValueSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TimestampLatchValue as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimestampLatchValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TimestampReset as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimestampReset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceUserID as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceUserID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceTemperature as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceTemperature)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).MaxDeviceResetTime as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(MaxDeviceResetTime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceTLVersionMinor as *const _ as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceTLVersionMinor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceSerialNumber as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceSerialNumber)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceVendorName as *const _ as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceVendorName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceRegistersEndianness as *const _ as usize
        },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceRegistersEndianness)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceManufacturerInfo as *const _ as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceManufacturerInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceLinkSpeed as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceLinkSpeed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LinkUptime as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LinkUptime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceEventChannelCount as *const _ as usize
        },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceEventChannelCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TimestampLatch as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimestampLatch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceScanType as *const _ as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceScanType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceReset as *const _ as usize },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceReset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceCharacterSet as *const _ as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceCharacterSet)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceLinkThroughputLimit as *const _ as usize
        },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceLinkThroughputLimit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceFirmwareVersion as *const _ as usize
        },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceFirmwareVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceStreamChannelCount as *const _ as usize
        },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceStreamChannelCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceTLType as *const _ as usize },
        600usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceTLType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceVersion as *const _ as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DevicePowerSupplySelector as *const _ as usize
        },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DevicePowerSupplySelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SensorDescription as *const _ as usize },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SensorDescription)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceModelName as *const _ as usize },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceModelName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceTLVersionMajor as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceTLVersionMajor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceTemperatureSelector as *const _ as usize
        },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceTemperatureSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EnumerationCount as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EnumerationCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).PowerSupplyCurrent as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PowerSupplyCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceID as *const _ as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceUptime as *const _ as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceUptime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceLinkCurrentThroughput as *const _ as usize
        },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceLinkCurrentThroughput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceMaxThroughput as *const _ as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceMaxThroughput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).FactoryReset as *const _ as usize },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FactoryReset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).PowerSupplyVoltage as *const _ as usize },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PowerSupplyVoltage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceIndicatorMode as *const _ as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceIndicatorMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceLinkBandwidthReserve as *const _ as usize
        },
        728usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceLinkBandwidthReserve)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AasRoiOffsetY as *const _ as usize },
        736usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AasRoiOffsetY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AasRoiOffsetX as *const _ as usize },
        744usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AasRoiOffsetX)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureControlPriority as *const _ as usize
        },
        752usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureControlPriority)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).BalanceWhiteAutoLowerLimit as *const _ as usize
        },
        760usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BalanceWhiteAutoLowerLimit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).BalanceWhiteAutoDamping as *const _ as usize
        },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BalanceWhiteAutoDamping)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AasRoiHeight as *const _ as usize },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AasRoiHeight)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureGreyValueUpperLimit as *const _
                as usize
        },
        784usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureGreyValueUpperLimit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureTargetGreyValue as *const _ as usize
        },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureTargetGreyValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureGainLowerLimit as *const _ as usize
        },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureGainLowerLimit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureGreyValueLowerLimit as *const _
                as usize
        },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureGreyValueLowerLimit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureMeteringMode as *const _ as usize
        },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureMeteringMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureExposureTimeUpperLimit as *const _
                as usize
        },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureExposureTimeUpperLimit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureGainUpperLimit as *const _ as usize
        },
        832usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureGainUpperLimit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureControlLoopDamping as *const _
                as usize
        },
        840usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureControlLoopDamping)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureEVCompensation as *const _ as usize
        },
        848usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureEVCompensation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureExposureTimeLowerLimit as *const _
                as usize
        },
        856usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureExposureTimeLowerLimit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).BalanceWhiteAutoProfile as *const _ as usize
        },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BalanceWhiteAutoProfile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoAlgorithmSelector as *const _ as usize
        },
        872usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoAlgorithmSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureTargetGreyValueAuto as *const _
                as usize
        },
        880usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureTargetGreyValueAuto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AasRoiEnable as *const _ as usize },
        888usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AasRoiEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AutoExposureLightingMode as *const _ as usize
        },
        896usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AutoExposureLightingMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AasRoiWidth as *const _ as usize },
        904usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AasRoiWidth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).BalanceWhiteAutoUpperLimit as *const _ as usize
        },
        912usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BalanceWhiteAutoUpperLimit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LinkErrorCount as *const _ as usize },
        920usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LinkErrorCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevCurrentIPConfigurationDHCP as *const _
                as usize
        },
        928usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevCurrentIPConfigurationDHCP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevInterfaceSelector as *const _ as usize },
        936usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevInterfaceSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSCPD as *const _ as usize },
        944usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCPD)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevTimestampTickFrequency as *const _ as usize
        },
        952usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevTimestampTickFrequency)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSCPSPacketSize as *const _ as usize },
        960usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCPSPacketSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevCurrentDefaultGateway as *const _ as usize
        },
        968usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevCurrentDefaultGateway)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevSCCFGUnconditionalStreaming as *const _
                as usize
        },
        976usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCCFGUnconditionalStreaming)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevMCTT as *const _ as usize },
        984usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevMCTT)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSCPSDoNotFragment as *const _ as usize },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCPSDoNotFragment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevCurrentSubnetMask as *const _ as usize },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevCurrentSubnetMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevStreamChannelSelector as *const _ as usize
        },
        1008usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevStreamChannelSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevCurrentIPAddress as *const _ as usize },
        1016usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevCurrentIPAddress)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevMCSP as *const _ as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevMCSP)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevGVCPPendingTimeout as *const _ as usize
        },
        1032usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevGVCPPendingTimeout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevIEEE1588Status as *const _ as usize },
        1040usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevIEEE1588Status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevFirstURL as *const _ as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevFirstURL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevMACAddress as *const _ as usize },
        1056usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevMACAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevPersistentSubnetMask as *const _ as usize
        },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevPersistentSubnetMask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevMCPHostPort as *const _ as usize },
        1072usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevMCPHostPort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSCPHostPort as *const _ as usize },
        1080usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCPHostPort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevGVCPPendingAck as *const _ as usize },
        1088usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevGVCPPendingAck)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSCPInterfaceIndex as *const _ as usize },
        1096usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCPInterfaceIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSupportedOption as *const _ as usize },
        1104usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSupportedOption)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevIEEE1588Mode as *const _ as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevIEEE1588Mode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevCurrentIPConfigurationLLA as *const _ as usize
        },
        1120usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevCurrentIPConfigurationLLA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSCSP as *const _ as usize },
        1128usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCSP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevIEEE1588 as *const _ as usize },
        1136usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevIEEE1588)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevSCCFGExtendedChunkData as *const _ as usize
        },
        1144usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCCFGExtendedChunkData)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevPersistentIPAddress as *const _ as usize
        },
        1152usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevPersistentIPAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevCurrentIPConfigurationPersistentIP as *const _
                as usize
        },
        1160usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevCurrentIPConfigurationPersistentIP)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevIEEE1588ClockAccuracy as *const _ as usize
        },
        1168usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevIEEE1588ClockAccuracy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevHeartbeatTimeout as *const _ as usize },
        1176usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevHeartbeatTimeout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevPersistentDefaultGateway as *const _ as usize
        },
        1184usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevPersistentDefaultGateway)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevCCP as *const _ as usize },
        1192usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevCCP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevMCDA as *const _ as usize },
        1200usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevMCDA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSCDA as *const _ as usize },
        1208usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCDA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSCPDirection as *const _ as usize },
        1216usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCPDirection)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevSCPSFireTestPacket as *const _ as usize
        },
        1224usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCPSFireTestPacket)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSecondURL as *const _ as usize },
        1232usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSecondURL)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevSupportedOptionSelector as *const _ as usize
        },
        1240usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSupportedOptionSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevGVCPHeartbeatDisable as *const _ as usize
        },
        1248usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevGVCPHeartbeatDisable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevMCRC as *const _ as usize },
        1256usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevMCRC)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSCPSBigEndian as *const _ as usize },
        1264usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCPSBigEndian)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevNumberOfInterfaces as *const _ as usize
        },
        1272usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevNumberOfInterfaces)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TLParamsLocked as *const _ as usize },
        1280usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TLParamsLocked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).PayloadSize as *const _ as usize },
        1288usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PayloadSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).PacketResendRequestCount as *const _ as usize
        },
        1296usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PacketResendRequestCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SharpeningEnable as *const _ as usize },
        1304usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SharpeningEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BlackLevelSelector as *const _ as usize },
        1312usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BlackLevelSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GammaEnable as *const _ as usize },
        1320usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GammaEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SharpeningAuto as *const _ as usize },
        1328usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SharpeningAuto)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).BlackLevelClampingEnable as *const _ as usize
        },
        1336usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BlackLevelClampingEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BalanceRatio as *const _ as usize },
        1344usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BalanceRatio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BalanceWhiteAuto as *const _ as usize },
        1352usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BalanceWhiteAuto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SharpeningThreshold as *const _ as usize },
        1360usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SharpeningThreshold)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GainAuto as *const _ as usize },
        1368usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GainAuto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Sharpening as *const _ as usize },
        1376usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Sharpening)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Gain as *const _ as usize },
        1384usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Gain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BalanceRatioSelector as *const _ as usize },
        1392usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BalanceRatioSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GainSelector as *const _ as usize },
        1400usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GainSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BlackLevel as *const _ as usize },
        1408usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BlackLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BlackLevelRaw as *const _ as usize },
        1416usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BlackLevelRaw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Gamma as *const _ as usize },
        1424usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Gamma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DefectTableIndex as *const _ as usize },
        1432usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DefectTableIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DefectTableFactoryRestore as *const _ as usize
        },
        1440usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DefectTableFactoryRestore)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DefectTableCoordinateY as *const _ as usize
        },
        1448usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DefectTableCoordinateY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DefectTableSave as *const _ as usize },
        1456usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DefectTableSave)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DefectCorrectionMode as *const _ as usize },
        1464usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DefectCorrectionMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DefectTableCoordinateX as *const _ as usize
        },
        1472usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DefectTableCoordinateX)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DefectTablePixelCount as *const _ as usize
        },
        1480usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DefectTablePixelCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DefectCorrectStaticEnable as *const _ as usize
        },
        1488usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DefectCorrectStaticEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DefectTableApply as *const _ as usize },
        1496usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DefectTableApply)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).UserSetFeatureEnable as *const _ as usize },
        1504usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(UserSetFeatureEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).UserSetSave as *const _ as usize },
        1512usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(UserSetSave)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).UserSetSelector as *const _ as usize },
        1520usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(UserSetSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).UserSetLoad as *const _ as usize },
        1528usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(UserSetLoad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).UserSetDefault as *const _ as usize },
        1536usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(UserSetDefault)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SerialPortBaudRate as *const _ as usize },
        1544usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialPortBaudRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SerialPortDataBits as *const _ as usize },
        1552usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialPortDataBits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SerialPortParity as *const _ as usize },
        1560usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialPortParity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SerialTransmitQueueMaxCharacterCount as *const _
                as usize
        },
        1568usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialTransmitQueueMaxCharacterCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SerialReceiveQueueCurrentCharacterCount
                as *const _ as usize
        },
        1576usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialReceiveQueueCurrentCharacterCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SerialPortSelector as *const _ as usize },
        1584usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialPortSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SerialPortStopBits as *const _ as usize },
        1592usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialPortStopBits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SerialReceiveQueueClear as *const _ as usize
        },
        1600usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialReceiveQueueClear)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SerialReceiveFramingErrorCount as *const _
                as usize
        },
        1608usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialReceiveFramingErrorCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SerialTransmitQueueCurrentCharacterCount
                as *const _ as usize
        },
        1616usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialTransmitQueueCurrentCharacterCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SerialReceiveParityErrorCount as *const _
                as usize
        },
        1624usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialReceiveParityErrorCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SerialPortSource as *const _ as usize },
        1632usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialPortSource)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SerialReceiveQueueMaxCharacterCount as *const _
                as usize
        },
        1640usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SerialReceiveQueueMaxCharacterCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SequencerSetStart as *const _ as usize },
        1648usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerSetStart)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SequencerMode as *const _ as usize },
        1656usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SequencerConfigurationValid as *const _ as usize
        },
        1664usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerConfigurationValid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SequencerSetValid as *const _ as usize },
        1672usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerSetValid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SequencerSetSelector as *const _ as usize },
        1680usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerSetSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SequencerTriggerActivation as *const _ as usize
        },
        1688usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerTriggerActivation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SequencerConfigurationMode as *const _ as usize
        },
        1696usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerConfigurationMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SequencerSetSave as *const _ as usize },
        1704usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerSetSave)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SequencerTriggerSource as *const _ as usize
        },
        1712usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerTriggerSource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SequencerSetActive as *const _ as usize },
        1720usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerSetActive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SequencerSetNext as *const _ as usize },
        1728usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerSetNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SequencerSetLoad as *const _ as usize },
        1736usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerSetLoad)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SequencerPathSelector as *const _ as usize
        },
        1744usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerPathSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SequencerFeatureEnable as *const _ as usize
        },
        1752usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SequencerFeatureEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferBlockCount as *const _ as usize },
        1760usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferBlockCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferStart as *const _ as usize },
        1768usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TransferQueueMaxBlockCount as *const _ as usize
        },
        1776usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferQueueMaxBlockCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TransferQueueCurrentBlockCount as *const _
                as usize
        },
        1784usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferQueueCurrentBlockCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferQueueMode as *const _ as usize },
        1792usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferQueueMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TransferOperationMode as *const _ as usize
        },
        1800usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferOperationMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferStop as *const _ as usize },
        1808usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferStop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TransferQueueOverflowCount as *const _ as usize
        },
        1816usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferQueueOverflowCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferControlMode as *const _ as usize },
        1824usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferControlMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkBlackLevel as *const _ as usize },
        1832usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkBlackLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkFrameID as *const _ as usize },
        1840usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkSerialData as *const _ as usize },
        1848usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkSerialData)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkExposureTime as *const _ as usize },
        1856usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkExposureTime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkCompressionMode as *const _ as usize },
        1864usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkCompressionMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkCompressionRatio as *const _ as usize
        },
        1872usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkCompressionRatio)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkSerialReceiveOverflow as *const _ as usize
        },
        1880usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkSerialReceiveOverflow)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkTimestamp as *const _ as usize },
        1888usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkTimestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkModeActive as *const _ as usize },
        1896usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkModeActive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkExposureEndLineStatusAll as *const _
                as usize
        },
        1904usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkExposureEndLineStatusAll)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkGainSelector as *const _ as usize },
        1912usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkGainSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkSelector as *const _ as usize },
        1920usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkBlackLevelSelector as *const _ as usize
        },
        1928usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkBlackLevelSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkWidth as *const _ as usize },
        1936usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkWidth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkImage as *const _ as usize },
        1944usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkImage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkHeight as *const _ as usize },
        1952usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkHeight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkPixelFormat as *const _ as usize },
        1960usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkPixelFormat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkGain as *const _ as usize },
        1968usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkGain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkSequencerSetActive as *const _ as usize
        },
        1976usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkSequencerSetActive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkCRC as *const _ as usize },
        1984usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkCRC)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkOffsetX as *const _ as usize },
        1992usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkOffsetX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkOffsetY as *const _ as usize },
        2000usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkOffsetY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkEnable as *const _ as usize },
        2008usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkSerialDataLength as *const _ as usize
        },
        2016usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkSerialDataLength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).FileAccessOffset as *const _ as usize },
        2024usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FileAccessOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).FileAccessLength as *const _ as usize },
        2032usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FileAccessLength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).FileOperationStatus as *const _ as usize },
        2040usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FileOperationStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).FileOperationExecute as *const _ as usize },
        2048usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FileOperationExecute)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).FileOpenMode as *const _ as usize },
        2056usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FileOpenMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).FileOperationResult as *const _ as usize },
        2064usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FileOperationResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).FileOperationSelector as *const _ as usize
        },
        2072usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FileOperationSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).FileSelector as *const _ as usize },
        2080usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FileSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).FileSize as *const _ as usize },
        2088usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FileSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BinningSelector as *const _ as usize },
        2096usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BinningSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).PixelDynamicRangeMin as *const _ as usize },
        2104usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PixelDynamicRangeMin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).PixelDynamicRangeMax as *const _ as usize },
        2112usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PixelDynamicRangeMax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).OffsetY as *const _ as usize },
        2120usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(OffsetY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BinningHorizontal as *const _ as usize },
        2128usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BinningHorizontal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Width as *const _ as usize },
        2136usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TestPatternGeneratorSelector as *const _ as usize
        },
        2144usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TestPatternGeneratorSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CompressionRatio as *const _ as usize },
        2152usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CompressionRatio)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).CompressionSaturationPriority as *const _
                as usize
        },
        2160usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CompressionSaturationPriority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ReverseX as *const _ as usize },
        2168usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ReverseX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ReverseY as *const _ as usize },
        2176usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ReverseY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TestPattern as *const _ as usize },
        2184usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TestPattern)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).PixelColorFilter as *const _ as usize },
        2192usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PixelColorFilter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).WidthMax as *const _ as usize },
        2200usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(WidthMax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AdcBitDepth as *const _ as usize },
        2208usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AdcBitDepth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BinningVertical as *const _ as usize },
        2216usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BinningVertical)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DecimationHorizontalMode as *const _ as usize
        },
        2224usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DecimationHorizontalMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BinningVerticalMode as *const _ as usize },
        2232usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BinningVerticalMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).OffsetX as *const _ as usize },
        2240usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(OffsetX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).HeightMax as *const _ as usize },
        2248usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(HeightMax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DecimationHorizontal as *const _ as usize },
        2256usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DecimationHorizontal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).PixelSize as *const _ as usize },
        2264usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PixelSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SensorHeight as *const _ as usize },
        2272usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SensorHeight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DecimationSelector as *const _ as usize },
        2280usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DecimationSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).IspEnable as *const _ as usize },
        2288usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(IspEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AdaptiveCompressionEnable as *const _ as usize
        },
        2296usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AdaptiveCompressionEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ImageCompressionMode as *const _ as usize },
        2304usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ImageCompressionMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DecimationVertical as *const _ as usize },
        2312usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DecimationVertical)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Height as *const _ as usize },
        2320usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).BinningHorizontalMode as *const _ as usize
        },
        2328usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BinningHorizontalMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).PixelFormat as *const _ as usize },
        2336usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PixelFormat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SensorWidth as *const _ as usize },
        2344usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SensorWidth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DecimationVerticalMode as *const _ as usize
        },
        2352usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DecimationVerticalMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TestEventGenerate as *const _ as usize },
        2360usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TestEventGenerate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TriggerEventTest as *const _ as usize },
        2368usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TriggerEventTest)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GuiXmlManifestAddress as *const _ as usize
        },
        2376usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GuiXmlManifestAddress)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Test0001 as *const _ as usize },
        2384usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Test0001)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).V3_3Enable as *const _ as usize },
        2392usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(V3_3Enable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LineMode as *const _ as usize },
        2400usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LineMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LineSource as *const _ as usize },
        2408usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LineSource)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).LineInputFilterSelector as *const _ as usize
        },
        2416usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LineInputFilterSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).UserOutputValue as *const _ as usize },
        2424usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(UserOutputValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).UserOutputValueAll as *const _ as usize },
        2432usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(UserOutputValueAll)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).UserOutputSelector as *const _ as usize },
        2440usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(UserOutputSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LineStatus as *const _ as usize },
        2448usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LineStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LineFormat as *const _ as usize },
        2456usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LineFormat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LineStatusAll as *const _ as usize },
        2464usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LineStatusAll)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LineSelector as *const _ as usize },
        2472usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LineSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ExposureActiveMode as *const _ as usize },
        2480usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ExposureActiveMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LineInverter as *const _ as usize },
        2488usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LineInverter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LineFilterWidth as *const _ as usize },
        2496usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LineFilterWidth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).CounterTriggerActivation as *const _ as usize
        },
        2504usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterTriggerActivation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CounterValue as *const _ as usize },
        2512usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CounterSelector as *const _ as usize },
        2520usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CounterValueAtReset as *const _ as usize },
        2528usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterValueAtReset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CounterStatus as *const _ as usize },
        2536usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CounterTriggerSource as *const _ as usize },
        2544usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterTriggerSource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CounterDelay as *const _ as usize },
        2552usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterDelay)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CounterResetSource as *const _ as usize },
        2560usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterResetSource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CounterEventSource as *const _ as usize },
        2568usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterEventSource)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).CounterEventActivation as *const _ as usize
        },
        2576usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterEventActivation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CounterDuration as *const _ as usize },
        2584usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterDuration)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).CounterResetActivation as *const _ as usize
        },
        2592usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterResetActivation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceType as *const _ as usize },
        2600usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceFamilyName as *const _ as usize },
        2608usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceFamilyName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceSFNCVersionMajor as *const _ as usize
        },
        2616usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceSFNCVersionMajor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceSFNCVersionMinor as *const _ as usize
        },
        2624usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceSFNCVersionMinor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceSFNCVersionSubMinor as *const _ as usize
        },
        2632usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceSFNCVersionSubMinor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceManifestEntrySelector as *const _ as usize
        },
        2640usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceManifestEntrySelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceManifestXMLMajorVersion as *const _
                as usize
        },
        2648usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceManifestXMLMajorVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceManifestXMLMinorVersion as *const _
                as usize
        },
        2656usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceManifestXMLMinorVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceManifestXMLSubMinorVersion as *const _
                as usize
        },
        2664usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceManifestXMLSubMinorVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceManifestSchemaMajorVersion as *const _
                as usize
        },
        2672usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceManifestSchemaMajorVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceManifestSchemaMinorVersion as *const _
                as usize
        },
        2680usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceManifestSchemaMinorVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceManifestPrimaryURL as *const _ as usize
        },
        2688usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceManifestPrimaryURL)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceManifestSecondaryURL as *const _ as usize
        },
        2696usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceManifestSecondaryURL)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceTLVersionSubMinor as *const _ as usize
        },
        2704usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceTLVersionSubMinor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceGenCPVersionMajor as *const _ as usize
        },
        2712usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceGenCPVersionMajor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceGenCPVersionMinor as *const _ as usize
        },
        2720usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceGenCPVersionMinor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceConnectionSelector as *const _ as usize
        },
        2728usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceConnectionSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceConnectionSpeed as *const _ as usize
        },
        2736usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceConnectionSpeed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceConnectionStatus as *const _ as usize
        },
        2744usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceConnectionStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceLinkSelector as *const _ as usize },
        2752usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceLinkSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceLinkThroughputLimitMode as *const _
                as usize
        },
        2760usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceLinkThroughputLimitMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceLinkConnectionCount as *const _ as usize
        },
        2768usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceLinkConnectionCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceLinkHeartbeatMode as *const _ as usize
        },
        2776usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceLinkHeartbeatMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceLinkHeartbeatTimeout as *const _ as usize
        },
        2784usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceLinkHeartbeatTimeout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceLinkCommandTimeout as *const _ as usize
        },
        2792usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceLinkCommandTimeout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceStreamChannelSelector as *const _ as usize
        },
        2800usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceStreamChannelSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceStreamChannelType as *const _ as usize
        },
        2808usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceStreamChannelType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceStreamChannelLink as *const _ as usize
        },
        2816usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceStreamChannelLink)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceStreamChannelEndianness as *const _
                as usize
        },
        2824usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceStreamChannelEndianness)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceStreamChannelPacketSize as *const _
                as usize
        },
        2832usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceStreamChannelPacketSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceFeaturePersistenceStart as *const _
                as usize
        },
        2840usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceFeaturePersistenceStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceFeaturePersistenceEnd as *const _ as usize
        },
        2848usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceFeaturePersistenceEnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceRegistersStreamingStart as *const _
                as usize
        },
        2856usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceRegistersStreamingStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceRegistersStreamingEnd as *const _ as usize
        },
        2864usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceRegistersStreamingEnd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceRegistersCheck as *const _ as usize },
        2872usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceRegistersCheck)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceRegistersValid as *const _ as usize },
        2880usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceRegistersValid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceClockSelector as *const _ as usize },
        2888usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceClockSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceClockFrequency as *const _ as usize },
        2896usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceClockFrequency)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceSerialPortSelector as *const _ as usize
        },
        2904usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceSerialPortSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).DeviceSerialPortBaudRate as *const _ as usize
        },
        2912usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceSerialPortBaudRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Timestamp as *const _ as usize },
        2920usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SensorTaps as *const _ as usize },
        2928usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SensorTaps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SensorDigitizationTaps as *const _ as usize
        },
        2936usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SensorDigitizationTaps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).RegionSelector as *const _ as usize },
        2944usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(RegionSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).RegionMode as *const _ as usize },
        2952usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(RegionMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).RegionDestination as *const _ as usize },
        2960usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(RegionDestination)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ImageComponentSelector as *const _ as usize
        },
        2968usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ImageComponentSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ImageComponentEnable as *const _ as usize },
        2976usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ImageComponentEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LinePitch as *const _ as usize },
        2984usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LinePitch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).PixelFormatInfoSelector as *const _ as usize
        },
        2992usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PixelFormatInfoSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).PixelFormatInfoID as *const _ as usize },
        3000usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(PixelFormatInfoID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Deinterlacing as *const _ as usize },
        3008usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Deinterlacing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ImageCompressionRateOption as *const _ as usize
        },
        3016usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ImageCompressionRateOption)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ImageCompressionQuality as *const _ as usize
        },
        3024usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ImageCompressionQuality)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ImageCompressionBitrate as *const _ as usize
        },
        3032usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ImageCompressionBitrate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ImageCompressionJPEGFormatOption as *const _
                as usize
        },
        3040usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ImageCompressionJPEGFormatOption)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AcquisitionAbort as *const _ as usize },
        3048usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionAbort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AcquisitionArm as *const _ as usize },
        3056usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionArm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).AcquisitionStatusSelector as *const _ as usize
        },
        3064usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionStatusSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).AcquisitionStatus as *const _ as usize },
        3072usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(AcquisitionStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TriggerDivider as *const _ as usize },
        3080usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TriggerDivider)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TriggerMultiplier as *const _ as usize },
        3088usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TriggerMultiplier)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ExposureTimeMode as *const _ as usize },
        3096usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ExposureTimeMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ExposureTimeSelector as *const _ as usize },
        3104usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ExposureTimeSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GainAutoBalance as *const _ as usize },
        3112usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GainAutoBalance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).BlackLevelAuto as *const _ as usize },
        3120usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BlackLevelAuto)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).BlackLevelAutoBalance as *const _ as usize
        },
        3128usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(BlackLevelAutoBalance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).WhiteClipSelector as *const _ as usize },
        3136usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(WhiteClipSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).WhiteClip as *const _ as usize },
        3144usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(WhiteClip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).LUTValueAll as *const _ as usize },
        3152usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(LUTValueAll)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).UserOutputValueAllMask as *const _ as usize
        },
        3160usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(UserOutputValueAllMask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CounterReset as *const _ as usize },
        3168usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CounterReset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TimerSelector as *const _ as usize },
        3176usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimerSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TimerDuration as *const _ as usize },
        3184usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimerDuration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TimerDelay as *const _ as usize },
        3192usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimerDelay)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TimerReset as *const _ as usize },
        3200usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimerReset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TimerValue as *const _ as usize },
        3208usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimerValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TimerStatus as *const _ as usize },
        3216usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimerStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TimerTriggerSource as *const _ as usize },
        3224usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimerTriggerSource)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TimerTriggerActivation as *const _ as usize
        },
        3232usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TimerTriggerActivation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderSelector as *const _ as usize },
        3240usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderSourceA as *const _ as usize },
        3248usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderSourceA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderSourceB as *const _ as usize },
        3256usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderSourceB)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderMode as *const _ as usize },
        3264usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderDivider as *const _ as usize },
        3272usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderDivider)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderOutputMode as *const _ as usize },
        3280usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderOutputMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderStatus as *const _ as usize },
        3288usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderTimeout as *const _ as usize },
        3296usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderTimeout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderResetSource as *const _ as usize },
        3304usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderResetSource)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EncoderResetActivation as *const _ as usize
        },
        3312usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderResetActivation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderReset as *const _ as usize },
        3320usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderReset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderValue as *const _ as usize },
        3328usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EncoderValueAtReset as *const _ as usize },
        3336usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EncoderValueAtReset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).SoftwareSignalSelector as *const _ as usize
        },
        3344usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SoftwareSignalSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SoftwareSignalPulse as *const _ as usize },
        3352usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SoftwareSignalPulse)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ActionUnconditionalMode as *const _ as usize
        },
        3360usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ActionUnconditionalMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ActionDeviceKey as *const _ as usize },
        3368usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ActionDeviceKey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ActionQueueSize as *const _ as usize },
        3376usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ActionQueueSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ActionSelector as *const _ as usize },
        3384usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ActionSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ActionGroupMask as *const _ as usize },
        3392usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ActionGroupMask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ActionGroupKey as *const _ as usize },
        3400usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ActionGroupKey)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionTrigger as *const _ as usize
        },
        3408usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionTrigger)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionTriggerTimestamp as *const _
                as usize
        },
        3416usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionTriggerTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionTriggerFrameID as *const _
                as usize
        },
        3424usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionTriggerFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionStart as *const _ as usize
        },
        3432usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionStartTimestamp as *const _
                as usize
        },
        3440usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionStartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionStartFrameID as *const _ as usize
        },
        3448usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionStartFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionEnd as *const _ as usize },
        3456usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionEnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionEndTimestamp as *const _ as usize
        },
        3464usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionEndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionEndFrameID as *const _ as usize
        },
        3472usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionEndFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionTransferStart as *const _
                as usize
        },
        3480usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionTransferStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionTransferStartTimestamp
                as *const _ as usize
        },
        3488usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionTransferStartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionTransferStartFrameID as *const _
                as usize
        },
        3496usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionTransferStartFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionTransferEnd as *const _ as usize
        },
        3504usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionTransferEnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionTransferEndTimestamp as *const _
                as usize
        },
        3512usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionTransferEndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionTransferEndFrameID as *const _
                as usize
        },
        3520usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionTransferEndFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionError as *const _ as usize
        },
        3528usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionError)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionErrorTimestamp as *const _
                as usize
        },
        3536usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionErrorTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventAcquisitionErrorFrameID as *const _ as usize
        },
        3544usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventAcquisitionErrorFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventFrameTrigger as *const _ as usize },
        3552usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameTrigger)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameTriggerTimestamp as *const _ as usize
        },
        3560usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameTriggerTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameTriggerFrameID as *const _ as usize
        },
        3568usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameTriggerFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventFrameStart as *const _ as usize },
        3576usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameStartTimestamp as *const _ as usize
        },
        3584usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameStartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameStartFrameID as *const _ as usize
        },
        3592usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameStartFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventFrameEnd as *const _ as usize },
        3600usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameEnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameEndTimestamp as *const _ as usize
        },
        3608usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameEndTimestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventFrameEndFrameID as *const _ as usize },
        3616usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameEndFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventFrameBurstStart as *const _ as usize },
        3624usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameBurstStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameBurstStartTimestamp as *const _
                as usize
        },
        3632usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameBurstStartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameBurstStartFrameID as *const _ as usize
        },
        3640usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameBurstStartFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventFrameBurstEnd as *const _ as usize },
        3648usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameBurstEnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameBurstEndTimestamp as *const _ as usize
        },
        3656usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameBurstEndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameBurstEndFrameID as *const _ as usize
        },
        3664usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameBurstEndFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameTransferStart as *const _ as usize
        },
        3672usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameTransferStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameTransferStartTimestamp as *const _
                as usize
        },
        3680usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameTransferStartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameTransferStartFrameID as *const _
                as usize
        },
        3688usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameTransferStartFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameTransferEnd as *const _ as usize
        },
        3696usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameTransferEnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameTransferEndTimestamp as *const _
                as usize
        },
        3704usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameTransferEndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventFrameTransferEndFrameID as *const _ as usize
        },
        3712usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventFrameTransferEndFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventExposureStart as *const _ as usize },
        3720usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventExposureStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventExposureStartTimestamp as *const _ as usize
        },
        3728usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventExposureStartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventExposureStartFrameID as *const _ as usize
        },
        3736usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventExposureStartFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferStart as *const _ as usize
        },
        3744usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferStartTimestamp as *const _
                as usize
        },
        3752usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferStartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferStartFrameID as *const _
                as usize
        },
        3760usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferStartFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferEnd as *const _ as usize
        },
        3768usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferEnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferEndTimestamp as *const _
                as usize
        },
        3776usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferEndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferEndFrameID as *const _
                as usize
        },
        3784usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferEndFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferPause as *const _ as usize
        },
        3792usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferPause)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferPauseTimestamp as *const _
                as usize
        },
        3800usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferPauseTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferPauseFrameID as *const _
                as usize
        },
        3808usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferPauseFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferResume as *const _ as usize
        },
        3816usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferResume)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferResumeTimestamp as *const _
                as usize
        },
        3824usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferResumeTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferResumeFrameID as *const _
                as usize
        },
        3832usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferResumeFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBlockStart as *const _
                as usize
        },
        3840usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBlockStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBlockStartTimestamp
                as *const _ as usize
        },
        3848usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBlockStartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBlockStartFrameID as *const _
                as usize
        },
        3856usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBlockStartFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBlockEnd as *const _ as usize
        },
        3864usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBlockEnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBlockEndTimestamp as *const _
                as usize
        },
        3872usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBlockEndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBlockEndFrameID as *const _
                as usize
        },
        3880usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBlockEndFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBlockTrigger as *const _
                as usize
        },
        3888usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBlockTrigger)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBlockTriggerTimestamp
                as *const _ as usize
        },
        3896usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBlockTriggerTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBlockTriggerFrameID
                as *const _ as usize
        },
        3904usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBlockTriggerFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBurstStart as *const _
                as usize
        },
        3912usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBurstStart)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBurstStartTimestamp
                as *const _ as usize
        },
        3920usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBurstStartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBurstStartFrameID as *const _
                as usize
        },
        3928usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBurstStartFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBurstEnd as *const _ as usize
        },
        3936usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBurstEnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBurstEndTimestamp as *const _
                as usize
        },
        3944usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBurstEndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferBurstEndFrameID as *const _
                as usize
        },
        3952usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferBurstEndFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferOverflow as *const _ as usize
        },
        3960usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferOverflow)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferOverflowTimestamp as *const _
                as usize
        },
        3968usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferOverflowTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventStream0TransferOverflowFrameID as *const _
                as usize
        },
        3976usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventStream0TransferOverflowFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventSequencerSetChange as *const _ as usize
        },
        3984usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventSequencerSetChange)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventSequencerSetChangeTimestamp as *const _
                as usize
        },
        3992usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventSequencerSetChangeTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventSequencerSetChangeFrameID as *const _
                as usize
        },
        4000usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventSequencerSetChangeFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventCounter0Start as *const _ as usize },
        4008usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter0Start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventCounter0StartTimestamp as *const _ as usize
        },
        4016usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter0StartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventCounter0StartFrameID as *const _ as usize
        },
        4024usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter0StartFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventCounter1Start as *const _ as usize },
        4032usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter1Start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventCounter1StartTimestamp as *const _ as usize
        },
        4040usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter1StartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventCounter1StartFrameID as *const _ as usize
        },
        4048usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter1StartFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventCounter0End as *const _ as usize },
        4056usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter0End)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventCounter0EndTimestamp as *const _ as usize
        },
        4064usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter0EndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventCounter0EndFrameID as *const _ as usize
        },
        4072usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter0EndFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventCounter1End as *const _ as usize },
        4080usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter1End)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventCounter1EndTimestamp as *const _ as usize
        },
        4088usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter1EndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventCounter1EndFrameID as *const _ as usize
        },
        4096usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventCounter1EndFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventTimer0Start as *const _ as usize },
        4104usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer0Start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventTimer0StartTimestamp as *const _ as usize
        },
        4112usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer0StartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventTimer0StartFrameID as *const _ as usize
        },
        4120usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer0StartFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventTimer1Start as *const _ as usize },
        4128usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer1Start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventTimer1StartTimestamp as *const _ as usize
        },
        4136usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer1StartTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventTimer1StartFrameID as *const _ as usize
        },
        4144usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer1StartFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventTimer0End as *const _ as usize },
        4152usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer0End)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventTimer0EndTimestamp as *const _ as usize
        },
        4160usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer0EndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventTimer0EndFrameID as *const _ as usize
        },
        4168usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer0EndFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventTimer1End as *const _ as usize },
        4176usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer1End)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventTimer1EndTimestamp as *const _ as usize
        },
        4184usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer1EndTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventTimer1EndFrameID as *const _ as usize
        },
        4192usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventTimer1EndFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventEncoder0Stopped as *const _ as usize },
        4200usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder0Stopped)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventEncoder0StoppedTimestamp as *const _
                as usize
        },
        4208usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder0StoppedTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventEncoder0StoppedFrameID as *const _ as usize
        },
        4216usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder0StoppedFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventEncoder1Stopped as *const _ as usize },
        4224usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder1Stopped)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventEncoder1StoppedTimestamp as *const _
                as usize
        },
        4232usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder1StoppedTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventEncoder1StoppedFrameID as *const _ as usize
        },
        4240usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder1StoppedFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventEncoder0Restarted as *const _ as usize
        },
        4248usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder0Restarted)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventEncoder0RestartedTimestamp as *const _
                as usize
        },
        4256usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder0RestartedTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventEncoder0RestartedFrameID as *const _
                as usize
        },
        4264usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder0RestartedFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventEncoder1Restarted as *const _ as usize
        },
        4272usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder1Restarted)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventEncoder1RestartedTimestamp as *const _
                as usize
        },
        4280usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder1RestartedTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventEncoder1RestartedFrameID as *const _
                as usize
        },
        4288usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventEncoder1RestartedFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventLine0RisingEdge as *const _ as usize },
        4296usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine0RisingEdge)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine0RisingEdgeTimestamp as *const _
                as usize
        },
        4304usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine0RisingEdgeTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine0RisingEdgeFrameID as *const _ as usize
        },
        4312usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine0RisingEdgeFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventLine1RisingEdge as *const _ as usize },
        4320usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine1RisingEdge)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine1RisingEdgeTimestamp as *const _
                as usize
        },
        4328usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine1RisingEdgeTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine1RisingEdgeFrameID as *const _ as usize
        },
        4336usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine1RisingEdgeFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine0FallingEdge as *const _ as usize
        },
        4344usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine0FallingEdge)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine0FallingEdgeTimestamp as *const _
                as usize
        },
        4352usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine0FallingEdgeTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine0FallingEdgeFrameID as *const _ as usize
        },
        4360usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine0FallingEdgeFrameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine1FallingEdge as *const _ as usize
        },
        4368usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine1FallingEdge)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine1FallingEdgeTimestamp as *const _
                as usize
        },
        4376usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine1FallingEdgeTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine1FallingEdgeFrameID as *const _ as usize
        },
        4384usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine1FallingEdgeFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventLine0AnyEdge as *const _ as usize },
        4392usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine0AnyEdge)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine0AnyEdgeTimestamp as *const _ as usize
        },
        4400usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine0AnyEdgeTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine0AnyEdgeFrameID as *const _ as usize
        },
        4408usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine0AnyEdgeFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventLine1AnyEdge as *const _ as usize },
        4416usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine1AnyEdge)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine1AnyEdgeTimestamp as *const _ as usize
        },
        4424usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine1AnyEdgeTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLine1AnyEdgeFrameID as *const _ as usize
        },
        4432usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLine1AnyEdgeFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventLinkTrigger0 as *const _ as usize },
        4440usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLinkTrigger0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLinkTrigger0Timestamp as *const _ as usize
        },
        4448usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLinkTrigger0Timestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLinkTrigger0FrameID as *const _ as usize
        },
        4456usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLinkTrigger0FrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventLinkTrigger1 as *const _ as usize },
        4464usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLinkTrigger1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLinkTrigger1Timestamp as *const _ as usize
        },
        4472usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLinkTrigger1Timestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLinkTrigger1FrameID as *const _ as usize
        },
        4480usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLinkTrigger1FrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventActionLate as *const _ as usize },
        4488usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventActionLate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventActionLateTimestamp as *const _ as usize
        },
        4496usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventActionLateTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventActionLateFrameID as *const _ as usize
        },
        4504usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventActionLateFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).EventLinkSpeedChange as *const _ as usize },
        4512usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLinkSpeedChange)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLinkSpeedChangeTimestamp as *const _
                as usize
        },
        4520usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLinkSpeedChangeTimestamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).EventLinkSpeedChangeFrameID as *const _ as usize
        },
        4528usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(EventLinkSpeedChangeFrameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).FileAccessBuffer as *const _ as usize },
        4536usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(FileAccessBuffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SourceCount as *const _ as usize },
        4544usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SourceCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).SourceSelector as *const _ as usize },
        4552usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(SourceSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferSelector as *const _ as usize },
        4560usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferBurstCount as *const _ as usize },
        4568usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferBurstCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferAbort as *const _ as usize },
        4576usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferAbort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferPause as *const _ as usize },
        4584usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferPause)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferResume as *const _ as usize },
        4592usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferResume)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TransferTriggerSelector as *const _ as usize
        },
        4600usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferTriggerSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferTriggerMode as *const _ as usize },
        4608usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferTriggerMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TransferTriggerSource as *const _ as usize
        },
        4616usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferTriggerSource)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TransferTriggerActivation as *const _ as usize
        },
        4624usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferTriggerActivation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TransferStatusSelector as *const _ as usize
        },
        4632usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferStatusSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TransferStatus as *const _ as usize },
        4640usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferStatus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TransferComponentSelector as *const _ as usize
        },
        4648usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferComponentSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).TransferStreamChannel as *const _ as usize
        },
        4656usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TransferStreamChannel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Scan3dDistanceUnit as *const _ as usize },
        4664usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dDistanceUnit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).Scan3dCoordinateSystem as *const _ as usize
        },
        4672usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dCoordinateSystem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Scan3dOutputMode as *const _ as usize },
        4680usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dOutputMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).Scan3dCoordinateSystemReference as *const _
                as usize
        },
        4688usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dCoordinateSystemReference)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).Scan3dCoordinateSelector as *const _ as usize
        },
        4696usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dCoordinateSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).Scan3dCoordinateScale as *const _ as usize
        },
        4704usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dCoordinateScale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).Scan3dCoordinateOffset as *const _ as usize
        },
        4712usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dCoordinateOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).Scan3dInvalidDataFlag as *const _ as usize
        },
        4720usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dInvalidDataFlag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).Scan3dInvalidDataValue as *const _ as usize
        },
        4728usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dInvalidDataValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Scan3dAxisMin as *const _ as usize },
        4736usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dAxisMin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Scan3dAxisMax as *const _ as usize },
        4744usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dAxisMax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).Scan3dCoordinateTransformSelector as *const _
                as usize
        },
        4752usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dCoordinateTransformSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).Scan3dTransformValue as *const _ as usize },
        4760usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dTransformValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).Scan3dCoordinateReferenceSelector as *const _
                as usize
        },
        4768usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dCoordinateReferenceSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).Scan3dCoordinateReferenceValue as *const _
                as usize
        },
        4776usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(Scan3dCoordinateReferenceValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkPartSelector as *const _ as usize },
        4784usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkPartSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkImageComponent as *const _ as usize },
        4792usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkImageComponent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkPixelDynamicRangeMin as *const _ as usize
        },
        4800usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkPixelDynamicRangeMin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkPixelDynamicRangeMax as *const _ as usize
        },
        4808usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkPixelDynamicRangeMax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkTimestampLatchValue as *const _ as usize
        },
        4816usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkTimestampLatchValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkLineStatusAll as *const _ as usize },
        4824usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkLineStatusAll)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkCounterSelector as *const _ as usize },
        4832usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkCounterSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkCounterValue as *const _ as usize },
        4840usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkCounterValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkTimerSelector as *const _ as usize },
        4848usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkTimerSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkTimerValue as *const _ as usize },
        4856usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkTimerValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkEncoderSelector as *const _ as usize },
        4864usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkEncoderSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScanLineSelector as *const _ as usize
        },
        4872usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScanLineSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkEncoderValue as *const _ as usize },
        4880usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkEncoderValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkEncoderStatus as *const _ as usize },
        4888usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkEncoderStatus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkExposureTimeSelector as *const _ as usize
        },
        4896usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkExposureTimeSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkLinePitch as *const _ as usize },
        4904usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkLinePitch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkSourceID as *const _ as usize },
        4912usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkSourceID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkRegionID as *const _ as usize },
        4920usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkRegionID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkTransferBlockID as *const _ as usize },
        4928usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkTransferBlockID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkTransferStreamID as *const _ as usize
        },
        4936usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkTransferStreamID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkTransferQueueCurrentBlockCount as *const _
                as usize
        },
        4944usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkTransferQueueCurrentBlockCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkStreamChannelID as *const _ as usize },
        4952usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkStreamChannelID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dDistanceUnit as *const _ as usize
        },
        4960usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dDistanceUnit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dOutputMode as *const _ as usize
        },
        4968usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dOutputMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dCoordinateSystem as *const _ as usize
        },
        4976usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dCoordinateSystem)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dCoordinateSystemReference as *const _
                as usize
        },
        4984usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dCoordinateSystemReference)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dCoordinateSelector as *const _
                as usize
        },
        4992usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dCoordinateSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dCoordinateScale as *const _ as usize
        },
        5000usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dCoordinateScale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dCoordinateOffset as *const _ as usize
        },
        5008usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dCoordinateOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dInvalidDataFlag as *const _ as usize
        },
        5016usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dInvalidDataFlag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dInvalidDataValue as *const _ as usize
        },
        5024usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dInvalidDataValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dAxisMin as *const _ as usize },
        5032usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dAxisMin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dAxisMax as *const _ as usize },
        5040usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dAxisMax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dCoordinateTransformSelector
                as *const _ as usize
        },
        5048usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dCoordinateTransformSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dTransformValue as *const _ as usize
        },
        5056usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dTransformValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dCoordinateReferenceSelector
                as *const _ as usize
        },
        5064usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dCoordinateReferenceSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkScan3dCoordinateReferenceValue as *const _
                as usize
        },
        5072usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkScan3dCoordinateReferenceValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).TestPendingAck as *const _ as usize },
        5080usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(TestPendingAck)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).DeviceTapGeometry as *const _ as usize },
        5088usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(DeviceTapGeometry)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevPhysicalLinkConfiguration as *const _ as usize
        },
        5096usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevPhysicalLinkConfiguration)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevCurrentPhysicalLinkConfiguration as *const _
                as usize
        },
        5104usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevCurrentPhysicalLinkConfiguration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevActiveLinkCount as *const _ as usize },
        5112usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevActiveLinkCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevPAUSEFrameReception as *const _ as usize
        },
        5120usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevPAUSEFrameReception)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevPAUSEFrameTransmission as *const _ as usize
        },
        5128usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevPAUSEFrameTransmission)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevIPConfigurationStatus as *const _ as usize
        },
        5136usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevIPConfigurationStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevDiscoveryAckDelay as *const _ as usize },
        5144usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevDiscoveryAckDelay)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevGVCPExtendedStatusCodesSelector as *const _
                as usize
        },
        5152usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevGVCPExtendedStatusCodesSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevGVCPExtendedStatusCodes as *const _ as usize
        },
        5160usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevGVCPExtendedStatusCodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevPrimaryApplicationSwitchoverKey as *const _
                as usize
        },
        5168usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevPrimaryApplicationSwitchoverKey)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevGVSPExtendedIDMode as *const _ as usize
        },
        5176usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevGVSPExtendedIDMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevPrimaryApplicationSocket as *const _ as usize
        },
        5184usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevPrimaryApplicationSocket)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevPrimaryApplicationIPAddress as *const _
                as usize
        },
        5192usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevPrimaryApplicationIPAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevSCCFGPacketResendDestination as *const _
                as usize
        },
        5200usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCCFGPacketResendDestination)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevSCCFGAllInTransmission as *const _ as usize
        },
        5208usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCCFGAllInTransmission)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).GevSCZoneCount as *const _ as usize },
        5216usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCZoneCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevSCZoneDirectionAll as *const _ as usize
        },
        5224usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCZoneDirectionAll)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).GevSCZoneConfigurationLock as *const _ as usize
        },
        5232usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(GevSCZoneConfigurationLock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).aPAUSEMACCtrlFramesTransmitted as *const _
                as usize
        },
        5240usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(aPAUSEMACCtrlFramesTransmitted)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).aPAUSEMACCtrlFramesReceived as *const _ as usize
        },
        5248usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(aPAUSEMACCtrlFramesReceived)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ClConfiguration as *const _ as usize },
        5256usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ClConfiguration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ClTimeSlotsCount as *const _ as usize },
        5264usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ClTimeSlotsCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).CxpLinkConfigurationStatus as *const _ as usize
        },
        5272usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpLinkConfigurationStatus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).CxpLinkConfigurationPreferred as *const _
                as usize
        },
        5280usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpLinkConfigurationPreferred)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CxpLinkConfiguration as *const _ as usize },
        5288usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpLinkConfiguration)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).CxpConnectionSelector as *const _ as usize
        },
        5296usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpConnectionSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).CxpConnectionTestMode as *const _ as usize
        },
        5304usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpConnectionTestMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).CxpConnectionTestErrorCount as *const _ as usize
        },
        5312usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpConnectionTestErrorCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).CxpConnectionTestPacketCount as *const _ as usize
        },
        5320usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpConnectionTestPacketCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CxpPoCxpAuto as *const _ as usize },
        5328usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpPoCxpAuto)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CxpPoCxpTurnOff as *const _ as usize },
        5336usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpPoCxpTurnOff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CxpPoCxpTripReset as *const _ as usize },
        5344usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpPoCxpTripReset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).CxpPoCxpStatus as *const _ as usize },
        5352usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(CxpPoCxpStatus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkInferenceFrameId as *const _ as usize
        },
        5360usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkInferenceFrameId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpin>())).ChunkInferenceResult as *const _ as usize },
        5368usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkInferenceResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkInferenceConfidence as *const _ as usize
        },
        5376usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkInferenceConfidence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpin>())).ChunkInferenceBoundingBoxResult as *const _
                as usize
        },
        5384usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpin),
            "::",
            stringify!(ChunkInferenceBoundingBoxResult)
        )
    );
}
pub type quickSpin = _quickSpin;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _quickSpinTLSystem {
    pub TLID: quickSpinStringNode,
    pub TLVendorName: quickSpinStringNode,
    pub TLModelName: quickSpinStringNode,
    pub TLVersion: quickSpinStringNode,
    pub TLFileName: quickSpinStringNode,
    pub TLDisplayName: quickSpinStringNode,
    pub TLPath: quickSpinStringNode,
    pub TLType: quickSpinEnumerationNode,
    pub GenTLVersionMajor: quickSpinIntegerNode,
    pub GenTLVersionMinor: quickSpinIntegerNode,
    pub GenTLSFNCVersionMajor: quickSpinIntegerNode,
    pub GenTLSFNCVersionMinor: quickSpinIntegerNode,
    pub GenTLSFNCVersionSubMinor: quickSpinIntegerNode,
    pub GevVersionMajor: quickSpinIntegerNode,
    pub GevVersionMinor: quickSpinIntegerNode,
    pub InterfaceUpdateList: quickSpinCommandNode,
    pub InterfaceSelector: quickSpinIntegerNode,
    pub InterfaceID: quickSpinStringNode,
    pub InterfaceDisplayName: quickSpinStringNode,
    pub GevInterfaceMACAddress: quickSpinIntegerNode,
    pub GevInterfaceDefaultIPAddress: quickSpinIntegerNode,
    pub GevInterfaceDefaultSubnetMask: quickSpinIntegerNode,
    pub GevInterfaceDefaultGateway: quickSpinIntegerNode,
    pub EnumerateGEVInterfaces: quickSpinBooleanNode,
    pub EnumerateUSBInterfaces: quickSpinBooleanNode,
}
#[test]
fn bindgen_test_layout__quickSpinTLSystem() {
    assert_eq!(
        ::std::mem::size_of::<_quickSpinTLSystem>(),
        200usize,
        concat!("Size of: ", stringify!(_quickSpinTLSystem))
    );
    assert_eq!(
        ::std::mem::align_of::<_quickSpinTLSystem>(),
        8usize,
        concat!("Alignment of ", stringify!(_quickSpinTLSystem))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLSystem>())).TLID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(TLID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLSystem>())).TLVendorName as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(TLVendorName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLSystem>())).TLModelName as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(TLModelName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLSystem>())).TLVersion as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(TLVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLSystem>())).TLFileName as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(TLFileName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).TLDisplayName as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(TLDisplayName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLSystem>())).TLPath as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(TLPath)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLSystem>())).TLType as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(TLType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GenTLVersionMajor as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GenTLVersionMajor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GenTLVersionMinor as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GenTLVersionMinor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GenTLSFNCVersionMajor as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GenTLSFNCVersionMajor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GenTLSFNCVersionMinor as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GenTLSFNCVersionMinor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GenTLSFNCVersionSubMinor as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GenTLSFNCVersionSubMinor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GevVersionMajor as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GevVersionMajor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GevVersionMinor as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GevVersionMinor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).InterfaceUpdateList as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(InterfaceUpdateList)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).InterfaceSelector as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(InterfaceSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLSystem>())).InterfaceID as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(InterfaceID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).InterfaceDisplayName as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(InterfaceDisplayName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GevInterfaceMACAddress as *const _
                as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GevInterfaceMACAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GevInterfaceDefaultIPAddress as *const _
                as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GevInterfaceDefaultIPAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GevInterfaceDefaultSubnetMask as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GevInterfaceDefaultSubnetMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).GevInterfaceDefaultGateway as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(GevInterfaceDefaultGateway)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).EnumerateGEVInterfaces as *const _
                as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(EnumerateGEVInterfaces)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLSystem>())).EnumerateUSBInterfaces as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLSystem),
            "::",
            stringify!(EnumerateUSBInterfaces)
        )
    );
}
pub type quickSpinTLSystem = _quickSpinTLSystem;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _quickSpinTLDevice {
    pub DeviceID: quickSpinStringNode,
    pub DeviceSerialNumber: quickSpinStringNode,
    pub DeviceVendorName: quickSpinStringNode,
    pub DeviceModelName: quickSpinStringNode,
    pub DeviceType: quickSpinEnumerationNode,
    pub DeviceDisplayName: quickSpinStringNode,
    pub DeviceAccessStatus: quickSpinEnumerationNode,
    pub DeviceVersion: quickSpinStringNode,
    pub DeviceUserID: quickSpinStringNode,
    pub DeviceDriverVersion: quickSpinStringNode,
    pub DeviceIsUpdater: quickSpinBooleanNode,
    pub GevCCP: quickSpinEnumerationNode,
    pub GUIXMLLocation: quickSpinEnumerationNode,
    pub GUIXMLPath: quickSpinStringNode,
    pub GenICamXMLLocation: quickSpinEnumerationNode,
    pub GenICamXMLPath: quickSpinStringNode,
    pub GevDeviceIPAddress: quickSpinIntegerNode,
    pub GevDeviceSubnetMask: quickSpinIntegerNode,
    pub GevDeviceMACAddress: quickSpinIntegerNode,
    pub GevDeviceGateway: quickSpinIntegerNode,
    pub DeviceLinkSpeed: quickSpinIntegerNode,
    pub GevVersionMajor: quickSpinIntegerNode,
    pub GevVersionMinor: quickSpinIntegerNode,
    pub GevDeviceModeIsBigEndian: quickSpinBooleanNode,
    pub GevDeviceReadAndWriteTimeout: quickSpinIntegerNode,
    pub GevDeviceMaximumRetryCount: quickSpinIntegerNode,
    pub GevDevicePort: quickSpinIntegerNode,
    pub GevDeviceDiscoverMaximumPacketSize: quickSpinCommandNode,
    pub GevDeviceMaximumPacketSize: quickSpinIntegerNode,
    pub GevDeviceIsWrongSubnet: quickSpinBooleanNode,
    pub GevDeviceAutoForceIP: quickSpinCommandNode,
    pub GevDeviceForceIP: quickSpinCommandNode,
    pub GevDeviceForceIPAddress: quickSpinIntegerNode,
    pub GevDeviceForceSubnetMask: quickSpinIntegerNode,
    pub GevDeviceForceGateway: quickSpinIntegerNode,
    pub DeviceMulticastMonitorMode: quickSpinBooleanNode,
    pub DeviceEndianessMechanism: quickSpinEnumerationNode,
    pub DeviceInstanceId: quickSpinStringNode,
    pub DeviceLocation: quickSpinStringNode,
    pub DeviceCurrentSpeed: quickSpinEnumerationNode,
    pub DeviceU3VProtocol: quickSpinBooleanNode,
    pub DevicePortId: quickSpinStringNode,
}
#[test]
fn bindgen_test_layout__quickSpinTLDevice() {
    assert_eq!(
        ::std::mem::size_of::<_quickSpinTLDevice>(),
        336usize,
        concat!("Size of: ", stringify!(_quickSpinTLDevice))
    );
    assert_eq!(
        ::std::mem::align_of::<_quickSpinTLDevice>(),
        8usize,
        concat!("Alignment of ", stringify!(_quickSpinTLDevice))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceSerialNumber as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceSerialNumber)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceVendorName as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceVendorName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceModelName as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceModelName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceType as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceDisplayName as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceDisplayName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceAccessStatus as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceAccessStatus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceVersion as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceUserID as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceUserID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceDriverVersion as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceDriverVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceIsUpdater as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceIsUpdater)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevCCP as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevCCP)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GUIXMLLocation as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GUIXMLLocation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLDevice>())).GUIXMLPath as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GUIXMLPath)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GenICamXMLLocation as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GenICamXMLLocation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GenICamXMLPath as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GenICamXMLPath)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceIPAddress as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceIPAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceSubnetMask as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceSubnetMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceMACAddress as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceMACAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceGateway as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceGateway)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceLinkSpeed as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceLinkSpeed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevVersionMajor as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevVersionMajor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevVersionMinor as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevVersionMinor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceModeIsBigEndian as *const _
                as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceModeIsBigEndian)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceReadAndWriteTimeout as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceReadAndWriteTimeout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceMaximumRetryCount as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceMaximumRetryCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDevicePort as *const _ as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDevicePort)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceDiscoverMaximumPacketSize
                as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceDiscoverMaximumPacketSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceMaximumPacketSize as *const _
                as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceMaximumPacketSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceIsWrongSubnet as *const _
                as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceIsWrongSubnet)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceAutoForceIP as *const _ as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceAutoForceIP)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceForceIP as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceForceIP)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceForceIPAddress as *const _
                as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceForceIPAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceForceSubnetMask as *const _
                as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceForceSubnetMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).GevDeviceForceGateway as *const _
                as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(GevDeviceForceGateway)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceMulticastMonitorMode as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceMulticastMonitorMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceEndianessMechanism as *const _
                as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceEndianessMechanism)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceInstanceId as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceInstanceId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceLocation as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceLocation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceCurrentSpeed as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceCurrentSpeed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLDevice>())).DeviceU3VProtocol as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DeviceU3VProtocol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLDevice>())).DevicePortId as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLDevice),
            "::",
            stringify!(DevicePortId)
        )
    );
}
pub type quickSpinTLDevice = _quickSpinTLDevice;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _quickSpinTLInterface {
    pub InterfaceID: quickSpinStringNode,
    pub InterfaceDisplayName: quickSpinStringNode,
    pub InterfaceType: quickSpinEnumerationNode,
    pub GevInterfaceGatewaySelector: quickSpinIntegerNode,
    pub GevInterfaceGateway: quickSpinIntegerNode,
    pub GevInterfaceMACAddress: quickSpinIntegerNode,
    pub GevInterfaceSubnetSelector: quickSpinIntegerNode,
    pub GevInterfaceSubnetIPAddress: quickSpinIntegerNode,
    pub GevInterfaceSubnetMask: quickSpinIntegerNode,
    pub GevInterfaceTransmitLinkSpeed: quickSpinIntegerNode,
    pub GevInterfaceReceiveLinkSpeed: quickSpinIntegerNode,
    pub GevInterfaceMTU: quickSpinIntegerNode,
    pub POEStatus: quickSpinEnumerationNode,
    pub FilterDriverStatus: quickSpinEnumerationNode,
    pub GevActionDeviceKey: quickSpinIntegerNode,
    pub GevActionGroupKey: quickSpinIntegerNode,
    pub GevActionGroupMask: quickSpinIntegerNode,
    pub GevActionTime: quickSpinIntegerNode,
    pub ActionCommand: quickSpinCommandNode,
    pub DeviceUnlock: quickSpinStringNode,
    pub DeviceUpdateList: quickSpinCommandNode,
    pub DeviceCount: quickSpinIntegerNode,
    pub DeviceSelector: quickSpinIntegerNode,
    pub DeviceID: quickSpinStringNode,
    pub DeviceVendorName: quickSpinStringNode,
    pub DeviceModelName: quickSpinStringNode,
    pub DeviceSerialNumber: quickSpinStringNode,
    pub DeviceAccessStatus: quickSpinEnumerationNode,
    pub GevDeviceIPAddress: quickSpinIntegerNode,
    pub GevDeviceSubnetMask: quickSpinIntegerNode,
    pub GevDeviceGateway: quickSpinIntegerNode,
    pub GevDeviceMACAddress: quickSpinIntegerNode,
    pub IncompatibleDeviceCount: quickSpinIntegerNode,
    pub IncompatibleDeviceSelector: quickSpinIntegerNode,
    pub IncompatibleDeviceID: quickSpinStringNode,
    pub IncompatibleDeviceVendorName: quickSpinStringNode,
    pub IncompatibleDeviceModelName: quickSpinStringNode,
    pub IncompatibleGevDeviceIPAddress: quickSpinIntegerNode,
    pub IncompatibleGevDeviceSubnetMask: quickSpinIntegerNode,
    pub IncompatibleGevDeviceMACAddress: quickSpinIntegerNode,
    pub GevDeviceForceIP: quickSpinCommandNode,
    pub GevDeviceForceIPAddress: quickSpinIntegerNode,
    pub GevDeviceForceSubnetMask: quickSpinIntegerNode,
    pub GevDeviceForceGateway: quickSpinIntegerNode,
    pub GevDeviceAutoForceIP: quickSpinCommandNode,
    pub HostAdapterName: quickSpinStringNode,
    pub HostAdapterVendor: quickSpinStringNode,
    pub HostAdapterDriverVersion: quickSpinStringNode,
}
#[test]
fn bindgen_test_layout__quickSpinTLInterface() {
    assert_eq!(
        ::std::mem::size_of::<_quickSpinTLInterface>(),
        384usize,
        concat!("Size of: ", stringify!(_quickSpinTLInterface))
    );
    assert_eq!(
        ::std::mem::align_of::<_quickSpinTLInterface>(),
        8usize,
        concat!("Alignment of ", stringify!(_quickSpinTLInterface))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).InterfaceID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(InterfaceID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).InterfaceDisplayName as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(InterfaceDisplayName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).InterfaceType as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(InterfaceType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevInterfaceGatewaySelector
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevInterfaceGatewaySelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevInterfaceGateway as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevInterfaceGateway)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevInterfaceMACAddress as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevInterfaceMACAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevInterfaceSubnetSelector as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevInterfaceSubnetSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevInterfaceSubnetIPAddress
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevInterfaceSubnetIPAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevInterfaceSubnetMask as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevInterfaceSubnetMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevInterfaceTransmitLinkSpeed
                as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevInterfaceTransmitLinkSpeed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevInterfaceReceiveLinkSpeed
                as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevInterfaceReceiveLinkSpeed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevInterfaceMTU as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevInterfaceMTU)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLInterface>())).POEStatus as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(POEStatus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).FilterDriverStatus as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(FilterDriverStatus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevActionDeviceKey as *const _
                as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevActionDeviceKey)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevActionGroupKey as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevActionGroupKey)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevActionGroupMask as *const _
                as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevActionGroupMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevActionTime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevActionTime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).ActionCommand as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(ActionCommand)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).DeviceUnlock as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(DeviceUnlock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).DeviceUpdateList as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(DeviceUpdateList)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).DeviceCount as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(DeviceCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).DeviceSelector as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(DeviceSelector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLInterface>())).DeviceID as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(DeviceID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).DeviceVendorName as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(DeviceVendorName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).DeviceModelName as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(DeviceModelName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).DeviceSerialNumber as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(DeviceSerialNumber)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).DeviceAccessStatus as *const _
                as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(DeviceAccessStatus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevDeviceIPAddress as *const _
                as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevDeviceIPAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevDeviceSubnetMask as *const _
                as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevDeviceSubnetMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevDeviceGateway as *const _ as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevDeviceGateway)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevDeviceMACAddress as *const _
                as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevDeviceMACAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).IncompatibleDeviceCount as *const _
                as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(IncompatibleDeviceCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).IncompatibleDeviceSelector as *const _
                as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(IncompatibleDeviceSelector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).IncompatibleDeviceID as *const _
                as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(IncompatibleDeviceID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).IncompatibleDeviceVendorName
                as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(IncompatibleDeviceVendorName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).IncompatibleDeviceModelName
                as *const _ as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(IncompatibleDeviceModelName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).IncompatibleGevDeviceIPAddress
                as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(IncompatibleGevDeviceIPAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).IncompatibleGevDeviceSubnetMask
                as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(IncompatibleGevDeviceSubnetMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).IncompatibleGevDeviceMACAddress
                as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(IncompatibleGevDeviceMACAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevDeviceForceIP as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevDeviceForceIP)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevDeviceForceIPAddress as *const _
                as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevDeviceForceIPAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevDeviceForceSubnetMask as *const _
                as usize
        },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevDeviceForceSubnetMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevDeviceForceGateway as *const _
                as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevDeviceForceGateway)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).GevDeviceAutoForceIP as *const _
                as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(GevDeviceAutoForceIP)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).HostAdapterName as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(HostAdapterName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).HostAdapterVendor as *const _ as usize
        },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(HostAdapterVendor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLInterface>())).HostAdapterDriverVersion as *const _
                as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLInterface),
            "::",
            stringify!(HostAdapterDriverVersion)
        )
    );
}
pub type quickSpinTLInterface = _quickSpinTLInterface;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _quickSpinTLStream {
    pub StreamID: quickSpinStringNode,
    pub StreamType: quickSpinEnumerationNode,
    pub StreamBufferCountManual: quickSpinIntegerNode,
    pub StreamBufferCountResult: quickSpinIntegerNode,
    pub StreamBufferCountMax: quickSpinIntegerNode,
    pub StreamBufferCountMode: quickSpinEnumerationNode,
    pub StreamBufferHandlingMode: quickSpinEnumerationNode,
    pub StreamAnnounceBufferMinimum: quickSpinIntegerNode,
    pub StreamAnnouncedBufferCount: quickSpinIntegerNode,
    pub StreamStartedFrameCount: quickSpinIntegerNode,
    pub StreamDeliveredFrameCount: quickSpinIntegerNode,
    pub StreamLostFrameCount: quickSpinIntegerNode,
    pub StreamInputBufferCount: quickSpinIntegerNode,
    pub StreamOutputBufferCount: quickSpinIntegerNode,
    pub StreamCRCCheckEnable: quickSpinBooleanNode,
    pub GevPacketResendMode: quickSpinBooleanNode,
    pub GevMaximumNumberResendRequests: quickSpinIntegerNode,
    pub GevPacketResendTimeout: quickSpinIntegerNode,
    pub StreamIsGrabbing: quickSpinBooleanNode,
    pub StreamChunkCountMaximum: quickSpinIntegerNode,
    pub StreamBufferAlignment: quickSpinIntegerNode,
    pub StreamDroppedFrameCount: quickSpinIntegerNode,
    pub GevTotalPacketCount: quickSpinIntegerNode,
    pub GevFailedPacketCount: quickSpinIntegerNode,
    pub GevResendPacketCount: quickSpinIntegerNode,
    pub StreamFailedBufferCount: quickSpinIntegerNode,
    pub GevResendRequestCount: quickSpinIntegerNode,
    pub StreamBlockTransferSize: quickSpinIntegerNode,
}
#[test]
fn bindgen_test_layout__quickSpinTLStream() {
    assert_eq!(
        ::std::mem::size_of::<_quickSpinTLStream>(),
        224usize,
        concat!("Size of: ", stringify!(_quickSpinTLStream))
    );
    assert_eq!(
        ::std::mem::align_of::<_quickSpinTLStream>(),
        8usize,
        concat!("Alignment of ", stringify!(_quickSpinTLStream))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamType as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamBufferCountManual as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamBufferCountManual)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamBufferCountResult as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamBufferCountResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamBufferCountMax as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamBufferCountMax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamBufferCountMode as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamBufferCountMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamBufferHandlingMode as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamBufferHandlingMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamAnnounceBufferMinimum as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamAnnounceBufferMinimum)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamAnnouncedBufferCount as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamAnnouncedBufferCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamStartedFrameCount as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamStartedFrameCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamDeliveredFrameCount as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamDeliveredFrameCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamLostFrameCount as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamLostFrameCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamInputBufferCount as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamInputBufferCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamOutputBufferCount as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamOutputBufferCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamCRCCheckEnable as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamCRCCheckEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).GevPacketResendMode as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(GevPacketResendMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).GevMaximumNumberResendRequests
                as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(GevMaximumNumberResendRequests)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).GevPacketResendTimeout as *const _
                as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(GevPacketResendTimeout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamIsGrabbing as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamIsGrabbing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamChunkCountMaximum as *const _
                as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamChunkCountMaximum)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamBufferAlignment as *const _
                as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamBufferAlignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamDroppedFrameCount as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamDroppedFrameCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).GevTotalPacketCount as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(GevTotalPacketCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).GevFailedPacketCount as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(GevFailedPacketCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).GevResendPacketCount as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(GevResendPacketCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamFailedBufferCount as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamFailedBufferCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).GevResendRequestCount as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(GevResendRequestCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_quickSpinTLStream>())).StreamBlockTransferSize as *const _
                as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_quickSpinTLStream),
            "::",
            stringify!(StreamBlockTransferSize)
        )
    );
}
pub type quickSpinTLStream = _quickSpinTLStream;
#[doc = "< GigE Vision"]
pub const _spinTLStreamTypeEnums_StreamType_GigEVision: _spinTLStreamTypeEnums = 0;
#[doc = "< Camera Link"]
pub const _spinTLStreamTypeEnums_StreamType_CameraLink: _spinTLStreamTypeEnums = 1;
#[doc = "< Camera Link High Speed"]
pub const _spinTLStreamTypeEnums_StreamType_CameraLinkHS: _spinTLStreamTypeEnums = 2;
#[doc = "< CoaXPress"]
pub const _spinTLStreamTypeEnums_StreamType_CoaXPress: _spinTLStreamTypeEnums = 3;
#[doc = "< USB3 Vision"]
pub const _spinTLStreamTypeEnums_StreamType_USB3Vision: _spinTLStreamTypeEnums = 4;
#[doc = "< Custom transport layer"]
pub const _spinTLStreamTypeEnums_StreamType_Custom: _spinTLStreamTypeEnums = 5;
pub const _spinTLStreamTypeEnums_NUMSTREAMTYPE: _spinTLStreamTypeEnums = 6;
#[doc = "@brief The enumeration definitions for transport layer nodes."]
pub type _spinTLStreamTypeEnums = ::std::os::raw::c_uint;
#[doc = "@brief The enumeration definitions for transport layer nodes."]
pub use self::_spinTLStreamTypeEnums as spinTLStreamTypeEnums;
#[doc = "< The number of buffers used for the stream are set by the user."]
pub const _spinTLStreamBufferCountModeEnums_StreamBufferCountMode_Manual:
    _spinTLStreamBufferCountModeEnums = 0;
#[doc = "< DEPRECATED. The number of buffers used for the stream is automatically calculated based on the device frame rate."]
pub const _spinTLStreamBufferCountModeEnums_StreamBufferCountMode_Auto:
    _spinTLStreamBufferCountModeEnums = 1;
pub const _spinTLStreamBufferCountModeEnums_NUMSTREAMBUFFERCOUNTMODE:
    _spinTLStreamBufferCountModeEnums = 2;
pub type _spinTLStreamBufferCountModeEnums = ::std::os::raw::c_uint;
pub use self::_spinTLStreamBufferCountModeEnums as spinTLStreamBufferCountModeEnums;
#[doc = "< The application always gets the buffer from the head of the output buffer queue (thus, the oldest available one). If the output buffer queue is empty, the application waits for a newly acquired buffer until the timeout expires."]
pub const _spinTLStreamBufferHandlingModeEnums_StreamBufferHandlingMode_OldestFirst:
    _spinTLStreamBufferHandlingModeEnums = 0;
#[doc = "< The application always gets the buffer from the head of the output buffer queue (thus, the oldest available one). If the output buffer queue is empty, the application waits for a newly acquired buffer until the timeout expires. If a new buffer arrives it will overwrite the existing buffer from the head of the queue (behaves like a circular buffer)."]
pub const _spinTLStreamBufferHandlingModeEnums_StreamBufferHandlingMode_OldestFirstOverwrite:
    _spinTLStreamBufferHandlingModeEnums = 1;
#[doc = "< The application always gets the latest completed buffer (the newest one).  If the Output Buffer Queue is empty, the application waits for a newly acquired buffer until the timeout expires.  This buffer handling mode is typically used in a live display GUI where it is important that there is no lag between camera and display."]
pub const _spinTLStreamBufferHandlingModeEnums_StreamBufferHandlingMode_NewestOnly:
    _spinTLStreamBufferHandlingModeEnums = 2;
#[doc = "< The application always gets the buffer from the tail of the output buffer queue (thus, the newest available one). If the output buffer queue is empty, the application waits for a newly acquired buffer until the timeout expires."]
pub const _spinTLStreamBufferHandlingModeEnums_StreamBufferHandlingMode_NewestFirst:
    _spinTLStreamBufferHandlingModeEnums = 3;
pub const _spinTLStreamBufferHandlingModeEnums_NUMSTREAMBUFFERHANDLINGMODE:
    _spinTLStreamBufferHandlingModeEnums = 4;
pub type _spinTLStreamBufferHandlingModeEnums = ::std::os::raw::c_uint;
pub use self::_spinTLStreamBufferHandlingModeEnums as spinTLStreamBufferHandlingModeEnums;
#[doc = "< GigE Vision"]
pub const _spinTLDeviceTypeEnums_DeviceType_GigEVision: _spinTLDeviceTypeEnums = 0;
#[doc = "< Camera Link"]
pub const _spinTLDeviceTypeEnums_DeviceType_CameraLink: _spinTLDeviceTypeEnums = 1;
#[doc = "< Camera Link High Speed"]
pub const _spinTLDeviceTypeEnums_DeviceType_CameraLinkHS: _spinTLDeviceTypeEnums = 2;
#[doc = "< CoaXPress"]
pub const _spinTLDeviceTypeEnums_DeviceType_CoaXPress: _spinTLDeviceTypeEnums = 3;
#[doc = "< USB3 Vision"]
pub const _spinTLDeviceTypeEnums_DeviceType_USB3Vision: _spinTLDeviceTypeEnums = 4;
#[doc = "< Custom transport layer"]
pub const _spinTLDeviceTypeEnums_DeviceType_Custom: _spinTLDeviceTypeEnums = 5;
pub const _spinTLDeviceTypeEnums_NUMDEVICETYPE: _spinTLDeviceTypeEnums = 6;
pub type _spinTLDeviceTypeEnums = ::std::os::raw::c_uint;
pub use self::_spinTLDeviceTypeEnums as spinTLDeviceTypeEnums;
#[doc = "< Not known to producer."]
pub const _spinTLDeviceAccessStatusEnums_DeviceAccessStatus_Unknown:
    _spinTLDeviceAccessStatusEnums = 0;
#[doc = "< Full access"]
pub const _spinTLDeviceAccessStatusEnums_DeviceAccessStatus_ReadWrite:
    _spinTLDeviceAccessStatusEnums = 1;
#[doc = "< Read-only access"]
pub const _spinTLDeviceAccessStatusEnums_DeviceAccessStatus_ReadOnly:
    _spinTLDeviceAccessStatusEnums = 2;
#[doc = "< Not available to connect"]
pub const _spinTLDeviceAccessStatusEnums_DeviceAccessStatus_NoAccess:
    _spinTLDeviceAccessStatusEnums = 3;
#[doc = "< The device is already opened by another entity"]
pub const _spinTLDeviceAccessStatusEnums_DeviceAccessStatus_Busy: _spinTLDeviceAccessStatusEnums =
    4;
#[doc = "< Open in Read/Write mode by this GenTL host"]
pub const _spinTLDeviceAccessStatusEnums_DeviceAccessStatus_OpenReadWrite:
    _spinTLDeviceAccessStatusEnums = 5;
#[doc = "< Open in Read access mode by this GenTL host"]
pub const _spinTLDeviceAccessStatusEnums_DeviceAccessStatus_OpenReadOnly:
    _spinTLDeviceAccessStatusEnums = 6;
pub const _spinTLDeviceAccessStatusEnums_NUMDEVICEACCESSSTATUS: _spinTLDeviceAccessStatusEnums = 7;
pub type _spinTLDeviceAccessStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinTLDeviceAccessStatusEnums as spinTLDeviceAccessStatusEnums;
#[doc = "< Open access privilege."]
pub const _spinTLGevCCPEnums_GevCCP_EnumEntry_GevCCP_OpenAccess: _spinTLGevCCPEnums = 0;
#[doc = "< Exclusive access privilege."]
pub const _spinTLGevCCPEnums_GevCCP_EnumEntry_GevCCP_ExclusiveAccess: _spinTLGevCCPEnums = 1;
#[doc = "< Control access privilege."]
pub const _spinTLGevCCPEnums_GevCCP_EnumEntry_GevCCP_ControlAccess: _spinTLGevCCPEnums = 2;
pub const _spinTLGevCCPEnums_NUMGEVCCP: _spinTLGevCCPEnums = 3;
pub type _spinTLGevCCPEnums = ::std::os::raw::c_uint;
pub use self::_spinTLGevCCPEnums as spinTLGevCCPEnums;
#[doc = "< Load XML from device"]
pub const _spinTLGUIXMLLocationEnums_GUIXMLLocation_Device: _spinTLGUIXMLLocationEnums = 0;
#[doc = "< Load XML from host"]
pub const _spinTLGUIXMLLocationEnums_GUIXMLLocation_Host: _spinTLGUIXMLLocationEnums = 1;
pub const _spinTLGUIXMLLocationEnums_NUMGUIXMLLOCATION: _spinTLGUIXMLLocationEnums = 2;
pub type _spinTLGUIXMLLocationEnums = ::std::os::raw::c_uint;
pub use self::_spinTLGUIXMLLocationEnums as spinTLGUIXMLLocationEnums;
#[doc = "< Load GenICam XML from device"]
pub const _spinTLGenICamXMLLocationEnums_GenICamXMLLocation_Device: _spinTLGenICamXMLLocationEnums =
    0;
#[doc = "< Load GenICam XML from host"]
pub const _spinTLGenICamXMLLocationEnums_GenICamXMLLocation_Host: _spinTLGenICamXMLLocationEnums =
    1;
pub const _spinTLGenICamXMLLocationEnums_NUMGENICAMXMLLOCATION: _spinTLGenICamXMLLocationEnums = 2;
pub type _spinTLGenICamXMLLocationEnums = ::std::os::raw::c_uint;
pub use self::_spinTLGenICamXMLLocationEnums as spinTLGenICamXMLLocationEnums;
#[doc = "< Handling the device endianness according to GenICam Schema 1.0"]
pub const _spinTLDeviceEndianessMechanismEnums_DeviceEndianessMechanism_Legacy:
    _spinTLDeviceEndianessMechanismEnums = 0;
#[doc = "< Handling the device endianness according to GenICam Schema 1.1 and later"]
pub const _spinTLDeviceEndianessMechanismEnums_DeviceEndianessMechanism_Standard:
    _spinTLDeviceEndianessMechanismEnums = 1;
pub const _spinTLDeviceEndianessMechanismEnums_NUMDEVICEENDIANESSMECHANISM:
    _spinTLDeviceEndianessMechanismEnums = 2;
pub type _spinTLDeviceEndianessMechanismEnums = ::std::os::raw::c_uint;
pub use self::_spinTLDeviceEndianessMechanismEnums as spinTLDeviceEndianessMechanismEnums;
#[doc = "< Unknown-Speed."]
pub const _spinTLDeviceCurrentSpeedEnums_DeviceCurrentSpeed_UnknownSpeed:
    _spinTLDeviceCurrentSpeedEnums = 0;
#[doc = "< Low-Speed."]
pub const _spinTLDeviceCurrentSpeedEnums_DeviceCurrentSpeed_LowSpeed:
    _spinTLDeviceCurrentSpeedEnums = 1;
#[doc = "< Full-Speed."]
pub const _spinTLDeviceCurrentSpeedEnums_DeviceCurrentSpeed_FullSpeed:
    _spinTLDeviceCurrentSpeedEnums = 2;
#[doc = "< High-Speed."]
pub const _spinTLDeviceCurrentSpeedEnums_DeviceCurrentSpeed_HighSpeed:
    _spinTLDeviceCurrentSpeedEnums = 3;
#[doc = "< Super-Speed."]
pub const _spinTLDeviceCurrentSpeedEnums_DeviceCurrentSpeed_SuperSpeed:
    _spinTLDeviceCurrentSpeedEnums = 4;
pub const _spinTLDeviceCurrentSpeedEnums_NUMDEVICECURRENTSPEED: _spinTLDeviceCurrentSpeedEnums = 5;
pub type _spinTLDeviceCurrentSpeedEnums = ::std::os::raw::c_uint;
pub use self::_spinTLDeviceCurrentSpeedEnums as spinTLDeviceCurrentSpeedEnums;
#[doc = "< GigE Vision"]
pub const _spinTLInterfaceTypeEnums_InterfaceType_GigEVision: _spinTLInterfaceTypeEnums = 0;
#[doc = "< Camera Link"]
pub const _spinTLInterfaceTypeEnums_InterfaceType_CameraLink: _spinTLInterfaceTypeEnums = 1;
#[doc = "< Camera Link High Speed"]
pub const _spinTLInterfaceTypeEnums_InterfaceType_CameraLinkHS: _spinTLInterfaceTypeEnums = 2;
#[doc = "< CoaXPress"]
pub const _spinTLInterfaceTypeEnums_InterfaceType_CoaXPress: _spinTLInterfaceTypeEnums = 3;
#[doc = "< USB3 Vision"]
pub const _spinTLInterfaceTypeEnums_InterfaceType_USB3Vision: _spinTLInterfaceTypeEnums = 4;
#[doc = "< Custom transport layer"]
pub const _spinTLInterfaceTypeEnums_InterfaceType_Custom: _spinTLInterfaceTypeEnums = 5;
pub const _spinTLInterfaceTypeEnums_NUMINTERFACETYPE: _spinTLInterfaceTypeEnums = 6;
pub type _spinTLInterfaceTypeEnums = ::std::os::raw::c_uint;
pub use self::_spinTLInterfaceTypeEnums as spinTLInterfaceTypeEnums;
#[doc = "< Not Supported"]
pub const _spinTLPOEStatusEnums_POEStatus_NotSupported: _spinTLPOEStatusEnums = 0;
#[doc = "< Power is Off"]
pub const _spinTLPOEStatusEnums_POEStatus_PowerOff: _spinTLPOEStatusEnums = 1;
#[doc = "< Power is On"]
pub const _spinTLPOEStatusEnums_POEStatus_PowerOn: _spinTLPOEStatusEnums = 2;
pub const _spinTLPOEStatusEnums_NUMPOESTATUS: _spinTLPOEStatusEnums = 3;
pub type _spinTLPOEStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinTLPOEStatusEnums as spinTLPOEStatusEnums;
#[doc = "< Not Supported"]
pub const _spinTLFilterDriverStatusEnums_FilterDriverStatus_NotSupported:
    _spinTLFilterDriverStatusEnums = 0;
#[doc = "< FLIR Light Weight Filter Driver is disabled"]
pub const _spinTLFilterDriverStatusEnums_FilterDriverStatus_Disabled:
    _spinTLFilterDriverStatusEnums = 1;
#[doc = "< FLIR Light Weight Filter Driver is enabled"]
pub const _spinTLFilterDriverStatusEnums_FilterDriverStatus_Enabled:
    _spinTLFilterDriverStatusEnums = 2;
pub const _spinTLFilterDriverStatusEnums_NUMFILTERDRIVERSTATUS: _spinTLFilterDriverStatusEnums = 3;
pub type _spinTLFilterDriverStatusEnums = ::std::os::raw::c_uint;
pub use self::_spinTLFilterDriverStatusEnums as spinTLFilterDriverStatusEnums;
#[doc = "< GigE Vision"]
pub const _spinTLTLTypeEnums_TLType_GigEVision: _spinTLTLTypeEnums = 0;
#[doc = "< Camera Link"]
pub const _spinTLTLTypeEnums_TLType_CameraLink: _spinTLTLTypeEnums = 1;
#[doc = "< Camera Link High Speed"]
pub const _spinTLTLTypeEnums_TLType_CameraLinkHS: _spinTLTLTypeEnums = 2;
#[doc = "< CoaXPress"]
pub const _spinTLTLTypeEnums_TLType_CoaXPress: _spinTLTLTypeEnums = 3;
#[doc = "< USB3 Vision"]
pub const _spinTLTLTypeEnums_TLType_USB3Vision: _spinTLTLTypeEnums = 4;
#[doc = "< Different Interface modules of the GenTL Producer are of different types"]
pub const _spinTLTLTypeEnums_TLType_Mixed: _spinTLTLTypeEnums = 5;
#[doc = "< Custom transport layer"]
pub const _spinTLTLTypeEnums_TLType_Custom: _spinTLTLTypeEnums = 6;
pub const _spinTLTLTypeEnums_NUMTLTYPE: _spinTLTLTypeEnums = 7;
pub type _spinTLTLTypeEnums = ::std::os::raw::c_uint;
pub use self::_spinTLTLTypeEnums as spinTLTLTypeEnums;
extern "C" {
    pub fn quickSpinInit(hCamera: spinCamera, pQuickSpin: *mut quickSpin) -> spinError;
}
extern "C" {
    pub fn quickSpinInitEx(
        hCamera: spinCamera,
        pQuickSpin: *mut quickSpin,
        pQuickSpinTLDevice: *mut quickSpinTLDevice,
        pQuickSpinTLStream: *mut quickSpinTLStream,
    ) -> spinError;
}
extern "C" {
    pub fn quickSpinTLDeviceInit(
        hCamera: spinCamera,
        pQuickSpinTLDevice: *mut quickSpinTLDevice,
    ) -> spinError;
}
extern "C" {
    pub fn quickSpinTLStreamInit(
        hCamera: spinCamera,
        pQuickSpinTLStream: *mut quickSpinTLStream,
    ) -> spinError;
}
extern "C" {
    pub fn quickSpinTLInterfaceInit(
        hInterface: spinInterface,
        pQuickSpinTLInterface: *mut quickSpinTLInterface,
    ) -> spinError;
}
extern "C" {
    pub fn quickSpinTLSystemInit(
        hSystem: spinSystem,
        pQuickSpinTLSystem: *mut quickSpinTLSystem,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the error code of the last error"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param pError The error enum pointer in which the error message is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinErrorGetLast(pError: *mut spinError) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the error message of the last error"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param pBuf The c-string character buffer in which the error message is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinErrorGetLastMessage(
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the build date of the last error"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param pBuf The c-string character buffer in which the build date is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinErrorGetLastBuildDate(
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the build time of the last error"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param pBuf The c-string character buffer in which the build time is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinErrorGetLastBuildTime(
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the filename of the last error"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param pBuf The c-string character buffer in which the file name is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinErrorGetLastFileName(
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the full error message of the last error"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param pBuf The c-string character buffer in which the full error message is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinErrorGetLastFullMessage(
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the function name of the last error"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param pBuf The c-string character buffer in which the function name is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinErrorGetLastFunctionName(
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the line number of the last error"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param pBuf The c-string character buffer in which the line number is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinErrorGetLastLineNumber(pLineNum: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves an instance of the system object; the system is a singleton, so there will only ever be one instance;"]
    #[doc = " system instance must be destroyed by calling spinSystemReleaseInstance"]
    #[doc = ""]
    #[doc = " @see spinSystemReleaseInstance"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phSystem The system handle pointer in which the system instance is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemGetInstance(phSystem: *mut spinSystem) -> spinError;
}
extern "C" {
    #[doc = " Releases the system; make sure handle is cleaned up properly by setting it to NULL"]
    #[doc = " after system is released; the handle can only be used again after calling"]
    #[doc = " spinSystemGetInstance"]
    #[doc = ""]
    #[doc = " @see spinSystemGetInstance"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system handle"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemReleaseInstance(hSystem: spinSystem) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a list of detected (and enumerable) interfaces on the system;"]
    #[doc = " interface lists must be created and destroyed"]
    #[doc = ""]
    #[doc = " @see spinInterfaceListCreateEmpty()"]
    #[doc = " @see spinInterfaceListDestroy()"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, from which the interface list is retrieved"]
    #[doc = " @param hInterfaceList The interface list to house the interfaces from the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemGetInterfaces(
        hSystem: spinSystem,
        hInterfaceList: spinInterfaceList,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a list of detected (and enumerable) cameras on the system;"]
    #[doc = " camera lists must be created and destroyed"]
    #[doc = ""]
    #[doc = " @see spinCameraListCreateEmpty()"]
    #[doc = " @see spinCameraListDestroy()"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, from which the camera list is retrieved"]
    #[doc = " @param hCameraList The camera list to house the cameras from the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemGetCameras(hSystem: spinSystem, hCameraList: spinCameraList) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a list of detected (and enumerable) cameras on the system;"]
    #[doc = " manually set whether to update the current interface and camera lists;"]
    #[doc = " camera lists must be created and destroyed"]
    #[doc = ""]
    #[doc = " @see spinCameraListCreateEmpty()"]
    #[doc = " @see spinCameraListDestroy()"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, from which the camera list is retrieved"]
    #[doc = " @param bUpdateInterfaces The boolean of whether to update the interface list"]
    #[doc = " @param bUpdateCameras The boolean of whether to update the camera list"]
    #[doc = " @param hCameraList The camera list to house the cameras from the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemGetCamerasEx(
        hSystem: spinSystem,
        bUpdateInterfaces: bool8_t,
        bUpdateCameras: bool8_t,
        hCameraList: spinCameraList,
    ) -> spinError;
}
extern "C" {
    #[doc = " Sets the logging level for all logging events on the system"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, on which the logging level is set"]
    #[doc = " @param logLevel The logging level to set"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemSetLoggingLevel(hSystem: spinSystem, logLevel: spinnakerLogLevel)
        -> spinError;
}
extern "C" {
    #[doc = " Retrieves the logging level for all logging events on the system"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, from which the logging level is retrieved"]
    #[doc = " @param logLevel The logging level enum pointer in which the current logging level is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemGetLoggingLevel(
        hSystem: spinSystem,
        pLogLevel: *mut spinnakerLogLevel,
    ) -> spinError;
}
extern "C" {
    #[doc = " Registers a logging event handler to the system (event handlers registered in this way must be unregistered)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, on which the logging event handler is registered"]
    #[doc = " @param hLogEventHandler The logging event handler to register on the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemRegisterLogEventHandler(
        hSystem: spinSystem,
        hLogEventHandler: spinLogEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters a selected logging event handler from the system"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, from which the logging event handler is unregistered"]
    #[doc = " @param hLogEventHandler The logging event handler to unregister from the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemUnregisterLogEventHandler(
        hSystem: spinSystem,
        hLogEventHandler: spinLogEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters all logging event handlers from the system"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, from which all logging event handlers are unregistered"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemUnregisterAllLogEventHandlers(hSystem: spinSystem) -> spinError;
}
extern "C" {
    #[doc = " Checks whether a system is currently in use"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system to check"]
    #[doc = " @param pbIsInUse The boolean pointer to return whether the system is currently in use"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemIsInUse(hSystem: spinSystem, pbIsInUse: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Registers a device arrival event handler to every interface on the system (event handlers registered this way"]
    #[doc = " must be unregistered)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, on which the device arrival event handler is registered"]
    #[doc = " @param hDeviceArrivalEventHandler The device arrival event handler to register on the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemRegisterDeviceArrivalEventHandler(
        hSystem: spinSystem,
        hDeviceArrivalEventHandler: spinDeviceArrivalEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Registers a device removal event handler to the system to every interface on the system (event handlers"]
    #[doc = " registered this way must be unregistered)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, on which the device removal event handler is registered"]
    #[doc = " @param hDeviceRemovalEventHandler The device removal event handler to register on the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemRegisterDeviceRemovalEventHandler(
        hSystem: spinSystem,
        hDeviceRemovalEventHandler: spinDeviceRemovalEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters a device arrival event handler from the system"]
    #[doc = " @see spinError"]
    #[doc = " @see spinDeviceArrivalEventHandler"]
    #[doc = ""]
    #[doc = " @param hSystem The system, from which the device arrival event handler is unregistered"]
    #[doc = " @param hDeviceArrivalEventHandler The device arrival event handler to unregister from the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemUnregisterDeviceArrivalEventHandler(
        hSystem: spinSystem,
        hDeviceArrivalEventHandler: spinDeviceArrivalEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters a device removal event handler from the system"]
    #[doc = " @see spinError"]
    #[doc = " @see spinDeviceRemovalEventHandler"]
    #[doc = ""]
    #[doc = " @param hSystem The system, from which the device removal event handler is unregistered"]
    #[doc = " @param hDeviceRemovalEventHandler The device removal event handler to unregister from the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemUnregisterDeviceRemovalEventHandler(
        hSystem: spinSystem,
        hDeviceRemovalEventHandler: spinDeviceRemovalEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Registers an interface event handler (device arrival and device removal) to every interface on the system"]
    #[doc = " (interface events registered this way must be unregistered)"]
    #[doc = " If new interfaces are detected by the system after spinSystemRegisterInterfaceEventHandler() is called, those"]
    #[doc = " interfaces will be automatically registered with this event."]
    #[doc = " @see spinError"]
    #[doc = " @see spinInterfaceEventHandler"]
    #[doc = ""]
    #[doc = " @param hSystem The system, on which the interface event handler is registered"]
    #[doc = " @param hInterfaceEventHandler The interface event handler (device arrival and device removal) to register on the"]
    #[doc = " system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemRegisterInterfaceEventHandler(
        hSystem: spinSystem,
        hInterfaceEventHandler: spinInterfaceEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters an interface event handler from the system"]
    #[doc = " @see spinError"]
    #[doc = " @see spinInterfaceEventHandler"]
    #[doc = ""]
    #[doc = " @param hSystem The system, from which the interface event handler is unregistered"]
    #[doc = " @param hInterfaceEventHandler The interface event handler (device arrival and device removal) to unregister from"]
    #[doc = " the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemUnregisterInterfaceEventHandler(
        hSystem: spinSystem,
        hInterfaceEventHandler: spinInterfaceEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Updates the list of cameras on the system, informing whether there has been any changes"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, on which the list of attached cameras is updated"]
    #[doc = " @param pbChanged The boolean pointer to return whether cameras have arrived on or been removed from the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemUpdateCameras(hSystem: spinSystem, pbChanged: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Updates the list of cameras on the system, informing whether there has been any changes; manually set whether to"]
    #[doc = " update the current interface lists"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system, on which the list of attached cameras is updated"]
    #[doc = " @param bUpdateInterfaces The boolean of whether to update the interface list"]
    #[doc = " @param pbChanged The boolean pointer to return whether cameras have arrived or been removed from the system"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemUpdateCamerasEx(
        hSystem: spinSystem,
        bUpdateInterfaces: bool8_t,
        pbChanged: *mut bool8_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Broadcast an Action Command to all devices on system"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system on which to send the action command to all devices."]
    #[doc = " @param iDeviceKey The Action Command's device key"]
    #[doc = " @param iGroupKey The Action Command's group key"]
    #[doc = " @param iGroupMask The Action Command's group mask"]
    #[doc = " @param iActionTime (Optional) Time when to assert a future action. Zero means immediate action."]
    #[doc = " @param piResultSize (Optional) The number of results in the results array. The value passed should be equal to"]
    #[doc = " the expected number of devices that acknowledge the command. Returns the number of received results."]
    #[doc = " @param results (Optional) An Array with *piResultSize elements to hold the action command result status. The"]
    #[doc = " buffer is filled starting from index 0. If received results are less than expected number of devices that"]
    #[doc = " acknowledge the command, remaining results are not changed. If received results are more than expected number of"]
    #[doc = " devices that acknowledge the command, extra results are ignored and not appended to array. This parameter is"]
    #[doc = " ignored if piResultSize is 0. Thus this parameter can be NULL if pResultSize is 0 or NULL."]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemSendActionCommand(
        hSystem: spinSystem,
        iDeviceKey: size_t,
        iGroupKey: size_t,
        iGroupMask: size_t,
        iActionTime: size_t,
        piResultSize: *mut size_t,
        results: *mut actionCommandResult,
    ) -> spinError;
}
extern "C" {
    #[doc = " Get current library version of Spinnaker."]
    #[doc = ""]
    #[doc = " @return A struct containing the current version of Spinnaker(major, minor, type, build)."]
    pub fn spinSystemGetLibraryVersion(
        hSystem: spinSystem,
        hLibraryVersion: *mut spinLibraryVersion,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the transport layer nodemap from the system."]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSystem The system handle."]
    #[doc = " @param phNodeMap The nodemap handle pointer in which the transport layer system nodemap is returned."]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinSystemGetTLNodeMap(
        hSystem: spinSystem,
        phNodeMap: *mut spinNodeMapHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Creates an empty interface list (interface lists created this way must be destroyed)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phInterfaceList The interface list handle pointer in which the empty interface list is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceListCreateEmpty(phInterfaceList: *mut spinInterfaceList) -> spinError;
}
extern "C" {
    #[doc = " Destroys an interface list"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterfaceList The interface list to destroy"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceListDestroy(hInterfaceList: spinInterfaceList) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the number of interfaces in an interface list"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterfaceList The interface list where the interfaces to be counted are"]
    #[doc = " @param pSize The unsigned integer pointer in which the number of interfaces is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    #[doc = " @see spinError"]
    pub fn spinInterfaceListGetSize(
        hInterfaceList: spinInterfaceList,
        pSize: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves an interface from an interface list using an index (interfaces retrieved this way must be released)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterfaceList The interface list of the interface to be retrieved"]
    #[doc = " @param index The index of the interface"]
    #[doc = " @param phInterface The interface handle pointer in which the interface is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceListGet(
        hInterfaceList: spinInterfaceList,
        index: size_t,
        phInterface: *mut spinInterface,
    ) -> spinError;
}
extern "C" {
    #[doc = " Clears an interface list"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterfaceList The interface list to clear"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceListClear(hInterfaceList: spinInterfaceList) -> spinError;
}
extern "C" {
    #[doc = " Creates an empty camera list (camera lists created this way must be destroyed)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phCameraList The camera list handle pointer in which the empty camera list is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraListCreateEmpty(phCameraList: *mut spinCameraList) -> spinError;
}
extern "C" {
    #[doc = " Destroys a camera list"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCameraList The camera list to destroy"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraListDestroy(hCameraList: spinCameraList) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the number of cameras on a camera list"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCameraList The camera list where the cameras to be counted are"]
    #[doc = " @param pSize The unsigned integer pointer in which the number of cameras is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraListGetSize(hCameraList: spinCameraList, pSize: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a camera from a camera list using an index. This function will return"]
    #[doc = " a SPINNAKER_ERR_INVALID_PARAMETER error if the input index is out of range."]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCameraList The camera list of the camera to retrieve"]
    #[doc = " @param index The index of the camera"]
    #[doc = " @param phCamera The camera handle pointer in which the camera is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraListGet(
        hCameraList: spinCameraList,
        index: size_t,
        phCamera: *mut spinCamera,
    ) -> spinError;
}
extern "C" {
    #[doc = " Clears a camera list"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCameraList The camera list to clear"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraListClear(hCameraList: spinCameraList) -> spinError;
}
extern "C" {
    #[doc = " Removes a camera from a camera list using its index"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCameraList The camera list of the camera to remove"]
    #[doc = " @param index The index of the camera to remove"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraListRemove(hCameraList: spinCameraList, index: size_t) -> spinError;
}
extern "C" {
    #[doc = " Appends all the cameras from one camera list to another"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCameraListBase The camera list to receive the other"]
    #[doc = " @param hCameraListToAppend The camera list to add to the other"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraListAppend(
        hCameraListBase: spinCameraList,
        hCameraListToAppend: spinCameraList,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a camera from a camera list using its serial number. This"]
    #[doc = " function will return a NULL spinCamera pointer if no matching camera"]
    #[doc = " serial is found."]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCameraList The camera list of the camera to retrieve"]
    #[doc = " @param serial The serial number of the camera to retrieve"]
    #[doc = " @param phCamera The camera handle pointer in which the camera is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraListGetBySerial(
        hCameraList: spinCameraList,
        pSerial: *const ::std::os::raw::c_char,
        phCamera: *mut spinCamera,
    ) -> spinError;
}
extern "C" {
    #[doc = " Removes a camera from a camera list using its serial number"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCameraList The camera of the camera to remove"]
    #[doc = " @param pSerial The serial number of the camera to remove"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraListRemoveBySerial(
        hCameraList: spinCameraList,
        pSerial: *const ::std::os::raw::c_char,
    ) -> spinError;
}
extern "C" {
    #[doc = " Checks whether any cameras have been connected or disconnected on an interface"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface of the list of attached cameras to update"]
    #[doc = " @param pbChanged The boolean pointer to return whether or not the cameras have changed"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceUpdateCameras(
        hInterface: spinInterface,
        pbChanged: *mut bool8_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a camera list from an interface;"]
    #[doc = " camera lists must be created and destroy"]
    #[doc = ""]
    #[doc = " @see spinCameraListCreateEmpty()"]
    #[doc = " @see spinCameraListDestroy()"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface of the camera list to retrieve"]
    #[doc = " @param hCameraList The camera list to house the cameras from the interface"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceGetCameras(
        hInterface: spinInterface,
        hCameraList: spinCameraList,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a camera list from an interface;"]
    #[doc = " manually set whether to update the cameras;"]
    #[doc = " camera lists must be created and destroyed"]
    #[doc = ""]
    #[doc = " @see spinCameraListCreateEmpty()"]
    #[doc = " @see spinCameraListDestroy()"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface of the camera list to retrieve"]
    #[doc = " @param bUpdateCameras The boolean of whether or not to update the cameras"]
    #[doc = " @param hCameraList The camera list to house the cameras from the interface"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceGetCamerasEx(
        hInterface: spinInterface,
        bUpdateCameras: bool8_t,
        hCameraList: spinCameraList,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the transport layer nodemap from an interface"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface of the nodemap to retrieve"]
    #[doc = " @param phNodeMap The nodemap handle pointer in which the transport layer interface nodemap is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceGetTLNodeMap(
        hInterface: spinInterface,
        phNodeMap: *mut spinNodeMapHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Registers a device arrival event handler on an interface (event handlers registered in this way must be"]
    #[doc = " unregistered)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface on which to register the device arrival event handler"]
    #[doc = " @param hDeviceArrivalEventHandler The device arrival event handler to register"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceRegisterDeviceArrivalEventHandler(
        hInterface: spinInterface,
        hDeviceArrivalEventHandler: spinDeviceArrivalEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Registers a device removal event handler on an interface (event handlers registered in this way must be"]
    #[doc = " unregistered)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface the Interface on which to register the device removal event handler"]
    #[doc = " @param hDeviceRemovalEventHandler The device removal event handler to register"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceRegisterDeviceRemovalEventHandler(
        hInterface: spinInterface,
        hDeviceRemovalEventHandler: spinDeviceRemovalEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters a device arrival event handler from an interface"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface from which to unregister the device arrival event handler"]
    #[doc = " @param hDeviceArrivalEventHandler The device arrival event handler to unregister"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceUnregisterDeviceArrivalEventHandler(
        hInterface: spinInterface,
        hDeviceArrivalEventHandler: spinDeviceArrivalEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters a device removal event handler from an interface"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface from which to unregister the device removal event handler"]
    #[doc = " @param hDeviceRemovalEventHandler The device removal event handler to unregister"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceUnregisterDeviceRemovalEventHandler(
        hInterface: spinInterface,
        hDeviceRemovalEventHandler: spinDeviceRemovalEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Registers an interface event handler (both device arrival and device removal) on an interface"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface on which to register the interface event handler"]
    #[doc = " @param hInterfaceEventHandler The interface event handler to register"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceRegisterInterfaceEventHandler(
        hInterface: spinInterface,
        hInterfaceEventHandler: spinInterfaceEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters an interface event handler from an interface"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface from which to unregister the interface event handler"]
    #[doc = " @param hInterfaceEventHandler The interface event handler to unregister"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceUnregisterInterfaceEventHandler(
        hInterface: spinInterface,
        hInterfaceEventHandler: spinInterfaceEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Releases an interface"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface to release"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceRelease(hInterface: spinInterface) -> spinError;
}
extern "C" {
    #[doc = " Checks whether an interface is in use"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterface The interface to check"]
    #[doc = " @param pbIsInUse The boolean pointer to return whether or not the interface is in use"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceIsInUse(hInterface: spinInterface, pbIsInUse: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Broadcast an Action Command to all devices on interface"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param iDeviceKey The Action Command's device key"]
    #[doc = " @param iGroupKey The Action Command's group key"]
    #[doc = " @param iGroupMask The Action Command's group mask"]
    #[doc = " @param iActionTime (Optional) Time when to assert a future action. Zero means immediate action."]
    #[doc = " @param piResultSize (Optional) The number of results in the results array. The value passed should be equal to"]
    #[doc = " the expected number of devices that acknowledge the command. Returns the number of received results."]
    #[doc = " @param results (Optional) An Array with *piResultSize elements to hold the action command result status. The"]
    #[doc = " buffer is filled starting from index 0. If received results are less than expected number of devices that"]
    #[doc = " acknowledge the command, remaining results are not changed. If received results are more than expected number of"]
    #[doc = " devices that acknowledge the command, extra results are ignored and not appended to array. This parameter is"]
    #[doc = " ignored if piResultSize is 0. Thus this parameter can be NULL if pResultSize is 0 or NULL."]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceSendActionCommand(
        hInterface: spinInterface,
        iDeviceKey: size_t,
        iGroupKey: size_t,
        iGroupMask: size_t,
        iActionTime: size_t,
        piResultSize: *mut size_t,
        results: *mut actionCommandResult,
    ) -> spinError;
}
extern "C" {
    #[doc = " Initializes a camera, allowing for much more interaction"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera to initialize"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraInit(hCamera: spinCamera) -> spinError;
}
extern "C" {
    #[doc = " Deinitializes a camera, greatly reducing functionality"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera to deinitialize"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraDeInit(hCamera: spinCamera) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the GenICam nodemap from a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera from which the nodemap is retrieved"]
    #[doc = " @param phNodeMap The nodemap handle pointer in which the nodemap is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraGetNodeMap(
        hCamera: spinCamera,
        phNodeMap: *mut spinNodeMapHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the transport layer device nodemap from a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera from which the transport layer device nodemap is retrieved"]
    #[doc = " @param phNodeMap The nodemap handle pointer in which the nodemap is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraGetTLDeviceNodeMap(
        hCamera: spinCamera,
        phNodeMap: *mut spinNodeMapHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the transport layer stream nodemap from a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera from which the transport layer streaming nodemap is retrieved"]
    #[doc = " @param phNodeMap The nodemap handle pointer in which the nodemap is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraGetTLStreamNodeMap(
        hCamera: spinCamera,
        phNodeMap: *mut spinNodeMapHandle,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the access mode of a camera (as an enum, spinAccessMode)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinAccessMode"]
    #[doc = ""]
    #[doc = " @param hCamera The camera of the access mode to retrieve"]
    #[doc = " @param pAccessMode The access mode enum pointer in which the access mode is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraGetAccessMode(
        hCamera: spinCamera,
        pAccessMode: *mut spinAccessMode,
    ) -> spinError;
}
extern "C" {
    pub fn spinCameraReadPort(
        hCamera: spinCamera,
        iAddress: u64,
        pBuffer: *mut ::std::os::raw::c_void,
        iSize: size_t,
    ) -> spinError;
}
extern "C" {
    pub fn spinCameraWritePort(
        hCamera: spinCamera,
        iAddress: u64,
        pBuffer: *mut ::std::os::raw::c_void,
        iSize: size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Has a camera start acquiring images"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera to begin acquiring images"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraBeginAcquisition(hCamera: spinCamera) -> spinError;
}
extern "C" {
    #[doc = " Has a camera stop acquiring images"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera to stop acquiring images"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraEndAcquisition(hCamera: spinCamera) -> spinError;
}
extern "C" {
    #[doc = " Retrieves an image from a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera of the image to retrieve"]
    #[doc = " @param phImage The image handle pointer in which the image is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraGetNextImage(hCamera: spinCamera, phImage: *mut spinImage) -> spinError;
}
extern "C" {
    #[doc = " Retrieves an image from a camera; manually set the timeout in milliseconds"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera of the image to retrieve"]
    #[doc = " @param grabTimeout The timeout value for returned an image"]
    #[doc = " @param phImage The image handle pointer in which the image is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraGetNextImageEx(
        hCamera: spinCamera,
        grabTimeout: u64,
        phImage: *mut spinImage,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a unique identifier for a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera of the unique identifier"]
    #[doc = " @param pBuf The c-string character buffer in which the unique identifier is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraGetUniqueID(
        hCamera: spinCamera,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Checks whether a camera is currently acquiring images"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera to check"]
    #[doc = " @param pbIsStreaming The boolean pointer to return whether or not the camera is currently streaming"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraIsStreaming(hCamera: spinCamera, pbIsStreaming: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the GUI XML from a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera of the GUI XML to retrieve"]
    #[doc = " @param pBuf The c-string character buffer in which the GUI XML is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraGetGuiXml(
        hCamera: spinCamera,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Registers a universal device event handler (every device event type) to a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera on which to register the universal device event handler"]
    #[doc = " @param hDeviceEventHandler The device event handler to register"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraRegisterDeviceEventHandler(
        hCamera: spinCamera,
        hDeviceEventHandler: spinDeviceEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Registers a specific device event handler (only one device event type) to a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera on which to register the specific device event handler"]
    #[doc = " @param hDeviceEventHandler The device event handler to register"]
    #[doc = " @param pName The name of the device event handler to register"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraRegisterDeviceEventHandlerEx(
        hCamera: spinCamera,
        hDeviceEventHandler: spinDeviceEventHandler,
        pName: *const ::std::os::raw::c_char,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters a device event handler from a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera from which to unregister the device event handler"]
    #[doc = " @param hDeviceEventHandler The device event handler to unregister"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraUnregisterDeviceEventHandler(
        hCamera: spinCamera,
        hDeviceEventHandler: spinDeviceEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Registers an image event handler to a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera on which to register the image event handler"]
    #[doc = " @param hImageEventHandler The image event handler to register"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraRegisterImageEventHandler(
        hCamera: spinCamera,
        hImageEventHandler: spinImageEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Unregisters an image event handler from a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera from which to unregister the image event handler"]
    #[doc = " @param hImageEventHandler The image event handler to unregister"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraUnregisterImageEventHandler(
        hCamera: spinCamera,
        hImageEventHandler: spinImageEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Releases a camera"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera to release"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraRelease(hCamera: spinCamera) -> spinError;
}
extern "C" {
    #[doc = " Checks whether a camera is still valid for use"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera to check"]
    #[doc = " @param pbValid The boolean pointer to return whether or not the camera is valid"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraIsValid(hCamera: spinCamera, pbValid: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Checks whether a camera is currently initialized"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera to check"]
    #[doc = " @param pbInit The boolean pointer to return whether or not the camera is initialized"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraIsInitialized(hCamera: spinCamera, pbInit: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Returns the largest packet size that can be safely used on the interface that device is connected to."]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hCamera The camera to check"]
    #[doc = " @param pMaxPacketSize The maximum packet size returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraDiscoverMaxPacketSize(
        hCamera: spinCamera,
        pMaxPacketSize: *mut ::std::os::raw::c_uint,
    ) -> spinError;
}
extern "C" {
    #[doc = " Forces the camera to be on the same subnet as its corresponding interface."]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinCameraForceIP() -> spinError;
}
extern "C" {
    #[doc = " Creates an empty image;"]
    #[doc = " images created this way must be destroyed"]
    #[doc = ""]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phImage The image handle pointer in which the empty image is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageCreateEmpty(phImage: *mut spinImage) -> spinError;
}
extern "C" {
    #[doc = " Creates an image from another;"]
    #[doc = " images created this way must be destroyed"]
    #[doc = ""]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSrcImage The image to be copied"]
    #[doc = " @param phDestImage The image handle pointer of the image to be created"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageCreate(hSrcImage: spinImage, phDestImage: *mut spinImage) -> spinError;
}
extern "C" {
    #[doc = " Creates an image with some set properties;"]
    #[doc = " images created this way must be destroyed"]
    #[doc = ""]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phImage The image handle pointer in which the image is returned"]
    #[doc = " @param width The width to set"]
    #[doc = " @param height The height to set"]
    #[doc = " @param offsetX The offset along the X axis to set"]
    #[doc = " @param offsetY The offset along the Y axis to set"]
    #[doc = " @param pixelFormat The pixel format to set"]
    #[doc = " @param pData The image data to set; can be set to null"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageCreateEx(
        phImage: *mut spinImage,
        width: size_t,
        height: size_t,
        offsetX: size_t,
        offsetY: size_t,
        pixelFormat: spinPixelFormatEnums,
        pData: *mut ::std::os::raw::c_void,
    ) -> spinError;
}
extern "C" {
    #[doc = " Creates an image with some set properties;"]
    #[doc = " images created this way must be destroyed"]
    #[doc = ""]
    #[doc = " @see spinError"]
    #[doc = " @see spinImageGetTLPayloadType"]
    #[doc = ""]
    #[doc = " @param phImage The image handle pointer in which the image is returned"]
    #[doc = " @param width The width to set"]
    #[doc = " @param height The height to set"]
    #[doc = " @param offsetX The offset along the X axis to set"]
    #[doc = " @param offsetY The offset along the Y axis to set"]
    #[doc = " @param pixelFormat The pixel format to set"]
    #[doc = " @param pData The image data to set; can be set to null"]
    #[doc = " @param dataPayloadType The payload type of the data."]
    #[doc = "This value can be retrieved from an existing image by using the spinImageGetTLPayloadType() function call."]
    #[doc = " @param dataSize The size of the provided data in bytes"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageCreateEx2(
        phImage: *mut spinImage,
        width: size_t,
        height: size_t,
        offsetX: size_t,
        offsetY: size_t,
        pixelFormat: spinPixelFormatEnums,
        pData: *mut ::std::os::raw::c_void,
        dataPayloadType: spinPayloadTypeInfoIDs,
        dataSize: size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Destroys an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to destroy"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageDestroy(hImage: spinImage) -> spinError;
}
extern "C" {
    #[doc = " Sets the default color processing algorithm of all images (if not otherwise set)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param algorithm The color processing algorithm used by default"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSetDefaultColorProcessing(algorithm: spinColorProcessingAlgorithm)
        -> spinError;
}
extern "C" {
    #[doc = " Retrieves the default color processing algorithm"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param pAlgorithm The color processing algorithm enum pointer in which the color processing algorithm is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetDefaultColorProcessing(
        pAlgorithm: *mut spinColorProcessingAlgorithm,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the color processing algorithm of a specific image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the color processing algorithm to retrieve"]
    #[doc = " @param pAlgorithm The color processing algorithm pointer in which the color processing algorithm is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetColorProcessing(
        hImage: spinImage,
        pAlgorithm: *mut spinColorProcessingAlgorithm,
    ) -> spinError;
}
extern "C" {
    #[doc = " Sets the default number of threads used for image decompression during"]
    #[doc = " spinImageConvert(). The number of threads used is defaulted to be equal"]
    #[doc = " to one less than the number of concurrent threads supported by the"]
    #[doc = " system."]
    #[doc = ""]
    #[doc = " @param numThreads Number of parallel image decompression threads set to run"]
    #[doc = ""]
    #[doc = " @see spinImageConvert()"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSetNumDecompressionThreads(numThreads: ::std::os::raw::c_uint) -> spinError;
}
extern "C" {
    #[doc = " Gets the number of threads used for image decompression during Convert()."]
    #[doc = ""]
    #[doc = " @param pNumThreads The pointer indicating the number of parallel image decompression threads set to run"]
    #[doc = ""]
    #[doc = " @see spinImageSetNumDecompressionThreads()"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetNumDecompressionThreads(
        pNumThreads: *mut ::std::os::raw::c_uint,
    ) -> spinError;
}
extern "C" {
    #[doc = " Converts the pixel format of one image into a new image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSrcImage The image to be converted"]
    #[doc = " @param pixelFormat The pixel format to be converted to"]
    #[doc = " @param hDestImage The image handle pointer in which the converted image is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageConvert(
        hSrcImage: spinImage,
        pixelFormat: spinPixelFormatEnums,
        hDestImage: spinImage,
    ) -> spinError;
}
extern "C" {
    #[doc = " Converts the pixel format and color processing algorithm of one image into a new image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSrcImage The image to be converted"]
    #[doc = " @param pixelFormat The pixel format to be converted to"]
    #[doc = " @param algorithm The color processing algorithm to use for conversion"]
    #[doc = " @param hDestImage The image handle pointer in which the converted image is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageConvertEx(
        hSrcImage: spinImage,
        pixelFormat: spinPixelFormatEnums,
        algorithm: spinColorProcessingAlgorithm,
        hDestImage: spinImage,
    ) -> spinError;
}
extern "C" {
    #[doc = " Resets an image with some set properties"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be reset"]
    #[doc = " @param width The width to be reset to"]
    #[doc = " @param height The height to be reset to"]
    #[doc = " @param offsetX The offset to be reset to along the X axis"]
    #[doc = " @param offsetY The offset to be reset to along the Y axis"]
    #[doc = " @param pixelFormat The pixel format to be reset to"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageReset(
        hImage: spinImage,
        width: size_t,
        height: size_t,
        offsetX: size_t,
        offsetY: size_t,
        pixelFormat: spinPixelFormatEnums,
    ) -> spinError;
}
extern "C" {
    #[doc = " Resets an image with some set properties and image data"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to reset"]
    #[doc = " @param width The width to be reset to"]
    #[doc = " @param height The height to be reset to"]
    #[doc = " @param offsetX The offset to be reset to along the X axis"]
    #[doc = " @param offsetY The offset to be reset to along the Y axis"]
    #[doc = " @param pixelFormat The pixel format to be reset to"]
    #[doc = " @param pData The image data to reset to"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageResetEx(
        hImage: spinImage,
        width: size_t,
        height: size_t,
        offsetX: size_t,
        offsetY: size_t,
        pixelFormat: spinPixelFormatEnums,
        pData: *mut ::std::os::raw::c_void,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the ID of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the ID to retrieve"]
    #[doc = " @param pId The unsigned integer pointer in which the ID is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetID(hImage: spinImage, pId: *mut u64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the image data of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the image data to retrieve"]
    #[doc = " @param ppData The pointer to the void pointer in which the image data is retrieved"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetData(
        hImage: spinImage,
        ppData: *mut *mut ::std::os::raw::c_void,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the private data of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the private image data to retrieve"]
    #[doc = " @param ppData The pointer to the void pointer in which the private image data is retrieved"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetPrivateData(
        hImage: spinImage,
        ppData: *mut *mut ::std::os::raw::c_void,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the buffer size of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of image data buffer to retrieve"]
    #[doc = " @param pSize The unsigned integer pointer in which the size of the image data if returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetBufferSize(hImage: spinImage, pSize: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Creates a deep copy of an image (the destination image must be created as an empty image prior to the deep copy)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hSrcImage The image to be copied"]
    #[doc = " @param hDestImage The image handle in which the image is copied"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageDeepCopy(hSrcImage: spinImage, hDestImage: spinImage) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the width of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the width to retrieve"]
    #[doc = " @param pWidth The unsigned integer pointer in which the width is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetWidth(hImage: spinImage, pWidth: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the height of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the height to retrieve"]
    #[doc = " @param pHeight The unsigned integer pointer in which the height is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetHeight(hImage: spinImage, pHeight: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the offset of an image along its X axis"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the offset along the X axis to retrieve"]
    #[doc = " @param pOffsetX The unsigned integer pointer in which the offset along the X axis is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetOffsetX(hImage: spinImage, pOffsetX: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the offset of an image along its Y axis"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the offset along the Y axis to retrieve"]
    #[doc = " @param pOffsetY The unsigned integer pointer in which the offset along the Y axis is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetOffsetY(hImage: spinImage, pOffsetY: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the padding of an image along its X axis"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the padding along the X axis to retrieve"]
    #[doc = " @param pPaddingX The unsigned integer pointer in which the padding along the X axis is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetPaddingX(hImage: spinImage, pPaddingX: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the padding of an image along its Y axis"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the padding along the Y axis to retrieve"]
    #[doc = " @param pPaddingY The unsigned integer pointer in which the padding along the Y axis is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetPaddingY(hImage: spinImage, pPaddingY: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the frame ID of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the frame ID to retrieve"]
    #[doc = " @param pFrameID The unsigned integer pointer in which the frame ID is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetFrameID(hImage: spinImage, pFrameID: *mut u64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the timestamp of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the timestamp to retrieve"]
    #[doc = " @param pTimeStamp The unsigned integer pointer om which the timestamp is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetTimeStamp(hImage: spinImage, pTimeStamp: *mut u64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the payload type of an image (as an enum, spinPayloadTypeInfoIds)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinPayloadTypeInfoIds"]
    #[doc = ""]
    #[doc = " @param hImage The image of the payload type to retrieve"]
    #[doc = " @param pPayloadType The payload type enum pointer in which the payload type is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetPayloadType(hImage: spinImage, pPayloadType: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the transport layer payload type of an image (as an enum, spinPayloadTypeInfoIds)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinPayloadTypeInfoIds"]
    #[doc = ""]
    #[doc = " @param hImage The image of the TL payload type to retrieve"]
    #[doc = " @param pPayloadType The payload type enum pointer in which the TL payload type is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetTLPayloadType(
        hImage: spinImage,
        pPayloadType: *mut spinPayloadTypeInfoIDs,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the pixel format of an image (as an enum, spinPixelFormatEnums)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinPixelFormatEnums"]
    #[doc = ""]
    #[doc = " @param hImage The image of the pixel format to retrieve"]
    #[doc = " @param pPixelFormat The pixel format enum pointer in which the pixel format is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetPixelFormat(
        hImage: spinImage,
        pPixelFormat: *mut spinPixelFormatEnums,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the transport layer pixel format of an image (as an unsigned integer)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the TL pixel format to retrieve"]
    #[doc = " @param pPixelFormat The unsigned integer pointer in which the TL pixel format is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetTLPixelFormat(hImage: spinImage, pPixelFormat: *mut u64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the transport layer pixel format namespace of an image (as an enum, spinPixelFormatNamespaceID)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinPixelFormatNamespaceID"]
    #[doc = ""]
    #[doc = " @param hImage The image of the TL pixel format namespace to retrieve"]
    #[doc = " @param pPixelFormatNamespace The pixel format namespace pointer in which the pixel format namespace is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetTLPixelFormatNamespace(
        hImage: spinImage,
        pPixelFormatNamespace: *mut spinPixelFormatNamespaceID,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the pixel format of an image (as a symbolic)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the pixel format to retrieve"]
    #[doc = " @param pBuf The c-string character buffer in which the pixel format symbolic is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetPixelFormatName(
        hImage: spinImage,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Checks whether an image is incomplete"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to check"]
    #[doc = " @param pbIsIncomplete The boolean pointer to return whether or not the image is incomplete"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageIsIncomplete(hImage: spinImage, pbIsIncomplete: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the valid payload size of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image of the payload size to retrieve"]
    #[doc = " @param pSize The unsigned integer pointer in which the size of the valid payload is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetValidPayloadSize(hImage: spinImage, pSize: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Saves an image using a specified file format (using an enum, spinImageFileFormat)"]
    #[doc = " @see spinError"]
    #[doc = " @see spinImageFileFormat"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pFilename The filename to use to save the image (with or without the appropriate file extension)"]
    #[doc = " @Param format The file format to use to save the image"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSave(
        hImage: spinImage,
        pFilename: *const ::std::os::raw::c_char,
        format: spinImageFileFormat,
    ) -> spinError;
}
extern "C" {
    #[doc = " Saves an image using a specified file format (using the extension of the filename)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pFilename The filename to use to save the image (with or without the appropriate file extension)"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSaveFromExt(
        hImage: spinImage,
        pFilename: *const ::std::os::raw::c_char,
    ) -> spinError;
}
extern "C" {
    #[doc = " Saves an image as a PNG image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pFilename The filename to use to save the image (with or without the appropriate file extension)"]
    #[doc = " @param pOption The image options related to saving as PNG; includes compression level and whether to save as"]
    #[doc = " interlaced"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSavePng(
        hImage: spinImage,
        pFilename: *const ::std::os::raw::c_char,
        pOption: *const spinPNGOption,
    ) -> spinError;
}
extern "C" {
    #[doc = " Saves an image as a PPM image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pFilename The filename to use to save the image (with or without the appropriate file extension)"]
    #[doc = " @param pOption The image options related to saving as PPM; includes whether to save as binary"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSavePpm(
        hImage: spinImage,
        pFilename: *const ::std::os::raw::c_char,
        pOption: *const spinPPMOption,
    ) -> spinError;
}
extern "C" {
    #[doc = " Saves an image as an PGM image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pFilename The filename to use to save the image (with or without the appropriate file extension)"]
    #[doc = " @param pOption The image options related to saving as PGM; includes whether to save as binary"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSavePgm(
        hImage: spinImage,
        pFilename: *const ::std::os::raw::c_char,
        pOption: *const spinPGMOption,
    ) -> spinError;
}
extern "C" {
    #[doc = " Saves an image as a TIFF image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pFilename The filename to use to save the image (with or without the appropriate file extension)"]
    #[doc = " @param pOption The image options related to saving as TIFF; includes compression method"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSaveTiff(
        hImage: spinImage,
        pFilename: *const ::std::os::raw::c_char,
        pOption: *const spinTIFFOption,
    ) -> spinError;
}
extern "C" {
    #[doc = " Saves an image as a JPEG image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pFilename The filename to use to save the image (with or without the appropriate file extension)"]
    #[doc = " @param pOption The image options related to saving as JPEG; includes quality and whether to save as progressive"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSaveJpeg(
        hImage: spinImage,
        pFilename: *const ::std::os::raw::c_char,
        pOption: *const spinJPEGOption,
    ) -> spinError;
}
extern "C" {
    #[doc = " Saves an image as a JPEG 2000 image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pFilename The filename to use to save the image (with or without the appropriate file extension)"]
    #[doc = " @param pOption The image options related to saving as JPEG 2000; includes quality"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSaveJpg2(
        hImage: spinImage,
        pFilename: *const ::std::os::raw::c_char,
        pOption: *const spinJPG2Option,
    ) -> spinError;
}
extern "C" {
    #[doc = " Saves an image as a BMP image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pFilename The filename to use to save the image (with or without the appropriate file extension)"]
    #[doc = " @param pOption The image options related to saving as BMP; includes whether to save as indexed 8-bit"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageSaveBmp(
        hImage: spinImage,
        pFilename: *const ::std::os::raw::c_char,
        pOption: *const spinBMPOption,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the chunk layout ID of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pId The unsigned integer pointer in which the chunk layout ID is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetChunkLayoutID(hImage: spinImage, pId: *mut u64) -> spinError;
}
extern "C" {
    #[doc = " Calculates the image statistics of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param hStatistics The image statistics context in which the calculated statistics are returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageCalculateStatistics(
        hImage: spinImage,
        hStatistics: spinImageStatistics,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the image status of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pStatus The status enum pointer in which the image status is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetStatus(hImage: spinImage, pStatus: *mut spinImageStatus) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the description of image status"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param status The status enum"]
    #[doc = " @param pBuf The c-string character buffer in which the explanation of image status enum is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length; if pBuf is NULL, minimum length of string buffer is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetStatusDescription(
        status: spinImageStatus,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Releases an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageRelease(hImage: spinImage) -> spinError;
}
extern "C" {
    #[doc = " Checks whether an image has CRC"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pbHasCRC The boolean pointer to return whether the image has CRC available"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageHasCRC(hImage: spinImage, pbHasCRC: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Checks whether the CRC of an image is correct"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pbCheckCRC The boolean pointer to return whether the image CRC passes"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageCheckCRC(hImage: spinImage, pbCheckCRC: *mut bool8_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the number of bits per pixel of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pBitsPerPixel The unsigned integer pointer in which the number of bits per pixel is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetBitsPerPixel(hImage: spinImage, pBitsPerPixel: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the size of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pImageSize The unsigned integer pointer in which the size of the image is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetSize(hImage: spinImage, pImageSize: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the stride of an image"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImage The image to be saved"]
    #[doc = " @param pStride The unsigned integer pointer in which the stride is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageGetStride(hImage: spinImage, pStride: *mut size_t) -> spinError;
}
extern "C" {
    #[doc = " Creates a device event handler"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phDeviceEventHandler The device event handler pointer in which the device event context is created"]
    #[doc = " @param pFunction The function to be called at device event occurrences; signature to match:"]
    #[doc = " void(*spinDeviceEventFunction)(const spinDeviceEventData hEventData, const char* pEventName, void* pUserData)"]
    #[doc = " @param pUserData Properties that can be passed into the event function"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinDeviceEventHandlerCreate(
        phDeviceEventHandler: *mut spinDeviceEventHandler,
        pFunction: spinDeviceEventFunction,
        pUserData: *mut ::std::os::raw::c_void,
    ) -> spinError;
}
extern "C" {
    #[doc = " Destroys a device event handler"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hDeviceEventHandler The device event handler to destroy"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinDeviceEventHandlerDestroy(hDeviceEventHandler: spinDeviceEventHandler) -> spinError;
}
extern "C" {
    #[doc = " Creates an image event handler"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phImageEventHandler The image event handler pointer in which the image event context is created"]
    #[doc = " @param pFunction The function to be called at image event occurrences; signature to match:"]
    #[doc = " void(*spinImageEventFunction)(const spinImage hImage, void* pUserData)"]
    #[doc = " @param pUserData Properties that can be passed into the event function"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageEventHandlerCreate(
        phImageEventHandler: *mut spinImageEventHandler,
        pFunction: spinImageEventFunction,
        pUserData: *mut ::std::os::raw::c_void,
    ) -> spinError;
}
extern "C" {
    #[doc = " Destroys an image event handler"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hImageEventHandler The image event handler to destroy"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageEventHandlerDestroy(hImageEventHandler: spinImageEventHandler) -> spinError;
}
extern "C" {
    #[doc = " Creates a device arrival event handler"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phDeviceArrivalEventHandler The device arrival event handler pointer in which the device arrival event"]
    #[doc = " context is created"]
    #[doc = " @param pFunction The function to be called at device event occurrences; signature to match:"]
    #[doc = " void(*spinArrivalEventFunction)(void* pUserData)"]
    #[doc = " @param pUserData Properties that can be passed into the event function"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinDeviceArrivalEventHandlerCreate(
        phDeviceArrivalEventHandler: *mut spinDeviceArrivalEventHandler,
        pFunction: spinArrivalEventFunction,
        pUserData: *mut ::std::os::raw::c_void,
    ) -> spinError;
}
extern "C" {
    #[doc = " Destroys a device arrival event handler"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hDeviceArrivalEventHandler The device arrival event handler to destroy"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinDeviceArrivalEventHandlerDestroy(
        hDeviceArrivalEventHandler: spinDeviceArrivalEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Creates a device removal event handler"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phDeviceRemovalEventHandler The device removal event handler pointer in which the device removal event"]
    #[doc = "context is created"]
    #[doc = " @param pFunction The function to be called at device event occurrences; signature to match:"]
    #[doc = "void(*spinRemovalEventFunction)(uint64_t deviceSerialNumber, void* pUserData)"]
    #[doc = ""]
    #[doc = " @param pUserData Properties that can be passed into the event function"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinDeviceRemovalEventHandlerCreate(
        phDeviceRemovalEventHandler: *mut spinDeviceRemovalEventHandler,
        pFunction: spinRemovalEventFunction,
        pUserData: *mut ::std::os::raw::c_void,
    ) -> spinError;
}
extern "C" {
    #[doc = " Destroys a device removal event handler"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hDeviceRemovalEventHandler The device removal event handler to destroy"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinDeviceRemovalEventHandlerDestroy(
        hDeviceRemovalEventHandler: spinDeviceRemovalEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Creates an interface event handler (both device arrival and device removal)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phInterfaceEventHandler The interface event handler pointer in which the interface event context is"]
    #[doc = " created"]
    #[doc = " @param pArrivalFunction The function to be called at arrival event occurrences; signature to match:"]
    #[doc = " void(*spinArrivalEventFunction)(void* pUserData)"]
    #[doc = " @param hRemovalFunction The function to be called at removal event occurrences; signature to match:"]
    #[doc = " void(*spinRemovalEventFunction)(uint64_t deviceSerialNumber, void* pUserData)"]
    #[doc = " @param pUserData Properties that can be passed into the event function"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceEventHandlerCreate(
        phInterfaceEventHandler: *mut spinInterfaceEventHandler,
        pArrivalFunction: spinArrivalEventFunction,
        pRemovalFunction: spinRemovalEventFunction,
        pUserData: *mut ::std::os::raw::c_void,
    ) -> spinError;
}
extern "C" {
    #[doc = " Destroys an interface event handler (both device arrival and device removal)"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hInterfaceEventHandler The interface event handler to destroy"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinInterfaceEventHandlerDestroy(
        hInterfaceEventHandler: spinInterfaceEventHandler,
    ) -> spinError;
}
extern "C" {
    #[doc = " Creates a log event handler"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param phLogEventHandler The log event handler pointer in which the log event context is created"]
    #[doc = " @param pFunction The function to be called at device event occurrences; signature to match:"]
    #[doc = " void(*spinLogEventFunction)(const spinLogEventData hEventData, void* pUserData)"]
    #[doc = " @param pUserData Properties that can be passed into the event function"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinLogEventHandlerCreate(
        phLogEventHandler: *mut spinLogEventHandler,
        pFunction: spinLogEventFunction,
        pUserData: *mut ::std::os::raw::c_void,
    ) -> spinError;
}
extern "C" {
    #[doc = " Destroys a log event handler"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hLogEventHandler The log event handler to destroy"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinLogEventHandlerDestroy(hLogEventHandler: spinLogEventHandler) -> spinError;
}
extern "C" {
    #[doc = " Creates an image statistics context"]
    #[doc = ""]
    #[doc = " @param phStatistics The statistics handle pointer in which the image statistics context is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsCreate(phStatistics: *mut spinImageStatistics) -> spinError;
}
extern "C" {
    #[doc = " Destroys an image statistics context"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context to destroy"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsDestroy(hStatistics: spinImageStatistics) -> spinError;
}
extern "C" {
    #[doc = " Enables all channels of an image statistics context"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context to enable all channels"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsEnableAll(hStatistics: spinImageStatistics) -> spinError;
}
extern "C" {
    #[doc = " Disables all channels of an image statistics context"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context to disable all channels"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsDisableAll(hStatistics: spinImageStatistics) -> spinError;
}
extern "C" {
    #[doc = " Disables all channels of an image statistics context except grey-scale"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context to enable only grey"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsEnableGreyOnly(hStatistics: spinImageStatistics) -> spinError;
}
extern "C" {
    #[doc = " Disables all channels of an image statistics context except red, blue, and green"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context to enable only RGB"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsEnableRgbOnly(hStatistics: spinImageStatistics) -> spinError;
}
extern "C" {
    #[doc = " Disables all channels of an image statistics context except hue, saturation, and lightness"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context to enable only HSL"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsEnableHslOnly(hStatistics: spinImageStatistics) -> spinError;
}
extern "C" {
    #[doc = " Checks whether an image statistics context is enabled"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context of the channel"]
    #[doc = " @param channel The channel to check"]
    #[doc = " @param pbEnabled The boolean pointer to return whether or not the channel is enabled"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsGetChannelStatus(
        hStatistics: spinImageStatistics,
        channel: spinStatisticsChannel,
        pbEnabled: *mut bool8_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Sets the status of an image statistics channel"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context of the channel"]
    #[doc = " @param channel The channel to enable/disable"]
    #[doc = " @param bEnable The boolean value to set; true enables, false disables"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsSetChannelStatus(
        hStatistics: spinImageStatistics,
        channel: spinStatisticsChannel,
        bEnable: bool8_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the range of an image statistics channel"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context of the channel"]
    #[doc = " @param channel The channel of the range to retrieve"]
    #[doc = " @param pMin The unsigned integer pointer in which the minimum value of the range is returned"]
    #[doc = " @param pMax The unsigned integer pointer in which the maximum value of the range is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsGetRange(
        hStatistics: spinImageStatistics,
        channel: spinStatisticsChannel,
        pMin: *mut ::std::os::raw::c_uint,
        pMax: *mut ::std::os::raw::c_uint,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the pixel value range of an image statistics channel"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context of the channel"]
    #[doc = " @param channel The channel of the pixel value range to retrieve"]
    #[doc = " @param pMin The unsigned integer pointer in which the minimum value of the pixel value range is returned"]
    #[doc = " @param pMax The unsigned integer pointer in which the maximum value of the pixel value range is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsGetPixelValueRange(
        hStatistics: spinImageStatistics,
        channel: spinStatisticsChannel,
        pMin: *mut ::std::os::raw::c_uint,
        pMax: *mut ::std::os::raw::c_uint,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the number of pixel values of an image statistics channel"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context of the channel"]
    #[doc = " @param channel The channel where the pixel values to be counted are"]
    #[doc = " @param iNumValues The unsigned integer pointer in which the number of pixel values is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsGetNumPixelValues(
        hStatistics: spinImageStatistics,
        channel: spinStatisticsChannel,
        pNumValues: *mut ::std::os::raw::c_uint,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the mean of pixel values of an image statistics channel"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context of the channel"]
    #[doc = " @param channel The channel of the mean pixel value to be retrieved"]
    #[doc = " @param pMean The float pointer in which the mean pixel value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsGetMean(
        hStatistics: spinImageStatistics,
        channel: spinStatisticsChannel,
        pMean: *mut f32,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves a histogram of an image statistics channel"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context of the channel"]
    #[doc = " @param channel The channel of the histogram to be returned"]
    #[doc = " @param pHistogram The pointer to the integer pointer in which the histogram data is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsGetHistogram(
        hStatistics: spinImageStatistics,
        channel: spinStatisticsChannel,
        ppHistogram: *mut *mut ::std::os::raw::c_int,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves all available information of an image statistics channel"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hStatistics The image statistics context of the channel"]
    #[doc = " @param channel The channel of the information to retrieve"]
    #[doc = " @param pRangeMin The unsigned integer pointer in which the minimum value of the range is returned"]
    #[doc = " @param pRangeMax The unsigned integer pointer in which the maximum value of the range is returned"]
    #[doc = " @param pPixelValueMin The unsigned integer pointer in which the minimum pixel value of the range is returned"]
    #[doc = " @param pPixelValueMax The unsigned integer pointer in which the maximum pixel value of the range is returned"]
    #[doc = " @param pNumPixelValues The unsigned integer pointer in which the number of pixel values is returned"]
    #[doc = " @param pPixelValueMean The float pointer in which the mean pixel value is returned"]
    #[doc = " @param ppiHistogram The pointer to the pointer in which the histogram data is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinImageStatisticsGetAll(
        hStatistics: spinImageStatistics,
        channel: spinStatisticsChannel,
        pRangeMin: *mut ::std::os::raw::c_uint,
        pRangeMax: *mut ::std::os::raw::c_uint,
        pPixelValueMin: *mut ::std::os::raw::c_uint,
        pPixelValueMax: *mut ::std::os::raw::c_uint,
        pNumPixelValues: *mut ::std::os::raw::c_uint,
        pPixelValueMean: *mut f32,
        ppHistogram: *mut *mut ::std::os::raw::c_int,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the category name of a log event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hLogEventData The log event data received from the log event"]
    #[doc = " @param pBuf The c-string character buffer in which the category name of the log event is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinLogDataGetCategoryName(
        hLogEventData: spinLogEventData,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the priority of a log event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hLogEventData The log event data received from the log event"]
    #[doc = " @param pValue The integer pointer in which the priority value is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinLogDataGetPriority(hLogEventData: spinLogEventData, pValue: *mut i64) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the priority name of a log event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hLogEventData The log event data received from the log event"]
    #[doc = " @param pBuf The c-string character buffer in which the priority name of the log event is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinLogDataGetPriorityName(
        hLogEventData: spinLogEventData,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the timestamp of a log event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hLogEventData The log event data received from the log event"]
    #[doc = " @param pBuf The c-string character buffer in which the timestamp of the log event is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinLogDataGetTimestamp(
        hLogEventData: spinLogEventData,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the NDC of a log event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hLogEventData The log event data received from the log event"]
    #[doc = " @param pBuf The c-string character buffer in which the NDC of the log event is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinLogDataGetNDC(
        hLogEventData: spinLogEventData,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the thread name of a log event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hLogEventData The log event data received from the log event"]
    #[doc = " @param pBuf The c-string character buffer in which the thread name of the log event is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinLogDataGetThreadName(
        hLogEventData: spinLogEventData,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the log message of a log event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hLogEventData The log event data received from the log event"]
    #[doc = " @param pBuf The c-string character buffer in which the log message of the log event is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinLogDataGetLogMessage(
        hLogEventData: spinLogEventData,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the event ID of a device event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hDeviceEventData The log event data received from the log event"]
    #[doc = " @param pEventId The unsigned integer pointer in which the event ID is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinDeviceEventGetId(
        hDeviceEventData: spinDeviceEventData,
        pEventId: *mut u64,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the payload data of a device event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hDeviceEventData The log event data received from the log event"]
    #[doc = " @param pBuf The unsigned integer pointer in which the event payload is returned"]
    #[doc = " @param pBufSize The unsigned integer pointer in which the size of the payload is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinDeviceEventGetPayloadData(
        hDeviceEventData: spinDeviceEventData,
        pBuf: *const u8,
        pBufSize: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the payload data size of a device event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hDeviceEventData The log event data received from the log event"]
    #[doc = " @param pBufSize The unsigned integer pointer in which the size of the payload is returned"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinDeviceEventGetPayloadDataSize(
        hDeviceEventData: spinDeviceEventData,
        pBufSize: *mut size_t,
    ) -> spinError;
}
extern "C" {
    #[doc = " Retrieves the event name of a device event"]
    #[doc = " @see spinError"]
    #[doc = ""]
    #[doc = " @param hDeviceEventData The log event data received from the log event"]
    #[doc = " @param pBuf The c-string character buffer in which the name of the device event is returned"]
    #[doc = " @param pBufLen The unsigned integer pointer in which the length of the c-string is returned; the input value is"]
    #[doc = " the maximum length"]
    #[doc = ""]
    #[doc = " @return spinError The error code; returns SPINNAKER_ERR_SUCCESS (or 0) for no error"]
    pub fn spinDeviceEventGetName(
        hDeviceEventData: spinDeviceEventData,
        pBuf: *mut ::std::os::raw::c_char,
        pBufLen: *mut size_t,
    ) -> spinError;
}
extern "C" {
    pub fn spinImageChunkDataGetIntValue(
        hImage: spinImage,
        pName: *const ::std::os::raw::c_char,
        pValue: *mut i64,
    ) -> spinError;
}
extern "C" {
    pub fn spinImageChunkDataGetFloatValue(
        hImage: spinImage,
        pName: *const ::std::os::raw::c_char,
        pValue: *mut f64,
    ) -> spinError;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_data {
    pub _address: u8,
}
