// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Tile;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "ShumateMemoryCache")]
    pub struct MemoryCache(Object<ffi::ShumateMemoryCache, ffi::ShumateMemoryCacheClass>);

    match fn {
        type_ => || ffi::shumate_memory_cache_get_type(),
    }
}

impl MemoryCache {
    pub const NONE: Option<&'static MemoryCache> = None;

    #[doc(alias = "shumate_memory_cache_new_full")]
    pub fn new_full(size_limit: u32) -> MemoryCache {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::shumate_memory_cache_new_full(size_limit)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`MemoryCache`] objects.
    ///
    /// This method returns an instance of [`MemoryCacheBuilder`](crate::builders::MemoryCacheBuilder) which can be used to create [`MemoryCache`] objects.
    pub fn builder() -> MemoryCacheBuilder {
        MemoryCacheBuilder::default()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`MemoryCache`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MemoryCacheBuilder {
    size_limit: Option<u32>,
}

impl MemoryCacheBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`MemoryCacheBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`MemoryCache`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> MemoryCache {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref size_limit) = self.size_limit {
            properties.push(("size-limit", size_limit));
        }
        glib::Object::new::<MemoryCache>(&properties)
            .expect("Failed to create an instance of MemoryCache")
    }

    pub fn size_limit(mut self, size_limit: u32) -> Self {
        self.size_limit = Some(size_limit);
        self
    }
}

pub trait MemoryCacheExt: 'static {
    #[doc(alias = "shumate_memory_cache_clean")]
    fn clean(&self);

    #[doc(alias = "shumate_memory_cache_get_size_limit")]
    #[doc(alias = "get_size_limit")]
    fn size_limit(&self) -> u32;

    #[doc(alias = "shumate_memory_cache_set_size_limit")]
    fn set_size_limit(&self, size_limit: u32);

    #[doc(alias = "shumate_memory_cache_store_texture")]
    fn store_texture(
        &self,
        tile: &impl IsA<Tile>,
        texture: &impl IsA<gdk::Texture>,
        source_id: &str,
    );

    #[doc(alias = "shumate_memory_cache_try_fill_tile")]
    fn try_fill_tile(&self, tile: &impl IsA<Tile>, source_id: &str) -> bool;

    #[doc(alias = "size-limit")]
    fn connect_size_limit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<MemoryCache>> MemoryCacheExt for O {
    fn clean(&self) {
        unsafe {
            ffi::shumate_memory_cache_clean(self.as_ref().to_glib_none().0);
        }
    }

    fn size_limit(&self) -> u32 {
        unsafe { ffi::shumate_memory_cache_get_size_limit(self.as_ref().to_glib_none().0) }
    }

    fn set_size_limit(&self, size_limit: u32) {
        unsafe {
            ffi::shumate_memory_cache_set_size_limit(self.as_ref().to_glib_none().0, size_limit);
        }
    }

    fn store_texture(
        &self,
        tile: &impl IsA<Tile>,
        texture: &impl IsA<gdk::Texture>,
        source_id: &str,
    ) {
        unsafe {
            ffi::shumate_memory_cache_store_texture(
                self.as_ref().to_glib_none().0,
                tile.as_ref().to_glib_none().0,
                texture.as_ref().to_glib_none().0,
                source_id.to_glib_none().0,
            );
        }
    }

    fn try_fill_tile(&self, tile: &impl IsA<Tile>, source_id: &str) -> bool {
        unsafe {
            from_glib(ffi::shumate_memory_cache_try_fill_tile(
                self.as_ref().to_glib_none().0,
                tile.as_ref().to_glib_none().0,
                source_id.to_glib_none().0,
            ))
        }
    }

    fn connect_size_limit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_limit_trampoline<
            P: IsA<MemoryCache>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateMemoryCache,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(MemoryCache::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-limit\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_limit_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for MemoryCache {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("MemoryCache")
    }
}
