// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::MapProjection;
use crate::Tile;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "ShumateMapSource")]
    pub struct MapSource(Object<ffi::ShumateMapSource, ffi::ShumateMapSourceClass>);

    match fn {
        type_ => || ffi::shumate_map_source_get_type(),
    }
}

impl MapSource {
    pub const NONE: Option<&'static MapSource> = None;
}

pub trait MapSourceExt: 'static {
    #[doc(alias = "shumate_map_source_fill_tile_async")]
    fn fill_tile_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        tile: &impl IsA<Tile>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn fill_tile_future(
        &self,
        tile: &(impl IsA<Tile> + Clone + 'static),
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "shumate_map_source_get_column_count")]
    #[doc(alias = "get_column_count")]
    fn column_count(&self, zoom_level: u32) -> u32;

    #[doc(alias = "shumate_map_source_get_id")]
    #[doc(alias = "get_id")]
    fn id(&self) -> Option<glib::GString>;

    #[doc(alias = "shumate_map_source_get_latitude")]
    #[doc(alias = "get_latitude")]
    fn latitude(&self, zoom_level: f64, y: f64) -> f64;

    #[doc(alias = "shumate_map_source_get_license")]
    #[doc(alias = "get_license")]
    fn license(&self) -> Option<glib::GString>;

    #[doc(alias = "shumate_map_source_get_license_uri")]
    #[doc(alias = "get_license_uri")]
    fn license_uri(&self) -> Option<glib::GString>;

    #[doc(alias = "shumate_map_source_get_longitude")]
    #[doc(alias = "get_longitude")]
    fn longitude(&self, zoom_level: f64, x: f64) -> f64;

    #[doc(alias = "shumate_map_source_get_max_zoom_level")]
    #[doc(alias = "get_max_zoom_level")]
    fn max_zoom_level(&self) -> u32;

    #[doc(alias = "shumate_map_source_get_meters_per_pixel")]
    #[doc(alias = "get_meters_per_pixel")]
    fn meters_per_pixel(&self, zoom_level: f64, latitude: f64, longitude: f64) -> f64;

    #[doc(alias = "shumate_map_source_get_min_zoom_level")]
    #[doc(alias = "get_min_zoom_level")]
    fn min_zoom_level(&self) -> u32;

    #[doc(alias = "shumate_map_source_get_name")]
    #[doc(alias = "get_name")]
    fn name(&self) -> Option<glib::GString>;

    #[doc(alias = "shumate_map_source_get_projection")]
    #[doc(alias = "get_projection")]
    fn projection(&self) -> MapProjection;

    #[doc(alias = "shumate_map_source_get_row_count")]
    #[doc(alias = "get_row_count")]
    fn row_count(&self, zoom_level: u32) -> u32;

    #[doc(alias = "shumate_map_source_get_tile_size")]
    #[doc(alias = "get_tile_size")]
    fn tile_size(&self) -> u32;

    #[doc(alias = "shumate_map_source_get_tile_size_at_zoom")]
    #[doc(alias = "get_tile_size_at_zoom")]
    fn tile_size_at_zoom(&self, zoom_level: f64) -> f64;

    #[doc(alias = "shumate_map_source_get_x")]
    #[doc(alias = "get_x")]
    fn x(&self, zoom_level: f64, longitude: f64) -> f64;

    #[doc(alias = "shumate_map_source_get_y")]
    #[doc(alias = "get_y")]
    fn y(&self, zoom_level: f64, latitude: f64) -> f64;

    #[doc(alias = "shumate_map_source_set_id")]
    fn set_id(&self, id: &str);

    #[doc(alias = "shumate_map_source_set_license")]
    fn set_license(&self, license: &str);

    #[doc(alias = "shumate_map_source_set_license_uri")]
    fn set_license_uri(&self, license_uri: &str);

    #[doc(alias = "shumate_map_source_set_max_zoom_level")]
    fn set_max_zoom_level(&self, zoom_level: u32);

    #[doc(alias = "shumate_map_source_set_min_zoom_level")]
    fn set_min_zoom_level(&self, zoom_level: u32);

    #[doc(alias = "shumate_map_source_set_name")]
    fn set_name(&self, name: &str);

    #[doc(alias = "shumate_map_source_set_projection")]
    fn set_projection(&self, projection: MapProjection);

    #[doc(alias = "shumate_map_source_set_tile_size")]
    fn set_tile_size(&self, tile_size: u32);

    #[doc(alias = "id")]
    fn connect_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "license")]
    fn connect_license_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "license-uri")]
    fn connect_license_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "max-zoom-level")]
    fn connect_max_zoom_level_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "min-zoom-level")]
    fn connect_min_zoom_level_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "name")]
    fn connect_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "projection")]
    fn connect_projection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tile-size")]
    fn connect_tile_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<MapSource>> MapSourceExt for O {
    fn fill_tile_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        tile: &impl IsA<Tile>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn fill_tile_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ =
                ffi::shumate_map_source_fill_tile_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = fill_tile_async_trampoline::<P>;
        unsafe {
            ffi::shumate_map_source_fill_tile_async(
                self.as_ref().to_glib_none().0,
                tile.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn fill_tile_future(
        &self,
        tile: &(impl IsA<Tile> + Clone + 'static),
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let tile = tile.clone();
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.fill_tile_async(&tile, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn column_count(&self, zoom_level: u32) -> u32 {
        unsafe {
            ffi::shumate_map_source_get_column_count(self.as_ref().to_glib_none().0, zoom_level)
        }
    }

    fn id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::shumate_map_source_get_id(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn latitude(&self, zoom_level: f64, y: f64) -> f64 {
        unsafe {
            ffi::shumate_map_source_get_latitude(self.as_ref().to_glib_none().0, zoom_level, y)
        }
    }

    fn license(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::shumate_map_source_get_license(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn license_uri(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::shumate_map_source_get_license_uri(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn longitude(&self, zoom_level: f64, x: f64) -> f64 {
        unsafe {
            ffi::shumate_map_source_get_longitude(self.as_ref().to_glib_none().0, zoom_level, x)
        }
    }

    fn max_zoom_level(&self) -> u32 {
        unsafe { ffi::shumate_map_source_get_max_zoom_level(self.as_ref().to_glib_none().0) }
    }

    fn meters_per_pixel(&self, zoom_level: f64, latitude: f64, longitude: f64) -> f64 {
        unsafe {
            ffi::shumate_map_source_get_meters_per_pixel(
                self.as_ref().to_glib_none().0,
                zoom_level,
                latitude,
                longitude,
            )
        }
    }

    fn min_zoom_level(&self) -> u32 {
        unsafe { ffi::shumate_map_source_get_min_zoom_level(self.as_ref().to_glib_none().0) }
    }

    fn name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::shumate_map_source_get_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn projection(&self) -> MapProjection {
        unsafe {
            from_glib(ffi::shumate_map_source_get_projection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn row_count(&self, zoom_level: u32) -> u32 {
        unsafe { ffi::shumate_map_source_get_row_count(self.as_ref().to_glib_none().0, zoom_level) }
    }

    fn tile_size(&self) -> u32 {
        unsafe { ffi::shumate_map_source_get_tile_size(self.as_ref().to_glib_none().0) }
    }

    fn tile_size_at_zoom(&self, zoom_level: f64) -> f64 {
        unsafe {
            ffi::shumate_map_source_get_tile_size_at_zoom(
                self.as_ref().to_glib_none().0,
                zoom_level,
            )
        }
    }

    fn x(&self, zoom_level: f64, longitude: f64) -> f64 {
        unsafe {
            ffi::shumate_map_source_get_x(self.as_ref().to_glib_none().0, zoom_level, longitude)
        }
    }

    fn y(&self, zoom_level: f64, latitude: f64) -> f64 {
        unsafe {
            ffi::shumate_map_source_get_y(self.as_ref().to_glib_none().0, zoom_level, latitude)
        }
    }

    fn set_id(&self, id: &str) {
        unsafe {
            ffi::shumate_map_source_set_id(self.as_ref().to_glib_none().0, id.to_glib_none().0);
        }
    }

    fn set_license(&self, license: &str) {
        unsafe {
            ffi::shumate_map_source_set_license(
                self.as_ref().to_glib_none().0,
                license.to_glib_none().0,
            );
        }
    }

    fn set_license_uri(&self, license_uri: &str) {
        unsafe {
            ffi::shumate_map_source_set_license_uri(
                self.as_ref().to_glib_none().0,
                license_uri.to_glib_none().0,
            );
        }
    }

    fn set_max_zoom_level(&self, zoom_level: u32) {
        unsafe {
            ffi::shumate_map_source_set_max_zoom_level(self.as_ref().to_glib_none().0, zoom_level);
        }
    }

    fn set_min_zoom_level(&self, zoom_level: u32) {
        unsafe {
            ffi::shumate_map_source_set_min_zoom_level(self.as_ref().to_glib_none().0, zoom_level);
        }
    }

    fn set_name(&self, name: &str) {
        unsafe {
            ffi::shumate_map_source_set_name(self.as_ref().to_glib_none().0, name.to_glib_none().0);
        }
    }

    fn set_projection(&self, projection: MapProjection) {
        unsafe {
            ffi::shumate_map_source_set_projection(
                self.as_ref().to_glib_none().0,
                projection.into_glib(),
            );
        }
    }

    fn set_tile_size(&self, tile_size: u32) {
        unsafe {
            ffi::shumate_map_source_set_tile_size(self.as_ref().to_glib_none().0, tile_size);
        }
    }

    fn connect_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_id_trampoline<P: IsA<MapSource>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateMapSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(MapSource::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::id\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_id_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_license_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_license_trampoline<P: IsA<MapSource>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateMapSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(MapSource::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::license\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_license_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_license_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_license_uri_trampoline<
            P: IsA<MapSource>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateMapSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(MapSource::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::license-uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_license_uri_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_max_zoom_level_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_zoom_level_trampoline<
            P: IsA<MapSource>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateMapSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(MapSource::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-zoom-level\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_zoom_level_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_min_zoom_level_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_zoom_level_trampoline<
            P: IsA<MapSource>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateMapSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(MapSource::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-zoom-level\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_min_zoom_level_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_name_trampoline<P: IsA<MapSource>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateMapSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(MapSource::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_projection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_projection_trampoline<
            P: IsA<MapSource>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateMapSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(MapSource::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::projection\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_projection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tile_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tile_size_trampoline<P: IsA<MapSource>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateMapSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(MapSource::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tile-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tile_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for MapSource {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("MapSource")
    }
}
